#!/usr/bin/python
# -*- coding: utf-8 -*-
"""
zhpy is an convertor to translate chinese python code to nature python code(english) and vice versa.
zhpy refactored the origin code from HYRY.

fredlin 2007, gasolin+mopowg@gmail.com
"""
from pyparsing import *

"""import ConfigParser
worddict = {}

inifiles = [x for x in os.listdir(".") if x.endswith(".ini")]
for f in inifiles:
    conf = ConfigParser.ConfigParser()
    conf.read(f)
    sects = conf.sections()
    for sect in sects:
        for k, v in conf.items(sect):
            if worddict.has_key(k):
                print "already has key: %s, %s" % (sect, k)
            else:
                worddict[k] = v
"""

# Traditional chinese and simplized chinese keywords
worddict = {"印出":"print", "打印":"print",
            "輸入":"raw_input", "输入字符串":"raw_input",
            "定義":"def", "類別":"class", "定义":"def", "类":"class",
            "從":"from", "導入":"import", "取名":"as", 
            "从":"from", "载入":"import",
            "返回":"return", "略過":"pass", "舉出":"raise", "繼續":"continue",
            "继续":"continue","略过":"pass", 
            "如果":"if", "不然":"elif", "否則":"else", 
            "若":"if", "否则如果":"elif", "否则":"else",
            "取":"for", "自":"in", "在":"in",
            "當":"while", "跳出":"break", "当":"while", "中断":"break",
            "嘗試":"try", "異常":"except", "最後":"finally", "试运行":"try", "错误处理":"except",
            "全域":"global", "全局变量":"global",
            "宣告":"assert", "刪除":"del", "執行":"exec",
            "函式":"lambda", '圈':"yield", "伴隨":"with",
            "範圍":"range", "范围":"range", # preload module
            "字串":"str", "列表": "list", "字典":"dict", # build-in types
            "字符串":"str",
            "長度":"len" ,"长度":"len",
            "整數":"int", "小數":"float", "整数":"int", "小数":"float",
            "加入":"append", "追加":"append", #list methods
            "有關鍵字":"has_key", "列出關鍵字":"keys", "列出值":"values", "列出項目": "items", #dict methods
            "有关键字":"has_key", "关键字列表":"keys", "值列表":"values", "项目列表":"items",
            "等於":"==", "不等於":"!=", "等于":"==", "不等于":"!=", #operators
            "加":"+", "減":"-", "乘":"*", "除":"/","取餘數":"%", #math
            "一":"1", "百":"100", # numbers
            }

def annotator(anno_dict):
    for tmp in anno_dict.keys:
        if not worddict.has_key(tmp):
            worddict[tmp] = anno_dict[tmp]
            print "add %s=%s"%(tmp, anno_dict[tmp])

replacedict = {
    "（":"(",
    "）":")",
    "。":".",
    """:'"',
    """:'"',
    "'":"'",
    "'":"'",
    "，":",",
    "：":":",
    "！":"!",
    }

vnum = 0

def convertToEnglish(s,l,t):
    """search dict to match keywords
    if not in keyword, replace the chinese variable/argument/function name/class name/method name to a variable with prefix 'p'
    
    TODO: able to convert pretty code by annotate dict
    """
    global vnum
    tmp = t[0].encode("utf8")
    print tmp
    if not worddict.has_key(tmp):
        worddict[tmp] = "p" + str(vnum)
        vnum += 1
    english = worddict[tmp]
    return english.decode("utf8")

chineseChars = srange(r"[\0x0080-\0xfe00]")
#chineseChars = srange(r"[\0x2E80-\0x2FA1D]")
chineseWord = Word(chineseChars)
chineseWord.setParseAction(convertToEnglish)
pythonWord = dblQuotedString | chineseWord

def convertor(test):
    for k, v in replacedict.items():
        test = test.replace(k,v)
    
    utest = test.decode("utf8")
    result = pythonWord.transformString(utest)
    result = result.encode("utf8")
    return result

def commandtool():
    import os
    import sys
    os.chdir(os.getcwd())
    test = file(sys.argv[1]).read()
    #if test.startswith("\xef\xbb\xbf"):
    #    test = test[3:]
    result = convertor(test)
    
    if len(sys.argv)>=3:
        file(sys.argv[2],"w").write(result)
    else:
        try:
            exec result
        except Exception, e:
            s = str(e)
            print s
            for k, v in worddict.items():
                if "'" + v + "'" in s:
                    print unicode(k,"utf8"), v
    
if __name__=="__main__":
    commandtool()