# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AccessPolicyEccAlgo(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Elliptical curve algorithm to be used: ES256, ES384 or ES512.
    """

    #: ES265.
    ES256 = "ES256"
    #: ES384.
    ES384 = "ES384"
    #: ES512.
    ES512 = "ES512"

class AccessPolicyRole(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the access level granted by this policy.
    """

    #: Reader role allows for read-only operations to be performed through the client APIs.
    READER = "Reader"

class AccessPolicyRsaAlgo(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """RSA algorithm to be used: RS256, RS384 or RS512.
    """

    #: RS256.
    RS256 = "RS256"
    #: RS384.
    RS384 = "RS384"
    #: RS512.
    RS512 = "RS512"

class AccountEncryptionKeyType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of key used to encrypt the Account Key.
    """

    #: The Account Key is encrypted with a System Key.
    SYSTEM_KEY = "SystemKey"
    #: The Account Key is encrypted with a Customer Key.
    CUSTOMER_KEY = "CustomerKey"

class ActionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Indicates the action type.
    """

    #: An internal action.
    INTERNAL = "Internal"

class CheckNameAvailabilityReason(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The reason why the given name is not available.
    """

    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"

class CreatedByType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class MetricAggregationType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The metric aggregation type
    """

    #: The average.
    AVERAGE = "Average"
    #: The count of a number of items, usually requests.
    COUNT = "Count"
    #: The sum.
    TOTAL = "Total"

class MetricUnit(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The metric unit
    """

    #: The number of bytes.
    BYTES = "Bytes"
    #: The count.
    COUNT = "Count"
    #: The number of milliseconds.
    MILLISECONDS = "Milliseconds"

class VideoAnalyzerEndpointType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the endpoint.
    """

    #: The client API endpoint.
    CLIENT_API = "ClientApi"

class VideoType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the video archive. Different archive formats provide different capabilities.
    """

    #: Archive is flexible format that represents a video stream associated with wall-clock time. The
    #: video archive can either be continuous or discontinuous. An archive is discontinuous when there
    #: are gaps in the recording due to various reasons, such as the live pipeline being stopped,
    #: camera being disconnected or due to the use of event based recordings through the use of a
    #: signal gate. Finally, there is no limit to the archive duration and new video data can be
    #: appended to the existing archive at any time, as long as the same video codec and codec
    #: parameters are being used.
    ARCHIVE = "Archive"
