# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._video_analyzer_enums import *


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class AccessPolicyEntity(ProxyResource):
    """Policy that determines how a video can be accessed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~video_analyzer.models.SystemData
    :param role: Defines the access level granted by this policy. Possible values include:
     "Reader".
    :type role: str or ~video_analyzer.models.AccessPolicyRole
    :param authentication: Authentication method to be used when validating client API access.
    :type authentication: ~video_analyzer.models.AuthenticationBase
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'role': {'key': 'properties.role', 'type': 'str'},
        'authentication': {'key': 'properties.authentication', 'type': 'AuthenticationBase'},
    }

    def __init__(
        self,
        *,
        role: Optional[Union[str, "AccessPolicyRole"]] = None,
        authentication: Optional["AuthenticationBase"] = None,
        **kwargs
    ):
        super(AccessPolicyEntity, self).__init__(**kwargs)
        self.system_data = None
        self.role = role
        self.authentication = authentication


class AccessPolicyEntityCollection(msrest.serialization.Model):
    """A collection of AccessPolicyEntity items.

    :param value: A collection of AccessPolicyEntity items.
    :type value: list[~video_analyzer.models.AccessPolicyEntity]
    :param next_link: A link to the next page of the collection (when the collection contains too
     many results to return in one response).
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AccessPolicyEntity]'},
        'next_link': {'key': '@nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["AccessPolicyEntity"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(AccessPolicyEntityCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AccountEncryption(msrest.serialization.Model):
    """Defines how the Video Analyzer account is (optionally) encrypted.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of key used to encrypt the Account Key. Possible values
     include: "SystemKey", "CustomerKey".
    :type type: str or ~video_analyzer.models.AccountEncryptionKeyType
    :param key_vault_properties: The properties of the key used to encrypt the account.
    :type key_vault_properties: ~video_analyzer.models.KeyVaultProperties
    :param identity: The Key Vault identity.
    :type identity: ~video_analyzer.models.ResourceIdentity
    :ivar status: The current status of the Key Vault mapping.
    :vartype status: str
    """

    _validation = {
        'type': {'required': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'key_vault_properties': {'key': 'keyVaultProperties', 'type': 'KeyVaultProperties'},
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "AccountEncryptionKeyType"],
        key_vault_properties: Optional["KeyVaultProperties"] = None,
        identity: Optional["ResourceIdentity"] = None,
        **kwargs
    ):
        super(AccountEncryption, self).__init__(**kwargs)
        self.type = type
        self.key_vault_properties = key_vault_properties
        self.identity = identity
        self.status = None


class AuthenticationBase(msrest.serialization.Model):
    """Base class for access policies authentication methods.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: JwtAuthentication.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'#Microsoft.VideoAnalyzer.JwtAuthentication': 'JwtAuthentication'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AuthenticationBase, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class CheckNameAvailabilityRequest(msrest.serialization.Model):
    """The check availability request body.

    :param name: The name of the resource for which availability needs to be checked.
    :type name: str
    :param type: The resource type.
    :type type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        super(CheckNameAvailabilityRequest, self).__init__(**kwargs)
        self.name = name
        self.type = type


class CheckNameAvailabilityResponse(msrest.serialization.Model):
    """The check availability result.

    :param name_available: Indicates if the resource name is available.
    :type name_available: bool
    :param reason: The reason why the given name is not available. Possible values include:
     "Invalid", "AlreadyExists".
    :type reason: str or ~video_analyzer.models.CheckNameAvailabilityReason
    :param message: Detailed reason why the given name is available.
    :type message: str
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "CheckNameAvailabilityReason"]] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(CheckNameAvailabilityResponse, self).__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class TokenKey(msrest.serialization.Model):
    """Key properties for JWT token validation.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: EccTokenKey, RsaTokenKey.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param kid: Required. JWT token key id. Validation keys are looked up based on the key id
     present on the JWT token header.
    :type kid: str
    """

    _validation = {
        'type': {'required': True},
        'kid': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'kid': {'key': 'kid', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'#Microsoft.VideoAnalyzer.EccTokenKey': 'EccTokenKey', '#Microsoft.VideoAnalyzer.RsaTokenKey': 'RsaTokenKey'}
    }

    def __init__(
        self,
        *,
        kid: str,
        **kwargs
    ):
        super(TokenKey, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.kid = kid


class EccTokenKey(TokenKey):
    """Required validation properties for tokens generated with Elliptical Curve algorithm.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param kid: Required. JWT token key id. Validation keys are looked up based on the key id
     present on the JWT token header.
    :type kid: str
    :param alg: Required. Elliptical curve algorithm to be used: ES256, ES384 or ES512. Possible
     values include: "ES256", "ES384", "ES512".
    :type alg: str or ~video_analyzer.models.AccessPolicyEccAlgo
    :param x: Required. X coordinate.
    :type x: str
    :param y: Required. Y coordinate.
    :type y: str
    """

    _validation = {
        'type': {'required': True},
        'kid': {'required': True},
        'alg': {'required': True},
        'x': {'required': True},
        'y': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'kid': {'key': 'kid', 'type': 'str'},
        'alg': {'key': 'alg', 'type': 'str'},
        'x': {'key': 'x', 'type': 'str'},
        'y': {'key': 'y', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kid: str,
        alg: Union[str, "AccessPolicyEccAlgo"],
        x: str,
        y: str,
        **kwargs
    ):
        super(EccTokenKey, self).__init__(kid=kid, **kwargs)
        self.type = '#Microsoft.VideoAnalyzer.EccTokenKey'  # type: str
        self.alg = alg
        self.x = x
        self.y = y


class EdgeModuleEntity(ProxyResource):
    """The representation of an edge module.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~video_analyzer.models.SystemData
    :ivar edge_module_id: Internal ID generated for the instance of the Video Analyzer edge module.
    :vartype edge_module_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'edge_module_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'edge_module_id': {'key': 'properties.edgeModuleId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EdgeModuleEntity, self).__init__(**kwargs)
        self.system_data = None
        self.edge_module_id = None


class EdgeModuleEntityCollection(msrest.serialization.Model):
    """A collection of EdgeModuleEntity items.

    :param value: A collection of EdgeModuleEntity items.
    :type value: list[~video_analyzer.models.EdgeModuleEntity]
    :param next_link: A link to the next page of the collection (when the collection contains too
     many results to return in one response).
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EdgeModuleEntity]'},
        'next_link': {'key': '@nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EdgeModuleEntity"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(EdgeModuleEntityCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class EdgeModuleProvisioningToken(msrest.serialization.Model):
    """Provisioning token properties. A provisioning token allows for a single instance of Azure Video analyzer IoT edge module to be initialized and authorized to the cloud account. The provisioning token itself is short lived and it is only used for the initial handshake between IoT edge module and the cloud. After the initial handshake, the IoT edge module will agree on a set of authentication keys which will be auto-rotated as long as the module is able to periodically connect to the cloud. A new provisioning token can be generated for the same IoT edge module in case the module state lost or reset.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar expiration_date: The expiration date of the registration token. The Azure Video Analyzer
     IoT edge module must be initialized and connected to the Internet prior to the token expiration
     date.
    :vartype expiration_date: ~datetime.datetime
    :ivar token: The token blob to be provided to the Azure Video Analyzer IoT edge module through
     the Azure IoT Edge module twin properties.
    :vartype token: str
    """

    _validation = {
        'expiration_date': {'readonly': True},
        'token': {'readonly': True},
    }

    _attribute_map = {
        'expiration_date': {'key': 'expirationDate', 'type': 'iso-8601'},
        'token': {'key': 'token', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EdgeModuleProvisioningToken, self).__init__(**kwargs)
        self.expiration_date = None
        self.token = None


class Endpoint(msrest.serialization.Model):
    """The endpoint details.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_url: The URL of the endpoint.
    :type endpoint_url: str
    :param type: Required. The type of the endpoint. Possible values include: "ClientApi".
    :type type: str or ~video_analyzer.models.VideoAnalyzerEndpointType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'endpoint_url': {'key': 'endpointUrl', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "VideoAnalyzerEndpointType"],
        endpoint_url: Optional[str] = None,
        **kwargs
    ):
        super(Endpoint, self).__init__(**kwargs)
        self.endpoint_url = endpoint_url
        self.type = type


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: str
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~video_analyzer.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~video_analyzer.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :param error: The error object.
    :type error: ~video_analyzer.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetail"] = None,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class JwtAuthentication(AuthenticationBase):
    """Properties for access validation based on JSON Web Tokens (JWT).

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param issuers: List of expected token issuers. Token issuer is valid if it matches at least
     one of the given values.
    :type issuers: list[str]
    :param audiences: List of expected token audiences. Token audience is valid if it matches at
     least one of the given values.
    :type audiences: list[str]
    :param claims: List of additional token claims to be validated. Token must contains all claims
     and respective values for it to be valid.
    :type claims: list[~video_analyzer.models.TokenClaim]
    :param keys: List of keys which can be used to validate access tokens. Having multiple keys
     allow for seamless key rotation of the token signing key. Token signature must match exactly
     one key.
    :type keys: list[~video_analyzer.models.TokenKey]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'issuers': {'key': 'issuers', 'type': '[str]'},
        'audiences': {'key': 'audiences', 'type': '[str]'},
        'claims': {'key': 'claims', 'type': '[TokenClaim]'},
        'keys': {'key': 'keys', 'type': '[TokenKey]'},
    }

    def __init__(
        self,
        *,
        issuers: Optional[List[str]] = None,
        audiences: Optional[List[str]] = None,
        claims: Optional[List["TokenClaim"]] = None,
        keys: Optional[List["TokenKey"]] = None,
        **kwargs
    ):
        super(JwtAuthentication, self).__init__(**kwargs)
        self.type = '#Microsoft.VideoAnalyzer.JwtAuthentication'  # type: str
        self.issuers = issuers
        self.audiences = audiences
        self.claims = claims
        self.keys = keys


class KeyVaultProperties(msrest.serialization.Model):
    """The details for accessing the encryption keys in Key Vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param key_identifier: Required. The URL of the Key Vault key used to encrypt the account. The
     key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key
     without a version (for example https://vault/keys/mykey).
    :type key_identifier: str
    :ivar current_key_identifier: The current key used to encrypt Video Analyzer account, including
     the key version.
    :vartype current_key_identifier: str
    """

    _validation = {
        'key_identifier': {'required': True},
        'current_key_identifier': {'readonly': True},
    }

    _attribute_map = {
        'key_identifier': {'key': 'keyIdentifier', 'type': 'str'},
        'current_key_identifier': {'key': 'currentKeyIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_identifier: str,
        **kwargs
    ):
        super(KeyVaultProperties, self).__init__(**kwargs)
        self.key_identifier = key_identifier
        self.current_key_identifier = None


class ListProvisioningTokenInput(msrest.serialization.Model):
    """The input parameters to generate registration token for the Azure Video Analyzer IoT edge module.

    All required parameters must be populated in order to send to Azure.

    :param expiration_date: Required. The desired expiration date of the registration token. The
     Azure Video Analyzer IoT edge module must be initialized and connected to the Internet prior to
     the token expiration date.
    :type expiration_date: ~datetime.datetime
    """

    _validation = {
        'expiration_date': {'required': True},
    }

    _attribute_map = {
        'expiration_date': {'key': 'expirationDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        expiration_date: datetime.datetime,
        **kwargs
    ):
        super(ListProvisioningTokenInput, self).__init__(**kwargs)
        self.expiration_date = expiration_date


class LogSpecification(msrest.serialization.Model):
    """A diagnostic log emitted by service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The diagnostic log category name.
    :vartype name: str
    :ivar display_name: The diagnostic log category display name.
    :vartype display_name: str
    :ivar blob_duration: The time range for requests in each blob.
    :vartype blob_duration: str
    """

    _validation = {
        'name': {'readonly': True},
        'display_name': {'readonly': True},
        'blob_duration': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogSpecification, self).__init__(**kwargs)
        self.name = None
        self.display_name = None
        self.blob_duration = None


class MetricDimension(msrest.serialization.Model):
    """A metric dimension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The metric dimension name.
    :vartype name: str
    :ivar display_name: The display name for the dimension.
    :vartype display_name: str
    :ivar to_be_exported_for_shoebox: Whether to export metric to shoebox.
    :vartype to_be_exported_for_shoebox: bool
    """

    _validation = {
        'name': {'readonly': True},
        'display_name': {'readonly': True},
        'to_be_exported_for_shoebox': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'to_be_exported_for_shoebox': {'key': 'toBeExportedForShoebox', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricDimension, self).__init__(**kwargs)
        self.name = None
        self.display_name = None
        self.to_be_exported_for_shoebox = None


class MetricSpecification(msrest.serialization.Model):
    """A metric emitted by service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The metric name.
    :vartype name: str
    :ivar display_name: The metric display name.
    :vartype display_name: str
    :ivar display_description: The metric display description.
    :vartype display_description: str
    :ivar unit: The metric unit. Possible values include: "Bytes", "Count", "Milliseconds".
    :vartype unit: str or ~video_analyzer.models.MetricUnit
    :ivar aggregation_type: The metric aggregation type. Possible values include: "Average",
     "Count", "Total".
    :vartype aggregation_type: str or ~video_analyzer.models.MetricAggregationType
    :ivar lock_aggregation_type: The metric lock aggregation type. Possible values include:
     "Average", "Count", "Total".
    :vartype lock_aggregation_type: str or ~video_analyzer.models.MetricAggregationType
    :param supported_aggregation_types: Supported aggregation types.
    :type supported_aggregation_types: list[str]
    :ivar dimensions: The metric dimensions.
    :vartype dimensions: list[~video_analyzer.models.MetricDimension]
    :ivar enable_regional_mdm_account: Indicates whether regional MDM account is enabled.
    :vartype enable_regional_mdm_account: bool
    :ivar source_mdm_account: The source MDM account.
    :vartype source_mdm_account: str
    :ivar source_mdm_namespace: The source MDM namespace.
    :vartype source_mdm_namespace: str
    :ivar supported_time_grain_types: The supported time grain types.
    :vartype supported_time_grain_types: list[str]
    """

    _validation = {
        'name': {'readonly': True},
        'display_name': {'readonly': True},
        'display_description': {'readonly': True},
        'unit': {'readonly': True},
        'aggregation_type': {'readonly': True},
        'lock_aggregation_type': {'readonly': True},
        'dimensions': {'readonly': True},
        'enable_regional_mdm_account': {'readonly': True},
        'source_mdm_account': {'readonly': True},
        'source_mdm_namespace': {'readonly': True},
        'supported_time_grain_types': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'lock_aggregation_type': {'key': 'lockAggregationType', 'type': 'str'},
        'supported_aggregation_types': {'key': 'supportedAggregationTypes', 'type': '[str]'},
        'dimensions': {'key': 'dimensions', 'type': '[MetricDimension]'},
        'enable_regional_mdm_account': {'key': 'enableRegionalMdmAccount', 'type': 'bool'},
        'source_mdm_account': {'key': 'sourceMdmAccount', 'type': 'str'},
        'source_mdm_namespace': {'key': 'sourceMdmNamespace', 'type': 'str'},
        'supported_time_grain_types': {'key': 'supportedTimeGrainTypes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        supported_aggregation_types: Optional[List[str]] = None,
        **kwargs
    ):
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = None
        self.display_name = None
        self.display_description = None
        self.unit = None
        self.aggregation_type = None
        self.lock_aggregation_type = None
        self.supported_aggregation_types = supported_aggregation_types
        self.dimensions = None
        self.enable_regional_mdm_account = None
        self.source_mdm_account = None
        self.source_mdm_namespace = None
        self.supported_time_grain_types = None


class Operation(msrest.serialization.Model):
    """An operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The operation name.
    :type name: str
    :param display: The operation display name.
    :type display: ~video_analyzer.models.OperationDisplay
    :param origin: Origin of the operation.
    :type origin: str
    :param properties: Operation properties format.
    :type properties: ~video_analyzer.models.Properties
    :param is_data_action: Whether the operation applies to data-plane.
    :type is_data_action: bool
    :param action_type: Indicates the action type. Possible values include: "Internal".
    :type action_type: str or ~video_analyzer.models.ActionType
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'Properties'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'action_type': {'key': 'actionType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        display: Optional["OperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional["Properties"] = None,
        is_data_action: Optional[bool] = None,
        action_type: Optional[Union[str, "ActionType"]] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties
        self.is_data_action = is_data_action
        self.action_type = action_type


class OperationCollection(msrest.serialization.Model):
    """A collection of Operation items.

    :param value: A collection of Operation items.
    :type value: list[~video_analyzer.models.Operation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        **kwargs
    ):
        super(OperationCollection, self).__init__(**kwargs)
        self.value = value


class OperationDisplay(msrest.serialization.Model):
    """Operation details.

    :param provider: The service provider.
    :type provider: str
    :param resource: Resource on which the operation is performed.
    :type resource: str
    :param operation: The operation type.
    :type operation: str
    :param description: The operation description.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class Properties(msrest.serialization.Model):
    """Metric properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar service_specification: The service specifications.
    :vartype service_specification: ~video_analyzer.models.ServiceSpecification
    """

    _validation = {
        'service_specification': {'readonly': True},
    }

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Properties, self).__init__(**kwargs)
        self.service_specification = None


class ResourceIdentity(msrest.serialization.Model):
    """The user assigned managed identity to use when accessing a resource.

    All required parameters must be populated in order to send to Azure.

    :param user_assigned_identity: Required. The user assigned managed identity's resource
     identifier to use when accessing a resource.
    :type user_assigned_identity: str
    """

    _validation = {
        'user_assigned_identity': {'required': True},
    }

    _attribute_map = {
        'user_assigned_identity': {'key': 'userAssignedIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_assigned_identity: str,
        **kwargs
    ):
        super(ResourceIdentity, self).__init__(**kwargs)
        self.user_assigned_identity = user_assigned_identity


class RsaTokenKey(TokenKey):
    """Required validation properties for tokens generated with RSA algorithm.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param kid: Required. JWT token key id. Validation keys are looked up based on the key id
     present on the JWT token header.
    :type kid: str
    :param alg: Required. RSA algorithm to be used: RS256, RS384 or RS512. Possible values include:
     "RS256", "RS384", "RS512".
    :type alg: str or ~video_analyzer.models.AccessPolicyRsaAlgo
    :param n: Required. RSA public key modulus.
    :type n: str
    :param e: Required. RSA public key exponent.
    :type e: str
    """

    _validation = {
        'type': {'required': True},
        'kid': {'required': True},
        'alg': {'required': True},
        'n': {'required': True},
        'e': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'kid': {'key': 'kid', 'type': 'str'},
        'alg': {'key': 'alg', 'type': 'str'},
        'n': {'key': 'n', 'type': 'str'},
        'e': {'key': 'e', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kid: str,
        alg: Union[str, "AccessPolicyRsaAlgo"],
        n: str,
        e: str,
        **kwargs
    ):
        super(RsaTokenKey, self).__init__(kid=kid, **kwargs)
        self.type = '#Microsoft.VideoAnalyzer.RsaTokenKey'  # type: str
        self.alg = alg
        self.n = n
        self.e = e


class ServiceSpecification(msrest.serialization.Model):
    """The service metric specifications.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar log_specifications: List of log specifications.
    :vartype log_specifications: list[~video_analyzer.models.LogSpecification]
    :ivar metric_specifications: List of metric specifications.
    :vartype metric_specifications: list[~video_analyzer.models.MetricSpecification]
    """

    _validation = {
        'log_specifications': {'readonly': True},
        'metric_specifications': {'readonly': True},
    }

    _attribute_map = {
        'log_specifications': {'key': 'logSpecifications', 'type': '[LogSpecification]'},
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceSpecification, self).__init__(**kwargs)
        self.log_specifications = None
        self.metric_specifications = None


class StorageAccount(msrest.serialization.Model):
    """The details about the associated storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: The ID of the storage account resource. Video Analyzer relies on tables, queues, and
     blobs. The primary storage account must be a Standard Storage account (either
     Microsoft.ClassicStorage or Microsoft.Storage).
    :type id: str
    :param identity: A managed identity that Video Analyzer will use to access the storage account.
    :type identity: ~video_analyzer.models.ResourceIdentity
    :ivar status: The current status of the storage account mapping.
    :vartype status: str
    """

    _validation = {
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        identity: Optional["ResourceIdentity"] = None,
        **kwargs
    ):
        super(StorageAccount, self).__init__(**kwargs)
        self.id = id
        self.identity = identity
        self.status = None


class SyncStorageKeysInput(msrest.serialization.Model):
    """The input to the sync storage keys request.

    :param id: The ID of the storage account resource.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(SyncStorageKeysInput, self).__init__(**kwargs)
        self.id = id


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~video_analyzer.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~video_analyzer.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TokenClaim(msrest.serialization.Model):
    """Properties for expected token claims.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the claim which must be present on the token.
    :type name: str
    :param value: Required. Expected value of the claim to be present on the token.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        value: str,
        **kwargs
    ):
        super(TokenClaim, self).__init__(**kwargs)
        self.name = name
        self.value = value


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class UserAssignedManagedIdentity(msrest.serialization.Model):
    """The details of the user assigned managed identity used by the Video Analyzer resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar client_id: The client ID.
    :vartype client_id: str
    :ivar principal_id: The principal ID.
    :vartype principal_id: str
    """

    _validation = {
        'client_id': {'readonly': True},
        'principal_id': {'readonly': True},
    }

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserAssignedManagedIdentity, self).__init__(**kwargs)
        self.client_id = None
        self.principal_id = None


class VideoAnalyzer(TrackedResource):
    """A Video Analyzer account.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :ivar system_data: The system data of the Video Analyzer account.
    :vartype system_data: ~video_analyzer.models.SystemData
    :param identity: The set of managed identities associated with the Video Analyzer resource.
    :type identity: ~video_analyzer.models.VideoAnalyzerIdentity
    :param storage_accounts: The storage accounts for this resource.
    :type storage_accounts: list[~video_analyzer.models.StorageAccount]
    :ivar endpoints: The list of endpoints associated with this resource.
    :vartype endpoints: list[~video_analyzer.models.Endpoint]
    :param encryption: The account encryption properties.
    :type encryption: ~video_analyzer.models.AccountEncryption
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'endpoints': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'identity': {'key': 'identity', 'type': 'VideoAnalyzerIdentity'},
        'storage_accounts': {'key': 'properties.storageAccounts', 'type': '[StorageAccount]'},
        'endpoints': {'key': 'properties.endpoints', 'type': '[Endpoint]'},
        'encryption': {'key': 'properties.encryption', 'type': 'AccountEncryption'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["VideoAnalyzerIdentity"] = None,
        storage_accounts: Optional[List["StorageAccount"]] = None,
        encryption: Optional["AccountEncryption"] = None,
        **kwargs
    ):
        super(VideoAnalyzer, self).__init__(tags=tags, location=location, **kwargs)
        self.system_data = None
        self.identity = identity
        self.storage_accounts = storage_accounts
        self.endpoints = None
        self.encryption = encryption


class VideoAnalyzerCollection(msrest.serialization.Model):
    """A collection of VideoAnalyzer items.

    :param value: A collection of VideoAnalyzer items.
    :type value: list[~video_analyzer.models.VideoAnalyzer]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VideoAnalyzer]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["VideoAnalyzer"]] = None,
        **kwargs
    ):
        super(VideoAnalyzerCollection, self).__init__(**kwargs)
        self.value = value


class VideoAnalyzerIdentity(msrest.serialization.Model):
    """The managed identity for the Video Analyzer resource.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The identity type.
    :type type: str
    :param user_assigned_identities: The User Assigned Managed Identities.
    :type user_assigned_identities: dict[str, ~video_analyzer.models.UserAssignedManagedIdentity]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedManagedIdentity}'},
    }

    def __init__(
        self,
        *,
        type: str,
        user_assigned_identities: Optional[Dict[str, "UserAssignedManagedIdentity"]] = None,
        **kwargs
    ):
        super(VideoAnalyzerIdentity, self).__init__(**kwargs)
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class VideoAnalyzerPropertiesUpdate(msrest.serialization.Model):
    """Properties of the Video Analyzer account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param storage_accounts: The storage accounts for this resource.
    :type storage_accounts: list[~video_analyzer.models.StorageAccount]
    :ivar endpoints: The list of endpoints associated with this resource.
    :vartype endpoints: list[~video_analyzer.models.Endpoint]
    :param encryption: The account encryption properties.
    :type encryption: ~video_analyzer.models.AccountEncryption
    """

    _validation = {
        'endpoints': {'readonly': True},
    }

    _attribute_map = {
        'storage_accounts': {'key': 'storageAccounts', 'type': '[StorageAccount]'},
        'endpoints': {'key': 'endpoints', 'type': '[Endpoint]'},
        'encryption': {'key': 'encryption', 'type': 'AccountEncryption'},
    }

    def __init__(
        self,
        *,
        storage_accounts: Optional[List["StorageAccount"]] = None,
        encryption: Optional["AccountEncryption"] = None,
        **kwargs
    ):
        super(VideoAnalyzerPropertiesUpdate, self).__init__(**kwargs)
        self.storage_accounts = storage_accounts
        self.endpoints = None
        self.encryption = encryption


class VideoAnalyzerProperties(VideoAnalyzerPropertiesUpdate):
    """VideoAnalyzerProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param storage_accounts: The storage accounts for this resource.
    :type storage_accounts: list[~video_analyzer.models.StorageAccount]
    :ivar endpoints: The list of endpoints associated with this resource.
    :vartype endpoints: list[~video_analyzer.models.Endpoint]
    :param encryption: The account encryption properties.
    :type encryption: ~video_analyzer.models.AccountEncryption
    """

    _validation = {
        'endpoints': {'readonly': True},
    }

    _attribute_map = {
        'storage_accounts': {'key': 'storageAccounts', 'type': '[StorageAccount]'},
        'endpoints': {'key': 'endpoints', 'type': '[Endpoint]'},
        'encryption': {'key': 'encryption', 'type': 'AccountEncryption'},
    }

    def __init__(
        self,
        *,
        storage_accounts: Optional[List["StorageAccount"]] = None,
        encryption: Optional["AccountEncryption"] = None,
        **kwargs
    ):
        super(VideoAnalyzerProperties, self).__init__(storage_accounts=storage_accounts, encryption=encryption, **kwargs)


class VideoAnalyzerUpdate(msrest.serialization.Model):
    """The update operation for a Video Analyzer account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity: The identities associated to the Video Analyzer resource.
    :type identity: ~video_analyzer.models.VideoAnalyzerIdentity
    :param storage_accounts: The storage accounts for this resource.
    :type storage_accounts: list[~video_analyzer.models.StorageAccount]
    :ivar endpoints: The list of endpoints associated with this resource.
    :vartype endpoints: list[~video_analyzer.models.Endpoint]
    :param encryption: The account encryption properties.
    :type encryption: ~video_analyzer.models.AccountEncryption
    """

    _validation = {
        'endpoints': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'VideoAnalyzerIdentity'},
        'storage_accounts': {'key': 'properties.storageAccounts', 'type': '[StorageAccount]'},
        'endpoints': {'key': 'properties.endpoints', 'type': '[Endpoint]'},
        'encryption': {'key': 'properties.encryption', 'type': 'AccountEncryption'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["VideoAnalyzerIdentity"] = None,
        storage_accounts: Optional[List["StorageAccount"]] = None,
        encryption: Optional["AccountEncryption"] = None,
        **kwargs
    ):
        super(VideoAnalyzerUpdate, self).__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.storage_accounts = storage_accounts
        self.endpoints = None
        self.encryption = encryption


class VideoEntity(ProxyResource):
    """The representation of a single video in a Video Analyzer account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~video_analyzer.models.SystemData
    :param title: Optional video title provided by the user. Value can be up to 256 characters
     long.
    :type title: str
    :param description: Optional video description provided by the user. Value can be up to 2048
     characters long.
    :type description: str
    :ivar type_properties_type: Type of the video archive. Different archive formats provide
     different capabilities. Possible values include: "Archive".
    :vartype type_properties_type: str or ~video_analyzer.models.VideoType
    :ivar flags: Video flags contain information about the available video actions and its dynamic
     properties based on the current video state.
    :vartype flags: ~video_analyzer.models.VideoFlags
    :ivar streaming: Video streaming holds information about video streaming URLs.
    :vartype streaming: ~video_analyzer.models.VideoStreaming
    :ivar media_info: Contains information about the video and audio content.
    :vartype media_info: ~video_analyzer.models.VideoMediaInfo
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'type_properties_type': {'readonly': True},
        'flags': {'readonly': True},
        'streaming': {'readonly': True},
        'media_info': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'flags': {'key': 'properties.flags', 'type': 'VideoFlags'},
        'streaming': {'key': 'properties.streaming', 'type': 'VideoStreaming'},
        'media_info': {'key': 'properties.mediaInfo', 'type': 'VideoMediaInfo'},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(VideoEntity, self).__init__(**kwargs)
        self.system_data = None
        self.title = title
        self.description = description
        self.type_properties_type = None
        self.flags = None
        self.streaming = None
        self.media_info = None


class VideoEntityCollection(msrest.serialization.Model):
    """A collection of VideoEntity items.

    :param value: A collection of VideoEntity items.
    :type value: list[~video_analyzer.models.VideoEntity]
    :param next_link: A link to the next page of the collection (when the collection contains too
     many results to return in one response).
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VideoEntity]'},
        'next_link': {'key': '@nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["VideoEntity"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VideoEntityCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VideoFlags(msrest.serialization.Model):
    """Video flags contain information about the available video actions and its dynamic properties based on the current video state.

    All required parameters must be populated in order to send to Azure.

    :param can_stream: Required. Value indicating whether or not the video can be streamed. Only
     "archive" type videos can be streamed.
    :type can_stream: bool
    :param has_data: Required. Value indicating whether or not there has ever been data recorded or
     uploaded into the video. Newly created videos have this value set to false.
    :type has_data: bool
    :param is_recording: Required. Value indicating whether or not the video is currently being
     referenced be an active live pipeline. The fact that is being referenced, doesn't necessarily
     indicate that data is being received. For example, video recording may be gated on events or
     camera may not be accessible at the time.
    :type is_recording: bool
    """

    _validation = {
        'can_stream': {'required': True},
        'has_data': {'required': True},
        'is_recording': {'required': True},
    }

    _attribute_map = {
        'can_stream': {'key': 'canStream', 'type': 'bool'},
        'has_data': {'key': 'hasData', 'type': 'bool'},
        'is_recording': {'key': 'isRecording', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        can_stream: bool,
        has_data: bool,
        is_recording: bool,
        **kwargs
    ):
        super(VideoFlags, self).__init__(**kwargs)
        self.can_stream = can_stream
        self.has_data = has_data
        self.is_recording = is_recording


class VideoMediaInfo(msrest.serialization.Model):
    """Contains information about the video and audio content.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar segment_length: Video segment length indicates the length of individual video files
     (segments) which are persisted to storage. Smaller segments provide lower archive playback
     latency but generate larger volume of storage transactions. Larger segments reduce the amount
     of storage transactions while increasing the archive playback latency. Value must be specified
     in ISO8601 duration format (i.e. "PT30S" equals 30 seconds) and can vary between 30 seconds to
     5 minutes, in 30 seconds increments.
    :vartype segment_length: str
    """

    _validation = {
        'segment_length': {'readonly': True},
    }

    _attribute_map = {
        'segment_length': {'key': 'segmentLength', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoMediaInfo, self).__init__(**kwargs)
        self.segment_length = None


class VideoStreaming(msrest.serialization.Model):
    """Video streaming holds information about video streaming URLs.

    :param archive_base_url: Video streaming base URL for the video archive. When present, archived
     video can be played through the Azure Video Analyzer player. Alternatively, this URL can be
     used with compatible DASH or HLS players by appending the following to the base URL:
    
    
     * HLSv4:     /manifest(format=m3u8-aapl).m3u8
     * HLS CMAF:  /manifest(format=m3u8-cmaf)
     * DASH CMAF: /manifest(format=mpd-time-cmaf)
    
     Moreover, an ongoing video recording can be played in "live mode" with latencies which are
     approximately double of the chosen video segment length.
    :type archive_base_url: str
    """

    _attribute_map = {
        'archive_base_url': {'key': 'archiveBaseUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        archive_base_url: Optional[str] = None,
        **kwargs
    ):
        super(VideoStreaming, self).__init__(**kwargs)
        self.archive_base_url = archive_base_url


class VideoStreamingToken(msrest.serialization.Model):
    """Video streaming token grants access to the video streaming URLs which can be used by an compatible HLS or DASH player.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar expiration_date: The streaming token expiration date in ISO8601 format (eg.
     2021-01-01T00:00:00Z).
    :vartype expiration_date: ~datetime.datetime
    :ivar token: The streaming token value to be added to the video streaming URL as the value for
     a "token" query string parameter. The token is specific to a single video.
    :vartype token: str
    """

    _validation = {
        'expiration_date': {'readonly': True},
        'token': {'readonly': True},
    }

    _attribute_map = {
        'expiration_date': {'key': 'expirationDate', 'type': 'iso-8601'},
        'token': {'key': 'token', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoStreamingToken, self).__init__(**kwargs)
        self.expiration_date = None
        self.token = None
