#pragma once

#if defined(_WIN32) || defined(_WIN64)
#define GLAPI __stdcall
#else
#define GLAPI
#endif

namespace OpenGL {

	#ifdef __x86_64__
		typedef long long int GLsizeiptr;
		typedef long long int GLintptr;
	#else
		typedef int GLsizeiptr;
		typedef int GLintptr;
	#endif 

	typedef char GLbyte;
	typedef char GLchar;
	typedef double GLclampd;
	typedef double GLdouble;
	typedef float GLclampf;
	typedef float GLfloat;
	typedef int GLint;
	typedef int GLsizei;
	typedef long long int GLint64;
	typedef short GLshort;
	typedef struct __GLsync * GLsync;
	typedef unsigned char GLboolean;
	typedef unsigned char GLubyte;
	typedef unsigned int GLbitfield;
	typedef unsigned int GLenum;
	typedef unsigned int GLuint;
	typedef unsigned long long int GLuint64;
	typedef unsigned short GLhalf;
	typedef unsigned short GLushort;
	typedef void GLvoid;

	typedef void (* GLDEBUGPROC) (GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar * message, const void * userParam);

	bool InitializeOpenGL();

	const GLenum   GL_DEPTH_BUFFER_BIT                                           = 0x0100;
	const GLenum   GL_STENCIL_BUFFER_BIT                                         = 0x0400;
	const GLenum   GL_COLOR_BUFFER_BIT                                           = 0x4000;
	const GLenum   GL_FALSE                                                      = 0x0000;
	const GLenum   GL_TRUE                                                       = 0x0001;
	const GLenum   GL_POINTS                                                     = 0x0000;
	const GLenum   GL_LINES                                                      = 0x0001;
	const GLenum   GL_LINE_LOOP                                                  = 0x0002;
	const GLenum   GL_LINE_STRIP                                                 = 0x0003;
	const GLenum   GL_TRIANGLES                                                  = 0x0004;
	const GLenum   GL_TRIANGLE_STRIP                                             = 0x0005;
	const GLenum   GL_TRIANGLE_FAN                                               = 0x0006;
	const GLenum   GL_QUADS                                                      = 0x0007;
	const GLenum   GL_NEVER                                                      = 0x0200;
	const GLenum   GL_LESS                                                       = 0x0201;
	const GLenum   GL_EQUAL                                                      = 0x0202;
	const GLenum   GL_LEQUAL                                                     = 0x0203;
	const GLenum   GL_GREATER                                                    = 0x0204;
	const GLenum   GL_NOTEQUAL                                                   = 0x0205;
	const GLenum   GL_GEQUAL                                                     = 0x0206;
	const GLenum   GL_ALWAYS                                                     = 0x0207;
	const GLenum   GL_ZERO                                                       = 0x0000;
	const GLenum   GL_ONE                                                        = 0x0001;
	const GLenum   GL_SRC_COLOR                                                  = 0x0300;
	const GLenum   GL_ONE_MINUS_SRC_COLOR                                        = 0x0301;
	const GLenum   GL_SRC_ALPHA                                                  = 0x0302;
	const GLenum   GL_ONE_MINUS_SRC_ALPHA                                        = 0x0303;
	const GLenum   GL_DST_ALPHA                                                  = 0x0304;
	const GLenum   GL_ONE_MINUS_DST_ALPHA                                        = 0x0305;
	const GLenum   GL_DST_COLOR                                                  = 0x0306;
	const GLenum   GL_ONE_MINUS_DST_COLOR                                        = 0x0307;
	const GLenum   GL_SRC_ALPHA_SATURATE                                         = 0x0308;
	const GLenum   GL_NONE                                                       = 0x0000;
	const GLenum   GL_FRONT_LEFT                                                 = 0x0400;
	const GLenum   GL_FRONT_RIGHT                                                = 0x0401;
	const GLenum   GL_BACK_LEFT                                                  = 0x0402;
	const GLenum   GL_BACK_RIGHT                                                 = 0x0403;
	const GLenum   GL_FRONT                                                      = 0x0404;
	const GLenum   GL_BACK                                                       = 0x0405;
	const GLenum   GL_LEFT                                                       = 0x0406;
	const GLenum   GL_RIGHT                                                      = 0x0407;
	const GLenum   GL_FRONT_AND_BACK                                             = 0x0408;
	const GLenum   GL_NO_ERROR                                                   = 0x0000;
	const GLenum   GL_INVALID_ENUM                                               = 0x0500;
	const GLenum   GL_INVALID_VALUE                                              = 0x0501;
	const GLenum   GL_INVALID_OPERATION                                          = 0x0502;
	const GLenum   GL_OUT_OF_MEMORY                                              = 0x0505;
	const GLenum   GL_CW                                                         = 0x0900;
	const GLenum   GL_CCW                                                        = 0x0901;
	const GLenum   GL_POINT_SIZE                                                 = 0x0B11;
	const GLenum   GL_POINT_SIZE_RANGE                                           = 0x0B12;
	const GLenum   GL_POINT_SIZE_GRANULARITY                                     = 0x0B13;
	const GLenum   GL_LINE_SMOOTH                                                = 0x0B20;
	const GLenum   GL_LINE_WIDTH                                                 = 0x0B21;
	const GLenum   GL_LINE_WIDTH_RANGE                                           = 0x0B22;
	const GLenum   GL_LINE_WIDTH_GRANULARITY                                     = 0x0B23;
	const GLenum   GL_POLYGON_MODE                                               = 0x0B40;
	const GLenum   GL_POLYGON_SMOOTH                                             = 0x0B41;
	const GLenum   GL_CULL_FACE                                                  = 0x0B44;
	const GLenum   GL_CULL_FACE_MODE                                             = 0x0B45;
	const GLenum   GL_FRONT_FACE                                                 = 0x0B46;
	const GLenum   GL_DEPTH_RANGE                                                = 0x0B70;
	const GLenum   GL_DEPTH_TEST                                                 = 0x0B71;
	const GLenum   GL_DEPTH_WRITEMASK                                            = 0x0B72;
	const GLenum   GL_DEPTH_CLEAR_VALUE                                          = 0x0B73;
	const GLenum   GL_DEPTH_FUNC                                                 = 0x0B74;
	const GLenum   GL_STENCIL_TEST                                               = 0x0B90;
	const GLenum   GL_STENCIL_CLEAR_VALUE                                        = 0x0B91;
	const GLenum   GL_STENCIL_FUNC                                               = 0x0B92;
	const GLenum   GL_STENCIL_VALUE_MASK                                         = 0x0B93;
	const GLenum   GL_STENCIL_FAIL                                               = 0x0B94;
	const GLenum   GL_STENCIL_PASS_DEPTH_FAIL                                    = 0x0B95;
	const GLenum   GL_STENCIL_PASS_DEPTH_PASS                                    = 0x0B96;
	const GLenum   GL_STENCIL_REF                                                = 0x0B97;
	const GLenum   GL_STENCIL_WRITEMASK                                          = 0x0B98;
	const GLenum   GL_VIEWPORT                                                   = 0x0BA2;
	const GLenum   GL_DITHER                                                     = 0x0BD0;
	const GLenum   GL_BLEND_DST                                                  = 0x0BE0;
	const GLenum   GL_BLEND_SRC                                                  = 0x0BE1;
	const GLenum   GL_BLEND                                                      = 0x0BE2;
	const GLenum   GL_LOGIC_OP_MODE                                              = 0x0BF0;
	const GLenum   GL_COLOR_LOGIC_OP                                             = 0x0BF2;
	const GLenum   GL_DRAW_BUFFER                                                = 0x0C01;
	const GLenum   GL_READ_BUFFER                                                = 0x0C02;
	const GLenum   GL_SCISSOR_BOX                                                = 0x0C10;
	const GLenum   GL_SCISSOR_TEST                                               = 0x0C11;
	const GLenum   GL_COLOR_CLEAR_VALUE                                          = 0x0C22;
	const GLenum   GL_COLOR_WRITEMASK                                            = 0x0C23;
	const GLenum   GL_DOUBLEBUFFER                                               = 0x0C32;
	const GLenum   GL_STEREO                                                     = 0x0C33;
	const GLenum   GL_LINE_SMOOTH_HINT                                           = 0x0C52;
	const GLenum   GL_POLYGON_SMOOTH_HINT                                        = 0x0C53;
	const GLenum   GL_UNPACK_SWAP_BYTES                                          = 0x0CF0;
	const GLenum   GL_UNPACK_LSB_FIRST                                           = 0x0CF1;
	const GLenum   GL_UNPACK_ROW_LENGTH                                          = 0x0CF2;
	const GLenum   GL_UNPACK_SKIP_ROWS                                           = 0x0CF3;
	const GLenum   GL_UNPACK_SKIP_PIXELS                                         = 0x0CF4;
	const GLenum   GL_UNPACK_ALIGNMENT                                           = 0x0CF5;
	const GLenum   GL_PACK_SWAP_BYTES                                            = 0x0D00;
	const GLenum   GL_PACK_LSB_FIRST                                             = 0x0D01;
	const GLenum   GL_PACK_ROW_LENGTH                                            = 0x0D02;
	const GLenum   GL_PACK_SKIP_ROWS                                             = 0x0D03;
	const GLenum   GL_PACK_SKIP_PIXELS                                           = 0x0D04;
	const GLenum   GL_PACK_ALIGNMENT                                             = 0x0D05;
	const GLenum   GL_MAX_TEXTURE_SIZE                                           = 0x0D33;
	const GLenum   GL_MAX_VIEWPORT_DIMS                                          = 0x0D3A;
	const GLenum   GL_SUBPIXEL_BITS                                              = 0x0D50;
	const GLenum   GL_TEXTURE_1D                                                 = 0x0DE0;
	const GLenum   GL_TEXTURE_2D                                                 = 0x0DE1;
	const GLenum   GL_POLYGON_OFFSET_UNITS                                       = 0x2A00;
	const GLenum   GL_POLYGON_OFFSET_POINT                                       = 0x2A01;
	const GLenum   GL_POLYGON_OFFSET_LINE                                        = 0x2A02;
	const GLenum   GL_POLYGON_OFFSET_FILL                                        = 0x8037;
	const GLenum   GL_POLYGON_OFFSET_FACTOR                                      = 0x8038;
	const GLenum   GL_TEXTURE_BINDING_1D                                         = 0x8068;
	const GLenum   GL_TEXTURE_BINDING_2D                                         = 0x8069;
	const GLenum   GL_TEXTURE_WIDTH                                              = 0x1000;
	const GLenum   GL_TEXTURE_HEIGHT                                             = 0x1001;
	const GLenum   GL_TEXTURE_INTERNAL_FORMAT                                    = 0x1003;
	const GLenum   GL_TEXTURE_BORDER_COLOR                                       = 0x1004;
	const GLenum   GL_TEXTURE_RED_SIZE                                           = 0x805C;
	const GLenum   GL_TEXTURE_GREEN_SIZE                                         = 0x805D;
	const GLenum   GL_TEXTURE_BLUE_SIZE                                          = 0x805E;
	const GLenum   GL_TEXTURE_ALPHA_SIZE                                         = 0x805F;
	const GLenum   GL_DONT_CARE                                                  = 0x1100;
	const GLenum   GL_FASTEST                                                    = 0x1101;
	const GLenum   GL_NICEST                                                     = 0x1102;
	const GLenum   GL_BYTE                                                       = 0x1400;
	const GLenum   GL_UNSIGNED_BYTE                                              = 0x1401;
	const GLenum   GL_SHORT                                                      = 0x1402;
	const GLenum   GL_UNSIGNED_SHORT                                             = 0x1403;
	const GLenum   GL_INT                                                        = 0x1404;
	const GLenum   GL_UNSIGNED_INT                                               = 0x1405;
	const GLenum   GL_FLOAT                                                      = 0x1406;
	const GLenum   GL_DOUBLE                                                     = 0x140A;
	const GLenum   GL_STACK_OVERFLOW                                             = 0x0503;
	const GLenum   GL_STACK_UNDERFLOW                                            = 0x0504;
	const GLenum   GL_CLEAR                                                      = 0x1500;
	const GLenum   GL_AND                                                        = 0x1501;
	const GLenum   GL_AND_REVERSE                                                = 0x1502;
	const GLenum   GL_COPY                                                       = 0x1503;
	const GLenum   GL_AND_INVERTED                                               = 0x1504;
	const GLenum   GL_NOOP                                                       = 0x1505;
	const GLenum   GL_XOR                                                        = 0x1506;
	const GLenum   GL_OR                                                         = 0x1507;
	const GLenum   GL_NOR                                                        = 0x1508;
	const GLenum   GL_EQUIV                                                      = 0x1509;
	const GLenum   GL_INVERT                                                     = 0x150A;
	const GLenum   GL_OR_REVERSE                                                 = 0x150B;
	const GLenum   GL_COPY_INVERTED                                              = 0x150C;
	const GLenum   GL_OR_INVERTED                                                = 0x150D;
	const GLenum   GL_NAND                                                       = 0x150E;
	const GLenum   GL_SET                                                        = 0x150F;
	const GLenum   GL_TEXTURE                                                    = 0x1702;
	const GLenum   GL_COLOR                                                      = 0x1800;
	const GLenum   GL_DEPTH                                                      = 0x1801;
	const GLenum   GL_STENCIL                                                    = 0x1802;
	const GLenum   GL_STENCIL_INDEX                                              = 0x1901;
	const GLenum   GL_DEPTH_COMPONENT                                            = 0x1902;
	const GLenum   GL_RED                                                        = 0x1903;
	const GLenum   GL_GREEN                                                      = 0x1904;
	const GLenum   GL_BLUE                                                       = 0x1905;
	const GLenum   GL_ALPHA                                                      = 0x1906;
	const GLenum   GL_RGB                                                        = 0x1907;
	const GLenum   GL_RGBA                                                       = 0x1908;
	const GLenum   GL_POINT                                                      = 0x1B00;
	const GLenum   GL_LINE                                                       = 0x1B01;
	const GLenum   GL_FILL                                                       = 0x1B02;
	const GLenum   GL_KEEP                                                       = 0x1E00;
	const GLenum   GL_REPLACE                                                    = 0x1E01;
	const GLenum   GL_INCR                                                       = 0x1E02;
	const GLenum   GL_DECR                                                       = 0x1E03;
	const GLenum   GL_VENDOR                                                     = 0x1F00;
	const GLenum   GL_RENDERER                                                   = 0x1F01;
	const GLenum   GL_VERSION                                                    = 0x1F02;
	const GLenum   GL_EXTENSIONS                                                 = 0x1F03;
	const GLenum   GL_NEAREST                                                    = 0x2600;
	const GLenum   GL_LINEAR                                                     = 0x2601;
	const GLenum   GL_NEAREST_MIPMAP_NEAREST                                     = 0x2700;
	const GLenum   GL_LINEAR_MIPMAP_NEAREST                                      = 0x2701;
	const GLenum   GL_NEAREST_MIPMAP_LINEAR                                      = 0x2702;
	const GLenum   GL_LINEAR_MIPMAP_LINEAR                                       = 0x2703;
	const GLenum   GL_TEXTURE_MAG_FILTER                                         = 0x2800;
	const GLenum   GL_TEXTURE_MIN_FILTER                                         = 0x2801;
	const GLenum   GL_TEXTURE_WRAP_S                                             = 0x2802;
	const GLenum   GL_TEXTURE_WRAP_T                                             = 0x2803;
	const GLenum   GL_PROXY_TEXTURE_1D                                           = 0x8063;
	const GLenum   GL_PROXY_TEXTURE_2D                                           = 0x8064;
	const GLenum   GL_REPEAT                                                     = 0x2901;
	const GLenum   GL_R3_G3_B2                                                   = 0x2A10;
	const GLenum   GL_RGB4                                                       = 0x804F;
	const GLenum   GL_RGB5                                                       = 0x8050;
	const GLenum   GL_RGB8                                                       = 0x8051;
	const GLenum   GL_RGB10                                                      = 0x8052;
	const GLenum   GL_RGB12                                                      = 0x8053;
	const GLenum   GL_RGB16                                                      = 0x8054;
	const GLenum   GL_RGBA2                                                      = 0x8055;
	const GLenum   GL_RGBA4                                                      = 0x8056;
	const GLenum   GL_RGB5_A1                                                    = 0x8057;
	const GLenum   GL_RGBA8                                                      = 0x8058;
	const GLenum   GL_RGB10_A2                                                   = 0x8059;
	const GLenum   GL_RGBA12                                                     = 0x805A;
	const GLenum   GL_RGBA16                                                     = 0x805B;
	const GLenum   GL_VERTEX_ARRAY                                               = 0x8074;
	const GLenum   GL_UNSIGNED_BYTE_3_3_2                                        = 0x8032;
	const GLenum   GL_UNSIGNED_SHORT_4_4_4_4                                     = 0x8033;
	const GLenum   GL_UNSIGNED_SHORT_5_5_5_1                                     = 0x8034;
	const GLenum   GL_UNSIGNED_INT_8_8_8_8                                       = 0x8035;
	const GLenum   GL_UNSIGNED_INT_10_10_10_2                                    = 0x8036;
	const GLenum   GL_TEXTURE_BINDING_3D                                         = 0x806A;
	const GLenum   GL_PACK_SKIP_IMAGES                                           = 0x806B;
	const GLenum   GL_PACK_IMAGE_HEIGHT                                          = 0x806C;
	const GLenum   GL_UNPACK_SKIP_IMAGES                                         = 0x806D;
	const GLenum   GL_UNPACK_IMAGE_HEIGHT                                        = 0x806E;
	const GLenum   GL_TEXTURE_3D                                                 = 0x806F;
	const GLenum   GL_PROXY_TEXTURE_3D                                           = 0x8070;
	const GLenum   GL_TEXTURE_DEPTH                                              = 0x8071;
	const GLenum   GL_TEXTURE_WRAP_R                                             = 0x8072;
	const GLenum   GL_MAX_3D_TEXTURE_SIZE                                        = 0x8073;
	const GLenum   GL_UNSIGNED_BYTE_2_3_3_REV                                    = 0x8362;
	const GLenum   GL_UNSIGNED_SHORT_5_6_5                                       = 0x8363;
	const GLenum   GL_UNSIGNED_SHORT_5_6_5_REV                                   = 0x8364;
	const GLenum   GL_UNSIGNED_SHORT_4_4_4_4_REV                                 = 0x8365;
	const GLenum   GL_UNSIGNED_SHORT_1_5_5_5_REV                                 = 0x8366;
	const GLenum   GL_UNSIGNED_INT_8_8_8_8_REV                                   = 0x8367;
	const GLenum   GL_UNSIGNED_INT_2_10_10_10_REV                                = 0x8368;
	const GLenum   GL_BGR                                                        = 0x80E0;
	const GLenum   GL_BGRA                                                       = 0x80E1;
	const GLenum   GL_MAX_ELEMENTS_VERTICES                                      = 0x80E8;
	const GLenum   GL_MAX_ELEMENTS_INDICES                                       = 0x80E9;
	const GLenum   GL_CLAMP_TO_EDGE                                              = 0x812F;
	const GLenum   GL_TEXTURE_MIN_LOD                                            = 0x813A;
	const GLenum   GL_TEXTURE_MAX_LOD                                            = 0x813B;
	const GLenum   GL_TEXTURE_BASE_LEVEL                                         = 0x813C;
	const GLenum   GL_TEXTURE_MAX_LEVEL                                          = 0x813D;
	const GLenum   GL_SMOOTH_POINT_SIZE_RANGE                                    = 0x0B12;
	const GLenum   GL_SMOOTH_POINT_SIZE_GRANULARITY                              = 0x0B13;
	const GLenum   GL_SMOOTH_LINE_WIDTH_RANGE                                    = 0x0B22;
	const GLenum   GL_SMOOTH_LINE_WIDTH_GRANULARITY                              = 0x0B23;
	const GLenum   GL_ALIASED_LINE_WIDTH_RANGE                                   = 0x846E;
	const GLenum   GL_TEXTURE0                                                   = 0x84C0;
	const GLenum   GL_TEXTURE1                                                   = 0x84C1;
	const GLenum   GL_TEXTURE2                                                   = 0x84C2;
	const GLenum   GL_TEXTURE3                                                   = 0x84C3;
	const GLenum   GL_TEXTURE4                                                   = 0x84C4;
	const GLenum   GL_TEXTURE5                                                   = 0x84C5;
	const GLenum   GL_TEXTURE6                                                   = 0x84C6;
	const GLenum   GL_TEXTURE7                                                   = 0x84C7;
	const GLenum   GL_TEXTURE8                                                   = 0x84C8;
	const GLenum   GL_TEXTURE9                                                   = 0x84C9;
	const GLenum   GL_TEXTURE10                                                  = 0x84CA;
	const GLenum   GL_TEXTURE11                                                  = 0x84CB;
	const GLenum   GL_TEXTURE12                                                  = 0x84CC;
	const GLenum   GL_TEXTURE13                                                  = 0x84CD;
	const GLenum   GL_TEXTURE14                                                  = 0x84CE;
	const GLenum   GL_TEXTURE15                                                  = 0x84CF;
	const GLenum   GL_TEXTURE16                                                  = 0x84D0;
	const GLenum   GL_TEXTURE17                                                  = 0x84D1;
	const GLenum   GL_TEXTURE18                                                  = 0x84D2;
	const GLenum   GL_TEXTURE19                                                  = 0x84D3;
	const GLenum   GL_TEXTURE20                                                  = 0x84D4;
	const GLenum   GL_TEXTURE21                                                  = 0x84D5;
	const GLenum   GL_TEXTURE22                                                  = 0x84D6;
	const GLenum   GL_TEXTURE23                                                  = 0x84D7;
	const GLenum   GL_TEXTURE24                                                  = 0x84D8;
	const GLenum   GL_TEXTURE25                                                  = 0x84D9;
	const GLenum   GL_TEXTURE26                                                  = 0x84DA;
	const GLenum   GL_TEXTURE27                                                  = 0x84DB;
	const GLenum   GL_TEXTURE28                                                  = 0x84DC;
	const GLenum   GL_TEXTURE29                                                  = 0x84DD;
	const GLenum   GL_TEXTURE30                                                  = 0x84DE;
	const GLenum   GL_TEXTURE31                                                  = 0x84DF;
	const GLenum   GL_ACTIVE_TEXTURE                                             = 0x84E0;
	const GLenum   GL_MULTISAMPLE                                                = 0x809D;
	const GLenum   GL_SAMPLE_ALPHA_TO_COVERAGE                                   = 0x809E;
	const GLenum   GL_SAMPLE_ALPHA_TO_ONE                                        = 0x809F;
	const GLenum   GL_SAMPLE_COVERAGE                                            = 0x80A0;
	const GLenum   GL_SAMPLE_BUFFERS                                             = 0x80A8;
	const GLenum   GL_SAMPLES                                                    = 0x80A9;
	const GLenum   GL_SAMPLE_COVERAGE_VALUE                                      = 0x80AA;
	const GLenum   GL_SAMPLE_COVERAGE_INVERT                                     = 0x80AB;
	const GLenum   GL_TEXTURE_CUBE_MAP                                           = 0x8513;
	const GLenum   GL_TEXTURE_BINDING_CUBE_MAP                                   = 0x8514;
	const GLenum   GL_TEXTURE_CUBE_MAP_POSITIVE_X                                = 0x8515;
	const GLenum   GL_TEXTURE_CUBE_MAP_NEGATIVE_X                                = 0x8516;
	const GLenum   GL_TEXTURE_CUBE_MAP_POSITIVE_Y                                = 0x8517;
	const GLenum   GL_TEXTURE_CUBE_MAP_NEGATIVE_Y                                = 0x8518;
	const GLenum   GL_TEXTURE_CUBE_MAP_POSITIVE_Z                                = 0x8519;
	const GLenum   GL_TEXTURE_CUBE_MAP_NEGATIVE_Z                                = 0x851A;
	const GLenum   GL_PROXY_TEXTURE_CUBE_MAP                                     = 0x851B;
	const GLenum   GL_MAX_CUBE_MAP_TEXTURE_SIZE                                  = 0x851C;
	const GLenum   GL_COMPRESSED_RGB                                             = 0x84ED;
	const GLenum   GL_COMPRESSED_RGBA                                            = 0x84EE;
	const GLenum   GL_TEXTURE_COMPRESSION_HINT                                   = 0x84EF;
	const GLenum   GL_TEXTURE_COMPRESSED_IMAGE_SIZE                              = 0x86A0;
	const GLenum   GL_TEXTURE_COMPRESSED                                         = 0x86A1;
	const GLenum   GL_NUM_COMPRESSED_TEXTURE_FORMATS                             = 0x86A2;
	const GLenum   GL_COMPRESSED_TEXTURE_FORMATS                                 = 0x86A3;
	const GLenum   GL_CLAMP_TO_BORDER                                            = 0x812D;
	const GLenum   GL_BLEND_DST_RGB                                              = 0x80C8;
	const GLenum   GL_BLEND_SRC_RGB                                              = 0x80C9;
	const GLenum   GL_BLEND_DST_ALPHA                                            = 0x80CA;
	const GLenum   GL_BLEND_SRC_ALPHA                                            = 0x80CB;
	const GLenum   GL_POINT_FADE_THRESHOLD_SIZE                                  = 0x8128;
	const GLenum   GL_DEPTH_COMPONENT16                                          = 0x81A5;
	const GLenum   GL_DEPTH_COMPONENT24                                          = 0x81A6;
	const GLenum   GL_DEPTH_COMPONENT32                                          = 0x81A7;
	const GLenum   GL_MIRRORED_REPEAT                                            = 0x8370;
	const GLenum   GL_MAX_TEXTURE_LOD_BIAS                                       = 0x84FD;
	const GLenum   GL_TEXTURE_LOD_BIAS                                           = 0x8501;
	const GLenum   GL_INCR_WRAP                                                  = 0x8507;
	const GLenum   GL_DECR_WRAP                                                  = 0x8508;
	const GLenum   GL_TEXTURE_DEPTH_SIZE                                         = 0x884A;
	const GLenum   GL_TEXTURE_COMPARE_MODE                                       = 0x884C;
	const GLenum   GL_TEXTURE_COMPARE_FUNC                                       = 0x884D;
	const GLenum   GL_FUNC_ADD                                                   = 0x8006;
	const GLenum   GL_FUNC_SUBTRACT                                              = 0x800A;
	const GLenum   GL_FUNC_REVERSE_SUBTRACT                                      = 0x800B;
	const GLenum   GL_MIN                                                        = 0x8007;
	const GLenum   GL_MAX                                                        = 0x8008;
	const GLenum   GL_CONSTANT_COLOR                                             = 0x8001;
	const GLenum   GL_ONE_MINUS_CONSTANT_COLOR                                   = 0x8002;
	const GLenum   GL_CONSTANT_ALPHA                                             = 0x8003;
	const GLenum   GL_ONE_MINUS_CONSTANT_ALPHA                                   = 0x8004;
	const GLenum   GL_BUFFER_SIZE                                                = 0x8764;
	const GLenum   GL_BUFFER_USAGE                                               = 0x8765;
	const GLenum   GL_QUERY_COUNTER_BITS                                         = 0x8864;
	const GLenum   GL_CURRENT_QUERY                                              = 0x8865;
	const GLenum   GL_QUERY_RESULT                                               = 0x8866;
	const GLenum   GL_QUERY_RESULT_AVAILABLE                                     = 0x8867;
	const GLenum   GL_ARRAY_BUFFER                                               = 0x8892;
	const GLenum   GL_ELEMENT_ARRAY_BUFFER                                       = 0x8893;
	const GLenum   GL_ARRAY_BUFFER_BINDING                                       = 0x8894;
	const GLenum   GL_ELEMENT_ARRAY_BUFFER_BINDING                               = 0x8895;
	const GLenum   GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING                         = 0x889F;
	const GLenum   GL_READ_ONLY                                                  = 0x88B8;
	const GLenum   GL_WRITE_ONLY                                                 = 0x88B9;
	const GLenum   GL_READ_WRITE                                                 = 0x88BA;
	const GLenum   GL_BUFFER_ACCESS                                              = 0x88BB;
	const GLenum   GL_BUFFER_MAPPED                                              = 0x88BC;
	const GLenum   GL_BUFFER_MAP_POINTER                                         = 0x88BD;
	const GLenum   GL_STREAM_DRAW                                                = 0x88E0;
	const GLenum   GL_STREAM_READ                                                = 0x88E1;
	const GLenum   GL_STREAM_COPY                                                = 0x88E2;
	const GLenum   GL_STATIC_DRAW                                                = 0x88E4;
	const GLenum   GL_STATIC_READ                                                = 0x88E5;
	const GLenum   GL_STATIC_COPY                                                = 0x88E6;
	const GLenum   GL_DYNAMIC_DRAW                                               = 0x88E8;
	const GLenum   GL_DYNAMIC_READ                                               = 0x88E9;
	const GLenum   GL_DYNAMIC_COPY                                               = 0x88EA;
	const GLenum   GL_SAMPLES_PASSED                                             = 0x8914;
	const GLenum   GL_SRC1_ALPHA                                                 = 0x8589;
	const GLenum   GL_BLEND_EQUATION_RGB                                         = 0x8009;
	const GLenum   GL_VERTEX_ATTRIB_ARRAY_ENABLED                                = 0x8622;
	const GLenum   GL_VERTEX_ATTRIB_ARRAY_SIZE                                   = 0x8623;
	const GLenum   GL_VERTEX_ATTRIB_ARRAY_STRIDE                                 = 0x8624;
	const GLenum   GL_VERTEX_ATTRIB_ARRAY_TYPE                                   = 0x8625;
	const GLenum   GL_CURRENT_VERTEX_ATTRIB                                      = 0x8626;
	const GLenum   GL_VERTEX_PROGRAM_POINT_SIZE                                  = 0x8642;
	const GLenum   GL_VERTEX_ATTRIB_ARRAY_POINTER                                = 0x8645;
	const GLenum   GL_STENCIL_BACK_FUNC                                          = 0x8800;
	const GLenum   GL_STENCIL_BACK_FAIL                                          = 0x8801;
	const GLenum   GL_STENCIL_BACK_PASS_DEPTH_FAIL                               = 0x8802;
	const GLenum   GL_STENCIL_BACK_PASS_DEPTH_PASS                               = 0x8803;
	const GLenum   GL_MAX_DRAW_BUFFERS                                           = 0x8824;
	const GLenum   GL_DRAW_BUFFER0                                               = 0x8825;
	const GLenum   GL_DRAW_BUFFER1                                               = 0x8826;
	const GLenum   GL_DRAW_BUFFER2                                               = 0x8827;
	const GLenum   GL_DRAW_BUFFER3                                               = 0x8828;
	const GLenum   GL_DRAW_BUFFER4                                               = 0x8829;
	const GLenum   GL_DRAW_BUFFER5                                               = 0x882A;
	const GLenum   GL_DRAW_BUFFER6                                               = 0x882B;
	const GLenum   GL_DRAW_BUFFER7                                               = 0x882C;
	const GLenum   GL_DRAW_BUFFER8                                               = 0x882D;
	const GLenum   GL_DRAW_BUFFER9                                               = 0x882E;
	const GLenum   GL_DRAW_BUFFER10                                              = 0x882F;
	const GLenum   GL_DRAW_BUFFER11                                              = 0x8830;
	const GLenum   GL_DRAW_BUFFER12                                              = 0x8831;
	const GLenum   GL_DRAW_BUFFER13                                              = 0x8832;
	const GLenum   GL_DRAW_BUFFER14                                              = 0x8833;
	const GLenum   GL_DRAW_BUFFER15                                              = 0x8834;
	const GLenum   GL_BLEND_EQUATION_ALPHA                                       = 0x883D;
	const GLenum   GL_MAX_VERTEX_ATTRIBS                                         = 0x8869;
	const GLenum   GL_VERTEX_ATTRIB_ARRAY_NORMALIZED                             = 0x886A;
	const GLenum   GL_MAX_TEXTURE_IMAGE_UNITS                                    = 0x8872;
	const GLenum   GL_FRAGMENT_SHADER                                            = 0x8B30;
	const GLenum   GL_VERTEX_SHADER                                              = 0x8B31;
	const GLenum   GL_MAX_FRAGMENT_UNIFORM_COMPONENTS                            = 0x8B49;
	const GLenum   GL_MAX_VERTEX_UNIFORM_COMPONENTS                              = 0x8B4A;
	const GLenum   GL_MAX_VARYING_FLOATS                                         = 0x8B4B;
	const GLenum   GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS                             = 0x8B4C;
	const GLenum   GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS                           = 0x8B4D;
	const GLenum   GL_SHADER_TYPE                                                = 0x8B4F;
	const GLenum   GL_FLOAT_VEC2                                                 = 0x8B50;
	const GLenum   GL_FLOAT_VEC3                                                 = 0x8B51;
	const GLenum   GL_FLOAT_VEC4                                                 = 0x8B52;
	const GLenum   GL_INT_VEC2                                                   = 0x8B53;
	const GLenum   GL_INT_VEC3                                                   = 0x8B54;
	const GLenum   GL_INT_VEC4                                                   = 0x8B55;
	const GLenum   GL_BOOL                                                       = 0x8B56;
	const GLenum   GL_BOOL_VEC2                                                  = 0x8B57;
	const GLenum   GL_BOOL_VEC3                                                  = 0x8B58;
	const GLenum   GL_BOOL_VEC4                                                  = 0x8B59;
	const GLenum   GL_FLOAT_MAT2                                                 = 0x8B5A;
	const GLenum   GL_FLOAT_MAT3                                                 = 0x8B5B;
	const GLenum   GL_FLOAT_MAT4                                                 = 0x8B5C;
	const GLenum   GL_SAMPLER_1D                                                 = 0x8B5D;
	const GLenum   GL_SAMPLER_2D                                                 = 0x8B5E;
	const GLenum   GL_SAMPLER_3D                                                 = 0x8B5F;
	const GLenum   GL_SAMPLER_CUBE                                               = 0x8B60;
	const GLenum   GL_SAMPLER_1D_SHADOW                                          = 0x8B61;
	const GLenum   GL_SAMPLER_2D_SHADOW                                          = 0x8B62;
	const GLenum   GL_DELETE_STATUS                                              = 0x8B80;
	const GLenum   GL_COMPILE_STATUS                                             = 0x8B81;
	const GLenum   GL_LINK_STATUS                                                = 0x8B82;
	const GLenum   GL_VALIDATE_STATUS                                            = 0x8B83;
	const GLenum   GL_INFO_LOG_LENGTH                                            = 0x8B84;
	const GLenum   GL_ATTACHED_SHADERS                                           = 0x8B85;
	const GLenum   GL_ACTIVE_UNIFORMS                                            = 0x8B86;
	const GLenum   GL_ACTIVE_UNIFORM_MAX_LENGTH                                  = 0x8B87;
	const GLenum   GL_SHADER_SOURCE_LENGTH                                       = 0x8B88;
	const GLenum   GL_ACTIVE_ATTRIBUTES                                          = 0x8B89;
	const GLenum   GL_ACTIVE_ATTRIBUTE_MAX_LENGTH                                = 0x8B8A;
	const GLenum   GL_FRAGMENT_SHADER_DERIVATIVE_HINT                            = 0x8B8B;
	const GLenum   GL_SHADING_LANGUAGE_VERSION                                   = 0x8B8C;
	const GLenum   GL_CURRENT_PROGRAM                                            = 0x8B8D;
	const GLenum   GL_POINT_SPRITE_COORD_ORIGIN                                  = 0x8CA0;
	const GLenum   GL_LOWER_LEFT                                                 = 0x8CA1;
	const GLenum   GL_UPPER_LEFT                                                 = 0x8CA2;
	const GLenum   GL_STENCIL_BACK_REF                                           = 0x8CA3;
	const GLenum   GL_STENCIL_BACK_VALUE_MASK                                    = 0x8CA4;
	const GLenum   GL_STENCIL_BACK_WRITEMASK                                     = 0x8CA5;
	const GLenum   GL_PIXEL_PACK_BUFFER                                          = 0x88EB;
	const GLenum   GL_PIXEL_UNPACK_BUFFER                                        = 0x88EC;
	const GLenum   GL_PIXEL_PACK_BUFFER_BINDING                                  = 0x88ED;
	const GLenum   GL_PIXEL_UNPACK_BUFFER_BINDING                                = 0x88EF;
	const GLenum   GL_FLOAT_MAT2x3                                               = 0x8B65;
	const GLenum   GL_FLOAT_MAT2x4                                               = 0x8B66;
	const GLenum   GL_FLOAT_MAT3x2                                               = 0x8B67;
	const GLenum   GL_FLOAT_MAT3x4                                               = 0x8B68;
	const GLenum   GL_FLOAT_MAT4x2                                               = 0x8B69;
	const GLenum   GL_FLOAT_MAT4x3                                               = 0x8B6A;
	const GLenum   GL_SRGB                                                       = 0x8C40;
	const GLenum   GL_SRGB8                                                      = 0x8C41;
	const GLenum   GL_SRGB_ALPHA                                                 = 0x8C42;
	const GLenum   GL_SRGB8_ALPHA8                                               = 0x8C43;
	const GLenum   GL_COMPRESSED_SRGB                                            = 0x8C48;
	const GLenum   GL_COMPRESSED_SRGB_ALPHA                                      = 0x8C49;
	const GLenum   GL_COMPARE_REF_TO_TEXTURE                                     = 0x884E;
	const GLenum   GL_CLIP_DISTANCE0                                             = 0x3000;
	const GLenum   GL_CLIP_DISTANCE1                                             = 0x3001;
	const GLenum   GL_CLIP_DISTANCE2                                             = 0x3002;
	const GLenum   GL_CLIP_DISTANCE3                                             = 0x3003;
	const GLenum   GL_CLIP_DISTANCE4                                             = 0x3004;
	const GLenum   GL_CLIP_DISTANCE5                                             = 0x3005;
	const GLenum   GL_CLIP_DISTANCE6                                             = 0x3006;
	const GLenum   GL_CLIP_DISTANCE7                                             = 0x3007;
	const GLenum   GL_MAX_CLIP_DISTANCES                                         = 0x0D32;
	const GLenum   GL_MAJOR_VERSION                                              = 0x821B;
	const GLenum   GL_MINOR_VERSION                                              = 0x821C;
	const GLenum   GL_NUM_EXTENSIONS                                             = 0x821D;
	const GLenum   GL_CONTEXT_FLAGS                                              = 0x821E;
	const GLenum   GL_COMPRESSED_RED                                             = 0x8225;
	const GLenum   GL_COMPRESSED_RG                                              = 0x8226;
	const GLenum   GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT                        = 0x0001;
	const GLenum   GL_RGBA32F                                                    = 0x8814;
	const GLenum   GL_RGB32F                                                     = 0x8815;
	const GLenum   GL_RGBA16F                                                    = 0x881A;
	const GLenum   GL_RGB16F                                                     = 0x881B;
	const GLenum   GL_VERTEX_ATTRIB_ARRAY_INTEGER                                = 0x88FD;
	const GLenum   GL_MAX_ARRAY_TEXTURE_LAYERS                                   = 0x88FF;
	const GLenum   GL_MIN_PROGRAM_TEXEL_OFFSET                                   = 0x8904;
	const GLenum   GL_MAX_PROGRAM_TEXEL_OFFSET                                   = 0x8905;
	const GLenum   GL_CLAMP_READ_COLOR                                           = 0x891C;
	const GLenum   GL_FIXED_ONLY                                                 = 0x891D;
	const GLenum   GL_MAX_VARYING_COMPONENTS                                     = 0x8B4B;
	const GLenum   GL_TEXTURE_1D_ARRAY                                           = 0x8C18;
	const GLenum   GL_PROXY_TEXTURE_1D_ARRAY                                     = 0x8C19;
	const GLenum   GL_TEXTURE_2D_ARRAY                                           = 0x8C1A;
	const GLenum   GL_PROXY_TEXTURE_2D_ARRAY                                     = 0x8C1B;
	const GLenum   GL_TEXTURE_BINDING_1D_ARRAY                                   = 0x8C1C;
	const GLenum   GL_TEXTURE_BINDING_2D_ARRAY                                   = 0x8C1D;
	const GLenum   GL_R11F_G11F_B10F                                             = 0x8C3A;
	const GLenum   GL_UNSIGNED_INT_10F_11F_11F_REV                               = 0x8C3B;
	const GLenum   GL_RGB9_E5                                                    = 0x8C3D;
	const GLenum   GL_UNSIGNED_INT_5_9_9_9_REV                                   = 0x8C3E;
	const GLenum   GL_TEXTURE_SHARED_SIZE                                        = 0x8C3F;
	const GLenum   GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH                      = 0x8C76;
	const GLenum   GL_TRANSFORM_FEEDBACK_BUFFER_MODE                             = 0x8C7F;
	const GLenum   GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS                 = 0x8C80;
	const GLenum   GL_TRANSFORM_FEEDBACK_VARYINGS                                = 0x8C83;
	const GLenum   GL_TRANSFORM_FEEDBACK_BUFFER_START                            = 0x8C84;
	const GLenum   GL_TRANSFORM_FEEDBACK_BUFFER_SIZE                             = 0x8C85;
	const GLenum   GL_PRIMITIVES_GENERATED                                       = 0x8C87;
	const GLenum   GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN                      = 0x8C88;
	const GLenum   GL_RASTERIZER_DISCARD                                         = 0x8C89;
	const GLenum   GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS              = 0x8C8A;
	const GLenum   GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS                    = 0x8C8B;
	const GLenum   GL_INTERLEAVED_ATTRIBS                                        = 0x8C8C;
	const GLenum   GL_SEPARATE_ATTRIBS                                           = 0x8C8D;
	const GLenum   GL_TRANSFORM_FEEDBACK_BUFFER                                  = 0x8C8E;
	const GLenum   GL_TRANSFORM_FEEDBACK_BUFFER_BINDING                          = 0x8C8F;
	const GLenum   GL_RGBA32UI                                                   = 0x8D70;
	const GLenum   GL_RGB32UI                                                    = 0x8D71;
	const GLenum   GL_RGBA16UI                                                   = 0x8D76;
	const GLenum   GL_RGB16UI                                                    = 0x8D77;
	const GLenum   GL_RGBA8UI                                                    = 0x8D7C;
	const GLenum   GL_RGB8UI                                                     = 0x8D7D;
	const GLenum   GL_RGBA32I                                                    = 0x8D82;
	const GLenum   GL_RGB32I                                                     = 0x8D83;
	const GLenum   GL_RGBA16I                                                    = 0x8D88;
	const GLenum   GL_RGB16I                                                     = 0x8D89;
	const GLenum   GL_RGBA8I                                                     = 0x8D8E;
	const GLenum   GL_RGB8I                                                      = 0x8D8F;
	const GLenum   GL_RED_INTEGER                                                = 0x8D94;
	const GLenum   GL_GREEN_INTEGER                                              = 0x8D95;
	const GLenum   GL_BLUE_INTEGER                                               = 0x8D96;
	const GLenum   GL_RGB_INTEGER                                                = 0x8D98;
	const GLenum   GL_RGBA_INTEGER                                               = 0x8D99;
	const GLenum   GL_BGR_INTEGER                                                = 0x8D9A;
	const GLenum   GL_BGRA_INTEGER                                               = 0x8D9B;
	const GLenum   GL_SAMPLER_1D_ARRAY                                           = 0x8DC0;
	const GLenum   GL_SAMPLER_2D_ARRAY                                           = 0x8DC1;
	const GLenum   GL_SAMPLER_1D_ARRAY_SHADOW                                    = 0x8DC3;
	const GLenum   GL_SAMPLER_2D_ARRAY_SHADOW                                    = 0x8DC4;
	const GLenum   GL_SAMPLER_CUBE_SHADOW                                        = 0x8DC5;
	const GLenum   GL_UNSIGNED_INT_VEC2                                          = 0x8DC6;
	const GLenum   GL_UNSIGNED_INT_VEC3                                          = 0x8DC7;
	const GLenum   GL_UNSIGNED_INT_VEC4                                          = 0x8DC8;
	const GLenum   GL_INT_SAMPLER_1D                                             = 0x8DC9;
	const GLenum   GL_INT_SAMPLER_2D                                             = 0x8DCA;
	const GLenum   GL_INT_SAMPLER_3D                                             = 0x8DCB;
	const GLenum   GL_INT_SAMPLER_CUBE                                           = 0x8DCC;
	const GLenum   GL_INT_SAMPLER_1D_ARRAY                                       = 0x8DCE;
	const GLenum   GL_INT_SAMPLER_2D_ARRAY                                       = 0x8DCF;
	const GLenum   GL_UNSIGNED_INT_SAMPLER_1D                                    = 0x8DD1;
	const GLenum   GL_UNSIGNED_INT_SAMPLER_2D                                    = 0x8DD2;
	const GLenum   GL_UNSIGNED_INT_SAMPLER_3D                                    = 0x8DD3;
	const GLenum   GL_UNSIGNED_INT_SAMPLER_CUBE                                  = 0x8DD4;
	const GLenum   GL_UNSIGNED_INT_SAMPLER_1D_ARRAY                              = 0x8DD6;
	const GLenum   GL_UNSIGNED_INT_SAMPLER_2D_ARRAY                              = 0x8DD7;
	const GLenum   GL_QUERY_WAIT                                                 = 0x8E13;
	const GLenum   GL_QUERY_NO_WAIT                                              = 0x8E14;
	const GLenum   GL_QUERY_BY_REGION_WAIT                                       = 0x8E15;
	const GLenum   GL_QUERY_BY_REGION_NO_WAIT                                    = 0x8E16;
	const GLenum   GL_BUFFER_ACCESS_FLAGS                                        = 0x911F;
	const GLenum   GL_BUFFER_MAP_LENGTH                                          = 0x9120;
	const GLenum   GL_BUFFER_MAP_OFFSET                                          = 0x9121;
	const GLenum   GL_DEPTH_COMPONENT32F                                         = 0x8CAC;
	const GLenum   GL_DEPTH32F_STENCIL8                                          = 0x8CAD;
	const GLenum   GL_FLOAT_32_UNSIGNED_INT_24_8_REV                             = 0x8DAD;
	const GLenum   GL_INVALID_FRAMEBUFFER_OPERATION                              = 0x0506;
	const GLenum   GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING                      = 0x8210;
	const GLenum   GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE                      = 0x8211;
	const GLenum   GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE                            = 0x8212;
	const GLenum   GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE                          = 0x8213;
	const GLenum   GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE                           = 0x8214;
	const GLenum   GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE                          = 0x8215;
	const GLenum   GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE                          = 0x8216;
	const GLenum   GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE                        = 0x8217;
	const GLenum   GL_FRAMEBUFFER_DEFAULT                                        = 0x8218;
	const GLenum   GL_FRAMEBUFFER_UNDEFINED                                      = 0x8219;
	const GLenum   GL_DEPTH_STENCIL_ATTACHMENT                                   = 0x821A;
	const GLenum   GL_MAX_RENDERBUFFER_SIZE                                      = 0x84E8;
	const GLenum   GL_DEPTH_STENCIL                                              = 0x84F9;
	const GLenum   GL_UNSIGNED_INT_24_8                                          = 0x84FA;
	const GLenum   GL_DEPTH24_STENCIL8                                           = 0x88F0;
	const GLenum   GL_TEXTURE_STENCIL_SIZE                                       = 0x88F1;
	const GLenum   GL_TEXTURE_RED_TYPE                                           = 0x8C10;
	const GLenum   GL_TEXTURE_GREEN_TYPE                                         = 0x8C11;
	const GLenum   GL_TEXTURE_BLUE_TYPE                                          = 0x8C12;
	const GLenum   GL_TEXTURE_ALPHA_TYPE                                         = 0x8C13;
	const GLenum   GL_TEXTURE_DEPTH_TYPE                                         = 0x8C16;
	const GLenum   GL_UNSIGNED_NORMALIZED                                        = 0x8C17;
	const GLenum   GL_FRAMEBUFFER_BINDING                                        = 0x8CA6;
	const GLenum   GL_DRAW_FRAMEBUFFER_BINDING                                   = 0x8CA6;
	const GLenum   GL_RENDERBUFFER_BINDING                                       = 0x8CA7;
	const GLenum   GL_READ_FRAMEBUFFER                                           = 0x8CA8;
	const GLenum   GL_DRAW_FRAMEBUFFER                                           = 0x8CA9;
	const GLenum   GL_READ_FRAMEBUFFER_BINDING                                   = 0x8CAA;
	const GLenum   GL_RENDERBUFFER_SAMPLES                                       = 0x8CAB;
	const GLenum   GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE                         = 0x8CD0;
	const GLenum   GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME                         = 0x8CD1;
	const GLenum   GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL                       = 0x8CD2;
	const GLenum   GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE               = 0x8CD3;
	const GLenum   GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER                       = 0x8CD4;
	const GLenum   GL_FRAMEBUFFER_COMPLETE                                       = 0x8CD5;
	const GLenum   GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT                          = 0x8CD6;
	const GLenum   GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT                  = 0x8CD7;
	const GLenum   GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER                         = 0x8CDB;
	const GLenum   GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER                         = 0x8CDC;
	const GLenum   GL_FRAMEBUFFER_UNSUPPORTED                                    = 0x8CDD;
	const GLenum   GL_MAX_COLOR_ATTACHMENTS                                      = 0x8CDF;
	const GLenum   GL_COLOR_ATTACHMENT0                                          = 0x8CE0;
	const GLenum   GL_COLOR_ATTACHMENT1                                          = 0x8CE1;
	const GLenum   GL_COLOR_ATTACHMENT2                                          = 0x8CE2;
	const GLenum   GL_COLOR_ATTACHMENT3                                          = 0x8CE3;
	const GLenum   GL_COLOR_ATTACHMENT4                                          = 0x8CE4;
	const GLenum   GL_COLOR_ATTACHMENT5                                          = 0x8CE5;
	const GLenum   GL_COLOR_ATTACHMENT6                                          = 0x8CE6;
	const GLenum   GL_COLOR_ATTACHMENT7                                          = 0x8CE7;
	const GLenum   GL_COLOR_ATTACHMENT8                                          = 0x8CE8;
	const GLenum   GL_COLOR_ATTACHMENT9                                          = 0x8CE9;
	const GLenum   GL_COLOR_ATTACHMENT10                                         = 0x8CEA;
	const GLenum   GL_COLOR_ATTACHMENT11                                         = 0x8CEB;
	const GLenum   GL_COLOR_ATTACHMENT12                                         = 0x8CEC;
	const GLenum   GL_COLOR_ATTACHMENT13                                         = 0x8CED;
	const GLenum   GL_COLOR_ATTACHMENT14                                         = 0x8CEE;
	const GLenum   GL_COLOR_ATTACHMENT15                                         = 0x8CEF;
	const GLenum   GL_COLOR_ATTACHMENT16                                         = 0x8CF0;
	const GLenum   GL_COLOR_ATTACHMENT17                                         = 0x8CF1;
	const GLenum   GL_COLOR_ATTACHMENT18                                         = 0x8CF2;
	const GLenum   GL_COLOR_ATTACHMENT19                                         = 0x8CF3;
	const GLenum   GL_COLOR_ATTACHMENT20                                         = 0x8CF4;
	const GLenum   GL_COLOR_ATTACHMENT21                                         = 0x8CF5;
	const GLenum   GL_COLOR_ATTACHMENT22                                         = 0x8CF6;
	const GLenum   GL_COLOR_ATTACHMENT23                                         = 0x8CF7;
	const GLenum   GL_COLOR_ATTACHMENT24                                         = 0x8CF8;
	const GLenum   GL_COLOR_ATTACHMENT25                                         = 0x8CF9;
	const GLenum   GL_COLOR_ATTACHMENT26                                         = 0x8CFA;
	const GLenum   GL_COLOR_ATTACHMENT27                                         = 0x8CFB;
	const GLenum   GL_COLOR_ATTACHMENT28                                         = 0x8CFC;
	const GLenum   GL_COLOR_ATTACHMENT29                                         = 0x8CFD;
	const GLenum   GL_COLOR_ATTACHMENT30                                         = 0x8CFE;
	const GLenum   GL_COLOR_ATTACHMENT31                                         = 0x8CFF;
	const GLenum   GL_DEPTH_ATTACHMENT                                           = 0x8D00;
	const GLenum   GL_STENCIL_ATTACHMENT                                         = 0x8D20;
	const GLenum   GL_FRAMEBUFFER                                                = 0x8D40;
	const GLenum   GL_RENDERBUFFER                                               = 0x8D41;
	const GLenum   GL_RENDERBUFFER_WIDTH                                         = 0x8D42;
	const GLenum   GL_RENDERBUFFER_HEIGHT                                        = 0x8D43;
	const GLenum   GL_RENDERBUFFER_INTERNAL_FORMAT                               = 0x8D44;
	const GLenum   GL_STENCIL_INDEX1                                             = 0x8D46;
	const GLenum   GL_STENCIL_INDEX4                                             = 0x8D47;
	const GLenum   GL_STENCIL_INDEX8                                             = 0x8D48;
	const GLenum   GL_STENCIL_INDEX16                                            = 0x8D49;
	const GLenum   GL_RENDERBUFFER_RED_SIZE                                      = 0x8D50;
	const GLenum   GL_RENDERBUFFER_GREEN_SIZE                                    = 0x8D51;
	const GLenum   GL_RENDERBUFFER_BLUE_SIZE                                     = 0x8D52;
	const GLenum   GL_RENDERBUFFER_ALPHA_SIZE                                    = 0x8D53;
	const GLenum   GL_RENDERBUFFER_DEPTH_SIZE                                    = 0x8D54;
	const GLenum   GL_RENDERBUFFER_STENCIL_SIZE                                  = 0x8D55;
	const GLenum   GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE                         = 0x8D56;
	const GLenum   GL_MAX_SAMPLES                                                = 0x8D57;
	const GLenum   GL_FRAMEBUFFER_SRGB                                           = 0x8DB9;
	const GLenum   GL_HALF_FLOAT                                                 = 0x140B;
	const GLenum   GL_MAP_READ_BIT                                               = 0x0001;
	const GLenum   GL_MAP_WRITE_BIT                                              = 0x0002;
	const GLenum   GL_MAP_INVALIDATE_RANGE_BIT                                   = 0x0004;
	const GLenum   GL_MAP_INVALIDATE_BUFFER_BIT                                  = 0x0008;
	const GLenum   GL_MAP_FLUSH_EXPLICIT_BIT                                     = 0x0010;
	const GLenum   GL_MAP_UNSYNCHRONIZED_BIT                                     = 0x0020;
	const GLenum   GL_COMPRESSED_RED_RGTC1                                       = 0x8DBB;
	const GLenum   GL_COMPRESSED_SIGNED_RED_RGTC1                                = 0x8DBC;
	const GLenum   GL_COMPRESSED_RG_RGTC2                                        = 0x8DBD;
	const GLenum   GL_COMPRESSED_SIGNED_RG_RGTC2                                 = 0x8DBE;
	const GLenum   GL_RG                                                         = 0x8227;
	const GLenum   GL_RG_INTEGER                                                 = 0x8228;
	const GLenum   GL_R8                                                         = 0x8229;
	const GLenum   GL_R16                                                        = 0x822A;
	const GLenum   GL_RG8                                                        = 0x822B;
	const GLenum   GL_RG16                                                       = 0x822C;
	const GLenum   GL_R16F                                                       = 0x822D;
	const GLenum   GL_R32F                                                       = 0x822E;
	const GLenum   GL_RG16F                                                      = 0x822F;
	const GLenum   GL_RG32F                                                      = 0x8230;
	const GLenum   GL_R8I                                                        = 0x8231;
	const GLenum   GL_R8UI                                                       = 0x8232;
	const GLenum   GL_R16I                                                       = 0x8233;
	const GLenum   GL_R16UI                                                      = 0x8234;
	const GLenum   GL_R32I                                                       = 0x8235;
	const GLenum   GL_R32UI                                                      = 0x8236;
	const GLenum   GL_RG8I                                                       = 0x8237;
	const GLenum   GL_RG8UI                                                      = 0x8238;
	const GLenum   GL_RG16I                                                      = 0x8239;
	const GLenum   GL_RG16UI                                                     = 0x823A;
	const GLenum   GL_RG32I                                                      = 0x823B;
	const GLenum   GL_RG32UI                                                     = 0x823C;
	const GLenum   GL_VERTEX_ARRAY_BINDING                                       = 0x85B5;
	const GLenum   GL_SAMPLER_2D_RECT                                            = 0x8B63;
	const GLenum   GL_SAMPLER_2D_RECT_SHADOW                                     = 0x8B64;
	const GLenum   GL_SAMPLER_BUFFER                                             = 0x8DC2;
	const GLenum   GL_INT_SAMPLER_2D_RECT                                        = 0x8DCD;
	const GLenum   GL_INT_SAMPLER_BUFFER                                         = 0x8DD0;
	const GLenum   GL_UNSIGNED_INT_SAMPLER_2D_RECT                               = 0x8DD5;
	const GLenum   GL_UNSIGNED_INT_SAMPLER_BUFFER                                = 0x8DD8;
	const GLenum   GL_TEXTURE_BUFFER                                             = 0x8C2A;
	const GLenum   GL_MAX_TEXTURE_BUFFER_SIZE                                    = 0x8C2B;
	const GLenum   GL_TEXTURE_BINDING_BUFFER                                     = 0x8C2C;
	const GLenum   GL_TEXTURE_BUFFER_DATA_STORE_BINDING                          = 0x8C2D;
	const GLenum   GL_TEXTURE_RECTANGLE                                          = 0x84F5;
	const GLenum   GL_TEXTURE_BINDING_RECTANGLE                                  = 0x84F6;
	const GLenum   GL_PROXY_TEXTURE_RECTANGLE                                    = 0x84F7;
	const GLenum   GL_MAX_RECTANGLE_TEXTURE_SIZE                                 = 0x84F8;
	const GLenum   GL_R8_SNORM                                                   = 0x8F94;
	const GLenum   GL_RG8_SNORM                                                  = 0x8F95;
	const GLenum   GL_RGB8_SNORM                                                 = 0x8F96;
	const GLenum   GL_RGBA8_SNORM                                                = 0x8F97;
	const GLenum   GL_R16_SNORM                                                  = 0x8F98;
	const GLenum   GL_RG16_SNORM                                                 = 0x8F99;
	const GLenum   GL_RGB16_SNORM                                                = 0x8F9A;
	const GLenum   GL_RGBA16_SNORM                                               = 0x8F9B;
	const GLenum   GL_SIGNED_NORMALIZED                                          = 0x8F9C;
	const GLenum   GL_PRIMITIVE_RESTART                                          = 0x8F9D;
	const GLenum   GL_PRIMITIVE_RESTART_INDEX                                    = 0x8F9E;
	const GLenum   GL_COPY_READ_BUFFER                                           = 0x8F36;
	const GLenum   GL_COPY_WRITE_BUFFER                                          = 0x8F37;
	const GLenum   GL_UNIFORM_BUFFER                                             = 0x8A11;
	const GLenum   GL_UNIFORM_BUFFER_BINDING                                     = 0x8A28;
	const GLenum   GL_UNIFORM_BUFFER_START                                       = 0x8A29;
	const GLenum   GL_UNIFORM_BUFFER_SIZE                                        = 0x8A2A;
	const GLenum   GL_MAX_VERTEX_UNIFORM_BLOCKS                                  = 0x8A2B;
	const GLenum   GL_MAX_GEOMETRY_UNIFORM_BLOCKS                                = 0x8A2C;
	const GLenum   GL_MAX_FRAGMENT_UNIFORM_BLOCKS                                = 0x8A2D;
	const GLenum   GL_MAX_COMBINED_UNIFORM_BLOCKS                                = 0x8A2E;
	const GLenum   GL_MAX_UNIFORM_BUFFER_BINDINGS                                = 0x8A2F;
	const GLenum   GL_MAX_UNIFORM_BLOCK_SIZE                                     = 0x8A30;
	const GLenum   GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS                     = 0x8A31;
	const GLenum   GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS                   = 0x8A32;
	const GLenum   GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS                   = 0x8A33;
	const GLenum   GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT                            = 0x8A34;
	const GLenum   GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH                       = 0x8A35;
	const GLenum   GL_ACTIVE_UNIFORM_BLOCKS                                      = 0x8A36;
	const GLenum   GL_UNIFORM_TYPE                                               = 0x8A37;
	const GLenum   GL_UNIFORM_SIZE                                               = 0x8A38;
	const GLenum   GL_UNIFORM_NAME_LENGTH                                        = 0x8A39;
	const GLenum   GL_UNIFORM_BLOCK_INDEX                                        = 0x8A3A;
	const GLenum   GL_UNIFORM_OFFSET                                             = 0x8A3B;
	const GLenum   GL_UNIFORM_ARRAY_STRIDE                                       = 0x8A3C;
	const GLenum   GL_UNIFORM_MATRIX_STRIDE                                      = 0x8A3D;
	const GLenum   GL_UNIFORM_IS_ROW_MAJOR                                       = 0x8A3E;
	const GLenum   GL_UNIFORM_BLOCK_BINDING                                      = 0x8A3F;
	const GLenum   GL_UNIFORM_BLOCK_DATA_SIZE                                    = 0x8A40;
	const GLenum   GL_UNIFORM_BLOCK_NAME_LENGTH                                  = 0x8A41;
	const GLenum   GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS                              = 0x8A42;
	const GLenum   GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES                       = 0x8A43;
	const GLenum   GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER                  = 0x8A44;
	const GLenum   GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER                = 0x8A45;
	const GLenum   GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER                = 0x8A46;
	const GLenum   GL_CONTEXT_CORE_PROFILE_BIT                                   = 0x0001;
	const GLenum   GL_CONTEXT_COMPATIBILITY_PROFILE_BIT                          = 0x0002;
	const GLenum   GL_LINES_ADJACENCY                                            = 0x000A;
	const GLenum   GL_LINE_STRIP_ADJACENCY                                       = 0x000B;
	const GLenum   GL_TRIANGLES_ADJACENCY                                        = 0x000C;
	const GLenum   GL_TRIANGLE_STRIP_ADJACENCY                                   = 0x000D;
	const GLenum   GL_PROGRAM_POINT_SIZE                                         = 0x8642;
	const GLenum   GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS                           = 0x8C29;
	const GLenum   GL_FRAMEBUFFER_ATTACHMENT_LAYERED                             = 0x8DA7;
	const GLenum   GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS                       = 0x8DA8;
	const GLenum   GL_GEOMETRY_SHADER                                            = 0x8DD9;
	const GLenum   GL_GEOMETRY_VERTICES_OUT                                      = 0x8916;
	const GLenum   GL_GEOMETRY_INPUT_TYPE                                        = 0x8917;
	const GLenum   GL_GEOMETRY_OUTPUT_TYPE                                       = 0x8918;
	const GLenum   GL_MAX_GEOMETRY_UNIFORM_COMPONENTS                            = 0x8DDF;
	const GLenum   GL_MAX_GEOMETRY_OUTPUT_VERTICES                               = 0x8DE0;
	const GLenum   GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS                       = 0x8DE1;
	const GLenum   GL_MAX_VERTEX_OUTPUT_COMPONENTS                               = 0x9122;
	const GLenum   GL_MAX_GEOMETRY_INPUT_COMPONENTS                              = 0x9123;
	const GLenum   GL_MAX_GEOMETRY_OUTPUT_COMPONENTS                             = 0x9124;
	const GLenum   GL_MAX_FRAGMENT_INPUT_COMPONENTS                              = 0x9125;
	const GLenum   GL_CONTEXT_PROFILE_MASK                                       = 0x9126;
	const GLenum   GL_DEPTH_CLAMP                                                = 0x864F;
	const GLenum   GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION                   = 0x8E4C;
	const GLenum   GL_FIRST_VERTEX_CONVENTION                                    = 0x8E4D;
	const GLenum   GL_LAST_VERTEX_CONVENTION                                     = 0x8E4E;
	const GLenum   GL_PROVOKING_VERTEX                                           = 0x8E4F;
	const GLenum   GL_TEXTURE_CUBE_MAP_SEAMLESS                                  = 0x884F;
	const GLenum   GL_MAX_SERVER_WAIT_TIMEOUT                                    = 0x9111;
	const GLenum   GL_OBJECT_TYPE                                                = 0x9112;
	const GLenum   GL_SYNC_CONDITION                                             = 0x9113;
	const GLenum   GL_SYNC_STATUS                                                = 0x9114;
	const GLenum   GL_SYNC_FLAGS                                                 = 0x9115;
	const GLenum   GL_SYNC_FENCE                                                 = 0x9116;
	const GLenum   GL_SYNC_GPU_COMMANDS_COMPLETE                                 = 0x9117;
	const GLenum   GL_UNSIGNALED                                                 = 0x9118;
	const GLenum   GL_SIGNALED                                                   = 0x9119;
	const GLenum   GL_ALREADY_SIGNALED                                           = 0x911A;
	const GLenum   GL_TIMEOUT_EXPIRED                                            = 0x911B;
	const GLenum   GL_CONDITION_SATISFIED                                        = 0x911C;
	const GLenum   GL_WAIT_FAILED                                                = 0x911D;
	const GLenum   GL_SYNC_FLUSH_COMMANDS_BIT                                    = 0x0001;
	const GLenum   GL_SAMPLE_POSITION                                            = 0x8E50;
	const GLenum   GL_SAMPLE_MASK                                                = 0x8E51;
	const GLenum   GL_SAMPLE_MASK_VALUE                                          = 0x8E52;
	const GLenum   GL_MAX_SAMPLE_MASK_WORDS                                      = 0x8E59;
	const GLenum   GL_TEXTURE_2D_MULTISAMPLE                                     = 0x9100;
	const GLenum   GL_PROXY_TEXTURE_2D_MULTISAMPLE                               = 0x9101;
	const GLenum   GL_TEXTURE_2D_MULTISAMPLE_ARRAY                               = 0x9102;
	const GLenum   GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY                         = 0x9103;
	const GLenum   GL_TEXTURE_BINDING_2D_MULTISAMPLE                             = 0x9104;
	const GLenum   GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY                       = 0x9105;
	const GLenum   GL_TEXTURE_SAMPLES                                            = 0x9106;
	const GLenum   GL_TEXTURE_FIXED_SAMPLE_LOCATIONS                             = 0x9107;
	const GLenum   GL_SAMPLER_2D_MULTISAMPLE                                     = 0x9108;
	const GLenum   GL_INT_SAMPLER_2D_MULTISAMPLE                                 = 0x9109;
	const GLenum   GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE                        = 0x910A;
	const GLenum   GL_SAMPLER_2D_MULTISAMPLE_ARRAY                               = 0x910B;
	const GLenum   GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY                           = 0x910C;
	const GLenum   GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY                  = 0x910D;
	const GLenum   GL_MAX_COLOR_TEXTURE_SAMPLES                                  = 0x910E;
	const GLenum   GL_MAX_DEPTH_TEXTURE_SAMPLES                                  = 0x910F;
	const GLenum   GL_MAX_INTEGER_SAMPLES                                        = 0x9110;
	const GLenum   GL_VERTEX_ATTRIB_ARRAY_DIVISOR                                = 0x88FE;
	const GLenum   GL_SRC1_COLOR                                                 = 0x88F9;
	const GLenum   GL_ONE_MINUS_SRC1_COLOR                                       = 0x88FA;
	const GLenum   GL_ONE_MINUS_SRC1_ALPHA                                       = 0x88FB;
	const GLenum   GL_MAX_DUAL_SOURCE_DRAW_BUFFERS                               = 0x88FC;
	const GLenum   GL_ANY_SAMPLES_PASSED                                         = 0x8C2F;
	const GLenum   GL_SAMPLER_BINDING                                            = 0x8919;
	const GLenum   GL_RGB10_A2UI                                                 = 0x906F;
	const GLenum   GL_TEXTURE_SWIZZLE_R                                          = 0x8E42;
	const GLenum   GL_TEXTURE_SWIZZLE_G                                          = 0x8E43;
	const GLenum   GL_TEXTURE_SWIZZLE_B                                          = 0x8E44;
	const GLenum   GL_TEXTURE_SWIZZLE_A                                          = 0x8E45;
	const GLenum   GL_TEXTURE_SWIZZLE_RGBA                                       = 0x8E46;
	const GLenum   GL_TIME_ELAPSED                                               = 0x88BF;
	const GLenum   GL_TIMESTAMP                                                  = 0x8E28;
	const GLenum   GL_INT_2_10_10_10_REV                                         = 0x8D9F;
	const GLenum   GL_SAMPLE_SHADING                                             = 0x8C36;
	const GLenum   GL_MIN_SAMPLE_SHADING_VALUE                                   = 0x8C37;
	const GLenum   GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET                          = 0x8E5E;
	const GLenum   GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET                          = 0x8E5F;
	const GLenum   GL_TEXTURE_CUBE_MAP_ARRAY                                     = 0x9009;
	const GLenum   GL_TEXTURE_BINDING_CUBE_MAP_ARRAY                             = 0x900A;
	const GLenum   GL_PROXY_TEXTURE_CUBE_MAP_ARRAY                               = 0x900B;
	const GLenum   GL_SAMPLER_CUBE_MAP_ARRAY                                     = 0x900C;
	const GLenum   GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW                              = 0x900D;
	const GLenum   GL_INT_SAMPLER_CUBE_MAP_ARRAY                                 = 0x900E;
	const GLenum   GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY                        = 0x900F;
	const GLenum   GL_DRAW_INDIRECT_BUFFER                                       = 0x8F3F;
	const GLenum   GL_DRAW_INDIRECT_BUFFER_BINDING                               = 0x8F43;
	const GLenum   GL_GEOMETRY_SHADER_INVOCATIONS                                = 0x887F;
	const GLenum   GL_MAX_GEOMETRY_SHADER_INVOCATIONS                            = 0x8E5A;
	const GLenum   GL_MIN_FRAGMENT_INTERPOLATION_OFFSET                          = 0x8E5B;
	const GLenum   GL_MAX_FRAGMENT_INTERPOLATION_OFFSET                          = 0x8E5C;
	const GLenum   GL_FRAGMENT_INTERPOLATION_OFFSET_BITS                         = 0x8E5D;
	const GLenum   GL_MAX_VERTEX_STREAMS                                         = 0x8E71;
	const GLenum   GL_DOUBLE_VEC2                                                = 0x8FFC;
	const GLenum   GL_DOUBLE_VEC3                                                = 0x8FFD;
	const GLenum   GL_DOUBLE_VEC4                                                = 0x8FFE;
	const GLenum   GL_DOUBLE_MAT2                                                = 0x8F46;
	const GLenum   GL_DOUBLE_MAT3                                                = 0x8F47;
	const GLenum   GL_DOUBLE_MAT4                                                = 0x8F48;
	const GLenum   GL_DOUBLE_MAT2x3                                              = 0x8F49;
	const GLenum   GL_DOUBLE_MAT2x4                                              = 0x8F4A;
	const GLenum   GL_DOUBLE_MAT3x2                                              = 0x8F4B;
	const GLenum   GL_DOUBLE_MAT3x4                                              = 0x8F4C;
	const GLenum   GL_DOUBLE_MAT4x2                                              = 0x8F4D;
	const GLenum   GL_DOUBLE_MAT4x3                                              = 0x8F4E;
	const GLenum   GL_ACTIVE_SUBROUTINES                                         = 0x8DE5;
	const GLenum   GL_ACTIVE_SUBROUTINE_UNIFORMS                                 = 0x8DE6;
	const GLenum   GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS                        = 0x8E47;
	const GLenum   GL_ACTIVE_SUBROUTINE_MAX_LENGTH                               = 0x8E48;
	const GLenum   GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH                       = 0x8E49;
	const GLenum   GL_MAX_SUBROUTINES                                            = 0x8DE7;
	const GLenum   GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS                           = 0x8DE8;
	const GLenum   GL_NUM_COMPATIBLE_SUBROUTINES                                 = 0x8E4A;
	const GLenum   GL_COMPATIBLE_SUBROUTINES                                     = 0x8E4B;
	const GLenum   GL_PATCHES                                                    = 0x000E;
	const GLenum   GL_PATCH_VERTICES                                             = 0x8E72;
	const GLenum   GL_PATCH_DEFAULT_INNER_LEVEL                                  = 0x8E73;
	const GLenum   GL_PATCH_DEFAULT_OUTER_LEVEL                                  = 0x8E74;
	const GLenum   GL_TESS_CONTROL_OUTPUT_VERTICES                               = 0x8E75;
	const GLenum   GL_TESS_GEN_MODE                                              = 0x8E76;
	const GLenum   GL_TESS_GEN_SPACING                                           = 0x8E77;
	const GLenum   GL_TESS_GEN_VERTEX_ORDER                                      = 0x8E78;
	const GLenum   GL_TESS_GEN_POINT_MODE                                        = 0x8E79;
	const GLenum   GL_ISOLINES                                                   = 0x8E7A;
	const GLenum   GL_FRACTIONAL_ODD                                             = 0x8E7B;
	const GLenum   GL_FRACTIONAL_EVEN                                            = 0x8E7C;
	const GLenum   GL_MAX_PATCH_VERTICES                                         = 0x8E7D;
	const GLenum   GL_MAX_TESS_GEN_LEVEL                                         = 0x8E7E;
	const GLenum   GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS                        = 0x8E7F;
	const GLenum   GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS                     = 0x8E80;
	const GLenum   GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS                       = 0x8E81;
	const GLenum   GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS                    = 0x8E82;
	const GLenum   GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS                         = 0x8E83;
	const GLenum   GL_MAX_TESS_PATCH_COMPONENTS                                  = 0x8E84;
	const GLenum   GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS                   = 0x8E85;
	const GLenum   GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS                      = 0x8E86;
	const GLenum   GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS                            = 0x8E89;
	const GLenum   GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS                         = 0x8E8A;
	const GLenum   GL_MAX_TESS_CONTROL_INPUT_COMPONENTS                          = 0x886C;
	const GLenum   GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS                       = 0x886D;
	const GLenum   GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS               = 0x8E1E;
	const GLenum   GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS            = 0x8E1F;
	const GLenum   GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER            = 0x84F0;
	const GLenum   GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER         = 0x84F1;
	const GLenum   GL_TESS_EVALUATION_SHADER                                     = 0x8E87;
	const GLenum   GL_TESS_CONTROL_SHADER                                        = 0x8E88;
	const GLenum   GL_TRANSFORM_FEEDBACK                                         = 0x8E22;
	const GLenum   GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED                           = 0x8E23;
	const GLenum   GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE                           = 0x8E24;
	const GLenum   GL_TRANSFORM_FEEDBACK_BINDING                                 = 0x8E25;
	const GLenum   GL_MAX_TRANSFORM_FEEDBACK_BUFFERS                             = 0x8E70;
	const GLenum   GL_FIXED                                                      = 0x140C;
	const GLenum   GL_IMPLEMENTATION_COLOR_READ_TYPE                             = 0x8B9A;
	const GLenum   GL_IMPLEMENTATION_COLOR_READ_FORMAT                           = 0x8B9B;
	const GLenum   GL_LOW_FLOAT                                                  = 0x8DF0;
	const GLenum   GL_MEDIUM_FLOAT                                               = 0x8DF1;
	const GLenum   GL_HIGH_FLOAT                                                 = 0x8DF2;
	const GLenum   GL_LOW_INT                                                    = 0x8DF3;
	const GLenum   GL_MEDIUM_INT                                                 = 0x8DF4;
	const GLenum   GL_HIGH_INT                                                   = 0x8DF5;
	const GLenum   GL_SHADER_COMPILER                                            = 0x8DFA;
	const GLenum   GL_SHADER_BINARY_FORMATS                                      = 0x8DF8;
	const GLenum   GL_NUM_SHADER_BINARY_FORMATS                                  = 0x8DF9;
	const GLenum   GL_MAX_VERTEX_UNIFORM_VECTORS                                 = 0x8DFB;
	const GLenum   GL_MAX_VARYING_VECTORS                                        = 0x8DFC;
	const GLenum   GL_MAX_FRAGMENT_UNIFORM_VECTORS                               = 0x8DFD;
	const GLenum   GL_RGB565                                                     = 0x8D62;
	const GLenum   GL_PROGRAM_BINARY_RETRIEVABLE_HINT                            = 0x8257;
	const GLenum   GL_PROGRAM_BINARY_LENGTH                                      = 0x8741;
	const GLenum   GL_NUM_PROGRAM_BINARY_FORMATS                                 = 0x87FE;
	const GLenum   GL_PROGRAM_BINARY_FORMATS                                     = 0x87FF;
	const GLenum   GL_VERTEX_SHADER_BIT                                          = 0x0001;
	const GLenum   GL_FRAGMENT_SHADER_BIT                                        = 0x0002;
	const GLenum   GL_GEOMETRY_SHADER_BIT                                        = 0x0004;
	const GLenum   GL_TESS_CONTROL_SHADER_BIT                                    = 0x0008;
	const GLenum   GL_TESS_EVALUATION_SHADER_BIT                                 = 0x0010;
	const GLenum   GL_PROGRAM_SEPARABLE                                          = 0x8258;
	const GLenum   GL_ACTIVE_PROGRAM                                             = 0x8259;
	const GLenum   GL_PROGRAM_PIPELINE_BINDING                                   = 0x825A;
	const GLenum   GL_MAX_VIEWPORTS                                              = 0x825B;
	const GLenum   GL_VIEWPORT_SUBPIXEL_BITS                                     = 0x825C;
	const GLenum   GL_VIEWPORT_BOUNDS_RANGE                                      = 0x825D;
	const GLenum   GL_LAYER_PROVOKING_VERTEX                                     = 0x825E;
	const GLenum   GL_VIEWPORT_INDEX_PROVOKING_VERTEX                            = 0x825F;
	const GLenum   GL_UNDEFINED_VERTEX                                           = 0x8260;
	const GLenum   GL_COPY_READ_BUFFER_BINDING                                   = 0x8F36;
	const GLenum   GL_COPY_WRITE_BUFFER_BINDING                                  = 0x8F37;
	const GLenum   GL_TRANSFORM_FEEDBACK_ACTIVE                                  = 0x8E24;
	const GLenum   GL_TRANSFORM_FEEDBACK_PAUSED                                  = 0x8E23;
	const GLenum   GL_UNPACK_COMPRESSED_BLOCK_WIDTH                              = 0x9127;
	const GLenum   GL_UNPACK_COMPRESSED_BLOCK_HEIGHT                             = 0x9128;
	const GLenum   GL_UNPACK_COMPRESSED_BLOCK_DEPTH                              = 0x9129;
	const GLenum   GL_UNPACK_COMPRESSED_BLOCK_SIZE                               = 0x912A;
	const GLenum   GL_PACK_COMPRESSED_BLOCK_WIDTH                                = 0x912B;
	const GLenum   GL_PACK_COMPRESSED_BLOCK_HEIGHT                               = 0x912C;
	const GLenum   GL_PACK_COMPRESSED_BLOCK_DEPTH                                = 0x912D;
	const GLenum   GL_PACK_COMPRESSED_BLOCK_SIZE                                 = 0x912E;
	const GLenum   GL_NUM_SAMPLE_COUNTS                                          = 0x9380;
	const GLenum   GL_MIN_MAP_BUFFER_ALIGNMENT                                   = 0x90BC;
	const GLenum   GL_ATOMIC_COUNTER_BUFFER                                      = 0x92C0;
	const GLenum   GL_ATOMIC_COUNTER_BUFFER_BINDING                              = 0x92C1;
	const GLenum   GL_ATOMIC_COUNTER_BUFFER_START                                = 0x92C2;
	const GLenum   GL_ATOMIC_COUNTER_BUFFER_SIZE                                 = 0x92C3;
	const GLenum   GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE                            = 0x92C4;
	const GLenum   GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS               = 0x92C5;
	const GLenum   GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES        = 0x92C6;
	const GLenum   GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER          = 0x92C7;
	const GLenum   GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER    = 0x92C8;
	const GLenum   GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x92C9;
	const GLenum   GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER        = 0x92CA;
	const GLenum   GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER        = 0x92CB;
	const GLenum   GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS                          = 0x92CC;
	const GLenum   GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS                    = 0x92CD;
	const GLenum   GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS                 = 0x92CE;
	const GLenum   GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS                        = 0x92CF;
	const GLenum   GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS                        = 0x92D0;
	const GLenum   GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS                        = 0x92D1;
	const GLenum   GL_MAX_VERTEX_ATOMIC_COUNTERS                                 = 0x92D2;
	const GLenum   GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS                           = 0x92D3;
	const GLenum   GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS                        = 0x92D4;
	const GLenum   GL_MAX_GEOMETRY_ATOMIC_COUNTERS                               = 0x92D5;
	const GLenum   GL_MAX_FRAGMENT_ATOMIC_COUNTERS                               = 0x92D6;
	const GLenum   GL_MAX_COMBINED_ATOMIC_COUNTERS                               = 0x92D7;
	const GLenum   GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE                             = 0x92D8;
	const GLenum   GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS                         = 0x92DC;
	const GLenum   GL_ACTIVE_ATOMIC_COUNTER_BUFFERS                              = 0x92D9;
	const GLenum   GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX                        = 0x92DA;
	const GLenum   GL_UNSIGNED_INT_ATOMIC_COUNTER                                = 0x92DB;
	const GLenum   GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT                            = 0x0001;
	const GLenum   GL_ELEMENT_ARRAY_BARRIER_BIT                                  = 0x0002;
	const GLenum   GL_UNIFORM_BARRIER_BIT                                        = 0x0004;
	const GLenum   GL_TEXTURE_FETCH_BARRIER_BIT                                  = 0x0008;
	const GLenum   GL_SHADER_IMAGE_ACCESS_BARRIER_BIT                            = 0x0020;
	const GLenum   GL_COMMAND_BARRIER_BIT                                        = 0x0040;
	const GLenum   GL_PIXEL_BUFFER_BARRIER_BIT                                   = 0x0080;
	const GLenum   GL_TEXTURE_UPDATE_BARRIER_BIT                                 = 0x0100;
	const GLenum   GL_BUFFER_UPDATE_BARRIER_BIT                                  = 0x0200;
	const GLenum   GL_FRAMEBUFFER_BARRIER_BIT                                    = 0x0400;
	const GLenum   GL_TRANSFORM_FEEDBACK_BARRIER_BIT                             = 0x0800;
	const GLenum   GL_ATOMIC_COUNTER_BARRIER_BIT                                 = 0x1000;
	const GLenum   GL_MAX_IMAGE_UNITS                                            = 0x8F38;
	const GLenum   GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS              = 0x8F39;
	const GLenum   GL_IMAGE_BINDING_NAME                                         = 0x8F3A;
	const GLenum   GL_IMAGE_BINDING_LEVEL                                        = 0x8F3B;
	const GLenum   GL_IMAGE_BINDING_LAYERED                                      = 0x8F3C;
	const GLenum   GL_IMAGE_BINDING_LAYER                                        = 0x8F3D;
	const GLenum   GL_IMAGE_BINDING_ACCESS                                       = 0x8F3E;
	const GLenum   GL_IMAGE_1D                                                   = 0x904C;
	const GLenum   GL_IMAGE_2D                                                   = 0x904D;
	const GLenum   GL_IMAGE_3D                                                   = 0x904E;
	const GLenum   GL_IMAGE_2D_RECT                                              = 0x904F;
	const GLenum   GL_IMAGE_CUBE                                                 = 0x9050;
	const GLenum   GL_IMAGE_BUFFER                                               = 0x9051;
	const GLenum   GL_IMAGE_1D_ARRAY                                             = 0x9052;
	const GLenum   GL_IMAGE_2D_ARRAY                                             = 0x9053;
	const GLenum   GL_IMAGE_CUBE_MAP_ARRAY                                       = 0x9054;
	const GLenum   GL_IMAGE_2D_MULTISAMPLE                                       = 0x9055;
	const GLenum   GL_IMAGE_2D_MULTISAMPLE_ARRAY                                 = 0x9056;
	const GLenum   GL_INT_IMAGE_1D                                               = 0x9057;
	const GLenum   GL_INT_IMAGE_2D                                               = 0x9058;
	const GLenum   GL_INT_IMAGE_3D                                               = 0x9059;
	const GLenum   GL_INT_IMAGE_2D_RECT                                          = 0x905A;
	const GLenum   GL_INT_IMAGE_CUBE                                             = 0x905B;
	const GLenum   GL_INT_IMAGE_BUFFER                                           = 0x905C;
	const GLenum   GL_INT_IMAGE_1D_ARRAY                                         = 0x905D;
	const GLenum   GL_INT_IMAGE_2D_ARRAY                                         = 0x905E;
	const GLenum   GL_INT_IMAGE_CUBE_MAP_ARRAY                                   = 0x905F;
	const GLenum   GL_INT_IMAGE_2D_MULTISAMPLE                                   = 0x9060;
	const GLenum   GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY                             = 0x9061;
	const GLenum   GL_UNSIGNED_INT_IMAGE_1D                                      = 0x9062;
	const GLenum   GL_UNSIGNED_INT_IMAGE_2D                                      = 0x9063;
	const GLenum   GL_UNSIGNED_INT_IMAGE_3D                                      = 0x9064;
	const GLenum   GL_UNSIGNED_INT_IMAGE_2D_RECT                                 = 0x9065;
	const GLenum   GL_UNSIGNED_INT_IMAGE_CUBE                                    = 0x9066;
	const GLenum   GL_UNSIGNED_INT_IMAGE_BUFFER                                  = 0x9067;
	const GLenum   GL_UNSIGNED_INT_IMAGE_1D_ARRAY                                = 0x9068;
	const GLenum   GL_UNSIGNED_INT_IMAGE_2D_ARRAY                                = 0x9069;
	const GLenum   GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY                          = 0x906A;
	const GLenum   GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE                          = 0x906B;
	const GLenum   GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY                    = 0x906C;
	const GLenum   GL_MAX_IMAGE_SAMPLES                                          = 0x906D;
	const GLenum   GL_IMAGE_BINDING_FORMAT                                       = 0x906E;
	const GLenum   GL_IMAGE_FORMAT_COMPATIBILITY_TYPE                            = 0x90C7;
	const GLenum   GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE                         = 0x90C8;
	const GLenum   GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS                        = 0x90C9;
	const GLenum   GL_MAX_VERTEX_IMAGE_UNIFORMS                                  = 0x90CA;
	const GLenum   GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS                            = 0x90CB;
	const GLenum   GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS                         = 0x90CC;
	const GLenum   GL_MAX_GEOMETRY_IMAGE_UNIFORMS                                = 0x90CD;
	const GLenum   GL_MAX_FRAGMENT_IMAGE_UNIFORMS                                = 0x90CE;
	const GLenum   GL_MAX_COMBINED_IMAGE_UNIFORMS                                = 0x90CF;
	const GLenum   GL_COMPRESSED_RGBA_BPTC_UNORM                                 = 0x8E8C;
	const GLenum   GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM                           = 0x8E8D;
	const GLenum   GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT                           = 0x8E8E;
	const GLenum   GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT                         = 0x8E8F;
	const GLenum   GL_TEXTURE_IMMUTABLE_FORMAT                                   = 0x912F;
	const GLenum   GL_NUM_SHADING_LANGUAGE_VERSIONS                              = 0x82E9;
	const GLenum   GL_VERTEX_ATTRIB_ARRAY_LONG                                   = 0x874E;
	const GLenum   GL_COMPRESSED_RGB8_ETC2                                       = 0x9274;
	const GLenum   GL_COMPRESSED_SRGB8_ETC2                                      = 0x9275;
	const GLenum   GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2                   = 0x9276;
	const GLenum   GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2                  = 0x9277;
	const GLenum   GL_COMPRESSED_RGBA8_ETC2_EAC                                  = 0x9278;
	const GLenum   GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC                           = 0x9279;
	const GLenum   GL_COMPRESSED_R11_EAC                                         = 0x9270;
	const GLenum   GL_COMPRESSED_SIGNED_R11_EAC                                  = 0x9271;
	const GLenum   GL_COMPRESSED_RG11_EAC                                        = 0x9272;
	const GLenum   GL_COMPRESSED_SIGNED_RG11_EAC                                 = 0x9273;
	const GLenum   GL_PRIMITIVE_RESTART_FIXED_INDEX                              = 0x8D69;
	const GLenum   GL_ANY_SAMPLES_PASSED_CONSERVATIVE                            = 0x8D6A;
	const GLenum   GL_MAX_ELEMENT_INDEX                                          = 0x8D6B;
	const GLenum   GL_COMPUTE_SHADER                                             = 0x91B9;
	const GLenum   GL_MAX_COMPUTE_UNIFORM_BLOCKS                                 = 0x91BB;
	const GLenum   GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS                            = 0x91BC;
	const GLenum   GL_MAX_COMPUTE_IMAGE_UNIFORMS                                 = 0x91BD;
	const GLenum   GL_MAX_COMPUTE_SHARED_MEMORY_SIZE                             = 0x8262;
	const GLenum   GL_MAX_COMPUTE_UNIFORM_COMPONENTS                             = 0x8263;
	const GLenum   GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS                         = 0x8264;
	const GLenum   GL_MAX_COMPUTE_ATOMIC_COUNTERS                                = 0x8265;
	const GLenum   GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS                    = 0x8266;
	const GLenum   GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS                         = 0x90EB;
	const GLenum   GL_MAX_COMPUTE_WORK_GROUP_COUNT                               = 0x91BE;
	const GLenum   GL_MAX_COMPUTE_WORK_GROUP_SIZE                                = 0x91BF;
	const GLenum   GL_COMPUTE_WORK_GROUP_SIZE                                    = 0x8267;
	const GLenum   GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER                 = 0x90EC;
	const GLenum   GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER         = 0x90ED;
	const GLenum   GL_DISPATCH_INDIRECT_BUFFER                                   = 0x90EE;
	const GLenum   GL_DISPATCH_INDIRECT_BUFFER_BINDING                           = 0x90EF;
	const GLenum   GL_COMPUTE_SHADER_BIT                                         = 0x0020;
	const GLenum   GL_DEBUG_OUTPUT_SYNCHRONOUS                                   = 0x8242;
	const GLenum   GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH                           = 0x8243;
	const GLenum   GL_DEBUG_CALLBACK_FUNCTION                                    = 0x8244;
	const GLenum   GL_DEBUG_CALLBACK_USER_PARAM                                  = 0x8245;
	const GLenum   GL_DEBUG_SOURCE_API                                           = 0x8246;
	const GLenum   GL_DEBUG_SOURCE_WINDOW_SYSTEM                                 = 0x8247;
	const GLenum   GL_DEBUG_SOURCE_SHADER_COMPILER                               = 0x8248;
	const GLenum   GL_DEBUG_SOURCE_THIRD_PARTY                                   = 0x8249;
	const GLenum   GL_DEBUG_SOURCE_APPLICATION                                   = 0x824A;
	const GLenum   GL_DEBUG_SOURCE_OTHER                                         = 0x824B;
	const GLenum   GL_DEBUG_TYPE_ERROR                                           = 0x824C;
	const GLenum   GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR                             = 0x824D;
	const GLenum   GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR                              = 0x824E;
	const GLenum   GL_DEBUG_TYPE_PORTABILITY                                     = 0x824F;
	const GLenum   GL_DEBUG_TYPE_PERFORMANCE                                     = 0x8250;
	const GLenum   GL_DEBUG_TYPE_OTHER                                           = 0x8251;
	const GLenum   GL_MAX_DEBUG_MESSAGE_LENGTH                                   = 0x9143;
	const GLenum   GL_MAX_DEBUG_LOGGED_MESSAGES                                  = 0x9144;
	const GLenum   GL_DEBUG_LOGGED_MESSAGES                                      = 0x9145;
	const GLenum   GL_DEBUG_SEVERITY_HIGH                                        = 0x9146;
	const GLenum   GL_DEBUG_SEVERITY_MEDIUM                                      = 0x9147;
	const GLenum   GL_DEBUG_SEVERITY_LOW                                         = 0x9148;
	const GLenum   GL_DEBUG_TYPE_MARKER                                          = 0x8268;
	const GLenum   GL_DEBUG_TYPE_PUSH_GROUP                                      = 0x8269;
	const GLenum   GL_DEBUG_TYPE_POP_GROUP                                       = 0x826A;
	const GLenum   GL_DEBUG_SEVERITY_NOTIFICATION                                = 0x826B;
	const GLenum   GL_MAX_DEBUG_GROUP_STACK_DEPTH                                = 0x826C;
	const GLenum   GL_DEBUG_GROUP_STACK_DEPTH                                    = 0x826D;
	const GLenum   GL_BUFFER                                                     = 0x82E0;
	const GLenum   GL_SHADER                                                     = 0x82E1;
	const GLenum   GL_PROGRAM                                                    = 0x82E2;
	const GLenum   GL_QUERY                                                      = 0x82E3;
	const GLenum   GL_PROGRAM_PIPELINE                                           = 0x82E4;
	const GLenum   GL_SAMPLER                                                    = 0x82E6;
	const GLenum   GL_MAX_LABEL_LENGTH                                           = 0x82E8;
	const GLenum   GL_DEBUG_OUTPUT                                               = 0x92E0;
	const GLenum   GL_CONTEXT_FLAG_DEBUG_BIT                                     = 0x0002;
	const GLenum   GL_MAX_UNIFORM_LOCATIONS                                      = 0x826E;
	const GLenum   GL_FRAMEBUFFER_DEFAULT_WIDTH                                  = 0x9310;
	const GLenum   GL_FRAMEBUFFER_DEFAULT_HEIGHT                                 = 0x9311;
	const GLenum   GL_FRAMEBUFFER_DEFAULT_LAYERS                                 = 0x9312;
	const GLenum   GL_FRAMEBUFFER_DEFAULT_SAMPLES                                = 0x9313;
	const GLenum   GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS                 = 0x9314;
	const GLenum   GL_MAX_FRAMEBUFFER_WIDTH                                      = 0x9315;
	const GLenum   GL_MAX_FRAMEBUFFER_HEIGHT                                     = 0x9316;
	const GLenum   GL_MAX_FRAMEBUFFER_LAYERS                                     = 0x9317;
	const GLenum   GL_MAX_FRAMEBUFFER_SAMPLES                                    = 0x9318;
	const GLenum   GL_INTERNALFORMAT_SUPPORTED                                   = 0x826F;
	const GLenum   GL_INTERNALFORMAT_PREFERRED                                   = 0x8270;
	const GLenum   GL_INTERNALFORMAT_RED_SIZE                                    = 0x8271;
	const GLenum   GL_INTERNALFORMAT_GREEN_SIZE                                  = 0x8272;
	const GLenum   GL_INTERNALFORMAT_BLUE_SIZE                                   = 0x8273;
	const GLenum   GL_INTERNALFORMAT_ALPHA_SIZE                                  = 0x8274;
	const GLenum   GL_INTERNALFORMAT_DEPTH_SIZE                                  = 0x8275;
	const GLenum   GL_INTERNALFORMAT_STENCIL_SIZE                                = 0x8276;
	const GLenum   GL_INTERNALFORMAT_SHARED_SIZE                                 = 0x8277;
	const GLenum   GL_INTERNALFORMAT_RED_TYPE                                    = 0x8278;
	const GLenum   GL_INTERNALFORMAT_GREEN_TYPE                                  = 0x8279;
	const GLenum   GL_INTERNALFORMAT_BLUE_TYPE                                   = 0x827A;
	const GLenum   GL_INTERNALFORMAT_ALPHA_TYPE                                  = 0x827B;
	const GLenum   GL_INTERNALFORMAT_DEPTH_TYPE                                  = 0x827C;
	const GLenum   GL_INTERNALFORMAT_STENCIL_TYPE                                = 0x827D;
	const GLenum   GL_MAX_WIDTH                                                  = 0x827E;
	const GLenum   GL_MAX_HEIGHT                                                 = 0x827F;
	const GLenum   GL_MAX_DEPTH                                                  = 0x8280;
	const GLenum   GL_MAX_LAYERS                                                 = 0x8281;
	const GLenum   GL_MAX_COMBINED_DIMENSIONS                                    = 0x8282;
	const GLenum   GL_COLOR_COMPONENTS                                           = 0x8283;
	const GLenum   GL_DEPTH_COMPONENTS                                           = 0x8284;
	const GLenum   GL_STENCIL_COMPONENTS                                         = 0x8285;
	const GLenum   GL_COLOR_RENDERABLE                                           = 0x8286;
	const GLenum   GL_DEPTH_RENDERABLE                                           = 0x8287;
	const GLenum   GL_STENCIL_RENDERABLE                                         = 0x8288;
	const GLenum   GL_FRAMEBUFFER_RENDERABLE                                     = 0x8289;
	const GLenum   GL_FRAMEBUFFER_RENDERABLE_LAYERED                             = 0x828A;
	const GLenum   GL_FRAMEBUFFER_BLEND                                          = 0x828B;
	const GLenum   GL_READ_PIXELS                                                = 0x828C;
	const GLenum   GL_READ_PIXELS_FORMAT                                         = 0x828D;
	const GLenum   GL_READ_PIXELS_TYPE                                           = 0x828E;
	const GLenum   GL_TEXTURE_IMAGE_FORMAT                                       = 0x828F;
	const GLenum   GL_TEXTURE_IMAGE_TYPE                                         = 0x8290;
	const GLenum   GL_GET_TEXTURE_IMAGE_FORMAT                                   = 0x8291;
	const GLenum   GL_GET_TEXTURE_IMAGE_TYPE                                     = 0x8292;
	const GLenum   GL_MIPMAP                                                     = 0x8293;
	const GLenum   GL_MANUAL_GENERATE_MIPMAP                                     = 0x8294;
	const GLenum   GL_AUTO_GENERATE_MIPMAP                                       = 0x8295;
	const GLenum   GL_COLOR_ENCODING                                             = 0x8296;
	const GLenum   GL_SRGB_READ                                                  = 0x8297;
	const GLenum   GL_SRGB_WRITE                                                 = 0x8298;
	const GLenum   GL_FILTER                                                     = 0x829A;
	const GLenum   GL_VERTEX_TEXTURE                                             = 0x829B;
	const GLenum   GL_TESS_CONTROL_TEXTURE                                       = 0x829C;
	const GLenum   GL_TESS_EVALUATION_TEXTURE                                    = 0x829D;
	const GLenum   GL_GEOMETRY_TEXTURE                                           = 0x829E;
	const GLenum   GL_FRAGMENT_TEXTURE                                           = 0x829F;
	const GLenum   GL_COMPUTE_TEXTURE                                            = 0x82A0;
	const GLenum   GL_TEXTURE_SHADOW                                             = 0x82A1;
	const GLenum   GL_TEXTURE_GATHER                                             = 0x82A2;
	const GLenum   GL_TEXTURE_GATHER_SHADOW                                      = 0x82A3;
	const GLenum   GL_SHADER_IMAGE_LOAD                                          = 0x82A4;
	const GLenum   GL_SHADER_IMAGE_STORE                                         = 0x82A5;
	const GLenum   GL_SHADER_IMAGE_ATOMIC                                        = 0x82A6;
	const GLenum   GL_IMAGE_TEXEL_SIZE                                           = 0x82A7;
	const GLenum   GL_IMAGE_COMPATIBILITY_CLASS                                  = 0x82A8;
	const GLenum   GL_IMAGE_PIXEL_FORMAT                                         = 0x82A9;
	const GLenum   GL_IMAGE_PIXEL_TYPE                                           = 0x82AA;
	const GLenum   GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST                        = 0x82AC;
	const GLenum   GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST                      = 0x82AD;
	const GLenum   GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE                       = 0x82AE;
	const GLenum   GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE                     = 0x82AF;
	const GLenum   GL_TEXTURE_COMPRESSED_BLOCK_WIDTH                             = 0x82B1;
	const GLenum   GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT                            = 0x82B2;
	const GLenum   GL_TEXTURE_COMPRESSED_BLOCK_SIZE                              = 0x82B3;
	const GLenum   GL_CLEAR_BUFFER                                               = 0x82B4;
	const GLenum   GL_TEXTURE_VIEW                                               = 0x82B5;
	const GLenum   GL_VIEW_COMPATIBILITY_CLASS                                   = 0x82B6;
	const GLenum   GL_FULL_SUPPORT                                               = 0x82B7;
	const GLenum   GL_CAVEAT_SUPPORT                                             = 0x82B8;
	const GLenum   GL_IMAGE_CLASS_4_X_32                                         = 0x82B9;
	const GLenum   GL_IMAGE_CLASS_2_X_32                                         = 0x82BA;
	const GLenum   GL_IMAGE_CLASS_1_X_32                                         = 0x82BB;
	const GLenum   GL_IMAGE_CLASS_4_X_16                                         = 0x82BC;
	const GLenum   GL_IMAGE_CLASS_2_X_16                                         = 0x82BD;
	const GLenum   GL_IMAGE_CLASS_1_X_16                                         = 0x82BE;
	const GLenum   GL_IMAGE_CLASS_4_X_8                                          = 0x82BF;
	const GLenum   GL_IMAGE_CLASS_2_X_8                                          = 0x82C0;
	const GLenum   GL_IMAGE_CLASS_1_X_8                                          = 0x82C1;
	const GLenum   GL_IMAGE_CLASS_11_11_10                                       = 0x82C2;
	const GLenum   GL_IMAGE_CLASS_10_10_10_2                                     = 0x82C3;
	const GLenum   GL_VIEW_CLASS_128_BITS                                        = 0x82C4;
	const GLenum   GL_VIEW_CLASS_96_BITS                                         = 0x82C5;
	const GLenum   GL_VIEW_CLASS_64_BITS                                         = 0x82C6;
	const GLenum   GL_VIEW_CLASS_48_BITS                                         = 0x82C7;
	const GLenum   GL_VIEW_CLASS_32_BITS                                         = 0x82C8;
	const GLenum   GL_VIEW_CLASS_24_BITS                                         = 0x82C9;
	const GLenum   GL_VIEW_CLASS_16_BITS                                         = 0x82CA;
	const GLenum   GL_VIEW_CLASS_8_BITS                                          = 0x82CB;
	const GLenum   GL_VIEW_CLASS_S3TC_DXT1_RGB                                   = 0x82CC;
	const GLenum   GL_VIEW_CLASS_S3TC_DXT1_RGBA                                  = 0x82CD;
	const GLenum   GL_VIEW_CLASS_S3TC_DXT3_RGBA                                  = 0x82CE;
	const GLenum   GL_VIEW_CLASS_S3TC_DXT5_RGBA                                  = 0x82CF;
	const GLenum   GL_VIEW_CLASS_RGTC1_RED                                       = 0x82D0;
	const GLenum   GL_VIEW_CLASS_RGTC2_RG                                        = 0x82D1;
	const GLenum   GL_VIEW_CLASS_BPTC_UNORM                                      = 0x82D2;
	const GLenum   GL_VIEW_CLASS_BPTC_FLOAT                                      = 0x82D3;
	const GLenum   GL_UNIFORM                                                    = 0x92E1;
	const GLenum   GL_UNIFORM_BLOCK                                              = 0x92E2;
	const GLenum   GL_PROGRAM_INPUT                                              = 0x92E3;
	const GLenum   GL_PROGRAM_OUTPUT                                             = 0x92E4;
	const GLenum   GL_BUFFER_VARIABLE                                            = 0x92E5;
	const GLenum   GL_SHADER_STORAGE_BLOCK                                       = 0x92E6;
	const GLenum   GL_VERTEX_SUBROUTINE                                          = 0x92E8;
	const GLenum   GL_TESS_CONTROL_SUBROUTINE                                    = 0x92E9;
	const GLenum   GL_TESS_EVALUATION_SUBROUTINE                                 = 0x92EA;
	const GLenum   GL_GEOMETRY_SUBROUTINE                                        = 0x92EB;
	const GLenum   GL_FRAGMENT_SUBROUTINE                                        = 0x92EC;
	const GLenum   GL_COMPUTE_SUBROUTINE                                         = 0x92ED;
	const GLenum   GL_VERTEX_SUBROUTINE_UNIFORM                                  = 0x92EE;
	const GLenum   GL_TESS_CONTROL_SUBROUTINE_UNIFORM                            = 0x92EF;
	const GLenum   GL_TESS_EVALUATION_SUBROUTINE_UNIFORM                         = 0x92F0;
	const GLenum   GL_GEOMETRY_SUBROUTINE_UNIFORM                                = 0x92F1;
	const GLenum   GL_FRAGMENT_SUBROUTINE_UNIFORM                                = 0x92F2;
	const GLenum   GL_COMPUTE_SUBROUTINE_UNIFORM                                 = 0x92F3;
	const GLenum   GL_TRANSFORM_FEEDBACK_VARYING                                 = 0x92F4;
	const GLenum   GL_ACTIVE_RESOURCES                                           = 0x92F5;
	const GLenum   GL_MAX_NAME_LENGTH                                            = 0x92F6;
	const GLenum   GL_MAX_NUM_ACTIVE_VARIABLES                                   = 0x92F7;
	const GLenum   GL_MAX_NUM_COMPATIBLE_SUBROUTINES                             = 0x92F8;
	const GLenum   GL_NAME_LENGTH                                                = 0x92F9;
	const GLenum   GL_TYPE                                                       = 0x92FA;
	const GLenum   GL_ARRAY_SIZE                                                 = 0x92FB;
	const GLenum   GL_OFFSET                                                     = 0x92FC;
	const GLenum   GL_BLOCK_INDEX                                                = 0x92FD;
	const GLenum   GL_ARRAY_STRIDE                                               = 0x92FE;
	const GLenum   GL_MATRIX_STRIDE                                              = 0x92FF;
	const GLenum   GL_IS_ROW_MAJOR                                               = 0x9300;
	const GLenum   GL_ATOMIC_COUNTER_BUFFER_INDEX                                = 0x9301;
	const GLenum   GL_BUFFER_BINDING                                             = 0x9302;
	const GLenum   GL_BUFFER_DATA_SIZE                                           = 0x9303;
	const GLenum   GL_NUM_ACTIVE_VARIABLES                                       = 0x9304;
	const GLenum   GL_ACTIVE_VARIABLES                                           = 0x9305;
	const GLenum   GL_REFERENCED_BY_VERTEX_SHADER                                = 0x9306;
	const GLenum   GL_REFERENCED_BY_TESS_CONTROL_SHADER                          = 0x9307;
	const GLenum   GL_REFERENCED_BY_TESS_EVALUATION_SHADER                       = 0x9308;
	const GLenum   GL_REFERENCED_BY_GEOMETRY_SHADER                              = 0x9309;
	const GLenum   GL_REFERENCED_BY_FRAGMENT_SHADER                              = 0x930A;
	const GLenum   GL_REFERENCED_BY_COMPUTE_SHADER                               = 0x930B;
	const GLenum   GL_TOP_LEVEL_ARRAY_SIZE                                       = 0x930C;
	const GLenum   GL_TOP_LEVEL_ARRAY_STRIDE                                     = 0x930D;
	const GLenum   GL_LOCATION                                                   = 0x930E;
	const GLenum   GL_LOCATION_INDEX                                             = 0x930F;
	const GLenum   GL_IS_PER_PATCH                                               = 0x92E7;
	const GLenum   GL_SHADER_STORAGE_BUFFER                                      = 0x90D2;
	const GLenum   GL_SHADER_STORAGE_BUFFER_BINDING                              = 0x90D3;
	const GLenum   GL_SHADER_STORAGE_BUFFER_START                                = 0x90D4;
	const GLenum   GL_SHADER_STORAGE_BUFFER_SIZE                                 = 0x90D5;
	const GLenum   GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS                           = 0x90D6;
	const GLenum   GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS                         = 0x90D7;
	const GLenum   GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS                     = 0x90D8;
	const GLenum   GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS                  = 0x90D9;
	const GLenum   GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS                         = 0x90DA;
	const GLenum   GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS                          = 0x90DB;
	const GLenum   GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS                         = 0x90DC;
	const GLenum   GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS                         = 0x90DD;
	const GLenum   GL_MAX_SHADER_STORAGE_BLOCK_SIZE                              = 0x90DE;
	const GLenum   GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT                     = 0x90DF;
	const GLenum   GL_SHADER_STORAGE_BARRIER_BIT                                 = 0x2000;
	const GLenum   GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES                       = 0x8F39;
	const GLenum   GL_DEPTH_STENCIL_TEXTURE_MODE                                 = 0x90EA;
	const GLenum   GL_TEXTURE_BUFFER_OFFSET                                      = 0x919D;
	const GLenum   GL_TEXTURE_BUFFER_SIZE                                        = 0x919E;
	const GLenum   GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT                            = 0x919F;
	const GLenum   GL_TEXTURE_VIEW_MIN_LEVEL                                     = 0x82DB;
	const GLenum   GL_TEXTURE_VIEW_NUM_LEVELS                                    = 0x82DC;
	const GLenum   GL_TEXTURE_VIEW_MIN_LAYER                                     = 0x82DD;
	const GLenum   GL_TEXTURE_VIEW_NUM_LAYERS                                    = 0x82DE;
	const GLenum   GL_TEXTURE_IMMUTABLE_LEVELS                                   = 0x82DF;
	const GLenum   GL_VERTEX_ATTRIB_BINDING                                      = 0x82D4;
	const GLenum   GL_VERTEX_ATTRIB_RELATIVE_OFFSET                              = 0x82D5;
	const GLenum   GL_VERTEX_BINDING_DIVISOR                                     = 0x82D6;
	const GLenum   GL_VERTEX_BINDING_OFFSET                                      = 0x82D7;
	const GLenum   GL_VERTEX_BINDING_STRIDE                                      = 0x82D8;
	const GLenum   GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET                          = 0x82D9;
	const GLenum   GL_MAX_VERTEX_ATTRIB_BINDINGS                                 = 0x82DA;
	const GLenum   GL_VERTEX_BINDING_BUFFER                                      = 0x8F4F;
	const GLenum   GL_MAX_VERTEX_ATTRIB_STRIDE                                   = 0x82E5;
	const GLenum   GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED                    = 0x8221;
	const GLenum   GL_TEXTURE_BUFFER_BINDING                                     = 0x8C2A;
	const GLenum   GL_MAP_PERSISTENT_BIT                                         = 0x0040;
	const GLenum   GL_MAP_COHERENT_BIT                                           = 0x0080;
	const GLenum   GL_DYNAMIC_STORAGE_BIT                                        = 0x0100;
	const GLenum   GL_CLIENT_STORAGE_BIT                                         = 0x0200;
	const GLenum   GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT                           = 0x4000;
	const GLenum   GL_BUFFER_IMMUTABLE_STORAGE                                   = 0x821F;
	const GLenum   GL_BUFFER_STORAGE_FLAGS                                       = 0x8220;
	const GLenum   GL_CLEAR_TEXTURE                                              = 0x9365;
	const GLenum   GL_LOCATION_COMPONENT                                         = 0x934A;
	const GLenum   GL_TRANSFORM_FEEDBACK_BUFFER_INDEX                            = 0x934B;
	const GLenum   GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE                           = 0x934C;
	const GLenum   GL_QUERY_BUFFER                                               = 0x9192;
	const GLenum   GL_QUERY_BUFFER_BARRIER_BIT                                   = 0x8000;
	const GLenum   GL_QUERY_BUFFER_BINDING                                       = 0x9193;
	const GLenum   GL_QUERY_RESULT_NO_WAIT                                       = 0x9194;
	const GLenum   GL_MIRROR_CLAMP_TO_EDGE                                       = 0x8743;
	const GLenum   GL_CONTEXT_LOST                                               = 0x0507;
	const GLenum   GL_NEGATIVE_ONE_TO_ONE                                        = 0x935E;
	const GLenum   GL_ZERO_TO_ONE                                                = 0x935F;
	const GLenum   GL_CLIP_ORIGIN                                                = 0x935C;
	const GLenum   GL_CLIP_DEPTH_MODE                                            = 0x935D;
	const GLenum   GL_QUERY_WAIT_INVERTED                                        = 0x8E17;
	const GLenum   GL_QUERY_NO_WAIT_INVERTED                                     = 0x8E18;
	const GLenum   GL_QUERY_BY_REGION_WAIT_INVERTED                              = 0x8E19;
	const GLenum   GL_QUERY_BY_REGION_NO_WAIT_INVERTED                           = 0x8E1A;
	const GLenum   GL_MAX_CULL_DISTANCES                                         = 0x82F9;
	const GLenum   GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES                       = 0x82FA;
	const GLenum   GL_TEXTURE_TARGET                                             = 0x1006;
	const GLenum   GL_QUERY_TARGET                                               = 0x82EA;
	const GLenum   GL_GUILTY_CONTEXT_RESET                                       = 0x8253;
	const GLenum   GL_INNOCENT_CONTEXT_RESET                                     = 0x8254;
	const GLenum   GL_UNKNOWN_CONTEXT_RESET                                      = 0x8255;
	const GLenum   GL_RESET_NOTIFICATION_STRATEGY                                = 0x8256;
	const GLenum   GL_LOSE_CONTEXT_ON_RESET                                      = 0x8252;
	const GLenum   GL_NO_RESET_NOTIFICATION                                      = 0x8261;
	const GLenum   GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT                             = 0x0004;
	const GLenum   GL_CONTEXT_RELEASE_BEHAVIOR                                   = 0x82FB;
	const GLenum   GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH                             = 0x82FC;
	const GLenum   GL_INVALID_INDEX                                              = 0xFFFFFFFF;
	const GLenum   GL_ALL_SHADER_BITS                                            = 0xFFFFFFFF;
	const GLenum   GL_ALL_BARRIER_BITS                                           = 0xFFFFFFFF;
	const GLuint64 GL_TIMEOUT_IGNORED                                            = 0xFFFFFFFFFFFFFFFF;

	typedef GLvoid (GLAPI * PROC_glCullFace)(GLenum mode);
	typedef GLvoid (GLAPI * PROC_glFrontFace)(GLenum mode);
	typedef GLvoid (GLAPI * PROC_glHint)(GLenum target, GLenum mode);
	typedef GLvoid (GLAPI * PROC_glLineWidth)(GLfloat width);
	typedef GLvoid (GLAPI * PROC_glPointSize)(GLfloat size);
	typedef GLvoid (GLAPI * PROC_glPolygonMode)(GLenum face, GLenum mode);
	typedef GLvoid (GLAPI * PROC_glScissor)(GLint x, GLint y, GLsizei width, GLsizei height);
	typedef GLvoid (GLAPI * PROC_glTexParameterf)(GLenum target, GLenum pname, GLfloat param);
	typedef GLvoid (GLAPI * PROC_glTexParameterfv)(GLenum target, GLenum pname, const GLfloat * params);
	typedef GLvoid (GLAPI * PROC_glTexParameteri)(GLenum target, GLenum pname, GLint param);
	typedef GLvoid (GLAPI * PROC_glTexParameteriv)(GLenum target, GLenum pname, const GLint * params);
	typedef GLvoid (GLAPI * PROC_glTexImage1D)(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid * pixels);
	typedef GLvoid (GLAPI * PROC_glTexImage2D)(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid * pixels);
	typedef GLvoid (GLAPI * PROC_glDrawBuffer)(GLenum buf);
	typedef GLvoid (GLAPI * PROC_glClear)(GLbitfield mask);
	typedef GLvoid (GLAPI * PROC_glClearColor)(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
	typedef GLvoid (GLAPI * PROC_glClearStencil)(GLint s);
	typedef GLvoid (GLAPI * PROC_glClearDepth)(GLdouble depth);
	typedef GLvoid (GLAPI * PROC_glStencilMask)(GLuint mask);
	typedef GLvoid (GLAPI * PROC_glColorMask)(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
	typedef GLvoid (GLAPI * PROC_glDepthMask)(GLboolean flag);
	typedef GLvoid (GLAPI * PROC_glDisable)(GLenum cap);
	typedef GLvoid (GLAPI * PROC_glEnable)(GLenum cap);
	typedef GLvoid (GLAPI * PROC_glFinish)();
	typedef GLvoid (GLAPI * PROC_glFlush)();
	typedef GLvoid (GLAPI * PROC_glBlendFunc)(GLenum sfactor, GLenum dfactor);
	typedef GLvoid (GLAPI * PROC_glLogicOp)(GLenum opcode);
	typedef GLvoid (GLAPI * PROC_glStencilFunc)(GLenum func, GLint ref, GLuint mask);
	typedef GLvoid (GLAPI * PROC_glStencilOp)(GLenum fail, GLenum zfail, GLenum zpass);
	typedef GLvoid (GLAPI * PROC_glDepthFunc)(GLenum func);
	typedef GLvoid (GLAPI * PROC_glPixelStoref)(GLenum pname, GLfloat param);
	typedef GLvoid (GLAPI * PROC_glPixelStorei)(GLenum pname, GLint param);
	typedef GLvoid (GLAPI * PROC_glReadBuffer)(GLenum src);
	typedef GLvoid (GLAPI * PROC_glReadPixels)(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid * pixels);
	typedef GLvoid (GLAPI * PROC_glGetBooleanv)(GLenum pname, GLboolean * data);
	typedef GLvoid (GLAPI * PROC_glGetDoublev)(GLenum pname, GLdouble * data);
	typedef GLenum (GLAPI * PROC_glGetError)();
	typedef GLvoid (GLAPI * PROC_glGetFloatv)(GLenum pname, GLfloat * data);
	typedef GLvoid (GLAPI * PROC_glGetIntegerv)(GLenum pname, GLint * data);
	typedef const GLubyte * (GLAPI * PROC_glGetString)(GLenum name);
	typedef GLvoid (GLAPI * PROC_glGetTexImage)(GLenum target, GLint level, GLenum format, GLenum type, GLvoid * pixels);
	typedef GLvoid (GLAPI * PROC_glGetTexParameterfv)(GLenum target, GLenum pname, GLfloat * params);
	typedef GLvoid (GLAPI * PROC_glGetTexParameteriv)(GLenum target, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glGetTexLevelParameterfv)(GLenum target, GLint level, GLenum pname, GLfloat * params);
	typedef GLvoid (GLAPI * PROC_glGetTexLevelParameteriv)(GLenum target, GLint level, GLenum pname, GLint * params);
	typedef GLboolean (GLAPI * PROC_glIsEnabled)(GLenum cap);
	typedef GLvoid (GLAPI * PROC_glDepthRange)(GLdouble near, GLdouble far);
	typedef GLvoid (GLAPI * PROC_glViewport)(GLint x, GLint y, GLsizei width, GLsizei height);
	typedef GLvoid (GLAPI * PROC_glDrawArrays)(GLenum mode, GLint first, GLsizei count);
	typedef GLvoid (GLAPI * PROC_glDrawElements)(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices);
	typedef GLvoid (GLAPI * PROC_glGetPointerv)(GLenum pname, GLvoid ** params);
	typedef GLvoid (GLAPI * PROC_glPolygonOffset)(GLfloat factor, GLfloat units);
	typedef GLvoid (GLAPI * PROC_glCopyTexImage1D)(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border);
	typedef GLvoid (GLAPI * PROC_glCopyTexImage2D)(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
	typedef GLvoid (GLAPI * PROC_glCopyTexSubImage1D)(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
	typedef GLvoid (GLAPI * PROC_glCopyTexSubImage2D)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
	typedef GLvoid (GLAPI * PROC_glTexSubImage1D)(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid * pixels);
	typedef GLvoid (GLAPI * PROC_glTexSubImage2D)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * pixels);
	typedef GLvoid (GLAPI * PROC_glBindTexture)(GLenum target, GLuint texture);
	typedef GLvoid (GLAPI * PROC_glDeleteTextures)(GLsizei n, const GLuint * textures);
	typedef GLvoid (GLAPI * PROC_glGenTextures)(GLsizei n, GLuint * textures);
	typedef GLboolean (GLAPI * PROC_glIsTexture)(GLuint texture);
	typedef GLvoid (GLAPI * PROC_glDrawRangeElements)(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid * indices);
	typedef GLvoid (GLAPI * PROC_glTexImage3D)(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid * pixels);
	typedef GLvoid (GLAPI * PROC_glTexSubImage3D)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid * pixels);
	typedef GLvoid (GLAPI * PROC_glCopyTexSubImage3D)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
	typedef GLvoid (GLAPI * PROC_glActiveTexture)(GLenum texture);
	typedef GLvoid (GLAPI * PROC_glSampleCoverage)(GLfloat value, GLboolean invert);
	typedef GLvoid (GLAPI * PROC_glCompressedTexImage3D)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid * data);
	typedef GLvoid (GLAPI * PROC_glCompressedTexImage2D)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid * data);
	typedef GLvoid (GLAPI * PROC_glCompressedTexImage1D)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid * data);
	typedef GLvoid (GLAPI * PROC_glCompressedTexSubImage3D)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid * data);
	typedef GLvoid (GLAPI * PROC_glCompressedTexSubImage2D)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid * data);
	typedef GLvoid (GLAPI * PROC_glCompressedTexSubImage1D)(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid * data);
	typedef GLvoid (GLAPI * PROC_glGetCompressedTexImage)(GLenum target, GLint level, GLvoid * img);
	typedef GLvoid (GLAPI * PROC_glBlendFuncSeparate)(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha);
	typedef GLvoid (GLAPI * PROC_glMultiDrawArrays)(GLenum mode, const GLint * first, const GLsizei * count, GLsizei drawcount);
	typedef GLvoid (GLAPI * PROC_glMultiDrawElements)(GLenum mode, const GLsizei * count, GLenum type, const GLvoid * const* indices, GLsizei drawcount);
	typedef GLvoid (GLAPI * PROC_glPointParameterf)(GLenum pname, GLfloat param);
	typedef GLvoid (GLAPI * PROC_glPointParameterfv)(GLenum pname, const GLfloat * params);
	typedef GLvoid (GLAPI * PROC_glPointParameteri)(GLenum pname, GLint param);
	typedef GLvoid (GLAPI * PROC_glPointParameteriv)(GLenum pname, const GLint * params);
	typedef GLvoid (GLAPI * PROC_glBlendColor)(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
	typedef GLvoid (GLAPI * PROC_glBlendEquation)(GLenum mode);
	typedef GLvoid (GLAPI * PROC_glGenQueries)(GLsizei n, GLuint * ids);
	typedef GLvoid (GLAPI * PROC_glDeleteQueries)(GLsizei n, const GLuint * ids);
	typedef GLboolean (GLAPI * PROC_glIsQuery)(GLuint id);
	typedef GLvoid (GLAPI * PROC_glBeginQuery)(GLenum target, GLuint id);
	typedef GLvoid (GLAPI * PROC_glEndQuery)(GLenum target);
	typedef GLvoid (GLAPI * PROC_glGetQueryiv)(GLenum target, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glGetQueryObjectiv)(GLuint id, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glGetQueryObjectuiv)(GLuint id, GLenum pname, GLuint * params);
	typedef GLvoid (GLAPI * PROC_glBindBuffer)(GLenum target, GLuint buffer);
	typedef GLvoid (GLAPI * PROC_glDeleteBuffers)(GLsizei n, const GLuint * buffers);
	typedef GLvoid (GLAPI * PROC_glGenBuffers)(GLsizei n, GLuint * buffers);
	typedef GLboolean (GLAPI * PROC_glIsBuffer)(GLuint buffer);
	typedef GLvoid (GLAPI * PROC_glBufferData)(GLenum target, GLsizeiptr size, const GLvoid * data, GLenum usage);
	typedef GLvoid (GLAPI * PROC_glBufferSubData)(GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid * data);
	typedef GLvoid (GLAPI * PROC_glGetBufferSubData)(GLenum target, GLintptr offset, GLsizeiptr size, GLvoid * data);
	typedef GLvoid * (GLAPI * PROC_glMapBuffer)(GLenum target, GLenum access);
	typedef GLboolean (GLAPI * PROC_glUnmapBuffer)(GLenum target);
	typedef GLvoid (GLAPI * PROC_glGetBufferParameteriv)(GLenum target, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glGetBufferPointerv)(GLenum target, GLenum pname, GLvoid ** params);
	typedef GLvoid (GLAPI * PROC_glBlendEquationSeparate)(GLenum modeRGB, GLenum modeAlpha);
	typedef GLvoid (GLAPI * PROC_glDrawBuffers)(GLsizei n, const GLenum * bufs);
	typedef GLvoid (GLAPI * PROC_glStencilOpSeparate)(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass);
	typedef GLvoid (GLAPI * PROC_glStencilFuncSeparate)(GLenum face, GLenum func, GLint ref, GLuint mask);
	typedef GLvoid (GLAPI * PROC_glStencilMaskSeparate)(GLenum face, GLuint mask);
	typedef GLvoid (GLAPI * PROC_glAttachShader)(GLuint program, GLuint shader);
	typedef GLvoid (GLAPI * PROC_glBindAttribLocation)(GLuint program, GLuint index, const GLchar * name);
	typedef GLvoid (GLAPI * PROC_glCompileShader)(GLuint shader);
	typedef GLuint (GLAPI * PROC_glCreateProgram)();
	typedef GLuint (GLAPI * PROC_glCreateShader)(GLenum type);
	typedef GLvoid (GLAPI * PROC_glDeleteProgram)(GLuint program);
	typedef GLvoid (GLAPI * PROC_glDeleteShader)(GLuint shader);
	typedef GLvoid (GLAPI * PROC_glDetachShader)(GLuint program, GLuint shader);
	typedef GLvoid (GLAPI * PROC_glDisableVertexAttribArray)(GLuint index);
	typedef GLvoid (GLAPI * PROC_glEnableVertexAttribArray)(GLuint index);
	typedef GLvoid (GLAPI * PROC_glGetActiveAttrib)(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name);
	typedef GLvoid (GLAPI * PROC_glGetActiveUniform)(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name);
	typedef GLvoid (GLAPI * PROC_glGetAttachedShaders)(GLuint program, GLsizei maxCount, GLsizei * count, GLuint * shaders);
	typedef GLint (GLAPI * PROC_glGetAttribLocation)(GLuint program, const GLchar * name);
	typedef GLvoid (GLAPI * PROC_glGetProgramiv)(GLuint program, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glGetProgramInfoLog)(GLuint program, GLsizei bufSize, GLsizei * length, GLchar * infoLog);
	typedef GLvoid (GLAPI * PROC_glGetShaderiv)(GLuint shader, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glGetShaderInfoLog)(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * infoLog);
	typedef GLvoid (GLAPI * PROC_glGetShaderSource)(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * source);
	typedef GLint (GLAPI * PROC_glGetUniformLocation)(GLuint program, const GLchar * name);
	typedef GLvoid (GLAPI * PROC_glGetUniformfv)(GLuint program, GLint location, GLfloat * params);
	typedef GLvoid (GLAPI * PROC_glGetUniformiv)(GLuint program, GLint location, GLint * params);
	typedef GLvoid (GLAPI * PROC_glGetVertexAttribdv)(GLuint index, GLenum pname, GLdouble * params);
	typedef GLvoid (GLAPI * PROC_glGetVertexAttribfv)(GLuint index, GLenum pname, GLfloat * params);
	typedef GLvoid (GLAPI * PROC_glGetVertexAttribiv)(GLuint index, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glGetVertexAttribPointerv)(GLuint index, GLenum pname, GLvoid ** pointer);
	typedef GLboolean (GLAPI * PROC_glIsProgram)(GLuint program);
	typedef GLboolean (GLAPI * PROC_glIsShader)(GLuint shader);
	typedef GLvoid (GLAPI * PROC_glLinkProgram)(GLuint program);
	typedef GLvoid (GLAPI * PROC_glShaderSource)(GLuint shader, GLsizei count, const GLchar * const* string, const GLint * length);
	typedef GLvoid (GLAPI * PROC_glUseProgram)(GLuint program);
	typedef GLvoid (GLAPI * PROC_glUniform1f)(GLint location, GLfloat v0);
	typedef GLvoid (GLAPI * PROC_glUniform2f)(GLint location, GLfloat v0, GLfloat v1);
	typedef GLvoid (GLAPI * PROC_glUniform3f)(GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
	typedef GLvoid (GLAPI * PROC_glUniform4f)(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
	typedef GLvoid (GLAPI * PROC_glUniform1i)(GLint location, GLint v0);
	typedef GLvoid (GLAPI * PROC_glUniform2i)(GLint location, GLint v0, GLint v1);
	typedef GLvoid (GLAPI * PROC_glUniform3i)(GLint location, GLint v0, GLint v1, GLint v2);
	typedef GLvoid (GLAPI * PROC_glUniform4i)(GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
	typedef GLvoid (GLAPI * PROC_glUniform1fv)(GLint location, GLsizei count, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glUniform2fv)(GLint location, GLsizei count, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glUniform3fv)(GLint location, GLsizei count, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glUniform4fv)(GLint location, GLsizei count, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glUniform1iv)(GLint location, GLsizei count, const GLint * value);
	typedef GLvoid (GLAPI * PROC_glUniform2iv)(GLint location, GLsizei count, const GLint * value);
	typedef GLvoid (GLAPI * PROC_glUniform3iv)(GLint location, GLsizei count, const GLint * value);
	typedef GLvoid (GLAPI * PROC_glUniform4iv)(GLint location, GLsizei count, const GLint * value);
	typedef GLvoid (GLAPI * PROC_glUniformMatrix2fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glUniformMatrix3fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glUniformMatrix4fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glValidateProgram)(GLuint program);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib1d)(GLuint index, GLdouble x);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib1dv)(GLuint index, const GLdouble * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib1f)(GLuint index, GLfloat x);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib1fv)(GLuint index, const GLfloat * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib1s)(GLuint index, GLshort x);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib1sv)(GLuint index, const GLshort * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib2d)(GLuint index, GLdouble x, GLdouble y);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib2dv)(GLuint index, const GLdouble * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib2f)(GLuint index, GLfloat x, GLfloat y);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib2fv)(GLuint index, const GLfloat * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib2s)(GLuint index, GLshort x, GLshort y);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib2sv)(GLuint index, const GLshort * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib3d)(GLuint index, GLdouble x, GLdouble y, GLdouble z);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib3dv)(GLuint index, const GLdouble * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib3f)(GLuint index, GLfloat x, GLfloat y, GLfloat z);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib3fv)(GLuint index, const GLfloat * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib3s)(GLuint index, GLshort x, GLshort y, GLshort z);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib3sv)(GLuint index, const GLshort * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib4Nbv)(GLuint index, const GLbyte * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib4Niv)(GLuint index, const GLint * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib4Nsv)(GLuint index, const GLshort * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib4Nub)(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib4Nubv)(GLuint index, const GLubyte * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib4Nuiv)(GLuint index, const GLuint * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib4Nusv)(GLuint index, const GLushort * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib4bv)(GLuint index, const GLbyte * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib4d)(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib4dv)(GLuint index, const GLdouble * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib4f)(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib4fv)(GLuint index, const GLfloat * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib4iv)(GLuint index, const GLint * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib4s)(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib4sv)(GLuint index, const GLshort * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib4ubv)(GLuint index, const GLubyte * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib4uiv)(GLuint index, const GLuint * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttrib4usv)(GLuint index, const GLushort * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttribPointer)(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid * pointer);
	typedef GLvoid (GLAPI * PROC_glUniformMatrix2x3fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glUniformMatrix3x2fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glUniformMatrix2x4fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glUniformMatrix4x2fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glUniformMatrix3x4fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glUniformMatrix4x3fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glColorMaski)(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a);
	typedef GLvoid (GLAPI * PROC_glGetBooleani_v)(GLenum target, GLuint index, GLboolean * data);
	typedef GLvoid (GLAPI * PROC_glGetIntegeri_v)(GLenum target, GLuint index, GLint * data);
	typedef GLvoid (GLAPI * PROC_glEnablei)(GLenum target, GLuint index);
	typedef GLvoid (GLAPI * PROC_glDisablei)(GLenum target, GLuint index);
	typedef GLboolean (GLAPI * PROC_glIsEnabledi)(GLenum target, GLuint index);
	typedef GLvoid (GLAPI * PROC_glBeginTransformFeedback)(GLenum primitiveMode);
	typedef GLvoid (GLAPI * PROC_glEndTransformFeedback)();
	typedef GLvoid (GLAPI * PROC_glBindBufferRange)(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size);
	typedef GLvoid (GLAPI * PROC_glBindBufferBase)(GLenum target, GLuint index, GLuint buffer);
	typedef GLvoid (GLAPI * PROC_glTransformFeedbackVaryings)(GLuint program, GLsizei count, const GLchar * const* varyings, GLenum bufferMode);
	typedef GLvoid (GLAPI * PROC_glGetTransformFeedbackVarying)(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLsizei * size, GLenum * type, GLchar * name);
	typedef GLvoid (GLAPI * PROC_glClampColor)(GLenum target, GLenum clamp);
	typedef GLvoid (GLAPI * PROC_glBeginConditionalRender)(GLuint id, GLenum mode);
	typedef GLvoid (GLAPI * PROC_glEndConditionalRender)();
	typedef GLvoid (GLAPI * PROC_glVertexAttribIPointer)(GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid * pointer);
	typedef GLvoid (GLAPI * PROC_glGetVertexAttribIiv)(GLuint index, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glGetVertexAttribIuiv)(GLuint index, GLenum pname, GLuint * params);
	typedef GLvoid (GLAPI * PROC_glVertexAttribI1i)(GLuint index, GLint x);
	typedef GLvoid (GLAPI * PROC_glVertexAttribI2i)(GLuint index, GLint x, GLint y);
	typedef GLvoid (GLAPI * PROC_glVertexAttribI3i)(GLuint index, GLint x, GLint y, GLint z);
	typedef GLvoid (GLAPI * PROC_glVertexAttribI4i)(GLuint index, GLint x, GLint y, GLint z, GLint w);
	typedef GLvoid (GLAPI * PROC_glVertexAttribI1ui)(GLuint index, GLuint x);
	typedef GLvoid (GLAPI * PROC_glVertexAttribI2ui)(GLuint index, GLuint x, GLuint y);
	typedef GLvoid (GLAPI * PROC_glVertexAttribI3ui)(GLuint index, GLuint x, GLuint y, GLuint z);
	typedef GLvoid (GLAPI * PROC_glVertexAttribI4ui)(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w);
	typedef GLvoid (GLAPI * PROC_glVertexAttribI1iv)(GLuint index, const GLint * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttribI2iv)(GLuint index, const GLint * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttribI3iv)(GLuint index, const GLint * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttribI4iv)(GLuint index, const GLint * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttribI1uiv)(GLuint index, const GLuint * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttribI2uiv)(GLuint index, const GLuint * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttribI3uiv)(GLuint index, const GLuint * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttribI4uiv)(GLuint index, const GLuint * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttribI4bv)(GLuint index, const GLbyte * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttribI4sv)(GLuint index, const GLshort * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttribI4ubv)(GLuint index, const GLubyte * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttribI4usv)(GLuint index, const GLushort * v);
	typedef GLvoid (GLAPI * PROC_glGetUniformuiv)(GLuint program, GLint location, GLuint * params);
	typedef GLvoid (GLAPI * PROC_glBindFragDataLocation)(GLuint program, GLuint color, const GLchar * name);
	typedef GLint (GLAPI * PROC_glGetFragDataLocation)(GLuint program, const GLchar * name);
	typedef GLvoid (GLAPI * PROC_glUniform1ui)(GLint location, GLuint v0);
	typedef GLvoid (GLAPI * PROC_glUniform2ui)(GLint location, GLuint v0, GLuint v1);
	typedef GLvoid (GLAPI * PROC_glUniform3ui)(GLint location, GLuint v0, GLuint v1, GLuint v2);
	typedef GLvoid (GLAPI * PROC_glUniform4ui)(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3);
	typedef GLvoid (GLAPI * PROC_glUniform1uiv)(GLint location, GLsizei count, const GLuint * value);
	typedef GLvoid (GLAPI * PROC_glUniform2uiv)(GLint location, GLsizei count, const GLuint * value);
	typedef GLvoid (GLAPI * PROC_glUniform3uiv)(GLint location, GLsizei count, const GLuint * value);
	typedef GLvoid (GLAPI * PROC_glUniform4uiv)(GLint location, GLsizei count, const GLuint * value);
	typedef GLvoid (GLAPI * PROC_glTexParameterIiv)(GLenum target, GLenum pname, const GLint * params);
	typedef GLvoid (GLAPI * PROC_glTexParameterIuiv)(GLenum target, GLenum pname, const GLuint * params);
	typedef GLvoid (GLAPI * PROC_glGetTexParameterIiv)(GLenum target, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glGetTexParameterIuiv)(GLenum target, GLenum pname, GLuint * params);
	typedef GLvoid (GLAPI * PROC_glClearBufferiv)(GLenum buffer, GLint drawbuffer, const GLint * value);
	typedef GLvoid (GLAPI * PROC_glClearBufferuiv)(GLenum buffer, GLint drawbuffer, const GLuint * value);
	typedef GLvoid (GLAPI * PROC_glClearBufferfv)(GLenum buffer, GLint drawbuffer, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glClearBufferfi)(GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil);
	typedef const GLubyte * (GLAPI * PROC_glGetStringi)(GLenum name, GLuint index);
	typedef GLboolean (GLAPI * PROC_glIsRenderbuffer)(GLuint renderbuffer);
	typedef GLvoid (GLAPI * PROC_glBindRenderbuffer)(GLenum target, GLuint renderbuffer);
	typedef GLvoid (GLAPI * PROC_glDeleteRenderbuffers)(GLsizei n, const GLuint * renderbuffers);
	typedef GLvoid (GLAPI * PROC_glGenRenderbuffers)(GLsizei n, GLuint * renderbuffers);
	typedef GLvoid (GLAPI * PROC_glRenderbufferStorage)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height);
	typedef GLvoid (GLAPI * PROC_glGetRenderbufferParameteriv)(GLenum target, GLenum pname, GLint * params);
	typedef GLboolean (GLAPI * PROC_glIsFramebuffer)(GLuint framebuffer);
	typedef GLvoid (GLAPI * PROC_glBindFramebuffer)(GLenum target, GLuint framebuffer);
	typedef GLvoid (GLAPI * PROC_glDeleteFramebuffers)(GLsizei n, const GLuint * framebuffers);
	typedef GLvoid (GLAPI * PROC_glGenFramebuffers)(GLsizei n, GLuint * framebuffers);
	typedef GLenum (GLAPI * PROC_glCheckFramebufferStatus)(GLenum target);
	typedef GLvoid (GLAPI * PROC_glFramebufferTexture1D)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
	typedef GLvoid (GLAPI * PROC_glFramebufferTexture2D)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
	typedef GLvoid (GLAPI * PROC_glFramebufferTexture3D)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset);
	typedef GLvoid (GLAPI * PROC_glFramebufferRenderbuffer)(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
	typedef GLvoid (GLAPI * PROC_glGetFramebufferAttachmentParameteriv)(GLenum target, GLenum attachment, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glGenerateMipmap)(GLenum target);
	typedef GLvoid (GLAPI * PROC_glBlitFramebuffer)(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);
	typedef GLvoid (GLAPI * PROC_glRenderbufferStorageMultisample)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
	typedef GLvoid (GLAPI * PROC_glFramebufferTextureLayer)(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer);
	typedef GLvoid * (GLAPI * PROC_glMapBufferRange)(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access);
	typedef GLvoid (GLAPI * PROC_glFlushMappedBufferRange)(GLenum target, GLintptr offset, GLsizeiptr length);
	typedef GLvoid (GLAPI * PROC_glBindVertexArray)(GLuint array);
	typedef GLvoid (GLAPI * PROC_glDeleteVertexArrays)(GLsizei n, const GLuint * arrays);
	typedef GLvoid (GLAPI * PROC_glGenVertexArrays)(GLsizei n, GLuint * arrays);
	typedef GLboolean (GLAPI * PROC_glIsVertexArray)(GLuint array);
	typedef GLvoid (GLAPI * PROC_glDrawArraysInstanced)(GLenum mode, GLint first, GLsizei count, GLsizei instancecount);
	typedef GLvoid (GLAPI * PROC_glDrawElementsInstanced)(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei instancecount);
	typedef GLvoid (GLAPI * PROC_glTexBuffer)(GLenum target, GLenum internalformat, GLuint buffer);
	typedef GLvoid (GLAPI * PROC_glPrimitiveRestartIndex)(GLuint index);
	typedef GLvoid (GLAPI * PROC_glCopyBufferSubData)(GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size);
	typedef GLvoid (GLAPI * PROC_glGetUniformIndices)(GLuint program, GLsizei uniformCount, const GLchar * const* uniformNames, GLuint * uniformIndices);
	typedef GLvoid (GLAPI * PROC_glGetActiveUniformsiv)(GLuint program, GLsizei uniformCount, const GLuint * uniformIndices, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glGetActiveUniformName)(GLuint program, GLuint uniformIndex, GLsizei bufSize, GLsizei * length, GLchar * uniformName);
	typedef GLuint (GLAPI * PROC_glGetUniformBlockIndex)(GLuint program, const GLchar * uniformBlockName);
	typedef GLvoid (GLAPI * PROC_glGetActiveUniformBlockiv)(GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glGetActiveUniformBlockName)(GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei * length, GLchar * uniformBlockName);
	typedef GLvoid (GLAPI * PROC_glUniformBlockBinding)(GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding);
	typedef GLvoid (GLAPI * PROC_glDrawElementsBaseVertex)(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLint basevertex);
	typedef GLvoid (GLAPI * PROC_glDrawRangeElementsBaseVertex)(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid * indices, GLint basevertex);
	typedef GLvoid (GLAPI * PROC_glDrawElementsInstancedBaseVertex)(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei instancecount, GLint basevertex);
	typedef GLvoid (GLAPI * PROC_glMultiDrawElementsBaseVertex)(GLenum mode, const GLsizei * count, GLenum type, const GLvoid * const* indices, GLsizei drawcount, const GLint * basevertex);
	typedef GLvoid (GLAPI * PROC_glProvokingVertex)(GLenum mode);
	typedef GLsync (GLAPI * PROC_glFenceSync)(GLenum condition, GLbitfield flags);
	typedef GLboolean (GLAPI * PROC_glIsSync)(GLsync sync);
	typedef GLvoid (GLAPI * PROC_glDeleteSync)(GLsync sync);
	typedef GLenum (GLAPI * PROC_glClientWaitSync)(GLsync sync, GLbitfield flags, GLuint64 timeout);
	typedef GLvoid (GLAPI * PROC_glWaitSync)(GLsync sync, GLbitfield flags, GLuint64 timeout);
	typedef GLvoid (GLAPI * PROC_glGetInteger64v)(GLenum pname, GLint64 * data);
	typedef GLvoid (GLAPI * PROC_glGetSynciv)(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei * length, GLint * values);
	typedef GLvoid (GLAPI * PROC_glGetInteger64i_v)(GLenum target, GLuint index, GLint64 * data);
	typedef GLvoid (GLAPI * PROC_glGetBufferParameteri64v)(GLenum target, GLenum pname, GLint64 * params);
	typedef GLvoid (GLAPI * PROC_glFramebufferTexture)(GLenum target, GLenum attachment, GLuint texture, GLint level);
	typedef GLvoid (GLAPI * PROC_glTexImage2DMultisample)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);
	typedef GLvoid (GLAPI * PROC_glTexImage3DMultisample)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);
	typedef GLvoid (GLAPI * PROC_glGetMultisamplefv)(GLenum pname, GLuint index, GLfloat * val);
	typedef GLvoid (GLAPI * PROC_glSampleMaski)(GLuint maskNumber, GLbitfield mask);
	typedef GLvoid (GLAPI * PROC_glBindFragDataLocationIndexed)(GLuint program, GLuint colorNumber, GLuint index, const GLchar * name);
	typedef GLint (GLAPI * PROC_glGetFragDataIndex)(GLuint program, const GLchar * name);
	typedef GLvoid (GLAPI * PROC_glGenSamplers)(GLsizei count, GLuint * samplers);
	typedef GLvoid (GLAPI * PROC_glDeleteSamplers)(GLsizei count, const GLuint * samplers);
	typedef GLboolean (GLAPI * PROC_glIsSampler)(GLuint sampler);
	typedef GLvoid (GLAPI * PROC_glBindSampler)(GLuint unit, GLuint sampler);
	typedef GLvoid (GLAPI * PROC_glSamplerParameteri)(GLuint sampler, GLenum pname, GLint param);
	typedef GLvoid (GLAPI * PROC_glSamplerParameteriv)(GLuint sampler, GLenum pname, const GLint * param);
	typedef GLvoid (GLAPI * PROC_glSamplerParameterf)(GLuint sampler, GLenum pname, GLfloat param);
	typedef GLvoid (GLAPI * PROC_glSamplerParameterfv)(GLuint sampler, GLenum pname, const GLfloat * param);
	typedef GLvoid (GLAPI * PROC_glSamplerParameterIiv)(GLuint sampler, GLenum pname, const GLint * param);
	typedef GLvoid (GLAPI * PROC_glSamplerParameterIuiv)(GLuint sampler, GLenum pname, const GLuint * param);
	typedef GLvoid (GLAPI * PROC_glGetSamplerParameteriv)(GLuint sampler, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glGetSamplerParameterIiv)(GLuint sampler, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glGetSamplerParameterfv)(GLuint sampler, GLenum pname, GLfloat * params);
	typedef GLvoid (GLAPI * PROC_glGetSamplerParameterIuiv)(GLuint sampler, GLenum pname, GLuint * params);
	typedef GLvoid (GLAPI * PROC_glQueryCounter)(GLuint id, GLenum target);
	typedef GLvoid (GLAPI * PROC_glGetQueryObjecti64v)(GLuint id, GLenum pname, GLint64 * params);
	typedef GLvoid (GLAPI * PROC_glGetQueryObjectui64v)(GLuint id, GLenum pname, GLuint64 * params);
	typedef GLvoid (GLAPI * PROC_glVertexAttribDivisor)(GLuint index, GLuint divisor);
	typedef GLvoid (GLAPI * PROC_glVertexAttribP1ui)(GLuint index, GLenum type, GLboolean normalized, GLuint value);
	typedef GLvoid (GLAPI * PROC_glVertexAttribP1uiv)(GLuint index, GLenum type, GLboolean normalized, const GLuint * value);
	typedef GLvoid (GLAPI * PROC_glVertexAttribP2ui)(GLuint index, GLenum type, GLboolean normalized, GLuint value);
	typedef GLvoid (GLAPI * PROC_glVertexAttribP2uiv)(GLuint index, GLenum type, GLboolean normalized, const GLuint * value);
	typedef GLvoid (GLAPI * PROC_glVertexAttribP3ui)(GLuint index, GLenum type, GLboolean normalized, GLuint value);
	typedef GLvoid (GLAPI * PROC_glVertexAttribP3uiv)(GLuint index, GLenum type, GLboolean normalized, const GLuint * value);
	typedef GLvoid (GLAPI * PROC_glVertexAttribP4ui)(GLuint index, GLenum type, GLboolean normalized, GLuint value);
	typedef GLvoid (GLAPI * PROC_glVertexAttribP4uiv)(GLuint index, GLenum type, GLboolean normalized, const GLuint * value);
	typedef GLvoid (GLAPI * PROC_glMinSampleShading)(GLfloat value);
	typedef GLvoid (GLAPI * PROC_glBlendEquationi)(GLuint buf, GLenum mode);
	typedef GLvoid (GLAPI * PROC_glBlendEquationSeparatei)(GLuint buf, GLenum modeRGB, GLenum modeAlpha);
	typedef GLvoid (GLAPI * PROC_glBlendFunci)(GLuint buf, GLenum src, GLenum dst);
	typedef GLvoid (GLAPI * PROC_glBlendFuncSeparatei)(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha);
	typedef GLvoid (GLAPI * PROC_glDrawArraysIndirect)(GLenum mode, const GLvoid * indirect);
	typedef GLvoid (GLAPI * PROC_glDrawElementsIndirect)(GLenum mode, GLenum type, const GLvoid * indirect);
	typedef GLvoid (GLAPI * PROC_glUniform1d)(GLint location, GLdouble x);
	typedef GLvoid (GLAPI * PROC_glUniform2d)(GLint location, GLdouble x, GLdouble y);
	typedef GLvoid (GLAPI * PROC_glUniform3d)(GLint location, GLdouble x, GLdouble y, GLdouble z);
	typedef GLvoid (GLAPI * PROC_glUniform4d)(GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
	typedef GLvoid (GLAPI * PROC_glUniform1dv)(GLint location, GLsizei count, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glUniform2dv)(GLint location, GLsizei count, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glUniform3dv)(GLint location, GLsizei count, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glUniform4dv)(GLint location, GLsizei count, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glUniformMatrix2dv)(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glUniformMatrix3dv)(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glUniformMatrix4dv)(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glUniformMatrix2x3dv)(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glUniformMatrix2x4dv)(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glUniformMatrix3x2dv)(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glUniformMatrix3x4dv)(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glUniformMatrix4x2dv)(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glUniformMatrix4x3dv)(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glGetUniformdv)(GLuint program, GLint location, GLdouble * params);
	typedef GLint (GLAPI * PROC_glGetSubroutineUniformLocation)(GLuint program, GLenum shadertype, const GLchar * name);
	typedef GLuint (GLAPI * PROC_glGetSubroutineIndex)(GLuint program, GLenum shadertype, const GLchar * name);
	typedef GLvoid (GLAPI * PROC_glGetActiveSubroutineUniformiv)(GLuint program, GLenum shadertype, GLuint index, GLenum pname, GLint * values);
	typedef GLvoid (GLAPI * PROC_glGetActiveSubroutineUniformName)(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei * length, GLchar * name);
	typedef GLvoid (GLAPI * PROC_glGetActiveSubroutineName)(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei * length, GLchar * name);
	typedef GLvoid (GLAPI * PROC_glUniformSubroutinesuiv)(GLenum shadertype, GLsizei count, const GLuint * indices);
	typedef GLvoid (GLAPI * PROC_glGetUniformSubroutineuiv)(GLenum shadertype, GLint location, GLuint * params);
	typedef GLvoid (GLAPI * PROC_glGetProgramStageiv)(GLuint program, GLenum shadertype, GLenum pname, GLint * values);
	typedef GLvoid (GLAPI * PROC_glPatchParameteri)(GLenum pname, GLint value);
	typedef GLvoid (GLAPI * PROC_glPatchParameterfv)(GLenum pname, const GLfloat * values);
	typedef GLvoid (GLAPI * PROC_glBindTransformFeedback)(GLenum target, GLuint id);
	typedef GLvoid (GLAPI * PROC_glDeleteTransformFeedbacks)(GLsizei n, const GLuint * ids);
	typedef GLvoid (GLAPI * PROC_glGenTransformFeedbacks)(GLsizei n, GLuint * ids);
	typedef GLboolean (GLAPI * PROC_glIsTransformFeedback)(GLuint id);
	typedef GLvoid (GLAPI * PROC_glPauseTransformFeedback)();
	typedef GLvoid (GLAPI * PROC_glResumeTransformFeedback)();
	typedef GLvoid (GLAPI * PROC_glDrawTransformFeedback)(GLenum mode, GLuint id);
	typedef GLvoid (GLAPI * PROC_glDrawTransformFeedbackStream)(GLenum mode, GLuint id, GLuint stream);
	typedef GLvoid (GLAPI * PROC_glBeginQueryIndexed)(GLenum target, GLuint index, GLuint id);
	typedef GLvoid (GLAPI * PROC_glEndQueryIndexed)(GLenum target, GLuint index);
	typedef GLvoid (GLAPI * PROC_glGetQueryIndexediv)(GLenum target, GLuint index, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glReleaseShaderCompiler)();
	typedef GLvoid (GLAPI * PROC_glShaderBinary)(GLsizei count, const GLuint * shaders, GLenum binaryformat, const GLvoid * binary, GLsizei length);
	typedef GLvoid (GLAPI * PROC_glGetShaderPrecisionFormat)(GLenum shadertype, GLenum precisiontype, GLint * range, GLint * precision);
	typedef GLvoid (GLAPI * PROC_glDepthRangef)(GLfloat n, GLfloat f);
	typedef GLvoid (GLAPI * PROC_glClearDepthf)(GLfloat d);
	typedef GLvoid (GLAPI * PROC_glGetProgramBinary)(GLuint program, GLsizei bufSize, GLsizei * length, GLenum * binaryFormat, GLvoid * binary);
	typedef GLvoid (GLAPI * PROC_glProgramBinary)(GLuint program, GLenum binaryFormat, const GLvoid * binary, GLsizei length);
	typedef GLvoid (GLAPI * PROC_glProgramParameteri)(GLuint program, GLenum pname, GLint value);
	typedef GLvoid (GLAPI * PROC_glUseProgramStages)(GLuint pipeline, GLbitfield stages, GLuint program);
	typedef GLvoid (GLAPI * PROC_glActiveShaderProgram)(GLuint pipeline, GLuint program);
	typedef GLuint (GLAPI * PROC_glCreateShaderProgramv)(GLenum type, GLsizei count, const GLchar * const* strings);
	typedef GLvoid (GLAPI * PROC_glBindProgramPipeline)(GLuint pipeline);
	typedef GLvoid (GLAPI * PROC_glDeleteProgramPipelines)(GLsizei n, const GLuint * pipelines);
	typedef GLvoid (GLAPI * PROC_glGenProgramPipelines)(GLsizei n, GLuint * pipelines);
	typedef GLboolean (GLAPI * PROC_glIsProgramPipeline)(GLuint pipeline);
	typedef GLvoid (GLAPI * PROC_glGetProgramPipelineiv)(GLuint pipeline, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glProgramUniform1i)(GLuint program, GLint location, GLint v0);
	typedef GLvoid (GLAPI * PROC_glProgramUniform1iv)(GLuint program, GLint location, GLsizei count, const GLint * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniform1f)(GLuint program, GLint location, GLfloat v0);
	typedef GLvoid (GLAPI * PROC_glProgramUniform1fv)(GLuint program, GLint location, GLsizei count, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniform1d)(GLuint program, GLint location, GLdouble v0);
	typedef GLvoid (GLAPI * PROC_glProgramUniform1dv)(GLuint program, GLint location, GLsizei count, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniform1ui)(GLuint program, GLint location, GLuint v0);
	typedef GLvoid (GLAPI * PROC_glProgramUniform1uiv)(GLuint program, GLint location, GLsizei count, const GLuint * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniform2i)(GLuint program, GLint location, GLint v0, GLint v1);
	typedef GLvoid (GLAPI * PROC_glProgramUniform2iv)(GLuint program, GLint location, GLsizei count, const GLint * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniform2f)(GLuint program, GLint location, GLfloat v0, GLfloat v1);
	typedef GLvoid (GLAPI * PROC_glProgramUniform2fv)(GLuint program, GLint location, GLsizei count, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniform2d)(GLuint program, GLint location, GLdouble v0, GLdouble v1);
	typedef GLvoid (GLAPI * PROC_glProgramUniform2dv)(GLuint program, GLint location, GLsizei count, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniform2ui)(GLuint program, GLint location, GLuint v0, GLuint v1);
	typedef GLvoid (GLAPI * PROC_glProgramUniform2uiv)(GLuint program, GLint location, GLsizei count, const GLuint * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniform3i)(GLuint program, GLint location, GLint v0, GLint v1, GLint v2);
	typedef GLvoid (GLAPI * PROC_glProgramUniform3iv)(GLuint program, GLint location, GLsizei count, const GLint * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniform3f)(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
	typedef GLvoid (GLAPI * PROC_glProgramUniform3fv)(GLuint program, GLint location, GLsizei count, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniform3d)(GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2);
	typedef GLvoid (GLAPI * PROC_glProgramUniform3dv)(GLuint program, GLint location, GLsizei count, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniform3ui)(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2);
	typedef GLvoid (GLAPI * PROC_glProgramUniform3uiv)(GLuint program, GLint location, GLsizei count, const GLuint * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniform4i)(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
	typedef GLvoid (GLAPI * PROC_glProgramUniform4iv)(GLuint program, GLint location, GLsizei count, const GLint * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniform4f)(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
	typedef GLvoid (GLAPI * PROC_glProgramUniform4fv)(GLuint program, GLint location, GLsizei count, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniform4d)(GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2, GLdouble v3);
	typedef GLvoid (GLAPI * PROC_glProgramUniform4dv)(GLuint program, GLint location, GLsizei count, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniform4ui)(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3);
	typedef GLvoid (GLAPI * PROC_glProgramUniform4uiv)(GLuint program, GLint location, GLsizei count, const GLuint * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniformMatrix2fv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniformMatrix3fv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniformMatrix4fv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniformMatrix2dv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniformMatrix3dv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniformMatrix4dv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniformMatrix2x3fv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniformMatrix3x2fv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniformMatrix2x4fv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniformMatrix4x2fv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniformMatrix3x4fv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniformMatrix4x3fv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniformMatrix2x3dv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniformMatrix3x2dv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniformMatrix2x4dv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniformMatrix4x2dv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniformMatrix3x4dv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glProgramUniformMatrix4x3dv)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble * value);
	typedef GLvoid (GLAPI * PROC_glValidateProgramPipeline)(GLuint pipeline);
	typedef GLvoid (GLAPI * PROC_glGetProgramPipelineInfoLog)(GLuint pipeline, GLsizei bufSize, GLsizei * length, GLchar * infoLog);
	typedef GLvoid (GLAPI * PROC_glVertexAttribL1d)(GLuint index, GLdouble x);
	typedef GLvoid (GLAPI * PROC_glVertexAttribL2d)(GLuint index, GLdouble x, GLdouble y);
	typedef GLvoid (GLAPI * PROC_glVertexAttribL3d)(GLuint index, GLdouble x, GLdouble y, GLdouble z);
	typedef GLvoid (GLAPI * PROC_glVertexAttribL4d)(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
	typedef GLvoid (GLAPI * PROC_glVertexAttribL1dv)(GLuint index, const GLdouble * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttribL2dv)(GLuint index, const GLdouble * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttribL3dv)(GLuint index, const GLdouble * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttribL4dv)(GLuint index, const GLdouble * v);
	typedef GLvoid (GLAPI * PROC_glVertexAttribLPointer)(GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid * pointer);
	typedef GLvoid (GLAPI * PROC_glGetVertexAttribLdv)(GLuint index, GLenum pname, GLdouble * params);
	typedef GLvoid (GLAPI * PROC_glViewportArrayv)(GLuint first, GLsizei count, const GLfloat * v);
	typedef GLvoid (GLAPI * PROC_glViewportIndexedf)(GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h);
	typedef GLvoid (GLAPI * PROC_glViewportIndexedfv)(GLuint index, const GLfloat * v);
	typedef GLvoid (GLAPI * PROC_glScissorArrayv)(GLuint first, GLsizei count, const GLint * v);
	typedef GLvoid (GLAPI * PROC_glScissorIndexed)(GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height);
	typedef GLvoid (GLAPI * PROC_glScissorIndexedv)(GLuint index, const GLint * v);
	typedef GLvoid (GLAPI * PROC_glDepthRangeArrayv)(GLuint first, GLsizei count, const GLdouble * v);
	typedef GLvoid (GLAPI * PROC_glDepthRangeIndexed)(GLuint index, GLdouble n, GLdouble f);
	typedef GLvoid (GLAPI * PROC_glGetFloati_v)(GLenum target, GLuint index, GLfloat * data);
	typedef GLvoid (GLAPI * PROC_glGetDoublei_v)(GLenum target, GLuint index, GLdouble * data);
	typedef GLvoid (GLAPI * PROC_glDrawArraysInstancedBaseInstance)(GLenum mode, GLint first, GLsizei count, GLsizei instancecount, GLuint baseinstance);
	typedef GLvoid (GLAPI * PROC_glDrawElementsInstancedBaseInstance)(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei instancecount, GLuint baseinstance);
	typedef GLvoid (GLAPI * PROC_glDrawElementsInstancedBaseVertexBaseInstance)(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei instancecount, GLint basevertex, GLuint baseinstance);
	typedef GLvoid (GLAPI * PROC_glGetInternalformativ)(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint * params);
	typedef GLvoid (GLAPI * PROC_glGetActiveAtomicCounterBufferiv)(GLuint program, GLuint bufferIndex, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glBindImageTexture)(GLuint unit, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLenum format);
	typedef GLvoid (GLAPI * PROC_glMemoryBarrier)(GLbitfield barriers);
	typedef GLvoid (GLAPI * PROC_glTexStorage1D)(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width);
	typedef GLvoid (GLAPI * PROC_glTexStorage2D)(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
	typedef GLvoid (GLAPI * PROC_glTexStorage3D)(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);
	typedef GLvoid (GLAPI * PROC_glDrawTransformFeedbackInstanced)(GLenum mode, GLuint id, GLsizei instancecount);
	typedef GLvoid (GLAPI * PROC_glDrawTransformFeedbackStreamInstanced)(GLenum mode, GLuint id, GLuint stream, GLsizei instancecount);
	typedef GLvoid (GLAPI * PROC_glClearBufferData)(GLenum target, GLenum internalformat, GLenum format, GLenum type, const GLvoid * data);
	typedef GLvoid (GLAPI * PROC_glClearBufferSubData)(GLenum target, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const GLvoid * data);
	typedef GLvoid (GLAPI * PROC_glDispatchCompute)(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z);
	typedef GLvoid (GLAPI * PROC_glDispatchComputeIndirect)(GLintptr indirect);
	typedef GLvoid (GLAPI * PROC_glCopyImageSubData)(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth);
	typedef GLvoid (GLAPI * PROC_glFramebufferParameteri)(GLenum target, GLenum pname, GLint param);
	typedef GLvoid (GLAPI * PROC_glGetFramebufferParameteriv)(GLenum target, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glGetInternalformati64v)(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint64 * params);
	typedef GLvoid (GLAPI * PROC_glInvalidateTexSubImage)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth);
	typedef GLvoid (GLAPI * PROC_glInvalidateTexImage)(GLuint texture, GLint level);
	typedef GLvoid (GLAPI * PROC_glInvalidateBufferSubData)(GLuint buffer, GLintptr offset, GLsizeiptr length);
	typedef GLvoid (GLAPI * PROC_glInvalidateBufferData)(GLuint buffer);
	typedef GLvoid (GLAPI * PROC_glInvalidateFramebuffer)(GLenum target, GLsizei numAttachments, const GLenum * attachments);
	typedef GLvoid (GLAPI * PROC_glInvalidateSubFramebuffer)(GLenum target, GLsizei numAttachments, const GLenum * attachments, GLint x, GLint y, GLsizei width, GLsizei height);
	typedef GLvoid (GLAPI * PROC_glMultiDrawArraysIndirect)(GLenum mode, const GLvoid * indirect, GLsizei drawcount, GLsizei stride);
	typedef GLvoid (GLAPI * PROC_glMultiDrawElementsIndirect)(GLenum mode, GLenum type, const GLvoid * indirect, GLsizei drawcount, GLsizei stride);
	typedef GLvoid (GLAPI * PROC_glGetProgramInterfaceiv)(GLuint program, GLenum programInterface, GLenum pname, GLint * params);
	typedef GLuint (GLAPI * PROC_glGetProgramResourceIndex)(GLuint program, GLenum programInterface, const GLchar * name);
	typedef GLvoid (GLAPI * PROC_glGetProgramResourceName)(GLuint program, GLenum programInterface, GLuint index, GLsizei bufSize, GLsizei * length, GLchar * name);
	typedef GLvoid (GLAPI * PROC_glGetProgramResourceiv)(GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum * props, GLsizei bufSize, GLsizei * length, GLint * params);
	typedef GLint (GLAPI * PROC_glGetProgramResourceLocation)(GLuint program, GLenum programInterface, const GLchar * name);
	typedef GLint (GLAPI * PROC_glGetProgramResourceLocationIndex)(GLuint program, GLenum programInterface, const GLchar * name);
	typedef GLvoid (GLAPI * PROC_glShaderStorageBlockBinding)(GLuint program, GLuint storageBlockIndex, GLuint storageBlockBinding);
	typedef GLvoid (GLAPI * PROC_glTexBufferRange)(GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size);
	typedef GLvoid (GLAPI * PROC_glTexStorage2DMultisample)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);
	typedef GLvoid (GLAPI * PROC_glTexStorage3DMultisample)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);
	typedef GLvoid (GLAPI * PROC_glTextureView)(GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers);
	typedef GLvoid (GLAPI * PROC_glBindVertexBuffer)(GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride);
	typedef GLvoid (GLAPI * PROC_glVertexAttribFormat)(GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset);
	typedef GLvoid (GLAPI * PROC_glVertexAttribIFormat)(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
	typedef GLvoid (GLAPI * PROC_glVertexAttribLFormat)(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
	typedef GLvoid (GLAPI * PROC_glVertexAttribBinding)(GLuint attribindex, GLuint bindingindex);
	typedef GLvoid (GLAPI * PROC_glVertexBindingDivisor)(GLuint bindingindex, GLuint divisor);
	typedef GLvoid (GLAPI * PROC_glDebugMessageControl)(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint * ids, GLboolean enabled);
	typedef GLvoid (GLAPI * PROC_glDebugMessageInsert)(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar * buf);
	typedef GLvoid (GLAPI * PROC_glDebugMessageCallback)(GLDEBUGPROC callback, const GLvoid * userParam);
	typedef GLuint (GLAPI * PROC_glGetDebugMessageLog)(GLuint count, GLsizei bufSize, GLenum * sources, GLenum * types, GLuint * ids, GLenum * severities, GLsizei * lengths, GLchar * messageLog);
	typedef GLvoid (GLAPI * PROC_glPushDebugGroup)(GLenum source, GLuint id, GLsizei length, const GLchar * message);
	typedef GLvoid (GLAPI * PROC_glPopDebugGroup)();
	typedef GLvoid (GLAPI * PROC_glObjectLabel)(GLenum identifier, GLuint name, GLsizei length, const GLchar * label);
	typedef GLvoid (GLAPI * PROC_glGetObjectLabel)(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei * length, GLchar * label);
	typedef GLvoid (GLAPI * PROC_glObjectPtrLabel)(const GLvoid * ptr, GLsizei length, const GLchar * label);
	typedef GLvoid (GLAPI * PROC_glGetObjectPtrLabel)(const GLvoid * ptr, GLsizei bufSize, GLsizei * length, GLchar * label);
	typedef GLvoid (GLAPI * PROC_glBufferStorage)(GLenum target, GLsizeiptr size, const GLvoid * data, GLbitfield flags);
	typedef GLvoid (GLAPI * PROC_glClearTexImage)(GLuint texture, GLint level, GLenum format, GLenum type, const GLvoid * data);
	typedef GLvoid (GLAPI * PROC_glClearTexSubImage)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid * data);
	typedef GLvoid (GLAPI * PROC_glBindBuffersBase)(GLenum target, GLuint first, GLsizei count, const GLuint * buffers);
	typedef GLvoid (GLAPI * PROC_glBindBuffersRange)(GLenum target, GLuint first, GLsizei count, const GLuint * buffers, const GLintptr * offsets, const GLsizeiptr * sizes);
	typedef GLvoid (GLAPI * PROC_glBindTextures)(GLuint first, GLsizei count, const GLuint * textures);
	typedef GLvoid (GLAPI * PROC_glBindSamplers)(GLuint first, GLsizei count, const GLuint * samplers);
	typedef GLvoid (GLAPI * PROC_glBindImageTextures)(GLuint first, GLsizei count, const GLuint * textures);
	typedef GLvoid (GLAPI * PROC_glBindVertexBuffers)(GLuint first, GLsizei count, const GLuint * buffers, const GLintptr * offsets, const GLsizei * strides);
	typedef GLvoid (GLAPI * PROC_glClipControl)(GLenum origin, GLenum depth);
	typedef GLvoid (GLAPI * PROC_glCreateTransformFeedbacks)(GLsizei n, GLuint * ids);
	typedef GLvoid (GLAPI * PROC_glTransformFeedbackBufferBase)(GLuint xfb, GLuint index, GLuint buffer);
	typedef GLvoid (GLAPI * PROC_glTransformFeedbackBufferRange)(GLuint xfb, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size);
	typedef GLvoid (GLAPI * PROC_glGetTransformFeedbackiv)(GLuint xfb, GLenum pname, GLint * param);
	typedef GLvoid (GLAPI * PROC_glGetTransformFeedbacki_v)(GLuint xfb, GLenum pname, GLuint index, GLint * param);
	typedef GLvoid (GLAPI * PROC_glGetTransformFeedbacki64_v)(GLuint xfb, GLenum pname, GLuint index, GLint64 * param);
	typedef GLvoid (GLAPI * PROC_glCreateBuffers)(GLsizei n, GLuint * buffers);
	typedef GLvoid (GLAPI * PROC_glNamedBufferStorage)(GLuint buffer, GLsizeiptr size, const GLvoid * data, GLbitfield flags);
	typedef GLvoid (GLAPI * PROC_glNamedBufferData)(GLuint buffer, GLsizeiptr size, const GLvoid * data, GLenum usage);
	typedef GLvoid (GLAPI * PROC_glNamedBufferSubData)(GLuint buffer, GLintptr offset, GLsizeiptr size, const GLvoid * data);
	typedef GLvoid (GLAPI * PROC_glCopyNamedBufferSubData)(GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size);
	typedef GLvoid (GLAPI * PROC_glClearNamedBufferData)(GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const GLvoid * data);
	typedef GLvoid (GLAPI * PROC_glClearNamedBufferSubData)(GLuint buffer, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const GLvoid * data);
	typedef GLvoid * (GLAPI * PROC_glMapNamedBuffer)(GLuint buffer, GLenum access);
	typedef GLvoid * (GLAPI * PROC_glMapNamedBufferRange)(GLuint buffer, GLintptr offset, GLsizeiptr length, GLbitfield access);
	typedef GLboolean (GLAPI * PROC_glUnmapNamedBuffer)(GLuint buffer);
	typedef GLvoid (GLAPI * PROC_glFlushMappedNamedBufferRange)(GLuint buffer, GLintptr offset, GLsizeiptr length);
	typedef GLvoid (GLAPI * PROC_glGetNamedBufferParameteriv)(GLuint buffer, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glGetNamedBufferParameteri64v)(GLuint buffer, GLenum pname, GLint64 * params);
	typedef GLvoid (GLAPI * PROC_glGetNamedBufferPointerv)(GLuint buffer, GLenum pname, GLvoid ** params);
	typedef GLvoid (GLAPI * PROC_glGetNamedBufferSubData)(GLuint buffer, GLintptr offset, GLsizeiptr size, GLvoid * data);
	typedef GLvoid (GLAPI * PROC_glCreateFramebuffers)(GLsizei n, GLuint * framebuffers);
	typedef GLvoid (GLAPI * PROC_glNamedFramebufferRenderbuffer)(GLuint framebuffer, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
	typedef GLvoid (GLAPI * PROC_glNamedFramebufferParameteri)(GLuint framebuffer, GLenum pname, GLint param);
	typedef GLvoid (GLAPI * PROC_glNamedFramebufferTexture)(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level);
	typedef GLvoid (GLAPI * PROC_glNamedFramebufferTextureLayer)(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint layer);
	typedef GLvoid (GLAPI * PROC_glNamedFramebufferDrawBuffer)(GLuint framebuffer, GLenum buf);
	typedef GLvoid (GLAPI * PROC_glNamedFramebufferDrawBuffers)(GLuint framebuffer, GLsizei n, const GLenum * bufs);
	typedef GLvoid (GLAPI * PROC_glNamedFramebufferReadBuffer)(GLuint framebuffer, GLenum src);
	typedef GLvoid (GLAPI * PROC_glInvalidateNamedFramebufferData)(GLuint framebuffer, GLsizei numAttachments, const GLenum * attachments);
	typedef GLvoid (GLAPI * PROC_glInvalidateNamedFramebufferSubData)(GLuint framebuffer, GLsizei numAttachments, const GLenum * attachments, GLint x, GLint y, GLsizei width, GLsizei height);
	typedef GLvoid (GLAPI * PROC_glClearNamedFramebufferiv)(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLint * value);
	typedef GLvoid (GLAPI * PROC_glClearNamedFramebufferuiv)(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLuint * value);
	typedef GLvoid (GLAPI * PROC_glClearNamedFramebufferfv)(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLfloat * value);
	typedef GLvoid (GLAPI * PROC_glClearNamedFramebufferfi)(GLuint framebuffer, GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil);
	typedef GLvoid (GLAPI * PROC_glBlitNamedFramebuffer)(GLuint readFramebuffer, GLuint drawFramebuffer, GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);
	typedef GLenum (GLAPI * PROC_glCheckNamedFramebufferStatus)(GLuint framebuffer, GLenum target);
	typedef GLvoid (GLAPI * PROC_glGetNamedFramebufferParameteriv)(GLuint framebuffer, GLenum pname, GLint * param);
	typedef GLvoid (GLAPI * PROC_glGetNamedFramebufferAttachmentParameteriv)(GLuint framebuffer, GLenum attachment, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glCreateRenderbuffers)(GLsizei n, GLuint * renderbuffers);
	typedef GLvoid (GLAPI * PROC_glNamedRenderbufferStorage)(GLuint renderbuffer, GLenum internalformat, GLsizei width, GLsizei height);
	typedef GLvoid (GLAPI * PROC_glNamedRenderbufferStorageMultisample)(GLuint renderbuffer, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
	typedef GLvoid (GLAPI * PROC_glGetNamedRenderbufferParameteriv)(GLuint renderbuffer, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glCreateTextures)(GLenum target, GLsizei n, GLuint * textures);
	typedef GLvoid (GLAPI * PROC_glTextureBuffer)(GLuint texture, GLenum internalformat, GLuint buffer);
	typedef GLvoid (GLAPI * PROC_glTextureBufferRange)(GLuint texture, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size);
	typedef GLvoid (GLAPI * PROC_glTextureStorage1D)(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width);
	typedef GLvoid (GLAPI * PROC_glTextureStorage2D)(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
	typedef GLvoid (GLAPI * PROC_glTextureStorage3D)(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);
	typedef GLvoid (GLAPI * PROC_glTextureStorage2DMultisample)(GLuint texture, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);
	typedef GLvoid (GLAPI * PROC_glTextureStorage3DMultisample)(GLuint texture, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);
	typedef GLvoid (GLAPI * PROC_glTextureSubImage1D)(GLuint texture, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid * pixels);
	typedef GLvoid (GLAPI * PROC_glTextureSubImage2D)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * pixels);
	typedef GLvoid (GLAPI * PROC_glTextureSubImage3D)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid * pixels);
	typedef GLvoid (GLAPI * PROC_glCompressedTextureSubImage1D)(GLuint texture, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid * data);
	typedef GLvoid (GLAPI * PROC_glCompressedTextureSubImage2D)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid * data);
	typedef GLvoid (GLAPI * PROC_glCompressedTextureSubImage3D)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid * data);
	typedef GLvoid (GLAPI * PROC_glCopyTextureSubImage1D)(GLuint texture, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
	typedef GLvoid (GLAPI * PROC_glCopyTextureSubImage2D)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
	typedef GLvoid (GLAPI * PROC_glCopyTextureSubImage3D)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
	typedef GLvoid (GLAPI * PROC_glTextureParameterf)(GLuint texture, GLenum pname, GLfloat param);
	typedef GLvoid (GLAPI * PROC_glTextureParameterfv)(GLuint texture, GLenum pname, const GLfloat * param);
	typedef GLvoid (GLAPI * PROC_glTextureParameteri)(GLuint texture, GLenum pname, GLint param);
	typedef GLvoid (GLAPI * PROC_glTextureParameterIiv)(GLuint texture, GLenum pname, const GLint * params);
	typedef GLvoid (GLAPI * PROC_glTextureParameterIuiv)(GLuint texture, GLenum pname, const GLuint * params);
	typedef GLvoid (GLAPI * PROC_glTextureParameteriv)(GLuint texture, GLenum pname, const GLint * param);
	typedef GLvoid (GLAPI * PROC_glGenerateTextureMipmap)(GLuint texture);
	typedef GLvoid (GLAPI * PROC_glBindTextureUnit)(GLuint unit, GLuint texture);
	typedef GLvoid (GLAPI * PROC_glGetTextureImage)(GLuint texture, GLint level, GLenum format, GLenum type, GLsizei bufSize, GLvoid * pixels);
	typedef GLvoid (GLAPI * PROC_glGetCompressedTextureImage)(GLuint texture, GLint level, GLsizei bufSize, GLvoid * pixels);
	typedef GLvoid (GLAPI * PROC_glGetTextureLevelParameterfv)(GLuint texture, GLint level, GLenum pname, GLfloat * params);
	typedef GLvoid (GLAPI * PROC_glGetTextureLevelParameteriv)(GLuint texture, GLint level, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glGetTextureParameterfv)(GLuint texture, GLenum pname, GLfloat * params);
	typedef GLvoid (GLAPI * PROC_glGetTextureParameterIiv)(GLuint texture, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glGetTextureParameterIuiv)(GLuint texture, GLenum pname, GLuint * params);
	typedef GLvoid (GLAPI * PROC_glGetTextureParameteriv)(GLuint texture, GLenum pname, GLint * params);
	typedef GLvoid (GLAPI * PROC_glCreateVertexArrays)(GLsizei n, GLuint * arrays);
	typedef GLvoid (GLAPI * PROC_glDisableVertexArrayAttrib)(GLuint vaobj, GLuint index);
	typedef GLvoid (GLAPI * PROC_glEnableVertexArrayAttrib)(GLuint vaobj, GLuint index);
	typedef GLvoid (GLAPI * PROC_glVertexArrayElementBuffer)(GLuint vaobj, GLuint buffer);
	typedef GLvoid (GLAPI * PROC_glVertexArrayVertexBuffer)(GLuint vaobj, GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride);
	typedef GLvoid (GLAPI * PROC_glVertexArrayVertexBuffers)(GLuint vaobj, GLuint first, GLsizei count, const GLuint * buffers, const GLintptr * offsets, const GLsizei * strides);
	typedef GLvoid (GLAPI * PROC_glVertexArrayAttribBinding)(GLuint vaobj, GLuint attribindex, GLuint bindingindex);
	typedef GLvoid (GLAPI * PROC_glVertexArrayAttribFormat)(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset);
	typedef GLvoid (GLAPI * PROC_glVertexArrayAttribIFormat)(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
	typedef GLvoid (GLAPI * PROC_glVertexArrayAttribLFormat)(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
	typedef GLvoid (GLAPI * PROC_glVertexArrayBindingDivisor)(GLuint vaobj, GLuint bindingindex, GLuint divisor);
	typedef GLvoid (GLAPI * PROC_glGetVertexArrayiv)(GLuint vaobj, GLenum pname, GLint * param);
	typedef GLvoid (GLAPI * PROC_glGetVertexArrayIndexediv)(GLuint vaobj, GLuint index, GLenum pname, GLint * param);
	typedef GLvoid (GLAPI * PROC_glGetVertexArrayIndexed64iv)(GLuint vaobj, GLuint index, GLenum pname, GLint64 * param);
	typedef GLvoid (GLAPI * PROC_glCreateSamplers)(GLsizei n, GLuint * samplers);
	typedef GLvoid (GLAPI * PROC_glCreateProgramPipelines)(GLsizei n, GLuint * pipelines);
	typedef GLvoid (GLAPI * PROC_glCreateQueries)(GLenum target, GLsizei n, GLuint * ids);
	typedef GLvoid (GLAPI * PROC_glGetQueryBufferObjecti64v)(GLuint id, GLuint buffer, GLenum pname, GLintptr offset);
	typedef GLvoid (GLAPI * PROC_glGetQueryBufferObjectiv)(GLuint id, GLuint buffer, GLenum pname, GLintptr offset);
	typedef GLvoid (GLAPI * PROC_glGetQueryBufferObjectui64v)(GLuint id, GLuint buffer, GLenum pname, GLintptr offset);
	typedef GLvoid (GLAPI * PROC_glGetQueryBufferObjectuiv)(GLuint id, GLuint buffer, GLenum pname, GLintptr offset);
	typedef GLvoid (GLAPI * PROC_glMemoryBarrierByRegion)(GLbitfield barriers);
	typedef GLvoid (GLAPI * PROC_glGetTextureSubImage)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, GLsizei bufSize, GLvoid * pixels);
	typedef GLvoid (GLAPI * PROC_glGetCompressedTextureSubImage)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLsizei bufSize, GLvoid * pixels);
	typedef GLenum (GLAPI * PROC_glGetGraphicsResetStatus)();
	typedef GLvoid (GLAPI * PROC_glGetnCompressedTexImage)(GLenum target, GLint lod, GLsizei bufSize, GLvoid * pixels);
	typedef GLvoid (GLAPI * PROC_glGetnTexImage)(GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, GLvoid * pixels);
	typedef GLvoid (GLAPI * PROC_glGetnUniformdv)(GLuint program, GLint location, GLsizei bufSize, GLdouble * params);
	typedef GLvoid (GLAPI * PROC_glGetnUniformfv)(GLuint program, GLint location, GLsizei bufSize, GLfloat * params);
	typedef GLvoid (GLAPI * PROC_glGetnUniformiv)(GLuint program, GLint location, GLsizei bufSize, GLint * params);
	typedef GLvoid (GLAPI * PROC_glGetnUniformuiv)(GLuint program, GLint location, GLsizei bufSize, GLuint * params);
	typedef GLvoid (GLAPI * PROC_glReadnPixels)(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, GLvoid * data);
	typedef GLvoid (GLAPI * PROC_glTextureBarrier)();
	
	extern PROC_glCullFace glCullFace;
	extern PROC_glFrontFace glFrontFace;
	extern PROC_glHint glHint;
	extern PROC_glLineWidth glLineWidth;
	extern PROC_glPointSize glPointSize;
	extern PROC_glPolygonMode glPolygonMode;
	extern PROC_glScissor glScissor;
	extern PROC_glTexParameterf glTexParameterf;
	extern PROC_glTexParameterfv glTexParameterfv;
	extern PROC_glTexParameteri glTexParameteri;
	extern PROC_glTexParameteriv glTexParameteriv;
	extern PROC_glTexImage1D glTexImage1D;
	extern PROC_glTexImage2D glTexImage2D;
	extern PROC_glDrawBuffer glDrawBuffer;
	extern PROC_glClear glClear;
	extern PROC_glClearColor glClearColor;
	extern PROC_glClearStencil glClearStencil;
	extern PROC_glClearDepth glClearDepth;
	extern PROC_glStencilMask glStencilMask;
	extern PROC_glColorMask glColorMask;
	extern PROC_glDepthMask glDepthMask;
	extern PROC_glDisable glDisable;
	extern PROC_glEnable glEnable;
	extern PROC_glFinish glFinish;
	extern PROC_glFlush glFlush;
	extern PROC_glBlendFunc glBlendFunc;
	extern PROC_glLogicOp glLogicOp;
	extern PROC_glStencilFunc glStencilFunc;
	extern PROC_glStencilOp glStencilOp;
	extern PROC_glDepthFunc glDepthFunc;
	extern PROC_glPixelStoref glPixelStoref;
	extern PROC_glPixelStorei glPixelStorei;
	extern PROC_glReadBuffer glReadBuffer;
	extern PROC_glReadPixels glReadPixels;
	extern PROC_glGetBooleanv glGetBooleanv;
	extern PROC_glGetDoublev glGetDoublev;
	extern PROC_glGetError glGetError;
	extern PROC_glGetFloatv glGetFloatv;
	extern PROC_glGetIntegerv glGetIntegerv;
	extern PROC_glGetString glGetString;
	extern PROC_glGetTexImage glGetTexImage;
	extern PROC_glGetTexParameterfv glGetTexParameterfv;
	extern PROC_glGetTexParameteriv glGetTexParameteriv;
	extern PROC_glGetTexLevelParameterfv glGetTexLevelParameterfv;
	extern PROC_glGetTexLevelParameteriv glGetTexLevelParameteriv;
	extern PROC_glIsEnabled glIsEnabled;
	extern PROC_glDepthRange glDepthRange;
	extern PROC_glViewport glViewport;
	extern PROC_glDrawArrays glDrawArrays;
	extern PROC_glDrawElements glDrawElements;
	extern PROC_glGetPointerv glGetPointerv;
	extern PROC_glPolygonOffset glPolygonOffset;
	extern PROC_glCopyTexImage1D glCopyTexImage1D;
	extern PROC_glCopyTexImage2D glCopyTexImage2D;
	extern PROC_glCopyTexSubImage1D glCopyTexSubImage1D;
	extern PROC_glCopyTexSubImage2D glCopyTexSubImage2D;
	extern PROC_glTexSubImage1D glTexSubImage1D;
	extern PROC_glTexSubImage2D glTexSubImage2D;
	extern PROC_glBindTexture glBindTexture;
	extern PROC_glDeleteTextures glDeleteTextures;
	extern PROC_glGenTextures glGenTextures;
	extern PROC_glIsTexture glIsTexture;
	extern PROC_glDrawRangeElements glDrawRangeElements;
	extern PROC_glTexImage3D glTexImage3D;
	extern PROC_glTexSubImage3D glTexSubImage3D;
	extern PROC_glCopyTexSubImage3D glCopyTexSubImage3D;
	extern PROC_glActiveTexture glActiveTexture;
	extern PROC_glSampleCoverage glSampleCoverage;
	extern PROC_glCompressedTexImage3D glCompressedTexImage3D;
	extern PROC_glCompressedTexImage2D glCompressedTexImage2D;
	extern PROC_glCompressedTexImage1D glCompressedTexImage1D;
	extern PROC_glCompressedTexSubImage3D glCompressedTexSubImage3D;
	extern PROC_glCompressedTexSubImage2D glCompressedTexSubImage2D;
	extern PROC_glCompressedTexSubImage1D glCompressedTexSubImage1D;
	extern PROC_glGetCompressedTexImage glGetCompressedTexImage;
	extern PROC_glBlendFuncSeparate glBlendFuncSeparate;
	extern PROC_glMultiDrawArrays glMultiDrawArrays;
	extern PROC_glMultiDrawElements glMultiDrawElements;
	extern PROC_glPointParameterf glPointParameterf;
	extern PROC_glPointParameterfv glPointParameterfv;
	extern PROC_glPointParameteri glPointParameteri;
	extern PROC_glPointParameteriv glPointParameteriv;
	extern PROC_glBlendColor glBlendColor;
	extern PROC_glBlendEquation glBlendEquation;
	extern PROC_glGenQueries glGenQueries;
	extern PROC_glDeleteQueries glDeleteQueries;
	extern PROC_glIsQuery glIsQuery;
	extern PROC_glBeginQuery glBeginQuery;
	extern PROC_glEndQuery glEndQuery;
	extern PROC_glGetQueryiv glGetQueryiv;
	extern PROC_glGetQueryObjectiv glGetQueryObjectiv;
	extern PROC_glGetQueryObjectuiv glGetQueryObjectuiv;
	extern PROC_glBindBuffer glBindBuffer;
	extern PROC_glDeleteBuffers glDeleteBuffers;
	extern PROC_glGenBuffers glGenBuffers;
	extern PROC_glIsBuffer glIsBuffer;
	extern PROC_glBufferData glBufferData;
	extern PROC_glBufferSubData glBufferSubData;
	extern PROC_glGetBufferSubData glGetBufferSubData;
	extern PROC_glMapBuffer glMapBuffer;
	extern PROC_glUnmapBuffer glUnmapBuffer;
	extern PROC_glGetBufferParameteriv glGetBufferParameteriv;
	extern PROC_glGetBufferPointerv glGetBufferPointerv;
	extern PROC_glBlendEquationSeparate glBlendEquationSeparate;
	extern PROC_glDrawBuffers glDrawBuffers;
	extern PROC_glStencilOpSeparate glStencilOpSeparate;
	extern PROC_glStencilFuncSeparate glStencilFuncSeparate;
	extern PROC_glStencilMaskSeparate glStencilMaskSeparate;
	extern PROC_glAttachShader glAttachShader;
	extern PROC_glBindAttribLocation glBindAttribLocation;
	extern PROC_glCompileShader glCompileShader;
	extern PROC_glCreateProgram glCreateProgram;
	extern PROC_glCreateShader glCreateShader;
	extern PROC_glDeleteProgram glDeleteProgram;
	extern PROC_glDeleteShader glDeleteShader;
	extern PROC_glDetachShader glDetachShader;
	extern PROC_glDisableVertexAttribArray glDisableVertexAttribArray;
	extern PROC_glEnableVertexAttribArray glEnableVertexAttribArray;
	extern PROC_glGetActiveAttrib glGetActiveAttrib;
	extern PROC_glGetActiveUniform glGetActiveUniform;
	extern PROC_glGetAttachedShaders glGetAttachedShaders;
	extern PROC_glGetAttribLocation glGetAttribLocation;
	extern PROC_glGetProgramiv glGetProgramiv;
	extern PROC_glGetProgramInfoLog glGetProgramInfoLog;
	extern PROC_glGetShaderiv glGetShaderiv;
	extern PROC_glGetShaderInfoLog glGetShaderInfoLog;
	extern PROC_glGetShaderSource glGetShaderSource;
	extern PROC_glGetUniformLocation glGetUniformLocation;
	extern PROC_glGetUniformfv glGetUniformfv;
	extern PROC_glGetUniformiv glGetUniformiv;
	extern PROC_glGetVertexAttribdv glGetVertexAttribdv;
	extern PROC_glGetVertexAttribfv glGetVertexAttribfv;
	extern PROC_glGetVertexAttribiv glGetVertexAttribiv;
	extern PROC_glGetVertexAttribPointerv glGetVertexAttribPointerv;
	extern PROC_glIsProgram glIsProgram;
	extern PROC_glIsShader glIsShader;
	extern PROC_glLinkProgram glLinkProgram;
	extern PROC_glShaderSource glShaderSource;
	extern PROC_glUseProgram glUseProgram;
	extern PROC_glUniform1f glUniform1f;
	extern PROC_glUniform2f glUniform2f;
	extern PROC_glUniform3f glUniform3f;
	extern PROC_glUniform4f glUniform4f;
	extern PROC_glUniform1i glUniform1i;
	extern PROC_glUniform2i glUniform2i;
	extern PROC_glUniform3i glUniform3i;
	extern PROC_glUniform4i glUniform4i;
	extern PROC_glUniform1fv glUniform1fv;
	extern PROC_glUniform2fv glUniform2fv;
	extern PROC_glUniform3fv glUniform3fv;
	extern PROC_glUniform4fv glUniform4fv;
	extern PROC_glUniform1iv glUniform1iv;
	extern PROC_glUniform2iv glUniform2iv;
	extern PROC_glUniform3iv glUniform3iv;
	extern PROC_glUniform4iv glUniform4iv;
	extern PROC_glUniformMatrix2fv glUniformMatrix2fv;
	extern PROC_glUniformMatrix3fv glUniformMatrix3fv;
	extern PROC_glUniformMatrix4fv glUniformMatrix4fv;
	extern PROC_glValidateProgram glValidateProgram;
	extern PROC_glVertexAttrib1d glVertexAttrib1d;
	extern PROC_glVertexAttrib1dv glVertexAttrib1dv;
	extern PROC_glVertexAttrib1f glVertexAttrib1f;
	extern PROC_glVertexAttrib1fv glVertexAttrib1fv;
	extern PROC_glVertexAttrib1s glVertexAttrib1s;
	extern PROC_glVertexAttrib1sv glVertexAttrib1sv;
	extern PROC_glVertexAttrib2d glVertexAttrib2d;
	extern PROC_glVertexAttrib2dv glVertexAttrib2dv;
	extern PROC_glVertexAttrib2f glVertexAttrib2f;
	extern PROC_glVertexAttrib2fv glVertexAttrib2fv;
	extern PROC_glVertexAttrib2s glVertexAttrib2s;
	extern PROC_glVertexAttrib2sv glVertexAttrib2sv;
	extern PROC_glVertexAttrib3d glVertexAttrib3d;
	extern PROC_glVertexAttrib3dv glVertexAttrib3dv;
	extern PROC_glVertexAttrib3f glVertexAttrib3f;
	extern PROC_glVertexAttrib3fv glVertexAttrib3fv;
	extern PROC_glVertexAttrib3s glVertexAttrib3s;
	extern PROC_glVertexAttrib3sv glVertexAttrib3sv;
	extern PROC_glVertexAttrib4Nbv glVertexAttrib4Nbv;
	extern PROC_glVertexAttrib4Niv glVertexAttrib4Niv;
	extern PROC_glVertexAttrib4Nsv glVertexAttrib4Nsv;
	extern PROC_glVertexAttrib4Nub glVertexAttrib4Nub;
	extern PROC_glVertexAttrib4Nubv glVertexAttrib4Nubv;
	extern PROC_glVertexAttrib4Nuiv glVertexAttrib4Nuiv;
	extern PROC_glVertexAttrib4Nusv glVertexAttrib4Nusv;
	extern PROC_glVertexAttrib4bv glVertexAttrib4bv;
	extern PROC_glVertexAttrib4d glVertexAttrib4d;
	extern PROC_glVertexAttrib4dv glVertexAttrib4dv;
	extern PROC_glVertexAttrib4f glVertexAttrib4f;
	extern PROC_glVertexAttrib4fv glVertexAttrib4fv;
	extern PROC_glVertexAttrib4iv glVertexAttrib4iv;
	extern PROC_glVertexAttrib4s glVertexAttrib4s;
	extern PROC_glVertexAttrib4sv glVertexAttrib4sv;
	extern PROC_glVertexAttrib4ubv glVertexAttrib4ubv;
	extern PROC_glVertexAttrib4uiv glVertexAttrib4uiv;
	extern PROC_glVertexAttrib4usv glVertexAttrib4usv;
	extern PROC_glVertexAttribPointer glVertexAttribPointer;
	extern PROC_glUniformMatrix2x3fv glUniformMatrix2x3fv;
	extern PROC_glUniformMatrix3x2fv glUniformMatrix3x2fv;
	extern PROC_glUniformMatrix2x4fv glUniformMatrix2x4fv;
	extern PROC_glUniformMatrix4x2fv glUniformMatrix4x2fv;
	extern PROC_glUniformMatrix3x4fv glUniformMatrix3x4fv;
	extern PROC_glUniformMatrix4x3fv glUniformMatrix4x3fv;
	extern PROC_glColorMaski glColorMaski;
	extern PROC_glGetBooleani_v glGetBooleani_v;
	extern PROC_glGetIntegeri_v glGetIntegeri_v;
	extern PROC_glEnablei glEnablei;
	extern PROC_glDisablei glDisablei;
	extern PROC_glIsEnabledi glIsEnabledi;
	extern PROC_glBeginTransformFeedback glBeginTransformFeedback;
	extern PROC_glEndTransformFeedback glEndTransformFeedback;
	extern PROC_glBindBufferRange glBindBufferRange;
	extern PROC_glBindBufferBase glBindBufferBase;
	extern PROC_glTransformFeedbackVaryings glTransformFeedbackVaryings;
	extern PROC_glGetTransformFeedbackVarying glGetTransformFeedbackVarying;
	extern PROC_glClampColor glClampColor;
	extern PROC_glBeginConditionalRender glBeginConditionalRender;
	extern PROC_glEndConditionalRender glEndConditionalRender;
	extern PROC_glVertexAttribIPointer glVertexAttribIPointer;
	extern PROC_glGetVertexAttribIiv glGetVertexAttribIiv;
	extern PROC_glGetVertexAttribIuiv glGetVertexAttribIuiv;
	extern PROC_glVertexAttribI1i glVertexAttribI1i;
	extern PROC_glVertexAttribI2i glVertexAttribI2i;
	extern PROC_glVertexAttribI3i glVertexAttribI3i;
	extern PROC_glVertexAttribI4i glVertexAttribI4i;
	extern PROC_glVertexAttribI1ui glVertexAttribI1ui;
	extern PROC_glVertexAttribI2ui glVertexAttribI2ui;
	extern PROC_glVertexAttribI3ui glVertexAttribI3ui;
	extern PROC_glVertexAttribI4ui glVertexAttribI4ui;
	extern PROC_glVertexAttribI1iv glVertexAttribI1iv;
	extern PROC_glVertexAttribI2iv glVertexAttribI2iv;
	extern PROC_glVertexAttribI3iv glVertexAttribI3iv;
	extern PROC_glVertexAttribI4iv glVertexAttribI4iv;
	extern PROC_glVertexAttribI1uiv glVertexAttribI1uiv;
	extern PROC_glVertexAttribI2uiv glVertexAttribI2uiv;
	extern PROC_glVertexAttribI3uiv glVertexAttribI3uiv;
	extern PROC_glVertexAttribI4uiv glVertexAttribI4uiv;
	extern PROC_glVertexAttribI4bv glVertexAttribI4bv;
	extern PROC_glVertexAttribI4sv glVertexAttribI4sv;
	extern PROC_glVertexAttribI4ubv glVertexAttribI4ubv;
	extern PROC_glVertexAttribI4usv glVertexAttribI4usv;
	extern PROC_glGetUniformuiv glGetUniformuiv;
	extern PROC_glBindFragDataLocation glBindFragDataLocation;
	extern PROC_glGetFragDataLocation glGetFragDataLocation;
	extern PROC_glUniform1ui glUniform1ui;
	extern PROC_glUniform2ui glUniform2ui;
	extern PROC_glUniform3ui glUniform3ui;
	extern PROC_glUniform4ui glUniform4ui;
	extern PROC_glUniform1uiv glUniform1uiv;
	extern PROC_glUniform2uiv glUniform2uiv;
	extern PROC_glUniform3uiv glUniform3uiv;
	extern PROC_glUniform4uiv glUniform4uiv;
	extern PROC_glTexParameterIiv glTexParameterIiv;
	extern PROC_glTexParameterIuiv glTexParameterIuiv;
	extern PROC_glGetTexParameterIiv glGetTexParameterIiv;
	extern PROC_glGetTexParameterIuiv glGetTexParameterIuiv;
	extern PROC_glClearBufferiv glClearBufferiv;
	extern PROC_glClearBufferuiv glClearBufferuiv;
	extern PROC_glClearBufferfv glClearBufferfv;
	extern PROC_glClearBufferfi glClearBufferfi;
	extern PROC_glGetStringi glGetStringi;
	extern PROC_glIsRenderbuffer glIsRenderbuffer;
	extern PROC_glBindRenderbuffer glBindRenderbuffer;
	extern PROC_glDeleteRenderbuffers glDeleteRenderbuffers;
	extern PROC_glGenRenderbuffers glGenRenderbuffers;
	extern PROC_glRenderbufferStorage glRenderbufferStorage;
	extern PROC_glGetRenderbufferParameteriv glGetRenderbufferParameteriv;
	extern PROC_glIsFramebuffer glIsFramebuffer;
	extern PROC_glBindFramebuffer glBindFramebuffer;
	extern PROC_glDeleteFramebuffers glDeleteFramebuffers;
	extern PROC_glGenFramebuffers glGenFramebuffers;
	extern PROC_glCheckFramebufferStatus glCheckFramebufferStatus;
	extern PROC_glFramebufferTexture1D glFramebufferTexture1D;
	extern PROC_glFramebufferTexture2D glFramebufferTexture2D;
	extern PROC_glFramebufferTexture3D glFramebufferTexture3D;
	extern PROC_glFramebufferRenderbuffer glFramebufferRenderbuffer;
	extern PROC_glGetFramebufferAttachmentParameteriv glGetFramebufferAttachmentParameteriv;
	extern PROC_glGenerateMipmap glGenerateMipmap;
	extern PROC_glBlitFramebuffer glBlitFramebuffer;
	extern PROC_glRenderbufferStorageMultisample glRenderbufferStorageMultisample;
	extern PROC_glFramebufferTextureLayer glFramebufferTextureLayer;
	extern PROC_glMapBufferRange glMapBufferRange;
	extern PROC_glFlushMappedBufferRange glFlushMappedBufferRange;
	extern PROC_glBindVertexArray glBindVertexArray;
	extern PROC_glDeleteVertexArrays glDeleteVertexArrays;
	extern PROC_glGenVertexArrays glGenVertexArrays;
	extern PROC_glIsVertexArray glIsVertexArray;
	extern PROC_glDrawArraysInstanced glDrawArraysInstanced;
	extern PROC_glDrawElementsInstanced glDrawElementsInstanced;
	extern PROC_glTexBuffer glTexBuffer;
	extern PROC_glPrimitiveRestartIndex glPrimitiveRestartIndex;
	extern PROC_glCopyBufferSubData glCopyBufferSubData;
	extern PROC_glGetUniformIndices glGetUniformIndices;
	extern PROC_glGetActiveUniformsiv glGetActiveUniformsiv;
	extern PROC_glGetActiveUniformName glGetActiveUniformName;
	extern PROC_glGetUniformBlockIndex glGetUniformBlockIndex;
	extern PROC_glGetActiveUniformBlockiv glGetActiveUniformBlockiv;
	extern PROC_glGetActiveUniformBlockName glGetActiveUniformBlockName;
	extern PROC_glUniformBlockBinding glUniformBlockBinding;
	extern PROC_glDrawElementsBaseVertex glDrawElementsBaseVertex;
	extern PROC_glDrawRangeElementsBaseVertex glDrawRangeElementsBaseVertex;
	extern PROC_glDrawElementsInstancedBaseVertex glDrawElementsInstancedBaseVertex;
	extern PROC_glMultiDrawElementsBaseVertex glMultiDrawElementsBaseVertex;
	extern PROC_glProvokingVertex glProvokingVertex;
	extern PROC_glFenceSync glFenceSync;
	extern PROC_glIsSync glIsSync;
	extern PROC_glDeleteSync glDeleteSync;
	extern PROC_glClientWaitSync glClientWaitSync;
	extern PROC_glWaitSync glWaitSync;
	extern PROC_glGetInteger64v glGetInteger64v;
	extern PROC_glGetSynciv glGetSynciv;
	extern PROC_glGetInteger64i_v glGetInteger64i_v;
	extern PROC_glGetBufferParameteri64v glGetBufferParameteri64v;
	extern PROC_glFramebufferTexture glFramebufferTexture;
	extern PROC_glTexImage2DMultisample glTexImage2DMultisample;
	extern PROC_glTexImage3DMultisample glTexImage3DMultisample;
	extern PROC_glGetMultisamplefv glGetMultisamplefv;
	extern PROC_glSampleMaski glSampleMaski;
	extern PROC_glBindFragDataLocationIndexed glBindFragDataLocationIndexed;
	extern PROC_glGetFragDataIndex glGetFragDataIndex;
	extern PROC_glGenSamplers glGenSamplers;
	extern PROC_glDeleteSamplers glDeleteSamplers;
	extern PROC_glIsSampler glIsSampler;
	extern PROC_glBindSampler glBindSampler;
	extern PROC_glSamplerParameteri glSamplerParameteri;
	extern PROC_glSamplerParameteriv glSamplerParameteriv;
	extern PROC_glSamplerParameterf glSamplerParameterf;
	extern PROC_glSamplerParameterfv glSamplerParameterfv;
	extern PROC_glSamplerParameterIiv glSamplerParameterIiv;
	extern PROC_glSamplerParameterIuiv glSamplerParameterIuiv;
	extern PROC_glGetSamplerParameteriv glGetSamplerParameteriv;
	extern PROC_glGetSamplerParameterIiv glGetSamplerParameterIiv;
	extern PROC_glGetSamplerParameterfv glGetSamplerParameterfv;
	extern PROC_glGetSamplerParameterIuiv glGetSamplerParameterIuiv;
	extern PROC_glQueryCounter glQueryCounter;
	extern PROC_glGetQueryObjecti64v glGetQueryObjecti64v;
	extern PROC_glGetQueryObjectui64v glGetQueryObjectui64v;
	extern PROC_glVertexAttribDivisor glVertexAttribDivisor;
	extern PROC_glVertexAttribP1ui glVertexAttribP1ui;
	extern PROC_glVertexAttribP1uiv glVertexAttribP1uiv;
	extern PROC_glVertexAttribP2ui glVertexAttribP2ui;
	extern PROC_glVertexAttribP2uiv glVertexAttribP2uiv;
	extern PROC_glVertexAttribP3ui glVertexAttribP3ui;
	extern PROC_glVertexAttribP3uiv glVertexAttribP3uiv;
	extern PROC_glVertexAttribP4ui glVertexAttribP4ui;
	extern PROC_glVertexAttribP4uiv glVertexAttribP4uiv;
	extern PROC_glMinSampleShading glMinSampleShading;
	extern PROC_glBlendEquationi glBlendEquationi;
	extern PROC_glBlendEquationSeparatei glBlendEquationSeparatei;
	extern PROC_glBlendFunci glBlendFunci;
	extern PROC_glBlendFuncSeparatei glBlendFuncSeparatei;
	extern PROC_glDrawArraysIndirect glDrawArraysIndirect;
	extern PROC_glDrawElementsIndirect glDrawElementsIndirect;
	extern PROC_glUniform1d glUniform1d;
	extern PROC_glUniform2d glUniform2d;
	extern PROC_glUniform3d glUniform3d;
	extern PROC_glUniform4d glUniform4d;
	extern PROC_glUniform1dv glUniform1dv;
	extern PROC_glUniform2dv glUniform2dv;
	extern PROC_glUniform3dv glUniform3dv;
	extern PROC_glUniform4dv glUniform4dv;
	extern PROC_glUniformMatrix2dv glUniformMatrix2dv;
	extern PROC_glUniformMatrix3dv glUniformMatrix3dv;
	extern PROC_glUniformMatrix4dv glUniformMatrix4dv;
	extern PROC_glUniformMatrix2x3dv glUniformMatrix2x3dv;
	extern PROC_glUniformMatrix2x4dv glUniformMatrix2x4dv;
	extern PROC_glUniformMatrix3x2dv glUniformMatrix3x2dv;
	extern PROC_glUniformMatrix3x4dv glUniformMatrix3x4dv;
	extern PROC_glUniformMatrix4x2dv glUniformMatrix4x2dv;
	extern PROC_glUniformMatrix4x3dv glUniformMatrix4x3dv;
	extern PROC_glGetUniformdv glGetUniformdv;
	extern PROC_glGetSubroutineUniformLocation glGetSubroutineUniformLocation;
	extern PROC_glGetSubroutineIndex glGetSubroutineIndex;
	extern PROC_glGetActiveSubroutineUniformiv glGetActiveSubroutineUniformiv;
	extern PROC_glGetActiveSubroutineUniformName glGetActiveSubroutineUniformName;
	extern PROC_glGetActiveSubroutineName glGetActiveSubroutineName;
	extern PROC_glUniformSubroutinesuiv glUniformSubroutinesuiv;
	extern PROC_glGetUniformSubroutineuiv glGetUniformSubroutineuiv;
	extern PROC_glGetProgramStageiv glGetProgramStageiv;
	extern PROC_glPatchParameteri glPatchParameteri;
	extern PROC_glPatchParameterfv glPatchParameterfv;
	extern PROC_glBindTransformFeedback glBindTransformFeedback;
	extern PROC_glDeleteTransformFeedbacks glDeleteTransformFeedbacks;
	extern PROC_glGenTransformFeedbacks glGenTransformFeedbacks;
	extern PROC_glIsTransformFeedback glIsTransformFeedback;
	extern PROC_glPauseTransformFeedback glPauseTransformFeedback;
	extern PROC_glResumeTransformFeedback glResumeTransformFeedback;
	extern PROC_glDrawTransformFeedback glDrawTransformFeedback;
	extern PROC_glDrawTransformFeedbackStream glDrawTransformFeedbackStream;
	extern PROC_glBeginQueryIndexed glBeginQueryIndexed;
	extern PROC_glEndQueryIndexed glEndQueryIndexed;
	extern PROC_glGetQueryIndexediv glGetQueryIndexediv;
	extern PROC_glReleaseShaderCompiler glReleaseShaderCompiler;
	extern PROC_glShaderBinary glShaderBinary;
	extern PROC_glGetShaderPrecisionFormat glGetShaderPrecisionFormat;
	extern PROC_glDepthRangef glDepthRangef;
	extern PROC_glClearDepthf glClearDepthf;
	extern PROC_glGetProgramBinary glGetProgramBinary;
	extern PROC_glProgramBinary glProgramBinary;
	extern PROC_glProgramParameteri glProgramParameteri;
	extern PROC_glUseProgramStages glUseProgramStages;
	extern PROC_glActiveShaderProgram glActiveShaderProgram;
	extern PROC_glCreateShaderProgramv glCreateShaderProgramv;
	extern PROC_glBindProgramPipeline glBindProgramPipeline;
	extern PROC_glDeleteProgramPipelines glDeleteProgramPipelines;
	extern PROC_glGenProgramPipelines glGenProgramPipelines;
	extern PROC_glIsProgramPipeline glIsProgramPipeline;
	extern PROC_glGetProgramPipelineiv glGetProgramPipelineiv;
	extern PROC_glProgramUniform1i glProgramUniform1i;
	extern PROC_glProgramUniform1iv glProgramUniform1iv;
	extern PROC_glProgramUniform1f glProgramUniform1f;
	extern PROC_glProgramUniform1fv glProgramUniform1fv;
	extern PROC_glProgramUniform1d glProgramUniform1d;
	extern PROC_glProgramUniform1dv glProgramUniform1dv;
	extern PROC_glProgramUniform1ui glProgramUniform1ui;
	extern PROC_glProgramUniform1uiv glProgramUniform1uiv;
	extern PROC_glProgramUniform2i glProgramUniform2i;
	extern PROC_glProgramUniform2iv glProgramUniform2iv;
	extern PROC_glProgramUniform2f glProgramUniform2f;
	extern PROC_glProgramUniform2fv glProgramUniform2fv;
	extern PROC_glProgramUniform2d glProgramUniform2d;
	extern PROC_glProgramUniform2dv glProgramUniform2dv;
	extern PROC_glProgramUniform2ui glProgramUniform2ui;
	extern PROC_glProgramUniform2uiv glProgramUniform2uiv;
	extern PROC_glProgramUniform3i glProgramUniform3i;
	extern PROC_glProgramUniform3iv glProgramUniform3iv;
	extern PROC_glProgramUniform3f glProgramUniform3f;
	extern PROC_glProgramUniform3fv glProgramUniform3fv;
	extern PROC_glProgramUniform3d glProgramUniform3d;
	extern PROC_glProgramUniform3dv glProgramUniform3dv;
	extern PROC_glProgramUniform3ui glProgramUniform3ui;
	extern PROC_glProgramUniform3uiv glProgramUniform3uiv;
	extern PROC_glProgramUniform4i glProgramUniform4i;
	extern PROC_glProgramUniform4iv glProgramUniform4iv;
	extern PROC_glProgramUniform4f glProgramUniform4f;
	extern PROC_glProgramUniform4fv glProgramUniform4fv;
	extern PROC_glProgramUniform4d glProgramUniform4d;
	extern PROC_glProgramUniform4dv glProgramUniform4dv;
	extern PROC_glProgramUniform4ui glProgramUniform4ui;
	extern PROC_glProgramUniform4uiv glProgramUniform4uiv;
	extern PROC_glProgramUniformMatrix2fv glProgramUniformMatrix2fv;
	extern PROC_glProgramUniformMatrix3fv glProgramUniformMatrix3fv;
	extern PROC_glProgramUniformMatrix4fv glProgramUniformMatrix4fv;
	extern PROC_glProgramUniformMatrix2dv glProgramUniformMatrix2dv;
	extern PROC_glProgramUniformMatrix3dv glProgramUniformMatrix3dv;
	extern PROC_glProgramUniformMatrix4dv glProgramUniformMatrix4dv;
	extern PROC_glProgramUniformMatrix2x3fv glProgramUniformMatrix2x3fv;
	extern PROC_glProgramUniformMatrix3x2fv glProgramUniformMatrix3x2fv;
	extern PROC_glProgramUniformMatrix2x4fv glProgramUniformMatrix2x4fv;
	extern PROC_glProgramUniformMatrix4x2fv glProgramUniformMatrix4x2fv;
	extern PROC_glProgramUniformMatrix3x4fv glProgramUniformMatrix3x4fv;
	extern PROC_glProgramUniformMatrix4x3fv glProgramUniformMatrix4x3fv;
	extern PROC_glProgramUniformMatrix2x3dv glProgramUniformMatrix2x3dv;
	extern PROC_glProgramUniformMatrix3x2dv glProgramUniformMatrix3x2dv;
	extern PROC_glProgramUniformMatrix2x4dv glProgramUniformMatrix2x4dv;
	extern PROC_glProgramUniformMatrix4x2dv glProgramUniformMatrix4x2dv;
	extern PROC_glProgramUniformMatrix3x4dv glProgramUniformMatrix3x4dv;
	extern PROC_glProgramUniformMatrix4x3dv glProgramUniformMatrix4x3dv;
	extern PROC_glValidateProgramPipeline glValidateProgramPipeline;
	extern PROC_glGetProgramPipelineInfoLog glGetProgramPipelineInfoLog;
	extern PROC_glVertexAttribL1d glVertexAttribL1d;
	extern PROC_glVertexAttribL2d glVertexAttribL2d;
	extern PROC_glVertexAttribL3d glVertexAttribL3d;
	extern PROC_glVertexAttribL4d glVertexAttribL4d;
	extern PROC_glVertexAttribL1dv glVertexAttribL1dv;
	extern PROC_glVertexAttribL2dv glVertexAttribL2dv;
	extern PROC_glVertexAttribL3dv glVertexAttribL3dv;
	extern PROC_glVertexAttribL4dv glVertexAttribL4dv;
	extern PROC_glVertexAttribLPointer glVertexAttribLPointer;
	extern PROC_glGetVertexAttribLdv glGetVertexAttribLdv;
	extern PROC_glViewportArrayv glViewportArrayv;
	extern PROC_glViewportIndexedf glViewportIndexedf;
	extern PROC_glViewportIndexedfv glViewportIndexedfv;
	extern PROC_glScissorArrayv glScissorArrayv;
	extern PROC_glScissorIndexed glScissorIndexed;
	extern PROC_glScissorIndexedv glScissorIndexedv;
	extern PROC_glDepthRangeArrayv glDepthRangeArrayv;
	extern PROC_glDepthRangeIndexed glDepthRangeIndexed;
	extern PROC_glGetFloati_v glGetFloati_v;
	extern PROC_glGetDoublei_v glGetDoublei_v;
	extern PROC_glDrawArraysInstancedBaseInstance glDrawArraysInstancedBaseInstance;
	extern PROC_glDrawElementsInstancedBaseInstance glDrawElementsInstancedBaseInstance;
	extern PROC_glDrawElementsInstancedBaseVertexBaseInstance glDrawElementsInstancedBaseVertexBaseInstance;
	extern PROC_glGetInternalformativ glGetInternalformativ;
	extern PROC_glGetActiveAtomicCounterBufferiv glGetActiveAtomicCounterBufferiv;
	extern PROC_glBindImageTexture glBindImageTexture;
	extern PROC_glMemoryBarrier glMemoryBarrier;
	extern PROC_glTexStorage1D glTexStorage1D;
	extern PROC_glTexStorage2D glTexStorage2D;
	extern PROC_glTexStorage3D glTexStorage3D;
	extern PROC_glDrawTransformFeedbackInstanced glDrawTransformFeedbackInstanced;
	extern PROC_glDrawTransformFeedbackStreamInstanced glDrawTransformFeedbackStreamInstanced;
	extern PROC_glClearBufferData glClearBufferData;
	extern PROC_glClearBufferSubData glClearBufferSubData;
	extern PROC_glDispatchCompute glDispatchCompute;
	extern PROC_glDispatchComputeIndirect glDispatchComputeIndirect;
	extern PROC_glCopyImageSubData glCopyImageSubData;
	extern PROC_glFramebufferParameteri glFramebufferParameteri;
	extern PROC_glGetFramebufferParameteriv glGetFramebufferParameteriv;
	extern PROC_glGetInternalformati64v glGetInternalformati64v;
	extern PROC_glInvalidateTexSubImage glInvalidateTexSubImage;
	extern PROC_glInvalidateTexImage glInvalidateTexImage;
	extern PROC_glInvalidateBufferSubData glInvalidateBufferSubData;
	extern PROC_glInvalidateBufferData glInvalidateBufferData;
	extern PROC_glInvalidateFramebuffer glInvalidateFramebuffer;
	extern PROC_glInvalidateSubFramebuffer glInvalidateSubFramebuffer;
	extern PROC_glMultiDrawArraysIndirect glMultiDrawArraysIndirect;
	extern PROC_glMultiDrawElementsIndirect glMultiDrawElementsIndirect;
	extern PROC_glGetProgramInterfaceiv glGetProgramInterfaceiv;
	extern PROC_glGetProgramResourceIndex glGetProgramResourceIndex;
	extern PROC_glGetProgramResourceName glGetProgramResourceName;
	extern PROC_glGetProgramResourceiv glGetProgramResourceiv;
	extern PROC_glGetProgramResourceLocation glGetProgramResourceLocation;
	extern PROC_glGetProgramResourceLocationIndex glGetProgramResourceLocationIndex;
	extern PROC_glShaderStorageBlockBinding glShaderStorageBlockBinding;
	extern PROC_glTexBufferRange glTexBufferRange;
	extern PROC_glTexStorage2DMultisample glTexStorage2DMultisample;
	extern PROC_glTexStorage3DMultisample glTexStorage3DMultisample;
	extern PROC_glTextureView glTextureView;
	extern PROC_glBindVertexBuffer glBindVertexBuffer;
	extern PROC_glVertexAttribFormat glVertexAttribFormat;
	extern PROC_glVertexAttribIFormat glVertexAttribIFormat;
	extern PROC_glVertexAttribLFormat glVertexAttribLFormat;
	extern PROC_glVertexAttribBinding glVertexAttribBinding;
	extern PROC_glVertexBindingDivisor glVertexBindingDivisor;
	extern PROC_glDebugMessageControl glDebugMessageControl;
	extern PROC_glDebugMessageInsert glDebugMessageInsert;
	extern PROC_glDebugMessageCallback glDebugMessageCallback;
	extern PROC_glGetDebugMessageLog glGetDebugMessageLog;
	extern PROC_glPushDebugGroup glPushDebugGroup;
	extern PROC_glPopDebugGroup glPopDebugGroup;
	extern PROC_glObjectLabel glObjectLabel;
	extern PROC_glGetObjectLabel glGetObjectLabel;
	extern PROC_glObjectPtrLabel glObjectPtrLabel;
	extern PROC_glGetObjectPtrLabel glGetObjectPtrLabel;
	extern PROC_glBufferStorage glBufferStorage;
	extern PROC_glClearTexImage glClearTexImage;
	extern PROC_glClearTexSubImage glClearTexSubImage;
	extern PROC_glBindBuffersBase glBindBuffersBase;
	extern PROC_glBindBuffersRange glBindBuffersRange;
	extern PROC_glBindTextures glBindTextures;
	extern PROC_glBindSamplers glBindSamplers;
	extern PROC_glBindImageTextures glBindImageTextures;
	extern PROC_glBindVertexBuffers glBindVertexBuffers;
	extern PROC_glClipControl glClipControl;
	extern PROC_glCreateTransformFeedbacks glCreateTransformFeedbacks;
	extern PROC_glTransformFeedbackBufferBase glTransformFeedbackBufferBase;
	extern PROC_glTransformFeedbackBufferRange glTransformFeedbackBufferRange;
	extern PROC_glGetTransformFeedbackiv glGetTransformFeedbackiv;
	extern PROC_glGetTransformFeedbacki_v glGetTransformFeedbacki_v;
	extern PROC_glGetTransformFeedbacki64_v glGetTransformFeedbacki64_v;
	extern PROC_glCreateBuffers glCreateBuffers;
	extern PROC_glNamedBufferStorage glNamedBufferStorage;
	extern PROC_glNamedBufferData glNamedBufferData;
	extern PROC_glNamedBufferSubData glNamedBufferSubData;
	extern PROC_glCopyNamedBufferSubData glCopyNamedBufferSubData;
	extern PROC_glClearNamedBufferData glClearNamedBufferData;
	extern PROC_glClearNamedBufferSubData glClearNamedBufferSubData;
	extern PROC_glMapNamedBuffer glMapNamedBuffer;
	extern PROC_glMapNamedBufferRange glMapNamedBufferRange;
	extern PROC_glUnmapNamedBuffer glUnmapNamedBuffer;
	extern PROC_glFlushMappedNamedBufferRange glFlushMappedNamedBufferRange;
	extern PROC_glGetNamedBufferParameteriv glGetNamedBufferParameteriv;
	extern PROC_glGetNamedBufferParameteri64v glGetNamedBufferParameteri64v;
	extern PROC_glGetNamedBufferPointerv glGetNamedBufferPointerv;
	extern PROC_glGetNamedBufferSubData glGetNamedBufferSubData;
	extern PROC_glCreateFramebuffers glCreateFramebuffers;
	extern PROC_glNamedFramebufferRenderbuffer glNamedFramebufferRenderbuffer;
	extern PROC_glNamedFramebufferParameteri glNamedFramebufferParameteri;
	extern PROC_glNamedFramebufferTexture glNamedFramebufferTexture;
	extern PROC_glNamedFramebufferTextureLayer glNamedFramebufferTextureLayer;
	extern PROC_glNamedFramebufferDrawBuffer glNamedFramebufferDrawBuffer;
	extern PROC_glNamedFramebufferDrawBuffers glNamedFramebufferDrawBuffers;
	extern PROC_glNamedFramebufferReadBuffer glNamedFramebufferReadBuffer;
	extern PROC_glInvalidateNamedFramebufferData glInvalidateNamedFramebufferData;
	extern PROC_glInvalidateNamedFramebufferSubData glInvalidateNamedFramebufferSubData;
	extern PROC_glClearNamedFramebufferiv glClearNamedFramebufferiv;
	extern PROC_glClearNamedFramebufferuiv glClearNamedFramebufferuiv;
	extern PROC_glClearNamedFramebufferfv glClearNamedFramebufferfv;
	extern PROC_glClearNamedFramebufferfi glClearNamedFramebufferfi;
	extern PROC_glBlitNamedFramebuffer glBlitNamedFramebuffer;
	extern PROC_glCheckNamedFramebufferStatus glCheckNamedFramebufferStatus;
	extern PROC_glGetNamedFramebufferParameteriv glGetNamedFramebufferParameteriv;
	extern PROC_glGetNamedFramebufferAttachmentParameteriv glGetNamedFramebufferAttachmentParameteriv;
	extern PROC_glCreateRenderbuffers glCreateRenderbuffers;
	extern PROC_glNamedRenderbufferStorage glNamedRenderbufferStorage;
	extern PROC_glNamedRenderbufferStorageMultisample glNamedRenderbufferStorageMultisample;
	extern PROC_glGetNamedRenderbufferParameteriv glGetNamedRenderbufferParameteriv;
	extern PROC_glCreateTextures glCreateTextures;
	extern PROC_glTextureBuffer glTextureBuffer;
	extern PROC_glTextureBufferRange glTextureBufferRange;
	extern PROC_glTextureStorage1D glTextureStorage1D;
	extern PROC_glTextureStorage2D glTextureStorage2D;
	extern PROC_glTextureStorage3D glTextureStorage3D;
	extern PROC_glTextureStorage2DMultisample glTextureStorage2DMultisample;
	extern PROC_glTextureStorage3DMultisample glTextureStorage3DMultisample;
	extern PROC_glTextureSubImage1D glTextureSubImage1D;
	extern PROC_glTextureSubImage2D glTextureSubImage2D;
	extern PROC_glTextureSubImage3D glTextureSubImage3D;
	extern PROC_glCompressedTextureSubImage1D glCompressedTextureSubImage1D;
	extern PROC_glCompressedTextureSubImage2D glCompressedTextureSubImage2D;
	extern PROC_glCompressedTextureSubImage3D glCompressedTextureSubImage3D;
	extern PROC_glCopyTextureSubImage1D glCopyTextureSubImage1D;
	extern PROC_glCopyTextureSubImage2D glCopyTextureSubImage2D;
	extern PROC_glCopyTextureSubImage3D glCopyTextureSubImage3D;
	extern PROC_glTextureParameterf glTextureParameterf;
	extern PROC_glTextureParameterfv glTextureParameterfv;
	extern PROC_glTextureParameteri glTextureParameteri;
	extern PROC_glTextureParameterIiv glTextureParameterIiv;
	extern PROC_glTextureParameterIuiv glTextureParameterIuiv;
	extern PROC_glTextureParameteriv glTextureParameteriv;
	extern PROC_glGenerateTextureMipmap glGenerateTextureMipmap;
	extern PROC_glBindTextureUnit glBindTextureUnit;
	extern PROC_glGetTextureImage glGetTextureImage;
	extern PROC_glGetCompressedTextureImage glGetCompressedTextureImage;
	extern PROC_glGetTextureLevelParameterfv glGetTextureLevelParameterfv;
	extern PROC_glGetTextureLevelParameteriv glGetTextureLevelParameteriv;
	extern PROC_glGetTextureParameterfv glGetTextureParameterfv;
	extern PROC_glGetTextureParameterIiv glGetTextureParameterIiv;
	extern PROC_glGetTextureParameterIuiv glGetTextureParameterIuiv;
	extern PROC_glGetTextureParameteriv glGetTextureParameteriv;
	extern PROC_glCreateVertexArrays glCreateVertexArrays;
	extern PROC_glDisableVertexArrayAttrib glDisableVertexArrayAttrib;
	extern PROC_glEnableVertexArrayAttrib glEnableVertexArrayAttrib;
	extern PROC_glVertexArrayElementBuffer glVertexArrayElementBuffer;
	extern PROC_glVertexArrayVertexBuffer glVertexArrayVertexBuffer;
	extern PROC_glVertexArrayVertexBuffers glVertexArrayVertexBuffers;
	extern PROC_glVertexArrayAttribBinding glVertexArrayAttribBinding;
	extern PROC_glVertexArrayAttribFormat glVertexArrayAttribFormat;
	extern PROC_glVertexArrayAttribIFormat glVertexArrayAttribIFormat;
	extern PROC_glVertexArrayAttribLFormat glVertexArrayAttribLFormat;
	extern PROC_glVertexArrayBindingDivisor glVertexArrayBindingDivisor;
	extern PROC_glGetVertexArrayiv glGetVertexArrayiv;
	extern PROC_glGetVertexArrayIndexediv glGetVertexArrayIndexediv;
	extern PROC_glGetVertexArrayIndexed64iv glGetVertexArrayIndexed64iv;
	extern PROC_glCreateSamplers glCreateSamplers;
	extern PROC_glCreateProgramPipelines glCreateProgramPipelines;
	extern PROC_glCreateQueries glCreateQueries;
	extern PROC_glGetQueryBufferObjecti64v glGetQueryBufferObjecti64v;
	extern PROC_glGetQueryBufferObjectiv glGetQueryBufferObjectiv;
	extern PROC_glGetQueryBufferObjectui64v glGetQueryBufferObjectui64v;
	extern PROC_glGetQueryBufferObjectuiv glGetQueryBufferObjectuiv;
	extern PROC_glMemoryBarrierByRegion glMemoryBarrierByRegion;
	extern PROC_glGetTextureSubImage glGetTextureSubImage;
	extern PROC_glGetCompressedTextureSubImage glGetCompressedTextureSubImage;
	extern PROC_glGetGraphicsResetStatus glGetGraphicsResetStatus;
	extern PROC_glGetnCompressedTexImage glGetnCompressedTexImage;
	extern PROC_glGetnTexImage glGetnTexImage;
	extern PROC_glGetnUniformdv glGetnUniformdv;
	extern PROC_glGetnUniformfv glGetnUniformfv;
	extern PROC_glGetnUniformiv glGetnUniformiv;
	extern PROC_glGetnUniformuiv glGetnUniformuiv;
	extern PROC_glReadnPixels glReadnPixels;
	extern PROC_glTextureBarrier glTextureBarrier;

	extern bool isglCullFace();
	extern bool isglFrontFace();
	extern bool isglHint();
	extern bool isglLineWidth();
	extern bool isglPointSize();
	extern bool isglPolygonMode();
	extern bool isglScissor();
	extern bool isglTexParameterf();
	extern bool isglTexParameterfv();
	extern bool isglTexParameteri();
	extern bool isglTexParameteriv();
	extern bool isglTexImage1D();
	extern bool isglTexImage2D();
	extern bool isglDrawBuffer();
	extern bool isglClear();
	extern bool isglClearColor();
	extern bool isglClearStencil();
	extern bool isglClearDepth();
	extern bool isglStencilMask();
	extern bool isglColorMask();
	extern bool isglDepthMask();
	extern bool isglDisable();
	extern bool isglEnable();
	extern bool isglFinish();
	extern bool isglFlush();
	extern bool isglBlendFunc();
	extern bool isglLogicOp();
	extern bool isglStencilFunc();
	extern bool isglStencilOp();
	extern bool isglDepthFunc();
	extern bool isglPixelStoref();
	extern bool isglPixelStorei();
	extern bool isglReadBuffer();
	extern bool isglReadPixels();
	extern bool isglGetBooleanv();
	extern bool isglGetDoublev();
	extern bool isglGetError();
	extern bool isglGetFloatv();
	extern bool isglGetIntegerv();
	extern bool isglGetString();
	extern bool isglGetTexImage();
	extern bool isglGetTexParameterfv();
	extern bool isglGetTexParameteriv();
	extern bool isglGetTexLevelParameterfv();
	extern bool isglGetTexLevelParameteriv();
	extern bool isglIsEnabled();
	extern bool isglDepthRange();
	extern bool isglViewport();
	extern bool isglDrawArrays();
	extern bool isglDrawElements();
	extern bool isglGetPointerv();
	extern bool isglPolygonOffset();
	extern bool isglCopyTexImage1D();
	extern bool isglCopyTexImage2D();
	extern bool isglCopyTexSubImage1D();
	extern bool isglCopyTexSubImage2D();
	extern bool isglTexSubImage1D();
	extern bool isglTexSubImage2D();
	extern bool isglBindTexture();
	extern bool isglDeleteTextures();
	extern bool isglGenTextures();
	extern bool isglIsTexture();
	extern bool isglDrawRangeElements();
	extern bool isglTexImage3D();
	extern bool isglTexSubImage3D();
	extern bool isglCopyTexSubImage3D();
	extern bool isglActiveTexture();
	extern bool isglSampleCoverage();
	extern bool isglCompressedTexImage3D();
	extern bool isglCompressedTexImage2D();
	extern bool isglCompressedTexImage1D();
	extern bool isglCompressedTexSubImage3D();
	extern bool isglCompressedTexSubImage2D();
	extern bool isglCompressedTexSubImage1D();
	extern bool isglGetCompressedTexImage();
	extern bool isglBlendFuncSeparate();
	extern bool isglMultiDrawArrays();
	extern bool isglMultiDrawElements();
	extern bool isglPointParameterf();
	extern bool isglPointParameterfv();
	extern bool isglPointParameteri();
	extern bool isglPointParameteriv();
	extern bool isglBlendColor();
	extern bool isglBlendEquation();
	extern bool isglGenQueries();
	extern bool isglDeleteQueries();
	extern bool isglIsQuery();
	extern bool isglBeginQuery();
	extern bool isglEndQuery();
	extern bool isglGetQueryiv();
	extern bool isglGetQueryObjectiv();
	extern bool isglGetQueryObjectuiv();
	extern bool isglBindBuffer();
	extern bool isglDeleteBuffers();
	extern bool isglGenBuffers();
	extern bool isglIsBuffer();
	extern bool isglBufferData();
	extern bool isglBufferSubData();
	extern bool isglGetBufferSubData();
	extern bool isglMapBuffer();
	extern bool isglUnmapBuffer();
	extern bool isglGetBufferParameteriv();
	extern bool isglGetBufferPointerv();
	extern bool isglBlendEquationSeparate();
	extern bool isglDrawBuffers();
	extern bool isglStencilOpSeparate();
	extern bool isglStencilFuncSeparate();
	extern bool isglStencilMaskSeparate();
	extern bool isglAttachShader();
	extern bool isglBindAttribLocation();
	extern bool isglCompileShader();
	extern bool isglCreateProgram();
	extern bool isglCreateShader();
	extern bool isglDeleteProgram();
	extern bool isglDeleteShader();
	extern bool isglDetachShader();
	extern bool isglDisableVertexAttribArray();
	extern bool isglEnableVertexAttribArray();
	extern bool isglGetActiveAttrib();
	extern bool isglGetActiveUniform();
	extern bool isglGetAttachedShaders();
	extern bool isglGetAttribLocation();
	extern bool isglGetProgramiv();
	extern bool isglGetProgramInfoLog();
	extern bool isglGetShaderiv();
	extern bool isglGetShaderInfoLog();
	extern bool isglGetShaderSource();
	extern bool isglGetUniformLocation();
	extern bool isglGetUniformfv();
	extern bool isglGetUniformiv();
	extern bool isglGetVertexAttribdv();
	extern bool isglGetVertexAttribfv();
	extern bool isglGetVertexAttribiv();
	extern bool isglGetVertexAttribPointerv();
	extern bool isglIsProgram();
	extern bool isglIsShader();
	extern bool isglLinkProgram();
	extern bool isglShaderSource();
	extern bool isglUseProgram();
	extern bool isglUniform1f();
	extern bool isglUniform2f();
	extern bool isglUniform3f();
	extern bool isglUniform4f();
	extern bool isglUniform1i();
	extern bool isglUniform2i();
	extern bool isglUniform3i();
	extern bool isglUniform4i();
	extern bool isglUniform1fv();
	extern bool isglUniform2fv();
	extern bool isglUniform3fv();
	extern bool isglUniform4fv();
	extern bool isglUniform1iv();
	extern bool isglUniform2iv();
	extern bool isglUniform3iv();
	extern bool isglUniform4iv();
	extern bool isglUniformMatrix2fv();
	extern bool isglUniformMatrix3fv();
	extern bool isglUniformMatrix4fv();
	extern bool isglValidateProgram();
	extern bool isglVertexAttrib1d();
	extern bool isglVertexAttrib1dv();
	extern bool isglVertexAttrib1f();
	extern bool isglVertexAttrib1fv();
	extern bool isglVertexAttrib1s();
	extern bool isglVertexAttrib1sv();
	extern bool isglVertexAttrib2d();
	extern bool isglVertexAttrib2dv();
	extern bool isglVertexAttrib2f();
	extern bool isglVertexAttrib2fv();
	extern bool isglVertexAttrib2s();
	extern bool isglVertexAttrib2sv();
	extern bool isglVertexAttrib3d();
	extern bool isglVertexAttrib3dv();
	extern bool isglVertexAttrib3f();
	extern bool isglVertexAttrib3fv();
	extern bool isglVertexAttrib3s();
	extern bool isglVertexAttrib3sv();
	extern bool isglVertexAttrib4Nbv();
	extern bool isglVertexAttrib4Niv();
	extern bool isglVertexAttrib4Nsv();
	extern bool isglVertexAttrib4Nub();
	extern bool isglVertexAttrib4Nubv();
	extern bool isglVertexAttrib4Nuiv();
	extern bool isglVertexAttrib4Nusv();
	extern bool isglVertexAttrib4bv();
	extern bool isglVertexAttrib4d();
	extern bool isglVertexAttrib4dv();
	extern bool isglVertexAttrib4f();
	extern bool isglVertexAttrib4fv();
	extern bool isglVertexAttrib4iv();
	extern bool isglVertexAttrib4s();
	extern bool isglVertexAttrib4sv();
	extern bool isglVertexAttrib4ubv();
	extern bool isglVertexAttrib4uiv();
	extern bool isglVertexAttrib4usv();
	extern bool isglVertexAttribPointer();
	extern bool isglUniformMatrix2x3fv();
	extern bool isglUniformMatrix3x2fv();
	extern bool isglUniformMatrix2x4fv();
	extern bool isglUniformMatrix4x2fv();
	extern bool isglUniformMatrix3x4fv();
	extern bool isglUniformMatrix4x3fv();
	extern bool isglColorMaski();
	extern bool isglGetBooleani_v();
	extern bool isglGetIntegeri_v();
	extern bool isglEnablei();
	extern bool isglDisablei();
	extern bool isglIsEnabledi();
	extern bool isglBeginTransformFeedback();
	extern bool isglEndTransformFeedback();
	extern bool isglBindBufferRange();
	extern bool isglBindBufferBase();
	extern bool isglTransformFeedbackVaryings();
	extern bool isglGetTransformFeedbackVarying();
	extern bool isglClampColor();
	extern bool isglBeginConditionalRender();
	extern bool isglEndConditionalRender();
	extern bool isglVertexAttribIPointer();
	extern bool isglGetVertexAttribIiv();
	extern bool isglGetVertexAttribIuiv();
	extern bool isglVertexAttribI1i();
	extern bool isglVertexAttribI2i();
	extern bool isglVertexAttribI3i();
	extern bool isglVertexAttribI4i();
	extern bool isglVertexAttribI1ui();
	extern bool isglVertexAttribI2ui();
	extern bool isglVertexAttribI3ui();
	extern bool isglVertexAttribI4ui();
	extern bool isglVertexAttribI1iv();
	extern bool isglVertexAttribI2iv();
	extern bool isglVertexAttribI3iv();
	extern bool isglVertexAttribI4iv();
	extern bool isglVertexAttribI1uiv();
	extern bool isglVertexAttribI2uiv();
	extern bool isglVertexAttribI3uiv();
	extern bool isglVertexAttribI4uiv();
	extern bool isglVertexAttribI4bv();
	extern bool isglVertexAttribI4sv();
	extern bool isglVertexAttribI4ubv();
	extern bool isglVertexAttribI4usv();
	extern bool isglGetUniformuiv();
	extern bool isglBindFragDataLocation();
	extern bool isglGetFragDataLocation();
	extern bool isglUniform1ui();
	extern bool isglUniform2ui();
	extern bool isglUniform3ui();
	extern bool isglUniform4ui();
	extern bool isglUniform1uiv();
	extern bool isglUniform2uiv();
	extern bool isglUniform3uiv();
	extern bool isglUniform4uiv();
	extern bool isglTexParameterIiv();
	extern bool isglTexParameterIuiv();
	extern bool isglGetTexParameterIiv();
	extern bool isglGetTexParameterIuiv();
	extern bool isglClearBufferiv();
	extern bool isglClearBufferuiv();
	extern bool isglClearBufferfv();
	extern bool isglClearBufferfi();
	extern bool isglGetStringi();
	extern bool isglIsRenderbuffer();
	extern bool isglBindRenderbuffer();
	extern bool isglDeleteRenderbuffers();
	extern bool isglGenRenderbuffers();
	extern bool isglRenderbufferStorage();
	extern bool isglGetRenderbufferParameteriv();
	extern bool isglIsFramebuffer();
	extern bool isglBindFramebuffer();
	extern bool isglDeleteFramebuffers();
	extern bool isglGenFramebuffers();
	extern bool isglCheckFramebufferStatus();
	extern bool isglFramebufferTexture1D();
	extern bool isglFramebufferTexture2D();
	extern bool isglFramebufferTexture3D();
	extern bool isglFramebufferRenderbuffer();
	extern bool isglGetFramebufferAttachmentParameteriv();
	extern bool isglGenerateMipmap();
	extern bool isglBlitFramebuffer();
	extern bool isglRenderbufferStorageMultisample();
	extern bool isglFramebufferTextureLayer();
	extern bool isglMapBufferRange();
	extern bool isglFlushMappedBufferRange();
	extern bool isglBindVertexArray();
	extern bool isglDeleteVertexArrays();
	extern bool isglGenVertexArrays();
	extern bool isglIsVertexArray();
	extern bool isglDrawArraysInstanced();
	extern bool isglDrawElementsInstanced();
	extern bool isglTexBuffer();
	extern bool isglPrimitiveRestartIndex();
	extern bool isglCopyBufferSubData();
	extern bool isglGetUniformIndices();
	extern bool isglGetActiveUniformsiv();
	extern bool isglGetActiveUniformName();
	extern bool isglGetUniformBlockIndex();
	extern bool isglGetActiveUniformBlockiv();
	extern bool isglGetActiveUniformBlockName();
	extern bool isglUniformBlockBinding();
	extern bool isglDrawElementsBaseVertex();
	extern bool isglDrawRangeElementsBaseVertex();
	extern bool isglDrawElementsInstancedBaseVertex();
	extern bool isglMultiDrawElementsBaseVertex();
	extern bool isglProvokingVertex();
	extern bool isglFenceSync();
	extern bool isglIsSync();
	extern bool isglDeleteSync();
	extern bool isglClientWaitSync();
	extern bool isglWaitSync();
	extern bool isglGetInteger64v();
	extern bool isglGetSynciv();
	extern bool isglGetInteger64i_v();
	extern bool isglGetBufferParameteri64v();
	extern bool isglFramebufferTexture();
	extern bool isglTexImage2DMultisample();
	extern bool isglTexImage3DMultisample();
	extern bool isglGetMultisamplefv();
	extern bool isglSampleMaski();
	extern bool isglBindFragDataLocationIndexed();
	extern bool isglGetFragDataIndex();
	extern bool isglGenSamplers();
	extern bool isglDeleteSamplers();
	extern bool isglIsSampler();
	extern bool isglBindSampler();
	extern bool isglSamplerParameteri();
	extern bool isglSamplerParameteriv();
	extern bool isglSamplerParameterf();
	extern bool isglSamplerParameterfv();
	extern bool isglSamplerParameterIiv();
	extern bool isglSamplerParameterIuiv();
	extern bool isglGetSamplerParameteriv();
	extern bool isglGetSamplerParameterIiv();
	extern bool isglGetSamplerParameterfv();
	extern bool isglGetSamplerParameterIuiv();
	extern bool isglQueryCounter();
	extern bool isglGetQueryObjecti64v();
	extern bool isglGetQueryObjectui64v();
	extern bool isglVertexAttribDivisor();
	extern bool isglVertexAttribP1ui();
	extern bool isglVertexAttribP1uiv();
	extern bool isglVertexAttribP2ui();
	extern bool isglVertexAttribP2uiv();
	extern bool isglVertexAttribP3ui();
	extern bool isglVertexAttribP3uiv();
	extern bool isglVertexAttribP4ui();
	extern bool isglVertexAttribP4uiv();
	extern bool isglMinSampleShading();
	extern bool isglBlendEquationi();
	extern bool isglBlendEquationSeparatei();
	extern bool isglBlendFunci();
	extern bool isglBlendFuncSeparatei();
	extern bool isglDrawArraysIndirect();
	extern bool isglDrawElementsIndirect();
	extern bool isglUniform1d();
	extern bool isglUniform2d();
	extern bool isglUniform3d();
	extern bool isglUniform4d();
	extern bool isglUniform1dv();
	extern bool isglUniform2dv();
	extern bool isglUniform3dv();
	extern bool isglUniform4dv();
	extern bool isglUniformMatrix2dv();
	extern bool isglUniformMatrix3dv();
	extern bool isglUniformMatrix4dv();
	extern bool isglUniformMatrix2x3dv();
	extern bool isglUniformMatrix2x4dv();
	extern bool isglUniformMatrix3x2dv();
	extern bool isglUniformMatrix3x4dv();
	extern bool isglUniformMatrix4x2dv();
	extern bool isglUniformMatrix4x3dv();
	extern bool isglGetUniformdv();
	extern bool isglGetSubroutineUniformLocation();
	extern bool isglGetSubroutineIndex();
	extern bool isglGetActiveSubroutineUniformiv();
	extern bool isglGetActiveSubroutineUniformName();
	extern bool isglGetActiveSubroutineName();
	extern bool isglUniformSubroutinesuiv();
	extern bool isglGetUniformSubroutineuiv();
	extern bool isglGetProgramStageiv();
	extern bool isglPatchParameteri();
	extern bool isglPatchParameterfv();
	extern bool isglBindTransformFeedback();
	extern bool isglDeleteTransformFeedbacks();
	extern bool isglGenTransformFeedbacks();
	extern bool isglIsTransformFeedback();
	extern bool isglPauseTransformFeedback();
	extern bool isglResumeTransformFeedback();
	extern bool isglDrawTransformFeedback();
	extern bool isglDrawTransformFeedbackStream();
	extern bool isglBeginQueryIndexed();
	extern bool isglEndQueryIndexed();
	extern bool isglGetQueryIndexediv();
	extern bool isglReleaseShaderCompiler();
	extern bool isglShaderBinary();
	extern bool isglGetShaderPrecisionFormat();
	extern bool isglDepthRangef();
	extern bool isglClearDepthf();
	extern bool isglGetProgramBinary();
	extern bool isglProgramBinary();
	extern bool isglProgramParameteri();
	extern bool isglUseProgramStages();
	extern bool isglActiveShaderProgram();
	extern bool isglCreateShaderProgramv();
	extern bool isglBindProgramPipeline();
	extern bool isglDeleteProgramPipelines();
	extern bool isglGenProgramPipelines();
	extern bool isglIsProgramPipeline();
	extern bool isglGetProgramPipelineiv();
	extern bool isglProgramUniform1i();
	extern bool isglProgramUniform1iv();
	extern bool isglProgramUniform1f();
	extern bool isglProgramUniform1fv();
	extern bool isglProgramUniform1d();
	extern bool isglProgramUniform1dv();
	extern bool isglProgramUniform1ui();
	extern bool isglProgramUniform1uiv();
	extern bool isglProgramUniform2i();
	extern bool isglProgramUniform2iv();
	extern bool isglProgramUniform2f();
	extern bool isglProgramUniform2fv();
	extern bool isglProgramUniform2d();
	extern bool isglProgramUniform2dv();
	extern bool isglProgramUniform2ui();
	extern bool isglProgramUniform2uiv();
	extern bool isglProgramUniform3i();
	extern bool isglProgramUniform3iv();
	extern bool isglProgramUniform3f();
	extern bool isglProgramUniform3fv();
	extern bool isglProgramUniform3d();
	extern bool isglProgramUniform3dv();
	extern bool isglProgramUniform3ui();
	extern bool isglProgramUniform3uiv();
	extern bool isglProgramUniform4i();
	extern bool isglProgramUniform4iv();
	extern bool isglProgramUniform4f();
	extern bool isglProgramUniform4fv();
	extern bool isglProgramUniform4d();
	extern bool isglProgramUniform4dv();
	extern bool isglProgramUniform4ui();
	extern bool isglProgramUniform4uiv();
	extern bool isglProgramUniformMatrix2fv();
	extern bool isglProgramUniformMatrix3fv();
	extern bool isglProgramUniformMatrix4fv();
	extern bool isglProgramUniformMatrix2dv();
	extern bool isglProgramUniformMatrix3dv();
	extern bool isglProgramUniformMatrix4dv();
	extern bool isglProgramUniformMatrix2x3fv();
	extern bool isglProgramUniformMatrix3x2fv();
	extern bool isglProgramUniformMatrix2x4fv();
	extern bool isglProgramUniformMatrix4x2fv();
	extern bool isglProgramUniformMatrix3x4fv();
	extern bool isglProgramUniformMatrix4x3fv();
	extern bool isglProgramUniformMatrix2x3dv();
	extern bool isglProgramUniformMatrix3x2dv();
	extern bool isglProgramUniformMatrix2x4dv();
	extern bool isglProgramUniformMatrix4x2dv();
	extern bool isglProgramUniformMatrix3x4dv();
	extern bool isglProgramUniformMatrix4x3dv();
	extern bool isglValidateProgramPipeline();
	extern bool isglGetProgramPipelineInfoLog();
	extern bool isglVertexAttribL1d();
	extern bool isglVertexAttribL2d();
	extern bool isglVertexAttribL3d();
	extern bool isglVertexAttribL4d();
	extern bool isglVertexAttribL1dv();
	extern bool isglVertexAttribL2dv();
	extern bool isglVertexAttribL3dv();
	extern bool isglVertexAttribL4dv();
	extern bool isglVertexAttribLPointer();
	extern bool isglGetVertexAttribLdv();
	extern bool isglViewportArrayv();
	extern bool isglViewportIndexedf();
	extern bool isglViewportIndexedfv();
	extern bool isglScissorArrayv();
	extern bool isglScissorIndexed();
	extern bool isglScissorIndexedv();
	extern bool isglDepthRangeArrayv();
	extern bool isglDepthRangeIndexed();
	extern bool isglGetFloati_v();
	extern bool isglGetDoublei_v();
	extern bool isglDrawArraysInstancedBaseInstance();
	extern bool isglDrawElementsInstancedBaseInstance();
	extern bool isglDrawElementsInstancedBaseVertexBaseInstance();
	extern bool isglGetInternalformativ();
	extern bool isglGetActiveAtomicCounterBufferiv();
	extern bool isglBindImageTexture();
	extern bool isglMemoryBarrier();
	extern bool isglTexStorage1D();
	extern bool isglTexStorage2D();
	extern bool isglTexStorage3D();
	extern bool isglDrawTransformFeedbackInstanced();
	extern bool isglDrawTransformFeedbackStreamInstanced();
	extern bool isglClearBufferData();
	extern bool isglClearBufferSubData();
	extern bool isglDispatchCompute();
	extern bool isglDispatchComputeIndirect();
	extern bool isglCopyImageSubData();
	extern bool isglFramebufferParameteri();
	extern bool isglGetFramebufferParameteriv();
	extern bool isglGetInternalformati64v();
	extern bool isglInvalidateTexSubImage();
	extern bool isglInvalidateTexImage();
	extern bool isglInvalidateBufferSubData();
	extern bool isglInvalidateBufferData();
	extern bool isglInvalidateFramebuffer();
	extern bool isglInvalidateSubFramebuffer();
	extern bool isglMultiDrawArraysIndirect();
	extern bool isglMultiDrawElementsIndirect();
	extern bool isglGetProgramInterfaceiv();
	extern bool isglGetProgramResourceIndex();
	extern bool isglGetProgramResourceName();
	extern bool isglGetProgramResourceiv();
	extern bool isglGetProgramResourceLocation();
	extern bool isglGetProgramResourceLocationIndex();
	extern bool isglShaderStorageBlockBinding();
	extern bool isglTexBufferRange();
	extern bool isglTexStorage2DMultisample();
	extern bool isglTexStorage3DMultisample();
	extern bool isglTextureView();
	extern bool isglBindVertexBuffer();
	extern bool isglVertexAttribFormat();
	extern bool isglVertexAttribIFormat();
	extern bool isglVertexAttribLFormat();
	extern bool isglVertexAttribBinding();
	extern bool isglVertexBindingDivisor();
	extern bool isglDebugMessageControl();
	extern bool isglDebugMessageInsert();
	extern bool isglDebugMessageCallback();
	extern bool isglGetDebugMessageLog();
	extern bool isglPushDebugGroup();
	extern bool isglPopDebugGroup();
	extern bool isglObjectLabel();
	extern bool isglGetObjectLabel();
	extern bool isglObjectPtrLabel();
	extern bool isglGetObjectPtrLabel();
	extern bool isglBufferStorage();
	extern bool isglClearTexImage();
	extern bool isglClearTexSubImage();
	extern bool isglBindBuffersBase();
	extern bool isglBindBuffersRange();
	extern bool isglBindTextures();
	extern bool isglBindSamplers();
	extern bool isglBindImageTextures();
	extern bool isglBindVertexBuffers();
	extern bool isglClipControl();
	extern bool isglCreateTransformFeedbacks();
	extern bool isglTransformFeedbackBufferBase();
	extern bool isglTransformFeedbackBufferRange();
	extern bool isglGetTransformFeedbackiv();
	extern bool isglGetTransformFeedbacki_v();
	extern bool isglGetTransformFeedbacki64_v();
	extern bool isglCreateBuffers();
	extern bool isglNamedBufferStorage();
	extern bool isglNamedBufferData();
	extern bool isglNamedBufferSubData();
	extern bool isglCopyNamedBufferSubData();
	extern bool isglClearNamedBufferData();
	extern bool isglClearNamedBufferSubData();
	extern bool isglMapNamedBuffer();
	extern bool isglMapNamedBufferRange();
	extern bool isglUnmapNamedBuffer();
	extern bool isglFlushMappedNamedBufferRange();
	extern bool isglGetNamedBufferParameteriv();
	extern bool isglGetNamedBufferParameteri64v();
	extern bool isglGetNamedBufferPointerv();
	extern bool isglGetNamedBufferSubData();
	extern bool isglCreateFramebuffers();
	extern bool isglNamedFramebufferRenderbuffer();
	extern bool isglNamedFramebufferParameteri();
	extern bool isglNamedFramebufferTexture();
	extern bool isglNamedFramebufferTextureLayer();
	extern bool isglNamedFramebufferDrawBuffer();
	extern bool isglNamedFramebufferDrawBuffers();
	extern bool isglNamedFramebufferReadBuffer();
	extern bool isglInvalidateNamedFramebufferData();
	extern bool isglInvalidateNamedFramebufferSubData();
	extern bool isglClearNamedFramebufferiv();
	extern bool isglClearNamedFramebufferuiv();
	extern bool isglClearNamedFramebufferfv();
	extern bool isglClearNamedFramebufferfi();
	extern bool isglBlitNamedFramebuffer();
	extern bool isglCheckNamedFramebufferStatus();
	extern bool isglGetNamedFramebufferParameteriv();
	extern bool isglGetNamedFramebufferAttachmentParameteriv();
	extern bool isglCreateRenderbuffers();
	extern bool isglNamedRenderbufferStorage();
	extern bool isglNamedRenderbufferStorageMultisample();
	extern bool isglGetNamedRenderbufferParameteriv();
	extern bool isglCreateTextures();
	extern bool isglTextureBuffer();
	extern bool isglTextureBufferRange();
	extern bool isglTextureStorage1D();
	extern bool isglTextureStorage2D();
	extern bool isglTextureStorage3D();
	extern bool isglTextureStorage2DMultisample();
	extern bool isglTextureStorage3DMultisample();
	extern bool isglTextureSubImage1D();
	extern bool isglTextureSubImage2D();
	extern bool isglTextureSubImage3D();
	extern bool isglCompressedTextureSubImage1D();
	extern bool isglCompressedTextureSubImage2D();
	extern bool isglCompressedTextureSubImage3D();
	extern bool isglCopyTextureSubImage1D();
	extern bool isglCopyTextureSubImage2D();
	extern bool isglCopyTextureSubImage3D();
	extern bool isglTextureParameterf();
	extern bool isglTextureParameterfv();
	extern bool isglTextureParameteri();
	extern bool isglTextureParameterIiv();
	extern bool isglTextureParameterIuiv();
	extern bool isglTextureParameteriv();
	extern bool isglGenerateTextureMipmap();
	extern bool isglBindTextureUnit();
	extern bool isglGetTextureImage();
	extern bool isglGetCompressedTextureImage();
	extern bool isglGetTextureLevelParameterfv();
	extern bool isglGetTextureLevelParameteriv();
	extern bool isglGetTextureParameterfv();
	extern bool isglGetTextureParameterIiv();
	extern bool isglGetTextureParameterIuiv();
	extern bool isglGetTextureParameteriv();
	extern bool isglCreateVertexArrays();
	extern bool isglDisableVertexArrayAttrib();
	extern bool isglEnableVertexArrayAttrib();
	extern bool isglVertexArrayElementBuffer();
	extern bool isglVertexArrayVertexBuffer();
	extern bool isglVertexArrayVertexBuffers();
	extern bool isglVertexArrayAttribBinding();
	extern bool isglVertexArrayAttribFormat();
	extern bool isglVertexArrayAttribIFormat();
	extern bool isglVertexArrayAttribLFormat();
	extern bool isglVertexArrayBindingDivisor();
	extern bool isglGetVertexArrayiv();
	extern bool isglGetVertexArrayIndexediv();
	extern bool isglGetVertexArrayIndexed64iv();
	extern bool isglCreateSamplers();
	extern bool isglCreateProgramPipelines();
	extern bool isglCreateQueries();
	extern bool isglGetQueryBufferObjecti64v();
	extern bool isglGetQueryBufferObjectiv();
	extern bool isglGetQueryBufferObjectui64v();
	extern bool isglGetQueryBufferObjectuiv();
	extern bool isglMemoryBarrierByRegion();
	extern bool isglGetTextureSubImage();
	extern bool isglGetCompressedTextureSubImage();
	extern bool isglGetGraphicsResetStatus();
	extern bool isglGetnCompressedTexImage();
	extern bool isglGetnTexImage();
	extern bool isglGetnUniformdv();
	extern bool isglGetnUniformfv();
	extern bool isglGetnUniformiv();
	extern bool isglGetnUniformuiv();
	extern bool isglReadnPixels();
	extern bool isglTextureBarrier();

}

#undef GLAPI
