# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class ChangeCategory(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The entity that made the change
    """

    #: User initiated change.
    USER = "User"
    #: System initiated change.
    SYSTEM = "System"

class ChangeType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of change that was captured in the resource
    """

    #: An existing resource underwent a change.
    UPDATE = "Update"
    #: An existing resource was deleted.
    DELETE = "Delete"
    #: A newly created resource.
    CREATE = "Create"

class PropertyChangeType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of change that occurred
    """

    #: An existing property underwent a change.
    UPDATE = "Update"
    #: A property was newly created.
    INSERT = "Insert"
    #: An existing property was deleted.
    REMOVE = "Remove"
