# -*- coding: utf-8 -*-
#
# Copyright 2014 Danny Goodall
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
from __future__ import (absolute_import, division, print_function, unicode_literals)
from builtins import *
from stuf import stuf

CF_FB_BUNDESLIGA_1 = 351
CF_FB_BUNDESLIGA_2 = 352
CF_FB_BUNDESLIGA_3 = 353
CF_FB_PREMIER_LEAGUE = 354
CF_FB_LIGUE_1 = 355
CF_FB_LIGUE_2 = 356
CF_FB_SERIE_A = 357
CF_FB_PRIMERA_DIVISION = 358
CF_FB_SEGUNDA_DIVISION = 359
CF_FB_EHRENDIVISION = 360
CF_FB_SERIE_B = 361
CF_FB_CHAMPIONS_LEAGUE = 362


CF_FB_MANCHESTER_UNITED = 66
CF_FB_SOUTHAMPTON = 340
CF_FB_SWANSEA_CITY = 72
CF_FB_LEICESTER_CITY = 338
CF_FB_EVERTON = 62
CF_FB_WEST_HAM_UNITED = 563
CF_FB_TOTTENHAM_HOTSPUR = 73
CF_FB_WEST_BROMWICH_ALBION = 74
CF_FB_SUNDERLAND = 71
CF_FB_STOKE_CITY = 70
CF_FB_ASTON_VILLA = 58
CF_FB_QUEENS_PARK_RANGERS = 69
CF_FB_HULL_CITY = 322
CF_FB_ARSENAL = 57
CF_FB_CRYSTAL_PALACE = 354
CF_FB_LIVERPOOL = 64
CF_FB_NEWCASTLE_UNITED = 67
CF_FB_MANCHESTER_CITY = 65
CF_FB_BURNLEY = 328
CF_FB_CHELSEA = 61

CF_FB_BARCELONA = 81
CF_FB_REAL_MADRID = 86

CF_FB_LEAGUE_DETAILS = stuf(
    BL1=CF_FB_BUNDESLIGA_1,
    BL2=CF_FB_BUNDESLIGA_2,
    BL3=CF_FB_BUNDESLIGA_3,
    PL=CF_FB_PREMIER_LEAGUE,
    FL1=CF_FB_LIGUE_1,
    FL2=CF_FB_LIGUE_2,
    SA=CF_FB_SERIE_A,
    SB=CF_FB_SERIE_B,
    PD=CF_FB_PRIMERA_DIVISION,
    SD=CF_FB_SEGUNDA_DIVISION,
    DED=CF_FB_EHRENDIVISION,
    CL=CF_FB_CHAMPIONS_LEAGUE
)

CF_FB_LEAGUE_CODES = CF_FB_LEAGUE_DETAILS.keys()
CF_FB_LEAGUE_NUMBERS = CF_FB_LEAGUE_DETAILS.values()

CF_FB_TEAM_DETAILS = stuf(
    MANU=CF_FB_MANCHESTER_UNITED,
    SAINTS=CF_FB_SOUTHAMPTON,
    SWANSEA=CF_FB_SWANSEA_CITY,
    LEICESTER=CF_FB_LEICESTER_CITY,
    EVERTON=CF_FB_EVERTON,
    WEST_HAM=CF_FB_WEST_HAM_UNITED,
    SPURS=CF_FB_TOTTENHAM_HOTSPUR,
    WEST_BROM=CF_FB_WEST_BROMWICH_ALBION,
    SUNDERLAND=CF_FB_SUNDERLAND,
    STOKE=CF_FB_STOKE_CITY,
    VILLA=CF_FB_ASTON_VILLA,
    QPR=CF_FB_QUEENS_PARK_RANGERS,
    HULL=CF_FB_HULL_CITY,
    ARSENAL=CF_FB_ARSENAL,
    PALACE=CF_FB_CRYSTAL_PALACE,
    LIVERPOOL=CF_FB_LIVERPOOL,
    NEWCASTLE=CF_FB_NEWCASTLE_UNITED,
    MAN_CITY=CF_FB_MANCHESTER_CITY,
    BURNLEY=CF_FB_BURNLEY,
    CHELSEA=CF_FB_CHELSEA,

    BARCA=CF_FB_BARCELONA,
    REAL_MADRID=CF_FB_REAL_MADRID
)

CF_FB_TEAM_CODES = CF_FB_TEAM_DETAILS.keys()
CF_FB_TEAM_NUMBERS = CF_FB_TEAM_DETAILS.values()
