'''
Dual-Draw Surface image file definitions

Structures were pieced together from various online sources
'''

from supyr_struct.defs.tag_def import *


def get(): return dds_def


dx10_resource_format = LUEnum32("format",
    ("Unknown", 0),
    ("R32G32B32A32_TYPELESS", 1),
    ("R32G32B32A32_FLOAT", 2),
    ("R32G32B32A32_UINT",  3),
    ("R32G32B32A32_SINT",  4),
    ("R32G32B32_TYPELESS", 5),
    ("R32G32B32_FLOAT",    6),
    ("R32G32B32_UINT",     7),
    ("R32G32B32_SINT",     8),
    ("R16G16B16A16_TYPELESS", 9),
    ("R16G16B16A16_FLOAT",   10),
    ("R16G16B16A16_UNORM",   11),
    ("R16G16B16A16_UINT",    12),
    ("R16G16B16A16_SNORM",   13),
    ("R16G16B16A16_SINT",    14),
    ("R32G32_TYPELESS",      15),
    ("R32G32_FLOAT",         16),
    ("R32G32_UINT",          17),
    ("R32G32_SINT",          18),
    ("R32G8X24_TYPELESS",    19),
    ("D32_FLOAT_S8X24_UINT", 20),
    ("R32_FLOAT_X8X24_TYPELESS", 21),
    ("X32_TYPELESS_G8X24_UINT",  22),
    ("R10G10B10A2_TYPELESS", 23),
    ("R10G10B10A2_UNORM",    24),
    ("R10G10B10A2_UINT",     25),
    ("R11G11B10_FLOAT",      26),
    ("R8G8B8A8_TYPELESS",    27),
    ("R8G8B8A8_UNORM",       28),
    ("R8G8B8A8_UNORM_SRGB",  29),
    ("R8G8B8A8_UINT",   30),
    ("R8G8B8A8_SNORM",  31),
    ("R8G8B8A8_SINT",   32),
    ("R16G16_TYPELESS", 33),
    ("R16G16_FLOAT", 34),
    ("R16G16_UNORM", 35),
    ("R16G16_UINT",  36),
    ("R16G16_SNORM", 37),
    ("R16G16_SINT",  38),
    ("R32_TYPELESS", 39),
    ("D32_FLOAT",    40),
    ("R32_FLOAT",    41),
    ("R32_UINT",     42),
    ("R32_SINT",     43),
    ("R24G8_TYPELESS",        44),
    ("D24_UNORM_S8_UINT",     45),
    ("R24_UNORM_X8_TYPELESS", 46),
    ("X24_TYPELESS_G8_UINT",  47),
    ("R8G8_TYPELESS", 48),
    ("R8G8_UNORM",    49),
    ("R8G8_UINT",     50),
    ("R8G8_SNORM",    51),
    ("R8G8_SINT",     52),
    ("R16_TYPELESS",  53),
    ("R16_FLOAT",     54),
    ("D16_UNORM",     55),
    ("R16_UNORM",     56),
    ("R16_UINT",      57),
    ("R16_SNORM",     58),
    ("R16_SINT",      59),
    ("R8_TYPELESS",   60),
    ("R8_UNORM",      61),
    ("R8_UINT",       62),
    ("R8_SNORM",      63),
    ("R8_SINT",       64),
    ("A8_UNORM",      65),
    ("R1_UNORM",      66),
    ("R9G9B9E5_SHAREDEXP", 67),
    ("R8G8_B8G8_UNORM", 68),
    ("G8R8_G8B8_UNORM", 69),
    ("BC1_TYPELESS",    70),
    ("BC1_UNORM",       71),
    ("BC1_UNORM_SRGB",  72),
    ("BC2_TYPELESS",    73),
    ("BC2_UNORM",       74),
    ("BC2_UNORM_SRGB",  75),
    ("BC3_TYPELESS",    76),
    ("BC3_UNORM",       77),
    ("BC3_UNORM_SRGB",  78),
    ("BC4_TYPELESS",    79),
    ("BC4_UNORM",       80),
    ("BC4_SNORM",       81),
    ("BC5_TYPELESS",    82),
    ("BC5_UNORM",       83),
    ("BC5_SNORM",       84),
    ("B5G6R5_UNORM",    85),
    ("B5G5R5A1_UNORM",  86),
    ("B8G8R8A8_UNORM",  87),
    ("B8G8R8X8_UNORM",  88),
    ("R10G10B10_XR_BIAS_A2_UNORM", 89),
    ("B8G8R8A8_TYPELESS",   90),
    ("B8G8R8A8_UNORM_SRGB", 91),
    ("B8G8R8X8_TYPELESS",   92),
    ("B8G8R8X8_UNORM_SRGB", 93),
    ("BC6H_TYPELESS",  94),
    ("BC6H_UF16",      95),
    ("BC6H_SF16",      96),
    ("BC7_TYPELESS",   97),
    ("BC7_UNORM",      98),
    ("BC7_UNORM_SRGB", 99),
    ("AYUV", 100),
    ("Y410", 101),
    ("Y416", 102),
    ("NV12", 103),
    ("P010", 104),
    ("P016", 105),
    ("420_OPAQUE", 106),
    ("YUY2", 107),
    ("Y210", 108),
    ("Y216", 109),
    ("NV11", 110),
    ("AI44", 111),
    ("IA44", 112),
    ("P8",   113),
    ("A8P8", 114),
    ("B4G4R4A4_UNORM", 115),
    ("P208", 130),
    ("V208", 131),
    ("V408", 132)
    )

dx10_resource_dimension = LUEnum32("resource_dimension",
    ("tex_1D", 2),
    ("tex_2D", 3),
    ("tex_3D", 4)
    )

dx10_misc_flags = LBool32("misc_flag",
    ("cubemap", 0x4)
    )

dx10_misc_flags2 = LUEnum32("misc_flags2",
    ("unknown",       0x00),
    ("straight",      0x01),
    ("premultiplied", 0x02),
    ("opaque",        0x03),
    ("custom",        0x04)
    )

dds_header_dx10 = Struct("dds_header_dx10",
    dx10_resource_format,
    dx10_resource_dimension,
    dx10_misc_flags,
    LUInt32("array_size", DEFAULT=1),
    dx10_misc_flags2
    )

dds_header_xbox = Struct("dds_header_xbox",
    dx10_resource_format,
    dx10_resource_dimension,
    dx10_misc_flags,
    LUInt32("array_size", DEFAULT=1),
    dx10_misc_flags2,
    LUInt32("xg_tile_mode"),
    LUInt32("base_alignment"),
    LUInt32("data_size"),
    LUInt32("xdk_ver")
    )

dds_pixelformat = Struct('dds_pixelformat',
    LUInt32("size", DEFAULT=32, MIN=32, MAX=32),
    LBool32("flags",
        ("has_alpha",  0x000001),
        ("alpha_only", 0x000002),
        ("four_cc",    0x000004),
        ("RGB",        0x000040),
        ("YUV",        0x000200),
        ("luminance",  0x020000),
        ("U8V8",       0x080000)
        ),
    LUEnum32("four_cc",
        ("None", 0),
        ("DXT1", '1TXD'),
        ("DXT2", '2TXD'),
        ("DXT3", '3TXD'),
        ("DXT4", '4TXD'),
        ("DXT5", '5TXD'),
        ("DXN",  '2ITA'),
        ("UYVY", 'YVYU'),
        ("YUY2", '2YUY'),
        ("DX10", '01XD'),
        ("XBOX", 'XOBX'),
        ("BC4U", 'U4CB'),
        ("BC4S", 'S4CB'),
        ("BC5S", 'S5CB'),
        ("RGBG", 'GBGR'),
        ("GRGB", 'BGRG'),
        ("RGBA_16_UNORM", 36),
        ("RGBA_16_SNORM", 110),
        ("R_16_FLOAT",    111),
        ("RG_16_FLOAT",   112),
        ("RGBA_16_FLOAT", 113),
        ("R_32_FLOAT",    114),
        ("RG_32_FLOAT",   115),
        ("RGBA_32_FLOAT", 116),
        ("CxV8U8",        117),

        # These are all Xbox 360 formats
        ("D3DFMT_LIN_DXT1",      0x1A200052),
        ("D3DFMT_LIN_DXT2",      0x9A200053),
        ("D3DFMT_LIN_DXT3",      0x1A200053),
        ("D3DFMT_LIN_DXT4",      0x9A200054),
        ("D3DFMT_LIN_DXT5",      0x1A200054),
        ("D3DFMT_LIN_DXN",       0x1A200071),
        ("D3DFMT_LIN_DXT3A",     0x1A20007A),
        ("D3DFMT_LIN_DXT5A",     0x1A20007B),
        ("D3DFMT_LIN_CTX1",      0x1A20007C),
        ("D3DFMT_LIN_G8R8_G8B8", 0x1828004C),
        ("D3DFMT_LIN_UYVY",      0x5A20004C),
        DEFAULT=0
        ),
    LUInt32("rgb_bitcount"),
    LUInt32("r_bitmask"),
    LUInt32("g_bitmask"),
    LUInt32("b_bitmask"),
    LUInt32("a_bitmask")
    )

dds_header = Struct("header",
    LUInt32("magic", DEFAULT=' SDD', EDITABLE=False),
    LUInt32("size",  DEFAULT=124, MIN=124, MAX=124),
    LBool32("flags",
        {NAME: "caps",   VALUE: 0x000001, DEFAULT: True},
        {NAME: "height", VALUE: 0x000002, DEFAULT: True},
        {NAME: "width",  VALUE: 0x000004, DEFAULT: True},
        ("pitch", 0x000008),
        {NAME: "pixelformat", VALUE: 0x001000, DEFAULT: True},
        ("mipmaps",    0x020000),
        ("linearsize", 0x080000),
        ("depth",      0x800000),
        ),
    LUInt32("height"),
    LUInt32("width"),
    LUInt32("pitch_or_linearsize"),
    LUInt32("depth", DEFAULT=1),
    LUInt32("mipmap_count", DEFAULT=1),
    Pad(44),
    dds_pixelformat,
    LBool32("caps",
        ("complex", 0x000008),
        {NAME: "texture", VALUE: 0x001000, DEFAULT: True},
        ("mipmaps", 0x400000)
        ),
    LBool32("caps2",
        ("cubemap", 0x000200),
        ("pos_x",   0x000400),
        ("neg_x",   0x000800),
        ("pos_y",   0x001000),
        ("neg_y",   0x002000),
        ("pos_z",   0x004000),
        ("neg_z",   0x008000),
        ("volume",  0x200000)
        ),
    LBool32("caps3"),
    LBool32("caps4"),
    Pad(4)
    )

dds_def = TagDef("dds",
    dds_header,
    Switch("dxt10_header",
        CASE=".header.dds_pixelformat.four_cc.enum_name",
        CASES={'DX10': dds_header_dx10,
               'XBOX': dds_header_xbox}
    ),
    BytearrayRaw("pixel_data", SIZE=remaining_data_length),

    ext=".dds", endian="<"
    )
