/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.factory;

import java.util.regex.PatternSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.Converter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.IdentityConverter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ModelSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.BaseParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.RegexpValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;

public class RegexpParserValidator
extends BaseParserValidator<String> {
    public static final String REGEXP_TYPE = "REGEXP";
    public static final String LEFT_DELIMITER = "(";
    public static final String RIGHT_DELIMITER = ")";
    protected static final String REGEXP_TYPE_REGEXP = "[Rr][Ee][Gg][Ee][Xx][Pp]";
    protected static final String LEFT_DELIMITER_REGEXP = "\\(";
    protected static final String RIGHT_DELIMITER_REGEXP = "\\)";

    public RegexpParserValidator(String model) throws ModelSyntaxException {
        super(model);
    }

    @Override
    public String getType() {
        return REGEXP_TYPE;
    }

    @Override
    public String getTypeRegexp() {
        return REGEXP_TYPE_REGEXP;
    }

    @Override
    public Class getClassType() {
        return String.class;
    }

    @Override
    protected Converter<String> createConverter(String model) throws ModelSyntaxException {
        return new IdentityConverter();
    }

    @Override
    protected Validator<String> createValidator(String model, Converter<String> converter) throws ModelSyntaxException {
        String regexpRegexp = "^[Rr][Ee][Gg][Ee][Xx][Pp]\\((.+)\\)$";
        String regexpString = this.parseAndGetOneGroup(model, regexpRegexp);
        try {
            return new RegexpValidator(regexpString);
        }
        catch (PatternSyntaxException e) {
            throw new ModelSyntaxException(e.getMessage(), e);
        }
    }
}

