/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.factory;

import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.Converter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.IdentityConverter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ModelSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.BaseParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.JSONValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;
import org.springframework.expression.ParseException;

public class JSONParserValidator
extends BaseParserValidator<String> {
    public static final String JSON_TYPE = "JSON";
    public static final String JSON_TYPE_REGEXP = "[Jj][Ss][Oo][Nn]";

    public JSONParserValidator(String model) throws ModelSyntaxException {
        super(model);
        String regexep = "^[Jj][Ss][Oo][Nn]$";
        if (!model.matches(regexep)) {
            throw new ModelSyntaxException("JSON expression in model does not match " + regexep);
        }
    }

    @Override
    protected String getType() {
        return JSON_TYPE;
    }

    @Override
    protected String getTypeRegexp() {
        return JSON_TYPE_REGEXP;
    }

    @Override
    protected Class getClassType() {
        return String.class;
    }

    @Override
    protected Converter<String> createConverter(String model) throws ModelSyntaxException {
        return new IdentityConverter();
    }

    @Override
    protected Validator<String> createValidator(String model, Converter<String> converter) throws ModelSyntaxException {
        try {
            return new JSONValidator();
        }
        catch (ParseException e) {
            throw new ModelSyntaxException(e.getMessage(), e);
        }
    }
}

