/*
 * Decompiled with CFR 0.152.
 */
package be.re.util;

import java.util.HashSet;
import java.util.Set;

public class DigitalTree
implements Cloneable {
    private static final int BITS = 8;
    private static final int MASK = 255;
    private static final int SIZE = 256;
    private Set keys;
    private Node[] root = new Node[256];

    public DigitalTree() {
        this(false);
    }

    public DigitalTree(boolean saveKeys) {
        this.keys = saveKeys ? new HashSet() : null;
    }

    public Object clone() {
        DigitalTree copy = null;
        try {
            copy = (DigitalTree)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        copy.root = DigitalTree.cloneNodes(this.root);
        if (this.keys != null) {
            copy.keys = (Set)((HashSet)this.keys).clone();
        }
        return copy;
    }

    private static Node[] cloneNodes(Node[] nodes) {
        Node[] result = new Node[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] == null) continue;
            result[i] = (Node)nodes[i].clone();
        }
        return result;
    }

    public Object get(String key) {
        Node[] current = this.root;
        int i = 0;
        int length = key.length();
        Node node = null;
        for (i = 0; i < length && current != null; ++i) {
            char c = key.charAt(i);
            for (int j = 0; j < 2 && current != null; ++j) {
                node = current[(255 << j * 8 & c) >>> j * 8];
                current = node != null ? node.nodes : null;
            }
        }
        return i == length && node != null ? node.object : null;
    }

    public Set keySet() {
        return this.keys;
    }

    public void put(String key, Object o) {
        Node[] current = this.root;
        int length = key.length();
        Node node = null;
        for (int i = 0; i < length; ++i) {
            char c = key.charAt(i);
            for (int j = 0; j < 2; ++j) {
                int value = (255 << j * 8 & c) >>> j * 8;
                if (current[value] == null) {
                    current[value] = new Node();
                }
                if (current[value].nodes == null && (i < length - 1 || j < 1)) {
                    Node.access$002(current[value], new Node[256]);
                }
                node = current[value];
                current = current[value].nodes;
            }
        }
        node.object = o;
        if (this.keys != null) {
            this.keys.add(key);
        }
    }

    public void remove(String key) {
        this.put(key, null);
    }

    private static class Node
    implements Cloneable {
        private Node[] nodes;
        private Object object;

        private Node() {
        }

        protected Object clone() {
            Node copy = null;
            try {
                copy = (Node)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
            if (this.nodes != null) {
                copy.nodes = DigitalTree.cloneNodes(this.nodes);
            }
            return copy;
        }

        static /* synthetic */ Node[] access$002(Node x0, Node[] x1) {
            x0.nodes = x1;
            return x1;
        }
    }
}

