
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class ProductType(object):
	def __init__(self, apiContext: ApiContext = None, dataViewMode="Live", mozuClient = None):
		if (apiContext is not None and apiContext.dataViewMode is None):
			apiContext.dataViewMode = dataViewMode;
		else:
			apiContext = ApiContext(dataViewMode = dataViewMode);
		self.client = mozuClient or default_client();
		self.client.withApiContext(apiContext);
	
	def getProductTypes(self,startIndex = None, pageSize = None, sortBy = None, filter = None, responseFields = None):
		""" Retrieves a list of product types according to any specified filter criteria and sort options.
		
		Args:
			| startIndex (int) - 
			| pageSize (int) - The number of results to display on each page when creating paged results from a query. The maximum value is 200.
			| sortBy (string) - 
			| filter (string) - A set of filter expressions representing the search parameters for a query: eq=equals, ne=not equals, gt=greater than, lt = less than or equals, gt = greater than or equals, lt = less than or equals, sw = starts with, or cont = contains. Optional.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| ProductTypeCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/producttypes/?startIndex={startIndex}&pageSize={pageSize}&sortBy={sortBy}&filter={filter}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("filter", filter);
		url.formatUrl("pageSize", pageSize);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("sortBy", sortBy);
		url.formatUrl("startIndex", startIndex);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getProductType(self,productTypeId, responseFields = None):
		""" Retrieves the details of the product type specified in the request.
		
		Args:
			| productTypeId (int) - Identifier of the product type.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| ProductType 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/producttypes/{productTypeId}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("productTypeId", productTypeId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def addProductType(self,productType, responseFields = None):
		""" Creates a new product type based on the information supplied in the request.
		
		Args:
			| productType(productType) - A product type is like a product template.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| ProductType 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/producttypes/?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(productType).execute();
		return self.client.result();

	
		
	def updateProductType(self,productType, productTypeId, responseFields = None):
		""" Updates one or more properties of a product type.
		
		Args:
			| productType(productType) - A product type is like a product template.
			| productTypeId (int) - Identifier of the product type.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| ProductType 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/producttypes/{productTypeId}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("productTypeId", productTypeId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(productType).execute();
		return self.client.result();

	
		
	def deleteProductType(self,productTypeId):
		""" Deletes the product type by providing the product type ID.
		
		Args:
			| productTypeId (int) - Identifier of the product type.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/producttypes/{productTypeId}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("productTypeId", productTypeId);
		self.client.withResourceUrl(url).execute();

	
	
	