#! /usr/bin/env python
# coding=gbk

import pandas as pd
# import cv2 as cv
import geopandas as gpd
import numpy as np


# calculated from SZCoor_To_BJ54_Link.txt
Affine_matrix_SZ2BJ = np.array([0.9998689001117214,-0.017059728017262597,0.017059728017262583,0.9998689001117212,391088.72254002985,2472704.7089761095])
Affine_matrix_BJ2SZ = np.array([0.9998400529958233,0.017059235828785463,-0.01705923582878549,0.9998400529958231,-433208.6218358641,-2465637.5325179063])

def sz_transform(file_path,type):
    if(type == "sz2wgs"):
        Data_SZ = gpd.read_file(file_path)
        # affine transform
        Data_BJ = Data_SZ.set_geometry(Data_SZ.affine_transform(Affine_matrix_SZ2BJ))

        # set_crs BJ54 114E
        Data_BJ = Data_BJ.set_crs(2435, allow_override = True)
        # to_crs cgcs2000 114E
        Data_cgcs = Data_BJ.to_crs(4547)
        # to_crs wgs84
        Data_wgs = Data_cgcs.to_crs(4326)

        file_path = file_path.replace('.shp', '_WGS.shp')
        print('file written to ' + file_path)
        Data_wgs.to_file(file_path, encoding ='utf-8')

    elif(type == "wgs2sz"):
        Data_wgs = gpd.read_file(file_path)

        # set_crs BJ54 114E
        Data_wgs = Data_wgs.set_crs(4326, allow_override = True)
        # to_crs cgcs2000 114E
        Data_cgcs = Data_wgs.to_crs(4547)
        # to_crs BJ54 114E
        Data_BJ = Data_cgcs.to_crs(2435)

        # affine transform
        Data_SZ = Data_BJ.set_geometry(Data_BJ.affine_transform(Affine_matrix_BJ2SZ))

        file_path = file_path.replace('.shp', '_WGS.shp')
        print('file written to ' + file_path)
        Data_SZ.to_file(file_path, encoding ='utf-8')

    else:
        print("Please choose sz2wgs or wgs2sz")


