/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.process_tree_killer;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ow2.proactive.process_tree_killer.VariableResolver;

public class Util {
    private static final Pattern VARIABLE = Pattern.compile("\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_.]+\\}|\\$)");

    public static String join(Collection<?> strings, String separator) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (Object s : strings) {
            if (first) {
                first = false;
            } else {
                buf.append(separator);
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public static String replaceMacro(String s, Map<String, String> properties) {
        return Util.replaceMacro(s, new VariableResolver.ByMap<String>(properties));
    }

    public static String replaceMacro(String s, VariableResolver<String> resolver) {
        if (s == null) {
            return null;
        }
        int idx = 0;
        Matcher m;
        while ((m = VARIABLE.matcher(s)).find(idx)) {
            String value;
            String key = m.group().substring(1);
            if (key.charAt(0) == '$') {
                value = "$";
            } else {
                if (key.charAt(0) == '{') {
                    key = key.substring(1, key.length() - 1);
                }
                value = resolver.resolve(key);
            }
            if (value == null) {
                idx = m.end();
                continue;
            }
            s = s.substring(0, m.start()) + value + s.substring(m.end());
            idx = m.start() + value.length();
        }
        return s;
    }
}

