# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PoolEndpointConfiguration(Model):
    """The endpoint configuration for a pool.

    :param inbound_nat_pools: A list of inbound NAT pools that can be used to
     address specific ports on an individual compute node externally. The
     maximum number of inbound NAT pools per Batch pool is 5. If the maximum
     number of inbound NAT pools is exceeded the request fails with HTTP status
     code 400.
    :type inbound_nat_pools: list[~azure.mgmt.batch.models.InboundNatPool]
    """

    _validation = {
        'inbound_nat_pools': {'required': True},
    }

    _attribute_map = {
        'inbound_nat_pools': {'key': 'inboundNatPools', 'type': '[InboundNatPool]'},
    }

    def __init__(self, inbound_nat_pools):
        self.inbound_nat_pools = inbound_nat_pools
