# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class FixedScaleSettings(Model):
    """Fixed scale settings for the pool.

    :param resize_timeout: The timeout for allocation of compute nodes to the
     pool. The default value is 15 minutes. The minimum value is 5 minutes. If
     you specify a value less than 5 minutes, the Batch service rejects the
     request with an error; if you are calling the REST API directly, the HTTP
     status code is 400 (Bad Request).
    :type resize_timeout: timedelta
    :param target_dedicated_nodes: The desired number of dedicated compute
     nodes in the pool. At least one of targetDedicatedNodes, targetLowPriority
     nodes must be set.
    :type target_dedicated_nodes: int
    :param target_low_priority_nodes: The desired number of low-priority
     compute nodes in the pool. At least one of targetDedicatedNodes,
     targetLowPriority nodes must be set.
    :type target_low_priority_nodes: int
    :param node_deallocation_option: Determines what to do with a node and its
     running task(s) if the pool size is decreasing. If omitted, the default
     value is Requeue. Possible values include: 'Requeue', 'Terminate',
     'TaskCompletion', 'RetainedData'
    :type node_deallocation_option: str or
     ~azure.mgmt.batch.models.ComputeNodeDeallocationOption
    """

    _attribute_map = {
        'resize_timeout': {'key': 'resizeTimeout', 'type': 'duration'},
        'target_dedicated_nodes': {'key': 'targetDedicatedNodes', 'type': 'int'},
        'target_low_priority_nodes': {'key': 'targetLowPriorityNodes', 'type': 'int'},
        'node_deallocation_option': {'key': 'nodeDeallocationOption', 'type': 'ComputeNodeDeallocationOption'},
    }

    def __init__(self, resize_timeout=None, target_dedicated_nodes=None, target_low_priority_nodes=None, node_deallocation_option=None):
        self.resize_timeout = resize_timeout
        self.target_dedicated_nodes = target_dedicated_nodes
        self.target_low_priority_nodes = target_low_priority_nodes
        self.node_deallocation_option = node_deallocation_option
