#ifndef __PYX_HAVE__axon__odict
#define __PYX_HAVE__axon__odict

struct LinkObject;
struct OrderedDictObject;

/* "axon/odict.pxd":68
 * @cython.freelist(64)
 * @cython.final
 * cdef public class Link[object LinkObject, type LinkType]:             # <<<<<<<<<<<<<<
 *     cdef cython.void *prev
 *     cdef cython.void *next
 */
struct LinkObject {
  PyObject_HEAD
  void *prev;
  void *next;
  PyObject *key;
  PyObject *value;
};

/* "axon/odict.pxd":76
 * cdef Link link_marker
 * 
 * cdef public class OrderedDict[object OrderedDictObject, type OrderedDictType]:             # <<<<<<<<<<<<<<
 *     cdef Link root
 *     cdef dict map
 */
struct OrderedDictObject {
  PyObject_HEAD
  struct LinkObject *root;
  PyObject *map;
};

#ifndef __PYX_HAVE_API__axon__odict

#ifndef __PYX_EXTERN_C
  #ifdef __cplusplus
    #define __PYX_EXTERN_C extern "C"
  #else
    #define __PYX_EXTERN_C extern
  #endif
#endif

#ifndef DL_IMPORT
  #define DL_IMPORT(_T) _T
#endif

__PYX_EXTERN_C DL_IMPORT(PyTypeObject) LinkType;
__PYX_EXTERN_C DL_IMPORT(PyTypeObject) OrderedDictType;

#endif /* !__PYX_HAVE_API__axon__odict */

#if PY_MAJOR_VERSION < 3
PyMODINIT_FUNC initodict(void);
#else
PyMODINIT_FUNC PyInit_odict(void);
#endif

#endif /* !__PYX_HAVE__axon__odict */
