from zope.interface import Attribute, Interface


class ITransformResult(Interface):
    """Data stream, is the result of a transform.

    The data argument takes an object providing Python's iterator protocol.
    In case of textual data, the data has to be Unicode. The same applies
    to the data return value and the values in the subobjects.
    """

    data = Attribute("The default return data from the transform. Needs to "
                     "comply to Python's iterator protocol.")

    metadata = Attribute("The metadata for the result as a dictonary.")

    subobjects = Attribute("A dict of subobject keys and subobjects."
                           "The values should be iterators as well.")

    errors = Attribute("None or a simple string which might include error "
                       "messages generated by the transform.")


class ITransform(Interface):
    """A transformation utility.
    """

    inputs = Attribute("List of mimetypes this transform accepts as inputs. "
                       "Mimetypes syntax follows rfc2045 / rfc4288.")

    output = Attribute("Mimetype this transform outputs. Mimetypes syntax "
                       "follows rfc2045 / rfc4288.")

    name = Attribute("A unique name for the transform.")

    title = Attribute("The title of the transform.")

    description = Attribute("A description of the transform.")

    available = Attribute("A boolean indicating if the transform is available."
                          "This is often set to false at runtime, when an "
                          "external dependency is not available.")

    def transform(data, options=None):
        """
        The transform method takes some data in one of the input formats.
        It returns either an ITransformResult in the output format or None
        if an error occurred.

        The optional options dictonary can be used to provide additional
        arguments to influence the result of the transform, like image sizes
        or quality settings.
        """


class IRankedTransform(Interface):
    """A transformation utility with a score value determining its
    rank when compared to another transform.
    
    Lower rank number means higher priority.
    """

    rank = Attribute("An integer value.")
