# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class Domain(Resource):
    """Information about a domain.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :param name: Resource Name.
    :type name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Resource Location.
    :type location: str
    :param type: Resource type.
    :type type: str
    :param tags: Resource tags.
    :type tags: dict
    :param contact_admin: Administrative contact.
    :type contact_admin: :class:`Contact <azure.mgmt.web.models.Contact>`
    :param contact_billing: Billing contact.
    :type contact_billing: :class:`Contact <azure.mgmt.web.models.Contact>`
    :param contact_registrant: Registrant contact.
    :type contact_registrant: :class:`Contact <azure.mgmt.web.models.Contact>`
    :param contact_tech: Technical contact.
    :type contact_tech: :class:`Contact <azure.mgmt.web.models.Contact>`
    :ivar registration_status: Domain registration status. Possible values
     include: 'Active', 'Awaiting', 'Cancelled', 'Confiscated', 'Disabled',
     'Excluded', 'Expired', 'Failed', 'Held', 'Locked', 'Parked', 'Pending',
     'Reserved', 'Reverted', 'Suspended', 'Transferred', 'Unknown', 'Unlocked',
     'Unparked', 'Updated', 'JsonConverterFailed'
    :vartype registration_status: str or :class:`DomainStatus
     <azure.mgmt.web.models.DomainStatus>`
    :ivar provisioning_state: Domain provisioning state. Possible values
     include: 'Succeeded', 'Failed', 'Canceled', 'InProgress', 'Deleting'
    :vartype provisioning_state: str or :class:`ProvisioningState
     <azure.mgmt.web.models.ProvisioningState>`
    :param name_servers: Name servers.
    :type name_servers: list of str
    :param privacy: <code>true</code> if domain privacy is enabled for this
     domain; otherwise, <code>false</code>.
    :type privacy: bool
    :ivar created_time: Domain creation timestamp.
    :vartype created_time: datetime
    :ivar expiration_time: Domain expiration timestamp.
    :vartype expiration_time: datetime
    :ivar last_renewed_time: Timestamp when the domain was renewed last time.
    :vartype last_renewed_time: datetime
    :param auto_renew: <code>true</code> if the domain should be automatically
     renewed; otherwise, <code>false</code>. Default value: True .
    :type auto_renew: bool
    :ivar ready_for_dns_record_management: <code>true</code> if Azure can
     assign this domain to App Service apps; otherwise, <code>false</code>.
     This value will be <code>true</code> if domain registration status is
     active and
     it is hosted on name servers Azure has programmatic access to.
    :vartype ready_for_dns_record_management: bool
    :param managed_host_names: All hostnames derived from the domain and
     assigned to Azure resources.
    :type managed_host_names: list of :class:`HostName
     <azure.mgmt.web.models.HostName>`
    :param consent: Legal agreement consent.
    :type consent: :class:`DomainPurchaseConsent
     <azure.mgmt.web.models.DomainPurchaseConsent>`
    :param domain_not_renewable_reasons: Reasons why domain is not renewable.
    :type domain_not_renewable_reasons: list of str
    """

    _validation = {
        'id': {'readonly': True},
        'location': {'required': True},
        'registration_status': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_time': {'readonly': True},
        'expiration_time': {'readonly': True},
        'last_renewed_time': {'readonly': True},
        'ready_for_dns_record_management': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'contact_admin': {'key': 'properties.contactAdmin', 'type': 'Contact'},
        'contact_billing': {'key': 'properties.contactBilling', 'type': 'Contact'},
        'contact_registrant': {'key': 'properties.contactRegistrant', 'type': 'Contact'},
        'contact_tech': {'key': 'properties.contactTech', 'type': 'Contact'},
        'registration_status': {'key': 'properties.registrationStatus', 'type': 'DomainStatus'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'ProvisioningState'},
        'name_servers': {'key': 'properties.nameServers', 'type': '[str]'},
        'privacy': {'key': 'properties.privacy', 'type': 'bool'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
        'last_renewed_time': {'key': 'properties.lastRenewedTime', 'type': 'iso-8601'},
        'auto_renew': {'key': 'properties.autoRenew', 'type': 'bool'},
        'ready_for_dns_record_management': {'key': 'properties.readyForDnsRecordManagement', 'type': 'bool'},
        'managed_host_names': {'key': 'properties.managedHostNames', 'type': '[HostName]'},
        'consent': {'key': 'properties.consent', 'type': 'DomainPurchaseConsent'},
        'domain_not_renewable_reasons': {'key': 'properties.domainNotRenewableReasons', 'type': '[str]'},
    }

    def __init__(self, location, name=None, kind=None, type=None, tags=None, contact_admin=None, contact_billing=None, contact_registrant=None, contact_tech=None, name_servers=None, privacy=None, auto_renew=True, managed_host_names=None, consent=None, domain_not_renewable_reasons=None):
        super(Domain, self).__init__(name=name, kind=kind, location=location, type=type, tags=tags)
        self.contact_admin = contact_admin
        self.contact_billing = contact_billing
        self.contact_registrant = contact_registrant
        self.contact_tech = contact_tech
        self.registration_status = None
        self.provisioning_state = None
        self.name_servers = name_servers
        self.privacy = privacy
        self.created_time = None
        self.expiration_time = None
        self.last_renewed_time = None
        self.auto_renew = auto_renew
        self.ready_for_dns_record_management = None
        self.managed_host_names = managed_host_names
        self.consent = consent
        self.domain_not_renewable_reasons = domain_not_renewable_reasons
