/*

The MIT License (MIT)

Copyright (c) 2014 William T. James

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

*/

#include "prf.hxx"
#include <iostream>
#include <cryptopp/osrng.h>

int main()
{
	prf f;
	CryptoPP::AutoSeededRandomPool rng;
	byte key[32];
	
	CryptoPP::Integer limit(rng,0,CryptoPP::Integer::Power2(32*8),CryptoPP::Integer::RandomNumberType::PRIME);
	
	f.set_limit(limit);
	
	rng.GenerateBlock(key,32);
	
	f.set_key(key,32);
	
	std::cout << "p    = " << std::hex << limit << std::endl;
	
	for (int j=0;j<2;j++)
	{
		for (int i=0;i<10;i++)
		{
			std::cout << "r[" << i << "] = " << std::hex << f.evaluate(i) << std::endl;
		}
	}
}