"""constants.py - Various constants used for communicating with NEC large-screen displays.
Revision: 170322
"""
#
#
# Copyright (C) 2016-17 NEC Display Solutions, Ltd
# written by Will Hollingworth <whollingworth at necdisplay.com>
# See LICENSE.rst for details.
#

# timeout in seconds for establishing a TCP connection
connect_timeout = 2.0
# timeout in seconds for waiting for a reply from the display
reply_timeout = 7.0


# opcode definitions
OPCODE_RESET__FACTORY_RESET = 0x0004
OPCODE_RESET__GEOMETRY_RESET = 0x0006
OPCODE_RESET__COLOR_RESET = 0x0008
OPCODE_ADJUST__CLOCK = 0x000e
OPCODE_PICTURE__BRIGHTNESS = 0x0010
OPCODE_PICTURE__CONTRAST = 0x0012
OPCODE_PICTURE__COLOR__SELECT_COLOR_PRESET = 0x0014
OPCODE_PICTURE__COLOR__GAIN__RED_GAIN = 0x0016
OPCODE_PICTURE__COLOR__GAIN__GREEN_GAIN = 0x0018
OPCODE_PICTURE__COLOR__GAIN__BLUE_GAIN = 0x001a
OPCODE_ADJUST__AUTO_SETUP = 0x001e
OPCODE_ADJUST__H_POSITION = 0x0020
OPCODE_ADJUST__V_POSITION = 0x0030
OPCODE_ADJUST__CLOCK_PHASE = 0x003e
OPCODE_PICTURE__COLOR__COLOR_TEMP = 0x0054
OPCODE_INPUT = 0x0060
OPCODE_AUDIO__AUDIO_VOLUME = 0x0062
OPCODE_OSD__OSD_LANGUAGE = 0x0068
OPCODE_PICTURE__COLOR__SATURATION = 0x008a
OPCODE_TV_CHANNEL = 0x008b
OPCODE_PICTURE__SHARPNESS = 0x008c
OPCODE_AUDIO__MUTE = 0x008d
OPCODE_AUDIO__AUDIO_TREBLE = 0x008f
OPCODE_PICTURE__COLOR__TINT = 0x0090
OPCODE_AUDIO__AUDIO_BASS = 0x0091
OPCODE_PICTURE__BLACK_LEVEL = 0x0092
OPCODE_AUDIO__AUDIO_BALANCE = 0x0093
OPCODE_AUDIO__AUDIO_CHANNEL_MODE = 0x0094
OPCODE_PICTURE__COLOR__6_AXIS_COLOR_RED = 0x009b
OPCODE_PICTURE__COLOR__6_AXIS_COLOR_YELLOW = 0x009c
OPCODE_PICTURE__COLOR__6_AXIS_COLOR_GREEN = 0x009d
OPCODE_PICTURE__COLOR__6_AXIS_COLOR_CYAN = 0x009e
OPCODE_PICTURE__COLOR__6_AXIS_COLOR_BLUE = 0x009f
OPCODE_PICTURE__COLOR__6_AXIS_COLOR_MAGENTA = 0x00a0
OPCODE_SETTINGS = 0x00b0
OPCODE_MONITOR_TYPE_READ_ONLY = 0x00b6
OPCODE_POWER_MODE_READ_ONLY = 0x00d6
OPCODE_SCAN_MODE = 0x00da
OPCODE_VCP_VERSION_READ_ONLY = 0x00df
OPCODE_POWER_SAVE = 0x00e1
OPCODE_TOTAL_OPERATING_TIME_30_MIN_READ_ONLY = 0x00fa
OPCODE_KEY_LOCK = 0x00fb
OPCODE_OSD__OSD_TURN_OFF_DELAY = 0x00fc
OPCODE_OPERATING_TIME_ON_30_MIN_READ_ONLY = 0x00ff
OPCODE_PICTURE__PICTURE_MODE = 0x021a
OPCODE_PICTURE__COLOR__COLOR = 0x021f
OPCODE_PICTURE__NOISE_REDUCTION = 0x0220
OPCODE_COLOR_SYSTEM = 0x0221
OPCODE_PICTURE__FILM_MODE = 0x0223
OPCODE_SCAN_CONVERSION = 0x0225
OPCODE_NOISE_REDUCTION = 0x0226
OPCODE_OFF_TIMER_HOURS = 0x022b
OPCODE_AUDIO__MTS_AUDIO = 0x022c
OPCODE_AUTO_BRIGHTNESS = 0x022d
OPCODE_AUDIO__AUDIO_INPUT = 0x022e
OPCODE_RESET__SOUND_RESET = 0x0231
OPCODE_AUDIO__SURROUND_SOUND = 0x0234
OPCODE_OSD__OSD_H_POSITION = 0x0238
OPCODE_OSD__OSD_V_POSITION = 0x0239
OPCODE_OSD__INFORMATION_OSD = 0x023d
OPCODE_MONITOR_ID = 0x023e
OPCODE_IR_CONTROL = 0x023f
OPCODE_INPUT_DETECT = 0x0240
OPCODE_OSD__OSD_ROTATION = 0x0241
OPCODE_ADJUST__H_RESOLUTION = 0x0250
OPCODE_ADJUST__V_RESOLUTION = 0x0251
OPCODE_PICTURE__GAMMA = 0x0268
OPCODE_ADJUST__ASPECT__ZOOM_H_EXPANSION = 0x026c
OPCODE_ADJUST__ASPECT__ZOOM_V_EXPANSION = 0x026d
OPCODE_ADJUST__ASPECT__ZOOM = 0x026f
OPCODE_ADJUST__ASPECT__ASPECT = 0x0270
OPCODE_PIP__PIP_SIZE = 0x0271
OPCODE_PIP__PIP_MODE = 0x0272
OPCODE_PIP__PIP_INPUT_SUB_INPUT = 0x0273
OPCODE_PIP__PIP_H_POSITION = 0x0274
OPCODE_PIP__PIP_V_POSITION = 0x0275
OPCODE_STILL_CAPTURE = 0x0276
OPCODE_SELECT_TEMPERATURE_SENSOR = 0x0278
OPCODE_READ_TEMPERATURE_SENSOR_READ_ONLY = 0x0279
OPCODE_FAN__FAN_SELECT = 0x027a
OPCODE_FAN__FAN_STATUS_READ_ONLY = 0x027b
OPCODE_FAN__FAN_CONTROL = 0x027d
OPCODE_PICTURE__ADAPTIVE_CONTRAST = 0x028d
OPCODE_STANDBY_MODE = 0x029a
OPCODE_SCART_MODE = 0x029e
OPCODE_SPECTRAVIEW_ENGINE__LUMINANCE_SET = 0x02b3
OPCODE_CURRENT_LUMINANCE_READ_ONLY = 0x02b4
OPCODE_BRIGHT_SENSOR_READ_READ_ONLY = 0x02b5
OPCODE_OSD__OSD_TRANSPARENCY = 0x02b8
OPCODE_POWER_LED_INDICATOR = 0x02be
OPCODE_TEST_PATTERN__VT_MODE = 0x02c3
OPCODE_CSC_GAIN = 0x02ca
OPCODE_RESET__MENU_TREE_RESET = 0x02cb
OPCODE_ADJUST__ASPECT__ZOOM_H_POSITION = 0x02cc
OPCODE_ADJUST__ASPECT__ZOOM_V_POSITION = 0x02cd
OPCODE_ADJUST__ASPECT__BASE_ZOOM = 0x02ce
OPCODE_DVI_MODE = 0x02cf
OPCODE_TILE_MATRIX__TILE_MATRIX_H_MONITORS = 0x02d0
OPCODE_TILE_MATRIX__TILE_MATRIX_V_MONITORS = 0x02d1
OPCODE_TILE_MATRIX__TILE_MATRIX_POSITION = 0x02d2
OPCODE_TILE_MATRIX__TILE_MATRIX_MODE = 0x02d3
OPCODE_TILE_MATRIX__TILE_MATRIX_TILE_COMP = 0x02d5
OPCODE_VIDEO_AV_INPUT_POWER_SAVE = 0x02d6
OPCODE_IMAGE_FLIP = 0x02d7
OPCODE_POWER_ON_DELAY = 0x02d8
OPCODE_ADJUST__INPUT_RESOLUTION = 0x02da
OPCODE_SCREEN_SAVER__SCREEN_SAVER_GAMMA = 0x02db
OPCODE_SCREEN_SAVER__SCREEN_SAVER_BRIGHTNESS = 0x02dc
OPCODE_SCREEN_SAVER__SCREEN_SAVER_MOTION = 0x02dd
OPCODE_SIDE_BORDER_COLOR = 0x02df
OPCODE_LONG_CABLE__MANUAL_SYNC_TERMINATE = 0x02e1
OPCODE_SCAN_MODE_ALT = 0x02e3
OPCODE_RESET__ADVANCED_OPTION_RESET = 0x02e4
OPCODE_ENABLE_SCHEDULE = 0x02e5
OPCODE_DISABLE_SCHEDULE = 0x02e6
OPCODE_SPECTRAVIEW_ENGINE__CUSTOM_GAMMA_VALUE = 0x02e8
OPCODE_SIGNAL_INFORMATION = 0x02ea
OPCODE_UNIFORMITY_CORRECTION_LEVEL = 0x02ee
OPCODE_LONG_CABLE__COMP_DVI = 0x02f0
OPCODE_RESET__GAMMA_PROGRAMMABLE_RESET = 0x02f8
OPCODE_GAMMA_PROGRAMMABLE_LUT_SIZE = 0x02f9
OPCODE_ISF = 0x1000
OPCODE_ISF_MODE = 0x1001
OPCODE_ISF_DATA_COPY = 0x1002
OPCODE_PIP__TEXT_TICKER_MODE = 0x1008
OPCODE_PIP__TEXT_TICKER_POSITION = 0x1009
OPCODE_PIP__TEXT_TICKER_SIZE = 0x100a
OPCODE_PIP__TEXT_TICKER_BLEND = 0x100b
OPCODE_PIP__TEXT_TICKER_DETECT = 0x100c
OPCODE_PIP__TEXT_TICKER_FADE_IN = 0x100d
OPCODE_CARBON_FOOTPRINT_G_READ_ONLY = 0x1010
OPCODE_CARBON_FOOTPRINT_KG_READ_ONLY = 0x1011
OPCODE_CARBON_USAGE_G_READ_ONLY = 0x1026
OPCODE_CARBON_USAGE_KG_READ_ONLY = 0x1027
OPCODE_CARBON_FOOTPRINT_SAVINGS_NO_RESET_G_READ_ONLY = 0x1028
OPCODE_CARBON_FOOTPRINT_SAVINGS_NO_RESET_KG_READ_ONLY = 0x1029
OPCODE_CARBON_USAGE_NO_RESET_G_READ_ONLY = 0x102a
OPCODE_CARBON_USAGE_NO_RESET_KG_READ_ONLY = 0x102b
OPCODE_CUSTOM_DETECT_PRIORITY_1 = 0x102e
OPCODE_CUSTOM_DETECT_PRIORITY_2 = 0x102f
OPCODE_CUSTOM_DETECT_PRIORITY_3 = 0x1030
OPCODE_CUSTOM_DETECT_PRIORITY_4 = 0x1031
OPCODE_CUSTOM_DETECT_PRIORITY_5 = 0x1032
OPCODE_AMBIENT_BRIGHTNESS_LOW = 0x1033
OPCODE_AMBIENT_BRIGHTNESS_HIGH = 0x1034
OPCODE_SCREEN_SAVER__SCREEN_SAVER_ZOOM = 0x1035
OPCODE_LONG_CABLE__COMP_MANUAL_POLE = 0x1036
OPCODE_LONG_CABLE__COMP_MANUAL_PEAK = 0x1037
OPCODE_LONG_CABLE__COMP_MANUAL_GAIN = 0x1038
OPCODE_LONG_CABLE__COMP_MANUAL_OFFSET = 0x1039
OPCODE_TEST_PATTERN__TEST_PATTERN_RED_LEVEL = 0x103a
OPCODE_TEST_PATTERN__TEST_PATTERN_GREEN_LEVEL = 0x103b
OPCODE_TEST_PATTERN__TEST_PATTERN_BLUE_LEVEL = 0x103c
OPCODE_LONG_CABLE__COMP_MANUAL_EQUALIZE = 0x103d
OPCODE_EXTERNAL_CONTROL__EXTERNAL_CONTROL = 0x103e
OPCODE_FAN__FAN_SPEED = 0x103f
OPCODE_HDMI_SIGNAL = 0x1040
OPCODE_OPS__OPTION_SLOT_POWER = 0x1041
OPCODE_EDID_SWITCH = 0x1049
OPCODE_TILE_MATRIX__TILE_MATRIX_MEMORY = 0x104a
OPCODE_SPECTRAVIEW_ENGINE__PICTURE_MODE = 0x1050
OPCODE_SPECTRAVIEW_ENGINE__PRESET = 0x1051
OPCODE_SPECTRAVIEW_ENGINE__TARGET_WHITE_POINT_CIE_X_X1000 = 0x1052
OPCODE_SPECTRAVIEW_ENGINE__TARGET_WHITE_POINT_CIE_Y_X1000 = 0x1053
OPCODE_SPECTRAVIEW_ENGINE__BLACK_LEVEL_X10 = 0x1054
OPCODE_SPECTRAVIEW_ENGINE__TARGET_COLORSPACE_RED_CIE_X_X1000 = 0x1055
OPCODE_SPECTRAVIEW_ENGINE__TARGET_COLORSPACE_RED_CIE_Y_X1000 = 0x1056
OPCODE_SPECTRAVIEW_ENGINE__TARGET_COLORSPACE_GREEN_CIE_X_X1000 = 0x1057
OPCODE_SPECTRAVIEW_ENGINE__TARGET_COLORSPACE_GREEN_CIE_Y_X1000 = 0x1058
OPCODE_SPECTRAVIEW_ENGINE__TARGET_COLORSPACE_BLUE_CIE_X_X1000 = 0x1059
OPCODE_SPECTRAVIEW_ENGINE__TARGET_COLORSPACE_BLUE_CIE_Y_X1000 = 0x105a
OPCODE_SPECTRAVIEW_ENGINE__COLOR_VISION_EMULATION = 0x105b
OPCODE_SPECTRAVIEW_ENGINE__METAMERISM = 0x105c
OPCODE_SPECTRAVIEW_ENGINE__PRINT_PREVIEW_3D_LUT = 0x1069
OPCODE_SPECTRAVIEW_ENGINE__3D_LUTPROG_GAMMA_SELECT = 0x106b
OPCODE_SPECTRAVIEW_ENGINE__RESET_PICTURE_MODE = 0x1070
OPCODE_SPECTRAVIEW_ENGINE__TARGET_COLORSPACE_RESET = 0x1071
OPCODE_HUMAN_SENSING__HUMAN_SENSING_MODE = 0x1075
OPCODE_HUMAN_SENSING__HUMAN_SENSING_READING = 0x1076
OPCODE_HUMAN_SENSING__HUMAN_SENSING_THRESHOLD = 0x1077
OPCODE_HUMAN_SENSING__HUMAN_SENSING_START_TIME = 0x1078
OPCODE_BNC_MODE = 0x107e
OPCODE_GROUP_ID = 0x107f
OPCODE_AUDIO__PIP_AUDIO = 0x1080
OPCODE_AUDIO__AUDIO_LINE_OUT = 0x1081
OPCODE_PIP__KEEP_PIP_MODE = 0x1082
OPCODE_PIP__PIP_ASPECT = 0x1083
OPCODE_CLOSED_CAPTION = 0x1084
OPCODE_EXTERNAL_CONTROL__ID_ALL_REPLY = 0x1085
OPCODE_INPUT_CHANGE = 0x1086
OPCODE_MOTION_COMPENSATION_120HZ = 0x1087
OPCODE_EDGE_COMPENSATION__MURA = 0x1088
OPCODE_OSD__OSD_OFF = 0x1089
OPCODE_SHUTDOWN = 0x108a
OPCODE_OPTION_LAN_ALERT = 0x108b
OPCODE_EDGE_COMP_TYPE = 0x108c
OPCODE_EDGE_COMP_BRIGHTNESS = 0x108d
OPCODE_DSUB_MODE = 0x108e
OPCODE_OSD__DISPLAY_ID_ON_OSD = 0x1095
OPCODE_EXPERT_ANALOG_VIDEO__ADC_OFFSET_BASE_RED = 0x1098
OPCODE_EXPERT_ANALOG_VIDEO__ADC_OFFSET_BASE_GREEN = 0x1099
OPCODE_EXPERT_ANALOG_VIDEO__ADC_OFFSET_BASE_BLUE = 0x109a
OPCODE_EXPERT_ANALOG_VIDEO__ADC_OFFSET_RED = 0x109b
OPCODE_EXPERT_ANALOG_VIDEO__ADC_OFFSET_GREEN = 0x109c
OPCODE_EXPERT_ANALOG_VIDEO__ADC_OFFSET_BLUE = 0x109d
OPCODE_EXPERT_ANALOG_VIDEO__ADC_GAIN_RED = 0x109e
OPCODE_EXPERT_ANALOG_VIDEO__ADC_GAIN_GREEN = 0x109f
OPCODE_EXPERT_ANALOG_VIDEO__ADC_GAIN_BLUE = 0x10a0
OPCODE_DIGITAL_CLOSED_CAPTION = 0x10a1
OPCODE_AUDIO__AUDIO_VOLUME_STEP = 0x10ad
OPCODE_AUDIO__OPTION_SLOT_AUDIO = 0x10b0
OPCODE_PIP__PBP_TYPE = 0x10b5
OPCODE_SCREEN_MUTE = 0x10b6
OPCODE_AUTO_ADJUST = 0x10b7
OPCODE_OSD__OSD_FLIP = 0x10b8
OPCODE_PIP__PIP_SIZE__VARIABLE = 0x10b9
OPCODE_MEMO_DISPLAY = 0x10ba
OPCODE_POWER_ON_DELAY_LINK_TO_ID = 0x10bc
OPCODE_DDCI = 0x10be
OPCODE_OPS__INTERNAL_PC_OFF_WARNING = 0x10c0
OPCODE_OPS__INTERNAL_PC_AUTO_OFF = 0x10c1
OPCODE_OPS__INTERNAL_PC_START = 0x10c2
OPCODE_OPS__INTERNAL_PC_FORCE_QUIT = 0x10c3
OPCODE_TOUCH_PANEL_POWER_SUPPLY = 0x10c4
OPCODE_TOUCH_PANEL_PC_SOURCE = 0x10c5
OPCODE_HUMAN_SENSING__HUMAN_SENSING_BACKLIGHT = 0x10c6
OPCODE_HUMAN_SENSING__HUMAN_SENSING_VOLUME = 0x10c7
OPCODE_ROOM_LIGHT_SENSING = 0x10c8
OPCODE_ROOM_AMBIENT_BRIGHTNESS_MAX = 0x10c9
OPCODE_INPUT_CHANGE_SUPER_INPUT_1 = 0x10ce
OPCODE_INPUT_CHANGE_SUPER_INPUT_2 = 0x10cf
OPCODE_HUMAN_SENSING__HUMAN_SENSING_INPUT = 0x10d0
OPCODE_POWER_SAVE_TIMER = 0x10d2
OPCODE_LAN_POWER = 0x10d3
OPCODE_IR_LOCK_SETTINGS_MODE_SELECT = 0x10d4
OPCODE_IR_LOCK_SETTINGS_POWER = 0x10d5
OPCODE_IR_LOCK_SETTINGS_VOLUME = 0x10d6
OPCODE_IR_LOCK_SETTINGS_MIN_VOLUME = 0x10d7
OPCODE_IR_LOCK_SETTINGS_MAX_VOLUME = 0x10d8
OPCODE_IR_LOCK_SETTINGS_INPUT = 0x10d9
OPCODE_IR_LOCK_SETTINGS_UNLOCK_SELECT_1 = 0x10da
OPCODE_IR_LOCK_SETTINGS_UNLOCK_SELECT_2 = 0x10db
OPCODE_IR_LOCK_SETTINGS_UNLOCK_SELECT_3 = 0x10dc
OPCODE_HUMAN_SENSING__HUMAN_SENSING_BACKLIGHT_ONOFF = 0x10dd
OPCODE_HUMAN_SENSING__HUMAN_SENSING_VOLUME_ONOFF = 0x10de
OPCODE_HUMAN_SENSING__HUMAN_SENSING_INPUT_ONOFF = 0x10df
OPCODE_FAN__FAN_CONTROL_SENSOR_1_SET_TEMPERATURE = 0x10e0
OPCODE_FAN__FAN_CONTROL_SENSOR_1_TEMPERATURE_FROM_MAX = 0x10e1
OPCODE_FAN__FAN_CONTROL_SENSOR_2_SET_TEMPERATURE = 0x10e2
OPCODE_FAN__FAN_CONTROL_SENSOR_2_TEMPERATURE_FROM_MAX = 0x10e3
OPCODE_FAN__FAN_CONTROL_SENSOR_3_SET_TEMPERATURE = 0x10e4
OPCODE_FAN__FAN_CONTROL_SENSOR_3_TEMPERATURE_FROM_MAX = 0x10e5
OPCODE_VIDEO_LOOP_OUT_SETTING = 0x10ea
OPCODE_INTELLIGENT_WIRELESS_DATA = 0x10ec
OPCODE_RF_TAG_DESTINATION_ID_READ_ONLY = 0x10ee
OPCODE_BOWLING_MODE = 0x10ef
OPCODE_HUMAN_SENSING__HUMAN_SENSOR_ATTACHMENT_STATUS_READ_ONLY = 0x10f0
OPCODE_DISPLAYPORT_TERMINAL_SELECT = 0x10f1
OPCODE_DISPLAYPORT_TERMINAL_TYPE = 0x10f2
OPCODE_EXTENDED_POWER_SAVE = 0x10f5
OPCODE_AUTO_POWER_SAVE_TIME_SEC_X5 = 0x10f6
OPCODE_AUTO_STANDBY_TIME_SEC_X5 = 0x10f7
OPCODE_TILE_MATRIX__FRAME_COMP_MODE = 0x1101
OPCODE_TILE_MATRIX__FRAME_COMP_AUTO_VALUE = 0x1102
OPCODE_TILE_MATRIX__FRAME_COMP_MANUAL_VALUE = 0x1103
OPCODE_TILE_MATRIX__V_SCAN_REVERSE_MODE = 0x1104
OPCODE_TILE_MATRIX__V_SCAN_REVERSE_MANUAL = 0x1105
OPCODE_INPUT_ALT = 0x1106
OPCODE_UHD_UPSCALING = 0x1109
OPCODE_PIP__ACTIVE_WINDOW = 0x110b
OPCODE_PIP__ACTIVE_FRAME = 0x110d
OPCODE_PIP__INPUT_SELECT_WINDOW_1 = 0x110e
OPCODE_PIP__INPUT_SELECT_WINDOW_2 = 0x110f
OPCODE_PIP__INPUT_SELECT_WINDOW_3 = 0x1110
OPCODE_PIP__INPUT_SELECT_WINDOW_4 = 0x1111
OPCODE_PIP__PIVOT_WINDOW_1 = 0x1112
OPCODE_PIP__PIVOT_WINDOW_2 = 0x1113
OPCODE_PIP__PIVOT_WINDOW_3 = 0x1114
OPCODE_PIP__PIVOT_WINDOW_4 = 0x1115
OPCODE_PIP__PIVOT_ALL_WINDOWS = 0x1116
OPCODE_OSD__COMMUNICATIONS_INFORMATION = 0x1117
OPCODE_HDMIDVI_SELECT = 0x1118
OPCODE_DISPLAY_PORT_BIT_RATE = 0x1119
OPCODE_LONG_CABLE__COMP_DVI2 = 0x111a
OPCODE_LONG_CABLE__COMP_HDMI1 = 0x111b
OPCODE_LONG_CABLE__COMP_HDMI2 = 0x111c
OPCODE_LONG_CABLE__COMP_HDMI3 = 0x111d
OPCODE_LONG_CABLE__COMP_HDMI4 = 0x111e
OPCODE_INPUT_CONFIGURATION__PRESET_1_MODE = 0x111f
OPCODE_INPUT_CONFIGURATION__PRESET_2_MODE = 0x1120
OPCODE_INPUT_CONFIGURATION__PRESET_3_MODE = 0x1121
OPCODE_INPUT_CONFIGURATION__TOP_LEFT = 0x1122
OPCODE_INPUT_CONFIGURATION__TOP_RIGHT = 0x1123
OPCODE_INPUT_CONFIGURATION__BOTTOM_LEFT = 0x1124
OPCODE_INPUT_CONFIGURATION__BOTTOM_RIGHT = 0x1125
OPCODE_INPUT_CONFIGURATION__LEFT = 0x1126
OPCODE_INPUT_CONFIGURATION__RIGHT = 0x1127
OPCODE_INPUT_CONFIGURATION__TOP = 0x1128
OPCODE_INPUT_CONFIGURATION__BOTTOM = 0x1129
OPCODE_TEXT_TICKER__WINDOW_1 = 0x112a
OPCODE_TEXT_TICKER__WINDOW_2 = 0x112b
OPCODE_ADJUST__ASPECT__EXTENSION_ZOOM = 0x112c
OPCODE_ADJUST__ASPECT__EXTENSION_H_ZOOM = 0x112d
OPCODE_ADJUST__ASPECT__EXTENSION_V_ZOOM = 0x112e
OPCODE_SPECTRAVIEW_ENGINE__SPECTRAVIEW_ENGINE_MODE = 0x1147
OPCODE_HUMAN_SENSING_HUMAN_SENSOR_STATUS = 0x114c
OPCODE_COMMAND_TRANSFER = 0x114f
OPCODE_OSD_CLOSE_OSD = 0x1157
OPCODE_MULTI_INPUT_TERMINAL_SETTINGS_DISPLAYPORT = 0x1167
OPCODE_MULTI_INPUT_TERMINAL_SETTINGS_HDMI = 0x1168
OPCODE_CONTROL_IR_LOCK_SETTINGS_CHANNEL = 0x1169
OPCODE_CONTROL_KEY_LOCK_SETTINGS_MODE_SELECT = 0x116a
OPCODE_CONTROL_KEY_LOCK_SETTINGS_POWER = 0x116b
OPCODE_CONTROL_KEY_LOCK_SETTINGS_VOLUME = 0x116c
OPCODE_CONTROL_KEY_LOCK_SETTINGS_MIN_VOLUME = 0x116d
OPCODE_CONTROL_KEY_LOCK_SETTINGS_MAX_VOLUME = 0x116e
OPCODE_CONTROL_KEY_LOCK_SETTINGS_INPUT = 0x116f
OPCODE_CONTROL_KEY_LOCK_SETTINGS_CHANNEL = 0x1170
OPCODE_CONTROL_POWER_INDICATOR_SCHEDULE_INDICATOR = 0x1171
OPCODE_CONTROL_USB_USB_TOUCH_POWER = 0x1172
OPCODE_CONTROL_USB_USB_EXTERNAL_CONTROL = 0x1173
OPCODE_CONTROL_USB_USB_PC_SOURCE = 0x1174
OPCODE_CONTROL_USB_USB_POWER = 0x1175
OPCODE_CONTROL_CEC = 0x1176
OPCODE_CONTROL_CEC_AUTO_TURN_OFF = 0x1177
OPCODE_CONTROL_CEC_AUDIO_RECEIVER = 0x1178
OPCODE_CONTROL_CEC_SEARCH_DEVICE = 0x1179
OPCODE_OSD_KEY_GUIDE = 0x117a
OPCODE_POWER_SAVE_MESSAGE = 0x117b
OPCODE_COMPUTE_MODULE_POWER_SUPPLY = 0x117c
OPCODE_COMPUTE_MODULE_AUTO_POWER_ON = 0x117d
OPCODE_COMPUTE_MODULE_USB_BOOT_MODE = 0x117e
OPCODE_COMPUTE_MODULE_IR_SIGNAL = 0x117f
OPCODE_COMPUTE_MODULE_MONITOR_CONTROL = 0x1180
OPCODE_COMPUTE_MODULE_SHUTDOWN_SIGNAL = 0x1181
OPCODE_COMPUTE_MODULE_POWER_SUPPLY_OFF_DELAY = 0x1182
OPCODE_DP_POWER_SETTING = 0x1183
OPCODE_DUAL_LINK_HDCP_SWITCH = 0x1184
OPCODE_INTERNAL_TOUCH = 0x1185
OPCODE_HDMI_SW_THROUGH = 0x1186
OPCODE_COMPUTE_MODULE_WATCHDOG_TIMER_ENABLE = 0x119B
OPCODE_COMPUTE_MODULE_WATCHDOG_TIMER_START_UP_TIME = 0x119C
OPCODE_COMPUTE_MODULE_WATCHDOG_TIMER_PERIOD_TIME = 0x119D
OPCODE_COMPUTE_MODULE_WATCHDOG_TIMER_RESET = 0x119E
OPCODE_TOTAL_OPERATING_TIME__UPPER___MINUTES___READ_ONLY_ = 0x11fa
OPCODE_TOTAL_OPERATING_TIME__LOWER___MINUTES___READ_ONLY_ = 0x11fb
OPCODE_OPERATING_TIME_ON__UPPER___MINUTES___READ_ONLY_ = 0x11fe
OPCODE_OPERATING_TIME_ON__LOWER___MINUTES___READ_ONLY_ = 0x11ff

# dictionary of codes for use when sending IR remote button emulation commands
# e.g. command_send_ir_remote_control_code() and helper_send_ir_remote_control_codes()
PD_IR_COMMAND_CODES = {
    'power': 0x03,
    'standby': 0x4e,
    'power_on': 0x52,
    'menu': 0x20,
    'display': 0x19,
    'up': 0x15,
    '-': 0x21,
    'set': 0x23,
    '+': 0x22,
    'auto': 0x1c,
    'down': 0x14,
    'exit': 0x1f,
    '1': 0x08,
    '2': 0x09,
    '3': 0x0a,
    '4': 0x0b,
    '5': 0x0c,
    '6': 0x0d,
    '7': 0x0e,
    '8': 0x0f,
    '9': 0x10,
    '0': 0x12,
    'hyphen': 0x44,
    'ent': 0x45,
    'vol+': 0x17,
    'vol-': 0x16,
    'ch+': 0x33,
    'ch-': 0x32,
    'guide': 0x34,
    'mute': 0x1b,
    'dvi': 0x2d,
    'displayport': 0x55,
    'vga': 0x04,
    'rgbhv': 0x2e,
    'hdmi': 0x42,
    'dvdhd': 0x31,
    'ypbpr': 0x31,
    'video': 0x06,
    'svideo': 0x54,
    'dvi1': 0x65,
    'dvi2': 0x5b,
    'hdmi1': 0x64,
    'hdmi2': 0x58,
    'hdmi3': 0x59,
    'hdmi4': 0x5a,
    'media_player': 0x68,
    'compute_module': 0x69,
    'picture_mode': 0x1d,
    'aspect': 0x29,
    'sound': 0x43,
    'option': 0x39,
    'image_flip': 0x57,
    'option_menu': 0x56,
    'audio_input': 0x1e,
    'active_picture': 0x5f,
    'multipicture_on_off': 0x24,
    'multipicture_mode': 0x63,
    'multipicture_change': 0x26,
    'multipicture_picture_aspect': 0x62,
    'multipicture_rotate': 0x60,
    'multipicture_rotate_all': 0x61,
    'preset1': 0x5c,
    'preset2': 0x5d,
    'preset3': 0x5e
}


# dictionary of diagnostic error codes that can be returned by the display
# e.g. helper_self_diagnosis_status_text() and command_self_diagnosis_status_read()
DISPLAY_DIAGNOSTIC_ERROR_CODES = {
    0x00: "Normal",
    0x70: "Standby-power +3.3V abnormality",
    0x71: "Standby-power +5V abnormality",
    0x72: "Panel-power +12V abnormality",
    0x73: "Main-power +2.5V abnormality",
    0x74: "Main-power +1.8V abnormality",
    0x75: "Main-power +5V abnormality",
    0x76: "Sub-power +3.3V abnormality",
    0x77: "Main-power +3.3V abnormality",
    0x78: "Inverter power/Option slot2 power +24V Abnormality",
    0x80: "Cooling fan-1 abnormality",
    0x81: "Cooling fan-2 abnormality",
    0x82: "Cooling fan-3 abnormality)",
    0x83: "COMPUTE MODULE Cooling fan abnormality",
    0x90: "LED Backlight abnormality",
    0x91: "LED Backlight abnormality",
    0xA0: "Temperature abnormality -shutdown",
    0xA1: "Temperature abnormality - half brightness",
    0xA2: "SENSOR reached at the temperature that the user had specified.",
    0xB0: "No signal",
    0xC0: "Option board (SLOT3) abnormality",
    0xD0: "PROOF OF PLAY buffer full",
    0xD1: "RTC error",
    0xE0: "System/EEPROM error",
    0xE1: "Pegasus error",
    0xE2: "LPM-Mission communication error",
    0xE3: "NFC-EEPROM error",
    0xE4: "CPLD error"
}

# dictionary of fan status modes returned by the display
DISPLAY_FAN_STATUS = {
    0x00: "Off",
    0x01: "On",
    0x02: "Error"
}

# dictionary of power state modes returned by the display
PD_POWER_STATES = {
    'Error': 0,
    'On': 1,
    'Standby': 2,
    'Suspend': 3,
    'Off': 4,
}
