/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.utils;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import org.objectweb.proactive.utils.LinePosition;

public class PrefixPrintStream
extends PrintStream {
    private final String prefix;
    private final LinePosition linePosition = new LinePosition();
    String lineSeparator = System.getProperty("line.separator");

    public PrefixPrintStream(OutputStream out, String prefix) {
        super(out, true);
        this.prefix = prefix;
    }

    @Override
    public void println() {
        super.println();
        this.linePosition.reset();
    }

    @Override
    public void println(boolean x) {
        super.println(x);
        this.linePosition.reset();
    }

    @Override
    public void println(char x) {
        super.println(x);
        this.linePosition.reset();
    }

    @Override
    public void println(int x) {
        super.println(x);
        this.linePosition.reset();
    }

    @Override
    public void println(long x) {
        super.println(x);
        this.linePosition.reset();
    }

    @Override
    public void println(float x) {
        super.println(x);
        this.linePosition.reset();
    }

    @Override
    public void println(double x) {
        super.println(x);
        this.linePosition.reset();
    }

    @Override
    public void println(char[] x) {
        super.println(x);
        this.linePosition.reset();
    }

    @Override
    public void println(String x) {
        super.println(x);
        this.linePosition.reset();
    }

    @Override
    public void println(Object x) {
        super.println(x);
        this.linePosition.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        PrefixPrintStream prefixPrintStream = this;
        synchronized (prefixPrintStream) {
            try {
                this.ensureOpen();
                this.out.flush();
            }
            catch (IOException x) {
                this.setError();
            }
            boolean isNewLine = false;
            for (StackTraceElement elem : Thread.currentThread().getStackTrace()) {
                if (!elem.getClassName().equals(PrintStream.class.getName()) || !elem.getMethodName().equals("newLine")) continue;
                isNewLine = true;
                break;
            }
            if (isNewLine) {
                this.linePosition.reset();
            }
        }
    }

    @Override
    public void write(int c) {
        this.maybePrintPrefix();
        super.write(c);
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.maybePrintPrefix();
        super.write(buf, off, len);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.maybePrintPrefix();
        super.write(buf);
    }

    public void write(String s) throws IOException {
        this.maybePrintPrefix();
        this.write(s.getBytes());
        if (s.contains(this.lineSeparator)) {
            this.linePosition.reset();
        }
    }

    @Override
    public PrintStream printf(String format, Object ... args) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrintStream printf(Locale l, String format, Object ... args) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrintStream format(String format, Object ... args) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrintStream format(Locale l, String format, Object ... args) {
        throw new UnsupportedOperationException();
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybePrintPrefix() {
        if (this.linePosition.atStart()) {
            try {
                PrefixPrintStream prefixPrintStream = this;
                synchronized (prefixPrintStream) {
                    this.ensureOpen();
                    this.out.write(this.prefix.getBytes());
                }
            }
            catch (InterruptedIOException x) {
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                this.setError();
            }
            this.linePosition.update();
        }
    }
}

