/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.rest.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobInfoData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobStateData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.SchedulerUserData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskInfoData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.eventing.EventNotification;

public class EventCodecUtil {
    private static final ObjectMapper mapper;

    private EventCodecUtil() {
    }

    public static <T> T fromJsonString(String jsonString, Class<T> valueType) {
        try {
            return (T)mapper.readValue(jsonString, valueType);
        }
        catch (Exception e) {
            throw new RuntimeException("Parser error for jsonString : " + jsonString, e);
        }
    }

    public static String toJsonString(Object value) {
        try {
            return mapper.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Parser error.", e);
        }
    }

    static {
        SimpleModule module = new SimpleModule("JsonUtilsMapper", new Version(1, 0, 0, null));
        EventNotificationDeserializer deserializer = new EventNotificationDeserializer();
        module.addDeserializer(EventNotification.class, (JsonDeserializer)deserializer);
        mapper = new ObjectMapper();
        mapper.registerModule((Module)module);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private static class EventNotificationDeserializer
    extends StdDeserializer<EventNotification> {
        private static final long serialVersionUID = 131L;

        protected EventNotificationDeserializer() {
            super(EventNotification.class);
        }

        public EventNotification deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            EventNotification notification = new EventNotification();
            ObjectMapper mapper = (ObjectMapper)jp.getCodec();
            ObjectNode root = (ObjectNode)mapper.readTree(jp);
            String actionString = root.get("action").asText();
            notification.setAction(EventNotification.Action.valueOf((String)actionString));
            JsonNode data = root.get("data");
            switch (notification.getAction()) {
                case JOB_SUBMITTED: {
                    notification.setData(mapper.readValue(data.toString(), JobStateData.class));
                    break;
                }
                case JOB_STATE_UPDATED: {
                    notification.setData(mapper.readValue(data.toString(), JobInfoData.class));
                    break;
                }
                case JOB_FULL_DATA_UPDATED: {
                    notification.setData(mapper.readValue(data.toString(), JobStateData.class));
                    break;
                }
                case TASK_STATE_UPDATED: {
                    notification.setData(mapper.readValue(data.toString(), TaskInfoData.class));
                    break;
                }
                case USERS_UPDATED: {
                    notification.setData(mapper.readValue(data.toString(), SchedulerUserData.class));
                    break;
                }
            }
            notification.setSchedulerEvent(root.get("schedulerEvent").asText());
            return notification;
        }
    }
}

