/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.util.logforwarder;

import java.net.URI;
import org.apache.log4j.Appender;
import org.ow2.proactive.scheduler.common.util.logforwarder.AppenderProvider;
import org.ow2.proactive.scheduler.common.util.logforwarder.LogForwardingException;
import org.ow2.proactive.scheduler.common.util.logforwarder.LogForwardingProvider;
import org.ow2.proactive.scheduler.common.util.logforwarder.LoggingEventProcessor;

public final class LogForwardingService {
    private final LoggingEventProcessor loggingEventProcessor;
    private URI serverConnection = null;
    private boolean initialized = false;
    private String providerClassname;
    private LogForwardingProvider provider;

    public LogForwardingService(String providerClassname) {
        this.providerClassname = providerClassname;
        this.loggingEventProcessor = new LoggingEventProcessor();
    }

    public void addAppender(String loggerName, Appender appender) {
        this.loggingEventProcessor.addAppender(loggerName, appender);
    }

    public void removeAllAppenders(String loggerName) {
        this.loggingEventProcessor.removeAllAppenders(loggerName);
    }

    public void removeLogger(String loggerName) {
        this.loggingEventProcessor.removeLogger(loggerName);
    }

    public final synchronized void initialize() throws LogForwardingException {
        try {
            if (this.initialized) {
                throw new IllegalStateException("The service has already been initialized.");
            }
            Class<?> providerClass = Class.forName(this.providerClassname);
            this.provider = (LogForwardingProvider)providerClass.newInstance();
            this.serverConnection = this.provider.createServer(this.loggingEventProcessor);
            this.initialized = true;
        }
        catch (ClassNotFoundException e) {
            throw new LogForwardingException("LogForwardingProvider class cannot be found.", e);
        }
        catch (InstantiationException e) {
            throw new LogForwardingException("LogForwardingProvider cannot be instanciated.", e);
        }
        catch (IllegalAccessException e) {
            throw new LogForwardingException("LogForwardingProvider cannot be instanciated.", e);
        }
        catch (ClassCastException e) {
            throw new LogForwardingException("Class defined as LogForwardingProvider is not a LogForwardingProvider.", e);
        }
    }

    public final synchronized void terminate() throws LogForwardingException {
        this.loggingEventProcessor.removeAllAppenders();
        this.loggingEventProcessor.shutdown();
        this.serverConnection = null;
        this.initialized = false;
        this.provider.terminateServer();
        this.provider = null;
        this.providerClassname = null;
    }

    public final synchronized AppenderProvider getAppenderProvider() throws LogForwardingException {
        if (this.initialized) {
            return this.provider.createAppenderProvider(this.serverConnection);
        }
        throw new IllegalStateException("The service has not been initialized. Cannot create appender provider.");
    }

    public final synchronized URI getServerURI() {
        if (this.initialized) {
            return this.serverConnection;
        }
        throw new IllegalStateException("The service has not been initialized.");
    }
}

