/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scheduler.common.exception.UserException;
import org.ow2.proactive.scheduler.common.job.Job;
import org.ow2.proactive.scheduler.common.job.JobId;
import org.ow2.proactive.scheduler.common.job.JobType;
import org.ow2.proactive.scheduler.common.task.Task;
import org.ow2.proactive.scheduler.common.task.flow.FlowActionType;
import org.ow2.proactive.scheduler.common.task.flow.FlowScript;
import org.ow2.proactive.scheduler.common.util.LogFormatter;

@PublicAPI
public class TaskFlowJob
extends Job {
    private int taskCountForUnSetTaskName = 1;
    private Map<String, Task> tasks = new LinkedHashMap<String, Task>();
    private static final long serialVersionUID = 131L;

    @Override
    public JobType getType() {
        return JobType.TASKSFLOW;
    }

    public void addTask(Task task) throws UserException {
        if (task.getName() == null) {
            throw new UserException("The name of the task must not be null !");
        }
        if (task.getName().equals("NOT SET")) {
            task.setName("task_" + this.taskCountForUnSetTaskName);
            ++this.taskCountForUnSetTaskName;
        }
        if (this.tasks.containsKey(task.getName())) {
            throw new UserException("The name of the task is already used : " + task.getName());
        }
        this.tasks.put(task.getName(), task);
    }

    public void addTasks(List<Task> tasks) throws UserException {
        for (Task task : tasks) {
            this.addTask(task);
        }
    }

    public ArrayList<Task> getTasks() {
        return new ArrayList<Task>(this.tasks.values());
    }

    public Set<Task> findTerminalTasks() {
        HashSet<Task> ifParents = new HashSet<Task>();
        HashSet<String> ifChildrenTaskNames = new HashSet<String>();
        HashSet<String> elseChildrenTaskNames = new HashSet<String>();
        HashSet<Task> terminalTasks = new HashSet<Task>();
        for (Task task : this.tasks.values()) {
            FlowScript flowScript = task.getFlowScript();
            if (flowScript != null && flowScript.getActionType().equals(FlowActionType.IF.toString())) {
                ifParents.add(task);
                if (flowScript.getActionTarget() != null) {
                    ifChildrenTaskNames.add(flowScript.getActionTarget());
                }
                if (flowScript.getActionTargetElse() != null) {
                    elseChildrenTaskNames.add(flowScript.getActionTargetElse());
                }
            }
            terminalTasks.add(task);
        }
        for (Task task : this.tasks.values()) {
            if (task.getDependencesList() != null) {
                terminalTasks.removeAll(task.getDependencesList());
            }
            if (ifParents.contains(task)) {
                terminalTasks.remove(task);
            }
            if (ifChildrenTaskNames.contains(task.getName())) {
                terminalTasks.removeAll(this.findSubTree(task));
            }
            if (!elseChildrenTaskNames.contains(task.getName())) continue;
            terminalTasks.removeAll(this.findSubTree(task));
        }
        return terminalTasks;
    }

    private Set<Task> findSubTree(Task parentTask) {
        int lastChildrenSetSize;
        HashSet<Task> childrenSet = new HashSet<Task>();
        this.addTaskToChildrenSet(childrenSet, parentTask);
        do {
            lastChildrenSetSize = childrenSet.size();
            for (Task task : this.tasks.values()) {
                HashSet<Task> dependencySet;
                if (task.getDependencesList() == null || Sets.intersection(dependencySet = new HashSet<Task>(task.getDependencesList()), childrenSet).size() <= 0) continue;
                this.addTaskToChildrenSet(childrenSet, task);
            }
        } while (childrenSet.size() > lastChildrenSetSize);
        return childrenSet;
    }

    private void addTaskToChildrenSet(Set<Task> childrenSet, Task task) {
        childrenSet.add(task);
        if (task.getFlowScript() != null && task.getFlowScript().getActionType().equals(FlowActionType.IF.toString())) {
            childrenSet.add(this.getTask(task.getFlowScript().getActionTarget()));
            childrenSet.add(this.getTask(task.getFlowScript().getActionTargetElse()));
            childrenSet.add(this.getTask(task.getFlowScript().getActionContinuation()));
        }
    }

    public Task getTask(String name) {
        return this.tasks.get(name);
    }

    @Override
    public JobId getId() {
        return null;
    }

    @Override
    public String display() {
        String nl = System.lineSeparator();
        return super.display() + nl + LogFormatter.addIndent(this.displayAllTasks());
    }

    private String displayAllTasks() {
        String nl = System.lineSeparator();
        StringBuilder answer = new StringBuilder("Tasks = {");
        answer.append(nl);
        for (String tid : this.tasks.keySet()) {
            answer.append(LogFormatter.addIndent(this.tasks.get(tid).display())).append(nl).append(nl);
        }
        answer.append("}");
        return answer.toString();
    }
}

