
import logging
from pyvisdk.exceptions import InvalidArgumentError

########################################
# Automatically generated, do not edit.
########################################

log = logging.getLogger(__name__)

def ClusterDrsFaults(vim, *args, **kwargs):
    '''The faults generated by DRS when it tries to make recommendations for rule
    enforcement, power management, etc., and indexed in a tree structure with
    reason for recommendations and VM to migrate (optional) as the index keys.'''
    
    obj = vim.client.factory.create('ns0:ClusterDrsFaults')

    # do some validation checking...
    if (len(args) + len(kwargs)) < 2:
        raise IndexError('Expected at least 3 arguments got: %d' % len(args))

    required = [ 'faultsByVm', 'reason' ]
    optional = [ 'dynamicProperty', 'dynamicType' ]

    for name, arg in zip(required+optional, args):
        setattr(obj, name, arg)

    for name, value in kwargs.items():
        if name in required + optional:
            setattr(obj, name, value)
        else:
            raise InvalidArgumentError("Invalid argument: %s.  Expected one of %s" % (name, ", ".join(required + optional)))

    return obj
    