# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class ApiProperties(Model):
    """ApiProperties.

    :param server_version: Describes the ServerVersion of an a MongoDB
     account. Possible values include: '3.2', '3.6'
    :type server_version: str or ~azure.mgmt.cosmosdb.models.ServerVersion
    """

    _attribute_map = {
        'server_version': {'key': 'serverVersion', 'type': 'str'},
    }

    def __init__(self, *, server_version=None, **kwargs) -> None:
        super(ApiProperties, self).__init__(**kwargs)
        self.server_version = server_version


class ARMProxyResource(Model):
    """The resource model definition for a ARM proxy resource. It will have
    everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ARMProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ARMResourceProperties(Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
    }

    def __init__(self, *, location: str=None, tags=None, identity=None, **kwargs) -> None:
        super(ARMResourceProperties, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.identity = identity


class AutoscaleSettings(Model):
    """AutoscaleSettings.

    :param max_throughput: Represents maximum throughput, the resource can
     scale up to.
    :type max_throughput: int
    """

    _attribute_map = {
        'max_throughput': {'key': 'maxThroughput', 'type': 'int'},
    }

    def __init__(self, *, max_throughput: int=None, **kwargs) -> None:
        super(AutoscaleSettings, self).__init__(**kwargs)
        self.max_throughput = max_throughput


class AutoscaleSettingsResource(Model):
    """Cosmos DB provisioned throughput settings object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param max_throughput: Required. Represents maximum throughput container
     can scale up to.
    :type max_throughput: int
    :param auto_upgrade_policy: Cosmos DB resource auto-upgrade policy
    :type auto_upgrade_policy:
     ~azure.mgmt.cosmosdb.models.AutoUpgradePolicyResource
    :ivar target_max_throughput: Represents target maximum throughput
     container can scale up to once offer is no longer in pending state.
    :vartype target_max_throughput: int
    """

    _validation = {
        'max_throughput': {'required': True},
        'target_max_throughput': {'readonly': True},
    }

    _attribute_map = {
        'max_throughput': {'key': 'maxThroughput', 'type': 'int'},
        'auto_upgrade_policy': {'key': 'autoUpgradePolicy', 'type': 'AutoUpgradePolicyResource'},
        'target_max_throughput': {'key': 'targetMaxThroughput', 'type': 'int'},
    }

    def __init__(self, *, max_throughput: int, auto_upgrade_policy=None, **kwargs) -> None:
        super(AutoscaleSettingsResource, self).__init__(**kwargs)
        self.max_throughput = max_throughput
        self.auto_upgrade_policy = auto_upgrade_policy
        self.target_max_throughput = None


class AutoUpgradePolicyResource(Model):
    """Cosmos DB resource auto-upgrade policy.

    :param throughput_policy: Represents throughput policy which service must
     adhere to for auto-upgrade
    :type throughput_policy:
     ~azure.mgmt.cosmosdb.models.ThroughputPolicyResource
    """

    _attribute_map = {
        'throughput_policy': {'key': 'throughputPolicy', 'type': 'ThroughputPolicyResource'},
    }

    def __init__(self, *, throughput_policy=None, **kwargs) -> None:
        super(AutoUpgradePolicyResource, self).__init__(**kwargs)
        self.throughput_policy = throughput_policy


class Resource(Model):
    """Resource.

    Common fields that are returned in the response for all Azure Resource
    Manager resources.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AzureEntityResource(Resource):
    """Entity Resource.

    The resource model definition for an Azure Resource Manager resource with
    an etag.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(AzureEntityResource, self).__init__(**kwargs)
        self.etag = None


class BackupPolicy(Model):
    """The object representing the policy for taking backups on an account.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: PeriodicModeBackupPolicy, ContinuousModeBackupPolicy

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Periodic': 'PeriodicModeBackupPolicy', 'Continuous': 'ContinuousModeBackupPolicy'}
    }

    def __init__(self, **kwargs) -> None:
        super(BackupPolicy, self).__init__(**kwargs)
        self.type = None


class Capability(Model):
    """Cosmos DB capability object.

    :param name: Name of the Cosmos DB capability. For example, "name":
     "EnableCassandra". Current values also include "EnableTable" and
     "EnableGremlin".
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, **kwargs) -> None:
        super(Capability, self).__init__(**kwargs)
        self.name = name


class CassandraKeyspaceCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB Cassandra keyspace.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource: Required. The standard JSON format of a Cassandra
     keyspace
    :type resource: ~azure.mgmt.cosmosdb.models.CassandraKeyspaceResource
    :param options: Required. A key-value pair of options to be applied for
     the request. This corresponds to the headers sent with the request.
    :type options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource': {'required': True},
        'options': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'CassandraKeyspaceResource'},
        'options': {'key': 'properties.options', 'type': 'CreateUpdateOptions'},
    }

    def __init__(self, *, resource, options, location: str=None, tags=None, identity=None, **kwargs) -> None:
        super(CassandraKeyspaceCreateUpdateParameters, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource
        self.options = options


class OptionsResource(Model):
    """Cosmos DB options resource object.

    :param throughput: Value of the Cosmos DB resource throughput or
     autoscaleSettings. Use the ThroughputSetting resource when retrieving
     offer details.
    :type throughput: int
    :param autoscale_settings: Specifies the Autoscale settings.
    :type autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
    """

    _attribute_map = {
        'throughput': {'key': 'throughput', 'type': 'int'},
        'autoscale_settings': {'key': 'autoscaleSettings', 'type': 'AutoscaleSettings'},
    }

    def __init__(self, *, throughput: int=None, autoscale_settings=None, **kwargs) -> None:
        super(OptionsResource, self).__init__(**kwargs)
        self.throughput = throughput
        self.autoscale_settings = autoscale_settings


class CassandraKeyspaceGetPropertiesOptions(OptionsResource):
    """CassandraKeyspaceGetPropertiesOptions.

    :param throughput: Value of the Cosmos DB resource throughput or
     autoscaleSettings. Use the ThroughputSetting resource when retrieving
     offer details.
    :type throughput: int
    :param autoscale_settings: Specifies the Autoscale settings.
    :type autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
    """

    _attribute_map = {
        'throughput': {'key': 'throughput', 'type': 'int'},
        'autoscale_settings': {'key': 'autoscaleSettings', 'type': 'AutoscaleSettings'},
    }

    def __init__(self, *, throughput: int=None, autoscale_settings=None, **kwargs) -> None:
        super(CassandraKeyspaceGetPropertiesOptions, self).__init__(throughput=throughput, autoscale_settings=autoscale_settings, **kwargs)


class CassandraKeyspaceGetPropertiesResource(Model):
    """CassandraKeyspaceGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB Cassandra keyspace
    :type id: str
    :ivar _rid: A system generated property. A unique identifier.
    :vartype _rid: str
    :ivar _ts: A system generated property that denotes the last updated
     timestamp of the resource.
    :vartype _ts: object
    :ivar _etag: A system generated property representing the resource etag
     required for optimistic concurrency control.
    :vartype _etag: str
    """

    _validation = {
        'id': {'required': True},
        '_rid': {'readonly': True},
        '_ts': {'readonly': True},
        '_etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        '_rid': {'key': '_rid', 'type': 'str'},
        '_ts': {'key': '_ts', 'type': 'object'},
        '_etag': {'key': '_etag', 'type': 'str'},
    }

    def __init__(self, *, id: str, **kwargs) -> None:
        super(CassandraKeyspaceGetPropertiesResource, self).__init__(**kwargs)
        self.id = id
        self._rid = None
        self._ts = None
        self._etag = None


class CassandraKeyspaceGetResults(ARMResourceProperties):
    """An Azure Cosmos DB Cassandra keyspace.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource:
    :type resource:
     ~azure.mgmt.cosmosdb.models.CassandraKeyspaceGetPropertiesResource
    :param options:
    :type options:
     ~azure.mgmt.cosmosdb.models.CassandraKeyspaceGetPropertiesOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'CassandraKeyspaceGetPropertiesResource'},
        'options': {'key': 'properties.options', 'type': 'CassandraKeyspaceGetPropertiesOptions'},
    }

    def __init__(self, *, location: str=None, tags=None, identity=None, resource=None, options=None, **kwargs) -> None:
        super(CassandraKeyspaceGetResults, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource
        self.options = options


class CassandraKeyspaceResource(Model):
    """Cosmos DB Cassandra keyspace resource object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB Cassandra keyspace
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str, **kwargs) -> None:
        super(CassandraKeyspaceResource, self).__init__(**kwargs)
        self.id = id


class CassandraPartitionKey(Model):
    """Cosmos DB Cassandra table partition key.

    :param name: Name of the Cosmos DB Cassandra table partition key
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, **kwargs) -> None:
        super(CassandraPartitionKey, self).__init__(**kwargs)
        self.name = name


class CassandraSchema(Model):
    """Cosmos DB Cassandra table schema.

    :param columns: List of Cassandra table columns.
    :type columns: list[~azure.mgmt.cosmosdb.models.Column]
    :param partition_keys: List of partition key.
    :type partition_keys:
     list[~azure.mgmt.cosmosdb.models.CassandraPartitionKey]
    :param cluster_keys: List of cluster key.
    :type cluster_keys: list[~azure.mgmt.cosmosdb.models.ClusterKey]
    """

    _attribute_map = {
        'columns': {'key': 'columns', 'type': '[Column]'},
        'partition_keys': {'key': 'partitionKeys', 'type': '[CassandraPartitionKey]'},
        'cluster_keys': {'key': 'clusterKeys', 'type': '[ClusterKey]'},
    }

    def __init__(self, *, columns=None, partition_keys=None, cluster_keys=None, **kwargs) -> None:
        super(CassandraSchema, self).__init__(**kwargs)
        self.columns = columns
        self.partition_keys = partition_keys
        self.cluster_keys = cluster_keys


class CassandraTableCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB Cassandra table.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource: Required. The standard JSON format of a Cassandra table
    :type resource: ~azure.mgmt.cosmosdb.models.CassandraTableResource
    :param options: Required. A key-value pair of options to be applied for
     the request. This corresponds to the headers sent with the request.
    :type options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource': {'required': True},
        'options': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'CassandraTableResource'},
        'options': {'key': 'properties.options', 'type': 'CreateUpdateOptions'},
    }

    def __init__(self, *, resource, options, location: str=None, tags=None, identity=None, **kwargs) -> None:
        super(CassandraTableCreateUpdateParameters, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource
        self.options = options


class CassandraTableGetPropertiesOptions(OptionsResource):
    """CassandraTableGetPropertiesOptions.

    :param throughput: Value of the Cosmos DB resource throughput or
     autoscaleSettings. Use the ThroughputSetting resource when retrieving
     offer details.
    :type throughput: int
    :param autoscale_settings: Specifies the Autoscale settings.
    :type autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
    """

    _attribute_map = {
        'throughput': {'key': 'throughput', 'type': 'int'},
        'autoscale_settings': {'key': 'autoscaleSettings', 'type': 'AutoscaleSettings'},
    }

    def __init__(self, *, throughput: int=None, autoscale_settings=None, **kwargs) -> None:
        super(CassandraTableGetPropertiesOptions, self).__init__(throughput=throughput, autoscale_settings=autoscale_settings, **kwargs)


class CassandraTableGetPropertiesResource(Model):
    """CassandraTableGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB Cassandra table
    :type id: str
    :param default_ttl: Time to live of the Cosmos DB Cassandra table
    :type default_ttl: int
    :param schema: Schema of the Cosmos DB Cassandra table
    :type schema: ~azure.mgmt.cosmosdb.models.CassandraSchema
    :param analytical_storage_ttl: Analytical TTL.
    :type analytical_storage_ttl: int
    :ivar _rid: A system generated property. A unique identifier.
    :vartype _rid: str
    :ivar _ts: A system generated property that denotes the last updated
     timestamp of the resource.
    :vartype _ts: object
    :ivar _etag: A system generated property representing the resource etag
     required for optimistic concurrency control.
    :vartype _etag: str
    """

    _validation = {
        'id': {'required': True},
        '_rid': {'readonly': True},
        '_ts': {'readonly': True},
        '_etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'default_ttl': {'key': 'defaultTtl', 'type': 'int'},
        'schema': {'key': 'schema', 'type': 'CassandraSchema'},
        'analytical_storage_ttl': {'key': 'analyticalStorageTtl', 'type': 'int'},
        '_rid': {'key': '_rid', 'type': 'str'},
        '_ts': {'key': '_ts', 'type': 'object'},
        '_etag': {'key': '_etag', 'type': 'str'},
    }

    def __init__(self, *, id: str, default_ttl: int=None, schema=None, analytical_storage_ttl: int=None, **kwargs) -> None:
        super(CassandraTableGetPropertiesResource, self).__init__(**kwargs)
        self.id = id
        self.default_ttl = default_ttl
        self.schema = schema
        self.analytical_storage_ttl = analytical_storage_ttl
        self._rid = None
        self._ts = None
        self._etag = None


class CassandraTableGetResults(ARMResourceProperties):
    """An Azure Cosmos DB Cassandra table.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource:
    :type resource:
     ~azure.mgmt.cosmosdb.models.CassandraTableGetPropertiesResource
    :param options:
    :type options:
     ~azure.mgmt.cosmosdb.models.CassandraTableGetPropertiesOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'CassandraTableGetPropertiesResource'},
        'options': {'key': 'properties.options', 'type': 'CassandraTableGetPropertiesOptions'},
    }

    def __init__(self, *, location: str=None, tags=None, identity=None, resource=None, options=None, **kwargs) -> None:
        super(CassandraTableGetResults, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource
        self.options = options


class CassandraTableResource(Model):
    """Cosmos DB Cassandra table resource object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB Cassandra table
    :type id: str
    :param default_ttl: Time to live of the Cosmos DB Cassandra table
    :type default_ttl: int
    :param schema: Schema of the Cosmos DB Cassandra table
    :type schema: ~azure.mgmt.cosmosdb.models.CassandraSchema
    :param analytical_storage_ttl: Analytical TTL.
    :type analytical_storage_ttl: int
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'default_ttl': {'key': 'defaultTtl', 'type': 'int'},
        'schema': {'key': 'schema', 'type': 'CassandraSchema'},
        'analytical_storage_ttl': {'key': 'analyticalStorageTtl', 'type': 'int'},
    }

    def __init__(self, *, id: str, default_ttl: int=None, schema=None, analytical_storage_ttl: int=None, **kwargs) -> None:
        super(CassandraTableResource, self).__init__(**kwargs)
        self.id = id
        self.default_ttl = default_ttl
        self.schema = schema
        self.analytical_storage_ttl = analytical_storage_ttl


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class ClusterKey(Model):
    """Cosmos DB Cassandra table cluster key.

    :param name: Name of the Cosmos DB Cassandra table cluster key
    :type name: str
    :param order_by: Order of the Cosmos DB Cassandra table cluster key, only
     support "Asc" and "Desc"
    :type order_by: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'order_by': {'key': 'orderBy', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, order_by: str=None, **kwargs) -> None:
        super(ClusterKey, self).__init__(**kwargs)
        self.name = name
        self.order_by = order_by


class Column(Model):
    """Cosmos DB Cassandra table column.

    :param name: Name of the Cosmos DB Cassandra table column
    :type name: str
    :param type: Type of the Cosmos DB Cassandra table column
    :type type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, type: str=None, **kwargs) -> None:
        super(Column, self).__init__(**kwargs)
        self.name = name
        self.type = type


class CompositePath(Model):
    """CompositePath.

    :param path: The path for which the indexing behavior applies to. Index
     paths typically start with root and end with wildcard (/path/*)
    :type path: str
    :param order: Sort order for composite paths. Possible values include:
     'Ascending', 'Descending'
    :type order: str or ~azure.mgmt.cosmosdb.models.CompositePathSortOrder
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'order': {'key': 'order', 'type': 'str'},
    }

    def __init__(self, *, path: str=None, order=None, **kwargs) -> None:
        super(CompositePath, self).__init__(**kwargs)
        self.path = path
        self.order = order


class ConflictResolutionPolicy(Model):
    """The conflict resolution policy for the container.

    :param mode: Indicates the conflict resolution mode. Possible values
     include: 'LastWriterWins', 'Custom'. Default value: "LastWriterWins" .
    :type mode: str or ~azure.mgmt.cosmosdb.models.ConflictResolutionMode
    :param conflict_resolution_path: The conflict resolution path in the case
     of LastWriterWins mode.
    :type conflict_resolution_path: str
    :param conflict_resolution_procedure: The procedure to resolve conflicts
     in the case of custom mode.
    :type conflict_resolution_procedure: str
    """

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'conflict_resolution_path': {'key': 'conflictResolutionPath', 'type': 'str'},
        'conflict_resolution_procedure': {'key': 'conflictResolutionProcedure', 'type': 'str'},
    }

    def __init__(self, *, mode="LastWriterWins", conflict_resolution_path: str=None, conflict_resolution_procedure: str=None, **kwargs) -> None:
        super(ConflictResolutionPolicy, self).__init__(**kwargs)
        self.mode = mode
        self.conflict_resolution_path = conflict_resolution_path
        self.conflict_resolution_procedure = conflict_resolution_procedure


class ConsistencyPolicy(Model):
    """The consistency policy for the Cosmos DB database account.

    All required parameters must be populated in order to send to Azure.

    :param default_consistency_level: Required. The default consistency level
     and configuration settings of the Cosmos DB account. Possible values
     include: 'Eventual', 'Session', 'BoundedStaleness', 'Strong',
     'ConsistentPrefix'
    :type default_consistency_level: str or
     ~azure.mgmt.cosmosdb.models.DefaultConsistencyLevel
    :param max_staleness_prefix: When used with the Bounded Staleness
     consistency level, this value represents the number of stale requests
     tolerated. Accepted range for this value is 1 – 2,147,483,647. Required
     when defaultConsistencyPolicy is set to 'BoundedStaleness'.
    :type max_staleness_prefix: long
    :param max_interval_in_seconds: When used with the Bounded Staleness
     consistency level, this value represents the time amount of staleness (in
     seconds) tolerated. Accepted range for this value is 5 - 86400. Required
     when defaultConsistencyPolicy is set to 'BoundedStaleness'.
    :type max_interval_in_seconds: int
    """

    _validation = {
        'default_consistency_level': {'required': True},
        'max_staleness_prefix': {'maximum': 2147483647, 'minimum': 1},
        'max_interval_in_seconds': {'maximum': 86400, 'minimum': 5},
    }

    _attribute_map = {
        'default_consistency_level': {'key': 'defaultConsistencyLevel', 'type': 'DefaultConsistencyLevel'},
        'max_staleness_prefix': {'key': 'maxStalenessPrefix', 'type': 'long'},
        'max_interval_in_seconds': {'key': 'maxIntervalInSeconds', 'type': 'int'},
    }

    def __init__(self, *, default_consistency_level, max_staleness_prefix: int=None, max_interval_in_seconds: int=None, **kwargs) -> None:
        super(ConsistencyPolicy, self).__init__(**kwargs)
        self.default_consistency_level = default_consistency_level
        self.max_staleness_prefix = max_staleness_prefix
        self.max_interval_in_seconds = max_interval_in_seconds


class ContainerPartitionKey(Model):
    """The configuration of the partition key to be used for partitioning data
    into multiple partitions.

    :param paths: List of paths using which data within the container can be
     partitioned
    :type paths: list[str]
    :param kind: Indicates the kind of algorithm used for partitioning.
     Possible values include: 'Hash', 'Range'. Default value: "Hash" .
    :type kind: str or ~azure.mgmt.cosmosdb.models.PartitionKind
    :param version: Indicates the version of the partition key definition
    :type version: int
    """

    _validation = {
        'version': {'maximum': 2, 'minimum': 1},
    }

    _attribute_map = {
        'paths': {'key': 'paths', 'type': '[str]'},
        'kind': {'key': 'kind', 'type': 'str'},
        'version': {'key': 'version', 'type': 'int'},
    }

    def __init__(self, *, paths=None, kind="Hash", version: int=None, **kwargs) -> None:
        super(ContainerPartitionKey, self).__init__(**kwargs)
        self.paths = paths
        self.kind = kind
        self.version = version


class ContinuousModeBackupPolicy(BackupPolicy):
    """The object representing continuous mode backup policy.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ContinuousModeBackupPolicy, self).__init__(**kwargs)
        self.type = 'Continuous'


class CorsPolicy(Model):
    """The CORS policy for the Cosmos DB database account.

    All required parameters must be populated in order to send to Azure.

    :param allowed_origins: Required. The origin domains that are permitted to
     make a request against the service via CORS.
    :type allowed_origins: str
    :param allowed_methods: The methods (HTTP request verbs) that the origin
     domain may use for a CORS request.
    :type allowed_methods: str
    :param allowed_headers: The request headers that the origin domain may
     specify on the CORS request.
    :type allowed_headers: str
    :param exposed_headers: The response headers that may be sent in the
     response to the CORS request and exposed by the browser to the request
     issuer.
    :type exposed_headers: str
    :param max_age_in_seconds: The maximum amount time that a browser should
     cache the preflight OPTIONS request.
    :type max_age_in_seconds: long
    """

    _validation = {
        'allowed_origins': {'required': True},
        'max_age_in_seconds': {'maximum': 2147483647, 'minimum': 1},
    }

    _attribute_map = {
        'allowed_origins': {'key': 'allowedOrigins', 'type': 'str'},
        'allowed_methods': {'key': 'allowedMethods', 'type': 'str'},
        'allowed_headers': {'key': 'allowedHeaders', 'type': 'str'},
        'exposed_headers': {'key': 'exposedHeaders', 'type': 'str'},
        'max_age_in_seconds': {'key': 'maxAgeInSeconds', 'type': 'long'},
    }

    def __init__(self, *, allowed_origins: str, allowed_methods: str=None, allowed_headers: str=None, exposed_headers: str=None, max_age_in_seconds: int=None, **kwargs) -> None:
        super(CorsPolicy, self).__init__(**kwargs)
        self.allowed_origins = allowed_origins
        self.allowed_methods = allowed_methods
        self.allowed_headers = allowed_headers
        self.exposed_headers = exposed_headers
        self.max_age_in_seconds = max_age_in_seconds


class CreateUpdateOptions(Model):
    """CreateUpdateOptions are a list of key-value pairs that describe the
    resource. Supported keys are "If-Match", "If-None-Match", "Session-Token"
    and "Throughput".

    :param throughput: Request Units per second. For example, "throughput":
     10000.
    :type throughput: int
    :param autoscale_settings: Specifies the Autoscale settings.
    :type autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
    """

    _attribute_map = {
        'throughput': {'key': 'throughput', 'type': 'int'},
        'autoscale_settings': {'key': 'autoscaleSettings', 'type': 'AutoscaleSettings'},
    }

    def __init__(self, *, throughput: int=None, autoscale_settings=None, **kwargs) -> None:
        super(CreateUpdateOptions, self).__init__(**kwargs)
        self.throughput = throughput
        self.autoscale_settings = autoscale_settings


class DatabaseAccountConnectionString(Model):
    """Connection string for the Cosmos DB account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar connection_string: Value of the connection string
    :vartype connection_string: str
    :ivar description: Description of the connection string
    :vartype description: str
    """

    _validation = {
        'connection_string': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(DatabaseAccountConnectionString, self).__init__(**kwargs)
        self.connection_string = None
        self.description = None


class DatabaseAccountCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB database accounts.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param kind: Indicates the type of database account. This can only be set
     at database account creation. Possible values include: 'GlobalDocumentDB',
     'MongoDB', 'Parse'. Default value: "GlobalDocumentDB" .
    :type kind: str or ~azure.mgmt.cosmosdb.models.DatabaseAccountKind
    :param properties: Required.
    :type properties:
     ~azure.mgmt.cosmosdb.models.DatabaseAccountCreateUpdateProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DatabaseAccountCreateUpdateProperties'},
    }

    def __init__(self, *, properties, location: str=None, tags=None, identity=None, kind="GlobalDocumentDB", **kwargs) -> None:
        super(DatabaseAccountCreateUpdateParameters, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.kind = kind
        self.properties = properties


class DatabaseAccountCreateUpdateProperties(Model):
    """Properties to create and update Azure Cosmos DB database accounts.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DefaultRequestDatabaseAccountCreateUpdateProperties,
    RestoreReqeustDatabaseAccountCreateUpdateProperties

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param consistency_policy: The consistency policy for the Cosmos DB
     account.
    :type consistency_policy: ~azure.mgmt.cosmosdb.models.ConsistencyPolicy
    :param locations: Required. An array that contains the georeplication
     locations enabled for the Cosmos DB account.
    :type locations: list[~azure.mgmt.cosmosdb.models.Location]
    :ivar database_account_offer_type: Required. The offer type for the
     database. Default value: "Standard" .
    :vartype database_account_offer_type: str
    :param ip_rules: List of IpRules.
    :type ip_rules: list[~azure.mgmt.cosmosdb.models.IpAddressOrRange]
    :param is_virtual_network_filter_enabled: Flag to indicate whether to
     enable/disable Virtual Network ACL rules.
    :type is_virtual_network_filter_enabled: bool
    :param enable_automatic_failover: Enables automatic failover of the write
     region in the rare event that the region is unavailable due to an outage.
     Automatic failover will result in a new write region for the account and
     is chosen based on the failover priorities configured for the account.
    :type enable_automatic_failover: bool
    :param capabilities: List of Cosmos DB capabilities for the account
    :type capabilities: list[~azure.mgmt.cosmosdb.models.Capability]
    :param virtual_network_rules: List of Virtual Network ACL rules configured
     for the Cosmos DB account.
    :type virtual_network_rules:
     list[~azure.mgmt.cosmosdb.models.VirtualNetworkRule]
    :param enable_multiple_write_locations: Enables the account to write in
     multiple locations
    :type enable_multiple_write_locations: bool
    :param enable_cassandra_connector: Enables the cassandra connector on the
     Cosmos DB C* account
    :type enable_cassandra_connector: bool
    :param connector_offer: The cassandra connector offer type for the Cosmos
     DB database C* account. Possible values include: 'Small'
    :type connector_offer: str or ~azure.mgmt.cosmosdb.models.ConnectorOffer
    :param disable_key_based_metadata_write_access: Disable write operations
     on metadata resources (databases, containers, throughput) via account keys
    :type disable_key_based_metadata_write_access: bool
    :param key_vault_key_uri: The URI of the key vault
    :type key_vault_key_uri: str
    :param public_network_access: Whether requests from Public Network are
     allowed. Possible values include: 'Enabled', 'Disabled'
    :type public_network_access: str or
     ~azure.mgmt.cosmosdb.models.PublicNetworkAccess
    :param enable_free_tier: Flag to indicate whether Free Tier is enabled.
    :type enable_free_tier: bool
    :param api_properties: API specific properties. Currently, supported only
     for MongoDB API.
    :type api_properties: ~azure.mgmt.cosmosdb.models.ApiProperties
    :param enable_analytical_storage: Flag to indicate whether to enable
     storage analytics.
    :type enable_analytical_storage: bool
    :param backup_policy: The object representing the policy for taking
     backups on an account.
    :type backup_policy: ~azure.mgmt.cosmosdb.models.BackupPolicy
    :param cors: The CORS policy for the Cosmos DB database account.
    :type cors: list[~azure.mgmt.cosmosdb.models.CorsPolicy]
    :param create_mode: Required. Constant filled by server.
    :type create_mode: str
    """

    _validation = {
        'locations': {'required': True},
        'database_account_offer_type': {'required': True, 'constant': True},
        'create_mode': {'required': True},
    }

    _attribute_map = {
        'consistency_policy': {'key': 'consistencyPolicy', 'type': 'ConsistencyPolicy'},
        'locations': {'key': 'locations', 'type': '[Location]'},
        'database_account_offer_type': {'key': 'databaseAccountOfferType', 'type': 'str'},
        'ip_rules': {'key': 'ipRules', 'type': '[IpAddressOrRange]'},
        'is_virtual_network_filter_enabled': {'key': 'isVirtualNetworkFilterEnabled', 'type': 'bool'},
        'enable_automatic_failover': {'key': 'enableAutomaticFailover', 'type': 'bool'},
        'capabilities': {'key': 'capabilities', 'type': '[Capability]'},
        'virtual_network_rules': {'key': 'virtualNetworkRules', 'type': '[VirtualNetworkRule]'},
        'enable_multiple_write_locations': {'key': 'enableMultipleWriteLocations', 'type': 'bool'},
        'enable_cassandra_connector': {'key': 'enableCassandraConnector', 'type': 'bool'},
        'connector_offer': {'key': 'connectorOffer', 'type': 'str'},
        'disable_key_based_metadata_write_access': {'key': 'disableKeyBasedMetadataWriteAccess', 'type': 'bool'},
        'key_vault_key_uri': {'key': 'keyVaultKeyUri', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'enable_free_tier': {'key': 'enableFreeTier', 'type': 'bool'},
        'api_properties': {'key': 'apiProperties', 'type': 'ApiProperties'},
        'enable_analytical_storage': {'key': 'enableAnalyticalStorage', 'type': 'bool'},
        'backup_policy': {'key': 'backupPolicy', 'type': 'BackupPolicy'},
        'cors': {'key': 'cors', 'type': '[CorsPolicy]'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
    }

    _subtype_map = {
        'create_mode': {'Default': 'DefaultRequestDatabaseAccountCreateUpdateProperties', 'Restore': 'RestoreReqeustDatabaseAccountCreateUpdateProperties'}
    }

    database_account_offer_type = "Standard"

    def __init__(self, *, locations, consistency_policy=None, ip_rules=None, is_virtual_network_filter_enabled: bool=None, enable_automatic_failover: bool=None, capabilities=None, virtual_network_rules=None, enable_multiple_write_locations: bool=None, enable_cassandra_connector: bool=None, connector_offer=None, disable_key_based_metadata_write_access: bool=None, key_vault_key_uri: str=None, public_network_access=None, enable_free_tier: bool=None, api_properties=None, enable_analytical_storage: bool=None, backup_policy=None, cors=None, **kwargs) -> None:
        super(DatabaseAccountCreateUpdateProperties, self).__init__(**kwargs)
        self.consistency_policy = consistency_policy
        self.locations = locations
        self.ip_rules = ip_rules
        self.is_virtual_network_filter_enabled = is_virtual_network_filter_enabled
        self.enable_automatic_failover = enable_automatic_failover
        self.capabilities = capabilities
        self.virtual_network_rules = virtual_network_rules
        self.enable_multiple_write_locations = enable_multiple_write_locations
        self.enable_cassandra_connector = enable_cassandra_connector
        self.connector_offer = connector_offer
        self.disable_key_based_metadata_write_access = disable_key_based_metadata_write_access
        self.key_vault_key_uri = key_vault_key_uri
        self.public_network_access = public_network_access
        self.enable_free_tier = enable_free_tier
        self.api_properties = api_properties
        self.enable_analytical_storage = enable_analytical_storage
        self.backup_policy = backup_policy
        self.cors = cors
        self.create_mode = None


class DatabaseAccountGetResults(ARMResourceProperties):
    """An Azure Cosmos DB database account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param kind: Indicates the type of database account. This can only be set
     at database account creation. Possible values include: 'GlobalDocumentDB',
     'MongoDB', 'Parse'. Default value: "GlobalDocumentDB" .
    :type kind: str or ~azure.mgmt.cosmosdb.models.DatabaseAccountKind
    :param provisioning_state:
    :type provisioning_state: str
    :ivar document_endpoint: The connection endpoint for the Cosmos DB
     database account.
    :vartype document_endpoint: str
    :ivar database_account_offer_type: The offer type for the Cosmos DB
     database account. Default value: Standard. Possible values include:
     'Standard'
    :vartype database_account_offer_type: str or
     ~azure.mgmt.cosmosdb.models.DatabaseAccountOfferType
    :param ip_rules: List of IpRules.
    :type ip_rules: list[~azure.mgmt.cosmosdb.models.IpAddressOrRange]
    :param is_virtual_network_filter_enabled: Flag to indicate whether to
     enable/disable Virtual Network ACL rules.
    :type is_virtual_network_filter_enabled: bool
    :param enable_automatic_failover: Enables automatic failover of the write
     region in the rare event that the region is unavailable due to an outage.
     Automatic failover will result in a new write region for the account and
     is chosen based on the failover priorities configured for the account.
    :type enable_automatic_failover: bool
    :param consistency_policy: The consistency policy for the Cosmos DB
     database account.
    :type consistency_policy: ~azure.mgmt.cosmosdb.models.ConsistencyPolicy
    :param capabilities: List of Cosmos DB capabilities for the account
    :type capabilities: list[~azure.mgmt.cosmosdb.models.Capability]
    :ivar write_locations: An array that contains the write location for the
     Cosmos DB account.
    :vartype write_locations: list[~azure.mgmt.cosmosdb.models.Location]
    :ivar read_locations: An array that contains of the read locations enabled
     for the Cosmos DB account.
    :vartype read_locations: list[~azure.mgmt.cosmosdb.models.Location]
    :ivar locations: An array that contains all of the locations enabled for
     the Cosmos DB account.
    :vartype locations: list[~azure.mgmt.cosmosdb.models.Location]
    :ivar failover_policies: An array that contains the regions ordered by
     their failover priorities.
    :vartype failover_policies:
     list[~azure.mgmt.cosmosdb.models.FailoverPolicy]
    :param virtual_network_rules: List of Virtual Network ACL rules configured
     for the Cosmos DB account.
    :type virtual_network_rules:
     list[~azure.mgmt.cosmosdb.models.VirtualNetworkRule]
    :ivar private_endpoint_connections: List of Private Endpoint Connections
     configured for the Cosmos DB account.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.cosmosdb.models.PrivateEndpointConnection]
    :param enable_multiple_write_locations: Enables the account to write in
     multiple locations
    :type enable_multiple_write_locations: bool
    :param enable_cassandra_connector: Enables the cassandra connector on the
     Cosmos DB C* account
    :type enable_cassandra_connector: bool
    :param connector_offer: The cassandra connector offer type for the Cosmos
     DB database C* account. Possible values include: 'Small'
    :type connector_offer: str or ~azure.mgmt.cosmosdb.models.ConnectorOffer
    :param disable_key_based_metadata_write_access: Disable write operations
     on metadata resources (databases, containers, throughput) via account keys
    :type disable_key_based_metadata_write_access: bool
    :param key_vault_key_uri: The URI of the key vault
    :type key_vault_key_uri: str
    :param public_network_access: Whether requests from Public Network are
     allowed. Possible values include: 'Enabled', 'Disabled'
    :type public_network_access: str or
     ~azure.mgmt.cosmosdb.models.PublicNetworkAccess
    :param enable_free_tier: Flag to indicate whether Free Tier is enabled.
    :type enable_free_tier: bool
    :param api_properties: API specific properties.
    :type api_properties: ~azure.mgmt.cosmosdb.models.ApiProperties
    :param enable_analytical_storage: Flag to indicate whether to enable
     storage analytics.
    :type enable_analytical_storage: bool
    :ivar instance_id: A unique identifier assigned to the database account
    :vartype instance_id: str
    :param create_mode: Enum to indicate the mode of account creation.
     Possible values include: 'Default', 'Restore'. Default value: "Default" .
    :type create_mode: str or ~azure.mgmt.cosmosdb.models.CreateMode
    :param restore_parameters: Parameters to indicate the information about
     the restore.
    :type restore_parameters: ~azure.mgmt.cosmosdb.models.RestoreParameters
    :param backup_policy: The object representing the policy for taking
     backups on an account.
    :type backup_policy: ~azure.mgmt.cosmosdb.models.BackupPolicy
    :param cors: The CORS policy for the Cosmos DB database account.
    :type cors: list[~azure.mgmt.cosmosdb.models.CorsPolicy]
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.cosmosdb.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'document_endpoint': {'readonly': True},
        'database_account_offer_type': {'readonly': True},
        'write_locations': {'readonly': True},
        'read_locations': {'readonly': True},
        'locations': {'readonly': True},
        'failover_policies': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'instance_id': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'document_endpoint': {'key': 'properties.documentEndpoint', 'type': 'str'},
        'database_account_offer_type': {'key': 'properties.databaseAccountOfferType', 'type': 'DatabaseAccountOfferType'},
        'ip_rules': {'key': 'properties.ipRules', 'type': '[IpAddressOrRange]'},
        'is_virtual_network_filter_enabled': {'key': 'properties.isVirtualNetworkFilterEnabled', 'type': 'bool'},
        'enable_automatic_failover': {'key': 'properties.enableAutomaticFailover', 'type': 'bool'},
        'consistency_policy': {'key': 'properties.consistencyPolicy', 'type': 'ConsistencyPolicy'},
        'capabilities': {'key': 'properties.capabilities', 'type': '[Capability]'},
        'write_locations': {'key': 'properties.writeLocations', 'type': '[Location]'},
        'read_locations': {'key': 'properties.readLocations', 'type': '[Location]'},
        'locations': {'key': 'properties.locations', 'type': '[Location]'},
        'failover_policies': {'key': 'properties.failoverPolicies', 'type': '[FailoverPolicy]'},
        'virtual_network_rules': {'key': 'properties.virtualNetworkRules', 'type': '[VirtualNetworkRule]'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'enable_multiple_write_locations': {'key': 'properties.enableMultipleWriteLocations', 'type': 'bool'},
        'enable_cassandra_connector': {'key': 'properties.enableCassandraConnector', 'type': 'bool'},
        'connector_offer': {'key': 'properties.connectorOffer', 'type': 'str'},
        'disable_key_based_metadata_write_access': {'key': 'properties.disableKeyBasedMetadataWriteAccess', 'type': 'bool'},
        'key_vault_key_uri': {'key': 'properties.keyVaultKeyUri', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'enable_free_tier': {'key': 'properties.enableFreeTier', 'type': 'bool'},
        'api_properties': {'key': 'properties.apiProperties', 'type': 'ApiProperties'},
        'enable_analytical_storage': {'key': 'properties.enableAnalyticalStorage', 'type': 'bool'},
        'instance_id': {'key': 'properties.instanceId', 'type': 'str'},
        'create_mode': {'key': 'properties.createMode', 'type': 'str'},
        'restore_parameters': {'key': 'properties.restoreParameters', 'type': 'RestoreParameters'},
        'backup_policy': {'key': 'properties.backupPolicy', 'type': 'BackupPolicy'},
        'cors': {'key': 'properties.cors', 'type': '[CorsPolicy]'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, *, location: str=None, tags=None, identity=None, kind="GlobalDocumentDB", provisioning_state: str=None, ip_rules=None, is_virtual_network_filter_enabled: bool=None, enable_automatic_failover: bool=None, consistency_policy=None, capabilities=None, virtual_network_rules=None, enable_multiple_write_locations: bool=None, enable_cassandra_connector: bool=None, connector_offer=None, disable_key_based_metadata_write_access: bool=None, key_vault_key_uri: str=None, public_network_access=None, enable_free_tier: bool=None, api_properties=None, enable_analytical_storage: bool=None, create_mode="Default", restore_parameters=None, backup_policy=None, cors=None, **kwargs) -> None:
        super(DatabaseAccountGetResults, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.kind = kind
        self.provisioning_state = provisioning_state
        self.document_endpoint = None
        self.database_account_offer_type = None
        self.ip_rules = ip_rules
        self.is_virtual_network_filter_enabled = is_virtual_network_filter_enabled
        self.enable_automatic_failover = enable_automatic_failover
        self.consistency_policy = consistency_policy
        self.capabilities = capabilities
        self.write_locations = None
        self.read_locations = None
        self.locations = None
        self.failover_policies = None
        self.virtual_network_rules = virtual_network_rules
        self.private_endpoint_connections = None
        self.enable_multiple_write_locations = enable_multiple_write_locations
        self.enable_cassandra_connector = enable_cassandra_connector
        self.connector_offer = connector_offer
        self.disable_key_based_metadata_write_access = disable_key_based_metadata_write_access
        self.key_vault_key_uri = key_vault_key_uri
        self.public_network_access = public_network_access
        self.enable_free_tier = enable_free_tier
        self.api_properties = api_properties
        self.enable_analytical_storage = enable_analytical_storage
        self.instance_id = None
        self.create_mode = create_mode
        self.restore_parameters = restore_parameters
        self.backup_policy = backup_policy
        self.cors = cors
        self.system_data = None


class DatabaseAccountListConnectionStringsResult(Model):
    """The connection strings for the given database account.

    :param connection_strings: An array that contains the connection strings
     for the Cosmos DB account.
    :type connection_strings:
     list[~azure.mgmt.cosmosdb.models.DatabaseAccountConnectionString]
    """

    _attribute_map = {
        'connection_strings': {'key': 'connectionStrings', 'type': '[DatabaseAccountConnectionString]'},
    }

    def __init__(self, *, connection_strings=None, **kwargs) -> None:
        super(DatabaseAccountListConnectionStringsResult, self).__init__(**kwargs)
        self.connection_strings = connection_strings


class DatabaseAccountListReadOnlyKeysResult(Model):
    """The read-only access keys for the given database account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar primary_readonly_master_key: Base 64 encoded value of the primary
     read-only key.
    :vartype primary_readonly_master_key: str
    :ivar secondary_readonly_master_key: Base 64 encoded value of the
     secondary read-only key.
    :vartype secondary_readonly_master_key: str
    """

    _validation = {
        'primary_readonly_master_key': {'readonly': True},
        'secondary_readonly_master_key': {'readonly': True},
    }

    _attribute_map = {
        'primary_readonly_master_key': {'key': 'primaryReadonlyMasterKey', 'type': 'str'},
        'secondary_readonly_master_key': {'key': 'secondaryReadonlyMasterKey', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(DatabaseAccountListReadOnlyKeysResult, self).__init__(**kwargs)
        self.primary_readonly_master_key = None
        self.secondary_readonly_master_key = None


class DatabaseAccountListKeysResult(DatabaseAccountListReadOnlyKeysResult):
    """The access keys for the given database account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar primary_readonly_master_key: Base 64 encoded value of the primary
     read-only key.
    :vartype primary_readonly_master_key: str
    :ivar secondary_readonly_master_key: Base 64 encoded value of the
     secondary read-only key.
    :vartype secondary_readonly_master_key: str
    :ivar primary_master_key: Base 64 encoded value of the primary read-write
     key.
    :vartype primary_master_key: str
    :ivar secondary_master_key: Base 64 encoded value of the secondary
     read-write key.
    :vartype secondary_master_key: str
    """

    _validation = {
        'primary_readonly_master_key': {'readonly': True},
        'secondary_readonly_master_key': {'readonly': True},
        'primary_master_key': {'readonly': True},
        'secondary_master_key': {'readonly': True},
    }

    _attribute_map = {
        'primary_readonly_master_key': {'key': 'primaryReadonlyMasterKey', 'type': 'str'},
        'secondary_readonly_master_key': {'key': 'secondaryReadonlyMasterKey', 'type': 'str'},
        'primary_master_key': {'key': 'primaryMasterKey', 'type': 'str'},
        'secondary_master_key': {'key': 'secondaryMasterKey', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(DatabaseAccountListKeysResult, self).__init__(**kwargs)
        self.primary_master_key = None
        self.secondary_master_key = None


class DatabaseAccountRegenerateKeyParameters(Model):
    """Parameters to regenerate the keys within the database account.

    All required parameters must be populated in order to send to Azure.

    :param key_kind: Required. The access key to regenerate. Possible values
     include: 'primary', 'secondary', 'primaryReadonly', 'secondaryReadonly'
    :type key_kind: str or ~azure.mgmt.cosmosdb.models.KeyKind
    """

    _validation = {
        'key_kind': {'required': True},
    }

    _attribute_map = {
        'key_kind': {'key': 'keyKind', 'type': 'str'},
    }

    def __init__(self, *, key_kind, **kwargs) -> None:
        super(DatabaseAccountRegenerateKeyParameters, self).__init__(**kwargs)
        self.key_kind = key_kind


class DatabaseAccountUpdateParameters(Model):
    """Parameters for patching Azure Cosmos DB database account properties.

    :param tags:
    :type tags: dict[str, str]
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param consistency_policy: The consistency policy for the Cosmos DB
     account.
    :type consistency_policy: ~azure.mgmt.cosmosdb.models.ConsistencyPolicy
    :param locations: An array that contains the georeplication locations
     enabled for the Cosmos DB account.
    :type locations: list[~azure.mgmt.cosmosdb.models.Location]
    :param ip_rules: List of IpRules.
    :type ip_rules: list[~azure.mgmt.cosmosdb.models.IpAddressOrRange]
    :param is_virtual_network_filter_enabled: Flag to indicate whether to
     enable/disable Virtual Network ACL rules.
    :type is_virtual_network_filter_enabled: bool
    :param enable_automatic_failover: Enables automatic failover of the write
     region in the rare event that the region is unavailable due to an outage.
     Automatic failover will result in a new write region for the account and
     is chosen based on the failover priorities configured for the account.
    :type enable_automatic_failover: bool
    :param capabilities: List of Cosmos DB capabilities for the account
    :type capabilities: list[~azure.mgmt.cosmosdb.models.Capability]
    :param virtual_network_rules: List of Virtual Network ACL rules configured
     for the Cosmos DB account.
    :type virtual_network_rules:
     list[~azure.mgmt.cosmosdb.models.VirtualNetworkRule]
    :param enable_multiple_write_locations: Enables the account to write in
     multiple locations
    :type enable_multiple_write_locations: bool
    :param enable_cassandra_connector: Enables the cassandra connector on the
     Cosmos DB C* account
    :type enable_cassandra_connector: bool
    :param connector_offer: The cassandra connector offer type for the Cosmos
     DB database C* account. Possible values include: 'Small'
    :type connector_offer: str or ~azure.mgmt.cosmosdb.models.ConnectorOffer
    :param disable_key_based_metadata_write_access: Disable write operations
     on metadata resources (databases, containers, throughput) via account keys
    :type disable_key_based_metadata_write_access: bool
    :param key_vault_key_uri: The URI of the key vault
    :type key_vault_key_uri: str
    :param public_network_access: Whether requests from Public Network are
     allowed. Possible values include: 'Enabled', 'Disabled'
    :type public_network_access: str or
     ~azure.mgmt.cosmosdb.models.PublicNetworkAccess
    :param enable_free_tier: Flag to indicate whether Free Tier is enabled.
    :type enable_free_tier: bool
    :param api_properties: API specific properties. Currently, supported only
     for MongoDB API.
    :type api_properties: ~azure.mgmt.cosmosdb.models.ApiProperties
    :param enable_analytical_storage: Flag to indicate whether to enable
     storage analytics.
    :type enable_analytical_storage: bool
    :param backup_policy: The object representing the policy for taking
     backups on an account.
    :type backup_policy: ~azure.mgmt.cosmosdb.models.BackupPolicy
    :param cors: The CORS policy for the Cosmos DB database account.
    :type cors: list[~azure.mgmt.cosmosdb.models.CorsPolicy]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'consistency_policy': {'key': 'properties.consistencyPolicy', 'type': 'ConsistencyPolicy'},
        'locations': {'key': 'properties.locations', 'type': '[Location]'},
        'ip_rules': {'key': 'properties.ipRules', 'type': '[IpAddressOrRange]'},
        'is_virtual_network_filter_enabled': {'key': 'properties.isVirtualNetworkFilterEnabled', 'type': 'bool'},
        'enable_automatic_failover': {'key': 'properties.enableAutomaticFailover', 'type': 'bool'},
        'capabilities': {'key': 'properties.capabilities', 'type': '[Capability]'},
        'virtual_network_rules': {'key': 'properties.virtualNetworkRules', 'type': '[VirtualNetworkRule]'},
        'enable_multiple_write_locations': {'key': 'properties.enableMultipleWriteLocations', 'type': 'bool'},
        'enable_cassandra_connector': {'key': 'properties.enableCassandraConnector', 'type': 'bool'},
        'connector_offer': {'key': 'properties.connectorOffer', 'type': 'str'},
        'disable_key_based_metadata_write_access': {'key': 'properties.disableKeyBasedMetadataWriteAccess', 'type': 'bool'},
        'key_vault_key_uri': {'key': 'properties.keyVaultKeyUri', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'enable_free_tier': {'key': 'properties.enableFreeTier', 'type': 'bool'},
        'api_properties': {'key': 'properties.apiProperties', 'type': 'ApiProperties'},
        'enable_analytical_storage': {'key': 'properties.enableAnalyticalStorage', 'type': 'bool'},
        'backup_policy': {'key': 'properties.backupPolicy', 'type': 'BackupPolicy'},
        'cors': {'key': 'properties.cors', 'type': '[CorsPolicy]'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
    }

    def __init__(self, *, tags=None, location: str=None, consistency_policy=None, locations=None, ip_rules=None, is_virtual_network_filter_enabled: bool=None, enable_automatic_failover: bool=None, capabilities=None, virtual_network_rules=None, enable_multiple_write_locations: bool=None, enable_cassandra_connector: bool=None, connector_offer=None, disable_key_based_metadata_write_access: bool=None, key_vault_key_uri: str=None, public_network_access=None, enable_free_tier: bool=None, api_properties=None, enable_analytical_storage: bool=None, backup_policy=None, cors=None, identity=None, **kwargs) -> None:
        super(DatabaseAccountUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.location = location
        self.consistency_policy = consistency_policy
        self.locations = locations
        self.ip_rules = ip_rules
        self.is_virtual_network_filter_enabled = is_virtual_network_filter_enabled
        self.enable_automatic_failover = enable_automatic_failover
        self.capabilities = capabilities
        self.virtual_network_rules = virtual_network_rules
        self.enable_multiple_write_locations = enable_multiple_write_locations
        self.enable_cassandra_connector = enable_cassandra_connector
        self.connector_offer = connector_offer
        self.disable_key_based_metadata_write_access = disable_key_based_metadata_write_access
        self.key_vault_key_uri = key_vault_key_uri
        self.public_network_access = public_network_access
        self.enable_free_tier = enable_free_tier
        self.api_properties = api_properties
        self.enable_analytical_storage = enable_analytical_storage
        self.backup_policy = backup_policy
        self.cors = cors
        self.identity = identity


class DatabaseRestoreResource(Model):
    """Specific Databases to restore.

    :param database_name: The name of the database available for restore.
    :type database_name: str
    :param collection_names: The names of the collections available for
     restore.
    :type collection_names: list[str]
    """

    _attribute_map = {
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'collection_names': {'key': 'collectionNames', 'type': '[str]'},
    }

    def __init__(self, *, database_name: str=None, collection_names=None, **kwargs) -> None:
        super(DatabaseRestoreResource, self).__init__(**kwargs)
        self.database_name = database_name
        self.collection_names = collection_names


class DefaultErrorResponse(Model):
    """An error response from the service.

    :param error:
    :type error: ~azure.mgmt.cosmosdb.models.ErrorResponse
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(DefaultErrorResponse, self).__init__(**kwargs)
        self.error = error


class DefaultErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'DefaultErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(DefaultErrorResponseException, self).__init__(deserialize, response, 'DefaultErrorResponse', *args)


class DefaultRequestDatabaseAccountCreateUpdateProperties(DatabaseAccountCreateUpdateProperties):
    """Properties for non-restore Azure Cosmos DB database account requests.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param consistency_policy: The consistency policy for the Cosmos DB
     account.
    :type consistency_policy: ~azure.mgmt.cosmosdb.models.ConsistencyPolicy
    :param locations: Required. An array that contains the georeplication
     locations enabled for the Cosmos DB account.
    :type locations: list[~azure.mgmt.cosmosdb.models.Location]
    :ivar database_account_offer_type: Required. The offer type for the
     database. Default value: "Standard" .
    :vartype database_account_offer_type: str
    :param ip_rules: List of IpRules.
    :type ip_rules: list[~azure.mgmt.cosmosdb.models.IpAddressOrRange]
    :param is_virtual_network_filter_enabled: Flag to indicate whether to
     enable/disable Virtual Network ACL rules.
    :type is_virtual_network_filter_enabled: bool
    :param enable_automatic_failover: Enables automatic failover of the write
     region in the rare event that the region is unavailable due to an outage.
     Automatic failover will result in a new write region for the account and
     is chosen based on the failover priorities configured for the account.
    :type enable_automatic_failover: bool
    :param capabilities: List of Cosmos DB capabilities for the account
    :type capabilities: list[~azure.mgmt.cosmosdb.models.Capability]
    :param virtual_network_rules: List of Virtual Network ACL rules configured
     for the Cosmos DB account.
    :type virtual_network_rules:
     list[~azure.mgmt.cosmosdb.models.VirtualNetworkRule]
    :param enable_multiple_write_locations: Enables the account to write in
     multiple locations
    :type enable_multiple_write_locations: bool
    :param enable_cassandra_connector: Enables the cassandra connector on the
     Cosmos DB C* account
    :type enable_cassandra_connector: bool
    :param connector_offer: The cassandra connector offer type for the Cosmos
     DB database C* account. Possible values include: 'Small'
    :type connector_offer: str or ~azure.mgmt.cosmosdb.models.ConnectorOffer
    :param disable_key_based_metadata_write_access: Disable write operations
     on metadata resources (databases, containers, throughput) via account keys
    :type disable_key_based_metadata_write_access: bool
    :param key_vault_key_uri: The URI of the key vault
    :type key_vault_key_uri: str
    :param public_network_access: Whether requests from Public Network are
     allowed. Possible values include: 'Enabled', 'Disabled'
    :type public_network_access: str or
     ~azure.mgmt.cosmosdb.models.PublicNetworkAccess
    :param enable_free_tier: Flag to indicate whether Free Tier is enabled.
    :type enable_free_tier: bool
    :param api_properties: API specific properties. Currently, supported only
     for MongoDB API.
    :type api_properties: ~azure.mgmt.cosmosdb.models.ApiProperties
    :param enable_analytical_storage: Flag to indicate whether to enable
     storage analytics.
    :type enable_analytical_storage: bool
    :param backup_policy: The object representing the policy for taking
     backups on an account.
    :type backup_policy: ~azure.mgmt.cosmosdb.models.BackupPolicy
    :param cors: The CORS policy for the Cosmos DB database account.
    :type cors: list[~azure.mgmt.cosmosdb.models.CorsPolicy]
    :param create_mode: Required. Constant filled by server.
    :type create_mode: str
    """

    _validation = {
        'locations': {'required': True},
        'database_account_offer_type': {'required': True, 'constant': True},
        'create_mode': {'required': True},
    }

    _attribute_map = {
        'consistency_policy': {'key': 'consistencyPolicy', 'type': 'ConsistencyPolicy'},
        'locations': {'key': 'locations', 'type': '[Location]'},
        'database_account_offer_type': {'key': 'databaseAccountOfferType', 'type': 'str'},
        'ip_rules': {'key': 'ipRules', 'type': '[IpAddressOrRange]'},
        'is_virtual_network_filter_enabled': {'key': 'isVirtualNetworkFilterEnabled', 'type': 'bool'},
        'enable_automatic_failover': {'key': 'enableAutomaticFailover', 'type': 'bool'},
        'capabilities': {'key': 'capabilities', 'type': '[Capability]'},
        'virtual_network_rules': {'key': 'virtualNetworkRules', 'type': '[VirtualNetworkRule]'},
        'enable_multiple_write_locations': {'key': 'enableMultipleWriteLocations', 'type': 'bool'},
        'enable_cassandra_connector': {'key': 'enableCassandraConnector', 'type': 'bool'},
        'connector_offer': {'key': 'connectorOffer', 'type': 'str'},
        'disable_key_based_metadata_write_access': {'key': 'disableKeyBasedMetadataWriteAccess', 'type': 'bool'},
        'key_vault_key_uri': {'key': 'keyVaultKeyUri', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'enable_free_tier': {'key': 'enableFreeTier', 'type': 'bool'},
        'api_properties': {'key': 'apiProperties', 'type': 'ApiProperties'},
        'enable_analytical_storage': {'key': 'enableAnalyticalStorage', 'type': 'bool'},
        'backup_policy': {'key': 'backupPolicy', 'type': 'BackupPolicy'},
        'cors': {'key': 'cors', 'type': '[CorsPolicy]'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
    }

    def __init__(self, *, locations, consistency_policy=None, ip_rules=None, is_virtual_network_filter_enabled: bool=None, enable_automatic_failover: bool=None, capabilities=None, virtual_network_rules=None, enable_multiple_write_locations: bool=None, enable_cassandra_connector: bool=None, connector_offer=None, disable_key_based_metadata_write_access: bool=None, key_vault_key_uri: str=None, public_network_access=None, enable_free_tier: bool=None, api_properties=None, enable_analytical_storage: bool=None, backup_policy=None, cors=None, **kwargs) -> None:
        super(DefaultRequestDatabaseAccountCreateUpdateProperties, self).__init__(consistency_policy=consistency_policy, locations=locations, ip_rules=ip_rules, is_virtual_network_filter_enabled=is_virtual_network_filter_enabled, enable_automatic_failover=enable_automatic_failover, capabilities=capabilities, virtual_network_rules=virtual_network_rules, enable_multiple_write_locations=enable_multiple_write_locations, enable_cassandra_connector=enable_cassandra_connector, connector_offer=connector_offer, disable_key_based_metadata_write_access=disable_key_based_metadata_write_access, key_vault_key_uri=key_vault_key_uri, public_network_access=public_network_access, enable_free_tier=enable_free_tier, api_properties=api_properties, enable_analytical_storage=enable_analytical_storage, backup_policy=backup_policy, cors=cors, **kwargs)
        self.create_mode = 'Default'


class ErrorResponse(Model):
    """Error Response.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, code: str=None, message: str=None, **kwargs) -> None:
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class ExcludedPath(Model):
    """ExcludedPath.

    :param path: The path for which the indexing behavior applies to. Index
     paths typically start with root and end with wildcard (/path/*)
    :type path: str
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(self, *, path: str=None, **kwargs) -> None:
        super(ExcludedPath, self).__init__(**kwargs)
        self.path = path


class ExtendedResourceProperties(Model):
    """The system generated resource properties associated with SQL databases, SQL
    containers, Gremlin databases and Gremlin graphs.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar _rid: A system generated property. A unique identifier.
    :vartype _rid: str
    :ivar _ts: A system generated property that denotes the last updated
     timestamp of the resource.
    :vartype _ts: object
    :ivar _etag: A system generated property representing the resource etag
     required for optimistic concurrency control.
    :vartype _etag: str
    """

    _validation = {
        '_rid': {'readonly': True},
        '_ts': {'readonly': True},
        '_etag': {'readonly': True},
    }

    _attribute_map = {
        '_rid': {'key': '_rid', 'type': 'str'},
        '_ts': {'key': '_ts', 'type': 'object'},
        '_etag': {'key': '_etag', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ExtendedResourceProperties, self).__init__(**kwargs)
        self._rid = None
        self._ts = None
        self._etag = None


class FailoverPolicies(Model):
    """The list of new failover policies for the failover priority change.

    All required parameters must be populated in order to send to Azure.

    :param failover_policies: Required. List of failover policies.
    :type failover_policies: list[~azure.mgmt.cosmosdb.models.FailoverPolicy]
    """

    _validation = {
        'failover_policies': {'required': True},
    }

    _attribute_map = {
        'failover_policies': {'key': 'failoverPolicies', 'type': '[FailoverPolicy]'},
    }

    def __init__(self, *, failover_policies, **kwargs) -> None:
        super(FailoverPolicies, self).__init__(**kwargs)
        self.failover_policies = failover_policies


class FailoverPolicy(Model):
    """The failover policy for a given region of a database account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique identifier of the region in which the database
     account replicates to. Example: &lt;accountName&gt;-&lt;locationName&gt;.
    :vartype id: str
    :param location_name: The name of the region in which the database account
     exists.
    :type location_name: str
    :param failover_priority: The failover priority of the region. A failover
     priority of 0 indicates a write region. The maximum value for a failover
     priority = (total number of regions - 1). Failover priority values must be
     unique for each of the regions in which the database account exists.
    :type failover_priority: int
    """

    _validation = {
        'id': {'readonly': True},
        'failover_priority': {'minimum': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'location_name': {'key': 'locationName', 'type': 'str'},
        'failover_priority': {'key': 'failoverPriority', 'type': 'int'},
    }

    def __init__(self, *, location_name: str=None, failover_priority: int=None, **kwargs) -> None:
        super(FailoverPolicy, self).__init__(**kwargs)
        self.id = None
        self.location_name = location_name
        self.failover_priority = failover_priority


class GremlinDatabaseCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB Gremlin database.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource: Required. The standard JSON format of a Gremlin database
    :type resource: ~azure.mgmt.cosmosdb.models.GremlinDatabaseResource
    :param options: Required. A key-value pair of options to be applied for
     the request. This corresponds to the headers sent with the request.
    :type options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource': {'required': True},
        'options': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'GremlinDatabaseResource'},
        'options': {'key': 'properties.options', 'type': 'CreateUpdateOptions'},
    }

    def __init__(self, *, resource, options, location: str=None, tags=None, identity=None, **kwargs) -> None:
        super(GremlinDatabaseCreateUpdateParameters, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource
        self.options = options


class GremlinDatabaseGetPropertiesOptions(OptionsResource):
    """GremlinDatabaseGetPropertiesOptions.

    :param throughput: Value of the Cosmos DB resource throughput or
     autoscaleSettings. Use the ThroughputSetting resource when retrieving
     offer details.
    :type throughput: int
    :param autoscale_settings: Specifies the Autoscale settings.
    :type autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
    """

    _attribute_map = {
        'throughput': {'key': 'throughput', 'type': 'int'},
        'autoscale_settings': {'key': 'autoscaleSettings', 'type': 'AutoscaleSettings'},
    }

    def __init__(self, *, throughput: int=None, autoscale_settings=None, **kwargs) -> None:
        super(GremlinDatabaseGetPropertiesOptions, self).__init__(throughput=throughput, autoscale_settings=autoscale_settings, **kwargs)


class GremlinDatabaseGetPropertiesResource(Model):
    """GremlinDatabaseGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB Gremlin database
    :type id: str
    :ivar _rid: A system generated property. A unique identifier.
    :vartype _rid: str
    :ivar _ts: A system generated property that denotes the last updated
     timestamp of the resource.
    :vartype _ts: object
    :ivar _etag: A system generated property representing the resource etag
     required for optimistic concurrency control.
    :vartype _etag: str
    """

    _validation = {
        'id': {'required': True},
        '_rid': {'readonly': True},
        '_ts': {'readonly': True},
        '_etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        '_rid': {'key': '_rid', 'type': 'str'},
        '_ts': {'key': '_ts', 'type': 'object'},
        '_etag': {'key': '_etag', 'type': 'str'},
    }

    def __init__(self, *, id: str, **kwargs) -> None:
        super(GremlinDatabaseGetPropertiesResource, self).__init__(**kwargs)
        self.id = id
        self._rid = None
        self._ts = None
        self._etag = None


class GremlinDatabaseGetResults(ARMResourceProperties):
    """An Azure Cosmos DB Gremlin database.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource:
    :type resource:
     ~azure.mgmt.cosmosdb.models.GremlinDatabaseGetPropertiesResource
    :param options:
    :type options:
     ~azure.mgmt.cosmosdb.models.GremlinDatabaseGetPropertiesOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'GremlinDatabaseGetPropertiesResource'},
        'options': {'key': 'properties.options', 'type': 'GremlinDatabaseGetPropertiesOptions'},
    }

    def __init__(self, *, location: str=None, tags=None, identity=None, resource=None, options=None, **kwargs) -> None:
        super(GremlinDatabaseGetResults, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource
        self.options = options


class GremlinDatabaseResource(Model):
    """Cosmos DB Gremlin database resource object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB Gremlin database
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str, **kwargs) -> None:
        super(GremlinDatabaseResource, self).__init__(**kwargs)
        self.id = id


class GremlinGraphCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB Gremlin graph.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource: Required. The standard JSON format of a Gremlin graph
    :type resource: ~azure.mgmt.cosmosdb.models.GremlinGraphResource
    :param options: Required. A key-value pair of options to be applied for
     the request. This corresponds to the headers sent with the request.
    :type options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource': {'required': True},
        'options': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'GremlinGraphResource'},
        'options': {'key': 'properties.options', 'type': 'CreateUpdateOptions'},
    }

    def __init__(self, *, resource, options, location: str=None, tags=None, identity=None, **kwargs) -> None:
        super(GremlinGraphCreateUpdateParameters, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource
        self.options = options


class GremlinGraphGetPropertiesOptions(OptionsResource):
    """GremlinGraphGetPropertiesOptions.

    :param throughput: Value of the Cosmos DB resource throughput or
     autoscaleSettings. Use the ThroughputSetting resource when retrieving
     offer details.
    :type throughput: int
    :param autoscale_settings: Specifies the Autoscale settings.
    :type autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
    """

    _attribute_map = {
        'throughput': {'key': 'throughput', 'type': 'int'},
        'autoscale_settings': {'key': 'autoscaleSettings', 'type': 'AutoscaleSettings'},
    }

    def __init__(self, *, throughput: int=None, autoscale_settings=None, **kwargs) -> None:
        super(GremlinGraphGetPropertiesOptions, self).__init__(throughput=throughput, autoscale_settings=autoscale_settings, **kwargs)


class GremlinGraphGetPropertiesResource(Model):
    """GremlinGraphGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB Gremlin graph
    :type id: str
    :param indexing_policy: The configuration of the indexing policy. By
     default, the indexing is automatic for all document paths within the graph
    :type indexing_policy: ~azure.mgmt.cosmosdb.models.IndexingPolicy
    :param partition_key: The configuration of the partition key to be used
     for partitioning data into multiple partitions
    :type partition_key: ~azure.mgmt.cosmosdb.models.ContainerPartitionKey
    :param default_ttl: Default time to live
    :type default_ttl: int
    :param unique_key_policy: The unique key policy configuration for
     specifying uniqueness constraints on documents in the collection in the
     Azure Cosmos DB service.
    :type unique_key_policy: ~azure.mgmt.cosmosdb.models.UniqueKeyPolicy
    :param conflict_resolution_policy: The conflict resolution policy for the
     graph.
    :type conflict_resolution_policy:
     ~azure.mgmt.cosmosdb.models.ConflictResolutionPolicy
    :ivar _rid: A system generated property. A unique identifier.
    :vartype _rid: str
    :ivar _ts: A system generated property that denotes the last updated
     timestamp of the resource.
    :vartype _ts: object
    :ivar _etag: A system generated property representing the resource etag
     required for optimistic concurrency control.
    :vartype _etag: str
    """

    _validation = {
        'id': {'required': True},
        '_rid': {'readonly': True},
        '_ts': {'readonly': True},
        '_etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'indexing_policy': {'key': 'indexingPolicy', 'type': 'IndexingPolicy'},
        'partition_key': {'key': 'partitionKey', 'type': 'ContainerPartitionKey'},
        'default_ttl': {'key': 'defaultTtl', 'type': 'int'},
        'unique_key_policy': {'key': 'uniqueKeyPolicy', 'type': 'UniqueKeyPolicy'},
        'conflict_resolution_policy': {'key': 'conflictResolutionPolicy', 'type': 'ConflictResolutionPolicy'},
        '_rid': {'key': '_rid', 'type': 'str'},
        '_ts': {'key': '_ts', 'type': 'object'},
        '_etag': {'key': '_etag', 'type': 'str'},
    }

    def __init__(self, *, id: str, indexing_policy=None, partition_key=None, default_ttl: int=None, unique_key_policy=None, conflict_resolution_policy=None, **kwargs) -> None:
        super(GremlinGraphGetPropertiesResource, self).__init__(**kwargs)
        self.id = id
        self.indexing_policy = indexing_policy
        self.partition_key = partition_key
        self.default_ttl = default_ttl
        self.unique_key_policy = unique_key_policy
        self.conflict_resolution_policy = conflict_resolution_policy
        self._rid = None
        self._ts = None
        self._etag = None


class GremlinGraphGetResults(ARMResourceProperties):
    """An Azure Cosmos DB Gremlin graph.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource:
    :type resource:
     ~azure.mgmt.cosmosdb.models.GremlinGraphGetPropertiesResource
    :param options:
    :type options:
     ~azure.mgmt.cosmosdb.models.GremlinGraphGetPropertiesOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'GremlinGraphGetPropertiesResource'},
        'options': {'key': 'properties.options', 'type': 'GremlinGraphGetPropertiesOptions'},
    }

    def __init__(self, *, location: str=None, tags=None, identity=None, resource=None, options=None, **kwargs) -> None:
        super(GremlinGraphGetResults, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource
        self.options = options


class GremlinGraphResource(Model):
    """Cosmos DB Gremlin graph resource object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB Gremlin graph
    :type id: str
    :param indexing_policy: The configuration of the indexing policy. By
     default, the indexing is automatic for all document paths within the graph
    :type indexing_policy: ~azure.mgmt.cosmosdb.models.IndexingPolicy
    :param partition_key: The configuration of the partition key to be used
     for partitioning data into multiple partitions
    :type partition_key: ~azure.mgmt.cosmosdb.models.ContainerPartitionKey
    :param default_ttl: Default time to live
    :type default_ttl: int
    :param unique_key_policy: The unique key policy configuration for
     specifying uniqueness constraints on documents in the collection in the
     Azure Cosmos DB service.
    :type unique_key_policy: ~azure.mgmt.cosmosdb.models.UniqueKeyPolicy
    :param conflict_resolution_policy: The conflict resolution policy for the
     graph.
    :type conflict_resolution_policy:
     ~azure.mgmt.cosmosdb.models.ConflictResolutionPolicy
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'indexing_policy': {'key': 'indexingPolicy', 'type': 'IndexingPolicy'},
        'partition_key': {'key': 'partitionKey', 'type': 'ContainerPartitionKey'},
        'default_ttl': {'key': 'defaultTtl', 'type': 'int'},
        'unique_key_policy': {'key': 'uniqueKeyPolicy', 'type': 'UniqueKeyPolicy'},
        'conflict_resolution_policy': {'key': 'conflictResolutionPolicy', 'type': 'ConflictResolutionPolicy'},
    }

    def __init__(self, *, id: str, indexing_policy=None, partition_key=None, default_ttl: int=None, unique_key_policy=None, conflict_resolution_policy=None, **kwargs) -> None:
        super(GremlinGraphResource, self).__init__(**kwargs)
        self.id = id
        self.indexing_policy = indexing_policy
        self.partition_key = partition_key
        self.default_ttl = default_ttl
        self.unique_key_policy = unique_key_policy
        self.conflict_resolution_policy = conflict_resolution_policy


class IncludedPath(Model):
    """The paths that are included in indexing.

    :param path: The path for which the indexing behavior applies to. Index
     paths typically start with root and end with wildcard (/path/*)
    :type path: str
    :param indexes: List of indexes for this path
    :type indexes: list[~azure.mgmt.cosmosdb.models.Indexes]
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'indexes': {'key': 'indexes', 'type': '[Indexes]'},
    }

    def __init__(self, *, path: str=None, indexes=None, **kwargs) -> None:
        super(IncludedPath, self).__init__(**kwargs)
        self.path = path
        self.indexes = indexes


class Indexes(Model):
    """The indexes for the path.

    :param data_type: The datatype for which the indexing behavior is applied
     to. Possible values include: 'String', 'Number', 'Point', 'Polygon',
     'LineString', 'MultiPolygon'. Default value: "String" .
    :type data_type: str or ~azure.mgmt.cosmosdb.models.DataType
    :param precision: The precision of the index. -1 is maximum precision.
    :type precision: int
    :param kind: Indicates the type of index. Possible values include: 'Hash',
     'Range', 'Spatial'. Default value: "Hash" .
    :type kind: str or ~azure.mgmt.cosmosdb.models.IndexKind
    """

    _attribute_map = {
        'data_type': {'key': 'dataType', 'type': 'str'},
        'precision': {'key': 'precision', 'type': 'int'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(self, *, data_type="String", precision: int=None, kind="Hash", **kwargs) -> None:
        super(Indexes, self).__init__(**kwargs)
        self.data_type = data_type
        self.precision = precision
        self.kind = kind


class IndexingPolicy(Model):
    """Cosmos DB indexing policy.

    :param automatic: Indicates if the indexing policy is automatic
    :type automatic: bool
    :param indexing_mode: Indicates the indexing mode. Possible values
     include: 'Consistent', 'Lazy', 'None'. Default value: "Consistent" .
    :type indexing_mode: str or ~azure.mgmt.cosmosdb.models.IndexingMode
    :param included_paths: List of paths to include in the indexing
    :type included_paths: list[~azure.mgmt.cosmosdb.models.IncludedPath]
    :param excluded_paths: List of paths to exclude from indexing
    :type excluded_paths: list[~azure.mgmt.cosmosdb.models.ExcludedPath]
    :param composite_indexes: List of composite path list
    :type composite_indexes:
     list[list[~azure.mgmt.cosmosdb.models.CompositePath]]
    :param spatial_indexes: List of spatial specifics
    :type spatial_indexes: list[~azure.mgmt.cosmosdb.models.SpatialSpec]
    """

    _attribute_map = {
        'automatic': {'key': 'automatic', 'type': 'bool'},
        'indexing_mode': {'key': 'indexingMode', 'type': 'str'},
        'included_paths': {'key': 'includedPaths', 'type': '[IncludedPath]'},
        'excluded_paths': {'key': 'excludedPaths', 'type': '[ExcludedPath]'},
        'composite_indexes': {'key': 'compositeIndexes', 'type': '[[CompositePath]]'},
        'spatial_indexes': {'key': 'spatialIndexes', 'type': '[SpatialSpec]'},
    }

    def __init__(self, *, automatic: bool=None, indexing_mode="Consistent", included_paths=None, excluded_paths=None, composite_indexes=None, spatial_indexes=None, **kwargs) -> None:
        super(IndexingPolicy, self).__init__(**kwargs)
        self.automatic = automatic
        self.indexing_mode = indexing_mode
        self.included_paths = included_paths
        self.excluded_paths = excluded_paths
        self.composite_indexes = composite_indexes
        self.spatial_indexes = spatial_indexes


class IpAddressOrRange(Model):
    """IpAddressOrRange object.

    :param ip_address_or_range: A single IPv4 address or a single IPv4 address
     range in CIDR format. Provided IPs must be well-formatted and cannot be
     contained in one of the following ranges: 10.0.0.0/8, 100.64.0.0/10,
     172.16.0.0/12, 192.168.0.0/16, since these are not enforceable by the IP
     address filter. Example of valid inputs: “23.40.210.245” or
     “23.40.210.0/8”.
    :type ip_address_or_range: str
    """

    _attribute_map = {
        'ip_address_or_range': {'key': 'ipAddressOrRange', 'type': 'str'},
    }

    def __init__(self, *, ip_address_or_range: str=None, **kwargs) -> None:
        super(IpAddressOrRange, self).__init__(**kwargs)
        self.ip_address_or_range = ip_address_or_range


class Location(Model):
    """A region in which the Azure Cosmos DB database account is deployed.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique identifier of the region within the database account.
     Example: &lt;accountName&gt;-&lt;locationName&gt;.
    :vartype id: str
    :param location_name: The name of the region.
    :type location_name: str
    :ivar document_endpoint: The connection endpoint for the specific region.
     Example:
     https://&lt;accountName&gt;-&lt;locationName&gt;.documents.azure.com:443/
    :vartype document_endpoint: str
    :param provisioning_state:
    :type provisioning_state: str
    :param failover_priority: The failover priority of the region. A failover
     priority of 0 indicates a write region. The maximum value for a failover
     priority = (total number of regions - 1). Failover priority values must be
     unique for each of the regions in which the database account exists.
    :type failover_priority: int
    :param is_zone_redundant: Flag to indicate whether or not this region is
     an AvailabilityZone region
    :type is_zone_redundant: bool
    """

    _validation = {
        'id': {'readonly': True},
        'document_endpoint': {'readonly': True},
        'failover_priority': {'minimum': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'location_name': {'key': 'locationName', 'type': 'str'},
        'document_endpoint': {'key': 'documentEndpoint', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'failover_priority': {'key': 'failoverPriority', 'type': 'int'},
        'is_zone_redundant': {'key': 'isZoneRedundant', 'type': 'bool'},
    }

    def __init__(self, *, location_name: str=None, provisioning_state: str=None, failover_priority: int=None, is_zone_redundant: bool=None, **kwargs) -> None:
        super(Location, self).__init__(**kwargs)
        self.id = None
        self.location_name = location_name
        self.document_endpoint = None
        self.provisioning_state = provisioning_state
        self.failover_priority = failover_priority
        self.is_zone_redundant = is_zone_redundant


class ManagedServiceIdentity(Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar principal_id: The principal id of the system assigned identity. This
     property will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the system assigned identity. This
     property will only be provided for a system assigned identity.
    :vartype tenant_id: str
    :param type: The type of identity used for the resource. The type
     'SystemAssigned,UserAssigned' includes both an implicitly created identity
     and a set of user assigned identities. The type 'None' will remove any
     identities from the service. Possible values include: 'SystemAssigned',
     'UserAssigned', 'SystemAssigned,UserAssigned', 'None'
    :type type: str or ~azure.mgmt.cosmosdb.models.ResourceIdentityType
    :param user_assigned_identities: The list of user identities associated
     with resource. The user identity dictionary key references will be ARM
     resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.cosmosdb.models.ManagedServiceIdentityUserAssignedIdentitiesValue]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'ResourceIdentityType'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{ManagedServiceIdentityUserAssignedIdentitiesValue}'},
    }

    def __init__(self, *, type=None, user_assigned_identities=None, **kwargs) -> None:
        super(ManagedServiceIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class ManagedServiceIdentityUserAssignedIdentitiesValue(Model):
    """ManagedServiceIdentityUserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ManagedServiceIdentityUserAssignedIdentitiesValue, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class Metric(Model):
    """Metric data.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar start_time: The start time for the metric (ISO-8601 format).
    :vartype start_time: datetime
    :ivar end_time: The end time for the metric (ISO-8601 format).
    :vartype end_time: datetime
    :ivar time_grain: The time grain to be used to summarize the metric
     values.
    :vartype time_grain: str
    :param unit: The unit of the metric. Possible values include: 'Count',
     'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond',
     'Milliseconds'
    :type unit: str or ~azure.mgmt.cosmosdb.models.UnitType
    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.cosmosdb.models.MetricName
    :ivar metric_values: The metric values for the specified time window and
     timestep.
    :vartype metric_values: list[~azure.mgmt.cosmosdb.models.MetricValue]
    """

    _validation = {
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'time_grain': {'readonly': True},
        'name': {'readonly': True},
        'metric_values': {'readonly': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'name': {'key': 'name', 'type': 'MetricName'},
        'metric_values': {'key': 'metricValues', 'type': '[MetricValue]'},
    }

    def __init__(self, *, unit=None, **kwargs) -> None:
        super(Metric, self).__init__(**kwargs)
        self.start_time = None
        self.end_time = None
        self.time_grain = None
        self.unit = unit
        self.name = None
        self.metric_values = None


class MetricAvailability(Model):
    """The availability of the metric.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar time_grain: The time grain to be used to summarize the metric
     values.
    :vartype time_grain: str
    :ivar retention: The retention for the metric values.
    :vartype retention: str
    """

    _validation = {
        'time_grain': {'readonly': True},
        'retention': {'readonly': True},
    }

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'retention': {'key': 'retention', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(MetricAvailability, self).__init__(**kwargs)
        self.time_grain = None
        self.retention = None


class MetricDefinition(Model):
    """The definition of a metric.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar metric_availabilities: The list of metric availabilities for the
     account.
    :vartype metric_availabilities:
     list[~azure.mgmt.cosmosdb.models.MetricAvailability]
    :ivar primary_aggregation_type: The primary aggregation type of the
     metric. Possible values include: 'None', 'Average', 'Total', 'Minimum',
     'Maximum', 'Last'
    :vartype primary_aggregation_type: str or
     ~azure.mgmt.cosmosdb.models.PrimaryAggregationType
    :param unit: The unit of the metric. Possible values include: 'Count',
     'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond',
     'Milliseconds'
    :type unit: str or ~azure.mgmt.cosmosdb.models.UnitType
    :ivar resource_uri: The resource uri of the database.
    :vartype resource_uri: str
    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.cosmosdb.models.MetricName
    """

    _validation = {
        'metric_availabilities': {'readonly': True},
        'primary_aggregation_type': {'readonly': True},
        'resource_uri': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'metric_availabilities': {'key': 'metricAvailabilities', 'type': '[MetricAvailability]'},
        'primary_aggregation_type': {'key': 'primaryAggregationType', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'name': {'key': 'name', 'type': 'MetricName'},
    }

    def __init__(self, *, unit=None, **kwargs) -> None:
        super(MetricDefinition, self).__init__(**kwargs)
        self.metric_availabilities = None
        self.primary_aggregation_type = None
        self.unit = unit
        self.resource_uri = None
        self.name = None


class MetricName(Model):
    """A metric name.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: The name of the metric.
    :vartype value: str
    :ivar localized_value: The friendly name of the metric.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'readonly': True},
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(MetricName, self).__init__(**kwargs)
        self.value = None
        self.localized_value = None


class MetricValue(Model):
    """Represents metrics values.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar _count: The number of values for the metric.
    :vartype _count: float
    :ivar average: The average value of the metric.
    :vartype average: float
    :ivar maximum: The max value of the metric.
    :vartype maximum: float
    :ivar minimum: The min value of the metric.
    :vartype minimum: float
    :ivar timestamp: The metric timestamp (ISO-8601 format).
    :vartype timestamp: datetime
    :ivar total: The total value of the metric.
    :vartype total: float
    """

    _validation = {
        '_count': {'readonly': True},
        'average': {'readonly': True},
        'maximum': {'readonly': True},
        'minimum': {'readonly': True},
        'timestamp': {'readonly': True},
        'total': {'readonly': True},
    }

    _attribute_map = {
        '_count': {'key': '_count', 'type': 'float'},
        'average': {'key': 'average', 'type': 'float'},
        'maximum': {'key': 'maximum', 'type': 'float'},
        'minimum': {'key': 'minimum', 'type': 'float'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'total': {'key': 'total', 'type': 'float'},
    }

    def __init__(self, **kwargs) -> None:
        super(MetricValue, self).__init__(**kwargs)
        self._count = None
        self.average = None
        self.maximum = None
        self.minimum = None
        self.timestamp = None
        self.total = None


class MongoDBCollectionCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB MongoDB collection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource: Required. The standard JSON format of a MongoDB
     collection
    :type resource: ~azure.mgmt.cosmosdb.models.MongoDBCollectionResource
    :param options: Required. A key-value pair of options to be applied for
     the request. This corresponds to the headers sent with the request.
    :type options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource': {'required': True},
        'options': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'MongoDBCollectionResource'},
        'options': {'key': 'properties.options', 'type': 'CreateUpdateOptions'},
    }

    def __init__(self, *, resource, options, location: str=None, tags=None, identity=None, **kwargs) -> None:
        super(MongoDBCollectionCreateUpdateParameters, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource
        self.options = options


class MongoDBCollectionGetPropertiesOptions(OptionsResource):
    """MongoDBCollectionGetPropertiesOptions.

    :param throughput: Value of the Cosmos DB resource throughput or
     autoscaleSettings. Use the ThroughputSetting resource when retrieving
     offer details.
    :type throughput: int
    :param autoscale_settings: Specifies the Autoscale settings.
    :type autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
    """

    _attribute_map = {
        'throughput': {'key': 'throughput', 'type': 'int'},
        'autoscale_settings': {'key': 'autoscaleSettings', 'type': 'AutoscaleSettings'},
    }

    def __init__(self, *, throughput: int=None, autoscale_settings=None, **kwargs) -> None:
        super(MongoDBCollectionGetPropertiesOptions, self).__init__(throughput=throughput, autoscale_settings=autoscale_settings, **kwargs)


class MongoDBCollectionGetPropertiesResource(Model):
    """MongoDBCollectionGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB MongoDB collection
    :type id: str
    :param shard_key: A key-value pair of shard keys to be applied for the
     request.
    :type shard_key: dict[str, str]
    :param indexes: List of index keys
    :type indexes: list[~azure.mgmt.cosmosdb.models.MongoIndex]
    :param analytical_storage_ttl: Analytical TTL.
    :type analytical_storage_ttl: int
    :ivar _rid: A system generated property. A unique identifier.
    :vartype _rid: str
    :ivar _ts: A system generated property that denotes the last updated
     timestamp of the resource.
    :vartype _ts: object
    :ivar _etag: A system generated property representing the resource etag
     required for optimistic concurrency control.
    :vartype _etag: str
    """

    _validation = {
        'id': {'required': True},
        '_rid': {'readonly': True},
        '_ts': {'readonly': True},
        '_etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'shard_key': {'key': 'shardKey', 'type': '{str}'},
        'indexes': {'key': 'indexes', 'type': '[MongoIndex]'},
        'analytical_storage_ttl': {'key': 'analyticalStorageTtl', 'type': 'int'},
        '_rid': {'key': '_rid', 'type': 'str'},
        '_ts': {'key': '_ts', 'type': 'object'},
        '_etag': {'key': '_etag', 'type': 'str'},
    }

    def __init__(self, *, id: str, shard_key=None, indexes=None, analytical_storage_ttl: int=None, **kwargs) -> None:
        super(MongoDBCollectionGetPropertiesResource, self).__init__(**kwargs)
        self.id = id
        self.shard_key = shard_key
        self.indexes = indexes
        self.analytical_storage_ttl = analytical_storage_ttl
        self._rid = None
        self._ts = None
        self._etag = None


class MongoDBCollectionGetResults(ARMResourceProperties):
    """An Azure Cosmos DB MongoDB collection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource:
    :type resource:
     ~azure.mgmt.cosmosdb.models.MongoDBCollectionGetPropertiesResource
    :param options:
    :type options:
     ~azure.mgmt.cosmosdb.models.MongoDBCollectionGetPropertiesOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'MongoDBCollectionGetPropertiesResource'},
        'options': {'key': 'properties.options', 'type': 'MongoDBCollectionGetPropertiesOptions'},
    }

    def __init__(self, *, location: str=None, tags=None, identity=None, resource=None, options=None, **kwargs) -> None:
        super(MongoDBCollectionGetResults, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource
        self.options = options


class MongoDBCollectionResource(Model):
    """Cosmos DB MongoDB collection resource object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB MongoDB collection
    :type id: str
    :param shard_key: A key-value pair of shard keys to be applied for the
     request.
    :type shard_key: dict[str, str]
    :param indexes: List of index keys
    :type indexes: list[~azure.mgmt.cosmosdb.models.MongoIndex]
    :param analytical_storage_ttl: Analytical TTL.
    :type analytical_storage_ttl: int
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'shard_key': {'key': 'shardKey', 'type': '{str}'},
        'indexes': {'key': 'indexes', 'type': '[MongoIndex]'},
        'analytical_storage_ttl': {'key': 'analyticalStorageTtl', 'type': 'int'},
    }

    def __init__(self, *, id: str, shard_key=None, indexes=None, analytical_storage_ttl: int=None, **kwargs) -> None:
        super(MongoDBCollectionResource, self).__init__(**kwargs)
        self.id = id
        self.shard_key = shard_key
        self.indexes = indexes
        self.analytical_storage_ttl = analytical_storage_ttl


class MongoDBDatabaseCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB MongoDB database.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource: Required. The standard JSON format of a MongoDB database
    :type resource: ~azure.mgmt.cosmosdb.models.MongoDBDatabaseResource
    :param options: Required. A key-value pair of options to be applied for
     the request. This corresponds to the headers sent with the request.
    :type options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource': {'required': True},
        'options': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'MongoDBDatabaseResource'},
        'options': {'key': 'properties.options', 'type': 'CreateUpdateOptions'},
    }

    def __init__(self, *, resource, options, location: str=None, tags=None, identity=None, **kwargs) -> None:
        super(MongoDBDatabaseCreateUpdateParameters, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource
        self.options = options


class MongoDBDatabaseGetPropertiesOptions(OptionsResource):
    """MongoDBDatabaseGetPropertiesOptions.

    :param throughput: Value of the Cosmos DB resource throughput or
     autoscaleSettings. Use the ThroughputSetting resource when retrieving
     offer details.
    :type throughput: int
    :param autoscale_settings: Specifies the Autoscale settings.
    :type autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
    """

    _attribute_map = {
        'throughput': {'key': 'throughput', 'type': 'int'},
        'autoscale_settings': {'key': 'autoscaleSettings', 'type': 'AutoscaleSettings'},
    }

    def __init__(self, *, throughput: int=None, autoscale_settings=None, **kwargs) -> None:
        super(MongoDBDatabaseGetPropertiesOptions, self).__init__(throughput=throughput, autoscale_settings=autoscale_settings, **kwargs)


class MongoDBDatabaseGetPropertiesResource(Model):
    """MongoDBDatabaseGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB MongoDB database
    :type id: str
    :ivar _rid: A system generated property. A unique identifier.
    :vartype _rid: str
    :ivar _ts: A system generated property that denotes the last updated
     timestamp of the resource.
    :vartype _ts: object
    :ivar _etag: A system generated property representing the resource etag
     required for optimistic concurrency control.
    :vartype _etag: str
    """

    _validation = {
        'id': {'required': True},
        '_rid': {'readonly': True},
        '_ts': {'readonly': True},
        '_etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        '_rid': {'key': '_rid', 'type': 'str'},
        '_ts': {'key': '_ts', 'type': 'object'},
        '_etag': {'key': '_etag', 'type': 'str'},
    }

    def __init__(self, *, id: str, **kwargs) -> None:
        super(MongoDBDatabaseGetPropertiesResource, self).__init__(**kwargs)
        self.id = id
        self._rid = None
        self._ts = None
        self._etag = None


class MongoDBDatabaseGetResults(ARMResourceProperties):
    """An Azure Cosmos DB MongoDB database.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource:
    :type resource:
     ~azure.mgmt.cosmosdb.models.MongoDBDatabaseGetPropertiesResource
    :param options:
    :type options:
     ~azure.mgmt.cosmosdb.models.MongoDBDatabaseGetPropertiesOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'MongoDBDatabaseGetPropertiesResource'},
        'options': {'key': 'properties.options', 'type': 'MongoDBDatabaseGetPropertiesOptions'},
    }

    def __init__(self, *, location: str=None, tags=None, identity=None, resource=None, options=None, **kwargs) -> None:
        super(MongoDBDatabaseGetResults, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource
        self.options = options


class MongoDBDatabaseResource(Model):
    """Cosmos DB MongoDB database resource object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB MongoDB database
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str, **kwargs) -> None:
        super(MongoDBDatabaseResource, self).__init__(**kwargs)
        self.id = id


class MongoIndex(Model):
    """Cosmos DB MongoDB collection index key.

    :param key: Cosmos DB MongoDB collection index keys
    :type key: ~azure.mgmt.cosmosdb.models.MongoIndexKeys
    :param options: Cosmos DB MongoDB collection index key options
    :type options: ~azure.mgmt.cosmosdb.models.MongoIndexOptions
    """

    _attribute_map = {
        'key': {'key': 'key', 'type': 'MongoIndexKeys'},
        'options': {'key': 'options', 'type': 'MongoIndexOptions'},
    }

    def __init__(self, *, key=None, options=None, **kwargs) -> None:
        super(MongoIndex, self).__init__(**kwargs)
        self.key = key
        self.options = options


class MongoIndexKeys(Model):
    """Cosmos DB MongoDB collection resource object.

    :param keys: List of keys for each MongoDB collection in the Azure Cosmos
     DB service
    :type keys: list[str]
    """

    _attribute_map = {
        'keys': {'key': 'keys', 'type': '[str]'},
    }

    def __init__(self, *, keys=None, **kwargs) -> None:
        super(MongoIndexKeys, self).__init__(**kwargs)
        self.keys = keys


class MongoIndexOptions(Model):
    """Cosmos DB MongoDB collection index options.

    :param expire_after_seconds: Expire after seconds
    :type expire_after_seconds: int
    :param unique: Is unique or not
    :type unique: bool
    """

    _attribute_map = {
        'expire_after_seconds': {'key': 'expireAfterSeconds', 'type': 'int'},
        'unique': {'key': 'unique', 'type': 'bool'},
    }

    def __init__(self, *, expire_after_seconds: int=None, unique: bool=None, **kwargs) -> None:
        super(MongoIndexOptions, self).__init__(**kwargs)
        self.expire_after_seconds = expire_after_seconds
        self.unique = unique


class NotebookWorkspace(ARMProxyResource):
    """A notebook workspace resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar notebook_server_endpoint: Specifies the endpoint of Notebook server.
    :vartype notebook_server_endpoint: str
    :ivar status: Status of the notebook workspace. Possible values are:
     Creating, Online, Deleting, Failed, Updating.
    :vartype status: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'notebook_server_endpoint': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'notebook_server_endpoint': {'key': 'properties.notebookServerEndpoint', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(NotebookWorkspace, self).__init__(**kwargs)
        self.notebook_server_endpoint = None
        self.status = None


class NotebookWorkspaceConnectionInfoResult(Model):
    """The connection info for the given notebook workspace.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar auth_token: Specifies auth token used for connecting to Notebook
     server (uses token-based auth).
    :vartype auth_token: str
    :ivar notebook_server_endpoint: Specifies the endpoint of Notebook server.
    :vartype notebook_server_endpoint: str
    """

    _validation = {
        'auth_token': {'readonly': True},
        'notebook_server_endpoint': {'readonly': True},
    }

    _attribute_map = {
        'auth_token': {'key': 'authToken', 'type': 'str'},
        'notebook_server_endpoint': {'key': 'notebookServerEndpoint', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(NotebookWorkspaceConnectionInfoResult, self).__init__(**kwargs)
        self.auth_token = None
        self.notebook_server_endpoint = None


class NotebookWorkspaceCreateUpdateParameters(ARMProxyResource):
    """Parameters to create a notebook workspace resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(NotebookWorkspaceCreateUpdateParameters, self).__init__(**kwargs)


class Operation(Model):
    """REST API operation.

    :param name: Operation name: {provider}/{resource}/{operation}
    :type name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.cosmosdb.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(self, *, name: str=None, display=None, **kwargs) -> None:
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(Model):
    """The object that represents the operation.

    :param provider: Service provider: Microsoft.ResourceProvider
    :type provider: str
    :param resource: Resource on which the operation is performed: Profile,
     endpoint, etc.
    :type resource: str
    :param operation: Operation type: Read, write, delete, etc.
    :type operation: str
    :param description: Description of operation
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'Provider', 'type': 'str'},
        'resource': {'key': 'Resource', 'type': 'str'},
        'operation': {'key': 'Operation', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
    }

    def __init__(self, *, provider: str=None, resource: str=None, operation: str=None, description: str=None, **kwargs) -> None:
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class PartitionMetric(Metric):
    """The metric values for a single partition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar start_time: The start time for the metric (ISO-8601 format).
    :vartype start_time: datetime
    :ivar end_time: The end time for the metric (ISO-8601 format).
    :vartype end_time: datetime
    :ivar time_grain: The time grain to be used to summarize the metric
     values.
    :vartype time_grain: str
    :param unit: The unit of the metric. Possible values include: 'Count',
     'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond',
     'Milliseconds'
    :type unit: str or ~azure.mgmt.cosmosdb.models.UnitType
    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.cosmosdb.models.MetricName
    :ivar metric_values: The metric values for the specified time window and
     timestep.
    :vartype metric_values: list[~azure.mgmt.cosmosdb.models.MetricValue]
    :ivar partition_id: The partition id (GUID identifier) of the metric
     values.
    :vartype partition_id: str
    :ivar partition_key_range_id: The partition key range id (integer
     identifier) of the metric values.
    :vartype partition_key_range_id: str
    """

    _validation = {
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'time_grain': {'readonly': True},
        'name': {'readonly': True},
        'metric_values': {'readonly': True},
        'partition_id': {'readonly': True},
        'partition_key_range_id': {'readonly': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'name': {'key': 'name', 'type': 'MetricName'},
        'metric_values': {'key': 'metricValues', 'type': '[MetricValue]'},
        'partition_id': {'key': 'partitionId', 'type': 'str'},
        'partition_key_range_id': {'key': 'partitionKeyRangeId', 'type': 'str'},
    }

    def __init__(self, *, unit=None, **kwargs) -> None:
        super(PartitionMetric, self).__init__(unit=unit, **kwargs)
        self.partition_id = None
        self.partition_key_range_id = None


class Usage(Model):
    """The usage data for a usage request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param unit: The unit of the metric. Possible values include: 'Count',
     'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond',
     'Milliseconds'
    :type unit: str or ~azure.mgmt.cosmosdb.models.UnitType
    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.cosmosdb.models.MetricName
    :ivar quota_period: The quota period used to summarize the usage values.
    :vartype quota_period: str
    :ivar limit: Maximum value for this metric
    :vartype limit: long
    :ivar current_value: Current value for this metric
    :vartype current_value: long
    """

    _validation = {
        'name': {'readonly': True},
        'quota_period': {'readonly': True},
        'limit': {'readonly': True},
        'current_value': {'readonly': True},
    }

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'name': {'key': 'name', 'type': 'MetricName'},
        'quota_period': {'key': 'quotaPeriod', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'long'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
    }

    def __init__(self, *, unit=None, **kwargs) -> None:
        super(Usage, self).__init__(**kwargs)
        self.unit = unit
        self.name = None
        self.quota_period = None
        self.limit = None
        self.current_value = None


class PartitionUsage(Usage):
    """The partition level usage data for a usage request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param unit: The unit of the metric. Possible values include: 'Count',
     'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond',
     'Milliseconds'
    :type unit: str or ~azure.mgmt.cosmosdb.models.UnitType
    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.cosmosdb.models.MetricName
    :ivar quota_period: The quota period used to summarize the usage values.
    :vartype quota_period: str
    :ivar limit: Maximum value for this metric
    :vartype limit: long
    :ivar current_value: Current value for this metric
    :vartype current_value: long
    :ivar partition_id: The partition id (GUID identifier) of the usages.
    :vartype partition_id: str
    :ivar partition_key_range_id: The partition key range id (integer
     identifier) of the usages.
    :vartype partition_key_range_id: str
    """

    _validation = {
        'name': {'readonly': True},
        'quota_period': {'readonly': True},
        'limit': {'readonly': True},
        'current_value': {'readonly': True},
        'partition_id': {'readonly': True},
        'partition_key_range_id': {'readonly': True},
    }

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'name': {'key': 'name', 'type': 'MetricName'},
        'quota_period': {'key': 'quotaPeriod', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'long'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'partition_id': {'key': 'partitionId', 'type': 'str'},
        'partition_key_range_id': {'key': 'partitionKeyRangeId', 'type': 'str'},
    }

    def __init__(self, *, unit=None, **kwargs) -> None:
        super(PartitionUsage, self).__init__(unit=unit, **kwargs)
        self.partition_id = None
        self.partition_key_range_id = None


class PercentileMetric(Model):
    """Percentile Metric data.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar start_time: The start time for the metric (ISO-8601 format).
    :vartype start_time: datetime
    :ivar end_time: The end time for the metric (ISO-8601 format).
    :vartype end_time: datetime
    :ivar time_grain: The time grain to be used to summarize the metric
     values.
    :vartype time_grain: str
    :param unit: The unit of the metric. Possible values include: 'Count',
     'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond',
     'Milliseconds'
    :type unit: str or ~azure.mgmt.cosmosdb.models.UnitType
    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.cosmosdb.models.MetricName
    :ivar metric_values: The percentile metric values for the specified time
     window and timestep.
    :vartype metric_values:
     list[~azure.mgmt.cosmosdb.models.PercentileMetricValue]
    """

    _validation = {
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'time_grain': {'readonly': True},
        'name': {'readonly': True},
        'metric_values': {'readonly': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'name': {'key': 'name', 'type': 'MetricName'},
        'metric_values': {'key': 'metricValues', 'type': '[PercentileMetricValue]'},
    }

    def __init__(self, *, unit=None, **kwargs) -> None:
        super(PercentileMetric, self).__init__(**kwargs)
        self.start_time = None
        self.end_time = None
        self.time_grain = None
        self.unit = unit
        self.name = None
        self.metric_values = None


class PercentileMetricValue(MetricValue):
    """Represents percentile metrics values.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar _count: The number of values for the metric.
    :vartype _count: float
    :ivar average: The average value of the metric.
    :vartype average: float
    :ivar maximum: The max value of the metric.
    :vartype maximum: float
    :ivar minimum: The min value of the metric.
    :vartype minimum: float
    :ivar timestamp: The metric timestamp (ISO-8601 format).
    :vartype timestamp: datetime
    :ivar total: The total value of the metric.
    :vartype total: float
    :ivar p10: The 10th percentile value for the metric.
    :vartype p10: float
    :ivar p25: The 25th percentile value for the metric.
    :vartype p25: float
    :ivar p50: The 50th percentile value for the metric.
    :vartype p50: float
    :ivar p75: The 75th percentile value for the metric.
    :vartype p75: float
    :ivar p90: The 90th percentile value for the metric.
    :vartype p90: float
    :ivar p95: The 95th percentile value for the metric.
    :vartype p95: float
    :ivar p99: The 99th percentile value for the metric.
    :vartype p99: float
    """

    _validation = {
        '_count': {'readonly': True},
        'average': {'readonly': True},
        'maximum': {'readonly': True},
        'minimum': {'readonly': True},
        'timestamp': {'readonly': True},
        'total': {'readonly': True},
        'p10': {'readonly': True},
        'p25': {'readonly': True},
        'p50': {'readonly': True},
        'p75': {'readonly': True},
        'p90': {'readonly': True},
        'p95': {'readonly': True},
        'p99': {'readonly': True},
    }

    _attribute_map = {
        '_count': {'key': '_count', 'type': 'float'},
        'average': {'key': 'average', 'type': 'float'},
        'maximum': {'key': 'maximum', 'type': 'float'},
        'minimum': {'key': 'minimum', 'type': 'float'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'total': {'key': 'total', 'type': 'float'},
        'p10': {'key': 'P10', 'type': 'float'},
        'p25': {'key': 'P25', 'type': 'float'},
        'p50': {'key': 'P50', 'type': 'float'},
        'p75': {'key': 'P75', 'type': 'float'},
        'p90': {'key': 'P90', 'type': 'float'},
        'p95': {'key': 'P95', 'type': 'float'},
        'p99': {'key': 'P99', 'type': 'float'},
    }

    def __init__(self, **kwargs) -> None:
        super(PercentileMetricValue, self).__init__(**kwargs)
        self.p10 = None
        self.p25 = None
        self.p50 = None
        self.p75 = None
        self.p90 = None
        self.p95 = None
        self.p99 = None


class PeriodicModeBackupPolicy(BackupPolicy):
    """The object representing periodic mode backup policy.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    :param periodic_mode_properties: Configuration values for periodic mode
     backup
    :type periodic_mode_properties:
     ~azure.mgmt.cosmosdb.models.PeriodicModeProperties
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'periodic_mode_properties': {'key': 'periodicModeProperties', 'type': 'PeriodicModeProperties'},
    }

    def __init__(self, *, periodic_mode_properties=None, **kwargs) -> None:
        super(PeriodicModeBackupPolicy, self).__init__(**kwargs)
        self.periodic_mode_properties = periodic_mode_properties
        self.type = 'Periodic'


class PeriodicModeProperties(Model):
    """Configuration values for periodic mode backup.

    :param backup_interval_in_minutes: An integer representing the interval in
     minutes between two backups
    :type backup_interval_in_minutes: int
    :param backup_retention_interval_in_hours: An integer representing the
     time (in hours) that each backup is retained
    :type backup_retention_interval_in_hours: int
    """

    _validation = {
        'backup_interval_in_minutes': {'minimum': 0},
        'backup_retention_interval_in_hours': {'minimum': 0},
    }

    _attribute_map = {
        'backup_interval_in_minutes': {'key': 'backupIntervalInMinutes', 'type': 'int'},
        'backup_retention_interval_in_hours': {'key': 'backupRetentionIntervalInHours', 'type': 'int'},
    }

    def __init__(self, *, backup_interval_in_minutes: int=None, backup_retention_interval_in_hours: int=None, **kwargs) -> None:
        super(PeriodicModeProperties, self).__init__(**kwargs)
        self.backup_interval_in_minutes = backup_interval_in_minutes
        self.backup_retention_interval_in_hours = backup_retention_interval_in_hours


class Permission(Model):
    """The set of data plane operations permitted through this Role Definition.

    :param data_actions: An array of data actions that are allowed.
    :type data_actions: list[str]
    :param not_data_actions: An array of data actions that are denied.
    :type not_data_actions: list[str]
    """

    _attribute_map = {
        'data_actions': {'key': 'dataActions', 'type': '[str]'},
        'not_data_actions': {'key': 'notDataActions', 'type': '[str]'},
    }

    def __init__(self, *, data_actions=None, not_data_actions=None, **kwargs) -> None:
        super(Permission, self).__init__(**kwargs)
        self.data_actions = data_actions
        self.not_data_actions = not_data_actions


class ProxyResource(Resource):
    """Proxy Resource.

    The resource model definition for a Azure Resource Manager proxy resource.
    It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ProxyResource, self).__init__(**kwargs)


class PrivateEndpointConnection(ProxyResource):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :param private_endpoint: Private endpoint which the connection belongs to.
    :type private_endpoint:
     ~azure.mgmt.cosmosdb.models.PrivateEndpointProperty
    :param private_link_service_connection_state: Connection State of the
     Private Endpoint Connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.cosmosdb.models.PrivateLinkServiceConnectionStateProperty
    :param group_id: Group id of the private endpoint.
    :type group_id: str
    :param provisioning_state: Provisioning state of the private endpoint.
    :type provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpointProperty'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionStateProperty'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, private_endpoint=None, private_link_service_connection_state=None, group_id: str=None, provisioning_state: str=None, **kwargs) -> None:
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.group_id = group_id
        self.provisioning_state = provisioning_state


class PrivateEndpointProperty(Model):
    """Private endpoint which the connection belongs to.

    :param id: Resource id of the private endpoint.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, **kwargs) -> None:
        super(PrivateEndpointProperty, self).__init__(**kwargs)
        self.id = id


class PrivateLinkResource(ARMProxyResource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource required zone names.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
        'required_zone_names': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(self, **kwargs) -> None:
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = None


class PrivateLinkServiceConnectionStateProperty(Model):
    """Connection State of the Private Endpoint Connection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param status: The private link service connection status.
    :type status: str
    :ivar actions_required: Any action that is required beyond basic workflow
     (approve/ reject/ disconnect)
    :vartype actions_required: str
    :param description: The private link service connection description.
    :type description: str
    """

    _validation = {
        'actions_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, *, status: str=None, description: str=None, **kwargs) -> None:
        super(PrivateLinkServiceConnectionStateProperty, self).__init__(**kwargs)
        self.status = status
        self.actions_required = None
        self.description = description


class RegionForOnlineOffline(Model):
    """Cosmos DB region to online or offline.

    All required parameters must be populated in order to send to Azure.

    :param region: Required. Cosmos DB region, with spaces between words and
     each word capitalized.
    :type region: str
    """

    _validation = {
        'region': {'required': True},
    }

    _attribute_map = {
        'region': {'key': 'region', 'type': 'str'},
    }

    def __init__(self, *, region: str, **kwargs) -> None:
        super(RegionForOnlineOffline, self).__init__(**kwargs)
        self.region = region


class RestorableDatabaseAccountGetResult(ARMResourceProperties):
    """A Azure Cosmos DB restorable database account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param account_name: The name of the global database account
    :type account_name: str
    :param creation_time: The creation time of the restorable database account
     (ISO-8601 format).
    :type creation_time: datetime
    :param deletion_time: The time at which the restorable database account
     has been deleted (ISO-8601 format).
    :type deletion_time: datetime
    :ivar api_type: The API type of the restorable database account. Possible
     values include: 'MongoDB', 'Gremlin', 'Cassandra', 'Table', 'Sql',
     'GremlinV2'
    :vartype api_type: str or ~azure.mgmt.cosmosdb.models.ApiType
    :ivar restorable_locations: List of regions where the of the database
     account can be restored from.
    :vartype restorable_locations:
     list[~azure.mgmt.cosmosdb.models.RestorableLocationResource]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'api_type': {'readonly': True},
        'restorable_locations': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'account_name': {'key': 'properties.accountName', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'deletion_time': {'key': 'properties.deletionTime', 'type': 'iso-8601'},
        'api_type': {'key': 'properties.apiType', 'type': 'str'},
        'restorable_locations': {'key': 'properties.restorableLocations', 'type': '[RestorableLocationResource]'},
    }

    def __init__(self, *, location: str=None, tags=None, identity=None, account_name: str=None, creation_time=None, deletion_time=None, **kwargs) -> None:
        super(RestorableDatabaseAccountGetResult, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.account_name = account_name
        self.creation_time = creation_time
        self.deletion_time = deletion_time
        self.api_type = None
        self.restorable_locations = None


class RestorableLocationResource(Model):
    """Properties of the regional restorable account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar location_name: The location of the regional restorable account.
    :vartype location_name: str
    :ivar regional_database_account_instance_id: The instance id of the
     regional restorable account.
    :vartype regional_database_account_instance_id: str
    :ivar creation_time: The creation time of the regional restorable database
     account (ISO-8601 format).
    :vartype creation_time: datetime
    :ivar deletion_time: The time at which the regional restorable database
     account has been deleted (ISO-8601 format).
    :vartype deletion_time: datetime
    """

    _validation = {
        'location_name': {'readonly': True},
        'regional_database_account_instance_id': {'readonly': True},
        'creation_time': {'readonly': True},
        'deletion_time': {'readonly': True},
    }

    _attribute_map = {
        'location_name': {'key': 'locationName', 'type': 'str'},
        'regional_database_account_instance_id': {'key': 'regionalDatabaseAccountInstanceId', 'type': 'str'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'deletion_time': {'key': 'deletionTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs) -> None:
        super(RestorableLocationResource, self).__init__(**kwargs)
        self.location_name = None
        self.regional_database_account_instance_id = None
        self.creation_time = None
        self.deletion_time = None


class RestorableMongodbCollectionGetResult(ARMResourceProperties):
    """An Azure Cosmos DB restorable MongoDB collection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource:
    :type resource:
     ~azure.mgmt.cosmosdb.models.RestorableMongodbCollectionPropertiesResource
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'RestorableMongodbCollectionPropertiesResource'},
    }

    def __init__(self, *, location: str=None, tags=None, identity=None, resource=None, **kwargs) -> None:
        super(RestorableMongodbCollectionGetResult, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource


class RestorableMongodbCollectionPropertiesResource(Model):
    """RestorableMongodbCollectionPropertiesResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar _rid: A system generated property. A unique identifier.
    :vartype _rid: str
    :ivar operation_type: The operation type of this collection event.
     Possible values include: 'Create', 'Replace', 'Delete', 'SystemOperation'
    :vartype operation_type: str or ~azure.mgmt.cosmosdb.models.OperationType
    :ivar event_timestamp: The timestamp of this collection event.
    :vartype event_timestamp: str
    :ivar owner_id: The name of this restorable MongoDB collection.
    :vartype owner_id: str
    :ivar owner_resource_id: The resource Id of this restorable MongoDB
     collection.
    :vartype owner_resource_id: str
    """

    _validation = {
        '_rid': {'readonly': True},
        'operation_type': {'readonly': True},
        'event_timestamp': {'readonly': True},
        'owner_id': {'readonly': True},
        'owner_resource_id': {'readonly': True},
    }

    _attribute_map = {
        '_rid': {'key': '_rid', 'type': 'str'},
        'operation_type': {'key': 'operationType', 'type': 'str'},
        'event_timestamp': {'key': 'eventTimestamp', 'type': 'str'},
        'owner_id': {'key': 'ownerId', 'type': 'str'},
        'owner_resource_id': {'key': 'ownerResourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(RestorableMongodbCollectionPropertiesResource, self).__init__(**kwargs)
        self._rid = None
        self.operation_type = None
        self.event_timestamp = None
        self.owner_id = None
        self.owner_resource_id = None


class RestorableMongodbDatabaseGetResult(ARMResourceProperties):
    """An Azure Cosmos DB restorable MongoDB database.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource:
    :type resource:
     ~azure.mgmt.cosmosdb.models.RestorableMongodbDatabasePropertiesResource
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'RestorableMongodbDatabasePropertiesResource'},
    }

    def __init__(self, *, location: str=None, tags=None, identity=None, resource=None, **kwargs) -> None:
        super(RestorableMongodbDatabaseGetResult, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource


class RestorableMongodbDatabasePropertiesResource(Model):
    """RestorableMongodbDatabasePropertiesResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar _rid: A system generated property. A unique identifier.
    :vartype _rid: str
    :ivar operation_type: The operation type of this database event. Possible
     values include: 'Create', 'Replace', 'Delete', 'SystemOperation'
    :vartype operation_type: str or ~azure.mgmt.cosmosdb.models.OperationType
    :ivar event_timestamp: The timestamp of this database event.
    :vartype event_timestamp: str
    :ivar owner_id: The name of this restorable MongoDB database.
    :vartype owner_id: str
    :ivar owner_resource_id: The resource Id of this restorable MongoDB
     database.
    :vartype owner_resource_id: str
    """

    _validation = {
        '_rid': {'readonly': True},
        'operation_type': {'readonly': True},
        'event_timestamp': {'readonly': True},
        'owner_id': {'readonly': True},
        'owner_resource_id': {'readonly': True},
    }

    _attribute_map = {
        '_rid': {'key': '_rid', 'type': 'str'},
        'operation_type': {'key': 'operationType', 'type': 'str'},
        'event_timestamp': {'key': 'eventTimestamp', 'type': 'str'},
        'owner_id': {'key': 'ownerId', 'type': 'str'},
        'owner_resource_id': {'key': 'ownerResourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(RestorableMongodbDatabasePropertiesResource, self).__init__(**kwargs)
        self._rid = None
        self.operation_type = None
        self.event_timestamp = None
        self.owner_id = None
        self.owner_resource_id = None


class RestorableSqlContainerGetResult(ARMResourceProperties):
    """An Azure Cosmos DB restorable SQL container.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource:
    :type resource:
     ~azure.mgmt.cosmosdb.models.RestorableSqlContainerPropertiesResource
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'RestorableSqlContainerPropertiesResource'},
    }

    def __init__(self, *, location: str=None, tags=None, identity=None, resource=None, **kwargs) -> None:
        super(RestorableSqlContainerGetResult, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource


class RestorableSqlContainerPropertiesResource(Model):
    """RestorableSqlContainerPropertiesResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar _rid: A system generated property. A unique identifier.
    :vartype _rid: str
    :ivar operation_type: The operation type of this container event. Possible
     values include: 'Create', 'Replace', 'Delete', 'SystemOperation'
    :vartype operation_type: str or ~azure.mgmt.cosmosdb.models.OperationType
    :ivar event_timestamp: The timestamp of this container event.
    :vartype event_timestamp: str
    :ivar owner_id: The name of this restorable SQL container.
    :vartype owner_id: str
    :ivar owner_resource_id: The resource Id of this restorable SQL container.
    :vartype owner_resource_id: str
    :param container:
    :type container:
     ~azure.mgmt.cosmosdb.models.RestorableSqlContainerPropertiesResourceContainer
    """

    _validation = {
        '_rid': {'readonly': True},
        'operation_type': {'readonly': True},
        'event_timestamp': {'readonly': True},
        'owner_id': {'readonly': True},
        'owner_resource_id': {'readonly': True},
    }

    _attribute_map = {
        '_rid': {'key': '_rid', 'type': 'str'},
        'operation_type': {'key': 'operationType', 'type': 'str'},
        'event_timestamp': {'key': 'eventTimestamp', 'type': 'str'},
        'owner_id': {'key': 'ownerId', 'type': 'str'},
        'owner_resource_id': {'key': 'ownerResourceId', 'type': 'str'},
        'container': {'key': 'container', 'type': 'RestorableSqlContainerPropertiesResourceContainer'},
    }

    def __init__(self, *, container=None, **kwargs) -> None:
        super(RestorableSqlContainerPropertiesResource, self).__init__(**kwargs)
        self._rid = None
        self.operation_type = None
        self.event_timestamp = None
        self.owner_id = None
        self.owner_resource_id = None
        self.container = container


class RestorableSqlContainerPropertiesResourceContainer(Model):
    """RestorableSqlContainerPropertiesResourceContainer.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB SQL container
    :type id: str
    :param indexing_policy: The configuration of the indexing policy. By
     default, the indexing is automatic for all document paths within the
     container
    :type indexing_policy: ~azure.mgmt.cosmosdb.models.IndexingPolicy
    :param partition_key: The configuration of the partition key to be used
     for partitioning data into multiple partitions
    :type partition_key: ~azure.mgmt.cosmosdb.models.ContainerPartitionKey
    :param default_ttl: Default time to live
    :type default_ttl: int
    :param unique_key_policy: The unique key policy configuration for
     specifying uniqueness constraints on documents in the collection in the
     Azure Cosmos DB service.
    :type unique_key_policy: ~azure.mgmt.cosmosdb.models.UniqueKeyPolicy
    :param conflict_resolution_policy: The conflict resolution policy for the
     container.
    :type conflict_resolution_policy:
     ~azure.mgmt.cosmosdb.models.ConflictResolutionPolicy
    :ivar _rid: A system generated property. A unique identifier.
    :vartype _rid: str
    :ivar _ts: A system generated property that denotes the last updated
     timestamp of the resource.
    :vartype _ts: object
    :ivar _etag: A system generated property representing the resource etag
     required for optimistic concurrency control.
    :vartype _etag: str
    :ivar _self: A system generated property that specifies the addressable
     path of the container resource.
    :vartype _self: str
    """

    _validation = {
        'id': {'required': True},
        '_rid': {'readonly': True},
        '_ts': {'readonly': True},
        '_etag': {'readonly': True},
        '_self': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'indexing_policy': {'key': 'indexingPolicy', 'type': 'IndexingPolicy'},
        'partition_key': {'key': 'partitionKey', 'type': 'ContainerPartitionKey'},
        'default_ttl': {'key': 'defaultTtl', 'type': 'int'},
        'unique_key_policy': {'key': 'uniqueKeyPolicy', 'type': 'UniqueKeyPolicy'},
        'conflict_resolution_policy': {'key': 'conflictResolutionPolicy', 'type': 'ConflictResolutionPolicy'},
        '_rid': {'key': '_rid', 'type': 'str'},
        '_ts': {'key': '_ts', 'type': 'object'},
        '_etag': {'key': '_etag', 'type': 'str'},
        '_self': {'key': '_self', 'type': 'str'},
    }

    def __init__(self, *, id: str, indexing_policy=None, partition_key=None, default_ttl: int=None, unique_key_policy=None, conflict_resolution_policy=None, **kwargs) -> None:
        super(RestorableSqlContainerPropertiesResourceContainer, self).__init__(**kwargs)
        self.id = id
        self.indexing_policy = indexing_policy
        self.partition_key = partition_key
        self.default_ttl = default_ttl
        self.unique_key_policy = unique_key_policy
        self.conflict_resolution_policy = conflict_resolution_policy
        self._rid = None
        self._ts = None
        self._etag = None
        self._self = None


class RestorableSqlDatabaseGetResult(ARMResourceProperties):
    """An Azure Cosmos DB restorable SQL database.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource:
    :type resource:
     ~azure.mgmt.cosmosdb.models.RestorableSqlDatabasePropertiesResource
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'RestorableSqlDatabasePropertiesResource'},
    }

    def __init__(self, *, location: str=None, tags=None, identity=None, resource=None, **kwargs) -> None:
        super(RestorableSqlDatabaseGetResult, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource


class RestorableSqlDatabasePropertiesResource(Model):
    """RestorableSqlDatabasePropertiesResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar _rid: A system generated property. A unique identifier.
    :vartype _rid: str
    :ivar operation_type: The operation type of this database event. Possible
     values include: 'Create', 'Replace', 'Delete', 'SystemOperation'
    :vartype operation_type: str or ~azure.mgmt.cosmosdb.models.OperationType
    :ivar event_timestamp: The timestamp of this database event.
    :vartype event_timestamp: str
    :ivar owner_id: The name of this restorable SQL database.
    :vartype owner_id: str
    :ivar owner_resource_id: The resource Id of this restorable SQL database.
    :vartype owner_resource_id: str
    :param database:
    :type database:
     ~azure.mgmt.cosmosdb.models.RestorableSqlDatabasePropertiesResourceDatabase
    """

    _validation = {
        '_rid': {'readonly': True},
        'operation_type': {'readonly': True},
        'event_timestamp': {'readonly': True},
        'owner_id': {'readonly': True},
        'owner_resource_id': {'readonly': True},
    }

    _attribute_map = {
        '_rid': {'key': '_rid', 'type': 'str'},
        'operation_type': {'key': 'operationType', 'type': 'str'},
        'event_timestamp': {'key': 'eventTimestamp', 'type': 'str'},
        'owner_id': {'key': 'ownerId', 'type': 'str'},
        'owner_resource_id': {'key': 'ownerResourceId', 'type': 'str'},
        'database': {'key': 'database', 'type': 'RestorableSqlDatabasePropertiesResourceDatabase'},
    }

    def __init__(self, *, database=None, **kwargs) -> None:
        super(RestorableSqlDatabasePropertiesResource, self).__init__(**kwargs)
        self._rid = None
        self.operation_type = None
        self.event_timestamp = None
        self.owner_id = None
        self.owner_resource_id = None
        self.database = database


class RestorableSqlDatabasePropertiesResourceDatabase(Model):
    """RestorableSqlDatabasePropertiesResourceDatabase.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB SQL database
    :type id: str
    :ivar _rid: A system generated property. A unique identifier.
    :vartype _rid: str
    :ivar _ts: A system generated property that denotes the last updated
     timestamp of the resource.
    :vartype _ts: object
    :ivar _etag: A system generated property representing the resource etag
     required for optimistic concurrency control.
    :vartype _etag: str
    :ivar _colls: A system generated property that specified the addressable
     path of the collections resource.
    :vartype _colls: str
    :ivar _users: A system generated property that specifies the addressable
     path of the users resource.
    :vartype _users: str
    :ivar _self: A system generated property that specifies the addressable
     path of the database resource.
    :vartype _self: str
    """

    _validation = {
        'id': {'required': True},
        '_rid': {'readonly': True},
        '_ts': {'readonly': True},
        '_etag': {'readonly': True},
        '_colls': {'readonly': True},
        '_users': {'readonly': True},
        '_self': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        '_rid': {'key': '_rid', 'type': 'str'},
        '_ts': {'key': '_ts', 'type': 'object'},
        '_etag': {'key': '_etag', 'type': 'str'},
        '_colls': {'key': '_colls', 'type': 'str'},
        '_users': {'key': '_users', 'type': 'str'},
        '_self': {'key': '_self', 'type': 'str'},
    }

    def __init__(self, *, id: str, **kwargs) -> None:
        super(RestorableSqlDatabasePropertiesResourceDatabase, self).__init__(**kwargs)
        self.id = id
        self._rid = None
        self._ts = None
        self._etag = None
        self._colls = None
        self._users = None
        self._self = None


class RestoreParameters(Model):
    """Parameters to indicate the information about the restore.

    :param restore_mode: Describes the mode of the restore. Possible values
     include: 'PointInTime'
    :type restore_mode: str or ~azure.mgmt.cosmosdb.models.RestoreMode
    :param restore_source: The id of the restorable database account from
     which the restore has to be initiated. For example:
     /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}
    :type restore_source: str
    :param restore_timestamp_in_utc: Time to which the account has to be
     restored (ISO-8601 format).
    :type restore_timestamp_in_utc: datetime
    :param databases_to_restore: List of specific databases available for
     restore.
    :type databases_to_restore:
     list[~azure.mgmt.cosmosdb.models.DatabaseRestoreResource]
    """

    _attribute_map = {
        'restore_mode': {'key': 'restoreMode', 'type': 'str'},
        'restore_source': {'key': 'restoreSource', 'type': 'str'},
        'restore_timestamp_in_utc': {'key': 'restoreTimestampInUtc', 'type': 'iso-8601'},
        'databases_to_restore': {'key': 'databasesToRestore', 'type': '[DatabaseRestoreResource]'},
    }

    def __init__(self, *, restore_mode=None, restore_source: str=None, restore_timestamp_in_utc=None, databases_to_restore=None, **kwargs) -> None:
        super(RestoreParameters, self).__init__(**kwargs)
        self.restore_mode = restore_mode
        self.restore_source = restore_source
        self.restore_timestamp_in_utc = restore_timestamp_in_utc
        self.databases_to_restore = databases_to_restore


class RestoreReqeustDatabaseAccountCreateUpdateProperties(DatabaseAccountCreateUpdateProperties):
    """Properties to restore Azure Cosmos DB database account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param consistency_policy: The consistency policy for the Cosmos DB
     account.
    :type consistency_policy: ~azure.mgmt.cosmosdb.models.ConsistencyPolicy
    :param locations: Required. An array that contains the georeplication
     locations enabled for the Cosmos DB account.
    :type locations: list[~azure.mgmt.cosmosdb.models.Location]
    :ivar database_account_offer_type: Required. The offer type for the
     database. Default value: "Standard" .
    :vartype database_account_offer_type: str
    :param ip_rules: List of IpRules.
    :type ip_rules: list[~azure.mgmt.cosmosdb.models.IpAddressOrRange]
    :param is_virtual_network_filter_enabled: Flag to indicate whether to
     enable/disable Virtual Network ACL rules.
    :type is_virtual_network_filter_enabled: bool
    :param enable_automatic_failover: Enables automatic failover of the write
     region in the rare event that the region is unavailable due to an outage.
     Automatic failover will result in a new write region for the account and
     is chosen based on the failover priorities configured for the account.
    :type enable_automatic_failover: bool
    :param capabilities: List of Cosmos DB capabilities for the account
    :type capabilities: list[~azure.mgmt.cosmosdb.models.Capability]
    :param virtual_network_rules: List of Virtual Network ACL rules configured
     for the Cosmos DB account.
    :type virtual_network_rules:
     list[~azure.mgmt.cosmosdb.models.VirtualNetworkRule]
    :param enable_multiple_write_locations: Enables the account to write in
     multiple locations
    :type enable_multiple_write_locations: bool
    :param enable_cassandra_connector: Enables the cassandra connector on the
     Cosmos DB C* account
    :type enable_cassandra_connector: bool
    :param connector_offer: The cassandra connector offer type for the Cosmos
     DB database C* account. Possible values include: 'Small'
    :type connector_offer: str or ~azure.mgmt.cosmosdb.models.ConnectorOffer
    :param disable_key_based_metadata_write_access: Disable write operations
     on metadata resources (databases, containers, throughput) via account keys
    :type disable_key_based_metadata_write_access: bool
    :param key_vault_key_uri: The URI of the key vault
    :type key_vault_key_uri: str
    :param public_network_access: Whether requests from Public Network are
     allowed. Possible values include: 'Enabled', 'Disabled'
    :type public_network_access: str or
     ~azure.mgmt.cosmosdb.models.PublicNetworkAccess
    :param enable_free_tier: Flag to indicate whether Free Tier is enabled.
    :type enable_free_tier: bool
    :param api_properties: API specific properties. Currently, supported only
     for MongoDB API.
    :type api_properties: ~azure.mgmt.cosmosdb.models.ApiProperties
    :param enable_analytical_storage: Flag to indicate whether to enable
     storage analytics.
    :type enable_analytical_storage: bool
    :param backup_policy: The object representing the policy for taking
     backups on an account.
    :type backup_policy: ~azure.mgmt.cosmosdb.models.BackupPolicy
    :param cors: The CORS policy for the Cosmos DB database account.
    :type cors: list[~azure.mgmt.cosmosdb.models.CorsPolicy]
    :param create_mode: Required. Constant filled by server.
    :type create_mode: str
    :param restore_parameters: Parameters to indicate the information about
     the restore.
    :type restore_parameters: ~azure.mgmt.cosmosdb.models.RestoreParameters
    """

    _validation = {
        'locations': {'required': True},
        'database_account_offer_type': {'required': True, 'constant': True},
        'create_mode': {'required': True},
    }

    _attribute_map = {
        'consistency_policy': {'key': 'consistencyPolicy', 'type': 'ConsistencyPolicy'},
        'locations': {'key': 'locations', 'type': '[Location]'},
        'database_account_offer_type': {'key': 'databaseAccountOfferType', 'type': 'str'},
        'ip_rules': {'key': 'ipRules', 'type': '[IpAddressOrRange]'},
        'is_virtual_network_filter_enabled': {'key': 'isVirtualNetworkFilterEnabled', 'type': 'bool'},
        'enable_automatic_failover': {'key': 'enableAutomaticFailover', 'type': 'bool'},
        'capabilities': {'key': 'capabilities', 'type': '[Capability]'},
        'virtual_network_rules': {'key': 'virtualNetworkRules', 'type': '[VirtualNetworkRule]'},
        'enable_multiple_write_locations': {'key': 'enableMultipleWriteLocations', 'type': 'bool'},
        'enable_cassandra_connector': {'key': 'enableCassandraConnector', 'type': 'bool'},
        'connector_offer': {'key': 'connectorOffer', 'type': 'str'},
        'disable_key_based_metadata_write_access': {'key': 'disableKeyBasedMetadataWriteAccess', 'type': 'bool'},
        'key_vault_key_uri': {'key': 'keyVaultKeyUri', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'enable_free_tier': {'key': 'enableFreeTier', 'type': 'bool'},
        'api_properties': {'key': 'apiProperties', 'type': 'ApiProperties'},
        'enable_analytical_storage': {'key': 'enableAnalyticalStorage', 'type': 'bool'},
        'backup_policy': {'key': 'backupPolicy', 'type': 'BackupPolicy'},
        'cors': {'key': 'cors', 'type': '[CorsPolicy]'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'restore_parameters': {'key': 'restoreParameters', 'type': 'RestoreParameters'},
    }

    def __init__(self, *, locations, consistency_policy=None, ip_rules=None, is_virtual_network_filter_enabled: bool=None, enable_automatic_failover: bool=None, capabilities=None, virtual_network_rules=None, enable_multiple_write_locations: bool=None, enable_cassandra_connector: bool=None, connector_offer=None, disable_key_based_metadata_write_access: bool=None, key_vault_key_uri: str=None, public_network_access=None, enable_free_tier: bool=None, api_properties=None, enable_analytical_storage: bool=None, backup_policy=None, cors=None, restore_parameters=None, **kwargs) -> None:
        super(RestoreReqeustDatabaseAccountCreateUpdateProperties, self).__init__(consistency_policy=consistency_policy, locations=locations, ip_rules=ip_rules, is_virtual_network_filter_enabled=is_virtual_network_filter_enabled, enable_automatic_failover=enable_automatic_failover, capabilities=capabilities, virtual_network_rules=virtual_network_rules, enable_multiple_write_locations=enable_multiple_write_locations, enable_cassandra_connector=enable_cassandra_connector, connector_offer=connector_offer, disable_key_based_metadata_write_access=disable_key_based_metadata_write_access, key_vault_key_uri=key_vault_key_uri, public_network_access=public_network_access, enable_free_tier=enable_free_tier, api_properties=api_properties, enable_analytical_storage=enable_analytical_storage, backup_policy=backup_policy, cors=cors, **kwargs)
        self.restore_parameters = restore_parameters
        self.create_mode = 'Restore'


class SpatialSpec(Model):
    """SpatialSpec.

    :param path: The path for which the indexing behavior applies to. Index
     paths typically start with root and end with wildcard (/path/*)
    :type path: str
    :param types: List of path's spatial type
    :type types: list[str or ~azure.mgmt.cosmosdb.models.SpatialType]
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'types': {'key': 'types', 'type': '[str]'},
    }

    def __init__(self, *, path: str=None, types=None, **kwargs) -> None:
        super(SpatialSpec, self).__init__(**kwargs)
        self.path = path
        self.types = types


class SqlContainerCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB container.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource: Required. The standard JSON format of a container
    :type resource: ~azure.mgmt.cosmosdb.models.SqlContainerResource
    :param options: Required. A key-value pair of options to be applied for
     the request. This corresponds to the headers sent with the request.
    :type options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource': {'required': True},
        'options': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'SqlContainerResource'},
        'options': {'key': 'properties.options', 'type': 'CreateUpdateOptions'},
    }

    def __init__(self, *, resource, options, location: str=None, tags=None, identity=None, **kwargs) -> None:
        super(SqlContainerCreateUpdateParameters, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource
        self.options = options


class SqlContainerGetPropertiesOptions(OptionsResource):
    """SqlContainerGetPropertiesOptions.

    :param throughput: Value of the Cosmos DB resource throughput or
     autoscaleSettings. Use the ThroughputSetting resource when retrieving
     offer details.
    :type throughput: int
    :param autoscale_settings: Specifies the Autoscale settings.
    :type autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
    """

    _attribute_map = {
        'throughput': {'key': 'throughput', 'type': 'int'},
        'autoscale_settings': {'key': 'autoscaleSettings', 'type': 'AutoscaleSettings'},
    }

    def __init__(self, *, throughput: int=None, autoscale_settings=None, **kwargs) -> None:
        super(SqlContainerGetPropertiesOptions, self).__init__(throughput=throughput, autoscale_settings=autoscale_settings, **kwargs)


class SqlContainerGetPropertiesResource(Model):
    """SqlContainerGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB SQL container
    :type id: str
    :param indexing_policy: The configuration of the indexing policy. By
     default, the indexing is automatic for all document paths within the
     container
    :type indexing_policy: ~azure.mgmt.cosmosdb.models.IndexingPolicy
    :param partition_key: The configuration of the partition key to be used
     for partitioning data into multiple partitions
    :type partition_key: ~azure.mgmt.cosmosdb.models.ContainerPartitionKey
    :param default_ttl: Default time to live
    :type default_ttl: int
    :param unique_key_policy: The unique key policy configuration for
     specifying uniqueness constraints on documents in the collection in the
     Azure Cosmos DB service.
    :type unique_key_policy: ~azure.mgmt.cosmosdb.models.UniqueKeyPolicy
    :param conflict_resolution_policy: The conflict resolution policy for the
     container.
    :type conflict_resolution_policy:
     ~azure.mgmt.cosmosdb.models.ConflictResolutionPolicy
    :ivar _rid: A system generated property. A unique identifier.
    :vartype _rid: str
    :ivar _ts: A system generated property that denotes the last updated
     timestamp of the resource.
    :vartype _ts: object
    :ivar _etag: A system generated property representing the resource etag
     required for optimistic concurrency control.
    :vartype _etag: str
    """

    _validation = {
        'id': {'required': True},
        '_rid': {'readonly': True},
        '_ts': {'readonly': True},
        '_etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'indexing_policy': {'key': 'indexingPolicy', 'type': 'IndexingPolicy'},
        'partition_key': {'key': 'partitionKey', 'type': 'ContainerPartitionKey'},
        'default_ttl': {'key': 'defaultTtl', 'type': 'int'},
        'unique_key_policy': {'key': 'uniqueKeyPolicy', 'type': 'UniqueKeyPolicy'},
        'conflict_resolution_policy': {'key': 'conflictResolutionPolicy', 'type': 'ConflictResolutionPolicy'},
        '_rid': {'key': '_rid', 'type': 'str'},
        '_ts': {'key': '_ts', 'type': 'object'},
        '_etag': {'key': '_etag', 'type': 'str'},
    }

    def __init__(self, *, id: str, indexing_policy=None, partition_key=None, default_ttl: int=None, unique_key_policy=None, conflict_resolution_policy=None, **kwargs) -> None:
        super(SqlContainerGetPropertiesResource, self).__init__(**kwargs)
        self.id = id
        self.indexing_policy = indexing_policy
        self.partition_key = partition_key
        self.default_ttl = default_ttl
        self.unique_key_policy = unique_key_policy
        self.conflict_resolution_policy = conflict_resolution_policy
        self._rid = None
        self._ts = None
        self._etag = None


class SqlContainerGetResults(ARMResourceProperties):
    """An Azure Cosmos DB container.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource:
    :type resource:
     ~azure.mgmt.cosmosdb.models.SqlContainerGetPropertiesResource
    :param options:
    :type options:
     ~azure.mgmt.cosmosdb.models.SqlContainerGetPropertiesOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'SqlContainerGetPropertiesResource'},
        'options': {'key': 'properties.options', 'type': 'SqlContainerGetPropertiesOptions'},
    }

    def __init__(self, *, location: str=None, tags=None, identity=None, resource=None, options=None, **kwargs) -> None:
        super(SqlContainerGetResults, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource
        self.options = options


class SqlContainerResource(Model):
    """Cosmos DB SQL container resource object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB SQL container
    :type id: str
    :param indexing_policy: The configuration of the indexing policy. By
     default, the indexing is automatic for all document paths within the
     container
    :type indexing_policy: ~azure.mgmt.cosmosdb.models.IndexingPolicy
    :param partition_key: The configuration of the partition key to be used
     for partitioning data into multiple partitions
    :type partition_key: ~azure.mgmt.cosmosdb.models.ContainerPartitionKey
    :param default_ttl: Default time to live
    :type default_ttl: int
    :param unique_key_policy: The unique key policy configuration for
     specifying uniqueness constraints on documents in the collection in the
     Azure Cosmos DB service.
    :type unique_key_policy: ~azure.mgmt.cosmosdb.models.UniqueKeyPolicy
    :param conflict_resolution_policy: The conflict resolution policy for the
     container.
    :type conflict_resolution_policy:
     ~azure.mgmt.cosmosdb.models.ConflictResolutionPolicy
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'indexing_policy': {'key': 'indexingPolicy', 'type': 'IndexingPolicy'},
        'partition_key': {'key': 'partitionKey', 'type': 'ContainerPartitionKey'},
        'default_ttl': {'key': 'defaultTtl', 'type': 'int'},
        'unique_key_policy': {'key': 'uniqueKeyPolicy', 'type': 'UniqueKeyPolicy'},
        'conflict_resolution_policy': {'key': 'conflictResolutionPolicy', 'type': 'ConflictResolutionPolicy'},
    }

    def __init__(self, *, id: str, indexing_policy=None, partition_key=None, default_ttl: int=None, unique_key_policy=None, conflict_resolution_policy=None, **kwargs) -> None:
        super(SqlContainerResource, self).__init__(**kwargs)
        self.id = id
        self.indexing_policy = indexing_policy
        self.partition_key = partition_key
        self.default_ttl = default_ttl
        self.unique_key_policy = unique_key_policy
        self.conflict_resolution_policy = conflict_resolution_policy


class SqlDatabaseCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB SQL database.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource: Required. The standard JSON format of a SQL database
    :type resource: ~azure.mgmt.cosmosdb.models.SqlDatabaseResource
    :param options: Required. A key-value pair of options to be applied for
     the request. This corresponds to the headers sent with the request.
    :type options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource': {'required': True},
        'options': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'SqlDatabaseResource'},
        'options': {'key': 'properties.options', 'type': 'CreateUpdateOptions'},
    }

    def __init__(self, *, resource, options, location: str=None, tags=None, identity=None, **kwargs) -> None:
        super(SqlDatabaseCreateUpdateParameters, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource
        self.options = options


class SqlDatabaseGetPropertiesOptions(OptionsResource):
    """SqlDatabaseGetPropertiesOptions.

    :param throughput: Value of the Cosmos DB resource throughput or
     autoscaleSettings. Use the ThroughputSetting resource when retrieving
     offer details.
    :type throughput: int
    :param autoscale_settings: Specifies the Autoscale settings.
    :type autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
    """

    _attribute_map = {
        'throughput': {'key': 'throughput', 'type': 'int'},
        'autoscale_settings': {'key': 'autoscaleSettings', 'type': 'AutoscaleSettings'},
    }

    def __init__(self, *, throughput: int=None, autoscale_settings=None, **kwargs) -> None:
        super(SqlDatabaseGetPropertiesOptions, self).__init__(throughput=throughput, autoscale_settings=autoscale_settings, **kwargs)


class SqlDatabaseGetPropertiesResource(Model):
    """SqlDatabaseGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB SQL database
    :type id: str
    :ivar _rid: A system generated property. A unique identifier.
    :vartype _rid: str
    :ivar _ts: A system generated property that denotes the last updated
     timestamp of the resource.
    :vartype _ts: object
    :ivar _etag: A system generated property representing the resource etag
     required for optimistic concurrency control.
    :vartype _etag: str
    :param _colls: A system generated property that specified the addressable
     path of the collections resource.
    :type _colls: str
    :param _users: A system generated property that specifies the addressable
     path of the users resource.
    :type _users: str
    """

    _validation = {
        'id': {'required': True},
        '_rid': {'readonly': True},
        '_ts': {'readonly': True},
        '_etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        '_rid': {'key': '_rid', 'type': 'str'},
        '_ts': {'key': '_ts', 'type': 'object'},
        '_etag': {'key': '_etag', 'type': 'str'},
        '_colls': {'key': '_colls', 'type': 'str'},
        '_users': {'key': '_users', 'type': 'str'},
    }

    def __init__(self, *, id: str, _colls: str=None, _users: str=None, **kwargs) -> None:
        super(SqlDatabaseGetPropertiesResource, self).__init__(**kwargs)
        self.id = id
        self._rid = None
        self._ts = None
        self._etag = None
        self._colls = _colls
        self._users = _users


class SqlDatabaseGetResults(ARMResourceProperties):
    """An Azure Cosmos DB SQL database.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource:
    :type resource:
     ~azure.mgmt.cosmosdb.models.SqlDatabaseGetPropertiesResource
    :param options:
    :type options: ~azure.mgmt.cosmosdb.models.SqlDatabaseGetPropertiesOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'SqlDatabaseGetPropertiesResource'},
        'options': {'key': 'properties.options', 'type': 'SqlDatabaseGetPropertiesOptions'},
    }

    def __init__(self, *, location: str=None, tags=None, identity=None, resource=None, options=None, **kwargs) -> None:
        super(SqlDatabaseGetResults, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource
        self.options = options


class SqlDatabaseResource(Model):
    """Cosmos DB SQL database resource object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB SQL database
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str, **kwargs) -> None:
        super(SqlDatabaseResource, self).__init__(**kwargs)
        self.id = id


class SqlRoleAssignmentCreateUpdateParameters(Model):
    """Parameters to create and update an Azure Cosmos DB SQL Role Assignment.

    :param role_definition_id: The unique identifier for the associated Role
     Definition.
    :type role_definition_id: str
    :param scope: The data plane resource path for which access is being
     granted through this Role Assignment.
    :type scope: str
    :param principal_id: The unique identifier for the associated AAD
     principal in the AAD graph to which access is being granted through this
     Role Assignment. Tenant ID for the principal is inferred using the tenant
     associated with the subscription.
    :type principal_id: str
    """

    _attribute_map = {
        'role_definition_id': {'key': 'properties.roleDefinitionId', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
    }

    def __init__(self, *, role_definition_id: str=None, scope: str=None, principal_id: str=None, **kwargs) -> None:
        super(SqlRoleAssignmentCreateUpdateParameters, self).__init__(**kwargs)
        self.role_definition_id = role_definition_id
        self.scope = scope
        self.principal_id = principal_id


class SqlRoleAssignmentGetResults(ARMProxyResource):
    """An Azure Cosmos DB Role Assignment.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param role_definition_id: The unique identifier for the associated Role
     Definition.
    :type role_definition_id: str
    :param scope: The data plane resource path for which access is being
     granted through this Role Assignment.
    :type scope: str
    :param principal_id: The unique identifier for the associated AAD
     principal in the AAD graph to which access is being granted through this
     Role Assignment. Tenant ID for the principal is inferred using the tenant
     associated with the subscription.
    :type principal_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'role_definition_id': {'key': 'properties.roleDefinitionId', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
    }

    def __init__(self, *, role_definition_id: str=None, scope: str=None, principal_id: str=None, **kwargs) -> None:
        super(SqlRoleAssignmentGetResults, self).__init__(**kwargs)
        self.role_definition_id = role_definition_id
        self.scope = scope
        self.principal_id = principal_id


class SqlRoleDefinitionCreateUpdateParameters(Model):
    """Parameters to create and update an Azure Cosmos DB SQL Role Definition.

    :param role_name: A user-friendly name for the Role Definition. Must be
     unique for the database account.
    :type role_name: str
    :param type: Indicates whether the Role Definition was built-in or user
     created. Possible values include: 'BuiltInRole', 'CustomRole'
    :type type: str or ~azure.mgmt.cosmosdb.models.RoleDefinitionType
    :param assignable_scopes: A set of fully qualified Scopes at or below
     which Role Assignments may be created using this Role Definition. This
     will allow application of this Role Definition on the entire database
     account or any underlying Database / Collection. Must have at least one
     element. Scopes higher than Database account are not enforceable as
     assignable Scopes. Note that resources referenced in assignable Scopes
     need not exist.
    :type assignable_scopes: list[str]
    :param permissions: The set of operations allowed through this Role
     Definition.
    :type permissions: list[~azure.mgmt.cosmosdb.models.Permission]
    """

    _attribute_map = {
        'role_name': {'key': 'properties.roleName', 'type': 'str'},
        'type': {'key': 'properties.type', 'type': 'RoleDefinitionType'},
        'assignable_scopes': {'key': 'properties.assignableScopes', 'type': '[str]'},
        'permissions': {'key': 'properties.permissions', 'type': '[Permission]'},
    }

    def __init__(self, *, role_name: str=None, type=None, assignable_scopes=None, permissions=None, **kwargs) -> None:
        super(SqlRoleDefinitionCreateUpdateParameters, self).__init__(**kwargs)
        self.role_name = role_name
        self.type = type
        self.assignable_scopes = assignable_scopes
        self.permissions = permissions


class SqlRoleDefinitionGetResults(ARMProxyResource):
    """An Azure Cosmos DB SQL Role Definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param role_name: A user-friendly name for the Role Definition. Must be
     unique for the database account.
    :type role_name: str
    :param sql_role_definition_get_results_type: Indicates whether the Role
     Definition was built-in or user created. Possible values include:
     'BuiltInRole', 'CustomRole'
    :type sql_role_definition_get_results_type: str or
     ~azure.mgmt.cosmosdb.models.RoleDefinitionType
    :param assignable_scopes: A set of fully qualified Scopes at or below
     which Role Assignments may be created using this Role Definition. This
     will allow application of this Role Definition on the entire database
     account or any underlying Database / Collection. Must have at least one
     element. Scopes higher than Database account are not enforceable as
     assignable Scopes. Note that resources referenced in assignable Scopes
     need not exist.
    :type assignable_scopes: list[str]
    :param permissions: The set of operations allowed through this Role
     Definition.
    :type permissions: list[~azure.mgmt.cosmosdb.models.Permission]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'role_name': {'key': 'properties.roleName', 'type': 'str'},
        'sql_role_definition_get_results_type': {'key': 'properties.type', 'type': 'RoleDefinitionType'},
        'assignable_scopes': {'key': 'properties.assignableScopes', 'type': '[str]'},
        'permissions': {'key': 'properties.permissions', 'type': '[Permission]'},
    }

    def __init__(self, *, role_name: str=None, sql_role_definition_get_results_type=None, assignable_scopes=None, permissions=None, **kwargs) -> None:
        super(SqlRoleDefinitionGetResults, self).__init__(**kwargs)
        self.role_name = role_name
        self.sql_role_definition_get_results_type = sql_role_definition_get_results_type
        self.assignable_scopes = assignable_scopes
        self.permissions = permissions


class SqlStoredProcedureCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB storedProcedure.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource: Required. The standard JSON format of a storedProcedure
    :type resource: ~azure.mgmt.cosmosdb.models.SqlStoredProcedureResource
    :param options: Required. A key-value pair of options to be applied for
     the request. This corresponds to the headers sent with the request.
    :type options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource': {'required': True},
        'options': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'SqlStoredProcedureResource'},
        'options': {'key': 'properties.options', 'type': 'CreateUpdateOptions'},
    }

    def __init__(self, *, resource, options, location: str=None, tags=None, identity=None, **kwargs) -> None:
        super(SqlStoredProcedureCreateUpdateParameters, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource
        self.options = options


class SqlStoredProcedureGetPropertiesResource(Model):
    """SqlStoredProcedureGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB SQL storedProcedure
    :type id: str
    :param body: Body of the Stored Procedure
    :type body: str
    :ivar _rid: A system generated property. A unique identifier.
    :vartype _rid: str
    :ivar _ts: A system generated property that denotes the last updated
     timestamp of the resource.
    :vartype _ts: object
    :ivar _etag: A system generated property representing the resource etag
     required for optimistic concurrency control.
    :vartype _etag: str
    """

    _validation = {
        'id': {'required': True},
        '_rid': {'readonly': True},
        '_ts': {'readonly': True},
        '_etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'body': {'key': 'body', 'type': 'str'},
        '_rid': {'key': '_rid', 'type': 'str'},
        '_ts': {'key': '_ts', 'type': 'object'},
        '_etag': {'key': '_etag', 'type': 'str'},
    }

    def __init__(self, *, id: str, body: str=None, **kwargs) -> None:
        super(SqlStoredProcedureGetPropertiesResource, self).__init__(**kwargs)
        self.id = id
        self.body = body
        self._rid = None
        self._ts = None
        self._etag = None


class SqlStoredProcedureGetResults(ARMResourceProperties):
    """An Azure Cosmos DB storedProcedure.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource:
    :type resource:
     ~azure.mgmt.cosmosdb.models.SqlStoredProcedureGetPropertiesResource
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'SqlStoredProcedureGetPropertiesResource'},
    }

    def __init__(self, *, location: str=None, tags=None, identity=None, resource=None, **kwargs) -> None:
        super(SqlStoredProcedureGetResults, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource


class SqlStoredProcedureResource(Model):
    """Cosmos DB SQL storedProcedure resource object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB SQL storedProcedure
    :type id: str
    :param body: Body of the Stored Procedure
    :type body: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'body': {'key': 'body', 'type': 'str'},
    }

    def __init__(self, *, id: str, body: str=None, **kwargs) -> None:
        super(SqlStoredProcedureResource, self).__init__(**kwargs)
        self.id = id
        self.body = body


class SqlTriggerCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB trigger.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource: Required. The standard JSON format of a trigger
    :type resource: ~azure.mgmt.cosmosdb.models.SqlTriggerResource
    :param options: Required. A key-value pair of options to be applied for
     the request. This corresponds to the headers sent with the request.
    :type options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource': {'required': True},
        'options': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'SqlTriggerResource'},
        'options': {'key': 'properties.options', 'type': 'CreateUpdateOptions'},
    }

    def __init__(self, *, resource, options, location: str=None, tags=None, identity=None, **kwargs) -> None:
        super(SqlTriggerCreateUpdateParameters, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource
        self.options = options


class SqlTriggerGetPropertiesResource(Model):
    """SqlTriggerGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB SQL trigger
    :type id: str
    :param body: Body of the Trigger
    :type body: str
    :param trigger_type: Type of the Trigger. Possible values include: 'Pre',
     'Post'
    :type trigger_type: str or ~azure.mgmt.cosmosdb.models.TriggerType
    :param trigger_operation: The operation the trigger is associated with.
     Possible values include: 'All', 'Create', 'Update', 'Delete', 'Replace'
    :type trigger_operation: str or
     ~azure.mgmt.cosmosdb.models.TriggerOperation
    :ivar _rid: A system generated property. A unique identifier.
    :vartype _rid: str
    :ivar _ts: A system generated property that denotes the last updated
     timestamp of the resource.
    :vartype _ts: object
    :ivar _etag: A system generated property representing the resource etag
     required for optimistic concurrency control.
    :vartype _etag: str
    """

    _validation = {
        'id': {'required': True},
        '_rid': {'readonly': True},
        '_ts': {'readonly': True},
        '_etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'body': {'key': 'body', 'type': 'str'},
        'trigger_type': {'key': 'triggerType', 'type': 'str'},
        'trigger_operation': {'key': 'triggerOperation', 'type': 'str'},
        '_rid': {'key': '_rid', 'type': 'str'},
        '_ts': {'key': '_ts', 'type': 'object'},
        '_etag': {'key': '_etag', 'type': 'str'},
    }

    def __init__(self, *, id: str, body: str=None, trigger_type=None, trigger_operation=None, **kwargs) -> None:
        super(SqlTriggerGetPropertiesResource, self).__init__(**kwargs)
        self.id = id
        self.body = body
        self.trigger_type = trigger_type
        self.trigger_operation = trigger_operation
        self._rid = None
        self._ts = None
        self._etag = None


class SqlTriggerGetResults(ARMResourceProperties):
    """An Azure Cosmos DB trigger.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource:
    :type resource:
     ~azure.mgmt.cosmosdb.models.SqlTriggerGetPropertiesResource
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'SqlTriggerGetPropertiesResource'},
    }

    def __init__(self, *, location: str=None, tags=None, identity=None, resource=None, **kwargs) -> None:
        super(SqlTriggerGetResults, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource


class SqlTriggerResource(Model):
    """Cosmos DB SQL trigger resource object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB SQL trigger
    :type id: str
    :param body: Body of the Trigger
    :type body: str
    :param trigger_type: Type of the Trigger. Possible values include: 'Pre',
     'Post'
    :type trigger_type: str or ~azure.mgmt.cosmosdb.models.TriggerType
    :param trigger_operation: The operation the trigger is associated with.
     Possible values include: 'All', 'Create', 'Update', 'Delete', 'Replace'
    :type trigger_operation: str or
     ~azure.mgmt.cosmosdb.models.TriggerOperation
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'body': {'key': 'body', 'type': 'str'},
        'trigger_type': {'key': 'triggerType', 'type': 'str'},
        'trigger_operation': {'key': 'triggerOperation', 'type': 'str'},
    }

    def __init__(self, *, id: str, body: str=None, trigger_type=None, trigger_operation=None, **kwargs) -> None:
        super(SqlTriggerResource, self).__init__(**kwargs)
        self.id = id
        self.body = body
        self.trigger_type = trigger_type
        self.trigger_operation = trigger_operation


class SqlUserDefinedFunctionCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB userDefinedFunction.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource: Required. The standard JSON format of a
     userDefinedFunction
    :type resource: ~azure.mgmt.cosmosdb.models.SqlUserDefinedFunctionResource
    :param options: Required. A key-value pair of options to be applied for
     the request. This corresponds to the headers sent with the request.
    :type options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource': {'required': True},
        'options': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'SqlUserDefinedFunctionResource'},
        'options': {'key': 'properties.options', 'type': 'CreateUpdateOptions'},
    }

    def __init__(self, *, resource, options, location: str=None, tags=None, identity=None, **kwargs) -> None:
        super(SqlUserDefinedFunctionCreateUpdateParameters, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource
        self.options = options


class SqlUserDefinedFunctionGetPropertiesResource(Model):
    """SqlUserDefinedFunctionGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB SQL userDefinedFunction
    :type id: str
    :param body: Body of the User Defined Function
    :type body: str
    :ivar _rid: A system generated property. A unique identifier.
    :vartype _rid: str
    :ivar _ts: A system generated property that denotes the last updated
     timestamp of the resource.
    :vartype _ts: object
    :ivar _etag: A system generated property representing the resource etag
     required for optimistic concurrency control.
    :vartype _etag: str
    """

    _validation = {
        'id': {'required': True},
        '_rid': {'readonly': True},
        '_ts': {'readonly': True},
        '_etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'body': {'key': 'body', 'type': 'str'},
        '_rid': {'key': '_rid', 'type': 'str'},
        '_ts': {'key': '_ts', 'type': 'object'},
        '_etag': {'key': '_etag', 'type': 'str'},
    }

    def __init__(self, *, id: str, body: str=None, **kwargs) -> None:
        super(SqlUserDefinedFunctionGetPropertiesResource, self).__init__(**kwargs)
        self.id = id
        self.body = body
        self._rid = None
        self._ts = None
        self._etag = None


class SqlUserDefinedFunctionGetResults(ARMResourceProperties):
    """An Azure Cosmos DB userDefinedFunction.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource:
    :type resource:
     ~azure.mgmt.cosmosdb.models.SqlUserDefinedFunctionGetPropertiesResource
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'SqlUserDefinedFunctionGetPropertiesResource'},
    }

    def __init__(self, *, location: str=None, tags=None, identity=None, resource=None, **kwargs) -> None:
        super(SqlUserDefinedFunctionGetResults, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource


class SqlUserDefinedFunctionResource(Model):
    """Cosmos DB SQL userDefinedFunction resource object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB SQL userDefinedFunction
    :type id: str
    :param body: Body of the User Defined Function
    :type body: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'body': {'key': 'body', 'type': 'str'},
    }

    def __init__(self, *, id: str, body: str=None, **kwargs) -> None:
        super(SqlUserDefinedFunctionResource, self).__init__(**kwargs)
        self.id = id
        self.body = body


class SystemData(Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource.
     Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
    :type created_by_type: str or ~azure.mgmt.cosmosdb.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the
     resource. Possible values include: 'User', 'Application',
     'ManagedIdentity', 'Key'
    :type last_modified_by_type: str or
     ~azure.mgmt.cosmosdb.models.CreatedByType
    :param last_modified_at: The type of identity that last modified the
     resource.
    :type last_modified_at: datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(self, *, created_by: str=None, created_by_type=None, created_at=None, last_modified_by: str=None, last_modified_by_type=None, last_modified_at=None, **kwargs) -> None:
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TableCreateUpdateParameters(ARMResourceProperties):
    """Parameters to create and update Cosmos DB Table.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource: Required. The standard JSON format of a Table
    :type resource: ~azure.mgmt.cosmosdb.models.TableResource
    :param options: Required. A key-value pair of options to be applied for
     the request. This corresponds to the headers sent with the request.
    :type options: ~azure.mgmt.cosmosdb.models.CreateUpdateOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource': {'required': True},
        'options': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'TableResource'},
        'options': {'key': 'properties.options', 'type': 'CreateUpdateOptions'},
    }

    def __init__(self, *, resource, options, location: str=None, tags=None, identity=None, **kwargs) -> None:
        super(TableCreateUpdateParameters, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource
        self.options = options


class TableGetPropertiesOptions(OptionsResource):
    """TableGetPropertiesOptions.

    :param throughput: Value of the Cosmos DB resource throughput or
     autoscaleSettings. Use the ThroughputSetting resource when retrieving
     offer details.
    :type throughput: int
    :param autoscale_settings: Specifies the Autoscale settings.
    :type autoscale_settings: ~azure.mgmt.cosmosdb.models.AutoscaleSettings
    """

    _attribute_map = {
        'throughput': {'key': 'throughput', 'type': 'int'},
        'autoscale_settings': {'key': 'autoscaleSettings', 'type': 'AutoscaleSettings'},
    }

    def __init__(self, *, throughput: int=None, autoscale_settings=None, **kwargs) -> None:
        super(TableGetPropertiesOptions, self).__init__(throughput=throughput, autoscale_settings=autoscale_settings, **kwargs)


class TableGetPropertiesResource(Model):
    """TableGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB table
    :type id: str
    :ivar _rid: A system generated property. A unique identifier.
    :vartype _rid: str
    :ivar _ts: A system generated property that denotes the last updated
     timestamp of the resource.
    :vartype _ts: object
    :ivar _etag: A system generated property representing the resource etag
     required for optimistic concurrency control.
    :vartype _etag: str
    """

    _validation = {
        'id': {'required': True},
        '_rid': {'readonly': True},
        '_ts': {'readonly': True},
        '_etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        '_rid': {'key': '_rid', 'type': 'str'},
        '_ts': {'key': '_ts', 'type': 'object'},
        '_etag': {'key': '_etag', 'type': 'str'},
    }

    def __init__(self, *, id: str, **kwargs) -> None:
        super(TableGetPropertiesResource, self).__init__(**kwargs)
        self.id = id
        self._rid = None
        self._ts = None
        self._etag = None


class TableGetResults(ARMResourceProperties):
    """An Azure Cosmos DB Table.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource:
    :type resource: ~azure.mgmt.cosmosdb.models.TableGetPropertiesResource
    :param options:
    :type options: ~azure.mgmt.cosmosdb.models.TableGetPropertiesOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'TableGetPropertiesResource'},
        'options': {'key': 'properties.options', 'type': 'TableGetPropertiesOptions'},
    }

    def __init__(self, *, location: str=None, tags=None, identity=None, resource=None, options=None, **kwargs) -> None:
        super(TableGetResults, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource
        self.options = options


class TableResource(Model):
    """Cosmos DB table resource object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB table
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str, **kwargs) -> None:
        super(TableResource, self).__init__(**kwargs)
        self.id = id


class ThroughputPolicyResource(Model):
    """Cosmos DB resource throughput policy.

    :param is_enabled: Determines whether the ThroughputPolicy is active or
     not
    :type is_enabled: bool
    :param increment_percent: Represents the percentage by which throughput
     can increase every time throughput policy kicks in.
    :type increment_percent: int
    """

    _attribute_map = {
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'increment_percent': {'key': 'incrementPercent', 'type': 'int'},
    }

    def __init__(self, *, is_enabled: bool=None, increment_percent: int=None, **kwargs) -> None:
        super(ThroughputPolicyResource, self).__init__(**kwargs)
        self.is_enabled = is_enabled
        self.increment_percent = increment_percent


class ThroughputSettingsGetPropertiesResource(Model):
    """ThroughputSettingsGetPropertiesResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param throughput: Value of the Cosmos DB resource throughput. Either
     throughput is required or autoscaleSettings is required, but not both.
    :type throughput: int
    :param autoscale_settings: Cosmos DB resource for autoscale settings.
     Either throughput is required or autoscaleSettings is required, but not
     both.
    :type autoscale_settings:
     ~azure.mgmt.cosmosdb.models.AutoscaleSettingsResource
    :ivar minimum_throughput: The minimum throughput of the resource
    :vartype minimum_throughput: str
    :ivar offer_replace_pending: The throughput replace is pending
    :vartype offer_replace_pending: str
    :ivar _rid: A system generated property. A unique identifier.
    :vartype _rid: str
    :ivar _ts: A system generated property that denotes the last updated
     timestamp of the resource.
    :vartype _ts: object
    :ivar _etag: A system generated property representing the resource etag
     required for optimistic concurrency control.
    :vartype _etag: str
    """

    _validation = {
        'minimum_throughput': {'readonly': True},
        'offer_replace_pending': {'readonly': True},
        '_rid': {'readonly': True},
        '_ts': {'readonly': True},
        '_etag': {'readonly': True},
    }

    _attribute_map = {
        'throughput': {'key': 'throughput', 'type': 'int'},
        'autoscale_settings': {'key': 'autoscaleSettings', 'type': 'AutoscaleSettingsResource'},
        'minimum_throughput': {'key': 'minimumThroughput', 'type': 'str'},
        'offer_replace_pending': {'key': 'offerReplacePending', 'type': 'str'},
        '_rid': {'key': '_rid', 'type': 'str'},
        '_ts': {'key': '_ts', 'type': 'object'},
        '_etag': {'key': '_etag', 'type': 'str'},
    }

    def __init__(self, *, throughput: int=None, autoscale_settings=None, **kwargs) -> None:
        super(ThroughputSettingsGetPropertiesResource, self).__init__(**kwargs)
        self.throughput = throughput
        self.autoscale_settings = autoscale_settings
        self.minimum_throughput = None
        self.offer_replace_pending = None
        self._rid = None
        self._ts = None
        self._etag = None


class ThroughputSettingsGetResults(ARMResourceProperties):
    """An Azure Cosmos DB resource throughput.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource:
    :type resource:
     ~azure.mgmt.cosmosdb.models.ThroughputSettingsGetPropertiesResource
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'ThroughputSettingsGetPropertiesResource'},
    }

    def __init__(self, *, location: str=None, tags=None, identity=None, resource=None, **kwargs) -> None:
        super(ThroughputSettingsGetResults, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource


class ThroughputSettingsResource(Model):
    """Cosmos DB resource throughput object. Either throughput is required or
    autoscaleSettings is required, but not both.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param throughput: Value of the Cosmos DB resource throughput. Either
     throughput is required or autoscaleSettings is required, but not both.
    :type throughput: int
    :param autoscale_settings: Cosmos DB resource for autoscale settings.
     Either throughput is required or autoscaleSettings is required, but not
     both.
    :type autoscale_settings:
     ~azure.mgmt.cosmosdb.models.AutoscaleSettingsResource
    :ivar minimum_throughput: The minimum throughput of the resource
    :vartype minimum_throughput: str
    :ivar offer_replace_pending: The throughput replace is pending
    :vartype offer_replace_pending: str
    """

    _validation = {
        'minimum_throughput': {'readonly': True},
        'offer_replace_pending': {'readonly': True},
    }

    _attribute_map = {
        'throughput': {'key': 'throughput', 'type': 'int'},
        'autoscale_settings': {'key': 'autoscaleSettings', 'type': 'AutoscaleSettingsResource'},
        'minimum_throughput': {'key': 'minimumThroughput', 'type': 'str'},
        'offer_replace_pending': {'key': 'offerReplacePending', 'type': 'str'},
    }

    def __init__(self, *, throughput: int=None, autoscale_settings=None, **kwargs) -> None:
        super(ThroughputSettingsResource, self).__init__(**kwargs)
        self.throughput = throughput
        self.autoscale_settings = autoscale_settings
        self.minimum_throughput = None
        self.offer_replace_pending = None


class ThroughputSettingsUpdateParameters(ARMResourceProperties):
    """Parameters to update Cosmos DB resource throughput.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the ARM resource.
    :vartype id: str
    :ivar name: The name of the ARM resource.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.cosmosdb.models.ManagedServiceIdentity
    :param resource: Required. The standard JSON format of a resource
     throughput
    :type resource: ~azure.mgmt.cosmosdb.models.ThroughputSettingsResource
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'resource': {'key': 'properties.resource', 'type': 'ThroughputSettingsResource'},
    }

    def __init__(self, *, resource, location: str=None, tags=None, identity=None, **kwargs) -> None:
        super(ThroughputSettingsUpdateParameters, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.resource = resource


class TrackedResource(Resource):
    """Tracked Resource.

    The resource model definition for an Azure Resource Manager tracked top
    level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(self, *, location: str, tags=None, **kwargs) -> None:
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class UniqueKey(Model):
    """The unique key on that enforces uniqueness constraint on documents in the
    collection in the Azure Cosmos DB service.

    :param paths: List of paths must be unique for each document in the Azure
     Cosmos DB service
    :type paths: list[str]
    """

    _attribute_map = {
        'paths': {'key': 'paths', 'type': '[str]'},
    }

    def __init__(self, *, paths=None, **kwargs) -> None:
        super(UniqueKey, self).__init__(**kwargs)
        self.paths = paths


class UniqueKeyPolicy(Model):
    """The unique key policy configuration for specifying uniqueness constraints
    on documents in the collection in the Azure Cosmos DB service.

    :param unique_keys: List of unique keys on that enforces uniqueness
     constraint on documents in the collection in the Azure Cosmos DB service.
    :type unique_keys: list[~azure.mgmt.cosmosdb.models.UniqueKey]
    """

    _attribute_map = {
        'unique_keys': {'key': 'uniqueKeys', 'type': '[UniqueKey]'},
    }

    def __init__(self, *, unique_keys=None, **kwargs) -> None:
        super(UniqueKeyPolicy, self).__init__(**kwargs)
        self.unique_keys = unique_keys


class VirtualNetworkRule(Model):
    """Virtual Network ACL Rule object.

    :param id: Resource ID of a subnet, for example:
     /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
    :type id: str
    :param ignore_missing_vnet_service_endpoint: Create firewall rule before
     the virtual network has vnet service endpoint enabled.
    :type ignore_missing_vnet_service_endpoint: bool
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'ignore_missing_vnet_service_endpoint': {'key': 'ignoreMissingVNetServiceEndpoint', 'type': 'bool'},
    }

    def __init__(self, *, id: str=None, ignore_missing_vnet_service_endpoint: bool=None, **kwargs) -> None:
        super(VirtualNetworkRule, self).__init__(**kwargs)
        self.id = id
        self.ignore_missing_vnet_service_endpoint = ignore_missing_vnet_service_endpoint
