# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ManagedClusterProperties(Model):
    """Properties of the managed cluster.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar provisioning_state: The current deployment or provisioning state,
     which only appears in the response.
    :vartype provisioning_state: str
    :param dns_prefix: DNS prefix specified when creating the managed cluster.
    :type dns_prefix: str
    :ivar fqdn: FDQN for the master pool.
    :vartype fqdn: str
    :param kubernetes_version: Version of Kubernetes specified when creating
     the managed cluster.
    :type kubernetes_version: str
    :param access_profiles: Access profiles for the managed cluster.
    :type access_profiles: :class:`ManagedClusterPropertiesAccessProfiles
     <azure.mgmt.containerservice.models.ManagedClusterPropertiesAccessProfiles>`
    :param agent_pool_profiles: Properties of the agent pool.
    :type agent_pool_profiles: list of
     :class:`ContainerServiceAgentPoolProfile
     <azure.mgmt.containerservice.models.ContainerServiceAgentPoolProfile>`
    :param linux_profile: Profile for Linux VMs in the container service
     cluster.
    :type linux_profile: :class:`ContainerServiceLinuxProfile
     <azure.mgmt.containerservice.models.ContainerServiceLinuxProfile>`
    :param service_principal_profile: Information about a service principal
     identity for the cluster to use for manipulating Azure APIs. Either secret
     or keyVaultSecretRef must be specified.
    :type service_principal_profile:
     :class:`ContainerServiceServicePrincipalProfile
     <azure.mgmt.containerservice.models.ContainerServiceServicePrincipalProfile>`
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'fqdn': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'dns_prefix': {'key': 'dnsPrefix', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'kubernetes_version': {'key': 'kubernetesVersion', 'type': 'str'},
        'access_profiles': {'key': 'accessProfiles', 'type': 'ManagedClusterPropertiesAccessProfiles'},
        'agent_pool_profiles': {'key': 'agentPoolProfiles', 'type': '[ContainerServiceAgentPoolProfile]'},
        'linux_profile': {'key': 'linuxProfile', 'type': 'ContainerServiceLinuxProfile'},
        'service_principal_profile': {'key': 'servicePrincipalProfile', 'type': 'ContainerServiceServicePrincipalProfile'},
    }

    def __init__(self, dns_prefix=None, kubernetes_version=None, access_profiles=None, agent_pool_profiles=None, linux_profile=None, service_principal_profile=None):
        self.provisioning_state = None
        self.dns_prefix = dns_prefix
        self.fqdn = None
        self.kubernetes_version = kubernetes_version
        self.access_profiles = access_profiles
        self.agent_pool_profiles = agent_pool_profiles
        self.linux_profile = linux_profile
        self.service_principal_profile = service_principal_profile
