/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.hdfs;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.hdfs.HdfsFileSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public final class HdfsFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final HdfsFileSystemConfigBuilder BUILDER = new HdfsFileSystemConfigBuilder();
    private static final String KEY_CONFIG_NAMES = "configNames";
    private static final String KEY_CONFIG_PATHS = "configPaths";
    private static final String KEY_CONFIG_URLS = "configURLs";
    private static final String KEY_CONFIG_STREAM = "configStream";
    private static final String KEY_CONFIG_CONF = "configConf";

    public static HdfsFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    private HdfsFileSystemConfigBuilder() {
        super("hdfs.");
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return HdfsFileSystem.class;
    }

    public Configuration getConfigConfiguration(FileSystemOptions opts) {
        return (Configuration)this.getParam(opts, KEY_CONFIG_CONF);
    }

    public InputStream getConfigInputStream(FileSystemOptions opts) {
        return (InputStream)this.getParam(opts, KEY_CONFIG_STREAM);
    }

    public String[] getConfigNames(FileSystemOptions opts) {
        String names = this.getString(opts, KEY_CONFIG_NAMES);
        return names == null || names.isEmpty() ? null : names.split(",");
    }

    public Path[] getConfigPaths(FileSystemOptions opts) {
        String pathNames = this.getString(opts, KEY_CONFIG_PATHS);
        if (pathNames == null || pathNames.isEmpty()) {
            return null;
        }
        String[] paths = pathNames.split(",");
        return (Path[])Arrays.stream(paths).map(Path::new).toArray(Path[]::new);
    }

    public URL[] getConfigURLs(FileSystemOptions opts) {
        try {
            String urlNames = this.getString(opts, KEY_CONFIG_URLS);
            if (urlNames == null || urlNames.isEmpty()) {
                return null;
            }
            String[] urls = urlNames.split(",");
            URL[] realURLs = new URL[urls.length];
            for (int i = 0; i < urls.length; ++i) {
                realURLs[i] = new URL(urls[i]);
            }
            return realURLs;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public void setConfigConfiguration(FileSystemOptions opts, Configuration configuration) {
        this.setParam(opts, KEY_CONFIG_CONF, configuration);
    }

    public void setConfigInputStream(FileSystemOptions opts, InputStream inputStream) {
        this.setParam(opts, KEY_CONFIG_STREAM, inputStream);
    }

    public void setConfigName(FileSystemOptions opts, String name) {
        if (name == null || name.isEmpty()) {
            this.setParam(opts, KEY_CONFIG_NAMES, null);
        } else {
            String previousNames = this.getString(opts, KEY_CONFIG_NAMES);
            if (previousNames == null || previousNames.isEmpty()) {
                this.setParam(opts, KEY_CONFIG_NAMES, name);
            } else {
                this.setParam(opts, KEY_CONFIG_NAMES, previousNames + "," + name);
            }
        }
    }

    public void setConfigPath(FileSystemOptions opts, Path path) {
        if (path == null) {
            this.setParam(opts, KEY_CONFIG_PATHS, null);
        } else {
            String previousPathNames = this.getString(opts, KEY_CONFIG_PATHS);
            if (previousPathNames == null || previousPathNames.isEmpty()) {
                this.setParam(opts, KEY_CONFIG_PATHS, path.toString());
            } else {
                this.setParam(opts, KEY_CONFIG_PATHS, previousPathNames + "," + path.toString());
            }
        }
    }

    public void setConfigURL(FileSystemOptions opts, URL url) {
        if (url == null) {
            this.setParam(opts, KEY_CONFIG_URLS, null);
        } else {
            String previousURLNames = this.getString(opts, KEY_CONFIG_URLS);
            if (previousURLNames == null || previousURLNames.isEmpty()) {
                this.setParam(opts, KEY_CONFIG_URLS, url.toString());
            } else {
                this.setParam(opts, KEY_CONFIG_URLS, previousURLNames + "," + url.toString());
            }
        }
    }
}

