# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ComposeDeploymentUpgradeDescription(Model):
    """Describes the parameters for a compose deployment upgrade.

    :param deployment_name:
    :type deployment_name: str
    :param compose_file_content: The content of the compose file that
     describes the deployment to create.
    :type compose_file_content: str
    :param registry_credential:
    :type registry_credential: :class:`RegistryCredential
     <azure.servicefabric.models.RegistryCredential>`
    :param upgrade_kind: Possible values include: 'Invalid', 'Rolling'.
     Default value: "Rolling" .
    :type upgrade_kind: str or :class:`enum <azure.servicefabric.models.enum>`
    :param rolling_upgrade_mode: Possible values include: 'Invalid',
     'UnmonitoredAuto', 'UnmonitoredManual', 'Monitored'. Default value:
     "UnmonitoredAuto" .
    :type rolling_upgrade_mode: str or :class:`enum
     <azure.servicefabric.models.enum>`
    :param upgrade_replica_set_check_timeout_in_seconds:
    :type upgrade_replica_set_check_timeout_in_seconds: long
    :param force_restart:
    :type force_restart: bool
    :param monitoring_policy:
    :type monitoring_policy: :class:`MonitoringPolicyDescription
     <azure.servicefabric.models.MonitoringPolicyDescription>`
    :param application_health_policy:
    :type application_health_policy: :class:`ApplicationHealthPolicy
     <azure.servicefabric.models.ApplicationHealthPolicy>`
    """

    _validation = {
        'deployment_name': {'required': True},
        'compose_file_content': {'required': True},
        'upgrade_kind': {'required': True},
    }

    _attribute_map = {
        'deployment_name': {'key': 'DeploymentName', 'type': 'str'},
        'compose_file_content': {'key': 'ComposeFileContent', 'type': 'str'},
        'registry_credential': {'key': 'RegistryCredential', 'type': 'RegistryCredential'},
        'upgrade_kind': {'key': 'UpgradeKind', 'type': 'str'},
        'rolling_upgrade_mode': {'key': 'RollingUpgradeMode', 'type': 'str'},
        'upgrade_replica_set_check_timeout_in_seconds': {'key': 'UpgradeReplicaSetCheckTimeoutInSeconds', 'type': 'long'},
        'force_restart': {'key': 'ForceRestart', 'type': 'bool'},
        'monitoring_policy': {'key': 'MonitoringPolicy', 'type': 'MonitoringPolicyDescription'},
        'application_health_policy': {'key': 'ApplicationHealthPolicy', 'type': 'ApplicationHealthPolicy'},
    }

    def __init__(self, deployment_name, compose_file_content, registry_credential=None, upgrade_kind="Rolling", rolling_upgrade_mode="UnmonitoredAuto", upgrade_replica_set_check_timeout_in_seconds=None, force_restart=None, monitoring_policy=None, application_health_policy=None):
        self.deployment_name = deployment_name
        self.compose_file_content = compose_file_content
        self.registry_credential = registry_credential
        self.upgrade_kind = upgrade_kind
        self.rolling_upgrade_mode = rolling_upgrade_mode
        self.upgrade_replica_set_check_timeout_in_seconds = upgrade_replica_set_check_timeout_in_seconds
        self.force_restart = force_restart
        self.monitoring_policy = monitoring_policy
        self.application_health_policy = application_health_policy
