# Copyright 2020 StrongDM Inc
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# This file was generated by protogen. DO NOT EDIT.

import grpc
from . import plumbing
from . import models
from .options_pb2 import *
from .options_pb2_grpc import *
from .spec_pb2 import *
from .spec_pb2_grpc import *
from .account_attachments_pb2 import *
from .account_attachments_pb2_grpc import *
from .account_grants_pb2 import *
from .account_grants_pb2_grpc import *
from .tags_pb2 import *
from .tags_pb2_grpc import *
from .accounts_pb2 import *
from .accounts_pb2_grpc import *
from .control_panel_pb2 import *
from .control_panel_pb2_grpc import *
from .drivers_pb2 import *
from .drivers_pb2_grpc import *
from .nodes_pb2 import *
from .nodes_pb2_grpc import *
from .remote_identities_pb2 import *
from .remote_identities_pb2_grpc import *
from .remote_identity_groups_pb2 import *
from .remote_identity_groups_pb2_grpc import *
from .resources_pb2 import *
from .resources_pb2_grpc import *
from .roles_pb2 import *
from .roles_pb2_grpc import *
from .secret_store_types_pb2 import *
from .secret_store_types_pb2_grpc import *
from .secret_stores_pb2 import *
from .secret_stores_pb2_grpc import *
import warnings
import functools


def deprecated(func):
    """This is a decorator which can be used to mark functions
    as deprecated. It will result in a warning being emitted
    when the function is used."""
    @functools.wraps(func)
    def new_func(*args, **kwargs):
        warnings.warn("Call to deprecated function {}.".format(func.__name__),
                      category=DeprecationWarning,
                      stacklevel=2)
        return func(*args, **kwargs)

    return new_func


class AccountAttachments:
    '''
     AccountAttachments assign an account to a role.
    See `strongdm.models.AccountAttachment`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = AccountAttachmentsStub(channel)

    def create(self, account_attachment, timeout=None):
        '''
         Create registers a new AccountAttachment.
        '''
        req = AccountAttachmentCreateRequest()

        if account_attachment is not None:
            req.account_attachment.CopyFrom(
                plumbing.convert_account_attachment_to_plumbing(
                    account_attachment))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata(
                        'AccountAttachments.Create', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.AccountAttachmentCreateResponse()
        resp.account_attachment = plumbing.convert_account_attachment_to_porcelain(
            plumbing_response.account_attachment)
        resp.meta = plumbing.convert_create_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads one AccountAttachment by ID.
        '''
        req = AccountAttachmentGetRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('AccountAttachments.Get',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.AccountAttachmentGetResponse()
        resp.account_attachment = plumbing.convert_account_attachment_to_porcelain(
            plumbing_response.account_attachment)
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete removes a AccountAttachment by ID.
        '''
        req = AccountAttachmentDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata(
                        'AccountAttachments.Delete', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.AccountAttachmentDeleteResponse()
        resp.meta = plumbing.convert_delete_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of AccountAttachments matching a given set of criteria.
        '''
        req = AccountAttachmentListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        page_size_option = self.parent._test_options.get('PageSize')
        if isinstance(page_size_option, int):
            req.meta.limit = page_size_option

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'AccountAttachments.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.account_attachments:
                    yield plumbing.convert_account_attachment_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class AccountGrants:
    '''
     AccountGrants assign a resource directly to an account, giving the account the permission to connect to that resource.
    See `strongdm.models.AccountGrant`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = AccountGrantsStub(channel)

    def create(self, account_grant, timeout=None):
        '''
         Create registers a new AccountGrant.
        '''
        req = AccountGrantCreateRequest()

        if account_grant is not None:
            req.account_grant.CopyFrom(
                plumbing.convert_account_grant_to_plumbing(account_grant))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata('AccountGrants.Create',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.AccountGrantCreateResponse()
        resp.account_grant = plumbing.convert_account_grant_to_porcelain(
            plumbing_response.account_grant)
        resp.meta = plumbing.convert_create_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads one AccountGrant by ID.
        '''
        req = AccountGrantGetRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('AccountGrants.Get',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.AccountGrantGetResponse()
        resp.account_grant = plumbing.convert_account_grant_to_porcelain(
            plumbing_response.account_grant)
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete removes a AccountGrant by ID.
        '''
        req = AccountGrantDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata('AccountGrants.Delete',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.AccountGrantDeleteResponse()
        resp.meta = plumbing.convert_delete_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of AccountGrants matching a given set of criteria.
        '''
        req = AccountGrantListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        page_size_option = self.parent._test_options.get('PageSize')
        if isinstance(page_size_option, int):
            req.meta.limit = page_size_option

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'AccountGrants.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.account_grants:
                    yield plumbing.convert_account_grant_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class Accounts:
    '''
     Accounts are users that have access to strongDM. There are two types of accounts:
     1. **Users:** humans who are authenticated through username and password or SSO.
     2. **Service Accounts:** machines that are authenticated using a service token.
    See:
    `strongdm.models.Service`
    `strongdm.models.User`
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = AccountsStub(channel)

    def create(self, account, timeout=None):
        '''
         Create registers a new Account.
        '''
        req = AccountCreateRequest()

        if account is not None:
            req.account.CopyFrom(plumbing.convert_account_to_plumbing(account))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata('Accounts.Create', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.AccountCreateResponse()
        resp.account = plumbing.convert_account_to_porcelain(
            plumbing_response.account)
        resp.meta = plumbing.convert_create_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.token = (plumbing_response.token)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads one Account by ID.
        '''
        req = AccountGetRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('Accounts.Get', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.AccountGetResponse()
        resp.account = plumbing.convert_account_to_porcelain(
            plumbing_response.account)
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def update(self, account, timeout=None):
        '''
         Update replaces all the fields of an Account by ID.
        '''
        req = AccountUpdateRequest()

        if account is not None:
            req.account.CopyFrom(plumbing.convert_account_to_plumbing(account))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Update(
                    req,
                    metadata=self.parent.get_metadata('Accounts.Update', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.AccountUpdateResponse()
        resp.account = plumbing.convert_account_to_porcelain(
            plumbing_response.account)
        resp.meta = plumbing.convert_update_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete removes an Account by ID.
        '''
        req = AccountDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata('Accounts.Delete', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.AccountDeleteResponse()
        resp.meta = plumbing.convert_delete_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of Accounts matching a given set of criteria.
        '''
        req = AccountListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        page_size_option = self.parent._test_options.get('PageSize')
        if isinstance(page_size_option, int):
            req.meta.limit = page_size_option

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata('Accounts.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.accounts:
                    yield plumbing.convert_account_to_porcelain(plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class ControlPanel:
    '''
     ControlPanel contains all administrative controls.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = ControlPanelStub(channel)

    def get_sshca_public_key(self, timeout=None):
        '''
         GetSSHCAPublicKey retrieves the SSH CA public key.
        '''
        req = ControlPanelGetSSHCAPublicKeyRequest()

        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.GetSSHCAPublicKey(
                    req,
                    metadata=self.parent.get_metadata(
                        'ControlPanel.GetSSHCAPublicKey', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.ControlPanelGetSSHCAPublicKeyResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.public_key = (plumbing_response.public_key)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def verify_jwt(self, token, timeout=None):
        '''
         VerifyJWT reports whether the given JWT token (x-sdm-token) is valid.
        '''
        req = ControlPanelVerifyJWTRequest()

        req.token = (token)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.VerifyJWT(
                    req,
                    metadata=self.parent.get_metadata('ControlPanel.VerifyJWT',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.ControlPanelVerifyJWTResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.valid = (plumbing_response.valid)
        return resp


class Nodes:
    '''
     Nodes make up the strongDM network, and allow your users to connect securely to your resources. There are two types of nodes:
     - **Gateways** are the entry points into network. They listen for connection from the strongDM client, and provide access to databases and servers.
     - **Relays** are used to extend the strongDM network into segmented subnets. They provide access to databases and servers but do not listen for incoming connections.
    See:
    `strongdm.models.Gateway`
    `strongdm.models.Relay`
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = NodesStub(channel)

    def create(self, node, timeout=None):
        '''
         Create registers a new Node.
        '''
        req = NodeCreateRequest()

        if node is not None:
            req.node.CopyFrom(plumbing.convert_node_to_plumbing(node))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata('Nodes.Create', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.NodeCreateResponse()
        resp.meta = plumbing.convert_create_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.node = plumbing.convert_node_to_porcelain(plumbing_response.node)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.token = (plumbing_response.token)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads one Node by ID.
        '''
        req = NodeGetRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('Nodes.Get', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.NodeGetResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.node = plumbing.convert_node_to_porcelain(plumbing_response.node)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def update(self, node, timeout=None):
        '''
         Update replaces all the fields of a Node by ID.
        '''
        req = NodeUpdateRequest()

        if node is not None:
            req.node.CopyFrom(plumbing.convert_node_to_plumbing(node))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Update(
                    req,
                    metadata=self.parent.get_metadata('Nodes.Update', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.NodeUpdateResponse()
        resp.meta = plumbing.convert_update_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.node = plumbing.convert_node_to_porcelain(plumbing_response.node)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete removes a Node by ID.
        '''
        req = NodeDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata('Nodes.Delete', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.NodeDeleteResponse()
        resp.meta = plumbing.convert_delete_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of Nodes matching a given set of criteria.
        '''
        req = NodeListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        page_size_option = self.parent._test_options.get('PageSize')
        if isinstance(page_size_option, int):
            req.meta.limit = page_size_option

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata('Nodes.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.nodes:
                    yield plumbing.convert_node_to_porcelain(plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class RemoteIdentities:
    '''
     RemoteIdentities assign a resource directly to an account, giving the account the permission to connect to that resource.
    See `strongdm.models.RemoteIdentity`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = RemoteIdentitiesStub(channel)

    def create(self, remote_identity, timeout=None):
        '''
         Create registers a new RemoteIdentity.
        '''
        req = RemoteIdentityCreateRequest()

        if remote_identity is not None:
            req.remote_identity.CopyFrom(
                plumbing.convert_remote_identity_to_plumbing(remote_identity))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata(
                        'RemoteIdentities.Create', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.RemoteIdentityCreateResponse()
        resp.meta = plumbing.convert_create_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.remote_identity = plumbing.convert_remote_identity_to_porcelain(
            plumbing_response.remote_identity)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads one RemoteIdentity by ID.
        '''
        req = RemoteIdentityGetRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('RemoteIdentities.Get',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.RemoteIdentityGetResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.remote_identity = plumbing.convert_remote_identity_to_porcelain(
            plumbing_response.remote_identity)
        return resp

    def update(self, remote_identity, timeout=None):
        '''
         Update replaces all the fields of a RemoteIdentity by ID.
        '''
        req = RemoteIdentityUpdateRequest()

        if remote_identity is not None:
            req.remote_identity.CopyFrom(
                plumbing.convert_remote_identity_to_plumbing(remote_identity))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Update(
                    req,
                    metadata=self.parent.get_metadata(
                        'RemoteIdentities.Update', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.RemoteIdentityUpdateResponse()
        resp.meta = plumbing.convert_update_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.remote_identity = plumbing.convert_remote_identity_to_porcelain(
            plumbing_response.remote_identity)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete removes a RemoteIdentity by ID.
        '''
        req = RemoteIdentityDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata(
                        'RemoteIdentities.Delete', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.RemoteIdentityDeleteResponse()
        resp.meta = plumbing.convert_delete_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of RemoteIdentities matching a given set of criteria.
        '''
        req = RemoteIdentityListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        page_size_option = self.parent._test_options.get('PageSize')
        if isinstance(page_size_option, int):
            req.meta.limit = page_size_option

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'RemoteIdentities.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.remote_identities:
                    yield plumbing.convert_remote_identity_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class RemoteIdentityGroups:
    '''
     A RemoteIdentityGroup is a named grouping of Remote Identities for Accounts.
     An Account's relationship to a RemoteIdentityGroup is defined via RemoteIdentity objects.
    See `strongdm.models.RemoteIdentityGroup`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = RemoteIdentityGroupsStub(channel)

    def get(self, id, timeout=None):
        '''
         Get reads one RemoteIdentityGroup by ID.
        '''
        req = RemoteIdentityGroupGetRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata(
                        'RemoteIdentityGroups.Get', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.RemoteIdentityGroupGetResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.remote_identity_group = plumbing.convert_remote_identity_group_to_porcelain(
            plumbing_response.remote_identity_group)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of RemoteIdentityGroups matching a given set of criteria.
        '''
        req = RemoteIdentityGroupListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        page_size_option = self.parent._test_options.get('PageSize')
        if isinstance(page_size_option, int):
            req.meta.limit = page_size_option

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'RemoteIdentityGroups.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.remote_identity_groups:
                    yield plumbing.convert_remote_identity_group_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class Resources:
    '''
     Resources are databases, servers, clusters, websites, or clouds that strongDM
     delegates access to.
    See:
    `strongdm.models.AKS`
    `strongdm.models.AKSBasicAuth`
    `strongdm.models.AKSServiceAccount`
    `strongdm.models.AKSServiceAccountUserImpersonation`
    `strongdm.models.AKSUserImpersonation`
    `strongdm.models.AmazonEKS`
    `strongdm.models.AmazonEKSInstanceProfile`
    `strongdm.models.AmazonEKSUserImpersonation`
    `strongdm.models.AmazonES`
    `strongdm.models.AmazonMQAMQP091`
    `strongdm.models.Athena`
    `strongdm.models.AuroraMysql`
    `strongdm.models.AuroraPostgres`
    `strongdm.models.AWS`
    `strongdm.models.AWSConsole`
    `strongdm.models.AWSConsoleStaticKeyPair`
    `strongdm.models.Azure`
    `strongdm.models.AzureCertificate`
    `strongdm.models.AzureMysql`
    `strongdm.models.AzurePostgres`
    `strongdm.models.BigQuery`
    `strongdm.models.Cassandra`
    `strongdm.models.Citus`
    `strongdm.models.Clustrix`
    `strongdm.models.Cockroach`
    `strongdm.models.DB2I`
    `strongdm.models.DB2LUW`
    `strongdm.models.DocumentDBHost`
    `strongdm.models.DocumentDBReplicaSet`
    `strongdm.models.Druid`
    `strongdm.models.DynamoDB`
    `strongdm.models.Elastic`
    `strongdm.models.ElasticacheRedis`
    `strongdm.models.GCP`
    `strongdm.models.GoogleGKE`
    `strongdm.models.GoogleGKEUserImpersonation`
    `strongdm.models.Greenplum`
    `strongdm.models.HTTPAuth`
    `strongdm.models.HTTPBasicAuth`
    `strongdm.models.HTTPNoAuth`
    `strongdm.models.Kubernetes`
    `strongdm.models.KubernetesBasicAuth`
    `strongdm.models.KubernetesServiceAccount`
    `strongdm.models.KubernetesServiceAccountUserImpersonation`
    `strongdm.models.KubernetesUserImpersonation`
    `strongdm.models.Maria`
    `strongdm.models.Memcached`
    `strongdm.models.Memsql`
    `strongdm.models.MongoHost`
    `strongdm.models.MongoLegacyHost`
    `strongdm.models.MongoLegacyReplicaset`
    `strongdm.models.MongoReplicaSet`
    `strongdm.models.MongoShardedCluster`
    `strongdm.models.MTLSMysql`
    `strongdm.models.MTLSPostgres`
    `strongdm.models.Mysql`
    `strongdm.models.Neptune`
    `strongdm.models.NeptuneIAM`
    `strongdm.models.Oracle`
    `strongdm.models.Postgres`
    `strongdm.models.Presto`
    `strongdm.models.RabbitMQAMQP091`
    `strongdm.models.RawTCP`
    `strongdm.models.RDP`
    `strongdm.models.Redis`
    `strongdm.models.Redshift`
    `strongdm.models.SingleStore`
    `strongdm.models.Snowflake`
    `strongdm.models.Snowsight`
    `strongdm.models.SQLServer`
    `strongdm.models.SSH`
    `strongdm.models.SSHCert`
    `strongdm.models.SSHCustomerKey`
    `strongdm.models.Sybase`
    `strongdm.models.SybaseIQ`
    `strongdm.models.Teradata`
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = ResourcesStub(channel)

    def enumerate_tags(self, filter, *args, timeout=None):
        '''
         EnumerateTags gets a list of the filter matching tags.
        '''
        req = EnumerateTagsRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        page_size_option = self.parent._test_options.get('PageSize')
        if isinstance(page_size_option, int):
            req.meta.limit = page_size_option

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.EnumerateTags(
                        req,
                        metadata=svc.parent.get_metadata(
                            'Resources.EnumerateTags', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.matches:
                    yield plumbing.convert_tag_to_porcelain(plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)

    def create(self, resource, timeout=None):
        '''
         Create registers a new Resource.
        '''
        req = ResourceCreateRequest()

        if resource is not None:
            req.resource.CopyFrom(
                plumbing.convert_resource_to_plumbing(resource))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata('Resources.Create', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.ResourceCreateResponse()
        resp.meta = plumbing.convert_create_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.resource = plumbing.convert_resource_to_porcelain(
            plumbing_response.resource)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads one Resource by ID.
        '''
        req = ResourceGetRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('Resources.Get', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.ResourceGetResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.resource = plumbing.convert_resource_to_porcelain(
            plumbing_response.resource)
        return resp

    def update(self, resource, timeout=None):
        '''
         Update replaces all the fields of a Resource by ID.
        '''
        req = ResourceUpdateRequest()

        if resource is not None:
            req.resource.CopyFrom(
                plumbing.convert_resource_to_plumbing(resource))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Update(
                    req,
                    metadata=self.parent.get_metadata('Resources.Update', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.ResourceUpdateResponse()
        resp.meta = plumbing.convert_update_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.resource = plumbing.convert_resource_to_porcelain(
            plumbing_response.resource)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete removes a Resource by ID.
        '''
        req = ResourceDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata('Resources.Delete', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.ResourceDeleteResponse()
        resp.meta = plumbing.convert_delete_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of Resources matching a given set of criteria.
        '''
        req = ResourceListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        page_size_option = self.parent._test_options.get('PageSize')
        if isinstance(page_size_option, int):
            req.meta.limit = page_size_option

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'Resources.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.resources:
                    yield plumbing.convert_resource_to_porcelain(plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class Roles:
    '''
     A Role has a list of access rules which determine which Resources the members
     of the Role have access to. An Account can be a member of multiple Roles via
     AccountAttachments.
    See `strongdm.models.Role`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = RolesStub(channel)

    def create(self, role, timeout=None):
        '''
         Create registers a new Role.
        '''
        req = RoleCreateRequest()

        if role is not None:
            req.role.CopyFrom(plumbing.convert_role_to_plumbing(role))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata('Roles.Create', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.RoleCreateResponse()
        resp.meta = plumbing.convert_create_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.role = plumbing.convert_role_to_porcelain(plumbing_response.role)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads one Role by ID.
        '''
        req = RoleGetRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('Roles.Get', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.RoleGetResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.role = plumbing.convert_role_to_porcelain(plumbing_response.role)
        return resp

    def update(self, role, timeout=None):
        '''
         Update replaces all the fields of a Role by ID.
        '''
        req = RoleUpdateRequest()

        if role is not None:
            req.role.CopyFrom(plumbing.convert_role_to_plumbing(role))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Update(
                    req,
                    metadata=self.parent.get_metadata('Roles.Update', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.RoleUpdateResponse()
        resp.meta = plumbing.convert_update_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.role = plumbing.convert_role_to_porcelain(plumbing_response.role)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete removes a Role by ID.
        '''
        req = RoleDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata('Roles.Delete', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.RoleDeleteResponse()
        resp.meta = plumbing.convert_delete_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of Roles matching a given set of criteria.
        '''
        req = RoleListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        page_size_option = self.parent._test_options.get('PageSize')
        if isinstance(page_size_option, int):
            req.meta.limit = page_size_option

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata('Roles.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.roles:
                    yield plumbing.convert_role_to_porcelain(plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class SecretStores:
    '''
     SecretStores are servers where resource secrets (passwords, keys) are stored.
    See:
    `strongdm.models.AWSStore`
    `strongdm.models.AzureStore`
    `strongdm.models.CyberarkConjurStore`
    `strongdm.models.CyberarkPAMStore`
    `strongdm.models.CyberarkPAMExperimentalStore`
    `strongdm.models.DelineaStore`
    `strongdm.models.GCPStore`
    `strongdm.models.VaultAppRoleStore`
    `strongdm.models.VaultTLSStore`
    `strongdm.models.VaultTokenStore`
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = SecretStoresStub(channel)

    def create(self, secret_store, timeout=None):
        req = SecretStoreCreateRequest()

        if secret_store is not None:
            req.secret_store.CopyFrom(
                plumbing.convert_secret_store_to_plumbing(secret_store))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata('SecretStores.Create',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.SecretStoreCreateResponse()
        resp.meta = plumbing.convert_create_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.secret_store = plumbing.convert_secret_store_to_porcelain(
            plumbing_response.secret_store)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads one SecretStore by ID.
        '''
        req = SecretStoreGetRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('SecretStores.Get', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.SecretStoreGetResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.secret_store = plumbing.convert_secret_store_to_porcelain(
            plumbing_response.secret_store)
        return resp

    def update(self, secret_store, timeout=None):
        '''
         Update replaces all the fields of a SecretStore by ID.
        '''
        req = SecretStoreUpdateRequest()

        if secret_store is not None:
            req.secret_store.CopyFrom(
                plumbing.convert_secret_store_to_plumbing(secret_store))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Update(
                    req,
                    metadata=self.parent.get_metadata('SecretStores.Update',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.SecretStoreUpdateResponse()
        resp.meta = plumbing.convert_update_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.secret_store = plumbing.convert_secret_store_to_porcelain(
            plumbing_response.secret_store)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete removes a SecretStore by ID.
        '''
        req = SecretStoreDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata('SecretStores.Delete',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.SecretStoreDeleteResponse()
        resp.meta = plumbing.convert_delete_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of SecretStores matching a given set of criteria.
        '''
        req = SecretStoreListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        page_size_option = self.parent._test_options.get('PageSize')
        if isinstance(page_size_option, int):
            req.meta.limit = page_size_option

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'SecretStores.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.secret_stores:
                    yield plumbing.convert_secret_store_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)
