# Copyright 2020 StrongDM Inc
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# This file was generated by protogen. DO NOT EDIT.

import grpc
import google.rpc as rpc
import json
from google.rpc import status_pb2
from . import errors
from . import models
from google.protobuf.timestamp_pb2 import Timestamp
import datetime
from .options_pb2 import *
from .spec_pb2 import *
from .account_attachments_pb2 import *
from .account_grants_pb2 import *
from .tags_pb2 import *
from .accounts_pb2 import *
from .control_panel_pb2 import *
from .drivers_pb2 import *
from .nodes_pb2 import *
from .remote_identities_pb2 import *
from .remote_identity_groups_pb2 import *
from .resources_pb2 import *
from .roles_pb2 import *
from .secret_store_types_pb2 import *
from .secret_stores_pb2 import *


def quote_filter_args(filter, *args):
    parts = filter.split("?")
    if len(parts) != len(args) + 1:
        raise errors.BadRequestError("incorrect number of replacements")
    b = ""
    for i, v in enumerate(parts):
        b += v
        if i < len(args):
            s = str(args[i])
            s = json.dumps(s)
            b += s
    return b


def convert_timestamp_to_porcelain(t):
    ts = t.ToDatetime().replace(tzinfo=datetime.timezone.utc)
    if ts == datetime.datetime(1970, 1, 1, 0, 0, 0, 0, datetime.timezone.utc):
        return None
    return ts


def convert_timestamp_to_plumbing(t):
    if t is None:
        return Timestamp()
    if t.tzinfo is None:
        t = t.astimezone(datetime.timezone.utc)
    res = Timestamp()
    res.FromDatetime(t)
    return res


def convert_tags_to_porcelain(t):
    res = {}
    for tag in t.pairs:
        res[tag.name] = tag.value
    return res


def convert_tags_to_plumbing(t):
    tags = Tags()
    if t is None:
        return tags
    for key, value in t.items():
        pair = Tags.Pair()
        pair.name = key
        pair.value = value
        tags.pairs.append(pair)
    return tags


def convert_access_rules_to_porcelain(access_rules_json):
    if access_rules_json == "":
        return []
    return json.loads(access_rules_json)


def convert_access_rules_to_plumbing(access_rules):
    return json.dumps(access_rules)


def convert_aks_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AKS()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.client_certificate = (plumbing.client_certificate)
    porcelain.client_key = (plumbing.client_key)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.remote_identity_group_id = (plumbing.remote_identity_group_id)
    porcelain.remote_identity_healthcheck_username = (
        plumbing.remote_identity_healthcheck_username)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_aks_to_plumbing(porcelain):
    plumbing = AKS()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.client_certificate = (porcelain.client_certificate)
    plumbing.client_key = (porcelain.client_key)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.remote_identity_group_id = (porcelain.remote_identity_group_id)
    plumbing.remote_identity_healthcheck_username = (
        porcelain.remote_identity_healthcheck_username)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_aks_to_plumbing(porcelains):
    return [convert_aks_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_aks_to_porcelain(plumbings):
    return [convert_aks_to_porcelain(plumbing) for plumbing in plumbings]


def convert_aks_basic_auth_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AKSBasicAuth()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_aks_basic_auth_to_plumbing(porcelain):
    plumbing = AKSBasicAuth()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_aks_basic_auth_to_plumbing(porcelains):
    return [
        convert_aks_basic_auth_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_aks_basic_auth_to_porcelain(plumbings):
    return [
        convert_aks_basic_auth_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_aks_service_account_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AKSServiceAccount()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.remote_identity_group_id = (plumbing.remote_identity_group_id)
    porcelain.remote_identity_healthcheck_username = (
        plumbing.remote_identity_healthcheck_username)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.token = (plumbing.token)
    return porcelain


def convert_aks_service_account_to_plumbing(porcelain):
    plumbing = AKSServiceAccount()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.remote_identity_group_id = (porcelain.remote_identity_group_id)
    plumbing.remote_identity_healthcheck_username = (
        porcelain.remote_identity_healthcheck_username)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.token = (porcelain.token)
    return plumbing


def convert_repeated_aks_service_account_to_plumbing(porcelains):
    return [
        convert_aks_service_account_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_aks_service_account_to_porcelain(plumbings):
    return [
        convert_aks_service_account_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_aks_service_account_user_impersonation_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AKSServiceAccountUserImpersonation()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.token = (plumbing.token)
    return porcelain


def convert_aks_service_account_user_impersonation_to_plumbing(porcelain):
    plumbing = AKSServiceAccountUserImpersonation()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.token = (porcelain.token)
    return plumbing


def convert_repeated_aks_service_account_user_impersonation_to_plumbing(
        porcelains):
    return [
        convert_aks_service_account_user_impersonation_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_aks_service_account_user_impersonation_to_porcelain(
        plumbings):
    return [
        convert_aks_service_account_user_impersonation_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_aks_user_impersonation_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AKSUserImpersonation()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.client_certificate = (plumbing.client_certificate)
    porcelain.client_key = (plumbing.client_key)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_aks_user_impersonation_to_plumbing(porcelain):
    plumbing = AKSUserImpersonation()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.client_certificate = (porcelain.client_certificate)
    plumbing.client_key = (porcelain.client_key)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_aks_user_impersonation_to_plumbing(porcelains):
    return [
        convert_aks_user_impersonation_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_aks_user_impersonation_to_porcelain(plumbings):
    return [
        convert_aks_user_impersonation_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_aws_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AWS()
    porcelain.access_key = (plumbing.access_key)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_region = (plumbing.healthcheck_region)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_aws_to_plumbing(porcelain):
    plumbing = AWS()
    if porcelain is None:
        return plumbing
    plumbing.access_key = (porcelain.access_key)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_region = (porcelain.healthcheck_region)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_access_key = (porcelain.secret_access_key)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_aws_to_plumbing(porcelains):
    return [convert_aws_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_aws_to_porcelain(plumbings):
    return [convert_aws_to_porcelain(plumbing) for plumbing in plumbings]


def convert_aws_console_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AWSConsole()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.enable_env_variables = (plumbing.enable_env_variables)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.region = (plumbing.region)
    porcelain.remote_identity_group_id = (plumbing.remote_identity_group_id)
    porcelain.remote_identity_healthcheck_username = (
        plumbing.remote_identity_healthcheck_username)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.session_expiry = (plumbing.session_expiry)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_aws_console_to_plumbing(porcelain):
    plumbing = AWSConsole()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.enable_env_variables = (porcelain.enable_env_variables)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.region = (porcelain.region)
    plumbing.remote_identity_group_id = (porcelain.remote_identity_group_id)
    plumbing.remote_identity_healthcheck_username = (
        porcelain.remote_identity_healthcheck_username)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.session_expiry = (porcelain.session_expiry)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_aws_console_to_plumbing(porcelains):
    return [
        convert_aws_console_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_aws_console_to_porcelain(plumbings):
    return [
        convert_aws_console_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_aws_console_static_key_pair_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AWSConsoleStaticKeyPair()
    porcelain.access_key = (plumbing.access_key)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.region = (plumbing.region)
    porcelain.remote_identity_group_id = (plumbing.remote_identity_group_id)
    porcelain.remote_identity_healthcheck_username = (
        plumbing.remote_identity_healthcheck_username)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.session_expiry = (plumbing.session_expiry)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_aws_console_static_key_pair_to_plumbing(porcelain):
    plumbing = AWSConsoleStaticKeyPair()
    if porcelain is None:
        return plumbing
    plumbing.access_key = (porcelain.access_key)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.region = (porcelain.region)
    plumbing.remote_identity_group_id = (porcelain.remote_identity_group_id)
    plumbing.remote_identity_healthcheck_username = (
        porcelain.remote_identity_healthcheck_username)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_access_key = (porcelain.secret_access_key)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.session_expiry = (porcelain.session_expiry)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_aws_console_static_key_pair_to_plumbing(porcelains):
    return [
        convert_aws_console_static_key_pair_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_aws_console_static_key_pair_to_porcelain(plumbings):
    return [
        convert_aws_console_static_key_pair_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_aws_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AWSStore()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.region = (plumbing.region)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_aws_store_to_plumbing(porcelain):
    plumbing = AWSStore()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.region = (porcelain.region)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_aws_store_to_plumbing(porcelains):
    return [
        convert_aws_store_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_aws_store_to_porcelain(plumbings):
    return [convert_aws_store_to_porcelain(plumbing) for plumbing in plumbings]


def convert_account_to_plumbing(porcelain):
    plumbing = Account()
    if porcelain is None:
        return plumbing
    if isinstance(porcelain, models.Service):
        plumbing.service.CopyFrom(convert_service_to_plumbing(porcelain))
    if isinstance(porcelain, models.User):
        plumbing.user.CopyFrom(convert_user_to_plumbing(porcelain))
    return plumbing


def convert_account_to_porcelain(plumbing):
    if plumbing is None:
        return None
    if plumbing.HasField('service'):
        return convert_service_to_porcelain(plumbing.service)
    if plumbing.HasField('user'):
        return convert_user_to_porcelain(plumbing.user)
    raise errors.UnknownError(
        "unknown polymorphic type, please upgrade your SDK")


def convert_repeated_account_to_plumbing(porcelains):
    return [convert_account_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_account_to_porcelain(plumbings):
    return [convert_account_to_porcelain(plumbing) for plumbing in plumbings]


def convert_account_attachment_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountAttachment()
    porcelain.account_id = (plumbing.account_id)
    porcelain.id = (plumbing.id)
    porcelain.role_id = (plumbing.role_id)
    return porcelain


def convert_account_attachment_to_plumbing(porcelain):
    plumbing = AccountAttachment()
    if porcelain is None:
        return plumbing
    plumbing.account_id = (porcelain.account_id)
    plumbing.id = (porcelain.id)
    plumbing.role_id = (porcelain.role_id)
    return plumbing


def convert_repeated_account_attachment_to_plumbing(porcelains):
    return [
        convert_account_attachment_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_attachment_to_porcelain(plumbings):
    return [
        convert_account_attachment_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_attachment_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountAttachmentCreateResponse()
    porcelain.account_attachment = convert_account_attachment_to_porcelain(
        plumbing.account_attachment)
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_attachment_create_response_to_plumbing(porcelain):
    plumbing = AccountAttachmentCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.account_attachment.CopyFrom(
        convert_account_attachment_to_plumbing(porcelain.account_attachment))
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_attachment_create_response_to_plumbing(
        porcelains):
    return [
        convert_account_attachment_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_attachment_create_response_to_porcelain(
        plumbings):
    return [
        convert_account_attachment_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_attachment_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountAttachmentDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_attachment_delete_response_to_plumbing(porcelain):
    plumbing = AccountAttachmentDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_attachment_delete_response_to_plumbing(
        porcelains):
    return [
        convert_account_attachment_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_attachment_delete_response_to_porcelain(
        plumbings):
    return [
        convert_account_attachment_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_attachment_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountAttachmentGetResponse()
    porcelain.account_attachment = convert_account_attachment_to_porcelain(
        plumbing.account_attachment)
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_attachment_get_response_to_plumbing(porcelain):
    plumbing = AccountAttachmentGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.account_attachment.CopyFrom(
        convert_account_attachment_to_plumbing(porcelain.account_attachment))
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_attachment_get_response_to_plumbing(porcelains):
    return [
        convert_account_attachment_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_attachment_get_response_to_porcelain(plumbings):
    return [
        convert_account_attachment_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountCreateResponse()
    porcelain.account = convert_account_to_porcelain(plumbing.account)
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.token = (plumbing.token)
    return porcelain


def convert_account_create_response_to_plumbing(porcelain):
    plumbing = AccountCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.account.CopyFrom(convert_account_to_plumbing(porcelain.account))
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.token = (porcelain.token)
    return plumbing


def convert_repeated_account_create_response_to_plumbing(porcelains):
    return [
        convert_account_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_create_response_to_porcelain(plumbings):
    return [
        convert_account_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_delete_response_to_plumbing(porcelain):
    plumbing = AccountDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_delete_response_to_plumbing(porcelains):
    return [
        convert_account_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_delete_response_to_porcelain(plumbings):
    return [
        convert_account_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountGetResponse()
    porcelain.account = convert_account_to_porcelain(plumbing.account)
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_get_response_to_plumbing(porcelain):
    plumbing = AccountGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.account.CopyFrom(convert_account_to_plumbing(porcelain.account))
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_get_response_to_plumbing(porcelains):
    return [
        convert_account_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_get_response_to_porcelain(plumbings):
    return [
        convert_account_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_grant_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountGrant()
    porcelain.account_id = (plumbing.account_id)
    porcelain.id = (plumbing.id)
    porcelain.resource_id = (plumbing.resource_id)
    porcelain.start_from = convert_timestamp_to_porcelain(plumbing.start_from)
    porcelain.valid_until = convert_timestamp_to_porcelain(
        plumbing.valid_until)
    return porcelain


def convert_account_grant_to_plumbing(porcelain):
    plumbing = AccountGrant()
    if porcelain is None:
        return plumbing
    plumbing.account_id = (porcelain.account_id)
    plumbing.id = (porcelain.id)
    plumbing.resource_id = (porcelain.resource_id)
    plumbing.start_from.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.start_from))
    plumbing.valid_until.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.valid_until))
    return plumbing


def convert_repeated_account_grant_to_plumbing(porcelains):
    return [
        convert_account_grant_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_grant_to_porcelain(plumbings):
    return [
        convert_account_grant_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_account_grant_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountGrantCreateResponse()
    porcelain.account_grant = convert_account_grant_to_porcelain(
        plumbing.account_grant)
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_grant_create_response_to_plumbing(porcelain):
    plumbing = AccountGrantCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.account_grant.CopyFrom(
        convert_account_grant_to_plumbing(porcelain.account_grant))
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_grant_create_response_to_plumbing(porcelains):
    return [
        convert_account_grant_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_grant_create_response_to_porcelain(plumbings):
    return [
        convert_account_grant_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_grant_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountGrantDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_grant_delete_response_to_plumbing(porcelain):
    plumbing = AccountGrantDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_grant_delete_response_to_plumbing(porcelains):
    return [
        convert_account_grant_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_grant_delete_response_to_porcelain(plumbings):
    return [
        convert_account_grant_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_grant_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountGrantGetResponse()
    porcelain.account_grant = convert_account_grant_to_porcelain(
        plumbing.account_grant)
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_grant_get_response_to_plumbing(porcelain):
    plumbing = AccountGrantGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.account_grant.CopyFrom(
        convert_account_grant_to_plumbing(porcelain.account_grant))
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_grant_get_response_to_plumbing(porcelains):
    return [
        convert_account_grant_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_grant_get_response_to_porcelain(plumbings):
    return [
        convert_account_grant_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountUpdateResponse()
    porcelain.account = convert_account_to_porcelain(plumbing.account)
    porcelain.meta = convert_update_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_update_response_to_plumbing(porcelain):
    plumbing = AccountUpdateResponse()
    if porcelain is None:
        return plumbing
    plumbing.account.CopyFrom(convert_account_to_plumbing(porcelain.account))
    plumbing.meta.CopyFrom(
        convert_update_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_update_response_to_plumbing(porcelains):
    return [
        convert_account_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_update_response_to_porcelain(plumbings):
    return [
        convert_account_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_amazon_eks_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AmazonEKS()
    porcelain.access_key = (plumbing.access_key)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.cluster_name = (plumbing.cluster_name)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.region = (plumbing.region)
    porcelain.remote_identity_group_id = (plumbing.remote_identity_group_id)
    porcelain.remote_identity_healthcheck_username = (
        plumbing.remote_identity_healthcheck_username)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_amazon_eks_to_plumbing(porcelain):
    plumbing = AmazonEKS()
    if porcelain is None:
        return plumbing
    plumbing.access_key = (porcelain.access_key)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.cluster_name = (porcelain.cluster_name)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.region = (porcelain.region)
    plumbing.remote_identity_group_id = (porcelain.remote_identity_group_id)
    plumbing.remote_identity_healthcheck_username = (
        porcelain.remote_identity_healthcheck_username)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_access_key = (porcelain.secret_access_key)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_amazon_eks_to_plumbing(porcelains):
    return [
        convert_amazon_eks_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_amazon_eks_to_porcelain(plumbings):
    return [
        convert_amazon_eks_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_amazon_eks_instance_profile_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AmazonEKSInstanceProfile()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.cluster_name = (plumbing.cluster_name)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.region = (plumbing.region)
    porcelain.remote_identity_group_id = (plumbing.remote_identity_group_id)
    porcelain.remote_identity_healthcheck_username = (
        plumbing.remote_identity_healthcheck_username)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_amazon_eks_instance_profile_to_plumbing(porcelain):
    plumbing = AmazonEKSInstanceProfile()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.cluster_name = (porcelain.cluster_name)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.region = (porcelain.region)
    plumbing.remote_identity_group_id = (porcelain.remote_identity_group_id)
    plumbing.remote_identity_healthcheck_username = (
        porcelain.remote_identity_healthcheck_username)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_amazon_eks_instance_profile_to_plumbing(porcelains):
    return [
        convert_amazon_eks_instance_profile_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_amazon_eks_instance_profile_to_porcelain(plumbings):
    return [
        convert_amazon_eks_instance_profile_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_amazon_eks_user_impersonation_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AmazonEKSUserImpersonation()
    porcelain.access_key = (plumbing.access_key)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.cluster_name = (plumbing.cluster_name)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_amazon_eks_user_impersonation_to_plumbing(porcelain):
    plumbing = AmazonEKSUserImpersonation()
    if porcelain is None:
        return plumbing
    plumbing.access_key = (porcelain.access_key)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.cluster_name = (porcelain.cluster_name)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.region = (porcelain.region)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_access_key = (porcelain.secret_access_key)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_amazon_eks_user_impersonation_to_plumbing(porcelains):
    return [
        convert_amazon_eks_user_impersonation_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_amazon_eks_user_impersonation_to_porcelain(plumbings):
    return [
        convert_amazon_eks_user_impersonation_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_amazon_es_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AmazonES()
    porcelain.access_key = (plumbing.access_key)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_amazon_es_to_plumbing(porcelain):
    plumbing = AmazonES()
    if porcelain is None:
        return plumbing
    plumbing.access_key = (porcelain.access_key)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.region = (porcelain.region)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_access_key = (porcelain.secret_access_key)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_amazon_es_to_plumbing(porcelains):
    return [
        convert_amazon_es_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_amazon_es_to_porcelain(plumbings):
    return [convert_amazon_es_to_porcelain(plumbing) for plumbing in plumbings]


def convert_amazon_mqamqp_091_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AmazonMQAMQP091()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_amazon_mqamqp_091_to_plumbing(porcelain):
    plumbing = AmazonMQAMQP091()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_amazon_mqamqp_091_to_plumbing(porcelains):
    return [
        convert_amazon_mqamqp_091_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_amazon_mqamqp_091_to_porcelain(plumbings):
    return [
        convert_amazon_mqamqp_091_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_athena_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Athena()
    porcelain.access_key = (plumbing.access_key)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.output = (plumbing.output)
    porcelain.port_override = (plumbing.port_override)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_athena_to_plumbing(porcelain):
    plumbing = Athena()
    if porcelain is None:
        return plumbing
    plumbing.access_key = (porcelain.access_key)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.output = (porcelain.output)
    plumbing.port_override = (porcelain.port_override)
    plumbing.region = (porcelain.region)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_access_key = (porcelain.secret_access_key)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_athena_to_plumbing(porcelains):
    return [convert_athena_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_athena_to_porcelain(plumbings):
    return [convert_athena_to_porcelain(plumbing) for plumbing in plumbings]


def convert_aurora_mysql_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AuroraMysql()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_aurora_mysql_to_plumbing(porcelain):
    plumbing = AuroraMysql()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_aurora_mysql_to_plumbing(porcelains):
    return [
        convert_aurora_mysql_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_aurora_mysql_to_porcelain(plumbings):
    return [
        convert_aurora_mysql_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_aurora_postgres_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AuroraPostgres()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_aurora_postgres_to_plumbing(porcelain):
    plumbing = AuroraPostgres()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_aurora_postgres_to_plumbing(porcelains):
    return [
        convert_aurora_postgres_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_aurora_postgres_to_porcelain(plumbings):
    return [
        convert_aurora_postgres_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_azure_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Azure()
    porcelain.app_id = (plumbing.app_id)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tenant_id = (plumbing.tenant_id)
    return porcelain


def convert_azure_to_plumbing(porcelain):
    plumbing = Azure()
    if porcelain is None:
        return plumbing
    plumbing.app_id = (porcelain.app_id)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tenant_id = (porcelain.tenant_id)
    return plumbing


def convert_repeated_azure_to_plumbing(porcelains):
    return [convert_azure_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_azure_to_porcelain(plumbings):
    return [convert_azure_to_porcelain(plumbing) for plumbing in plumbings]


def convert_azure_certificate_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AzureCertificate()
    porcelain.app_id = (plumbing.app_id)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.client_certificate = (plumbing.client_certificate)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tenant_id = (plumbing.tenant_id)
    return porcelain


def convert_azure_certificate_to_plumbing(porcelain):
    plumbing = AzureCertificate()
    if porcelain is None:
        return plumbing
    plumbing.app_id = (porcelain.app_id)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.client_certificate = (porcelain.client_certificate)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tenant_id = (porcelain.tenant_id)
    return plumbing


def convert_repeated_azure_certificate_to_plumbing(porcelains):
    return [
        convert_azure_certificate_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_azure_certificate_to_porcelain(plumbings):
    return [
        convert_azure_certificate_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_azure_mysql_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AzureMysql()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_azure_mysql_to_plumbing(porcelain):
    plumbing = AzureMysql()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_azure_mysql_to_plumbing(porcelains):
    return [
        convert_azure_mysql_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_azure_mysql_to_porcelain(plumbings):
    return [
        convert_azure_mysql_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_azure_postgres_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AzurePostgres()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_azure_postgres_to_plumbing(porcelain):
    plumbing = AzurePostgres()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_azure_postgres_to_plumbing(porcelains):
    return [
        convert_azure_postgres_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_azure_postgres_to_porcelain(plumbings):
    return [
        convert_azure_postgres_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_azure_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AzureStore()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.vault_uri = (plumbing.vault_uri)
    return porcelain


def convert_azure_store_to_plumbing(porcelain):
    plumbing = AzureStore()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.vault_uri = (porcelain.vault_uri)
    return plumbing


def convert_repeated_azure_store_to_plumbing(porcelains):
    return [
        convert_azure_store_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_azure_store_to_porcelain(plumbings):
    return [
        convert_azure_store_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_big_query_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.BigQuery()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.private_key = (plumbing.private_key)
    porcelain.project = (plumbing.project)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_big_query_to_plumbing(porcelain):
    plumbing = BigQuery()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.private_key = (porcelain.private_key)
    plumbing.project = (porcelain.project)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_big_query_to_plumbing(porcelains):
    return [
        convert_big_query_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_big_query_to_porcelain(plumbings):
    return [convert_big_query_to_porcelain(plumbing) for plumbing in plumbings]


def convert_cassandra_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Cassandra()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_cassandra_to_plumbing(porcelain):
    plumbing = Cassandra()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_cassandra_to_plumbing(porcelains):
    return [
        convert_cassandra_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_cassandra_to_porcelain(plumbings):
    return [convert_cassandra_to_porcelain(plumbing) for plumbing in plumbings]


def convert_citus_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Citus()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_citus_to_plumbing(porcelain):
    plumbing = Citus()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_citus_to_plumbing(porcelains):
    return [convert_citus_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_citus_to_porcelain(plumbings):
    return [convert_citus_to_porcelain(plumbing) for plumbing in plumbings]


def convert_clustrix_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Clustrix()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_clustrix_to_plumbing(porcelain):
    plumbing = Clustrix()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_clustrix_to_plumbing(porcelains):
    return [
        convert_clustrix_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_clustrix_to_porcelain(plumbings):
    return [convert_clustrix_to_porcelain(plumbing) for plumbing in plumbings]


def convert_cockroach_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Cockroach()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_cockroach_to_plumbing(porcelain):
    plumbing = Cockroach()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_cockroach_to_plumbing(porcelains):
    return [
        convert_cockroach_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_cockroach_to_porcelain(plumbings):
    return [convert_cockroach_to_porcelain(plumbing) for plumbing in plumbings]


def convert_control_panel_get_sshca_public_key_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ControlPanelGetSSHCAPublicKeyResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.public_key = (plumbing.public_key)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_control_panel_get_sshca_public_key_response_to_plumbing(porcelain):
    plumbing = ControlPanelGetSSHCAPublicKeyResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.public_key = (porcelain.public_key)
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_control_panel_get_sshca_public_key_response_to_plumbing(
        porcelains):
    return [
        convert_control_panel_get_sshca_public_key_response_to_plumbing(
            porcelain) for porcelain in porcelains
    ]


def convert_repeated_control_panel_get_sshca_public_key_response_to_porcelain(
        plumbings):
    return [
        convert_control_panel_get_sshca_public_key_response_to_porcelain(
            plumbing) for plumbing in plumbings
    ]


def convert_control_panel_verify_jwt_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ControlPanelVerifyJWTResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.valid = (plumbing.valid)
    return porcelain


def convert_control_panel_verify_jwt_response_to_plumbing(porcelain):
    plumbing = ControlPanelVerifyJWTResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.valid = (porcelain.valid)
    return plumbing


def convert_repeated_control_panel_verify_jwt_response_to_plumbing(porcelains):
    return [
        convert_control_panel_verify_jwt_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_control_panel_verify_jwt_response_to_porcelain(plumbings):
    return [
        convert_control_panel_verify_jwt_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_create_response_metadata_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.CreateResponseMetadata()
    return porcelain


def convert_create_response_metadata_to_plumbing(porcelain):
    plumbing = CreateResponseMetadata()
    if porcelain is None:
        return plumbing
    return plumbing


def convert_repeated_create_response_metadata_to_plumbing(porcelains):
    return [
        convert_create_response_metadata_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_create_response_metadata_to_porcelain(plumbings):
    return [
        convert_create_response_metadata_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_cyberark_conjur_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.CyberarkConjurStore()
    porcelain.appurl = (plumbing.appURL)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_cyberark_conjur_store_to_plumbing(porcelain):
    plumbing = CyberarkConjurStore()
    if porcelain is None:
        return plumbing
    plumbing.appURL = (porcelain.appurl)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_cyberark_conjur_store_to_plumbing(porcelains):
    return [
        convert_cyberark_conjur_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_cyberark_conjur_store_to_porcelain(plumbings):
    return [
        convert_cyberark_conjur_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_cyberark_pam_experimental_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.CyberarkPAMExperimentalStore()
    porcelain.appurl = (plumbing.appURL)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_cyberark_pam_experimental_store_to_plumbing(porcelain):
    plumbing = CyberarkPAMExperimentalStore()
    if porcelain is None:
        return plumbing
    plumbing.appURL = (porcelain.appurl)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_cyberark_pam_experimental_store_to_plumbing(porcelains):
    return [
        convert_cyberark_pam_experimental_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_cyberark_pam_experimental_store_to_porcelain(plumbings):
    return [
        convert_cyberark_pam_experimental_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_cyberark_pam_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.CyberarkPAMStore()
    porcelain.appurl = (plumbing.appURL)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_cyberark_pam_store_to_plumbing(porcelain):
    plumbing = CyberarkPAMStore()
    if porcelain is None:
        return plumbing
    plumbing.appURL = (porcelain.appurl)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_cyberark_pam_store_to_plumbing(porcelains):
    return [
        convert_cyberark_pam_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_cyberark_pam_store_to_porcelain(plumbings):
    return [
        convert_cyberark_pam_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_db_2_i_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DB2I()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_db_2_i_to_plumbing(porcelain):
    plumbing = DB2I()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_db_2_i_to_plumbing(porcelains):
    return [convert_db_2_i_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_db_2_i_to_porcelain(plumbings):
    return [convert_db_2_i_to_porcelain(plumbing) for plumbing in plumbings]


def convert_db_2_luw_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DB2LUW()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_db_2_luw_to_plumbing(porcelain):
    plumbing = DB2LUW()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_db_2_luw_to_plumbing(porcelains):
    return [
        convert_db_2_luw_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_db_2_luw_to_porcelain(plumbings):
    return [convert_db_2_luw_to_porcelain(plumbing) for plumbing in plumbings]


def convert_delete_response_metadata_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DeleteResponseMetadata()
    return porcelain


def convert_delete_response_metadata_to_plumbing(porcelain):
    plumbing = DeleteResponseMetadata()
    if porcelain is None:
        return plumbing
    return plumbing


def convert_repeated_delete_response_metadata_to_plumbing(porcelains):
    return [
        convert_delete_response_metadata_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_delete_response_metadata_to_porcelain(plumbings):
    return [
        convert_delete_response_metadata_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_delinea_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DelineaStore()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.server_url = (plumbing.server_url)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tenant_name = (plumbing.tenant_name)
    return porcelain


def convert_delinea_store_to_plumbing(porcelain):
    plumbing = DelineaStore()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.server_url = (porcelain.server_url)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tenant_name = (porcelain.tenant_name)
    return plumbing


def convert_repeated_delinea_store_to_plumbing(porcelains):
    return [
        convert_delinea_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_delinea_store_to_porcelain(plumbings):
    return [
        convert_delinea_store_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_document_db_host_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DocumentDBHost()
    porcelain.auth_database = (plumbing.auth_database)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_document_db_host_to_plumbing(porcelain):
    plumbing = DocumentDBHost()
    if porcelain is None:
        return plumbing
    plumbing.auth_database = (porcelain.auth_database)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_document_db_host_to_plumbing(porcelains):
    return [
        convert_document_db_host_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_document_db_host_to_porcelain(plumbings):
    return [
        convert_document_db_host_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_document_db_replica_set_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DocumentDBReplicaSet()
    porcelain.auth_database = (plumbing.auth_database)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.connect_to_replica = (plumbing.connect_to_replica)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port_override = (plumbing.port_override)
    porcelain.replica_set = (plumbing.replica_set)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_document_db_replica_set_to_plumbing(porcelain):
    plumbing = DocumentDBReplicaSet()
    if porcelain is None:
        return plumbing
    plumbing.auth_database = (porcelain.auth_database)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.connect_to_replica = (porcelain.connect_to_replica)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port_override = (porcelain.port_override)
    plumbing.replica_set = (porcelain.replica_set)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_document_db_replica_set_to_plumbing(porcelains):
    return [
        convert_document_db_replica_set_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_document_db_replica_set_to_porcelain(plumbings):
    return [
        convert_document_db_replica_set_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_druid_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Druid()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_druid_to_plumbing(porcelain):
    plumbing = Druid()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_druid_to_plumbing(porcelains):
    return [convert_druid_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_druid_to_porcelain(plumbings):
    return [convert_druid_to_porcelain(plumbing) for plumbing in plumbings]


def convert_dynamo_db_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DynamoDB()
    porcelain.access_key = (plumbing.access_key)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_dynamo_db_to_plumbing(porcelain):
    plumbing = DynamoDB()
    if porcelain is None:
        return plumbing
    plumbing.access_key = (porcelain.access_key)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.region = (porcelain.region)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_access_key = (porcelain.secret_access_key)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_dynamo_db_to_plumbing(porcelains):
    return [
        convert_dynamo_db_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_dynamo_db_to_porcelain(plumbings):
    return [convert_dynamo_db_to_porcelain(plumbing) for plumbing in plumbings]


def convert_elastic_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Elastic()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_elastic_to_plumbing(porcelain):
    plumbing = Elastic()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_elastic_to_plumbing(porcelains):
    return [convert_elastic_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_elastic_to_porcelain(plumbings):
    return [convert_elastic_to_porcelain(plumbing) for plumbing in plumbings]


def convert_elasticache_redis_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ElasticacheRedis()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_elasticache_redis_to_plumbing(porcelain):
    plumbing = ElasticacheRedis()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_elasticache_redis_to_plumbing(porcelains):
    return [
        convert_elasticache_redis_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_elasticache_redis_to_porcelain(plumbings):
    return [
        convert_elasticache_redis_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_gcp_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.GCP()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.keyfile = (plumbing.keyfile)
    porcelain.name = (plumbing.name)
    porcelain.scopes = (plumbing.scopes)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_gcp_to_plumbing(porcelain):
    plumbing = GCP()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.keyfile = (porcelain.keyfile)
    plumbing.name = (porcelain.name)
    plumbing.scopes = (porcelain.scopes)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_gcp_to_plumbing(porcelains):
    return [convert_gcp_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_gcp_to_porcelain(plumbings):
    return [convert_gcp_to_porcelain(plumbing) for plumbing in plumbings]


def convert_gcp_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.GCPStore()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.projectid = (plumbing.projectID)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_gcp_store_to_plumbing(porcelain):
    plumbing = GCPStore()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.projectID = (porcelain.projectid)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_gcp_store_to_plumbing(porcelains):
    return [
        convert_gcp_store_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_gcp_store_to_porcelain(plumbings):
    return [convert_gcp_store_to_porcelain(plumbing) for plumbing in plumbings]


def convert_gateway_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Gateway()
    porcelain.bind_address = (plumbing.bind_address)
    porcelain.device = (plumbing.device)
    porcelain.gateway_filter = (plumbing.gateway_filter)
    porcelain.id = (plumbing.id)
    porcelain.listen_address = (plumbing.listen_address)
    porcelain.location = (plumbing.location)
    porcelain.name = (plumbing.name)
    porcelain.state = (plumbing.state)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.version = (plumbing.version)
    return porcelain


def convert_gateway_to_plumbing(porcelain):
    plumbing = Gateway()
    if porcelain is None:
        return plumbing
    plumbing.bind_address = (porcelain.bind_address)
    plumbing.device = (porcelain.device)
    plumbing.gateway_filter = (porcelain.gateway_filter)
    plumbing.id = (porcelain.id)
    plumbing.listen_address = (porcelain.listen_address)
    plumbing.location = (porcelain.location)
    plumbing.name = (porcelain.name)
    plumbing.state = (porcelain.state)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.version = (porcelain.version)
    return plumbing


def convert_repeated_gateway_to_plumbing(porcelains):
    return [convert_gateway_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_gateway_to_porcelain(plumbings):
    return [convert_gateway_to_porcelain(plumbing) for plumbing in plumbings]


def convert_get_response_metadata_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.GetResponseMetadata()
    return porcelain


def convert_get_response_metadata_to_plumbing(porcelain):
    plumbing = GetResponseMetadata()
    if porcelain is None:
        return plumbing
    return plumbing


def convert_repeated_get_response_metadata_to_plumbing(porcelains):
    return [
        convert_get_response_metadata_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_get_response_metadata_to_porcelain(plumbings):
    return [
        convert_get_response_metadata_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_google_gke_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.GoogleGKE()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.remote_identity_group_id = (plumbing.remote_identity_group_id)
    porcelain.remote_identity_healthcheck_username = (
        plumbing.remote_identity_healthcheck_username)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.service_account_key = (plumbing.service_account_key)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_google_gke_to_plumbing(porcelain):
    plumbing = GoogleGKE()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.remote_identity_group_id = (porcelain.remote_identity_group_id)
    plumbing.remote_identity_healthcheck_username = (
        porcelain.remote_identity_healthcheck_username)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.service_account_key = (porcelain.service_account_key)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_google_gke_to_plumbing(porcelains):
    return [
        convert_google_gke_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_google_gke_to_porcelain(plumbings):
    return [
        convert_google_gke_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_google_gke_user_impersonation_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.GoogleGKEUserImpersonation()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.service_account_key = (plumbing.service_account_key)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_google_gke_user_impersonation_to_plumbing(porcelain):
    plumbing = GoogleGKEUserImpersonation()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.service_account_key = (porcelain.service_account_key)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_google_gke_user_impersonation_to_plumbing(porcelains):
    return [
        convert_google_gke_user_impersonation_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_google_gke_user_impersonation_to_porcelain(plumbings):
    return [
        convert_google_gke_user_impersonation_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_greenplum_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Greenplum()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_greenplum_to_plumbing(porcelain):
    plumbing = Greenplum()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_greenplum_to_plumbing(porcelains):
    return [
        convert_greenplum_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_greenplum_to_porcelain(plumbings):
    return [convert_greenplum_to_porcelain(plumbing) for plumbing in plumbings]


def convert_http_auth_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.HTTPAuth()
    porcelain.auth_header = (plumbing.auth_header)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.default_path = (plumbing.default_path)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.headers_blacklist = (plumbing.headers_blacklist)
    porcelain.healthcheck_path = (plumbing.healthcheck_path)
    porcelain.healthy = (plumbing.healthy)
    porcelain.host_override = (plumbing.host_override)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.url = (plumbing.url)
    return porcelain


def convert_http_auth_to_plumbing(porcelain):
    plumbing = HTTPAuth()
    if porcelain is None:
        return plumbing
    plumbing.auth_header = (porcelain.auth_header)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.default_path = (porcelain.default_path)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.headers_blacklist = (porcelain.headers_blacklist)
    plumbing.healthcheck_path = (porcelain.healthcheck_path)
    plumbing.healthy = (porcelain.healthy)
    plumbing.host_override = (porcelain.host_override)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.url = (porcelain.url)
    return plumbing


def convert_repeated_http_auth_to_plumbing(porcelains):
    return [
        convert_http_auth_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_http_auth_to_porcelain(plumbings):
    return [convert_http_auth_to_porcelain(plumbing) for plumbing in plumbings]


def convert_http_basic_auth_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.HTTPBasicAuth()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.default_path = (plumbing.default_path)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.headers_blacklist = (plumbing.headers_blacklist)
    porcelain.healthcheck_path = (plumbing.healthcheck_path)
    porcelain.healthy = (plumbing.healthy)
    porcelain.host_override = (plumbing.host_override)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.url = (plumbing.url)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_http_basic_auth_to_plumbing(porcelain):
    plumbing = HTTPBasicAuth()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.default_path = (porcelain.default_path)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.headers_blacklist = (porcelain.headers_blacklist)
    plumbing.healthcheck_path = (porcelain.healthcheck_path)
    plumbing.healthy = (porcelain.healthy)
    plumbing.host_override = (porcelain.host_override)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.url = (porcelain.url)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_http_basic_auth_to_plumbing(porcelains):
    return [
        convert_http_basic_auth_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_http_basic_auth_to_porcelain(plumbings):
    return [
        convert_http_basic_auth_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_http_no_auth_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.HTTPNoAuth()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.default_path = (plumbing.default_path)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.headers_blacklist = (plumbing.headers_blacklist)
    porcelain.healthcheck_path = (plumbing.healthcheck_path)
    porcelain.healthy = (plumbing.healthy)
    porcelain.host_override = (plumbing.host_override)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.url = (plumbing.url)
    return porcelain


def convert_http_no_auth_to_plumbing(porcelain):
    plumbing = HTTPNoAuth()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.default_path = (porcelain.default_path)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.headers_blacklist = (porcelain.headers_blacklist)
    plumbing.healthcheck_path = (porcelain.healthcheck_path)
    plumbing.healthy = (porcelain.healthy)
    plumbing.host_override = (porcelain.host_override)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.url = (porcelain.url)
    return plumbing


def convert_repeated_http_no_auth_to_plumbing(porcelains):
    return [
        convert_http_no_auth_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_http_no_auth_to_porcelain(plumbings):
    return [
        convert_http_no_auth_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_kubernetes_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Kubernetes()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.client_certificate = (plumbing.client_certificate)
    porcelain.client_key = (plumbing.client_key)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.remote_identity_group_id = (plumbing.remote_identity_group_id)
    porcelain.remote_identity_healthcheck_username = (
        plumbing.remote_identity_healthcheck_username)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_kubernetes_to_plumbing(porcelain):
    plumbing = Kubernetes()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.client_certificate = (porcelain.client_certificate)
    plumbing.client_key = (porcelain.client_key)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.remote_identity_group_id = (porcelain.remote_identity_group_id)
    plumbing.remote_identity_healthcheck_username = (
        porcelain.remote_identity_healthcheck_username)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_kubernetes_to_plumbing(porcelains):
    return [
        convert_kubernetes_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_kubernetes_to_porcelain(plumbings):
    return [
        convert_kubernetes_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_kubernetes_basic_auth_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.KubernetesBasicAuth()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_kubernetes_basic_auth_to_plumbing(porcelain):
    plumbing = KubernetesBasicAuth()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_kubernetes_basic_auth_to_plumbing(porcelains):
    return [
        convert_kubernetes_basic_auth_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_kubernetes_basic_auth_to_porcelain(plumbings):
    return [
        convert_kubernetes_basic_auth_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_kubernetes_service_account_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.KubernetesServiceAccount()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.remote_identity_group_id = (plumbing.remote_identity_group_id)
    porcelain.remote_identity_healthcheck_username = (
        plumbing.remote_identity_healthcheck_username)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.token = (plumbing.token)
    return porcelain


def convert_kubernetes_service_account_to_plumbing(porcelain):
    plumbing = KubernetesServiceAccount()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.remote_identity_group_id = (porcelain.remote_identity_group_id)
    plumbing.remote_identity_healthcheck_username = (
        porcelain.remote_identity_healthcheck_username)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.token = (porcelain.token)
    return plumbing


def convert_repeated_kubernetes_service_account_to_plumbing(porcelains):
    return [
        convert_kubernetes_service_account_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_kubernetes_service_account_to_porcelain(plumbings):
    return [
        convert_kubernetes_service_account_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_kubernetes_service_account_user_impersonation_to_porcelain(
        plumbing):
    if plumbing is None:
        return None
    porcelain = models.KubernetesServiceAccountUserImpersonation()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.token = (plumbing.token)
    return porcelain


def convert_kubernetes_service_account_user_impersonation_to_plumbing(
        porcelain):
    plumbing = KubernetesServiceAccountUserImpersonation()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.token = (porcelain.token)
    return plumbing


def convert_repeated_kubernetes_service_account_user_impersonation_to_plumbing(
        porcelains):
    return [
        convert_kubernetes_service_account_user_impersonation_to_plumbing(
            porcelain) for porcelain in porcelains
    ]


def convert_repeated_kubernetes_service_account_user_impersonation_to_porcelain(
        plumbings):
    return [
        convert_kubernetes_service_account_user_impersonation_to_porcelain(
            plumbing) for plumbing in plumbings
    ]


def convert_kubernetes_user_impersonation_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.KubernetesUserImpersonation()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.client_certificate = (plumbing.client_certificate)
    porcelain.client_key = (plumbing.client_key)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_kubernetes_user_impersonation_to_plumbing(porcelain):
    plumbing = KubernetesUserImpersonation()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.client_certificate = (porcelain.client_certificate)
    plumbing.client_key = (porcelain.client_key)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_kubernetes_user_impersonation_to_plumbing(porcelains):
    return [
        convert_kubernetes_user_impersonation_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_kubernetes_user_impersonation_to_porcelain(plumbings):
    return [
        convert_kubernetes_user_impersonation_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_mtls_mysql_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.MTLSMysql()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.client_certificate = (plumbing.client_certificate)
    porcelain.client_key = (plumbing.client_key)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.server_name = (plumbing.server_name)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_mtls_mysql_to_plumbing(porcelain):
    plumbing = MTLSMysql()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.client_certificate = (porcelain.client_certificate)
    plumbing.client_key = (porcelain.client_key)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.server_name = (porcelain.server_name)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_mtls_mysql_to_plumbing(porcelains):
    return [
        convert_mtls_mysql_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_mtls_mysql_to_porcelain(plumbings):
    return [
        convert_mtls_mysql_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_mtls_postgres_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.MTLSPostgres()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.client_certificate = (plumbing.client_certificate)
    porcelain.client_key = (plumbing.client_key)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.server_name = (plumbing.server_name)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_mtls_postgres_to_plumbing(porcelain):
    plumbing = MTLSPostgres()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.client_certificate = (porcelain.client_certificate)
    plumbing.client_key = (porcelain.client_key)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.server_name = (porcelain.server_name)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_mtls_postgres_to_plumbing(porcelains):
    return [
        convert_mtls_postgres_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_mtls_postgres_to_porcelain(plumbings):
    return [
        convert_mtls_postgres_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_maria_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Maria()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_maria_to_plumbing(porcelain):
    plumbing = Maria()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_maria_to_plumbing(porcelains):
    return [convert_maria_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_maria_to_porcelain(plumbings):
    return [convert_maria_to_porcelain(plumbing) for plumbing in plumbings]


def convert_memcached_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Memcached()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_memcached_to_plumbing(porcelain):
    plumbing = Memcached()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_memcached_to_plumbing(porcelains):
    return [
        convert_memcached_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_memcached_to_porcelain(plumbings):
    return [convert_memcached_to_porcelain(plumbing) for plumbing in plumbings]


def convert_memsql_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Memsql()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_memsql_to_plumbing(porcelain):
    plumbing = Memsql()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_memsql_to_plumbing(porcelains):
    return [convert_memsql_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_memsql_to_porcelain(plumbings):
    return [convert_memsql_to_porcelain(plumbing) for plumbing in plumbings]


def convert_mongo_host_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.MongoHost()
    porcelain.auth_database = (plumbing.auth_database)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_mongo_host_to_plumbing(porcelain):
    plumbing = MongoHost()
    if porcelain is None:
        return plumbing
    plumbing.auth_database = (porcelain.auth_database)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_mongo_host_to_plumbing(porcelains):
    return [
        convert_mongo_host_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_mongo_host_to_porcelain(plumbings):
    return [
        convert_mongo_host_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_mongo_legacy_host_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.MongoLegacyHost()
    porcelain.auth_database = (plumbing.auth_database)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.replica_set = (plumbing.replica_set)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_mongo_legacy_host_to_plumbing(porcelain):
    plumbing = MongoLegacyHost()
    if porcelain is None:
        return plumbing
    plumbing.auth_database = (porcelain.auth_database)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.replica_set = (porcelain.replica_set)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_mongo_legacy_host_to_plumbing(porcelains):
    return [
        convert_mongo_legacy_host_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_mongo_legacy_host_to_porcelain(plumbings):
    return [
        convert_mongo_legacy_host_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_mongo_legacy_replicaset_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.MongoLegacyReplicaset()
    porcelain.auth_database = (plumbing.auth_database)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.connect_to_replica = (plumbing.connect_to_replica)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.replica_set = (plumbing.replica_set)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_mongo_legacy_replicaset_to_plumbing(porcelain):
    plumbing = MongoLegacyReplicaset()
    if porcelain is None:
        return plumbing
    plumbing.auth_database = (porcelain.auth_database)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.connect_to_replica = (porcelain.connect_to_replica)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.replica_set = (porcelain.replica_set)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_mongo_legacy_replicaset_to_plumbing(porcelains):
    return [
        convert_mongo_legacy_replicaset_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_mongo_legacy_replicaset_to_porcelain(plumbings):
    return [
        convert_mongo_legacy_replicaset_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_mongo_replica_set_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.MongoReplicaSet()
    porcelain.auth_database = (plumbing.auth_database)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.connect_to_replica = (plumbing.connect_to_replica)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.replica_set = (plumbing.replica_set)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_mongo_replica_set_to_plumbing(porcelain):
    plumbing = MongoReplicaSet()
    if porcelain is None:
        return plumbing
    plumbing.auth_database = (porcelain.auth_database)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.connect_to_replica = (porcelain.connect_to_replica)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.replica_set = (porcelain.replica_set)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_mongo_replica_set_to_plumbing(porcelains):
    return [
        convert_mongo_replica_set_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_mongo_replica_set_to_porcelain(plumbings):
    return [
        convert_mongo_replica_set_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_mongo_sharded_cluster_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.MongoShardedCluster()
    porcelain.auth_database = (plumbing.auth_database)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_mongo_sharded_cluster_to_plumbing(porcelain):
    plumbing = MongoShardedCluster()
    if porcelain is None:
        return plumbing
    plumbing.auth_database = (porcelain.auth_database)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_mongo_sharded_cluster_to_plumbing(porcelains):
    return [
        convert_mongo_sharded_cluster_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_mongo_sharded_cluster_to_porcelain(plumbings):
    return [
        convert_mongo_sharded_cluster_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_mysql_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Mysql()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_mysql_to_plumbing(porcelain):
    plumbing = Mysql()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_mysql_to_plumbing(porcelains):
    return [convert_mysql_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_mysql_to_porcelain(plumbings):
    return [convert_mysql_to_porcelain(plumbing) for plumbing in plumbings]


def convert_neptune_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Neptune()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_neptune_to_plumbing(porcelain):
    plumbing = Neptune()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_neptune_to_plumbing(porcelains):
    return [convert_neptune_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_neptune_to_porcelain(plumbings):
    return [convert_neptune_to_porcelain(plumbing) for plumbing in plumbings]


def convert_neptune_iam_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.NeptuneIAM()
    porcelain.access_key = (plumbing.access_key)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_neptune_iam_to_plumbing(porcelain):
    plumbing = NeptuneIAM()
    if porcelain is None:
        return plumbing
    plumbing.access_key = (porcelain.access_key)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.region = (porcelain.region)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_access_key = (porcelain.secret_access_key)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_neptune_iam_to_plumbing(porcelains):
    return [
        convert_neptune_iam_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_neptune_iam_to_porcelain(plumbings):
    return [
        convert_neptune_iam_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_node_to_plumbing(porcelain):
    plumbing = Node()
    if porcelain is None:
        return plumbing
    if isinstance(porcelain, models.Gateway):
        plumbing.gateway.CopyFrom(convert_gateway_to_plumbing(porcelain))
    if isinstance(porcelain, models.Relay):
        plumbing.relay.CopyFrom(convert_relay_to_plumbing(porcelain))
    return plumbing


def convert_node_to_porcelain(plumbing):
    if plumbing is None:
        return None
    if plumbing.HasField('gateway'):
        return convert_gateway_to_porcelain(plumbing.gateway)
    if plumbing.HasField('relay'):
        return convert_relay_to_porcelain(plumbing.relay)
    raise errors.UnknownError(
        "unknown polymorphic type, please upgrade your SDK")


def convert_repeated_node_to_plumbing(porcelains):
    return [convert_node_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_node_to_porcelain(plumbings):
    return [convert_node_to_porcelain(plumbing) for plumbing in plumbings]


def convert_node_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.NodeCreateResponse()
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.node = convert_node_to_porcelain(plumbing.node)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.token = (plumbing.token)
    return porcelain


def convert_node_create_response_to_plumbing(porcelain):
    plumbing = NodeCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.node.CopyFrom(convert_node_to_plumbing(porcelain.node))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.token = (porcelain.token)
    return plumbing


def convert_repeated_node_create_response_to_plumbing(porcelains):
    return [
        convert_node_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_node_create_response_to_porcelain(plumbings):
    return [
        convert_node_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_node_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.NodeDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_node_delete_response_to_plumbing(porcelain):
    plumbing = NodeDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_node_delete_response_to_plumbing(porcelains):
    return [
        convert_node_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_node_delete_response_to_porcelain(plumbings):
    return [
        convert_node_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_node_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.NodeGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.node = convert_node_to_porcelain(plumbing.node)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_node_get_response_to_plumbing(porcelain):
    plumbing = NodeGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.node.CopyFrom(convert_node_to_plumbing(porcelain.node))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_node_get_response_to_plumbing(porcelains):
    return [
        convert_node_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_node_get_response_to_porcelain(plumbings):
    return [
        convert_node_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_node_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.NodeUpdateResponse()
    porcelain.meta = convert_update_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.node = convert_node_to_porcelain(plumbing.node)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_node_update_response_to_plumbing(porcelain):
    plumbing = NodeUpdateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_update_response_metadata_to_plumbing(porcelain.meta))
    plumbing.node.CopyFrom(convert_node_to_plumbing(porcelain.node))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_node_update_response_to_plumbing(porcelains):
    return [
        convert_node_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_node_update_response_to_porcelain(plumbings):
    return [
        convert_node_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_oracle_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Oracle()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_oracle_to_plumbing(porcelain):
    plumbing = Oracle()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_oracle_to_plumbing(porcelains):
    return [convert_oracle_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_oracle_to_porcelain(plumbings):
    return [convert_oracle_to_porcelain(plumbing) for plumbing in plumbings]


def convert_postgres_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Postgres()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_postgres_to_plumbing(porcelain):
    plumbing = Postgres()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_postgres_to_plumbing(porcelains):
    return [
        convert_postgres_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_postgres_to_porcelain(plumbings):
    return [convert_postgres_to_porcelain(plumbing) for plumbing in plumbings]


def convert_presto_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Presto()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_presto_to_plumbing(porcelain):
    plumbing = Presto()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_presto_to_plumbing(porcelains):
    return [convert_presto_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_presto_to_porcelain(plumbings):
    return [convert_presto_to_porcelain(plumbing) for plumbing in plumbings]


def convert_rdp_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RDP()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.downgrade_nla_connections = (plumbing.downgrade_nla_connections)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_rdp_to_plumbing(porcelain):
    plumbing = RDP()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.downgrade_nla_connections = (porcelain.downgrade_nla_connections)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_rdp_to_plumbing(porcelains):
    return [convert_rdp_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_rdp_to_porcelain(plumbings):
    return [convert_rdp_to_porcelain(plumbing) for plumbing in plumbings]


def convert_rabbit_mqamqp_091_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RabbitMQAMQP091()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_rabbit_mqamqp_091_to_plumbing(porcelain):
    plumbing = RabbitMQAMQP091()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_rabbit_mqamqp_091_to_plumbing(porcelains):
    return [
        convert_rabbit_mqamqp_091_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_rabbit_mqamqp_091_to_porcelain(plumbings):
    return [
        convert_rabbit_mqamqp_091_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_rate_limit_metadata_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RateLimitMetadata()
    porcelain.bucket = (plumbing.bucket)
    porcelain.limit = (plumbing.limit)
    porcelain.remaining = (plumbing.remaining)
    porcelain.reset_at = convert_timestamp_to_porcelain(plumbing.reset_at)
    return porcelain


def convert_rate_limit_metadata_to_plumbing(porcelain):
    plumbing = RateLimitMetadata()
    if porcelain is None:
        return plumbing
    plumbing.bucket = (porcelain.bucket)
    plumbing.limit = (porcelain.limit)
    plumbing.remaining = (porcelain.remaining)
    plumbing.reset_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.reset_at))
    return plumbing


def convert_repeated_rate_limit_metadata_to_plumbing(porcelains):
    return [
        convert_rate_limit_metadata_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_rate_limit_metadata_to_porcelain(plumbings):
    return [
        convert_rate_limit_metadata_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_raw_tcp_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RawTCP()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_raw_tcp_to_plumbing(porcelain):
    plumbing = RawTCP()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_raw_tcp_to_plumbing(porcelains):
    return [convert_raw_tcp_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_raw_tcp_to_porcelain(plumbings):
    return [convert_raw_tcp_to_porcelain(plumbing) for plumbing in plumbings]


def convert_redis_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Redis()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_redis_to_plumbing(porcelain):
    plumbing = Redis()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_redis_to_plumbing(porcelains):
    return [convert_redis_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_redis_to_porcelain(plumbings):
    return [convert_redis_to_porcelain(plumbing) for plumbing in plumbings]


def convert_redshift_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Redshift()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_redshift_to_plumbing(porcelain):
    plumbing = Redshift()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_redshift_to_plumbing(porcelains):
    return [
        convert_redshift_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_redshift_to_porcelain(plumbings):
    return [convert_redshift_to_porcelain(plumbing) for plumbing in plumbings]


def convert_relay_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Relay()
    porcelain.device = (plumbing.device)
    porcelain.gateway_filter = (plumbing.gateway_filter)
    porcelain.id = (plumbing.id)
    porcelain.location = (plumbing.location)
    porcelain.name = (plumbing.name)
    porcelain.state = (plumbing.state)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.version = (plumbing.version)
    return porcelain


def convert_relay_to_plumbing(porcelain):
    plumbing = Relay()
    if porcelain is None:
        return plumbing
    plumbing.device = (porcelain.device)
    plumbing.gateway_filter = (porcelain.gateway_filter)
    plumbing.id = (porcelain.id)
    plumbing.location = (porcelain.location)
    plumbing.name = (porcelain.name)
    plumbing.state = (porcelain.state)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.version = (porcelain.version)
    return plumbing


def convert_repeated_relay_to_plumbing(porcelains):
    return [convert_relay_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_relay_to_porcelain(plumbings):
    return [convert_relay_to_porcelain(plumbing) for plumbing in plumbings]


def convert_remote_identity_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RemoteIdentity()
    porcelain.account_id = (plumbing.account_id)
    porcelain.id = (plumbing.id)
    porcelain.remote_identity_group_id = (plumbing.remote_identity_group_id)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_remote_identity_to_plumbing(porcelain):
    plumbing = RemoteIdentity()
    if porcelain is None:
        return plumbing
    plumbing.account_id = (porcelain.account_id)
    plumbing.id = (porcelain.id)
    plumbing.remote_identity_group_id = (porcelain.remote_identity_group_id)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_remote_identity_to_plumbing(porcelains):
    return [
        convert_remote_identity_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_remote_identity_to_porcelain(plumbings):
    return [
        convert_remote_identity_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_remote_identity_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RemoteIdentityCreateResponse()
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.remote_identity = convert_remote_identity_to_porcelain(
        plumbing.remote_identity)
    return porcelain


def convert_remote_identity_create_response_to_plumbing(porcelain):
    plumbing = RemoteIdentityCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.remote_identity.CopyFrom(
        convert_remote_identity_to_plumbing(porcelain.remote_identity))
    return plumbing


def convert_repeated_remote_identity_create_response_to_plumbing(porcelains):
    return [
        convert_remote_identity_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_remote_identity_create_response_to_porcelain(plumbings):
    return [
        convert_remote_identity_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_remote_identity_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RemoteIdentityDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_remote_identity_delete_response_to_plumbing(porcelain):
    plumbing = RemoteIdentityDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_remote_identity_delete_response_to_plumbing(porcelains):
    return [
        convert_remote_identity_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_remote_identity_delete_response_to_porcelain(plumbings):
    return [
        convert_remote_identity_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_remote_identity_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RemoteIdentityGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.remote_identity = convert_remote_identity_to_porcelain(
        plumbing.remote_identity)
    return porcelain


def convert_remote_identity_get_response_to_plumbing(porcelain):
    plumbing = RemoteIdentityGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.remote_identity.CopyFrom(
        convert_remote_identity_to_plumbing(porcelain.remote_identity))
    return plumbing


def convert_repeated_remote_identity_get_response_to_plumbing(porcelains):
    return [
        convert_remote_identity_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_remote_identity_get_response_to_porcelain(plumbings):
    return [
        convert_remote_identity_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_remote_identity_group_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RemoteIdentityGroup()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    return porcelain


def convert_remote_identity_group_to_plumbing(porcelain):
    plumbing = RemoteIdentityGroup()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    return plumbing


def convert_repeated_remote_identity_group_to_plumbing(porcelains):
    return [
        convert_remote_identity_group_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_remote_identity_group_to_porcelain(plumbings):
    return [
        convert_remote_identity_group_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_remote_identity_group_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RemoteIdentityGroupGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.remote_identity_group = convert_remote_identity_group_to_porcelain(
        plumbing.remote_identity_group)
    return porcelain


def convert_remote_identity_group_get_response_to_plumbing(porcelain):
    plumbing = RemoteIdentityGroupGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.remote_identity_group.CopyFrom(
        convert_remote_identity_group_to_plumbing(
            porcelain.remote_identity_group))
    return plumbing


def convert_repeated_remote_identity_group_get_response_to_plumbing(
        porcelains):
    return [
        convert_remote_identity_group_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_remote_identity_group_get_response_to_porcelain(
        plumbings):
    return [
        convert_remote_identity_group_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_remote_identity_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RemoteIdentityUpdateResponse()
    porcelain.meta = convert_update_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.remote_identity = convert_remote_identity_to_porcelain(
        plumbing.remote_identity)
    return porcelain


def convert_remote_identity_update_response_to_plumbing(porcelain):
    plumbing = RemoteIdentityUpdateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_update_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.remote_identity.CopyFrom(
        convert_remote_identity_to_plumbing(porcelain.remote_identity))
    return plumbing


def convert_repeated_remote_identity_update_response_to_plumbing(porcelains):
    return [
        convert_remote_identity_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_remote_identity_update_response_to_porcelain(plumbings):
    return [
        convert_remote_identity_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_resource_to_plumbing(porcelain):
    plumbing = Resource()
    if porcelain is None:
        return plumbing
    if isinstance(porcelain, models.AKS):
        plumbing.aks.CopyFrom(convert_aks_to_plumbing(porcelain))
    if isinstance(porcelain, models.AKSBasicAuth):
        plumbing.aks_basic_auth.CopyFrom(
            convert_aks_basic_auth_to_plumbing(porcelain))
    if isinstance(porcelain, models.AKSServiceAccount):
        plumbing.aks_service_account.CopyFrom(
            convert_aks_service_account_to_plumbing(porcelain))
    if isinstance(porcelain, models.AKSServiceAccountUserImpersonation):
        plumbing.aks_service_account_user_impersonation.CopyFrom(
            convert_aks_service_account_user_impersonation_to_plumbing(
                porcelain))
    if isinstance(porcelain, models.AKSUserImpersonation):
        plumbing.aks_user_impersonation.CopyFrom(
            convert_aks_user_impersonation_to_plumbing(porcelain))
    if isinstance(porcelain, models.AmazonEKS):
        plumbing.amazon_eks.CopyFrom(convert_amazon_eks_to_plumbing(porcelain))
    if isinstance(porcelain, models.AmazonEKSInstanceProfile):
        plumbing.amazon_eks_instance_profile.CopyFrom(
            convert_amazon_eks_instance_profile_to_plumbing(porcelain))
    if isinstance(porcelain, models.AmazonEKSUserImpersonation):
        plumbing.amazon_eks_user_impersonation.CopyFrom(
            convert_amazon_eks_user_impersonation_to_plumbing(porcelain))
    if isinstance(porcelain, models.AmazonES):
        plumbing.amazon_es.CopyFrom(convert_amazon_es_to_plumbing(porcelain))
    if isinstance(porcelain, models.AmazonMQAMQP091):
        plumbing.amazon_mqamqp_091.CopyFrom(
            convert_amazon_mqamqp_091_to_plumbing(porcelain))
    if isinstance(porcelain, models.Athena):
        plumbing.athena.CopyFrom(convert_athena_to_plumbing(porcelain))
    if isinstance(porcelain, models.AuroraMysql):
        plumbing.aurora_mysql.CopyFrom(
            convert_aurora_mysql_to_plumbing(porcelain))
    if isinstance(porcelain, models.AuroraPostgres):
        plumbing.aurora_postgres.CopyFrom(
            convert_aurora_postgres_to_plumbing(porcelain))
    if isinstance(porcelain, models.AWS):
        plumbing.aws.CopyFrom(convert_aws_to_plumbing(porcelain))
    if isinstance(porcelain, models.AWSConsole):
        plumbing.aws_console.CopyFrom(
            convert_aws_console_to_plumbing(porcelain))
    if isinstance(porcelain, models.AWSConsoleStaticKeyPair):
        plumbing.aws_console_static_key_pair.CopyFrom(
            convert_aws_console_static_key_pair_to_plumbing(porcelain))
    if isinstance(porcelain, models.Azure):
        plumbing.azure.CopyFrom(convert_azure_to_plumbing(porcelain))
    if isinstance(porcelain, models.AzureCertificate):
        plumbing.azure_certificate.CopyFrom(
            convert_azure_certificate_to_plumbing(porcelain))
    if isinstance(porcelain, models.AzureMysql):
        plumbing.azure_mysql.CopyFrom(
            convert_azure_mysql_to_plumbing(porcelain))
    if isinstance(porcelain, models.AzurePostgres):
        plumbing.azure_postgres.CopyFrom(
            convert_azure_postgres_to_plumbing(porcelain))
    if isinstance(porcelain, models.BigQuery):
        plumbing.big_query.CopyFrom(convert_big_query_to_plumbing(porcelain))
    if isinstance(porcelain, models.Cassandra):
        plumbing.cassandra.CopyFrom(convert_cassandra_to_plumbing(porcelain))
    if isinstance(porcelain, models.Citus):
        plumbing.citus.CopyFrom(convert_citus_to_plumbing(porcelain))
    if isinstance(porcelain, models.Clustrix):
        plumbing.clustrix.CopyFrom(convert_clustrix_to_plumbing(porcelain))
    if isinstance(porcelain, models.Cockroach):
        plumbing.cockroach.CopyFrom(convert_cockroach_to_plumbing(porcelain))
    if isinstance(porcelain, models.DB2I):
        plumbing.db_2_i.CopyFrom(convert_db_2_i_to_plumbing(porcelain))
    if isinstance(porcelain, models.DB2LUW):
        plumbing.db_2_luw.CopyFrom(convert_db_2_luw_to_plumbing(porcelain))
    if isinstance(porcelain, models.DocumentDBHost):
        plumbing.document_db_host.CopyFrom(
            convert_document_db_host_to_plumbing(porcelain))
    if isinstance(porcelain, models.DocumentDBReplicaSet):
        plumbing.document_db_replica_set.CopyFrom(
            convert_document_db_replica_set_to_plumbing(porcelain))
    if isinstance(porcelain, models.Druid):
        plumbing.druid.CopyFrom(convert_druid_to_plumbing(porcelain))
    if isinstance(porcelain, models.DynamoDB):
        plumbing.dynamo_db.CopyFrom(convert_dynamo_db_to_plumbing(porcelain))
    if isinstance(porcelain, models.Elastic):
        plumbing.elastic.CopyFrom(convert_elastic_to_plumbing(porcelain))
    if isinstance(porcelain, models.ElasticacheRedis):
        plumbing.elasticache_redis.CopyFrom(
            convert_elasticache_redis_to_plumbing(porcelain))
    if isinstance(porcelain, models.GCP):
        plumbing.gcp.CopyFrom(convert_gcp_to_plumbing(porcelain))
    if isinstance(porcelain, models.GoogleGKE):
        plumbing.google_gke.CopyFrom(convert_google_gke_to_plumbing(porcelain))
    if isinstance(porcelain, models.GoogleGKEUserImpersonation):
        plumbing.google_gke_user_impersonation.CopyFrom(
            convert_google_gke_user_impersonation_to_plumbing(porcelain))
    if isinstance(porcelain, models.Greenplum):
        plumbing.greenplum.CopyFrom(convert_greenplum_to_plumbing(porcelain))
    if isinstance(porcelain, models.HTTPAuth):
        plumbing.http_auth.CopyFrom(convert_http_auth_to_plumbing(porcelain))
    if isinstance(porcelain, models.HTTPBasicAuth):
        plumbing.http_basic_auth.CopyFrom(
            convert_http_basic_auth_to_plumbing(porcelain))
    if isinstance(porcelain, models.HTTPNoAuth):
        plumbing.http_no_auth.CopyFrom(
            convert_http_no_auth_to_plumbing(porcelain))
    if isinstance(porcelain, models.Kubernetes):
        plumbing.kubernetes.CopyFrom(convert_kubernetes_to_plumbing(porcelain))
    if isinstance(porcelain, models.KubernetesBasicAuth):
        plumbing.kubernetes_basic_auth.CopyFrom(
            convert_kubernetes_basic_auth_to_plumbing(porcelain))
    if isinstance(porcelain, models.KubernetesServiceAccount):
        plumbing.kubernetes_service_account.CopyFrom(
            convert_kubernetes_service_account_to_plumbing(porcelain))
    if isinstance(porcelain, models.KubernetesServiceAccountUserImpersonation):
        plumbing.kubernetes_service_account_user_impersonation.CopyFrom(
            convert_kubernetes_service_account_user_impersonation_to_plumbing(
                porcelain))
    if isinstance(porcelain, models.KubernetesUserImpersonation):
        plumbing.kubernetes_user_impersonation.CopyFrom(
            convert_kubernetes_user_impersonation_to_plumbing(porcelain))
    if isinstance(porcelain, models.Maria):
        plumbing.maria.CopyFrom(convert_maria_to_plumbing(porcelain))
    if isinstance(porcelain, models.Memcached):
        plumbing.memcached.CopyFrom(convert_memcached_to_plumbing(porcelain))
    if isinstance(porcelain, models.Memsql):
        plumbing.memsql.CopyFrom(convert_memsql_to_plumbing(porcelain))
    if isinstance(porcelain, models.MongoHost):
        plumbing.mongo_host.CopyFrom(convert_mongo_host_to_plumbing(porcelain))
    if isinstance(porcelain, models.MongoLegacyHost):
        plumbing.mongo_legacy_host.CopyFrom(
            convert_mongo_legacy_host_to_plumbing(porcelain))
    if isinstance(porcelain, models.MongoLegacyReplicaset):
        plumbing.mongo_legacy_replicaset.CopyFrom(
            convert_mongo_legacy_replicaset_to_plumbing(porcelain))
    if isinstance(porcelain, models.MongoReplicaSet):
        plumbing.mongo_replica_set.CopyFrom(
            convert_mongo_replica_set_to_plumbing(porcelain))
    if isinstance(porcelain, models.MongoShardedCluster):
        plumbing.mongo_sharded_cluster.CopyFrom(
            convert_mongo_sharded_cluster_to_plumbing(porcelain))
    if isinstance(porcelain, models.MTLSMysql):
        plumbing.mtls_mysql.CopyFrom(convert_mtls_mysql_to_plumbing(porcelain))
    if isinstance(porcelain, models.MTLSPostgres):
        plumbing.mtls_postgres.CopyFrom(
            convert_mtls_postgres_to_plumbing(porcelain))
    if isinstance(porcelain, models.Mysql):
        plumbing.mysql.CopyFrom(convert_mysql_to_plumbing(porcelain))
    if isinstance(porcelain, models.Neptune):
        plumbing.neptune.CopyFrom(convert_neptune_to_plumbing(porcelain))
    if isinstance(porcelain, models.NeptuneIAM):
        plumbing.neptune_iam.CopyFrom(
            convert_neptune_iam_to_plumbing(porcelain))
    if isinstance(porcelain, models.Oracle):
        plumbing.oracle.CopyFrom(convert_oracle_to_plumbing(porcelain))
    if isinstance(porcelain, models.Postgres):
        plumbing.postgres.CopyFrom(convert_postgres_to_plumbing(porcelain))
    if isinstance(porcelain, models.Presto):
        plumbing.presto.CopyFrom(convert_presto_to_plumbing(porcelain))
    if isinstance(porcelain, models.RabbitMQAMQP091):
        plumbing.rabbit_mqamqp_091.CopyFrom(
            convert_rabbit_mqamqp_091_to_plumbing(porcelain))
    if isinstance(porcelain, models.RawTCP):
        plumbing.raw_tcp.CopyFrom(convert_raw_tcp_to_plumbing(porcelain))
    if isinstance(porcelain, models.RDP):
        plumbing.rdp.CopyFrom(convert_rdp_to_plumbing(porcelain))
    if isinstance(porcelain, models.Redis):
        plumbing.redis.CopyFrom(convert_redis_to_plumbing(porcelain))
    if isinstance(porcelain, models.Redshift):
        plumbing.redshift.CopyFrom(convert_redshift_to_plumbing(porcelain))
    if isinstance(porcelain, models.SingleStore):
        plumbing.single_store.CopyFrom(
            convert_single_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.Snowflake):
        plumbing.snowflake.CopyFrom(convert_snowflake_to_plumbing(porcelain))
    if isinstance(porcelain, models.Snowsight):
        plumbing.snowsight.CopyFrom(convert_snowsight_to_plumbing(porcelain))
    if isinstance(porcelain, models.SQLServer):
        plumbing.sql_server.CopyFrom(convert_sql_server_to_plumbing(porcelain))
    if isinstance(porcelain, models.SSH):
        plumbing.ssh.CopyFrom(convert_ssh_to_plumbing(porcelain))
    if isinstance(porcelain, models.SSHCert):
        plumbing.ssh_cert.CopyFrom(convert_ssh_cert_to_plumbing(porcelain))
    if isinstance(porcelain, models.SSHCustomerKey):
        plumbing.ssh_customer_key.CopyFrom(
            convert_ssh_customer_key_to_plumbing(porcelain))
    if isinstance(porcelain, models.Sybase):
        plumbing.sybase.CopyFrom(convert_sybase_to_plumbing(porcelain))
    if isinstance(porcelain, models.SybaseIQ):
        plumbing.sybase_iq.CopyFrom(convert_sybase_iq_to_plumbing(porcelain))
    if isinstance(porcelain, models.Teradata):
        plumbing.teradata.CopyFrom(convert_teradata_to_plumbing(porcelain))
    return plumbing


def convert_resource_to_porcelain(plumbing):
    if plumbing is None:
        return None
    if plumbing.HasField('aks'):
        return convert_aks_to_porcelain(plumbing.aks)
    if plumbing.HasField('aks_basic_auth'):
        return convert_aks_basic_auth_to_porcelain(plumbing.aks_basic_auth)
    if plumbing.HasField('aks_service_account'):
        return convert_aks_service_account_to_porcelain(
            plumbing.aks_service_account)
    if plumbing.HasField('aks_service_account_user_impersonation'):
        return convert_aks_service_account_user_impersonation_to_porcelain(
            plumbing.aks_service_account_user_impersonation)
    if plumbing.HasField('aks_user_impersonation'):
        return convert_aks_user_impersonation_to_porcelain(
            plumbing.aks_user_impersonation)
    if plumbing.HasField('amazon_eks'):
        return convert_amazon_eks_to_porcelain(plumbing.amazon_eks)
    if plumbing.HasField('amazon_eks_instance_profile'):
        return convert_amazon_eks_instance_profile_to_porcelain(
            plumbing.amazon_eks_instance_profile)
    if plumbing.HasField('amazon_eks_user_impersonation'):
        return convert_amazon_eks_user_impersonation_to_porcelain(
            plumbing.amazon_eks_user_impersonation)
    if plumbing.HasField('amazon_es'):
        return convert_amazon_es_to_porcelain(plumbing.amazon_es)
    if plumbing.HasField('amazon_mqamqp_091'):
        return convert_amazon_mqamqp_091_to_porcelain(
            plumbing.amazon_mqamqp_091)
    if plumbing.HasField('athena'):
        return convert_athena_to_porcelain(plumbing.athena)
    if plumbing.HasField('aurora_mysql'):
        return convert_aurora_mysql_to_porcelain(plumbing.aurora_mysql)
    if plumbing.HasField('aurora_postgres'):
        return convert_aurora_postgres_to_porcelain(plumbing.aurora_postgres)
    if plumbing.HasField('aws'):
        return convert_aws_to_porcelain(plumbing.aws)
    if plumbing.HasField('aws_console'):
        return convert_aws_console_to_porcelain(plumbing.aws_console)
    if plumbing.HasField('aws_console_static_key_pair'):
        return convert_aws_console_static_key_pair_to_porcelain(
            plumbing.aws_console_static_key_pair)
    if plumbing.HasField('azure'):
        return convert_azure_to_porcelain(plumbing.azure)
    if plumbing.HasField('azure_certificate'):
        return convert_azure_certificate_to_porcelain(
            plumbing.azure_certificate)
    if plumbing.HasField('azure_mysql'):
        return convert_azure_mysql_to_porcelain(plumbing.azure_mysql)
    if plumbing.HasField('azure_postgres'):
        return convert_azure_postgres_to_porcelain(plumbing.azure_postgres)
    if plumbing.HasField('big_query'):
        return convert_big_query_to_porcelain(plumbing.big_query)
    if plumbing.HasField('cassandra'):
        return convert_cassandra_to_porcelain(plumbing.cassandra)
    if plumbing.HasField('citus'):
        return convert_citus_to_porcelain(plumbing.citus)
    if plumbing.HasField('clustrix'):
        return convert_clustrix_to_porcelain(plumbing.clustrix)
    if plumbing.HasField('cockroach'):
        return convert_cockroach_to_porcelain(plumbing.cockroach)
    if plumbing.HasField('db_2_i'):
        return convert_db_2_i_to_porcelain(plumbing.db_2_i)
    if plumbing.HasField('db_2_luw'):
        return convert_db_2_luw_to_porcelain(plumbing.db_2_luw)
    if plumbing.HasField('document_db_host'):
        return convert_document_db_host_to_porcelain(plumbing.document_db_host)
    if plumbing.HasField('document_db_replica_set'):
        return convert_document_db_replica_set_to_porcelain(
            plumbing.document_db_replica_set)
    if plumbing.HasField('druid'):
        return convert_druid_to_porcelain(plumbing.druid)
    if plumbing.HasField('dynamo_db'):
        return convert_dynamo_db_to_porcelain(plumbing.dynamo_db)
    if plumbing.HasField('elastic'):
        return convert_elastic_to_porcelain(plumbing.elastic)
    if plumbing.HasField('elasticache_redis'):
        return convert_elasticache_redis_to_porcelain(
            plumbing.elasticache_redis)
    if plumbing.HasField('gcp'):
        return convert_gcp_to_porcelain(plumbing.gcp)
    if plumbing.HasField('google_gke'):
        return convert_google_gke_to_porcelain(plumbing.google_gke)
    if plumbing.HasField('google_gke_user_impersonation'):
        return convert_google_gke_user_impersonation_to_porcelain(
            plumbing.google_gke_user_impersonation)
    if plumbing.HasField('greenplum'):
        return convert_greenplum_to_porcelain(plumbing.greenplum)
    if plumbing.HasField('http_auth'):
        return convert_http_auth_to_porcelain(plumbing.http_auth)
    if plumbing.HasField('http_basic_auth'):
        return convert_http_basic_auth_to_porcelain(plumbing.http_basic_auth)
    if plumbing.HasField('http_no_auth'):
        return convert_http_no_auth_to_porcelain(plumbing.http_no_auth)
    if plumbing.HasField('kubernetes'):
        return convert_kubernetes_to_porcelain(plumbing.kubernetes)
    if plumbing.HasField('kubernetes_basic_auth'):
        return convert_kubernetes_basic_auth_to_porcelain(
            plumbing.kubernetes_basic_auth)
    if plumbing.HasField('kubernetes_service_account'):
        return convert_kubernetes_service_account_to_porcelain(
            plumbing.kubernetes_service_account)
    if plumbing.HasField('kubernetes_service_account_user_impersonation'):
        return convert_kubernetes_service_account_user_impersonation_to_porcelain(
            plumbing.kubernetes_service_account_user_impersonation)
    if plumbing.HasField('kubernetes_user_impersonation'):
        return convert_kubernetes_user_impersonation_to_porcelain(
            plumbing.kubernetes_user_impersonation)
    if plumbing.HasField('maria'):
        return convert_maria_to_porcelain(plumbing.maria)
    if plumbing.HasField('memcached'):
        return convert_memcached_to_porcelain(plumbing.memcached)
    if plumbing.HasField('memsql'):
        return convert_memsql_to_porcelain(plumbing.memsql)
    if plumbing.HasField('mongo_host'):
        return convert_mongo_host_to_porcelain(plumbing.mongo_host)
    if plumbing.HasField('mongo_legacy_host'):
        return convert_mongo_legacy_host_to_porcelain(
            plumbing.mongo_legacy_host)
    if plumbing.HasField('mongo_legacy_replicaset'):
        return convert_mongo_legacy_replicaset_to_porcelain(
            plumbing.mongo_legacy_replicaset)
    if plumbing.HasField('mongo_replica_set'):
        return convert_mongo_replica_set_to_porcelain(
            plumbing.mongo_replica_set)
    if plumbing.HasField('mongo_sharded_cluster'):
        return convert_mongo_sharded_cluster_to_porcelain(
            plumbing.mongo_sharded_cluster)
    if plumbing.HasField('mtls_mysql'):
        return convert_mtls_mysql_to_porcelain(plumbing.mtls_mysql)
    if plumbing.HasField('mtls_postgres'):
        return convert_mtls_postgres_to_porcelain(plumbing.mtls_postgres)
    if plumbing.HasField('mysql'):
        return convert_mysql_to_porcelain(plumbing.mysql)
    if plumbing.HasField('neptune'):
        return convert_neptune_to_porcelain(plumbing.neptune)
    if plumbing.HasField('neptune_iam'):
        return convert_neptune_iam_to_porcelain(plumbing.neptune_iam)
    if plumbing.HasField('oracle'):
        return convert_oracle_to_porcelain(plumbing.oracle)
    if plumbing.HasField('postgres'):
        return convert_postgres_to_porcelain(plumbing.postgres)
    if plumbing.HasField('presto'):
        return convert_presto_to_porcelain(plumbing.presto)
    if plumbing.HasField('rabbit_mqamqp_091'):
        return convert_rabbit_mqamqp_091_to_porcelain(
            plumbing.rabbit_mqamqp_091)
    if plumbing.HasField('raw_tcp'):
        return convert_raw_tcp_to_porcelain(plumbing.raw_tcp)
    if plumbing.HasField('rdp'):
        return convert_rdp_to_porcelain(plumbing.rdp)
    if plumbing.HasField('redis'):
        return convert_redis_to_porcelain(plumbing.redis)
    if plumbing.HasField('redshift'):
        return convert_redshift_to_porcelain(plumbing.redshift)
    if plumbing.HasField('single_store'):
        return convert_single_store_to_porcelain(plumbing.single_store)
    if plumbing.HasField('snowflake'):
        return convert_snowflake_to_porcelain(plumbing.snowflake)
    if plumbing.HasField('snowsight'):
        return convert_snowsight_to_porcelain(plumbing.snowsight)
    if plumbing.HasField('sql_server'):
        return convert_sql_server_to_porcelain(plumbing.sql_server)
    if plumbing.HasField('ssh'):
        return convert_ssh_to_porcelain(plumbing.ssh)
    if plumbing.HasField('ssh_cert'):
        return convert_ssh_cert_to_porcelain(plumbing.ssh_cert)
    if plumbing.HasField('ssh_customer_key'):
        return convert_ssh_customer_key_to_porcelain(plumbing.ssh_customer_key)
    if plumbing.HasField('sybase'):
        return convert_sybase_to_porcelain(plumbing.sybase)
    if plumbing.HasField('sybase_iq'):
        return convert_sybase_iq_to_porcelain(plumbing.sybase_iq)
    if plumbing.HasField('teradata'):
        return convert_teradata_to_porcelain(plumbing.teradata)
    raise errors.UnknownError(
        "unknown polymorphic type, please upgrade your SDK")


def convert_repeated_resource_to_plumbing(porcelains):
    return [
        convert_resource_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_resource_to_porcelain(plumbings):
    return [convert_resource_to_porcelain(plumbing) for plumbing in plumbings]


def convert_resource_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ResourceCreateResponse()
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.resource = convert_resource_to_porcelain(plumbing.resource)
    return porcelain


def convert_resource_create_response_to_plumbing(porcelain):
    plumbing = ResourceCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.resource.CopyFrom(convert_resource_to_plumbing(
        porcelain.resource))
    return plumbing


def convert_repeated_resource_create_response_to_plumbing(porcelains):
    return [
        convert_resource_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_resource_create_response_to_porcelain(plumbings):
    return [
        convert_resource_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_resource_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ResourceDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_resource_delete_response_to_plumbing(porcelain):
    plumbing = ResourceDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_resource_delete_response_to_plumbing(porcelains):
    return [
        convert_resource_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_resource_delete_response_to_porcelain(plumbings):
    return [
        convert_resource_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_resource_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ResourceGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.resource = convert_resource_to_porcelain(plumbing.resource)
    return porcelain


def convert_resource_get_response_to_plumbing(porcelain):
    plumbing = ResourceGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.resource.CopyFrom(convert_resource_to_plumbing(
        porcelain.resource))
    return plumbing


def convert_repeated_resource_get_response_to_plumbing(porcelains):
    return [
        convert_resource_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_resource_get_response_to_porcelain(plumbings):
    return [
        convert_resource_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_resource_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ResourceUpdateResponse()
    porcelain.meta = convert_update_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.resource = convert_resource_to_porcelain(plumbing.resource)
    return porcelain


def convert_resource_update_response_to_plumbing(porcelain):
    plumbing = ResourceUpdateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_update_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.resource.CopyFrom(convert_resource_to_plumbing(
        porcelain.resource))
    return plumbing


def convert_repeated_resource_update_response_to_plumbing(porcelains):
    return [
        convert_resource_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_resource_update_response_to_porcelain(plumbings):
    return [
        convert_resource_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_role_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Role()
    porcelain.access_rules = convert_access_rules_to_porcelain(
        plumbing.access_rules)
    porcelain.id = (plumbing.id)
    porcelain.managed_by = (plumbing.managed_by)
    porcelain.name = (plumbing.name)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_role_to_plumbing(porcelain):
    plumbing = Role()
    if porcelain is None:
        return plumbing
    plumbing.access_rules = convert_access_rules_to_plumbing(
        porcelain.access_rules)
    plumbing.id = (porcelain.id)
    plumbing.managed_by = (porcelain.managed_by)
    plumbing.name = (porcelain.name)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_role_to_plumbing(porcelains):
    return [convert_role_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_role_to_porcelain(plumbings):
    return [convert_role_to_porcelain(plumbing) for plumbing in plumbings]


def convert_role_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleCreateResponse()
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.role = convert_role_to_porcelain(plumbing.role)
    return porcelain


def convert_role_create_response_to_plumbing(porcelain):
    plumbing = RoleCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.role.CopyFrom(convert_role_to_plumbing(porcelain.role))
    return plumbing


def convert_repeated_role_create_response_to_plumbing(porcelains):
    return [
        convert_role_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_role_create_response_to_porcelain(plumbings):
    return [
        convert_role_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_role_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_role_delete_response_to_plumbing(porcelain):
    plumbing = RoleDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_role_delete_response_to_plumbing(porcelains):
    return [
        convert_role_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_role_delete_response_to_porcelain(plumbings):
    return [
        convert_role_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_role_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.role = convert_role_to_porcelain(plumbing.role)
    return porcelain


def convert_role_get_response_to_plumbing(porcelain):
    plumbing = RoleGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.role.CopyFrom(convert_role_to_plumbing(porcelain.role))
    return plumbing


def convert_repeated_role_get_response_to_plumbing(porcelains):
    return [
        convert_role_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_role_get_response_to_porcelain(plumbings):
    return [
        convert_role_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_role_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleUpdateResponse()
    porcelain.meta = convert_update_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.role = convert_role_to_porcelain(plumbing.role)
    return porcelain


def convert_role_update_response_to_plumbing(porcelain):
    plumbing = RoleUpdateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_update_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.role.CopyFrom(convert_role_to_plumbing(porcelain.role))
    return plumbing


def convert_repeated_role_update_response_to_plumbing(porcelains):
    return [
        convert_role_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_role_update_response_to_porcelain(plumbings):
    return [
        convert_role_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_sql_server_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SQLServer()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.schema = (plumbing.schema)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_sql_server_to_plumbing(porcelain):
    plumbing = SQLServer()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.schema = (porcelain.schema)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_sql_server_to_plumbing(porcelains):
    return [
        convert_sql_server_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_sql_server_to_porcelain(plumbings):
    return [
        convert_sql_server_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_ssh_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SSH()
    porcelain.allow_deprecated_key_exchanges = (
        plumbing.allow_deprecated_key_exchanges)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.key_type = (plumbing.key_type)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_forwarding = (plumbing.port_forwarding)
    porcelain.port_override = (plumbing.port_override)
    porcelain.public_key = (plumbing.public_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_ssh_to_plumbing(porcelain):
    plumbing = SSH()
    if porcelain is None:
        return plumbing
    plumbing.allow_deprecated_key_exchanges = (
        porcelain.allow_deprecated_key_exchanges)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.key_type = (porcelain.key_type)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_forwarding = (porcelain.port_forwarding)
    plumbing.port_override = (porcelain.port_override)
    plumbing.public_key = (porcelain.public_key)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_ssh_to_plumbing(porcelains):
    return [convert_ssh_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_ssh_to_porcelain(plumbings):
    return [convert_ssh_to_porcelain(plumbing) for plumbing in plumbings]


def convert_ssh_cert_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SSHCert()
    porcelain.allow_deprecated_key_exchanges = (
        plumbing.allow_deprecated_key_exchanges)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.key_type = (plumbing.key_type)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_forwarding = (plumbing.port_forwarding)
    porcelain.port_override = (plumbing.port_override)
    porcelain.remote_identity_group_id = (plumbing.remote_identity_group_id)
    porcelain.remote_identity_healthcheck_username = (
        plumbing.remote_identity_healthcheck_username)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_ssh_cert_to_plumbing(porcelain):
    plumbing = SSHCert()
    if porcelain is None:
        return plumbing
    plumbing.allow_deprecated_key_exchanges = (
        porcelain.allow_deprecated_key_exchanges)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.key_type = (porcelain.key_type)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_forwarding = (porcelain.port_forwarding)
    plumbing.port_override = (porcelain.port_override)
    plumbing.remote_identity_group_id = (porcelain.remote_identity_group_id)
    plumbing.remote_identity_healthcheck_username = (
        porcelain.remote_identity_healthcheck_username)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_ssh_cert_to_plumbing(porcelains):
    return [
        convert_ssh_cert_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_ssh_cert_to_porcelain(plumbings):
    return [convert_ssh_cert_to_porcelain(plumbing) for plumbing in plumbings]


def convert_ssh_customer_key_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SSHCustomerKey()
    porcelain.allow_deprecated_key_exchanges = (
        plumbing.allow_deprecated_key_exchanges)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_forwarding = (plumbing.port_forwarding)
    porcelain.port_override = (plumbing.port_override)
    porcelain.private_key = (plumbing.private_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_ssh_customer_key_to_plumbing(porcelain):
    plumbing = SSHCustomerKey()
    if porcelain is None:
        return plumbing
    plumbing.allow_deprecated_key_exchanges = (
        porcelain.allow_deprecated_key_exchanges)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_forwarding = (porcelain.port_forwarding)
    plumbing.port_override = (porcelain.port_override)
    plumbing.private_key = (porcelain.private_key)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_ssh_customer_key_to_plumbing(porcelains):
    return [
        convert_ssh_customer_key_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_ssh_customer_key_to_porcelain(plumbings):
    return [
        convert_ssh_customer_key_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_store_to_plumbing(porcelain):
    plumbing = SecretStore()
    if porcelain is None:
        return plumbing
    if isinstance(porcelain, models.AWSStore):
        plumbing.aws.CopyFrom(convert_aws_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.AzureStore):
        plumbing.azure.CopyFrom(convert_azure_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.CyberarkConjurStore):
        plumbing.cyberark_conjur.CopyFrom(
            convert_cyberark_conjur_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.CyberarkPAMStore):
        plumbing.cyberark_pam.CopyFrom(
            convert_cyberark_pam_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.CyberarkPAMExperimentalStore):
        plumbing.cyberark_pam_experimental.CopyFrom(
            convert_cyberark_pam_experimental_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.DelineaStore):
        plumbing.delinea.CopyFrom(convert_delinea_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.GCPStore):
        plumbing.gcp.CopyFrom(convert_gcp_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.VaultAppRoleStore):
        plumbing.vault_app_role.CopyFrom(
            convert_vault_app_role_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.VaultTLSStore):
        plumbing.vault_tls.CopyFrom(
            convert_vault_tls_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.VaultTokenStore):
        plumbing.vault_token.CopyFrom(
            convert_vault_token_store_to_plumbing(porcelain))
    return plumbing


def convert_secret_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    if plumbing.HasField('aws'):
        return convert_aws_store_to_porcelain(plumbing.aws)
    if plumbing.HasField('azure'):
        return convert_azure_store_to_porcelain(plumbing.azure)
    if plumbing.HasField('cyberark_conjur'):
        return convert_cyberark_conjur_store_to_porcelain(
            plumbing.cyberark_conjur)
    if plumbing.HasField('cyberark_pam'):
        return convert_cyberark_pam_store_to_porcelain(plumbing.cyberark_pam)
    if plumbing.HasField('cyberark_pam_experimental'):
        return convert_cyberark_pam_experimental_store_to_porcelain(
            plumbing.cyberark_pam_experimental)
    if plumbing.HasField('delinea'):
        return convert_delinea_store_to_porcelain(plumbing.delinea)
    if plumbing.HasField('gcp'):
        return convert_gcp_store_to_porcelain(plumbing.gcp)
    if plumbing.HasField('vault_app_role'):
        return convert_vault_app_role_store_to_porcelain(
            plumbing.vault_app_role)
    if plumbing.HasField('vault_tls'):
        return convert_vault_tls_store_to_porcelain(plumbing.vault_tls)
    if plumbing.HasField('vault_token'):
        return convert_vault_token_store_to_porcelain(plumbing.vault_token)
    raise errors.UnknownError(
        "unknown polymorphic type, please upgrade your SDK")


def convert_repeated_secret_store_to_plumbing(porcelains):
    return [
        convert_secret_store_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_secret_store_to_porcelain(plumbings):
    return [
        convert_secret_store_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_secret_store_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretStoreCreateResponse()
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.secret_store = convert_secret_store_to_porcelain(
        plumbing.secret_store)
    return porcelain


def convert_secret_store_create_response_to_plumbing(porcelain):
    plumbing = SecretStoreCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.secret_store.CopyFrom(
        convert_secret_store_to_plumbing(porcelain.secret_store))
    return plumbing


def convert_repeated_secret_store_create_response_to_plumbing(porcelains):
    return [
        convert_secret_store_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_store_create_response_to_porcelain(plumbings):
    return [
        convert_secret_store_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_store_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretStoreDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_secret_store_delete_response_to_plumbing(porcelain):
    plumbing = SecretStoreDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_secret_store_delete_response_to_plumbing(porcelains):
    return [
        convert_secret_store_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_store_delete_response_to_porcelain(plumbings):
    return [
        convert_secret_store_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_store_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretStoreGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.secret_store = convert_secret_store_to_porcelain(
        plumbing.secret_store)
    return porcelain


def convert_secret_store_get_response_to_plumbing(porcelain):
    plumbing = SecretStoreGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.secret_store.CopyFrom(
        convert_secret_store_to_plumbing(porcelain.secret_store))
    return plumbing


def convert_repeated_secret_store_get_response_to_plumbing(porcelains):
    return [
        convert_secret_store_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_store_get_response_to_porcelain(plumbings):
    return [
        convert_secret_store_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_store_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretStoreUpdateResponse()
    porcelain.meta = convert_update_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.secret_store = convert_secret_store_to_porcelain(
        plumbing.secret_store)
    return porcelain


def convert_secret_store_update_response_to_plumbing(porcelain):
    plumbing = SecretStoreUpdateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_update_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.secret_store.CopyFrom(
        convert_secret_store_to_plumbing(porcelain.secret_store))
    return plumbing


def convert_repeated_secret_store_update_response_to_plumbing(porcelains):
    return [
        convert_secret_store_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_store_update_response_to_porcelain(plumbings):
    return [
        convert_secret_store_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_service_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Service()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.suspended = (plumbing.suspended)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_service_to_plumbing(porcelain):
    plumbing = Service()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.suspended = (porcelain.suspended)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_service_to_plumbing(porcelains):
    return [convert_service_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_service_to_porcelain(plumbings):
    return [convert_service_to_porcelain(plumbing) for plumbing in plumbings]


def convert_single_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SingleStore()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_single_store_to_plumbing(porcelain):
    plumbing = SingleStore()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_single_store_to_plumbing(porcelains):
    return [
        convert_single_store_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_single_store_to_porcelain(plumbings):
    return [
        convert_single_store_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_snowflake_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Snowflake()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port_override = (plumbing.port_override)
    porcelain.schema = (plumbing.schema)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_snowflake_to_plumbing(porcelain):
    plumbing = Snowflake()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port_override = (porcelain.port_override)
    plumbing.schema = (porcelain.schema)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_snowflake_to_plumbing(porcelains):
    return [
        convert_snowflake_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_snowflake_to_porcelain(plumbings):
    return [convert_snowflake_to_porcelain(plumbing) for plumbing in plumbings]


def convert_snowsight_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Snowsight()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_username = (plumbing.healthcheck_username)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.samlmetadata = (plumbing.samlMetadata)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_snowsight_to_plumbing(porcelain):
    plumbing = Snowsight()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_username = (porcelain.healthcheck_username)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.samlMetadata = (porcelain.samlmetadata)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_snowsight_to_plumbing(porcelains):
    return [
        convert_snowsight_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_snowsight_to_porcelain(plumbings):
    return [convert_snowsight_to_porcelain(plumbing) for plumbing in plumbings]


def convert_sybase_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Sybase()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_sybase_to_plumbing(porcelain):
    plumbing = Sybase()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_sybase_to_plumbing(porcelains):
    return [convert_sybase_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_sybase_to_porcelain(plumbings):
    return [convert_sybase_to_porcelain(plumbing) for plumbing in plumbings]


def convert_sybase_iq_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SybaseIQ()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_sybase_iq_to_plumbing(porcelain):
    plumbing = SybaseIQ()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_sybase_iq_to_plumbing(porcelains):
    return [
        convert_sybase_iq_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_sybase_iq_to_porcelain(plumbings):
    return [convert_sybase_iq_to_porcelain(plumbing) for plumbing in plumbings]


def convert_tag_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Tag()
    porcelain.name = (plumbing.name)
    porcelain.value = (plumbing.value)
    return porcelain


def convert_tag_to_plumbing(porcelain):
    plumbing = Tag()
    if porcelain is None:
        return plumbing
    plumbing.name = (porcelain.name)
    plumbing.value = (porcelain.value)
    return plumbing


def convert_repeated_tag_to_plumbing(porcelains):
    return [convert_tag_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_tag_to_porcelain(plumbings):
    return [convert_tag_to_porcelain(plumbing) for plumbing in plumbings]


def convert_teradata_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Teradata()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_teradata_to_plumbing(porcelain):
    plumbing = Teradata()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_teradata_to_plumbing(porcelains):
    return [
        convert_teradata_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_teradata_to_porcelain(plumbings):
    return [convert_teradata_to_porcelain(plumbing) for plumbing in plumbings]


def convert_update_response_metadata_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.UpdateResponseMetadata()
    return porcelain


def convert_update_response_metadata_to_plumbing(porcelain):
    plumbing = UpdateResponseMetadata()
    if porcelain is None:
        return plumbing
    return plumbing


def convert_repeated_update_response_metadata_to_plumbing(porcelains):
    return [
        convert_update_response_metadata_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_update_response_metadata_to_porcelain(plumbings):
    return [
        convert_update_response_metadata_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_user_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.User()
    porcelain.email = (plumbing.email)
    porcelain.external_id = (plumbing.external_id)
    porcelain.first_name = (plumbing.first_name)
    porcelain.id = (plumbing.id)
    porcelain.last_name = (plumbing.last_name)
    porcelain.managed_by = (plumbing.managed_by)
    porcelain.permission_level = (plumbing.permission_level)
    porcelain.suspended = (plumbing.suspended)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_user_to_plumbing(porcelain):
    plumbing = User()
    if porcelain is None:
        return plumbing
    plumbing.email = (porcelain.email)
    plumbing.external_id = (porcelain.external_id)
    plumbing.first_name = (porcelain.first_name)
    plumbing.id = (porcelain.id)
    plumbing.last_name = (porcelain.last_name)
    plumbing.managed_by = (porcelain.managed_by)
    plumbing.permission_level = (porcelain.permission_level)
    plumbing.suspended = (porcelain.suspended)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_user_to_plumbing(porcelains):
    return [convert_user_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_user_to_porcelain(plumbings):
    return [convert_user_to_porcelain(plumbing) for plumbing in plumbings]


def convert_vault_app_role_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.VaultAppRoleStore()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.namespace = (plumbing.namespace)
    porcelain.server_address = (plumbing.server_address)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_vault_app_role_store_to_plumbing(porcelain):
    plumbing = VaultAppRoleStore()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.namespace = (porcelain.namespace)
    plumbing.server_address = (porcelain.server_address)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_vault_app_role_store_to_plumbing(porcelains):
    return [
        convert_vault_app_role_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_vault_app_role_store_to_porcelain(plumbings):
    return [
        convert_vault_app_role_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_vault_tls_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.VaultTLSStore()
    porcelain.ca_cert_path = (plumbing.CA_cert_path)
    porcelain.client_cert_path = (plumbing.client_cert_path)
    porcelain.client_key_path = (plumbing.client_key_path)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.namespace = (plumbing.namespace)
    porcelain.server_address = (plumbing.server_address)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_vault_tls_store_to_plumbing(porcelain):
    plumbing = VaultTLSStore()
    if porcelain is None:
        return plumbing
    plumbing.CA_cert_path = (porcelain.ca_cert_path)
    plumbing.client_cert_path = (porcelain.client_cert_path)
    plumbing.client_key_path = (porcelain.client_key_path)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.namespace = (porcelain.namespace)
    plumbing.server_address = (porcelain.server_address)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_vault_tls_store_to_plumbing(porcelains):
    return [
        convert_vault_tls_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_vault_tls_store_to_porcelain(plumbings):
    return [
        convert_vault_tls_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_vault_token_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.VaultTokenStore()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.namespace = (plumbing.namespace)
    porcelain.server_address = (plumbing.server_address)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_vault_token_store_to_plumbing(porcelain):
    plumbing = VaultTokenStore()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.namespace = (porcelain.namespace)
    plumbing.server_address = (porcelain.server_address)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_vault_token_store_to_plumbing(porcelains):
    return [
        convert_vault_token_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_vault_token_store_to_porcelain(plumbings):
    return [
        convert_vault_token_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def is_status_detail(x):
    # Return True if a metadata is a grpc-status-details
    if (hasattr(x, 'key') and (hasattr(x, 'value'))
            and x.key.startswith('grpc-status-details')):
        return True
    return False


def get_status_metadata(err):
    # Extracts error details from a grpc.RpcError.
    # Returns a status object and a list of details.
    metadata = err.trailing_metadata()

    # get only metadata relevant to status details
    status_md = [x for x in metadata if is_status_detail(x)]
    st = None
    if status_md:
        for md in status_md:
            st = status_pb2.Status()
            # there should be exactly one status for every RpcError
            # so MergeFromString should at worst append more details
            # but never override st.message and st.code in every loop
            st.MergeFromString(md.value)

    return st


def convert_error_to_porcelain(err):
    if not isinstance(err, grpc.RpcError):
        return errors.UnknownError(str(err))
    # get_status_metadata fails for deadline exceeded
    if err.code().name == 'DEADLINE_EXCEEDED':
        return errors.TimeoutError()
    status = get_status_metadata(err)
    if status is None:
        code, name = err.code().value
        return errors.RPCError(name, code)
    if err.code() == grpc.StatusCode.INVALID_ARGUMENT:
        return errors.BadRequestError(status.message)
    elif err.code() == grpc.StatusCode.NOT_FOUND:
        return errors.NotFoundError(status.message)
    elif err.code() == grpc.StatusCode.ALREADY_EXISTS:
        return errors.AlreadyExistsError(status.message)
    elif err.code() == grpc.StatusCode.PERMISSION_DENIED:
        return errors.PermissionError(status.message)
    elif err.code() == grpc.StatusCode.RESOURCE_EXHAUSTED:
        for detail in status.details:
            if detail.Is(RateLimitMetadata.DESCRIPTOR):
                rate_limit = RateLimitMetadata()
                detail.Unpack(rate_limit)
                return errors.RateLimitError(
                    status.message,
                    convert_rate_limit_metadata_to_porcelain(rate_limit))
    elif err.code() == grpc.StatusCode.INTERNAL:
        return errors.InternalError(status.message)
    elif err.code() == grpc.StatusCode.UNAUTHENTICATED:
        return errors.AuthenticationError(status.message)

    code = err.code().value[0]
    return errors.RPCError(status.message, code)
