# Copyright 2020 StrongDM Inc
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# This file was generated by protogen. DO NOT EDIT.

import collections


class AKS:
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'client_certificate',
        'client_key',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'remote_identity_group_id',
        'remote_identity_healthcheck_username',
        'secret_store_id',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        client_certificate=None,
        client_key=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        remote_identity_group_id=None,
        remote_identity_healthcheck_username=None,
        secret_store_id=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        self.client_certificate = client_certificate if client_certificate is not None else ''
        self.client_key = client_key if client_key is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        self.remote_identity_healthcheck_username = remote_identity_healthcheck_username if remote_identity_healthcheck_username is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AKS ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'client_certificate: ' + repr(self.client_certificate) + ' ' +\
            'client_key: ' + repr(self.client_key) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'remote_identity_healthcheck_username: ' + repr(self.remote_identity_healthcheck_username) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'client_certificate': self.client_certificate,
            'client_key': self.client_key,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'remote_identity_group_id': self.remote_identity_group_id,
            'remote_identity_healthcheck_username':
            self.remote_identity_healthcheck_username,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            client_certificate=d.get('client_certificate'),
            client_key=d.get('client_key'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            remote_identity_healthcheck_username=d.get(
                'remote_identity_healthcheck_username'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
        )


class AKSBasicAuth:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.AKSBasicAuth ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class AKSServiceAccount:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'remote_identity_group_id',
        'remote_identity_healthcheck_username',
        'secret_store_id',
        'tags',
        'token',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        remote_identity_group_id=None,
        remote_identity_healthcheck_username=None,
        secret_store_id=None,
        tags=None,
        token=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        self.remote_identity_healthcheck_username = remote_identity_healthcheck_username if remote_identity_healthcheck_username is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.token = token if token is not None else ''

    def __repr__(self):
        return '<sdm.AKSServiceAccount ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'remote_identity_healthcheck_username: ' + repr(self.remote_identity_healthcheck_username) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'token: ' + repr(self.token) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'remote_identity_group_id': self.remote_identity_group_id,
            'remote_identity_healthcheck_username':
            self.remote_identity_healthcheck_username,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'token': self.token,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            remote_identity_healthcheck_username=d.get(
                'remote_identity_healthcheck_username'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            token=d.get('token'),
        )


class AKSServiceAccountUserImpersonation:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'token',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        token=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.token = token if token is not None else ''

    def __repr__(self):
        return '<sdm.AKSServiceAccountUserImpersonation ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'token: ' + repr(self.token) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'token': self.token,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            token=d.get('token'),
        )


class AKSUserImpersonation:
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'client_certificate',
        'client_key',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        client_certificate=None,
        client_key=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        self.client_certificate = client_certificate if client_certificate is not None else ''
        self.client_key = client_key if client_key is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AKSUserImpersonation ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'client_certificate: ' + repr(self.client_certificate) + ' ' +\
            'client_key: ' + repr(self.client_key) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'client_certificate': self.client_certificate,
            'client_key': self.client_key,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            client_certificate=d.get('client_certificate'),
            client_key=d.get('client_key'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
        )


class AWS:
    __slots__ = [
        'access_key',
        'bind_interface',
        'egress_filter',
        'healthcheck_region',
        'healthy',
        'id',
        'name',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        egress_filter=None,
        healthcheck_region=None,
        healthy=None,
        id=None,
        name=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_region = healthcheck_region if healthcheck_region is not None else ''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AWS ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_region: ' + repr(self.healthcheck_region) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthcheck_region': self.healthcheck_region,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthcheck_region=d.get('healthcheck_region'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
        )


class AWSConsole:
    '''
    AWSConsole is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'enable_env_variables',
        'healthy',
        'id',
        'name',
        'port_override',
        'region',
        'remote_identity_group_id',
        'remote_identity_healthcheck_username',
        'role_arn',
        'role_external_id',
        'secret_store_id',
        'session_expiry',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        enable_env_variables=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        region=None,
        remote_identity_group_id=None,
        remote_identity_healthcheck_username=None,
        role_arn=None,
        role_external_id=None,
        secret_store_id=None,
        session_expiry=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.enable_env_variables = enable_env_variables if enable_env_variables is not None else False
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        self.region = region if region is not None else ''
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        self.remote_identity_healthcheck_username = remote_identity_healthcheck_username if remote_identity_healthcheck_username is not None else ''
        self.role_arn = role_arn if role_arn is not None else ''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.session_expiry = session_expiry if session_expiry is not None else 0
        self.subdomain = subdomain if subdomain is not None else ''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AWSConsole ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'enable_env_variables: ' + repr(self.enable_env_variables) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'remote_identity_healthcheck_username: ' + repr(self.remote_identity_healthcheck_username) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'session_expiry: ' + repr(self.session_expiry) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'enable_env_variables': self.enable_env_variables,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'region': self.region,
            'remote_identity_group_id': self.remote_identity_group_id,
            'remote_identity_healthcheck_username':
            self.remote_identity_healthcheck_username,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_store_id': self.secret_store_id,
            'session_expiry': self.session_expiry,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            enable_env_variables=d.get('enable_env_variables'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            region=d.get('region'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            remote_identity_healthcheck_username=d.get(
                'remote_identity_healthcheck_username'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_store_id=d.get('secret_store_id'),
            session_expiry=d.get('session_expiry'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AWSConsoleStaticKeyPair:
    '''
    AWSConsoleStaticKeyPair is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'access_key',
        'bind_interface',
        'egress_filter',
        'healthy',
        'id',
        'name',
        'port_override',
        'region',
        'remote_identity_group_id',
        'remote_identity_healthcheck_username',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'session_expiry',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        region=None,
        remote_identity_group_id=None,
        remote_identity_healthcheck_username=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        session_expiry=None,
        subdomain=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        self.region = region if region is not None else ''
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        self.remote_identity_healthcheck_username = remote_identity_healthcheck_username if remote_identity_healthcheck_username is not None else ''
        self.role_arn = role_arn if role_arn is not None else ''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.session_expiry = session_expiry if session_expiry is not None else 0
        self.subdomain = subdomain if subdomain is not None else ''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AWSConsoleStaticKeyPair ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'remote_identity_healthcheck_username: ' + repr(self.remote_identity_healthcheck_username) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'session_expiry: ' + repr(self.session_expiry) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'region': self.region,
            'remote_identity_group_id': self.remote_identity_group_id,
            'remote_identity_healthcheck_username':
            self.remote_identity_healthcheck_username,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'session_expiry': self.session_expiry,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            region=d.get('region'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            remote_identity_healthcheck_username=d.get(
                'remote_identity_healthcheck_username'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            session_expiry=d.get('session_expiry'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AWSStore:
    __slots__ = [
        'id',
        'name',
        'region',
        'tags',
    ]

    def __init__(
        self,
        id=None,
        name=None,
        region=None,
        tags=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.region = region if region is not None else ''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AWSStore ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
            'region': self.region,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
            region=d.get('region'),
            tags=d.get('tags'),
        )


class AccountAttachment:
    '''
         AccountAttachments assign an account to a role.
    '''
    __slots__ = [
        'account_id',
        'id',
        'role_id',
    ]

    def __init__(
        self,
        account_id=None,
        id=None,
        role_id=None,
    ):
        self.account_id = account_id if account_id is not None else ''
        '''
         The id of the account of this AccountAttachment.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the AccountAttachment.
        '''
        self.role_id = role_id if role_id is not None else ''
        '''
         The id of the attached role of this AccountAttachment.
        '''

    def __repr__(self):
        return '<sdm.AccountAttachment ' + \
            'account_id: ' + repr(self.account_id) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'role_id: ' + repr(self.role_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_id': self.account_id,
            'id': self.id,
            'role_id': self.role_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_id=d.get('account_id'),
            id=d.get('id'),
            role_id=d.get('role_id'),
        )


class AccountAttachmentCreateResponse:
    '''
         AccountAttachmentCreateResponse reports how the AccountAttachments were created in the system.
    '''
    __slots__ = [
        'account_attachment',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        account_attachment=None,
        meta=None,
        rate_limit=None,
    ):
        self.account_attachment = account_attachment if account_attachment is not None else None
        '''
         The created AccountAttachment.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountAttachmentCreateResponse ' + \
            'account_attachment: ' + repr(self.account_attachment) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_attachment': self.account_attachment,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_attachment=d.get('account_attachment'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountAttachmentDeleteResponse:
    '''
         AccountAttachmentDeleteResponse returns information about a AccountAttachment that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountAttachmentDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountAttachmentGetResponse:
    '''
         AccountAttachmentGetResponse returns a requested AccountAttachment.
    '''
    __slots__ = [
        'account_attachment',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        account_attachment=None,
        meta=None,
        rate_limit=None,
    ):
        self.account_attachment = account_attachment if account_attachment is not None else None
        '''
         The requested AccountAttachment.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountAttachmentGetResponse ' + \
            'account_attachment: ' + repr(self.account_attachment) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_attachment': self.account_attachment,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_attachment=d.get('account_attachment'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountCreateResponse:
    '''
         AccountCreateResponse reports how the Accounts were created in the system.
    '''
    __slots__ = [
        'account',
        'meta',
        'rate_limit',
        'token',
    ]

    def __init__(
        self,
        account=None,
        meta=None,
        rate_limit=None,
        token=None,
    ):
        self.account = account if account is not None else None
        '''
         The created Account.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.token = token if token is not None else ''
        '''
         The auth token generated for the Account. The Account will use this token to
         authenticate with the strongDM API.
        '''

    def __repr__(self):
        return '<sdm.AccountCreateResponse ' + \
            'account: ' + repr(self.account) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'token: ' + repr(self.token) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account': self.account,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'token': self.token,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account=d.get('account'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            token=d.get('token'),
        )


class AccountDeleteResponse:
    '''
         AccountDeleteResponse returns information about a Account that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountGetResponse:
    '''
         AccountGetResponse returns a requested Account.
    '''
    __slots__ = [
        'account',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        account=None,
        meta=None,
        rate_limit=None,
    ):
        self.account = account if account is not None else None
        '''
         The requested Account.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountGetResponse ' + \
            'account: ' + repr(self.account) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account': self.account,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account=d.get('account'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountGrant:
    '''
         AccountGrants connect a resource directly to an account, giving the account the permission to connect to that resource.
    '''
    __slots__ = [
        'account_id',
        'id',
        'resource_id',
        'start_from',
        'valid_until',
    ]

    def __init__(
        self,
        account_id=None,
        id=None,
        resource_id=None,
        start_from=None,
        valid_until=None,
    ):
        self.account_id = account_id if account_id is not None else ''
        '''
         The account ID of this AccountGrant.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the AccountGrant.
        '''
        self.resource_id = resource_id if resource_id is not None else ''
        '''
         The resource ID of this AccountGrant.
        '''
        self.start_from = start_from if start_from is not None else None
        '''
         The timestamp when the resource will be granted. When creating an AccountGrant, if this field is not specified, it will default to the current time.
        '''
        self.valid_until = valid_until if valid_until is not None else None
        '''
         The timestamp when the resource grant will expire.
        '''

    def __repr__(self):
        return '<sdm.AccountGrant ' + \
            'account_id: ' + repr(self.account_id) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'resource_id: ' + repr(self.resource_id) + ' ' +\
            'start_from: ' + repr(self.start_from) + ' ' +\
            'valid_until: ' + repr(self.valid_until) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_id': self.account_id,
            'id': self.id,
            'resource_id': self.resource_id,
            'start_from': self.start_from,
            'valid_until': self.valid_until,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_id=d.get('account_id'),
            id=d.get('id'),
            resource_id=d.get('resource_id'),
            start_from=d.get('start_from'),
            valid_until=d.get('valid_until'),
        )


class AccountGrantCreateResponse:
    '''
         AccountGrantCreateResponse reports how the AccountGrants were created in the system.
    '''
    __slots__ = [
        'account_grant',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        account_grant=None,
        meta=None,
        rate_limit=None,
    ):
        self.account_grant = account_grant if account_grant is not None else None
        '''
         The created AccountGrant.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountGrantCreateResponse ' + \
            'account_grant: ' + repr(self.account_grant) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_grant': self.account_grant,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_grant=d.get('account_grant'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountGrantDeleteResponse:
    '''
         AccountGrantDeleteResponse returns information about a AccountGrant that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountGrantDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountGrantGetResponse:
    '''
         AccountGrantGetResponse returns a requested AccountGrant.
    '''
    __slots__ = [
        'account_grant',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        account_grant=None,
        meta=None,
        rate_limit=None,
    ):
        self.account_grant = account_grant if account_grant is not None else None
        '''
         The requested AccountGrant.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountGrantGetResponse ' + \
            'account_grant: ' + repr(self.account_grant) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_grant': self.account_grant,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_grant=d.get('account_grant'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountUpdateResponse:
    '''
         AccountUpdateResponse returns the fields of a Account after it has been updated by
     a AccountUpdateRequest.
    '''
    __slots__ = [
        'account',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        account=None,
        meta=None,
        rate_limit=None,
    ):
        self.account = account if account is not None else None
        '''
         The updated Account.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountUpdateResponse ' + \
            'account: ' + repr(self.account) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account': self.account,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account=d.get('account'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AmazonEKS:
    __slots__ = [
        'access_key',
        'bind_interface',
        'certificate_authority',
        'cluster_name',
        'egress_filter',
        'endpoint',
        'healthcheck_namespace',
        'healthy',
        'id',
        'name',
        'region',
        'remote_identity_group_id',
        'remote_identity_healthcheck_username',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        certificate_authority=None,
        cluster_name=None,
        egress_filter=None,
        endpoint=None,
        healthcheck_namespace=None,
        healthy=None,
        id=None,
        name=None,
        region=None,
        remote_identity_group_id=None,
        remote_identity_healthcheck_username=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        self.cluster_name = cluster_name if cluster_name is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.region = region if region is not None else ''
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        self.remote_identity_healthcheck_username = remote_identity_healthcheck_username if remote_identity_healthcheck_username is not None else ''
        self.role_arn = role_arn if role_arn is not None else ''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AmazonEKS ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'cluster_name: ' + repr(self.cluster_name) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'remote_identity_healthcheck_username: ' + repr(self.remote_identity_healthcheck_username) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'cluster_name': self.cluster_name,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'region': self.region,
            'remote_identity_group_id': self.remote_identity_group_id,
            'remote_identity_healthcheck_username':
            self.remote_identity_healthcheck_username,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            cluster_name=d.get('cluster_name'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            region=d.get('region'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            remote_identity_healthcheck_username=d.get(
                'remote_identity_healthcheck_username'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
        )


class AmazonEKSInstanceProfile:
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'cluster_name',
        'egress_filter',
        'endpoint',
        'healthcheck_namespace',
        'healthy',
        'id',
        'name',
        'region',
        'remote_identity_group_id',
        'remote_identity_healthcheck_username',
        'role_arn',
        'role_external_id',
        'secret_store_id',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        cluster_name=None,
        egress_filter=None,
        endpoint=None,
        healthcheck_namespace=None,
        healthy=None,
        id=None,
        name=None,
        region=None,
        remote_identity_group_id=None,
        remote_identity_healthcheck_username=None,
        role_arn=None,
        role_external_id=None,
        secret_store_id=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        self.cluster_name = cluster_name if cluster_name is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.region = region if region is not None else ''
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        self.remote_identity_healthcheck_username = remote_identity_healthcheck_username if remote_identity_healthcheck_username is not None else ''
        self.role_arn = role_arn if role_arn is not None else ''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AmazonEKSInstanceProfile ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'cluster_name: ' + repr(self.cluster_name) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'remote_identity_healthcheck_username: ' + repr(self.remote_identity_healthcheck_username) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'cluster_name': self.cluster_name,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'region': self.region,
            'remote_identity_group_id': self.remote_identity_group_id,
            'remote_identity_healthcheck_username':
            self.remote_identity_healthcheck_username,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            cluster_name=d.get('cluster_name'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            region=d.get('region'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            remote_identity_healthcheck_username=d.get(
                'remote_identity_healthcheck_username'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
        )


class AmazonEKSUserImpersonation:
    __slots__ = [
        'access_key',
        'bind_interface',
        'certificate_authority',
        'cluster_name',
        'egress_filter',
        'endpoint',
        'healthcheck_namespace',
        'healthy',
        'id',
        'name',
        'region',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        certificate_authority=None,
        cluster_name=None,
        egress_filter=None,
        endpoint=None,
        healthcheck_namespace=None,
        healthy=None,
        id=None,
        name=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        self.cluster_name = cluster_name if cluster_name is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.region = region if region is not None else ''
        self.role_arn = role_arn if role_arn is not None else ''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AmazonEKSUserImpersonation ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'cluster_name: ' + repr(self.cluster_name) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'cluster_name': self.cluster_name,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            cluster_name=d.get('cluster_name'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
        )


class AmazonES:
    __slots__ = [
        'access_key',
        'bind_interface',
        'egress_filter',
        'endpoint',
        'healthy',
        'id',
        'name',
        'port_override',
        'region',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        egress_filter=None,
        endpoint=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        self.region = region if region is not None else ''
        self.role_arn = role_arn if role_arn is not None else ''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AmazonES ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
        )


class AmazonMQAMQP091:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.AmazonMQAMQP091 ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class Athena:
    __slots__ = [
        'access_key',
        'bind_interface',
        'egress_filter',
        'healthy',
        'id',
        'name',
        'output',
        'port_override',
        'region',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        id=None,
        name=None,
        output=None,
        port_override=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.output = output if output is not None else ''
        self.port_override = port_override if port_override is not None else 0
        self.region = region if region is not None else ''
        self.role_arn = role_arn if role_arn is not None else ''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.Athena ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'output: ' + repr(self.output) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'output': self.output,
            'port_override': self.port_override,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            output=d.get('output'),
            port_override=d.get('port_override'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
        )


class AuroraMysql:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.database = database if database is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.AuroraMysql ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class AuroraPostgres:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.database = database if database is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.AuroraPostgres ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Azure:
    __slots__ = [
        'app_id',
        'bind_interface',
        'egress_filter',
        'healthy',
        'id',
        'name',
        'password',
        'secret_store_id',
        'tags',
        'tenant_id',
    ]

    def __init__(
        self,
        app_id=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        id=None,
        name=None,
        password=None,
        secret_store_id=None,
        tags=None,
        tenant_id=None,
    ):
        self.app_id = app_id if app_id is not None else ''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tenant_id = tenant_id if tenant_id is not None else ''

    def __repr__(self):
        return '<sdm.Azure ' + \
            'app_id: ' + repr(self.app_id) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tenant_id: ' + repr(self.tenant_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'app_id': self.app_id,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'tenant_id': self.tenant_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            app_id=d.get('app_id'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            tenant_id=d.get('tenant_id'),
        )


class AzureCertificate:
    __slots__ = [
        'app_id',
        'bind_interface',
        'client_certificate',
        'egress_filter',
        'healthy',
        'id',
        'name',
        'secret_store_id',
        'tags',
        'tenant_id',
    ]

    def __init__(
        self,
        app_id=None,
        bind_interface=None,
        client_certificate=None,
        egress_filter=None,
        healthy=None,
        id=None,
        name=None,
        secret_store_id=None,
        tags=None,
        tenant_id=None,
    ):
        self.app_id = app_id if app_id is not None else ''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.client_certificate = client_certificate if client_certificate is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tenant_id = tenant_id if tenant_id is not None else ''

    def __repr__(self):
        return '<sdm.AzureCertificate ' + \
            'app_id: ' + repr(self.app_id) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'client_certificate: ' + repr(self.client_certificate) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tenant_id: ' + repr(self.tenant_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'app_id': self.app_id,
            'bind_interface': self.bind_interface,
            'client_certificate': self.client_certificate,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'tenant_id': self.tenant_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            app_id=d.get('app_id'),
            bind_interface=d.get('bind_interface'),
            client_certificate=d.get('client_certificate'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            tenant_id=d.get('tenant_id'),
        )


class AzureMysql:
    '''
    AzureMysql is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.database = database if database is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.AzureMysql ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class AzurePostgres:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.database = database if database is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.AzurePostgres ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class AzureStore:
    __slots__ = [
        'id',
        'name',
        'tags',
        'vault_uri',
    ]

    def __init__(
        self,
        id=None,
        name=None,
        tags=None,
        vault_uri=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.vault_uri = vault_uri if vault_uri is not None else ''

    def __repr__(self):
        return '<sdm.AzureStore ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'vault_uri: ' + repr(self.vault_uri) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
            'tags': self.tags,
            'vault_uri': self.vault_uri,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
            tags=d.get('tags'),
            vault_uri=d.get('vault_uri'),
        )


class BigQuery:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'endpoint',
        'healthy',
        'id',
        'name',
        'port_override',
        'private_key',
        'project',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        endpoint=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        private_key=None,
        project=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        self.private_key = private_key if private_key is not None else ''
        self.project = project if project is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.BigQuery ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'private_key: ' + repr(self.private_key) + ' ' +\
            'project: ' + repr(self.project) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'private_key': self.private_key,
            'project': self.project,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            private_key=d.get('private_key'),
            project=d.get('project'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Cassandra:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.Cassandra ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class Citus:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.database = database if database is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.Citus ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Clustrix:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.database = database if database is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.Clustrix ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Cockroach:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.database = database if database is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.Cockroach ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class ControlPanelGetSSHCAPublicKeyResponse:
    '''
         ControlPanelGetSSHCAPublicKeyResponse represents a request for an
     organization's SSH Certificate Authority public key.
    '''
    __slots__ = [
        'meta',
        'public_key',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        public_key=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.public_key = public_key if public_key is not None else ''
        '''
         The public key of the SSH Certificate Authority, in OpenSSH RSA public
         key format.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ControlPanelGetSSHCAPublicKeyResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'public_key: ' + repr(self.public_key) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'public_key': self.public_key,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            public_key=d.get('public_key'),
            rate_limit=d.get('rate_limit'),
        )


class ControlPanelVerifyJWTResponse:
    '''
         ControlPanelVerifyJWTResponse reports whether x-sdm-token is valid.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'valid',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        valid=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.valid = valid if valid is not None else False
        '''
         Reports if the given token is valid.
        '''

    def __repr__(self):
        return '<sdm.ControlPanelVerifyJWTResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'valid: ' + repr(self.valid) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'valid': self.valid,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            valid=d.get('valid'),
        )


class CreateResponseMetadata:
    '''
         CreateResponseMetadata is reserved for future use.
    '''
    __slots__ = []

    def __init__(self, ):
        pass

    def __repr__(self):
        return '<sdm.CreateResponseMetadata ' + \
            '>'

    def to_dict(self):
        return {}

    @classmethod
    def from_dict(cls, d):
        return cls()


class CyberarkConjurStore:
    __slots__ = [
        'appurl',
        'id',
        'name',
        'tags',
    ]

    def __init__(
        self,
        appurl=None,
        id=None,
        name=None,
        tags=None,
    ):
        self.appurl = appurl if appurl is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.CyberarkConjurStore ' + \
            'appurl: ' + repr(self.appurl) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'appurl': self.appurl,
            'id': self.id,
            'name': self.name,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            appurl=d.get('appurl'),
            id=d.get('id'),
            name=d.get('name'),
            tags=d.get('tags'),
        )


class CyberarkPAMExperimentalStore:
    '''
    CyberarkPAMExperimentalStore is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'appurl',
        'id',
        'name',
        'tags',
    ]

    def __init__(
        self,
        appurl=None,
        id=None,
        name=None,
        tags=None,
    ):
        self.appurl = appurl if appurl is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.CyberarkPAMExperimentalStore ' + \
            'appurl: ' + repr(self.appurl) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'appurl': self.appurl,
            'id': self.id,
            'name': self.name,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            appurl=d.get('appurl'),
            id=d.get('id'),
            name=d.get('name'),
            tags=d.get('tags'),
        )


class CyberarkPAMStore:
    __slots__ = [
        'appurl',
        'id',
        'name',
        'tags',
    ]

    def __init__(
        self,
        appurl=None,
        id=None,
        name=None,
        tags=None,
    ):
        self.appurl = appurl if appurl is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.CyberarkPAMStore ' + \
            'appurl: ' + repr(self.appurl) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'appurl': self.appurl,
            'id': self.id,
            'name': self.name,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            appurl=d.get('appurl'),
            id=d.get('id'),
            name=d.get('name'),
            tags=d.get('tags'),
        )


class DB2I:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.DB2I ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class DB2LUW:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.database = database if database is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.DB2LUW ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class DeleteResponseMetadata:
    '''
         DeleteResponseMetadata is reserved for future use.
    '''
    __slots__ = []

    def __init__(self, ):
        pass

    def __repr__(self):
        return '<sdm.DeleteResponseMetadata ' + \
            '>'

    def to_dict(self):
        return {}

    @classmethod
    def from_dict(cls, d):
        return cls()


class DelineaStore:
    '''
    DelineaStore is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'id',
        'name',
        'server_url',
        'tags',
        'tenant_name',
    ]

    def __init__(
        self,
        id=None,
        name=None,
        server_url=None,
        tags=None,
        tenant_name=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.server_url = server_url if server_url is not None else ''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tenant_name = tenant_name if tenant_name is not None else ''

    def __repr__(self):
        return '<sdm.DelineaStore ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'server_url: ' + repr(self.server_url) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tenant_name: ' + repr(self.tenant_name) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
            'server_url': self.server_url,
            'tags': self.tags,
            'tenant_name': self.tenant_name,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
            server_url=d.get('server_url'),
            tags=d.get('tags'),
            tenant_name=d.get('tenant_name'),
        )


class DocumentDBHost:
    __slots__ = [
        'auth_database',
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        auth_database=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.auth_database = auth_database if auth_database is not None else ''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.DocumentDBHost ' + \
            'auth_database: ' + repr(self.auth_database) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_database': self.auth_database,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_database=d.get('auth_database'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class DocumentDBReplicaSet:
    __slots__ = [
        'auth_database',
        'bind_interface',
        'connect_to_replica',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port_override',
        'replica_set',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        auth_database=None,
        bind_interface=None,
        connect_to_replica=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port_override=None,
        replica_set=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.auth_database = auth_database if auth_database is not None else ''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.connect_to_replica = connect_to_replica if connect_to_replica is not None else False
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         Hostname must contain the hostname/port pairs of all instances in the replica set separated by commas.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port_override = port_override if port_override is not None else 0
        self.replica_set = replica_set if replica_set is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.DocumentDBReplicaSet ' + \
            'auth_database: ' + repr(self.auth_database) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'connect_to_replica: ' + repr(self.connect_to_replica) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'replica_set: ' + repr(self.replica_set) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_database': self.auth_database,
            'bind_interface': self.bind_interface,
            'connect_to_replica': self.connect_to_replica,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port_override': self.port_override,
            'replica_set': self.replica_set,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_database=d.get('auth_database'),
            bind_interface=d.get('bind_interface'),
            connect_to_replica=d.get('connect_to_replica'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port_override=d.get('port_override'),
            replica_set=d.get('replica_set'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Druid:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.Druid ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class DynamoDB:
    __slots__ = [
        'access_key',
        'bind_interface',
        'egress_filter',
        'endpoint',
        'healthy',
        'id',
        'name',
        'port_override',
        'region',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        egress_filter=None,
        endpoint=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        self.region = region if region is not None else ''
        self.role_arn = role_arn if role_arn is not None else ''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.DynamoDB ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
        )


class Elastic:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.Elastic ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class ElasticacheRedis:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.ElasticacheRedis ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class GCP:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'id',
        'keyfile',
        'name',
        'scopes',
        'secret_store_id',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        id=None,
        keyfile=None,
        name=None,
        scopes=None,
        secret_store_id=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.keyfile = keyfile if keyfile is not None else ''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.scopes = scopes if scopes is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.GCP ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'keyfile: ' + repr(self.keyfile) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'scopes: ' + repr(self.scopes) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'id': self.id,
            'keyfile': self.keyfile,
            'name': self.name,
            'scopes': self.scopes,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            keyfile=d.get('keyfile'),
            name=d.get('name'),
            scopes=d.get('scopes'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
        )


class GCPStore:
    __slots__ = [
        'id',
        'name',
        'projectid',
        'tags',
    ]

    def __init__(
        self,
        id=None,
        name=None,
        projectid=None,
        tags=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.projectid = projectid if projectid is not None else ''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.GCPStore ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'projectid: ' + repr(self.projectid) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
            'projectid': self.projectid,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
            projectid=d.get('projectid'),
            tags=d.get('tags'),
        )


class Gateway:
    '''
         Gateway represents a StrongDM CLI installation running in gateway mode.
    '''
    __slots__ = [
        'bind_address',
        'device',
        'gateway_filter',
        'id',
        'listen_address',
        'location',
        'name',
        'state',
        'tags',
        'version',
    ]

    def __init__(
        self,
        bind_address=None,
        device=None,
        gateway_filter=None,
        id=None,
        listen_address=None,
        location=None,
        name=None,
        state=None,
        tags=None,
        version=None,
    ):
        self.bind_address = bind_address if bind_address is not None else ''
        '''
         The hostname/port tuple which the gateway daemon will bind to.
         If not provided on create, set to "0.0.0.0:listen_address_port".
        '''
        self.device = device if device is not None else ''
        '''
         Device is a read only device name uploaded by the gateway process when 
         it comes online.
        '''
        self.gateway_filter = gateway_filter if gateway_filter is not None else ''
        '''
         GatewayFilter can be used to restrict the peering between relays and
         gateways.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Gateway.
        '''
        self.listen_address = listen_address if listen_address is not None else ''
        '''
         The public hostname/port tuple at which the gateway will be accessible to clients.
        '''
        self.location = location if location is not None else ''
        '''
         Location is a read only network location uploaded by the gateway process
         when it comes online.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Gateway. Node names must include only letters, numbers, and hyphens (no spaces, underscores, or other special characters). Generated if not provided on create.
        '''
        self.state = state if state is not None else ''
        '''
         The current state of the gateway. One of: "new", "verifying_restart",
         "restarting", "started", "stopped", "dead", "unknown"
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.version = version if version is not None else ''
        '''
         Version is a read only sdm binary version uploaded by the gateway process
         when it comes online.
        '''

    def __repr__(self):
        return '<sdm.Gateway ' + \
            'bind_address: ' + repr(self.bind_address) + ' ' +\
            'device: ' + repr(self.device) + ' ' +\
            'gateway_filter: ' + repr(self.gateway_filter) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'listen_address: ' + repr(self.listen_address) + ' ' +\
            'location: ' + repr(self.location) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'state: ' + repr(self.state) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'version: ' + repr(self.version) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_address': self.bind_address,
            'device': self.device,
            'gateway_filter': self.gateway_filter,
            'id': self.id,
            'listen_address': self.listen_address,
            'location': self.location,
            'name': self.name,
            'state': self.state,
            'tags': self.tags,
            'version': self.version,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_address=d.get('bind_address'),
            device=d.get('device'),
            gateway_filter=d.get('gateway_filter'),
            id=d.get('id'),
            listen_address=d.get('listen_address'),
            location=d.get('location'),
            name=d.get('name'),
            state=d.get('state'),
            tags=d.get('tags'),
            version=d.get('version'),
        )


class GetResponseMetadata:
    '''
         GetResponseMetadata is reserved for future use.
    '''
    __slots__ = []

    def __init__(self, ):
        pass

    def __repr__(self):
        return '<sdm.GetResponseMetadata ' + \
            '>'

    def to_dict(self):
        return {}

    @classmethod
    def from_dict(cls, d):
        return cls()


class GoogleGKE:
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'egress_filter',
        'endpoint',
        'healthcheck_namespace',
        'healthy',
        'id',
        'name',
        'remote_identity_group_id',
        'remote_identity_healthcheck_username',
        'secret_store_id',
        'service_account_key',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        egress_filter=None,
        endpoint=None,
        healthcheck_namespace=None,
        healthy=None,
        id=None,
        name=None,
        remote_identity_group_id=None,
        remote_identity_healthcheck_username=None,
        secret_store_id=None,
        service_account_key=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        self.remote_identity_healthcheck_username = remote_identity_healthcheck_username if remote_identity_healthcheck_username is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.service_account_key = service_account_key if service_account_key is not None else ''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.GoogleGKE ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'remote_identity_healthcheck_username: ' + repr(self.remote_identity_healthcheck_username) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'service_account_key: ' + repr(self.service_account_key) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'remote_identity_group_id': self.remote_identity_group_id,
            'remote_identity_healthcheck_username':
            self.remote_identity_healthcheck_username,
            'secret_store_id': self.secret_store_id,
            'service_account_key': self.service_account_key,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            remote_identity_healthcheck_username=d.get(
                'remote_identity_healthcheck_username'),
            secret_store_id=d.get('secret_store_id'),
            service_account_key=d.get('service_account_key'),
            tags=d.get('tags'),
        )


class GoogleGKEUserImpersonation:
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'egress_filter',
        'endpoint',
        'healthcheck_namespace',
        'healthy',
        'id',
        'name',
        'secret_store_id',
        'service_account_key',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        egress_filter=None,
        endpoint=None,
        healthcheck_namespace=None,
        healthy=None,
        id=None,
        name=None,
        secret_store_id=None,
        service_account_key=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.service_account_key = service_account_key if service_account_key is not None else ''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.GoogleGKEUserImpersonation ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'service_account_key: ' + repr(self.service_account_key) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'secret_store_id': self.secret_store_id,
            'service_account_key': self.service_account_key,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            secret_store_id=d.get('secret_store_id'),
            service_account_key=d.get('service_account_key'),
            tags=d.get('tags'),
        )


class Greenplum:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.database = database if database is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.Greenplum ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class HTTPAuth:
    __slots__ = [
        'auth_header',
        'bind_interface',
        'default_path',
        'egress_filter',
        'headers_blacklist',
        'healthcheck_path',
        'healthy',
        'host_override',
        'id',
        'name',
        'secret_store_id',
        'subdomain',
        'tags',
        'url',
    ]

    def __init__(
        self,
        auth_header=None,
        bind_interface=None,
        default_path=None,
        egress_filter=None,
        headers_blacklist=None,
        healthcheck_path=None,
        healthy=None,
        host_override=None,
        id=None,
        name=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        url=None,
    ):
        self.auth_header = auth_header if auth_header is not None else ''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.default_path = default_path if default_path is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.headers_blacklist = headers_blacklist if headers_blacklist is not None else ''
        self.healthcheck_path = healthcheck_path if healthcheck_path is not None else ''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.host_override = host_override if host_override is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.url = url if url is not None else ''

    def __repr__(self):
        return '<sdm.HTTPAuth ' + \
            'auth_header: ' + repr(self.auth_header) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'default_path: ' + repr(self.default_path) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'headers_blacklist: ' + repr(self.headers_blacklist) + ' ' +\
            'healthcheck_path: ' + repr(self.healthcheck_path) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'host_override: ' + repr(self.host_override) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'url: ' + repr(self.url) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_header': self.auth_header,
            'bind_interface': self.bind_interface,
            'default_path': self.default_path,
            'egress_filter': self.egress_filter,
            'headers_blacklist': self.headers_blacklist,
            'healthcheck_path': self.healthcheck_path,
            'healthy': self.healthy,
            'host_override': self.host_override,
            'id': self.id,
            'name': self.name,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'url': self.url,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_header=d.get('auth_header'),
            bind_interface=d.get('bind_interface'),
            default_path=d.get('default_path'),
            egress_filter=d.get('egress_filter'),
            headers_blacklist=d.get('headers_blacklist'),
            healthcheck_path=d.get('healthcheck_path'),
            healthy=d.get('healthy'),
            host_override=d.get('host_override'),
            id=d.get('id'),
            name=d.get('name'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            url=d.get('url'),
        )


class HTTPBasicAuth:
    __slots__ = [
        'bind_interface',
        'default_path',
        'egress_filter',
        'headers_blacklist',
        'healthcheck_path',
        'healthy',
        'host_override',
        'id',
        'name',
        'password',
        'secret_store_id',
        'subdomain',
        'tags',
        'url',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        default_path=None,
        egress_filter=None,
        headers_blacklist=None,
        healthcheck_path=None,
        healthy=None,
        host_override=None,
        id=None,
        name=None,
        password=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        url=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.default_path = default_path if default_path is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.headers_blacklist = headers_blacklist if headers_blacklist is not None else ''
        self.healthcheck_path = healthcheck_path if healthcheck_path is not None else ''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.host_override = host_override if host_override is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.url = url if url is not None else ''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.HTTPBasicAuth ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'default_path: ' + repr(self.default_path) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'headers_blacklist: ' + repr(self.headers_blacklist) + ' ' +\
            'healthcheck_path: ' + repr(self.healthcheck_path) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'host_override: ' + repr(self.host_override) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'url: ' + repr(self.url) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'default_path': self.default_path,
            'egress_filter': self.egress_filter,
            'headers_blacklist': self.headers_blacklist,
            'healthcheck_path': self.healthcheck_path,
            'healthy': self.healthy,
            'host_override': self.host_override,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'url': self.url,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            default_path=d.get('default_path'),
            egress_filter=d.get('egress_filter'),
            headers_blacklist=d.get('headers_blacklist'),
            healthcheck_path=d.get('healthcheck_path'),
            healthy=d.get('healthy'),
            host_override=d.get('host_override'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            url=d.get('url'),
            username=d.get('username'),
        )


class HTTPNoAuth:
    __slots__ = [
        'bind_interface',
        'default_path',
        'egress_filter',
        'headers_blacklist',
        'healthcheck_path',
        'healthy',
        'host_override',
        'id',
        'name',
        'secret_store_id',
        'subdomain',
        'tags',
        'url',
    ]

    def __init__(
        self,
        bind_interface=None,
        default_path=None,
        egress_filter=None,
        headers_blacklist=None,
        healthcheck_path=None,
        healthy=None,
        host_override=None,
        id=None,
        name=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        url=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.default_path = default_path if default_path is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.headers_blacklist = headers_blacklist if headers_blacklist is not None else ''
        self.healthcheck_path = healthcheck_path if healthcheck_path is not None else ''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.host_override = host_override if host_override is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.url = url if url is not None else ''

    def __repr__(self):
        return '<sdm.HTTPNoAuth ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'default_path: ' + repr(self.default_path) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'headers_blacklist: ' + repr(self.headers_blacklist) + ' ' +\
            'healthcheck_path: ' + repr(self.healthcheck_path) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'host_override: ' + repr(self.host_override) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'url: ' + repr(self.url) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'default_path': self.default_path,
            'egress_filter': self.egress_filter,
            'headers_blacklist': self.headers_blacklist,
            'healthcheck_path': self.healthcheck_path,
            'healthy': self.healthy,
            'host_override': self.host_override,
            'id': self.id,
            'name': self.name,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'url': self.url,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            default_path=d.get('default_path'),
            egress_filter=d.get('egress_filter'),
            headers_blacklist=d.get('headers_blacklist'),
            healthcheck_path=d.get('healthcheck_path'),
            healthy=d.get('healthy'),
            host_override=d.get('host_override'),
            id=d.get('id'),
            name=d.get('name'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            url=d.get('url'),
        )


class Kubernetes:
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'client_certificate',
        'client_key',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'remote_identity_group_id',
        'remote_identity_healthcheck_username',
        'secret_store_id',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        client_certificate=None,
        client_key=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        remote_identity_group_id=None,
        remote_identity_healthcheck_username=None,
        secret_store_id=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        self.client_certificate = client_certificate if client_certificate is not None else ''
        self.client_key = client_key if client_key is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        self.remote_identity_healthcheck_username = remote_identity_healthcheck_username if remote_identity_healthcheck_username is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.Kubernetes ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'client_certificate: ' + repr(self.client_certificate) + ' ' +\
            'client_key: ' + repr(self.client_key) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'remote_identity_healthcheck_username: ' + repr(self.remote_identity_healthcheck_username) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'client_certificate': self.client_certificate,
            'client_key': self.client_key,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'remote_identity_group_id': self.remote_identity_group_id,
            'remote_identity_healthcheck_username':
            self.remote_identity_healthcheck_username,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            client_certificate=d.get('client_certificate'),
            client_key=d.get('client_key'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            remote_identity_healthcheck_username=d.get(
                'remote_identity_healthcheck_username'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
        )


class KubernetesBasicAuth:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.KubernetesBasicAuth ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class KubernetesServiceAccount:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'remote_identity_group_id',
        'remote_identity_healthcheck_username',
        'secret_store_id',
        'tags',
        'token',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        remote_identity_group_id=None,
        remote_identity_healthcheck_username=None,
        secret_store_id=None,
        tags=None,
        token=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        self.remote_identity_healthcheck_username = remote_identity_healthcheck_username if remote_identity_healthcheck_username is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.token = token if token is not None else ''

    def __repr__(self):
        return '<sdm.KubernetesServiceAccount ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'remote_identity_healthcheck_username: ' + repr(self.remote_identity_healthcheck_username) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'token: ' + repr(self.token) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'remote_identity_group_id': self.remote_identity_group_id,
            'remote_identity_healthcheck_username':
            self.remote_identity_healthcheck_username,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'token': self.token,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            remote_identity_healthcheck_username=d.get(
                'remote_identity_healthcheck_username'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            token=d.get('token'),
        )


class KubernetesServiceAccountUserImpersonation:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'token',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        token=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.token = token if token is not None else ''

    def __repr__(self):
        return '<sdm.KubernetesServiceAccountUserImpersonation ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'token: ' + repr(self.token) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'token': self.token,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            token=d.get('token'),
        )


class KubernetesUserImpersonation:
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'client_certificate',
        'client_key',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        client_certificate=None,
        client_key=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        self.client_certificate = client_certificate if client_certificate is not None else ''
        self.client_key = client_key if client_key is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.KubernetesUserImpersonation ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'client_certificate: ' + repr(self.client_certificate) + ' ' +\
            'client_key: ' + repr(self.client_key) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'client_certificate': self.client_certificate,
            'client_key': self.client_key,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            client_certificate=d.get('client_certificate'),
            client_key=d.get('client_key'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
        )


class MTLSMysql:
    '''
    MTLSMysql is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'client_certificate',
        'client_key',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'server_name',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        client_certificate=None,
        client_key=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        server_name=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        self.client_certificate = client_certificate if client_certificate is not None else ''
        self.client_key = client_key if client_key is not None else ''
        self.database = database if database is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.server_name = server_name if server_name is not None else ''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.MTLSMysql ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'client_certificate: ' + repr(self.client_certificate) + ' ' +\
            'client_key: ' + repr(self.client_key) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'server_name: ' + repr(self.server_name) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'client_certificate': self.client_certificate,
            'client_key': self.client_key,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'server_name': self.server_name,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            client_certificate=d.get('client_certificate'),
            client_key=d.get('client_key'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            server_name=d.get('server_name'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class MTLSPostgres:
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'client_certificate',
        'client_key',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'server_name',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        client_certificate=None,
        client_key=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        server_name=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        self.client_certificate = client_certificate if client_certificate is not None else ''
        self.client_key = client_key if client_key is not None else ''
        self.database = database if database is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.server_name = server_name if server_name is not None else ''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.MTLSPostgres ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'client_certificate: ' + repr(self.client_certificate) + ' ' +\
            'client_key: ' + repr(self.client_key) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'server_name: ' + repr(self.server_name) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'client_certificate': self.client_certificate,
            'client_key': self.client_key,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'server_name': self.server_name,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            client_certificate=d.get('client_certificate'),
            client_key=d.get('client_key'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            server_name=d.get('server_name'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Maria:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.database = database if database is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.Maria ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Memcached:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.Memcached ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
        )


class Memsql:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.database = database if database is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.Memsql ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class MongoHost:
    '''
    MongoHost is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'auth_database',
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        auth_database=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.auth_database = auth_database if auth_database is not None else ''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.MongoHost ' + \
            'auth_database: ' + repr(self.auth_database) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_database': self.auth_database,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_database=d.get('auth_database'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class MongoLegacyHost:
    __slots__ = [
        'auth_database',
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'replica_set',
        'secret_store_id',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        auth_database=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        replica_set=None,
        secret_store_id=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.auth_database = auth_database if auth_database is not None else ''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.replica_set = replica_set if replica_set is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.MongoLegacyHost ' + \
            'auth_database: ' + repr(self.auth_database) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'replica_set: ' + repr(self.replica_set) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_database': self.auth_database,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'replica_set': self.replica_set,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_database=d.get('auth_database'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            replica_set=d.get('replica_set'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class MongoLegacyReplicaset:
    __slots__ = [
        'auth_database',
        'bind_interface',
        'connect_to_replica',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'replica_set',
        'secret_store_id',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        auth_database=None,
        bind_interface=None,
        connect_to_replica=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        replica_set=None,
        secret_store_id=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.auth_database = auth_database if auth_database is not None else ''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.connect_to_replica = connect_to_replica if connect_to_replica is not None else False
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.replica_set = replica_set if replica_set is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.MongoLegacyReplicaset ' + \
            'auth_database: ' + repr(self.auth_database) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'connect_to_replica: ' + repr(self.connect_to_replica) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'replica_set: ' + repr(self.replica_set) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_database': self.auth_database,
            'bind_interface': self.bind_interface,
            'connect_to_replica': self.connect_to_replica,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'replica_set': self.replica_set,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_database=d.get('auth_database'),
            bind_interface=d.get('bind_interface'),
            connect_to_replica=d.get('connect_to_replica'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            replica_set=d.get('replica_set'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class MongoReplicaSet:
    '''
    MongoReplicaSet is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'auth_database',
        'bind_interface',
        'connect_to_replica',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'replica_set',
        'secret_store_id',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        auth_database=None,
        bind_interface=None,
        connect_to_replica=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        replica_set=None,
        secret_store_id=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.auth_database = auth_database if auth_database is not None else ''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.connect_to_replica = connect_to_replica if connect_to_replica is not None else False
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.replica_set = replica_set if replica_set is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.MongoReplicaSet ' + \
            'auth_database: ' + repr(self.auth_database) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'connect_to_replica: ' + repr(self.connect_to_replica) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'replica_set: ' + repr(self.replica_set) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_database': self.auth_database,
            'bind_interface': self.bind_interface,
            'connect_to_replica': self.connect_to_replica,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'replica_set': self.replica_set,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_database=d.get('auth_database'),
            bind_interface=d.get('bind_interface'),
            connect_to_replica=d.get('connect_to_replica'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            replica_set=d.get('replica_set'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class MongoShardedCluster:
    '''
    MongoShardedCluster is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'auth_database',
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port_override',
        'secret_store_id',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        auth_database=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.auth_database = auth_database if auth_database is not None else ''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.MongoShardedCluster ' + \
            'auth_database: ' + repr(self.auth_database) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_database': self.auth_database,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_database=d.get('auth_database'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class Mysql:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.database = database if database is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.Mysql ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Neptune:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'endpoint',
        'healthy',
        'id',
        'name',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        endpoint=None,
        healthy=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.Neptune ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
        )


class NeptuneIAM:
    __slots__ = [
        'access_key',
        'bind_interface',
        'egress_filter',
        'endpoint',
        'healthy',
        'id',
        'name',
        'port',
        'port_override',
        'region',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        egress_filter=None,
        endpoint=None,
        healthy=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.region = region if region is not None else ''
        self.role_arn = role_arn if role_arn is not None else ''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.NeptuneIAM ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
        )


class NodeCreateResponse:
    '''
         NodeCreateResponse reports how the Nodes were created in the system.
    '''
    __slots__ = [
        'meta',
        'node',
        'rate_limit',
        'token',
    ]

    def __init__(
        self,
        meta=None,
        node=None,
        rate_limit=None,
        token=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.node = node if node is not None else None
        '''
         The created Node.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.token = token if token is not None else ''
        '''
         The auth token generated for the Node. The Node will use this token to
         authenticate with the strongDM API.
        '''

    def __repr__(self):
        return '<sdm.NodeCreateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'node: ' + repr(self.node) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'token: ' + repr(self.token) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'node': self.node,
            'rate_limit': self.rate_limit,
            'token': self.token,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            node=d.get('node'),
            rate_limit=d.get('rate_limit'),
            token=d.get('token'),
        )


class NodeDeleteResponse:
    '''
         NodeDeleteResponse returns information about a Node that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.NodeDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class NodeGetResponse:
    '''
         NodeGetResponse returns a requested Node.
    '''
    __slots__ = [
        'meta',
        'node',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        node=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.node = node if node is not None else None
        '''
         The requested Node.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.NodeGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'node: ' + repr(self.node) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'node': self.node,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            node=d.get('node'),
            rate_limit=d.get('rate_limit'),
        )


class NodeUpdateResponse:
    '''
         NodeUpdateResponse returns the fields of a Node after it has been updated by
     a NodeUpdateRequest.
    '''
    __slots__ = [
        'meta',
        'node',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        node=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.node = node if node is not None else None
        '''
         The updated Node.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.NodeUpdateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'node: ' + repr(self.node) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'node': self.node,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            node=d.get('node'),
            rate_limit=d.get('rate_limit'),
        )


class Oracle:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.database = database if database is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.Oracle ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class Postgres:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.database = database if database is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.Postgres ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Presto:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.database = database if database is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.Presto ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class RDP:
    __slots__ = [
        'bind_interface',
        'downgrade_nla_connections',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        downgrade_nla_connections=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.downgrade_nla_connections = downgrade_nla_connections if downgrade_nla_connections is not None else False
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.RDP ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'downgrade_nla_connections: ' + repr(self.downgrade_nla_connections) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'downgrade_nla_connections': self.downgrade_nla_connections,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            downgrade_nla_connections=d.get('downgrade_nla_connections'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class RabbitMQAMQP091:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.RabbitMQAMQP091 ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class RateLimitMetadata:
    '''
         RateLimitMetadata contains information about remaining requests avaialable
     to the user over some timeframe.
    '''
    __slots__ = [
        'bucket',
        'limit',
        'remaining',
        'reset_at',
    ]

    def __init__(
        self,
        bucket=None,
        limit=None,
        remaining=None,
        reset_at=None,
    ):
        self.bucket = bucket if bucket is not None else ''
        '''
         The bucket this user/token is associated with, which may be shared between
         multiple users/tokens.
        '''
        self.limit = limit if limit is not None else 0
        '''
         How many total requests the user/token is authorized to make before being
         rate limited.
        '''
        self.remaining = remaining if remaining is not None else 0
        '''
         How many remaining requests out of the limit are still avaialable.
        '''
        self.reset_at = reset_at if reset_at is not None else None
        '''
         The time when remaining will be reset to limit.
        '''

    def __repr__(self):
        return '<sdm.RateLimitMetadata ' + \
            'bucket: ' + repr(self.bucket) + ' ' +\
            'limit: ' + repr(self.limit) + ' ' +\
            'remaining: ' + repr(self.remaining) + ' ' +\
            'reset_at: ' + repr(self.reset_at) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bucket': self.bucket,
            'limit': self.limit,
            'remaining': self.remaining,
            'reset_at': self.reset_at,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bucket=d.get('bucket'),
            limit=d.get('limit'),
            remaining=d.get('remaining'),
            reset_at=d.get('reset_at'),
        )


class RawTCP:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.RawTCP ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
        )


class Redis:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.Redis ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class Redshift:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.database = database if database is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.Redshift ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Relay:
    '''
         Relay represents a StrongDM CLI installation running in relay mode.
    '''
    __slots__ = [
        'device',
        'gateway_filter',
        'id',
        'location',
        'name',
        'state',
        'tags',
        'version',
    ]

    def __init__(
        self,
        device=None,
        gateway_filter=None,
        id=None,
        location=None,
        name=None,
        state=None,
        tags=None,
        version=None,
    ):
        self.device = device if device is not None else ''
        '''
         Device is a read only device name uploaded by the gateway process when 
         it comes online.
        '''
        self.gateway_filter = gateway_filter if gateway_filter is not None else ''
        '''
         GatewayFilter can be used to restrict the peering between relays and
         gateways.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Relay.
        '''
        self.location = location if location is not None else ''
        '''
         Location is a read only network location uploaded by the gateway process
         when it comes online.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Relay. Node names must include only letters, numbers, and hyphens (no spaces, underscores, or other special characters). Generated if not provided on create.
        '''
        self.state = state if state is not None else ''
        '''
         The current state of the relay. One of: "new", "verifying_restart",
         "awaiting_restart", "restarting", "started", "stopped", "dead",
         "unknown".
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.version = version if version is not None else ''
        '''
         Version is a read only sdm binary version uploaded by the gateway process
         when it comes online.
        '''

    def __repr__(self):
        return '<sdm.Relay ' + \
            'device: ' + repr(self.device) + ' ' +\
            'gateway_filter: ' + repr(self.gateway_filter) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'location: ' + repr(self.location) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'state: ' + repr(self.state) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'version: ' + repr(self.version) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'device': self.device,
            'gateway_filter': self.gateway_filter,
            'id': self.id,
            'location': self.location,
            'name': self.name,
            'state': self.state,
            'tags': self.tags,
            'version': self.version,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            device=d.get('device'),
            gateway_filter=d.get('gateway_filter'),
            id=d.get('id'),
            location=d.get('location'),
            name=d.get('name'),
            state=d.get('state'),
            tags=d.get('tags'),
            version=d.get('version'),
        )


class RemoteIdentity:
    '''
         RemoteIdentities define the username to be used for a specific account
     when connecting to a remote resource using that group.
    '''
    __slots__ = [
        'account_id',
        'id',
        'remote_identity_group_id',
        'username',
    ]

    def __init__(
        self,
        account_id=None,
        id=None,
        remote_identity_group_id=None,
        username=None,
    ):
        self.account_id = account_id if account_id is not None else ''
        '''
         The account for this remote identity.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the RemoteIdentity.
        '''
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        '''
         The remote identity group.
        '''
        self.username = username if username is not None else ''
        '''
         The username to be used as the remote identity for this account.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentity ' + \
            'account_id: ' + repr(self.account_id) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_id': self.account_id,
            'id': self.id,
            'remote_identity_group_id': self.remote_identity_group_id,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_id=d.get('account_id'),
            id=d.get('id'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            username=d.get('username'),
        )


class RemoteIdentityCreateResponse:
    '''
         RemoteIdentityCreateResponse reports how the RemoteIdentities were created in the system.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'remote_identity',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        remote_identity=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.remote_identity = remote_identity if remote_identity is not None else None
        '''
         The created RemoteIdentity.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentityCreateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'remote_identity: ' + repr(self.remote_identity) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'remote_identity': self.remote_identity,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            remote_identity=d.get('remote_identity'),
        )


class RemoteIdentityDeleteResponse:
    '''
         RemoteIdentityDeleteResponse returns information about a RemoteIdentity that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentityDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class RemoteIdentityGetResponse:
    '''
         RemoteIdentityGetResponse returns a requested RemoteIdentity.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'remote_identity',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        remote_identity=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.remote_identity = remote_identity if remote_identity is not None else None
        '''
         The requested RemoteIdentity.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentityGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'remote_identity: ' + repr(self.remote_identity) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'remote_identity': self.remote_identity,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            remote_identity=d.get('remote_identity'),
        )


class RemoteIdentityGroup:
    '''
         A RemoteIdentityGroup defines a group of remote identities.
    '''
    __slots__ = [
        'id',
        'name',
    ]

    def __init__(
        self,
        id=None,
        name=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the RemoteIdentityGroup.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the RemoteIdentityGroup.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentityGroup ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
        )


class RemoteIdentityGroupGetResponse:
    '''
         RemoteIdentityGroupGetResponse returns a requested RemoteIdentityGroup.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'remote_identity_group',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        remote_identity_group=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.remote_identity_group = remote_identity_group if remote_identity_group is not None else None
        '''
         The requested RemoteIdentityGroup.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentityGroupGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'remote_identity_group: ' + repr(self.remote_identity_group) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'remote_identity_group': self.remote_identity_group,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            remote_identity_group=d.get('remote_identity_group'),
        )


class RemoteIdentityUpdateResponse:
    '''
         RemoteIdentityUpdateResponse returns the fields of a RemoteIdentity after it has been updated by
     a RemoteIdentityUpdateRequest.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'remote_identity',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        remote_identity=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.remote_identity = remote_identity if remote_identity is not None else None
        '''
         The updated RemoteIdentity.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentityUpdateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'remote_identity: ' + repr(self.remote_identity) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'remote_identity': self.remote_identity,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            remote_identity=d.get('remote_identity'),
        )


class ResourceCreateResponse:
    '''
         ResourceCreateResponse reports how the Resources were created in the system.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'resource',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        resource=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.resource = resource if resource is not None else None
        '''
         The created Resource.
        '''

    def __repr__(self):
        return '<sdm.ResourceCreateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'resource: ' + repr(self.resource) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'resource': self.resource,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            resource=d.get('resource'),
        )


class ResourceDeleteResponse:
    '''
         ResourceDeleteResponse returns information about a Resource that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ResourceDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class ResourceGetResponse:
    '''
         ResourceGetResponse returns a requested Resource.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'resource',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        resource=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.resource = resource if resource is not None else None
        '''
         The requested Resource.
        '''

    def __repr__(self):
        return '<sdm.ResourceGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'resource: ' + repr(self.resource) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'resource': self.resource,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            resource=d.get('resource'),
        )


class ResourceUpdateResponse:
    '''
         ResourceUpdateResponse returns the fields of a Resource after it has been updated by
     a ResourceUpdateRequest.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'resource',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        resource=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.resource = resource if resource is not None else None
        '''
         The updated Resource.
        '''

    def __repr__(self):
        return '<sdm.ResourceUpdateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'resource: ' + repr(self.resource) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'resource': self.resource,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            resource=d.get('resource'),
        )


class Role:
    '''
         A Role has a list of access rules which determine which Resources the members
     of the Role have access to. An Account can be a member of multiple Roles via
     AccountAttachments.
    '''
    __slots__ = [
        'access_rules',
        'id',
        'managed_by',
        'name',
        'tags',
    ]

    def __init__(
        self,
        access_rules=None,
        id=None,
        managed_by=None,
        name=None,
        tags=None,
    ):
        self.access_rules = access_rules if access_rules is not None else _porcelain_zero_value_access_rules(
        )
        '''
         AccessRules is a list of access rules defining the resources this Role has access to.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Role.
        '''
        self.managed_by = managed_by if managed_by is not None else ''
        '''
         Managed By is a read only field for what service manages this role, e.g. StrongDM, Okta, Azure.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Role.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.Role ' + \
            'access_rules: ' + repr(self.access_rules) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'managed_by: ' + repr(self.managed_by) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_rules': self.access_rules,
            'id': self.id,
            'managed_by': self.managed_by,
            'name': self.name,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_rules=d.get('access_rules'),
            id=d.get('id'),
            managed_by=d.get('managed_by'),
            name=d.get('name'),
            tags=d.get('tags'),
        )


class RoleCreateResponse:
    '''
         RoleCreateResponse reports how the Roles were created in the system. It can
     communicate partial successes or failures.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'role',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        role=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.role = role if role is not None else None
        '''
         The created Role.
        '''

    def __repr__(self):
        return '<sdm.RoleCreateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'role: ' + repr(self.role) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'role': self.role,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            role=d.get('role'),
        )


class RoleDeleteResponse:
    '''
         RoleDeleteResponse returns information about a Role that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.RoleDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class RoleGetResponse:
    '''
         RoleGetResponse returns a requested Role.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'role',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        role=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.role = role if role is not None else None
        '''
         The requested Role.
        '''

    def __repr__(self):
        return '<sdm.RoleGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'role: ' + repr(self.role) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'role': self.role,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            role=d.get('role'),
        )


class RoleUpdateResponse:
    '''
         RoleUpdateResponse returns the fields of a Role after it has been updated by
     a RoleUpdateRequest.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'role',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        role=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.role = role if role is not None else None
        '''
         The updated Role.
        '''

    def __repr__(self):
        return '<sdm.RoleUpdateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'role: ' + repr(self.role) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'role': self.role,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            role=d.get('role'),
        )


class SQLServer:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'schema',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        schema=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.database = database if database is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.schema = schema if schema is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.SQLServer ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'schema: ' + repr(self.schema) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'schema': self.schema,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            schema=d.get('schema'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class SSH:
    __slots__ = [
        'allow_deprecated_key_exchanges',
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'key_type',
        'name',
        'port',
        'port_forwarding',
        'port_override',
        'public_key',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        allow_deprecated_key_exchanges=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        key_type=None,
        name=None,
        port=None,
        port_forwarding=None,
        port_override=None,
        public_key=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.allow_deprecated_key_exchanges = allow_deprecated_key_exchanges if allow_deprecated_key_exchanges is not None else False
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.key_type = key_type if key_type is not None else ''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        self.port_forwarding = port_forwarding if port_forwarding is not None else False
        self.port_override = port_override if port_override is not None else 0
        self.public_key = public_key if public_key is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.SSH ' + \
            'allow_deprecated_key_exchanges: ' + repr(self.allow_deprecated_key_exchanges) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'key_type: ' + repr(self.key_type) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_forwarding: ' + repr(self.port_forwarding) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'public_key: ' + repr(self.public_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'allow_deprecated_key_exchanges':
            self.allow_deprecated_key_exchanges,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'key_type': self.key_type,
            'name': self.name,
            'port': self.port,
            'port_forwarding': self.port_forwarding,
            'port_override': self.port_override,
            'public_key': self.public_key,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            allow_deprecated_key_exchanges=d.get(
                'allow_deprecated_key_exchanges'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            key_type=d.get('key_type'),
            name=d.get('name'),
            port=d.get('port'),
            port_forwarding=d.get('port_forwarding'),
            port_override=d.get('port_override'),
            public_key=d.get('public_key'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class SSHCert:
    __slots__ = [
        'allow_deprecated_key_exchanges',
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'key_type',
        'name',
        'port',
        'port_forwarding',
        'port_override',
        'remote_identity_group_id',
        'remote_identity_healthcheck_username',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        allow_deprecated_key_exchanges=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        key_type=None,
        name=None,
        port=None,
        port_forwarding=None,
        port_override=None,
        remote_identity_group_id=None,
        remote_identity_healthcheck_username=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.allow_deprecated_key_exchanges = allow_deprecated_key_exchanges if allow_deprecated_key_exchanges is not None else False
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.key_type = key_type if key_type is not None else ''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        self.port_forwarding = port_forwarding if port_forwarding is not None else False
        self.port_override = port_override if port_override is not None else 0
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        self.remote_identity_healthcheck_username = remote_identity_healthcheck_username if remote_identity_healthcheck_username is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.SSHCert ' + \
            'allow_deprecated_key_exchanges: ' + repr(self.allow_deprecated_key_exchanges) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'key_type: ' + repr(self.key_type) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_forwarding: ' + repr(self.port_forwarding) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'remote_identity_healthcheck_username: ' + repr(self.remote_identity_healthcheck_username) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'allow_deprecated_key_exchanges':
            self.allow_deprecated_key_exchanges,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'key_type': self.key_type,
            'name': self.name,
            'port': self.port,
            'port_forwarding': self.port_forwarding,
            'port_override': self.port_override,
            'remote_identity_group_id': self.remote_identity_group_id,
            'remote_identity_healthcheck_username':
            self.remote_identity_healthcheck_username,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            allow_deprecated_key_exchanges=d.get(
                'allow_deprecated_key_exchanges'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            key_type=d.get('key_type'),
            name=d.get('name'),
            port=d.get('port'),
            port_forwarding=d.get('port_forwarding'),
            port_override=d.get('port_override'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            remote_identity_healthcheck_username=d.get(
                'remote_identity_healthcheck_username'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class SSHCustomerKey:
    __slots__ = [
        'allow_deprecated_key_exchanges',
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_forwarding',
        'port_override',
        'private_key',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        allow_deprecated_key_exchanges=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_forwarding=None,
        port_override=None,
        private_key=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.allow_deprecated_key_exchanges = allow_deprecated_key_exchanges if allow_deprecated_key_exchanges is not None else False
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        self.port_forwarding = port_forwarding if port_forwarding is not None else False
        self.port_override = port_override if port_override is not None else 0
        self.private_key = private_key if private_key is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.SSHCustomerKey ' + \
            'allow_deprecated_key_exchanges: ' + repr(self.allow_deprecated_key_exchanges) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_forwarding: ' + repr(self.port_forwarding) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'private_key: ' + repr(self.private_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'allow_deprecated_key_exchanges':
            self.allow_deprecated_key_exchanges,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_forwarding': self.port_forwarding,
            'port_override': self.port_override,
            'private_key': self.private_key,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            allow_deprecated_key_exchanges=d.get(
                'allow_deprecated_key_exchanges'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_forwarding=d.get('port_forwarding'),
            port_override=d.get('port_override'),
            private_key=d.get('private_key'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class SecretStoreCreateResponse:
    '''
         SecretStoreCreateResponse reports how the SecretStores were created in the system.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'secret_store',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        secret_store=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.secret_store = secret_store if secret_store is not None else None
        '''
         The created SecretStore.
        '''

    def __repr__(self):
        return '<sdm.SecretStoreCreateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'secret_store: ' + repr(self.secret_store) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'secret_store': self.secret_store,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            secret_store=d.get('secret_store'),
        )


class SecretStoreDeleteResponse:
    '''
         SecretStoreDeleteResponse returns information about a SecretStore that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.SecretStoreDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class SecretStoreGetResponse:
    '''
         SecretStoreGetResponse returns a requested SecretStore.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'secret_store',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        secret_store=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.secret_store = secret_store if secret_store is not None else None
        '''
         The requested SecretStore.
        '''

    def __repr__(self):
        return '<sdm.SecretStoreGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'secret_store: ' + repr(self.secret_store) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'secret_store': self.secret_store,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            secret_store=d.get('secret_store'),
        )


class SecretStoreUpdateResponse:
    '''
         SecretStoreUpdateResponse returns the fields of a SecretStore after it has been updated by
     a SecretStoreUpdateRequest.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'secret_store',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        secret_store=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.secret_store = secret_store if secret_store is not None else None
        '''
         The updated SecretStore.
        '''

    def __repr__(self):
        return '<sdm.SecretStoreUpdateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'secret_store: ' + repr(self.secret_store) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'secret_store': self.secret_store,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            secret_store=d.get('secret_store'),
        )


class Service:
    '''
         A Service is a service account that can connect to resources they are granted
     directly, or granted via roles. Services are typically automated jobs.
    '''
    __slots__ = [
        'id',
        'name',
        'suspended',
        'tags',
    ]

    def __init__(
        self,
        id=None,
        name=None,
        suspended=None,
        tags=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Service.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Service.
        '''
        self.suspended = suspended if suspended is not None else False
        '''
         The Service's suspended state.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.Service ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'suspended: ' + repr(self.suspended) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
            'suspended': self.suspended,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
            suspended=d.get('suspended'),
            tags=d.get('tags'),
        )


class SingleStore:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.database = database if database is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.SingleStore ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Snowflake:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port_override',
        'schema',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port_override=None,
        schema=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.database = database if database is not None else ''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port_override = port_override if port_override is not None else 0
        self.schema = schema if schema is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.Snowflake ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'schema: ' + repr(self.schema) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port_override': self.port_override,
            'schema': self.schema,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port_override=d.get('port_override'),
            schema=d.get('schema'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Snowsight:
    '''
    Snowsight is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthcheck_username',
        'healthy',
        'id',
        'name',
        'port_override',
        'samlmetadata',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthcheck_username=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        samlmetadata=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_username = healthcheck_username if healthcheck_username is not None else ''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        self.samlmetadata = samlmetadata if samlmetadata is not None else ''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.Snowsight ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_username: ' + repr(self.healthcheck_username) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'samlmetadata: ' + repr(self.samlmetadata) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthcheck_username': self.healthcheck_username,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'samlmetadata': self.samlmetadata,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthcheck_username=d.get('healthcheck_username'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            samlmetadata=d.get('samlmetadata'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class Sybase:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.Sybase ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class SybaseIQ:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.SybaseIQ ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Tag:
    __slots__ = [
        'name',
        'value',
    ]

    def __init__(
        self,
        name=None,
        value=None,
    ):
        self.name = name if name is not None else ''
        self.value = value if value is not None else ''

    def __repr__(self):
        return '<sdm.Tag ' + \
            'name: ' + repr(self.name) + ' ' +\
            'value: ' + repr(self.value) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'name': self.name,
            'value': self.value,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            name=d.get('name'),
            value=d.get('value'),
        )


class Teradata:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         Bind interface
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        self.port = port if port is not None else 0
        self.port_override = port_override if port_override is not None else 0
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''

    def __repr__(self):
        return '<sdm.Teradata ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class UpdateResponseMetadata:
    '''
         UpdateResponseMetadata is reserved for future use.
    '''
    __slots__ = []

    def __init__(self, ):
        pass

    def __repr__(self):
        return '<sdm.UpdateResponseMetadata ' + \
            '>'

    def to_dict(self):
        return {}

    @classmethod
    def from_dict(cls, d):
        return cls()


class User:
    '''
         A User can connect to resources they are granted directly, or granted
     via roles.
    '''
    __slots__ = [
        'email',
        'external_id',
        'first_name',
        'id',
        'last_name',
        'managed_by',
        'permission_level',
        'suspended',
        'tags',
    ]

    def __init__(
        self,
        email=None,
        external_id=None,
        first_name=None,
        id=None,
        last_name=None,
        managed_by=None,
        permission_level=None,
        suspended=None,
        tags=None,
    ):
        self.email = email if email is not None else ''
        '''
         The User's email address. Must be unique.
        '''
        self.external_id = external_id if external_id is not None else ''
        '''
         External ID is an alternative unique ID this user is represented by within an external service.
        '''
        self.first_name = first_name if first_name is not None else ''
        '''
         The User's first name.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the User.
        '''
        self.last_name = last_name if last_name is not None else ''
        '''
         The User's last name.
        '''
        self.managed_by = managed_by if managed_by is not None else ''
        '''
         Managed By is a read only field for what service manages this user, e.g. StrongDM, Okta, Azure.
        '''
        self.permission_level = permission_level if permission_level is not None else ''
        '''
         PermissionLevel is a read only field for the user's permission level e.g. admin, DBA, user.
        '''
        self.suspended = suspended if suspended is not None else False
        '''
         The User's suspended state.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.User ' + \
            'email: ' + repr(self.email) + ' ' +\
            'external_id: ' + repr(self.external_id) + ' ' +\
            'first_name: ' + repr(self.first_name) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'last_name: ' + repr(self.last_name) + ' ' +\
            'managed_by: ' + repr(self.managed_by) + ' ' +\
            'permission_level: ' + repr(self.permission_level) + ' ' +\
            'suspended: ' + repr(self.suspended) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'email': self.email,
            'external_id': self.external_id,
            'first_name': self.first_name,
            'id': self.id,
            'last_name': self.last_name,
            'managed_by': self.managed_by,
            'permission_level': self.permission_level,
            'suspended': self.suspended,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            email=d.get('email'),
            external_id=d.get('external_id'),
            first_name=d.get('first_name'),
            id=d.get('id'),
            last_name=d.get('last_name'),
            managed_by=d.get('managed_by'),
            permission_level=d.get('permission_level'),
            suspended=d.get('suspended'),
            tags=d.get('tags'),
        )


class VaultAppRoleStore:
    __slots__ = [
        'id',
        'name',
        'namespace',
        'server_address',
        'tags',
    ]

    def __init__(
        self,
        id=None,
        name=None,
        namespace=None,
        server_address=None,
        tags=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.namespace = namespace if namespace is not None else ''
        self.server_address = server_address if server_address is not None else ''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.VaultAppRoleStore ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'namespace: ' + repr(self.namespace) + ' ' +\
            'server_address: ' + repr(self.server_address) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
            'namespace': self.namespace,
            'server_address': self.server_address,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
            namespace=d.get('namespace'),
            server_address=d.get('server_address'),
            tags=d.get('tags'),
        )


class VaultTLSStore:
    __slots__ = [
        'ca_cert_path',
        'client_cert_path',
        'client_key_path',
        'id',
        'name',
        'namespace',
        'server_address',
        'tags',
    ]

    def __init__(
        self,
        ca_cert_path=None,
        client_cert_path=None,
        client_key_path=None,
        id=None,
        name=None,
        namespace=None,
        server_address=None,
        tags=None,
    ):
        self.ca_cert_path = ca_cert_path if ca_cert_path is not None else ''
        self.client_cert_path = client_cert_path if client_cert_path is not None else ''
        self.client_key_path = client_key_path if client_key_path is not None else ''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.namespace = namespace if namespace is not None else ''
        self.server_address = server_address if server_address is not None else ''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.VaultTLSStore ' + \
            'ca_cert_path: ' + repr(self.ca_cert_path) + ' ' +\
            'client_cert_path: ' + repr(self.client_cert_path) + ' ' +\
            'client_key_path: ' + repr(self.client_key_path) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'namespace: ' + repr(self.namespace) + ' ' +\
            'server_address: ' + repr(self.server_address) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'ca_cert_path': self.ca_cert_path,
            'client_cert_path': self.client_cert_path,
            'client_key_path': self.client_key_path,
            'id': self.id,
            'name': self.name,
            'namespace': self.namespace,
            'server_address': self.server_address,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            ca_cert_path=d.get('ca_cert_path'),
            client_cert_path=d.get('client_cert_path'),
            client_key_path=d.get('client_key_path'),
            id=d.get('id'),
            name=d.get('name'),
            namespace=d.get('namespace'),
            server_address=d.get('server_address'),
            tags=d.get('tags'),
        )


class VaultTokenStore:
    __slots__ = [
        'id',
        'name',
        'namespace',
        'server_address',
        'tags',
    ]

    def __init__(
        self,
        id=None,
        name=None,
        namespace=None,
        server_address=None,
        tags=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.namespace = namespace if namespace is not None else ''
        self.server_address = server_address if server_address is not None else ''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.VaultTokenStore ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'namespace: ' + repr(self.namespace) + ' ' +\
            'server_address: ' + repr(self.server_address) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
            'namespace': self.namespace,
            'server_address': self.server_address,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
            namespace=d.get('namespace'),
            server_address=d.get('server_address'),
            tags=d.get('tags'),
        )


def _porcelain_zero_value_tags():
    return {}


def _porcelain_zero_value_access_rules():
    return []
