# Advanced usage samples for Azure Form Recognizer client library for Python

> Note: The samples included in this folder are aimed at providing additional context for processing information for the Form Recognizer library clients. These samples currently show usage with a preview version of the library and may be subject to change during later releases.

These code samples show more advanced scenario operations with the Azure Form Recognizer client library.

All of these samples need the endpoint to your Form Recognizer resource ([instructions on how to get endpoint][get-endpoint-instructions]), and your Form Recognizer API key ([instructions on how to get key][get-key-instructions]).

## Advanced samples for client library versions 3.2.0b1 and later

|**File Name**|**Description**|
|----------------|-------------|
|sample_get_elements_with_spans.py and sample_get_elements_with_spans_async.py|Get elements, such as lines, words, and/or styles, that are contained in the spans of another element|

## Next steps

Check out the [API reference documentation][python-fr-ref-docs] to learn more about
what you can do with the Azure Form Recognizer client library.


[python-fr-ref-docs]: https://aka.ms/azsdk/python/formrecognizer/docs
[get-endpoint-instructions]: https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/formrecognizer/azure-ai-formrecognizer/README.md#get-the-endpoint
[get-key-instructions]: https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/formrecognizer/azure-ai-formrecognizer/README.md#get-the-api-key

![Impressions](https://azure-sdk-impressions.azurewebsites.net/api/impressions/azure-sdk-for-python/sdk/formrecognizer/azure-ai-formrecognizer/samples/v3.2-beta/advanced_samples/README.png)
