# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AddressValue(msrest.serialization.Model):
    """Address field value.

    :ivar house_number: House or building number.
    :vartype house_number: str
    :ivar po_box: Post office box number.
    :vartype po_box: str
    :ivar road: Street name.
    :vartype road: str
    :ivar city: Name of city, town, village, etc.
    :vartype city: str
    :ivar state: First-level administrative division.
    :vartype state: str
    :ivar postal_code: Postal code used for mail sorting.
    :vartype postal_code: str
    :ivar country_region: Country/region.
    :vartype country_region: str
    :ivar street_address: Street-level address, excluding city, state, countryRegion, and
     postalCode.
    :vartype street_address: str
    """

    _attribute_map = {
        'house_number': {'key': 'houseNumber', 'type': 'str'},
        'po_box': {'key': 'poBox', 'type': 'str'},
        'road': {'key': 'road', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'postal_code': {'key': 'postalCode', 'type': 'str'},
        'country_region': {'key': 'countryRegion', 'type': 'str'},
        'street_address': {'key': 'streetAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword house_number: House or building number.
        :paramtype house_number: str
        :keyword po_box: Post office box number.
        :paramtype po_box: str
        :keyword road: Street name.
        :paramtype road: str
        :keyword city: Name of city, town, village, etc.
        :paramtype city: str
        :keyword state: First-level administrative division.
        :paramtype state: str
        :keyword postal_code: Postal code used for mail sorting.
        :paramtype postal_code: str
        :keyword country_region: Country/region.
        :paramtype country_region: str
        :keyword street_address: Street-level address, excluding city, state, countryRegion, and
         postalCode.
        :paramtype street_address: str
        """
        super(AddressValue, self).__init__(**kwargs)
        self.house_number = kwargs.get('house_number', None)
        self.po_box = kwargs.get('po_box', None)
        self.road = kwargs.get('road', None)
        self.city = kwargs.get('city', None)
        self.state = kwargs.get('state', None)
        self.postal_code = kwargs.get('postal_code', None)
        self.country_region = kwargs.get('country_region', None)
        self.street_address = kwargs.get('street_address', None)


class AnalyzeDocumentRequest(msrest.serialization.Model):
    """Document analysis parameters.

    :ivar url_source: Document URL to analyze.
    :vartype url_source: str
    :ivar base64_source: Base64 encoding of the document to analyze.
    :vartype base64_source: bytearray
    """

    _attribute_map = {
        'url_source': {'key': 'urlSource', 'type': 'str'},
        'base64_source': {'key': 'base64Source', 'type': 'bytearray'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword url_source: Document URL to analyze.
        :paramtype url_source: str
        :keyword base64_source: Base64 encoding of the document to analyze.
        :paramtype base64_source: bytearray
        """
        super(AnalyzeDocumentRequest, self).__init__(**kwargs)
        self.url_source = kwargs.get('url_source', None)
        self.base64_source = kwargs.get('base64_source', None)


class AnalyzeResult(msrest.serialization.Model):
    """Document analysis result.

    All required parameters must be populated in order to send to Azure.

    :ivar api_version: Required. API version used to produce this result. Known values are:
     "2022-06-30-preview".
    :vartype api_version: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.ApiVersion
    :ivar model_id: Required. Model ID used to produce this result.
    :vartype model_id: str
    :ivar string_index_type: Required. Method used to compute string offset and length. Known
     values are: "textElements", "unicodeCodePoint", "utf16CodeUnit".
    :vartype string_index_type: str or
     ~azure.ai.formrecognizer.v2022_06_30_preview.models.StringIndexType
    :ivar content: Required. Concatenate string representation of all textual and visual elements
     in reading order.
    :vartype content: str
    :ivar pages: Required. Analyzed pages.
    :vartype pages: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentPage]
    :ivar paragraphs: Extracted paragraphs.
    :vartype paragraphs:
     list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentParagraph]
    :ivar tables: Extracted tables.
    :vartype tables: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentTable]
    :ivar key_value_pairs: Extracted key-value pairs.
    :vartype key_value_pairs:
     list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentKeyValuePair]
    :ivar styles: Extracted font styles.
    :vartype styles: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentStyle]
    :ivar languages: Detected languages.
    :vartype languages: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentLanguage]
    :ivar documents: Extracted documents.
    :vartype documents: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.Document]
    """

    _validation = {
        'api_version': {'required': True},
        'model_id': {'required': True, 'pattern': r'[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}'},
        'string_index_type': {'required': True},
        'content': {'required': True},
        'pages': {'required': True},
    }

    _attribute_map = {
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'model_id': {'key': 'modelId', 'type': 'str'},
        'string_index_type': {'key': 'stringIndexType', 'type': 'str'},
        'content': {'key': 'content', 'type': 'str'},
        'pages': {'key': 'pages', 'type': '[DocumentPage]'},
        'paragraphs': {'key': 'paragraphs', 'type': '[DocumentParagraph]'},
        'tables': {'key': 'tables', 'type': '[DocumentTable]'},
        'key_value_pairs': {'key': 'keyValuePairs', 'type': '[DocumentKeyValuePair]'},
        'styles': {'key': 'styles', 'type': '[DocumentStyle]'},
        'languages': {'key': 'languages', 'type': '[DocumentLanguage]'},
        'documents': {'key': 'documents', 'type': '[Document]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword api_version: Required. API version used to produce this result. Known values are:
         "2022-06-30-preview".
        :paramtype api_version: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.ApiVersion
        :keyword model_id: Required. Model ID used to produce this result.
        :paramtype model_id: str
        :keyword string_index_type: Required. Method used to compute string offset and length. Known
         values are: "textElements", "unicodeCodePoint", "utf16CodeUnit".
        :paramtype string_index_type: str or
         ~azure.ai.formrecognizer.v2022_06_30_preview.models.StringIndexType
        :keyword content: Required. Concatenate string representation of all textual and visual
         elements in reading order.
        :paramtype content: str
        :keyword pages: Required. Analyzed pages.
        :paramtype pages: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentPage]
        :keyword paragraphs: Extracted paragraphs.
        :paramtype paragraphs:
         list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentParagraph]
        :keyword tables: Extracted tables.
        :paramtype tables: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentTable]
        :keyword key_value_pairs: Extracted key-value pairs.
        :paramtype key_value_pairs:
         list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentKeyValuePair]
        :keyword styles: Extracted font styles.
        :paramtype styles: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentStyle]
        :keyword languages: Detected languages.
        :paramtype languages:
         list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentLanguage]
        :keyword documents: Extracted documents.
        :paramtype documents: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.Document]
        """
        super(AnalyzeResult, self).__init__(**kwargs)
        self.api_version = kwargs['api_version']
        self.model_id = kwargs['model_id']
        self.string_index_type = kwargs['string_index_type']
        self.content = kwargs['content']
        self.pages = kwargs['pages']
        self.paragraphs = kwargs.get('paragraphs', None)
        self.tables = kwargs.get('tables', None)
        self.key_value_pairs = kwargs.get('key_value_pairs', None)
        self.styles = kwargs.get('styles', None)
        self.languages = kwargs.get('languages', None)
        self.documents = kwargs.get('documents', None)


class AnalyzeResultOperation(msrest.serialization.Model):
    """Status and result of the analyze operation.

    All required parameters must be populated in order to send to Azure.

    :ivar status: Required. Operation status. Known values are: "notStarted", "running", "failed",
     "succeeded".
    :vartype status: str or
     ~azure.ai.formrecognizer.v2022_06_30_preview.models.AnalyzeResultOperationStatus
    :ivar created_date_time: Required. Date and time (UTC) when the analyze operation was
     submitted.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_updated_date_time: Required. Date and time (UTC) when the status was last updated.
    :vartype last_updated_date_time: ~datetime.datetime
    :ivar error: Encountered error during document analysis.
    :vartype error: ~azure.ai.formrecognizer.v2022_06_30_preview.models.Error
    :ivar analyze_result: Document analysis result.
    :vartype analyze_result: ~azure.ai.formrecognizer.v2022_06_30_preview.models.AnalyzeResult
    """

    _validation = {
        'status': {'required': True},
        'created_date_time': {'required': True},
        'last_updated_date_time': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'Error'},
        'analyze_result': {'key': 'analyzeResult', 'type': 'AnalyzeResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword status: Required. Operation status. Known values are: "notStarted", "running",
         "failed", "succeeded".
        :paramtype status: str or
         ~azure.ai.formrecognizer.v2022_06_30_preview.models.AnalyzeResultOperationStatus
        :keyword created_date_time: Required. Date and time (UTC) when the analyze operation was
         submitted.
        :paramtype created_date_time: ~datetime.datetime
        :keyword last_updated_date_time: Required. Date and time (UTC) when the status was last
         updated.
        :paramtype last_updated_date_time: ~datetime.datetime
        :keyword error: Encountered error during document analysis.
        :paramtype error: ~azure.ai.formrecognizer.v2022_06_30_preview.models.Error
        :keyword analyze_result: Document analysis result.
        :paramtype analyze_result: ~azure.ai.formrecognizer.v2022_06_30_preview.models.AnalyzeResult
        """
        super(AnalyzeResultOperation, self).__init__(**kwargs)
        self.status = kwargs['status']
        self.created_date_time = kwargs['created_date_time']
        self.last_updated_date_time = kwargs['last_updated_date_time']
        self.error = kwargs.get('error', None)
        self.analyze_result = kwargs.get('analyze_result', None)


class AuthorizeCopyRequest(msrest.serialization.Model):
    """Request body to authorize model copy.

    All required parameters must be populated in order to send to Azure.

    :ivar model_id: Required. Unique model name.
    :vartype model_id: str
    :ivar description: Model description.
    :vartype description: str
    :ivar tags: A set of tags. List of key-value tag attributes associated with the model.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'model_id': {'required': True, 'pattern': r'[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}'},
        'description': {'max_length': 4096, 'min_length': 0},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword model_id: Required. Unique model name.
        :paramtype model_id: str
        :keyword description: Model description.
        :paramtype description: str
        :keyword tags: A set of tags. List of key-value tag attributes associated with the model.
        :paramtype tags: dict[str, str]
        """
        super(AuthorizeCopyRequest, self).__init__(**kwargs)
        self.model_id = kwargs['model_id']
        self.description = kwargs.get('description', None)
        self.tags = kwargs.get('tags', None)


class AzureBlobContentSource(msrest.serialization.Model):
    """Azure Blob Storage content.

    All required parameters must be populated in order to send to Azure.

    :ivar container_url: Required. Azure Blob Storage container URL.
    :vartype container_url: str
    :ivar prefix: Blob name prefix.
    :vartype prefix: str
    """

    _validation = {
        'container_url': {'required': True},
    }

    _attribute_map = {
        'container_url': {'key': 'containerUrl', 'type': 'str'},
        'prefix': {'key': 'prefix', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword container_url: Required. Azure Blob Storage container URL.
        :paramtype container_url: str
        :keyword prefix: Blob name prefix.
        :paramtype prefix: str
        """
        super(AzureBlobContentSource, self).__init__(**kwargs)
        self.container_url = kwargs['container_url']
        self.prefix = kwargs.get('prefix', None)


class BoundingRegion(msrest.serialization.Model):
    """Bounding polygon on a specific page of the input.

    All required parameters must be populated in order to send to Azure.

    :ivar page_number: Required. 1-based page number of page containing the bounding region.
    :vartype page_number: int
    :ivar polygon: Required. Bounding polygon on the page, or the entire page if not specified.
    :vartype polygon: list[float]
    """

    _validation = {
        'page_number': {'required': True, 'minimum': 1},
        'polygon': {'required': True},
    }

    _attribute_map = {
        'page_number': {'key': 'pageNumber', 'type': 'int'},
        'polygon': {'key': 'polygon', 'type': '[float]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword page_number: Required. 1-based page number of page containing the bounding region.
        :paramtype page_number: int
        :keyword polygon: Required. Bounding polygon on the page, or the entire page if not specified.
        :paramtype polygon: list[float]
        """
        super(BoundingRegion, self).__init__(**kwargs)
        self.page_number = kwargs['page_number']
        self.polygon = kwargs['polygon']


class BuildDocumentModelRequest(msrest.serialization.Model):
    """Request body to build a new custom model.

    All required parameters must be populated in order to send to Azure.

    :ivar model_id: Required. Unique model name.
    :vartype model_id: str
    :ivar description: Model description.
    :vartype description: str
    :ivar build_mode: Required. Custom model build mode. Known values are: "template", "neural".
    :vartype build_mode: str or
     ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentBuildMode
    :ivar azure_blob_source: Azure Blob Storage location containing the training data.
    :vartype azure_blob_source:
     ~azure.ai.formrecognizer.v2022_06_30_preview.models.AzureBlobContentSource
    :ivar tags: A set of tags. List of key-value tag attributes associated with the model.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'model_id': {'required': True, 'pattern': r'[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}'},
        'description': {'max_length': 4096, 'min_length': 0},
        'build_mode': {'required': True},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'build_mode': {'key': 'buildMode', 'type': 'str'},
        'azure_blob_source': {'key': 'azureBlobSource', 'type': 'AzureBlobContentSource'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword model_id: Required. Unique model name.
        :paramtype model_id: str
        :keyword description: Model description.
        :paramtype description: str
        :keyword build_mode: Required. Custom model build mode. Known values are: "template", "neural".
        :paramtype build_mode: str or
         ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentBuildMode
        :keyword azure_blob_source: Azure Blob Storage location containing the training data.
        :paramtype azure_blob_source:
         ~azure.ai.formrecognizer.v2022_06_30_preview.models.AzureBlobContentSource
        :keyword tags: A set of tags. List of key-value tag attributes associated with the model.
        :paramtype tags: dict[str, str]
        """
        super(BuildDocumentModelRequest, self).__init__(**kwargs)
        self.model_id = kwargs['model_id']
        self.description = kwargs.get('description', None)
        self.build_mode = kwargs['build_mode']
        self.azure_blob_source = kwargs.get('azure_blob_source', None)
        self.tags = kwargs.get('tags', None)


class ComponentModelInfo(msrest.serialization.Model):
    """A component of a composed model.

    All required parameters must be populated in order to send to Azure.

    :ivar model_id: Required. Unique model name.
    :vartype model_id: str
    """

    _validation = {
        'model_id': {'required': True, 'pattern': r'[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}'},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword model_id: Required. Unique model name.
        :paramtype model_id: str
        """
        super(ComponentModelInfo, self).__init__(**kwargs)
        self.model_id = kwargs['model_id']


class ComposeDocumentModelRequest(msrest.serialization.Model):
    """Request body to create a composed model from component models.

    All required parameters must be populated in order to send to Azure.

    :ivar model_id: Required. Unique model name.
    :vartype model_id: str
    :ivar description: Model description.
    :vartype description: str
    :ivar component_models: Required. List of component models to compose.
    :vartype component_models:
     list[~azure.ai.formrecognizer.v2022_06_30_preview.models.ComponentModelInfo]
    :ivar tags: A set of tags. List of key-value tag attributes associated with the model.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'model_id': {'required': True, 'pattern': r'[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}'},
        'description': {'max_length': 4096, 'min_length': 0},
        'component_models': {'required': True, 'unique': True},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'component_models': {'key': 'componentModels', 'type': '[ComponentModelInfo]'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword model_id: Required. Unique model name.
        :paramtype model_id: str
        :keyword description: Model description.
        :paramtype description: str
        :keyword component_models: Required. List of component models to compose.
        :paramtype component_models:
         list[~azure.ai.formrecognizer.v2022_06_30_preview.models.ComponentModelInfo]
        :keyword tags: A set of tags. List of key-value tag attributes associated with the model.
        :paramtype tags: dict[str, str]
        """
        super(ComposeDocumentModelRequest, self).__init__(**kwargs)
        self.model_id = kwargs['model_id']
        self.description = kwargs.get('description', None)
        self.component_models = kwargs['component_models']
        self.tags = kwargs.get('tags', None)


class CopyAuthorization(msrest.serialization.Model):
    """Authorization to copy a model to the specified target resource and modelId.

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_id: Required. ID of the target Azure resource where the model should be
     copied to.
    :vartype target_resource_id: str
    :ivar target_resource_region: Required. Location of the target Azure resource where the model
     should be copied to.
    :vartype target_resource_region: str
    :ivar target_model_id: Required. Identifier of the target model.
    :vartype target_model_id: str
    :ivar target_model_location: Required. URL of the copied model in the target account.
    :vartype target_model_location: str
    :ivar access_token: Required. Token used to authorize the request.
    :vartype access_token: str
    :ivar expiration_date_time: Required. Date/time when the access token expires.
    :vartype expiration_date_time: ~datetime.datetime
    """

    _validation = {
        'target_resource_id': {'required': True},
        'target_resource_region': {'required': True},
        'target_model_id': {'required': True, 'pattern': r'[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}'},
        'target_model_location': {'required': True},
        'access_token': {'required': True},
        'expiration_date_time': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'target_resource_region': {'key': 'targetResourceRegion', 'type': 'str'},
        'target_model_id': {'key': 'targetModelId', 'type': 'str'},
        'target_model_location': {'key': 'targetModelLocation', 'type': 'str'},
        'access_token': {'key': 'accessToken', 'type': 'str'},
        'expiration_date_time': {'key': 'expirationDateTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword target_resource_id: Required. ID of the target Azure resource where the model should
         be copied to.
        :paramtype target_resource_id: str
        :keyword target_resource_region: Required. Location of the target Azure resource where the
         model should be copied to.
        :paramtype target_resource_region: str
        :keyword target_model_id: Required. Identifier of the target model.
        :paramtype target_model_id: str
        :keyword target_model_location: Required. URL of the copied model in the target account.
        :paramtype target_model_location: str
        :keyword access_token: Required. Token used to authorize the request.
        :paramtype access_token: str
        :keyword expiration_date_time: Required. Date/time when the access token expires.
        :paramtype expiration_date_time: ~datetime.datetime
        """
        super(CopyAuthorization, self).__init__(**kwargs)
        self.target_resource_id = kwargs['target_resource_id']
        self.target_resource_region = kwargs['target_resource_region']
        self.target_model_id = kwargs['target_model_id']
        self.target_model_location = kwargs['target_model_location']
        self.access_token = kwargs['access_token']
        self.expiration_date_time = kwargs['expiration_date_time']


class CurrencyValue(msrest.serialization.Model):
    """Currency field value.

    All required parameters must be populated in order to send to Azure.

    :ivar amount: Required. Currency amount.
    :vartype amount: float
    :ivar currency_symbol: Currency symbol label, if any.
    :vartype currency_symbol: str
    """

    _validation = {
        'amount': {'required': True},
    }

    _attribute_map = {
        'amount': {'key': 'amount', 'type': 'float'},
        'currency_symbol': {'key': 'currencySymbol', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword amount: Required. Currency amount.
        :paramtype amount: float
        :keyword currency_symbol: Currency symbol label, if any.
        :paramtype currency_symbol: str
        """
        super(CurrencyValue, self).__init__(**kwargs)
        self.amount = kwargs['amount']
        self.currency_symbol = kwargs.get('currency_symbol', None)


class CustomDocumentModelsInfo(msrest.serialization.Model):
    """Info regarding custom document models.

    All required parameters must be populated in order to send to Azure.

    :ivar count: Required. Number of custom models in the current resource.
    :vartype count: int
    :ivar limit: Required. Maximum number of custom models supported in the current resource.
    :vartype limit: int
    """

    _validation = {
        'count': {'required': True},
        'limit': {'required': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword count: Required. Number of custom models in the current resource.
        :paramtype count: int
        :keyword limit: Required. Maximum number of custom models supported in the current resource.
        :paramtype limit: int
        """
        super(CustomDocumentModelsInfo, self).__init__(**kwargs)
        self.count = kwargs['count']
        self.limit = kwargs['limit']


class DocTypeInfo(msrest.serialization.Model):
    """Document type info.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Model description.
    :vartype description: str
    :ivar build_mode: Custom model build mode. Known values are: "template", "neural".
    :vartype build_mode: str or
     ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentBuildMode
    :ivar field_schema: Required. Description of the document semantic schema using a JSON Schema
     style syntax.
    :vartype field_schema: dict[str,
     ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentFieldSchema]
    :ivar field_confidence: Estimated confidence for each field.
    :vartype field_confidence: dict[str, float]
    """

    _validation = {
        'description': {'max_length': 4096, 'min_length': 0},
        'field_schema': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'build_mode': {'key': 'buildMode', 'type': 'str'},
        'field_schema': {'key': 'fieldSchema', 'type': '{DocumentFieldSchema}'},
        'field_confidence': {'key': 'fieldConfidence', 'type': '{float}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: Model description.
        :paramtype description: str
        :keyword build_mode: Custom model build mode. Known values are: "template", "neural".
        :paramtype build_mode: str or
         ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentBuildMode
        :keyword field_schema: Required. Description of the document semantic schema using a JSON
         Schema style syntax.
        :paramtype field_schema: dict[str,
         ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentFieldSchema]
        :keyword field_confidence: Estimated confidence for each field.
        :paramtype field_confidence: dict[str, float]
        """
        super(DocTypeInfo, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.build_mode = kwargs.get('build_mode', None)
        self.field_schema = kwargs['field_schema']
        self.field_confidence = kwargs.get('field_confidence', None)


class Document(msrest.serialization.Model):
    """An object describing the location and semantic content of a document.

    All required parameters must be populated in order to send to Azure.

    :ivar doc_type: Required. Document type.
    :vartype doc_type: str
    :ivar bounding_regions: Bounding regions covering the document.
    :vartype bounding_regions:
     list[~azure.ai.formrecognizer.v2022_06_30_preview.models.BoundingRegion]
    :ivar spans: Required. Location of the document in the reading order concatenated content.
    :vartype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
    :ivar fields: Dictionary of named field values.
    :vartype fields: dict[str, ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentField]
    :ivar confidence: Required. Confidence of correctly extracting the document.
    :vartype confidence: float
    """

    _validation = {
        'doc_type': {'required': True, 'max_length': 64, 'min_length': 2},
        'spans': {'required': True},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'doc_type': {'key': 'docType', 'type': 'str'},
        'bounding_regions': {'key': 'boundingRegions', 'type': '[BoundingRegion]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
        'fields': {'key': 'fields', 'type': '{DocumentField}'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword doc_type: Required. Document type.
        :paramtype doc_type: str
        :keyword bounding_regions: Bounding regions covering the document.
        :paramtype bounding_regions:
         list[~azure.ai.formrecognizer.v2022_06_30_preview.models.BoundingRegion]
        :keyword spans: Required. Location of the document in the reading order concatenated content.
        :paramtype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
        :keyword fields: Dictionary of named field values.
        :paramtype fields: dict[str, ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentField]
        :keyword confidence: Required. Confidence of correctly extracting the document.
        :paramtype confidence: float
        """
        super(Document, self).__init__(**kwargs)
        self.doc_type = kwargs['doc_type']
        self.bounding_regions = kwargs.get('bounding_regions', None)
        self.spans = kwargs['spans']
        self.fields = kwargs.get('fields', None)
        self.confidence = kwargs['confidence']


class DocumentCaption(msrest.serialization.Model):
    """An object representing the location and content of a table caption.

    All required parameters must be populated in order to send to Azure.

    :ivar content: Required. Table caption content.
    :vartype content: str
    :ivar bounding_regions: Bounding regions covering the table caption.
    :vartype bounding_regions:
     list[~azure.ai.formrecognizer.v2022_06_30_preview.models.BoundingRegion]
    :ivar spans: Required. Location of the table caption in the reading order concatenated content.
    :vartype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
    """

    _validation = {
        'content': {'required': True},
        'spans': {'required': True},
    }

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
        'bounding_regions': {'key': 'boundingRegions', 'type': '[BoundingRegion]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword content: Required. Table caption content.
        :paramtype content: str
        :keyword bounding_regions: Bounding regions covering the table caption.
        :paramtype bounding_regions:
         list[~azure.ai.formrecognizer.v2022_06_30_preview.models.BoundingRegion]
        :keyword spans: Required. Location of the table caption in the reading order concatenated
         content.
        :paramtype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
        """
        super(DocumentCaption, self).__init__(**kwargs)
        self.content = kwargs['content']
        self.bounding_regions = kwargs.get('bounding_regions', None)
        self.spans = kwargs['spans']


class DocumentField(msrest.serialization.Model):
    """An object representing the content and location of a field value.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Data type of the field value. Known values are: "string", "date", "time",
     "phoneNumber", "number", "integer", "selectionMark", "countryRegion", "signature", "array",
     "object", "currency", "address".
    :vartype type: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentFieldType
    :ivar value_string: String value.
    :vartype value_string: str
    :ivar value_date: Date value in YYYY-MM-DD format (ISO 8601).
    :vartype value_date: ~datetime.date
    :ivar value_time: Time value in hh:mm:ss format (ISO 8601).
    :vartype value_time: ~datetime.time
    :ivar value_phone_number: Phone number value in E.164 format (ex. +19876543210).
    :vartype value_phone_number: str
    :ivar value_number: Floating point value.
    :vartype value_number: float
    :ivar value_integer: Integer value.
    :vartype value_integer: long
    :ivar value_selection_mark: Selection mark value. Known values are: "selected", "unselected".
    :vartype value_selection_mark: str or
     ~azure.ai.formrecognizer.v2022_06_30_preview.models.SelectionMarkState
    :ivar value_signature: Presence of signature. Known values are: "signed", "unsigned".
    :vartype value_signature: str or
     ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSignatureType
    :ivar value_country_region: 3-letter country code value (ISO 3166-1 alpha-3).
    :vartype value_country_region: str
    :ivar value_array: Array of field values.
    :vartype value_array: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentField]
    :ivar value_object: Dictionary of named field values.
    :vartype value_object: dict[str,
     ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentField]
    :ivar value_currency: Currency value.
    :vartype value_currency: ~azure.ai.formrecognizer.v2022_06_30_preview.models.CurrencyValue
    :ivar value_address: Address value.
    :vartype value_address: ~azure.ai.formrecognizer.v2022_06_30_preview.models.AddressValue
    :ivar content: Field content.
    :vartype content: str
    :ivar bounding_regions: Bounding regions covering the field.
    :vartype bounding_regions:
     list[~azure.ai.formrecognizer.v2022_06_30_preview.models.BoundingRegion]
    :ivar spans: Location of the field in the reading order concatenated content.
    :vartype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
    :ivar confidence: Confidence of correctly extracting the field.
    :vartype confidence: float
    """

    _validation = {
        'type': {'required': True},
        'confidence': {'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value_string': {'key': 'valueString', 'type': 'str'},
        'value_date': {'key': 'valueDate', 'type': 'date'},
        'value_time': {'key': 'valueTime', 'type': 'time'},
        'value_phone_number': {'key': 'valuePhoneNumber', 'type': 'str'},
        'value_number': {'key': 'valueNumber', 'type': 'float'},
        'value_integer': {'key': 'valueInteger', 'type': 'long'},
        'value_selection_mark': {'key': 'valueSelectionMark', 'type': 'str'},
        'value_signature': {'key': 'valueSignature', 'type': 'str'},
        'value_country_region': {'key': 'valueCountryRegion', 'type': 'str'},
        'value_array': {'key': 'valueArray', 'type': '[DocumentField]'},
        'value_object': {'key': 'valueObject', 'type': '{DocumentField}'},
        'value_currency': {'key': 'valueCurrency', 'type': 'CurrencyValue'},
        'value_address': {'key': 'valueAddress', 'type': 'AddressValue'},
        'content': {'key': 'content', 'type': 'str'},
        'bounding_regions': {'key': 'boundingRegions', 'type': '[BoundingRegion]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword type: Required. Data type of the field value. Known values are: "string", "date",
         "time", "phoneNumber", "number", "integer", "selectionMark", "countryRegion", "signature",
         "array", "object", "currency", "address".
        :paramtype type: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentFieldType
        :keyword value_string: String value.
        :paramtype value_string: str
        :keyword value_date: Date value in YYYY-MM-DD format (ISO 8601).
        :paramtype value_date: ~datetime.date
        :keyword value_time: Time value in hh:mm:ss format (ISO 8601).
        :paramtype value_time: ~datetime.time
        :keyword value_phone_number: Phone number value in E.164 format (ex. +19876543210).
        :paramtype value_phone_number: str
        :keyword value_number: Floating point value.
        :paramtype value_number: float
        :keyword value_integer: Integer value.
        :paramtype value_integer: long
        :keyword value_selection_mark: Selection mark value. Known values are: "selected",
         "unselected".
        :paramtype value_selection_mark: str or
         ~azure.ai.formrecognizer.v2022_06_30_preview.models.SelectionMarkState
        :keyword value_signature: Presence of signature. Known values are: "signed", "unsigned".
        :paramtype value_signature: str or
         ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSignatureType
        :keyword value_country_region: 3-letter country code value (ISO 3166-1 alpha-3).
        :paramtype value_country_region: str
        :keyword value_array: Array of field values.
        :paramtype value_array: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentField]
        :keyword value_object: Dictionary of named field values.
        :paramtype value_object: dict[str,
         ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentField]
        :keyword value_currency: Currency value.
        :paramtype value_currency: ~azure.ai.formrecognizer.v2022_06_30_preview.models.CurrencyValue
        :keyword value_address: Address value.
        :paramtype value_address: ~azure.ai.formrecognizer.v2022_06_30_preview.models.AddressValue
        :keyword content: Field content.
        :paramtype content: str
        :keyword bounding_regions: Bounding regions covering the field.
        :paramtype bounding_regions:
         list[~azure.ai.formrecognizer.v2022_06_30_preview.models.BoundingRegion]
        :keyword spans: Location of the field in the reading order concatenated content.
        :paramtype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
        :keyword confidence: Confidence of correctly extracting the field.
        :paramtype confidence: float
        """
        super(DocumentField, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.value_string = kwargs.get('value_string', None)
        self.value_date = kwargs.get('value_date', None)
        self.value_time = kwargs.get('value_time', None)
        self.value_phone_number = kwargs.get('value_phone_number', None)
        self.value_number = kwargs.get('value_number', None)
        self.value_integer = kwargs.get('value_integer', None)
        self.value_selection_mark = kwargs.get('value_selection_mark', None)
        self.value_signature = kwargs.get('value_signature', None)
        self.value_country_region = kwargs.get('value_country_region', None)
        self.value_array = kwargs.get('value_array', None)
        self.value_object = kwargs.get('value_object', None)
        self.value_currency = kwargs.get('value_currency', None)
        self.value_address = kwargs.get('value_address', None)
        self.content = kwargs.get('content', None)
        self.bounding_regions = kwargs.get('bounding_regions', None)
        self.spans = kwargs.get('spans', None)
        self.confidence = kwargs.get('confidence', None)


class DocumentFieldSchema(msrest.serialization.Model):
    """Description of the field semantic schema using a JSON Schema style syntax.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Semantic data type of the field value. Known values are: "string",
     "date", "time", "phoneNumber", "number", "integer", "selectionMark", "countryRegion",
     "signature", "array", "object", "currency", "address".
    :vartype type: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentFieldType
    :ivar description: Field description.
    :vartype description: str
    :ivar example: Example field content.
    :vartype example: str
    :ivar items: Field type schema of each array element.
    :vartype items: ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentFieldSchema
    :ivar properties: Named sub-fields of the object field.
    :vartype properties: dict[str,
     ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentFieldSchema]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'example': {'key': 'example', 'type': 'str'},
        'items': {'key': 'items', 'type': 'DocumentFieldSchema'},
        'properties': {'key': 'properties', 'type': '{DocumentFieldSchema}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword type: Required. Semantic data type of the field value. Known values are: "string",
         "date", "time", "phoneNumber", "number", "integer", "selectionMark", "countryRegion",
         "signature", "array", "object", "currency", "address".
        :paramtype type: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentFieldType
        :keyword description: Field description.
        :paramtype description: str
        :keyword example: Example field content.
        :paramtype example: str
        :keyword items: Field type schema of each array element.
        :paramtype items: ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentFieldSchema
        :keyword properties: Named sub-fields of the object field.
        :paramtype properties: dict[str,
         ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentFieldSchema]
        """
        super(DocumentFieldSchema, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.description = kwargs.get('description', None)
        self.example = kwargs.get('example', None)
        self.items = kwargs.get('items', None)
        self.properties = kwargs.get('properties', None)


class DocumentFootnote(msrest.serialization.Model):
    """An object representing the location and content of a table footnote.

    All required parameters must be populated in order to send to Azure.

    :ivar content: Required. Table footnote content.
    :vartype content: str
    :ivar bounding_regions: Bounding regions covering the table footnote.
    :vartype bounding_regions:
     list[~azure.ai.formrecognizer.v2022_06_30_preview.models.BoundingRegion]
    :ivar spans: Required. Location of the table footnote in the reading order concatenated
     content.
    :vartype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
    """

    _validation = {
        'content': {'required': True},
        'spans': {'required': True},
    }

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
        'bounding_regions': {'key': 'boundingRegions', 'type': '[BoundingRegion]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword content: Required. Table footnote content.
        :paramtype content: str
        :keyword bounding_regions: Bounding regions covering the table footnote.
        :paramtype bounding_regions:
         list[~azure.ai.formrecognizer.v2022_06_30_preview.models.BoundingRegion]
        :keyword spans: Required. Location of the table footnote in the reading order concatenated
         content.
        :paramtype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
        """
        super(DocumentFootnote, self).__init__(**kwargs)
        self.content = kwargs['content']
        self.bounding_regions = kwargs.get('bounding_regions', None)
        self.spans = kwargs['spans']


class DocumentImage(msrest.serialization.Model):
    """An image object detected in the page.

    All required parameters must be populated in order to send to Azure.

    :ivar polygon: Bounding polygon of the image.
    :vartype polygon: list[float]
    :ivar span: Required. Location of the image in the reading order concatenated content.
    :vartype span: ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan
    :ivar page_ref: Required. 0-based index of the global pages array that containing the content
     of the image.
    :vartype page_ref: int
    :ivar confidence: Required. Confidence of correctly identifying the image.
    :vartype confidence: float
    """

    _validation = {
        'span': {'required': True},
        'page_ref': {'required': True, 'minimum': 0},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'polygon': {'key': 'polygon', 'type': '[float]'},
        'span': {'key': 'span', 'type': 'DocumentSpan'},
        'page_ref': {'key': 'pageRef', 'type': 'int'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword polygon: Bounding polygon of the image.
        :paramtype polygon: list[float]
        :keyword span: Required. Location of the image in the reading order concatenated content.
        :paramtype span: ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan
        :keyword page_ref: Required. 0-based index of the global pages array that containing the
         content of the image.
        :paramtype page_ref: int
        :keyword confidence: Required. Confidence of correctly identifying the image.
        :paramtype confidence: float
        """
        super(DocumentImage, self).__init__(**kwargs)
        self.polygon = kwargs.get('polygon', None)
        self.span = kwargs['span']
        self.page_ref = kwargs['page_ref']
        self.confidence = kwargs['confidence']


class DocumentKeyValueElement(msrest.serialization.Model):
    """An object representing the field key or value in a key-value pair.

    All required parameters must be populated in order to send to Azure.

    :ivar content: Required. Concatenated content of the key-value element in reading order.
    :vartype content: str
    :ivar bounding_regions: Bounding regions covering the key-value element.
    :vartype bounding_regions:
     list[~azure.ai.formrecognizer.v2022_06_30_preview.models.BoundingRegion]
    :ivar spans: Required. Location of the key-value element in the reading order concatenated
     content.
    :vartype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
    """

    _validation = {
        'content': {'required': True},
        'spans': {'required': True},
    }

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
        'bounding_regions': {'key': 'boundingRegions', 'type': '[BoundingRegion]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword content: Required. Concatenated content of the key-value element in reading order.
        :paramtype content: str
        :keyword bounding_regions: Bounding regions covering the key-value element.
        :paramtype bounding_regions:
         list[~azure.ai.formrecognizer.v2022_06_30_preview.models.BoundingRegion]
        :keyword spans: Required. Location of the key-value element in the reading order concatenated
         content.
        :paramtype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
        """
        super(DocumentKeyValueElement, self).__init__(**kwargs)
        self.content = kwargs['content']
        self.bounding_regions = kwargs.get('bounding_regions', None)
        self.spans = kwargs['spans']


class DocumentKeyValuePair(msrest.serialization.Model):
    """An object representing a form field with distinct field label (key) and field value (may be empty).

    All required parameters must be populated in order to send to Azure.

    :ivar key: Required. Field label of the key-value pair.
    :vartype key: ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentKeyValueElement
    :ivar value: Field value of the key-value pair.
    :vartype value: ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentKeyValueElement
    :ivar confidence: Required. Confidence of correctly extracting the key-value pair.
    :vartype confidence: float
    """

    _validation = {
        'key': {'required': True},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'DocumentKeyValueElement'},
        'value': {'key': 'value', 'type': 'DocumentKeyValueElement'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword key: Required. Field label of the key-value pair.
        :paramtype key: ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentKeyValueElement
        :keyword value: Field value of the key-value pair.
        :paramtype value: ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentKeyValueElement
        :keyword confidence: Required. Confidence of correctly extracting the key-value pair.
        :paramtype confidence: float
        """
        super(DocumentKeyValuePair, self).__init__(**kwargs)
        self.key = kwargs['key']
        self.value = kwargs.get('value', None)
        self.confidence = kwargs['confidence']


class DocumentLanguage(msrest.serialization.Model):
    """An object representing the detected language for a given text span.

    All required parameters must be populated in order to send to Azure.

    :ivar locale: Required. Detected language.  Value may an ISO 639-1 language code (ex. "en",
     "fr") or BCP 47 language tag (ex. "zh-Hans").
    :vartype locale: str
    :ivar spans: Required. Location of the text elements in the concatenated content the language
     applies to.
    :vartype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
    :ivar confidence: Required. Confidence of correctly identifying the language.
    :vartype confidence: float
    """

    _validation = {
        'locale': {'required': True},
        'spans': {'required': True},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'locale': {'key': 'locale', 'type': 'str'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword locale: Required. Detected language.  Value may an ISO 639-1 language code (ex. "en",
         "fr") or BCP 47 language tag (ex. "zh-Hans").
        :paramtype locale: str
        :keyword spans: Required. Location of the text elements in the concatenated content the
         language applies to.
        :paramtype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
        :keyword confidence: Required. Confidence of correctly identifying the language.
        :paramtype confidence: float
        """
        super(DocumentLanguage, self).__init__(**kwargs)
        self.locale = kwargs['locale']
        self.spans = kwargs['spans']
        self.confidence = kwargs['confidence']


class DocumentLine(msrest.serialization.Model):
    """A content line object consisting of an adjacent sequence of content elements, such as words and selection marks.

    All required parameters must be populated in order to send to Azure.

    :ivar content: Required. Concatenated content of the contained elements in reading order.
    :vartype content: str
    :ivar polygon: Bounding polygon of the line.
    :vartype polygon: list[float]
    :ivar spans: Required. Location of the line in the reading order concatenated content.
    :vartype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
    """

    _validation = {
        'content': {'required': True},
        'spans': {'required': True},
    }

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
        'polygon': {'key': 'polygon', 'type': '[float]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword content: Required. Concatenated content of the contained elements in reading order.
        :paramtype content: str
        :keyword polygon: Bounding polygon of the line.
        :paramtype polygon: list[float]
        :keyword spans: Required. Location of the line in the reading order concatenated content.
        :paramtype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
        """
        super(DocumentLine, self).__init__(**kwargs)
        self.content = kwargs['content']
        self.polygon = kwargs.get('polygon', None)
        self.spans = kwargs['spans']


class DocumentPage(msrest.serialization.Model):
    """Content and layout elements extracted from a page from the input.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Kind of document page. Known values are: "document", "sheet", "slide",
     "image".
    :vartype kind: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentPageKind
    :ivar page_number: Required. 1-based page number in the input document.
    :vartype page_number: int
    :ivar angle: The general orientation of the content in clockwise direction, measured in degrees
     between (-180, 180].
    :vartype angle: float
    :ivar width: The width of the image/PDF in pixels/inches, respectively.
    :vartype width: float
    :ivar height: The height of the image/PDF in pixels/inches, respectively.
    :vartype height: float
    :ivar unit: The unit used by the width, height, and polygon properties. For images, the unit is
     "pixel". For PDF, the unit is "inch". Known values are: "pixel", "inch".
    :vartype unit: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.LengthUnit
    :ivar spans: Required. Location of the page in the reading order concatenated content.
    :vartype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
    :ivar words: Extracted words from the page.
    :vartype words: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentWord]
    :ivar selection_marks: Extracted selection marks from the page.
    :vartype selection_marks:
     list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSelectionMark]
    :ivar images: Extracted images from the page.
    :vartype images: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentImage]
    :ivar lines: Extracted lines from the page, potentially containing both textual and visual
     elements.
    :vartype lines: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentLine]
    """

    _validation = {
        'kind': {'required': True},
        'page_number': {'required': True, 'minimum': 1},
        'angle': {'maximum': 180, 'minimum_ex': -180},
        'width': {'minimum': 0},
        'height': {'minimum': 0},
        'spans': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'page_number': {'key': 'pageNumber', 'type': 'int'},
        'angle': {'key': 'angle', 'type': 'float'},
        'width': {'key': 'width', 'type': 'float'},
        'height': {'key': 'height', 'type': 'float'},
        'unit': {'key': 'unit', 'type': 'str'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
        'words': {'key': 'words', 'type': '[DocumentWord]'},
        'selection_marks': {'key': 'selectionMarks', 'type': '[DocumentSelectionMark]'},
        'images': {'key': 'images', 'type': '[DocumentImage]'},
        'lines': {'key': 'lines', 'type': '[DocumentLine]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword kind: Required. Kind of document page. Known values are: "document", "sheet", "slide",
         "image".
        :paramtype kind: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentPageKind
        :keyword page_number: Required. 1-based page number in the input document.
        :paramtype page_number: int
        :keyword angle: The general orientation of the content in clockwise direction, measured in
         degrees between (-180, 180].
        :paramtype angle: float
        :keyword width: The width of the image/PDF in pixels/inches, respectively.
        :paramtype width: float
        :keyword height: The height of the image/PDF in pixels/inches, respectively.
        :paramtype height: float
        :keyword unit: The unit used by the width, height, and polygon properties. For images, the unit
         is "pixel". For PDF, the unit is "inch". Known values are: "pixel", "inch".
        :paramtype unit: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.LengthUnit
        :keyword spans: Required. Location of the page in the reading order concatenated content.
        :paramtype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
        :keyword words: Extracted words from the page.
        :paramtype words: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentWord]
        :keyword selection_marks: Extracted selection marks from the page.
        :paramtype selection_marks:
         list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSelectionMark]
        :keyword images: Extracted images from the page.
        :paramtype images: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentImage]
        :keyword lines: Extracted lines from the page, potentially containing both textual and visual
         elements.
        :paramtype lines: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentLine]
        """
        super(DocumentPage, self).__init__(**kwargs)
        self.kind = kwargs['kind']
        self.page_number = kwargs['page_number']
        self.angle = kwargs.get('angle', None)
        self.width = kwargs.get('width', None)
        self.height = kwargs.get('height', None)
        self.unit = kwargs.get('unit', None)
        self.spans = kwargs['spans']
        self.words = kwargs.get('words', None)
        self.selection_marks = kwargs.get('selection_marks', None)
        self.images = kwargs.get('images', None)
        self.lines = kwargs.get('lines', None)


class DocumentParagraph(msrest.serialization.Model):
    """A paragraph object consisting with contiguous lines generally with common alignment and spacing.

    All required parameters must be populated in order to send to Azure.

    :ivar role: Semantic role of the paragraph. Known values are: "pageHeader", "pageFooter",
     "pageNumber", "title", "sectionHeading", "footnote".
    :vartype role: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.ParagraphRole
    :ivar content: Required. Concatenated content of the paragraph in reading order.
    :vartype content: str
    :ivar bounding_regions: Bounding regions covering the paragraph.
    :vartype bounding_regions:
     list[~azure.ai.formrecognizer.v2022_06_30_preview.models.BoundingRegion]
    :ivar spans: Required. Location of the paragraph in the reading order concatenated content.
    :vartype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
    """

    _validation = {
        'content': {'required': True},
        'spans': {'required': True},
    }

    _attribute_map = {
        'role': {'key': 'role', 'type': 'str'},
        'content': {'key': 'content', 'type': 'str'},
        'bounding_regions': {'key': 'boundingRegions', 'type': '[BoundingRegion]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword role: Semantic role of the paragraph. Known values are: "pageHeader", "pageFooter",
         "pageNumber", "title", "sectionHeading", "footnote".
        :paramtype role: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.ParagraphRole
        :keyword content: Required. Concatenated content of the paragraph in reading order.
        :paramtype content: str
        :keyword bounding_regions: Bounding regions covering the paragraph.
        :paramtype bounding_regions:
         list[~azure.ai.formrecognizer.v2022_06_30_preview.models.BoundingRegion]
        :keyword spans: Required. Location of the paragraph in the reading order concatenated content.
        :paramtype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
        """
        super(DocumentParagraph, self).__init__(**kwargs)
        self.role = kwargs.get('role', None)
        self.content = kwargs['content']
        self.bounding_regions = kwargs.get('bounding_regions', None)
        self.spans = kwargs['spans']


class DocumentSelectionMark(msrest.serialization.Model):
    """A selection mark object representing check boxes, radio buttons, and other elements indicating a selection.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Required. State of the selection mark. Known values are: "selected", "unselected".
    :vartype state: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.SelectionMarkState
    :ivar polygon: Bounding polygon of the selection mark.
    :vartype polygon: list[float]
    :ivar span: Required. Location of the selection mark in the reading order concatenated content.
    :vartype span: ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan
    :ivar confidence: Required. Confidence of correctly extracting the selection mark.
    :vartype confidence: float
    """

    _validation = {
        'state': {'required': True},
        'span': {'required': True},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'polygon': {'key': 'polygon', 'type': '[float]'},
        'span': {'key': 'span', 'type': 'DocumentSpan'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword state: Required. State of the selection mark. Known values are: "selected",
         "unselected".
        :paramtype state: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.SelectionMarkState
        :keyword polygon: Bounding polygon of the selection mark.
        :paramtype polygon: list[float]
        :keyword span: Required. Location of the selection mark in the reading order concatenated
         content.
        :paramtype span: ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan
        :keyword confidence: Required. Confidence of correctly extracting the selection mark.
        :paramtype confidence: float
        """
        super(DocumentSelectionMark, self).__init__(**kwargs)
        self.state = kwargs['state']
        self.polygon = kwargs.get('polygon', None)
        self.span = kwargs['span']
        self.confidence = kwargs['confidence']


class DocumentSpan(msrest.serialization.Model):
    """Contiguous region of the concatenated content property, specified as an offset and length.

    All required parameters must be populated in order to send to Azure.

    :ivar offset: Required. Zero-based index of the content represented by the span.
    :vartype offset: int
    :ivar length: Required. Number of characters in the content represented by the span.
    :vartype length: int
    """

    _validation = {
        'offset': {'required': True, 'minimum': 0},
        'length': {'required': True, 'minimum': 0},
    }

    _attribute_map = {
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword offset: Required. Zero-based index of the content represented by the span.
        :paramtype offset: int
        :keyword length: Required. Number of characters in the content represented by the span.
        :paramtype length: int
        """
        super(DocumentSpan, self).__init__(**kwargs)
        self.offset = kwargs['offset']
        self.length = kwargs['length']


class DocumentStyle(msrest.serialization.Model):
    """An object representing observed text styles.

    All required parameters must be populated in order to send to Azure.

    :ivar is_handwritten: Is content handwritten?.
    :vartype is_handwritten: bool
    :ivar spans: Required. Location of the text elements in the concatenated content the style
     applies to.
    :vartype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
    :ivar confidence: Required. Confidence of correctly identifying the style.
    :vartype confidence: float
    """

    _validation = {
        'spans': {'required': True},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'is_handwritten': {'key': 'isHandwritten', 'type': 'bool'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword is_handwritten: Is content handwritten?.
        :paramtype is_handwritten: bool
        :keyword spans: Required. Location of the text elements in the concatenated content the style
         applies to.
        :paramtype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
        :keyword confidence: Required. Confidence of correctly identifying the style.
        :paramtype confidence: float
        """
        super(DocumentStyle, self).__init__(**kwargs)
        self.is_handwritten = kwargs.get('is_handwritten', None)
        self.spans = kwargs['spans']
        self.confidence = kwargs['confidence']


class DocumentTable(msrest.serialization.Model):
    """A table object consisting table cells arranged in a rectangular layout.

    All required parameters must be populated in order to send to Azure.

    :ivar row_count: Required. Number of rows in the table.
    :vartype row_count: int
    :ivar column_count: Required. Number of columns in the table.
    :vartype column_count: int
    :ivar cells: Required. Cells contained within the table.
    :vartype cells: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentTableCell]
    :ivar caption: Caption associated with the table.
    :vartype caption: ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentCaption
    :ivar footnotes: Footnotes associated with the table.
    :vartype footnotes: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentFootnote]
    :ivar bounding_regions: Bounding regions covering the table.
    :vartype bounding_regions:
     list[~azure.ai.formrecognizer.v2022_06_30_preview.models.BoundingRegion]
    :ivar spans: Required. Location of the table in the reading order concatenated content.
    :vartype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
    """

    _validation = {
        'row_count': {'required': True, 'minimum': 1},
        'column_count': {'required': True, 'minimum': 1},
        'cells': {'required': True},
        'spans': {'required': True},
    }

    _attribute_map = {
        'row_count': {'key': 'rowCount', 'type': 'int'},
        'column_count': {'key': 'columnCount', 'type': 'int'},
        'cells': {'key': 'cells', 'type': '[DocumentTableCell]'},
        'caption': {'key': 'caption', 'type': 'DocumentCaption'},
        'footnotes': {'key': 'footnotes', 'type': '[DocumentFootnote]'},
        'bounding_regions': {'key': 'boundingRegions', 'type': '[BoundingRegion]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword row_count: Required. Number of rows in the table.
        :paramtype row_count: int
        :keyword column_count: Required. Number of columns in the table.
        :paramtype column_count: int
        :keyword cells: Required. Cells contained within the table.
        :paramtype cells: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentTableCell]
        :keyword caption: Caption associated with the table.
        :paramtype caption: ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentCaption
        :keyword footnotes: Footnotes associated with the table.
        :paramtype footnotes:
         list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentFootnote]
        :keyword bounding_regions: Bounding regions covering the table.
        :paramtype bounding_regions:
         list[~azure.ai.formrecognizer.v2022_06_30_preview.models.BoundingRegion]
        :keyword spans: Required. Location of the table in the reading order concatenated content.
        :paramtype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
        """
        super(DocumentTable, self).__init__(**kwargs)
        self.row_count = kwargs['row_count']
        self.column_count = kwargs['column_count']
        self.cells = kwargs['cells']
        self.caption = kwargs.get('caption', None)
        self.footnotes = kwargs.get('footnotes', None)
        self.bounding_regions = kwargs.get('bounding_regions', None)
        self.spans = kwargs['spans']


class DocumentTableCell(msrest.serialization.Model):
    """An object representing the location and content of a table cell.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Table cell kind. Known values are: "content", "rowHeader", "columnHeader",
     "stubHead", "description". Default value: "content".
    :vartype kind: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentTableCellKind
    :ivar row_index: Required. Row index of the cell.
    :vartype row_index: int
    :ivar column_index: Required. Column index of the cell.
    :vartype column_index: int
    :ivar row_span: Number of rows spanned by this cell.
    :vartype row_span: int
    :ivar column_span: Number of columns spanned by this cell.
    :vartype column_span: int
    :ivar content: Required. Concatenated content of the table cell in reading order.
    :vartype content: str
    :ivar bounding_regions: Bounding regions covering the table cell.
    :vartype bounding_regions:
     list[~azure.ai.formrecognizer.v2022_06_30_preview.models.BoundingRegion]
    :ivar spans: Required. Location of the table cell in the reading order concatenated content.
    :vartype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
    """

    _validation = {
        'row_index': {'required': True},
        'column_index': {'required': True},
        'row_span': {'minimum': 1},
        'column_span': {'minimum': 1},
        'content': {'required': True},
        'spans': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'row_index': {'key': 'rowIndex', 'type': 'int'},
        'column_index': {'key': 'columnIndex', 'type': 'int'},
        'row_span': {'key': 'rowSpan', 'type': 'int'},
        'column_span': {'key': 'columnSpan', 'type': 'int'},
        'content': {'key': 'content', 'type': 'str'},
        'bounding_regions': {'key': 'boundingRegions', 'type': '[BoundingRegion]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword kind: Table cell kind. Known values are: "content", "rowHeader", "columnHeader",
         "stubHead", "description". Default value: "content".
        :paramtype kind: str or
         ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentTableCellKind
        :keyword row_index: Required. Row index of the cell.
        :paramtype row_index: int
        :keyword column_index: Required. Column index of the cell.
        :paramtype column_index: int
        :keyword row_span: Number of rows spanned by this cell.
        :paramtype row_span: int
        :keyword column_span: Number of columns spanned by this cell.
        :paramtype column_span: int
        :keyword content: Required. Concatenated content of the table cell in reading order.
        :paramtype content: str
        :keyword bounding_regions: Bounding regions covering the table cell.
        :paramtype bounding_regions:
         list[~azure.ai.formrecognizer.v2022_06_30_preview.models.BoundingRegion]
        :keyword spans: Required. Location of the table cell in the reading order concatenated content.
        :paramtype spans: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan]
        """
        super(DocumentTableCell, self).__init__(**kwargs)
        self.kind = kwargs.get('kind', "content")
        self.row_index = kwargs['row_index']
        self.column_index = kwargs['column_index']
        self.row_span = kwargs.get('row_span', 1)
        self.column_span = kwargs.get('column_span', 1)
        self.content = kwargs['content']
        self.bounding_regions = kwargs.get('bounding_regions', None)
        self.spans = kwargs['spans']


class DocumentWord(msrest.serialization.Model):
    """A word object consisting of a contiguous sequence of characters.  For non-space delimited languages, such as Chinese, Japanese, and Korean, each character is represented as its own word.

    All required parameters must be populated in order to send to Azure.

    :ivar content: Required. Text content of the word.
    :vartype content: str
    :ivar polygon: Bounding polygon of the word.
    :vartype polygon: list[float]
    :ivar span: Required. Location of the word in the reading order concatenated content.
    :vartype span: ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan
    :ivar confidence: Required. Confidence of correctly extracting the word.
    :vartype confidence: float
    """

    _validation = {
        'content': {'required': True},
        'span': {'required': True},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
        'polygon': {'key': 'polygon', 'type': '[float]'},
        'span': {'key': 'span', 'type': 'DocumentSpan'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword content: Required. Text content of the word.
        :paramtype content: str
        :keyword polygon: Bounding polygon of the word.
        :paramtype polygon: list[float]
        :keyword span: Required. Location of the word in the reading order concatenated content.
        :paramtype span: ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocumentSpan
        :keyword confidence: Required. Confidence of correctly extracting the word.
        :paramtype confidence: float
        """
        super(DocumentWord, self).__init__(**kwargs)
        self.content = kwargs['content']
        self.polygon = kwargs.get('polygon', None)
        self.span = kwargs['span']
        self.confidence = kwargs['confidence']


class Error(msrest.serialization.Model):
    """Error info.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. Error code.
    :vartype code: str
    :ivar message: Required. Error message.
    :vartype message: str
    :ivar target: Target of the error.
    :vartype target: str
    :ivar details: List of detailed errors.
    :vartype details: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.Error]
    :ivar innererror: Detailed error.
    :vartype innererror: ~azure.ai.formrecognizer.v2022_06_30_preview.models.InnerError
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[Error]'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code: Required. Error code.
        :paramtype code: str
        :keyword message: Required. Error message.
        :paramtype message: str
        :keyword target: Target of the error.
        :paramtype target: str
        :keyword details: List of detailed errors.
        :paramtype details: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.Error]
        :keyword innererror: Detailed error.
        :paramtype innererror: ~azure.ai.formrecognizer.v2022_06_30_preview.models.InnerError
        """
        super(Error, self).__init__(**kwargs)
        self.code = kwargs['code']
        self.message = kwargs['message']
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)
        self.innererror = kwargs.get('innererror', None)


class ErrorResponse(msrest.serialization.Model):
    """Error response object.

    All required parameters must be populated in order to send to Azure.

    :ivar error: Required. Error info.
    :vartype error: ~azure.ai.formrecognizer.v2022_06_30_preview.models.Error
    """

    _validation = {
        'error': {'required': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'Error'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword error: Required. Error info.
        :paramtype error: ~azure.ai.formrecognizer.v2022_06_30_preview.models.Error
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs['error']


class GetInfoResponse(msrest.serialization.Model):
    """General information regarding the current resource.

    All required parameters must be populated in order to send to Azure.

    :ivar custom_document_models: Required. Info regarding custom document models.
    :vartype custom_document_models:
     ~azure.ai.formrecognizer.v2022_06_30_preview.models.CustomDocumentModelsInfo
    """

    _validation = {
        'custom_document_models': {'required': True},
    }

    _attribute_map = {
        'custom_document_models': {'key': 'customDocumentModels', 'type': 'CustomDocumentModelsInfo'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword custom_document_models: Required. Info regarding custom document models.
        :paramtype custom_document_models:
         ~azure.ai.formrecognizer.v2022_06_30_preview.models.CustomDocumentModelsInfo
        """
        super(GetInfoResponse, self).__init__(**kwargs)
        self.custom_document_models = kwargs['custom_document_models']


class GetModelsResponse(msrest.serialization.Model):
    """List Models response object.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. List of models.
    :vartype value: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.ModelSummary]
    :ivar next_link: Link to the next page of models.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ModelSummary]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value: Required. List of models.
        :paramtype value: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.ModelSummary]
        :keyword next_link: Link to the next page of models.
        :paramtype next_link: str
        """
        super(GetModelsResponse, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class OperationInfo(msrest.serialization.Model):
    """Operation info.

    All required parameters must be populated in order to send to Azure.

    :ivar operation_id: Required. Operation ID.
    :vartype operation_id: str
    :ivar status: Required. Operation status. Known values are: "notStarted", "running", "failed",
     "succeeded", "canceled".
    :vartype status: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.OperationStatus
    :ivar percent_completed: Operation progress (0-100).
    :vartype percent_completed: int
    :ivar created_date_time: Required. Date and time (UTC) when the operation was created.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_updated_date_time: Required. Date and time (UTC) when the status was last updated.
    :vartype last_updated_date_time: ~datetime.datetime
    :ivar kind: Required. Type of operation. Known values are: "documentModelBuild",
     "documentModelCompose", "documentModelCopyTo".
    :vartype kind: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.OperationKind
    :ivar resource_location: Required. URL of the resource targeted by this operation.
    :vartype resource_location: str
    :ivar api_version: API version used to create this operation.
    :vartype api_version: str
    :ivar tags: A set of tags. List of key-value tag attributes associated with the model.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'operation_id': {'required': True},
        'status': {'required': True},
        'percent_completed': {'maximum': 100, 'minimum': 0},
        'created_date_time': {'required': True},
        'last_updated_date_time': {'required': True},
        'kind': {'required': True},
        'resource_location': {'required': True},
    }

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'percent_completed': {'key': 'percentCompleted', 'type': 'int'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
        'kind': {'key': 'kind', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword operation_id: Required. Operation ID.
        :paramtype operation_id: str
        :keyword status: Required. Operation status. Known values are: "notStarted", "running",
         "failed", "succeeded", "canceled".
        :paramtype status: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.OperationStatus
        :keyword percent_completed: Operation progress (0-100).
        :paramtype percent_completed: int
        :keyword created_date_time: Required. Date and time (UTC) when the operation was created.
        :paramtype created_date_time: ~datetime.datetime
        :keyword last_updated_date_time: Required. Date and time (UTC) when the status was last
         updated.
        :paramtype last_updated_date_time: ~datetime.datetime
        :keyword kind: Required. Type of operation. Known values are: "documentModelBuild",
         "documentModelCompose", "documentModelCopyTo".
        :paramtype kind: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.OperationKind
        :keyword resource_location: Required. URL of the resource targeted by this operation.
        :paramtype resource_location: str
        :keyword api_version: API version used to create this operation.
        :paramtype api_version: str
        :keyword tags: A set of tags. List of key-value tag attributes associated with the model.
        :paramtype tags: dict[str, str]
        """
        super(OperationInfo, self).__init__(**kwargs)
        self.operation_id = kwargs['operation_id']
        self.status = kwargs['status']
        self.percent_completed = kwargs.get('percent_completed', None)
        self.created_date_time = kwargs['created_date_time']
        self.last_updated_date_time = kwargs['last_updated_date_time']
        self.kind = kwargs['kind']
        self.resource_location = kwargs['resource_location']
        self.api_version = kwargs.get('api_version', None)
        self.tags = kwargs.get('tags', None)


class GetOperationResponse(OperationInfo):
    """Get Operation response object.

    All required parameters must be populated in order to send to Azure.

    :ivar operation_id: Required. Operation ID.
    :vartype operation_id: str
    :ivar status: Required. Operation status. Known values are: "notStarted", "running", "failed",
     "succeeded", "canceled".
    :vartype status: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.OperationStatus
    :ivar percent_completed: Operation progress (0-100).
    :vartype percent_completed: int
    :ivar created_date_time: Required. Date and time (UTC) when the operation was created.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_updated_date_time: Required. Date and time (UTC) when the status was last updated.
    :vartype last_updated_date_time: ~datetime.datetime
    :ivar kind: Required. Type of operation. Known values are: "documentModelBuild",
     "documentModelCompose", "documentModelCopyTo".
    :vartype kind: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.OperationKind
    :ivar resource_location: Required. URL of the resource targeted by this operation.
    :vartype resource_location: str
    :ivar api_version: API version used to create this operation.
    :vartype api_version: str
    :ivar tags: A set of tags. List of key-value tag attributes associated with the model.
    :vartype tags: dict[str, str]
    :ivar error: Encountered error.
    :vartype error: ~azure.ai.formrecognizer.v2022_06_30_preview.models.Error
    :ivar result: Operation result upon success.
    :vartype result: any
    """

    _validation = {
        'operation_id': {'required': True},
        'status': {'required': True},
        'percent_completed': {'maximum': 100, 'minimum': 0},
        'created_date_time': {'required': True},
        'last_updated_date_time': {'required': True},
        'kind': {'required': True},
        'resource_location': {'required': True},
    }

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'percent_completed': {'key': 'percentCompleted', 'type': 'int'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
        'kind': {'key': 'kind', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'error': {'key': 'error', 'type': 'Error'},
        'result': {'key': 'result', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword operation_id: Required. Operation ID.
        :paramtype operation_id: str
        :keyword status: Required. Operation status. Known values are: "notStarted", "running",
         "failed", "succeeded", "canceled".
        :paramtype status: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.OperationStatus
        :keyword percent_completed: Operation progress (0-100).
        :paramtype percent_completed: int
        :keyword created_date_time: Required. Date and time (UTC) when the operation was created.
        :paramtype created_date_time: ~datetime.datetime
        :keyword last_updated_date_time: Required. Date and time (UTC) when the status was last
         updated.
        :paramtype last_updated_date_time: ~datetime.datetime
        :keyword kind: Required. Type of operation. Known values are: "documentModelBuild",
         "documentModelCompose", "documentModelCopyTo".
        :paramtype kind: str or ~azure.ai.formrecognizer.v2022_06_30_preview.models.OperationKind
        :keyword resource_location: Required. URL of the resource targeted by this operation.
        :paramtype resource_location: str
        :keyword api_version: API version used to create this operation.
        :paramtype api_version: str
        :keyword tags: A set of tags. List of key-value tag attributes associated with the model.
        :paramtype tags: dict[str, str]
        :keyword error: Encountered error.
        :paramtype error: ~azure.ai.formrecognizer.v2022_06_30_preview.models.Error
        :keyword result: Operation result upon success.
        :paramtype result: any
        """
        super(GetOperationResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)
        self.result = kwargs.get('result', None)


class GetOperationsResponse(msrest.serialization.Model):
    """List Operations response object.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. List of operations.
    :vartype value: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.OperationInfo]
    :ivar next_link: Link to the next page of operations.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value: Required. List of operations.
        :paramtype value: list[~azure.ai.formrecognizer.v2022_06_30_preview.models.OperationInfo]
        :keyword next_link: Link to the next page of operations.
        :paramtype next_link: str
        """
        super(GetOperationsResponse, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class InnerError(msrest.serialization.Model):
    """Detailed error.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. Error code.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    :ivar innererror: Detailed error.
    :vartype innererror: ~azure.ai.formrecognizer.v2022_06_30_preview.models.InnerError
    """

    _validation = {
        'code': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code: Required. Error code.
        :paramtype code: str
        :keyword message: Error message.
        :paramtype message: str
        :keyword innererror: Detailed error.
        :paramtype innererror: ~azure.ai.formrecognizer.v2022_06_30_preview.models.InnerError
        """
        super(InnerError, self).__init__(**kwargs)
        self.code = kwargs['code']
        self.message = kwargs.get('message', None)
        self.innererror = kwargs.get('innererror', None)


class ModelSummary(msrest.serialization.Model):
    """Model summary.

    All required parameters must be populated in order to send to Azure.

    :ivar model_id: Required. Unique model name.
    :vartype model_id: str
    :ivar description: Model description.
    :vartype description: str
    :ivar created_date_time: Required. Date and time (UTC) when the model was created.
    :vartype created_date_time: ~datetime.datetime
    :ivar api_version: API version used to create this model.
    :vartype api_version: str
    :ivar tags: A set of tags. List of key-value tag attributes associated with the model.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'model_id': {'required': True, 'pattern': r'[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}'},
        'description': {'max_length': 4096, 'min_length': 0},
        'created_date_time': {'required': True},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword model_id: Required. Unique model name.
        :paramtype model_id: str
        :keyword description: Model description.
        :paramtype description: str
        :keyword created_date_time: Required. Date and time (UTC) when the model was created.
        :paramtype created_date_time: ~datetime.datetime
        :keyword api_version: API version used to create this model.
        :paramtype api_version: str
        :keyword tags: A set of tags. List of key-value tag attributes associated with the model.
        :paramtype tags: dict[str, str]
        """
        super(ModelSummary, self).__init__(**kwargs)
        self.model_id = kwargs['model_id']
        self.description = kwargs.get('description', None)
        self.created_date_time = kwargs['created_date_time']
        self.api_version = kwargs.get('api_version', None)
        self.tags = kwargs.get('tags', None)


class ModelInfo(ModelSummary):
    """Model info.

    All required parameters must be populated in order to send to Azure.

    :ivar model_id: Required. Unique model name.
    :vartype model_id: str
    :ivar description: Model description.
    :vartype description: str
    :ivar created_date_time: Required. Date and time (UTC) when the model was created.
    :vartype created_date_time: ~datetime.datetime
    :ivar api_version: API version used to create this model.
    :vartype api_version: str
    :ivar tags: A set of tags. List of key-value tag attributes associated with the model.
    :vartype tags: dict[str, str]
    :ivar doc_types: Supported document types.
    :vartype doc_types: dict[str, ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocTypeInfo]
    """

    _validation = {
        'model_id': {'required': True, 'pattern': r'[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}'},
        'description': {'max_length': 4096, 'min_length': 0},
        'created_date_time': {'required': True},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'doc_types': {'key': 'docTypes', 'type': '{DocTypeInfo}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword model_id: Required. Unique model name.
        :paramtype model_id: str
        :keyword description: Model description.
        :paramtype description: str
        :keyword created_date_time: Required. Date and time (UTC) when the model was created.
        :paramtype created_date_time: ~datetime.datetime
        :keyword api_version: API version used to create this model.
        :paramtype api_version: str
        :keyword tags: A set of tags. List of key-value tag attributes associated with the model.
        :paramtype tags: dict[str, str]
        :keyword doc_types: Supported document types.
        :paramtype doc_types: dict[str,
         ~azure.ai.formrecognizer.v2022_06_30_preview.models.DocTypeInfo]
        """
        super(ModelInfo, self).__init__(**kwargs)
        self.doc_types = kwargs.get('doc_types', None)
