# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .linked_service import LinkedService


class AzureKeyVaultLinkedService(LinkedService):
    """Azure Key Vault linked service.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param connect_via: The integration runtime reference.
    :type connect_via:
     ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param type: Constant filled by server.
    :type type: str
    :param base_url: The base URL of the Azure Key Vault. e.g.
     https://myakv.vault.azure.net Type: string (or Expression with resultType
     string).
    :type base_url: object
    """

    _validation = {
        'type': {'required': True},
        'base_url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'base_url': {'key': 'typeProperties.baseUrl', 'type': 'object'},
    }

    def __init__(self, base_url, additional_properties=None, connect_via=None, description=None):
        super(AzureKeyVaultLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description)
        self.base_url = base_url
        self.type = 'AzureKeyVault'
