/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Dimension;
import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.basics.HotkeyManager;
import org.sikuli.basics.PreferencesUser;
import org.sikuli.basics.Settings;
import org.sikuli.script.FindFailed;
import org.sikuli.script.Finder;
import org.sikuli.script.Image;
import org.sikuli.script.ImagePath;
import org.sikuli.script.Keys;
import org.sikuli.script.Mouse;
import org.sikuli.script.Observing;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;
import org.sikuli.script.RunServer;
import org.sikuli.script.RunTime;
import org.sikuli.script.Runner;
import org.sikuli.script.Screen;
import org.sikuli.util.JythonHelper;
import org.sikuli.util.ScreenHighlighter;
import org.sikuli.util.Tests;

public class Sikulix {
    private static String imgLink = "http://www.sikulix.com/uploads/1/4/2/8/14281286";
    private static String imgHttp = "1389888228.jpg";
    private static String imgNet = imgLink + "/" + imgHttp;
    private static int lvl = 3;
    private static boolean runningFromJar;
    private static String jarPath;
    private static String jarParentPath;
    private static final String prefNonSikuli = "nonSikuli_";
    private static RunTime rt;
    public static int testNumber;
    private static boolean shouldRunServer;
    private static boolean runningSikulixapi;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, "Sikulix: " + message, args);
    }

    private static void p(String msg, Object ... args) {
        System.out.println(String.format(msg, args));
    }

    private static void terminate(int retVal, String msg, Object ... args) {
        Sikulix.p(msg, args);
        System.exit(retVal);
    }

    public static void main(String[] args) throws FindFailed {
        if (args.length > 0 && args[0].toLowerCase().startsWith("-s")) {
            shouldRunServer = true;
        } else {
            System.out.println("********** Running Sikulix.main");
            int dl = RunTime.checkArgs(args, RunTime.Type.API);
            if (dl > -1 && dl < 999) {
                testNumber = dl;
                Debug.on(3);
            } else {
                testNumber = -1;
            }
            testNumber = rt.getOptionNumber("testing.test", testNumber);
            if (dl == 999) {
                int exitCode = Runner.runScripts(args);
                Sikulix.cleanUp(exitCode);
                System.exit(exitCode);
            } else if (testNumber > -1) {
                if (!RunTime.testing) {
                    rt.show();
                    RunTime.testing = true;
                }
                Tests.runTest(testNumber);
                System.exit(1);
            }
        }
        rt = RunTime.get();
        if (Sikulix.rt.fSxBaseJar.getName().contains("setup")) {
            Sikulix.popError("Not useable!\nRun setup first!");
            System.exit(0);
        }
        if (shouldRunServer && RunServer.run(null)) {
            System.exit(1);
        }
        Debug.on(3);
        Settings.InfoLogs = false;
        Settings.ActionLogs = false;
        ImagePath.add("org.sikuli.script.Sikulix/ImagesAPI.sikuli");
        if (Sikulix.rt.runningWinApp) {
            Sikulix.popup("Hello World\nNot much else to do ( yet ;-)", Sikulix.rt.fSxBaseJar.getName());
            try {
                Screen scr = new Screen();
                scr.find(new Image(scr.userCapture("grab something to find"))).highlight(3);
            }
            catch (Exception ex) {
                Sikulix.popup("Uuups :-(\n" + ex.getMessage(), Sikulix.rt.fSxBaseJar.getName());
            }
            Sikulix.popup("Hello World\nNothing else to do ( yet ;-)", Sikulix.rt.fSxBaseJar.getName());
            System.exit(1);
        }
        String version = String.format("(%s-%s)", rt.getVersionShort(), Sikulix.rt.sxBuildStamp);
        File lastSession = new File(Sikulix.rt.fSikulixStore, "LastAPIJavaScript.js");
        String runSomeJS = "";
        if (lastSession.exists()) {
            runSomeJS = FileManager.readFileToString(lastSession);
        }
        if ((runSomeJS = Sikulix.inputText("enter some JavaScript (know what you do - may silently die ;-)\nexample: run(\"git*\") will run the JavaScript showcase from GitHub\nWhat you enter now will be shown the next time.", "API::JavaScriptRunner " + version, 10, 60, runSomeJS)).isEmpty()) {
            Sikulix.popup("Nothing to do!", version);
        } else {
            while (!runSomeJS.isEmpty()) {
                FileManager.writeStringToFile(runSomeJS, lastSession);
                Runner.runjs(null, null, runSomeJS, null);
                runSomeJS = Sikulix.inputText("Edit the JavaScript and/or press OK to run it (again)\nPress Cancel to terminate", "API::JavaScriptRunner " + version, 10, 60, runSomeJS);
            }
        }
        System.exit(0);
    }

    public static String load(String fpJar) {
        return Sikulix.load(fpJar, null);
    }

    public static String load(String fpJar, String fpJarImagePath) {
        JythonHelper jython = JythonHelper.get();
        String fpJarFound = null;
        if (jython != null) {
            File aFile = jython.existsSysPathJar(fpJar);
            if (aFile != null) {
                fpJar = aFile.getAbsolutePath();
            }
            fpJarFound = jython.load(fpJar);
        } else {
            File fJarFound = rt.asExtension(fpJar);
            if (fJarFound != null) {
                fpJarFound = fJarFound.getAbsolutePath();
                rt.addToClasspath(fpJarFound);
            }
        }
        if (fpJarFound != null && fpJarImagePath != null) {
            ImagePath.addJar(fpJarFound, fpJarImagePath);
        }
        return fpJarFound;
    }

    public static boolean buildJarFromFolder(String targetJar, String sourceFolder) {
        Sikulix.log(lvl, "buildJarFromFolder: \nfrom Folder: %s\nto Jar: %s", sourceFolder, targetJar);
        File fJar = new File(targetJar);
        if (!fJar.getParentFile().exists()) {
            Sikulix.log(-1, "buildJarFromFolder: parent folder of Jar not available", new Object[0]);
            return false;
        }
        File fSrc = new File(sourceFolder);
        if (!fSrc.exists() || !fSrc.isDirectory()) {
            Sikulix.log(-1, "buildJarFromFolder: source folder not available", new Object[0]);
            return false;
        }
        String prefix = null;
        if ((new File(fSrc, "__init__.py").exists() || new File(fSrc, "__init__$py.class").exists()) && (prefix = fSrc.getName()).endsWith("_")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        return FileManager.buildJar(targetJar, new String[]{null}, new String[]{sourceFolder}, new String[]{prefix}, null);
    }

    public static boolean compileJythonFolder(String fpSource, String fpTarget) {
        JythonHelper jython = JythonHelper.get();
        if (jython != null) {
            File fTarget = new File(fpTarget);
            FileManager.deleteFileOrFolder(fTarget);
            fTarget.mkdirs();
            if (!fTarget.exists()) {
                Sikulix.log(-1, "compileJythonFolder: target folder not available\n%", fTarget);
                return false;
            }
            File fSource = new File(fpSource);
            if (!fSource.exists()) {
                Sikulix.log(-1, "compileJythonFolder: source folder not available\n", fSource);
                return false;
            }
            if (fTarget.equals(fSource)) {
                Sikulix.log(-1, "compileJythonFolder: target folder cannot be the same as the source folder", new Object[0]);
                return false;
            }
            FileManager.xcopy(fSource, fTarget);
            if (!jython.exec("import compileall")) {
                return false;
            }
            jython = Sikulix.doCompileJythonFolder(jython, fTarget);
            FileManager.traverseFolder(fTarget, new CompileJythonFilter(jython));
        }
        return false;
    }

    private static JythonHelper doCompileJythonFolder(JythonHelper jython, File fSource) {
        String fpSource = FileManager.slashify(fSource.getAbsolutePath(), false);
        if (!jython.exec(String.format("compileall.compile_dir(\"%s\",maxlevels = 0, quiet = 1)", fpSource))) {
            return null;
        }
        for (File aFile : fSource.listFiles()) {
            if (!aFile.getName().endsWith(".py")) continue;
            aFile.delete();
        }
        return jython;
    }

    private static boolean addFromProject(String project, String aJar) {
        File aFile = null;
        if (Sikulix.rt.fSxProject == null) {
            return false;
        }
        aFile = new File(Sikulix.rt.fSxProject, project);
        aFile = new File(aFile, "target/" + aJar);
        return rt.addToClasspath(aFile.getAbsolutePath());
    }

    public static boolean isRunningFromJar() {
        return runningFromJar;
    }

    public static String getJarPath() {
        return jarPath;
    }

    public static String getJarParentPath() {
        return jarParentPath;
    }

    public static boolean isRunningSikulixapi() {
        return runningSikulixapi;
    }

    public static void setRunningSikulixapi(boolean runningAPI) {
        runningSikulixapi = runningAPI;
    }

    public static Screen init() {
        if (!Sikulix.canRun()) {
            return null;
        }
        Mouse.init();
        Keys.init();
        return new Screen();
    }

    public static boolean canRun() {
        return !RunTime.get().isHeadless();
    }

    public static void endNormal(int n) {
        Sikulix.log(lvl, "endNormal: %d", n);
        Sikulix.cleanUp(n);
        System.exit(n);
    }

    public static void endWarning(int n) {
        Sikulix.log(lvl, "endWarning: %d", n);
        Sikulix.cleanUp(n);
        System.exit(n);
    }

    public static void endError(int n) {
        Sikulix.log(lvl, "endError: %d", n);
        Sikulix.cleanUp(n);
        System.exit(n);
    }

    public static void terminate(int n) {
        String msg = "***** Terminating SikuliX Setup after a fatal error" + (n == 0 ? "*****\n" : " %d *****\n") + "SikuliX is not useable!\n" + "Check the error log at " + Debug.logfile;
        if (Settings.runningSetup) {
            if (Settings.noPupUps) {
                Sikulix.log(-1, msg, n);
            } else {
                Sikulix.popError(String.format(msg, n));
            }
        } else {
            Debug.error("***** Terminating SikuliX after a fatal error" + (n == 0 ? "*****\n" : " %d *****\n") + "It makes no sense to continue!\n" + "If you do not have any idea about the error cause or solution, run again\n" + "with a Debug level of 3. You might paste the output to the Q&A board.", n);
            Sikulix.cleanUp(0);
        }
        System.exit(1);
    }

    public static void cleanUp(int n) {
        Sikulix.log(lvl, "cleanUp: %d", n);
        ScreenHighlighter.closeAll();
        Observing.cleanUp();
        Mouse.reset();
        Screen.getPrimaryScreen().getRobot().keyUp();
        HotkeyManager.reset();
    }

    public static boolean testSetup() {
        return Sikulix.doTestSetup("Java API", false);
    }

    public static boolean testSetup(String src) {
        return Sikulix.doTestSetup(src, false);
    }

    public static boolean testSetupSilent() {
        Settings.noPupUps = true;
        return Sikulix.doTestSetup("Java API", true);
    }

    private static boolean doTestSetup(String testSetupSource, boolean silent) {
        Pattern p;
        Region r = Region.create(0, 0, 100, 100);
        Image img = new Image(r.getScreen().capture(r).getImage());
        Finder f = new Finder(img);
        boolean success = null != f.find(p = new Pattern(img));
        Sikulix.log(lvl, "testSetup: Finder setup with image %s", !success ? "did not work" : "worked");
        if (success &= f.hasNext()) {
            success = null != f.find(img.asFile());
            Sikulix.log(lvl, "testSetup: Finder setup with image file %s", !success ? "did not work" : "worked");
            success &= f.hasNext();
            String screenFind = "Screen.find(imagefile)";
            try {
                ((Screen)r.getScreen()).find(img.asFile());
                Sikulix.log(lvl, "testSetup: %s worked", screenFind);
                screenFind = "repeated Screen.find(imagefile)";
                ((Screen)r.getScreen()).find(img.asFile());
                Sikulix.log(lvl, "testSetup: %s worked", screenFind);
            }
            catch (Exception ex) {
                Sikulix.log(lvl, "testSetup: %s did not work", screenFind);
                success = false;
            }
        }
        if (success) {
            if (!silent) {
                Sikulix.popup("Hallo from Sikulix.testSetup: " + testSetupSource + "\n" + "SikuliX seems to be working!\n\nHave fun!");
                Sikulix.log(lvl, "testSetup: Finder.find: worked", new Object[0]);
            } else {
                System.out.println("[info] RunSetup: Sikulix.testSetup: Java Sikuli seems to be working!");
            }
            return true;
        }
        Sikulix.log(lvl, "testSetup: last Screen/Finder.find: did not work", new Object[0]);
        return false;
    }

    @Deprecated
    public static boolean addToClasspath(String jar) {
        return RunTime.get().addToClasspath(jar);
    }

    @Deprecated
    public static boolean isOnClasspath(String artefact) {
        return null != RunTime.get().isOnClasspath(artefact);
    }

    public static String run(String cmdline) {
        return Sikulix.run(new String[]{cmdline});
    }

    public static String run(String[] cmd) {
        return rt.runcmd(cmd);
    }

    public static void popError(String message) {
        Sikulix.popError(message, "Sikuli");
    }

    public static void popError(String message, String title) {
        JOptionPane.showMessageDialog(null, message, title, 0);
    }

    public static String input(String msg, String preset, String title, boolean hidden) {
        if (!hidden) {
            if ("".equals(title)) {
                title = "Sikuli input request";
            }
            return (String)JOptionPane.showInputDialog(null, msg, title, -1, null, null, preset);
        }
        preset = "";
        JTextArea tm = new JTextArea(msg);
        tm.setColumns(20);
        tm.setLineWrap(true);
        tm.setWrapStyleWord(true);
        tm.setEditable(false);
        tm.setBackground(new JLabel().getBackground());
        JPasswordField pw = new JPasswordField(preset);
        JPanel pnl = new JPanel();
        pnl.setLayout(new BoxLayout(pnl, 1));
        pnl.add(pw);
        pnl.add(Box.createVerticalStrut(10));
        pnl.add(tm);
        if (0 == JOptionPane.showConfirmDialog(null, pnl, title, 2)) {
            char[] pwc = pw.getPassword();
            String pwr = "";
            for (int i = 0; i < pwc.length; ++i) {
                pwr = pwr + pwc[i];
                pwc[i] = '\u0000';
            }
            return pwr;
        }
        return "";
    }

    public static String input(String msg, String title, boolean hidden) {
        return Sikulix.input(msg, "", title, hidden);
    }

    public static String input(String msg, boolean hidden) {
        return Sikulix.input(msg, "", "", hidden);
    }

    public static String input(String msg, String preset, String title) {
        return Sikulix.input(msg, preset, title, false);
    }

    public static String input(String msg, String preset) {
        return Sikulix.input(msg, preset, "", false);
    }

    public static String input(String msg) {
        return Sikulix.input(msg, "", "", false);
    }

    public static boolean popAsk(String msg) {
        return Sikulix.popAsk(msg, null);
    }

    public static boolean popAsk(String msg, String title) {
        int ret;
        if (title == null) {
            title = "... something to decide!";
        }
        return (ret = JOptionPane.showConfirmDialog(null, msg, title, 0)) != -1 && ret != 1;
    }

    public static void popup(String message) {
        Sikulix.popup(message, "Sikuli");
    }

    public static void popup(String message, String title) {
        JOptionPane.showMessageDialog(null, message, title, -1);
    }

    public static String popSelect(String msg, String[] options, String preset) {
        return Sikulix.popSelect(msg, null, options, preset);
    }

    public static String popSelect(String msg, String[] options) {
        if (options.length == 0) {
            return "";
        }
        return Sikulix.popSelect(msg, null, options, options[0]);
    }

    public static String popSelect(String msg, String title, String[] options) {
        if (options.length == 0) {
            return "";
        }
        return Sikulix.popSelect(msg, title, options, options[0]);
    }

    public static String popSelect(String msg, String title, String[] options, String preset) {
        if (title == null || "".equals(title)) {
            title = "... something to select!";
        }
        if (options.length == 0) {
            return "";
        }
        if (preset == null) {
            preset = options[0];
        }
        return (String)JOptionPane.showInputDialog(null, msg, title, -1, null, options, preset);
    }

    public static String inputText(String msg, String title, int lines, int width) {
        return Sikulix.inputText(msg, title, lines, width, "");
    }

    public static String inputText(String msg, String title, int lines, int width, String text) {
        width = Math.max(20, width);
        lines = Math.max(9, lines);
        if ("".equals(title)) {
            title = "Sikuli input request";
        }
        JTextArea ta = new JTextArea("");
        int w = width * ta.getFontMetrics(ta.getFont()).charWidth('m');
        int h = lines * ta.getFontMetrics(ta.getFont()).getHeight();
        ta.setPreferredSize(new Dimension(w, h));
        ta.setMaximumSize(new Dimension(w, 2 * h));
        ta.setText(text);
        JScrollPane sp = new JScrollPane(ta);
        sp.setVerticalScrollBarPolicy(21);
        JTextArea tm = new JTextArea(msg);
        tm.setColumns(width);
        tm.setLineWrap(true);
        tm.setWrapStyleWord(true);
        tm.setEditable(false);
        tm.setBackground(new JLabel().getBackground());
        JPanel pnl = new JPanel();
        pnl.setLayout(new BoxLayout(pnl, 1));
        pnl.add(sp);
        pnl.add(Box.createVerticalStrut(10));
        pnl.add(tm);
        pnl.add(Box.createVerticalStrut(10));
        if (0 == JOptionPane.showConfirmDialog(null, pnl, title, 2)) {
            return ta.getText();
        }
        return "";
    }

    public static boolean importPrefs(String path) {
        return true;
    }

    public static String arrayToString(String[] args) {
        String ret = "";
        for (String s : args) {
            if (s.contains(" ")) {
                s = "\"" + s + "\"";
            }
            ret = ret + s + " ";
        }
        return ret;
    }

    public static boolean exportPrefs(String path) {
        return true;
    }

    public static void prefStore(String key, String value) {
        PreferencesUser.getInstance().put(prefNonSikuli + key, value);
    }

    public static String prefLoad(String key) {
        return PreferencesUser.getInstance().get(prefNonSikuli + key, "");
    }

    public static String prefLoad(String key, String value) {
        return PreferencesUser.getInstance().get(prefNonSikuli + key, value);
    }

    public static String prefRemove(String key) {
        String val = Sikulix.prefLoad(key);
        PreferencesUser.getInstance().remove(prefNonSikuli + key);
        return val;
    }

    public static void prefRemove() {
        PreferencesUser.getInstance().removeAll(prefNonSikuli);
    }

    private static Exception Exception() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        rt = null;
        testNumber = -1;
        shouldRunServer = false;
        String jarName = "";
        CodeSource codeSrc = Sikulix.class.getProtectionDomain().getCodeSource();
        if (codeSrc != null && codeSrc.getLocation() != null) {
            jarName = codeSrc.getLocation().getPath();
        }
        if (jarName.contains("sikulixsetupAPI")) {
            JOptionPane.showMessageDialog(null, "Not useable!\nRun setup first!", "sikulixsetupAPI", 0);
            System.exit(0);
        }
        rt = RunTime.get();
        if (Debug.getDebugLevel() == 0) {
            Debug.setDebugLevel(1);
        }
        if (codeSrc != null && codeSrc.getLocation() != null) {
            URL jarURL = codeSrc.getLocation();
            jarPath = FileManager.slashify(new File(jarURL.getPath()).getAbsolutePath(), false);
            jarParentPath = new File(jarPath).getParent();
            if (jarPath.endsWith(".jar")) {
                runningFromJar = true;
            } else {
                jarPath = jarPath + "/";
            }
        }
        runningSikulixapi = false;
    }

    private static class CompileJythonFilter
    implements FileManager.FileFilter {
        JythonHelper jython = null;

        public CompileJythonFilter(JythonHelper jython) {
            this.jython = jython;
        }

        @Override
        public boolean accept(File entry) {
            if (this.jython != null && entry.isDirectory()) {
                this.jython = Sikulix.doCompileJythonFolder(this.jython, entry);
            }
            return false;
        }
    }
}

