/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.basics.Settings;
import org.sikuli.script.Env;
import org.sikuli.script.Screen;
import org.sikuli.script.Sikulix;
import org.sikuli.util.JythonHelper;
import org.sikuli.util.LinuxSupport;
import org.sikuli.util.SysJNA;

public class RunTime {
    public static File scriptProject = null;
    public static URL uScriptProject = null;
    public static boolean shouldRunServer = false;
    public static String appDataMsg = "";
    private final String me = "RunTime%s: ";
    private int lvl;
    private int minLvl = this.lvl = 3;
    private static String preLogMessages = "";
    public static final String runCmdError = "*****error*****";
    public static String NL = "\n";
    public boolean runningInteractive = false;
    public boolean runningTests = false;
    public String interactiveRunner;
    public File fLibsProvided;
    public File fLibsLocal;
    public boolean useLibsProvided = false;
    private String lastResult = "";
    public boolean shouldCleanDownloads = false;
    public boolean isJythonReady = false;
    private boolean shouldExport = false;
    private static RunTime runTime = null;
    private static int debugLevelSaved;
    private static String debugLogfileSaved;
    public static boolean testing;
    public static boolean testingWinApp;
    public Type runType = Type.INIT;
    public String sxBuild = "";
    public String sxBuildStamp = "";
    public String jreVersion = System.getProperty("java.runtime.version");
    public Preferences optionsIDE = null;
    public ClassLoader classLoader = RunTime.class.getClassLoader();
    public String baseJar = "";
    public String userName = "";
    public String fpBaseTempPath = "";
    private Class clsRef = RunTime.class;
    private Class clsRefBase = this.clsRef;
    private List<URL> classPath = new ArrayList<URL>();
    public File fTempPath = null;
    public File fBaseTempPath = null;
    public File fLibsFolder = null;
    public String fpJarLibs = "/sikulixlibs/";
    public String fpSysLibs = null;
    boolean areLibsExported = false;
    private Map<String, Boolean> libsLoaded = new HashMap<String, Boolean>();
    public File fUserDir = null;
    public File fWorkDir = null;
    public File fTestFolder = null;
    public File fTestFile = null;
    public File fAppPath = null;
    public File fSikulixAppPath = null;
    public File fSikulixExtensions = null;
    public String[] standardExtensions = new String[]{"selenium4sikulix"};
    public File fSikulixLib = null;
    public File fSikulixStore;
    public File fSikulixDownloadsGeneric = null;
    public File fSikulixDownloadsBuild = null;
    public File fSikulixSetup;
    private File fOptions = null;
    private Properties options = null;
    private String fnOptions = "SikulixOptions.txt";
    private String fnPrefs = "SikulixPreferences.txt";
    public File fSxBase = null;
    public File fSxBaseJar = null;
    public File fSxProject = null;
    public File fSxProjectTestScriptsJS = null;
    public File fSxProjectTestScripts = null;
    public String fpContent = "sikulixcontent";
    public boolean runningJar = true;
    public boolean runningInProject = false;
    public boolean runningWindows = false;
    public boolean runningMac = false;
    public boolean runningLinux = false;
    public boolean runningWinApp = false;
    public boolean runningMacApp = false;
    private theSystem runningOn = theSystem.FOO;
    private final String osNameSysProp = System.getProperty("os.name");
    private final String osVersionSysProp = System.getProperty("os.version");
    public String javaShow = "not-set";
    public int javaArch = 32;
    public int javaVersion = 0;
    public String javahome = FileManager.slashify(System.getProperty("java.home"), false);
    public String osName = "NotKnown";
    public String sysName = "NotKnown";
    public String osVersion = "";
    private String appType = null;
    public int debuglevelAPI = -1;
    private boolean runningScripts = false;
    public String linuxDistro = "???LINUX???";
    public String linuxAppSupport = "";
    public String linuxNeededLibs = "";
    GraphicsEnvironment genv = null;
    GraphicsDevice[] gdevs;
    public Rectangle[] monitorBounds = null;
    Rectangle rAllMonitors;
    int mainMonitor = -1;
    int nMonitors = 0;
    Point pNull = new Point(0, 0);
    File isRunning = null;
    FileOutputStream isRunningFile = null;
    String isRunningFilename = "s_i_k_u_l_i-ide-isrunning";
    public int SikuliVersionMajor;
    public int SikuliVersionMinor;
    public int SikuliVersionSub;
    public int SikuliVersionBetaN;
    public String SikuliProjectVersionUsed = "";
    public String SikuliProjectVersion = "";
    public String SikuliVersionBuild;
    public String SikuliVersionType;
    public String SikuliVersionTypeText;
    public String downloadBaseDirBase;
    public String downloadBaseDirWeb;
    public String downloadBaseDir;
    private final String dlProdLink = "https://launchpad.net/raiman/sikulix2013+/";
    private final String dlProdLink1 = ".0";
    private final String dlProdLink2 = "/+download/";
    private final String dlDevLink = "http://nightly.sikuli.de/";
    public String SikuliRepo;
    public String SikuliLocalRepo = "";
    public String[] ServerList = new String[]{"http://dl.dropboxusercontent.com/u/42895525/SikuliX"};
    private String sversion;
    private String bversion;
    public String SikuliVersionDefault;
    public String SikuliVersionBeta;
    public String SikuliVersionDefaultIDE;
    public String SikuliVersionBetaIDE;
    public String SikuliVersionDefaultScript;
    public String SikuliVersionBetaScript;
    public String SikuliVersion;
    public String SikuliVersionIDE;
    public String SikuliVersionScript;
    public String SikuliJythonVersion;
    public String SikuliJythonVersion25 = "2.5.4-rc1";
    public String SikuliJythonMaven;
    public String SikuliJythonMaven25;
    public String SikuliJython;
    public String SikuliJython25;
    public String SikuliJRubyVersion;
    public String SikuliJRuby;
    public String SikuliJRubyMaven;
    public String dlMavenRelease = "https://repo1.maven.org/maven2/";
    public String dlMavenSnapshot = "https://oss.sonatype.org/content/groups/public/";
    public Map<String, String> tessData = new HashMap<String, String>();
    public final String libOpenCV = "libopencv_java248";
    public String SikuliVersionLong;
    public String SikuliSystemVersion;
    public String SikuliJavaVersion;
    private String[] args = new String[0];
    private String[] sargs = new String[0];

    public static void resetProject() {
        scriptProject = null;
        uScriptProject = null;
    }

    public static void pause(int time) {
        try {
            Thread.sleep(time * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void pause(float time) {
        try {
            Thread.sleep((int)(time * 1000.0f));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void log(int level, String message, Object ... args) {
        Debug.logx(level, String.format("RunTime%s: ", new Object[]{this.runType}) + message, args);
    }

    private void logp(String message, Object ... args) {
        Debug.logx(-3, message, args);
    }

    private void logp(int level, String message, Object ... args) {
        if (level <= Debug.getDebugLevel()) {
            this.logp(message, args);
        }
    }

    public void terminate(int retval, String message, Object ... args) {
        this.log(-1, " *** terminating: " + message, args);
        System.exit(retval);
    }

    private RunTime() {
    }

    public static synchronized RunTime get(Type typ) {
        return RunTime.get(typ, null);
    }

    public static synchronized RunTime get(Type typ, String[] clArgs) {
        if (runTime == null) {
            runTime = new RunTime();
            int debugLevel = 0;
            if (null != clArgs) {
                debugLevel = RunTime.checkArgs(clArgs, typ);
                if (Type.IDE.equals((Object)typ)) {
                    if (debugLevel == -1) {
                        Debug.on(3);
                        Debug.log(3, "RunTime: option -d detected --- log goes to SikulixLog.txt", new Object[0]);
                        Debug.setLogFile("");
                        Settings.LogTime = true;
                        System.setProperty("sikuli.console", "false");
                    } else if (debugLevel == 999) {
                        RunTime.runTime.runningScripts = true;
                    } else if (debugLevel == -3) {
                        shouldRunServer = true;
                    }
                }
            }
            if (Type.API.equals((Object)typ)) {
                Debug.init();
            }
            String vJava = System.getProperty("java.runtime.version");
            String vVM = System.getProperty("java.vm.version");
            String vClass = System.getProperty("java.class.version");
            String vSysArch = System.getProperty("sikuli.arch");
            if (null == vSysArch) {
                vSysArch = System.getProperty("os.arch");
            } else {
                runTime.log(RunTime.runTime.lvl, "SystemProperty given: sikuli.arch=%s", vSysArch);
            }
            if (vSysArch != null) {
                if (vSysArch.contains("64")) {
                    RunTime.runTime.javaArch = 64;
                }
            } else {
                runTime.log(RunTime.runTime.lvl, "Java arch (32 or 64 Bit) not detected nor given - using %d Bit", RunTime.runTime.javaArch);
            }
            try {
                RunTime.runTime.javaVersion = Integer.parseInt(vJava.substring(2, 3));
                RunTime.runTime.javaShow = String.format("java %d-%d version %s vm %s class %s arch %s", RunTime.runTime.javaVersion, RunTime.runTime.javaArch, vJava, vVM, vClass, vSysArch);
            }
            catch (Exception ex) {
                runTime.log(-1, "Java version not detected (using 7): %s", vJava);
                RunTime.runTime.javaVersion = 7;
                RunTime.runTime.javaShow = String.format("java ?7?-%d version %s vm %s class %s arch %s", RunTime.runTime.javaArch, vJava, vVM, vClass, vSysArch);
                runTime.logp(RunTime.runTime.javaShow, new Object[0]);
                runTime.dumpSysProps();
            }
            if (Debug.getDebugLevel() > RunTime.runTime.minLvl) {
                runTime.dumpSysProps();
            }
            RunTime.runTime.osVersion = RunTime.runTime.osVersionSysProp;
            String os = RunTime.runTime.osNameSysProp.toLowerCase();
            if (os.startsWith("windows")) {
                RunTime.runTime.runningOn = theSystem.WIN;
                RunTime.runTime.sysName = "windows";
                RunTime.runTime.osName = "Windows";
                RunTime.runTime.runningWindows = true;
                NL = "\r\n";
            } else if (os.startsWith("mac")) {
                RunTime.runTime.runningOn = theSystem.MAC;
                RunTime.runTime.sysName = "mac";
                RunTime.runTime.osName = "Mac OSX";
                RunTime.runTime.runningMac = true;
            } else if (os.startsWith("linux")) {
                RunTime.runTime.runningOn = theSystem.LUX;
                RunTime.runTime.sysName = "linux";
                RunTime.runTime.osName = "Linux";
                RunTime.runTime.runningLinux = true;
                String result = runTime.runcmd("lsb_release -i -r -s");
                if (result.contains("*** error ***")) {
                    runTime.log(-1, "command returns error: lsb_release -i -r -s\n%s", result);
                } else {
                    RunTime.runTime.linuxDistro = result.replaceAll("\n", " ").trim();
                }
            } else {
                runTime.terminate(-1, "running on not supported System: %s (%s)", os, RunTime.runTime.osVersion);
            }
            RunTime.runTime.fpJarLibs = RunTime.runTime.fpJarLibs + RunTime.runTime.sysName + "/libs" + RunTime.runTime.javaArch;
            RunTime.runTime.fpSysLibs = RunTime.runTime.fpJarLibs.substring(1);
            String aFolder = System.getProperty("user.home");
            if (aFolder == null || aFolder.isEmpty() || !(RunTime.runTime.fUserDir = new File(aFolder)).exists()) {
                runTime.terminate(-1, "JavaSystemProperty::user.home not valid", new Object[0]);
            }
            if ((aFolder = System.getProperty("user.dir")) == null || aFolder.isEmpty() || !(RunTime.runTime.fWorkDir = new File(aFolder)).exists()) {
                runTime.terminate(-1, "JavaSystemProperty::user.dir not valid", new Object[0]);
            }
            RunTime.runTime.fSikulixAppPath = new File("SikulixAppDataNotAvailable");
            if (RunTime.runTime.runningWindows) {
                appDataMsg = "init: Windows: %APPDATA% not valid (null or empty) or is not accessible:\n%s";
                String tmpdir = System.getenv("APPDATA");
                if (tmpdir != null && !tmpdir.isEmpty()) {
                    RunTime.runTime.fAppPath = new File(tmpdir);
                    RunTime.runTime.fSikulixAppPath = new File(RunTime.runTime.fAppPath, "Sikulix");
                }
            } else if (RunTime.runTime.runningMac) {
                appDataMsg = "init: Mac: SikulxAppData does not exist or is not accessible:\n%s";
                RunTime.runTime.fAppPath = new File(RunTime.runTime.fUserDir, "Library/Application Support");
                RunTime.runTime.fSikulixAppPath = new File(RunTime.runTime.fAppPath, "Sikulix");
            } else if (RunTime.runTime.runningLinux) {
                RunTime.runTime.fAppPath = RunTime.runTime.fUserDir;
                RunTime.runTime.fSikulixAppPath = new File(RunTime.runTime.fAppPath, ".Sikulix");
                appDataMsg = "init: Linux: SikulxAppData does not exist or is not accessible:\n%s";
            }
            RunTime.runTime.fSikulixStore = new File(RunTime.runTime.fSikulixAppPath, "SikulixStore");
            RunTime.runTime.fSikulixStore.mkdirs();
            debugLevelSaved = Debug.getDebugLevel();
            debugLogfileSaved = Debug.logfile;
            File fDebug = new File(RunTime.runTime.fSikulixStore, "SikulixDebug.txt");
            if (fDebug.exists()) {
                if (Debug.getDebugLevel() == 0) {
                    Debug.setDebugLevel(3);
                }
                Debug.setLogFile(fDebug.getAbsolutePath());
                if (Type.IDE.equals((Object)typ)) {
                    System.setProperty("sikuli.console", "false");
                }
                runTime.logp("auto-debugging with level %d into:\n%s", Debug.getDebugLevel(), fDebug);
            }
            RunTime.runTime.fTestFolder = new File(RunTime.runTime.fUserDir, "SikulixTest");
            RunTime.runTime.fTestFile = new File(RunTime.runTime.fTestFolder, "SikulixTest.txt");
            runTime.loadOptions(typ);
            int dl = runTime.getOptionNumber("Debug.level");
            if (dl > 0 && Debug.getDebugLevel() < 2) {
                Debug.setDebugLevel(dl);
            }
            if (Debug.getDebugLevel() == 2) {
                runTime.dumpOptions();
            }
            if (Type.SETUP.equals((Object)typ) && debugLevel != -2) {
                Debug.setDebugLevel(3);
            }
            Settings.init();
            runTime.initSikulixOptions();
            runTime.init(typ);
            if (Type.IDE.equals((Object)typ)) {
                runTime.initIDEbefore();
                runTime.initAPI();
                runTime.initIDEafter();
            } else {
                runTime.initAPI();
                if (Type.SETUP.equals((Object)typ)) {
                    runTime.initSetup();
                }
            }
        }
        if (testingWinApp && !RunTime.runTime.runningWindows) {
            runTime.terminate(1, "***** for testing winapp: not running on Windows", new Object[0]);
        }
        return runTime;
    }

    public static synchronized RunTime get() {
        if (runTime == null) {
            return RunTime.get(Type.API);
        }
        return runTime;
    }

    public static synchronized RunTime reset(Type typ) {
        if (runTime != null) {
            preLogMessages = preLogMessages + "RunTime: resetting RunTime instance;";
            if (Sikulix.testNumber == 1) {
                Debug.setDebugLevel(debugLevelSaved);
            }
            Debug.setLogFile(debugLogfileSaved);
            runTime = null;
        }
        return RunTime.get(typ);
    }

    public static synchronized RunTime reset() {
        return RunTime.reset(Type.API);
    }

    private void init(Type typ) {
        String optJython;
        String tmpdir;
        if ("winapp".equals(this.getOption("testing"))) {
            this.log(this.lvl, "***** for testing: simulating WinApp", new Object[0]);
            testingWinApp = true;
        }
        for (String line : preLogMessages.split(";")) {
            if (line.isEmpty()) continue;
            this.log(this.lvl, line, new Object[0]);
        }
        this.log(this.lvl, "global init: entering as: %s", new Object[]{typ});
        this.sxBuild = this.SikuliVersionBuild;
        this.sxBuildStamp = this.sxBuild.replace("_", "").replace("-", "").replace(":", "").substring(0, 12);
        if (System.getProperty("user.name") != null) {
            this.userName = System.getProperty("user.name");
        }
        if (this.userName.isEmpty()) {
            this.userName = "unknown";
        }
        if ((tmpdir = System.getProperty("java.io.tmpdir")) != null && !tmpdir.isEmpty()) {
            this.fTempPath = new File(tmpdir);
        } else {
            this.terminate(1, "init: java.io.tmpdir not valid (null or empty", new Object[0]);
        }
        this.fBaseTempPath = new File(this.fTempPath, String.format("Sikulix_%d", FileManager.getRandomInt()));
        this.fpBaseTempPath = this.fBaseTempPath.getAbsolutePath();
        this.fBaseTempPath.mkdirs();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                RunTime.this.log(RunTime.this.lvl, "final cleanup", new Object[0]);
                if (RunTime.this.isRunning != null) {
                    try {
                        RunTime.this.isRunningFile.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    RunTime.this.isRunning.delete();
                }
                if (RunTime.this.shouldCleanDownloads) {
                    FileManager.deleteFileOrFolder(RunTime.this.fSikulixDownloadsBuild);
                }
                for (File f : RunTime.this.fTempPath.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        File aFile = new File(dir, name);
                        boolean isObsolete = false;
                        long lastTime = aFile.lastModified();
                        if (lastTime == 0L) {
                            return false;
                        }
                        if (lastTime < new Date().getTime() - 604800000L) {
                            isObsolete = true;
                        }
                        if (name.contains("BridJExtractedLibraries") && isObsolete) {
                            return true;
                        }
                        if (name.toLowerCase().contains("sikuli")) {
                            if (name.contains("Sikulix_")) {
                                if (isObsolete || aFile.equals(RunTime.this.fBaseTempPath)) {
                                    return true;
                                }
                            } else {
                                return true;
                            }
                        }
                        return false;
                    }
                })) {
                    Debug.log(4, "cleanTemp: " + f.getName(), new Object[0]);
                    FileManager.deleteFileOrFolder(f.getAbsolutePath());
                }
            }
        });
        if (Type.IDE.equals((Object)typ) && !this.runningScripts) {
            this.isRunning = new File(this.fTempPath, this.isRunningFilename);
            boolean shouldTerminate = false;
            try {
                this.isRunning.createNewFile();
                this.isRunningFile = new FileOutputStream(this.isRunning);
                if (null == this.isRunningFile.getChannel().tryLock()) {
                    Sikulix.popError("Terminating: IDE already running");
                    shouldTerminate = true;
                }
            }
            catch (Exception ex) {
                Sikulix.popError("Terminating on FatalError: cannot access IDE lock for/n" + this.isRunning);
                shouldTerminate = true;
            }
            if (shouldTerminate) {
                System.exit(1);
            }
        }
        for (String aFile : this.fTempPath.list()) {
            if ((!aFile.startsWith("Sikulix") || !new File(aFile).isFile()) && (!aFile.startsWith("jffi") || !aFile.endsWith(".tmp"))) continue;
            FileManager.deleteFileOrFolder(new File(this.fTempPath, aFile));
        }
        try {
            if (!this.fSikulixAppPath.exists()) {
                this.fSikulixAppPath.mkdirs();
            }
            if (!this.fSikulixAppPath.exists()) {
                this.terminate(1, appDataMsg, this.fSikulixAppPath);
            }
            this.fSikulixExtensions = new File(this.fSikulixAppPath, "Extensions");
            this.fSikulixLib = new File(this.fSikulixAppPath, "Lib");
            this.fSikulixDownloadsGeneric = new File(this.fSikulixAppPath, "SikulixDownloads");
            this.fSikulixSetup = new File(this.fSikulixAppPath, "SikulixSetup");
            this.fLibsProvided = new File(this.fSikulixAppPath, this.fpSysLibs);
            this.fLibsLocal = this.fLibsProvided.getParentFile().getParentFile();
            this.fSikulixExtensions.mkdir();
            this.fSikulixDownloadsGeneric.mkdir();
        }
        catch (Exception ex) {
            this.terminate(1, appDataMsg + "\n" + ex.toString(), this.fSikulixAppPath);
        }
        if (!this.isHeadless()) {
            this.genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.gdevs = this.genv.getScreenDevices();
            this.nMonitors = this.gdevs.length;
            if (this.nMonitors == 0) {
                this.terminate(1, "GraphicsEnvironment has no ScreenDevices", new Object[0]);
            }
            this.monitorBounds = new Rectangle[this.nMonitors];
            this.rAllMonitors = null;
            for (int i = 0; i < this.nMonitors; ++i) {
                Rectangle currentBounds = this.gdevs[i].getDefaultConfiguration().getBounds();
                this.rAllMonitors = null != this.rAllMonitors ? this.rAllMonitors.union(currentBounds) : currentBounds;
                if (currentBounds.contains(this.pNull)) {
                    if (this.mainMonitor < 0) {
                        this.mainMonitor = i;
                        this.log(this.lvl, "ScreenDevice %d has (0,0) --- will be primary Screen(0)", i);
                    } else {
                        this.log(this.lvl, "ScreenDevice %d too contains (0,0)!", i);
                    }
                }
                this.log(this.lvl, "Monitor %d: (%d, %d) %d x %d", i, currentBounds.x, currentBounds.y, currentBounds.width, currentBounds.height);
                this.monitorBounds[i] = currentBounds;
            }
            if (this.mainMonitor < 0) {
                this.log(this.lvl, "No ScreenDevice has (0,0) --- using 0 as primary: %s", this.monitorBounds[0]);
                this.mainMonitor = 0;
            }
        } else {
            this.log(this.lvl, "running in headless environment", new Object[0]);
        }
        try {
            if (Type.IDE.equals((Object)typ)) {
                this.clsRef = Class.forName("org.sikuli.ide.SikuliIDE");
            } else if (Type.SETUP.equals((Object)typ)) {
                this.clsRef = Class.forName("org.sikuli.setup.RunSetup");
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        CodeSource codeSrc = this.clsRef.getProtectionDomain().getCodeSource();
        String base = null;
        if (codeSrc != null && codeSrc.getLocation() != null) {
            base = FileManager.slashify(codeSrc.getLocation().getPath(), false);
        }
        this.appType = "from a jar";
        if (base != null) {
            this.fSxBaseJar = new File(base);
            String jn = this.fSxBaseJar.getName();
            this.fSxBase = this.fSxBaseJar.getParentFile();
            this.log(this.lvl, "runs as %s in: %s", jn, this.fSxBase.getAbsolutePath());
            if (jn.contains("classes")) {
                this.runningJar = false;
                this.fSxProject = this.fSxBase.getParentFile().getParentFile();
                this.log(this.lvl, "not jar - supposing Maven project: %s", this.fSxProject);
                this.appType = "in Maven project from classes";
                this.runningInProject = true;
            } else if ("target".equals(this.fSxBase.getName())) {
                this.fSxProject = this.fSxBase.getParentFile().getParentFile();
                this.log(this.lvl, "folder target detected - supposing Maven project: %s", this.fSxProject);
                this.appType = "in Maven project from some jar";
                this.runningInProject = true;
            } else if (this.runningWindows) {
                if (jn.endsWith(".exe")) {
                    this.runningWinApp = true;
                    this.runningJar = false;
                    this.appType = "as application .exe";
                }
            } else if (this.runningMac && this.fSxBase.getAbsolutePath().contains("SikuliX.app/Content")) {
                this.runningMacApp = true;
                this.appType = "as application .app";
                if (!this.fSxBase.getAbsolutePath().startsWith("/Applications")) {
                    this.appType = this.appType + " (not from /Applications folder)";
                }
            }
        } else {
            this.terminate(1, "no valid Java context for SikuliX available (java.security.CodeSource.getLocation() is null)", new Object[0]);
        }
        if (this.runningInProject) {
            this.fSxProjectTestScriptsJS = new File(this.fSxProject, "StuffContainer/testScripts/testJavaScript");
            this.fSxProjectTestScripts = new File(this.fSxProject, "StuffContainer/testScripts");
        }
        ArrayList<String> items = new ArrayList<String>();
        if (Type.API.equals((Object)typ) && !(optJython = this.getOption("jython")).isEmpty()) {
            items.add(optJython);
        }
        if (!Type.SETUP.equals((Object)typ)) {
            String optClasspath = this.getOption("classpath");
            if (!optClasspath.isEmpty()) {
                items.addAll(Arrays.asList(optClasspath.split(System.getProperty("path.separator"))));
            }
            items.addAll(Arrays.asList(this.standardExtensions));
            if (items.size() > 0) {
                String[] fList = this.fSikulixExtensions.list();
                block9: for (String item : items) {
                    if (new File(item = item.trim()).isAbsolute()) {
                        this.addToClasspath(item);
                        continue;
                    }
                    for (String fpFile : fList) {
                        File fFile = new File(this.fSikulixExtensions, fpFile);
                        if (fFile.length() > 0L) {
                            if (!fpFile.startsWith(item)) continue;
                            this.addToClasspath(fFile.getAbsolutePath());
                            continue block9;
                        }
                        fFile.delete();
                    }
                }
            }
        }
        if (this.runningWinApp || testingWinApp) {
            RunTime.runTime.fpJarLibs = RunTime.runTime.fpJarLibs + "windows";
            RunTime.runTime.fpSysLibs = RunTime.runTime.fpJarLibs.substring(1) + "/libs" + RunTime.runTime.javaArch;
        }
        if (!Type.SETUP.equals((Object)typ)) {
            this.libsExport(typ);
        } else {
            String[] fpList;
            this.fSikulixDownloadsBuild = new File(this.fSikulixAppPath, "SikulixDownloads_" + this.sxBuildStamp);
            if (!this.fSikulixDownloadsBuild.exists() && (fpList = this.fSikulixAppPath.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.contains("SikulixDownloads_");
                }
            })).length > 0) {
                this.log(this.lvl, "renaming versioned downloads folder in AppPath (%s)", this.fSikulixDownloadsBuild.getName());
                for (String entry : fpList) {
                    new File(this.fSikulixAppPath, entry).renameTo(this.fSikulixDownloadsBuild);
                }
            }
        }
        this.runType = typ;
        if (Debug.getDebugLevel() == this.minLvl) {
            this.show();
        }
        this.log(this.lvl, "global init: leaving", new Object[0]);
    }

    public void makeFolders() {
        this.fLibsFolder = new File(this.fSikulixAppPath, "SikulixLibs_" + this.sxBuildStamp);
        if (testing) {
            this.logp("***** for testing: delete folders SikulixLibs/ and Lib/", new Object[0]);
            FileManager.deleteFileOrFolder(this.fLibsFolder);
            FileManager.deleteFileOrFolder(this.fSikulixLib);
        }
        if (!this.fLibsFolder.exists()) {
            this.fLibsFolder.mkdirs();
            if (!this.fLibsFolder.exists()) {
                this.terminate(1, "libs folder not available: " + this.fLibsFolder.toString(), new Object[0]);
            }
            this.log(this.lvl, "new libs folder at: %s", this.fLibsFolder);
        } else {
            this.log(this.lvl, "exists libs folder at: %s", this.fLibsFolder);
        }
        String[] fpList = this.fTempPath.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains("SikulixLibs");
            }
        });
        if (fpList.length > 0) {
            this.log(this.lvl, "deleting obsolete libs folders in Temp", new Object[0]);
            for (String entry : fpList) {
                if (entry.endsWith(this.sxBuildStamp)) continue;
                FileManager.deleteFileOrFolder(new File(this.fTempPath, entry));
            }
        }
        if ((fpList = this.fSikulixAppPath.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains("SikulixLibs");
            }
        })).length > 1) {
            this.log(this.lvl, "deleting obsolete libs folders in AppPath", new Object[0]);
            for (String entry : fpList) {
                if (entry.endsWith(this.sxBuildStamp)) continue;
                FileManager.deleteFileOrFolder(new File(this.fSikulixAppPath, entry));
            }
        }
    }

    private boolean libsLoad(String libName) {
        if (!this.areLibsExported) {
            this.libsExport(this.runType);
        }
        if (!this.areLibsExported) {
            this.terminate(1, "loadLib: deferred exporting of libs did not work", new Object[0]);
        }
        if (this.runningWindows) {
            libName = libName + ".dll";
        } else if (this.runningMac) {
            libName = "lib" + libName + ".dylib";
        } else if (this.runningLinux) {
            libName = "lib" + libName + ".so";
        }
        File fLib = new File(this.fLibsFolder, libName);
        Boolean vLib = this.libsLoaded.get(libName);
        if (vLib == null || !fLib.exists()) {
            this.terminate(1, String.format("loadlib: %s not available in %s", libName, this.fLibsFolder), new Object[0]);
        }
        String msg = "loadLib: %s";
        int level = this.lvl;
        if (vLib.booleanValue()) {
            ++level;
            msg = msg + " already loaded";
        }
        if (vLib.booleanValue()) {
            this.log(level, msg, libName);
            return true;
        }
        boolean shouldTerminate = false;
        Error loadError = null;
        while (!shouldTerminate) {
            shouldTerminate = true;
            loadError = null;
            try {
                System.load(new File(this.fLibsFolder, libName).getAbsolutePath());
            }
            catch (Error e) {
                loadError = e;
                if (!this.runningLinux) continue;
                this.log(-1, msg + " not usable: \n%s", libName, loadError);
                shouldTerminate = !LinuxSupport.checkAllLibs();
            }
        }
        if (loadError != null) {
            this.log(-1, "Problematic lib: %s (...TEMP...)", fLib);
            this.log(-1, "%s loaded, but it might be a problem with needed dependent libraries\nERROR: %s", libName, loadError.getMessage().replace(fLib.getAbsolutePath(), "...TEMP..."));
            this.terminate(1, "problem with native library: " + libName, new Object[0]);
        }
        this.libsLoaded.put(libName, true);
        this.log(level, msg, libName);
        return true;
    }

    private boolean libsCheck(File flibsFolder) {
        String name = String.format("1.1-MadeForSikuliX%d%s.txt", this.javaArch, this.runningOn.toString().substring(0, 1));
        if (!new File(flibsFolder, name).exists()) {
            this.log(this.lvl, "libs folder empty or has wrong content", new Object[0]);
            return false;
        }
        return true;
    }

    private void libsExport(Type typ) {
        this.shouldExport = false;
        this.makeFolders();
        URL uLibsFrom = null;
        if (!this.libsCheck(this.fLibsFolder)) {
            FileManager.deleteFileOrFolder(this.fLibsFolder);
            this.fLibsFolder.mkdirs();
            this.shouldExport = true;
            if (!this.fLibsFolder.exists()) {
                this.terminate(1, "libs folder not available: " + this.fLibsFolder.toString(), new Object[0]);
            }
        }
        if (this.shouldExport) {
            String sysShort = "win";
            if (!this.runningWinApp && !testingWinApp) {
                sysShort = this.runningOn.toString().toLowerCase();
            }
            String fpLibsFrom = "";
            if (this.runningJar) {
                fpLibsFrom = this.fSxBaseJar.getAbsolutePath();
            } else {
                String fSrcFolder = typ.toString();
                if (Type.SETUP.toString().equals(fSrcFolder)) {
                    fSrcFolder = "Setup";
                }
                fpLibsFrom = this.fSxBaseJar.getPath().replace(fSrcFolder, "Libs" + sysShort) + "/";
            }
            boolean shouldAddLibsJar = false;
            if (testing && !this.runningJar) {
                if (testingWinApp || this.testSwitch()) {
                    this.logp("***** for testing: exporting from classes", new Object[0]);
                } else {
                    this.logp("***** for testing: exporting from jar", new Object[0]);
                    shouldAddLibsJar = true;
                }
            }
            if (null != this.isJarOnClasspath("sikulix.jar") || null != this.isJarOnClasspath("sikulixapi.jar")) {
                shouldAddLibsJar = false;
                fpLibsFrom = "";
            }
            if (shouldAddLibsJar) {
                fpLibsFrom = new File(this.fSxProject, String.format("Libs%s/target/sikulixlibs%s-1.1.0.jar", sysShort, sysShort)).getAbsolutePath();
            }
            this.log(this.lvl, "now exporting libs", new Object[0]);
            if (!fpLibsFrom.isEmpty()) {
                this.addToClasspath(fpLibsFrom);
            }
            uLibsFrom = this.clsRef.getResource(this.fpJarLibs);
            if (testing || uLibsFrom == null) {
                this.dumpClassPath();
            }
            if (uLibsFrom == null) {
                this.terminate(1, "libs to export not found on above classpath: " + this.fpJarLibs, new Object[0]);
            }
            this.log(this.lvl, "libs to export are at:\n%s", uLibsFrom);
            if (this.runningWinApp || testingWinApp) {
                String libsAccepted = "libs" + this.javaArch;
                this.extractResourcesToFolder(this.fpJarLibs, this.fLibsFolder, new LibsFilter(libsAccepted));
                File fCurrentLibs = new File(this.fLibsFolder, libsAccepted);
                if (FileManager.xcopy(fCurrentLibs, this.fLibsFolder)) {
                    FileManager.deleteFileOrFolder(fCurrentLibs);
                } else {
                    this.terminate(1, "could not create libs folder for Windows --- see log", new Object[0]);
                }
            } else {
                this.extractResourcesToFolder(this.fpJarLibs, this.fLibsFolder, null);
            }
        }
        for (String aFile : this.fLibsFolder.list()) {
            this.libsLoaded.put(aFile, false);
        }
        if (this.useLibsProvided) {
            this.log(this.lvl, "Linux: requested to use provided libs - copying", new Object[0]);
            LinuxSupport.copyProvidedLibs(this.fLibsFolder);
        }
        if (this.runningWindows) {
            this.addToWindowsSystemPath(this.fLibsFolder);
            if (!this.checkJavaUsrPath(this.fLibsFolder)) {
                this.log(-1, "Problems setting up on Windows - see errors - might not work and crash later", new Object[0]);
            }
            String lib = "jawt.dll";
            File fJawtDll = new File(this.fLibsFolder, lib);
            FileManager.deleteFileOrFolder(fJawtDll);
            FileManager.xcopy(new File(this.javahome + "/bin/" + lib), fJawtDll);
            if (!fJawtDll.exists()) {
                this.terminate(1, "problem copying %s", fJawtDll);
            }
        }
        this.areLibsExported = true;
    }

    public static void loadLibrary(String libname) {
        RunTime.get().libsLoad(libname);
    }

    public static void loadLibrary(String libname, boolean useLibsProvided) {
        RunTime rt = RunTime.get();
        rt.useLibsProvided = useLibsProvided;
        rt.libsLoad(libname);
    }

    private void addToWindowsSystemPath(File fLibsFolder) {
        String syspath = SysJNA.WinKernel32.getEnvironmentVariable("PATH");
        if (syspath == null) {
            this.terminate(1, "addToWindowsSystemPath: cannot access system path", new Object[0]);
        } else {
            String libsPath = fLibsFolder.getAbsolutePath().replaceAll("/", "\\");
            if (!syspath.toUpperCase().contains(libsPath.toUpperCase())) {
                if (!SysJNA.WinKernel32.setEnvironmentVariable("PATH", libsPath + ";" + syspath)) {
                    Sikulix.terminate(999);
                }
                if (!(syspath = SysJNA.WinKernel32.getEnvironmentVariable("PATH")).toUpperCase().contains(libsPath.toUpperCase())) {
                    this.log(-1, "addToWindowsSystemPath: adding to system path did not work:\n%s", syspath);
                    this.terminate(1, "addToWindowsSystemPath: did not work - see error", new Object[0]);
                }
                this.log(this.lvl, "addToWindowsSystemPath: added to systempath:\n%s", libsPath);
            }
        }
    }

    private boolean checkJavaUsrPath(File fLibsFolder) {
        String fpLibsFolder = fLibsFolder.getAbsolutePath();
        Field usrPathsField = null;
        boolean contained = false;
        try {
            usrPathsField = ClassLoader.class.getDeclaredField("usr_paths");
        }
        catch (NoSuchFieldException ex) {
            this.log(-1, "checkJavaUsrPath: get\n%s", ex);
        }
        catch (SecurityException ex) {
            this.log(-1, "checkJavaUsrPath: get\n%s", ex);
        }
        if (usrPathsField != null) {
            usrPathsField.setAccessible(true);
            try {
                String[] javapaths;
                for (String p : javapaths = (String[])usrPathsField.get(null)) {
                    if (!new File(p).equals(fLibsFolder)) continue;
                    contained = true;
                    break;
                }
                if (!contained) {
                    String[] newPaths = Arrays.copyOf(javapaths, javapaths.length + 1);
                    newPaths[newPaths.length - 1] = fpLibsFolder;
                    usrPathsField.set(null, newPaths);
                    this.log(this.lvl, "checkJavaUsrPath: added to ClassLoader.usrPaths", new Object[0]);
                    contained = true;
                }
            }
            catch (IllegalAccessException ex) {
                this.log(-1, "checkJavaUsrPath: set\n%s", ex);
            }
            catch (IllegalArgumentException ex) {
                this.log(-1, "checkJavaUsrPath: set\n%s", ex);
            }
            return contained;
        }
        return false;
    }

    private void initIDEbefore() {
        this.log(this.lvl, "initIDEbefore: entering", new Object[0]);
        this.optionsIDE = Preferences.userNodeForPackage(Sikulix.class);
        if (this.jreVersion.startsWith("1.6")) {
            String jyversion = "";
            Properties prop = new Properties();
            String fp = "org/python/version.properties";
            InputStream ifp = null;
            try {
                ifp = this.classLoader.getResourceAsStream(fp);
                if (ifp != null) {
                    prop.load(ifp);
                    ifp.close();
                    jyversion = prop.getProperty("jython.version");
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (!jyversion.isEmpty() && !jyversion.startsWith("2.5")) {
                Sikulix.popError(String.format("The bundled Jython %s\ncannot be used on Java 6!\nRun setup again in this environment.\nClick OK to terminate now", jyversion));
                System.exit(1);
            }
        }
        Settings.isRunningIDE = true;
        if (this.runningMac) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            if (!(this.runningMacApp || this.runningInProject || Sikulix.popAsk("This use of SikuliX is not supported\nand might lead to misbehavior!\nClick YES to continue (you should be sure)\nClick NO to terminate and check the situation."))) {
                System.exit(1);
            }
        }
        this.log(this.lvl, "initIDEbefore: leaving", new Object[0]);
    }

    private void initIDEafter() {
    }

    private void initAPI() {
        this.log(this.lvl, "initAPI: entering", new Object[0]);
        if (this.runType == Type.API && (this.shouldExport || !this.fSikulixLib.exists())) {
            this.fSikulixLib.mkdir();
            this.extractResourcesToFolder("Lib", this.fSikulixLib, null);
        }
        this.log(this.lvl, "initAPI: leaving", new Object[0]);
    }

    private void initSetup() {
    }

    public boolean isRunningFromJar() {
        return this.runningJar;
    }

    public boolean isJava8() {
        return this.javaVersion > 7;
    }

    public boolean isJava7() {
        return this.javaVersion > 6;
    }

    public boolean isOSX10() {
        return this.osVersion.startsWith("10.10.");
    }

    public void show() {
        if (this.hasOptions()) {
            this.dumpOptions();
        }
        this.logp("***** show environment for %s (build %s)", new Object[]{this.runType, this.sxBuildStamp});
        this.logp("user.home: %s", this.fUserDir);
        this.logp("user.dir (work dir): %s", this.fWorkDir);
        this.logp("user.name: %s", this.userName);
        this.logp("java.io.tmpdir: %s", this.fTempPath);
        this.logp("running %dBit on %s (%s) %s", this.javaArch, this.osName, this.linuxDistro.contains("???") ? this.osVersion : this.linuxDistro, this.appType);
        this.logp(this.javaShow, new Object[0]);
        this.logp("app data folder: %s", this.fSikulixAppPath);
        this.logp("libs folder: %s", this.fLibsFolder);
        if (this.runningJar) {
            this.logp("executing jar: %s", this.fSxBaseJar);
        }
        if (Debug.getDebugLevel() > this.minLvl - 1 || this.isJythonReady) {
            this.dumpClassPath("sikulix");
            if (this.isJythonReady) {
                int saveLvl = Debug.getDebugLevel();
                Debug.setDebugLevel(this.lvl);
                JythonHelper.get().showSysPath();
                Screen.showMonitors();
                Debug.setDebugLevel(saveLvl);
            }
        }
        this.logp("***** show environment end", new Object[0]);
    }

    public boolean testSwitch() {
        return 0L == new Date().getTime() / 10000L % 2L;
    }

    public String getVersionShortBasic() {
        return this.sversion.substring(0, 3);
    }

    public String getVersionShort() {
        if (this.SikuliVersionBetaN > 0 && this.SikuliVersionBetaN < 99) {
            return this.bversion;
        }
        return this.sversion;
    }

    public String getSystemInfo() {
        return String.format("%s/%s/%s", this.SikuliVersionLong, this.SikuliSystemVersion, this.SikuliJavaVersion);
    }

    public boolean isVersionRelease() {
        return this.SikuliVersionType.isEmpty();
    }

    public String getVersion() {
        return this.SikuliVersion;
    }

    public void getStatus() {
        System.out.println("***** System Information Dump *****");
        System.out.println(String.format("*** SystemInfo\n%s", this.getSystemInfo()));
        System.getProperties().list(System.out);
        System.out.println("*** System Environment");
        for (String key : System.getenv().keySet()) {
            System.out.println(String.format("%s = %s", key, System.getenv(key)));
        }
        System.out.println("*** Java Class Path");
        URLClassLoader sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL[] urls = sysLoader.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            System.out.println(String.format("%d: %s", i, urls[i]));
        }
        System.out.println("***** System Information Dump ***** end *****");
    }

    private void loadOptions(Type typ) {
        for (File aFile : new File[]{this.fWorkDir, this.fUserDir, this.fSikulixStore}) {
            this.log(this.lvl, "loadOptions: check: %s", aFile);
            this.fOptions = new File(aFile, this.fnOptions);
            if (this.fOptions.exists()) break;
            this.fOptions = null;
        }
        if (this.fOptions != null) {
            this.options = new Properties();
            try {
                FileInputStream is = new FileInputStream(this.fOptions);
                this.options.load(is);
                ((InputStream)is).close();
            }
            catch (Exception ex) {
                this.log(-1, "while checking Options file:\n%s", this.fOptions);
                this.fOptions = null;
                this.options = null;
            }
            testing = this.isOption("testing", false);
            if (testing) {
                Debug.setDebugLevel(3);
            }
            this.log(this.lvl, "found Options file at: %s", this.fOptions);
        }
        if (this.hasOptions()) {
            for (Object oKey : this.options.keySet()) {
                String sKey = (String)oKey;
                String[] parts = sKey.split("\\.");
                if (parts.length == 1) continue;
                String sClass = parts[0];
                String sAttr = parts[1];
                Class<?> cClass = null;
                Field cField = null;
                Class<?> ccField = null;
                if (!sClass.contains("Settings")) continue;
                try {
                    cClass = Class.forName("org.sikuli.basics.Settings");
                    cField = cClass.getField(sAttr);
                    ccField = cField.getType();
                    if (ccField.getName() == "boolean") {
                        cField.setBoolean(null, this.isOption(sKey));
                        continue;
                    }
                    if (ccField.getName() == "int") {
                        cField.setInt(null, this.getOptionNumber(sKey));
                        continue;
                    }
                    if (ccField.getName() == "float") {
                        cField.setInt(null, this.getOptionNumber(sKey));
                        continue;
                    }
                    if (ccField.getName() == "double") {
                        cField.setInt(null, this.getOptionNumber(sKey));
                        continue;
                    }
                    if (ccField.getName() != "String") continue;
                    cField.set(null, this.getOption(sKey));
                }
                catch (Exception ex) {
                    this.log(-1, "loadOptions: not possible: %s = %s", sKey, this.options.getProperty(sKey));
                }
            }
        }
    }

    public void loadOptions(String fpOptions) {
        this.log(-1, "loadOptions: not yet implemented", new Object[0]);
    }

    public boolean saveOptions(String fpOptions) {
        this.log(-1, "saveOptions: not yet implemented", new Object[0]);
        return false;
    }

    public boolean saveOptions() {
        this.log(-1, "saveOptions: not yet implemented", new Object[0]);
        return false;
    }

    public boolean isOption(String pName) {
        return this.isOption(pName, false);
    }

    public boolean isOption(String pName, Boolean bDefault) {
        if (this.options == null) {
            return bDefault;
        }
        String pVal = this.options.getProperty(pName, bDefault.toString()).toLowerCase();
        if (pVal.isEmpty()) {
            return bDefault;
        }
        if (pVal.contains("yes") || pVal.contains("true") || pVal.contains("on")) {
            return true;
        }
        return !pVal.contains("no") && !pVal.contains("false") && !pVal.contains("off");
    }

    public String getOption(String pName) {
        if (this.options == null) {
            return "";
        }
        String pVal = this.options.getProperty(pName, "");
        return pVal;
    }

    public String getOption(String pName, String sDefault) {
        if (this.options == null) {
            this.options = new Properties();
            this.options.setProperty(pName, sDefault);
            return sDefault;
        }
        String pVal = this.options.getProperty(pName, sDefault);
        if (pVal.isEmpty()) {
            this.options.setProperty(pName, sDefault);
            return sDefault;
        }
        return pVal;
    }

    public void setOption(String pName, String sValue) {
        if (this.options == null) {
            this.options = new Properties();
        }
        this.options.setProperty(pName, sValue);
    }

    public int getOptionNumber(String pName) {
        if (this.options == null) {
            return 0;
        }
        String pVal = this.options.getProperty(pName, "0");
        int nVal = 0;
        try {
            nVal = Integer.decode(pVal);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return nVal;
    }

    public int getOptionNumber(String pName, Integer nDefault) {
        if (this.options == null) {
            return nDefault;
        }
        String pVal = this.options.getProperty(pName, nDefault.toString());
        int nVal = nDefault;
        try {
            nVal = Integer.decode(pVal);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return nVal;
    }

    public Map<String, String> getOptions() {
        HashMap<String, String> mapOptions = new HashMap<String, String>();
        if (this.options != null) {
            Enumeration<?> optionNames = this.options.propertyNames();
            while (optionNames.hasMoreElements()) {
                String optionName = (String)optionNames.nextElement();
                mapOptions.put(optionName, this.getOption(optionName));
            }
        }
        return mapOptions;
    }

    public boolean hasOptions() {
        return this.options != null && this.options.size() > 0;
    }

    public void dumpOptions() {
        if (this.hasOptions()) {
            this.logp("*** options dump:\n%s", this.fOptions == null ? "" : this.fOptions);
            for (String sOpt : this.getOptions().keySet()) {
                this.logp("%s = %s", sOpt, this.getOption(sOpt));
            }
            this.logp("*** options dump end", new Object[0]);
        }
    }

    private void initSikulixOptions() {
        this.SikuliRepo = null;
        Properties prop = new Properties();
        String svf = "sikulixversion.txt";
        try {
            InputStream is = this.clsRef.getClassLoader().getResourceAsStream("Settings/" + svf);
            if (is == null) {
                this.terminate(1, "initSikulixOptions: not found on classpath: %s", "Settings/" + svf);
            }
            prop.load(is);
            is.close();
            String svt = prop.getProperty("sikulixdev");
            this.SikuliVersionMajor = Integer.decode(prop.getProperty("sikulixvmaj"));
            this.SikuliVersionMinor = Integer.decode(prop.getProperty("sikulixvmin"));
            this.SikuliVersionSub = Integer.decode(prop.getProperty("sikulixvsub"));
            this.SikuliVersionBetaN = Integer.decode(prop.getProperty("sikulixbeta"));
            String ssxbeta = "";
            if (this.SikuliVersionBetaN > 0) {
                ssxbeta = String.format("-Beta%d", this.SikuliVersionBetaN);
            }
            this.SikuliVersionBuild = prop.getProperty("sikulixbuild");
            this.log(this.lvl + 1, "%s version from %s: %d.%d.%d%s build: %s", svf, this.SikuliVersionMajor, this.SikuliVersionMinor, this.SikuliVersionSub, ssxbeta, this.SikuliVersionBuild, svt);
            this.sversion = String.format("%d.%d.%d", this.SikuliVersionMajor, this.SikuliVersionMinor, this.SikuliVersionSub);
            this.bversion = String.format("%d.%d.%d-Beta%d", this.SikuliVersionMajor, this.SikuliVersionMinor, this.SikuliVersionSub, this.SikuliVersionBetaN);
            this.SikuliVersionDefault = "SikuliX " + this.sversion;
            this.SikuliVersionBeta = "Sikuli " + this.bversion;
            this.SikuliVersionDefaultIDE = "SikulixIDE " + this.sversion;
            this.SikuliVersionBetaIDE = "SikulixIDE " + this.bversion;
            this.SikuliVersionDefaultScript = "SikulixScript " + this.sversion;
            this.SikuliVersionBetaScript = "SikulixScript " + this.bversion;
            if ("release".equals(svt)) {
                this.downloadBaseDirBase = "https://launchpad.net/raiman/sikulix2013+/";
                this.downloadBaseDirWeb = this.downloadBaseDirBase + this.getVersionShortBasic() + ".0";
                this.downloadBaseDir = this.downloadBaseDirWeb + "/+download/";
                this.SikuliVersionType = "";
                this.SikuliVersionTypeText = "";
            } else {
                this.downloadBaseDirBase = "http://nightly.sikuli.de/";
                this.downloadBaseDirWeb = "http://nightly.sikuli.de/";
                this.downloadBaseDir = "http://nightly.sikuli.de/";
                this.SikuliVersionTypeText = "nightly";
                this.SikuliVersionBuild = this.SikuliVersionBuild + this.SikuliVersionTypeText;
                this.SikuliVersionType = svt;
            }
            if (this.SikuliVersionBetaN > 0) {
                this.SikuliVersion = this.SikuliVersionBeta;
                this.SikuliVersionIDE = this.SikuliVersionBetaIDE;
                this.SikuliVersionScript = this.SikuliVersionBetaScript;
                this.SikuliVersionLong = this.bversion + "(" + this.SikuliVersionBuild + ")";
            } else {
                this.SikuliVersion = this.SikuliVersionDefault;
                this.SikuliVersionIDE = this.SikuliVersionDefaultIDE;
                this.SikuliVersionScript = this.SikuliVersionDefaultScript;
                this.SikuliVersionLong = this.sversion + "(" + this.SikuliVersionBuild + ")";
            }
            this.SikuliProjectVersionUsed = prop.getProperty("sikulixvused");
            this.SikuliProjectVersion = prop.getProperty("sikulixvproject");
            String osn = "UnKnown";
            String os = System.getProperty("os.name").toLowerCase();
            if (os.startsWith("mac")) {
                osn = "Mac";
            } else if (os.startsWith("windows")) {
                osn = "Windows";
            } else if (os.startsWith("linux")) {
                osn = "Linux";
            }
            this.SikuliLocalRepo = FileManager.slashify(prop.getProperty("sikulixlocalrepo"), true);
            this.SikuliJythonVersion = prop.getProperty("sikulixvjython");
            this.SikuliJythonMaven = "org/python/jython-standalone/" + this.SikuliJythonVersion + "/jython-standalone-" + this.SikuliJythonVersion + ".jar";
            this.SikuliJythonMaven25 = "org/python/jython-standalone/" + this.SikuliJythonVersion25 + "/jython-standalone-" + this.SikuliJythonVersion25 + ".jar";
            this.SikuliJython = this.SikuliLocalRepo + this.SikuliJythonMaven;
            this.SikuliJython25 = this.SikuliLocalRepo + this.SikuliJythonMaven25;
            this.SikuliJRubyVersion = prop.getProperty("sikulixvjruby");
            this.SikuliJRubyMaven = "org/jruby/jruby-complete/" + this.SikuliJRubyVersion + "/jruby-complete-" + this.SikuliJRubyVersion + ".jar";
            this.SikuliJRuby = this.SikuliLocalRepo + this.SikuliJRubyMaven;
            this.SikuliSystemVersion = osn + System.getProperty("os.version");
            this.SikuliJavaVersion = "Java" + this.javaVersion + "(" + this.javaArch + ")" + this.jreVersion;
        }
        catch (Exception e) {
            Debug.error("Settings: load version file %s did not work", svf);
            Sikulix.terminate(999);
        }
        this.tessData.put("eng", "http://tesseract-ocr.googlecode.com/files/tesseract-ocr-3.02.eng.tar.gz");
        Env.setSikuliVersion(this.SikuliVersion);
    }

    protected List<String> extractTessData(File folder) {
        List<String> files = new ArrayList<String>();
        String tessdata = "/sikulixtessdata";
        URL uContentList = this.clsRef.getResource(tessdata + "/" + this.fpContent);
        if (uContentList != null) {
            if ((files = this.doResourceListWithList(tessdata, files, null)).size() > 0) {
                files = this.doExtractToFolderWithList(tessdata, folder, files);
            }
        } else {
            files = this.extractResourcesToFolder("/sikulixtessdata", folder, null);
        }
        return files.size() == 0 ? null : files;
    }

    public List<String> extractResourcesToFolder(String fpRessources, File fFolder, FilenameFilter filter) {
        List<String> content = null;
        content = this.resourceList(fpRessources, filter);
        if (content == null) {
            return null;
        }
        if (fFolder == null) {
            return content;
        }
        return this.doExtractToFolderWithList(fpRessources, fFolder, content);
    }

    private List<String> doExtractToFolderWithList(String fpRessources, File fFolder, List<String> content) {
        int count = 0;
        int ecount = 0;
        String subFolder = "";
        if (content != null && content.size() > 0) {
            for (String eFile : content) {
                if (eFile == null) continue;
                if (eFile.endsWith("/")) {
                    subFolder = eFile.substring(0, eFile.length() - 1);
                    continue;
                }
                if (!subFolder.isEmpty()) {
                    eFile = new File(subFolder, eFile).getPath();
                }
                if (this.extractResourceToFile(fpRessources, eFile, fFolder)) {
                    this.log(this.lvl + 1, "extractResourceToFile done: %s", eFile);
                    ++count;
                    continue;
                }
                ++ecount;
            }
        }
        if (ecount > 0) {
            this.log(this.lvl, "files exported: %d - skipped: %d from %s to:\n %s", count, ecount, fpRessources, fFolder);
        } else {
            this.log(this.lvl, "files exported: %d from: %s to:\n %s", count, fpRessources, fFolder);
        }
        return content;
    }

    public List<String> extractResourcesToFolderFromJar(String aJar, String fpRessources, File fFolder, FilenameFilter filter) {
        List<String> content = new ArrayList<String>();
        File faJar = new File(aJar);
        URL uaJar = null;
        fpRessources = FileManager.slashify(fpRessources, false);
        if (faJar.isAbsolute()) {
            if (!faJar.exists()) {
                this.log(-1, "extractResourcesToFolderFromJar: does not exist:\n%s", faJar);
                return null;
            }
            try {
                uaJar = new URL("jar", null, "file:" + aJar);
                this.logp("%s", uaJar);
            }
            catch (MalformedURLException ex) {
                this.log(-1, "extractResourcesToFolderFromJar: bad URL for:\n%s", faJar);
                return null;
            }
        }
        uaJar = this.fromClasspath(aJar);
        if (uaJar == null) {
            this.log(-1, "extractResourcesToFolderFromJar: not on classpath: %s", aJar);
            return null;
        }
        try {
            String sJar = "file:" + uaJar.getPath() + "!/";
            uaJar = new URL("jar", null, sJar);
        }
        catch (MalformedURLException ex) {
            this.log(-1, "extractResourcesToFolderFromJar: bad URL for:\n%s", uaJar);
            return null;
        }
        content = this.doResourceListJar(uaJar, fpRessources, content, filter);
        if (fFolder == null) {
            return content;
        }
        this.copyFromJarToFolderWithList(uaJar, fpRessources, content, fFolder);
        return content;
    }

    public boolean extractResourceToFile(String inPrefix, String inFile, File outDir) {
        return this.extractResourceToFile(inPrefix, inFile, outDir, "");
    }

    public boolean extractResourceToFile(String inPrefix, String inFile, File outDir, String outFile) {
        String content = inPrefix + "/" + inFile;
        try {
            File out;
            InputStream aIS;
            String string = content = this.runningWindows ? content.replace("\\", "/") : content;
            if (!content.startsWith("/")) {
                content = "/" + content;
            }
            if ((aIS = this.clsRef.getResourceAsStream(content)) == null) {
                throw new IOException("resource not accessible");
            }
            File file = out = outFile.isEmpty() ? new File(outDir, inFile) : new File(outDir, inFile);
            if (!out.getParentFile().exists()) {
                out.getParentFile().mkdirs();
            }
            FileOutputStream aFileOS = new FileOutputStream(out);
            this.copy(aIS, aFileOS);
            aIS.close();
            aFileOS.close();
        }
        catch (Exception ex) {
            this.log(-1, "extractResourceToFile: %s\n%s", content, ex);
            return false;
        }
        return true;
    }

    public String extractResourceToString(String inPrefix, String inFile, String encoding) {
        InputStream aIS = null;
        String out = null;
        String content = inPrefix + "/" + inFile;
        if (!content.startsWith("/")) {
            content = "/" + content;
        }
        try {
            content = this.runningWindows ? content.replace("\\", "/") : content;
            aIS = this.clsRef.getResourceAsStream(content);
            if (aIS == null) {
                throw new IOException("resource not accessible");
            }
            if (encoding == null) {
                encoding = "RAW-BYTE";
                out = new String(this.copy(aIS));
            } else {
                out = encoding.isEmpty() ? new String(this.copy(aIS), "UTF-8") : new String(this.copy(aIS), encoding);
            }
            aIS.close();
            aIS = null;
        }
        catch (Exception ex) {
            this.log(-1, "extractResourceToString as %s from:\n%s\n%s", encoding, content, ex);
        }
        try {
            if (aIS != null) {
                aIS.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return out;
    }

    public URL resourceLocation(String folderOrFile) {
        this.log(this.lvl, "resourceLocation: (%s) %s", this.clsRef, folderOrFile);
        if (!folderOrFile.startsWith("/")) {
            folderOrFile = "/" + folderOrFile;
        }
        return this.clsRef.getResource(folderOrFile);
    }

    private List<String> resourceList(String folder, FilenameFilter filter) {
        URL uFolder;
        this.log(this.lvl, "resourceList: enter", new Object[0]);
        List<String> files = new ArrayList<String>();
        if (!folder.startsWith("/")) {
            folder = "/" + folder;
        }
        if ((uFolder = this.resourceLocation(folder)) == null) {
            this.log(this.lvl, "resourceList: not found: %s", folder);
            return files;
        }
        try {
            uFolder = new URL(uFolder.toExternalForm().replaceAll(" ", "%20"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        URL uContentList = this.clsRef.getResource(folder + "/" + this.fpContent);
        if (uContentList != null) {
            return this.doResourceListWithList(folder, files, filter);
        }
        File fFolder = null;
        try {
            fFolder = new File(uFolder.toURI());
            this.log(this.lvl, "resourceList: having folder: %s", fFolder);
            String sFolder = FileManager.normalizeAbsolute(fFolder.getPath(), false);
            if (":".equals(sFolder.substring(2, 3))) {
                sFolder = sFolder.substring(1);
            }
            files.add(sFolder);
            files = this.doResourceListFolder(new File(sFolder), files, filter);
            files.remove(0);
            return files;
        }
        catch (Exception ex) {
            if (!"jar".equals(uFolder.getProtocol())) {
                this.log(this.lvl, "resourceList:\n%s", folder);
                this.log(-1, "resourceList: URL neither folder nor jar:\n%s", ex);
                return null;
            }
            String[] parts = uFolder.getPath().split("!");
            if (parts.length < 2 || !parts[0].startsWith("file:")) {
                this.log(this.lvl, "resourceList:\n%s", folder);
                this.log(-1, "resourceList: not a valid jar URL: " + uFolder.getPath(), new Object[0]);
                return null;
            }
            String fpFolder = parts[1];
            this.log(this.lvl, "resourceList: having jar: %s", uFolder);
            return this.doResourceListJar(uFolder, fpFolder, files, filter);
        }
    }

    public String[] resourceListAsFile(String folder, File target, FilenameFilter filter) {
        String content = this.resourceListAsString(folder, filter);
        if (content == null) {
            this.log(-1, "resourceListAsFile: did not work: %s", folder);
            return null;
        }
        if (target != null) {
            try {
                FileManager.deleteFileOrFolder(target.getAbsolutePath());
                target.getParentFile().mkdirs();
                PrintWriter aPW = new PrintWriter(target);
                aPW.write(content);
                aPW.close();
            }
            catch (Exception ex) {
                this.log(-1, "resourceListAsFile: %s:\n%s", target, ex);
            }
        }
        return content.split(System.getProperty("line.separator"));
    }

    public String[] resourceListAsSikulixContent(String folder, File targetFolder, FilenameFilter filter) {
        List<String> contentList = this.resourceList(folder, filter);
        if (contentList == null) {
            this.log(-1, "resourceListAsSikulixContent: did not work: %s", folder);
            return null;
        }
        File target = null;
        String[] arrString = new String[contentList.size()];
        try {
            PrintWriter aPW = null;
            if (targetFolder != null) {
                target = new File(targetFolder, this.fpContent);
                FileManager.deleteFileOrFolder(target);
                target.getParentFile().mkdirs();
                aPW = new PrintWriter(target);
            }
            int n = 0;
            for (String line : contentList) {
                arrString[n++] = line;
                if (targetFolder == null) continue;
                aPW.println(line);
            }
            if (targetFolder != null) {
                aPW.close();
            }
        }
        catch (Exception ex) {
            this.log(-1, "resourceListAsFile: %s:\n%s", target, ex);
        }
        return arrString;
    }

    public String[] resourceListAsSikulixContentFromJar(String aJar, String folder, File targetFolder, FilenameFilter filter) {
        List<String> contentList = this.extractResourcesToFolderFromJar(aJar, folder, null, filter);
        if (contentList == null || contentList.size() == 0) {
            this.log(-1, "resourceListAsSikulixContentFromJar: did not work: %s", folder);
            return null;
        }
        File target = null;
        String[] arrString = new String[contentList.size()];
        try {
            PrintWriter aPW = null;
            if (targetFolder != null) {
                target = new File(targetFolder, this.fpContent);
                FileManager.deleteFileOrFolder(target);
                target.getParentFile().mkdirs();
                aPW = new PrintWriter(target);
            }
            int n = 0;
            for (String line : contentList) {
                arrString[n++] = line;
                if (targetFolder == null) continue;
                aPW.println(line);
            }
            if (targetFolder != null) {
                aPW.close();
            }
        }
        catch (Exception ex) {
            this.log(-1, "resourceListAsFile: %s:\n%s", target, ex);
        }
        return arrString;
    }

    public String resourceListAsString(String folder, FilenameFilter filter) {
        return this.resourceListAsString(folder, filter, null);
    }

    public String resourceListAsString(String folder, FilenameFilter filter, String separator) {
        List<String> aList = this.resourceList(folder, filter);
        if (aList == null) {
            return null;
        }
        if (separator == null) {
            separator = System.getProperty("line.separator");
        }
        String out = "";
        String subFolder = "";
        if (aList != null && aList.size() > 0) {
            for (String eFile : aList) {
                if (eFile == null) continue;
                if (eFile.endsWith("/")) {
                    subFolder = eFile.substring(0, eFile.length() - 1);
                    continue;
                }
                if (!subFolder.isEmpty()) {
                    eFile = new File(subFolder, eFile).getPath();
                }
                out = out + eFile.replace("\\", "/") + separator;
            }
        }
        return out;
    }

    private List<String> doResourceListFolder(File fFolder, List<String> files, FilenameFilter filter) {
        int localLevel = testing ? this.lvl : this.lvl + 1;
        String subFolder = "";
        if (fFolder.isDirectory()) {
            String[] subList;
            if (!FileManager.pathEquals(fFolder.getPath(), files.get(0))) {
                subFolder = fFolder.getPath().substring(files.get(0).length() + 1).replace("\\", "/") + "/";
                if (filter != null && !filter.accept(new File(files.get(0), subFolder), "")) {
                    return files;
                }
            } else {
                this.logp(localLevel, "scanning folder:\n%s", fFolder);
                subFolder = "/";
                files.add(subFolder);
            }
            for (String entry : subList = fFolder.list()) {
                File fEntry = new File(fFolder, entry);
                if (fEntry.isDirectory()) {
                    files.add(fEntry.getAbsolutePath().substring(1 + files.get(0).length()).replace("\\", "/") + "/");
                    this.doResourceListFolder(fEntry, files, filter);
                    files.add(subFolder);
                    continue;
                }
                if (filter != null && !filter.accept(fFolder, entry)) continue;
                this.logp(localLevel, "from %s adding: %s", subFolder.isEmpty() ? "." : subFolder, entry);
                files.add(fEntry.getAbsolutePath().substring(1 + fFolder.getPath().length()));
            }
        }
        return files;
    }

    private List<String> doResourceListWithList(String folder, List<String> files, FilenameFilter filter) {
        String content;
        String[] contentList = content.split((content = this.extractResourceToString(folder, this.fpContent, "")).indexOf("\r") != -1 ? "\r\n" : "\n");
        if (filter == null) {
            files.addAll(Arrays.asList(contentList));
        } else {
            for (String fpFile : contentList) {
                if (!filter.accept(new File(fpFile), "")) continue;
                files.add(fpFile);
            }
        }
        return files;
    }

    private List<String> doResourceListJar(URL uJar, String fpResource, List<String> files, FilenameFilter filter) {
        String fpJar = uJar.getPath().split("!")[0];
        int localLevel = testing ? this.lvl : this.lvl + 1;
        String fileSep = "/";
        if (!fpJar.endsWith(".jar")) {
            return files;
        }
        this.logp(localLevel, "scanning jar:\n%s", uJar);
        fpResource = fpResource.startsWith("/") ? fpResource.substring(1) : fpResource;
        File fFolder = new File(fpResource);
        File fSubFolder = null;
        String subFolder = "";
        boolean skip = false;
        try {
            ZipEntry zEntry;
            ZipInputStream zJar = new ZipInputStream(new URL(fpJar).openStream());
            while ((zEntry = zJar.getNextEntry()) != null) {
                String zePath;
                if (zEntry.getName().endsWith("/") || !(zePath = zEntry.getName()).startsWith(fpResource)) continue;
                if (fpResource.length() == zePath.length()) {
                    files.add(zePath);
                    return files;
                }
                String zeName = zePath.substring(fpResource.length() + 1);
                int nSep = zeName.lastIndexOf(fileSep);
                String zefName = zeName.substring(nSep + 1, zeName.length());
                String zeSub = "";
                if (nSep > -1) {
                    zeSub = zeName.substring(0, nSep + 1);
                    if (!subFolder.equals(zeSub)) {
                        subFolder = zeSub;
                        fSubFolder = new File(fFolder, subFolder);
                        skip = false;
                        if (filter != null && !filter.accept(fSubFolder, "")) {
                            skip = true;
                            continue;
                        }
                        files.add(zeSub);
                    }
                    if (skip) {
                        continue;
                    }
                } else if (!subFolder.isEmpty()) {
                    subFolder = "";
                    fSubFolder = fFolder;
                    files.add("/");
                }
                if (filter != null && !filter.accept(fSubFolder, zefName)) continue;
                files.add(zefName);
                this.logp(localLevel, "from %s adding: %s", zeSub.isEmpty() ? "." : zeSub, zefName);
            }
        }
        catch (Exception ex) {
            this.log(-1, "doResourceListJar: %s", ex);
            return files;
        }
        return files;
    }

    private boolean copyFromJarToFolderWithList(URL uJar, String fpRessource, List<String> files, File fFolder) {
        if (files == null || files.isEmpty()) {
            this.log(this.lvl, "copyFromJarToFolderWithList: list of files is empty", new Object[0]);
            return false;
        }
        String fpJar = uJar.getPath().split("!")[0];
        if (!fpJar.endsWith(".jar")) {
            return false;
        }
        int localLevel = testing ? this.lvl : this.lvl + 1;
        this.logp(localLevel, "scanning jar:\n%s", uJar);
        fpRessource = fpRessource.startsWith("/") ? fpRessource.substring(1) : fpRessource;
        String subFolder = "";
        int maxFiles = files.size() - 1;
        int nFiles = 0;
        int prefix = fpRessource.length();
        fpRessource = fpRessource + (!fpRessource.isEmpty() ? "/" : "");
        String current = "/";
        boolean shouldStop = false;
        try {
            ZipEntry zEntry;
            ZipInputStream zJar = new ZipInputStream(new URL(fpJar).openStream());
            while ((zEntry = zJar.getNextEntry()) != null) {
                String zPath = zEntry.getName();
                if (zPath.endsWith("/")) continue;
                while (current.endsWith("/")) {
                    if (nFiles > maxFiles) {
                        shouldStop = true;
                        break;
                    }
                    String string = subFolder = current.length() == 1 ? "" : current;
                    if ((current = files.get(nFiles++)).endsWith("/")) continue;
                    current = fpRessource + subFolder + current;
                    break;
                }
                if (shouldStop) break;
                if (!zPath.startsWith(current)) continue;
                if (zPath.length() == fpRessource.length() - 1) {
                    this.log(-1, "extractResourcesToFolderFromJar: only ressource folders allowed - use filter", new Object[0]);
                    return false;
                }
                this.logp(localLevel, "copying: %s", zPath);
                File out = new File(fFolder, zPath.substring(prefix));
                if (!out.getParentFile().exists()) {
                    out.getParentFile().mkdirs();
                }
                FileOutputStream aFileOS = new FileOutputStream(out);
                this.copy(zJar, aFileOS);
                aFileOS.close();
                if (nFiles > maxFiles) break;
                if ((current = files.get(nFiles++)).endsWith("/")) continue;
                current = fpRessource + subFolder + current;
            }
            zJar.close();
        }
        catch (Exception ex) {
            this.log(-1, "doResourceListJar: %s", ex);
            return false;
        }
        return true;
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] tmp = new byte[8192];
        while ((len = in.read(tmp)) > 0) {
            out.write(tmp, 0, len);
        }
        out.flush();
    }

    private byte[] copy(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return baos.toByteArray();
    }

    private void storeClassPath() {
        URLClassLoader sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        this.classPath = Arrays.asList(sysLoader.getURLs());
    }

    public void dumpClassPath() {
        this.dumpClassPath(null);
    }

    public void dumpClassPath(String filter) {
        filter = filter == null ? "" : filter;
        this.logp("*** classpath dump %s", filter);
        this.storeClassPath();
        filter = filter.toUpperCase();
        int n = 0;
        for (URL uEntry : this.classPath) {
            String sEntry = uEntry.getPath();
            if (!filter.isEmpty() && !sEntry.toUpperCase().contains(filter)) {
                ++n;
                continue;
            }
            this.logp("%3d: %s", n, sEntry);
            ++n;
        }
        this.logp("*** classpath dump end", new Object[0]);
    }

    private String isOnClasspath(String artefact, boolean isJar) {
        artefact = FileManager.slashify(artefact, false);
        String cpe = null;
        if (this.classPath.isEmpty()) {
            this.storeClassPath();
        }
        for (URL entry : this.classPath) {
            String sEntry = FileManager.slashify(new File(entry.getPath()).getPath(), false);
            if (!sEntry.contains(artefact) || isJar && (!sEntry.endsWith(".jar") || !new File(sEntry).getName().contains(artefact) || new File(sEntry).getName().contains("4" + artefact))) continue;
            cpe = new File(entry.getPath()).getPath();
            break;
        }
        return cpe;
    }

    public String isJarOnClasspath(String artefact) {
        return this.isOnClasspath(artefact, true);
    }

    public String isOnClasspath(String artefact) {
        return this.isOnClasspath(artefact, false);
    }

    public URL fromClasspath(String artefact) {
        artefact = FileManager.slashify(artefact, false).toUpperCase();
        URL cpe = null;
        if (this.classPath.isEmpty()) {
            this.storeClassPath();
        }
        for (URL entry : this.classPath) {
            String sEntry = FileManager.slashify(new File(entry.getPath()).getPath(), false);
            if (!sEntry.toUpperCase().contains(artefact)) continue;
            return entry;
        }
        return cpe;
    }

    public boolean isOnClasspath(URL path) {
        if (this.classPath.isEmpty()) {
            this.storeClassPath();
        }
        for (URL entry : this.classPath) {
            if (!new File(path.getPath()).equals(new File(entry.getPath()))) continue;
            return true;
        }
        return false;
    }

    public boolean addToClasspath(String jarOrFolder) {
        URL uJarOrFolder = FileManager.makeURL(jarOrFolder);
        if (!new File(jarOrFolder).exists()) {
            this.log(-1, "addToClasspath: does not exist - not added:\n%s", jarOrFolder);
            return false;
        }
        if (this.isOnClasspath(uJarOrFolder)) {
            return true;
        }
        this.log(this.lvl, "addToClasspath:\n%s", uJarOrFolder);
        URLClassLoader sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysLoader, uJarOrFolder);
        }
        catch (Exception ex) {
            this.log(-1, "Did not work: %s", ex.getMessage());
            return false;
        }
        this.storeClassPath();
        return true;
    }

    public File asExtension(String fpJar) {
        File fJarFound = new File(FileManager.normalizeAbsolute(fpJar, false));
        if (!fJarFound.exists()) {
            String fpCPEntry = runTime.isOnClasspath(fJarFound.getName());
            if (fpCPEntry == null) {
                fJarFound = new File(RunTime.runTime.fSikulixExtensions, fpJar);
                if (!fJarFound.exists() && !(fJarFound = new File(RunTime.runTime.fSikulixLib, fpJar)).exists()) {
                    fJarFound = null;
                }
            } else {
                fJarFound = new File(fpCPEntry, fJarFound.getName());
            }
        } else {
            return null;
        }
        return fJarFound;
    }

    public void dumpSysProps() {
        this.dumpSysProps(null);
    }

    public void dumpSysProps(String filter) {
        filter = filter == null ? "" : filter;
        this.logp("*** system properties dump " + filter, new Object[0]);
        Properties sysProps = System.getProperties();
        ArrayList<String> keysProp = new ArrayList<String>();
        Integer nL = 0;
        for (Object e : sysProps.keySet()) {
            String entry = (String)e;
            if (entry.length() > nL) {
                nL = entry.length();
            }
            if (!filter.isEmpty() && (filter.isEmpty() || !entry.contains(filter))) continue;
            keysProp.add(entry);
        }
        Collections.sort(keysProp);
        String form = "%-" + nL.toString() + "s = %s";
        for (Object e : keysProp) {
            this.logp(form, e, sysProps.get(e));
        }
        this.logp("*** system properties dump end" + filter, new Object[0]);
    }

    public boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    public boolean isMultiMonitor() {
        return this.nMonitors > 1;
    }

    public Rectangle getMonitor(int n) {
        if (this.isHeadless()) {
            return new Rectangle(0, 0, 1, 1);
        }
        n = n < 0 || n >= this.nMonitors ? this.mainMonitor : n;
        return this.monitorBounds[n];
    }

    public Rectangle getAllMonitors() {
        if (this.isHeadless()) {
            return new Rectangle(0, 0, 1, 1);
        }
        return this.rAllMonitors;
    }

    public Rectangle hasPoint(Point aPoint) {
        if (this.isHeadless()) {
            return new Rectangle(0, 0, 1, 1);
        }
        for (Rectangle rMon : this.monitorBounds) {
            if (!rMon.contains(aPoint)) continue;
            return rMon;
        }
        return null;
    }

    public Rectangle hasRectangle(Rectangle aRect) {
        if (this.isHeadless()) {
            return new Rectangle(0, 0, 1, 1);
        }
        return this.hasPoint(aRect.getLocation());
    }

    public GraphicsDevice getGraphicsDevice(int id) {
        return this.gdevs[id];
    }

    public String runcmd(String cmd) {
        return this.runcmd(new String[]{cmd});
    }

    public String runcmd(String[] args) {
        int retVal;
        if (args.length == 0) {
            return "";
        }
        boolean silent = false;
        if (args.length == 1) {
            String separator = "\"";
            ArrayList<String> argsx = new ArrayList<String>();
            String cmd = args[0];
            if (Settings.isWindows()) {
                cmd = cmd.replaceAll("\\\\ ", "%20;");
            }
            StringTokenizer toks = new StringTokenizer(cmd);
            while (toks.hasMoreTokens()) {
                String tok = toks.nextToken(" ");
                if (tok.length() == 0 || separator.equals(tok)) continue;
                if (tok.startsWith(separator)) {
                    if (tok.endsWith(separator)) {
                        tok = tok.substring(1, tok.length() - 1);
                    } else {
                        tok = tok.substring(1);
                        tok = tok + toks.nextToken(separator);
                    }
                }
                argsx.add(tok.replaceAll("%20;", " "));
            }
            args = argsx.toArray(new String[0]);
        }
        if (args[0].startsWith("!")) {
            silent = true;
            args[0] = args[0].substring(1);
        }
        if (args[0].startsWith("#")) {
            String pgm = args[0].substring(1);
            args[0] = new File(pgm).getAbsolutePath();
            this.runcmd(new String[]{"chmod", "ugo+x", args[0]});
        }
        String result = "";
        String error = runCmdError + NL;
        boolean hasError = false;
        try {
            String s;
            if (!silent) {
                if (this.lvl <= Debug.getDebugLevel()) {
                    this.log(this.lvl, Sikulix.arrayToString(args), new Object[0]);
                } else {
                    Debug.info("runcmd: " + Sikulix.arrayToString(args), new Object[0]);
                }
            }
            Process process = Runtime.getRuntime().exec(args);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((s = stdInput.readLine()) != null) {
                if (s.isEmpty()) continue;
                result = result + s + NL;
            }
            s = stdError.readLine();
            if (s != null) {
                hasError = true;
                if (!s.isEmpty()) {
                    error = error + s + NL;
                }
            }
            process.waitFor();
            retVal = process.exitValue();
            process.destroy();
        }
        catch (Exception e) {
            this.log(-1, "fatal error: " + e, new Object[0]);
            result = String.format(error + "%s", e);
            retVal = 9999;
            hasError = true;
        }
        if (hasError) {
            result = result + error;
        }
        this.lastResult = result;
        return String.format("%d%s%s", retVal, NL, result);
    }

    public String getLastCommandResult() {
        return this.lastResult;
    }

    public void setArgs(String[] args, String[] sargs) {
        this.args = args;
        this.sargs = sargs;
    }

    public String[] getSikuliArgs() {
        return this.sargs;
    }

    public String[] getArgs() {
        return this.args;
    }

    public void printArgs() {
        int i;
        if (Debug.getDebugLevel() < this.lvl) {
            return;
        }
        String[] xargs = this.getSikuliArgs();
        if (xargs.length > 0) {
            Debug.log(this.lvl, "--- Sikuli parameters ---", new Object[0]);
            for (i = 0; i < xargs.length; ++i) {
                Debug.log(this.lvl, "%d: %s", i + 1, xargs[i]);
            }
        }
        if ((xargs = this.getArgs()).length > 0) {
            Debug.log(this.lvl, "--- User parameters ---", new Object[0]);
            for (i = 0; i < xargs.length; ++i) {
                Debug.log(this.lvl, "%d: %s", i + 1, xargs[i]);
            }
        }
    }

    public static int checkArgs(String[] args, Type typ) {
        int debugLevel = -99;
        boolean runningScripts = false;
        ArrayList<String> options = new ArrayList<String>();
        options.addAll(Arrays.asList(args));
        for (int n = 0; n < options.size(); ++n) {
            String opt = (String)options.get(n);
            if ("nodebug".equals(opt)) {
                return -2;
            }
            if (Type.IDE.equals((Object)typ) && "-s".equals(opt.toLowerCase())) {
                return -3;
            }
            if (!opt.startsWith("-")) continue;
            if (opt.startsWith("-d")) {
                debugLevel = -1;
                try {
                    debugLevel = n + 1 == options.size() ? -1 : Integer.decode((String)options.get(n + 1));
                }
                catch (Exception ex) {
                    debugLevel = -1;
                }
                if (debugLevel <= -1) continue;
                Debug.on(debugLevel);
                continue;
            }
            if (!opt.startsWith("-r") && !opt.startsWith("-t") && !opt.startsWith("-s") && !opt.startsWith("-i")) continue;
            runningScripts = true;
        }
        if (runningScripts) {
            return 999;
        }
        return debugLevel;
    }

    static {
        testing = false;
        testingWinApp = false;
    }

    public class oneFileFilter
    implements FilenameFilter {
        String aFile;

        public oneFileFilter(String aFileGiven) {
            this.aFile = aFileGiven;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.contains(this.aFile);
        }
    }

    class LibsFilter
    implements FilenameFilter {
        String sAccept = "";

        public LibsFilter(String toAccept) {
            this.sAccept = toAccept;
        }

        @Override
        public boolean accept(File dir, String name) {
            return dir.getPath().contains(this.sAccept);
        }
    }

    private static enum theSystem {
        WIN,
        MAC,
        LUX,
        FOO;

    }

    public static enum Type {
        IDE,
        API,
        SETUP,
        INIT;

    }
}

