/*
 * Decompiled with CFR 0.152.
 */
package jxgrabkey;

import java.awt.event.KeyEvent;
import java.util.Vector;
import jxgrabkey.HotkeyConflictException;
import jxgrabkey.HotkeyListener;
import jxgrabkey.HotkeyListenerDebugEnabled;
import jxgrabkey.X11KeysymDefinitions;
import jxgrabkey.X11MaskDefinitions;

public class JXGrabKey {
    private static final int SLEEP_WHILE_LISTEN_EXITS = 100;
    private static boolean debug;
    private static JXGrabKey instance;
    private static Thread thread;
    private static Vector<HotkeyListener> listeners;

    private JXGrabKey() {
        thread = new Thread(){

            public void run() {
                JXGrabKey.this.listen();
                JXGrabKey.debugCallback("-- listen()");
            }
        };
        thread.start();
    }

    public static synchronized JXGrabKey getInstance() {
        if (instance == null) {
            instance = new JXGrabKey();
        }
        return instance;
    }

    public synchronized void addHotkeyListener(HotkeyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        listeners.add(listener);
    }

    public synchronized void removeHotkeyListener(HotkeyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        listeners.remove(listener);
    }

    public synchronized void cleanUp() {
        this.clean();
        if (thread.isAlive()) {
            while (thread.isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    JXGrabKey.debugCallback("cleanUp() - InterruptedException: " + e.getMessage());
                }
            }
            instance = null;
        }
        if (listeners.size() > 0) {
            listeners.clear();
        }
    }

    public synchronized void registerX11Hotkey(int id, int x11Mask, int x11Keysym) throws HotkeyConflictException {
        this.registerHotkey(id, x11Mask, x11Keysym);
    }

    public synchronized void registerAwtHotkey(int id, int awtMask, int awtKey) throws HotkeyConflictException {
        JXGrabKey.debugCallback("++ registerAwtHotkey(" + id + ", 0x" + Integer.toHexString(awtMask) + ", 0x" + Integer.toHexString(awtKey) + ")");
        int x11Mask = X11MaskDefinitions.awtMaskToX11Mask(awtMask);
        int x11Keysym = X11KeysymDefinitions.awtKeyToX11Keysym(awtKey);
        JXGrabKey.debugCallback("registerAwtHotkey() - converted AWT mask '" + KeyEvent.getKeyModifiersText(awtMask) + "' (0x" + Integer.toHexString(awtMask) + ") to X11 mask (0x" + Integer.toHexString(x11Mask) + ")");
        JXGrabKey.debugCallback("registerAwtHotkey() - converted AWT key '" + KeyEvent.getKeyText(awtKey) + "' (0x" + Integer.toHexString(awtKey) + ") to X11 keysym (0x" + Integer.toHexString(x11Keysym) + ")");
        this.registerHotkey(id, x11Mask, x11Keysym);
        JXGrabKey.debugCallback("-- registerAwtHotkey()");
    }

    public static synchronized void setDebugOutput(boolean enabled) {
        debug = enabled;
        JXGrabKey.setDebug(enabled);
    }

    public static synchronized void fireKeyEvent(int id) {
        for (int i = 0; i < listeners.size(); ++i) {
            listeners.get(i).onHotkey(id);
        }
    }

    public static void debugCallback(String debugmessage) {
        if (debug) {
            debugmessage.trim();
            if (debugmessage.charAt(debugmessage.length() - 1) != '\n') {
                debugmessage = debugmessage + "\n";
            } else {
                while (debugmessage.endsWith("\n\n")) {
                    debugmessage = debugmessage.substring(0, debugmessage.length() - 1);
                }
            }
            boolean found = false;
            for (HotkeyListener l : listeners) {
                if (!(l instanceof HotkeyListenerDebugEnabled)) continue;
                ((HotkeyListenerDebugEnabled)l).debugCallback(debugmessage);
                found = true;
            }
            if (!found) {
                System.out.print(debugmessage);
            }
        }
    }

    public synchronized native void unregisterHotKey(int var1);

    private native void listen();

    private static native void setDebug(boolean var0);

    private native void clean();

    private native void registerHotkey(int var1, int var2, int var3) throws HotkeyConflictException;

    static {
        listeners = new Vector();
    }
}

