# <img src="https://github.com/rubatopy/rubato/blob/main/docs/source/_static/full.png?raw=true" alt="rubato" width="160"/>

[![Lisence](https://img.shields.io/github/license/rubatopy/rubato?style=flat-square)](https://www.gnu.org/licenses/gpl-3.0.html)
[![PyPI](https://img.shields.io/pypi/v/rubato?style=flat-square)](https://pypi.org/project/rubato/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/rubato?style=flat-square)](https://pypi.org/project/rubato/)
[![GitHub Release Date](https://img.shields.io/github/release-date/rubatopy/rubato?style=flat-square)](https://github.com/rubatopy/rubato/releases)
[![GitHub Build Status](https://img.shields.io/github/workflow/status/rubatopy/rubato/Build?style=flat-square)](https://github.com/rubatopy/rubato/actions/workflows/build.yml)
[![GitHub Docs Status](https://img.shields.io/github/workflow/status/rubatopy/rubato/Docs?label=docs&style=flat-square)](https://rubatopy.github.io/)
[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white&style=flat-square)](https://github.com/pre-commit/pre-commit)

[<img src="https://logodownload.org/wp-content/uploads/2017/11/discord-logo-4-1.png" alt="Discord Server" width="25" />](https://discord.gg/rdce5GXRrC)
&nbsp;
[<img src="https://cdn4.iconfinder.com/data/icons/social-media-icons-the-circle-set/48/twitter_circle-512.png" alt="Twitter Page" width="25"/>](https://twitter.com/rubatopy)
&nbsp;
[<img src="https://upload.wikimedia.org/wikipedia/commons/thumb/f/f8/LinkedIn_icon_circle.svg/2048px-LinkedIn_icon_circle.svg.png" alt="Linkedin Page" width="25"/>](https://www.linkedin.com/company/rubatopy/)
&nbsp;

rubato is a modern 2D engine for game developement in python. Dynamic physics simulations, robust scene management, event listener system and more all come prepackaged. Built in Cython using SDL2, rubato offers great performance without compromising on the intuitive nature of python code.

As of release 3.0.0, the transition to SDL2 and Cython was completed. DLLs and wheels for the household-name platforms come prebundled, making rubato plug-and-play on most machines. This transition has enabled more complex functionality such as antialiasing and hardware acceleration, as well as a backend of C classes that will be gradually rolled out in later 3.x releases to improve performance. Older versions of rubato, such as PyGame-based 1.2, are now completely deprecated and it is highly recommended for users of those versions to upgrade. If you would like to read more about PySDL2 or need to utilize its underlying functionality in your project, you can read the python wrapper documentation [here](https://pysdl2.readthedocs.io/en/0.9.11/) and the base C++ SDL wiki [here](https://wiki.libsdl.org).

_Wondering about the name? rubato is a music term that indicates a phrase that should be performed expressively and freely. We aim to harness that same freedom, bringing a fresh, modern take on game developement in python to a variety of users regardless of their coding background._

### Get started [here](https://rubato.app/).

A big thank you to all of our [contributors](https://github.com/rubatopy/rubato/blob/main/CONTRIBUTORS.md) who help make this project possible.

#### Changelog

See [CHANGELOG.md](https://github.com/rubatopy/rubato/blob/main/CHANGELOG.md)

#### Looking to contribute to Rubato?

See [CONTRIBUTING.md](https://github.com/rubatopy/rubato/blob/main/CONTRIBUTING.md).

#### Code of Conduct

See [CODE_OF_CONDUCT.md](https://github.com/rubatopy/rubato/blob/main/CODE_OF_CONDUCT.md).

_Credit to [@ArksDigital](https://twitter.com/ArksDigital) for the dino animation used in several of the demos / tutorials. ([itch page](https://arks.itch.io/dino-characters))_
