# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ServerVersionCapability(Model):
    """The server capabilities.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The server version name.
    :vartype name: str
    :ivar status: The status of the server version. Possible values include:
     'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar supported_editions: The list of supported database editions.
    :vartype supported_editions:
     list[~azure.mgmt.sql.models.EditionCapability]
    :ivar supported_elastic_pool_editions: The list of supported elastic pool
     editions.
    :vartype supported_elastic_pool_editions:
     list[~azure.mgmt.sql.models.ElasticPoolEditionCapability]
    """

    _validation = {
        'name': {'readonly': True},
        'status': {'readonly': True},
        'supported_editions': {'readonly': True},
        'supported_elastic_pool_editions': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
        'supported_editions': {'key': 'supportedEditions', 'type': '[EditionCapability]'},
        'supported_elastic_pool_editions': {'key': 'supportedElasticPoolEditions', 'type': '[ElasticPoolEditionCapability]'},
    }

    def __init__(self):
        self.name = None
        self.status = None
        self.supported_editions = None
        self.supported_elastic_pool_editions = None
