# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._monitor_query_client_enums import *


class BatchRequest(msrest.serialization.Model):
    """An array of requests.

    :param requests: An single request in a batch.
    :type requests: list[~monitor_query_client.models.LogQueryRequest]
    """

    _attribute_map = {
        'requests': {'key': 'requests', 'type': '[LogQueryRequest]'},
    }

    def __init__(
        self,
        *,
        requests: Optional[List["LogQueryRequest"]] = None,
        **kwargs
    ):
        super(BatchRequest, self).__init__(**kwargs)
        self.requests = requests


class BatchResponse(msrest.serialization.Model):
    """Response to a batch.

    :param responses: An array of responses corresponding to each individual request in a batch.
    :type responses: list[~monitor_query_client.models.LogQueryResponse]
    :param error: Error response for a batch request.
    :type error: ~monitor_query_client.models.BatchResponseError
    """

    _attribute_map = {
        'responses': {'key': 'responses', 'type': '[LogQueryResponse]'},
        'error': {'key': 'error', 'type': 'BatchResponseError'},
    }

    def __init__(
        self,
        *,
        responses: Optional[List["LogQueryResponse"]] = None,
        error: Optional["BatchResponseError"] = None,
        **kwargs
    ):
        super(BatchResponse, self).__init__(**kwargs)
        self.responses = responses
        self.error = error


class BatchResponseError(msrest.serialization.Model):
    """Error response for a batch request.

    :param message: The error message describing the cause of the error.
    :type message: str
    :param code: The error code.
    :type code: str
    :param inner_error:
    :type inner_error: ~monitor_query_client.models.BatchResponseErrorInnerError
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'code': {'key': 'code', 'type': 'str'},
        'inner_error': {'key': 'innerError', 'type': 'BatchResponseErrorInnerError'},
    }

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        code: Optional[str] = None,
        inner_error: Optional["BatchResponseErrorInnerError"] = None,
        **kwargs
    ):
        super(BatchResponseError, self).__init__(**kwargs)
        self.message = message
        self.code = code
        self.inner_error = inner_error


class BatchResponseErrorInnerError(msrest.serialization.Model):
    """BatchResponseErrorInnerError.

    :param code:
    :type code: str
    :param message:
    :type message: str
    :param details:
    :type details: list[~monitor_query_client.models.ErrorDetails]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetails]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        details: Optional[List["ErrorDetails"]] = None,
        **kwargs
    ):
        super(BatchResponseErrorInnerError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details


class Column(msrest.serialization.Model):
    """A column in a table.

    :param name: The name of this column.
    :type name: str
    :param type: The data type of this column.
    :type type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        super(Column, self).__init__(**kwargs)
        self.name = name
        self.type = type


class ErrorDetail(msrest.serialization.Model):
    """Error details.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. The error's code.
    :type code: str
    :param message: Required. A human readable error message.
    :type message: str
    :param target: Indicates which property in the request is responsible for the error.
    :type target: str
    :param value: Indicates which value in 'target' is responsible for the error.
    :type value: str
    :param resources: Indicates resources which were responsible for the error.
    :type resources: list[str]
    :param additional_properties: Additional properties that can be provided on the error details
     object.
    :type additional_properties: object
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'resources': {'key': 'resources', 'type': '[str]'},
        'additional_properties': {'key': 'additionalProperties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        target: Optional[str] = None,
        value: Optional[str] = None,
        resources: Optional[List[str]] = None,
        additional_properties: Optional[object] = None,
        **kwargs
    ):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.value = value
        self.resources = resources
        self.additional_properties = additional_properties


class ErrorDetails(msrest.serialization.Model):
    """ErrorDetails.

    :param code:
    :type code: str
    :param message:
    :type message: str
    :param target:
    :type target: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        **kwargs
    ):
        super(ErrorDetails, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target


class ErrorInfo(msrest.serialization.Model):
    """The code and message for an error.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. A machine readable error code.
    :type code: str
    :param message: Required. A human readable error message.
    :type message: str
    :param details: error details.
    :type details: list[~monitor_query_client.models.ErrorDetail]
    :param innererror: Inner error details if they exist.
    :type innererror: ~monitor_query_client.models.ErrorInfo
    :param additional_properties: Additional properties that can be provided on the error info
     object.
    :type additional_properties: object
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'innererror': {'key': 'innererror', 'type': 'ErrorInfo'},
        'additional_properties': {'key': 'additionalProperties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        details: Optional[List["ErrorDetail"]] = None,
        innererror: Optional["ErrorInfo"] = None,
        additional_properties: Optional[object] = None,
        **kwargs
    ):
        super(ErrorInfo, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details
        self.innererror = innererror
        self.additional_properties = additional_properties


class ErrorResponse(msrest.serialization.Model):
    """Contains details when the response code indicates an error.

    All required parameters must be populated in order to send to Azure.

    :param error: Required. The error details.
    :type error: ~monitor_query_client.models.ErrorInfo
    """

    _validation = {
        'error': {'required': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorInfo'},
    }

    def __init__(
        self,
        *,
        error: "ErrorInfo",
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class ErrorResponseAutoGenerated(msrest.serialization.Model):
    """Describes the format of Error response.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ErrorResponseAutoGenerated, self).__init__(**kwargs)
        self.code = code
        self.message = message


class LocalizableString(msrest.serialization.Model):
    """The localizable string class.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. the invariant value.
    :type value: str
    :param localized_value: the locale specific value.
    :type localized_value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: str,
        localized_value: Optional[str] = None,
        **kwargs
    ):
        super(LocalizableString, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class LogQueryRequest(msrest.serialization.Model):
    """An single request in a batch.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: The error details.
    :type id: str
    :param headers: Dictionary of :code:`<string>`.
    :type headers: dict[str, str]
    :param body: The Analytics query. Learn more about the `Analytics query syntax
     <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_.
    :type body: ~monitor_query_client.models.QueryBody
    :ivar path:  Default value: "/query".
    :vartype path: str
    :ivar method:  Default value: "POST".
    :vartype method: str
    :param workspace: Workspace Id to be included in the query.
    :type workspace: str
    """

    _validation = {
        'path': {'constant': True},
        'method': {'constant': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'headers': {'key': 'headers', 'type': '{str}'},
        'body': {'key': 'body', 'type': 'QueryBody'},
        'path': {'key': 'path', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'workspace': {'key': 'workspace', 'type': 'str'},
    }

    path = "/query"
    method = "POST"

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        headers: Optional[Dict[str, str]] = None,
        body: Optional["QueryBody"] = None,
        workspace: Optional[str] = None,
        **kwargs
    ):
        super(LogQueryRequest, self).__init__(**kwargs)
        self.id = id
        self.headers = headers
        self.body = body
        self.workspace = workspace


class LogQueryResponse(msrest.serialization.Model):
    """LogQueryResponse.

    :param id:
    :type id: str
    :param status:
    :type status: int
    :param body: Contains the tables, columns & rows resulting from a query.
    :type body: ~monitor_query_client.models.QueryResults
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'status': {'key': 'status', 'type': 'int'},
        'body': {'key': 'body', 'type': 'QueryResults'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        status: Optional[int] = None,
        body: Optional["QueryResults"] = None,
        **kwargs
    ):
        super(LogQueryResponse, self).__init__(**kwargs)
        self.id = id
        self.status = status
        self.body = body


class MetadataApplication(msrest.serialization.Model):
    """Application Insights apps that were part of the metadata request and that the user has access to.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the Application Insights app.
    :type id: str
    :param resource_id: Required. The ARM resource ID of the Application Insights app.
    :type resource_id: str
    :param name: Required. The name of the Application Insights app.
    :type name: str
    :param region: Required. The Azure region of the Application Insights app.
    :type region: str
    :param related: The related metadata items for the Application Insights app.
    :type related: ~monitor_query_client.models.MetadataApplicationRelated
    """

    _validation = {
        'id': {'required': True},
        'resource_id': {'required': True},
        'name': {'required': True},
        'region': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'region': {'key': 'region', 'type': 'str'},
        'related': {'key': 'related', 'type': 'MetadataApplicationRelated'},
    }

    def __init__(
        self,
        *,
        id: str,
        resource_id: str,
        name: str,
        region: str,
        related: Optional["MetadataApplicationRelated"] = None,
        **kwargs
    ):
        super(MetadataApplication, self).__init__(**kwargs)
        self.id = id
        self.resource_id = resource_id
        self.name = name
        self.region = region
        self.related = related


class MetadataApplicationRelated(msrest.serialization.Model):
    """The related metadata items for the Application Insights app.

    :param tables: The related tables for the Application Insights app.
    :type tables: list[str]
    :param functions: The related functions for the Application Insights app.
    :type functions: list[str]
    """

    _attribute_map = {
        'tables': {'key': 'tables', 'type': '[str]'},
        'functions': {'key': 'functions', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        tables: Optional[List[str]] = None,
        functions: Optional[List[str]] = None,
        **kwargs
    ):
        super(MetadataApplicationRelated, self).__init__(**kwargs)
        self.tables = tables
        self.functions = functions


class MetadataCategory(msrest.serialization.Model):
    """Categories are used to group other metadata entities.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the category.
    :type id: str
    :param display_name: Required. The display name of the category.
    :type display_name: str
    :param description: The description of the category.
    :type description: str
    :param related: The related metadata items for the category.
    :type related: ~monitor_query_client.models.MetadataCategoryRelated
    """

    _validation = {
        'id': {'required': True},
        'display_name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'related': {'key': 'related', 'type': 'MetadataCategoryRelated'},
    }

    def __init__(
        self,
        *,
        id: str,
        display_name: str,
        description: Optional[str] = None,
        related: Optional["MetadataCategoryRelated"] = None,
        **kwargs
    ):
        super(MetadataCategory, self).__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.description = description
        self.related = related


class MetadataCategoryRelated(msrest.serialization.Model):
    """The related metadata items for the category.

    :param tables: The tables related to the category.
    :type tables: list[str]
    :param functions: The functions related to the category.
    :type functions: list[str]
    :param resource_types: The resource types related to the category.
    :type resource_types: list[str]
    :param queries: The saved queries related to the category.
    :type queries: list[str]
    :param solutions: The Log Analytics solutions related to the category.
    :type solutions: list[str]
    """

    _attribute_map = {
        'tables': {'key': 'tables', 'type': '[str]'},
        'functions': {'key': 'functions', 'type': '[str]'},
        'resource_types': {'key': 'resourceTypes', 'type': '[str]'},
        'queries': {'key': 'queries', 'type': '[str]'},
        'solutions': {'key': 'solutions', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        tables: Optional[List[str]] = None,
        functions: Optional[List[str]] = None,
        resource_types: Optional[List[str]] = None,
        queries: Optional[List[str]] = None,
        solutions: Optional[List[str]] = None,
        **kwargs
    ):
        super(MetadataCategoryRelated, self).__init__(**kwargs)
        self.tables = tables
        self.functions = functions
        self.resource_types = resource_types
        self.queries = queries
        self.solutions = solutions


class MetadataFunction(msrest.serialization.Model):
    """Functions are stored Kusto queries that can be specified as part of queries by using their name.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the function.
    :type id: str
    :param name: Required. The name of the function, to be used in queries.
    :type name: str
    :param parameters: The parameters/arguments of the function, if any.
    :type parameters: str
    :param display_name: The display name of the function.
    :type display_name: str
    :param description: The description of the function.
    :type description: str
    :param body: Required. The KQL body of the function.
    :type body: str
    :param tags: A set of tags. The tags associated with the function.
    :type tags: object
    :param properties: The properties of the function.
    :type properties: object
    :param related: The related metadata items for the function.
    :type related: ~monitor_query_client.models.MetadataFunctionRelated
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'body': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'body': {'key': 'body', 'type': 'str'},
        'tags': {'key': 'tags', 'type': 'object'},
        'properties': {'key': 'properties', 'type': 'object'},
        'related': {'key': 'related', 'type': 'MetadataFunctionRelated'},
    }

    def __init__(
        self,
        *,
        id: str,
        name: str,
        body: str,
        parameters: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        tags: Optional[object] = None,
        properties: Optional[object] = None,
        related: Optional["MetadataFunctionRelated"] = None,
        **kwargs
    ):
        super(MetadataFunction, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.parameters = parameters
        self.display_name = display_name
        self.description = description
        self.body = body
        self.tags = tags
        self.properties = properties
        self.related = related


class MetadataFunctionRelated(msrest.serialization.Model):
    """The related metadata items for the function.

    :param tables: The related tables for the function.
    :type tables: list[str]
    :param solutions: The related Log Analytics solutions for the function.
    :type solutions: list[str]
    :param resource_types: The related resource types for the function.
    :type resource_types: list[str]
    :param categories: The related categories for the function.
    :type categories: list[str]
    :param workspaces: The related workspaces for the function.
    :type workspaces: list[str]
    """

    _attribute_map = {
        'tables': {'key': 'tables', 'type': '[str]'},
        'solutions': {'key': 'solutions', 'type': '[str]'},
        'resource_types': {'key': 'resourceTypes', 'type': '[str]'},
        'categories': {'key': 'categories', 'type': '[str]'},
        'workspaces': {'key': 'workspaces', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        tables: Optional[List[str]] = None,
        solutions: Optional[List[str]] = None,
        resource_types: Optional[List[str]] = None,
        categories: Optional[List[str]] = None,
        workspaces: Optional[List[str]] = None,
        **kwargs
    ):
        super(MetadataFunctionRelated, self).__init__(**kwargs)
        self.tables = tables
        self.solutions = solutions
        self.resource_types = resource_types
        self.categories = categories
        self.workspaces = workspaces


class MetadataPermissions(msrest.serialization.Model):
    """Permission information for the metadata call, includes apps/workspaces/resource the user didn't have access to.

    All required parameters must be populated in order to send to Azure.

    :param workspaces: Required. The permission indication for the workspaces on the metadata
     request.
    :type workspaces: list[~monitor_query_client.models.MetadataPermissionsWorkspacesItem]
    :param resources: The permission indication for the Azure resources on the metadata request.
    :type resources: list[~monitor_query_client.models.MetadataPermissionsResourcesItem]
    :param applications: The permission indication for the Application Insights apps on the
     metadata request.
    :type applications: list[~monitor_query_client.models.MetadataPermissionsApplicationsItem]
    """

    _validation = {
        'workspaces': {'required': True},
    }

    _attribute_map = {
        'workspaces': {'key': 'workspaces', 'type': '[MetadataPermissionsWorkspacesItem]'},
        'resources': {'key': 'resources', 'type': '[MetadataPermissionsResourcesItem]'},
        'applications': {'key': 'applications', 'type': '[MetadataPermissionsApplicationsItem]'},
    }

    def __init__(
        self,
        *,
        workspaces: List["MetadataPermissionsWorkspacesItem"],
        resources: Optional[List["MetadataPermissionsResourcesItem"]] = None,
        applications: Optional[List["MetadataPermissionsApplicationsItem"]] = None,
        **kwargs
    ):
        super(MetadataPermissions, self).__init__(**kwargs)
        self.workspaces = workspaces
        self.resources = resources
        self.applications = applications


class MetadataPermissionsApplicationsItem(msrest.serialization.Model):
    """MetadataPermissionsApplicationsItem.

    All required parameters must be populated in order to send to Azure.

    :param resource_id: Required. The resource ID on the permission indication.
    :type resource_id: str
    """

    _validation = {
        'resource_id': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: str,
        **kwargs
    ):
        super(MetadataPermissionsApplicationsItem, self).__init__(**kwargs)
        self.resource_id = resource_id


class MetadataPermissionsResourcesItem(msrest.serialization.Model):
    """MetadataPermissionsResourcesItem.

    All required parameters must be populated in order to send to Azure.

    :param resource_id: Required. The resource ID on the permission indication.
    :type resource_id: str
    :param deny_tables: The list of tables that were denied access for the resource ID.
    :type deny_tables: list[str]
    """

    _validation = {
        'resource_id': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'deny_tables': {'key': 'denyTables', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        resource_id: str,
        deny_tables: Optional[List[str]] = None,
        **kwargs
    ):
        super(MetadataPermissionsResourcesItem, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.deny_tables = deny_tables


class MetadataPermissionsWorkspacesItem(msrest.serialization.Model):
    """MetadataPermissionsWorkspacesItem.

    All required parameters must be populated in order to send to Azure.

    :param resource_id: Required. The resource ID on the permission indication.
    :type resource_id: str
    :param deny_tables: The list of tables that were denied access for the resource ID.
    :type deny_tables: list[str]
    """

    _validation = {
        'resource_id': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'deny_tables': {'key': 'denyTables', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        resource_id: str,
        deny_tables: Optional[List[str]] = None,
        **kwargs
    ):
        super(MetadataPermissionsWorkspacesItem, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.deny_tables = deny_tables


class MetadataQuery(msrest.serialization.Model):
    """Queries are stored pieces of KQL, along with a list of relevant metadata items.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the query.
    :type id: str
    :param display_name: The display name of the query.
    :type display_name: str
    :param description: The description of the query.
    :type description: str
    :param body: Required. The KQL body of the query.
    :type body: str
    :param labels: The user defined labels associated with the query.
    :type labels: list[str]
    :param tags: A set of tags. The tags associated with the query.
    :type tags: object
    :param properties: The properties of the query.
    :type properties: object
    :param related: The related metadata items for the query.
    :type related: ~monitor_query_client.models.MetadataQueryRelated
    """

    _validation = {
        'id': {'required': True},
        'body': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'body': {'key': 'body', 'type': 'str'},
        'labels': {'key': 'labels', 'type': '[str]'},
        'tags': {'key': 'tags', 'type': 'object'},
        'properties': {'key': 'properties', 'type': 'object'},
        'related': {'key': 'related', 'type': 'MetadataQueryRelated'},
    }

    def __init__(
        self,
        *,
        id: str,
        body: str,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        labels: Optional[List[str]] = None,
        tags: Optional[object] = None,
        properties: Optional[object] = None,
        related: Optional["MetadataQueryRelated"] = None,
        **kwargs
    ):
        super(MetadataQuery, self).__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.description = description
        self.body = body
        self.labels = labels
        self.tags = tags
        self.properties = properties
        self.related = related


class MetadataQueryRelated(msrest.serialization.Model):
    """The related metadata items for the query.

    :param categories: The related categories for the query.
    :type categories: list[str]
    :param solutions: The related Log Analytics solutions for the query.
    :type solutions: list[str]
    :param resource_types: The related resource types for the query.
    :type resource_types: list[str]
    :param tables: The related tables for the query.
    :type tables: list[str]
    """

    _attribute_map = {
        'categories': {'key': 'categories', 'type': '[str]'},
        'solutions': {'key': 'solutions', 'type': '[str]'},
        'resource_types': {'key': 'resourceTypes', 'type': '[str]'},
        'tables': {'key': 'tables', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        categories: Optional[List[str]] = None,
        solutions: Optional[List[str]] = None,
        resource_types: Optional[List[str]] = None,
        tables: Optional[List[str]] = None,
        **kwargs
    ):
        super(MetadataQueryRelated, self).__init__(**kwargs)
        self.categories = categories
        self.solutions = solutions
        self.resource_types = resource_types
        self.tables = tables


class MetadataResourceType(msrest.serialization.Model):
    """Metadata about types of Azure resources, containing relevant tables, functions, etc.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the resource-type.
    :type id: str
    :param type: Required. The type of the resource-type.
    :type type: str
    :param display_name: The display name of the resource-type.
    :type display_name: str
    :param description: The description of the resource-type.
    :type description: str
    :param labels: The user-defined labels of the resource-type.
    :type labels: list[str]
    :param tags: A set of tags. The tags associated with the resource-type.
    :type tags: object
    :param properties: The properties of the resource-type.
    :type properties: object
    :param related: The related metadata items for the resource-type.
    :type related: ~monitor_query_client.models.MetadataResourceTypeRelated
    """

    _validation = {
        'id': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'labels': {'key': 'labels', 'type': '[str]'},
        'tags': {'key': 'tags', 'type': 'object'},
        'properties': {'key': 'properties', 'type': 'object'},
        'related': {'key': 'related', 'type': 'MetadataResourceTypeRelated'},
    }

    def __init__(
        self,
        *,
        id: str,
        type: str,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        labels: Optional[List[str]] = None,
        tags: Optional[object] = None,
        properties: Optional[object] = None,
        related: Optional["MetadataResourceTypeRelated"] = None,
        **kwargs
    ):
        super(MetadataResourceType, self).__init__(**kwargs)
        self.id = id
        self.type = type
        self.display_name = display_name
        self.description = description
        self.labels = labels
        self.tags = tags
        self.properties = properties
        self.related = related


class MetadataResourceTypeRelated(msrest.serialization.Model):
    """The related metadata items for the resource-type.

    :param tables: The tables related to the resource-type.
    :type tables: list[str]
    :param functions: The functions related to the resource-type.
    :type functions: list[str]
    :param categories: The categories related to the resource-type.
    :type categories: list[str]
    :param queries: The queries related to the resource-type.
    :type queries: list[str]
    :param workspaces: The Log Analytics workspaces related to the resource-type.
    :type workspaces: list[str]
    :param resources: The Azure resources related to the resource-type.
    :type resources: list[str]
    """

    _attribute_map = {
        'tables': {'key': 'tables', 'type': '[str]'},
        'functions': {'key': 'functions', 'type': '[str]'},
        'categories': {'key': 'categories', 'type': '[str]'},
        'queries': {'key': 'queries', 'type': '[str]'},
        'workspaces': {'key': 'workspaces', 'type': '[str]'},
        'resources': {'key': 'resources', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        tables: Optional[List[str]] = None,
        functions: Optional[List[str]] = None,
        categories: Optional[List[str]] = None,
        queries: Optional[List[str]] = None,
        workspaces: Optional[List[str]] = None,
        resources: Optional[List[str]] = None,
        **kwargs
    ):
        super(MetadataResourceTypeRelated, self).__init__(**kwargs)
        self.tables = tables
        self.functions = functions
        self.categories = categories
        self.queries = queries
        self.workspaces = workspaces
        self.resources = resources


class MetadataResults(msrest.serialization.Model):
    """The metadata response for the app, including available tables, etc.

    :param categories: The list of categories that are referenced in this metadata response.
    :type categories: list[~monitor_query_client.models.MetadataCategory]
    :param resource_types: The list of resource types that are referenced in this metadata
     response.
    :type resource_types: list[~monitor_query_client.models.MetadataResourceType]
    :param solutions: The list of Log Analytics solutions installed on the workspace.
    :type solutions: list[~monitor_query_client.models.MetadataSolution]
    :param tables: The list of tables and columns that comprise the schema of the workspace.
    :type tables: list[~monitor_query_client.models.MetadataTable]
    :param functions: The list of functions stored on the workspace, or introduced by solutions
     etc.
    :type functions: list[~monitor_query_client.models.MetadataFunction]
    :param queries: The list of saved queries stored on the workspace, or introduced by solutions,
     resource types, etc.
    :type queries: list[~monitor_query_client.models.MetadataQuery]
    :param applications: The list of Application Insights apps that were referenced in the metadata
     request.
    :type applications: list[~monitor_query_client.models.MetadataApplication]
    :param workspaces: The list of Log Analytics workspaces that were referenced in the metadata
     request.
    :type workspaces: list[~monitor_query_client.models.MetadataWorkspace]
    :param resources: The list of Azure resources that were referenced in the metadata request.
    :type resources: list[object]
    :param permissions: The list of permission rules that affected the metadata request.
    :type permissions: list[~monitor_query_client.models.MetadataPermissions]
    """

    _validation = {
        'categories': {'unique': True},
        'resource_types': {'unique': True},
        'solutions': {'unique': True},
        'tables': {'unique': True},
        'functions': {'unique': True},
        'queries': {'unique': True},
        'applications': {'unique': True},
        'workspaces': {'unique': True},
        'resources': {'unique': True},
        'permissions': {'unique': True},
    }

    _attribute_map = {
        'categories': {'key': 'categories', 'type': '[MetadataCategory]'},
        'resource_types': {'key': 'resourceTypes', 'type': '[MetadataResourceType]'},
        'solutions': {'key': 'solutions', 'type': '[MetadataSolution]'},
        'tables': {'key': 'tables', 'type': '[MetadataTable]'},
        'functions': {'key': 'functions', 'type': '[MetadataFunction]'},
        'queries': {'key': 'queries', 'type': '[MetadataQuery]'},
        'applications': {'key': 'applications', 'type': '[MetadataApplication]'},
        'workspaces': {'key': 'workspaces', 'type': '[MetadataWorkspace]'},
        'resources': {'key': 'resources', 'type': '[object]'},
        'permissions': {'key': 'permissions', 'type': '[MetadataPermissions]'},
    }

    def __init__(
        self,
        *,
        categories: Optional[List["MetadataCategory"]] = None,
        resource_types: Optional[List["MetadataResourceType"]] = None,
        solutions: Optional[List["MetadataSolution"]] = None,
        tables: Optional[List["MetadataTable"]] = None,
        functions: Optional[List["MetadataFunction"]] = None,
        queries: Optional[List["MetadataQuery"]] = None,
        applications: Optional[List["MetadataApplication"]] = None,
        workspaces: Optional[List["MetadataWorkspace"]] = None,
        resources: Optional[List[object]] = None,
        permissions: Optional[List["MetadataPermissions"]] = None,
        **kwargs
    ):
        super(MetadataResults, self).__init__(**kwargs)
        self.categories = categories
        self.resource_types = resource_types
        self.solutions = solutions
        self.tables = tables
        self.functions = functions
        self.queries = queries
        self.applications = applications
        self.workspaces = workspaces
        self.resources = resources
        self.permissions = permissions


class MetadataSolution(msrest.serialization.Model):
    """Solutions can group tables and functions that are associated with a certain Azure Log Analytics offering.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the Log Analytics solution.
    :type id: str
    :param name: Required. The name of the Log Analytics solution.
    :type name: str
    :param display_name: The display name of the Log Analytics solution.
    :type display_name: str
    :param description: The description of the Log Analytics solution.
    :type description: str
    :param tags: A set of tags. The tags that are associated with the Log Analytics solution.
    :type tags: object
    :param properties: The properties of the Log Analytics solution.
    :type properties: object
    :param related: Required. The related metadata items for the Log Analytics solution.
    :type related: ~monitor_query_client.models.MetadataSolutionRelated
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'related': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'tags': {'key': 'tags', 'type': 'object'},
        'properties': {'key': 'properties', 'type': 'object'},
        'related': {'key': 'related', 'type': 'MetadataSolutionRelated'},
    }

    def __init__(
        self,
        *,
        id: str,
        name: str,
        related: "MetadataSolutionRelated",
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        tags: Optional[object] = None,
        properties: Optional[object] = None,
        **kwargs
    ):
        super(MetadataSolution, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.display_name = display_name
        self.description = description
        self.tags = tags
        self.properties = properties
        self.related = related


class MetadataSolutionRelated(msrest.serialization.Model):
    """The related metadata items for the Log Analytics solution.

    All required parameters must be populated in order to send to Azure.

    :param tables: Required. The tables related to the Log Analytics solution.
    :type tables: list[str]
    :param functions: The functions related to the Log Analytics solution.
    :type functions: list[str]
    :param categories: The categories related to the Log Analytics solution.
    :type categories: list[str]
    :param queries: The saved queries related to the Log Analytics solution.
    :type queries: list[str]
    :param workspaces: The Workspaces referenced in the metadata request that are related to the
     Log Analytics solution.
    :type workspaces: list[str]
    """

    _validation = {
        'tables': {'required': True},
    }

    _attribute_map = {
        'tables': {'key': 'tables', 'type': '[str]'},
        'functions': {'key': 'functions', 'type': '[str]'},
        'categories': {'key': 'categories', 'type': '[str]'},
        'queries': {'key': 'queries', 'type': '[str]'},
        'workspaces': {'key': 'workspaces', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        tables: List[str],
        functions: Optional[List[str]] = None,
        categories: Optional[List[str]] = None,
        queries: Optional[List[str]] = None,
        workspaces: Optional[List[str]] = None,
        **kwargs
    ):
        super(MetadataSolutionRelated, self).__init__(**kwargs)
        self.tables = tables
        self.functions = functions
        self.categories = categories
        self.queries = queries
        self.workspaces = workspaces


class MetadataTable(msrest.serialization.Model):
    """Tables are part of the workspace schema, and contain a list of columns and a reference to other relevant metadata items.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the table.
    :type id: str
    :param name: Required. The name of the table.
    :type name: str
    :param description: The description of the table.
    :type description: str
    :param timespan_column: The column associated with the timespan query parameter for the table.
    :type timespan_column: str
    :param labels: The user defined labels of the table.
    :type labels: list[str]
    :param tags: A set of tags. The tags associated with the table.
    :type tags: object
    :param properties: The properties of the table.
    :type properties: object
    :param columns: The list of columns defined on the table.
    :type columns: list[~monitor_query_client.models.MetadataTableColumnsItem]
    :param related: The related metadata items for the table.
    :type related: ~monitor_query_client.models.MetadataTableRelated
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'timespan_column': {'key': 'timespanColumn', 'type': 'str'},
        'labels': {'key': 'labels', 'type': '[str]'},
        'tags': {'key': 'tags', 'type': 'object'},
        'properties': {'key': 'properties', 'type': 'object'},
        'columns': {'key': 'columns', 'type': '[MetadataTableColumnsItem]'},
        'related': {'key': 'related', 'type': 'MetadataTableRelated'},
    }

    def __init__(
        self,
        *,
        id: str,
        name: str,
        description: Optional[str] = None,
        timespan_column: Optional[str] = None,
        labels: Optional[List[str]] = None,
        tags: Optional[object] = None,
        properties: Optional[object] = None,
        columns: Optional[List["MetadataTableColumnsItem"]] = None,
        related: Optional["MetadataTableRelated"] = None,
        **kwargs
    ):
        super(MetadataTable, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.description = description
        self.timespan_column = timespan_column
        self.labels = labels
        self.tags = tags
        self.properties = properties
        self.columns = columns
        self.related = related


class MetadataTableColumnsItem(msrest.serialization.Model):
    """MetadataTableColumnsItem.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the column.
    :type name: str
    :param description: The description of the column.
    :type description: str
    :param type: Required. The data type of the column. Possible values include: "bool",
     "datetime", "dynamic", "int", "long", "real", "string".
    :type type: str or ~monitor_query_client.models.MetadataColumnDataType
    :param is_preferred_facet: A flag indicating this column is a preferred facet.
    :type is_preferred_facet: bool
    :param source: an indication of the source of the column, used only when multiple workspaces
     have conflicting definition for the column.
    :type source: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_preferred_facet': {'key': 'isPreferredFacet', 'type': 'bool'},
        'source': {'key': 'source', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "MetadataColumnDataType"],
        description: Optional[str] = None,
        is_preferred_facet: Optional[bool] = None,
        source: Optional[object] = None,
        **kwargs
    ):
        super(MetadataTableColumnsItem, self).__init__(**kwargs)
        self.name = name
        self.description = description
        self.type = type
        self.is_preferred_facet = is_preferred_facet
        self.source = source


class MetadataTableRelated(msrest.serialization.Model):
    """The related metadata items for the table.

    :param categories: The related categories for the table.
    :type categories: list[str]
    :param solutions: The related Log Analytics solutions for the table.
    :type solutions: list[str]
    :param resource_types: The related resource types for the table.
    :type resource_types: list[str]
    :param workspaces: The related Log Analytics workspaces for the table.
    :type workspaces: list[str]
    :param functions: The related functions for the table.
    :type functions: list[str]
    :param queries: The related saved queries for the table.
    :type queries: list[str]
    """

    _attribute_map = {
        'categories': {'key': 'categories', 'type': '[str]'},
        'solutions': {'key': 'solutions', 'type': '[str]'},
        'resource_types': {'key': 'resourceTypes', 'type': '[str]'},
        'workspaces': {'key': 'workspaces', 'type': '[str]'},
        'functions': {'key': 'functions', 'type': '[str]'},
        'queries': {'key': 'queries', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        categories: Optional[List[str]] = None,
        solutions: Optional[List[str]] = None,
        resource_types: Optional[List[str]] = None,
        workspaces: Optional[List[str]] = None,
        functions: Optional[List[str]] = None,
        queries: Optional[List[str]] = None,
        **kwargs
    ):
        super(MetadataTableRelated, self).__init__(**kwargs)
        self.categories = categories
        self.solutions = solutions
        self.resource_types = resource_types
        self.workspaces = workspaces
        self.functions = functions
        self.queries = queries


class MetadataValue(msrest.serialization.Model):
    """Represents a metric metadata value.

    :param name: the name of the metadata.
    :type name: ~monitor_query_client.models.LocalizableString
    :param value: the value of the metadata.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'LocalizableString'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional["LocalizableString"] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(MetadataValue, self).__init__(**kwargs)
        self.name = name
        self.value = value


class MetadataWorkspace(msrest.serialization.Model):
    """Log Analytics workspaces that were part of the metadata request and that the user has access to.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the Log Analytics workspace.
    :type id: str
    :param resource_id: Required. The ARM resource ID of the Log Analytics workspace.
    :type resource_id: str
    :param name: Required. The name of the Log Analytics workspace.
    :type name: str
    :param region: Required. The Azure region of the Log Analytics workspace.
    :type region: str
    :param related: The related metadata items for the Log Analytics workspace.
    :type related: ~monitor_query_client.models.MetadataWorkspaceRelated
    """

    _validation = {
        'id': {'required': True},
        'resource_id': {'required': True},
        'name': {'required': True},
        'region': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'region': {'key': 'region', 'type': 'str'},
        'related': {'key': 'related', 'type': 'MetadataWorkspaceRelated'},
    }

    def __init__(
        self,
        *,
        id: str,
        resource_id: str,
        name: str,
        region: str,
        related: Optional["MetadataWorkspaceRelated"] = None,
        **kwargs
    ):
        super(MetadataWorkspace, self).__init__(**kwargs)
        self.id = id
        self.resource_id = resource_id
        self.name = name
        self.region = region
        self.related = related


class MetadataWorkspaceRelated(msrest.serialization.Model):
    """The related metadata items for the Log Analytics workspace.

    :param tables: The related tables for the Log Analytics workspace.
    :type tables: list[str]
    :param solutions: The related Log Analytics solutions for the Log Analytics workspace.
    :type solutions: list[str]
    :param resource_types: The related resource types for the Log Analytics workspace.
    :type resource_types: list[str]
    :param functions: The related functions for the Log Analytics workspace.
    :type functions: list[str]
    :param resources: The related Azure resources for the Log Analytics workspace.
    :type resources: list[str]
    """

    _attribute_map = {
        'tables': {'key': 'tables', 'type': '[str]'},
        'solutions': {'key': 'solutions', 'type': '[str]'},
        'resource_types': {'key': 'resourceTypes', 'type': '[str]'},
        'functions': {'key': 'functions', 'type': '[str]'},
        'resources': {'key': 'resources', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        tables: Optional[List[str]] = None,
        solutions: Optional[List[str]] = None,
        resource_types: Optional[List[str]] = None,
        functions: Optional[List[str]] = None,
        resources: Optional[List[str]] = None,
        **kwargs
    ):
        super(MetadataWorkspaceRelated, self).__init__(**kwargs)
        self.tables = tables
        self.solutions = solutions
        self.resource_types = resource_types
        self.functions = functions
        self.resources = resources


class Metric(msrest.serialization.Model):
    """The result data of a query.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. the metric Id.
    :type id: str
    :param type: Required. the resource type of the metric resource.
    :type type: str
    :param name: Required. the name and the display name of the metric, i.e. it is localizable
     string.
    :type name: ~monitor_query_client.models.LocalizableString
    :param unit: Required. the unit of the metric. Possible values include: "Count", "Bytes",
     "Seconds", "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds",
     "Unspecified", "Cores", "MilliCores", "NanoCores", "BitsPerSecond".
    :type unit: str or ~monitor_query_client.models.Unit
    :param timeseries: Required. the time series returned when a data query is performed.
    :type timeseries: list[~monitor_query_client.models.TimeSeriesElement]
    """

    _validation = {
        'id': {'required': True},
        'type': {'required': True},
        'name': {'required': True},
        'unit': {'required': True},
        'timeseries': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'LocalizableString'},
        'unit': {'key': 'unit', 'type': 'str'},
        'timeseries': {'key': 'timeseries', 'type': '[TimeSeriesElement]'},
    }

    def __init__(
        self,
        *,
        id: str,
        type: str,
        name: "LocalizableString",
        unit: Union[str, "Unit"],
        timeseries: List["TimeSeriesElement"],
        **kwargs
    ):
        super(Metric, self).__init__(**kwargs)
        self.id = id
        self.type = type
        self.name = name
        self.unit = unit
        self.timeseries = timeseries


class MetricAvailability(msrest.serialization.Model):
    """Metric availability specifies the time grain (aggregation interval or frequency) and the retention period for that time grain.

    :param time_grain: the time grain specifies the aggregation interval for the metric. Expressed
     as a duration 'PT1M', 'P1D', etc.
    :type time_grain: ~datetime.timedelta
    :param retention: the retention period for the metric at the specified timegrain.  Expressed as
     a duration 'PT1M', 'P1D', etc.
    :type retention: ~datetime.timedelta
    """

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'duration'},
        'retention': {'key': 'retention', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        time_grain: Optional[datetime.timedelta] = None,
        retention: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        super(MetricAvailability, self).__init__(**kwargs)
        self.time_grain = time_grain
        self.retention = retention


class MetricDefinition(msrest.serialization.Model):
    """Metric definition class specifies the metadata for a metric.

    :param is_dimension_required: Flag to indicate whether the dimension is required.
    :type is_dimension_required: bool
    :param resource_id: the resource identifier of the resource that emitted the metric.
    :type resource_id: str
    :param namespace: the namespace the metric belongs to.
    :type namespace: str
    :param name: the name and the display name of the metric, i.e. it is a localizable string.
    :type name: ~monitor_query_client.models.LocalizableString
    :param unit: the unit of the metric. Possible values include: "Count", "Bytes", "Seconds",
     "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds", "Unspecified",
     "Cores", "MilliCores", "NanoCores", "BitsPerSecond".
    :type unit: str or ~monitor_query_client.models.Unit
    :param primary_aggregation_type: the primary aggregation type value defining how to use the
     values for display. Possible values include: "None", "Average", "Count", "Minimum", "Maximum",
     "Total".
    :type primary_aggregation_type: str or ~monitor_query_client.models.AggregationType
    :param supported_aggregation_types: the collection of what aggregation types are supported.
    :type supported_aggregation_types: list[str or ~monitor_query_client.models.AggregationType]
    :param metric_availabilities: the collection of what aggregation intervals are available to be
     queried.
    :type metric_availabilities: list[~monitor_query_client.models.MetricAvailability]
    :param id: the resource identifier of the metric definition.
    :type id: str
    :param dimensions: the name and the display name of the dimension, i.e. it is a localizable
     string.
    :type dimensions: list[~monitor_query_client.models.LocalizableString]
    """

    _attribute_map = {
        'is_dimension_required': {'key': 'isDimensionRequired', 'type': 'bool'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'namespace': {'key': 'namespace', 'type': 'str'},
        'name': {'key': 'name', 'type': 'LocalizableString'},
        'unit': {'key': 'unit', 'type': 'str'},
        'primary_aggregation_type': {'key': 'primaryAggregationType', 'type': 'str'},
        'supported_aggregation_types': {'key': 'supportedAggregationTypes', 'type': '[str]'},
        'metric_availabilities': {'key': 'metricAvailabilities', 'type': '[MetricAvailability]'},
        'id': {'key': 'id', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[LocalizableString]'},
    }

    def __init__(
        self,
        *,
        is_dimension_required: Optional[bool] = None,
        resource_id: Optional[str] = None,
        namespace: Optional[str] = None,
        name: Optional["LocalizableString"] = None,
        unit: Optional[Union[str, "Unit"]] = None,
        primary_aggregation_type: Optional[Union[str, "AggregationType"]] = None,
        supported_aggregation_types: Optional[List[Union[str, "AggregationType"]]] = None,
        metric_availabilities: Optional[List["MetricAvailability"]] = None,
        id: Optional[str] = None,
        dimensions: Optional[List["LocalizableString"]] = None,
        **kwargs
    ):
        super(MetricDefinition, self).__init__(**kwargs)
        self.is_dimension_required = is_dimension_required
        self.resource_id = resource_id
        self.namespace = namespace
        self.name = name
        self.unit = unit
        self.primary_aggregation_type = primary_aggregation_type
        self.supported_aggregation_types = supported_aggregation_types
        self.metric_availabilities = metric_availabilities
        self.id = id
        self.dimensions = dimensions


class MetricDefinitionCollection(msrest.serialization.Model):
    """Represents collection of metric definitions.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. the values for the metric definitions.
    :type value: list[~monitor_query_client.models.MetricDefinition]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MetricDefinition]'},
    }

    def __init__(
        self,
        *,
        value: List["MetricDefinition"],
        **kwargs
    ):
        super(MetricDefinitionCollection, self).__init__(**kwargs)
        self.value = value


class MetricNamespace(msrest.serialization.Model):
    """Metric namespace class specifies the metadata for a metric namespace.

    :param id: The ID of the metricNamespace.
    :type id: str
    :param type: The type of the namespace.
    :type type: str
    :param name: The name of the namespace.
    :type name: str
    :param properties: Properties which include the fully qualified namespace name.
    :type properties: ~monitor_query_client.models.MetricNamespaceName
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'MetricNamespaceName'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        type: Optional[str] = None,
        name: Optional[str] = None,
        properties: Optional["MetricNamespaceName"] = None,
        **kwargs
    ):
        super(MetricNamespace, self).__init__(**kwargs)
        self.id = id
        self.type = type
        self.name = name
        self.properties = properties


class MetricNamespaceCollection(msrest.serialization.Model):
    """Represents collection of metric namespaces.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The values for the metric namespaces.
    :type value: list[~monitor_query_client.models.MetricNamespace]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MetricNamespace]'},
    }

    def __init__(
        self,
        *,
        value: List["MetricNamespace"],
        **kwargs
    ):
        super(MetricNamespaceCollection, self).__init__(**kwargs)
        self.value = value


class MetricNamespaceName(msrest.serialization.Model):
    """The fully qualified metric namespace name.

    :param metric_namespace_name: The metric namespace name.
    :type metric_namespace_name: str
    """

    _attribute_map = {
        'metric_namespace_name': {'key': 'metricNamespaceName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        metric_namespace_name: Optional[str] = None,
        **kwargs
    ):
        super(MetricNamespaceName, self).__init__(**kwargs)
        self.metric_namespace_name = metric_namespace_name


class MetricValue(msrest.serialization.Model):
    """Represents a metric value.

    All required parameters must be populated in order to send to Azure.

    :param time_stamp: Required. the timestamp for the metric value in ISO 8601 format.
    :type time_stamp: ~datetime.datetime
    :param average: the average value in the time range.
    :type average: float
    :param minimum: the least value in the time range.
    :type minimum: float
    :param maximum: the greatest value in the time range.
    :type maximum: float
    :param total: the sum of all of the values in the time range.
    :type total: float
    :param count: the number of samples in the time range. Can be used to determine the number of
     values that contributed to the average value.
    :type count: float
    """

    _validation = {
        'time_stamp': {'required': True},
    }

    _attribute_map = {
        'time_stamp': {'key': 'timeStamp', 'type': 'iso-8601'},
        'average': {'key': 'average', 'type': 'float'},
        'minimum': {'key': 'minimum', 'type': 'float'},
        'maximum': {'key': 'maximum', 'type': 'float'},
        'total': {'key': 'total', 'type': 'float'},
        'count': {'key': 'count', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        time_stamp: datetime.datetime,
        average: Optional[float] = None,
        minimum: Optional[float] = None,
        maximum: Optional[float] = None,
        total: Optional[float] = None,
        count: Optional[float] = None,
        **kwargs
    ):
        super(MetricValue, self).__init__(**kwargs)
        self.time_stamp = time_stamp
        self.average = average
        self.minimum = minimum
        self.maximum = maximum
        self.total = total
        self.count = count


class QueryBody(msrest.serialization.Model):
    """The Analytics query. Learn more about the `Analytics query syntax <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_.

    All required parameters must be populated in order to send to Azure.

    :param query: Required. The query to execute.
    :type query: str
    :param timespan: Optional. The timespan over which to query data. This is an ISO8601 time
     period value.  This timespan is applied in addition to any that are specified in the query
     expression.
    :type timespan: str
    :param workspaces: A list of workspaces that are included in the query.
    :type workspaces: list[str]
    :param qualified_names: A list of qualified workspace names that are included in the query.
    :type qualified_names: list[str]
    :param workspace_ids: A list of workspace IDs that are included in the query.
    :type workspace_ids: list[str]
    :param azure_resource_ids: A list of Azure resource IDs that are included in the query.
    :type azure_resource_ids: list[str]
    """

    _validation = {
        'query': {'required': True},
    }

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
        'timespan': {'key': 'timespan', 'type': 'str'},
        'workspaces': {'key': 'workspaces', 'type': '[str]'},
        'qualified_names': {'key': 'qualifiedNames', 'type': '[str]'},
        'workspace_ids': {'key': 'workspaceIds', 'type': '[str]'},
        'azure_resource_ids': {'key': 'azureResourceIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        query: str,
        timespan: Optional[str] = None,
        workspaces: Optional[List[str]] = None,
        qualified_names: Optional[List[str]] = None,
        workspace_ids: Optional[List[str]] = None,
        azure_resource_ids: Optional[List[str]] = None,
        **kwargs
    ):
        super(QueryBody, self).__init__(**kwargs)
        self.query = query
        self.timespan = timespan
        self.workspaces = workspaces
        self.qualified_names = qualified_names
        self.workspace_ids = workspace_ids
        self.azure_resource_ids = azure_resource_ids


class QueryResults(msrest.serialization.Model):
    """Contains the tables, columns & rows resulting from a query.

    :param tables: The list of tables, columns and rows.
    :type tables: list[~monitor_query_client.models.Table]
    :param errors:
    :type errors: ~monitor_query_client.models.ErrorDetails
    """

    _attribute_map = {
        'tables': {'key': 'tables', 'type': '[Table]'},
        'errors': {'key': 'errors', 'type': 'ErrorDetails'},
    }

    def __init__(
        self,
        *,
        tables: Optional[List["Table"]] = None,
        errors: Optional["ErrorDetails"] = None,
        **kwargs
    ):
        super(QueryResults, self).__init__(**kwargs)
        self.tables = tables
        self.errors = errors


class Response(msrest.serialization.Model):
    """The response to a metrics query.

    All required parameters must be populated in order to send to Azure.

    :param cost: The integer value representing the cost of the query, for data case.
    :type cost: int
    :param timespan: Required. The timespan for which the data was retrieved. Its value consists of
     two datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned
     back from what was originally requested.
    :type timespan: str
    :param interval: The interval (window size) for which the metric data was returned in.  This
     may be adjusted in the future and returned back from what was originally requested.  This is
     not present if a metadata request was made.
    :type interval: ~datetime.timedelta
    :param namespace: The namespace of the metrics been queried.
    :type namespace: str
    :param resourceregion: The region of the resource been queried for metrics.
    :type resourceregion: str
    :param value: Required. the value of the collection.
    :type value: list[~monitor_query_client.models.Metric]
    """

    _validation = {
        'cost': {'minimum': 0},
        'timespan': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'cost': {'key': 'cost', 'type': 'int'},
        'timespan': {'key': 'timespan', 'type': 'str'},
        'interval': {'key': 'interval', 'type': 'duration'},
        'namespace': {'key': 'namespace', 'type': 'str'},
        'resourceregion': {'key': 'resourceregion', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Metric]'},
    }

    def __init__(
        self,
        *,
        timespan: str,
        value: List["Metric"],
        cost: Optional[int] = None,
        interval: Optional[datetime.timedelta] = None,
        namespace: Optional[str] = None,
        resourceregion: Optional[str] = None,
        **kwargs
    ):
        super(Response, self).__init__(**kwargs)
        self.cost = cost
        self.timespan = timespan
        self.interval = interval
        self.namespace = namespace
        self.resourceregion = resourceregion
        self.value = value


class Table(msrest.serialization.Model):
    """Contains the columns and rows for one table in a query response.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the table.
    :type name: str
    :param columns: Required. The list of columns in this table.
    :type columns: list[~monitor_query_client.models.Column]
    :param rows: Required. The resulting rows from this query.
    :type rows: list[list[str]]
    """

    _validation = {
        'name': {'required': True},
        'columns': {'required': True},
        'rows': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'columns': {'key': 'columns', 'type': '[Column]'},
        'rows': {'key': 'rows', 'type': '[[str]]'},
    }

    def __init__(
        self,
        *,
        name: str,
        columns: List["Column"],
        rows: List[List[str]],
        **kwargs
    ):
        super(Table, self).__init__(**kwargs)
        self.name = name
        self.columns = columns
        self.rows = rows


class TimeSeriesElement(msrest.serialization.Model):
    """A time series result type. The discriminator value is always TimeSeries in this case.

    :param metadatavalues: the metadata values returned if $filter was specified in the call.
    :type metadatavalues: list[~monitor_query_client.models.MetadataValue]
    :param data: An array of data points representing the metric values.  This is only returned if
     a result type of data is specified.
    :type data: list[~monitor_query_client.models.MetricValue]
    """

    _attribute_map = {
        'metadatavalues': {'key': 'metadatavalues', 'type': '[MetadataValue]'},
        'data': {'key': 'data', 'type': '[MetricValue]'},
    }

    def __init__(
        self,
        *,
        metadatavalues: Optional[List["MetadataValue"]] = None,
        data: Optional[List["MetricValue"]] = None,
        **kwargs
    ):
        super(TimeSeriesElement, self).__init__(**kwargs)
        self.metadatavalues = metadatavalues
        self.data = data
