# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import TYPE_CHECKING

from azure.core import PipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Optional

    from azure.core.pipeline.transport import HttpRequest, HttpResponse

from ._configuration import MonitorQueryClientConfiguration
from .operations import QueryOperations
from .operations import MetadataOperations
from .operations import MetricDefinitionsOperations
from .operations import MetricNamespacesOperations
from .operations import MetricsOperations
from . import models


class MonitorQueryClient(object):
    """Azure Monitor Query Python Client.

    :ivar query: QueryOperations operations
    :vartype query: monitor_query_client.operations.QueryOperations
    :ivar metadata: MetadataOperations operations
    :vartype metadata: monitor_query_client.operations.MetadataOperations
    :ivar metric_definitions: MetricDefinitionsOperations operations
    :vartype metric_definitions: monitor_query_client.operations.MetricDefinitionsOperations
    :ivar metric_namespaces: MetricNamespacesOperations operations
    :vartype metric_namespaces: monitor_query_client.operations.MetricNamespacesOperations
    :ivar metrics: MetricsOperations operations
    :vartype metrics: monitor_query_client.operations.MetricsOperations
    :param host: server parameter.
    :type host: str
    :param str base_url: Service URL
    """

    def __init__(
        self,
        host="https://management.azure.com",  # type: str
        base_url=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        if not base_url:
            base_url = 'https://api.loganalytics.io/v1'
        self._config = MonitorQueryClientConfiguration(host, **kwargs)
        self._client = PipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.query = QueryOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.metadata = MetadataOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.metric_definitions = MetricDefinitionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.metric_namespaces = MetricNamespacesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.metrics = MetricsOperations(
            self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, http_request, **kwargs):
        # type: (HttpRequest, Any) -> HttpResponse
        """Runs the network request through the client's chained policies.

        :param http_request: The network request you want to make. Required.
        :type http_request: ~azure.core.pipeline.transport.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to True.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.pipeline.transport.HttpResponse
        """
        http_request.url = self._client.format_url(http_request.url)
        stream = kwargs.pop("stream", True)
        pipeline_response = self._client._pipeline.run(http_request, stream=stream, **kwargs)
        return pipeline_response.http_response

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> MonitorQueryClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
