
/* Chrysalide - Outil d'analyse de fichiers binaires
 * parser.h - prototypes pour le lecteur de contenu Yaml
 *
 * Copyright (C) 2019-2023 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef PLUGINS_YAML_PARSER_H
#define PLUGINS_YAML_PARSER_H


#include <sys/types.h>


#include "node.h"



/* Crée une arborescence YAML pour contenu au format adapté. */
GYamlNode *parse_yaml_from_text(const char *, size_t);

/* Crée une arborescence YAML pour fichier au format adapté. */
GYamlNode *parse_yaml_from_file(const char *);



#endif  /* PLUGINS_YAML_PARSER_H */
