
/* Chrysalide - Outil d'analyse de fichiers binaires
 * comment.h - prototypes pour l'équivalent Python du fichier "analysis/db/items/comment.h"
 *
 * Copyright (C) 2018 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _PLUGINS_PYCHRYSALIDE_ANALYSIS_DB_ITEMS_COMMENT_H
#define _PLUGINS_PYCHRYSALIDE_ANALYSIS_DB_ITEMS_COMMENT_H


#include <Python.h>
#include <stdbool.h>



/* --------------------- ELABORATION D'UN ELEMENT DE COLLECTION --------------------- */


/* Fournit un accès à une définition de type à diffuser. */
PyTypeObject *get_python_db_comment_type(void);

/* Prend en charge l'objet 'pychrysalide.analysis.db.items.DbComment'. */
bool ensure_python_db_comment_is_registered(void);

/* Tente de convertir en commentaire de base. */
int convert_to_db_comment(PyObject *, void *);



/* ---------------------- DEFINITION DE LA COLLECTION ASSOCIEE ---------------------- */


/* Fournit un accès à une définition de type à diffuser. */
PyTypeObject *get_python_comment_collection_type(void);

/* Prend en charge l'objet 'pychrysalide.analysis.db.items.CommentCollection'. */
bool ensure_python_comment_collection_is_registered(void);

/* Tente de convertir en collection de commentaires. */
int convert_to_comment_collection(PyObject *, void *);



#endif  /* _PLUGINS_PYCHRYSALIDE_ANALYSIS_DB_ITEMS_COMMENT_H */
