
/* Chrysalide - Outil d'analyse de fichiers binaires
 * ##FILE## - traduction d'instructions ARMv7
 *
 * Copyright (C) 2017 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


@title SVC (previously SWI)

@id 223

@desc {

	Supervisor Call, previously called Software Interrupt, causes a Supervisor Call exception. For more information, see Supervisor Call (SVC) exception on page B1-1209. Software can use this instruction as a call to an operating system to provide a service. In the following cases, the Supervisor Call exception generated by the SVC instruction is taken to Hyp mode: • If the SVC is executed in Hyp mode. • If HCR.TGE is set to 1, and the SVC is executed in Non-secure User mode. For more information, see Supervisor Call exception, when HCR.TGE is set to 1 on page B1-1191 In these cases, the HSR identifies that the exception entry was caused by a Supervisor Call exception, EC value 0x11, see Use of the HSR on page B3-1424. The immediate field in the HSR: • if the SVC is unconditional: — for the Thumb instruction, is the zero-extended value of the imm8 field — for the ARM instruction, is the least-significant 16 bits the imm24 field • if the SVC is conditional, is UNKNOWN.

}

@encoding (t1) {

	@half 1 1 0 1 1 1 1 1 imm8(8)

	@syntax {

		@subid 703

		@conv {

			imm32 = ZeroExtend(imm8, 32)

		}

		@asm svc imm32

	}

}

@encoding (A1) {

	@word cond(4) 1 1 1 1 imm24(24)

	@syntax {

		@subid 704

		@conv {

			imm32 = ZeroExtend(imm24, 32)

		}

		@asm svc imm32

		@rules {

			check g_arm_instruction_set_cond(cond)

		}

	}

}

