
/* Chrysalide - Outil d'analyse de fichiers binaires
 * ##FILE## - traduction d'instructions ARMv7
 *
 * Copyright (C) 2017 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


@title SUB (SP minus register)

@id 221

@desc {

	This instruction subtracts an optionally-shifted register value from the SP value, and writes the result to the destination register.

}

@encoding (T1) {

	@word 1 1 1 0 1 0 1 1 1 0 1 S(1) 1 1 0 1 0 imm3(3) Rd(4) imm2(2) type(2) Rm(4)

	@syntax {

		@subid 699

		@assert {

			S == 0

		}

		@conv {

			reg_D = Register(Rd)
			reg_SP = Register(13)
			reg_M = Register(Rm)
			shift = DecodeImmShift(type, imm3:imm2)

		}

		@asm sub ?reg_D reg_SP reg_M ?shift

	}

	@syntax {

		@subid 700

		@assert {

			S == 1

		}

		@conv {

			reg_D = Register(Rd)
			reg_SP = Register(13)
			reg_M = Register(Rm)
			shift = DecodeImmShift(type, imm3:imm2)

		}

		@asm subs ?reg_D reg_SP reg_M ?shift

	}

}

@encoding (A1) {

	@word cond(4) 0 0 0 0 0 1 0 S(1) 1 1 0 1 Rd(4) imm5(5) type(2) 0 Rm(4)

	@syntax {

		@subid 701

		@assert {

			S == 0

		}

		@conv {

			reg_D = Register(Rd)
			reg_SP = Register(13)
			reg_M = Register(Rm)
			shift = DecodeImmShift(type, imm5)

		}

		@asm sub ?reg_D reg_SP reg_M ?shift

		@rules {

			check g_arm_instruction_set_cond(cond)

		}

	}

	@syntax {

		@subid 702

		@assert {

			S == 1

		}

		@conv {

			reg_D = Register(Rd)
			reg_SP = Register(13)
			reg_M = Register(Rm)
			shift = DecodeImmShift(type, imm5)

		}

		@asm subs ?reg_D reg_SP reg_M ?shift

		@rules {

			check g_arm_instruction_set_cond(cond)

		}

	}

}

