# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    import __init__ as _models


class Resource(msrest.serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class AlertRuleResource(Resource):
    """The alert rule resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar name_properties_name: Required. the name of the alert rule.
    :vartype name_properties_name: str
    :ivar description: the description of the alert rule that will be included in the alert email.
    :vartype description: str
    :ivar provisioning_state: the provisioning state.
    :vartype provisioning_state: str
    :ivar is_enabled: Required. the flag that indicates whether the alert rule is enabled.
    :vartype is_enabled: bool
    :ivar condition: Required. the condition that results in the alert rule being activated.
    :vartype condition: ~$(python-base-namespace).v2015_04_01.models.RuleCondition
    :ivar action: action that is performed when the alert rule becomes active, and when an alert
     condition is resolved.
    :vartype action: ~$(python-base-namespace).v2015_04_01.models.RuleAction
    :ivar actions: the array of actions that are performed when the alert rule becomes active, and
     when an alert condition is resolved.
    :vartype actions: list[~$(python-base-namespace).v2015_04_01.models.RuleAction]
    :ivar last_updated_time: Last time the rule was updated in ISO8601 format.
    :vartype last_updated_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'name_properties_name': {'required': True},
        'is_enabled': {'required': True},
        'condition': {'required': True},
        'last_updated_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
        'condition': {'key': 'properties.condition', 'type': 'RuleCondition'},
        'action': {'key': 'properties.action', 'type': 'RuleAction'},
        'actions': {'key': 'properties.actions', 'type': '[RuleAction]'},
        'last_updated_time': {'key': 'properties.lastUpdatedTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        location: str,
        name_properties_name: str,
        is_enabled: bool,
        condition: "_models.RuleCondition",
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        action: Optional["_models.RuleAction"] = None,
        actions: Optional[List["_models.RuleAction"]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword name_properties_name: Required. the name of the alert rule.
        :paramtype name_properties_name: str
        :keyword description: the description of the alert rule that will be included in the alert
         email.
        :paramtype description: str
        :keyword provisioning_state: the provisioning state.
        :paramtype provisioning_state: str
        :keyword is_enabled: Required. the flag that indicates whether the alert rule is enabled.
        :paramtype is_enabled: bool
        :keyword condition: Required. the condition that results in the alert rule being activated.
        :paramtype condition: ~$(python-base-namespace).v2015_04_01.models.RuleCondition
        :keyword action: action that is performed when the alert rule becomes active, and when an alert
         condition is resolved.
        :paramtype action: ~$(python-base-namespace).v2015_04_01.models.RuleAction
        :keyword actions: the array of actions that are performed when the alert rule becomes active,
         and when an alert condition is resolved.
        :paramtype actions: list[~$(python-base-namespace).v2015_04_01.models.RuleAction]
        """
        super(AlertRuleResource, self).__init__(location=location, tags=tags, **kwargs)
        self.name_properties_name = name_properties_name
        self.description = description
        self.provisioning_state = provisioning_state
        self.is_enabled = is_enabled
        self.condition = condition
        self.action = action
        self.actions = actions
        self.last_updated_time = None


class AlertRuleResourceCollection(msrest.serialization.Model):
    """Represents a collection of alert rule resources.

    :ivar value: the values for the alert rule resources.
    :vartype value: list[~$(python-base-namespace).v2015_04_01.models.AlertRuleResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AlertRuleResource]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.AlertRuleResource"]] = None,
        **kwargs
    ):
        """
        :keyword value: the values for the alert rule resources.
        :paramtype value: list[~$(python-base-namespace).v2015_04_01.models.AlertRuleResource]
        """
        super(AlertRuleResourceCollection, self).__init__(**kwargs)
        self.value = value


class AlertRuleResourcePatch(msrest.serialization.Model):
    """The alert rule object for patch operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar name: the name of the alert rule.
    :vartype name: str
    :ivar description: the description of the alert rule that will be included in the alert email.
    :vartype description: str
    :ivar provisioning_state: the provisioning state.
    :vartype provisioning_state: str
    :ivar is_enabled: the flag that indicates whether the alert rule is enabled.
    :vartype is_enabled: bool
    :ivar condition: the condition that results in the alert rule being activated.
    :vartype condition: ~$(python-base-namespace).v2015_04_01.models.RuleCondition
    :ivar action: action that is performed when the alert rule becomes active, and when an alert
     condition is resolved.
    :vartype action: ~$(python-base-namespace).v2015_04_01.models.RuleAction
    :ivar actions: the array of actions that are performed when the alert rule becomes active, and
     when an alert condition is resolved.
    :vartype actions: list[~$(python-base-namespace).v2015_04_01.models.RuleAction]
    :ivar last_updated_time: Last time the rule was updated in ISO8601 format.
    :vartype last_updated_time: ~datetime.datetime
    """

    _validation = {
        'last_updated_time': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'name': {'key': 'properties.name', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
        'condition': {'key': 'properties.condition', 'type': 'RuleCondition'},
        'action': {'key': 'properties.action', 'type': 'RuleAction'},
        'actions': {'key': 'properties.actions', 'type': '[RuleAction]'},
        'last_updated_time': {'key': 'properties.lastUpdatedTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        is_enabled: Optional[bool] = None,
        condition: Optional["_models.RuleCondition"] = None,
        action: Optional["_models.RuleAction"] = None,
        actions: Optional[List["_models.RuleAction"]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword name: the name of the alert rule.
        :paramtype name: str
        :keyword description: the description of the alert rule that will be included in the alert
         email.
        :paramtype description: str
        :keyword provisioning_state: the provisioning state.
        :paramtype provisioning_state: str
        :keyword is_enabled: the flag that indicates whether the alert rule is enabled.
        :paramtype is_enabled: bool
        :keyword condition: the condition that results in the alert rule being activated.
        :paramtype condition: ~$(python-base-namespace).v2015_04_01.models.RuleCondition
        :keyword action: action that is performed when the alert rule becomes active, and when an alert
         condition is resolved.
        :paramtype action: ~$(python-base-namespace).v2015_04_01.models.RuleAction
        :keyword actions: the array of actions that are performed when the alert rule becomes active,
         and when an alert condition is resolved.
        :paramtype actions: list[~$(python-base-namespace).v2015_04_01.models.RuleAction]
        """
        super(AlertRuleResourcePatch, self).__init__(**kwargs)
        self.tags = tags
        self.name = name
        self.description = description
        self.provisioning_state = provisioning_state
        self.is_enabled = is_enabled
        self.condition = condition
        self.action = action
        self.actions = actions
        self.last_updated_time = None


class AutoscaleNotification(msrest.serialization.Model):
    """Autoscale notification.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar operation: the operation associated with the notification and its value must be "scale".
     Has constant value: "Scale".
    :vartype operation: str
    :ivar email: the email notification.
    :vartype email: ~$(python-base-namespace).v2015_04_01.models.EmailNotification
    :ivar webhooks: the collection of webhook notifications.
    :vartype webhooks: list[~$(python-base-namespace).v2015_04_01.models.WebhookNotification]
    """

    _validation = {
        'operation': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'operation': {'key': 'operation', 'type': 'str'},
        'email': {'key': 'email', 'type': 'EmailNotification'},
        'webhooks': {'key': 'webhooks', 'type': '[WebhookNotification]'},
    }

    operation = "Scale"

    def __init__(
        self,
        *,
        email: Optional["_models.EmailNotification"] = None,
        webhooks: Optional[List["_models.WebhookNotification"]] = None,
        **kwargs
    ):
        """
        :keyword email: the email notification.
        :paramtype email: ~$(python-base-namespace).v2015_04_01.models.EmailNotification
        :keyword webhooks: the collection of webhook notifications.
        :paramtype webhooks: list[~$(python-base-namespace).v2015_04_01.models.WebhookNotification]
        """
        super(AutoscaleNotification, self).__init__(**kwargs)
        self.email = email
        self.webhooks = webhooks


class AutoscaleProfile(msrest.serialization.Model):
    """Autoscale profile.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. the name of the profile.
    :vartype name: str
    :ivar capacity: Required. the number of instances that can be used during this profile.
    :vartype capacity: ~$(python-base-namespace).v2015_04_01.models.ScaleCapacity
    :ivar rules: Required. the collection of rules that provide the triggers and parameters for the
     scaling action. A maximum of 10 rules can be specified.
    :vartype rules: list[~$(python-base-namespace).v2015_04_01.models.ScaleRule]
    :ivar fixed_date: the specific date-time for the profile. This element is not used if the
     Recurrence element is used.
    :vartype fixed_date: ~$(python-base-namespace).v2015_04_01.models.TimeWindow
    :ivar recurrence: the repeating times at which this profile begins. This element is not used if
     the FixedDate element is used.
    :vartype recurrence: ~$(python-base-namespace).v2015_04_01.models.Recurrence
    """

    _validation = {
        'name': {'required': True},
        'capacity': {'required': True},
        'rules': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'ScaleCapacity'},
        'rules': {'key': 'rules', 'type': '[ScaleRule]'},
        'fixed_date': {'key': 'fixedDate', 'type': 'TimeWindow'},
        'recurrence': {'key': 'recurrence', 'type': 'Recurrence'},
    }

    def __init__(
        self,
        *,
        name: str,
        capacity: "_models.ScaleCapacity",
        rules: List["_models.ScaleRule"],
        fixed_date: Optional["_models.TimeWindow"] = None,
        recurrence: Optional["_models.Recurrence"] = None,
        **kwargs
    ):
        """
        :keyword name: Required. the name of the profile.
        :paramtype name: str
        :keyword capacity: Required. the number of instances that can be used during this profile.
        :paramtype capacity: ~$(python-base-namespace).v2015_04_01.models.ScaleCapacity
        :keyword rules: Required. the collection of rules that provide the triggers and parameters for
         the scaling action. A maximum of 10 rules can be specified.
        :paramtype rules: list[~$(python-base-namespace).v2015_04_01.models.ScaleRule]
        :keyword fixed_date: the specific date-time for the profile. This element is not used if the
         Recurrence element is used.
        :paramtype fixed_date: ~$(python-base-namespace).v2015_04_01.models.TimeWindow
        :keyword recurrence: the repeating times at which this profile begins. This element is not used
         if the FixedDate element is used.
        :paramtype recurrence: ~$(python-base-namespace).v2015_04_01.models.Recurrence
        """
        super(AutoscaleProfile, self).__init__(**kwargs)
        self.name = name
        self.capacity = capacity
        self.rules = rules
        self.fixed_date = fixed_date
        self.recurrence = recurrence


class AutoscaleSettingResource(Resource):
    """The autoscale setting resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar profiles: Required. the collection of automatic scaling profiles that specify different
     scaling parameters for different time periods. A maximum of 20 profiles can be specified.
    :vartype profiles: list[~$(python-base-namespace).v2015_04_01.models.AutoscaleProfile]
    :ivar notifications: the collection of notifications.
    :vartype notifications:
     list[~$(python-base-namespace).v2015_04_01.models.AutoscaleNotification]
    :ivar enabled: the enabled flag. Specifies whether automatic scaling is enabled for the
     resource. The default value is 'false'.
    :vartype enabled: bool
    :ivar name_properties_name: the name of the autoscale setting.
    :vartype name_properties_name: str
    :ivar target_resource_uri: the resource identifier of the resource that the autoscale setting
     should be added to.
    :vartype target_resource_uri: str
    :ivar target_resource_location: the location of the resource that the autoscale setting should
     be added to.
    :vartype target_resource_location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'profiles': {'required': True, 'max_items': 20, 'min_items': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'profiles': {'key': 'properties.profiles', 'type': '[AutoscaleProfile]'},
        'notifications': {'key': 'properties.notifications', 'type': '[AutoscaleNotification]'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'target_resource_uri': {'key': 'properties.targetResourceUri', 'type': 'str'},
        'target_resource_location': {'key': 'properties.targetResourceLocation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        profiles: List["_models.AutoscaleProfile"],
        tags: Optional[Dict[str, str]] = None,
        notifications: Optional[List["_models.AutoscaleNotification"]] = None,
        enabled: Optional[bool] = False,
        name_properties_name: Optional[str] = None,
        target_resource_uri: Optional[str] = None,
        target_resource_location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword profiles: Required. the collection of automatic scaling profiles that specify
         different scaling parameters for different time periods. A maximum of 20 profiles can be
         specified.
        :paramtype profiles: list[~$(python-base-namespace).v2015_04_01.models.AutoscaleProfile]
        :keyword notifications: the collection of notifications.
        :paramtype notifications:
         list[~$(python-base-namespace).v2015_04_01.models.AutoscaleNotification]
        :keyword enabled: the enabled flag. Specifies whether automatic scaling is enabled for the
         resource. The default value is 'false'.
        :paramtype enabled: bool
        :keyword name_properties_name: the name of the autoscale setting.
        :paramtype name_properties_name: str
        :keyword target_resource_uri: the resource identifier of the resource that the autoscale
         setting should be added to.
        :paramtype target_resource_uri: str
        :keyword target_resource_location: the location of the resource that the autoscale setting
         should be added to.
        :paramtype target_resource_location: str
        """
        super(AutoscaleSettingResource, self).__init__(location=location, tags=tags, **kwargs)
        self.profiles = profiles
        self.notifications = notifications
        self.enabled = enabled
        self.name_properties_name = name_properties_name
        self.target_resource_uri = target_resource_uri
        self.target_resource_location = target_resource_location


class AutoscaleSettingResourceCollection(msrest.serialization.Model):
    """Represents a collection of autoscale setting resources.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. the values for the autoscale setting resources.
    :vartype value: list[~$(python-base-namespace).v2015_04_01.models.AutoscaleSettingResource]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AutoscaleSettingResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.AutoscaleSettingResource"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. the values for the autoscale setting resources.
        :paramtype value: list[~$(python-base-namespace).v2015_04_01.models.AutoscaleSettingResource]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super(AutoscaleSettingResourceCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AutoscaleSettingResourcePatch(msrest.serialization.Model):
    """The autoscale setting object for patch operations.

    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar profiles: the collection of automatic scaling profiles that specify different scaling
     parameters for different time periods. A maximum of 20 profiles can be specified.
    :vartype profiles: list[~$(python-base-namespace).v2015_04_01.models.AutoscaleProfile]
    :ivar notifications: the collection of notifications.
    :vartype notifications:
     list[~$(python-base-namespace).v2015_04_01.models.AutoscaleNotification]
    :ivar enabled: the enabled flag. Specifies whether automatic scaling is enabled for the
     resource. The default value is 'false'.
    :vartype enabled: bool
    :ivar name: the name of the autoscale setting.
    :vartype name: str
    :ivar target_resource_uri: the resource identifier of the resource that the autoscale setting
     should be added to.
    :vartype target_resource_uri: str
    :ivar target_resource_location: the location of the resource that the autoscale setting should
     be added to.
    :vartype target_resource_location: str
    """

    _validation = {
        'profiles': {'max_items': 20, 'min_items': 0},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'profiles': {'key': 'properties.profiles', 'type': '[AutoscaleProfile]'},
        'notifications': {'key': 'properties.notifications', 'type': '[AutoscaleNotification]'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'name': {'key': 'properties.name', 'type': 'str'},
        'target_resource_uri': {'key': 'properties.targetResourceUri', 'type': 'str'},
        'target_resource_location': {'key': 'properties.targetResourceLocation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        profiles: Optional[List["_models.AutoscaleProfile"]] = None,
        notifications: Optional[List["_models.AutoscaleNotification"]] = None,
        enabled: Optional[bool] = False,
        name: Optional[str] = None,
        target_resource_uri: Optional[str] = None,
        target_resource_location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword profiles: the collection of automatic scaling profiles that specify different scaling
         parameters for different time periods. A maximum of 20 profiles can be specified.
        :paramtype profiles: list[~$(python-base-namespace).v2015_04_01.models.AutoscaleProfile]
        :keyword notifications: the collection of notifications.
        :paramtype notifications:
         list[~$(python-base-namespace).v2015_04_01.models.AutoscaleNotification]
        :keyword enabled: the enabled flag. Specifies whether automatic scaling is enabled for the
         resource. The default value is 'false'.
        :paramtype enabled: bool
        :keyword name: the name of the autoscale setting.
        :paramtype name: str
        :keyword target_resource_uri: the resource identifier of the resource that the autoscale
         setting should be added to.
        :paramtype target_resource_uri: str
        :keyword target_resource_location: the location of the resource that the autoscale setting
         should be added to.
        :paramtype target_resource_location: str
        """
        super(AutoscaleSettingResourcePatch, self).__init__(**kwargs)
        self.tags = tags
        self.profiles = profiles
        self.notifications = notifications
        self.enabled = enabled
        self.name = name
        self.target_resource_uri = target_resource_uri
        self.target_resource_location = target_resource_location


class EmailNotification(msrest.serialization.Model):
    """Email notification of an autoscale event.

    :ivar send_to_subscription_administrator: a value indicating whether to send email to
     subscription administrator.
    :vartype send_to_subscription_administrator: bool
    :ivar send_to_subscription_co_administrators: a value indicating whether to send email to
     subscription co-administrators.
    :vartype send_to_subscription_co_administrators: bool
    :ivar custom_emails: the custom e-mails list. This value can be null or empty, in which case
     this attribute will be ignored.
    :vartype custom_emails: list[str]
    """

    _attribute_map = {
        'send_to_subscription_administrator': {'key': 'sendToSubscriptionAdministrator', 'type': 'bool'},
        'send_to_subscription_co_administrators': {'key': 'sendToSubscriptionCoAdministrators', 'type': 'bool'},
        'custom_emails': {'key': 'customEmails', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        send_to_subscription_administrator: Optional[bool] = False,
        send_to_subscription_co_administrators: Optional[bool] = False,
        custom_emails: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword send_to_subscription_administrator: a value indicating whether to send email to
         subscription administrator.
        :paramtype send_to_subscription_administrator: bool
        :keyword send_to_subscription_co_administrators: a value indicating whether to send email to
         subscription co-administrators.
        :paramtype send_to_subscription_co_administrators: bool
        :keyword custom_emails: the custom e-mails list. This value can be null or empty, in which case
         this attribute will be ignored.
        :paramtype custom_emails: list[str]
        """
        super(EmailNotification, self).__init__(**kwargs)
        self.send_to_subscription_administrator = send_to_subscription_administrator
        self.send_to_subscription_co_administrators = send_to_subscription_co_administrators
        self.custom_emails = custom_emails


class ErrorResponse(msrest.serialization.Model):
    """Describes the format of Error response.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message indicating why the operation failed.
        :paramtype message: str
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class EventCategoryCollection(msrest.serialization.Model):
    """A collection of event categories. Currently possible values are: Administrative, Security, ServiceHealth, Alert, Recommendation, Policy.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. the list that includes the Azure event categories.
    :vartype value: list[~$(python-base-namespace).v2015_04_01.models.LocalizableString]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LocalizableString]'},
    }

    def __init__(
        self,
        *,
        value: List["_models.LocalizableString"],
        **kwargs
    ):
        """
        :keyword value: Required. the list that includes the Azure event categories.
        :paramtype value: list[~$(python-base-namespace).v2015_04_01.models.LocalizableString]
        """
        super(EventCategoryCollection, self).__init__(**kwargs)
        self.value = value


class EventData(msrest.serialization.Model):
    """The Azure event log entries are of type EventData.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar authorization: The sender authorization information.
    :vartype authorization: ~$(python-base-namespace).v2015_04_01.models.SenderAuthorization
    :ivar claims: key value pairs to identify ARM permissions.
    :vartype claims: dict[str, str]
    :ivar caller: the email address of the user who has performed the operation, the UPN claim or
     SPN claim based on availability.
    :vartype caller: str
    :ivar description: the description of the event.
    :vartype description: str
    :ivar id: the Id of this event as required by ARM for RBAC. It contains the EventDataID and a
     timestamp information.
    :vartype id: str
    :ivar event_data_id: the event data Id. This is a unique identifier for an event.
    :vartype event_data_id: str
    :ivar correlation_id: the correlation Id, usually a GUID in the string format. The correlation
     Id is shared among the events that belong to the same uber operation.
    :vartype correlation_id: str
    :ivar event_name: the event name. This value should not be confused with OperationName. For
     practical purposes, OperationName might be more appealing to end users.
    :vartype event_name: ~$(python-base-namespace).v2015_04_01.models.LocalizableString
    :ivar category: the event category.
    :vartype category: ~$(python-base-namespace).v2015_04_01.models.LocalizableString
    :ivar http_request: the HTTP request info. Usually includes the 'clientRequestId',
     'clientIpAddress' (IP address of the user who initiated the event) and 'method' (HTTP method
     e.g. PUT).
    :vartype http_request: ~$(python-base-namespace).v2015_04_01.models.HttpRequestInfo
    :ivar level: the event level. Known values are: "Critical", "Error", "Warning",
     "Informational", "Verbose".
    :vartype level: str or ~$(python-base-namespace).v2015_04_01.models.EventLevel
    :ivar resource_group_name: the resource group name of the impacted resource.
    :vartype resource_group_name: str
    :ivar resource_provider_name: the resource provider name of the impacted resource.
    :vartype resource_provider_name: ~$(python-base-namespace).v2015_04_01.models.LocalizableString
    :ivar resource_id: the resource uri that uniquely identifies the resource that caused this
     event.
    :vartype resource_id: str
    :ivar resource_type: the resource type.
    :vartype resource_type: ~$(python-base-namespace).v2015_04_01.models.LocalizableString
    :ivar operation_id: It is usually a GUID shared among the events corresponding to single
     operation. This value should not be confused with EventName.
    :vartype operation_id: str
    :ivar operation_name: the operation name.
    :vartype operation_name: ~$(python-base-namespace).v2015_04_01.models.LocalizableString
    :ivar properties: the set of <Key, Value> pairs (usually a Dictionary<String, String>) that
     includes details about the event.
    :vartype properties: dict[str, str]
    :ivar status: a string describing the status of the operation. Some typical values are:
     Started, In progress, Succeeded, Failed, Resolved.
    :vartype status: ~$(python-base-namespace).v2015_04_01.models.LocalizableString
    :ivar sub_status: the event sub status. Most of the time, when included, this captures the HTTP
     status code of the REST call. Common values are: OK (HTTP Status Code: 200), Created (HTTP
     Status Code: 201), Accepted (HTTP Status Code: 202), No Content (HTTP Status Code: 204), Bad
     Request(HTTP Status Code: 400), Not Found (HTTP Status Code: 404), Conflict (HTTP Status Code:
     409), Internal Server Error (HTTP Status Code: 500), Service Unavailable (HTTP Status
     Code:503), Gateway Timeout (HTTP Status Code: 504).
    :vartype sub_status: ~$(python-base-namespace).v2015_04_01.models.LocalizableString
    :ivar event_timestamp: the timestamp of when the event was generated by the Azure service
     processing the request corresponding the event. It in ISO 8601 format.
    :vartype event_timestamp: ~datetime.datetime
    :ivar submission_timestamp: the timestamp of when the event became available for querying via
     this API. It is in ISO 8601 format. This value should not be confused eventTimestamp. As there
     might be a delay between the occurrence time of the event, and the time that the event is
     submitted to the Azure logging infrastructure.
    :vartype submission_timestamp: ~datetime.datetime
    :ivar subscription_id: the Azure subscription Id usually a GUID.
    :vartype subscription_id: str
    :ivar tenant_id: the Azure tenant Id.
    :vartype tenant_id: str
    """

    _validation = {
        'authorization': {'readonly': True},
        'claims': {'readonly': True},
        'caller': {'readonly': True},
        'description': {'readonly': True},
        'id': {'readonly': True},
        'event_data_id': {'readonly': True},
        'correlation_id': {'readonly': True},
        'event_name': {'readonly': True},
        'category': {'readonly': True},
        'http_request': {'readonly': True},
        'level': {'readonly': True},
        'resource_group_name': {'readonly': True},
        'resource_provider_name': {'readonly': True},
        'resource_id': {'readonly': True},
        'resource_type': {'readonly': True},
        'operation_id': {'readonly': True},
        'operation_name': {'readonly': True},
        'properties': {'readonly': True},
        'status': {'readonly': True},
        'sub_status': {'readonly': True},
        'event_timestamp': {'readonly': True},
        'submission_timestamp': {'readonly': True},
        'subscription_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'authorization': {'key': 'authorization', 'type': 'SenderAuthorization'},
        'claims': {'key': 'claims', 'type': '{str}'},
        'caller': {'key': 'caller', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'event_data_id': {'key': 'eventDataId', 'type': 'str'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'event_name': {'key': 'eventName', 'type': 'LocalizableString'},
        'category': {'key': 'category', 'type': 'LocalizableString'},
        'http_request': {'key': 'httpRequest', 'type': 'HttpRequestInfo'},
        'level': {'key': 'level', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'resource_provider_name': {'key': 'resourceProviderName', 'type': 'LocalizableString'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'LocalizableString'},
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'operation_name': {'key': 'operationName', 'type': 'LocalizableString'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'status': {'key': 'status', 'type': 'LocalizableString'},
        'sub_status': {'key': 'subStatus', 'type': 'LocalizableString'},
        'event_timestamp': {'key': 'eventTimestamp', 'type': 'iso-8601'},
        'submission_timestamp': {'key': 'submissionTimestamp', 'type': 'iso-8601'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(EventData, self).__init__(**kwargs)
        self.authorization = None
        self.claims = None
        self.caller = None
        self.description = None
        self.id = None
        self.event_data_id = None
        self.correlation_id = None
        self.event_name = None
        self.category = None
        self.http_request = None
        self.level = None
        self.resource_group_name = None
        self.resource_provider_name = None
        self.resource_id = None
        self.resource_type = None
        self.operation_id = None
        self.operation_name = None
        self.properties = None
        self.status = None
        self.sub_status = None
        self.event_timestamp = None
        self.submission_timestamp = None
        self.subscription_id = None
        self.tenant_id = None


class EventDataCollection(msrest.serialization.Model):
    """Represents collection of events.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. this list that includes the Azure audit logs.
    :vartype value: list[~$(python-base-namespace).v2015_04_01.models.EventData]
    :ivar next_link: Provides the link to retrieve the next set of events.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EventData]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.EventData"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. this list that includes the Azure audit logs.
        :paramtype value: list[~$(python-base-namespace).v2015_04_01.models.EventData]
        :keyword next_link: Provides the link to retrieve the next set of events.
        :paramtype next_link: str
        """
        super(EventDataCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class HttpRequestInfo(msrest.serialization.Model):
    """The Http request info.

    :ivar client_request_id: the client request id.
    :vartype client_request_id: str
    :ivar client_ip_address: the client Ip Address.
    :vartype client_ip_address: str
    :ivar method: the Http request method.
    :vartype method: str
    :ivar uri: the Uri.
    :vartype uri: str
    """

    _attribute_map = {
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'client_ip_address': {'key': 'clientIpAddress', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_request_id: Optional[str] = None,
        client_ip_address: Optional[str] = None,
        method: Optional[str] = None,
        uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword client_request_id: the client request id.
        :paramtype client_request_id: str
        :keyword client_ip_address: the client Ip Address.
        :paramtype client_ip_address: str
        :keyword method: the Http request method.
        :paramtype method: str
        :keyword uri: the Uri.
        :paramtype uri: str
        """
        super(HttpRequestInfo, self).__init__(**kwargs)
        self.client_request_id = client_request_id
        self.client_ip_address = client_ip_address
        self.method = method
        self.uri = uri


class LocalizableString(msrest.serialization.Model):
    """The localizable string class.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. the invariant value.
    :vartype value: str
    :ivar localized_value: the locale specific value.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: str,
        localized_value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. the invariant value.
        :paramtype value: str
        :keyword localized_value: the locale specific value.
        :paramtype localized_value: str
        """
        super(LocalizableString, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class RuleCondition(msrest.serialization.Model):
    """The condition that results in the alert rule being activated.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: LocationThresholdRuleCondition, ManagementEventRuleCondition, ThresholdRuleCondition.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. specifies the type of condition. This can be one of three types:
     ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition
     (based on the number of failures of a web test), and ThresholdRuleCondition (based on the
     threshold of a metric).Constant filled by server.
    :vartype odata_type: str
    :ivar data_source: the resource from which the rule collects its data. For this type dataSource
     will always be of type RuleMetricDataSource.
    :vartype data_source: ~$(python-base-namespace).v2015_04_01.models.RuleDataSource
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'data_source': {'key': 'dataSource', 'type': 'RuleDataSource'},
    }

    _subtype_map = {
        'odata_type': {'Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition': 'LocationThresholdRuleCondition', 'Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition': 'ManagementEventRuleCondition', 'Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition': 'ThresholdRuleCondition'}
    }

    def __init__(
        self,
        *,
        data_source: Optional["_models.RuleDataSource"] = None,
        **kwargs
    ):
        """
        :keyword data_source: the resource from which the rule collects its data. For this type
         dataSource will always be of type RuleMetricDataSource.
        :paramtype data_source: ~$(python-base-namespace).v2015_04_01.models.RuleDataSource
        """
        super(RuleCondition, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.data_source = data_source


class LocationThresholdRuleCondition(RuleCondition):
    """A rule condition based on a certain number of locations failing.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. specifies the type of condition. This can be one of three types:
     ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition
     (based on the number of failures of a web test), and ThresholdRuleCondition (based on the
     threshold of a metric).Constant filled by server.
    :vartype odata_type: str
    :ivar data_source: the resource from which the rule collects its data. For this type dataSource
     will always be of type RuleMetricDataSource.
    :vartype data_source: ~$(python-base-namespace).v2015_04_01.models.RuleDataSource
    :ivar window_size: the period of time (in ISO 8601 duration format) that is used to monitor
     alert activity based on the threshold. If specified then it must be between 5 minutes and 1
     day.
    :vartype window_size: ~datetime.timedelta
    :ivar failed_location_count: Required. the number of locations that must fail to activate the
     alert.
    :vartype failed_location_count: int
    """

    _validation = {
        'odata_type': {'required': True},
        'failed_location_count': {'required': True, 'minimum': 0},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'data_source': {'key': 'dataSource', 'type': 'RuleDataSource'},
        'window_size': {'key': 'windowSize', 'type': 'duration'},
        'failed_location_count': {'key': 'failedLocationCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        failed_location_count: int,
        data_source: Optional["_models.RuleDataSource"] = None,
        window_size: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        """
        :keyword data_source: the resource from which the rule collects its data. For this type
         dataSource will always be of type RuleMetricDataSource.
        :paramtype data_source: ~$(python-base-namespace).v2015_04_01.models.RuleDataSource
        :keyword window_size: the period of time (in ISO 8601 duration format) that is used to monitor
         alert activity based on the threshold. If specified then it must be between 5 minutes and 1
         day.
        :paramtype window_size: ~datetime.timedelta
        :keyword failed_location_count: Required. the number of locations that must fail to activate
         the alert.
        :paramtype failed_location_count: int
        """
        super(LocationThresholdRuleCondition, self).__init__(data_source=data_source, **kwargs)
        self.odata_type = 'Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition'  # type: str
        self.window_size = window_size
        self.failed_location_count = failed_location_count


class ManagementEventAggregationCondition(msrest.serialization.Model):
    """How the data that is collected should be combined over time.

    :ivar operator: the condition operator. Known values are: "GreaterThan", "GreaterThanOrEqual",
     "LessThan", "LessThanOrEqual".
    :vartype operator: str or ~$(python-base-namespace).v2015_04_01.models.ConditionOperator
    :ivar threshold: The threshold value that activates the alert.
    :vartype threshold: float
    :ivar window_size: the period of time (in ISO 8601 duration format) that is used to monitor
     alert activity based on the threshold. If specified then it must be between 5 minutes and 1
     day.
    :vartype window_size: ~datetime.timedelta
    """

    _attribute_map = {
        'operator': {'key': 'operator', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'float'},
        'window_size': {'key': 'windowSize', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        operator: Optional[Union[str, "_models.ConditionOperator"]] = None,
        threshold: Optional[float] = None,
        window_size: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        """
        :keyword operator: the condition operator. Known values are: "GreaterThan",
         "GreaterThanOrEqual", "LessThan", "LessThanOrEqual".
        :paramtype operator: str or ~$(python-base-namespace).v2015_04_01.models.ConditionOperator
        :keyword threshold: The threshold value that activates the alert.
        :paramtype threshold: float
        :keyword window_size: the period of time (in ISO 8601 duration format) that is used to monitor
         alert activity based on the threshold. If specified then it must be between 5 minutes and 1
         day.
        :paramtype window_size: ~datetime.timedelta
        """
        super(ManagementEventAggregationCondition, self).__init__(**kwargs)
        self.operator = operator
        self.threshold = threshold
        self.window_size = window_size


class ManagementEventRuleCondition(RuleCondition):
    """A management event rule condition.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. specifies the type of condition. This can be one of three types:
     ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition
     (based on the number of failures of a web test), and ThresholdRuleCondition (based on the
     threshold of a metric).Constant filled by server.
    :vartype odata_type: str
    :ivar data_source: the resource from which the rule collects its data. For this type dataSource
     will always be of type RuleMetricDataSource.
    :vartype data_source: ~$(python-base-namespace).v2015_04_01.models.RuleDataSource
    :ivar aggregation: How the data that is collected should be combined over time and when the
     alert is activated. Note that for management event alerts aggregation is optional – if it is
     not provided then any event will cause the alert to activate.
    :vartype aggregation:
     ~$(python-base-namespace).v2015_04_01.models.ManagementEventAggregationCondition
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'data_source': {'key': 'dataSource', 'type': 'RuleDataSource'},
        'aggregation': {'key': 'aggregation', 'type': 'ManagementEventAggregationCondition'},
    }

    def __init__(
        self,
        *,
        data_source: Optional["_models.RuleDataSource"] = None,
        aggregation: Optional["_models.ManagementEventAggregationCondition"] = None,
        **kwargs
    ):
        """
        :keyword data_source: the resource from which the rule collects its data. For this type
         dataSource will always be of type RuleMetricDataSource.
        :paramtype data_source: ~$(python-base-namespace).v2015_04_01.models.RuleDataSource
        :keyword aggregation: How the data that is collected should be combined over time and when the
         alert is activated. Note that for management event alerts aggregation is optional – if it is
         not provided then any event will cause the alert to activate.
        :paramtype aggregation:
         ~$(python-base-namespace).v2015_04_01.models.ManagementEventAggregationCondition
        """
        super(ManagementEventRuleCondition, self).__init__(data_source=data_source, **kwargs)
        self.odata_type = 'Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition'  # type: str
        self.aggregation = aggregation


class MetricTrigger(msrest.serialization.Model):
    """The trigger that results in a scaling action.

    All required parameters must be populated in order to send to Azure.

    :ivar metric_name: Required. the name of the metric that defines what the rule monitors.
    :vartype metric_name: str
    :ivar metric_namespace: the namespace of the metric that defines what the rule monitors.
    :vartype metric_namespace: str
    :ivar metric_resource_uri: Required. the resource identifier of the resource the rule monitors.
    :vartype metric_resource_uri: str
    :ivar metric_resource_location: the location of the resource the rule monitors.
    :vartype metric_resource_location: str
    :ivar time_grain: Required. the granularity of metrics the rule monitors. Must be one of the
     predefined values returned from metric definitions for the metric. Must be between 12 hours and
     1 minute.
    :vartype time_grain: ~datetime.timedelta
    :ivar statistic: Required. the metric statistic type. How the metrics from multiple instances
     are combined. Known values are: "Average", "Min", "Max", "Sum", "Count".
    :vartype statistic: str or ~$(python-base-namespace).v2015_04_01.models.MetricStatisticType
    :ivar time_window: Required. the range of time in which instance data is collected. This value
     must be greater than the delay in metric collection, which can vary from resource-to-resource.
     Must be between 12 hours and 5 minutes.
    :vartype time_window: ~datetime.timedelta
    :ivar time_aggregation: Required. time aggregation type. How the data that is collected should
     be combined over time. The default value is Average. Known values are: "Average", "Minimum",
     "Maximum", "Total", "Count", "Last".
    :vartype time_aggregation: str or
     ~$(python-base-namespace).v2015_04_01.models.TimeAggregationType
    :ivar operator: Required. the operator that is used to compare the metric data and the
     threshold. Known values are: "Equals", "NotEquals", "GreaterThan", "GreaterThanOrEqual",
     "LessThan", "LessThanOrEqual".
    :vartype operator: str or ~$(python-base-namespace).v2015_04_01.models.ComparisonOperationType
    :ivar threshold: Required. the threshold of the metric that triggers the scale action.
    :vartype threshold: float
    :ivar dimensions: List of dimension conditions. For example:
     [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
    :vartype dimensions:
     list[~$(python-base-namespace).v2015_04_01.models.ScaleRuleMetricDimension]
    :ivar divide_per_instance: a value indicating whether metric should divide per instance.
    :vartype divide_per_instance: bool
    """

    _validation = {
        'metric_name': {'required': True},
        'metric_resource_uri': {'required': True},
        'time_grain': {'required': True},
        'statistic': {'required': True},
        'time_window': {'required': True},
        'time_aggregation': {'required': True},
        'operator': {'required': True},
        'threshold': {'required': True},
    }

    _attribute_map = {
        'metric_name': {'key': 'metricName', 'type': 'str'},
        'metric_namespace': {'key': 'metricNamespace', 'type': 'str'},
        'metric_resource_uri': {'key': 'metricResourceUri', 'type': 'str'},
        'metric_resource_location': {'key': 'metricResourceLocation', 'type': 'str'},
        'time_grain': {'key': 'timeGrain', 'type': 'duration'},
        'statistic': {'key': 'statistic', 'type': 'str'},
        'time_window': {'key': 'timeWindow', 'type': 'duration'},
        'time_aggregation': {'key': 'timeAggregation', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'float'},
        'dimensions': {'key': 'dimensions', 'type': '[ScaleRuleMetricDimension]'},
        'divide_per_instance': {'key': 'dividePerInstance', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        metric_name: str,
        metric_resource_uri: str,
        time_grain: datetime.timedelta,
        statistic: Union[str, "_models.MetricStatisticType"],
        time_window: datetime.timedelta,
        time_aggregation: Union[str, "_models.TimeAggregationType"],
        operator: Union[str, "_models.ComparisonOperationType"],
        threshold: float,
        metric_namespace: Optional[str] = None,
        metric_resource_location: Optional[str] = None,
        dimensions: Optional[List["_models.ScaleRuleMetricDimension"]] = None,
        divide_per_instance: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword metric_name: Required. the name of the metric that defines what the rule monitors.
        :paramtype metric_name: str
        :keyword metric_namespace: the namespace of the metric that defines what the rule monitors.
        :paramtype metric_namespace: str
        :keyword metric_resource_uri: Required. the resource identifier of the resource the rule
         monitors.
        :paramtype metric_resource_uri: str
        :keyword metric_resource_location: the location of the resource the rule monitors.
        :paramtype metric_resource_location: str
        :keyword time_grain: Required. the granularity of metrics the rule monitors. Must be one of the
         predefined values returned from metric definitions for the metric. Must be between 12 hours and
         1 minute.
        :paramtype time_grain: ~datetime.timedelta
        :keyword statistic: Required. the metric statistic type. How the metrics from multiple
         instances are combined. Known values are: "Average", "Min", "Max", "Sum", "Count".
        :paramtype statistic: str or ~$(python-base-namespace).v2015_04_01.models.MetricStatisticType
        :keyword time_window: Required. the range of time in which instance data is collected. This
         value must be greater than the delay in metric collection, which can vary from
         resource-to-resource. Must be between 12 hours and 5 minutes.
        :paramtype time_window: ~datetime.timedelta
        :keyword time_aggregation: Required. time aggregation type. How the data that is collected
         should be combined over time. The default value is Average. Known values are: "Average",
         "Minimum", "Maximum", "Total", "Count", "Last".
        :paramtype time_aggregation: str or
         ~$(python-base-namespace).v2015_04_01.models.TimeAggregationType
        :keyword operator: Required. the operator that is used to compare the metric data and the
         threshold. Known values are: "Equals", "NotEquals", "GreaterThan", "GreaterThanOrEqual",
         "LessThan", "LessThanOrEqual".
        :paramtype operator: str or
         ~$(python-base-namespace).v2015_04_01.models.ComparisonOperationType
        :keyword threshold: Required. the threshold of the metric that triggers the scale action.
        :paramtype threshold: float
        :keyword dimensions: List of dimension conditions. For example:
         [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
        :paramtype dimensions:
         list[~$(python-base-namespace).v2015_04_01.models.ScaleRuleMetricDimension]
        :keyword divide_per_instance: a value indicating whether metric should divide per instance.
        :paramtype divide_per_instance: bool
        """
        super(MetricTrigger, self).__init__(**kwargs)
        self.metric_name = metric_name
        self.metric_namespace = metric_namespace
        self.metric_resource_uri = metric_resource_uri
        self.metric_resource_location = metric_resource_location
        self.time_grain = time_grain
        self.statistic = statistic
        self.time_window = time_window
        self.time_aggregation = time_aggregation
        self.operator = operator
        self.threshold = threshold
        self.dimensions = dimensions
        self.divide_per_instance = divide_per_instance


class Operation(msrest.serialization.Model):
    """Microsoft Insights API operation definition.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display metadata associated with the operation.
    :vartype display: ~$(python-base-namespace).v2015_04_01.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        **kwargs
    ):
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Display metadata associated with the operation.
        :paramtype display: ~$(python-base-namespace).v2015_04_01.models.OperationDisplay
        """
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: Service provider: Microsoft.Insights.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: AlertRules, Autoscale, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Service provider: Microsoft.Insights.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed: AlertRules, Autoscale, etc.
        :paramtype resource: str
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list Microsoft.Insights operations. It contains a list of operations and a URL link to get the next set of results.

    :ivar value: List of operations supported by the Microsoft.Insights provider.
    :vartype value: list[~$(python-base-namespace).v2015_04_01.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.Operation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of operations supported by the Microsoft.Insights provider.
        :paramtype value: list[~$(python-base-namespace).v2015_04_01.models.Operation]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Recurrence(msrest.serialization.Model):
    """The repeating times at which this profile begins. This element is not used if the FixedDate element is used.

    All required parameters must be populated in order to send to Azure.

    :ivar frequency: Required. the recurrence frequency. How often the schedule profile should take
     effect. This value must be Week, meaning each week will have the same set of profiles. For
     example, to set a daily schedule, set **schedule** to every day of the week. The frequency
     property specifies that the schedule is repeated weekly. Known values are: "None", "Second",
     "Minute", "Hour", "Day", "Week", "Month", "Year".
    :vartype frequency: str or ~$(python-base-namespace).v2015_04_01.models.RecurrenceFrequency
    :ivar schedule: Required. the scheduling constraints for when the profile begins.
    :vartype schedule: ~$(python-base-namespace).v2015_04_01.models.RecurrentSchedule
    """

    _validation = {
        'frequency': {'required': True},
        'schedule': {'required': True},
    }

    _attribute_map = {
        'frequency': {'key': 'frequency', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': 'RecurrentSchedule'},
    }

    def __init__(
        self,
        *,
        frequency: Union[str, "_models.RecurrenceFrequency"],
        schedule: "_models.RecurrentSchedule",
        **kwargs
    ):
        """
        :keyword frequency: Required. the recurrence frequency. How often the schedule profile should
         take effect. This value must be Week, meaning each week will have the same set of profiles. For
         example, to set a daily schedule, set **schedule** to every day of the week. The frequency
         property specifies that the schedule is repeated weekly. Known values are: "None", "Second",
         "Minute", "Hour", "Day", "Week", "Month", "Year".
        :paramtype frequency: str or ~$(python-base-namespace).v2015_04_01.models.RecurrenceFrequency
        :keyword schedule: Required. the scheduling constraints for when the profile begins.
        :paramtype schedule: ~$(python-base-namespace).v2015_04_01.models.RecurrentSchedule
        """
        super(Recurrence, self).__init__(**kwargs)
        self.frequency = frequency
        self.schedule = schedule


class RecurrentSchedule(msrest.serialization.Model):
    """The scheduling constraints for when the profile begins.

    All required parameters must be populated in order to send to Azure.

    :ivar time_zone: Required. the timezone for the hours of the profile. Some examples of valid
     time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time,
     Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain
     Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard
     Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time,
     Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard
     Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time,
     Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina
     Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time,
     Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde
     Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W.
     Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European
     Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time,
     GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E.
     Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time,
     Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time,
     Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran
     Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius
     Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West
     Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time,
     Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard
     Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia
     Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W.
     Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time,
     Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard
     Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time,
     Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10,
     Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji
     Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands
     Standard Time.
    :vartype time_zone: str
    :ivar days: Required. the collection of days that the profile takes effect on. Possible values
     are Sunday through Saturday.
    :vartype days: list[str]
    :ivar hours: Required. A collection of hours that the profile takes effect on. Values supported
     are 0 to 23 on the 24-hour clock (AM/PM times are not supported).
    :vartype hours: list[int]
    :ivar minutes: Required. A collection of minutes at which the profile takes effect at.
    :vartype minutes: list[int]
    """

    _validation = {
        'time_zone': {'required': True},
        'days': {'required': True},
        'hours': {'required': True},
        'minutes': {'required': True},
    }

    _attribute_map = {
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'days': {'key': 'days', 'type': '[str]'},
        'hours': {'key': 'hours', 'type': '[int]'},
        'minutes': {'key': 'minutes', 'type': '[int]'},
    }

    def __init__(
        self,
        *,
        time_zone: str,
        days: List[str],
        hours: List[int],
        minutes: List[int],
        **kwargs
    ):
        """
        :keyword time_zone: Required. the timezone for the hours of the profile. Some examples of valid
         time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time,
         Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain
         Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard
         Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time,
         Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard
         Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time,
         Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina
         Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time,
         Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde
         Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W.
         Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European
         Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time,
         GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E.
         Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time,
         Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time,
         Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran
         Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius
         Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West
         Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time,
         Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard
         Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia
         Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W.
         Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time,
         Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard
         Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time,
         Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10,
         Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji
         Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands
         Standard Time.
        :paramtype time_zone: str
        :keyword days: Required. the collection of days that the profile takes effect on. Possible
         values are Sunday through Saturday.
        :paramtype days: list[str]
        :keyword hours: Required. A collection of hours that the profile takes effect on. Values
         supported are 0 to 23 on the 24-hour clock (AM/PM times are not supported).
        :paramtype hours: list[int]
        :keyword minutes: Required. A collection of minutes at which the profile takes effect at.
        :paramtype minutes: list[int]
        """
        super(RecurrentSchedule, self).__init__(**kwargs)
        self.time_zone = time_zone
        self.days = days
        self.hours = hours
        self.minutes = minutes


class RuleAction(msrest.serialization.Model):
    """The action that is performed when the alert rule becomes active, and when an alert condition is resolved.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: RuleEmailAction, RuleWebhookAction.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. specifies the type of the action. There are two types of actions:
     RuleEmailAction and RuleWebhookAction.Constant filled by server.
    :vartype odata_type: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'Microsoft.Azure.Management.Insights.Models.RuleEmailAction': 'RuleEmailAction', 'Microsoft.Azure.Management.Insights.Models.RuleWebhookAction': 'RuleWebhookAction'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(RuleAction, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]


class RuleDataSource(msrest.serialization.Model):
    """The resource from which the rule collects its data.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: RuleManagementEventDataSource, RuleMetricDataSource.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. specifies the type of data source. There are two types of rule data
     sources: RuleMetricDataSource and RuleManagementEventDataSource.Constant filled by server.
    :vartype odata_type: str
    :ivar resource_uri: the resource identifier of the resource the rule monitors. **NOTE**\ : this
     property cannot be updated for an existing rule.
    :vartype resource_uri: str
    :ivar legacy_resource_id: the legacy resource identifier of the resource the rule monitors.
     **NOTE**\ : this property cannot be updated for an existing rule.
    :vartype legacy_resource_id: str
    :ivar resource_location: the location of the resource.
    :vartype resource_location: str
    :ivar metric_namespace: the namespace of the metric.
    :vartype metric_namespace: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'legacy_resource_id': {'key': 'legacyResourceId', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'metric_namespace': {'key': 'metricNamespace', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource': 'RuleManagementEventDataSource', 'Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource': 'RuleMetricDataSource'}
    }

    def __init__(
        self,
        *,
        resource_uri: Optional[str] = None,
        legacy_resource_id: Optional[str] = None,
        resource_location: Optional[str] = None,
        metric_namespace: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword resource_uri: the resource identifier of the resource the rule monitors. **NOTE**\ :
         this property cannot be updated for an existing rule.
        :paramtype resource_uri: str
        :keyword legacy_resource_id: the legacy resource identifier of the resource the rule monitors.
         **NOTE**\ : this property cannot be updated for an existing rule.
        :paramtype legacy_resource_id: str
        :keyword resource_location: the location of the resource.
        :paramtype resource_location: str
        :keyword metric_namespace: the namespace of the metric.
        :paramtype metric_namespace: str
        """
        super(RuleDataSource, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.resource_uri = resource_uri
        self.legacy_resource_id = legacy_resource_id
        self.resource_location = resource_location
        self.metric_namespace = metric_namespace


class RuleEmailAction(RuleAction):
    """Specifies the action to send email when the rule condition is evaluated. The discriminator is always RuleEmailAction in this case.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. specifies the type of the action. There are two types of actions:
     RuleEmailAction and RuleWebhookAction.Constant filled by server.
    :vartype odata_type: str
    :ivar send_to_service_owners: Whether the administrators (service and co-administrators) of the
     service should be notified when the alert is activated.
    :vartype send_to_service_owners: bool
    :ivar custom_emails: the list of administrator's custom email addresses to notify of the
     activation of the alert.
    :vartype custom_emails: list[str]
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'send_to_service_owners': {'key': 'sendToServiceOwners', 'type': 'bool'},
        'custom_emails': {'key': 'customEmails', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        send_to_service_owners: Optional[bool] = None,
        custom_emails: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword send_to_service_owners: Whether the administrators (service and co-administrators) of
         the service should be notified when the alert is activated.
        :paramtype send_to_service_owners: bool
        :keyword custom_emails: the list of administrator's custom email addresses to notify of the
         activation of the alert.
        :paramtype custom_emails: list[str]
        """
        super(RuleEmailAction, self).__init__(**kwargs)
        self.odata_type = 'Microsoft.Azure.Management.Insights.Models.RuleEmailAction'  # type: str
        self.send_to_service_owners = send_to_service_owners
        self.custom_emails = custom_emails


class RuleManagementEventClaimsDataSource(msrest.serialization.Model):
    """The claims for a rule management event data source.

    :ivar email_address: the email address.
    :vartype email_address: str
    """

    _attribute_map = {
        'email_address': {'key': 'emailAddress', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        email_address: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword email_address: the email address.
        :paramtype email_address: str
        """
        super(RuleManagementEventClaimsDataSource, self).__init__(**kwargs)
        self.email_address = email_address


class RuleManagementEventDataSource(RuleDataSource):
    """A rule management event data source. The discriminator fields is always RuleManagementEventDataSource in this case.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. specifies the type of data source. There are two types of rule data
     sources: RuleMetricDataSource and RuleManagementEventDataSource.Constant filled by server.
    :vartype odata_type: str
    :ivar resource_uri: the resource identifier of the resource the rule monitors. **NOTE**\ : this
     property cannot be updated for an existing rule.
    :vartype resource_uri: str
    :ivar legacy_resource_id: the legacy resource identifier of the resource the rule monitors.
     **NOTE**\ : this property cannot be updated for an existing rule.
    :vartype legacy_resource_id: str
    :ivar resource_location: the location of the resource.
    :vartype resource_location: str
    :ivar metric_namespace: the namespace of the metric.
    :vartype metric_namespace: str
    :ivar event_name: the event name.
    :vartype event_name: str
    :ivar event_source: the event source.
    :vartype event_source: str
    :ivar level: the level.
    :vartype level: str
    :ivar operation_name: The name of the operation that should be checked for. If no name is
     provided, any operation will match.
    :vartype operation_name: str
    :ivar resource_group_name: the resource group name.
    :vartype resource_group_name: str
    :ivar resource_provider_name: the resource provider name.
    :vartype resource_provider_name: str
    :ivar status: The status of the operation that should be checked for. If no status is provided,
     any status will match.
    :vartype status: str
    :ivar sub_status: the substatus.
    :vartype sub_status: str
    :ivar claims: the claims.
    :vartype claims:
     ~$(python-base-namespace).v2015_04_01.models.RuleManagementEventClaimsDataSource
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'legacy_resource_id': {'key': 'legacyResourceId', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'metric_namespace': {'key': 'metricNamespace', 'type': 'str'},
        'event_name': {'key': 'eventName', 'type': 'str'},
        'event_source': {'key': 'eventSource', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
        'operation_name': {'key': 'operationName', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'resource_provider_name': {'key': 'resourceProviderName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'sub_status': {'key': 'subStatus', 'type': 'str'},
        'claims': {'key': 'claims', 'type': 'RuleManagementEventClaimsDataSource'},
    }

    def __init__(
        self,
        *,
        resource_uri: Optional[str] = None,
        legacy_resource_id: Optional[str] = None,
        resource_location: Optional[str] = None,
        metric_namespace: Optional[str] = None,
        event_name: Optional[str] = None,
        event_source: Optional[str] = None,
        level: Optional[str] = None,
        operation_name: Optional[str] = None,
        resource_group_name: Optional[str] = None,
        resource_provider_name: Optional[str] = None,
        status: Optional[str] = None,
        sub_status: Optional[str] = None,
        claims: Optional["_models.RuleManagementEventClaimsDataSource"] = None,
        **kwargs
    ):
        """
        :keyword resource_uri: the resource identifier of the resource the rule monitors. **NOTE**\ :
         this property cannot be updated for an existing rule.
        :paramtype resource_uri: str
        :keyword legacy_resource_id: the legacy resource identifier of the resource the rule monitors.
         **NOTE**\ : this property cannot be updated for an existing rule.
        :paramtype legacy_resource_id: str
        :keyword resource_location: the location of the resource.
        :paramtype resource_location: str
        :keyword metric_namespace: the namespace of the metric.
        :paramtype metric_namespace: str
        :keyword event_name: the event name.
        :paramtype event_name: str
        :keyword event_source: the event source.
        :paramtype event_source: str
        :keyword level: the level.
        :paramtype level: str
        :keyword operation_name: The name of the operation that should be checked for. If no name is
         provided, any operation will match.
        :paramtype operation_name: str
        :keyword resource_group_name: the resource group name.
        :paramtype resource_group_name: str
        :keyword resource_provider_name: the resource provider name.
        :paramtype resource_provider_name: str
        :keyword status: The status of the operation that should be checked for. If no status is
         provided, any status will match.
        :paramtype status: str
        :keyword sub_status: the substatus.
        :paramtype sub_status: str
        :keyword claims: the claims.
        :paramtype claims:
         ~$(python-base-namespace).v2015_04_01.models.RuleManagementEventClaimsDataSource
        """
        super(RuleManagementEventDataSource, self).__init__(resource_uri=resource_uri, legacy_resource_id=legacy_resource_id, resource_location=resource_location, metric_namespace=metric_namespace, **kwargs)
        self.odata_type = 'Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource'  # type: str
        self.event_name = event_name
        self.event_source = event_source
        self.level = level
        self.operation_name = operation_name
        self.resource_group_name = resource_group_name
        self.resource_provider_name = resource_provider_name
        self.status = status
        self.sub_status = sub_status
        self.claims = claims


class RuleMetricDataSource(RuleDataSource):
    """A rule metric data source. The discriminator value is always RuleMetricDataSource in this case.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. specifies the type of data source. There are two types of rule data
     sources: RuleMetricDataSource and RuleManagementEventDataSource.Constant filled by server.
    :vartype odata_type: str
    :ivar resource_uri: the resource identifier of the resource the rule monitors. **NOTE**\ : this
     property cannot be updated for an existing rule.
    :vartype resource_uri: str
    :ivar legacy_resource_id: the legacy resource identifier of the resource the rule monitors.
     **NOTE**\ : this property cannot be updated for an existing rule.
    :vartype legacy_resource_id: str
    :ivar resource_location: the location of the resource.
    :vartype resource_location: str
    :ivar metric_namespace: the namespace of the metric.
    :vartype metric_namespace: str
    :ivar metric_name: the name of the metric that defines what the rule monitors.
    :vartype metric_name: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'legacy_resource_id': {'key': 'legacyResourceId', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'metric_namespace': {'key': 'metricNamespace', 'type': 'str'},
        'metric_name': {'key': 'metricName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_uri: Optional[str] = None,
        legacy_resource_id: Optional[str] = None,
        resource_location: Optional[str] = None,
        metric_namespace: Optional[str] = None,
        metric_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword resource_uri: the resource identifier of the resource the rule monitors. **NOTE**\ :
         this property cannot be updated for an existing rule.
        :paramtype resource_uri: str
        :keyword legacy_resource_id: the legacy resource identifier of the resource the rule monitors.
         **NOTE**\ : this property cannot be updated for an existing rule.
        :paramtype legacy_resource_id: str
        :keyword resource_location: the location of the resource.
        :paramtype resource_location: str
        :keyword metric_namespace: the namespace of the metric.
        :paramtype metric_namespace: str
        :keyword metric_name: the name of the metric that defines what the rule monitors.
        :paramtype metric_name: str
        """
        super(RuleMetricDataSource, self).__init__(resource_uri=resource_uri, legacy_resource_id=legacy_resource_id, resource_location=resource_location, metric_namespace=metric_namespace, **kwargs)
        self.odata_type = 'Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource'  # type: str
        self.metric_name = metric_name


class RuleWebhookAction(RuleAction):
    """Specifies the action to post to service when the rule condition is evaluated. The discriminator is always RuleWebhookAction in this case.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. specifies the type of the action. There are two types of actions:
     RuleEmailAction and RuleWebhookAction.Constant filled by server.
    :vartype odata_type: str
    :ivar service_uri: the service uri to Post the notification when the alert activates or
     resolves.
    :vartype service_uri: str
    :ivar properties: the dictionary of custom properties to include with the post operation. These
     data are appended to the webhook payload.
    :vartype properties: dict[str, str]
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'service_uri': {'key': 'serviceUri', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        service_uri: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword service_uri: the service uri to Post the notification when the alert activates or
         resolves.
        :paramtype service_uri: str
        :keyword properties: the dictionary of custom properties to include with the post operation.
         These data are appended to the webhook payload.
        :paramtype properties: dict[str, str]
        """
        super(RuleWebhookAction, self).__init__(**kwargs)
        self.odata_type = 'Microsoft.Azure.Management.Insights.Models.RuleWebhookAction'  # type: str
        self.service_uri = service_uri
        self.properties = properties


class ScaleAction(msrest.serialization.Model):
    """The parameters for the scaling action.

    All required parameters must be populated in order to send to Azure.

    :ivar direction: Required. the scale direction. Whether the scaling action increases or
     decreases the number of instances. Known values are: "None", "Increase", "Decrease".
    :vartype direction: str or ~$(python-base-namespace).v2015_04_01.models.ScaleDirection
    :ivar type: Required. the type of action that should occur when the scale rule fires. Known
     values are: "ChangeCount", "PercentChangeCount", "ExactCount", "ServiceAllowedNextValue".
    :vartype type: str or ~$(python-base-namespace).v2015_04_01.models.ScaleType
    :ivar value: the number of instances that are involved in the scaling action. This value must
     be 1 or greater. The default value is 1.
    :vartype value: str
    :ivar cooldown: Required. the amount of time to wait since the last scaling action before this
     action occurs. It must be between 1 week and 1 minute in ISO 8601 format.
    :vartype cooldown: ~datetime.timedelta
    """

    _validation = {
        'direction': {'required': True},
        'type': {'required': True},
        'cooldown': {'required': True},
    }

    _attribute_map = {
        'direction': {'key': 'direction', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'cooldown': {'key': 'cooldown', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        direction: Union[str, "_models.ScaleDirection"],
        type: Union[str, "_models.ScaleType"],
        cooldown: datetime.timedelta,
        value: Optional[str] = "1",
        **kwargs
    ):
        """
        :keyword direction: Required. the scale direction. Whether the scaling action increases or
         decreases the number of instances. Known values are: "None", "Increase", "Decrease".
        :paramtype direction: str or ~$(python-base-namespace).v2015_04_01.models.ScaleDirection
        :keyword type: Required. the type of action that should occur when the scale rule fires. Known
         values are: "ChangeCount", "PercentChangeCount", "ExactCount", "ServiceAllowedNextValue".
        :paramtype type: str or ~$(python-base-namespace).v2015_04_01.models.ScaleType
        :keyword value: the number of instances that are involved in the scaling action. This value
         must be 1 or greater. The default value is 1.
        :paramtype value: str
        :keyword cooldown: Required. the amount of time to wait since the last scaling action before
         this action occurs. It must be between 1 week and 1 minute in ISO 8601 format.
        :paramtype cooldown: ~datetime.timedelta
        """
        super(ScaleAction, self).__init__(**kwargs)
        self.direction = direction
        self.type = type
        self.value = value
        self.cooldown = cooldown


class ScaleCapacity(msrest.serialization.Model):
    """The number of instances that can be used during this profile.

    All required parameters must be populated in order to send to Azure.

    :ivar minimum: Required. the minimum number of instances for the resource.
    :vartype minimum: str
    :ivar maximum: Required. the maximum number of instances for the resource. The actual maximum
     number of instances is limited by the cores that are available in the subscription.
    :vartype maximum: str
    :ivar default: Required. the number of instances that will be set if metrics are not available
     for evaluation. The default is only used if the current instance count is lower than the
     default.
    :vartype default: str
    """

    _validation = {
        'minimum': {'required': True},
        'maximum': {'required': True},
        'default': {'required': True},
    }

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'str'},
        'maximum': {'key': 'maximum', 'type': 'str'},
        'default': {'key': 'default', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        minimum: str,
        maximum: str,
        default: str,
        **kwargs
    ):
        """
        :keyword minimum: Required. the minimum number of instances for the resource.
        :paramtype minimum: str
        :keyword maximum: Required. the maximum number of instances for the resource. The actual
         maximum number of instances is limited by the cores that are available in the subscription.
        :paramtype maximum: str
        :keyword default: Required. the number of instances that will be set if metrics are not
         available for evaluation. The default is only used if the current instance count is lower than
         the default.
        :paramtype default: str
        """
        super(ScaleCapacity, self).__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
        self.default = default


class ScaleRule(msrest.serialization.Model):
    """A rule that provide the triggers and parameters for the scaling action.

    All required parameters must be populated in order to send to Azure.

    :ivar metric_trigger: Required. the trigger that results in a scaling action.
    :vartype metric_trigger: ~$(python-base-namespace).v2015_04_01.models.MetricTrigger
    :ivar scale_action: Required. the parameters for the scaling action.
    :vartype scale_action: ~$(python-base-namespace).v2015_04_01.models.ScaleAction
    """

    _validation = {
        'metric_trigger': {'required': True},
        'scale_action': {'required': True},
    }

    _attribute_map = {
        'metric_trigger': {'key': 'metricTrigger', 'type': 'MetricTrigger'},
        'scale_action': {'key': 'scaleAction', 'type': 'ScaleAction'},
    }

    def __init__(
        self,
        *,
        metric_trigger: "_models.MetricTrigger",
        scale_action: "_models.ScaleAction",
        **kwargs
    ):
        """
        :keyword metric_trigger: Required. the trigger that results in a scaling action.
        :paramtype metric_trigger: ~$(python-base-namespace).v2015_04_01.models.MetricTrigger
        :keyword scale_action: Required. the parameters for the scaling action.
        :paramtype scale_action: ~$(python-base-namespace).v2015_04_01.models.ScaleAction
        """
        super(ScaleRule, self).__init__(**kwargs)
        self.metric_trigger = metric_trigger
        self.scale_action = scale_action


class ScaleRuleMetricDimension(msrest.serialization.Model):
    """Specifies an auto scale rule metric dimension.

    All required parameters must be populated in order to send to Azure.

    :ivar dimension_name: Required. Name of the dimension.
    :vartype dimension_name: str
    :ivar operator: Required. the dimension operator. Only 'Equals' and 'NotEquals' are supported.
     'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the values.
     Known values are: "Equals", "NotEquals".
    :vartype operator: str or
     ~$(python-base-namespace).v2015_04_01.models.ScaleRuleMetricDimensionOperationType
    :ivar values: Required. list of dimension values. For example: ["App1","App2"].
    :vartype values: list[str]
    """

    _validation = {
        'dimension_name': {'required': True},
        'operator': {'required': True},
        'values': {'required': True},
    }

    _attribute_map = {
        'dimension_name': {'key': 'DimensionName', 'type': 'str'},
        'operator': {'key': 'Operator', 'type': 'str'},
        'values': {'key': 'Values', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        dimension_name: str,
        operator: Union[str, "_models.ScaleRuleMetricDimensionOperationType"],
        values: List[str],
        **kwargs
    ):
        """
        :keyword dimension_name: Required. Name of the dimension.
        :paramtype dimension_name: str
        :keyword operator: Required. the dimension operator. Only 'Equals' and 'NotEquals' are
         supported. 'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the
         values. Known values are: "Equals", "NotEquals".
        :paramtype operator: str or
         ~$(python-base-namespace).v2015_04_01.models.ScaleRuleMetricDimensionOperationType
        :keyword values: Required. list of dimension values. For example: ["App1","App2"].
        :paramtype values: list[str]
        """
        super(ScaleRuleMetricDimension, self).__init__(**kwargs)
        self.dimension_name = dimension_name
        self.operator = operator
        self.values = values


class SenderAuthorization(msrest.serialization.Model):
    """the authorization used by the user who has performed the operation that led to this event. This captures the RBAC properties of the event. These usually include the 'action', 'role' and the 'scope'.

    :ivar action: the permissible actions. For instance: microsoft.support/supporttickets/write.
    :vartype action: str
    :ivar role: the role of the user. For instance: Subscription Admin.
    :vartype role: str
    :ivar scope: the scope.
    :vartype scope: str
    """

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'role': {'key': 'role', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        action: Optional[str] = None,
        role: Optional[str] = None,
        scope: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword action: the permissible actions. For instance: microsoft.support/supporttickets/write.
        :paramtype action: str
        :keyword role: the role of the user. For instance: Subscription Admin.
        :paramtype role: str
        :keyword scope: the scope.
        :paramtype scope: str
        """
        super(SenderAuthorization, self).__init__(**kwargs)
        self.action = action
        self.role = role
        self.scope = scope


class ThresholdRuleCondition(RuleCondition):
    """A rule condition based on a metric crossing a threshold.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. specifies the type of condition. This can be one of three types:
     ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition
     (based on the number of failures of a web test), and ThresholdRuleCondition (based on the
     threshold of a metric).Constant filled by server.
    :vartype odata_type: str
    :ivar data_source: the resource from which the rule collects its data. For this type dataSource
     will always be of type RuleMetricDataSource.
    :vartype data_source: ~$(python-base-namespace).v2015_04_01.models.RuleDataSource
    :ivar operator: Required. the operator used to compare the data and the threshold. Known values
     are: "GreaterThan", "GreaterThanOrEqual", "LessThan", "LessThanOrEqual".
    :vartype operator: str or ~$(python-base-namespace).v2015_04_01.models.ConditionOperator
    :ivar threshold: Required. the threshold value that activates the alert.
    :vartype threshold: float
    :ivar window_size: the period of time (in ISO 8601 duration format) that is used to monitor
     alert activity based on the threshold. If specified then it must be between 5 minutes and 1
     day.
    :vartype window_size: ~datetime.timedelta
    :ivar time_aggregation: the time aggregation operator. How the data that are collected should
     be combined over time. The default value is the PrimaryAggregationType of the Metric. Known
     values are: "Average", "Minimum", "Maximum", "Total", "Last".
    :vartype time_aggregation: str or
     ~$(python-base-namespace).v2015_04_01.models.TimeAggregationOperator
    """

    _validation = {
        'odata_type': {'required': True},
        'operator': {'required': True},
        'threshold': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'data_source': {'key': 'dataSource', 'type': 'RuleDataSource'},
        'operator': {'key': 'operator', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'float'},
        'window_size': {'key': 'windowSize', 'type': 'duration'},
        'time_aggregation': {'key': 'timeAggregation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        operator: Union[str, "_models.ConditionOperator"],
        threshold: float,
        data_source: Optional["_models.RuleDataSource"] = None,
        window_size: Optional[datetime.timedelta] = None,
        time_aggregation: Optional[Union[str, "_models.TimeAggregationOperator"]] = None,
        **kwargs
    ):
        """
        :keyword data_source: the resource from which the rule collects its data. For this type
         dataSource will always be of type RuleMetricDataSource.
        :paramtype data_source: ~$(python-base-namespace).v2015_04_01.models.RuleDataSource
        :keyword operator: Required. the operator used to compare the data and the threshold. Known
         values are: "GreaterThan", "GreaterThanOrEqual", "LessThan", "LessThanOrEqual".
        :paramtype operator: str or ~$(python-base-namespace).v2015_04_01.models.ConditionOperator
        :keyword threshold: Required. the threshold value that activates the alert.
        :paramtype threshold: float
        :keyword window_size: the period of time (in ISO 8601 duration format) that is used to monitor
         alert activity based on the threshold. If specified then it must be between 5 minutes and 1
         day.
        :paramtype window_size: ~datetime.timedelta
        :keyword time_aggregation: the time aggregation operator. How the data that are collected
         should be combined over time. The default value is the PrimaryAggregationType of the Metric.
         Known values are: "Average", "Minimum", "Maximum", "Total", "Last".
        :paramtype time_aggregation: str or
         ~$(python-base-namespace).v2015_04_01.models.TimeAggregationOperator
        """
        super(ThresholdRuleCondition, self).__init__(data_source=data_source, **kwargs)
        self.odata_type = 'Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition'  # type: str
        self.operator = operator
        self.threshold = threshold
        self.window_size = window_size
        self.time_aggregation = time_aggregation


class TimeWindow(msrest.serialization.Model):
    """A specific date-time for the profile.

    All required parameters must be populated in order to send to Azure.

    :ivar time_zone: the timezone of the start and end times for the profile. Some examples of
     valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard
     Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time,
     Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central
     Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific
     Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time,
     Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western
     Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard
     Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo
     Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time,
     Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard
     Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central
     European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard
     Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time,
     E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time,
     Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time,
     Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran
     Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius
     Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West
     Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time,
     Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard
     Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia
     Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W.
     Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time,
     Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard
     Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time,
     Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10,
     Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji
     Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands
     Standard Time.
    :vartype time_zone: str
    :ivar start: Required. the start time for the profile in ISO 8601 format.
    :vartype start: ~datetime.datetime
    :ivar end: Required. the end time for the profile in ISO 8601 format.
    :vartype end: ~datetime.datetime
    """

    _validation = {
        'start': {'required': True},
        'end': {'required': True},
    }

    _attribute_map = {
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'start': {'key': 'start', 'type': 'iso-8601'},
        'end': {'key': 'end', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        start: datetime.datetime,
        end: datetime.datetime,
        time_zone: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword time_zone: the timezone of the start and end times for the profile. Some examples of
         valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard
         Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time,
         Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central
         Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific
         Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time,
         Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western
         Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard
         Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo
         Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time,
         Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard
         Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central
         European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard
         Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time,
         E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time,
         Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time,
         Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran
         Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius
         Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West
         Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time,
         Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard
         Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia
         Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W.
         Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time,
         Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard
         Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time,
         Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10,
         Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji
         Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands
         Standard Time.
        :paramtype time_zone: str
        :keyword start: Required. the start time for the profile in ISO 8601 format.
        :paramtype start: ~datetime.datetime
        :keyword end: Required. the end time for the profile in ISO 8601 format.
        :paramtype end: ~datetime.datetime
        """
        super(TimeWindow, self).__init__(**kwargs)
        self.time_zone = time_zone
        self.start = start
        self.end = end


class WebhookNotification(msrest.serialization.Model):
    """Webhook notification of an autoscale event.

    :ivar service_uri: the service address to receive the notification.
    :vartype service_uri: str
    :ivar properties: a property bag of settings. This value can be empty.
    :vartype properties: dict[str, str]
    """

    _attribute_map = {
        'service_uri': {'key': 'serviceUri', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        service_uri: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword service_uri: the service address to receive the notification.
        :paramtype service_uri: str
        :keyword properties: a property bag of settings. This value can be empty.
        :paramtype properties: dict[str, str]
        """
        super(WebhookNotification, self).__init__(**kwargs)
        self.service_uri = service_uri
        self.properties = properties
