/* jslint:disable */
﻿

/* authentication.js */
Exhibit.Authentication={};
Exhibit.Authentication.Enabled=false;
Exhibit.Authentication.GoogleToken=null;
Exhibit.Authentication.GoogleSessionToken=null;
Exhibit.Authentication.authenticate=function(){if(!window.Exhibit.params.authenticated){return ;
}var A=document.getElementsByTagName("head")[0].childNodes;
for(var B=0;
B<A.length;
B++){var C=A[B];
if(C.rel=="exhibit/output"&&C.getAttribute("ex:authenticated")){Exhibit.Authentication.handleGoogleAuthentication();
return ;
}}};
Exhibit.Authentication.parseLocationParams=function(){var E=document.location.search.substr(1).split("&");
var A={};
for(var B=0;
B<E.length;
B++){var D=E[B];
if(D.indexOf("=")!=-1){var C=D.split("=");
if(C.length!=2){SimileAjax.Debug.warn("Error parsing location parameter "+D);
}else{A[C[0]]=C[1];
}}else{A[D]=true;
}}return A;
};
Exhibit.Authentication.GoogleAuthenticationURL="https://www.google.com/accounts/AuthSubRequest";
Exhibit.Authentication.handleGoogleAuthentication=function(){var B=Exhibit.Authentication.parseLocationParams();
if(B.token){Exhibit.Authentication.GoogleToken=B.token;
Exhibit.Authentication.Enabled=true;
}else{var A=Exhibit.Authentication.GoogleAuthenticationURL;
A+="?session=1";
A+="&scope=http://spreadsheets.google.com/feeds/";
A+="&next="+document.location.href;
document.location.href=A;
}};


/* collection.js */
Exhibit.Collection=function(B,A){this._id=B;
this._database=A;
this._listeners=new SimileAjax.ListenerQueue();
this._facets=[];
this._updating=false;
this._items=null;
this._restrictedItems=null;
};
Exhibit.Collection.createAllItemsCollection=function(C,A){var B=new Exhibit.Collection(C,A);
B._update=Exhibit.Collection._allItemsCollection_update;
Exhibit.Collection._initializeBasicCollection(B,A);
return B;
};
Exhibit.Collection.createSubmissionsCollection=function(C,A){var B=new Exhibit.Collection(C,A);
B._update=Exhibit.Collection._submissionCollection_update;
Exhibit.Collection._initializeBasicCollection(B,A);
return B;
};
Exhibit.Collection.create=function(D,C,A){var B=new Exhibit.Collection(D,A);
if("itemTypes" in C){B._itemTypes=C.itemTypes;
B._update=Exhibit.Collection._typeBasedCollection_update;
}else{B._update=Exhibit.Collection._allItemsCollection_update;
}Exhibit.Collection._initializeBasicCollection(B,A);
return B;
};
Exhibit.Collection.createFromDOM=function(E,A,C){var D=new Exhibit.Collection(E,C);
var B=Exhibit.getAttribute(A,"itemTypes",",");
if(B!=null&&B.length>0){D._itemTypes=B;
D._update=Exhibit.Collection._typeBasedCollection_update;
}else{D._update=Exhibit.Collection._allItemsCollection_update;
}Exhibit.Collection._initializeBasicCollection(D,C);
return D;
};
Exhibit.Collection.create2=function(E,D,A){var B=A.getDatabase();
if("expression" in D){var C=new Exhibit.Collection(E,B);
C._expression=Exhibit.ExpressionParser.parse(D.expression);
C._baseCollection=("baseCollectionID" in D)?A.getExhibit().getCollection(D.baseCollectionID):A.getCollection();
C._restrictBaseCollection=("restrictBaseCollection" in D)?D.restrictBaseCollection:false;
if(C._restrictBaseCollection){Exhibit.Collection._initializeRestrictingBasedCollection(C);
}else{Exhibit.Collection._initializeBasedCollection(C);
}return C;
}else{return Exhibit.Collection.create(E,D,B);
}};
Exhibit.Collection.createFromDOM2=function(G,C,A){var E=A.getDatabase();
var F;
if(Exhibit.getAttribute(C,"submissionsCollection")){return Exhibit.Collection.createSubmissionsCollection(G,E);
}var B=Exhibit.getAttribute(C,"expression");
if(B!=null&&B.length>0){F=new Exhibit.Collection(G,E);
F._expression=Exhibit.ExpressionParser.parse(B);
var D=Exhibit.getAttribute(C,"baseCollectionID");
F._baseCollection=(D!=null&&D.length>0)?A.getExhibit().getCollection(D):A.getCollection();
F._restrictBaseCollection=Exhibit.getAttribute(C,"restrictBaseCollection")=="true";
if(F._restrictBaseCollection){Exhibit.Collection._initializeRestrictingBasedCollection(F,E);
}else{Exhibit.Collection._initializeBasedCollection(F);
}}else{F=Exhibit.Collection.createFromDOM(G,C,E);
}return F;
};
Exhibit.Collection._initializeBasicCollection=function(B,A){var C=function(){B._update();
};
B._listener={onAfterLoadingItems:C,onAfterRemovingAllStatements:C};
A.addListener(B._listener);
B._update();
};
Exhibit.Collection._initializeBasedCollection=function(A){A._update=Exhibit.Collection._basedCollection_update;
A._listener={onItemsChanged:function(){A._update();
}};
A._baseCollection.addListener(A._listener);
A._update();
};
Exhibit.Collection._initializeRestrictingBasedCollection=function(B,A){B._cache=new Exhibit.FacetUtilities.Cache(A,B._baseCollection,B._expression);
B._isUpdatingBaseCollection=false;
B.onFacetUpdated=Exhibit.Collection._restrictingBasedCollection_onFacetUpdated;
B.restrict=Exhibit.Collection._restrictingBasedCollection_restrict;
B.update=Exhibit.Collection._restrictingBasedCollection_update;
B.hasRestrictions=Exhibit.Collection._restrictingBasedCollection_hasRestrictions;
B._baseCollection.addFacet(B);
};
Exhibit.Collection._allItemsCollection_update=function(){this.setItems(this._database.getAllItems());
this._onRootItemsChanged();
};
Exhibit.Collection._submissionCollection_update=function(){this.setItems(this._database.getAllSubmissions());
this._onRootItemsChanged();
};
Exhibit.Collection._typeBasedCollection_update=function(){var A=new Exhibit.Set();
for(var B=0;
B<this._itemTypes.length;
B++){this._database.getSubjects(this._itemTypes[B],"type",A);
}this.setItems(A);
this._onRootItemsChanged();
};
Exhibit.Collection._basedCollection_update=function(){this.setItems(this._expression.evaluate({"value":this._baseCollection.getRestrictedItems()},{"value":"item"},"value",this._database).values);
this._onRootItemsChanged();
};
Exhibit.Collection._restrictingBasedCollection_onFacetUpdated=function(A){if(!this._updating){Exhibit.Collection.prototype.onFacetUpdated.call(this,A);
this._isUpdatingBaseCollection=true;
this._baseCollection.onFacetUpdated(this);
this._isUpdatingBaseCollection=false;
}};
Exhibit.Collection._restrictingBasedCollection_restrict=function(A){if(this._restrictedItems.size()==this._items.size()){return A;
}return this._cache.getItemsFromValues(this._restrictedItems,A);
};
Exhibit.Collection._restrictingBasedCollection_update=function(A){if(!this._isUpdatingBaseCollection){this.setItems(this._cache.getValuesFromItems(A));
this._onRootItemsChanged();
}};
Exhibit.Collection._restrictingBasedCollection_hasRestrictions=function(){return(this._items!=null)&&(this._restrictedItems!=null)&&(this._restrictedItems.size()!=this._items.size());
};
Exhibit.Collection.prototype.getID=function(){return this._id;
};
Exhibit.Collection.prototype.dispose=function(){if("_baseCollection" in this){this._baseCollection.removeListener(this._listener);
this._baseCollection=null;
this._expression=null;
}else{this._database.removeListener(this._listener);
}this._database=null;
this._listener=null;
this._listeners=null;
this._items=null;
this._restrictedItems=null;
};
Exhibit.Collection.prototype.addListener=function(A){this._listeners.add(A);
};
Exhibit.Collection.prototype.removeListener=function(A){this._listeners.remove(A);
};
Exhibit.Collection.prototype.addFacet=function(A){this._facets.push(A);
if(A.hasRestrictions()){this._computeRestrictedItems();
this._updateFacets(null);
this._listeners.fire("onItemsChanged",[]);
}else{A.update(this.getRestrictedItems());
}};
Exhibit.Collection.prototype.removeFacet=function(B){for(var A=0;
A<this._facets.length;
A++){if(B==this._facets[A]){this._facets.splice(A,1);
if(B.hasRestrictions()){this._computeRestrictedItems();
this._updateFacets(null);
this._listeners.fire("onItemsChanged",[]);
}break;
}}};
Exhibit.Collection.prototype.clearAllRestrictions=function(){var B=[];
this._updating=true;
for(var A=0;
A<this._facets.length;
A++){B.push(this._facets[A].clearAllRestrictions());
}this._updating=false;
this.onFacetUpdated(null);
return B;
};
Exhibit.Collection.prototype.applyRestrictions=function(B){this._updating=true;
for(var A=0;
A<this._facets.length;
A++){this._facets[A].applyRestrictions(B[A]);
}this._updating=false;
this.onFacetUpdated(null);
};
Exhibit.Collection.prototype.getAllItems=function(){return new Exhibit.Set(this._items);
};
Exhibit.Collection.prototype.countAllItems=function(){return this._items.size();
};
Exhibit.Collection.prototype.getRestrictedItems=function(){return new Exhibit.Set(this._restrictedItems);
};
Exhibit.Collection.prototype.countRestrictedItems=function(){return this._restrictedItems.size();
};
Exhibit.Collection.prototype.onFacetUpdated=function(A){if(!this._updating){this._computeRestrictedItems();
this._updateFacets(A);
this._listeners.fire("onItemsChanged",[]);
}};
Exhibit.Collection.prototype._onRootItemsChanged=function(){this._listeners.fire("onRootItemsChanged",[]);
this._computeRestrictedItems();
this._updateFacets(null);
this._listeners.fire("onItemsChanged",[]);
};
Exhibit.Collection.prototype._updateFacets=function(D){var A=0;
for(var E=0;
E<this._facets.length;
E++){if(this._facets[E].hasRestrictions()){A++;
}}for(var E=0;
E<this._facets.length;
E++){var F=this._facets[E];
if(F.hasRestrictions()){if(A<=1){F.update(this.getAllItems());
}else{var B=this.getAllItems();
for(var C=0;
C<this._facets.length;
C++){if(E!=C){B=this._facets[C].restrict(B);
}}F.update(B);
}}else{F.update(this.getRestrictedItems());
}}};
Exhibit.Collection.prototype._computeRestrictedItems=function(){this._restrictedItems=this._items;
for(var A=0;
A<this._facets.length;
A++){var B=this._facets[A];
if(B.hasRestrictions()){this._restrictedItems=B.restrict(this._restrictedItems);
}}};
Exhibit.Collection.prototype.setItems=function(A){this._items=A;
};


/* controls.js */
Exhibit.Controls={};
Exhibit.Controls["if"]={f:function(D,B,C,G,E){var A=D[0].evaluate(B,C,G,E);
var F=false;
A.forEachValue(function(H){if(H){F=true;
return true;
}});
if(F){return D[1].evaluate(B,C,G,E);
}else{return D[2].evaluate(B,C,G,E);
}}};
Exhibit.Controls["foreach"]={f:function(G,I,J,B,H){var E=G[0].evaluate(I,J,B,H);
var A=I["value"];
var F=J["value"];
J["value"]=E.valueType;
var D=[];
var C="text";
E.forEachValue(function(K){I["value"]=K;
var L=G[1].evaluate(I,J,B,H);
C=L.valueType;
L.forEachValue(function(M){D.push(M);
});
});
I["value"]=A;
J["value"]=F;
return new Exhibit.Expression._Collection(D,C);
}};
Exhibit.Controls["default"]={f:function(C,A,B,G,E){for(var D=0;
D<C.length;
D++){var F=C[D].evaluate(A,B,G,E);
if(F.size>0){return F;
}}return new Exhibit.Expression._Collection([],"text");
}};
Exhibit.Controls["filter"]={f:function(F,H,I,B,G){var D=F[0].evaluate(H,I,B,G);
var A=H["value"];
var E=I["value"];
var C=new Exhibit.Set();
I["value"]=D.valueType;
D.forEachValue(function(J){H["value"]=J;
var K=F[1].evaluate(H,I,B,G);
if(K.size>0&&K.contains("true")){C.add(J);
}});
H["value"]=A;
I["value"]=E;
return new Exhibit.Expression._Collection(C,D.valueType);
}};


/* database.js */
Exhibit.Database=new Object();
Exhibit.Database.create=function(){Exhibit.Database.handleAuthentication();
return new Exhibit.Database._Impl();
};
Exhibit.Database.handleAuthentication=function(){if(window.Exhibit.params.authenticated){var A=document.getElementsByTagName("head")[0].childNodes;
for(var B=0;
B<A.length;
B++){var C=A[B];
if(C.rel=="exhibit/output"&&C.getAttribute("ex:authenticated")){}}}};
Exhibit.Database.makeISO8601DateString=function(A){A=A||new Date();
var C=function(D){return D>9?D.toString():"0"+D;
};
var B=A.getFullYear()+"-"+C(A.getMonth()+1)+"-"+C(A.getDate());
return B;
};
Exhibit.Database.TimestampPropertyName="addedOn";
Exhibit.Database._Impl=function(){this._types={};
this._properties={};
this._propertyArray={};
this._submissionRegistry={};
this._originalValues={};
this._newItems={};
this._listeners=new SimileAjax.ListenerQueue();
this._spo={};
this._ops={};
this._items=new Exhibit.Set();
var E=Exhibit.Database.l10n;
var G=new Exhibit.Database._Type("Item");
G._custom=Exhibit.Database.l10n.itemType;
this._types["Item"]=G;
var F=new Exhibit.Database._Property("label",this);
F._uri="http://www.w3.org/2000/01/rdf-schema#label";
F._valueType="text";
F._label=E.labelProperty.label;
F._pluralLabel=E.labelProperty.pluralLabel;
F._reverseLabel=E.labelProperty.reverseLabel;
F._reversePluralLabel=E.labelProperty.reversePluralLabel;
F._groupingLabel=E.labelProperty.groupingLabel;
F._reverseGroupingLabel=E.labelProperty.reverseGroupingLabel;
this._properties["label"]=F;
var H=new Exhibit.Database._Property("type");
H._uri="http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
H._valueType="text";
H._label="type";
H._pluralLabel=E.typeProperty.label;
H._reverseLabel=E.typeProperty.reverseLabel;
H._reversePluralLabel=E.typeProperty.reversePluralLabel;
H._groupingLabel=E.typeProperty.groupingLabel;
H._reverseGroupingLabel=E.typeProperty.reverseGroupingLabel;
this._properties["type"]=H;
var C=new Exhibit.Database._Property("uri");
C._uri="http://simile.mit.edu/2006/11/exhibit#uri";
C._valueType="url";
C._label="URI";
C._pluralLabel="URIs";
C._reverseLabel="URI of";
C._reversePluralLabel="URIs of";
C._groupingLabel="URIs";
C._reverseGroupingLabel="things named by these URIs";
this._properties["uri"]=C;
var D=new Exhibit.Database._Property("change",this);
D._valueType="text";
D._label="change type";
D._pluralLabel="change types";
D._reverseLabel="change type of";
D._reversePluralLabel="change types of";
D._groupingLabel="change types";
D._reverseGroupingLabel="changes of this type";
this._properties["change"]=D;
var B=new Exhibit.Database._Property("changedItem",this);
B._valueType="text";
B._label="changed item";
B._pluralLabel="changed item";
B._groupingLabel="changed items";
this._properties["changedItem"]=B;
var A=new Exhibit.Database._Property(Exhibit.Database.ModifiedPropertyName,this);
A._valueType="text";
A._label="modified";
A._pluralLabel="modified";
A._groupingLabel="was modified";
this._properties["modified"]=A;
};
Exhibit.Database._Impl.prototype.createDatabase=function(){return Exhibit.Database.create();
};
Exhibit.Database._Impl.prototype.addListener=function(A){this._listeners.add(A);
};
Exhibit.Database._Impl.prototype.removeListener=function(A){this._listeners.remove(A);
};
Exhibit.Database._Impl.prototype.loadDataLinks=function(B){var A=SimileAjax.jQuery("head > link[rel=exhibit/data]").get();
this._loadLinks(A,this,B);
};
Exhibit.Database._Impl.prototype.loadSubmissionLinks=function(C){var B=this;
var D={loadData:function(E,F){if("types" in E){B.loadTypes(E.types,F);
}if("properties" in E){B.loadProperties(E.properties,F);
}if("items" in E){B._listeners.fire("onBeforeLoadingItems",[]);
E.items.forEach(function(H){var I=H.id||H.label;
var G=I+Math.floor(Math.random()*1000000);
B._submissionRegistry[G]=true;
H.id=G;
H.changedItem=I;
if(B.containsItem(I)){H.change="modification";
if(!H.type){H.type=B.getObject(I,"type");
}}else{H.change="addition";
}});
B.loadItems(E.items,F);
B._listeners.fire("onAfterLoadingItems",[]);
}}};
var A=SimileAjax.jQuery("head > link[rel=exhibit/submissions]").get();
this._loadLinks(A,D,C);
};
Exhibit.Database._Impl.prototype._loadLinks=function(A,C,B){A=[].concat(A);
var D=function(){while(A.length>0){var G=A.shift();
var E=G.type;
if(E==null||E.length==0){E="application/json";
}var F=Exhibit.importers[E];
if(F){F.load(G,C,D);
return ;
}else{SimileAjax.Debug.log("No importer for data of type "+E);
}}if(B!=null){B();
}};
D();
};
Exhibit.Database._Impl.prototype.loadData=function(A,B){if(typeof B=="undefined"){B=location.href;
}if("types" in A){this.loadTypes(A.types,B);
}if("properties" in A){this.loadProperties(A.properties,B);
}if("items" in A){this.loadItems(A.items,B);
}};
Exhibit.Database._Impl.prototype.loadTypes=function(C,H){this._listeners.fire("onBeforeLoadingTypes",[]);
try{var B=H.substr(H.length-1);
if(B=="#"){H=H.substr(0,H.length-1)+"/";
}else{if(B!="/"&&B!=":"){H+="/";
}}for(var A in C){if(typeof A!="string"){continue;
}var E=C[A];
if(typeof E!="object"){continue;
}var D;
if(A in this._types){D=this._types[A];
}else{D=new Exhibit.Database._Type(A);
this._types[A]=D;
}for(var G in E){D._custom[G]=E[G];
}if(!("uri" in D._custom)){D._custom["uri"]=H+"type#"+encodeURIComponent(A);
}if(!("label" in D._custom)){D._custom["label"]=A;
}}this._listeners.fire("onAfterLoadingTypes",[]);
}catch(F){SimileAjax.Debug.exception(F,"Database.loadTypes failed");
}};
Exhibit.Database._Impl.prototype.loadProperties=function(F,G){this._listeners.fire("onBeforeLoadingProperties",[]);
try{var B=G.substr(G.length-1);
if(B=="#"){G=G.substr(0,G.length-1)+"/";
}else{if(B!="/"&&B!=":"){G+="/";
}}for(var E in F){if(typeof E!="string"){continue;
}var A=F[E];
if(typeof A!="object"){continue;
}var C;
if(E in this._properties){C=this._properties[E];
}else{C=new Exhibit.Database._Property(E,this);
this._properties[E]=C;
}C._uri=("uri" in A)?A.uri:(G+"property#"+encodeURIComponent(E));
C._valueType=("valueType" in A)?A.valueType:"text";
C._label=("label" in A)?A.label:E;
C._pluralLabel=("pluralLabel" in A)?A.pluralLabel:C._label;
C._reverseLabel=("reverseLabel" in A)?A.reverseLabel:("!"+C._label);
C._reversePluralLabel=("reversePluralLabel" in A)?A.reversePluralLabel:("!"+C._pluralLabel);
C._groupingLabel=("groupingLabel" in A)?A.groupingLabel:C._label;
C._reverseGroupingLabel=("reverseGroupingLabel" in A)?A.reverseGroupingLabel:C._reverseLabel;
if("origin" in A){C._origin=A.origin;
}}this._propertyArray=null;
this._listeners.fire("onAfterLoadingProperties",[]);
}catch(D){SimileAjax.Debug.exception(D,"Database.loadProperties failed");
}};
Exhibit.Database._Impl.prototype.loadItems=function(F,D){this._listeners.fire("onBeforeLoadingItems",[]);
try{var J=D.substr(D.length-1);
if(J=="#"){D=D.substr(0,D.length-1)+"/";
}else{if(J!="/"&&J!=":"){D+="/";
}}var C=this._spo;
var B=this._ops;
var A=Exhibit.Database._indexPut;
var H=function(K,L,M){A(C,K,L,M);
A(B,M,L,K);
};
for(var E=0;
E<F.length;
E++){var I=F[E];
if(typeof I=="object"){this._loadItem(I,H,D);
}}this._propertyArray=null;
this._listeners.fire("onAfterLoadingItems",[]);
}catch(G){SimileAjax.Debug.exception(G,"Database.loadItems failed");
}};
Exhibit.Database._Impl.prototype.getType=function(A){return this._types[A];
};
Exhibit.Database._Impl.prototype.getProperty=function(A){return A in this._properties?this._properties[A]:null;
};
Exhibit.Database._Impl.prototype.getAllProperties=function(){if(this._propertyArray==null){this._propertyArray=[];
for(var A in this._properties){this._propertyArray.push(A);
}}return[].concat(this._propertyArray);
};
Exhibit.Database._Impl.prototype.isSubmission=function(A){return A in this._submissionRegistry;
};
Exhibit.Database._Impl.prototype.getAllItems=function(){var B=new Exhibit.Set();
var A=this;
this._items.visit(function(C){if(!A.isSubmission(C)){B.add(C);
}});
return B;
};
Exhibit.Database._Impl.prototype.getAllSubmissions=function(){var B=new Exhibit.Set();
var A=this._items.toArray();
for(var C in A){var D=A[C];
if(this.isSubmission(D)){B.add(D);
}}return B;
};
Exhibit.Database._Impl.prototype.getAllItemsCount=function(){return this._items.size();
};
Exhibit.Database._Impl.prototype.containsItem=function(A){return this._items.contains(A);
};
Exhibit.Database._Impl.prototype.getNamespaces=function(L,K){var A={};
for(var N in this._properties){var M=this._properties[N];
var D=M.getURI();
var H=D.indexOf("#");
if(H>0){var B=D.substr(0,H+1);
A[B]=true;
L[N]={base:B,localName:D.substr(H+1)};
continue;
}var F=D.lastIndexOf("/");
if(F>0){var B=D.substr(0,F+1);
A[B]=true;
L[N]={base:B,localName:D.substr(F+1)};
continue;
}}var C={};
var J="abcdefghijklmnopqrstuvwxyz";
var G=0;
for(var B in A){var I=J.substr(G++,1);
K[I]=B;
C[B]=I;
}for(var N in L){var E=L[N];
E.prefix=C[E.base];
}};
Exhibit.Database._Impl.prototype._loadItem=function(E,G,D){if(!("label" in E)&&!("id" in E)){SimileAjax.Debug.warn("Item entry has no label and no id: "+SimileAjax.JSON.toJSONString(E));
return ;
}var B;
if(!("label" in E)){B=E.id;
if(!this._items.contains(B)){SimileAjax.Debug.warn("Cannot add new item containing no label: "+SimileAjax.JSON.toJSONString(E));
}}else{var J=E.label;
var B=("id" in E)?E.id:J;
var C=("uri" in E)?E.uri:(D+"item#"+encodeURIComponent(B));
var I=("type" in E)?E.type:"Item";
var H=function(L){if(L.constructor.toString().indexOf("Array")==-1){return false;
}else{return true;
}};
if(H(J)){J=J[0];
}if(H(B)){B=B[0];
}if(H(C)){C=C[0];
}if(H(I)){I=I[0];
}this._items.add(B);
G(B,"uri",C);
G(B,"label",J);
G(B,"type",I);
this._ensureTypeExists(I,D);
}E.modified=E.modified||"no";
for(var A in E){if(typeof A!="string"){continue;
}if(A!="uri"&&A!="label"&&A!="id"&&A!="type"){this._ensurePropertyExists(A,D)._onNewData();
var K=E[A];
if(K instanceof Array){for(var F=0;
F<K.length;
F++){G(B,A,K[F]);
}}else{if(K!=undefined&&K!=null){G(B,A,K);
}}}}};
Exhibit.Database._Impl.prototype._ensureTypeExists=function(A,C){if(!(A in this._types)){var B=new Exhibit.Database._Type(A);
B._custom["uri"]=C+"type#"+encodeURIComponent(A);
B._custom["label"]=A;
this._types[A]=B;
}};
Exhibit.Database._Impl.prototype._ensurePropertyExists=function(B,C){if(!(B in this._properties)){var A=new Exhibit.Database._Property(B,this);
A._uri=C+"property#"+encodeURIComponent(B);
A._valueType="text";
A._label=B;
A._pluralLabel=A._label;
A._reverseLabel="reverse of "+A._label;
A._reversePluralLabel="reverse of "+A._pluralLabel;
A._groupingLabel=A._label;
A._reverseGroupingLabel=A._reverseLabel;
this._properties[B]=A;
this._propertyArray=null;
return A;
}else{return this._properties[B];
}};
Exhibit.Database._indexPut=function(B,A,G,E){var D=B[A];
if(!D){D={};
B[A]=D;
}var F=D[G];
if(!F){F=new Array();
D[G]=F;
}else{for(var C=0;
C<F.length;
C++){if(E==F[C]){return ;
}}}F.push(E);
};
Exhibit.Database._indexPutList=function(B,A,F,C){var D=B[A];
if(!D){D={};
B[A]=D;
}var E=D[F];
if(!E){D[F]=C;
}else{D[F]=D[F].concat(C);
}};
Exhibit.Database._indexRemove=function(B,A,H,F){function E(I){for(p in I){return false;
}return true;
}var D=B[A];
if(!D){return false;
}var G=D[H];
if(!G){return false;
}for(var C=0;
C<G.length;
C++){if(F==G[C]){G.splice(C,1);
if(G.length==0){delete D[H];
if(E(D)){delete B[A];
}}return true;
}}};
Exhibit.Database._indexRemoveList=function(B,A,E){var C=B[A];
if(!C){return null;
}var D=C[E];
if(!D){return null;
}delete C[E];
return D;
};
Exhibit.Database._Impl.prototype._indexFillSet=function(D,H,G,I,A){var B=D[H];
if(B){var E=B[G];
if(E){if(A){for(var C=0;
C<E.length;
C++){var F=E[C];
if(A.contains(F)){I.add(F);
}}}else{for(var C=0;
C<E.length;
C++){I.add(E[C]);
}}}}};
Exhibit.Database._Impl.prototype._indexCountDistinct=function(B,A,H,D){var E=0;
var F=B[A];
if(F){var G=F[H];
if(G){if(D){for(var C=0;
C<G.length;
C++){if(D.contains(G[C])){E++;
}}}else{E=G.length;
}}}return E;
};
Exhibit.Database._Impl.prototype._get=function(B,A,E,D,C){if(!D){D=new Exhibit.Set();
}this._indexFillSet(B,A,E,D,C);
return D;
};
Exhibit.Database._Impl.prototype._getUnion=function(A,D,F,E,B){if(!E){E=new Exhibit.Set();
}var C=this;
D.visit(function(G){C._indexFillSet(A,G,F,E,B);
});
return E;
};
Exhibit.Database._Impl.prototype._countDistinctUnion=function(A,E,F,B){var C=0;
var D=this;
E.visit(function(G){C+=D._indexCountDistinct(A,G,F,B);
});
return C;
};
Exhibit.Database._Impl.prototype._countDistinct=function(B,A,D,C){return this._indexCountDistinct(B,A,D,C);
};
Exhibit.Database._Impl.prototype._getProperties=function(B,A){var E=B[A];
var C=[];
if(E){for(var D in E){C.push(D);
}}return C;
};
Exhibit.Database._Impl.prototype.getObjects=function(B,C,D,A){return this._get(this._spo,B,C,D,A);
};
Exhibit.Database._Impl.prototype.countDistinctObjects=function(B,C,A){return this._countDistinct(this._spo,B,C,A);
};
Exhibit.Database._Impl.prototype.getObjectsUnion=function(A,C,D,B){return this._getUnion(this._spo,A,C,D,B);
};
Exhibit.Database._Impl.prototype.countDistinctObjectsUnion=function(A,C,B){return this._countDistinctUnion(this._spo,A,C,B);
};
Exhibit.Database._Impl.prototype.getSubjects=function(C,B,D,A){return this._get(this._ops,C,B,D,A);
};
Exhibit.Database._Impl.prototype.countDistinctSubjects=function(C,B,A){return this._countDistinct(this._ops,C,B,A);
};
Exhibit.Database._Impl.prototype.getSubjectsUnion=function(B,C,D,A){return this._getUnion(this._ops,B,C,D,A);
};
Exhibit.Database._Impl.prototype.countDistinctSubjectsUnion=function(B,C,A){return this._countDistinctUnion(this._ops,B,C,A);
};
Exhibit.Database._Impl.prototype.getObject=function(A,C){var B=this._spo[A];
if(B){var D=B[C];
if(D){return D[0];
}}return null;
};
Exhibit.Database._Impl.prototype.getSubject=function(C,B){var A=this._ops[C];
if(A){var D=A[B];
if(D){return D[0];
}}return null;
};
Exhibit.Database._Impl.prototype.getForwardProperties=function(A){return this._getProperties(this._spo,A);
};
Exhibit.Database._Impl.prototype.getBackwardProperties=function(A){return this._getProperties(this._ops,A);
};
Exhibit.Database._Impl.prototype.getSubjectsInRange=function(G,D,C,B,H,E){var F=this.getProperty(G);
if(F!=null){var A=F.getRangeIndex();
if(A!=null){return A.getSubjectsInRange(D,C,B,H,E);
}}return(!H)?new Exhibit.Set():H;
};
Exhibit.Database._Impl.prototype.getTypeIDs=function(A){return this.getObjectsUnion(A,"type",null,null);
};
Exhibit.Database._Impl.prototype.addStatement=function(A,C,D){var B=Exhibit.Database._indexPut;
B(this._spo,A,C,D);
B(this._ops,D,C,A);
};
Exhibit.Database._Impl.prototype.removeStatement=function(B,C,E){var F=Exhibit.Database._indexRemove;
var D=F(this._spo,B,C,E);
var A=F(this._ops,E,C,B);
return D||A;
};
Exhibit.Database._Impl.prototype.removeObjects=function(B,D){var F=Exhibit.Database._indexRemove;
var E=Exhibit.Database._indexRemoveList;
var C=E(this._spo,B,D);
if(C==null){return false;
}else{for(var A=0;
A<C.length;
A++){F(this._ops,C[A],D,B);
}return true;
}};
Exhibit.Database._Impl.prototype.removeSubjects=function(E,C){var F=Exhibit.Database._indexRemove;
var D=Exhibit.Database._indexRemoveList;
var A=D(this._ops,E,C);
if(A==null){return false;
}else{for(var B=0;
B<A.length;
B++){F(this._spo,A[B],C,E);
}return true;
}};
Exhibit.Database._Impl.prototype.removeAllStatements=function(){this._listeners.fire("onBeforeRemovingAllStatements",[]);
try{this._spo={};
this._ops={};
this._items=new Exhibit.Set();
for(var B in this._properties){this._properties[B]._onNewData();
}this._propertyArray=null;
this._listeners.fire("onAfterRemovingAllStatements",[]);
}catch(A){SimileAjax.Debug.exception(A,"Database.removeAllStatements failed");
}};
Exhibit.Database._Type=function(A){this._id=A;
this._custom={};
};
Exhibit.Database._Type.prototype={getID:function(){return this._id;
},getURI:function(){return this._custom["uri"];
},getLabel:function(){return this._custom["label"];
},getOrigin:function(){return this._custom["origin"];
},getProperty:function(A){return this._custom[A];
}};
Exhibit.Database._Property=function(B,A){this._id=B;
this._database=A;
this._rangeIndex=null;
};
Exhibit.Database._Property.prototype={getID:function(){return this._id;
},getURI:function(){return this._uri;
},getValueType:function(){return this._valueType;
},getLabel:function(){return this._label;
},getPluralLabel:function(){return this._pluralLabel;
},getReverseLabel:function(){return this._reverseLabel;
},getReversePluralLabel:function(){return this._reversePluralLabel;
},getGroupingLabel:function(){return this._groupingLabel;
},getGroupingPluralLabel:function(){return this._groupingPluralLabel;
},getOrigin:function(){return this._origin;
}};
Exhibit.Database._Property.prototype._onNewData=function(){this._rangeIndex=null;
};
Exhibit.Database._Property.prototype.getRangeIndex=function(){if(this._rangeIndex==null){this._buildRangeIndex();
}return this._rangeIndex;
};
Exhibit.Database._Property.prototype._buildRangeIndex=function(){var A;
var B=this._database;
var C=this._id;
switch(this.getValueType()){case"currency":case"number":A=function(D,E){B.getObjects(D,C,null,null).visit(function(F){if(typeof F!="number"){F=parseFloat(F);
}if(!isNaN(F)){E(F);
}});
};
break;
case"date":A=function(D,E){B.getObjects(D,C,null,null).visit(function(F){if(F!=null&&!(F instanceof Date)){F=SimileAjax.DateTime.parseIso8601DateTime(F);
}if(F instanceof Date){E(F.getTime());
}});
};
break;
default:A=function(D,E){};
}this._rangeIndex=new Exhibit.Database._RangeIndex(this._database.getAllItems(),A);
};
Exhibit.Database._RangeIndex=function(B,A){pairs=[];
B.visit(function(C){A(C,function(D){pairs.push({item:C,value:D});
});
});
pairs.sort(function(D,C){var E=D.value-C.value;
return(isNaN(E)===false)?E:D.value.localeCompare(C.value);
});
this._pairs=pairs;
};
Exhibit.Database._RangeIndex.prototype.getCount=function(){return this._pairs.length;
};
Exhibit.Database._RangeIndex.prototype.getMin=function(){return this._pairs.length>0?this._pairs[0].value:Number.POSITIVE_INFINITY;
};
Exhibit.Database._RangeIndex.prototype.getMax=function(){return this._pairs.length>0?this._pairs[this._pairs.length-1].value:Number.NEGATIVE_INFINITY;
};
Exhibit.Database._RangeIndex.prototype.getRange=function(E,D,F,G){var I=this._indexOf(D);
var A=this._pairs;
var B=A.length;
G=(G);
while(I<B){var C=A[I++];
var H=C.value;
if(H<F||(H==F&&G)){E(C.item);
}else{break;
}}};
Exhibit.Database._RangeIndex.prototype.getSubjectsInRange=function(C,B,A,F,D){if(!F){F=new Exhibit.Set();
}var E=(D!=null)?function(G){if(D.contains(G)){F.add(G);
}}:function(G){F.add(G);
};
this.getRange(E,C,B,A);
return F;
};
Exhibit.Database._RangeIndex.prototype.countRange=function(D,B,A){var G=this._indexOf(D);
var F=this._indexOf(B);
if(A){var E=this._pairs;
var C=E.length;
while(F<C){if(E[F].value==B){F++;
}else{break;
}}}return F-G;
};
Exhibit.Database._RangeIndex.prototype._indexOf=function(A){var C=this._pairs;
if(C.length==0||C[0].value>=A){return 0;
}var F=0;
var E=C.length;
while(F+1<E){var B=(F+E)>>1;
var D=C[B].value;
if(D>=A){E=B;
}else{F=B;
}}return E;
};
Exhibit.Database._Impl.prototype.isNewItem=function(A){return A in this._newItems;
};
Exhibit.Database._Impl.prototype.getItem=function(F){var C={id:F};
var B=this.getAllProperties();
for(var A in B){var E=B[A];
var D=this.getObject(F,E);
if(D){C[E]=D;
}}return C;
};
Exhibit.Database._Impl.prototype.addItem=function(A){if(!A.id){A.id=A.label;
}if(!A.modified){A.modified="yes";
}this._ensurePropertyExists(Exhibit.Database.TimestampPropertyName);
A[Exhibit.Database.TimestampPropertyName]=Exhibit.Database.makeISO8601DateString();
this.loadItems([A],"");
this._newItems[A.id]=true;
this._listeners.fire("onAfterLoadingItems",[]);
};
Exhibit.Database._Impl.prototype.editItem=function(F,E,C){if(E.toLowerCase()=="id"){Exhibit.UI.showHelp("We apologize, but changing the IDs of items in the Exhibit isn't supported at the moment.");
return ;
}var D=this.getObject(F,E);
this._originalValues[F]=this._originalValues[F]||{};
this._originalValues[F][E]=this._originalValues[F][E]||D;
var A=this._originalValues[F][E];
if(A==C){this.removeObjects(F,"modified");
this.addStatement(F,"modified","no");
delete this._originalValues[F][E];
}else{if(this.getObject(F,"modified")!="yes"){this.removeObjects(F,"modified");
this.addStatement(F,"modified","yes");
}}this.removeObjects(F,E);
this.addStatement(F,E,C);
var B=this._ensurePropertyExists(E);
B._onNewData();
this._listeners.fire("onAfterLoadingItems",[]);
};
Exhibit.Database._Impl.prototype.removeItem=function(D){if(!this.containsItem(D)){throw"Removing non-existent item "+D;
}this._items.remove(D);
delete this._spo[D];
if(this._newItems[D]){delete this._newItems[D];
}if(this._originalValues[D]){delete this._originalValues[D];
}var B=this.getAllProperties();
for(var A in B){var C=B[A];
this.removeObjects(D,C);
}this._listeners.fire("onAfterLoadingItems",[]);
};
Exhibit.Database.defaultIgnoredProperties=["uri","modified"];
Exhibit.Database._Impl.prototype.fixAllChanges=function(){this._originalValues={};
this._newItems={};
var A=this._items.toArray();
for(var B in A){var C=A[B];
this.removeObjects(C,"modified");
this.addStatement(C,"modified","no");
}};
Exhibit.Database._Impl.prototype.fixChangesForItem=function(A){delete this._originalValues[A];
delete this._newItems[A];
this.removeObjects(A,"modified");
this.addStatement(A,"modified","no");
};
Exhibit.Database._Impl.prototype.collectChangesForItem=function(B,E){E=E||Exhibit.Database.defaultIgnoredProperties;
var I=this.getObject(B,"type");
var K=this.getObject(B,"label")||B;
var M={id:B,label:K,type:I,vals:{}};
if(B in this._newItems){M.changeType="added";
var H=this.getAllProperties();
for(var G in H){var A=H[G];
if(E.indexOf(A)!=-1){continue;
}var D=this.getObject(B,A);
if(D){M.vals[A]={newVal:D};
}}}else{if(B in this._originalValues&&!this.isSubmission(B)){M.changeType="modified";
var J=this._originalValues[B];
var F=false;
for(var A in J){if(E.indexOf(A)!=-1){continue;
}F=true;
var L=this._originalValues[B][A];
var C=this.getObject(B,A);
if(!C){SimileAjax.Debug.warn("empty value for "+B+", "+A);
}else{M.vals[A]={oldVal:L,newVal:C};
}}if(!F){return null;
}}else{return null;
}}if(!M[Exhibit.Database.TimestampPropertyName]){M[Exhibit.Database.TimestampPropertyName]=Exhibit.Database.makeISO8601DateString();
}return M;
};
Exhibit.Database._Impl.prototype.collectAllChanges=function(E){var B=[];
var A=this._items.toArray();
for(var C in A){var F=A[C];
var D=this.collectChangesForItem(F,E);
if(D){B.push(D);
}}return B;
};
Exhibit.Database._Impl.prototype.mergeSubmissionIntoItem=function(C){var A=this;
if(!this.isSubmission(C)){throw C+" is not a submission!";
}var E=this.getObject(C,"change");
if(E=="modification"){var D=this.getObject(C,"changedItem");
var B=this._spo[C];
SimileAjax.jQuery.each(B,function(F,G){if(Exhibit.Database.defaultIgnoredSubmissionProperties.indexOf(F)!=-1){return ;
}if(G.length==1){A.editItem(D,F,G[0]);
}else{SimileAjax.Debug.warn("Exhibit.Database._Impl.prototype.commitChangeToItem cannot handle multiple values for attribute "+F+": "+G);
}});
delete this._submissionRegistry[C];
}else{if(E=="addition"){delete this._submissionRegistry[C];
this._newItems[C]=true;
}else{throw"unknown change type "+E;
}}this._listeners.fire("onAfterLoadingItems",[]);
};


/* bibtex-exporter.js */
Exhibit.BibtexExporter={getLabel:function(){return"Bibtex";
},_excludeProperties:{"pub-type":true,"type":true,"uri":true,"key":true}};
Exhibit.BibtexExporter.exportOne=function(B,A){return Exhibit.BibtexExporter._wrap(Exhibit.BibtexExporter._exportOne(B,A));
};
Exhibit.BibtexExporter.exportMany=function(C,B){var A="";
C.visit(function(D){A+=Exhibit.BibtexExporter._exportOne(D,B)+"\n";
});
return Exhibit.BibtexExporter._wrap(A);
};
Exhibit.BibtexExporter._exportOne=function(A,I){var L="";
var D=I.getObject(A,"pub-type");
var J=I.getObject(A,"key");
J=(J!=null?J:A);
J=J.replace(/[\s,]/g,"-");
L+="@"+D+"{"+J+",\n";
var E=I.getAllProperties();
for(var C=0;
C<E.length;
C++){var K=E[C];
var H=I.getProperty(K);
var G=I.getObjects(A,K);
var B=H.getValueType();
if(G.size()>0&&!(K in Exhibit.BibtexExporter._excludeProperties)){L+="\t"+(K=="label"?"title":K)+' = "';
var F;
if(B=="item"){F=[];
G.visit(function(M){F.push(I.getObject(M,"label"));
});
}else{if(B=="url"){F=[];
G.visit(function(M){F.push(Exhibit.Persistence.resolveURL(M));
});
}else{F=G.toArray();
}}L+=F.join(" and ")+'",\n';
}}L+='\torigin = "'+Exhibit.Persistence.getItemLink(A)+'"\n';
L+="}\n";
return L;
};
Exhibit.BibtexExporter._wrap=function(A){return A;
};


/* exhibit-json-exporter.js */
Exhibit.ExhibitJsonExporter={getLabel:function(){return Exhibit.l10n.exhibitJsonExporterLabel;
}};
Exhibit.ExhibitJsonExporter.exportOne=function(B,A){return Exhibit.ExhibitJsonExporter._wrap(Exhibit.ExhibitJsonExporter._exportOne(B,A)+"\n");
};
Exhibit.ExhibitJsonExporter.exportMany=function(E,D){var B="";
var A=E.size();
var C=0;
E.visit(function(F){B+=Exhibit.ExhibitJsonExporter._exportOne(F,D)+((C++<A-1)?",\n":"\n");
});
return Exhibit.ExhibitJsonExporter._wrap(B);
};
Exhibit.ExhibitJsonExporter._exportOne=function(B,K){function A(N){if(/[\\\x00-\x1F\x22]/.test(N)){return'"'+N.replace(/([\\\x00-\x1f\x22])/g,function(P,O){var Q={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"}[O];
if(Q){return Q;
}Q=O.charCodeAt();
return"\\x"+Math.floor(Q/16).toString(16)+(Q%16).toString(16);
})+'"';
}return'"'+N+'"';
}var M="";
var C=K.getObject(B,"uri");
M+='  {"id":'+A(B)+",\n";
var H=K.getAllProperties();
for(var F=0;
F<H.length;
F++){var L=H[F];
var J=K.getProperty(L);
var I=K.getObjects(B,L);
var D=J.getValueType();
if(I.size()>0){var G;
if(D=="url"){G=[];
I.visit(function(N){G.push(Exhibit.Persistence.resolveURL(N));
});
}else{G=I.toArray();
}M+="   "+A(L)+":";
if(G.length==1){M+=A(G[0]);
}else{M+="[";
for(var E=0;
E<G.length;
E++){M+=(E>0?",":"")+A(G[E]);
}M+="]";
}M+=",\n";
}}M+='   "origin":'+A(Exhibit.Persistence.getItemLink(B))+"\n";
M+="  }";
return M;
};
Exhibit.ExhibitJsonExporter._wrap=function(A){return'{\n "items":[\n'+A+" ]\n}";
};


/* facet-selection-exporter.js */
Exhibit.FacetSelectionExporter={getLabel:function(){return"Facet Selections";
},exportOne:function(B,A){return Exhibit.FacetSelectionExporter._exportUrl();
},exportMany:function(B,A){return Exhibit.FacetSelectionExporter._exportUrl();
}};
Exhibit.FacetSelectionExporter._exportUrl=function(){var A=window.exhibit.exportSettings();
var C=window.location.href.split("?")[0]+"?";
var B="";
for(id in A){C+=B+id+"="+escape(A[id]);
if(B===""){B="&";
}}return C;
};


/* rdf-xml-exporter.js */
Exhibit.RdfXmlExporter={getLabel:function(){return Exhibit.l10n.rdfXmlExporterLabel;
}};
Exhibit.RdfXmlExporter.exportOne=function(D,C){var B={};
var A={};
C.getNamespaces(B,A);
return Exhibit.RdfXmlExporter._wrapRdf(Exhibit.RdfXmlExporter._exportOne(D,C,B,A),A);
};
Exhibit.RdfXmlExporter.exportMany=function(E,D){var B="";
var C={};
var A={};
D.getNamespaces(C,A);
E.visit(function(F){B+=Exhibit.RdfXmlExporter._exportOne(F,D,C,A)+"\n";
});
return Exhibit.RdfXmlExporter._wrapRdf(B,A);
};
Exhibit.RdfXmlExporter._exportOne=function(A,L,B,I){var N="";
var C=L.getObject(A,"uri");
N+="<rdf:Description rdf:about='"+C+"'>\n";
var H=L.getAllProperties();
for(var F=0;
F<H.length;
F++){var M=H[F];
var K=L.getProperty(M);
var J=L.getObjects(A,M);
var E=K.getValueType();
var G;
if(M in B){var D=B[M];
G=D.prefix+":"+D.localName;
}else{G=K.getURI();
}if(E=="item"){J.visit(function(O){N+="\t<"+G+" rdf:resource='"+O+"' />\n";
});
}else{if(M!="uri"){if(E=="url"){J.visit(function(O){N+="\t<"+G+">"+Exhibit.Persistence.resolveURL(O)+"</"+G+">\n";
});
}else{J.visit(function(O){N+="\t<"+G+">"+O+"</"+G+">\n";
});
}}}}N+="\t<exhibit:origin>"+Exhibit.Persistence.getItemLink(A)+"</exhibit:origin>\n";
N+="</rdf:Description>";
return N;
};
Exhibit.RdfXmlExporter._wrapRdf=function(C,B){var A="<?xml version='1.0'?>\n<rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'\n\txmlns:exhibit='http://simile.mit.edu/2006/11/exhibit#'";
for(prefix in B){A+="\n\txmlns:"+prefix+"='"+B[prefix]+"'";
}A+=">\n"+C+"\n</rdf:RDF>";
return A;
};


/* semantic-wikitext-exporter.js */
Exhibit.SemanticWikitextExporter={getLabel:function(){return Exhibit.l10n.smwExporterLabel;
}};
Exhibit.SemanticWikitextExporter.exportOne=function(B,A){return Exhibit.SemanticWikitextExporter._wrap(Exhibit.SemanticWikitextExporter._exportOne(B,A));
};
Exhibit.SemanticWikitextExporter.exportMany=function(C,B){var A="";
C.visit(function(D){A+=Exhibit.SemanticWikitextExporter._exportOne(D,B)+"\n";
});
return Exhibit.SemanticWikitextExporter._wrap(A);
};
Exhibit.SemanticWikitextExporter._exportOne=function(A,G){var J="";
var B=G.getObject(A,"uri");
J+=B+"\n";
var E=G.getAllProperties();
for(var D=0;
D<E.length;
D++){var I=E[D];
var H=G.getProperty(I);
var F=G.getObjects(A,I);
var C=H.getValueType();
if(C=="item"){F.visit(function(K){J+="[["+I+"::"+K+"]]\n";
});
}else{if(C=="url"){F.visit(function(K){J+="[["+I+":="+Exhibit.Persistence.resolveURL(K)+"]]\n";
});
}else{F.visit(function(K){J+="[["+I+":="+K+"]]\n";
});
}}}J+="[[origin:="+Exhibit.Persistence.getItemLink(A)+"]]\n";
J+="\n";
return J;
};
Exhibit.SemanticWikitextExporter._wrap=function(A){return A;
};


/* tsv-exporter.js */
Exhibit.TSVExporter={getLabel:function(){return Exhibit.l10n.tsvExporterLabel;
}};
Exhibit.TSVExporter.exportOne=function(B,A){return Exhibit.TSVExporter._wrap(Exhibit.TSVExporter._exportOne(B,A),A);
};
Exhibit.TSVExporter.exportMany=function(C,B){var A="";
C.visit(function(D){A+=Exhibit.TSVExporter._exportOne(D,B)+"\n";
});
return Exhibit.TSVExporter._wrap(A,B);
};
Exhibit.TSVExporter._exportOne=function(A,E){var I="";
var D=E.getAllProperties();
for(var C=0;
C<D.length;
C++){var H=D[C];
var F=E.getProperty(H);
var G=E.getObjects(A,H);
var B=F.getValueType();
I+=G.toArray().join("; ")+"\t";
}return I;
};
Exhibit.TSVExporter._wrap=function(C,E){var H="";
var B=E.getAllProperties();
for(var A=0;
A<B.length;
A++){var F=B[A];
var D=E.getProperty(F);
var G=D.getValueType();
H+=F+":"+G+"\t";
}return H+"\n"+C;
};


/* expression-parser.js */
Exhibit.ExpressionParser=new Object();
Exhibit.ExpressionParser.parse=function(C,D,A){D=D||0;
A=A||{};
var B=new Exhibit.ExpressionScanner(C,D);
try{return Exhibit.ExpressionParser._internalParse(B,false);
}finally{A.index=B.token()!=null?B.token().start:B.index();
}};
Exhibit.ExpressionParser.parseSeveral=function(C,D,A){D=D||0;
A=A||{};
var B=new Exhibit.ExpressionScanner(C,D);
try{return Exhibit.ExpressionParser._internalParse(B,true);
}finally{A.index=B.token()!=null?B.token().start:B.index();
}};
Exhibit.ExpressionParser._internalParse=function(H,O){var B=Exhibit.ExpressionScanner;
var G=H.token();
var I=function(){H.next();
G=H.token();
};
var K=function(){return G!=null?G.start:H.index();
};
var L=function(){var Q=new Exhibit.Expression.Path();
while(G!=null&&G.type==B.PATH_OPERATOR){var P=G.value;
I();
if(G!=null&&G.type==B.IDENTIFIER){Q.appendSegment(G.value,P);
I();
}else{throw new Error("Missing property ID at position "+K());
}}return Q;
};
var M=function(){if(G==null){throw new Error("Missing factor at end of expression");
}var P=null;
switch(G.type){case B.NUMBER:P=new Exhibit.Expression._Constant(G.value,"number");
I();
break;
case B.STRING:P=new Exhibit.Expression._Constant(G.value,"text");
I();
break;
case B.PATH_OPERATOR:P=L();
break;
case B.IDENTIFIER:var R=G.value;
I();
if(R in Exhibit.Controls){if(G!=null&&G.type==B.DELIMITER&&G.value=="("){I();
var Q=(G!=null&&G.type==B.DELIMITER&&G.value==")")?[]:E();
P=new Exhibit.Expression._ControlCall(R,Q);
if(G!=null&&G.type==B.DELIMITER&&G.value==")"){I();
}else{throw new Error("Missing ) to end "+R+" at position "+K());
}}else{throw new Error("Missing ( to start "+R+" at position "+K());
}}else{if(G!=null&&G.type==B.DELIMITER&&G.value=="("){I();
var Q=(G!=null&&G.type==B.DELIMITER&&G.value==")")?[]:E();
P=new Exhibit.Expression._FunctionCall(R,Q);
if(G!=null&&G.type==B.DELIMITER&&G.value==")"){I();
}else{throw new Error("Missing ) after function call "+R+" at position "+K());
}}else{P=L();
P.setRootName(R);
}}break;
case B.DELIMITER:if(G.value=="("){I();
P=C();
if(G!=null&&G.type==B.DELIMITER&&G.value==")"){I();
break;
}else{throw new Error("Missing ) at position "+K());
}}default:throw new Error("Unexpected text "+G.value+" at position "+K());
}return P;
};
var D=function(){var Q=M();
while(G!=null&&G.type==B.OPERATOR&&(G.value=="*"||G.value=="/")){var P=G.value;
I();
Q=new Exhibit.Expression._Operator(P,[Q,M()]);
}return Q;
};
var F=function(){var Q=D();
while(G!=null&&G.type==B.OPERATOR&&(G.value=="+"||G.value=="-")){var P=G.value;
I();
Q=new Exhibit.Expression._Operator(P,[Q,D()]);
}return Q;
};
var C=function(){var Q=F();
while(G!=null&&G.type==B.OPERATOR&&(G.value=="="||G.value=="<>"||G.value=="<"||G.value=="<="||G.value==">"||G.value==">=")){var P=G.value;
I();
Q=new Exhibit.Expression._Operator(P,[Q,F()]);
}return Q;
};
var E=function(){var P=[C()];
while(G!=null&&G.type==B.DELIMITER&&G.value==","){I();
P.push(C());
}return P;
};
if(O){var N=E();
var J=[];
for(var A=0;
A<N.length;
A++){J.push(new Exhibit.Expression._Impl(N[A]));
}return J;
}else{return new Exhibit.Expression._Impl(C());
}};
Exhibit.ExpressionScanner=function(B,A){this._text=B+" ";
this._maxIndex=B.length;
this._index=A;
this.next();
};
Exhibit.ExpressionScanner.DELIMITER=0;
Exhibit.ExpressionScanner.NUMBER=1;
Exhibit.ExpressionScanner.STRING=2;
Exhibit.ExpressionScanner.IDENTIFIER=3;
Exhibit.ExpressionScanner.OPERATOR=4;
Exhibit.ExpressionScanner.PATH_OPERATOR=5;
Exhibit.ExpressionScanner.prototype.token=function(){return this._token;
};
Exhibit.ExpressionScanner.prototype.index=function(){return this._index;
};
Exhibit.ExpressionScanner.prototype.next=function(){this._token=null;
while(this._index<this._maxIndex&&" \t\r\n".indexOf(this._text.charAt(this._index))>=0){this._index++;
}if(this._index<this._maxIndex){var C=this._text.charAt(this._index);
var B=this._text.charAt(this._index+1);
if(".!".indexOf(C)>=0){if(B=="@"){this._token={type:Exhibit.ExpressionScanner.PATH_OPERATOR,value:C+B,start:this._index,end:this._index+2};
this._index+=2;
}else{this._token={type:Exhibit.ExpressionScanner.PATH_OPERATOR,value:C,start:this._index,end:this._index+1};
this._index++;
}}else{if("<>".indexOf(C)>=0){if((B=="=")||("<>".indexOf(B)>=0&&C!=B)){this._token={type:Exhibit.ExpressionScanner.OPERATOR,value:C+B,start:this._index,end:this._index+2};
this._index+=2;
}else{this._token={type:Exhibit.ExpressionScanner.OPERATOR,value:C,start:this._index,end:this._index+1};
this._index++;
}}else{if("+-*/=".indexOf(C)>=0){this._token={type:Exhibit.ExpressionScanner.OPERATOR,value:C,start:this._index,end:this._index+1};
this._index++;
}else{if("(),".indexOf(C)>=0){this._token={type:Exhibit.ExpressionScanner.DELIMITER,value:C,start:this._index,end:this._index+1};
this._index++;
}else{if("\"'".indexOf(C)>=0){var A=this._index+1;
while(A<this._maxIndex){if(this._text.charAt(A)==C&&this._text.charAt(A-1)!="\\"){break;
}A++;
}if(A<this._maxIndex){this._token={type:Exhibit.ExpressionScanner.STRING,value:this._text.substring(this._index+1,A).replace(/\\'/g,"'").replace(/\\"/g,'"'),start:this._index,end:A+1};
this._index=A+1;
}else{throw new Error("Unterminated string starting at "+this._index);
}}else{if(this._isDigit(C)){var A=this._index;
while(A<this._maxIndex&&this._isDigit(this._text.charAt(A))){A++;
}if(A<this._maxIndex&&this._text.charAt(A)=="."){A++;
while(A<this._maxIndex&&this._isDigit(this._text.charAt(A))){A++;
}}this._token={type:Exhibit.ExpressionScanner.NUMBER,value:parseFloat(this._text.substring(this._index,A)),start:this._index,end:A};
this._index=A;
}else{var A=this._index;
while(A<this._maxIndex){var D=this._text.charAt(A);
if("(),.!@ \t".indexOf(D)<0){A++;
}else{break;
}}this._token={type:Exhibit.ExpressionScanner.IDENTIFIER,value:this._text.substring(this._index,A),start:this._index,end:A};
this._index=A;
}}}}}}}};
Exhibit.ExpressionScanner.prototype._isDigit=function(A){return"0123456789".indexOf(A)>=0;
};


/* expression.js */
Exhibit.Expression=new Object();
Exhibit.Expression._Impl=function(A){this._rootNode=A;
};
Exhibit.Expression._Impl.prototype.evaluate=function(A,B,E,C){var D=this._rootNode.evaluate(A,B,E,C);
return{values:D.getSet(),valueType:D.valueType,size:D.size};
};
Exhibit.Expression._Impl.prototype.evaluateOnItem=function(B,A){return this.evaluate({"value":B},{"value":"item"},"value",A);
};
Exhibit.Expression._Impl.prototype.evaluateSingle=function(B,C,F,D){var E=this._rootNode.evaluate(B,C,F,D);
var A={value:null,valueType:E.valueType};
E.forEachValue(function(G){A.value=G;
return true;
});
return A;
};
Exhibit.Expression._Impl.prototype.evaluateSingleOnItem=function(B,A){return this.evaluateSingle({"value":B},{"value":"item"},"value",A);
};
Exhibit.Expression._Impl.prototype.testExists=function(A,B,D,C){return this.isPath()?this._rootNode.testExists(A,B,D,C):this.evaluate(A,B,D,C).values.size()>0;
};
Exhibit.Expression._Impl.prototype.isPath=function(){return this._rootNode instanceof Exhibit.Expression.Path;
};
Exhibit.Expression._Impl.prototype.getPath=function(){return this.isPath()?this._rootNode:null;
};
Exhibit.Expression._Collection=function(A,B){this._values=A;
this.valueType=B;
if(A instanceof Array){this.forEachValue=Exhibit.Expression._Collection._forEachValueInArray;
this.getSet=Exhibit.Expression._Collection._getSetFromArray;
this.contains=Exhibit.Expression._Collection._containsInArray;
this.size=A.length;
}else{this.forEachValue=Exhibit.Expression._Collection._forEachValueInSet;
this.getSet=Exhibit.Expression._Collection._getSetFromSet;
this.contains=Exhibit.Expression._Collection._containsInSet;
this.size=A.size();
}};
Exhibit.Expression._Collection._forEachValueInSet=function(A){this._values.visit(A);
};
Exhibit.Expression._Collection._forEachValueInArray=function(C){var A=this._values;
for(var B=0;
B<A.length;
B++){if(C(A[B])){break;
}}};
Exhibit.Expression._Collection._getSetFromSet=function(){return this._values;
};
Exhibit.Expression._Collection._getSetFromArray=function(){return new Exhibit.Set(this._values);
};
Exhibit.Expression._Collection._containsInSet=function(A){this._values.contains(A);
};
Exhibit.Expression._Collection._containsInArray=function(B){var A=this._values;
for(var C=0;
C<A.length;
C++){if(A[C]==B){return true;
}}return false;
};
Exhibit.Expression.Path=function(){this._rootName=null;
this._segments=[];
};
Exhibit.Expression.Path.create=function(B,A){var C=new Exhibit.Expression.Path();
C._segments.push({property:B,forward:A,isArray:false});
return C;
};
Exhibit.Expression.Path.prototype.setRootName=function(A){this._rootName=A;
};
Exhibit.Expression.Path.prototype.appendSegment=function(B,A){this._segments.push({property:B,forward:A.charAt(0)==".",isArray:A.length>1});
};
Exhibit.Expression.Path.prototype.getSegment=function(A){if(A<this._segments.length){var B=this._segments[A];
return{property:B.property,forward:B.forward,isArray:B.isArray};
}else{return null;
}};
Exhibit.Expression.Path.prototype.getLastSegment=function(){return this.getSegment(this._segments.length-1);
};
Exhibit.Expression.Path.prototype.getSegmentCount=function(){return this._segments.length;
};
Exhibit.Expression.Path.prototype.evaluate=function(B,C,H,D){var G=this._rootName!=null?this._rootName:H;
var F=G in C?C[G]:"text";
var E=null;
if(G in B){var A=B[G];
if(A instanceof Exhibit.Set||A instanceof Array){E=new Exhibit.Expression._Collection(A,F);
}else{E=new Exhibit.Expression._Collection([A],F);
}return this._walkForward(E,D);
}else{throw new Error("No such variable called "+G);
}};
Exhibit.Expression.Path.prototype.evaluateBackward=function(C,E,A,B){var D=new Exhibit.Expression._Collection([C],E);
return this._walkBackward(D,A,B);
};
Exhibit.Expression.Path.prototype.walkForward=function(A,C,B){return this._walkForward(new Exhibit.Expression._Collection(A,C),B);
};
Exhibit.Expression.Path.prototype.walkBackward=function(A,D,B,C){return this._walkBackward(new Exhibit.Expression._Collection(A,D),B,C);
};
Exhibit.Expression.Path.prototype._walkForward=function(G,F){for(var C=0;
C<this._segments.length;
C++){var D=this._segments[C];
if(D.isArray){var A=[];
var H;
if(D.forward){G.forEachValue(function(I){F.getObjects(I,D.property).visit(function(J){A.push(J);
});
});
var E=F.getProperty(D.property);
H=E!=null?E.getValueType():"text";
}else{G.forEachValue(function(I){F.getSubjects(I,D.property).visit(function(J){A.push(J);
});
});
H="item";
}G=new Exhibit.Expression._Collection(A,H);
}else{if(D.forward){var B=F.getObjectsUnion(G.getSet(),D.property);
var E=F.getProperty(D.property);
var H=E!=null?E.getValueType():"text";
G=new Exhibit.Expression._Collection(B,H);
}else{var B=F.getSubjectsUnion(G.getSet(),D.property);
G=new Exhibit.Expression._Collection(B,"item");
}}}return G;
};
Exhibit.Expression.Path.prototype._walkBackward=function(D,A,H){for(var C=this._segments.length-1;
C>=0;
C--){var E=this._segments[C];
if(E.isArray){var F=[];
var B;
if(E.forward){D.forEachValue(function(J){H.getSubjects(J,E.property).visit(function(K){if(C>0||A==null||A.contains(K)){F.push(K);
}});
});
var I=H.getProperty(E.property);
B=I!=null?I.getValueType():"text";
}else{D.forEachValue(function(J){H.getObjects(J,E.property).visit(function(K){if(C>0||A==null||A.contains(K)){F.push(K);
}});
});
B="item";
}D=new Exhibit.Expression._Collection(F,B);
}else{if(E.forward){var G=H.getSubjectsUnion(D.getSet(),E.property,null,C==0?A:null);
D=new Exhibit.Expression._Collection(G,"item");
}else{var G=H.getObjectsUnion(D.getSet(),E.property,null,C==0?A:null);
var I=H.getProperty(E.property);
var B=I!=null?I.getValueType():"text";
D=new Exhibit.Expression._Collection(G,B);
}}}return D;
};
Exhibit.Expression.Path.prototype.rangeBackward=function(F,G,E,A,J){var H=new Exhibit.Set();
var B="item";
if(this._segments.length>0){var D=this._segments[this._segments.length-1];
if(D.forward){J.getSubjectsInRange(D.property,F,G,E,H,this._segments.length==1?A:null);
}else{throw new Error("Last path of segment must be forward");
}for(var C=this._segments.length-2;
C>=0;
C--){D=this._segments[C];
if(D.forward){H=J.getSubjectsUnion(H,D.property,null,C==0?A:null);
B="item";
}else{H=J.getObjectsUnion(H,D.property,null,C==0?A:null);
var I=J.getProperty(D.property);
B=I!=null?I.getValueType():"text";
}}}return{valueType:B,values:H,count:H.size()};
};
Exhibit.Expression.Path.prototype.testExists=function(A,B,D,C){return this.evaluate(A,B,D,C).size>0;
};
Exhibit.Expression._Constant=function(A,B){this._value=A;
this._valueType=B;
};
Exhibit.Expression._Constant.prototype.evaluate=function(A,B,D,C){return new Exhibit.Expression._Collection([this._value],this._valueType);
};
Exhibit.Expression._Operator=function(A,B){this._operator=A;
this._args=B;
};
Exhibit.Expression._Operator.prototype.evaluate=function(H,I,B,F){var G=[];
var E=[];
for(var C=0;
C<this._args.length;
C++){E.push(this._args[C].evaluate(H,I,B,F));
}var A=Exhibit.Expression._operators[this._operator];
var D=A.f;
if(A.argumentType=="number"){E[0].forEachValue(function(J){if(!(typeof J=="number")){J=parseFloat(J);
}E[1].forEachValue(function(K){if(!(typeof K=="number")){K=parseFloat(K);
}G.push(D(J,K));
});
});
}else{E[0].forEachValue(function(J){E[1].forEachValue(function(K){G.push(D(J,K));
});
});
}return new Exhibit.Expression._Collection(G,A.valueType);
};
Exhibit.Expression._operators={"+":{argumentType:"number",valueType:"number",f:function(B,A){return B+A;
}},"-":{argumentType:"number",valueType:"number",f:function(B,A){return B-A;
}},"*":{argumentType:"number",valueType:"number",f:function(B,A){return B*A;
}},"/":{argumentType:"number",valueType:"number",f:function(B,A){return B/A;
}},"=":{valueType:"boolean",f:function(B,A){return B==A;
}},"<>":{valueType:"boolean",f:function(B,A){return B!=A;
}},"><":{valueType:"boolean",f:function(B,A){return B!=A;
}},"<":{argumentType:"number",valueType:"boolean",f:function(B,A){return B<A;
}},">":{argumentType:"number",valueType:"boolean",f:function(B,A){return B>A;
}},"<=":{argumentType:"number",valueType:"boolean",f:function(B,A){return B<=A;
}},">=":{argumentType:"number",valueType:"boolean",f:function(B,A){return B>=A;
}}};
Exhibit.Expression._FunctionCall=function(B,A){this._name=B;
this._args=A;
};
Exhibit.Expression._FunctionCall.prototype.evaluate=function(A,C,F,E){var B=[];
for(var D=0;
D<this._args.length;
D++){B.push(this._args[D].evaluate(A,C,F,E));
}if(this._name in Exhibit.Functions){return Exhibit.Functions[this._name].f(B);
}else{throw new Error("No such function named "+this._name);
}};
Exhibit.Expression._ControlCall=function(B,A){this._name=B;
this._args=A;
};
Exhibit.Expression._ControlCall.prototype.evaluate=function(A,B,D,C){return Exhibit.Controls[this._name].f(this._args,A,B,D,C);
};


/* functions.js */
Exhibit.Functions={};
Exhibit.FunctionUtilities={};
Exhibit.FunctionUtilities.registerSimpleMappingFunction=function(A,B,C){Exhibit.Functions[A]={f:function(D){var F=new Exhibit.Set();
for(var E=0;
E<D.length;
E++){D[E].forEachValue(function(G){var H=B(G);
if(H!=undefined){F.add(H);
}});
}return new Exhibit.Expression._Collection(F,C);
}};
};
Exhibit.Functions["union"]={f:function(B){var E=new Exhibit.Set();
var D=null;
if(B.length>0){var D=B[0].valueType;
for(var C=0;
C<B.length;
C++){var A=B[C];
if(A.size>0){if(D==null){D=A.valueType;
}E.addSet(A.getSet());
}}}return new Exhibit.Expression._Collection(E,D!=null?D:"text");
}};
Exhibit.Functions["contains"]={f:function(B){var A=B[0].size>0;
var C=B[0].getSet();
B[1].forEachValue(function(D){if(!C.contains(D)){A=false;
return true;
}});
return new Exhibit.Expression._Collection([A],"boolean");
}};
Exhibit.Functions["exists"]={f:function(A){return new Exhibit.Expression._Collection([A[0].size>0],"boolean");
}};
Exhibit.Functions["count"]={f:function(A){return new Exhibit.Expression._Collection([A[0].size],"number");
}};
Exhibit.Functions["not"]={f:function(A){return new Exhibit.Expression._Collection([!A[0].contains(true)],"boolean");
}};
Exhibit.Functions["and"]={f:function(A){var C=true;
for(var B=0;
C&&B<A.length;
B++){C=C&&A[B].contains(true);
}return new Exhibit.Expression._Collection([C],"boolean");
}};
Exhibit.Functions["or"]={f:function(A){var C=false;
for(var B=0;
C&&B<A.length;
B++){C=C||A[B].contains(true);
}return new Exhibit.Expression._Collection([C],"boolean");
}};
Exhibit.Functions["add"]={f:function(A){var C=0;
for(var B=0;
B<A.length;
B++){A[B].forEachValue(function(D){if(D!=null){if(typeof D=="number"){C+=D;
}else{var E=parseFloat(D);
if(!isNaN(E)){C+=E;
}}}});
}return new Exhibit.Expression._Collection([C],"number");
}};
Exhibit.Functions["concat"]={f:function(B){var A=[];
for(var C=0;
C<B.length;
C++){B[C].forEachValue(function(D){if(D!=null){A.push(D);
}});
}return new Exhibit.Expression._Collection([A.join("")],"text");
}};
Exhibit.Functions["multiply"]={f:function(A){var C=1;
for(var B=0;
B<A.length;
B++){A[B].forEachValue(function(D){if(D!=null){if(typeof D=="number"){C*=D;
}else{var E=parseFloat(D);
if(!isNaN(E)){C*=E;
}}}});
}return new Exhibit.Expression._Collection([C],"number");
}};
Exhibit.Functions["date-range"]={_parseDate:function(A){if(A==null){return Number.NEGATIVE_INFINITY;
}else{if(A instanceof Date){return A.getTime();
}else{try{return SimileAjax.DateTime.parseIso8601DateTime(A).getTime();
}catch(B){return Number.NEGATIVE_INFINITY;
}}}},_factors:{second:1000,minute:60*1000,hour:60*60*1000,day:24*60*60*1000,week:7*24*60*60*1000,month:30*24*60*60*1000,quarter:3*30*24*60*60*1000,year:365*24*60*60*1000,decade:10*365*24*60*60*1000,century:100*365*24*60*60*1000},_computeRange:function(D,C,B){var A=C-D;
if(isFinite(A)){if(B in this._factors){A=Math.round(A/this._factors[B]);
}return A;
}return null;
},f:function(D){var C=this;
var F=Number.POSITIVE_INFINITY;
D[0].forEachValue(function(G){F=Math.min(F,C._parseDate(G));
});
var E=Number.NEGATIVE_INFINITY;
D[1].forEachValue(function(G){E=Math.max(E,C._parseDate(G));
});
var B="day";
D[2].forEachValue(function(G){B=G;
});
var A=this._computeRange(F,E,B);
return new Exhibit.Expression._Collection(A!=null?[A]:[],"number");
}};
Exhibit.Functions["distance"]={_units:{km:1000,mile:1609.344},_computeDistance:function(E,D,B,C){var A=E.distanceFrom(D);
if(!C){C=1;
}if(isFinite(A)){if(this._units.hasOwnProperty(B)){A=A/this._units[B];
}return Exhibit.Util.round(A,C);
}return null;
},f:function(G){var J=this;
var D={};
var A=["origo","lat","lng","unit","round"];
for(var E=0,C;
C=A[E];
E++){G[E].forEachValue(function(K){D[C]=K;
});
}var B=D.origo.split(",");
var I=new GLatLng(B[0],B[1]);
var H=new GLatLng(D.lat,D.lng);
var F=this._computeDistance(I,H,D.unit,D.round);
return new Exhibit.Expression._Collection(F!=null?[F]:[],"number");
}};
Exhibit.Functions["min"]={f:function(D){var C=function(I){return I;
};
var F=Number.POSITIVE_INFINITY;
var H=null;
for(var E=0;
E<D.length;
E++){var B=D[E];
var A=B.valueType?B.valueType:"text";
var G=Exhibit.SettingsUtilities._typeToParser(A);
B.forEachValue(function(I){parsedV=G(I,C);
if(parsedV<F||F==Number.POSITIVE_INFINITY){F=parsedV;
H=(H==null)?A:(H==A?H:"text");
}});
}return new Exhibit.Expression._Collection([F],H!=null?H:"text");
}};
Exhibit.Functions["max"]={f:function(E){var D=function(I){return I;
};
var C=Number.NEGATIVE_INFINITY;
var H=null;
for(var F=0;
F<E.length;
F++){var B=E[F];
var A=B.valueType?B.valueType:"text";
var G=Exhibit.SettingsUtilities._typeToParser(A);
B.forEachValue(function(I){parsedV=G(I,D);
if(parsedV>C||C==Number.NEGATIVE_INFINITY){C=parsedV;
H=(H==null)?A:(H==A?H:"text");
}});
}return new Exhibit.Expression._Collection([C],H!=null?H:"text");
}};
Exhibit.Functions["remove"]={f:function(B){var E=B[0].getSet();
var D=B[0].valueType;
for(var C=1;
C<B.length;
C++){var A=B[C];
if(A.size>0){E.removeSet(A.getSet());
}}return new Exhibit.Expression._Collection(E,D);
}};
Exhibit.Functions["now"]={f:function(A){return new Exhibit.Expression._Collection([new Date()],"date");
}};


/* authenticated-importer.js */
Exhibit.AuthenticatedImporter={_callbacks:{}};
Exhibit.importers["application/authenticated"]=Exhibit.AuthenticatedImporter;
Exhibit.AuthenticatedImporter.constructURL=function(){return"https://www.google.com/accounts/AuthSubRequest?scope=http%3A%2F%2Fspreadsheets.google.com%2Ffeeds%2F&session=1&secure=0&next="+window.location;
};
Exhibit.AuthenticatedImporter.load=function(link,database,cont){var url=typeof link=="string"?link:link.href;
url=Exhibit.Persistence.resolveURL(url);
var fError=function(statusText,status,xmlhttp){Exhibit.UI.hideBusyIndicator();
Exhibit.UI.showHelp(Exhibit.l10n.failedToLoadDataFileMessage(url));
if(cont){cont();
}};
var fDone=function(xmlhttp){Exhibit.UI.hideBusyIndicator();
try{var o=null;
try{o=eval("("+xmlhttp.responseText+")");
}catch(e){Exhibit.UI.showJsonFileValidation(Exhibit.l10n.badJsonMessage(url,e),url);
}if(o!=null){database.loadData(o,Exhibit.Persistence.getBaseURL(url));
}}catch(e){SimileAjax.Debug.exception(e,"Error loading Exhibit JSON data from "+url);
}finally{if(cont){cont();
}}};
Exhibit.UI.showBusyIndicator();
SimileAjax.XmlHttp.get(url,fError,fDone);
};


/* babel-based-importer.js */
Exhibit.BabelBasedImporter={mimetypeToReader:{"application/rdf+xml":"rdf-xml","application/n3":"n3","application/msexcel":"xls","application/x-msexcel":"xls","application/x-ms-excel":"xls","application/vnd.ms-excel":"xls","application/x-excel":"xls","application/xls":"xls","application/x-xls":"xls","application/x-bibtex":"bibtex"},babelTranslatorURL:"http://service.simile-widgets.org/babel/translator",_initialize:function(){var B=[];
var F=document.documentElement.getElementsByTagName("head");
for(var C=0;
C<F.length;
C++){var E=F[C].getElementsByTagName("link");
for(var A=0;
A<E.length;
A++){var D=E[A];
if(D.rel.match(/\bexhibit\/babel-translator\b/)){Exhibit.BabelBasedImporter.babelTranslatorURL=D.href;
}}}Exhibit.BabelBasedImporter._initialize=function(){};
}};
Exhibit.importers["application/rdf+xml"]=Exhibit.BabelBasedImporter;
Exhibit.importers["application/n3"]=Exhibit.BabelBasedImporter;
Exhibit.importers["application/msexcel"]=Exhibit.BabelBasedImporter;
Exhibit.importers["application/x-msexcel"]=Exhibit.BabelBasedImporter;
Exhibit.importers["application/vnd.ms-excel"]=Exhibit.BabelBasedImporter;
Exhibit.importers["application/x-excel"]=Exhibit.BabelBasedImporter;
Exhibit.importers["application/xls"]=Exhibit.BabelBasedImporter;
Exhibit.importers["application/x-xls"]=Exhibit.BabelBasedImporter;
Exhibit.importers["application/x-bibtex"]=Exhibit.BabelBasedImporter;
Exhibit.BabelBasedImporter.load=function(F,H,B){Exhibit.BabelBasedImporter._initialize();
var D=(typeof F=="string")?Exhibit.Persistence.resolveURL(F):Exhibit.Persistence.resolveURL(F.href);
var A="rdf-xml";
var G="exhibit-jsonp";
if(typeof F!="string"){var C=F.type;
if(C in Exhibit.BabelBasedImporter.mimetypeToReader){A=Exhibit.BabelBasedImporter.mimetypeToReader[C];
}}if(A=="bibtex"){G="bibtex-exhibit-jsonp";
}var E=Exhibit.BabelBasedImporter.babelTranslatorURL+"?"+["reader="+A,"writer="+G,"url="+encodeURIComponent(D)].join("&");
return Exhibit.JSONPImporter.load(E,H,B);
};


/* exhibit-json-importer.js */
Exhibit.ExhibitJSONImporter={};
Exhibit.importers["application/json"]=Exhibit.ExhibitJSONImporter;
Exhibit.ExhibitJSONImporter.load=function(link,database,cont){var url=typeof link=="string"?link:link.href;
url=Exhibit.Persistence.resolveURL(url);
var fError=function(statusText,status,xmlhttp){Exhibit.UI.hideBusyIndicator();
Exhibit.UI.showHelp(Exhibit.l10n.failedToLoadDataFileMessage(url));
if(cont){cont();
}};
var fDone=function(xmlhttp){Exhibit.UI.hideBusyIndicator();
try{var o=null;
try{o=eval("("+xmlhttp.responseText+")");
}catch(e){Exhibit.UI.showJsonFileValidation(Exhibit.l10n.badJsonMessage(url,e),url);
}if(o!=null){database.loadData(o,Exhibit.Persistence.getBaseURL(url));
}}catch(e){SimileAjax.Debug.exception(e,"Error loading Exhibit JSON data from "+url);
}finally{if(cont){cont();
}}};
Exhibit.UI.showBusyIndicator();
SimileAjax.XmlHttp.get(url,fError,fDone);
};


/* html-table-importer.js */
Exhibit.HtmlTableImporter={};
Exhibit.importers["text/html"]=Exhibit.HtmlTableImporter;
Exhibit.HtmlTableImporter.load=function(G,I,K){var A=typeof G=="string"?G:G.href;
if(A.substr(0,1)=="#"){try{var B=/#(.*)/.exec(f)[1];
var J=document.getElementById(B);
J.style.display="none";
Exhibit.HtmlTableImporter.loadTable(J,I);
}catch(E){SimileAjax.Debug.exception(E);
}finally{if(K){K();
}}}else{if(typeof G!="string"){var D=G.getAttribute("ex:xpath");
var C=(G.getAttribute("ex:columns")).split(",");
var F="http://simile.mit.edu/babel/html-extractor?"+["xpath="+D,"url="+encodeURIComponent(A)].join("&");
var H=function(N){var Q=document.createElement("div");
Q.innerHTML=N;
var P=Q.firstChild;
var O,L=P.getElementsByTagName("th");
for(col=0;
O=L[col];
col++){var M=C[col];
O.setAttribute("ex:name",M);
}Exhibit.HtmlTableImporter.loadTable(P,I);
return{};
};
return Exhibit.JSONPImporter.load(F,I,K,H);
}else{if(K){K();
}}}};
Exhibit.HtmlTableImporter.loadTable=function(b,U){var N=function(h){return h.textContent||h.innerText||"";
};
var d=function(m,k){var j={},o=false,h,n,l;
for(l=0;
h=k[l];
l++){n=Exhibit.getAttribute(m,h);
if(n){j[h]=n;
o=true;
}}return o&&j;
};
var A=["uri","label","pluralLabel"];
var E=["uri","valueType","label","reverseLabel","pluralLabel","reversePluralLabel","groupingLabel","reverseGroupingLabel"];
var a=["valueParser","arity"];
var P={};
var G=Exhibit.getAttribute(b,"type");
var Q=G&&d(b,A);
if(Q){P.types={};
P.types[G]=Q;
}var W=[],F={},H=[],M,I;
var B,R=b.getElementsByTagName("tr");
var J,D=R[0].getElementsByTagName("th");
for(I=0;
J=D[I];
I++){var C=N(J).trim();
var L=false;
var X=d(J,E);
var g=Exhibit.getAttribute(J,"name");
if(g){X=X||{};
X.label=X.label||C;
C=g;
}if(X){F[C]=X;
if(F[C].valueType=="textwithlink"){F[C].valueType="text";
F[(C+"-link")]={valueType:"url"};
L=true;
}P.properties=F;
}W.push(C);
X=d(J,a)||{};
if(X.valueParser&&X.valueParser in window){X.valueParser=window[X.valueParser];
}else{if(X.arity=="single"){X.valueParser=function(k,i,j,h){return k.trim();
};
}else{X.valueParser=function(n,k,m,j){if(n.indexOf(";")==-1){return n.trim();
}var l=n.split(";");
for(var h=0;
h<l.length;
h++){l[h]=l[h].trim();
}return l;
};
if(L){var Y=X.valueParser;
X.valueParser=function(m,j,l,i){var h=j.getElementsByTagName("a");
if(!h.length){return Y(m,j,l,i);
}var k={};
k[W[i]]=m.trim();
k[(W[i]+"-link")]=h[0].href;
return k;
};
}}}H[I]=X;
}var e,T=b.getElementsByTagName("img");
while(e=T[0]){e.parentNode.replaceChild(document.createTextNode(e.src),e);
}var V=[],O,S;
for(M=1;
B=R[M];
M++){var c={};
var Z=B.getElementsByTagName("td");
for(I=0;
O=Z[I];
I++){var S=N(O);
data=H[I].valueParser(S,O,M,I);
if(data==null||S===""){continue;
}if(typeof data=="object"&&!(data instanceof Array)){for(var K in data){c[K]=data[K];
}}else{c[W[I]]=data;
}}if(G){c.type=G;
}V.push(c);
P.items=V;
}U.loadData(P,Exhibit.Persistence.resolveURL(location.href));
};


/* jsonp-importer.js */
Exhibit.JSONPImporter={_callbacks:{}};
Exhibit.importers["application/jsonp"]=Exhibit.JSONPImporter;
Exhibit.JSONPImporter.load=function(link,database,cont,fConvert,staticJSONPCallback,charset){var url=link;
if(typeof link!="string"){url=Exhibit.Persistence.resolveURL(link.href);
fConvert=Exhibit.getAttribute(link,"converter");
staticJSONPCallback=Exhibit.getAttribute(link,"jsonp-callback");
charset=Exhibit.getAttribute(link,"charset");
}if(typeof fConvert=="string"){var name=fConvert;
name=name.charAt(0).toLowerCase()+name.substring(1)+"Converter";
if(name in Exhibit.JSONPImporter){fConvert=Exhibit.JSONPImporter[name];
}else{try{fConvert=eval(fConvert);
}catch(e){fConvert=null;
}}}if(fConvert!=null&&"preprocessURL" in fConvert){url=fConvert.preprocessURL(url);
}var next=Exhibit.JSONPImporter._callbacks.next||1;
Exhibit.JSONPImporter._callbacks.next=next+1;
var callbackName="cb"+next.toString(36);
var callbackURL=url;
if(callbackURL.indexOf("?")==-1){callbackURL+="?";
}var lastChar=callbackURL.charAt(callbackURL.length-1);
if(lastChar!="="){if(lastChar!="&"&&lastChar!="?"){callbackURL+="&";
}callbackURL+="callback=";
}var callbackFull="Exhibit.JSONPImporter._callbacks."+callbackName;
callbackURL+=callbackFull;
var cleanup=function(failedURL){try{Exhibit.UI.hideBusyIndicator();
delete Exhibit.JSONPImporter._callbacks[callbackName+"_fail"];
delete Exhibit.JSONPImporter._callbacks[callbackName];
if(script&&script.parentNode){script.parentNode.removeChild(script);
}}finally{if(failedURL){prompt("Failed to load javascript file:",failedURL);
cont&&cont(undefined);
}}};
Exhibit.JSONPImporter._callbacks[callbackName+"_fail"]=cleanup;
Exhibit.JSONPImporter._callbacks[callbackName]=function(json){try{cleanup(null);
database.loadData(fConvert?fConvert(json,url,link):json,Exhibit.Persistence.getBaseURL(url));
}finally{if(cont){cont(json);
}}};
if(staticJSONPCallback){callbackURL=url;
eval(staticJSONPCallback+"="+callbackFull);
}var fail=callbackFull+"_fail('"+callbackURL+"');";
var script=SimileAjax.includeJavascriptFile(document,callbackURL,fail,charset);
Exhibit.UI.showBusyIndicator();
return Exhibit.JSONPImporter._callbacks[callbackName];
};
Exhibit.JSONPImporter.transformJSON=function(K,E,A,I){var J=K,F=[];
if(E){E=E.split(".");
while(E.length){J=J[E.shift()];
}}for(var D=0,C;
C=J[D];
D++){var H={};
for(var B in A){var E=A[B];
if(!A.hasOwnProperty(B)||!C.hasOwnProperty(E)){continue;
}var G=C[E];
if(I&&I.hasOwnProperty(B)){G=I[B](G,C,D,J,K);
}if(typeof G!="undefined"){H[B]=G;
}}F.push(H);
}return F;
};
Exhibit.JSONPImporter.deliciousConverter=function(C,B){var A=Exhibit.JSONPImporter.transformJSON(C,null,{label:"u",note:"n",description:"d",tags:"t"});
return{items:A,properties:{url:{valueType:"url"}}};
};
Exhibit.JSONPImporter.googleSpreadsheetsConverter=function(Z,G,J){var F=";";
if((J)&&(typeof J!="string")){var S=Exhibit.getAttribute(J,"separator");
if(S!=null&&S.length>0){F=S;
}}var U=[];
var K={};
var P={};
var N={"text":true,"number":true,"item":true,"url":true,"boolean":true,"date":true};
var R=Z.feed.entry||[];
for(var X=0;
X<R.length;
X++){var B=R[X];
var V=B.id.$t;
var f=V.lastIndexOf("C");
var T=V.lastIndexOf("R");
R[X]={row:parseInt(V.substring(T+1,f))-1,col:parseInt(V.substring(f+1))-1,val:B.content.$t};
}var M=0;
var L=function(){if(M<R.length){var d=R[M++];
var h=[d];
while(M<R.length){var c=R[M];
if(c.row==d.row){h.push(c);
M++;
}else{break;
}}return h;
}return null;
};
var D=L();
if(D!=null){var e=[];
for(var X=0;
X<D.length;
X++){var A=D[X];
var Q=A.val.trim().replace(/^\{/g,"").replace(/\}$/g,"").split(":");
var E=Q[0].trim();
var Y=Q.length>1?Q[1].split(","):[];
var I={single:false};
for(var b=0;
b<Y.length;
b++){var g=Y[b].trim();
if(g in N){I.valueType=g;
}else{if(g=="single"){I.single=true;
}}}e[A.col]=E;
K[E]=I;
}var H=null;
while((H=L())!=null){var a={};
for(var X=0;
X<H.length;
X++){var A=H[X];
var E=e[A.col];
if(typeof E=="string"){var C=/^\d{1,2}\/\d{1,2}\/\d{4}$/;
if(C.exec(A.val)){A.val=Exhibit.Database.makeISO8601DateString(new Date(A.val));
}a[E]=A.val;
var I=K[E];
if(!I.single){var W=A.val.split(F);
for(var O=0;
O<W.length;
O++){W[O]=W[O].trim();
}a[E]=W;
}else{a[E]=A.val.trim();
}}}U.push(a);
}}return{types:P,properties:K,items:U};
};
Exhibit.JSONPImporter.googleSpreadsheetsConverter.preprocessURL=function(A){return A.replace(/\/list\//g,"/cells/");
};


/* rdfa-importer.js */
var RDFA=new Object();
RDFA.url="http://www.w3.org/2006/07/SWD/RDFa/impl/js/20070301/rdfa.js";
Exhibit.RDFaImporter={};
Exhibit.importers["application/RDFa"]=Exhibit.RDFaImporter;
Exhibit.RDFaImporter.load=function(B,C,A){try{if((B.getAttribute("href")||"").length==0){Exhibit.RDFaImporter.loadRDFa(null,document,C);
}else{iframe=document.createElement("iframe");
iframe.style.display="none";
iframe.setAttribute("onLoad","Exhibit.RDFaImporter.loadRDFa(this, this.contentDocument, database)");
iframe.src=B.href;
document.body.appendChild(iframe);
}}catch(D){SimileAjax.Debug.exception(D);
}finally{if(A){A();
}}};
Exhibit.RDFaImporter.loadRDFa=function(C,B,D){var E=function(F){return F.textContent||F.innerText||"";
};
var A=function(J,H){var G={},L=false,F,K,I;
for(I=0;
F=H[I];
I++){K=Exhibit.getAttribute(J,F);
if(K){G[F]=K;
L=true;
}}return L&&G;
};
RDFA.CALLBACK_DONE_PARSING=function(){if(C!=null){document.body.removeChild(C);
}this.cloneObject=function(S){for(var R in S){this[R]=S[R];
}};
var O=this.triples;
var M={"classes":{},"properties":{},"items":[]};
for(var H in O){var P={};
P["id"],P["uri"],P["label"]=H;
var Q=O[H];
for(var G in Q){for(var F=0;
F<Q[G].length;
F++){if(Q[G][F].predicate.ns){var L=Q[G][F].predicate.ns.prefix+":"+Q[G][F].predicate.suffix;
if(G=="http://www.w3.org/1999/02/22-rdf-syntax-ns#type"){try{var N=Q[G][F]["object"];
var I=N.match(/(.+?)(#|\/)([a-zA-Z_]+)?$/);
var K=I[3]+"("+I[1]+")";
M["classes"][K]={"label":K,"uri":N};
P["type"]=K;
}catch(J){}}else{M["properties"][L]={"uri":G,"label":Q[G][F]["predicate"]["suffix"]};
try{if(!P[L]){P[L]=[];
}P[L].push(Q[G][F]["object"]);
}catch(J){SimileAjax.Debug.log("problem adding property value: "+J);
}if(G=="http://purl.org/dc/elements/1.1/title"||G=="http://www.w3.org/2000/01/rdf-schema#"||G=="http://xmlns.com/foaf/0.1/name"){P.label=P[L];
}}}else{P[G]=Q[G][F]["object"];
}}}M["items"].push(new this.cloneObject(P));
}D.loadData(M,Exhibit.Persistence.getBaseURL(document.location.href));
};
RDFA.CALLBACK_DONE_LOADING=function(){RDFA.parse(B);
};
SimileAjax.includeJavascriptFile(document,RDFA.url);
};


/* exhibit.js */
Exhibit.create=function(A){return new Exhibit._Impl(A);
};
Exhibit.getAttribute=function(E,C,A){try{var F=E.getAttribute(C);
if(F==null||F.length==0){F=E.getAttribute("ex:"+C);
if(F!=null&&F.length==0){return null;
}}if(A==null){return F;
}var B=F.split(A);
for(var D=0;
F=B[D];
D++){B[D]=F.trim();
}return B;
}catch(G){return null;
}};
Exhibit.getRoleAttribute=function(A){var B=Exhibit.getAttribute(A,"role")||"";
B=B.replace(/^exhibit-/,"");
return B;
};
Exhibit.getConfigurationFromDOM=function(elmt){var c=Exhibit.getAttribute(elmt,"configuration");
if(c!=null&&c.length>0){try{var o=eval(c);
if(typeof o=="object"){return o;
}}catch(e){}}return{};
};
Exhibit.extractOptionsFromElement=function(D){var E={};
var B=D.attributes;
for(var C in B){if(B.hasOwnProperty(C)){var A=B[C].nodeName;
var F=B[C].nodeValue;
if(A.indexOf("ex:")==0){A=A.substring(3);
}E[A]=F;
}}return E;
};
Exhibit.getExporters=function(){Exhibit._initializeExporters();
return[].concat(Exhibit._exporters);
};
Exhibit.addExporter=function(A){Exhibit._initializeExporters();
Exhibit._exporters.push(A);
};
Exhibit._initializeExporters=function(){if(!("_exporters" in Exhibit)){Exhibit._exporters=[Exhibit.RdfXmlExporter,Exhibit.SemanticWikitextExporter,Exhibit.TSVExporter,Exhibit.ExhibitJsonExporter,Exhibit.FacetSelectionExporter];
}};
Exhibit._Impl=function(A){this._database=A!=null?A:("database" in window?window.database:Exhibit.Database.create());
this._uiContext=Exhibit.UIContext.createRootContext({},this);
this._collectionMap={};
this._componentMap={};
this._historyListener={onBeforePerform:function(B){if(B.lengthy){Exhibit.UI.showBusyIndicator();
}},onAfterPerform:function(B){if(B.lengthy){Exhibit.UI.hideBusyIndicator();
}},onBeforeUndoSeveral:function(){Exhibit.UI.showBusyIndicator();
},onAfterUndoSeveral:function(){Exhibit.UI.hideBusyIndicator();
},onBeforeRedoSeveral:function(){Exhibit.UI.showBusyIndicator();
},onAfterRedoSeveral:function(){Exhibit.UI.hideBusyIndicator();
}};
SimileAjax.History.addListener(this._historyListener);
};
Exhibit._Impl.prototype.dispose=function(){SimileAjax.History.removeListener(this._historyListener);
for(var B in this._componentMap){try{this._componentMap[B].dispose();
}catch(A){SimileAjax.Debug.exception(A,"Failed to dispose component");
}}for(var B in this._collectionMap){try{this._collectionMap[B].dispose();
}catch(A){SimileAjax.Debug.exception(A,"Failed to dispose collection");
}}this._uiContext.dispose();
this._componentMap=null;
this._collectionMap=null;
this._uiContext=null;
this._database=null;
};
Exhibit._Impl.prototype.getDatabase=function(){return this._database;
};
Exhibit._Impl.prototype.getUIContext=function(){return this._uiContext;
};
Exhibit._Impl.prototype.getCollection=function(B){var A=this._collectionMap[B];
if(A==null&&B=="default"){A=Exhibit.Collection.createAllItemsCollection(B,this._database);
this.setDefaultCollection(A);
}return A;
};
Exhibit._Impl.prototype.getDefaultCollection=function(){return this.getCollection("default");
};
Exhibit._Impl.prototype.setCollection=function(C,B){if(C in this._collectionMap){try{this._collectionMap[C].dispose();
}catch(A){SimileAjax.Debug.exception(A);
}}this._collectionMap[C]=B;
};
Exhibit._Impl.prototype.setDefaultCollection=function(A){this.setCollection("default",A);
};
Exhibit._Impl.prototype.getComponent=function(A){return this._componentMap[A];
};
Exhibit._Impl.prototype.setComponent=function(C,B){if(C in this._componentMap){try{this._componentMap[C].dispose();
}catch(A){SimileAjax.Debug.exception(A);
}}this._componentMap[C]=B;
};
Exhibit._Impl.prototype.disposeComponent=function(B){if(B in this._componentMap){try{this._componentMap[B].dispose();
}catch(A){SimileAjax.Debug.exception(A);
}delete this._componentMap[B];
}};
Exhibit._Impl.prototype.configure=function(E){if("collections" in E){for(var C=0;
C<E.collections.length;
C++){var B=E.collections[C];
var D=B.id;
if(D==null||D.length==0){D="default";
}this.setCollection(D,Exhibit.Collection.create2(D,B,this._uiContext));
}}if("components" in E){for(var C=0;
C<E.components.length;
C++){var B=E.components[C];
var A=Exhibit.UI.create(B,B.elmt,this._uiContext);
if(A!=null){var D=elmt.id;
if(D==null||D.length==0){D="component"+Math.floor(Math.random()*1000000);
}this.setComponent(D,A);
}}}};
Exhibit._Impl.prototype.configureFromDOM=function(root){var collectionElmts=[];
var coderElmts=[];
var coordinatorElmts=[];
var lensElmts=[];
var facetElmts=[];
var otherElmts=[];
var f=function(elmt){var role=Exhibit.getRoleAttribute(elmt);
if(role.length>0){switch(role){case"collection":collectionElmts.push(elmt);
break;
case"coder":coderElmts.push(elmt);
break;
case"coordinator":coordinatorElmts.push(elmt);
break;
case"lens":case"submission-lens":case"edit-lens":lensElmts.push(elmt);
break;
case"facet":facetElmts.push(elmt);
break;
default:otherElmts.push(elmt);
}}else{var node=elmt.firstChild;
while(node!=null){if(node.nodeType==1){f(node);
}node=node.nextSibling;
}}};
f(root||document.body);
var uiContext=this._uiContext;
for(var i=0;
i<collectionElmts.length;
i++){var elmt=collectionElmts[i];
var id=elmt.id;
if(id==null||id.length==0){id="default";
}this.setCollection(id,Exhibit.Collection.createFromDOM2(id,elmt,uiContext));
}var self=this;
var processElmts=function(elmts){for(var i=0;
i<elmts.length;
i++){var elmt=elmts[i];
try{var component=Exhibit.UI.createFromDOM(elmt,uiContext);
if(component!=null){var id=elmt.id;
if(id==null||id.length==0){id="component"+Math.floor(Math.random()*1000000);
}self.setComponent(id,component);
}}catch(e){SimileAjax.Debug.exception(e);
}}};
processElmts(coordinatorElmts);
processElmts(coderElmts);
processElmts(lensElmts);
processElmts(facetElmts);
processElmts(otherElmts);
this.importSettings();
var exporters=Exhibit.getAttribute(document.body,"exporters");
if(exporters!=null){exporters=exporters.split(";");
for(var i=0;
i<exporters.length;
i++){var expr=exporters[i];
var exporter=null;
try{exporter=eval(expr);
}catch(e){}if(exporter==null){try{exporter=eval(expr+"Exporter");
}catch(e){}}if(exporter==null){try{exporter=eval("Exhibit."+expr+"Exporter");
}catch(e){}}if(typeof exporter=="object"){Exhibit.addExporter(exporter);
}}}var hash=document.location.hash;
if(hash.length>1){var itemID=decodeURIComponent(hash.substr(1));
if(this._database.containsItem(itemID)){this._showFocusDialogOnItem(itemID);
}}};
Exhibit._Impl.prototype._showFocusDialogOnItem=function(B){var C=SimileAjax.DOM.createDOMFromString("div","<div class='exhibit-focusDialog-viewContainer' id='lensContainer'></div><div class='exhibit-focusDialog-controls'><button id='closeButton'>"+Exhibit.l10n.focusDialogBoxCloseButtonLabel+"</button></div>");
C.elmt.className="exhibit-focusDialog exhibit-ui-protection";
C.close=function(){document.body.removeChild(C.elmt);
};
C.layer=SimileAjax.WindowManager.pushLayer(function(){C.close();
},false);
var A=this._uiContext.getLensRegistry().createLens(B,C.lensContainer,this._uiContext);
C.elmt.style.top=(document.body.scrollTop+100)+"px";
document.body.appendChild(C.elmt);
SimileAjax.WindowManager.registerEvent(C.closeButton,"click",function(E,D,F){SimileAjax.WindowManager.popLayer(C.layer);
},C.layer);
};
Exhibit._Impl.prototype.exportSettings=function(){var A={},B="";
for(var C in this._componentMap){if(typeof this._componentMap[C].exportFacetSelection!=="undefined"){B=this._componentMap[C].exportFacetSelection()||false;
if(B){A[C]=B;
}}}return A;
};
Exhibit._Impl.prototype.importSettings=function(){if(window.location.search.length>0){searchComponents=window.location.search.substr(1,window.location.search.length-1).split("&");
for(var A=0;
A<searchComponents.length;
A++){var C=searchComponents[A].split("=");
var B=C[0];
var D=unescape(C[1]);
if(this._componentMap[B]&&(typeof this._componentMap[B].importFacetSelection!=="undefined")){this._componentMap[B].importFacetSelection(D);
}}}};


/* persistence.js */
Exhibit.Persistence={};
Exhibit.Persistence.getBaseURL=function(A){try{if(A.indexOf("://")<0){var C=Exhibit.Persistence.getBaseURL(document.location.href);
if(A.substr(0,1)=="/"){A=C.substr(0,C.indexOf("/",C.indexOf("://")+3))+A;
}else{A=C+A;
}}var B=A.lastIndexOf("/");
if(B<0){return"";
}else{return A.substr(0,B+1);
}}catch(D){return A;
}};
Exhibit.Persistence.resolveURL=function(A){if(A.indexOf("://")<0){var B=Exhibit.Persistence.getBaseURL(document.location.href);
if(A.substr(0,1)=="/"){A=B.substr(0,B.indexOf("/",B.indexOf("://")+3))+A;
}else{A=B+A;
}}return A;
};
Exhibit.Persistence.getURLWithoutQueryAndHash=function(){var B;
if("_urlWithoutQueryAndHash" in Exhibit){B=Exhibit.Persistence._urlWithoutQueryAndHash;
}else{B=document.location.href;
var C=B.indexOf("#");
var A=B.indexOf("?");
if(A>=0){B=B.substr(0,A);
}else{if(C>=0){B=B.substr(0,C);
}}Exhibit.Persistence._urlWithoutQueryAndHash=B;
}return B;
};
Exhibit.Persistence.getURLWithoutQuery=function(){var B;
if("_urlWithoutQuery" in Exhibit.Persistence){B=Exhibit.Persistence._urlWithoutQuery;
}else{B=document.location.href;
var A=B.indexOf("?");
if(A>=0){B=B.substr(0,A);
}Exhibit.Persistence._urlWithoutQuery=B;
}return B;
};
Exhibit.Persistence.getItemLink=function(A){return Exhibit.Persistence.getURLWithoutQueryAndHash()+"#"+encodeURIComponent(A);
};


/* color-coder.js */
Exhibit.ColorCoder=function(A){this._uiContext=A;
this._settings={};
this._map={};
this._mixedCase={label:Exhibit.Coders.l10n.mixedCaseLabel,color:Exhibit.Coders.mixedCaseColor};
this._missingCase={label:Exhibit.Coders.l10n.missingCaseLabel,color:Exhibit.Coders.missingCaseColor};
this._othersCase={label:Exhibit.Coders.l10n.othersCaseLabel,color:Exhibit.Coders.othersCaseColor};
};
Exhibit.ColorCoder._settingSpecs={};
Exhibit.ColorCoder.create=function(C,A){var B=new Exhibit.ColorCoder(Exhibit.UIContext.create(C,A));
Exhibit.ColorCoder._configure(B,C);
return B;
};
Exhibit.ColorCoder.createFromDOM=function(E,A){E.style.display="none";
var F=Exhibit.getConfigurationFromDOM(E);
var B=new Exhibit.ColorCoder(Exhibit.UIContext.create(F,A));
Exhibit.SettingsUtilities.collectSettingsFromDOM(E,Exhibit.ColorCoder._settingSpecs,B._settings);
try{var C=E.firstChild;
while(C!=null){if(C.nodeType==1){B._addEntry(Exhibit.getAttribute(C,"case"),C.firstChild.nodeValue.trim(),Exhibit.getAttribute(C,"color"));
}C=C.nextSibling;
}}catch(D){SimileAjax.Debug.exception(D,"ColorCoder: Error processing configuration of coder");
}Exhibit.ColorCoder._configure(B,F);
return B;
};
Exhibit.ColorCoder._configure=function(B,D){Exhibit.SettingsUtilities.collectSettings(D,Exhibit.ColorCoder._settingSpecs,B._settings);
if("entries" in D){var A=D.entries;
for(var C=0;
C<A.length;
C++){B._addEntry(A[C].kase,A[C].key,A[C].color);
}}};
Exhibit.ColorCoder.prototype.dispose=function(){this._uiContext=null;
this._settings=null;
};
Exhibit.ColorCoder._colorTable={"red":"#ff0000","green":"#00ff00","blue":"#0000ff","white":"#ffffff","black":"#000000","gray":"#888888"};
Exhibit.ColorCoder.prototype._addEntry=function(B,C,A){if(A in Exhibit.ColorCoder._colorTable){A=Exhibit.ColorCoder._colorTable[A];
}var D=null;
switch(B){case"others":D=this._othersCase;
break;
case"mixed":D=this._mixedCase;
break;
case"missing":D=this._missingCase;
break;
}if(D!=null){D.label=C;
D.color=A;
}else{this._map[C]={color:A};
}};
Exhibit.ColorCoder.prototype.translate=function(B,A){if(B in this._map){if(A){A.keys.add(B);
}return this._map[B].color;
}else{if(B==null){if(A){A.missing=true;
}return this._missingCase.color;
}else{if(A){A.others=true;
}return this._othersCase.color;
}}};
Exhibit.ColorCoder.prototype.translateSet=function(D,A){var C=null;
var B=this;
D.visit(function(F){var E=B.translate(F,A);
if(C==null){C=E;
}else{if(C!=E){if(A){A.mixed=true;
}C=B._mixedCase.color;
return true;
}}return false;
});
if(C!=null){return C;
}else{if(A){A.missing=true;
}return this._missingCase.color;
}};
Exhibit.ColorCoder.prototype.getOthersLabel=function(){return this._othersCase.label;
};
Exhibit.ColorCoder.prototype.getOthersColor=function(){return this._othersCase.color;
};
Exhibit.ColorCoder.prototype.getMissingLabel=function(){return this._missingCase.label;
};
Exhibit.ColorCoder.prototype.getMissingColor=function(){return this._missingCase.color;
};
Exhibit.ColorCoder.prototype.getMixedLabel=function(){return this._mixedCase.label;
};
Exhibit.ColorCoder.prototype.getMixedColor=function(){return this._mixedCase.color;
};


/* color-gradient-coder.js */
Exhibit.ColorGradientCoder=function(A){this._uiContext=A;
this._settings={};
this._gradientPoints=[];
this._mixedCase={label:Exhibit.Coders.l10n.mixedCaseLabel,color:Exhibit.Coders.mixedCaseColor};
this._missingCase={label:Exhibit.Coders.l10n.missingCaseLabel,color:Exhibit.Coders.missingCaseColor};
this._othersCase={label:Exhibit.Coders.l10n.othersCaseLabel,color:Exhibit.Coders.othersCaseColor};
};
Exhibit.ColorGradientCoder._settingSpecs={};
Exhibit.ColorGradientCoder.create=function(C,A){var B=new Exhibit.ColorGradientCoder(Exhibit.UIContext.create(C,A));
Exhibit.ColorGradientCoder._configure(B,C);
return B;
};
Exhibit.ColorGradientCoder.createFromDOM=function(A,G){A.style.display="none";
var C=Exhibit.getConfigurationFromDOM(A);
var B=new Exhibit.ColorGradientCoder(Exhibit.UIContext.create(C,G));
Exhibit.SettingsUtilities.collectSettingsFromDOM(A,Exhibit.ColorGradientCoder._settingSpecs,B._settings);
try{var J=Exhibit.getAttribute(A,"gradientPoints",";");
for(var H=0;
H<J.length;
H++){var N=J[H];
var M=parseFloat(N);
var L=N.indexOf("#")+1;
var E=parseInt(N.slice(L,L+2),16);
var F=parseInt(N.slice(L+2,L+4),16);
var K=parseInt(N.slice(L+4),16);
B._gradientPoints.push({value:M,red:E,green:F,blue:K});
}var D=A.firstChild;
while(D!=null){if(D.nodeType==1){B._addEntry(Exhibit.getAttribute(D,"case"),D.firstChild.nodeValue.trim(),Exhibit.getAttribute(D,"color"));
}D=D.nextSibling;
}}catch(I){SimileAjax.Debug.exception(I,"ColorGradientCoder: Error processing configuration of coder");
}Exhibit.ColorGradientCoder._configure(B,C);
return B;
};
Exhibit.ColorGradientCoder._configure=function(B,D){Exhibit.SettingsUtilities.collectSettings(D,Exhibit.ColorGradientCoder._settingSpecs,B._settings);
if("entries" in D){var A=D.entries;
for(var C=0;
C<A.length;
C++){B._addEntry(A[C].kase,A[C].key,A[C].color);
}}};
Exhibit.ColorGradientCoder.prototype.dispose=function(){this._uiContext=null;
this._settings=null;
};
Exhibit.ColorGradientCoder.prototype._addEntry=function(B,C,A){var D=null;
switch(B){case"others":D=this._othersCase;
break;
case"mixed":D=this._mixedCase;
break;
case"missing":D=this._missingCase;
break;
}if(D!=null){D.label=C;
D.color=A;
}};
Exhibit.ColorGradientCoder.prototype.translate=function(B,A){var E=this._gradientPoints;
var D=function(G){if(G.constructor!=Number){G=parseFloat(G);
}for(j=0;
j<E.length;
j++){if(G==E[j].value){return C(E[j].red,E[j].green,E[j].blue);
}else{if(E[j+1]!=null){if(G<E[j+1].value){var H=(G-E[j].value)/(E[j+1].value-E[j].value);
var F=Math.floor(E[j].red+H*(E[j+1].red-E[j].red));
var I=Math.floor(E[j].green+H*(E[j+1].green-E[j].green));
var J=Math.floor(E[j].blue+H*(E[j+1].blue-E[j].blue));
return C(F,I,J);
}}}}};
var C=function(I,H,F){var G=function(J){if(J==0){return"00";
}else{return J.toString(16);
}};
return"#"+G(I)+G(H)+G(F);
};
if(B>=E[0].value&B<=E[E.length-1].value){if(A){A.keys.add(B);
}return D(B);
}else{if(B==null){if(A){A.missing=true;
}return this._missingCase.color;
}else{if(A){A.others=true;
}return this._othersCase.color;
}}};
Exhibit.ColorGradientCoder.prototype.translateSet=function(D,A){var C=null;
var B=this;
D.visit(function(F){var E=B.translate(F,A);
if(C==null){C=E;
}else{if(C!=E){if(A){A.mixed=true;
}C=B._mixedCase.color;
return true;
}}return false;
});
if(C!=null){return C;
}else{if(A){A.missing=true;
}return this._missingCase.color;
}};
Exhibit.ColorGradientCoder.prototype.getOthersLabel=function(){return this._othersCase.label;
};
Exhibit.ColorGradientCoder.prototype.getOthersColor=function(){return this._othersCase.color;
};
Exhibit.ColorGradientCoder.prototype.getMissingLabel=function(){return this._missingCase.label;
};
Exhibit.ColorGradientCoder.prototype.getMissingColor=function(){return this._missingCase.color;
};
Exhibit.ColorGradientCoder.prototype.getMixedLabel=function(){return this._mixedCase.label;
};
Exhibit.ColorGradientCoder.prototype.getMixedColor=function(){return this._mixedCase.color;
};


/* default-color-coder.js */
Exhibit.DefaultColorCoder=function(A){};
Exhibit.DefaultColorCoder.colors=["#FF9000","#5D7CBA","#A97838","#8B9BBA","#FFC77F","#003EBA","#29447B","#543C1C"];
Exhibit.DefaultColorCoder._map={};
Exhibit.DefaultColorCoder._nextColor=0;
Exhibit.DefaultColorCoder.prototype.translate=function(C,A){if(C==null){if(A){A.missing=true;
}return Exhibit.Coders.missingCaseColor;
}else{if(A){A.keys.add(C);
}if(C in Exhibit.DefaultColorCoder._map){return Exhibit.DefaultColorCoder._map[C];
}else{var B=Exhibit.DefaultColorCoder.colors[Exhibit.DefaultColorCoder._nextColor];
Exhibit.DefaultColorCoder._nextColor=(Exhibit.DefaultColorCoder._nextColor+1)%Exhibit.DefaultColorCoder.colors.length;
Exhibit.DefaultColorCoder._map[C]=B;
return B;
}}};
Exhibit.DefaultColorCoder.prototype.translateSet=function(D,A){var C=null;
var B=this;
D.visit(function(F){var E=B.translate(F,A);
if(C==null){C=E;
}else{if(C!=E){C=Exhibit.Coders.mixedCaseColor;
A.mixed=true;
return true;
}}return false;
});
if(C!=null){return C;
}else{A.missing=true;
return Exhibit.Coders.missingCaseColor;
}};
Exhibit.DefaultColorCoder.prototype.getOthersLabel=function(){return Exhibit.Coders.l10n.othersCaseLabel;
};
Exhibit.DefaultColorCoder.prototype.getOthersColor=function(){return Exhibit.Coders.othersCaseColor;
};
Exhibit.DefaultColorCoder.prototype.getMissingLabel=function(){return Exhibit.Coders.l10n.missingCaseLabel;
};
Exhibit.DefaultColorCoder.prototype.getMissingColor=function(){return Exhibit.Coders.missingCaseColor;
};
Exhibit.DefaultColorCoder.prototype.getMixedLabel=function(){return Exhibit.Coders.l10n.mixedCaseLabel;
};
Exhibit.DefaultColorCoder.prototype.getMixedColor=function(){return Exhibit.Coders.mixedCaseColor;
};


/* icon-coder.js */
Exhibit.IconCoder=function(A){this._uiContext=A;
this._settings={};
this._map={};
this._mixedCase={label:"mixed",icon:null};
this._missingCase={label:"missing",icon:null};
this._othersCase={label:"others",icon:null};
};
Exhibit.IconCoder._settingSpecs={};
Exhibit.IconCoder.create=function(C,A){var B=new Exhibit.IconCoder(Exhibit.UIContext.create(C,A));
Exhibit.IconCoder._configure(B,C);
return B;
};
Exhibit.IconCoder.createFromDOM=function(E,A){E.style.display="none";
var F=Exhibit.getConfigurationFromDOM(E);
var B=new Exhibit.IconCoder(Exhibit.UIContext.create(F,A));
Exhibit.SettingsUtilities.collectSettingsFromDOM(E,Exhibit.IconCoder._settingSpecs,B._settings);
try{var C=E.firstChild;
while(C!=null){if(C.nodeType==1){B._addEntry(Exhibit.getAttribute(C,"case"),C.firstChild.nodeValue.trim(),Exhibit.getAttribute(C,"icon"));
}C=C.nextSibling;
}}catch(D){SimileAjax.Debug.exception(D,"IconCoder: Error processing configuration of coder");
}Exhibit.IconCoder._configure(B,F);
return B;
};
Exhibit.IconCoder._configure=function(B,D){Exhibit.SettingsUtilities.collectSettings(D,Exhibit.IconCoder._settingSpecs,B._settings);
if("entries" in D){var A=D.entries;
for(var C=0;
C<A.length;
C++){B._addEntry(A[C].kase,A[C].key,A[C].icon);
}}};
Exhibit.IconCoder.prototype.dispose=function(){this._uiContext=null;
this._settings=null;
};
Exhibit.IconCoder._iconTable={};
Exhibit.IconCoder.prototype._addEntry=function(A,B,C){if(C in Exhibit.IconCoder._iconTable){C=Exhibit.IconCoder._iconTable[C];
}var D=null;
switch(A){case"others":D=this._othersCase;
break;
case"mixed":D=this._mixedCase;
break;
case"missing":D=this._missingCase;
break;
}if(D!=null){D.label=B;
D.icon=C;
}else{this._map[B]={icon:C};
}};
Exhibit.IconCoder.prototype.translate=function(B,A){if(B in this._map){if(A){A.keys.add(B);
}return this._map[B].icon;
}else{if(B==null){if(A){A.missing=true;
}return this._missingCase.icon;
}else{if(A){A.others=true;
}return this._othersCase.icon;
}}};
Exhibit.IconCoder.prototype.translateSet=function(D,A){var C=null;
var B=this;
D.visit(function(F){var E=B.translate(F,A);
if(C==null){C=E;
}else{if(C!=E){if(A){A.mixed=true;
}C=B._mixedCase.icon;
return true;
}}return false;
});
if(C!=null){return C;
}else{if(A){A.missing=true;
}return this._missingCase.icon;
}};
Exhibit.IconCoder.prototype.getOthersLabel=function(){return this._othersCase.label;
};
Exhibit.IconCoder.prototype.getOthersIcon=function(){return this._othersCase.icon;
};
Exhibit.IconCoder.prototype.getMissingLabel=function(){return this._missingCase.label;
};
Exhibit.IconCoder.prototype.getMissingIcon=function(){return this._missingCase.icon;
};
Exhibit.IconCoder.prototype.getMixedLabel=function(){return this._mixedCase.label;
};
Exhibit.IconCoder.prototype.getMixedIcon=function(){return this._mixedCase.icon;
};


/* size-coder.js */
Exhibit.SizeCoder=function(A){this._uiContext=A;
this._settings={};
this._map={};
this._mixedCase={label:"mixed",size:10};
this._missingCase={label:"missing",size:10};
this._othersCase={label:"others",size:10};
};
Exhibit.SizeCoder._settingSpecs={};
Exhibit.SizeCoder.create=function(C,A){var B=new Exhibit.SizeCoder(Exhibit.UIContext.create(C,A));
Exhibit.SizeCoder._configure(B,C);
return B;
};
Exhibit.SizeCoder.createFromDOM=function(E,A){E.style.display="none";
var F=Exhibit.getConfigurationFromDOM(E);
var B=new Exhibit.SizeCoder(Exhibit.UIContext.create(F,A));
Exhibit.SettingsUtilities.collectSettingsFromDOM(E,Exhibit.SizeCoder._settingSpecs,B._settings);
try{var C=E.firstChild;
while(C!=null){if(C.nodeType==1){B._addEntry(Exhibit.getAttribute(C,"case"),C.firstChild.nodeValue.trim(),Exhibit.getAttribute(C,"size"));
}C=C.nextSibling;
}}catch(D){SimileAjax.Debug.exception(D,"SizeCoder: Error processing configuration of coder");
}Exhibit.SizeCoder._configure(B,F);
return B;
};
Exhibit.SizeCoder._configure=function(B,D){Exhibit.SettingsUtilities.collectSettings(D,Exhibit.SizeCoder._settingSpecs,B._settings);
if("entries" in D){var A=D.entries;
for(var C=0;
C<A.length;
C++){B._addEntry(A[C].kase,A[C].key,A[C].size);
}}};
Exhibit.SizeCoder.prototype.dispose=function(){this._uiContext=null;
this._settings=null;
};
Exhibit.SizeCoder.prototype._addEntry=function(A,C,B){var D=null;
switch(A){case"others":D=this._othersCase;
break;
case"mixed":D=this._mixedCase;
break;
case"missing":D=this._missingCase;
break;
}if(D!=null){D.label=C;
D.size=B;
}else{this._map[C]={size:B};
}};
Exhibit.SizeCoder.prototype.translate=function(B,A){if(B in this._map){if(A){A.keys.add(B);
}return this._map[B].size;
}else{if(B==null){if(A){A.missing=true;
}return this._missingCase.size;
}else{if(A){A.others=true;
}return this._othersCase.size;
}}};
Exhibit.SizeCoder.prototype.translateSet=function(D,A){var C=null;
var B=this;
D.visit(function(E){var F=B.translate(E,A);
if(C==null){C=F;
}else{if(C!=F){if(A){A.mixed=true;
}C=B._mixedCase.size;
return true;
}}return false;
});
if(C!=null){return C;
}else{if(A){A.missing=true;
}return this._missingCase.size;
}};
Exhibit.SizeCoder.prototype.getOthersLabel=function(){return this._othersCase.label;
};
Exhibit.SizeCoder.prototype.getOthersSize=function(){return this._othersCase.size;
};
Exhibit.SizeCoder.prototype.getMissingLabel=function(){return this._missingCase.label;
};
Exhibit.SizeCoder.prototype.getMissingSize=function(){return this._missingCase.size;
};
Exhibit.SizeCoder.prototype.getMixedLabel=function(){return this._mixedCase.label;
};
Exhibit.SizeCoder.prototype.getMixedSize=function(){return this._mixedCase.size;
};


/* size-gradient-coder.js */
Exhibit.SizeGradientCoder=function(A){this._uiContext=A;
this._settings={};
this._log={func:function(B){return Math.ceil(Math.log(B));
},invFunc:function(B){return Math.ceil(Math.exp(B));
}};
this._linear={func:function(B){return Math.ceil(B);
},invFunc:function(B){return Math.ceil(B);
}};
this._quad={func:function(B){return Math.ceil(Math.pow((B/100),2));
},invFunc:function(B){return Math.sqrt(B)*100;
}};
this._exp={func:function(B){return Math.ceil(Math.exp(B));
},invFunc:function(B){return Math.ceil(Math.log(B));
}};
this._markerScale=this._quad;
this._valueScale=this._linear;
this._gradientPoints=[];
this._mixedCase={label:"mixed",size:20};
this._missingCase={label:"missing",size:20};
this._othersCase={label:"others",size:20};
};
Exhibit.SizeGradientCoder._settingSpecs={};
Exhibit.SizeGradientCoder.create=function(C,A){var B=new Exhibit.SizeGradientCoder(Exhibit.UIContext.create(C,A));
Exhibit.SizeGradientCoder._configure(B,C);
return B;
};
Exhibit.SizeGradientCoder.createFromDOM=function(A,F){A.style.display="none";
var C=Exhibit.getConfigurationFromDOM(A);
var B=new Exhibit.SizeGradientCoder(Exhibit.UIContext.create(C,F));
Exhibit.SettingsUtilities.collectSettingsFromDOM(A,Exhibit.SizeGradientCoder._settingSpecs,B._settings);
try{var E=B._settings.markerScale;
if(E=="log"){B._markerScale=B._log;
}if(E=="linear"){B._markerScale=B._linear;
}if(E=="exp"){B._markerScale=B._exp;
}var I=Exhibit.getAttribute(A,"gradientPoints",";");
for(var G=0;
G<I.length;
G++){var K=I[G].split(",");
var J=parseFloat(K[0]);
var L=B._markerScale.invFunc(parseFloat(K[1]));
B._gradientPoints.push({value:J,size:L});
}var D=A.firstChild;
while(D!=null){if(D.nodeType==1){B._addEntry(Exhibit.getAttribute(D,"case"),D.firstChild.nodeValue.trim(),Exhibit.getAttribute(D,"size"));
}D=D.nextSibling;
}}catch(H){SimileAjax.Debug.exception(H,"SizeGradientCoder: Error processing configuration of coder");
}Exhibit.SizeGradientCoder._configure(B,C);
return B;
};
Exhibit.SizeGradientCoder._configure=function(B,D){Exhibit.SettingsUtilities.collectSettings(D,Exhibit.SizeGradientCoder._settingSpecs,B._settings);
if("entries" in D){var A=D.entries;
for(var C=0;
C<A.length;
C++){B._addEntry(A[C].kase,A[C].key,A[C].size);
}}};
Exhibit.SizeGradientCoder.prototype.dispose=function(){this._uiContext=null;
this._settings=null;
};
Exhibit.SizeGradientCoder.prototype._addEntry=function(A,C,B){var D=null;
switch(A){case"others":D=this._othersCase;
break;
case"mixed":D=this._mixedCase;
break;
case"missing":D=this._missingCase;
break;
}if(D!=null){D.label=C;
D.size=B;
}};
Exhibit.SizeGradientCoder.prototype.translate=function(C,A){var B=this;
var E=this._gradientPoints;
var D=function(G){if(G.constructor!=Number){G=parseFloat(G);
}for(j=0;
j<E.length;
j++){if(G==E[j].value){return B._markerScale.func(E[j].size);
}else{if(E[j+1]!=null){if(G<E[j+1].value){var H=(G-E[j].value)/(E[j+1].value-E[j].value);
var F=Math.floor(E[j].size+H*(E[j+1].size-E[j].size));
return B._markerScale.func(F);
}}}}};
if(C>=E[0].value&C<=E[E.length-1].value){if(A){A.keys.add(C);
}return D(C);
}else{if(C==null){if(A){A.missing=true;
}return this._missingCase.size;
}else{if(A){A.others=true;
}return this._othersCase.size;
}}};
Exhibit.SizeGradientCoder.prototype.translateSet=function(D,A){var C=null;
var B=this;
D.visit(function(E){var F=B.translate(E,A);
if(C==null){C=F;
}else{if(C!=F){if(A){A.mixed=true;
}C=B._mixedCase.size;
return true;
}}return false;
});
if(C!=null){return C;
}else{if(A){A.missing=true;
}return this._missingCase.size;
}};
Exhibit.SizeGradientCoder.prototype.getOthersLabel=function(){return this._othersCase.label;
};
Exhibit.SizeGradientCoder.prototype.getOthersSize=function(){return this._othersCase.size;
};
Exhibit.SizeGradientCoder.prototype.getMissingLabel=function(){return this._missingCase.label;
};
Exhibit.SizeGradientCoder.prototype.getMissingSize=function(){return this._missingCase.size;
};
Exhibit.SizeGradientCoder.prototype.getMixedLabel=function(){return this._mixedCase.label;
};
Exhibit.SizeGradientCoder.prototype.getMixedSize=function(){return this._mixedCase.size;
};


/* coordinator.js */
Exhibit.Coordinator=function(A){this._uiContext=A;
this._listeners=[];
};
Exhibit.Coordinator.create=function(C,A){var B=new Exhibit.Coordinator(A);
return B;
};
Exhibit.Coordinator.createFromDOM=function(C,A){var B=new Exhibit.Coordinator(Exhibit.UIContext.createFromDOM(C,A,false));
return B;
};
Exhibit.Coordinator.prototype.dispose=function(){this._uiContext.dispose();
this._uiContext=null;
};
Exhibit.Coordinator.prototype.addListener=function(B){var A=new Exhibit.Coordinator._Listener(this,B);
this._listeners.push(A);
return A;
};
Exhibit.Coordinator.prototype._removeListener=function(B){for(var A=0;
A<this._listeners.length;
A++){if(this._listeners[A]==B){this._listeners.splice(A,1);
return ;
}}};
Exhibit.Coordinator.prototype._fire=function(C,D){for(var B=0;
B<this._listeners.length;
B++){var A=this._listeners[B];
if(A!=C){A._callback(D);
}}};
Exhibit.Coordinator._Listener=function(A,B){this._coordinator=A;
this._callback=B;
};
Exhibit.Coordinator._Listener.prototype.dispose=function(){this._coordinator._removeListener(this);
};
Exhibit.Coordinator._Listener.prototype.fire=function(A){this._coordinator._fire(this,A);
};


/* alpha-range-facet.js */
Exhibit.AlphaRangeFacet=function(C,B){this._div=C;
this._uiContext=B;
this._expression=null;
this._settings={};
this._dom=null;
this._ranges=[];
var A=this;
this._listener={onRootItemsChanged:function(){if("_rangeIndex" in A){delete A._rangeIndex;
}}};
B.getCollection().addListener(this._listener);
};
Exhibit.AlphaRangeFacet._settingSpecs={"facetLabel":{type:"text"},"scroll":{type:"boolean",defaultValue:true},"height":{type:"text"},"interval":{type:"int",defaultValue:7},"collapsible":{type:"boolean",defaultValue:false},"collapsed":{type:"boolean",defaultValue:false}};
Exhibit.AlphaRangeFacet.create=function(D,B,A){var A=Exhibit.UIContext.create(D,A);
var C=new Exhibit.AlphaRangeFacet(B,A);
Exhibit.AlphaRangeFacet._configure(C,D);
C._initializeUI();
A.getCollection().addFacet(C);
return C;
};
Exhibit.AlphaRangeFacet.createFromDOM=function(E,D,A){var G=Exhibit.getConfigurationFromDOM(E);
var A=Exhibit.UIContext.createFromDOM(E,A);
var F=new Exhibit.AlphaRangeFacet(D!=null?D:E,A);
Exhibit.SettingsUtilities.collectSettingsFromDOM(E,Exhibit.AlphaRangeFacet._settingSpecs,F._settings);
try{var B=Exhibit.getAttribute(E,"expression");
if(B!=null&&B.length>0){F._expression=Exhibit.ExpressionParser.parse(B);
}}catch(C){SimileAjax.Debug.exception(C,"AlphaRangeFacet: Error processing configuration of alpha range facet");
}Exhibit.AlphaRangeFacet._configure(F,G);
F._initializeUI();
A.getCollection().addFacet(F);
return F;
};
Exhibit.AlphaRangeFacet._configure=function(D,C){Exhibit.SettingsUtilities.collectSettings(C,Exhibit.AlphaRangeFacet._settingSpecs,D._settings);
if("expression" in C){D._expression=Exhibit.ExpressionParser.parse(C.expression);
}if(!("facetLabel" in D._settings)){D._settings.facetLabel="missing ex:facetLabel";
if(D._expression!=null&&D._expression.isPath()){var A=D._expression.getPath().getLastSegment();
var B=D._uiContext.getDatabase().getProperty(A.property);
if(B!=null){D._settings.facetLabel=A.forward?B.getLabel():B.getReverseLabel();
}}}if(D._settings.collapsed){D._settings.collapsible=true;
}};
Exhibit.AlphaRangeFacet.prototype.dispose=function(){this._uiContext.getCollection().removeFacet(this);
this._uiContext.getCollection().removeListener(this._listener);
this._uiContext=null;
this._div.innerHTML="";
this._div=null;
this._dom=null;
this._expression=null;
this._settings=null;
this._ranges=[];
};
Exhibit.AlphaRangeFacet.prototype.hasRestrictions=function(){return this._ranges.length>0;
};
Exhibit.AlphaRangeFacet.prototype.clearAllRestrictions=function(){var A=[];
if(this._ranges.length>0){A=A.concat(this._ranges);
this._ranges=[];
this._notifyCollection();
}return A;
};
Exhibit.AlphaRangeFacet.prototype.applyRestrictions=function(A){this._ranges=A;
this._notifyCollection();
};
Exhibit.AlphaRangeFacet.prototype.setRange=function(E,D,C){if(C){for(var B=0;
B<this._ranges.length;
B++){var A=this._ranges[B];
if(A.from==E&&A.to==D){return ;
}}this._ranges.push({from:E,to:D});
}else{for(var B=0;
B<this._ranges.length;
B++){var A=this._ranges[B];
if(A.from==E&&A.to==D){this._ranges.splice(B,1);
break;
}}}this._notifyCollection();
};
Exhibit.AlphaRangeFacet.prototype.restrict=function(B){if(this._ranges.length==0){return B;
}else{this._buildRangeIndex();
var D=new Exhibit.Set();
for(var C=0;
C<this._ranges.length;
C++){var A=this._ranges[C];
this._rangeIndex.getSubjectsInRange(A.from,String.fromCharCode(A.to.charCodeAt(0)+1),true,D,B);
}return D;
}};
Exhibit.AlphaRangeFacet.prototype.update=function(A){this._dom.valuesContainer.style.display="none";
this._dom.valuesContainer.innerHTML="";
this._reconstruct(A);
this._dom.valuesContainer.style.display="block";
};
Exhibit.AlphaRangeFacet.prototype._reconstruct=function(I){var Q=this;
var A=[];
var E;
var D;
this._buildRangeIndex();
E=this._rangeIndex;
countItems=function(R){return E.getSubjectsInRange(R.from,String.fromCharCode(R.to.charCodeAt(0)+1),true,null,I).size();
};
var J=[];
var C=function(R){for(N in J){if(J[N]==R){return true;
}}return false;
};
for(var M=0;
M<E.getCount();
M+=1){var B=E._pairs[M].value.substr(0,1).toUpperCase();
if(!C(B)){J.push(B);
}}for(var N=0;
N<J.length;
N+=this._settings.interval){var G={from:J[N],to:J[(N+this._settings.interval>=J.length?J.length-1:N+this._settings.interval-1)],selected:false};
G.count=countItems(G);
for(var F=0;
F<this._ranges.length;
F++){var P=this._ranges[F];
if(P.from==G.from&&P.to==G.to){G.selected=true;
O=true;
break;
}}A.push(G);
}var O=this._ranges.length>0;
var L=this._dom.valuesContainer;
L.style.display="none";
var H=Exhibit.FacetUtilities[this._settings.scroll?"constructFacetItem":"constructFlowingFacetItem"];
var K=function(X,W,V,U){var R=function(Z,Y,a){Q._toggleRange(X,W,U,false);
SimileAjax.DOM.cancelEvent(Y);
return false;
};
var T=function(Z,Y,a){Q._toggleRange(X,W,U,!(Y.ctrlKey||Y.metaKey));
SimileAjax.DOM.cancelEvent(Y);
return false;
};
var S=H(X.substr(0,1)+" - "+W.substr(0,1),V,null,U,O,R,T,Q._uiContext);
L.appendChild(S);
};
for(var F=0;
F<A.length;
F++){var G=A[F];
if(G.selected||G.count>0){K(G.from,G.to,G.count,G.selected);
}}L.style.display="block";
this._dom.setSelectionCount(this._ranges.length);
};
Exhibit.AlphaRangeFacet.prototype._notifyCollection=function(){this._uiContext.getCollection().onFacetUpdated(this);
};
Exhibit.AlphaRangeFacet.prototype._initializeUI=function(){var A=this;
this._dom=Exhibit.FacetUtilities[this._settings.scroll?"constructFacetFrame":"constructFlowingFacetFrame"](this,this._div,this._settings.facetLabel,function(C,B,D){A._clearSelections();
},this._uiContext,this._settings.collapsible,this._settings.collapsed);
if("height" in this._settings){this._dom.valuesContainer.style.height=this._settings.height;
}};
Exhibit.AlphaRangeFacet.prototype._toggleRange=function(G,H,D,E){var I=this;
var F=G+" to "+H;
var A=(this._ranges.length==1&&D);
if(E&&!A){var B=[{from:G,to:H}];
var C=[].concat(this._ranges);
SimileAjax.History.addLengthyAction(function(){I.applyRestrictions(B);
},function(){I.applyRestrictions(C);
},String.substitute(Exhibit.FacetUtilities.l10n["facetSelectOnlyActionTitle"],[F,this._settings.facetLabel]));
}else{SimileAjax.History.addLengthyAction(function(){I.setRange(G,H,!D);
},function(){I.setRange(G,H,D);
},String.substitute(Exhibit.FacetUtilities.l10n[D?"facetUnselectActionTitle":"facetSelectActionTitle"],[F,this._settings.facetLabel]));
}};
Exhibit.AlphaRangeFacet.prototype._clearSelections=function(){var B={};
var A=this;
SimileAjax.History.addLengthyAction(function(){B.restrictions=A.clearAllRestrictions();
},function(){A.applyRestrictions(B.restrictions);
},String.substitute(Exhibit.FacetUtilities.l10n["facetClearSelectionsActionTitle"],[this._settings.facetLabel]));
};
Exhibit.AlphaRangeFacet.prototype._buildRangeIndex=function(){if(!("_rangeIndex" in this)){var E=this._expression;
var D=this._uiContext.getDatabase();
var B=E.getPath().getLastSegment();
var C=D.getProperty(B.property);
var A=function(F,G){D.getObjects(F,C.getID(),null,null).visit(function(H){G(H.toUpperCase());
});
};
this._rangeIndex=new Exhibit.Database._RangeIndex(this._uiContext.getCollection().getAllItems(),A);
}};
Exhibit.AlphaRangeFacet.prototype.exportFacetSelection=function(){var C=[];
for(var B=0;
B<this._ranges.length;
B++){var A=this._ranges[B];
C.push(A.from+"|"+A.to);
}return C.join(",");
};
Exhibit.AlphaRangeFacet.prototype.importFacetSelection=function(D){if(D.length>0){var A=D.split(",");
for(var C=0;
C<A.length;
C++){var B=A[C].split("|");
this._ranges.push({from:B[0],to:B[1]});
}}if(A&&A.length>0){this.update();
this._notifyCollection();
}};


/* cloud-facet.js */
Exhibit.CloudFacet=function(C,B){this._div=C;
this._uiContext=B;
this._colorCoder=null;
this._expression=null;
this._valueSet=new Exhibit.Set();
this._selectMissing=false;
this._settings={};
this._dom=null;
var A=this;
this._listener={onRootItemsChanged:function(){if("_itemToValue" in A){delete A._itemToValue;
}if("_valueToItem" in A){delete A._valueToItem;
}if("_missingItems" in A){delete A._missingItems;
}}};
B.getCollection().addListener(this._listener);
};
Exhibit.CloudFacet._settingSpecs={"facetLabel":{type:"text"},"minimumCount":{type:"int",defaultValue:1},"showMissing":{type:"boolean",defaultValue:true},"missingLabel":{type:"text"}};
Exhibit.CloudFacet.create=function(D,B,A){var A=Exhibit.UIContext.create(D,A);
var C=new Exhibit.CloudFacet(B,A);
Exhibit.CloudFacet._configure(C,D);
C._initializeUI();
A.getCollection().addFacet(C);
return C;
};
Exhibit.CloudFacet.createFromDOM=function(A,D,F){var C=Exhibit.getConfigurationFromDOM(A);
var F=Exhibit.UIContext.createFromDOM(A,F);
var B=new Exhibit.CloudFacet(D!=null?D:A,F);
Exhibit.SettingsUtilities.collectSettingsFromDOM(A,Exhibit.CloudFacet._settingSpecs,B._settings);
try{var E=Exhibit.getAttribute(A,"expression");
if(E!=null&&E.length>0){B._expression=Exhibit.ExpressionParser.parse(E);
}var J=Exhibit.getAttribute(A,"selection",";");
if(J!=null&&J.length>0){for(var G=0,K;
K=J[G];
G++){B._valueSet.add(K);
}}var H=Exhibit.getAttribute(A,"selectMissing");
if(H!=null&&H.length>0){B._selectMissing=(H=="true");
}}catch(I){SimileAjax.Debug.exception(I,"CloudFacet: Error processing configuration of cloud facet");
}Exhibit.CloudFacet._configure(B,C);
B._initializeUI();
F.getCollection().addFacet(B);
return B;
};
Exhibit.CloudFacet._configure=function(D,C){Exhibit.SettingsUtilities.collectSettings(C,Exhibit.CloudFacet._settingSpecs,D._settings);
if("expression" in C){D._expression=Exhibit.ExpressionParser.parse(C.expression);
}if("selection" in C){var B=C.selection;
for(var A=0;
A<B.length;
A++){D._valueSet.add(B[A]);
}}if("selectMissing" in C){D._selectMissing=C.selectMissing;
}};
Exhibit.CloudFacet.prototype.dispose=function(){this._uiContext.getCollection().removeFacet(this);
this._uiContext.getCollection().removeListener(this._listener);
this._uiContext=null;
this._div.innerHTML="";
this._div=null;
this._dom=null;
this._expression=null;
this._valueSet=null;
this._settings=null;
this._itemToValue=null;
this._valueToItem=null;
this._missingItems=null;
};
Exhibit.CloudFacet.prototype.hasRestrictions=function(){return this._valueSet.size()>0||this._selectMissing;
};
Exhibit.CloudFacet.prototype.clearAllRestrictions=function(){var A={selection:[],selectMissing:false};
if(this.hasRestrictions()){this._valueSet.visit(function(B){A.selection.push(B);
});
this._valueSet=new Exhibit.Set();
A.selectMissing=this._selectMissing;
this._selectMissing=false;
this._notifyCollection();
}return A;
};
Exhibit.CloudFacet.prototype.applyRestrictions=function(B){this._valueSet=new Exhibit.Set();
for(var A=0;
A<B.selection.length;
A++){this._valueSet.add(B.selection[A]);
}this._selectMissing=B.selectMissing;
this._notifyCollection();
};
Exhibit.CloudFacet.prototype.setSelection=function(B,A){if(A){this._valueSet.add(B);
}else{this._valueSet.remove(B);
}this._notifyCollection();
};
Exhibit.CloudFacet.prototype.setSelectMissing=function(A){if(A!=this._selectMissing){this._selectMissing=A;
this._notifyCollection();
}};
Exhibit.CloudFacet.prototype.restrict=function(B){if(this._valueSet.size()==0&&!this._selectMissing){return B;
}var D;
if(this._expression.isPath()){D=this._expression.getPath().walkBackward(this._valueSet,"item",B,this._uiContext.getDatabase()).getSet();
}else{this._buildMaps();
D=new Exhibit.Set();
var C=this._valueToItem;
this._valueSet.visit(function(G){if(G in C){var H=C[G];
for(var E=0;
E<H.length;
E++){var F=H[E];
if(B.contains(F)){D.add(F);
}}}});
}if(this._selectMissing){this._buildMaps();
var A=this._missingItems;
B.visit(function(E){if(E in A){D.add(E);
}});
}return D;
};
Exhibit.CloudFacet.prototype.update=function(A){this._constructBody(this._computeFacet(A));
};
Exhibit.CloudFacet.prototype._computeFacet=function(I){var G=this._uiContext.getDatabase();
var F=[];
var Q="text";
var H=this;
if(this._expression.isPath()){var J=this._expression.getPath();
var T=J.walkForward(I,"item",G);
Q=T.valueType;
if(T.size>0){T.forEachValue(function(V){var U=J.evaluateBackward(V,Q,I,G);
if(U.size>=H._settings.minimumCount||H._valueSet.contains(V)){F.push({value:V,count:U.size});
}});
}}else{this._buildMaps();
Q=this._valueType;
for(var L in this._valueToItem){var K=this._valueToItem[L];
var E=0;
for(var O=0;
O<K.length;
O++){if(I.contains(K[O])){E++;
}}if(E>=this._settings.minimumCount||this._valueSet.contains(L)){F.push({value:L,count:E});
}}}if(F.length>0){var S=this._valueSet;
var B=Q=="item"?function(V){var U=G.getObject(V,"label");
return U!=null?U:V;
}:function(U){return U;
};
for(var O=0;
O<F.length;
O++){var A=F[O];
A.actionLabel=A.selectionLabel=B(A.value);
A.selected=S.contains(A.value);
}var D=function(V,U){return V.selectionLabel.localeCompare(U.selectionLabel);
};
if("_orderMap" in this){var P=this._orderMap;
D=function(V,U){if(V.selectionLabel in P){if(U.selectionLabel in P){return P[V.selectionLabel]-P[U.selectionLabel];
}else{return -1;
}}else{if(U.selectionLabel in P){return 1;
}else{return V.selectionLabel.localeCompare(U.selectionLabel);
}}};
}else{if(Q=="number"){D=function(V,U){V=parseFloat(V.value);
U=parseFloat(U.value);
return V<U?-1:V>U?1:0;
};
}}var M=D;
if(this._settings.sortMode=="count"){M=function(V,U){var W=U.count-V.count;
return W!=0?W:D(V,U);
};
}var C=M;
if(this._settings.sortDirection=="reverse"){C=function(V,U){return M(U,V);
};
}F.sort(C);
}if(this._settings.showMissing||this._selectMissing){this._buildMaps();
var E=0;
for(var R in this._missingItems){if(I.contains(R)){E++;
}}if(E>0||this._selectMissing){var N=document.createElement("span");
N.innerHTML=("missingLabel" in this._settings)?this._settings.missingLabel:Exhibit.FacetUtilities.l10n.missingThisField;
N.className="exhibit-facet-value-missingThisField";
F.unshift({value:null,count:E,selected:this._selectMissing,selectionLabel:N,actionLabel:Exhibit.FacetUtilities.l10n.missingThisField});
}}return F;
};
Exhibit.CloudFacet.prototype._notifyCollection=function(){this._uiContext.getCollection().onFacetUpdated(this);
};
Exhibit.CloudFacet.prototype._initializeUI=function(){this._div.innerHTML="";
this._div.className="exhibit-cloudFacet";
var A=SimileAjax.DOM.createDOMFromString(this._div,(("facetLabel" in this._settings)?("<div class='exhibit-cloudFacet-header'><span class='exhibit-cloudFacet-header-title'>"+this._settings.facetLabel+"</span></div>"):"")+"<div class='exhibit-cloudFacet-body' id='valuesContainer'></div>");
this._dom=A;
};
Exhibit.CloudFacet.prototype._constructBody=function(E){var I=this;
var A=this._dom.valuesContainer;
A.style.display="none";
A.innerHTML="";
if(E.length>0){var B=Number.POSITIVE_INFINITY;
var G=Number.NEGATIVE_INFINITY;
for(var C=0;
C<E.length;
C++){var H=E[C];
B=Math.min(B,H.count);
G=Math.max(G,H.count);
}var D=G-B;
var F=function(L){var J=function(N,M,O){I._filter(L.value,L.actionLabel,!(M.ctrlKey||M.metaKey));
SimileAjax.DOM.cancelEvent(M);
return false;
};
var K=document.createElement("span");
K.appendChild(document.createTextNode("\u00A0"));
if(typeof L.selectionLabel=="string"){K.appendChild(document.createTextNode(L.selectionLabel));
}else{K.appendChild(L.selectionLabel);
}K.appendChild(document.createTextNode("\u00A0"));
K.className=L.selected?"exhibit-cloudFacet-value exhibit-cloudFacet-value-selected":"exhibit-cloudFacet-value";
if(L.count>B){K.style.fontSize=Math.ceil(100+100*Math.log(1+1.5*(L.count-B)/D))+"%";
}SimileAjax.WindowManager.registerEvent(K,"click",J,SimileAjax.WindowManager.getBaseLayer());
A.appendChild(K);
A.appendChild(document.createTextNode(" "));
};
for(var C=0;
C<E.length;
C++){F(E[C]);
}}A.style.display="block";
};
Exhibit.CloudFacet.prototype._filter=function(M,J,B){var O=this;
var C,K,H;
var N=new Exhibit.Set(this._valueSet);
var L=this._selectMissing;
var Q;
var I;
var A;
var G;
var D;
if(M==null){G=L;
D=G&&(N.size()==0);
if(B){if(N.size()==0){I=!L;
}else{I=true;
}Q=new Exhibit.Set();
}else{I=!L;
Q=new Exhibit.Set(N);
}}else{G=N.contains(M);
D=G&&(N.size()==1)&&!L;
if(B){I=false;
Q=new Exhibit.Set();
if(!N.contains(M)){Q.add(M);
}else{if(N.size()>1||L){Q.add(M);
}}}else{I=L;
Q=new Exhibit.Set(N);
if(Q.contains(M)){Q.remove(M);
}else{Q.add(M);
}}}var E={selection:Q.toArray(),selectMissing:I};
var F={selection:N.toArray(),selectMissing:L};
var P=("facetLabel" in this._settings)?this._settings.facetLabel:"";
SimileAjax.History.addLengthyAction(function(){O.applyRestrictions(E);
},function(){O.applyRestrictions(F);
},(B&&!D)?String.substitute(Exhibit.FacetUtilities.l10n["facetSelectOnlyActionTitle"],[J,P]):String.substitute(Exhibit.FacetUtilities.l10n[G?"facetUnselectActionTitle":"facetSelectActionTitle"],[J,P]));
};
Exhibit.CloudFacet.prototype._clearSelections=function(){var B={};
var A=this;
SimileAjax.History.addLengthyAction(function(){B.restrictions=A.clearAllRestrictions();
},function(){A.applyRestrictions(B.restrictions);
},String.substitute(Exhibit.FacetUtilities.l10n["facetClearSelectionsActionTitle"],[this._settings.facetLabel]));
};
Exhibit.CloudFacet.prototype._buildMaps=function(){if(!("_itemToValue" in this)){var B={};
var C={};
var A={};
var G="text";
var E=function(H,J,I){if(H in I){I[H].push(J);
}else{I[H]=[J];
}};
var F=this._expression;
var D=this._uiContext.getDatabase();
this._uiContext.getCollection().getAllItems().visit(function(I){var H=F.evaluateOnItem(I,D);
if(H.values.size()>0){G=H.valueType;
H.values.visit(function(J){E(I,J,B);
E(J,I,C);
});
}else{A[I]=true;
}});
this._itemToValue=B;
this._valueToItem=C;
this._missingItems=A;
this._valueType=G;
}};


/* hierarchical-facet.js */
Exhibit.HierarchicalFacet=function(C,B){this._div=C;
this._uiContext=B;
this._colorCoder=null;
this._expression=null;
this._uniformGroupingExpression=null;
this._selections=[];
this._expanded={};
this._settings={};
this._dom=null;
var A=this;
this._listener={onRootItemsChanged:function(){if("_cache" in A){delete A._cache;
}}};
B.getCollection().addListener(this._listener);
};
Exhibit.HierarchicalFacet._settingSpecs={"facetLabel":{type:"text"},"fixedOrder":{type:"text"},"sortMode":{type:"text",defaultValue:"value"},"sortDirection":{type:"text",defaultValue:"forward"},"othersLabel":{type:"text"},"scroll":{type:"boolean",defaultValue:true},"height":{type:"text"},"colorCoder":{type:"text",defaultValue:null},"collapsible":{type:"boolean",defaultValue:false},"collapsed":{type:"boolean",defaultValue:false}};
Exhibit.HierarchicalFacet.create=function(D,B,A){var A=Exhibit.UIContext.create(D,A);
var C=new Exhibit.HierarchicalFacet(B,A);
Exhibit.HierarchicalFacet._configure(C,D);
C._initializeUI();
A.getCollection().addFacet(C);
return C;
};
Exhibit.HierarchicalFacet.createFromDOM=function(A,E,G){var D=Exhibit.getConfigurationFromDOM(A);
var G=Exhibit.UIContext.createFromDOM(A,G);
var C=new Exhibit.HierarchicalFacet(E!=null?E:A,G);
Exhibit.SettingsUtilities.collectSettingsFromDOM(A,Exhibit.HierarchicalFacet._settingSpecs,C._settings);
try{var F=Exhibit.getAttribute(A,"expression");
if(F!=null&&F.length>0){C._expression=Exhibit.ExpressionParser.parse(F);
}var B=Exhibit.getAttribute(A,"uniformGrouping");
if(B!=null&&B.length>0){C._uniformGroupingExpression=Exhibit.ExpressionParser.parse(B);
}var J=Exhibit.getAttribute(A,"selection",";");
if(J!=null&&J.length>0){for(var H=0,K;
K=J[H];
H++){C._selections=C._internalAddSelection({value:K,selectOthers:false});
}}}catch(I){SimileAjax.Debug.exception(I,"HierarchicalFacet: Error processing configuration of hierarchical facet");
}Exhibit.HierarchicalFacet._configure(C,D);
C._initializeUI();
G.getCollection().addFacet(C);
return C;
};
Exhibit.HierarchicalFacet._configure=function(H,G){Exhibit.SettingsUtilities.collectSettings(G,Exhibit.HierarchicalFacet._settingSpecs,H._settings);
if("expression" in G){H._expression=Exhibit.ExpressionParser.parse(G.expression);
}if("uniformGrouping" in G){H._uniformGroupingExpression=Exhibit.ExpressionParser.parse(G.uniformGrouping);
}if("selection" in G){var C=G.selection;
for(var B=0;
B<C.length;
B++){H._selections.push({value:C[B],selectOthers:false});
}}if(!("facetLabel" in H._settings)){H._settings.facetLabel="missing ex:facetLabel";
if(H._expression!=null&&H._expression.isPath()){var D=H._expression.getPath().getLastSegment();
var E=H._uiContext.getDatabase().getProperty(D.property);
if(E!=null){H._settings.facetLabel=D.forward?E.getLabel():E.getReverseLabel();
}}}if("fixedOrder" in H._settings){var A=H._settings.fixedOrder.split(";");
var F={};
for(var B=0;
B<A.length;
B++){F[A[B].trim()]=B;
}H._orderMap=F;
}if("colorCoder" in H._settings){H._colorCoder=H._uiContext.getExhibit().getComponent(H._settings.colorCoder);
}if(H._settings.collapsed){H._settings.collapsible=true;
}};
Exhibit.HierarchicalFacet.prototype.dispose=function(){this._uiContext.getCollection().removeFacet(this);
this._uiContext.getCollection().removeListener(this._listener);
this._uiContext=null;
this._colorCoder=null;
this._div.innerHTML="";
this._div=null;
this._dom=null;
this._expression=null;
this._uniformGroupingExpression=null;
this._selections=null;
this._settings=null;
this._cache=null;
};
Exhibit.HierarchicalFacet.prototype.hasRestrictions=function(){return this._selections.length>0;
};
Exhibit.HierarchicalFacet.prototype.clearAllRestrictions=function(){var A=this._selections;
this._selections=[];
if(A.length>0){this._notifyCollection();
}return A;
};
Exhibit.HierarchicalFacet.prototype.applyRestrictions=function(A){this._selections=[].concat(A);
this._notifyCollection();
};
Exhibit.HierarchicalFacet.prototype.setSelection=function(C,B){var A={value:C,selectOthers:false};
if(B){this._selections=this._internalAddSelection(A);
}else{this._selections=this._internalRemoveSelection(A);
}this._notifyCollection();
};
Exhibit.HierarchicalFacet.prototype.setselectOthers=function(C,B){var A={value:C,selectOthers:true};
if(B){this._selections=this._internalAddSelection(A);
}else{this._selections=this._internalRemoveSelection(A);
}this._notifyCollection();
};
Exhibit.HierarchicalFacet.prototype.restrict=function(A){if(this._selections.length==0){return A;
}this._buildCache();
var G=new Exhibit.Set();
var E=function(H){if("children" in H){F(H.children);
Exhibit.Set.createIntersection(H.others,A,G);
}else{Exhibit.Set.createIntersection(H.items,A,G);
}};
var F=function(I){for(var H=0;
H<I.length;
H++){E(I[H]);
}};
for(var B=0;
B<this._selections.length;
B++){var C=this._selections[B];
var D=this._getTreeNode(C.value);
if(D){if(C.selectOthers){Exhibit.Set.createIntersection(D.others,A,G);
}else{E(D);
}}}return G;
};
Exhibit.HierarchicalFacet.prototype._internalAddSelection=function(G){var F={};
var I={};
var A=this._cache;
var E=function(N){if(N in A.valueToParent){var K=A.valueToParent[N];
for(var L=0;
L<K.length;
L++){var M=K[L];
F[M]=true;
E(M);
}}};
var B=function(M){if(M in A.valueToChildren){var L=A.valueToChildren[M];
for(var K=0;
K<L.length;
K++){var N=L[K];
I[N]=true;
B(N);
}}};
if(G.value!=null){E(G.value);
if(G.selectOthers){F[G.value]=true;
}else{I[G.value]=true;
B(G.value);
}}var D=this._selections;
var H=[G];
for(var C=0;
C<D.length;
C++){var J=D[C];
if((!(J.value in F)||J.selectOthers)&&(!(J.value in I))){H.push(J);
}}return H;
};
Exhibit.HierarchicalFacet.prototype._internalRemoveSelection=function(D){var E=this._selections;
var A=[];
for(var B=0;
B<E.length;
B++){var C=E[B];
if(C.value!=D.value||C.selectOthers!=D.selectOthers){A.push(C);
}}return A;
};
Exhibit.HierarchicalFacet.prototype.update=function(B){this._dom.valuesContainer.style.display="none";
this._dom.valuesContainer.innerHTML="";
var A=this._computeFacet(B);
if(A){this._constructBody(A);
}this._dom.valuesContainer.style.display="block";
};
Exhibit.HierarchicalFacet.prototype._computeFacet=function(F){this._buildCache();
var G=this._uiContext.getDatabase();
var H=this._getValueSorter();
var B="othersLabel" in this._settings?this._settings.othersLabel:"(others)";
var E={};
for(var C=0;
C<this._selections.length;
C++){var I=this._selections[C];
E[I.value]=I.selectOthers;
}var D=function(K,M,P){var N=(K.value in E&&!E[K.value]);
if("children" in K){var S={value:K.value,label:K.label,children:[],selected:N,areOthers:false};
var R=new Exhibit.Set();
for(var O=0;
O<K.children.length;
O++){var J=K.children[O];
D(J,S.children,R);
}S.children.sort(H);
if(K.others.size()>0){var Q=(K.value in E&&E[K.value]);
var L=Exhibit.Set.createIntersection(F,K.others);
if(L.size()>0||Q){S.children.push({value:K.value,label:B,count:L.size(),selected:Q,areOthers:true});
R.addSet(L);
}}S.count=R.size();
if(N||S.count>0||S.children.length>0){M.push(S);
if(P!=null&&R.size()>0){P.addSet(R);
}}}else{var L=Exhibit.Set.createIntersection(F,K.items);
if(L.size()>0||N){M.push({value:K.value,label:K.label,count:L.size(),selected:N,areOthers:false});
if(P!=null&&L.size()>0){P.addSet(L);
}}}};
var A=[];
D(this._cache.tree,A,null);
return A[0];
};
Exhibit.HierarchicalFacet.prototype._getValueSorter=function(){var C=function(F,E){return F.label.localeCompare(E.label);
};
if("_orderMap" in this){var D=this._orderMap;
C=function(F,E){if(F.label in D){if(E.label in D){return D[F.label]-D[E.label];
}else{return -1;
}}else{if(E.label in D){return 1;
}else{return F.label.localeCompare(E.label);
}}};
}else{if(this._cache.valueType=="number"){C=function(F,E){F=parseFloat(F.value);
E=parseFloat(E.value);
return F<E?-1:F>E?1:0;
};
}}var A=C;
if(this._settings.sortMode=="count"){A=function(F,E){var G=E.count-F.count;
return G!=0?G:C(F,E);
};
}var B=A;
if(this._settings.sortDirection=="reverse"){B=function(F,E){return A(E,F);
};
}return B;
};
Exhibit.HierarchicalFacet.prototype._notifyCollection=function(){this._uiContext.getCollection().onFacetUpdated(this);
};
Exhibit.HierarchicalFacet.prototype._initializeUI=function(){var A=this;
this._dom=Exhibit.FacetUtilities[this._settings.scroll?"constructFacetFrame":"constructFlowingFacetFrame"](this,this._div,this._settings.facetLabel,function(C,B,D){A._clearSelections();
},this._uiContext,this._settings.collapsible,this._settings.collapsed);
if("height" in this._settings&&this._settings.scroll){this._dom.valuesContainer.style.height=this._settings.height;
}};
Exhibit.HierarchicalFacet.prototype._constructBody=function(A){var B=this;
var G=this._dom.valuesContainer;
G.style.display="none";
var F=Exhibit.FacetUtilities[this._settings.scroll?"constructHierarchicalFacetItem":"constructFlowingHierarchicalFacetItem"];
var C=this._selections.length>0;
var E=function(L,N){var H=("children" in L);
var I=function(P,O,Q){B._filter(L.value,L.areOthers,L.label,L.selected,false);
SimileAjax.DOM.cancelEvent(O);
return false;
};
var K=function(P,O,Q){B._filter(L.value,L.areOthers,L.label,L.selected,!(O.ctrlKey||O.metaKey));
SimileAjax.DOM.cancelEvent(O);
return false;
};
var J=function(Q,P,R){var O;
if(L.value in B._expanded){delete B._expanded[L.value];
O=false;
}else{B._expanded[L.value]=true;
O=true;
}M.showChildren(O);
SimileAjax.DOM.cancelEvent(P);
return false;
};
var M=F(L.label,L.count,(B._colorCoder!=null)?B._colorCoder.translate(L.value):null,L.selected,H,(L.value in B._expanded),C,I,K,J,B._uiContext);
N.appendChild(M.elmt);
if(H){D(L.children,M.childrenContainer);
}};
var D=function(I,J){for(var H=0;
H<I.length;
H++){E(I[H],J);
}};
D(A.children,G);
G.style.display="block";
this._dom.setSelectionCount(this._selections.length);
};
Exhibit.HierarchicalFacet.prototype._filter=function(H,C,G,F,B){var J=this;
var A=F&&this._selections.length==1;
var I={value:H,selectOthers:C};
var E=this._selections;
var D;
if(F){if(B){if(A){D=[];
}else{D=[I];
}}else{D=this._internalRemoveSelection(I);
}}else{if(B){D=[I];
}else{D=this._internalAddSelection(I);
}}SimileAjax.History.addLengthyAction(function(){J.applyRestrictions(D);
},function(){J.applyRestrictions(E);
},(B&&!A)?String.substitute(Exhibit.FacetUtilities.l10n["facetSelectOnlyActionTitle"],[G,this._settings.facetLabel]):String.substitute(Exhibit.FacetUtilities.l10n[F?"facetUnselectActionTitle":"facetSelectActionTitle"],[G,this._settings.facetLabel]));
};
Exhibit.HierarchicalFacet.prototype._clearSelections=function(){var B={};
var A=this;
SimileAjax.History.addLengthyAction(function(){B.restrictions=A.clearAllRestrictions();
},function(){A.applyRestrictions(B.restrictions);
},String.substitute(Exhibit.FacetUtilities.l10n["facetClearSelectionsActionTitle"],[this._settings.facetLabel]));
};
Exhibit.HierarchicalFacet.prototype._buildCache=function(){if(!("_cache" in this)){var L={};
var B="text";
var D={};
var F={};
var N={};
var J=new Exhibit.Set();
var K=function(P,R,Q){if(P in Q){Q[P].push(R);
}else{Q[P]=[R];
}};
var I=this._uiContext.getDatabase();
var O={value:null,label:"(root)",others:new Exhibit.Set(),children:[]};
var E=this._expression;
this._uiContext.getCollection().getAllItems().visit(function(Q){var P=E.evaluateOnItem(Q,I);
if(P.values.size()>0){B=P.valueType;
P.values.visit(function(R){J.add(R);
K(R,Q,L);
});
}else{O.others.add(Q);
}});
var A=this._uniformGroupingExpression;
var M=new Exhibit.Set();
var H=function(P){var Q=new Exhibit.Set();
P.visit(function(S){var R=A.evaluateOnItem(S,I);
if(R.values.size()>0){R.values.visit(function(T){K(S,T,F);
K(T,S,D);
if(!P.contains(T)){Q.add(T);
}return true;
});
}else{M.add(S);
}});
if(Q.size()>0){H(Q);
}};
H(J);
var G=function(W,Q,Y,Z){var V=I.getObject(W,"label");
var R={value:W,label:V!=null?V:W};
Q.push(R);
N[W]=Z;
if(W in D){R.children=[];
var P=new Exhibit.Set();
var U=D[W];
for(var S=0;
S<U.length;
S++){G(U[S],R.children,P,Z.concat(S));
}R.others=new Exhibit.Set();
if(W in L){var T=L[W];
for(var S=0;
S<T.length;
S++){var X=T[S];
if(!P.contains(X)){R.others.add(X);
Y.add(X);
}}}Y.addSet(P);
}else{R.items=new Exhibit.Set();
if(W in L){var T=L[W];
for(var S=0;
S<T.length;
S++){var X=T[S];
R.items.add(X);
Y.add(X);
}}}};
var C=0;
M.visit(function(P){G(P,O.children,new Exhibit.Set(),[C++]);
});
this._cache={tree:O,valueToChildren:D,valueToParent:F,valueToPath:N,valueType:B};
}};
Exhibit.HierarchicalFacet.prototype._getTreeNode=function(B){if(B==null){return this._cache.tree;
}var C=this._cache.valueToPath[B];
var A=function(F,G,E){var D=F.children[G[E]];
if(++E<G.length){return A(D,G,E);
}else{return D;
}};
return(C)?A(this._cache.tree,C,0):null;
};


/* image-facet.js */
Exhibit.ImageFacet=function(B,A){this._div=B;
this._uiContext=A;
this._colorCoder=null;
this._expression=null;
this._valueSet=new Exhibit.Set();
this._selectMissing=false;
this._settings={};
this._dom=null;
};
Exhibit.ImageFacet._settingSpecs={"facetLabel":{type:"text"},"thumbNail":{type:"uri"},"overlayCounts":{type:"boolean",defaultValue:true},"fixedOrder":{type:"text"},"sortMode":{type:"text",defaultValue:"value"},"sortDirection":{type:"text",defaultValue:"forward"},"showMissing":{type:"boolean",defaultValue:true},"missingLabel":{type:"text"},"scroll":{type:"boolean",defaultValue:true},"height":{type:"text"},"colorCoder":{type:"text",defaultValue:null},"collapsible":{type:"boolean",defaultValue:false},"collapsed":{type:"boolean",defaultValue:false}};
Exhibit.ImageFacet.create=function(D,B,A){var A=Exhibit.UIContext.create(D,A);
var C=new Exhibit.ImageFacet(B,A);
Exhibit.ImageFacet._configure(C,D);
C._initializeUI();
A.getCollection().addFacet(C);
return C;
};
Exhibit.ImageFacet.createFromDOM=function(A,D,G){var C=Exhibit.getConfigurationFromDOM(A);
var G=Exhibit.UIContext.createFromDOM(A,G);
var B=new Exhibit.ImageFacet(D!=null?D:A,G);
Exhibit.SettingsUtilities.collectSettingsFromDOM(A,Exhibit.ImageFacet._settingSpecs,B._settings);
try{var E=Exhibit.getAttribute(A,"expression");
if(E!=null&&E.length>0){B._expression=Exhibit.ExpressionParser.parse(E);
}var F=Exhibit.getAttribute(A,"image");
if(F!=null&&F.length>0){B._imageExpression=Exhibit.ExpressionParser.parse(F);
}var L=Exhibit.getAttribute(A,"tooltip");
if(L!=null&&L.length>0){B._tooltipExpression=Exhibit.ExpressionParser.parse(L);
}var K=Exhibit.getAttribute(A,"selection",";");
if(K!=null&&K.length>0){for(var H=0,M;
M=K[H];
H++){B._valueSet.add(M);
}}var I=Exhibit.getAttribute(A,"selectMissing");
if(I!=null&&I.length>0){B._selectMissing=(I=="true");
}}catch(J){SimileAjax.Debug.exception(J,"ImageFacet: Error processing configuration of list facet");
}Exhibit.ImageFacet._configure(B,C);
B._initializeUI();
G.getCollection().addFacet(B);
return B;
};
Exhibit.ImageFacet._configure=function(H,G){Exhibit.SettingsUtilities.collectSettings(G,Exhibit.ImageFacet._settingSpecs,H._settings);
if("expression" in G){H._expression=Exhibit.ExpressionParser.parse(G.expression);
}if("image" in G){H._imageExpression=Exhibit.ExpressionParser.parse(G.image);
}if("tooltip" in G){H._tooltipExpression=Exhibit.ExpressionParser.parse(G.tooltip);
}if(!(H._imageExpression)){H._imageExpression=Exhibit.ExpressionParser.parse("value");
}if(!(H._tooltipExpression)){H._tooltipExpression=Exhibit.ExpressionParser.parse("value");
}if("selection" in G){var C=G.selection;
for(var B=0;
B<C.length;
B++){H._valueSet.add(C[B]);
}}if("selectMissing" in G){H._selectMissing=G.selectMissing;
}if(!("facetLabel" in H._settings)){H._settings.facetLabel="missing ex:facetLabel";
if(H._expression!=null&&H._expression.isPath()){var D=H._expression.getPath().getLastSegment();
var E=H._uiContext.getDatabase().getProperty(D.property);
if(E!=null){H._settings.facetLabel=D.forward?E.getLabel():E.getReverseLabel();
}}}if("fixedOrder" in H._settings){var A=H._settings.fixedOrder.split(";");
var F={};
for(var B=0;
B<A.length;
B++){F[A[B].trim()]=B;
}H._orderMap=F;
}if("colorCoder" in H._settings){H._colorCoder=H._uiContext.getExhibit().getComponent(H._settings.colorCoder);
}if(H._settings.collapsed){H._settings.collapsible=true;
}H._cache=new Exhibit.FacetUtilities.Cache(H._uiContext.getDatabase(),H._uiContext.getCollection(),H._expression);
};
Exhibit.ImageFacet.prototype.dispose=function(){this._cache.dispose();
this._cache=null;
this._uiContext.getCollection().removeFacet(this);
this._uiContext=null;
this._colorCoder=null;
this._div.innerHTML="";
this._div=null;
this._dom=null;
this._expression=null;
this._valueSet=null;
this._settings=null;
};
Exhibit.ImageFacet.prototype.hasRestrictions=function(){return this._valueSet.size()>0||this._selectMissing;
};
Exhibit.ImageFacet.prototype.clearAllRestrictions=function(){var A={selection:[],selectMissing:false};
if(this.hasRestrictions()){this._valueSet.visit(function(B){A.selection.push(B);
});
this._valueSet=new Exhibit.Set();
A.selectMissing=this._selectMissing;
this._selectMissing=false;
this._notifyCollection();
}return A;
};
Exhibit.ImageFacet.prototype.applyRestrictions=function(B){this._valueSet=new Exhibit.Set();
for(var A=0;
A<B.selection.length;
A++){this._valueSet.add(B.selection[A]);
}this._selectMissing=B.selectMissing;
this._notifyCollection();
};
Exhibit.ImageFacet.prototype.setSelection=function(B,A){if(A){this._valueSet.add(B);
}else{this._valueSet.remove(B);
}this._notifyCollection();
};
Exhibit.ImageFacet.prototype.setSelectMissing=function(A){if(A!=this._selectMissing){this._selectMissing=A;
this._notifyCollection();
}};
Exhibit.ImageFacet.prototype.restrict=function(A){if(this._valueSet.size()==0&&!this._selectMissing){return A;
}var B=this._cache.getItemsFromValues(this._valueSet,A);
if(this._selectMissing){this._cache.getItemsMissingValue(A,B);
}return B;
};
Exhibit.ImageFacet.prototype.update=function(A){this._dom.valuesContainer.style.display="none";
this._dom.valuesContainer.innerHTML="";
this._constructBody(this._computeFacet(A));
this._dom.valuesContainer.style.display="block";
};
Exhibit.ImageFacet.prototype._computeFacet=function(E){var I=this._uiContext.getDatabase();
var A=this._cache.getValueCountsFromItems(E);
var D=A.entries;
var B=A.valueType;
if(D.length>0){var H=this._valueSet;
var F=B=="item"?function(K){var J=I.getObject(K,"label");
return J!=null?J:K;
}:function(J){return J;
};
for(var C=0;
C<D.length;
C++){var G=D[C];
G.actionLabel=G.selectionLabel=F(G.value);
G.image=this._imageExpression.evaluateSingleOnItem(G.value,I).value;
G.tooltip=this._tooltipExpression.evaluateSingleOnItem(G.value,I).value;
G.selected=H.contains(G.value);
}D.sort(this._createSortFunction(B));
}return D;
};
Exhibit.ImageFacet.prototype._notifyCollection=function(){this._uiContext.getCollection().onFacetUpdated(this);
};
Exhibit.ImageFacet.prototype._initializeUI=function(){var A=this;
this._dom=Exhibit.FacetUtilities[this._settings.scroll?"constructFacetFrame":"constructFlowingFacetFrame"](this,this._div,this._settings.facetLabel,function(C,B,D){A._clearSelections();
},this._uiContext,this._settings.collapsible,this._settings.collapsed);
if("height" in this._settings&&this._settings.scroll){this._dom.valuesContainer.style.height=this._settings.height;
}};
Exhibit.ImageFacet.prototype._constructBody=function(A){var B=this;
var F=this._settings.overlayCounts;
var G=this._dom.valuesContainer;
G.style.display="none";
var D=this._valueSet.size()>0||this._selectMissing;
var E=function(L){var J=function(Q,P,R){B._filter(L.value,L.actionLabel,!(P.ctrlKey||P.metaKey));
SimileAjax.DOM.cancelEvent(P);
return false;
};
var I=document.createElement("span");
var O=document.createElement("div");
O.className="wrapper";
var N=document.createElement("img");
N.src=L.image;
O.appendChild(N);
if(F==true){var K=document.createElement("div");
K.className="countDiv";
var M=document.createElement("div");
M.className="countBackground";
K.appendChild(M);
var H=document.createElement("div");
H.className="text";
H.innerHTML=L.count;
K.appendChild(H);
O.appendChild(K);
}I.appendChild(O);
I.className=L.selected?"inline-block exhibit-imageFacet-value exhibit-imageFacet-value-selected":"inline-block exhibit-imageFacet-value";
I.title=L.count+" "+L.tooltip;
SimileAjax.WindowManager.registerEvent(I,"click",J,SimileAjax.WindowManager.getBaseLayer());
G.appendChild(I);
};
for(var C=0;
C<A.length;
C++){E(A[C]);
}G.style.display="block";
this._dom.setSelectionCount(this._valueSet.size()+(this._selectMissing?1:0));
};
Exhibit.ImageFacet.prototype._filter=function(M,J,B){var O=this;
var C,K,H;
var N=new Exhibit.Set(this._valueSet);
var L=this._selectMissing;
var P;
var I;
var A;
var G;
var D;
if(M==null){G=L;
D=G&&(N.size()==0);
if(B){if(N.size()==0){I=!L;
}else{I=true;
}P=new Exhibit.Set();
}else{I=!L;
P=new Exhibit.Set(N);
}}else{G=N.contains(M);
D=G&&(N.size()==1)&&!L;
if(B){I=false;
P=new Exhibit.Set();
if(!N.contains(M)){P.add(M);
}else{if(N.size()>1||L){P.add(M);
}}}else{I=L;
P=new Exhibit.Set(N);
if(P.contains(M)){P.remove(M);
}else{P.add(M);
}}}var E={selection:P.toArray(),selectMissing:I};
var F={selection:N.toArray(),selectMissing:L};
SimileAjax.History.addLengthyAction(function(){O.applyRestrictions(E);
},function(){O.applyRestrictions(F);
},(B&&!D)?String.substitute(Exhibit.FacetUtilities.l10n["facetSelectOnlyActionTitle"],[J,this._settings.facetLabel]):String.substitute(Exhibit.FacetUtilities.l10n[G?"facetUnselectActionTitle":"facetSelectActionTitle"],[J,this._settings.facetLabel]));
};
Exhibit.ImageFacet.prototype._clearSelections=function(){var B={};
var A=this;
SimileAjax.History.addLengthyAction(function(){B.restrictions=A.clearAllRestrictions();
},function(){A.applyRestrictions(B.restrictions);
},String.substitute(Exhibit.FacetUtilities.l10n["facetClearSelectionsActionTitle"],[this._settings.facetLabel]));
};
Exhibit.ImageFacet.prototype._createSortFunction=function(E){var C=function(G,F){return G.selectionLabel.localeCompare(F.selectionLabel);
};
if("_orderMap" in this){var D=this._orderMap;
C=function(G,F){if(G.selectionLabel in D){if(F.selectionLabel in D){return D[G.selectionLabel]-D[F.selectionLabel];
}else{return -1;
}}else{if(F.selectionLabel in D){return 1;
}else{return G.selectionLabel.localeCompare(F.selectionLabel);
}}};
}else{if(E=="number"){C=function(G,F){G=parseFloat(G.value);
F=parseFloat(F.value);
return G<F?-1:G>F?1:0;
};
}}var A=C;
if(this._settings.sortMode=="count"){A=function(G,F){var H=F.count-G.count;
return H!=0?H:C(G,F);
};
}var B=A;
if(this._settings.sortDirection=="reverse"){B=function(G,F){return A(F,G);
};
}return B;
};


/* list-facet.js */
Exhibit.ListFacet=function(B,A){this._div=B;
this._uiContext=A;
this._colorCoder=null;
this._expression=null;
this._valueSet=new Exhibit.Set();
this._selectMissing=false;
this._delayedUpdateItems=null;
this._settings={};
this._dom=null;
};
Exhibit.ListFacet._settingSpecs={"facetLabel":{type:"text"},"fixedOrder":{type:"text"},"sortMode":{type:"text",defaultValue:"value"},"sortDirection":{type:"text",defaultValue:"forward"},"showMissing":{type:"boolean",defaultValue:true},"missingLabel":{type:"text"},"scroll":{type:"boolean",defaultValue:true},"height":{type:"text"},"colorCoder":{type:"text",defaultValue:null},"collapsible":{type:"boolean",defaultValue:false},"collapsed":{type:"boolean",defaultValue:false},"formatter":{type:"text",defaultValue:null}};
Exhibit.ListFacet.create=function(D,B,A){var A=Exhibit.UIContext.create(D,A);
var C=new Exhibit.ListFacet(B,A);
Exhibit.ListFacet._configure(C,D);
C._initializeUI();
A.getCollection().addFacet(C);
return C;
};
Exhibit.ListFacet.createFromDOM=function(A,D,F){var C=Exhibit.getConfigurationFromDOM(A);
var F=Exhibit.UIContext.createFromDOM(A,F);
var B=new Exhibit.ListFacet(D!=null?D:A,F);
Exhibit.SettingsUtilities.collectSettingsFromDOM(A,Exhibit.ListFacet._settingSpecs,B._settings);
try{var E=Exhibit.getAttribute(A,"expression");
if(E!=null&&E.length>0){B._expression=Exhibit.ExpressionParser.parse(E);
}var J=Exhibit.getAttribute(A,"selection",";");
if(J!=null&&J.length>0){for(var G=0,K;
K=J[G];
G++){B._valueSet.add(K);
}}var H=Exhibit.getAttribute(A,"selectMissing");
if(H!=null&&H.length>0){B._selectMissing=(H=="true");
}}catch(I){SimileAjax.Debug.exception(I,"ListFacet: Error processing configuration of list facet");
}Exhibit.ListFacet._configure(B,C);
B._initializeUI();
F.getCollection().addFacet(B);
return B;
};
Exhibit.ListFacet._configure=function(facet,configuration){Exhibit.SettingsUtilities.collectSettings(configuration,Exhibit.ListFacet._settingSpecs,facet._settings);
if("expression" in configuration){facet._expression=Exhibit.ExpressionParser.parse(configuration.expression);
}if("selection" in configuration){var selection=configuration.selection;
for(var i=0;
i<selection.length;
i++){facet._valueSet.add(selection[i]);
}}if("selectMissing" in configuration){facet._selectMissing=configuration.selectMissing;
}if(!("facetLabel" in facet._settings)){facet._settings.facetLabel="missing ex:facetLabel";
if(facet._expression!=null&&facet._expression.isPath()){var segment=facet._expression.getPath().getLastSegment();
var property=facet._uiContext.getDatabase().getProperty(segment.property);
if(property!=null){facet._settings.facetLabel=segment.forward?property.getLabel():property.getReverseLabel();
}}}if("fixedOrder" in facet._settings){var values=facet._settings.fixedOrder.split(";");
var orderMap={};
for(var i=0;
i<values.length;
i++){orderMap[values[i].trim()]=i;
}facet._orderMap=orderMap;
}if("colorCoder" in facet._settings){facet._colorCoder=facet._uiContext.getExhibit().getComponent(facet._settings.colorCoder);
}if(facet._settings.collapsed){facet._settings.collapsible=true;
}if("formatter" in facet._settings){var formatter=facet._settings.formatter;
if(formatter!=null&&formatter.length>0){try{facet._formatter=eval(formatter);
}catch(e){SimileAjax.Debug.log(e);
}}}facet._cache=new Exhibit.FacetUtilities.Cache(facet._uiContext.getDatabase(),facet._uiContext.getCollection(),facet._expression);
};
Exhibit.ListFacet.prototype.dispose=function(){this._cache.dispose();
this._cache=null;
this._uiContext.getCollection().removeFacet(this);
this._uiContext=null;
this._colorCoder=null;
this._div.innerHTML="";
this._div=null;
this._dom=null;
this._expression=null;
this._valueSet=null;
this._settings=null;
};
Exhibit.ListFacet.prototype.hasRestrictions=function(){return this._valueSet.size()>0||this._selectMissing;
};
Exhibit.ListFacet.prototype.clearAllRestrictions=function(){var A={selection:[],selectMissing:false};
if(this.hasRestrictions()){this._valueSet.visit(function(B){A.selection.push(B);
});
this._valueSet=new Exhibit.Set();
A.selectMissing=this._selectMissing;
this._selectMissing=false;
this._notifyCollection();
}return A;
};
Exhibit.ListFacet.prototype.applyRestrictions=function(B){this._valueSet=new Exhibit.Set();
for(var A=0;
A<B.selection.length;
A++){this._valueSet.add(B.selection[A]);
}this._selectMissing=B.selectMissing;
this._notifyCollection();
};
Exhibit.ListFacet.prototype.setSelection=function(B,A){if(A){this._valueSet.add(B);
}else{this._valueSet.remove(B);
}this._notifyCollection();
};
Exhibit.ListFacet.prototype.setSelectMissing=function(A){if(A!=this._selectMissing){this._selectMissing=A;
this._notifyCollection();
}};
Exhibit.ListFacet.prototype.restrict=function(A){if(this._valueSet.size()==0&&!this._selectMissing){return A;
}var B=this._cache.getItemsFromValues(this._valueSet,A);
if(this._selectMissing){this._cache.getItemsMissingValue(A,B);
}return B;
};
Exhibit.ListFacet.prototype.onUncollapse=function(){if(this._delayedUpdateItems!=null){this.update(this._delayedUpdateItems);
this._delayedUpdateItems=null;
}};
Exhibit.ListFacet.prototype.update=function(A){if(Exhibit.FacetUtilities.isCollapsed(this)){this._delayedUpdateItems=A;
return ;
}this._dom.valuesContainer.style.display="none";
this._dom.valuesContainer.innerHTML="";
this._constructBody(this._computeFacet(A));
this._dom.valuesContainer.style.display="block";
};
Exhibit.ListFacet.prototype._computeFacet=function(F){var K=this._uiContext.getDatabase();
var A=this._cache.getValueCountsFromItems(F);
var D=A.entries;
var B=A.valueType;
if(D.length>0){var J=this._valueSet;
var G=B=="item"?function(M){var L=K.getObject(M,"label");
return L!=null?L:M;
}:function(L){return L;
};
for(var C=0;
C<D.length;
C++){var I=D[C];
I.actionLabel=I.selectionLabel=G(I.value);
I.selected=J.contains(I.value);
}D.sort(this._createSortFunction(B));
}if(this._settings.showMissing||this._selectMissing){var E=this._cache.countItemsMissingValue(F);
if(E>0||this._selectMissing){var H=document.createElement("span");
H.innerHTML=("missingLabel" in this._settings)?this._settings.missingLabel:Exhibit.FacetUtilities.l10n.missingThisField;
H.className="exhibit-facet-value-missingThisField";
D.unshift({value:null,count:E,selected:this._selectMissing,selectionLabel:H,actionLabel:Exhibit.FacetUtilities.l10n.missingThisField});
}}return D;
};
Exhibit.ListFacet.prototype._notifyCollection=function(){this._uiContext.getCollection().onFacetUpdated(this);
};
Exhibit.ListFacet.prototype._initializeUI=function(){var A=this;
this._dom=Exhibit.FacetUtilities[this._settings.scroll?"constructFacetFrame":"constructFlowingFacetFrame"](this,this._div,this._settings.facetLabel,function(C,B,D){A._clearSelections();
},this._uiContext,this._settings.collapsible,this._settings.collapsed);
if("height" in this._settings&&this._settings.scroll){this._dom.valuesContainer.style.height=this._settings.height;
}};
Exhibit.ListFacet.prototype._constructBody=function(A){var B=this;
var G=this._dom.valuesContainer;
G.style.display="none";
var F=Exhibit.FacetUtilities[this._settings.scroll?"constructFacetItem":"constructFlowingFacetItem"];
var D=this._valueSet.size()>0||this._selectMissing;
var E=function(K){var H=function(M,L,N){B._filter(K.value,K.actionLabel,false);
SimileAjax.DOM.cancelEvent(L);
return false;
};
var J=function(M,L,N){B._filter(K.value,K.actionLabel,!(L.ctrlKey||L.metaKey));
SimileAjax.DOM.cancelEvent(L);
return false;
};
var I=F(K.selectionLabel,K.count,(B._colorCoder!=null)?B._colorCoder.translate(K.value):null,K.selected,D,H,J,B._uiContext);
if(B._formatter){B._formatter(I);
}G.appendChild(I);
};
for(var C=0;
C<A.length;
C++){E(A[C]);
}G.style.display="block";
this._dom.setSelectionCount(this._valueSet.size()+(this._selectMissing?1:0));
};
Exhibit.ListFacet.prototype._filter=function(M,J,B){var O=this;
var C,K,H;
var N=new Exhibit.Set(this._valueSet);
var L=this._selectMissing;
var P;
var I;
var A;
var G;
var D;
if(M==null){G=L;
D=G&&(N.size()==0);
if(B){if(N.size()==0){I=!L;
}else{I=true;
}P=new Exhibit.Set();
}else{I=!L;
P=new Exhibit.Set(N);
}}else{G=N.contains(M);
D=G&&(N.size()==1)&&!L;
if(B){I=false;
P=new Exhibit.Set();
if(!N.contains(M)){P.add(M);
}else{if(N.size()>1||L){P.add(M);
}}}else{I=L;
P=new Exhibit.Set(N);
if(P.contains(M)){P.remove(M);
}else{P.add(M);
}}}var E={selection:P.toArray(),selectMissing:I};
var F={selection:N.toArray(),selectMissing:L};
SimileAjax.History.addLengthyAction(function(){O.applyRestrictions(E);
},function(){O.applyRestrictions(F);
},(B&&!D)?String.substitute(Exhibit.FacetUtilities.l10n["facetSelectOnlyActionTitle"],[J,this._settings.facetLabel]):String.substitute(Exhibit.FacetUtilities.l10n[G?"facetUnselectActionTitle":"facetSelectActionTitle"],[J,this._settings.facetLabel]));
};
Exhibit.ListFacet.prototype._clearSelections=function(){var B={};
var A=this;
SimileAjax.History.addLengthyAction(function(){B.restrictions=A.clearAllRestrictions();
},function(){A.applyRestrictions(B.restrictions);
},String.substitute(Exhibit.FacetUtilities.l10n["facetClearSelectionsActionTitle"],[this._settings.facetLabel]));
};
Exhibit.ListFacet.prototype._createSortFunction=function(E){var C=function(G,F){return G.selectionLabel.localeCompare(F.selectionLabel);
};
if("_orderMap" in this){var D=this._orderMap;
C=function(G,F){if(G.selectionLabel in D){if(F.selectionLabel in D){return D[G.selectionLabel]-D[F.selectionLabel];
}else{return -1;
}}else{if(F.selectionLabel in D){return 1;
}else{return G.selectionLabel.localeCompare(F.selectionLabel);
}}};
}else{if(E=="number"){C=function(G,F){G=parseFloat(G.value);
F=parseFloat(F.value);
return G<F?-1:G>F?1:0;
};
}}var A=C;
if(this._settings.sortMode=="count"){A=function(G,F){var H=F.count-G.count;
return H!=0?H:C(G,F);
};
}var B=A;
if(this._settings.sortDirection=="reverse"){B=function(G,F){return A(F,G);
};
}return B;
};
Exhibit.ListFacet.prototype.exportFacetSelection=function(){var A=[];
this._valueSet.visit(function(B){A.push(B);
});
if(A.length>0){return A.join(",");
}};
Exhibit.ListFacet.prototype.importFacetSelection=function(B){var A=this;
A.applyRestrictions({selection:B.split(","),selectMissing:A._selectMissing});
};


/* numeric-range-facet.js */
Exhibit.NumericRangeFacet=function(C,B){this._div=C;
this._uiContext=B;
this._expression=null;
this._settings={};
this._dom=null;
this._ranges=[];
var A=this;
this._listener={onRootItemsChanged:function(){if("_rangeIndex" in A){delete A._rangeIndex;
}}};
B.getCollection().addListener(this._listener);
};
Exhibit.NumericRangeFacet._settingSpecs={"facetLabel":{type:"text"},"scroll":{type:"boolean",defaultValue:true},"height":{type:"text"},"interval":{type:"float",defaultValue:10},"collapsible":{type:"boolean",defaultValue:false},"collapsed":{type:"boolean",defaultValue:false}};
Exhibit.NumericRangeFacet.create=function(D,B,A){var A=Exhibit.UIContext.create(D,A);
var C=new Exhibit.NumericRangeFacet(B,A);
Exhibit.NumericRangeFacet._configure(C,D);
C._initializeUI();
A.getCollection().addFacet(C);
return C;
};
Exhibit.NumericRangeFacet.createFromDOM=function(E,D,A){var G=Exhibit.getConfigurationFromDOM(E);
var A=Exhibit.UIContext.createFromDOM(E,A);
var F=new Exhibit.NumericRangeFacet(D!=null?D:E,A);
Exhibit.SettingsUtilities.collectSettingsFromDOM(E,Exhibit.NumericRangeFacet._settingSpecs,F._settings);
try{var B=Exhibit.getAttribute(E,"expression");
if(B!=null&&B.length>0){F._expression=Exhibit.ExpressionParser.parse(B);
}}catch(C){SimileAjax.Debug.exception(C,"NumericRangeFacet: Error processing configuration of numeric range facet");
}Exhibit.NumericRangeFacet._configure(F,G);
F._initializeUI();
A.getCollection().addFacet(F);
return F;
};
Exhibit.NumericRangeFacet._configure=function(D,C){Exhibit.SettingsUtilities.collectSettings(C,Exhibit.NumericRangeFacet._settingSpecs,D._settings);
if("expression" in C){D._expression=Exhibit.ExpressionParser.parse(C.expression);
}if(!("facetLabel" in D._settings)){D._settings.facetLabel="missing ex:facetLabel";
if(D._expression!=null&&D._expression.isPath()){var A=D._expression.getPath().getLastSegment();
var B=D._uiContext.getDatabase().getProperty(A.property);
if(B!=null){D._settings.facetLabel=A.forward?B.getLabel():B.getReverseLabel();
}}}if(D._settings.collapsed){D._settings.collapsible=true;
}};
Exhibit.NumericRangeFacet.prototype.dispose=function(){this._uiContext.getCollection().removeFacet(this);
this._uiContext.getCollection().removeListener(this._listener);
this._uiContext=null;
this._div.innerHTML="";
this._div=null;
this._dom=null;
this._expression=null;
this._settings=null;
this._ranges=null;
};
Exhibit.NumericRangeFacet.prototype.hasRestrictions=function(){return this._ranges.length>0;
};
Exhibit.NumericRangeFacet.prototype.clearAllRestrictions=function(){var A=[];
if(this._ranges.length>0){A=A.concat(this._ranges);
this._ranges=[];
this._notifyCollection();
}return A;
};
Exhibit.NumericRangeFacet.prototype.applyRestrictions=function(A){this._ranges=A;
this._notifyCollection();
};
Exhibit.NumericRangeFacet.prototype.setRange=function(E,D,C){if(C){for(var B=0;
B<this._ranges.length;
B++){var A=this._ranges[B];
if(A.from==E&&A.to==D){return ;
}}this._ranges.push({from:E,to:D});
}else{for(var B=0;
B<this._ranges.length;
B++){var A=this._ranges[B];
if(A.from==E&&A.to==D){this._ranges.splice(B,1);
break;
}}}this._notifyCollection();
};
Exhibit.NumericRangeFacet.prototype.restrict=function(B){if(this._ranges.length==0){return B;
}else{if(this._expression.isPath()){var E=this._expression.getPath();
var D=this._uiContext.getDatabase();
var F=new Exhibit.Set();
for(var C=0;
C<this._ranges.length;
C++){var A=this._ranges[C];
F.addSet(E.rangeBackward(A.from,A.to,false,B,D).values);
}return F;
}else{this._buildRangeIndex();
var F=new Exhibit.Set();
for(var C=0;
C<this._ranges.length;
C++){var A=this._ranges[C];
this._rangeIndex.getSubjectsInRange(A.from,A.to,false,F,B);
}return F;
}}};
Exhibit.NumericRangeFacet.prototype.update=function(A){this._dom.valuesContainer.style.display="none";
this._dom.valuesContainer.innerHTML="";
this._reconstruct(A);
this._dom.valuesContainer.style.display="block";
};
Exhibit.NumericRangeFacet.prototype._reconstruct=function(K){var J=this;
var A=[];
var R;
var C;
if(this._expression.isPath()){var H=this._uiContext.getDatabase();
var L=this._expression.getPath();
var N=L.getLastSegment().property;
var B=H.getProperty(N);
if(B==null){return null;
}R=B.getRangeIndex();
countItems=function(T){return L.rangeBackward(T.from,T.to,false,K,H).values.size();
};
}else{this._buildRangeIndex();
R=this._rangeIndex;
countItems=function(T){return R.getSubjectsInRange(T.from,T.to,false,null,K).size();
};
}var O=R.getMin();
var P=R.getMax();
O=Math.floor(O/this._settings.interval)*this._settings.interval;
P=Math.ceil((P+this._settings.interval)/this._settings.interval)*this._settings.interval;
for(var D=O;
D<P;
D+=this._settings.interval){var I={from:D,to:D+this._settings.interval,selected:false};
I.count=countItems(I);
for(var Q=0;
Q<this._ranges.length;
Q++){var G=this._ranges[Q];
if(G.from==I.from&&G.to==I.to){I.selected=true;
F=true;
break;
}}A.push(I);
}var F=this._ranges.length>0;
var E=this._dom.valuesContainer;
E.style.display="none";
var S=Exhibit.FacetUtilities[this._settings.scroll?"constructFacetItem":"constructFlowingFacetItem"];
var M=function(Z,Y,X,W){var T=function(b,a,c){J._toggleRange(Z,Y,W,false);
SimileAjax.DOM.cancelEvent(a);
return false;
};
var V=function(b,a,c){J._toggleRange(Z,Y,W,!(a.ctrlKey||a.metaKey));
SimileAjax.DOM.cancelEvent(a);
return false;
};
var U=S(Z+" - "+Y,X,null,W,F,T,V,J._uiContext);
E.appendChild(U);
};
for(var Q=0;
Q<A.length;
Q++){var I=A[Q];
if(I.selected||I.count>0){M(I.from,I.to,I.count,I.selected);
}}E.style.display="block";
this._dom.setSelectionCount(this._ranges.length);
};
Exhibit.NumericRangeFacet.prototype._notifyCollection=function(){this._uiContext.getCollection().onFacetUpdated(this);
};
Exhibit.NumericRangeFacet.prototype._initializeUI=function(){var A=this;
this._dom=Exhibit.FacetUtilities[this._settings.scroll?"constructFacetFrame":"constructFlowingFacetFrame"](this,this._div,this._settings.facetLabel,function(C,B,D){A._clearSelections();
},this._uiContext,this._settings.collapsible,this._settings.collapsed);
if("height" in this._settings){this._dom.valuesContainer.style.height=this._settings.height;
}};
Exhibit.NumericRangeFacet.prototype._toggleRange=function(G,H,D,E){var I=this;
var F=G+" to "+H;
var A=(this._ranges.length==1&&D);
if(E&&!A){var B=[{from:G,to:H}];
var C=[].concat(this._ranges);
SimileAjax.History.addLengthyAction(function(){I.applyRestrictions(B);
},function(){I.applyRestrictions(C);
},String.substitute(Exhibit.FacetUtilities.l10n["facetSelectOnlyActionTitle"],[F,this._settings.facetLabel]));
}else{SimileAjax.History.addLengthyAction(function(){I.setRange(G,H,!D);
},function(){I.setRange(G,H,D);
},String.substitute(Exhibit.FacetUtilities.l10n[D?"facetUnselectActionTitle":"facetSelectActionTitle"],[F,this._settings.facetLabel]));
}};
Exhibit.NumericRangeFacet.prototype._clearSelections=function(){var B={};
var A=this;
SimileAjax.History.addLengthyAction(function(){B.restrictions=A.clearAllRestrictions();
},function(){A.applyRestrictions(B.restrictions);
},String.substitute(Exhibit.FacetUtilities.l10n["facetClearSelectionsActionTitle"],[this._settings.facetLabel]));
};
Exhibit.NumericRangeFacet.prototype._buildRangeIndex=function(){if(!("_rangeIndex" in this)){var C=this._expression;
var B=this._uiContext.getDatabase();
var A=function(D,E){C.evaluateOnItem(D,B).values.visit(function(F){if(typeof F!="number"){F=parseFloat(F);
}if(!isNaN(F)){E(F);
}});
};
this._rangeIndex=new Exhibit.Database._RangeIndex(this._uiContext.getCollection().getAllItems(),A);
}};


/* slider-facet.js */
Exhibit.SliderFacet=function(B,A){this._div=B;
this._uiContext=A;
this._expression=null;
this._settings={};
this._selection={min:null,max:null};
this._range={min:null,max:null};
this._maxRange={min:null,max:null};
};
Exhibit.SliderFacet._settingsSpecs={"facetLabel":{type:"text"},"scroll":{type:"boolean",defaultValue:true},"height":{type:"text"},"precision":{type:"float",defaultValue:1},"histogram":{type:"boolean",defaultValue:true},"height":{type:"int",defaultValue:false},"width":{type:"int",defaultValue:false},"horizontal":{type:"boolean",defaultValue:true},"inputText":{type:"boolean",defaultValue:true}};
Exhibit.SliderFacet.create=function(D,B,A){var A=Exhibit.UIContext.create(D,A);
var C=new Exhibit.SliderFacet(B,A);
Exhibit.SliderFacet._configure(C,D);
C._initializeUI();
A.getCollection().addFacet(C);
return C;
};
Exhibit.SliderFacet.createFromDOM=function(E,D,A){var G=Exhibit.getConfigurationFromDOM(E);
var A=Exhibit.UIContext.createFromDOM(E,A);
var F=new Exhibit.SliderFacet(D!=null?D:E,A);
Exhibit.SettingsUtilities.collectSettingsFromDOM(E,Exhibit.SliderFacet._settingsSpecs,F._settings);
try{var B=Exhibit.getAttribute(E,"expression");
if(B!=null&&B.length>0){F._expression=Exhibit.ExpressionParser.parse(B);
}}catch(C){SimileAjax.Debug.exception(C,"SliderFacet: Error processing configuration of slider facet");
}Exhibit.SliderFacet._configure(F,G);
F._initializeUI();
A.getCollection().addFacet(F);
return F;
};
Exhibit.SliderFacet._configure=function(E,D){Exhibit.SettingsUtilities.collectSettings(D,Exhibit.SliderFacet._settingsSpecs,E._settings);
if("expression" in D){E._expression=Exhibit.ExpressionParser.parse(D.expression);
}if("selection" in D){var A=D.selection;
E._selection={min:A[0],max:A[1]};
}if(!("facetLabel" in E._settings)){E._settings.facetLabel="missing ex:facetLabel";
if(E._expression!=null&&E._expression.isPath()){var B=E._expression.getPath().getLastSegment();
var C=E._uiContext.getDatabase().getProperty(B.property);
if(C!=null){E._settings.facetLabel=B.forward?C.getLabel():C.getReverseLabel();
}}}E._maxRange=E._getMaxRange();
};
Exhibit.SliderFacet.prototype._initializeUI=function(){this._dom=SimileAjax.DOM.createDOMFromString(this._div,"<div class='exhibit-facet-header'><span class='exhibit-facet-header-title'>"+this._settings.facetLabel+"</span></div><div class='exhibit-slider' id='slider'></div>");
this._slider=new Exhibit.SliderFacet.slider(this._dom.slider,this,this._settings.precision,this._settings.horizontal);
};
Exhibit.SliderFacet.prototype.hasRestrictions=function(){return(this._range.min&&this._range.min!=this._maxRange.min)||(this._range.max&&this._range.max!=this._maxRange.max);
};
Exhibit.SliderFacet.prototype.update=function(B){if(this._settings.histogram){var E=[];
var G=75;
var A=(this._maxRange.max-this._maxRange.min)/G;
var D=this._uiContext.getDatabase();
var F=this._expression.getPath();
for(var C=0;
C<G;
C++){E[C]=F.rangeBackward(this._maxRange.min+C*A,this._maxRange.min+(C+1)*A,false,B,D).values.size();
}this._slider.updateHistogram(E);
}};
Exhibit.SliderFacet.prototype.restrict=function(A){if(!this.hasRestrictions()){return A;
}var C=this._expression.getPath();
var B=this._uiContext.getDatabase();
return C.rangeBackward(this._range.min,this._range.max,false,A,B).values;
};
Exhibit.SliderFacet.prototype._getMaxRange=function(){var E=this._expression.getPath();
var C=this._uiContext.getDatabase();
var D=E.getLastSegment().property;
var B=C.getProperty(D);
var A=B.getRangeIndex();
return{min:A.getMin(),max:A.getMax()};
};
Exhibit.SliderFacet.prototype.changeRange=function(A){this._range=A;
this._notifyCollection();
};
Exhibit.SliderFacet.prototype._notifyCollection=function(){this._uiContext.getCollection().onFacetUpdated(this);
};
Exhibit.SliderFacet.prototype.clearAllRestrictions=function(){this._slider.resetSliders();
this._range=this._maxRange;
};
Exhibit.SliderFacet.prototype.dispose=function(){this._uiContext.getCollection().removeFacet(this);
this._uiContext=null;
this._colorCoder=null;
this._div.innerHTML="";
this._div=null;
this._dom=null;
this._expression=null;
this._settings=null;
this._selection=null;
this._range=null;
this._maxRange=null;
};


/* slider.js */
Exhibit.SliderFacet.slider=function(E,D,B){this._div=E;
this._facet=D;
this._prec=B||0.1;
this._maxRange={min:parseFloat(Exhibit.Util.round(D._maxRange.min-B/2,this._prec)),max:parseFloat(Exhibit.Util.round(D._maxRange.max+B/2,this._prec))};
this._horizontal=this._facet._settings.horizontal;
this._scaleFactor=null;
this._slider1={};
this._slider2={};
this._dom=SimileAjax.DOM.createDOMFromString(E,'<div class="exhibit-slider-bar" id="bar"><div id="slider1"></div><div id="slider2"></div>'+(this._facet._settings.histogram?'<div class="exhibit-slider-histogram" id="histogram"></div>':"")+'</div><div class="exhibit-slider-display">'+(this._facet._settings.inputText?'<input type="text" id="minDisplay"></input> - <input type="text" id="maxDisplay"></input> ':'<span id="minDisplay"></span> - <span id="maxDisplay"></span>')+"</div>");
var A=this._horizontal;
var C=this._dom.histogram;
if(A&&C){this._dom.bar.style.height="14px";
this._dom.bar.style.width="150px";
}else{if(A&&!C){this._dom.bar.style.height="1px";
this._dom.bar.style.width="150px";
}else{if(!A&&C){this._dom.bar.style.height="150px";
this._dom.bar.style.width="14px";
}else{this._dom.bar.style.height="150px";
this._dom.bar.style.width="1px";
}}}if(this._facet._settings.height){this._dom.bar.style.height=this._facet._settings.height+"px";
}if(this._facet._settings.width){this._dom.bar.style.width=this._facet._settings.width+"px";
}if(C){this._dom.histogram.style.height=this._dom.bar.offsetHeight;
this._dom.histogram.style.width=this._dom.bar.offsetWidth;
}if(A){this._scaleFactor=(this._maxRange.max-this._maxRange.min)/this._dom.bar.offsetWidth;
}else{this._scaleFactor=(this._maxRange.max-this._maxRange.min)/this._dom.bar.offsetHeight;
}this._slider1=new Exhibit.SliderFacet.slider.slider(this._dom.slider1,this);
this._slider2=new Exhibit.SliderFacet.slider.slider(this._dom.slider2,this);
this._setSlider(this._slider1,this._maxRange.min);
this._setSlider(this._slider2,this._maxRange.max);
this._registerDragging();
if(this._facet._settings.inputText){this._registerInputs();
}};
Exhibit.SliderFacet.slider.prototype.resetSliders=function(){this._setSlider(this._slider1,this._maxRange.min);
this._setSlider(this._slider2,this._maxRange.max);
};
Exhibit.SliderFacet.slider.prototype._setSlider=function(A,B){if(B>this._maxRange.max){B=this._maxRange.max;
}else{if(B<this._maxRange.min){B=this._maxRange.min;
}}B=parseFloat(Exhibit.Util.round(B,this._prec));
A.value=B;
if(this._horizontal){A.div.style.left=((B-this._maxRange.min)/this._scaleFactor-A.offset)+"px";
}else{A.div.style.top=((B-this._maxRange.min)/this._scaleFactor-A.offset)+"px";
}this._setDisplays(A);
};
Exhibit.SliderFacet.slider.prototype._setMin=function(C){var B=this._slider1.value<this._slider2.value?this._slider1:this._slider2;
var A=(B==this._slider1)?this._slider2:this._slider1;
C=parseFloat(C);
if(isNaN(C)){return ;
}if(C>A.value){C=A.value;
}this._setSlider(B,C);
};
Exhibit.SliderFacet.slider.prototype._setMax=function(C){var B=this._slider1.value>this._slider2.value?this._slider1:this._slider2;
var A=(B==this._slider1)?this._slider2:this._slider1;
C=parseFloat(C);
if(isNaN(C)){return ;
}if(C<A.value){C=A.value;
}this._setSlider(B,C);
};
Exhibit.SliderFacet.slider.prototype._setDisplays=function(D){var B=(D==this._slider1)?this._slider2:this._slider1;
var C=Math.min(D.value,B.value);
var A=Math.max(D.value,B.value);
if(this._facet._settings.inputText){this._dom.minDisplay.value=C;
this._dom.maxDisplay.value=A;
}else{this._dom.minDisplay.innerHTML=C;
this._dom.maxDisplay.innerHTML=A;
}};
Exhibit.SliderFacet.slider.slider=function(C,B){var A=B._dom.bar;
this.div=C;
if(B._horizontal){this.div.className="exhibit-slider-handle";
this.div.style.backgroundImage='url("'+Exhibit.urlPrefix+'images/slider-handle.png")';
this.offset=this.div.offsetWidth/2;
this.min=-this.offset;
this.max=A.offsetWidth-this.offset;
}else{this.div.className="exhibit-slider-handle2";
this.div.style.backgroundImage='url("'+Exhibit.urlPrefix+'images/slider-handle2.png")';
this.offset=this.div.offsetHeight/2;
this.min=-this.offset;
this.max=A.offsetHeight-this.offset;
}if(B._facet._settings.histogram){this.div.style.top=(A.offsetHeight-4)+"px";
}};
Exhibit.SliderFacet.slider.prototype._registerDragging=function(){var B=this;
var A=function(G){return function(H){H=H||window.event;
var I=B._horizontal?D(H,G):C(H,G);
if(document.attachEvent){document.attachEvent("onmousemove",I);
document.attachEvent("onmouseup",F(G,I));
}else{document.addEventListener("mousemove",I,false);
document.addEventListener("mouseup",F(G,I),false);
}SimileAjax.DOM.cancelEvent(H);
return false;
};
};
var D=function(K,I){var L=K.screenX;
var J=parseInt(I.div.style.left);
var H=I.min;
var G=I.max;
return function(O){O=O||window.event;
var M=O.screenX-L;
var N=J+M;
if(N<H){N=H;
}if(N>G){N=G;
}I.div.style.left=N+"px";
setTimeout(function(){var P=parseInt(I.div.style.left)+I.offset;
I.value=parseFloat(Exhibit.Util.round(P*B._scaleFactor+B._maxRange.min,B._prec));
B._setDisplays(I);
},0);
};
};
var C=function(J,I){var K=J.screenY;
var L=parseInt(I.div.style.top);
var H=I.min;
var G=I.max;
return function(O){O=O||window.event;
var M=O.screenY-K;
var N=L+M;
if(N<H){N=H;
}if(N>G){N=G;
}I.div.style.top=N+"px";
setTimeout(function(){var P=parseInt(I.div.style.top)+I.offset;
I.value=parseFloat(Exhibit.Util.round(P*B._scaleFactor+B._maxRange.min,B._prec));
B._setDisplays(I);
},0);
};
};
var F=function(G,H){return function(I){if(document.detachEvent){document.detachEvent("onmousemove",H);
document.detachEvent("onmouseup",arguments.callee);
}else{document.removeEventListener("mousemove",H,false);
document.removeEventListener("mouseup",arguments.callee,false);
}B._notifyFacet();
};
};
var E=function(G){if(document.attachEvent){G.div.attachEvent("onmousedown",A(G));
}else{G.div.addEventListener("mousedown",A(G),false);
}};
E(this._slider1);
E(this._slider2);
};
Exhibit.SliderFacet.slider.prototype._notifyFacet=function(){var B=this._slider1.value;
var A=this._slider2.value;
this._facet.changeRange({min:Math.min(B,A),max:Math.max(B,A)});
};
Exhibit.SliderFacet.slider.prototype.updateHistogram=function(C){var B=C.length;
var G=this._dom.histogram;
var J=Math.max.apply(Math,C);
if(!J){return ;
}if(this._horizontal){var A=G.offsetWidth/B;
var H=G.offsetHeight;
var F=H/J;
G.innerHTML="";
for(var D=0;
D<B;
D++){var I=Math.round(C[D]*F);
var E=document.createElement("div");
G.appendChild(E);
E.style.width=A+"px";
E.style.height=I+"px";
E.style.display=I?"":"none";
E.style.position="absolute";
E.style.top=(H-I)+"px";
E.style.left=D*A+"px";
}}else{var A=G.offsetHeight/B;
var H=G.offsetWidth;
var F=H/J;
G.innerHTML="";
for(var D=0;
D<B;
D++){var I=Math.round(C[D]*F);
var E=document.createElement("div");
E.style.height=A;
E.style.width=I;
E.style.position="absolute";
E.style.left=0;
E.style.top=D*A;
G.appendChild(E);
}}};
Exhibit.SliderFacet.slider.prototype._registerInputs=function(){var A=this;
if(document.attachEvent){this._dom.minDisplay.attachEvent("onchange",function(B){A._setMin(this.value);
A._notifyFacet();
});
this._dom.maxDisplay.attachEvent("onchange",function(B){A._setMax(this.value);
A._notifyFacet();
});
}else{this._dom.minDisplay.addEventListener("change",function(B){A._setMin(this.value);
A._notifyFacet();
},false);
this._dom.maxDisplay.addEventListener("change",function(B){A._setMax(this.value);
A._notifyFacet();
},false);
}};


/* text-search-facet.js */
Exhibit.TextSearchFacet=function(C,B){this._div=C;
this._uiContext=B;
this._expressions=[];
this._text=null;
this._settings={};
this._dom=null;
this._timerID=null;
var A=this;
this._listener={onRootItemsChanged:function(){if("_itemToValue" in A){delete A._itemToValue;
}}};
B.getCollection().addListener(this._listener);
};
Exhibit.TextSearchFacet._settingSpecs={"facetLabel":{type:"text"},"queryParamName":{type:"text"},"requiresEnter":{type:"boolean",defaultValue:false}};
Exhibit.TextSearchFacet.create=function(D,B,A){var A=Exhibit.UIContext.create(D,A);
var C=new Exhibit.TextSearchFacet(B,A);
Exhibit.TextSearchFacet._configure(C,D);
C._initializeUI();
A.getCollection().addFacet(C);
return C;
};
Exhibit.TextSearchFacet.createFromDOM=function(F,E,A){var H=Exhibit.getConfigurationFromDOM(F);
var A=Exhibit.UIContext.createFromDOM(F,A);
var G=new Exhibit.TextSearchFacet(E!=null?E:F,A);
Exhibit.SettingsUtilities.collectSettingsFromDOM(F,Exhibit.TextSearchFacet._settingSpecs,G._settings);
try{var B=Exhibit.getAttribute(F,"expressions");
if(B!=null&&B.length>0){G._expressions=Exhibit.ExpressionParser.parseSeveral(B);
}var C=Exhibit.getAttribute(F,"query");
if(C!=null&&C.length>0){G._text=C;
}}catch(D){SimileAjax.Debug.exception(D,"TextSearchFacet: Error processing configuration of list facet");
}Exhibit.TextSearchFacet._configure(G,H);
G._initializeUI();
A.getCollection().addFacet(G);
return G;
};
Exhibit.TextSearchFacet._configure=function(E,D){Exhibit.SettingsUtilities.collectSettings(D,Exhibit.TextSearchFacet._settingSpecs,E._settings);
if("expressions" in D){for(var A=0;
A<D.expressions.length;
A++){E._expressions.push(Exhibit.ExpressionParser.parse(D.expressions[A]));
}}if("selection" in D){var B=D.selection;
for(var A=0;
A<B.length;
A++){E._valueSet.add(B[A]);
}}if("query" in D){E._text=D.query;
}if("queryParamName" in E._settings){var C=SimileAjax.parseURLParameters();
if(E._settings["queryParamName"] in C){E._text=C[E._settings["queryParamName"]];
}}if(!("facetLabel" in E._settings)){E._settings.facetLabel="";
}};
Exhibit.TextSearchFacet.prototype.dispose=function(){this._uiContext.getCollection().removeFacet(this);
this._uiContext.getCollection().removeListener(this._listener);
this._uiContext=null;
this._div.innerHTML="";
this._div=null;
this._dom=null;
this._expressions=null;
this._itemToValue=null;
this._settings=null;
};
Exhibit.TextSearchFacet.prototype.hasRestrictions=function(){return this._text!=null;
};
Exhibit.TextSearchFacet.prototype.clearAllRestrictions=function(){var A=this._text;
if(this._text!=null){this._text=null;
this._notifyCollection();
}this._dom.input.value="";
return A;
};
Exhibit.TextSearchFacet.prototype.applyRestrictions=function(A){this.setText(A);
};
Exhibit.TextSearchFacet.prototype.setText=function(A){if(A!=null){A=A.trim();
this._dom.input.value=A;
A=A.length>0?A:null;
}else{this._dom.input.value="";
}if(A!=this._text){this._text=A;
this._notifyCollection();
}};
Exhibit.TextSearchFacet.prototype.restrict=function(A){if(this._text==null){return A;
}else{this._buildMaps();
var D=new Exhibit.Set();
var B=this._itemToValue;
var C=this._text.toLowerCase();
A.visit(function(G){if(G in B){var F=B[G];
for(var E=0;
E<F.length;
E++){if(F[E].indexOf(C)>=0){D.add(G);
break;
}}}});
return D;
}};
Exhibit.TextSearchFacet.prototype.update=function(A){};
Exhibit.TextSearchFacet.prototype._notifyCollection=function(){this._uiContext.getCollection().onFacetUpdated(this);
};
Exhibit.TextSearchFacet.prototype._initializeUI=function(){var A=this;
this._dom=Exhibit.TextSearchFacet.constructFacetFrame(this._div,this._settings.facetLabel);
if(this._text!=null){this._dom.input.value=this._text;
}SimileAjax.WindowManager.registerEvent(this._dom.input,"keyup",function(C,B,D){A._onTextInputKeyUp(B);
});
};
Exhibit.TextSearchFacet.constructFacetFrame=function(B,A){if(A!==""&&A!==null){return SimileAjax.DOM.createDOMFromString(B,"<div class='exhibit-facet-header'><span class='exhibit-facet-header-title'>"+A+"</span></div><div class='exhibit-text-facet'><input type='text' id='input'></div>");
}else{return SimileAjax.DOM.createDOMFromString(B,"<div class='exhibit-text-facet'><input type='text' id='input'></div>");
}};
Exhibit.TextSearchFacet.prototype._onTextInputKeyUp=function(A){if(this._timerID!=null){window.clearTimeout(this._timerID);
}var B=this;
if(this._settings.requiresEnter==false){this._timerID=window.setTimeout(function(){B._onTimeout();
},500);
}else{var C=this._dom.input.value.trim();
if(C.length==0||A.keyCode==13){this._timerID=window.setTimeout(function(){B._onTimeout();
},0);
}}};
Exhibit.TextSearchFacet.prototype._onTimeout=function(){this._timerID=null;
var C=this._dom.input.value.trim();
if(C.length==0){C=null;
}if(C!=this._text){var B=this;
var A=this._text;
SimileAjax.History.addLengthyAction(function(){B.setText(C);
},function(){B.setText(A);
},C!=null?String.substitute(Exhibit.FacetUtilities.l10n["facetTextSearchActionTitle"],[C]):Exhibit.FacetUtilities.l10n["facetClearTextSearchActionTitle"]);
}};
Exhibit.TextSearchFacet.prototype._buildMaps=function(){if(!("_itemToValue" in this)){var A={};
var B=this._uiContext.getCollection().getAllItems();
var D=this._uiContext.getDatabase();
if(this._expressions.length>0){var C=this._expressions;
B.visit(function(H){var G=[];
for(var F=0;
F<C.length;
F++){var I=C[F];
I.evaluateOnItem(H,D).values.visit(function(J){G.push(J.toLowerCase());
});
}A[H]=G;
});
}else{var E=D.getAllProperties();
B.visit(function(G){var F=[];
for(var H=0;
H<E.length;
H++){D.getObjects(G,E[H]).visit(function(I){F.push(I.toLowerCase());
});
}A[G]=F;
});
}this._itemToValue=A;
}};
Exhibit.TextSearchFacet.prototype.exportFacetSelection=function(){return this._text;
};
Exhibit.TextSearchFacet.prototype.importFacetSelection=function(A){this.setText(A);
};


/* format-parser.js */
Exhibit.FormatParser=new Object();
Exhibit.FormatParser.parse=function(A,D,E,B){E=E||0;
B=B||{};
var C=new Exhibit.FormatScanner(D,E);
try{return Exhibit.FormatParser._internalParse(A,C,B,false);
}finally{B.index=C.token()!=null?C.token().start:C.index();
}};
Exhibit.FormatParser.parseSeveral=function(A,D,E,B){E=E||0;
B=B||{};
var C=new Exhibit.FormatScanner(D,E);
try{return Exhibit.FormatParser._internalParse(A,C,B,true);
}finally{B.index=C.token()!=null?C.token().start:C.index();
}};
Exhibit.FormatParser._valueTypes={"list":true,"number":true,"date":true,"item":true,"text":true,"url":true,"image":true,"currency":true};
Exhibit.FormatParser._internalParse=function(M,D,S,A){var U=Exhibit.FormatScanner;
var H=D.token();
var R=function(){D.next();
H=D.token();
};
var G=function(){return H!=null?H.start:D.index();
};
var C=function(Z,X,Y){M.putSetting("format/"+Z+"/"+X,Y);
};
var E=function(Z,Y,X){if(H!=null&&H.type!=U.IDENTIFIER&&H.value in X){C(Z,Y,X[H.value]);
R();
return false;
}return true;
};
var L=function(Z,Y,X){if(E(Z,Y,X)){if(H==null||H.type!=U.NUMBER){throw new Error("Missing number at position "+G());
}C(Z,Y,H.value);
R();
}};
var T=function(Z,Y,X){if(E(Z,Y,X)){if(H==null||H.type!=U.NUMBER){throw new Error("Missing integer at position "+G());
}C(Z,Y,Math.round(H.value));
R();
}};
var W=function(Z,Y,X){if(E(Z,Y,X)){if(H==null||H.type!=U.NUMBER||H.value<0){throw new Error("Missing non-negative integer at position "+G());
}C(Z,Y,Math.round(H.value));
R();
}};
var I=function(Z,Y,X){if(E(Z,Y,X)){if(H==null||H.type!=U.STRING){throw new Error("Missing string at position "+G());
}C(Z,Y,H.value);
R();
}};
var N=function(Z,Y,X){if(E(Z,Y,X)){if(H==null||H.type!=U.URL){throw new Error("Missing url at position "+G());
}C(Z,Y,H.value);
R();
}};
var Q=function(Z,Y,X){if(E(Z,Y,X)){if(H==null||H.type!=U.EXPRESSION){throw new Error("Missing expression at position "+G());
}C(Z,Y,H.value);
R();
}};
var F=function(Z,Y,X){if(E(Z,Y,X)){if(H==null||(H.type!=U.EXPRESSION&&H.type!=U.STRING)){throw new Error("Missing expression or string at position "+G());
}C(Z,Y,H.value);
R();
}};
var P=function(a,Y,Z){if(H==null||H.type!=U.IDENTIFIER){throw new Error("Missing option at position "+G());
}for(var X=0;
X<Z.length;
X++){if(H.value==Z[X]){C(a,Y,H.value);
R();
return ;
}}throw new Error("Unsupported option "+H.value+" for setting "+Y+" on value type "+a+" found at position "+G());
};
var J=function(b,a,Y,X){outer:while(H!=null&&H.type==U.IDENTIFIER){for(var Z=0;
Z<Y.length;
Z++){if(H.value==Y[Z]){C(b,a+"/"+H.value,true);
R();
continue outer;
}}if(H.value in X){C(b,a+"/"+X[H.value],false);
R();
continue outer;
}throw new Error("Unsupported flag "+H.value+" for setting "+a+" on value type "+b+" found at position "+G());
}};
var V=function(Y,X){switch(Y){case"number":switch(X){case"decimal-digits":W(Y,X,{"default":-1});
return ;
}break;
case"date":switch(X){case"time-zone":L(Y,X,{"default":null});
return ;
case"show":P(Y,X,["date","time","date-time"]);
return ;
case"mode":P(Y,X,["short","medium","long","full"]);
C(Y,"template",null);
return ;
case"template":I(Y,X,{});
C(Y,"mode",null);
return ;
}break;
case"boolean":switch(X){}break;
case"text":switch(X){case"max-length":T(Y,X,{"none":0});
return ;
}break;
case"image":switch(X){case"tooltip":F(Y,X,{"none":null});
return ;
case"max-width":case"max-height":T(Y,X,{"none":-1});
return ;
}break;
case"url":switch(X){case"target":I(Y,X,{"none":null});
return ;
case"external-icon":N(Y,X,{"none":null});
return ;
}break;
case"item":switch(X){case"title":Q(Y,X,{"default":null});
return ;
}break;
case"currency":switch(X){case"negative-format":J(Y,X,["red","parentheses","signed"],{"unsigned":"signed","no-parenthesis":"parentheses","black":"red"});
return ;
case"symbol":I(Y,X,{"default":"$","none":null});
return ;
case"symbol-placement":P(Y,X,["first","last","after-sign"]);
return ;
case"decimal-digits":W(Y,X,{"default":-1});
return ;
}break;
case"list":switch(X){case"separator":case"last-separator":case"pair-separator":case"empty-text":I(Y,X,{});
return ;
}break;
}throw new Error("Unsupported setting called "+X+" for value type "+Y+" found at position "+G());
};
var O=function(Y){while(H!=null&&H.type==U.IDENTIFIER){var X=H.value;
R();
if(H==null||H.type!=U.DELIMITER||H.value!=":"){throw new Error("Missing : at position "+G());
}R();
V(Y,X);
if(H==null||H.type!=U.DELIMITER||H.value!=";"){break;
}else{R();
}}};
var K=function(){if(H==null||H.type!=U.IDENTIFIER){throw new Error("Missing value type at position "+G());
}var X=H.value;
if(!(X in Exhibit.FormatParser._valueTypes)){throw new Error("Unsupported value type "+X+" at position "+G());
}R();
if(H!=null&&H.type==U.DELIMITER&&H.value=="{"){R();
O(X);
if(H==null||H.type!=U.DELIMITER||H.value!="}"){throw new Error("Missing } at position "+G());
}R();
}return X;
};
var B=function(){var X="text";
while(H!=null&&H.type==U.IDENTIFIER){X=K();
}return X;
};
if(A){return B();
}else{return K();
}};
Exhibit.FormatScanner=function(B,A){this._text=B+" ";
this._maxIndex=B.length;
this._index=A;
this.next();
};
Exhibit.FormatScanner.DELIMITER=0;
Exhibit.FormatScanner.NUMBER=1;
Exhibit.FormatScanner.STRING=2;
Exhibit.FormatScanner.IDENTIFIER=3;
Exhibit.FormatScanner.URL=4;
Exhibit.FormatScanner.EXPRESSION=5;
Exhibit.FormatScanner.COLOR=6;
Exhibit.FormatScanner.prototype.token=function(){return this._token;
};
Exhibit.FormatScanner.prototype.index=function(){return this._index;
};
Exhibit.FormatScanner.prototype.next=function(){this._token=null;
var J=this;
var B=function(L){while(L<J._maxIndex&&" \t\r\n".indexOf(J._text.charAt(L))>=0){L++;
}return L;
};
this._index=B(this._index);
if(this._index<this._maxIndex){var E=this._text.charAt(this._index);
var C=this._text.charAt(this._index+1);
if("{}(),:;".indexOf(E)>=0){this._token={type:Exhibit.FormatScanner.DELIMITER,value:E,start:this._index,end:this._index+1};
this._index++;
}else{if("\"'".indexOf(E)>=0){var F=this._index+1;
while(F<this._maxIndex){if(this._text.charAt(F)==E&&this._text.charAt(F-1)!="\\"){break;
}F++;
}if(F<this._maxIndex){this._token={type:Exhibit.FormatScanner.STRING,value:this._text.substring(this._index+1,F).replace(/\\'/g,"'").replace(/\\"/g,'"'),start:this._index,end:F+1};
this._index=F+1;
}else{throw new Error("Unterminated string starting at "+this._index);
}}else{if(E=="#"){var F=this._index+1;
while(F<this._maxIndex&&this._isHexDigit(this._text.charAt(F))){F++;
}this._token={type:Exhibit.FormatScanner.COLOR,value:this._text.substring(this._index,F),start:this._index,end:F};
this._index=F;
}else{if(this._isDigit(E)){var F=this._index;
while(F<this._maxIndex&&this._isDigit(this._text.charAt(F))){F++;
}if(F<this._maxIndex&&this._text.charAt(F)=="."){F++;
while(F<this._maxIndex&&this._isDigit(this._text.charAt(F))){F++;
}}this._token={type:Exhibit.FormatScanner.NUMBER,value:parseFloat(this._text.substring(this._index,F)),start:this._index,end:F};
this._index=F;
}else{var F=this._index;
while(F<this._maxIndex){var D=this._text.substr(F).search(/\W/);
if(D>0){F+=D;
}else{if("-".indexOf(this._text.charAt(F))>=0){F++;
}else{break;
}}}var H=this._text.substring(this._index,F);
while(true){if(H=="url"){var K=B(F);
if(this._text.charAt(K)=="("){var G=this._text.indexOf(")",K);
if(G>0){this._token={type:Exhibit.FormatScanner.URL,value:this._text.substring(K+1,G),start:this._index,end:G+1};
this._index=G+1;
break;
}else{throw new Error("Missing ) to close url at "+this._index);
}}}else{if(H=="expression"){var K=B(F);
if(this._text.charAt(K)=="("){var A={};
var I=Exhibit.ExpressionParser.parse(this._text,K+1,A);
var G=B(A.index);
if(this._text.charAt(G)==")"){this._token={type:Exhibit.FormatScanner.EXPRESSION,value:I,start:this._index,end:G+1};
this._index=G+1;
break;
}else{throw new Error("Missing ) to close expression at "+A.index);
}}}}this._token={type:Exhibit.FormatScanner.IDENTIFIER,value:H,start:this._index,end:F};
this._index=F;
break;
}}}}}}};
Exhibit.FormatScanner.prototype._isDigit=function(A){return"0123456789".indexOf(A)>=0;
};
Exhibit.FormatScanner.prototype._isHexDigit=function(A){return"0123456789abcdefABCDEF".indexOf(A)>=0;
};


/* formatter.js */
Exhibit.Formatter=new Object();
Exhibit.Formatter.createListDelimiter=function(G,C,A){var F=A.getSetting("format/list/separator");
var B=A.getSetting("format/list/last-separator");
var E=A.getSetting("format/list/pair-separator");
if(typeof F!="string"){F=Exhibit.Formatter.l10n.listSeparator;
}if(typeof B!="string"){B=Exhibit.Formatter.l10n.listLastSeparator;
}if(typeof E!="string"){E=Exhibit.Formatter.l10n.listPairSeparator;
}var D=function(){if(D.index>0&&D.index<C){if(C>2){G.appendChild(document.createTextNode((D.index==C-1)?B:F));
}else{G.appendChild(document.createTextNode(E));
}}D.index++;
};
D.index=0;
return D;
};
Exhibit.Formatter._lessThanRegex=/</g;
Exhibit.Formatter._greaterThanRegex=/>/g;
Exhibit.Formatter.encodeAngleBrackets=function(A){return A.replace(Exhibit.Formatter._lessThanRegex,"&lt;").replace(Exhibit.Formatter._greaterThanRegex,"&gt;");
};
Exhibit.Formatter._ListFormatter=function(A){this._uiContext=A;
this._separator=A.getSetting("format/list/separator");
this._lastSeparator=A.getSetting("format/list/last-separator");
this._pairSeparator=A.getSetting("format/list/pair-separator");
this._emptyText=A.getSetting("format/list/empty-text");
if(typeof this._separator!="string"){this._separator=Exhibit.Formatter.l10n.listSeparator;
}if(typeof this._lastSeparator!="string"){this._lastSeparator=Exhibit.Formatter.l10n.listLastSeparator;
}if(typeof this._pairSeparator!="string"){this._pairSeparator=Exhibit.Formatter.l10n.listPairSeparator;
}};
Exhibit.Formatter._ListFormatter.prototype.formatList=function(D,F,G,A){var C=this._uiContext;
var B=this;
if(F==0){if(this._emptyText!=null&&this._emptyText.length>0){A(document.createTextNode(this._emptyText));
}}else{if(F==1){D.visit(function(H){C.format(H,G,A);
});
}else{var E=0;
if(F==2){D.visit(function(H){C.format(H,G,A);
E++;
if(E==1){A(document.createTextNode(B._pairSeparator));
}});
}else{D.visit(function(H){C.format(H,G,A);
E++;
if(E<F){A(document.createTextNode((E==F-1)?B._lastSeparator:B._separator));
}});
}}}};
Exhibit.Formatter._TextFormatter=function(A){this._maxLength=A.getSetting("format/text/max-length");
if(typeof this._maxLength=="number"){this._maxLength=Math.max(3,Math.round(this._maxLength));
}else{this._maxLength=0;
}};
Exhibit.Formatter._TextFormatter.prototype.format=function(C,A){var B=document.createElement("span");
B.innerHTML=this.formatText(C);
A(B);
};
Exhibit.Formatter._TextFormatter.prototype.formatText=function(A){if(Exhibit.params.safe){A=Exhibit.Formatter.encodeAngleBrackets(A);
}if(this._maxLength==0||A.length<=this._maxLength){return A;
}else{return A.substr(0,this._maxLength)+Exhibit.Formatter.l10n.textEllipsis;
}};
Exhibit.Formatter._BooleanFormatter=function(A){};
Exhibit.Formatter._BooleanFormatter.prototype.format=function(C,A){var B=document.createElement("span");
B.innerHTML=this.formatText(C);
A(B);
};
Exhibit.Formatter._BooleanFormatter.prototype.formatText=function(A){return(typeof A=="boolean"?A:(typeof A=="string"?(A=="true"):false))?Exhibit.Formatter.l10n.booleanTrue:Exhibit.Formatter.l10n.booleanFalse;
};
Exhibit.Formatter._NumberFormatter=function(A){this._decimalDigits=A.getSetting("format/number/decimal-digits");
if(typeof this._decimalDigits=="number"){this._decimalDigits=Math.max(-1,Math.round(this._decimalDigits));
}else{this._decimalDigits=-1;
}};
Exhibit.Formatter._NumberFormatter.prototype.format=function(B,A){A(document.createTextNode(this.formatText(B)));
};
Exhibit.Formatter._NumberFormatter.prototype.formatText=function(A){if(this._decimalDigits==-1){return A.toString();
}else{return new Number(A).toFixed(this._decimalDigits);
}};
Exhibit.Formatter._ImageFormatter=function(A){this._uiContext=A;
this._maxWidth=A.getSetting("format/image/max-width");
if(typeof this._maxWidth=="number"){this._maxWidth=Math.max(-1,Math.round(this._maxWidth));
}else{this._maxWidth=-1;
}this._maxHeight=A.getSetting("format/image/max-height");
if(typeof this._maxHeight=="number"){this._maxHeight=Math.max(-1,Math.round(this._maxHeight));
}else{this._maxHeight=-1;
}this._tooltip=A.getSetting("format/image/tooltip");
};
Exhibit.Formatter._ImageFormatter.prototype.format=function(C,A){if(Exhibit.params.safe){C=C.trim().startsWith("javascript:")?"":C;
}var B=document.createElement("img");
B.src=C;
if(this._tooltip!=null){if(typeof this._tooltip=="string"){B.title=this._tootlip;
}else{B.title=this._tooltip.evaluateSingleOnItem(this._uiContext.getSetting("itemID"),this._uiContext.getDatabase()).value;
}}A(B);
};
Exhibit.Formatter._ImageFormatter.prototype.formatText=function(A){return A;
};
Exhibit.Formatter._URLFormatter=function(A){this._target=A.getSetting("format/url/target");
this._externalIcon=A.getSetting("format/url/external-icon");
};
Exhibit.Formatter._URLFormatter.prototype.format=function(C,B){var A=document.createElement("a");
A.href=C;
A.innerHTML=C;
if(this._target!=null){A.target=this._target;
}if(this._externalIcon!=null){}B(A);
};
Exhibit.Formatter._URLFormatter.prototype.formatText=function(A){if(Exhibit.params.safe){A=A.trim().startsWith("javascript:")?"":A;
}return A;
};
Exhibit.Formatter._CurrencyFormatter=function(A){this._decimalDigits=A.getSetting("format/currency/decimal-digits");
if(typeof this._decimalDigits=="number"){this._decimalDigits=Math.max(-1,Math.round(this._decimalDigits));
}else{this._decimalDigits=2;
}this._symbol=A.getSetting("format/currency/symbol");
if(this._symbol==null){this._symbol=Exhibit.Formatter.l10n.currencySymbol;
}this._symbolPlacement=A.getSetting("format/currency/symbol-placement");
if(this._symbolPlacement==null){this._symbol=Exhibit.Formatter.l10n.currencySymbolPlacement;
}this._negativeFormat={signed:A.getBooleanSetting("format/currency/negative-format/signed",Exhibit.Formatter.l10n.currencyShowSign),red:A.getBooleanSetting("format/currency/negative-format/red",Exhibit.Formatter.l10n.currencyShowRed),parentheses:A.getBooleanSetting("format/currency/negative-format/parentheses",Exhibit.Formatter.l10n.currencyShowParentheses)};
};
Exhibit.Formatter._CurrencyFormatter.prototype.format=function(C,A){var D=this.formatText(C);
if(C<0&&this._negativeFormat.red){var B=document.createElement("span");
B.innerHTML=D;
B.style.color="red";
A(B);
}else{A(document.createTextNode(D));
}};
Exhibit.Formatter._CurrencyFormatter.prototype.formatText=function(C){var B=C<0;
var D;
if(this._decimalDigits==-1){D=Math.abs(C);
}else{D=new Number(Math.abs(C)).toFixed(this._decimalDigits);
}var A=(B&&this._negativeFormat.signed)?"-":"";
if(B&&this._negativeFormat.parentheses){D="("+D+")";
}switch(this._negativeFormat){case"first":D=this._symbol+A+D;
break;
case"after-sign":D=A+this._symbol+D;
break;
case"last":D=A+D+this._symbol;
break;
}return D;
};
Exhibit.Formatter._ItemFormatter=function(A){this._uiContext=A;
this._title=A.getSetting("format/item/title");
};
Exhibit.Formatter._ItemFormatter.prototype.format=function(E,B){var C=this;
var F=this.formatText(E);
var A=SimileAjax.DOM.createElementFromString('<a href="'+Exhibit.Persistence.getItemLink(E)+"\" class='exhibit-item'>"+F+"</a>");
var D=function(H,G,I){Exhibit.UI.showItemInPopup(E,H,C._uiContext);
};
SimileAjax.WindowManager.registerEvent(A,"click",D,this._uiContext.getSetting("layer"));
B(A);
};
Exhibit.Formatter._ItemFormatter.prototype.formatText=function(B){var A=this._uiContext.getDatabase();
var C=null;
if(this._title==null){C=A.getObject(B,"label");
}else{C=this._title.evaluateSingleOnItem(B,A).value;
}if(C==null){C=B;
}return C;
};
Exhibit.Formatter._DateFormatter=function(C){this._timeZone=C.getSetting("format/date/time-zone");
if(!(typeof this._timeZone=="number")){this._timeZone=-(new Date().getTimezoneOffset())/60;
}this._timeZoneOffset=this._timeZone*3600000;
var E=C.getSetting("format/date/mode");
var I=C.getSetting("format/date/show");
var K=null;
switch(E){case"short":K=I=="date"?Exhibit.Formatter.l10n.dateShortFormat:(I=="time"?Exhibit.Formatter.l10n.timeShortFormat:Exhibit.Formatter.l10n.dateTimeShortFormat);
break;
case"medium":K=I=="date"?Exhibit.Formatter.l10n.dateMediumFormat:(I=="time"?Exhibit.Formatter.l10n.timeMediumFormat:Exhibit.Formatter.l10n.dateTimeMediumFormat);
break;
case"long":K=I=="date"?Exhibit.Formatter.l10n.dateLongFormat:(I=="time"?Exhibit.Formatter.l10n.timeLongFormat:Exhibit.Formatter.l10n.dateTimeLongFormat);
break;
case"full":K=I=="date"?Exhibit.Formatter.l10n.dateFullFormat:(I=="time"?Exhibit.Formatter.l10n.timeFullFormat:Exhibit.Formatter.l10n.dateTimeFullFormat);
break;
default:K=C.getSetting("format/date/template");
}if(typeof K!="string"){K=Exhibit.Formatter.l10n.dateTimeDefaultFormat;
}var D=[];
var G=K.match(/\b\w+\b/g);
var J=0;
for(var A=0;
A<G.length;
A++){var H=G[A];
var F=K.indexOf(H,J);
if(F>J){D.push(K.substring(J,F));
}var B=Exhibit.Formatter._DateFormatter._retrievers[H];
if(typeof B=="function"){D.push(B);
}else{D.push(H);
}J=F+H.length;
}if(J<K.length){D.push(K.substr(J));
}this._segments=D;
};
Exhibit.Formatter._DateFormatter.prototype.format=function(B,A){A(document.createTextNode(this.formatText(B)));
};
Exhibit.Formatter._DateFormatter.prototype.formatText=function(E){var B=(E instanceof Date)?E:SimileAjax.DateTime.parseIso8601DateTime(E);
if(B==null){return E;
}B.setTime(B.getTime()+this._timeZoneOffset);
var F="";
var A=this._segments;
for(var C=0;
C<A.length;
C++){var D=A[C];
if(typeof D=="string"){F+=D;
}else{F+=D(B);
}}return F;
};
Exhibit.Formatter._DateFormatter._pad=function(A){return A<10?("0"+A):A.toString();
};
Exhibit.Formatter._DateFormatter._pad3=function(A){return A<10?("00"+A):(A<100?("0"+A):A.toString());
};
Exhibit.Formatter._DateFormatter._retrievers={"d":function(A){return A.getUTCDate().toString();
},"dd":function(A){return Exhibit.Formatter._DateFormatter._pad(A.getUTCDate());
},"EEE":function(A){return Exhibit.Formatter.l10n.shortDaysOfWeek[A.getUTCDay()];
},"EEEE":function(A){return Exhibit.Formatter.l10n.daysOfWeek[A.getUTCDay()];
},"MM":function(A){return Exhibit.Formatter._DateFormatter._pad(A.getUTCMonth()+1);
},"MMM":function(A){return Exhibit.Formatter.l10n.shortMonths[A.getUTCMonth()];
},"MMMM":function(A){return Exhibit.Formatter.l10n.months[A.getUTCMonth()];
},"yy":function(A){return Exhibit.Formatter._DateFormatter._pad(A.getUTCFullYear()%100);
},"yyyy":function(A){var B=A.getUTCFullYear();
return B>0?B.toString():(1-B);
},"G":function(A){var B=A.getUTCYear();
return B>0?Exhibit.Formatter.l10n.commonEra:Exhibit.Formatter.l10n.beforeCommonEra;
},"HH":function(A){return Exhibit.Formatter._DateFormatter._pad(A.getUTCHours());
},"hh":function(A){var B=A.getUTCHours();
return Exhibit.Formatter._DateFormatter._pad(B==0?12:(B>12?B-12:B));
},"h":function(A){var B=A.getUTCHours();
return(B==0?12:(B>12?B-12:B)).toString();
},"a":function(A){return A.getUTCHours()<12?Exhibit.Formatter.l10n.beforeNoon:Exhibit.Formatter.l10n.afterNoon;
},"A":function(A){return A.getUTCHours()<12?Exhibit.Formatter.l10n.BeforeNoon:Exhibit.Formatter.l10n.AfterNoon;
},"mm":function(A){return Exhibit.Formatter._DateFormatter._pad(A.getUTCMinutes());
},"ss":function(A){return Exhibit.Formatter._DateFormatter._pad(A.getUTCSeconds());
},"S":function(A){return Exhibit.Formatter._DateFormatter._pad3(A.getUTCMilliseconds());
}};
Exhibit.Formatter._constructors={"number":Exhibit.Formatter._NumberFormatter,"date":Exhibit.Formatter._DateFormatter,"text":Exhibit.Formatter._TextFormatter,"boolean":Exhibit.Formatter._BooleanFormatter,"image":Exhibit.Formatter._ImageFormatter,"url":Exhibit.Formatter._URLFormatter,"item":Exhibit.Formatter._ItemFormatter,"currency":Exhibit.Formatter._CurrencyFormatter};


/* lens.js */
Exhibit.LensRegistry=function(A){this._parentRegistry=A;
this._defaultLens=null;
this._typeToLens={};
this._editLensTemplates={};
this._submissionLensTemplates={};
this._lensSelectors=[];
};
Exhibit.LensRegistry.prototype.registerDefaultLens=function(A){this._defaultLens=(typeof A=="string")?A:A.cloneNode(true);
};
Exhibit.LensRegistry.prototype.registerLensForType=function(B,A){if(typeof B=="string"){this._typeToLens[A]=B;
}var C=Exhibit.getRoleAttribute(B);
if(C=="lens"){this._typeToLens[A]=B.cloneNode(true);
}else{if(C=="edit-lens"){this._editLensTemplates[A]=B.cloneNode(true);
}else{if(C=="submission-lens"){this._submissionLensTemplates[A]=B.cloneNode(true);
}else{SimileAjax.Debug.warn("Unknown lens type "+B);
}}}};
Exhibit.LensRegistry.prototype.addLensSelector=function(A){this._lensSelectors.unshift(A);
};
Exhibit.LensRegistry.prototype.getLens=function(B,A){return A.isBeingEdited(B)?this.getEditLens(B,A):this.getNormalLens(B,A);
};
Exhibit.LensRegistry.prototype.getNormalLens=function(F,B){var A=B.getDatabase();
for(var D=0;
D<this._lensSelectors.length;
D++){var C=this._lensSelectors[D](F,A);
if(C!=null){return C;
}}var E=A.getObject(F,"type");
if(E in this._typeToLens){return this._typeToLens[E];
}if(this._defaultLens!=null){return this._defaultLens;
}if(this._parentRegistry){return this._parentRegistry.getLens(F,B);
}return null;
};
Exhibit.LensRegistry.prototype.getEditLens=function(C,A){var B=A.getDatabase().getObject(C,"type");
if(B in this._editLensTemplates){return this._editLensTemplates[B];
}else{return this._parentRegistry&&this._parentRegistry.getEditLens(C,A);
}};
Exhibit.LensRegistry.prototype.createLens=function(E,F,A,D){var B=new Exhibit.Lens();
if(A.getDatabase().isNewItem(E)){SimileAjax.jQuery(F).addClass("newItem");
}D=D||{};
var C=D.lensTemplate||this.getLens(E,A);
if(C==null){B._constructDefaultUI(E,F,A);
}else{if(typeof C=="string"){B._constructFromLensTemplateURL(E,F,A,C,D);
}else{B._constructFromLensTemplateDOM(E,F,A,C,D);
}}return B;
};
Exhibit.LensRegistry.prototype.createEditLens=function(C,D,A,B){B=B||{};
B.lensTemplate=this.getEditLens(C,A);
return this.createLens(C,D,A,B);
};
Exhibit.LensRegistry.prototype.createNormalLens=function(C,D,A,B){B=B||{};
B.lensTemplate=this.getNormalLens(C,A);
return this.createLens(C,D,A,B);
};
Exhibit.Lens=function(){};
Exhibit.Lens._commonProperties=null;
Exhibit.Lens.prototype._constructDefaultUI=function(C,A,I){var N=I.getDatabase();
if(Exhibit.Lens._commonProperties==null){Exhibit.Lens._commonProperties=N.getAllProperties();
}var K=Exhibit.Lens._commonProperties;
var M=N.getObject(C,"label");
M=M!=null?M:C;
if(Exhibit.params.safe){M=Exhibit.Formatter.encodeAngleBrackets(M);
}var O={elmt:A,className:"exhibit-lens",children:[{tag:"div",className:"exhibit-lens-title",title:M,children:[M+" (",{tag:"a",href:Exhibit.Persistence.getItemLink(C),target:"_blank",children:[Exhibit.l10n.itemLinkLabel]},")"]},{tag:"div",className:"exhibit-lens-body",children:[{tag:"table",className:"exhibit-lens-properties",field:"propertiesTable"}]}]};
var H=SimileAjax.DOM.createDOMFromTemplate(O);
A.setAttribute("ex:itemID",C);
var B=Exhibit.ViewPanel.getPropertyValuesPairs(C,K,N);
for(var G=0;
G<B.length;
G++){var F=B[G];
var L=H.propertiesTable.insertRow(G);
L.className="exhibit-lens-property";
var E=L.insertCell(0);
E.className="exhibit-lens-property-name";
E.innerHTML=F.propertyLabel+": ";
var J=L.insertCell(1);
J.className="exhibit-lens-property-values";
if(F.valueType=="item"){for(var D=0;
D<F.values.length;
D++){if(D>0){J.appendChild(document.createTextNode(", "));
}J.appendChild(Exhibit.UI.makeItemSpan(F.values[D],null,I));
}}else{for(var D=0;
D<F.values.length;
D++){if(D>0){J.appendChild(document.createTextNode(", "));
}J.appendChild(Exhibit.UI.makeValueSpan(F.values[D],F.valueType));
}}}};
Exhibit.Lens.prototype._constructDefaultEditingUI=function(B,C,A){};
Exhibit.Lens._compiledTemplates={};
Exhibit.Lens._handlers=["onblur","onfocus","onkeydown","onkeypress","onkeyup","onmousedown","onmouseenter","onmouseleave","onmousemove","onmouseout","onmouseover","onmouseup","onclick","onresize","onscroll"];
Exhibit.Lens.prototype._constructFromLensTemplateURL=function(D,F,B,E){var C={lens:this,itemID:D,div:F,uiContext:B,opts:opts};
var A=Exhibit.Lens._compiledTemplates[E];
if(A==null){Exhibit.Lens._startCompilingTemplate(E,C);
}else{if(!A.compiled){A.jobs.push(C);
}else{C.template=A;
Exhibit.Lens._performConstructFromLensTemplateJob(C);
}}};
Exhibit.Lens.prototype._constructFromLensTemplateDOM=function(F,H,B,D,C){var E={lens:this,itemID:F,div:H,uiContext:B,opts:C};
var G=D.id;
if(G==null||G.length==0){G="exhibitLensTemplate"+Math.floor(Math.random()*10000);
D.id=G;
}var A=Exhibit.Lens._compiledTemplates[G];
if(A==null){A={url:G,template:Exhibit.Lens.compileTemplate(D,false,B),compiled:true,jobs:[]};
Exhibit.Lens._compiledTemplates[G]=A;
}E.template=A;
Exhibit.Lens._performConstructFromLensTemplateJob(E);
};
Exhibit.Lens._startCompilingTemplate=function(E,C){var A={url:E,template:null,compiled:false,jobs:[C]};
Exhibit.Lens._compiledTemplates[E]=A;
var D=function(H,F,G){SimileAjax.Debug.log("Failed to load view template from "+E+"\n"+H);
};
var B=function(G){try{A.template=Exhibit.Lens.compileTemplate(G.responseXML.documentElement,true,C.uiContext);
A.compiled=true;
for(var F=0;
F<A.jobs.length;
F++){try{var I=A.jobs[F];
I.template=A;
Exhibit.Lens._performConstructFromLensTemplateJob(I);
}catch(H){SimileAjax.Debug.exception(H,"Lens: Error constructing lens template in job queue");
}}A.jobs=null;
}catch(H){SimileAjax.Debug.exception(H,"Lens: Error compiling lens template and processing template job queue");
}};
SimileAjax.XmlHttp.get(E,D,B);
return A;
};
Exhibit.Lens.compileTemplate=function(B,C,A){return Exhibit.Lens._processTemplateNode(B,C,A);
};
Exhibit.Lens._processTemplateNode=function(B,C,A){if(B.nodeType==1){return Exhibit.Lens._processTemplateElement(B,C,A);
}else{return B.nodeValue;
}};
Exhibit.Lens._processTemplateElement=function(F,N,I){var D={tag:F.tagName.toLowerCase(),uiContext:I,control:null,condition:null,content:null,contentAttributes:null,subcontentAttributes:null,attributes:[],styles:[],handlers:[],children:null};
var H={parseChildTextNodes:true};
var J=F.attributes;
for(var K=0;
K<J.length;
K++){var E=J[K];
var B=E.nodeName;
var M=E.nodeValue;
Exhibit.Lens._processTemplateAttribute(I,D,H,B,M);
}if(!N&&SimileAjax.Platform.browser.isIE){var G=Exhibit.Lens._handlers;
for(var L=0;
L<G.length;
L++){var O=G[L];
var C=F[O];
if(C!=null){D.handlers.push({name:O,code:C});
}}}var A=F.firstChild;
if(A!=null){D.children=[];
while(A!=null){if((H.parseChildTextNodes&&A.nodeType==3)||A.nodeType==1){D.children.push(Exhibit.Lens._processTemplateNode(A,N,D.uiContext));
}A=A.nextSibling;
}}return D;
};
Exhibit.Lens._processTemplateAttribute=function(B,D,E,C,G){if(G==null||typeof G!="string"||G.length==0||C=="contentEditable"){return ;
}if(C=="ex:onshow"){D.attributes.push({name:C,value:G});
}else{if(C.length>3&&C.substr(0,3)=="ex:"){C=C.substr(3);
if(C=="formats"){D.uiContext=Exhibit.UIContext._createWithParent(B);
Exhibit.FormatParser.parseSeveral(D.uiContext,G,0,{});
}else{if(C=="control"){D.control=G;
}else{if(C=="content"){D.content=Exhibit.ExpressionParser.parse(G);
}else{if(C=="edit"){D.edit=G;
}else{if(C=="options"){D.options=G;
}else{if(C=="editvalues"){D.editValues=G;
}else{if(C=="tag"){D.tag=G;
}else{if(C=="if-exists"){D.condition={test:"if-exists",expression:Exhibit.ExpressionParser.parse(G)};
}else{if(C=="if"){D.condition={test:"if",expression:Exhibit.ExpressionParser.parse(G)};
E.parseChildTextNodes=false;
}else{if(C=="select"){D.condition={test:"select",expression:Exhibit.ExpressionParser.parse(G)};
}else{if(C=="case"){D.condition={test:"case",value:G};
E.parseChildTextNodes=false;
}else{var F=false;
var A=C.indexOf("-style-content");
if(A>0){F=true;
}else{A=C.indexOf("-content");
}if(A>0){if(D.contentAttributes==null){D.contentAttributes=[];
}D.contentAttributes.push({name:C.substr(0,A),expression:Exhibit.ExpressionParser.parse(G),isStyle:F});
}else{A=C.indexOf("-style-subcontent");
if(A>0){F=true;
}else{A=C.indexOf("-subcontent");
}if(A>0){if(D.subcontentAttributes==null){D.subcontentAttributes=[];
}D.subcontentAttributes.push({name:C.substr(0,A),fragments:Exhibit.Lens._parseSubcontentAttribute(G),isStyle:F});
}}}}}}}}}}}}}}else{if(C=="style"){Exhibit.Lens._processStyle(D,G);
}else{if(C!="id"){if(C=="class"){if(SimileAjax.Platform.browser.isIE){C="className";
}}else{if(C=="cellspacing"){C="cellSpacing";
}else{if(C=="cellpadding"){C="cellPadding";
}else{if(C=="bgcolor"){C="bgColor";
}}}}D.attributes.push({name:C,value:G});
}}}}};
Exhibit.Lens._processStyle=function(A,I){var G=I.split(";");
for(var H=0;
H<G.length;
H++){var C=G[H].split(":");
if(C.length>1){var B=C[0].trim();
var F=C[1].trim();
if(B=="float"){B=SimileAjax.Platform.browser.isIE?"styleFloat":"cssFloat";
}else{if(B=="-moz-opacity"){B="MozOpacity";
}else{if(B.indexOf("-")>0){var D=B.split("-");
B=D[0];
for(var E=1;
E<D.length;
E++){B+=D[E].substr(0,1).toUpperCase()+D[E].substr(1);
}}}}A.styles.push({name:B,value:F});
}}};
Exhibit.Lens._parseSubcontentAttribute=function(C){var A=[];
var D=0;
var B;
while(D<C.length&&(B=C.indexOf("{{",D))>=0){var E=C.indexOf("}}",B);
if(E<0){break;
}A.push(C.substring(D,B));
A.push(Exhibit.ExpressionParser.parse(C.substring(B+2,E)));
D=E+2;
}if(D<C.length){A.push(C.substr(D));
}return A;
};
Exhibit.Lens.constructFromLensTemplate=function(D,B,E,A,C){return Exhibit.Lens._performConstructFromLensTemplateJob({itemID:D,template:{template:B},div:E,uiContext:A,opts:C});
};
Exhibit.Lens._performConstructFromLensTemplateJob=function(D){Exhibit.Lens._constructFromLensTemplateNode({"value":D.itemID},{"value":"item"},D.template.template,D.div,D.opts);
var C=D.div.tagName.toLowerCase()=="table"?D.div.rows[D.div.rows.length-1]:D.div.lastChild;
var B=C.tagName.toLowerCase();
switch(B){case"span":C.style.display="inline";
break;
case"tr":C.style.display="table-row";
break;
case"td":C.style.display="table-cell";
break;
default:C.style.display="block";
}C.setAttribute("ex:itemID",D.itemID);
if(!Exhibit.params.safe){var A=Exhibit.getAttribute(C,"onshow");
if(A!=null&&A.length>0){try{(new Function(A)).call(C);
}catch(E){SimileAjax.Debug.log(E);
}}}return C;
};
Exhibit.Lens._constructFromLensTemplateNode=function(J,M,f,D,P){if(typeof f=="string"){D.appendChild(document.createTextNode(f));
return ;
}var K=f.uiContext;
var Q=K.getDatabase();
var H=f.children;
function R(){if(H!=null){for(var a=0;
a<H.length;
a++){Exhibit.Lens._constructFromLensTemplateNode(J,M,H[a],L,P);
}}}if(f.condition!=null){if(f.condition.test=="if-exists"){if(!f.condition.expression.testExists(J,M,"value",Q)){return ;
}}else{if(f.condition.test=="if"){if(f.condition.expression.evaluate(J,M,"value",Q).values.contains(true)){if(H!=null&&H.length>0){Exhibit.Lens._constructFromLensTemplateNode(J,M,H[0],D,P);
}}else{if(H!=null&&H.length>1){Exhibit.Lens._constructFromLensTemplateNode(J,M,H[1],D,P);
}}return ;
}else{if(f.condition.test=="select"){var C=f.condition.expression.evaluate(J,M,"value",Q).values;
if(H!=null){var F=null;
for(var Z=0;
Z<H.length;
Z++){var N=H[Z];
if(N.condition!=null&&N.condition.test=="case"){if(C.contains(N.condition.value)){Exhibit.Lens._constructFromLensTemplateNode(J,M,N,D,P);
return ;
}}else{if(typeof N!="string"){F=N;
}}}}if(F!=null){Exhibit.Lens._constructFromLensTemplateNode(J,M,F,D,P);
}return ;
}}}}var L=Exhibit.Lens._constructElmtWithAttributes(f,D,Q);
if(f.contentAttributes!=null){var b=f.contentAttributes;
for(var X=0;
X<b.length;
X++){var O=b[X];
var C=[];
O.expression.evaluate(J,M,"value",Q).values.visit(function(a){C.push(a);
});
var V=C.join(";");
if(O.isStyle){L.style[O.name]=V;
}else{if("class"==O.name){L.className=V;
}else{if(Exhibit.Lens._attributeValueIsSafe(O.name,V)){L.setAttribute(O.name,V);
}}}}}if(f.subcontentAttributes!=null){var G=f.subcontentAttributes;
for(var X=0;
X<G.length;
X++){var O=G[X];
var g=O.fragments;
var U="";
for(var S=0;
S<g.length;
S++){var A=g[S];
if(typeof A=="string"){U+=A;
}else{U+=A.evaluateSingle(J,M,"value",Q).value;
}}if(O.isStyle){L.style[O.name]=U;
}else{if("class"==O.name){L.className=U;
}else{if(Exhibit.Lens._attributeValueIsSafe(O.name,U)){L.setAttribute(O.name,U);
}}}}}if(!Exhibit.params.safe){var T=f.handlers;
for(var Y=0;
Y<T.length;
Y++){var B=T[Y];
L[B.name]=B.code;
}}var E=J["value"];
if(f.control!=null){switch(f.control){case"item-link":var d=document.createElement("a");
d.innerHTML=Exhibit.l10n.itemLinkLabel;
d.href=Exhibit.Persistence.getItemLink(E);
d.target="_blank";
L.appendChild(d);
break;
case"remove-item":if(!P.disableEditWidgets&&Q.isNewItem(E)){if(f.tag=="a"){L.href="javascript:";
}SimileAjax.jQuery(L).click(function(){Q.removeItem(E);
});
R();
}else{D.removeChild(L);
}break;
case"start-editing":if(f.tag=="a"){L.href="javascript:";
}if(P.disableEditWidgets){D.removeChild(L);
}else{if(P.inPopup){SimileAjax.jQuery(L).click(function(){Exhibit.UI.showItemInPopup(E,null,K,{lensType:"edit",coords:P.coords});
});
R();
}else{SimileAjax.jQuery(L).click(function(){K.setEditMode(E,true);
K.getCollection()._listeners.fire("onItemsChanged",[]);
});
R();
}}break;
case"stop-editing":if(f.tag=="a"){L.href="javascript:";
}if(P.disableEditWidgets){D.removeChild(L);
}else{if(P.inPopup){SimileAjax.jQuery(L).click(function(){Exhibit.UI.showItemInPopup(E,null,K,{lensType:"normal",coords:P.coords});
});
R();
}else{SimileAjax.jQuery(L).click(function(){K.setEditMode(E,false);
K.getCollection()._listeners.fire("onItemsChanged",[]);
});
R();
}}break;
case"accept-changes":if(Q.isSubmission(E)){if(f.tag=="a"){L.href="javascript:";
}SimileAjax.jQuery(L).click(function(){Q.mergeSubmissionIntoItem(E);
});
R();
}else{SimileAjax.Debug.warn("accept-changes element in non-submission item");
D.removeChild(L);
}break;
}}else{if(f.content!=null){var U=f.content.evaluate(J,M,"value",Q);
if(H!=null){var W={"value":U.valueType,"index":"number"};
var I=1;
var e=function(c){var a={"value":c,"index":I++};
for(var h=0;
h<H.length;
h++){Exhibit.Lens._constructFromLensTemplateNode(a,W,H[h],L,P);
}};
if(U.values instanceof Array){for(var X=0;
X<U.values.length;
X++){e(U.values[X]);
}}else{U.values.visit(e);
}}else{Exhibit.Lens._constructDefaultValueList(U.values,U.valueType,L,f.uiContext);
}}else{if(f.edit!=null){R();
Exhibit.Lens._constructEditableContent(f,L,E,K);
}else{if(H!=null){for(var X=0;
X<H.length;
X++){Exhibit.Lens._constructFromLensTemplateNode(J,M,H[X],L,P);
}}}}}};
Exhibit.Lens._constructElmtWithAttributes=function(B,E,J){var D;
if(B.tag=="input"&&SimileAjax.Platform.browser.isIE){var I=["<input"];
var F=B.attributes;
for(var G=0;
G<F.length;
G++){var C=F[G];
if(Exhibit.Lens._attributeValueIsSafe(C.name,C.value)){I.push(C.name+'="'+C.value+'"');
}}I.push("></input>");
D=SimileAjax.DOM.createElementFromString(I.join(" "));
E.appendChild(D);
}else{switch(B.tag){case"tr":D=E.insertRow(E.rows.length);
break;
case"td":D=E.insertCell(E.cells.length);
break;
default:D=document.createElement(B.tag);
E.appendChild(D);
}var F=B.attributes;
for(var G=0;
G<F.length;
G++){var C=F[G];
if(Exhibit.Lens._attributeValueIsSafe(C.name,C.value)){try{D.setAttribute(C.name,C.value);
}catch(H){}}}}var K=B.styles;
for(var G=0;
G<K.length;
G++){var A=K[G];
D.style[A.name]=A.value;
}return D;
};
Exhibit.Lens._constructEditableContent=function(F,E,G,C){var B=C.getDatabase();
var A=F.edit.replace(".","");
var H=B.getObject(G,A);
var D=function(){if(this.value&&this.value!=H){B.editItem(G,A,this.value);
}};
if(F.tag=="select"){Exhibit.Lens._constructEditableSelect(F,E,G,C,H);
SimileAjax.jQuery(E).blur(D);
}else{E.value=H;
SimileAjax.jQuery(E).change(D);
}};
Exhibit.Lens.doesSelectContain=function(A,D){for(var C in A.options){var B=A.options[C];
if(B.text==D||B.value==D){return true;
}}return false;
};
Exhibit.Lens._constructEditableSelect=function(B,C,A,E,D){if(B.options){var L=Exhibit.ExpressionParser.parse(B.options);
var I=E.getDatabase().getAllItems();
var G=L.evaluate({"value":I},{value:"item"},"value",E.getDatabase());
var K=G.values.toArray().sort();
for(var F in K){var J=K[F];
if(!Exhibit.Lens.doesSelectContain(C,J)){var H=new Option(K[F],K[F]);
C.add(H,null);
}}}if(!D){if(!Exhibit.Lens.doesSelectContain(C,"")){var H=new Option("","",true);
C.add(H,C.options[0]);
}}else{for(var F in C.options){if(C.options.hasOwnProperty(F)&&C.options[F].value==D){C.selectedIndex=F;
}}}};
Exhibit.Lens._constructDefaultValueList=function(B,D,C,A){A.formatList(B,B.size(),D,function(E){C.appendChild(E);
});
};
Exhibit.Lens._attributeValueIsSafe=function(A,B){if(Exhibit.params.safe){if((A=="href"&&B.startsWith("javascript:"))||(A.startsWith("on"))){return false;
}}return true;
};


/* ui-context.js */
Exhibit.UIContext=function(){this._parent=null;
this._exhibit=null;
this._collection=null;
this._lensRegistry=new Exhibit.LensRegistry();
this._settings={};
this._formatters={};
this._listFormatter=null;
this._editModeRegistry={};
this._popupFunc=null;
};
Exhibit.UIContext.createRootContext=function(F,B){var C=new Exhibit.UIContext();
C._exhibit=B;
var D=Exhibit.UIContext.l10n.initialSettings;
for(var E in D){C._settings[E]=D[E];
}var A=Exhibit.getAttribute(document.body,"formats");
if(A!=null&&A.length>0){Exhibit.FormatParser.parseSeveral(C,A,0,{});
}Exhibit.SettingsUtilities.collectSettingsFromDOM(document.body,Exhibit.UIContext._settingSpecs,C._settings);
Exhibit.UIContext._configure(C,F);
return C;
};
Exhibit.UIContext.create=function(D,B,A){var C=Exhibit.UIContext._createWithParent(B);
Exhibit.UIContext._configure(C,D,A);
return C;
};
Exhibit.UIContext.createFromDOM=function(E,C,B){var D=Exhibit.UIContext._createWithParent(C);
if(!(B)){Exhibit.UIContext.registerLensesFromDOM(E,D.getLensRegistry());
}var F=Exhibit.getAttribute(E,"collectionID");
if(F!=null&&F.length>0){D._collection=D._exhibit.getCollection(F);
}var A=Exhibit.getAttribute(E,"formats");
if(A!=null&&A.length>0){Exhibit.FormatParser.parseSeveral(D,A,0,{});
}Exhibit.SettingsUtilities.collectSettingsFromDOM(E,Exhibit.UIContext._settingSpecs,D._settings);
Exhibit.UIContext._configure(D,Exhibit.getConfigurationFromDOM(E),B);
return D;
};
Exhibit.UIContext.prototype.dispose=function(){};
Exhibit.UIContext.prototype.getParentUIContext=function(){return this._parent;
};
Exhibit.UIContext.prototype.getExhibit=function(){return this._exhibit;
};
Exhibit.UIContext.prototype.getDatabase=function(){return this.getExhibit().getDatabase();
};
Exhibit.UIContext.prototype.getCollection=function(){if(this._collection==null){if(this._parent!=null){this._collection=this._parent.getCollection();
}else{this._collection=this._exhibit.getDefaultCollection();
}}return this._collection;
};
Exhibit.UIContext.prototype.getLensRegistry=function(){return this._lensRegistry;
};
Exhibit.UIContext.prototype.getSetting=function(A){return A in this._settings?this._settings[A]:(this._parent!=null?this._parent.getSetting(A):undefined);
};
Exhibit.UIContext.prototype.getBooleanSetting=function(C,A){var B=this.getSetting(C);
return B==undefined||B==null?A:B;
};
Exhibit.UIContext.prototype.putSetting=function(A,B){this._settings[A]=B;
};
Exhibit.UIContext.prototype.format=function(C,D,A){var B;
if(D in this._formatters){B=this._formatters[D];
}else{B=this._formatters[D]=new Exhibit.Formatter._constructors[D](this);
}B.format(C,A);
};
Exhibit.UIContext.prototype.formatList=function(B,C,D,A){if(this._listFormatter==null){this._listFormatter=new Exhibit.Formatter._ListFormatter(this);
}this._listFormatter.formatList(B,C,D,A);
};
Exhibit.UIContext.prototype.setEditMode=function(A,B){if(B){this._editModeRegistry[A]=true;
}else{this._editModeRegistry[A]=false;
}};
Exhibit.UIContext.prototype.isBeingEdited=function(A){return !!this._editModeRegistry[A];
};
Exhibit.UIContext._createWithParent=function(B){var A=new Exhibit.UIContext();
A._parent=B;
A._exhibit=B._exhibit;
A._lensRegistry=new Exhibit.LensRegistry(B.getLensRegistry());
A._editModeRegistry=B._editModeRegistry;
return A;
};
Exhibit.UIContext._settingSpecs={"bubbleWidth":{type:"int"},"bubbleHeight":{type:"int"}};
Exhibit.UIContext._configure=function(B,C,A){Exhibit.UIContext.registerLenses(C,B.getLensRegistry());
if("collectionID" in C){B._collection=B._exhibit.getCollection(C["collectionID"]);
}if("formats" in C){Exhibit.FormatParser.parseSeveral(B,C.formats,0,{});
}if(!(A)){Exhibit.SettingsUtilities.collectSettings(C,Exhibit.UIContext._settingSpecs,B._settings);
}};
Exhibit.UIContext.registerLens=function(D,A){var C=D.templateFile;
if(C!=null){if("itemTypes" in D){for(var B=0;
B<D.itemTypes.length;
B++){A.registerLensForType(C,D.itemTypes[B]);
}}else{A.registerDefaultLens(C);
}}};
Exhibit.UIContext.registerLensFromDOM=function(D,B){D.style.display="none";
var G=Exhibit.getAttribute(D,"itemTypes",",");
var F=null;
var A=Exhibit.getAttribute(D,"templateFile");
if(A!=null&&A.length>0){F=A;
}else{var H=Exhibit.getAttribute(D,"template");
var E=H&&document.getElementById(H);
if(E!=null){F=E;
}else{F=D;
}}if(F!=null){if(G==null||G.length==0||(G.length==1&&G[0]=="")){B.registerDefaultLens(F);
}else{for(var C=0;
C<G.length;
C++){B.registerLensForType(F,G[C]);
}}}};
Exhibit.UIContext.registerLenses=function(D,B){if("lenses" in D){for(var C=0;
C<D.lenses.length;
C++){Exhibit.UIContext.registerLens(D.lenses[C],B);
}}if("lensSelector" in D){var A=D.lensSelector;
if(typeof A=="function"){B.addLensSelector(A);
}else{SimileAjax.Debug.log("lensSelector is not a function");
}}};
Exhibit.UIContext.registerLensesFromDOM=function(parentNode,lensRegistry){var node=parentNode.firstChild;
while(node!=null){if(node.nodeType==1){var role=Exhibit.getRoleAttribute(node);
if(role=="lens"||role=="edit-lens"){Exhibit.UIContext.registerLensFromDOM(node,lensRegistry);
}}node=node.nextSibling;
}var lensSelectorString=Exhibit.getAttribute(parentNode,"lensSelector");
if(lensSelectorString!=null&&lensSelectorString.length>0){try{var lensSelector=eval(lensSelectorString);
if(typeof lensSelector=="function"){lensRegistry.addLensSelector(lensSelector);
}else{SimileAjax.Debug.log("lensSelector expression "+lensSelectorString+" is not a function");
}}catch(e){SimileAjax.Debug.exception(e,"Bad lensSelector expression: "+lensSelectorString);
}}};
Exhibit.UIContext.createLensRegistry=function(C,B){var A=new Exhibit.LensRegistry(B);
Exhibit.UIContext.registerLenses(C,A);
return A;
};
Exhibit.UIContext.createLensRegistryFromDOM=function(A,D,C){var B=new Exhibit.LensRegistry(C);
Exhibit.UIContext.registerLensesFromDOM(A,B);
Exhibit.UIContext.registerLenses(D,B);
return B;
};


/* ui.js */
Exhibit.UI=new Object();
Exhibit.UI.componentMap={};
Exhibit.UI.registerComponent=function(B,A){var C="Cannot register component "+B+" -- ";
if(B in Exhibit.UI.componentMap){SimileAjax.Debug.warn(C+"another component has taken that name");
}else{if(!A){SimileAjax.Debug.warn(C+"no component object provided");
}else{if(!A.create){SimileAjax.Debug.warn(C+"component has no create function");
}else{if(!A.createFromDOM){SimileAjax.Debug.warn(C+"component has no createFromDOM function");
}else{Exhibit.UI.componentMap[B]=A;
}}}}};
Exhibit.UI.create=function(E,B,A){if("role" in E){var D=E.role;
if(D!=null&&D.startsWith("exhibit-")){D=D.substr("exhibit-".length);
}if(D in Exhibit.UI.componentMap){var C=Exhibit.UI.componentMap[D].create;
return C(E,B,A);
}switch(D){case"lens":case"edit-lens":Exhibit.UIContext.registerLens(E,A.getLensRegistry());
return null;
case"view":return Exhibit.UI.createView(E,B,A);
case"facet":return Exhibit.UI.createFacet(E,B,A);
case"coordinator":return Exhibit.UI.createCoordinator(E,A);
case"coder":return Exhibit.UI.createCoder(E,A);
case"viewPanel":return Exhibit.ViewPanel.create(E,B,A);
case"logo":return Exhibit.Logo.create(E,B,A);
case"hiddenContent":B.style.display="none";
return null;
}}return null;
};
Exhibit.UI.createFromDOM=function(C,A){var D=Exhibit.getRoleAttribute(C);
if(D in Exhibit.UI.componentMap){var B=Exhibit.UI.componentMap[D].createFromDOM;
return B(C,A);
}switch(D){case"lens":case"edit-lens":Exhibit.UIContext.registerLensFromDOM(C,A.getLensRegistry());
return null;
case"view":return Exhibit.UI.createViewFromDOM(C,null,A);
case"facet":return Exhibit.UI.createFacetFromDOM(C,null,A);
case"coordinator":return Exhibit.UI.createCoordinatorFromDOM(C,A);
case"coder":return Exhibit.UI.createCoderFromDOM(C,A);
case"viewPanel":return Exhibit.ViewPanel.createFromDOM(C,A);
case"logo":return Exhibit.Logo.createFromDOM(C,A);
case"hiddenContent":C.style.display="none";
return null;
}return null;
};
Exhibit.UI.generateCreationMethods=function(A){A.create=function(F,C,B){var E=Exhibit.UIContext.create(F,B);
var D={};
Exhibit.SettingsUtilities.collectSettings(F,A._settingSpecs||{},D);
return new A(C,E,D);
};
A.createFromDOM=function(C,B){var E=Exhibit.UIContext.createFromDOM(C,B);
var D={};
Exhibit.SettingsUtilities.collectSettingsFromDOM(C,A._settingSpecs||{},D);
return new A(C,E,D);
};
};
Exhibit.UI.createView=function(D,B,A){var C="viewClass" in D?D.viewClass:Exhibit.TileView;
if(typeof C=="string"){C=Exhibit.UI.viewClassNameToViewClass(C);
}return C.create(D,B,A);
};
Exhibit.UI.createViewFromDOM=function(C,A,B){var D=Exhibit.UI.viewClassNameToViewClass(Exhibit.getAttribute(C,"viewClass"));
return D.createFromDOM(C,A,B);
};
Exhibit.UI.viewClassNameToViewClass=function(A){if(A!=null&&A.length>0){try{return Exhibit.UI._stringToObject(A,"View");
}catch(B){SimileAjax.Debug.warn("Unknown viewClass "+A);
}}return Exhibit.TileView;
};
Exhibit.UI.createFacet=function(D,B,A){var C="facetClass" in D?D.facetClass:Exhibit.ListFacet;
if(typeof C=="string"){C=Exhibit.UI.facetClassNameToFacetClass(C);
}return C.create(D,B,A);
};
Exhibit.UI.createFacetFromDOM=function(C,A,B){var D=Exhibit.UI.facetClassNameToFacetClass(Exhibit.getAttribute(C,"facetClass"));
return D.createFromDOM(C,A,B);
};
Exhibit.UI.facetClassNameToFacetClass=function(A){if(A!=null&&A.length>0){try{return Exhibit.UI._stringToObject(A,"Facet");
}catch(B){SimileAjax.Debug.warn("Unknown facetClass "+A);
}}return Exhibit.ListFacet;
};
Exhibit.UI.createCoder=function(C,A){var B="coderClass" in C?C.coderClass:Exhibit.ColorCoder;
if(typeof B=="string"){B=Exhibit.UI.coderClassNameToCoderClass(B);
}return B.create(C,A);
};
Exhibit.UI.createCoderFromDOM=function(B,A){var C=Exhibit.UI.coderClassNameToCoderClass(Exhibit.getAttribute(B,"coderClass"));
return C.createFromDOM(B,A);
};
Exhibit.UI.coderClassNameToCoderClass=function(A){if(A!=null&&A.length>0){try{return Exhibit.UI._stringToObject(A,"Coder");
}catch(B){SimileAjax.Debug.warn("Unknown coderClass "+A);
}}return Exhibit.ColorCoder;
};
Exhibit.UI.createCoordinator=function(B,A){return Exhibit.Coordinator.create(B,A);
};
Exhibit.UI.createCoordinatorFromDOM=function(B,A){return Exhibit.Coordinator.createFromDOM(B,A);
};
Exhibit.UI._stringToObject=function(name,suffix){if(!name.startsWith("Exhibit.")){if(!name.endsWith(suffix)){try{return eval("Exhibit."+name+suffix);
}catch(e){}}try{return eval("Exhibit."+name);
}catch(e){}}if(!name.endsWith(suffix)){try{return eval(name+suffix);
}catch(e){}}try{return eval(name);
}catch(e){}throw new Error("Unknown class "+name);
};
Exhibit.UI.docRoot="http://simile.mit.edu/wiki/";
Exhibit.UI.validator="http://simile.mit.edu/babel/validator";
Exhibit.UI.showHelp=function(B,A,C){C=(C)?C:"_blank";
if(A!=null){if(window.confirm(B+"\n\n"+Exhibit.l10n.showDocumentationMessage)){window.open(A,C);
}}else{window.alert(B);
}};
Exhibit.UI.showJavascriptExpressionValidation=function(A,C){var B="_blank";
if(window.confirm(A+"\n\n"+Exhibit.l10n.showJavascriptValidationMessage)){window.open(Exhibit.UI.validator+"?expresson="+encodeURIComponent(C),B);
}};
Exhibit.UI.showJsonFileValidation=function(B,A){var C="_blank";
if(A.indexOf("file:")==0){if(window.confirm(B+"\n\n"+Exhibit.l10n.showJsonValidationFormMessage)){window.open(Exhibit.UI.validator,C);
}}else{if(window.confirm(B+"\n\n"+Exhibit.l10n.showJsonValidationMessage)){window.open(Exhibit.UI.validator+"?url="+A,C);
}}};
Exhibit.UI._busyIndicator=null;
Exhibit.UI._busyIndicatorCount=0;
Exhibit.UI.showBusyIndicator=function(){Exhibit.UI._busyIndicatorCount++;
if(Exhibit.UI._busyIndicatorCount>1){return ;
}if(Exhibit.UI._busyIndicator==null){Exhibit.UI._busyIndicator=Exhibit.UI.createBusyIndicator();
}var C=("scrollTop" in document.body)?document.body.scrollTop:document.body.parentNode.scrollTop;
var A=("innerHeight" in window)?window.innerHeight:("clientHeight" in document.body?document.body.clientHeight:document.body.parentNode.clientHeight);
var B=Math.floor(C+A/3);
Exhibit.UI._busyIndicator.style.top=B+"px";
document.body.appendChild(Exhibit.UI._busyIndicator);
};
Exhibit.UI.hideBusyIndicator=function(){Exhibit.UI._busyIndicatorCount--;
if(Exhibit.UI._busyIndicatorCount>0){return ;
}try{document.body.removeChild(Exhibit.UI._busyIndicator);
}catch(A){}};
Exhibit.UI.protectUI=function(A){SimileAjax.DOM.appendClassName(A,"exhibit-ui-protection");
};
Exhibit.UI.makeActionLink=function(E,D,C){var B=document.createElement("a");
B.href="javascript:";
B.className="exhibit-action";
B.innerHTML=E;
var A=function(G,F,H){if("true"!=G.getAttribute("disabled")){D(G,F,H);
}};
SimileAjax.WindowManager.registerEvent(B,"click",A,C);
return B;
};
Exhibit.UI.enableActionLink=function(A,B){A.setAttribute("disabled",B?"false":"true");
A.className=B?"exhibit-action":"exhibit-action-disabled";
};
Exhibit.UI.makeItemSpan=function(F,C,B,D){if(C==null){C=database.getObject(F,"label");
if(C==null){C=F;
}}var A=SimileAjax.DOM.createElementFromString('<a href="'+Exhibit.Persistence.getItemLink(F)+"\" class='exhibit-item'>"+C+"</a>");
var E=function(H,G,I){Exhibit.UI.showItemInPopup(F,H,B);
};
SimileAjax.WindowManager.registerEvent(A,"click",E,D);
return A;
};
Exhibit.UI.makeValueSpan=function(B,E,C){var D=document.createElement("span");
D.className="exhibit-value";
if(E=="url"){var A=B;
if(Exhibit.params.safe&&A.trim().startsWith("javascript:")){D.appendChild(document.createTextNode(A));
}else{D.innerHTML='<a href="'+A+"\" target='_blank'>"+(B.length>50?B.substr(0,20)+" ... "+B.substr(B.length-20):B)+"</a>";
}}else{if(Exhibit.params.safe){B=Exhibit.Formatter.encodeAngleBrackets(B);
}D.innerHTML=B;
}return D;
};
Exhibit.UI.calculatePopupPosition=function(A){var B=SimileAjax.DOM.getPageCoordinates(A);
return{x:B.left+Math.round(A.offsetWidth/2),y:B.top+Math.round(A.offsetHeight/2)};
};
Exhibit.UI.showItemInPopup=function(F,D,B,E){SimileAjax.WindowManager.popAllLayers();
E=E||{};
E.coords=E.coords||Exhibit.UI.calculatePopupPosition(D);
var A=document.createElement("div");
var C={inPopup:true,coords:E.coords};
if(E.lensType=="normal"){C.lensTemplate=B.getLensRegistry().getNormalLens(F,B);
}else{if(E.lensType=="edit"){C.lensTemplate=B.getLensRegistry().getEditLens(F,B);
}else{if(E.lensType){SimileAjax.Debug.warn("Unknown Exhibit.UI.showItemInPopup opts.lensType: "+E.lensType);
}}}B.getLensRegistry().createLens(F,A,B,C);
SimileAjax.Graphics.createBubbleForContentAndPoint(A,E.coords.x,E.coords.y,B.getSetting("bubbleWidth"));
};
Exhibit.UI.createButton=function(A,D,C){var B=document.createElement("button");
B.className=(C||"exhibit-button")+" screen";
B.innerHTML=A;
if(D){SimileAjax.WindowManager.registerEvent(B,"click",D);
}return B;
};
Exhibit.UI.createPopupMenuDom=function(A){var C=document.createElement("div");
C.className="exhibit-menu-popup exhibit-ui-protection";
var B={elmt:C,close:function(){document.body.removeChild(this.elmt);
},open:function(){var E=this;
this.layer=SimileAjax.WindowManager.pushLayer(function(){E.close();
},true,C);
var F=document.body.offsetWidth;
var D=document.body.offsetHeight;
var G=SimileAjax.DOM.getPageCoordinates(A);
C.style.top=(G.top+A.scrollHeight)+"px";
C.style.right=(F-(G.left+A.scrollWidth))+"px";
document.body.appendChild(this.elmt);
},appendMenuItem:function(F,G,H){var E=this;
var D=document.createElement("a");
D.className="exhibit-menu-item";
D.href="javascript:";
SimileAjax.WindowManager.registerEvent(D,"click",function(K,J,L){H(K,J,L);
SimileAjax.WindowManager.popLayer(E.layer);
SimileAjax.DOM.cancelEvent(J);
return false;
});
var I=document.createElement("div");
D.appendChild(I);
I.appendChild(SimileAjax.Graphics.createTranslucentImage(G!=null?G:(Exhibit.urlPrefix+"images/blank-16x16.png")));
I.appendChild(document.createTextNode(F));
this.elmt.appendChild(D);
},appendSeparator:function(){var D=document.createElement("hr");
this.elmt.appendChild(D);
}};
return B;
};
Exhibit.UI.createBusyIndicator=function(){var E=Exhibit.urlPrefix+"images/";
var I=document.createElement("div");
if(SimileAjax.Graphics.pngIsTranslucent){var J=document.createElement("div");
J.style.height="33px";
J.style.background="url("+E+"message-bubble/message-top-left.png) top left no-repeat";
J.style.paddingLeft="44px";
I.appendChild(J);
var C=document.createElement("div");
C.style.height="33px";
C.style.background="url("+E+"message-bubble/message-top-right.png) top right no-repeat";
J.appendChild(C);
var H=document.createElement("div");
H.style.background="url("+E+"message-bubble/message-left.png) top left repeat-y";
H.style.paddingLeft="44px";
I.appendChild(H);
var A=document.createElement("div");
A.style.background="url("+E+"message-bubble/message-right.png) top right repeat-y";
A.style.paddingRight="44px";
H.appendChild(A);
var D=document.createElement("div");
A.appendChild(D);
var B=document.createElement("div");
B.style.height="55px";
B.style.background="url("+E+"message-bubble/message-bottom-left.png) bottom left no-repeat";
B.style.paddingLeft="44px";
I.appendChild(B);
var G=document.createElement("div");
G.style.height="55px";
G.style.background="url("+E+"message-bubble/message-bottom-right.png) bottom right no-repeat";
B.appendChild(G);
}else{I.style.border="2px solid #7777AA";
I.style.padding="20px";
I.style.background="white";
SimileAjax.Graphics.setOpacity(I,90);
var D=document.createElement("div");
I.appendChild(D);
}I.className="exhibit-busyIndicator";
D.className="exhibit-busyIndicator-content";
var F=document.createElement("img");
F.src=E+"progress-running.gif";
D.appendChild(F);
D.appendChild(document.createTextNode(" "+Exhibit.l10n.busyIndicatorMessage));
return I;
};
Exhibit.UI.createFocusDialogBox=function(C,A,E){var B={tag:"div",className:"exhibit-focusDialog exhibit-ui-protection",children:[{tag:"div",className:"exhibit-focusDialog-viewContainer",field:"viewContainer"},{tag:"div",className:"exhibit-focusDialog-controls",children:[{tag:"button",field:"closeButton",children:[Exhibit.l10n.focusDialogBoxCloseButtonLabel]}]}]};
var D=SimileAjax.DOM.createDOMFromTemplate(B);
D.close=function(){document.body.removeChild(D.elmt);
};
D.open=function(){D.layer=SimileAjax.WindowManager.pushLayer(function(){D.close();
},false);
var F=new Exhibit.Lens(C,D.viewContainer,A,E);
D.elmt.style.top=(document.body.scrollTop+100)+"px";
document.body.appendChild(D.elmt);
SimileAjax.WindowManager.registerEvent(D.closeButton,"click",function(H,G,I){SimileAjax.WindowManager.popLayer(D.layer);
SimileAjax.DOM.cancelEvent(G);
return false;
},D.layer);
};
return D;
};
Exhibit.UI.createTranslucentImage=function(A,B){return SimileAjax.Graphics.createTranslucentImage(Exhibit.urlPrefix+A,B);
};
Exhibit.UI.createTranslucentImageHTML=function(A,B){return SimileAjax.Graphics.createTranslucentImageHTML(Exhibit.urlPrefix+A,B);
};
Exhibit.UI.findAttribute=function(A,D,B){var B=SimileAjax.jQuery(B||document.body);
var C=function(){var E=this.getAttribute(A);
if(D===undefined){return !!E;
}else{if(D instanceof Array){return D.indexOf(E)!=-1;
}else{return D.toString()==E;
}}};
return B.find("*").add(B).filter(C);
};


/* html-view.js */
Exhibit.HTMLView=function(C,A,B){this.html=B;
this.view=this.moveChildNodes(B,C);
};
Exhibit.HTMLView.create=Exhibit.HTMLView.createFromDOM=function(C,B,A){return new Exhibit.HTMLView(B!=null?B:C,null,C);
};
Exhibit.HTMLView.prototype.dispose=function(){this.html=this.moveChildNodes(this.view,this.html);
this.view=this.html=null;
};
Exhibit.HTMLView.prototype.moveChildNodes=function(B,C){if(B===C){return C;
}var A=document.createDocumentFragment();
while(B.firstChild){A.appendChild(B.firstChild);
}C.appendChild(A);
return C;
};


/* ordered-view-frame.js */
Exhibit.OrderedViewFrame=function(A){this._uiContext=A;
this._orders=null;
this._possibleOrders=null;
this._settings={};
};
Exhibit.OrderedViewFrame._settingSpecs={"showAll":{type:"boolean",defaultValue:false},"grouped":{type:"boolean",defaultValue:true},"showDuplicates":{type:"boolean",defaultValue:false},"abbreviatedCount":{type:"int",defaultValue:10},"showHeader":{type:"boolean",defaultValue:true},"showSummary":{type:"boolean",defaultValue:true},"showControls":{type:"boolean",defaultValue:true},"showFooter":{type:"boolean",defaultValue:true}};
Exhibit.OrderedViewFrame.prototype.configure=function(A){if("orders" in A){this._orders=[];
this._configureOrders(A.orders);
}if("possibleOrders" in A){this._possibleOrders=[];
this._configurePossibleOrders(A.possibleOrders);
}Exhibit.SettingsUtilities.collectSettings(A,Exhibit.OrderedViewFrame._settingSpecs,this._settings);
this._internalValidate();
};
Exhibit.OrderedViewFrame.prototype.configureFromDOM=function(A){var E=Exhibit.getAttribute(A,"orders",",");
if(E!=null&&E.length>0){this._orders=[];
this._configureOrders(E);
}var F=Exhibit.getAttribute(A,"directions",",");
if(F!=null&&F.length>0&&this._orders!=null){for(var D=0;
D<F.length&&D<this._orders.length;
D++){this._orders[D].ascending=(F[D].toLowerCase()!="descending");
}}var B=Exhibit.getAttribute(A,"possibleOrders",",");
if(B!=null&&B.length>0){this._possibleOrders=[];
this._configurePossibleOrders(B);
}var C=Exhibit.getAttribute(A,"possibleDirections",",");
if(C!=null&&C.length>0&&this._possibleOrders!=null){for(var D=0;
D<C.length&&D<this._possibleOrders.length;
D++){this._possibleOrders[D].ascending=(C[D].toLowerCase()!="descending");
}}Exhibit.SettingsUtilities.collectSettingsFromDOM(A,Exhibit.OrderedViewFrame._settingSpecs,this._settings);
this._internalValidate();
};
Exhibit.OrderedViewFrame.prototype.dispose=function(){if(this._headerDom){this._headerDom.dispose();
this._headerDom=null;
}if(this._footerDom){this._footerDom.dispose();
this._footerDom=null;
}this._divHeader=null;
this._divFooter=null;
this._uiContext=null;
};
Exhibit.OrderedViewFrame.prototype._internalValidate=function(){if(this._orders!=null&&this._orders.length==0){this._orders=null;
}if(this._possibleOrders!=null&&this._possibleOrders.length==0){this._possibleOrders=null;
}};
Exhibit.OrderedViewFrame.prototype._configureOrders=function(C){for(var D=0;
D<C.length;
D++){var A=C[D];
var H;
var B=true;
if(typeof A=="string"){H=A;
}else{if(typeof A=="object"){H=A.expression,B=("ascending" in A)?(A.ascending):true;
}else{SimileAjax.Debug.warn("Bad order object "+A);
continue;
}}try{var G=Exhibit.ExpressionParser.parse(H);
if(G.isPath()){var I=G.getPath();
if(I.getSegmentCount()==1){var E=I.getSegment(0);
this._orders.push({property:E.property,forward:E.forward,ascending:B});
}}}catch(F){SimileAjax.Debug.warn("Bad order expression "+H);
}}};
Exhibit.OrderedViewFrame.prototype._configurePossibleOrders=function(A){for(var D=0;
D<A.length;
D++){var B=A[D];
var H;
var C=true;
if(typeof B=="string"){H=B;
}else{if(typeof B=="object"){H=B.expression,C=("ascending" in B)?(B.ascending):true;
}else{SimileAjax.Debug.warn("Bad possible order object "+B);
continue;
}}try{var G=Exhibit.ExpressionParser.parse(H);
if(G.isPath()){var I=G.getPath();
if(I.getSegmentCount()==1){var E=I.getSegment(0);
this._possibleOrders.push({property:E.property,forward:E.forward,ascending:C});
}}}catch(F){SimileAjax.Debug.warn("Bad possible order expression "+H);
}}};
Exhibit.OrderedViewFrame.prototype.initializeUI=function(){var A=this;
if(this._settings.showHeader){this._headerDom=Exhibit.OrderedViewFrame.createHeaderDom(this._uiContext,this._divHeader,this._settings.showSummary,this._settings.showControls,function(C,B,D){A._openSortPopup(C,-1);
},function(C,B,D){A._toggleGroup();
});
}if(this._settings.showFooter){this._footerDom=Exhibit.OrderedViewFrame.createFooterDom(this._uiContext,this._divFooter,function(C,B,D){A._setShowAll(true);
},function(C,B,D){A._setShowAll(false);
});
}};
Exhibit.OrderedViewFrame.prototype.reconstruct=function(){var K=this;
var C=this._uiContext.getCollection();
var H=this._uiContext.getDatabase();
var D=C.countAllItems();
var I=C.countRestrictedItems();
var E=false;
if(I>0){var F=C.getRestrictedItems();
E=this._internalReconstruct(F);
var J=[];
var G=function(L,N){var O=H.getProperty(L.property);
var M=O!=null?(L.forward?O.getPluralLabel():O.getReversePluralLabel()):(L.forward?L.property:"reverse of "+L.property);
J.push(Exhibit.UI.makeActionLink(M,function(Q,P,R){K._openSortPopup(Q,N);
}));
};
var A=this._getOrders();
for(var B=0;
B<A.length;
B++){G(A[B],B);
}if(this._settings.showHeader&&this._settings.showControls){this._headerDom.setOrders(J);
this._headerDom.enableThenByAction(J.length<this._getPossibleOrders().length);
}}if(this._settings.showHeader&&this._settings.showControls){this._headerDom.groupOptionWidget.setChecked(this._settings.grouped);
}if(this._settings.showFooter){this._footerDom.setCounts(I,this._settings.abbreviatedCount,this._settings.showAll,!(E&&this._grouped));
}};
Exhibit.OrderedViewFrame.prototype._internalReconstruct=function(H){var L=this;
var D=this._settings;
var K=this._uiContext.getDatabase();
var E=this._getOrders();
var B=0;
var I=false;
var F=function(M){if((I&&D.grouped)||D.showAll||B<D.abbreviatedCount){L.onNewItem(M,B++);
}};
var J=function(N,O,M){if((I&&D.grouped)||D.showAll||B<D.abbreviatedCount){L.onNewGroup(N,O,M);
}};
var A=function(R,P){var M=E[P];
var U=M.forward?K.getObjectsUnion(R,M.property):K.getSubjectsUnion(R,M.property);
var O="text";
if(M.forward){var T=K.getProperty(M.property);
O=T!=null?T.getValueType():"text";
}else{O="item";
}var V=(O=="item"||O=="text")?C(R,P,U,O):G(R,P,U,O);
var Q=false;
for(var N=0;
N<V.length;
N++){if(V[N].items.size()>1){Q=true;
}}if(Q){I=true;
}for(var N=0;
N<V.length;
N++){var S=V[N];
if(S.items.size()>0){if(Q&&D.grouped){J(S.display,O,P);
}R.removeSet(S.items);
if(S.items.size()>1&&P<E.length-1){A(S.items,P+1);
}else{S.items.visit(F);
}}}if(R.size()>0){if(Q&&D.grouped){J(Exhibit.l10n.missingSortKey,O,P);
}if(R.size()>1&&P<E.length-1){A(R,P+1);
}else{R.visit(F);
}}};
var C=function(Q,P,T,O){var U=[];
var R;
var V;
var M=E[P];
if(O=="item"){T.visit(function(X){var W=K.getObject(X,"label");
W=W!=null?W:X;
U.push({itemID:X,display:W});
});
R=function(X,W){var Y=X.display.localeCompare(W.display);
return Y!=0?Y:X.itemID.localeCompare(W.itemID);
};
V=M.forward?function(W){return K.getSubjects(W.itemID,M.property,null,Q);
}:function(W){return K.getObjects(W.itemID,M.property,null,Q);
};
}else{T.visit(function(W){U.push({display:W});
});
R=function(X,W){return X.display.localeCompare(W.display);
};
V=M.forward?function(W){return K.getSubjects(W.display,M.property,null,Q);
}:function(W){return K.getObjects(W.display,M.property,null,Q);
};
}U.sort(function(X,W){return(M.ascending?1:-1)*R(X,W);
});
for(var N=0;
N<U.length;
N++){var S=U[N];
S.items=V(S);
if(!D.showDuplicates){Q.removeSet(S.items);
}}return U;
};
var G=function(R,P,V,O){var W=[];
var Q={};
var M=E[P];
var S;
if(O=="number"){S=function(X){if(typeof X=="number"){return X;
}else{try{return parseFloat(X);
}catch(Y){return null;
}}};
}else{S=function(X){if(X instanceof Date){return X.getTime();
}else{try{return SimileAjax.DateTime.parseIso8601DateTime(X.toString()).getTime();
}catch(Y){return null;
}}};
}V.visit(function(Z){var Y=S(Z);
if(Y!=null){var X=Q[Y];
if(!X){X={sortkey:Y,display:Z,values:[],items:new Exhibit.Set()};
Q[Y]=X;
W.push(X);
}X.values.push(Z);
}});
W.sort(function(Y,X){return(M.ascending?1:-1)*(Y.sortkey-X.sortkey);
});
for(var N=0;
N<W.length;
N++){var U=W[N];
var V=U.values;
for(var T=0;
T<V.length;
T++){if(M.forward){K.getSubjects(V[T],M.property,U.items,R);
}else{K.getObjects(V[T],M.property,U.items,R);
}}if(!D.showDuplicates){R.removeSet(U.items);
}}return W;
};
A(H,0);
return I;
};
Exhibit.OrderedViewFrame.prototype._getOrders=function(){return this._orders||[this._getPossibleOrders()[0]];
};
Exhibit.OrderedViewFrame.prototype._getPossibleOrders=function(){var A=null;
if(this._possibleOrders==null){A=this._uiContext.getDatabase().getAllProperties();
for(var B=0,C;
C=A[B];
B++){A[B]={ascending:true,forward:true,property:C};
}}else{A=[].concat(this._possibleOrders);
}if(A.length==0){A.push({property:"label",forward:true,ascending:true});
}return A;
};
Exhibit.OrderedViewFrame.prototype._openSortPopup=function(G,E){var J=this;
var H=this._uiContext.getDatabase();
var S=Exhibit.UI.createPopupMenuDom(G);
var K=this._getOrders();
if(E>=0){var N=K[E];
var D=H.getProperty(N.property);
var I=N.forward?D.getPluralLabel():D.getReversePluralLabel();
var P=N.forward?D.getValueType():"item";
var C=Exhibit.Database.l10n.sortLabels[P];
C=(C!=null)?C:Exhibit.Database.l10n.sortLabels["text"];
S.appendMenuItem(C.ascending,Exhibit.urlPrefix+(N.ascending?"images/option-check.png":"images/option.png"),N.ascending?function(){}:function(){J._reSort(E,N.property,N.forward,true,false);
});
S.appendMenuItem(C.descending,Exhibit.urlPrefix+(N.ascending?"images/option.png":"images/option-check.png"),N.ascending?function(){J._reSort(E,N.property,N.forward,false,false);
}:function(){});
if(K.length>1){S.appendSeparator();
S.appendMenuItem(Exhibit.OrderedViewFrame.l10n.removeOrderLabel,null,function(){J._removeOrder(E);
});
}}var A=[];
var B=this._getPossibleOrders();
for(O=0;
O<B.length;
O++){var F=B[O];
var L=false;
for(var M=(E<0)?K.length-1:E;
M>=0;
M--){var Q=K[M];
if(Q.property==F.property&&Q.forward==F.forward){L=true;
break;
}}if(!L){var D=H.getProperty(F.property);
A.push({property:F.property,forward:F.forward,ascending:F.ascending,label:F.forward?D.getPluralLabel():D.getReversePluralLabel()});
}}if(A.length>0){if(E>=0){S.appendSeparator();
}A.sort(function(U,T){return U.label.localeCompare(T.label);
});
var R=function(T){S.appendMenuItem(T.label,null,function(){J._reSort(E,T.property,T.forward,T.ascending,true);
});
};
for(var O=0;
O<A.length;
O++){R(A[O]);
}}S.open();
};
Exhibit.OrderedViewFrame.prototype._reSort=function(H,K,G,B,I){var D=this._getOrders();
H=(H<0)?D.length:H;
var F=D.slice(0,H);
F.push({property:K,forward:G,ascending:B});
if(!I){F=F.concat(D.slice(H+1));
}var J=this._uiContext.getDatabase().getProperty(K);
var A=G?J.getPluralLabel():J.getReversePluralLabel();
var C=G?J.getValueType():"item";
var E=Exhibit.Database.l10n.sortLabels[C];
E=(E!=null)?E:Exhibit.Database.l10n.sortLabels["text"];
var L=this;
SimileAjax.History.addLengthyAction(function(){L._orders=F;
L.parentReconstruct();
},function(){L._orders=D;
L.parentReconstruct();
},Exhibit.OrderedViewFrame.l10n.formatSortActionTitle(A,B?E.ascending:E.descending));
};
Exhibit.OrderedViewFrame.prototype._removeOrder=function(G){var D=this._getOrders();
var F=D.slice(0,G).concat(D.slice(G+1));
var A=D[G];
var H=this._uiContext.getDatabase().getProperty(A.property);
var B=A.forward?H.getPluralLabel():H.getReversePluralLabel();
var C=A.forward?H.getValueType():"item";
var E=Exhibit.Database.l10n.sortLabels[C];
E=(E!=null)?E:Exhibit.Database.l10n.sortLabels["text"];
var I=this;
SimileAjax.History.addLengthyAction(function(){I._orders=F;
I.parentReconstruct();
},function(){I._orders=D;
I.parentReconstruct();
},Exhibit.OrderedViewFrame.l10n.formatRemoveOrderActionTitle(B,A.ascending?E.ascending:E.descending));
};
Exhibit.OrderedViewFrame.prototype._setShowAll=function(B){var A=this;
var C=this._settings;
SimileAjax.History.addLengthyAction(function(){C.showAll=B;
A.parentReconstruct();
},function(){C.showAll=!B;
A.parentReconstruct();
},Exhibit.OrderedViewFrame.l10n[B?"showAllActionTitle":"dontShowAllActionTitle"]);
};
Exhibit.OrderedViewFrame.prototype._toggleGroup=function(){var C=this._settings;
var B=C.grouped;
var A=this;
SimileAjax.History.addLengthyAction(function(){C.grouped=!B;
A.parentReconstruct();
},function(){C.grouped=B;
A.parentReconstruct();
},Exhibit.OrderedViewFrame.l10n[B?"ungroupAsSortedActionTitle":"groupAsSortedActionTitle"]);
};
Exhibit.OrderedViewFrame.prototype._toggleShowDuplicates=function(){var C=this._settings;
var B=C.showDuplicates;
var A=this;
SimileAjax.History.addLengthyAction(function(){C.showDuplicates=!B;
A.parentReconstruct();
},function(){C.showDuplicates=B;
A.parentReconstruct();
},Exhibit.OrderedViewFrame.l10n[B?"hideDuplicatesActionTitle":"showDuplicatesActionTitle"]);
};
Exhibit.OrderedViewFrame.headerTemplate="<div id='collectionSummaryDiv' style='display: none;'></div><div class='exhibit-collectionView-header-sortControls' style='display: none;' id='controlsDiv'>%0<span class='exhibit-collectionView-header-groupControl'> \u2022 <a id='groupOption' class='exhibit-action'></a></span></div>";
Exhibit.OrderedViewFrame.createHeaderDom=function(D,G,F,C,E,A){var I=Exhibit.OrderedViewFrame.l10n;
var H=String.substitute(Exhibit.OrderedViewFrame.headerTemplate,[I.sortingControlsTemplate]);
var B=SimileAjax.DOM.createDOMFromString(G,H,{});
G.className="exhibit-collectionView-header";
if(F){B.collectionSummaryDiv.style.display="block";
B.collectionSummaryWidget=Exhibit.CollectionSummaryWidget.create({},B.collectionSummaryDiv,D);
}if(C){B.controlsDiv.style.display="block";
B.groupOptionWidget=Exhibit.OptionWidget.create({label:I.groupedAsSortedOptionLabel,onToggle:A},B.groupOption,D);
SimileAjax.WindowManager.registerEvent(B.thenSortByAction,"click",E);
B.enableThenByAction=function(J){Exhibit.UI.enableActionLink(B.thenSortByAction,J);
};
B.setOrders=function(L){B.ordersSpan.innerHTML="";
var J=Exhibit.Formatter.createListDelimiter(B.ordersSpan,L.length,D);
for(var K=0;
K<L.length;
K++){J();
B.ordersSpan.appendChild(L[K]);
}J();
};
}B.dispose=function(){if("collectionSummaryWidget" in B){B.collectionSummaryWidget.dispose();
B.collectionSummaryWidget=null;
}B.groupOptionWidget.dispose();
B.groupOptionWidget=null;
};
return B;
};
Exhibit.OrderedViewFrame.footerTemplate="<span id='showAllSpan'></span>";
Exhibit.OrderedViewFrame.createFooterDom=function(A,E,D,B){var C=Exhibit.OrderedViewFrame.l10n;
var F=SimileAjax.DOM.createDOMFromString(E,Exhibit.OrderedViewFrame.footerTemplate,{});
E.className="exhibit-collectionView-footer";
F.setCounts=function(I,H,G,J){F.showAllSpan.innerHTML="";
if(J&&I>H){if(G){F.showAllSpan.appendChild(Exhibit.UI.makeActionLink(C.formatDontShowAll(H),B));
}else{F.showAllSpan.appendChild(Exhibit.UI.makeActionLink(C.formatShowAll(I),D));
}}};
F.dispose=function(){};
return F;
};


/* tabular-view.js */
Exhibit.TabularView=function(C,B){this._div=C;
this._uiContext=B;
this._settings={rowStyler:null,tableStyler:null};
this._columns=[];
this._rowTemplate=null;
var A=this;
this._listener={onItemsChanged:function(){A._reconstruct();
}};
B.getCollection().addListener(this._listener);
};
Exhibit.TabularView._settingSpecs={"sortAscending":{type:"boolean",defaultValue:true},"sortColumn":{type:"int",defaultValue:0},"showSummary":{type:"boolean",defaultValue:true},"showToolbox":{type:"boolean",defaultValue:true},"border":{type:"int",defaultValue:1},"cellPadding":{type:"int",defaultValue:5},"cellSpacing":{type:"int",defaultValue:3}};
Exhibit.TabularView.create=function(D,C,B){var A=new Exhibit.TabularView(C,Exhibit.UIContext.create(D,B));
Exhibit.TabularView._configure(A,D);
A._internalValidate();
A._initializeUI();
return A;
};
Exhibit.TabularView.createFromDOM=function(configElmt,containerElmt,uiContext){var configuration=Exhibit.getConfigurationFromDOM(configElmt);
uiContext=Exhibit.UIContext.createFromDOM(configElmt,uiContext);
var view=new Exhibit.TabularView(containerElmt!=null?containerElmt:configElmt,uiContext);
Exhibit.SettingsUtilities.collectSettingsFromDOM(configElmt,Exhibit.TabularView._settingSpecs,view._settings);
try{var expressions=[];
var labels=Exhibit.getAttribute(configElmt,"columnLabels",",")||[];
var s=Exhibit.getAttribute(configElmt,"columns");
if(s!=null&&s.length>0){expressions=Exhibit.ExpressionParser.parseSeveral(s);
}for(var i=0;
i<expressions.length;
i++){var expression=expressions[i];
view._columns.push({expression:expression,uiContext:Exhibit.UIContext.create({},view._uiContext,true),styler:null,label:i<labels.length?labels[i]:null,format:"list"});
}var formats=Exhibit.getAttribute(configElmt,"columnFormats");
if(formats!=null&&formats.length>0){var index=0;
var startPosition=0;
while(index<view._columns.length&&startPosition<formats.length){var column=view._columns[index];
var o={};
column.format=Exhibit.FormatParser.parseSeveral(column.uiContext,formats,startPosition,o);
startPosition=o.index;
while(startPosition<formats.length&&" \t\r\n".indexOf(formats.charAt(startPosition))>=0){startPosition++;
}if(startPosition<formats.length&&formats.charAt(startPosition)==","){startPosition++;
}index++;
}}var tables=configElmt.getElementsByTagName("table");
if(tables.length>0&&tables[0].rows.length>0){view._rowTemplate=Exhibit.Lens.compileTemplate(tables[0].rows[0],false,uiContext);
}}catch(e){SimileAjax.Debug.exception(e,"TabularView: Error processing configuration of tabular view");
}var s=Exhibit.getAttribute(configElmt,"rowStyler");
if(s!=null&&s.length>0){var f=eval(s);
if(typeof f=="function"){view._settings.rowStyler=f;
}}s=Exhibit.getAttribute(configElmt,"tableStyler");
if(s!=null&&s.length>0){f=eval(s);
if(typeof f=="function"){view._settings.tableStyler=f;
}}Exhibit.TabularView._configure(view,configuration);
view._internalValidate();
view._initializeUI();
return view;
};
Exhibit.TabularView._configure=function(F,A){Exhibit.SettingsUtilities.collectSettings(A,Exhibit.TabularView._settingSpecs,F._settings);
if("columns" in A){var C=A.columns;
for(var D=0;
D<C.length;
D++){var B=C[D];
var I;
var K=null;
var G=null;
var H=null;
if(typeof B=="string"){I=B;
}else{I=B.expression;
K=B.styler;
G=B.label;
H=B.format;
}var E=Exhibit.ExpressionParser.parse(I);
if(E.isPath()){var J=E.getPath();
if(H!=null&&H.length>0){H=Exhibit.FormatParser.parse(F._uiContext,H,0);
}else{H="list";
}F._columns.push({expression:E,styler:K,label:G,format:H,uiContext:F._uiContext});
}}}if("rowStyler" in A){F._settings.rowStyler=A.rowStyler;
}if("tableStyler" in A){F._settings.tableStyler=A.tableStyler;
}};
Exhibit.TabularView.prototype._internalValidate=function(){if(this._columns.length==0){var B=this._uiContext.getDatabase();
var D=B.getAllProperties();
for(var A=0;
A<D.length;
A++){var C=D[A];
if(C!="uri"){this._columns.push({expression:Exhibit.ExpressionParser.parse("."+C),styler:null,label:B.getProperty(C).getLabel(),format:"list"});
}}}this._settings.sortColumn=Math.max(0,Math.min(this._settings.sortColumn,this._columns.length-1));
};
Exhibit.TabularView.prototype.dispose=function(){this._uiContext.getCollection().removeListener(this._listener);
if(this._toolboxWidget){this._toolboxWidget.dispose();
this._toolboxWidget=null;
}this._collectionSummaryWidget.dispose();
this._collectionSummaryWidget=null;
this._uiContext.dispose();
this._uiContext=null;
this._div.innerHTML="";
this._dom=null;
this._div=null;
};
Exhibit.TabularView.prototype._initializeUI=function(){var A=this;
this._div.innerHTML="";
this._dom=Exhibit.TabularView.createDom(this._div);
this._collectionSummaryWidget=Exhibit.CollectionSummaryWidget.create({},this._dom.collectionSummaryDiv,this._uiContext);
if(this._settings.showToolbox){this._toolboxWidget=Exhibit.ToolboxWidget.createFromDOM(this._div,this._div,this._uiContext);
this._toolboxWidget.getGeneratedHTML=function(){return A._dom.bodyDiv.innerHTML;
};
}if(!this._settings.showSummary){this._dom.collectionSummaryDiv.style.display="none";
}this._reconstruct();
};
Exhibit.TabularView.prototype._reconstruct=function(){var M=this;
var E=this._uiContext.getCollection();
var K=this._uiContext.getDatabase();
var B=this._dom.bodyDiv;
B.innerHTML="";
var G=[];
var F=E.countAllItems();
if(F>0){var I=E.getRestrictedItems();
I.visit(function(N){G.push({id:N,sortKey:""});
});
}if(G.length>0){var A=this._columns[this._settings.sortColumn];
G.sort(this._createSortFunction(G,A.expression,this._settings.sortAscending));
var L=document.createElement("table");
L.className="exhibit-tabularView-body";
if(this._settings.tableStyler!=null){this._settings.tableStyler(L,K);
}else{L.cellSpacing=this._settings.cellSpacing;
L.cellPadding=this._settings.cellPadding;
L.border=this._settings.border;
}var H=L.insertRow(0);
var J=function(N){var O=M._columns[N];
if(O.label==null){O.label=M._getColumnLabel(O.expression);
}var P=document.createElement("th");
Exhibit.TabularView.createColumnHeader(exhibit,P,O.label,N==M._settings.sortColumn,M._settings.sortAscending,function(R,Q,S){M._doSort(N);
SimileAjax.DOM.cancelEvent(Q);
return false;
});
H.appendChild(P);
};
for(var D=0;
D<this._columns.length;
D++){J(D);
}var C;
if(this._rowTemplate!=null){C=function(N){var O=G[N];
var P=Exhibit.Lens.constructFromLensTemplate(O.id,M._rowTemplate,L,M._uiContext);
if(M._settings.rowStyler!=null){M._settings.rowStyler(O.id,K,P,N);
}};
}else{C=function(O){var Q=G[O];
var R=L.insertRow(L.rows.length);
for(var U=0;
U<M._columns.length;
U++){var P=M._columns[U];
var T=R.insertCell(U);
var N=P.expression.evaluate({"value":Q.id},{"value":"item"},"value",K);
var S=P.format=="list"?N.valueType:P.format;
P.uiContext.formatList(N.values,N.size,S,function(V){T.appendChild(V);
});
if(P.styler!=null){P.styler(Q.id,K,T);
}}if(M._settings.rowStyler!=null){M._settings.rowStyler(Q.id,K,R,O);
}};
}for(var D=0;
D<G.length;
D++){C(D);
}B.appendChild(L);
}};
Exhibit.TabularView.prototype._getColumnLabel=function(F){var C=this._uiContext.getDatabase();
var E=F.getPath();
var A=E.getSegment(E.getSegmentCount()-1);
var D=A.property;
var B=C.getProperty(D);
if(B!=null){return A.forward?B.getLabel():B.getReverseLabel();
}else{return D;
}};
Exhibit.TabularView.prototype._createSortFunction=function(H,G,C){var L=this._uiContext.getDatabase();
var B=C?1:-1;
var J=function(Q,P){return B*(Q.sortKey-P.sortKey);
};
var O=function(Q,P){return B*Q.sortKey.localeCompare(P.sortKey);
};
var I=[];
var F={};
for(var E=0;
E<H.length;
E++){var N=H[E];
var A=G.evaluate({"value":N.id},{"value":"item"},"value",L);
A.values.visit(function(P){N.sortKey=P;
});
if(!(A.valueType in F)){F[A.valueType]=true;
I.push(A.valueType);
}}var D="text";
if(I.length==1){D=I[0];
}else{D="text";
}var M;
var K;
if(D=="number"){K=J;
M=function(P){if(P==null){return Number.NEGATIVE_INFINITY;
}else{if(typeof P=="number"){return P;
}else{var Q=parseFloat(P);
if(isNaN(Q)){return Number.NEGATIVE_INFINITY;
}else{return Q;
}}}};
}else{if(D=="date"){K=J;
M=function(P){if(P==null){return Number.NEGATIVE_INFINITY;
}else{if(P instanceof Date){return P.getTime();
}else{try{return SimileAjax.DateTime.parseIso8601DateTime(P).getTime();
}catch(Q){return Number.NEGATIVE_INFINITY;
}}}};
}else{if(D=="boolean"){K=J;
M=function(P){if(P==null){return Number.NEGATIVE_INFINITY;
}else{if(typeof P=="boolean"){return P?1:0;
}else{return P.toString().toLowerCase()=="true";
}}};
}else{if(D=="item"){K=O;
M=function(P){if(P==null){return Exhibit.l10n.missingSortKey;
}else{var Q=L.getObject(P,"label");
return(Q==null)?P:Q;
}};
}else{K=O;
M=function(P){if(P==null){return Exhibit.l10n.missingSortKey;
}else{return P.toString();
}};
}}}}for(var E=0;
E<H.length;
E++){var N=H[E];
N.sortKey=M(N.sortKey);
}return K;
};
Exhibit.TabularView.prototype._doSort=function(F){var B=this._settings.sortColumn;
var G=this._settings.sortAscending;
var E=F;
var A=B==E?!G:true;
var D=this._settings;
var C=this;
SimileAjax.History.addLengthyAction(function(){D.sortColumn=E;
D.sortAscending=A;
C._reconstruct();
},function(){D.sortColumn=B;
D.sortAscending=G;
C._reconstruct();
},Exhibit.TabularView.l10n.makeSortActionTitle(this._columns[F].label,A));
};
Exhibit.TabularView._constructDefaultValueList=function(B,D,C,A){A.formatList(B,B.size(),D,function(E){C.appendChild(E);
});
};
Exhibit.TabularView.createDom=function(C){var A=Exhibit.TabularView.l10n;
var B={elmt:C,className:"exhibit-collectionView-header",children:[{tag:"div",field:"collectionSummaryDiv"},{tag:"div",field:"bodyDiv"}]};
return SimileAjax.DOM.createDOMFromTemplate(B);
};
Exhibit.TabularView.createColumnHeader=function(G,A,E,C,D,H){var I=Exhibit.TabularView.l10n;
var F={elmt:A,className:C?"exhibit-tabularView-columnHeader-sorted":"exhibit-tabularView-columnHeader",title:C?I.columnHeaderReSortTooltip:I.columnHeaderSortTooltip,children:[E]};
if(C){F.children.push({elmt:Exhibit.UI.createTranslucentImage(D?"images/up-arrow.png":"images/down-arrow.png")});
}SimileAjax.WindowManager.registerEvent(A,"click",H,null);
var B=SimileAjax.DOM.createDOMFromTemplate(F);
return B;
};


/* thumbnail-view.js */
Exhibit.ThumbnailView=function(C,B){this._div=C;
this._uiContext=B;
this._settings={};
var A=this;
this._listener={onItemsChanged:function(){A._reconstruct();
}};
B.getCollection().addListener(this._listener);
this._orderedViewFrame=new Exhibit.OrderedViewFrame(B);
this._orderedViewFrame.parentReconstruct=function(){A._reconstruct();
};
};
Exhibit.ThumbnailView._settingSpecs={"showToolbox":{type:"boolean",defaultValue:true}};
Exhibit.ThumbnailView.create=function(D,C,B){var A=new Exhibit.ThumbnailView(C,Exhibit.UIContext.create(D,B,true));
A._lensRegistry=Exhibit.UIContext.createLensRegistry(D,B.getLensRegistry());
Exhibit.SettingsUtilities.collectSettings(D,Exhibit.ThumbnailView._settingSpecs,A._settings);
A._orderedViewFrame.configure(D);
A._initializeUI();
return A;
};
Exhibit.ThumbnailView.createFromDOM=function(D,C,B){var E=Exhibit.getConfigurationFromDOM(D);
var A=new Exhibit.ThumbnailView(C!=null?C:D,Exhibit.UIContext.createFromDOM(D,B,true));
A._lensRegistry=Exhibit.UIContext.createLensRegistryFromDOM(D,E,B.getLensRegistry());
Exhibit.SettingsUtilities.collectSettingsFromDOM(D,Exhibit.ThumbnailView._settingSpecs,A._settings);
Exhibit.SettingsUtilities.collectSettings(E,Exhibit.ThumbnailView._settingSpecs,A._settings);
A._orderedViewFrame.configureFromDOM(D);
A._orderedViewFrame.configure(E);
A._initializeUI();
return A;
};
Exhibit.ThumbnailView.prototype.dispose=function(){this._uiContext.getCollection().removeListener(this._listener);
if(this._toolboxWidget){this._toolboxWidget.dispose();
this._toolboxWidget=null;
}this._orderedViewFrame.dispose();
this._orderedViewFrame=null;
this._lensRegistry=null;
this._dom=null;
this._div.innerHTML="";
this._div=null;
this._uiContext=null;
};
Exhibit.ThumbnailView.prototype._initializeUI=function(){var A=this;
this._div.innerHTML="";
var B={elmt:this._div,children:[{tag:"div",field:"headerDiv"},{tag:"div",className:"exhibit-collectionView-body",field:"bodyDiv"},{tag:"div",field:"footerDiv"}]};
this._dom=SimileAjax.DOM.createDOMFromTemplate(B);
if(this._settings.showToolbox){this._toolboxWidget=Exhibit.ToolboxWidget.createFromDOM(this._div,this._div,this._uiContext);
this._toolboxWidget.getGeneratedHTML=function(){return A._dom.bodyDiv.innerHTML;
};
}this._orderedViewFrame._divHeader=this._dom.headerDiv;
this._orderedViewFrame._divFooter=this._dom.footerDiv;
this._orderedViewFrame._generatedContentElmtRetriever=function(){return A._dom.bodyDiv;
};
this._orderedViewFrame.initializeUI();
this._reconstruct();
};
Exhibit.ThumbnailView.prototype._reconstruct=function(){var A=this;
var B={div:this._dom.bodyDiv,itemContainer:null,groupDoms:[],groupCounts:[]};
var C=function(D){for(var E=D;
E<B.groupDoms.length;
E++){B.groupDoms[E].countSpan.innerHTML=B.groupCounts[E];
}B.groupDoms=B.groupDoms.slice(0,D);
B.groupCounts=B.groupCounts.slice(0,D);
if(D>0){B.div=B.groupDoms[D-1].contentDiv;
}else{B.div=A._dom.bodyDiv;
}B.itemContainer=null;
};
this._orderedViewFrame.onNewGroup=function(D,G,E){C(E);
var F=Exhibit.ThumbnailView.constructGroup(E,D);
B.div.appendChild(F.elmt);
B.div=F.contentDiv;
B.groupDoms.push(F);
B.groupCounts.push(0);
};
this._orderedViewFrame.onNewItem=function(H,E){if(B.itemContainer==null){B.itemContainer=Exhibit.ThumbnailView.constructItemContainer();
B.div.appendChild(B.itemContainer);
}for(var F=0;
F<B.groupCounts.length;
F++){B.groupCounts[F]++;
}var D=document.createElement("div");
D.className=SimileAjax.Platform.browser.isIE?"exhibit-thumbnailView-itemContainer-IE":"exhibit-thumbnailView-itemContainer";
var G=A._lensRegistry.createLens(H,D,A._uiContext);
B.itemContainer.appendChild(D);
};
this._div.style.display="none";
this._dom.bodyDiv.innerHTML="";
this._orderedViewFrame.reconstruct();
C(0);
this._div.style.display="block";
};
Exhibit.ThumbnailView.constructGroup=function(B,A){var C=Exhibit.ThumbnailView.l10n;
var D={tag:"div",className:"exhibit-thumbnailView-group",children:[{tag:"h"+(B+1),children:[A,{tag:"span",className:"exhibit-collectionView-group-count",children:[" (",{tag:"span",field:"countSpan"},")"]}],field:"header"},{tag:"div",className:"exhibit-collectionView-group-content",field:"contentDiv"}]};
return SimileAjax.DOM.createDOMFromTemplate(D);
};
Exhibit.ThumbnailView.constructItemContainer=function(){var A=document.createElement("div");
A.className="exhibit-thumbnailView-body";
return A;
};


/* tile-view.js */
Exhibit.TileView=function(C,B){this._div=C;
this._uiContext=B;
this._settings={};
var A=this;
this._listener={onItemsChanged:function(){A._reconstruct();
}};
B.getCollection().addListener(this._listener);
this._orderedViewFrame=new Exhibit.OrderedViewFrame(B);
this._orderedViewFrame.parentReconstruct=function(){A._reconstruct();
};
};
Exhibit.TileView._settingSpecs={"showToolbox":{type:"boolean",defaultValue:true}};
Exhibit.TileView.create=function(D,C,B){var A=new Exhibit.TileView(C,Exhibit.UIContext.create(D,B));
Exhibit.SettingsUtilities.collectSettings(D,Exhibit.TileView._settingSpecs,A._settings);
A._orderedViewFrame.configure(D);
A._initializeUI();
return A;
};
Exhibit.TileView.createFromDOM=function(D,C,B){var E=Exhibit.getConfigurationFromDOM(D);
var A=new Exhibit.TileView(C!=null?C:D,Exhibit.UIContext.createFromDOM(D,B));
Exhibit.SettingsUtilities.collectSettingsFromDOM(D,Exhibit.TileView._settingSpecs,A._settings);
Exhibit.SettingsUtilities.collectSettings(E,Exhibit.TileView._settingSpecs,A._settings);
A._orderedViewFrame.configureFromDOM(D);
A._orderedViewFrame.configure(E);
A._initializeUI();
return A;
};
Exhibit.TileView.prototype.dispose=function(){this._uiContext.getCollection().removeListener(this._listener);
this._div.innerHTML="";
if(this._toolboxWidget){this._toolboxWidget.dispose();
this._toolboxWidget=null;
}this._orderedViewFrame.dispose();
this._orderedViewFrame=null;
this._dom=null;
this._div=null;
this._uiContext=null;
};
Exhibit.TileView.prototype._initializeUI=function(){var A=this;
this._div.innerHTML="";
var B={elmt:this._div,children:[{tag:"div",field:"headerDiv"},{tag:"div",className:"exhibit-collectionView-body",field:"bodyDiv"},{tag:"div",field:"footerDiv"}]};
this._dom=SimileAjax.DOM.createDOMFromTemplate(B);
if(this._settings.showToolbox){this._toolboxWidget=Exhibit.ToolboxWidget.createFromDOM(this._div,this._div,this._uiContext);
this._toolboxWidget.getGeneratedHTML=function(){return A._dom.bodyDiv.innerHTML;
};
}this._orderedViewFrame._divHeader=this._dom.headerDiv;
this._orderedViewFrame._divFooter=this._dom.footerDiv;
this._orderedViewFrame._generatedContentElmtRetriever=function(){return A._dom.bodyDiv;
};
this._orderedViewFrame.initializeUI();
this._reconstruct();
};
Exhibit.TileView.prototype._reconstruct=function(){var A=this;
var B={div:this._dom.bodyDiv,contents:null,groupDoms:[],groupCounts:[]};
var C=function(D){for(var E=D;
E<B.groupDoms.length;
E++){B.groupDoms[E].countSpan.innerHTML=B.groupCounts[E];
}B.groupDoms=B.groupDoms.slice(0,D);
B.groupCounts=B.groupCounts.slice(0,D);
if(D>0){B.div=B.groupDoms[D-1].contentDiv;
}else{B.div=A._dom.bodyDiv;
}B.contents=null;
};
this._orderedViewFrame.onNewGroup=function(D,G,E){C(E);
var F=Exhibit.TileView.constructGroup(E,D);
B.div.appendChild(F.elmt);
B.div=F.contentDiv;
B.groupDoms.push(F);
B.groupCounts.push(0);
};
this._orderedViewFrame.onNewItem=function(H,D){if(B.contents==null){B.contents=Exhibit.TileView.constructList();
B.div.appendChild(B.contents);
}for(var E=0;
E<B.groupCounts.length;
E++){B.groupCounts[E]++;
}var G=document.createElement("li");
var F=A._uiContext.getLensRegistry().createLens(H,G,A._uiContext);
B.contents.appendChild(G);
};
this._div.style.display="none";
this._dom.bodyDiv.innerHTML="";
this._orderedViewFrame.reconstruct();
C(0);
this._div.style.display="block";
};
Exhibit.TileView.constructGroup=function(B,A){var C={tag:"div",className:"exhibit-collectionView-group",children:[{tag:"h"+(B+1),children:[A,{tag:"span",className:"exhibit-collectionView-group-count",children:[" (",{tag:"span",field:"countSpan"},")"]}],field:"header"},{tag:"div",className:"exhibit-collectionView-group-content",field:"contentDiv"}]};
return SimileAjax.DOM.createDOMFromTemplate(C);
};
Exhibit.TileView.constructList=function(){var A=document.createElement("ol");
A.className="exhibit-tileView-body";
return A;
};


/* view-panel.js */
Exhibit.ViewPanel=function(B,A){this._uiContext=A;
this._div=B;
this._uiContextCache={};
this._viewConstructors=[];
this._viewConfigs=[];
this._viewLabels=[];
this._viewTooltips=[];
this._viewDomConfigs=[];
this._viewIDs=[];
this._viewIndex=0;
this._view=null;
};
Exhibit.ViewPanel.create=function(C,A,D){var E=new Exhibit.ViewPanel(A,D);
if("views" in C){for(var F=0;
F<C.views.length;
F++){var G=C.views[F];
var H=("viewClass" in view)?view.viewClass:Exhibit.TileView;
if(typeof H=="string"){H=Exhibit.UI.viewClassNameToViewClass(H);
}var I=null;
if("viewLabel" in G){I=G.viewLabel;
}else{if("label" in G){I=G.label;
}else{if("l10n" in H&&"viewLabel" in H.l10n){I=H.l10n.viewLabel;
}else{I=""+H;
}}}var J=null;
if("tooltip" in G){J=G.tooltip;
}else{if("l10n" in H&&"viewTooltip" in H.l10n){J=H.l10n.viewTooltip;
}else{J=I;
}}var B=E._generateViewID();
if("id" in G){B=G.id;
}E._viewConstructors.push(H);
E._viewConfigs.push(G);
E._viewLabels.push(I);
E._viewTooltips.push(J);
E._viewDomConfigs.push(null);
E._viewIDs.push(B);
}}if("initialView" in C){E._viewIndex=C.initialView;
}E._internalValidate();
E._initializeUI();
return E;
};
Exhibit.ViewPanel.createFromDOM=function(B,G){var H=new Exhibit.ViewPanel(B,Exhibit.UIContext.createFromDOM(B,G,false));
var F=B.firstChild;
while(F!=null){if(F.nodeType==1){F.style.display="none";
var I=Exhibit.getRoleAttribute(F);
if(I=="view"){var K=Exhibit.TileView;
var A=Exhibit.getAttribute(F,"viewClass");
if(A!=null&&A.length>0){K=Exhibit.UI.viewClassNameToViewClass(A);
if(K==null){SimileAjax.Debug.warn("Unknown viewClass "+A);
}}var D=Exhibit.getAttribute(F,"viewLabel");
var M=(D!=null&&D.length>0)?D:Exhibit.getAttribute(F,"label");
var N=Exhibit.getAttribute(F,"title");
var C=F.id;
if(M==null){if("viewLabel" in K.l10n){M=K.l10n.viewLabel;
}else{M=""+K;
}}if(N==null){if("l10n" in K&&"viewTooltip" in K.l10n){N=K.l10n.viewTooltip;
}else{N=M;
}}if(C==null||C.length==0){C=H._generateViewID();
}H._viewConstructors.push(K);
H._viewConfigs.push(null);
H._viewLabels.push(M);
H._viewTooltips.push(N);
H._viewDomConfigs.push(F);
H._viewIDs.push(C);
}}F=F.nextSibling;
}var L=Exhibit.getAttribute(B,"initialView");
if(L!=null&&L.length>0){try{var E=parseInt(L);
if(!isNaN(E)){H._viewIndex=E;
}}catch(J){}}H._internalValidate();
H._initializeUI();
return H;
};
Exhibit.ViewPanel.prototype.dispose=function(){this._uiContext.getCollection().removeListener(this._listener);
if(this._view!=null){this._view.dispose();
this._view=null;
}this._div.innerHTML="";
this._uiContext.dispose();
this._uiContext=null;
this._div=null;
};
Exhibit.ViewPanel.prototype._generateViewID=function(){return"view"+Math.floor(Math.random()*1000000).toString();
};
Exhibit.ViewPanel.prototype._internalValidate=function(){if(this._viewConstructors.length==0){this._viewConstructors.push(Exhibit.TileView);
this._viewConfigs.push({});
this._viewLabels.push(Exhibit.TileView.l10n.viewLabel);
this._viewTooltips.push(Exhibit.TileView.l10n.viewTooltip);
this._viewDomConfigs.push(null);
this._viewIDs.push(this._generateViewID());
}this._viewIndex=Math.max(0,Math.min(this._viewIndex,this._viewConstructors.length-1));
};
Exhibit.ViewPanel.prototype._initializeUI=function(){var B=document.createElement("div");
if(this._div.firstChild!=null){this._div.insertBefore(B,this._div.firstChild);
}else{this._div.appendChild(B);
}var A=this;
this._dom=Exhibit.ViewPanel.constructDom(this._div.firstChild,this._viewLabels,this._viewTooltips,function(C){A._selectView(C);
});
this._createView();
};
Exhibit.ViewPanel.prototype._createView=function(){var A=this._dom.getViewContainer();
A.innerHTML="";
var B=document.createElement("div");
A.appendChild(B);
var C=this._viewIndex;
var D=this._uiContextCache[C]||this._uiContext;
try{if(this._viewDomConfigs[C]!=null){this._view=this._viewConstructors[C].createFromDOM(this._viewDomConfigs[C],A,D);
}else{this._view=this._viewConstructors[C].create(this._viewConfigs[C],A,D);
}}catch(E){SimileAjax.Debug.log("Failed to create view "+this._viewLabels[C]);
SimileAjax.Debug.exception(E);
}this._uiContextCache[C]=this._view._uiContext;
this._uiContext.getExhibit().setComponent(this._viewIDs[C],this._view);
this._dom.setViewIndex(C);
};
Exhibit.ViewPanel.prototype._switchView=function(A){if(this._view){this._uiContext.getExhibit().disposeComponent(this._viewIDs[this._viewIndex]);
this._view=null;
}this._viewIndex=A;
this._createView();
};
Exhibit.ViewPanel.prototype._selectView=function(B){var C=this._viewIndex;
var A=this;
SimileAjax.History.addLengthyAction(function(){A._switchView(B);
},function(){A._switchView(C);
},Exhibit.ViewPanel.l10n.createSelectViewActionTitle(A._viewLabels[B]));
};
Exhibit.ViewPanel.getPropertyValuesPairs=function(F,G,E){var D=[];
var B=function(M,J){var L=E.getProperty(M);
var I=J?E.getObjects(F,M):E.getSubjects(F,M);
var K=I.size();
if(K>0){var H=L.getValueType()=="item";
var N={propertyLabel:J?(K>1?L.getPluralLabel():L.getLabel()):(K>1?L.getReversePluralLabel():L.getReverseLabel()),valueType:L.getValueType(),values:[]};
if(H){I.visit(function(P){var O=E.getObject(P,"label");
N.values.push(O!=null?O:P);
});
}else{I.visit(function(O){N.values.push(O);
});
}D.push(N);
}};
for(var A=0;
A<G.length;
A++){var C=G[A];
if(typeof C=="string"){B(C,true);
}else{B(C.property,C.forward);
}}return D;
};
Exhibit.ViewPanel.constructDom=function(G,B,E,A){var C=Exhibit.ViewPanel.l10n;
var D={elmt:G,className:"exhibit-viewPanel exhibit-ui-protection",children:[{tag:"div",className:"exhibit-viewPanel-viewSelection",field:"viewSelectionDiv"},{tag:"div",className:"exhibit-viewPanel-viewContainer",field:"viewContainerDiv"}]};
var F=SimileAjax.DOM.createDOMFromTemplate(D);
F.getViewContainer=function(){return F.viewContainerDiv;
};
F.setViewIndex=function(I){if(B.length>1){F.viewSelectionDiv.innerHTML="";
var H=function(K){var N=(K==I);
if(K>0){F.viewSelectionDiv.appendChild(document.createTextNode(" \u2022 "));
}var M=document.createElement("span");
M.className=N?"exhibit-viewPanel-viewSelection-selectedView":"exhibit-viewPanel-viewSelection-view";
M.title=E[K];
M.innerHTML=B[K];
if(!N){var L=function(P,O,Q){A(K);
SimileAjax.DOM.cancelEvent(O);
return false;
};
SimileAjax.WindowManager.registerEvent(M,"click",L);
}F.viewSelectionDiv.appendChild(M);
};
for(var J=0;
J<B.length;
J++){H(J);
}}};
return F;
};


/* collection-summary-widget.js */
Exhibit.CollectionSummaryWidget=function(C,A){this._exhibit=A.getExhibit();
this._collection=A.getCollection();
this._uiContext=A;
this._div=C;
var B=this;
this._listener={onItemsChanged:function(){B._reconstruct();
}};
this._collection.addListener(this._listener);
};
Exhibit.CollectionSummaryWidget.create=function(D,C,A){var B=new Exhibit.CollectionSummaryWidget(C,Exhibit.UIContext.create(D,A));
B._initializeUI();
return B;
};
Exhibit.CollectionSummaryWidget.createFromDOM=function(D,C,A){var B=new Exhibit.CollectionSummaryWidget(C!=null?C:D,Exhibit.UIContext.createFromDOM(D,A));
B._initializeUI();
return B;
};
Exhibit.CollectionSummaryWidget.prototype.dispose=function(){this._collection.removeListener(this._listener);
this._div.innerHTML="";
this._noResultsDom=null;
this._allResultsDom=null;
this._filteredResultsDom=null;
this._div=null;
this._collection=null;
this._exhibit=null;
};
Exhibit.CollectionSummaryWidget.prototype._initializeUI=function(){var B=this;
var C=Exhibit.CollectionSummaryWidget.l10n;
var A=function(E,D,F){B._resetCollection();
SimileAjax.DOM.cancelEvent(D);
return false;
};
this._allResultsDom=SimileAjax.DOM.createDOMFromString("span",String.substitute(C.allResultsTemplate,["exhibit-collectionSummaryWidget-results"]));
this._filteredResultsDom=SimileAjax.DOM.createDOMFromString("span",String.substitute(C.filteredResultsTemplate,["exhibit-collectionSummaryWidget-results"]),{resetActionLink:Exhibit.UI.makeActionLink(C.resetFiltersLabel,A)});
this._noResultsDom=SimileAjax.DOM.createDOMFromString("span",String.substitute(C.noResultsTemplate,["exhibit-collectionSummaryWidget-results","exhibit-collectionSummaryWidget-count"]),{resetActionLink:Exhibit.UI.makeActionLink(C.resetFiltersLabel,A)});
this._div.innerHTML="";
this._reconstruct();
};
Exhibit.CollectionSummaryWidget.prototype._reconstruct=function(){var C=this._collection.countAllItems();
var A=this._collection.countRestrictedItems();
var E=this._uiContext.getDatabase();
var G=this._dom;
while(this._div.childNodes.length>0){this._div.removeChild(this._div.firstChild);
}if(C>0){if(A==0){this._div.appendChild(this._noResultsDom.elmt);
}else{var F=E.getTypeIDs(this._collection.getRestrictedItems()).toArray();
var B=F.length==1?F[0]:"Item";
var D=Exhibit.Database.l10n.labelItemsOfType(A,B,E,"exhibit-collectionSummaryWidget-count");
if(A==C){this._div.appendChild(this._allResultsDom.elmt);
this._allResultsDom.resultDescription.innerHTML="";
this._allResultsDom.resultDescription.appendChild(D);
}else{this._div.appendChild(this._filteredResultsDom.elmt);
this._filteredResultsDom.resultDescription.innerHTML="";
this._filteredResultsDom.resultDescription.appendChild(D);
this._filteredResultsDom.originalCountSpan.innerHTML=C;
}}}};
Exhibit.CollectionSummaryWidget.prototype._resetCollection=function(){var A={};
var B=this._collection;
SimileAjax.History.addLengthyAction(function(){A.restrictions=B.clearAllRestrictions();
},function(){B.applyRestrictions(A.restrictions);
},Exhibit.CollectionSummaryWidget.l10n.resetActionTitle);
};


/* legend-gradient-widget.js */
Exhibit.LegendGradientWidget=function(B,A){this._div=B;
this._uiContext=A;
this._initializeUI();
};
Exhibit.LegendGradientWidget.create=function(B,A){return new Exhibit.LegendGradientWidget(B,A);
};
Exhibit.LegendGradientWidget.prototype.addGradient=function(O){var B=[];
var B=O;
var P=function(c,Z){return c.value-Z.value;
};
B.sort(P);
var D=document.createElement("table");
var T=document.createElement("tbody");
var S=document.createElement("tr");
var R=document.createElement("tr");
var Q=document.createElement("tr");
S.style.height="2em";
R.style.height="2em";
Q.style.height="2em";
D.style.width="80%";
D.cellSpacing="0";
D.style.emptyCells="show";
D.style.marginLeft="auto";
D.style.marginRight="auto";
T.appendChild(S);
T.appendChild(R);
T.appendChild(Q);
D.appendChild(T);
this._theRow1=S;
this._theRow2=R;
this._theRow3=Q;
var J=B[0].value;
var W=B[B.length-1].value;
var E=(W-J)/50;
var M=0;
for(var V=0;
V<B.length-1;
V++){var I=B[V].value;
var Y=B[V+1].value;
var X=document.createElement("td");
X.style.backgroundColor="rgb("+B[V].red+","+B[V].green+","+B[V].blue+")";
var K=document.createElement("td");
var A=document.createElement("div");
var H=document.createTextNode(B[V].value);
A.appendChild(H);
K.appendChild(A);
S.appendChild(document.createElement("td"));
R.appendChild(X);
Q.appendChild(K);
X.onmouseover=function(){this.style.border="solid 1.2px";
};
X.onmouseout=function(){this.style.border="none";
};
M++;
for(var U=I+E;
U<Y;
U+=E){var G=(U-I)/(Y-I);
var C=Math.floor(B[V].red+G*(B[V+1].red-B[V].red));
var F=Math.floor(B[V].green+G*(B[V+1].green-B[V].green));
var N=Math.floor(B[V].blue+G*(B[V+1].blue-B[V].blue));
var X=document.createElement("td");
X.count=M;
X.style.backgroundColor="rgb("+C+","+F+","+N+")";
var K=document.createElement("td");
var A=document.createElement("div");
var H=document.createTextNode((Math.floor(U*100))/100);
A.appendChild(H);
K.appendChild(A);
A.style.width="2px";
A.style.overflow="hidden";
A.style.visibility="hidden";
S.appendChild(K);
R.appendChild(X);
Q.appendChild(document.createElement("td"));
M++;
X.onmouseover=function(){this.parentNode.parentNode.childNodes[0].childNodes[this.count].childNodes[0].style.visibility="visible";
this.parentNode.parentNode.childNodes[0].childNodes[this.count].childNodes[0].style.overflow="visible";
this.style.border="solid 1.2px";
};
X.onmouseout=function(){this.parentNode.parentNode.childNodes[0].childNodes[this.count].childNodes[0].style.visibility="hidden";
this.parentNode.parentNode.childNodes[0].childNodes[this.count].childNodes[0].style.overflow="hidden";
this.style.border="none";
};
}}var L=B.length-1;
var X=document.createElement("td");
X.style.backgroundColor="rgb("+B[L].red+","+B[L].green+","+B[L].blue+")";
var K=document.createElement("td");
var A=document.createElement("div");
var H=document.createTextNode(W);
A.appendChild(H);
K.appendChild(A);
S.appendChild(document.createElement("td"));
R.appendChild(X);
Q.appendChild(K);
M++;
X.onmouseover=function(){this.style.border="solid 1.2px";
};
X.onmouseout=function(){this.style.border="none";
};
this._div.appendChild(D);
};
Exhibit.LegendGradientWidget.prototype.addEntry=function(B,C){var A=document.createElement("td");
A.style.width="1.5em";
A.style.height="2em";
this._theRow1.appendChild(A);
this._theRow1.appendChild(document.createElement("td"));
this._theRow2.appendChild(document.createElement("td"));
this._theRow3.appendChild(document.createElement("td"));
var F=document.createElement("td");
F.style.backgroundColor=B;
this._theRow2.appendChild(F);
var E=document.createElement("td");
var D=document.createElement("div");
D.appendChild(document.createTextNode(C));
E.appendChild(D);
this._theRow3.appendChild(E);
};
Exhibit.LegendGradientWidget.prototype.dispose=function(){this._div.innerHTML="";
this._div=null;
this._uiContext=null;
};
Exhibit.LegendGradientWidget.prototype._initializeUI=function(){this._div.className="exhibit-legendGradientWidget";
this._div.innerHTML="";
};
Exhibit.LegendGradientWidget.prototype.clear=function(){this._div.innerHTML="";
};


/* legend-widget.js */
Exhibit.LegendWidget=function(C,B,A){this._configuration=C;
this._div=B;
this._uiContext=A;
this._colorMarkerGenerator="colorMarkerGenerator" in C?C.colorMarkerGenerator:Exhibit.LegendWidget._defaultColorMarkerGenerator;
this._sizeMarkerGenerator="sizeMarkerGenerator" in C?C.sizeMarkerGenerator:Exhibit.LegendWidget._defaultSizeMarkerGenerator;
this._iconMarkerGenerator="iconMarkerGenerator" in C?C.iconMarkerGenerator:Exhibit.LegendWidget._defaultIconMarkerGenerator;
this._labelStyler="labelStyler" in C?C.labelStyler:Exhibit.LegendWidget._defaultColorLabelStyler;
this._initializeUI();
};
Exhibit.LegendWidget.create=function(C,B,A){return new Exhibit.LegendWidget(C,B,A);
};
Exhibit.LegendWidget.prototype.dispose=function(){this._div.innerHTML="";
this._div=null;
this._uiContext=null;
};
Exhibit.LegendWidget.prototype._initializeUI=function(){this._div.className="exhibit-legendWidget";
this._div.innerHTML="<div id='exhibit-color-legend'></div><div id='exhibit-size-legend'></div><div id='exhibit-icon-legend'></div>";
};
Exhibit.LegendWidget.prototype.clear=function(){this._div.innerHTML="<div id='exhibit-color-legend'></div><div id='exhibit-size-legend'></div><div id='exhibit-icon-legend'></div>";
};
Exhibit.LegendWidget.prototype.addLegendLabel=function(A,B){var C=SimileAjax.DOM.createDOMFromString("div","<div id='legend-label'><span id='label' class='exhibit-legendWidget-entry-title'>"+A.replace(/\s+/g,"\u00a0")+"</span>\u00a0\u00a0 </div>",{});
C.elmt.className="exhibit-legendWidget-label";
var D="exhibit-"+B+"-legend";
document.getElementById(D).appendChild(C.elmt);
};
Exhibit.LegendWidget.prototype.addEntry=function(D,A,B){B=B||"color";
A=(A!=null)?A.toString():key.toString();
if(B=="color"){var E=SimileAjax.DOM.createDOMFromString("span","<span id='marker'></span>\u00a0<span id='label' class='exhibit-legendWidget-entry-title'>"+A.replace(/\s+/g,"\u00a0")+"</span>\u00a0\u00a0 ",{marker:this._colorMarkerGenerator(D)});
var C=document.getElementById("exhibit-color-legend");
}if(B=="size"){var E=SimileAjax.DOM.createDOMFromString("span","<span id='marker'></span>\u00a0<span id='label' class='exhibit-legendWidget-entry-title'>"+A.replace(/\s+/g,"\u00a0")+"</span>\u00a0\u00a0 ",{marker:this._sizeMarkerGenerator(D)});
var C=document.getElementById("exhibit-size-legend");
}if(B=="icon"){var E=SimileAjax.DOM.createDOMFromString("span","<span id='marker'></span>\u00a0<span id='label' class='exhibit-legendWidget-entry-title'>"+A.replace(/\s+/g,"\u00a0")+"</span>\u00a0\u00a0 ",{marker:this._iconMarkerGenerator(D)});
var C=document.getElementById("exhibit-icon-legend");
}E.elmt.className="exhibit-legendWidget-entry";
this._labelStyler(E.label,D);
C.appendChild(E.elmt);
};
Exhibit.LegendWidget._localeSort=function(B,A){return B.localeCompare(A);
};
Exhibit.LegendWidget._defaultColorMarkerGenerator=function(B){var A=document.createElement("span");
A.className="exhibit-legendWidget-entry-swatch";
A.style.background=B;
A.innerHTML="\u00a0\u00a0";
return A;
};
Exhibit.LegendWidget._defaultSizeMarkerGenerator=function(B){var A=document.createElement("span");
A.className="exhibit-legendWidget-entry-swatch";
A.style.height=B;
A.style.width=B;
A.style.background="#C0C0C0";
A.innerHTML="\u00a0\u00a0";
return A;
};
Exhibit.LegendWidget._defaultIconMarkerGenerator=function(B){var A=document.createElement("span");
A.className="<img src="+B+"/>";
return A;
};
Exhibit.LegendWidget._defaultColorLabelStyler=function(A,B){};


/* logo.js */
Exhibit.Logo=function(B,A){this._exhibit=A;
this._elmt=B;
this._color="Silver";
};
Exhibit.Logo.create=function(D,B,A){var C=new Exhibit.Logo(B,A);
if("color" in D){C._color=D.color;
}C._initializeUI();
return C;
};
Exhibit.Logo.createFromDOM=function(C,B){var D=new Exhibit.Logo(C,B);
var A=Exhibit.getAttribute(C,"color");
if(A!=null&&A.length>0){D._color=A;
}D._initializeUI();
return D;
};
Exhibit.Logo.prototype.dispose=function(){this._elmt=null;
this._exhibit=null;
};
Exhibit.Logo.prototype._initializeUI=function(){var C="http://static.simile.mit.edu/graphics/logos/exhibit/exhibit-small-"+this._color+".png";
var B=SimileAjax.Graphics.createTranslucentImage(C);
var D="exhibit-logo-image";
if(!document.getElementById(D)){B.id=D;
}var A=document.createElement("a");
A.href="http://simile.mit.edu/exhibit/";
A.title="http://simile.mit.edu/exhibit/";
A.target="_blank";
A.appendChild(B);
this._elmt.appendChild(A);
};


/* option-widget.js */
Exhibit.OptionWidget=function(C,B,A){this._label=C.label;
this._checked="checked" in C?C.checked:false;
this._onToggle=C.onToggle;
this._containerElmt=B;
this._uiContext=A;
this._initializeUI();
};
Exhibit.OptionWidget.create=function(C,B,A){return new Exhibit.OptionWidget(C,B,A);
};
Exhibit.OptionWidget.prototype.dispose=function(){this._containerElmt.innerHTML="";
this._dom=null;
this._containerElmt=null;
this._uiContext=null;
};
Exhibit.OptionWidget.uncheckedImageURL=Exhibit.urlPrefix+"images/option.png";
Exhibit.OptionWidget.checkedImageURL=Exhibit.urlPrefix+"images/option-check.png";
Exhibit.OptionWidget.uncheckedTemplate="<span id='uncheckedSpan' style='display: none;'><img id='uncheckedImage' /> %0</span>";
Exhibit.OptionWidget.checkedTemplate="<span id='checkedSpan' style='display: none;'><img id='checkedImage' /> %0</span>";
Exhibit.OptionWidget.prototype._initializeUI=function(){this._containerElmt.className="exhibit-optionWidget";
this._dom=SimileAjax.DOM.createDOMFromString(this._containerElmt,String.substitute(Exhibit.OptionWidget.uncheckedTemplate+Exhibit.OptionWidget.checkedTemplate,[this._label]),{uncheckedImage:SimileAjax.Graphics.createTranslucentImage(Exhibit.OptionWidget.uncheckedImageURL),checkedImage:SimileAjax.Graphics.createTranslucentImage(Exhibit.OptionWidget.checkedImageURL)});
if(this._checked){this._dom.checkedSpan.style.display="inline";
}else{this._dom.uncheckedSpan.style.display="inline";
}SimileAjax.WindowManager.registerEvent(this._containerElmt,"click",this._onToggle);
};
Exhibit.OptionWidget.prototype.getChecked=function(){return this._checked;
};
Exhibit.OptionWidget.prototype.setChecked=function(A){if(A!=this._checked){this._checked=A;
if(A){this._dom.checkedSpan.style.display="inline";
this._dom.uncheckedSpan.style.display="none";
}else{this._dom.checkedSpan.style.display="none";
this._dom.uncheckedSpan.style.display="inline";
}}};
Exhibit.OptionWidget.prototype.toggle=function(){this.setChecked(!this._checked);
};


/* resizable-div-widget.js */
Exhibit.ResizableDivWidget=function(C,B,A){this._div=B;
this._configuration=C;
if(!("minHeight" in C)){C["minHeight"]=10;
}this._initializeUI();
};
Exhibit.ResizableDivWidget.create=function(C,B,A){return new Exhibit.ResizableDivWidget(C,B,A);
};
Exhibit.ResizableDivWidget.prototype.dispose=function(){this._div.innerHTML="";
this._contentDiv=null;
this._resizerDiv=null;
this._div=null;
};
Exhibit.ResizableDivWidget.prototype.getContentDiv=function(){return this._contentDiv;
};
Exhibit.ResizableDivWidget.prototype._initializeUI=function(){var A=this;
this._div.innerHTML="<div></div><div class='exhibit-resizableDivWidget-resizer'>"+SimileAjax.Graphics.createTranslucentImageHTML(Exhibit.urlPrefix+"images/down-arrow.png")+"</div>";
this._contentDiv=this._div.childNodes[0];
this._resizerDiv=this._div.childNodes[1];
SimileAjax.WindowManager.registerForDragging(this._resizerDiv,{onDragStart:function(){this._height=A._contentDiv.offsetHeight;
},onDragBy:function(C,B){this._height+=B;
A._contentDiv.style.height=Math.max(A._configuration.minHeight,this._height)+"px";
},onDragEnd:function(){if("onResize" in A._configuration){A._configuration["onResize"]();
}}});
};


/* toolbox-widget.js */
Exhibit.ToolboxWidget=function(B,A){this._containerElmt=B;
this._uiContext=A;
this._settings={};
this._customExporters=[];
this._hovering=false;
this._initializeUI();
};
Exhibit.ToolboxWidget._settingSpecs={"itemID":{type:"text"}};
Exhibit.ToolboxWidget.create=function(D,C,A){var B=new Exhibit.ToolboxWidget(C,Exhibit.UIContext.create(D,A));
Exhibit.ToolboxWidget._configure(B,D);
B._initializeUI();
return B;
};
Exhibit.ToolboxWidget.createFromDOM=function(D,C,A){var E=Exhibit.getConfigurationFromDOM(D);
var B=new Exhibit.ToolboxWidget(C!=null?C:D,Exhibit.UIContext.createFromDOM(D,A));
Exhibit.SettingsUtilities.collectSettingsFromDOM(D,Exhibit.ToolboxWidget._settingSpecs,B._settings);
Exhibit.ToolboxWidget._configure(B,E);
B._initializeUI();
return B;
};
Exhibit.ToolboxWidget._configure=function(A,B){Exhibit.SettingsUtilities.collectSettings(B,Exhibit.ToolboxWidget._settingSpecs,A._settings);
};
Exhibit.ToolboxWidget.prototype.dispose=function(){this._containerElmt.onmouseover=null;
this._containerElmt.onmouseout=null;
this._dismiss();
this._settings=null;
this._containerElmt=null;
this._uiContext=null;
};
Exhibit.ToolboxWidget.prototype.addExporter=function(A){this._customExporters.push(A);
};
Exhibit.ToolboxWidget.prototype._initializeUI=function(){var A=this;
this._containerElmt.onmouseover=function(B){A._onContainerMouseOver(B);
};
this._containerElmt.onmouseout=function(B){A._onContainerMouseOut(B);
};
};
Exhibit.ToolboxWidget.prototype._onContainerMouseOver=function(B){if(!this._hovering){var D=this;
var F=SimileAjax.DOM.getPageCoordinates(this._containerElmt);
var E=document.body.offsetWidth;
var C=document.body.offsetHeight;
var A=document.createElement("div");
A.className="exhibit-toolboxWidget-popup screen";
A.style.top=F.top+"px";
A.style.right=(E-F.left-this._containerElmt.offsetWidth)+"px";
this._fillPopup(A);
document.body.appendChild(A);
A.onmouseover=function(G){D._onPopupMouseOver(G);
};
A.onmouseout=function(G){D._onPopupMouseOut(G);
};
this._popup=A;
this._hovering=true;
}else{this._clearTimeout();
}};
Exhibit.ToolboxWidget.prototype._onContainerMouseOut=function(A){if(Exhibit.ToolboxWidget._mouseOutsideElmt(Exhibit.ToolboxWidget._getEvent(A),this._containerElmt)){this._setTimeout();
}};
Exhibit.ToolboxWidget.prototype._onPopupMouseOver=function(A){this._clearTimeout();
};
Exhibit.ToolboxWidget.prototype._onPopupMouseOut=function(A){if(Exhibit.ToolboxWidget._mouseOutsideElmt(Exhibit.ToolboxWidget._getEvent(A),this._containerElmt)){this._setTimeout();
}};
Exhibit.ToolboxWidget.prototype._setTimeout=function(){var A=this;
this._timer=window.setTimeout(function(){A._onTimeout();
},200);
};
Exhibit.ToolboxWidget.prototype._clearTimeout=function(){if(this._timer){window.clearTimeout(this._timer);
this._timer=null;
}};
Exhibit.ToolboxWidget.prototype._onTimeout=function(){this._dismiss();
this._hovering=false;
this._timer=null;
};
Exhibit.ToolboxWidget.prototype._fillPopup=function(B){var A=this;
var C=Exhibit.UI.createTranslucentImage("images/liveclipboard-icon.png");
C.className="exhibit-toolboxWidget-button";
SimileAjax.WindowManager.registerEvent(C,"click",function(E,D,F){A._showExportMenu(C);
});
B.appendChild(C);
};
Exhibit.ToolboxWidget.prototype._dismiss=function(){if(this._popup){document.body.removeChild(this._popup);
this._popup=null;
}};
Exhibit.ToolboxWidget._mouseOutsideElmt=function(A,B){var C=SimileAjax.DOM.getEventPageCoordinates(A);
var D=SimileAjax.DOM.getPageCoordinates(B);
return((C.x<D.left||C.x>D.left+B.offsetWidth)||(C.y<D.top||C.y>D.top+B.offsetHeight));
};
Exhibit.ToolboxWidget._getEvent=function(A){return(A)?A:((event)?event:null);
};
Exhibit.ToolboxWidget.prototype._showExportMenu=function(C){var A=this;
var E=Exhibit.UI.createPopupMenuDom(C);
var D=function(G){E.appendMenuItem(G.getLabel(),null,function(){var H=A._uiContext.getDatabase();
var I=("itemID" in A._settings)?G.exportOne(A._settings.itemID,H):G.exportMany(A._uiContext.getCollection().getRestrictedItems(),H);
Exhibit.ToolboxWidget.createExportDialogBox(I).open();
});
};
var F=Exhibit.getExporters();
for(var B=0;
B<F.length;
B++){D(F[B]);
}for(var B=0;
B<this._customExporters.length;
B++){D(this._customExporters[B]);
}if("getGeneratedHTML" in this){D({getLabel:function(){return Exhibit.l10n.htmlExporterLabel;
},exportOne:this.getGeneratedHTML,exportMany:this.getGeneratedHTML});
}E.open();
};
Exhibit.ToolboxWidget.createExportDialogBox=function(A){var B={tag:"div",className:"exhibit-copyDialog exhibit-ui-protection",children:[{tag:"button",field:"closeButton",children:[Exhibit.l10n.exportDialogBoxCloseButtonLabel]},{tag:"p",children:[Exhibit.l10n.exportDialogBoxPrompt]},{tag:"div",field:"textAreaContainer"}]};
var C=SimileAjax.DOM.createDOMFromTemplate(B);
C.textAreaContainer.innerHTML="<textarea wrap='off' rows='15'>"+A+"</textarea>";
C.close=function(){document.body.removeChild(C.elmt);
};
C.open=function(){C.elmt.style.top=(document.body.scrollTop+100)+"px";
document.body.appendChild(C.elmt);
C.layer=SimileAjax.WindowManager.pushLayer(function(){C.close();
},false);
var D=C.textAreaContainer.firstChild;
D.select();
SimileAjax.WindowManager.registerEvent(C.closeButton,"click",function(F,E,G){SimileAjax.WindowManager.popLayer(C.layer);
},C.layer);
SimileAjax.WindowManager.registerEvent(D,"keyup",function(F,E,G){if(E.keyCode==27){SimileAjax.WindowManager.popLayer(C.layer);
}},C.layer);
};
return C;
};


/* coders.js */
Exhibit.Coders=new Object();
Exhibit.Coders.mixedCaseColor="#fff";
Exhibit.Coders.othersCaseColor="#aaa";
Exhibit.Coders.missingCaseColor="#888";


/* facets.js */
Exhibit.FacetUtilities=new Object();
Exhibit.FacetUtilities.constructFacetFrame=function(G,B,H,F,E,I,C){B.className="exhibit-facet";
var D=SimileAjax.DOM.createDOMFromString(B,"<div class='exhibit-facet-header'><div class='exhibit-facet-header-filterControl' id='clearSelectionsDiv' title='"+Exhibit.FacetUtilities.l10n.clearSelectionsTooltip+"'><span id='filterCountSpan'></span><img id='checkImage' /></div>"+((I)?"<img src='"+Exhibit.urlPrefix+"images/collapse.png' class='exhibit-facet-header-collapse' id='collapseImg' />":"")+"<span class='exhibit-facet-header-title'>"+H+"</span></div><div class='exhibit-facet-body-frame' id='frameDiv'></div>",{checkImage:Exhibit.UI.createTranslucentImage("images/black-check.png")});
var A=Exhibit.ResizableDivWidget.create({},D.frameDiv,E);
D.valuesContainer=A.getContentDiv();
D.valuesContainer.className="exhibit-facet-body";
D.setSelectionCount=function(J){this.filterCountSpan.innerHTML=J;
this.clearSelectionsDiv.style.display=J>0?"block":"none";
};
SimileAjax.WindowManager.registerEvent(D.clearSelectionsDiv,"click",F);
if(I){SimileAjax.WindowManager.registerEvent(D.collapseImg,"click",function(){Exhibit.FacetUtilities.toggleCollapse(D,G);
});
if(C){Exhibit.FacetUtilities.toggleCollapse(D,G);
}}return D;
};
Exhibit.FacetUtilities.toggleCollapse=function(B,C){var A=B.frameDiv;
if(A.style.display!="none"){A.style.display="none";
B.collapseImg.src=Exhibit.urlPrefix+"images/expand.png";
}else{A.style.display="block";
B.collapseImg.src=Exhibit.urlPrefix+"images/collapse.png";
if(typeof C.onUncollapse=="function"){C.onUncollapse();
}}};
Exhibit.FacetUtilities.isCollapsed=function(B){var A=B._dom.frameDiv;
return A.style.display=="none";
};
Exhibit.FacetUtilities.constructFacetItem=function(H,F,B,D,I,G,A,E){if(Exhibit.params.safe){H=Exhibit.Formatter.encodeAngleBrackets(H);
}var C=SimileAjax.DOM.createDOMFromString("div","<div class='exhibit-facet-value-count'>"+F+"</div><div class='exhibit-facet-value-inner' id='inner'>"+("<div class='exhibit-facet-value-checkbox'>&#160;"+SimileAjax.Graphics.createTranslucentImageHTML(Exhibit.urlPrefix+(I?(D?"images/black-check.png":"images/no-check.png"):"images/no-check-no-border.png"))+"</div>")+"<a class='exhibit-facet-value-link' href='javascript:{}' id='link'></a></div>");
C.elmt.className=D?"exhibit-facet-value exhibit-facet-value-selected":"exhibit-facet-value";
if(typeof H=="string"){C.elmt.title=H;
C.link.innerHTML=H;
if(B!=null){C.link.style.color=B;
}}else{C.link.appendChild(H);
if(B!=null){H.style.color=B;
}}SimileAjax.WindowManager.registerEvent(C.elmt,"click",A,SimileAjax.WindowManager.getBaseLayer());
if(I){SimileAjax.WindowManager.registerEvent(C.inner.firstChild,"click",G,SimileAjax.WindowManager.getBaseLayer());
}return C.elmt;
};
Exhibit.FacetUtilities.constructFlowingFacetFrame=function(C,H,E,B,A,D,G){H.className="exhibit-flowingFacet";
var F=SimileAjax.DOM.createDOMFromString(H,"<div class='exhibit-flowingFacet-header'>"+((D)?"<img src='"+Exhibit.urlPrefix+"images/collapse.png' class='exhibit-facet-header-collapse' id='collapseImg' />":"")+"<span class='exhibit-flowingFacet-header-title'>"+E+"</span></div><div id='frameDiv'><div class='exhibit-flowingFacet-body' id='valuesContainer'></div></div>");
F.setSelectionCount=function(I){};
if(D){SimileAjax.WindowManager.registerEvent(F.collapseImg,"click",function(){Exhibit.FacetUtilities.toggleCollapse(F,C);
});
if(G){Exhibit.FacetUtilities.toggleCollapse(F,C);
}}return F;
};
Exhibit.FacetUtilities.constructFlowingFacetItem=function(H,F,B,D,I,G,A,E){if(Exhibit.params.safe){H=Exhibit.Formatter.encodeAngleBrackets(H);
}var C=SimileAjax.DOM.createDOMFromString("div",("<div class='exhibit-flowingFacet-value-checkbox'>"+SimileAjax.Graphics.createTranslucentImageHTML(Exhibit.urlPrefix+(I?(D?"images/black-check.png":"images/no-check.png"):"images/no-check-no-border.png"))+"</div>")+"<a class='exhibit-flowingFacet-value-link' href='javascript:{}' id='inner'></a> <span class='exhibit-flowingFacet-value-count'>("+F+")</span>");
C.elmt.className=D?"exhibit-flowingFacet-value exhibit-flowingFacet-value-selected":"exhibit-flowingFacet-value";
if(typeof H=="string"){C.elmt.title=H;
C.inner.innerHTML=H;
if(B!=null){C.inner.style.color=B;
}}else{C.inner.appendChild(H);
if(B!=null){H.style.color=B;
}}SimileAjax.WindowManager.registerEvent(C.elmt,"click",A,SimileAjax.WindowManager.getBaseLayer());
if(I){SimileAjax.WindowManager.registerEvent(C.elmt.firstChild,"click",G,SimileAjax.WindowManager.getBaseLayer());
}return C.elmt;
};
Exhibit.FacetUtilities.constructHierarchicalFacetItem=function(K,G,B,E,F,H,L,I,A,J,D){if(Exhibit.params.safe){K=Exhibit.Formatter.encodeAngleBrackets(K);
}var C=SimileAjax.DOM.createDOMFromString("div","<div class='exhibit-facet-value-count'>"+G+"</div><div class='exhibit-facet-value-inner' id='inner'>"+("<div class='exhibit-facet-value-checkbox'>&#160;"+SimileAjax.Graphics.createTranslucentImageHTML(Exhibit.urlPrefix+(L?(E?"images/black-check.png":"images/no-check.png"):"images/no-check-no-border.png"))+"</div>")+"<a class='exhibit-facet-value-link' href='javascript:{}' id='link'></a>"+(F?("<a class='exhibit-facet-value-children-toggle' href='javascript:{}' id='toggle'>"+SimileAjax.Graphics.createTranslucentImageHTML(Exhibit.urlPrefix+"images/down-arrow.png")+SimileAjax.Graphics.createTranslucentImageHTML(Exhibit.urlPrefix+"images/right-arrow.png")+"</a>"):"")+"</div>"+(F?"<div class='exhibit-facet-childrenContainer' id='childrenContainer'></div>":""));
C.elmt.className=E?"exhibit-facet-value exhibit-facet-value-selected":"exhibit-facet-value";
if(typeof K=="string"){C.elmt.title=K;
C.link.appendChild(document.createTextNode(K));
if(B!=null){C.link.style.color=B;
}}else{C.link.appendChild(K);
if(B!=null){K.style.color=B;
}}SimileAjax.WindowManager.registerEvent(C.elmt,"click",A,SimileAjax.WindowManager.getBaseLayer());
if(L){SimileAjax.WindowManager.registerEvent(C.inner.firstChild,"click",I,SimileAjax.WindowManager.getBaseLayer());
}if(F){C.showChildren=function(M){C.childrenContainer.style.display=M?"block":"none";
C.toggle.childNodes[0].style.display=M?"inline":"none";
C.toggle.childNodes[1].style.display=M?"none":"inline";
};
SimileAjax.WindowManager.registerEvent(C.toggle,"click",J,SimileAjax.WindowManager.getBaseLayer());
C.showChildren(H);
}return C;
};
Exhibit.FacetUtilities.constructFlowingHierarchicalFacetItem=function(K,G,B,E,F,H,L,I,A,J,D){if(Exhibit.params.safe){K=Exhibit.Formatter.encodeAngleBrackets(K);
}var C=SimileAjax.DOM.createDOMFromString("div",("<div class='exhibit-flowingFacet-value-checkbox'>"+SimileAjax.Graphics.createTranslucentImageHTML(Exhibit.urlPrefix+(L?(E?"images/black-check.png":"images/no-check.png"):"images/no-check-no-border.png"))+"</div>")+"<a class='exhibit-flowingFacet-value-link' href='javascript:{}' id='inner'></a> <span class='exhibit-flowingFacet-value-count'>("+G+")</span>"+(F?("<a class='exhibit-flowingFacet-value-children-toggle' href='javascript:{}' id='toggle'>"+SimileAjax.Graphics.createTranslucentImageHTML(Exhibit.urlPrefix+"images/down-arrow.png")+SimileAjax.Graphics.createTranslucentImageHTML(Exhibit.urlPrefix+"images/right-arrow.png")+"</a>"):"")+(F?"<div class='exhibit-flowingFacet-childrenContainer' id='childrenContainer'></div>":""));
C.elmt.className=E?"exhibit-flowingFacet-value exhibit-flowingFacet-value-selected":"exhibit-flowingFacet-value";
if(typeof K=="string"){C.elmt.title=K;
C.inner.appendChild(document.createTextNode(K));
if(B!=null){C.inner.style.color=B;
}}else{C.inner.appendChild(K);
if(B!=null){K.style.color=B;
}}SimileAjax.WindowManager.registerEvent(C.elmt,"click",A,SimileAjax.WindowManager.getBaseLayer());
if(L){SimileAjax.WindowManager.registerEvent(C.elmt.firstChild,"click",I,SimileAjax.WindowManager.getBaseLayer());
}if(F){C.showChildren=function(M){C.childrenContainer.style.display=M?"block":"none";
C.toggle.childNodes[0].style.display=M?"inline":"none";
C.toggle.childNodes[1].style.display=M?"none":"inline";
};
SimileAjax.WindowManager.registerEvent(C.toggle,"click",J,SimileAjax.WindowManager.getBaseLayer());
C.showChildren(H);
}return C;
};
Exhibit.FacetUtilities.Cache=function(B,D,C){var A=this;
this._database=B;
this._collection=D;
this._expression=C;
this._listener={onRootItemsChanged:function(){if("_itemToValue" in A){delete A._itemToValue;
}if("_valueToItem" in A){delete A._valueToItem;
}if("_missingItems" in A){delete A._missingItems;
}}};
D.addListener(this._listener);
};
Exhibit.FacetUtilities.Cache.prototype.dispose=function(){this._collection.removeListener(this._listener);
this._collection=null;
this._listener=null;
this._itemToValue=null;
this._valueToItem=null;
this._missingItems=null;
};
Exhibit.FacetUtilities.Cache.prototype.getItemsFromValues=function(A,C){var D;
if(this._expression.isPath()){D=this._expression.getPath().walkBackward(A,"item",C,this._database).getSet();
}else{this._buildMaps();
D=new Exhibit.Set();
var B=this._valueToItem;
A.visit(function(G){if(G in B){var H=B[G];
for(var E=0;
E<H.length;
E++){var F=H[E];
if(C.contains(F)){D.add(F);
}}}});
}return D;
};
Exhibit.FacetUtilities.Cache.prototype.getItemsMissingValue=function(C,B){this._buildMaps();
B=B||new Exhibit.Set();
var A=this._missingItems;
C.visit(function(D){if(D in A){B.add(D);
}});
return B;
};
Exhibit.FacetUtilities.Cache.prototype.getValueCountsFromItems=function(F){var D=[];
var I=this._database;
var A="text";
if(this._expression.isPath()){var J=this._expression.getPath();
var B=J.walkForward(F,"item",I);
A=B.valueType;
if(B.size>0){B.forEachValue(function(L){var K=J.evaluateBackward(L,A,F,I);
D.push({value:L,count:K.size});
});
}}else{this._buildMaps();
A=this._valueType;
for(var H in this._valueToItem){var G=this._valueToItem[H];
var E=0;
for(var C=0;
C<G.length;
C++){if(F.contains(G[C])){E++;
}}if(E>0){D.push({value:H,count:E});
}}}return{entries:D,valueType:A};
};
Exhibit.FacetUtilities.Cache.prototype.getValuesFromItems=function(A){if(this._expression.isPath()){return this._expression.getPath().walkForward(A,"item",database).getSet();
}else{this._buildMaps();
var C=new Exhibit.Set();
var B=this._itemToValue;
A.visit(function(F){if(F in B){var D=B[F];
for(var E=0;
E<D.length;
E++){C.add(D[E]);
}}});
return C;
}};
Exhibit.FacetUtilities.Cache.prototype.countItemsMissingValue=function(A){this._buildMaps();
var C=0;
for(var B in this._missingItems){if(A.contains(B)){C++;
}}return C;
};
Exhibit.FacetUtilities.Cache.prototype._buildMaps=function(){if(!("_itemToValue" in this)){var B={};
var C={};
var A={};
var G="text";
var E=function(H,J,I){if(H in I){I[H].push(J);
}else{I[H]=[J];
}};
var F=this._expression;
var D=this._database;
this._collection.getAllItems().visit(function(I){var H=F.evaluateOnItem(I,D);
if(H.values.size()>0){G=H.valueType;
H.values.visit(function(J){E(I,J,B);
E(J,I,C);
});
}else{A[I]=true;
}});
this._itemToValue=B;
this._valueToItem=C;
this._missingItems=A;
this._valueType=G;
}};


/* set.js */
Exhibit.Set=function(A){this._hash={};
this._count=0;
if(A instanceof Array){for(var B=0;
B<A.length;
B++){this.add(A[B]);
}}else{if(A instanceof Exhibit.Set){this.addSet(A);
}}};
Exhibit.Set.prototype.add=function(A){if(!(A in this._hash)){this._hash[A]=true;
this._count++;
return true;
}return false;
};
Exhibit.Set.prototype.addSet=function(B){for(var A in B._hash){this.add(A);
}};
Exhibit.Set.prototype.remove=function(A){if(A in this._hash){delete this._hash[A];
this._count--;
return true;
}return false;
};
Exhibit.Set.prototype.removeSet=function(B){for(var A in B._hash){this.remove(A);
}};
Exhibit.Set.prototype.retainSet=function(B){for(var A in this._hash){if(!B.contains(A)){delete this._hash[A];
this._count--;
}}};
Exhibit.Set.prototype.contains=function(A){return(A in this._hash);
};
Exhibit.Set.prototype.size=function(){return this._count;
};
Exhibit.Set.prototype.toArray=function(){var A=[];
for(var B in this._hash){A.push(B);
}return A;
};
Exhibit.Set.prototype.visit=function(A){for(var B in this._hash){if(A(B)==true){break;
}}};
Exhibit.Set.createIntersection=function(D,C,B){var F=(B)?B:new Exhibit.Set();
var A,E;
if(D.size()<C.size()){A=D;
E=C;
}else{A=C;
E=D;
}A.visit(function(G){if(E.contains(G)){F.add(G);
}});
return F;
};


/* settings.js */
Exhibit.SettingsUtilities=new Object();
Exhibit.SettingsUtilities.collectSettings=function(A,C,B){Exhibit.SettingsUtilities._internalCollectSettings(function(D){return A[D];
},C,B);
};
Exhibit.SettingsUtilities.collectSettingsFromDOM=function(B,C,A){Exhibit.SettingsUtilities._internalCollectSettings(function(D){return Exhibit.getAttribute(B,D);
},C,A);
};
Exhibit.SettingsUtilities._internalCollectSettings=function(G,C,D){for(var K in C){var M=C[K];
var B=K;
if("name" in M){B=M.name;
}if(!(B in D)&&"defaultValue" in M){D[B]=M.defaultValue;
}var L=G(K);
if(L==null){continue;
}if(typeof L=="string"){L=L.trim();
if(L.length==0){continue;
}}var I="text";
if("type" in M){I=M.type;
}var A=1;
if("dimensions" in M){A=M.dimensions;
}try{if(A>1){var F=",";
if("separator" in M){F=M.separator;
}var J=L.split(F);
if(J.length!=A){throw new Error("Expected a tuple of "+A+" dimensions separated with "+F+" but got "+L);
}else{for(var E=0;
E<J.length;
E++){J[E]=Exhibit.SettingsUtilities._parseSetting(J[E].trim(),I,M);
}D[B]=J;
}}else{D[B]=Exhibit.SettingsUtilities._parseSetting(L,I,M);
}}catch(H){SimileAjax.Debug.exception(H);
}}};
Exhibit.SettingsUtilities._parseSetting=function(s,type,spec){var sType=typeof s;
if(type=="text"){return s;
}else{if(type=="float"){if(sType=="number"){return s;
}else{if(sType=="string"){var f=parseFloat(s);
if(!isNaN(f)){return f;
}}}throw new Error("Expected a floating point number but got "+s);
}else{if(type=="int"){if(sType=="number"){return Math.round(s);
}else{if(sType=="string"){var n=parseInt(s);
if(!isNaN(n)){return n;
}}}throw new Error("Expected an integer but got "+s);
}else{if(type=="boolean"){if(sType=="boolean"){return s;
}else{if(sType=="string"){s=s.toLowerCase();
if(s=="true"){return true;
}else{if(s=="false"){return false;
}}}}throw new Error("Expected either 'true' or 'false' but got "+s);
}else{if(type=="function"){if(sType=="function"){return s;
}else{if(sType=="string"){try{var f=eval(s);
if(typeof f=="function"){return f;
}}catch(e){}}}throw new Error("Expected a function or the name of a function but got "+s);
}else{if(type=="enum"){var choices=spec.choices;
for(var i=0;
i<choices.length;
i++){if(choices[i]==s){return s;
}}throw new Error("Expected one of "+choices.join(", ")+" but got "+s);
}else{throw new Error("Unknown setting type "+type);
}}}}}}};
Exhibit.SettingsUtilities.createAccessors=function(B,C,A){Exhibit.SettingsUtilities._internalCreateAccessors(function(D){return B[D];
},C,A);
};
Exhibit.SettingsUtilities.createAccessorsFromDOM=function(B,C,A){Exhibit.SettingsUtilities._internalCreateAccessors(function(D){return Exhibit.getAttribute(B,D);
},C,A);
};
Exhibit.SettingsUtilities._internalCreateAccessors=function(F,B,E){for(var I in B){var K=B[I];
var G=K.accessorName;
var D=null;
var H=false;
var J=function(L){H=false;
if("bindings" in L){return Exhibit.SettingsUtilities._createBindingsAccessor(F,L.bindings);
}else{if("bindingNames" in L){H=true;
return Exhibit.SettingsUtilities._createTupleAccessor(F,L);
}else{return Exhibit.SettingsUtilities._createElementalAccessor(F,L);
}}};
if("alternatives" in K){var A=K.alternatives;
for(var C=0;
C<A.length;
C++){D=J(A[C]);
if(D!=null){break;
}}}else{D=J(K);
}if(D!=null){E[G]=D;
}else{if(!(G in E)){E[G]=function(N,M,L){};
}}}};
Exhibit.SettingsUtilities._createBindingsAccessor=function(F,C){var G=[];
for(var E=0;
E<C.length;
E++){var D=C[E];
var A=null;
var B=false;
if("bindingNames" in D){B=true;
A=Exhibit.SettingsUtilities._createTupleAccessor(F,D);
}else{A=Exhibit.SettingsUtilities._createElementalAccessor(F,D);
}if(A==null){if(!("optional" in D)||!D.optional){return null;
}}else{G.push({bindingName:D.bindingName,accessor:A,isTuple:B});
}}return function(J,I,H){Exhibit.SettingsUtilities._evaluateBindings(J,I,H,G);
};
};
Exhibit.SettingsUtilities._createTupleAccessor=function(E,J){var H=E(J.attributeName);
if(H==null){return null;
}if(typeof H=="string"){H=H.trim();
if(H.length==0){return null;
}}try{var G=Exhibit.ExpressionParser.parse(H);
var I=[];
var A=J.types;
for(var B=0;
B<A.length;
B++){I.push(Exhibit.SettingsUtilities._typeToParser(A[B]));
}var D=J.bindingNames;
var C=",";
if("separator" in J){C=J.separator;
}return function(N,M,L,K){G.evaluateOnItem(N,M).values.visit(function(P){var O=P.split(C);
if(O.length==I.length){var R={};
if(K){for(var S in K){R[S]=K[S];
}}for(var Q=0;
Q<D.length;
Q++){R[D[Q]]=null;
I[Q](O[Q],function(T){R[D[Q]]=T;
});
}L(R);
}});
};
}catch(F){SimileAjax.Debug.exception(F);
return null;
}};
Exhibit.SettingsUtilities._createElementalAccessor=function(D,A){var C=D(A.attributeName);
if(C==null){return null;
}if(typeof C=="string"){C=C.trim();
if(C.length==0){return null;
}}var B="text";
if("type" in A){B=A.type;
}try{var F=Exhibit.ExpressionParser.parse(C);
var G=Exhibit.SettingsUtilities._typeToParser(B);
return function(J,I,H){F.evaluateOnItem(J,I).values.visit(function(K){return G(K,H);
});
};
}catch(E){SimileAjax.Debug.exception(E);
return null;
}};
Exhibit.SettingsUtilities._typeToParser=function(A){switch(A){case"text":return Exhibit.SettingsUtilities._textParser;
case"url":return Exhibit.SettingsUtilities._urlParser;
case"float":return Exhibit.SettingsUtilities._floatParser;
case"int":return Exhibit.SettingsUtilities._intParser;
case"date":return Exhibit.SettingsUtilities._dateParser;
case"boolean":return Exhibit.SettingsUtilities._booleanParser;
default:throw new Error("Unknown setting type "+A);
}};
Exhibit.SettingsUtilities._textParser=function(A,B){return B(A);
};
Exhibit.SettingsUtilities._floatParser=function(A,B){var C=parseFloat(A);
if(!isNaN(C)){return B(C);
}return false;
};
Exhibit.SettingsUtilities._intParser=function(A,B){var C=parseInt(A);
if(!isNaN(C)){return B(C);
}return false;
};
Exhibit.SettingsUtilities._dateParser=function(A,B){if(A instanceof Date){return B(A);
}else{if(typeof A=="number"){var C=new Date(0);
C.setUTCFullYear(A);
return B(C);
}else{var C=SimileAjax.DateTime.parseIso8601DateTime(A.toString());
if(C!=null){return B(C);
}}}return false;
};
Exhibit.SettingsUtilities._booleanParser=function(A,B){A=A.toString().toLowerCase();
if(A=="true"){return B(true);
}else{if(A=="false"){return B(false);
}}return false;
};
Exhibit.SettingsUtilities._urlParser=function(A,B){return B(Exhibit.Persistence.resolveURL(A.toString()));
};
Exhibit.SettingsUtilities._evaluateBindings=function(E,D,C,F){var A=F.length-1;
var B=function(G,I){var L=F[I];
var H=false;
var K=I==A?function(){C(G);
}:function(){B(G,I+1);
};
if(L.isTuple){L.accessor(E,D,function(M){H=true;
G=M;
K();
},G);
}else{var J=L.bindingName;
L.accessor(E,D,function(M){H=true;
G[J]=M;
K();
});
}if(!H){K();
}};
B({},0);
};


/* util.js */
Exhibit.Util={};
Exhibit.Util.round=function(D,A){A=A||1;
var B=Math.floor(Math.log(A)/Math.log(10));
D=(Math.round(D/A)*A).toString();
var C=D.split(".");
if(B>=0){return C[0];
}B=-B;
C[1]=(C[1]||"").substring(0,B);
while(C[1].length<B){C[1]+="0";
}return C.join(".");
};
if(!Array.prototype.indexOf){Array.prototype.indexOf=function(B){var A=this.length;
var C=Number(arguments[1])||0;
C=(C<0)?Math.ceil(C):Math.floor(C);
if(C<0){C+=A;
}for(;
C<A;
C++){if(C in this&&this[C]===B){return C;
}}return -1;
};
}if(!Array.prototype.filter){Array.prototype.filter=function(B){var A=this.length;
if(typeof B!="function"){throw new TypeError();
}var E=new Array();
var D=arguments[1];
for(var C=0;
C<A;
C++){if(C in this){var F=this[C];
if(B.call(D,F,C,this)){E.push(F);
}}}return E;
};
}if(!Array.prototype.map){Array.prototype.map=function(E,C){if(typeof E!="function"){throw new TypeError();
}if(typeof C=="undefined"){C=this;
}var B=[],D=this.length;
for(var A=0;
A<D;
A++){if(this.hasOwnProperty(A)){B[A]=E.call(C,this[A],A,this);
}}return B;
};
}if(!Array.prototype.forEach){Array.prototype.forEach=function(B){var A=this.length;
if(typeof B!="function"){throw new TypeError();
}var D=arguments[1];
for(var C=0;
C<A;
C++){if(C in this){B.call(D,this[C],C,this);
}}};
}

/* views.js */
Exhibit.ViewUtilities=new Object();
Exhibit.ViewUtilities.openBubbleForItems=function(B,D,C){var E=SimileAjax.DOM.getPageCoordinates(B);
var A=SimileAjax.Graphics.createBubbleForPoint(E.left+Math.round(B.offsetWidth/2),E.top+Math.round(B.offsetHeight/2),C.getSetting("bubbleWidth"),C.getSetting("bubbleHeight"));
Exhibit.ViewUtilities.fillBubbleWithItems(A.content,D,C);
};
Exhibit.ViewUtilities.fillBubbleWithItems=function(F,C,B){if(F==null){F=document.createElement("div");
}if(C.length>1){F.className=[F.className,"exhibit-views-bubbleWithItems"].join(" ");
var E=document.createElement("ul");
for(var D=0;
D<C.length;
D++){B.format(C[D],"item",function(I){var H=document.createElement("li");
H.appendChild(I);
E.appendChild(H);
});
}F.appendChild(E);
}else{var A=document.createElement("div");
var G=B.getLensRegistry().createLens(C[0],A,B);
F.appendChild(A);
}return F;
};
Exhibit.ViewUtilities.constructPlottingViewDom=function(F,A,D,B,C){var E=SimileAjax.DOM.createDOMFromString(F,"<div class='exhibit-views-header'>"+(D?"<div id='collectionSummaryDiv'></div>":"")+"<div id='unplottableMessageDiv' class='exhibit-views-unplottableMessage'></div></div><div id='resizableDiv'></div><div id='legendDiv'></div>",{});
if(D){E.collectionSummaryWidget=Exhibit.CollectionSummaryWidget.create({},E.collectionSummaryDiv,A);
}E.resizableDivWidget=Exhibit.ResizableDivWidget.create(B,E.resizableDiv,A);
E.plotContainer=E.resizableDivWidget.getContentDiv();
if(C.colorGradient==true){E.legendGradientWidget=Exhibit.LegendGradientWidget.create(E.legendDiv,A);
}else{E.legendWidget=Exhibit.LegendWidget.create(C,E.legendDiv,A);
}E.setUnplottableMessage=function(H,G){Exhibit.ViewUtilities._setUnplottableMessage(E,H,G,A);
};
E.dispose=function(){if(D){E.collectionSummaryWidget.dispose();
}E.resizableDivWidget.dispose();
E.legendWidget.dispose();
};
return E;
};
Exhibit.ViewUtilities._setUnplottableMessage=function(D,B,A,C){var E=D.unplottableMessageDiv;
if(A.length==0){E.style.display="none";
}else{E.innerHTML="";
var D=SimileAjax.DOM.createDOMFromString(E,Exhibit.ViewUtilities.l10n.unplottableMessageFormatter(B,A,C),{});
SimileAjax.WindowManager.registerEvent(D.unplottableCountLink,"click",function(G,F,H){Exhibit.ViewUtilities.openBubbleForItems(G,A,C);
});
E.style.display="block";
}};
