# -*- coding: utf-8 -*-
#
# This file is part of SENAITE.HEALTH
#
# Copyright 2018 by it's authors.
# Some rights reserved. See LICENSE.rst, CONTRIBUTORS.rst.

"""ICD9-CM code list
AB: 001 to 139: Infectious disease/Infection: Bacterial disease, Virus disease, Parasitic disease, Mycosis, Zoonosis
CD: 140 to 239: Cancer, Tumor, Myeloid hematologic, Lymphoid immune
CD: 279 to 289: Cancer, Tumor, Myeloid hematologic, Lymphoid immune
E: 240 to 278: Endocrine disease, Nutrition disorder, Inborn error of metabolism
F: 290 to 319: Mental disorder
G: 320 to 359: Nervous system disease (CNS, PNS), Neuromuscular disease
H: 360 to 389: Eye disease, Ear disease
I: 390 to 459: Cardiovascular disease
J: 460 to 519: Respiratory disease
K: 520 to 579: Stomatognathic disease (Tooth disease), Digestive disease (Esophageal, Stomach, Enteropathy, Liver, Pancreatic)
L: 680 to 709: Skin disease, skin appendages (Nail disease, Hair disease, Sweat gland disease)
M: 710 to 739: Musculoskeletal disorders: Myopathy, Arthropathy, Osteochondropathy (Osteopathy, Chondropathy)
N: 580 to 629: Urologic disease (Nephropathy, Urinary bladder disease), Male genital disease, Breast disease, Female genital disease
O: 630 to 679: Complications of pregnancy, Obstetric labor complication, Puerperal disorder
P: 760 to 779: Fetal disease
Q: 740 to 759: Congenital disorder (Congenital abnormality)
R: 780 to 799: Syndromes, Medical signs (Eponymous)
ST: 800 to 999: Bone fracture, Joint dislocation, Sprain, Strain, Subluxation, Head injury, Chest trauma, Poisoning

E and V codes are not included
"""

from bika.lims.browser import BrowserView
import json
import plone

icd9_codes = \
{'AB': [{'code': '001.0',
         'long': 'Cholera due to vibrio cholerae',
         'short': 'Cholera d/t vib cholerae'},
        {'code': '001.1',
         'long': 'Cholera due to vibrio cholerae el tor',
         'short': 'Cholera d/t vib el tor'},
        {'code': '001.9',
         'long': 'Cholera, unspecified',
         'short': 'Cholera NOS'},
        {'code': '002.0', 'long': 'Typhoid fever', 'short': 'Typhoid fever'},
        {'code': '002.1',
         'long': 'Paratyphoid fever A',
         'short': 'Paratyphoid fever a'},
        {'code': '002.2',
         'long': 'Paratyphoid fever B',
         'short': 'Paratyphoid fever b'},
        {'code': '002.3',
         'long': 'Paratyphoid fever C',
         'short': 'Paratyphoid fever c'},
        {'code': '002.9',
         'long': 'Paratyphoid fever, unspecified',
         'short': 'Paratyphoid fever NOS'},
        {'code': '003.0',
         'long': 'Salmonella gastroenteritis',
         'short': 'Salmonella enteritis'},
        {'code': '003.1',
         'long': 'Salmonella septicemia',
         'short': 'Salmonella septicemia'},
        {'code': '003.20',
         'long': 'Localized salmonella infection, unspecified',
         'short': 'Local salmonella inf NOS'},
        {'code': '003.21',
         'long': 'Salmonella meningitis',
         'short': 'Salmonella meningitis'},
        {'code': '003.22',
         'long': 'Salmonella pneumonia',
         'short': 'Salmonella pneumonia'},
        {'code': '003.23',
         'long': 'Salmonella arthritis',
         'short': 'Salmonella arthritis'},
        {'code': '003.24',
         'long': 'Salmonella osteomyelitis',
         'short': 'Salmonella osteomyelitis'},
        {'code': '003.29',
         'long': 'Other localized salmonella infections',
         'short': 'Local salmonella inf NEC'},
        {'code': '003.8',
         'long': 'Other specified salmonella infections',
         'short': 'Salmonella infection NEC'},
        {'code': '003.9',
         'long': 'Salmonella infection, unspecified',
         'short': 'Salmonella infection NOS'},
        {'code': '004.0',
         'long': 'Shigella dysenteriae',
         'short': 'Shigella dysenteriae'},
        {'code': '004.1',
         'long': 'Shigella flexneri',
         'short': 'Shigella flexneri'},
        {'code': '004.2',
         'long': 'Shigella boydii',
         'short': 'Shigella boydii'},
        {'code': '004.3',
         'long': 'Shigella sonnei',
         'short': 'Shigella sonnei'},
        {'code': '004.8',
         'long': 'Other specified shigella infections',
         'short': 'Shigella infection NEC'},
        {'code': '004.9',
         'long': 'Shigellosis, unspecified',
         'short': 'Shigellosis NOS'},
        {'code': '005.0',
         'long': 'Staphylococcal food poisoning',
         'short': 'Staph food poisoning'},
        {'code': '005.1',
         'long': 'Botulism food poisoning',
         'short': 'Botulism food poisoning'},
        {'code': '005.2',
         'long': 'Food poisoning due to Clostridium perfringens (C. welchii)',
         'short': 'Food pois d/t c. perfrin'},
        {'code': '005.3',
         'long': 'Food poisoning due to other Clostridia',
         'short': 'Food pois: clostrid NEC'},
        {'code': '005.4',
         'long': 'Food poisoning due to Vibrio parahaemolyticus',
         'short': 'Food pois: v. parahaem'},
        {'code': '005.81',
         'long': 'Food poisoning due to Vibrio vulnificus',
         'short': 'Food poisn d/t v. vulnif'},
        {'code': '005.89',
         'long': 'Other bacterial food poisoning',
         'short': 'Bact food poisoning NEC'},
        {'code': '005.9',
         'long': 'Food poisoning, unspecified',
         'short': 'Food poisoning NOS'},
        {'code': '006.0',
         'long': 'Acute amebic dysentery without mention of abscess',
         'short': 'Ac amebiasis w/o abscess'},
        {'code': '006.1',
         'long': 'Chronic intestinal amebiasis without mention of abscess',
         'short': 'Chr amebiasis w/o absces'},
        {'code': '006.2',
         'long': 'Amebic nondysenteric colitis',
         'short': 'Amebic nondysent colitis'},
        {'code': '006.3',
         'long': 'Amebic liver abscess',
         'short': 'Amebic liver abscess'},
        {'code': '006.4',
         'long': 'Amebic lung abscess',
         'short': 'Amebic lung abscess'},
        {'code': '006.5',
         'long': 'Amebic brain abscess',
         'short': 'Amebic brain abscess'},
        {'code': '006.6',
         'long': 'Amebic skin ulceration',
         'short': 'Amebic skin ulceration'},
        {'code': '006.8',
         'long': 'Amebic infection of other sites',
         'short': 'Amebic infection NEC'},
        {'code': '006.9',
         'long': 'Amebiasis, unspecified',
         'short': 'Amebiasis NOS'},
        {'code': '007.0', 'long': 'Balantidiasis', 'short': 'Balantidiasis'},
        {'code': '007.1', 'long': 'Giardiasis', 'short': 'Giardiasis'},
        {'code': '007.2', 'long': 'Coccidiosis', 'short': 'Coccidiosis'},
        {'code': '007.3',
         'long': 'Intestinal trichomoniasis',
         'short': 'Intest trichomoniasis'},
        {'code': '007.4',
         'long': 'Cryptosporidiosis',
         'short': 'Cryptosporidiosis'},
        {'code': '007.5',
         'long': 'Cyclosporiasis',
         'short': 'Cyclosporiasis'},
        {'code': '007.8',
         'long': 'Other specified protozoal intestinal diseases',
         'short': 'Protozoal intest dis NEC'},
        {'code': '007.9',
         'long': 'Unspecified protozoal intestinal disease',
         'short': 'Protozoal intest dis NOS'},
        {'code': '008.00',
         'long': 'Intestinal infection due to E. coli, unspecified',
         'short': 'Intest infec e coli NOS'},
        {'code': '008.01',
         'long': 'Intestinal infection due to enteropathogenic E. coli',
         'short': 'Int inf e coli entrpath'},
        {'code': '008.02',
         'long': 'Intestinal infection due to enterotoxigenic E. coli',
         'short': 'Int inf e coli entrtoxgn'},
        {'code': '008.03',
         'long': 'Intestinal infection due to enteroinvasive E. coli',
         'short': 'Int inf e coli entrnvsv'},
        {'code': '008.04',
         'long': 'Intestinal infection due to enterohemorrhagic E. coli',
         'short': 'Int inf e coli entrhmrg'},
        {'code': '008.09',
         'long': 'Intestinal infection due to other intestinal E. coli infections',
         'short': 'Int inf e coli spcf NEC'},
        {'code': '008.1',
         'long': 'Intestinal infection due to arizona group of paracolon bacilli',
         'short': 'Arizona enteritis'},
        {'code': '008.2',
         'long': 'Intestinal infection due to aerobacter aerogenes',
         'short': 'Aerobacter enteritis'},
        {'code': '008.3',
         'long': 'Intestinal infection due to proteus (mirabilis) (morganii)',
         'short': 'Proteus enteritis'},
        {'code': '008.41',
         'long': 'Intestinal infection due to staphylococcus',
         'short': 'Staphylococc enteritis'},
        {'code': '008.42',
         'long': 'Intestinal infection due to pseudomonas',
         'short': 'Pseudomonas enteritis'},
        {'code': '008.43',
         'long': 'Intestinal infection due to campylobacter',
         'short': 'Int infec campylobacter'},
        {'code': '008.44',
         'long': 'Intestinal infection due to yersinia enterocolitica',
         'short': 'Int inf yrsnia entrcltca'},
        {'code': '008.45',
         'long': 'Intestinal infection due to Clostridium difficile',
         'short': 'Int inf clstrdium dfcile'},
        {'code': '008.46',
         'long': 'Intestinal infection due to other anaerobes',
         'short': 'Intes infec oth anerobes'},
        {'code': '008.47',
         'long': 'Intestinal infection due to other gram-negative bacteria',
         'short': 'Int inf oth grm neg bctr'},
        {'code': '008.49',
         'long': 'Intestinal infection due to other organisms',
         'short': 'Bacterial enteritis NEC'},
        {'code': '008.5',
         'long': 'Bacterial enteritis, unspecified',
         'short': 'Bacterial enteritis NOS'},
        {'code': '008.61',
         'long': 'Enteritis due to rotavirus',
         'short': 'Intes infec rotavirus'},
        {'code': '008.62',
         'long': 'Enteritis due to adenovirus',
         'short': 'Intes infec adenovirus'},
        {'code': '008.63',
         'long': 'Enteritis due to norwalk virus',
         'short': 'Int inf norwalk virus'},
        {'code': '008.64',
         'long': "Enteritis due to other small round viruses [SRV's]",
         'short': 'Int inf oth sml rnd vrus'},
        {'code': '008.65',
         'long': 'Enteritis due to calicivirus',
         'short': 'Enteritis d/t calicivirs'},
        {'code': '008.66',
         'long': 'Enteritis due to astrovirus',
         'short': 'Intes infec astrovirus'},
        {'code': '008.67',
         'long': 'Enteritis due to enterovirus nec',
         'short': 'Int inf enterovirus NEC'},
        {'code': '008.69',
         'long': 'Enteritis due to other viral enteritis',
         'short': 'Other viral intes infec'},
        {'code': '008.8',
         'long': 'Intestinal infection due to other organism, not elsewhere classified',
         'short': 'Viral enteritis NOS'},
        {'code': '009.0',
         'long': 'Infectious colitis, enteritis, and gastroenteritis',
         'short': 'Infectious enteritis NOS'},
        {'code': '009.1',
         'long': 'Colitis, enteritis, and gastroenteritis of presumed infectious origin',
         'short': 'Enteritis of infect orig'},
        {'code': '009.2',
         'long': 'Infectious diarrhea',
         'short': 'Infectious diarrhea NOS'},
        {'code': '009.3',
         'long': 'Diarrhea of presumed infectious origin',
         'short': 'Diarrhea of infect orig'},
        {'code': '010.00',
         'long': 'Primary tuberculous infection, unspecified',
         'short': 'Prim TB complex-unspec'},
        {'code': '010.01',
         'long': 'Primary tuberculous infection, bacteriological or histological examination not done',
         'short': 'Prim TB complex-no exam'},
        {'code': '010.02',
         'long': 'Primary tuberculous infection, bacteriological or histological examination unknown (at present)',
         'short': 'Prim TB complex-exm unkn'},
        {'code': '010.03',
         'long': 'Primary tuberculous infection, tubercle bacilli found (in sputum) by microscopy',
         'short': 'Prim TB complex-micro dx'},
        {'code': '010.04',
         'long': 'Primary tuberculous infection, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'Prim TB complex-cult dx'},
        {'code': '010.05',
         'long': 'Primary tuberculous infection, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'Prim TB complex-histo dx'},
        {'code': '010.06',
         'long': 'Primary tuberculous infection, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'Prim TB complex-oth test'},
        {'code': '010.10',
         'long': 'Tuberculous pleurisy in primary progressive tuberculosis, unspecified',
         'short': 'Prim TB pleurisy-unspec'},
        {'code': '010.11',
         'long': 'Tuberculous pleurisy in primary progressive tuberculosis, bacteriological or histological examination not done',
         'short': 'Prim TB pleurisy-no exam'},
        {'code': '010.12',
         'long': 'Tuberculous pleurisy in primary progressive tuberculosis, bacteriological or histological examination unknown (at present)',
         'short': 'Prim TB pleur-exam unkn'},
        {'code': '010.13',
         'long': 'Tuberculous pleurisy in primary progressive tuberculosis, tubercle bacilli found (in sputum) by microscopy',
         'short': 'Prim TB pleuris-micro dx'},
        {'code': '010.14',
         'long': 'Tuberculous pleurisy in primary progressive tuberculosis, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'Prim TB pleurisy-cult dx'},
        {'code': '010.15',
         'long': 'Tuberculous pleurisy in primary progressive tuberculosis, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'Prim TB pleuris-histo dx'},
        {'code': '010.16',
         'long': 'Tuberculous pleurisy in primary progressive tuberculosis, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'Prim TB pleuris-oth test'},
        {'code': '010.80',
         'long': 'Other primary progressive tuberculosis, unspecified',
         'short': 'Prim prog TB NEC-unspec'},
        {'code': '010.81',
         'long': 'Other primary progressive tuberculosis, bacteriological or histological examination not done',
         'short': 'Prim prog TB NEC-no exam'},
        {'code': '010.82',
         'long': 'Other primary progressive tuberculosis, bacteriological or histological examination unknown (at present)',
         'short': 'Prim pr TB NEC-exam unkn'},
        {'code': '010.83',
         'long': 'Other primary progressive tuberculosis, tubercle bacilli found (in sputum) by microscopy',
         'short': 'Prim prg TB NEC-micro dx'},
        {'code': '010.84',
         'long': 'Other primary progressive tuberculosis, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'Prim prog TB NEC-cult dx'},
        {'code': '010.85',
         'long': 'Other primary progressive tuberculosis, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'Prim prg TB NEC-histo dx'},
        {'code': '010.86',
         'long': 'Other primary progressive tuberculosis, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'Prim prg TB NEC-oth test'},
        {'code': '010.90',
         'long': 'Primary tuberculous infection, unspecified, unspecified',
         'short': 'Primary TB NOS-unspec'},
        {'code': '010.91',
         'long': 'Primary tuberculous infection, unspecified, bacteriological or histological examination not done',
         'short': 'Primary TB NOS-no exam'},
        {'code': '010.92',
         'long': 'Primary tuberculous infection, unspecified, bacteriological or histological examination unknown (at present)',
         'short': 'Primary TB NOS-exam unkn'},
        {'code': '010.93',
         'long': 'Primary tuberculous infection, unspecified, tubercle bacilli found (in sputum) by microscopy',
         'short': 'Primary TB NOS-micro dx'},
        {'code': '010.94',
         'long': 'Primary tuberculous infection, unspecified, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'Primary TB NOS-cult dx'},
        {'code': '010.95',
         'long': 'Primary tuberculous infection, unspecified, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'Primary TB NOS-histo dx'},
        {'code': '010.96',
         'long': 'Primary tuberculous infection, unspecified, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'Primary TB NOS-oth test'},
        {'code': '011.00',
         'long': 'Tuberculosis of lung, infiltrative, unspecified',
         'short': 'TB lung infiltr-unspec'},
        {'code': '011.01',
         'long': 'Tuberculosis of lung, infiltrative, bacteriological or histological examination not done',
         'short': 'TB lung infiltr-no exam'},
        {'code': '011.02',
         'long': 'Tuberculosis of lung, infiltrative, bacteriological or histological examination unknown (at present)',
         'short': 'TB lung infiltr-exm unkn'},
        {'code': '011.03',
         'long': 'Tuberculosis of lung, infiltrative, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB lung infiltr-micro dx'},
        {'code': '011.04',
         'long': 'Tuberculosis of lung, infiltrative, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB lung infiltr-cult dx'},
        {'code': '011.05',
         'long': 'Tuberculosis of lung, infiltrative, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB lung infiltr-histo dx'},
        {'code': '011.06',
         'long': 'Tuberculosis of lung, infiltrative, tubercle bacilli not found bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB lung infiltr-oth test'},
        {'code': '011.10',
         'long': 'Tuberculosis of lung, nodular, unspecified',
         'short': 'TB lung nodular-unspec'},
        {'code': '011.11',
         'long': 'Tuberculosis of lung, nodular, bacteriological or histological examination not done',
         'short': 'TB lung nodular-no exam'},
        {'code': '011.12',
         'long': 'Tuberculosis of lung, nodular, bacteriological or histological examination unknown (at present)',
         'short': 'TB lung nodul-exam unkn'},
        {'code': '011.13',
         'long': 'Tuberculosis of lung, nodular, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB lung nodular-micro dx'},
        {'code': '011.14',
         'long': 'Tuberculosis of lung, nodular, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB lung nodular-cult dx'},
        {'code': '011.15',
         'long': 'Tuberculosis of lung, nodular, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB lung nodular-histo dx'},
        {'code': '011.16',
         'long': 'Tuberculosis of lung, nodular, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB lung nodular-oth test'},
        {'code': '011.20',
         'long': 'Tuberculosis of lung with cavitation, unspecified',
         'short': 'TB lung w cavity-unspec'},
        {'code': '011.21',
         'long': 'Tuberculosis of lung with cavitation, bacteriological or histological examination not done',
         'short': 'TB lung w cavity-no exam'},
        {'code': '011.22',
         'long': 'Tuberculosis of lung with cavitation, bacteriological or histological examination unknown (at present)',
         'short': 'TB lung cavity-exam unkn'},
        {'code': '011.23',
         'long': 'Tuberculosis of lung with cavitation, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB lung w cavit-micro dx'},
        {'code': '011.24',
         'long': 'Tuberculosis of lung with cavitation, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB lung w cavity-cult dx'},
        {'code': '011.25',
         'long': 'Tuberculosis of lung with cavitation, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB lung w cavit-histo dx'},
        {'code': '011.26',
         'long': 'Tuberculosis of lung with cavitation, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB lung w cavit-oth test'},
        {'code': '011.30',
         'long': 'Tuberculosis of bronchus, unspecified',
         'short': 'TB of bronchus-unspec'},
        {'code': '011.31',
         'long': 'Tuberculosis of bronchus, bacteriological or histological examination not done',
         'short': 'TB of bronchus-no exam'},
        {'code': '011.32',
         'long': 'Tuberculosis of bronchus, bacteriological or histological examination unknown (at present)',
         'short': 'TB of bronchus-exam unkn'},
        {'code': '011.33',
         'long': 'Tuberculosis of bronchus, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB of bronchus-micro dx'},
        {'code': '011.34',
         'long': 'Tuberculosis of bronchus, tubercle bacilli not found (in sputum) by microscopy, but found in bacterial culture',
         'short': 'TB of bronchus-cult dx'},
        {'code': '011.35',
         'long': 'Tuberculosis of bronchus, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB of bronchus-histo dx'},
        {'code': '011.36',
         'long': 'Tuberculosis of bronchus, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB of bronchus-oth test'},
        {'code': '011.40',
         'long': 'Tuberculous fibrosis of lung, unspecified',
         'short': 'TB lung fibrosis-unspec'},
        {'code': '011.41',
         'long': 'Tuberculous fibrosis of lung, bacteriological or histological examination not done',
         'short': 'TB lung fibrosis-no exam'},
        {'code': '011.42',
         'long': 'Tuberculous fibrosis of lung, bacteriological or histological examination unknown (at present)',
         'short': 'TB lung fibros-exam unkn'},
        {'code': '011.43',
         'long': 'Tuberculous fibrosis of lung, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB lung fibros-micro dx'},
        {'code': '011.44',
         'long': 'Tuberculous fibrosis of lung, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB lung fibrosis-cult dx'},
        {'code': '011.45',
         'long': 'Tuberculous fibrosis of lung, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB lung fibros-histo dx'},
        {'code': '011.46',
         'long': 'Tuberculous fibrosis of lung, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB lung fibros-oth test'},
        {'code': '011.50',
         'long': 'Tuberculous bronchiectasis, unspecified',
         'short': 'TB bronchiectasis-unspec'},
        {'code': '011.51',
         'long': 'Tuberculous bronchiectasis, bacteriological or histological examination not done',
         'short': 'TB bronchiect-no exam'},
        {'code': '011.52',
         'long': 'Tuberculous bronchiectasis, bacteriological or histological examination unknown (at present)',
         'short': 'TB bronchiect-exam unkn'},
        {'code': '011.53',
         'long': 'Tuberculous bronchiectasis, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB bronchiect-micro dx'},
        {'code': '011.54',
         'long': 'Tuberculous bronchiectasis, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB bronchiect-cult dx'},
        {'code': '011.55',
         'long': 'Tuberculous bronchiectasis, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB bronchiect-histo dx'},
        {'code': '011.56',
         'long': 'Tuberculous bronchiectasis, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB bronchiect-oth test'},
        {'code': '011.60',
         'long': 'Tuberculous pneumonia [any form], unspecified',
         'short': 'TB pneumonia-unspec'},
        {'code': '011.61',
         'long': 'Tuberculous pneumonia [any form], bacteriological or histological examination not done',
         'short': 'TB pneumonia-no exam'},
        {'code': '011.62',
         'long': 'Tuberculous pneumonia [any form], bacteriological or histological examination unknown (at present)',
         'short': 'TB pneumonia-exam unkn'},
        {'code': '011.63',
         'long': 'Tuberculous pneumonia [any form], tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB pneumonia-micro dx'},
        {'code': '011.64',
         'long': 'Tuberculous pneumonia [any form], tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB pneumonia-cult dx'},
        {'code': '011.65',
         'long': 'Tuberculous pneumonia [any form], tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB pneumonia-histo dx'},
        {'code': '011.66',
         'long': 'Tuberculous pneumonia [any form], tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB pneumonia-oth test'},
        {'code': '011.70',
         'long': 'Tuberculous pneumothorax, unspecified',
         'short': 'TB pneumothorax-unspec'},
        {'code': '011.71',
         'long': 'Tuberculous pneumothorax, bacteriological or histological examination not done',
         'short': 'TB pneumothorax-no exam'},
        {'code': '011.72',
         'long': 'Tuberculous pneumothorax, bacteriological or histological examination unknown (at present)',
         'short': 'TB pneumothorx-exam unkn'},
        {'code': '011.73',
         'long': 'Tuberculous pneumothorax, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB pneumothorax-micro dx'},
        {'code': '011.74',
         'long': 'Tuberculous pneumothorax, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB pneumothorax-cult dx'},
        {'code': '011.75',
         'long': 'Tuberculous pneumothorax, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB pneumothorax-histo dx'},
        {'code': '011.76',
         'long': 'Tuberculous pneumothorax, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB pneumothorax-oth test'},
        {'code': '011.80',
         'long': 'Other specified pulmonary tuberculosis, unspecified',
         'short': 'Pulmonary TB NEC-unspec'},
        {'code': '011.81',
         'long': 'Other specified pulmonary tuberculosis, bacteriological or histological examination not done',
         'short': 'Pulmonary TB NEC-no exam'},
        {'code': '011.82',
         'long': 'Other specified pulmonary tuberculosis, bacteriological or histological examination unknown (at present)',
         'short': 'Pulmon TB NEC-exam unkn'},
        {'code': '011.83',
         'long': 'Other specified pulmonary tuberculosis, tubercle bacilli found (in sputum) by microscopy',
         'short': 'Pulmon TB NEC-micro dx'},
        {'code': '011.84',
         'long': 'Other specified pulmonary tuberculosis, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'Pulmon TB NEC-cult dx'},
        {'code': '011.85',
         'long': 'Other specified pulmonary tuberculosis, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'Pulmon TB NEC-histo dx'},
        {'code': '011.86',
         'long': 'Other specified pulmonary tuberculosis, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'Pulmon TB NEC-oth test'},
        {'code': '011.90',
         'long': 'Pulmonary tuberculosis, unspecified, unspecified',
         'short': 'Pulmonary TB NOS-unspec'},
        {'code': '011.91',
         'long': 'Pulmonary tuberculosis, unspecified, bacteriological or histological examination not done',
         'short': 'Pulmonary TB NOS-no exam'},
        {'code': '011.92',
         'long': 'Pulmonary tuberculosis, unspecified, bacteriological or histological examination unknown (at present)',
         'short': 'Pulmon TB NOS-exam unkn'},
        {'code': '011.93',
         'long': 'Pulmonary tuberculosis, unspecified, tubercle bacilli found (in sputum) by microscopy',
         'short': 'Pulmon TB NOS-micro dx'},
        {'code': '011.94',
         'long': 'Pulmonary tuberculosis, unspecified, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'Pulmon TB NOS-cult dx'},
        {'code': '011.95',
         'long': 'Pulmonary tuberculosis, unspecified, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'Pulmon TB NOS-histo dx'},
        {'code': '011.96',
         'long': 'Pulmonary tuberculosis, unspecified, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'Pulmon TB NOS-oth test'},
        {'code': '012.00',
         'long': 'Tuberculous pleurisy, unspecified',
         'short': 'TB pleurisy-unspec'},
        {'code': '012.01',
         'long': 'Tuberculous pleurisy, bacteriological or histological examination not done',
         'short': 'TB pleurisy-no exam'},
        {'code': '012.02',
         'long': 'Tuberculous pleurisy, bacteriological or histological examination unknown (at present)',
         'short': 'TB pleurisy-exam unkn'},
        {'code': '012.03',
         'long': 'Tuberculous pleurisy, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB pleurisy-micro dx'},
        {'code': '012.04',
         'long': 'Tuberculous pleurisy, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB pleurisy-cult dx'},
        {'code': '012.05',
         'long': 'Tuberculous pleurisy, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB pleurisy-histolog dx'},
        {'code': '012.06',
         'long': 'Tuberculous pleurisy, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB pleurisy-oth test'},
        {'code': '012.10',
         'long': 'Tuberculosis of intrathoracic lymph nodes, unspecified',
         'short': 'TB thoracic nodes-unspec'},
        {'code': '012.11',
         'long': 'Tuberculosis of intrathoracic lymph nodes, bacteriological or histological examination not done',
         'short': 'TB thorax node-no exam'},
        {'code': '012.12',
         'long': 'Tuberculosis of intrathoracic lymph nodes, bacteriological or histological examination unknown (at present)',
         'short': 'TB thorax node-exam unkn'},
        {'code': '012.13',
         'long': 'Tuberculosis of intrathoracic lymph nodes, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB thorax node-micro dx'},
        {'code': '012.14',
         'long': 'Tuberculosis of intrathoracic lymph nodes, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB thorax node-cult dx'},
        {'code': '012.15',
         'long': 'Tuberculosis of intrathoracic lymph nodes, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB thorax node-histo dx'},
        {'code': '012.16',
         'long': 'Tuberculosis of intrathoracic lymph nodes, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB thorax node-oth test'},
        {'code': '012.20',
         'long': 'Isolated tracheal or bronchial tuberculosis, unspecified',
         'short': 'Isol tracheal tb-unspec'},
        {'code': '012.21',
         'long': 'Isolated tracheal or bronchial tuberculosis, bacteriological or histological examination not done',
         'short': 'Isol tracheal tb-no exam'},
        {'code': '012.22',
         'long': 'Isolated tracheal or bronchial tuberculosis, bacteriological or histological examination unknown (at present)',
         'short': 'Isol trach tb-exam unkn'},
        {'code': '012.23',
         'long': 'Isolated tracheal or bronchial tuberculosis, tubercle bacilli found (in sputum) by microscopy',
         'short': 'Isolat trach tb-micro dx'},
        {'code': '012.24',
         'long': 'Isolated tracheal or bronchial tuberculosis, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'Isol tracheal tb-cult dx'},
        {'code': '012.25',
         'long': 'Isolated tracheal or bronchial tuberculosis, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'Isolat trach tb-histo dx'},
        {'code': '012.26',
         'long': 'Isolated tracheal or bronchial tuberculosis, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'Isolat trach tb-oth test'},
        {'code': '012.30',
         'long': 'Tuberculous laryngitis, unspecified',
         'short': 'TB laryngitis-unspec'},
        {'code': '012.31',
         'long': 'Tuberculous laryngitis, bacteriological or histological examination not done',
         'short': 'TB laryngitis-no exam'},
        {'code': '012.32',
         'long': 'Tuberculous laryngitis, bacteriological or histological examination unknown (at present)',
         'short': 'TB laryngitis-exam unkn'},
        {'code': '012.33',
         'long': 'Tuberculous laryngitis, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB laryngitis-micro dx'},
        {'code': '012.34',
         'long': 'Tuberculous laryngitis, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB laryngitis-cult dx'},
        {'code': '012.35',
         'long': 'Tuberculous laryngitis, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB laryngitis-histo dx'},
        {'code': '012.36',
         'long': 'Tuberculous laryngitis, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB laryngitis-oth test'},
        {'code': '012.80',
         'long': 'Other specified respiratory tuberculosis, unspecified',
         'short': 'Resp TB NEC-unspec'},
        {'code': '012.81',
         'long': 'Other specified respiratory tuberculosis, bacteriological or histological examination not done',
         'short': 'Resp TB NEC-no exam'},
        {'code': '012.82',
         'long': 'Other specified respiratory tuberculosis, bacteriological or histological examination unknown (at present)',
         'short': 'Resp TB NEC-exam unkn'},
        {'code': '012.83',
         'long': 'Other specified respiratory tuberculosis, tubercle bacilli found (in sputum) by microscopy',
         'short': 'Resp TB NEC-micro dx'},
        {'code': '012.84',
         'long': 'Other specified respiratory tuberculosis, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'Resp TB NEC-cult dx'},
        {'code': '012.85',
         'long': 'Other specified respiratory tuberculosis, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'Resp TB NEC-histo dx'},
        {'code': '012.86',
         'long': 'Other specified respiratory tuberculosis, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'Resp TB NEC-oth test'},
        {'code': '013.00',
         'long': 'Tuberculous meningitis, unspecified',
         'short': 'TB meningitis-unspec'},
        {'code': '013.01',
         'long': 'Tuberculous meningitis, bacteriological or histological examination not done',
         'short': 'TB meningitis-no exam'},
        {'code': '013.02',
         'long': 'Tuberculous meningitis, bacteriological or histological examination unknown (at present)',
         'short': 'TB meningitis-exam unkn'},
        {'code': '013.03',
         'long': 'Tuberculous meningitis, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB meningitis-micro dx'},
        {'code': '013.04',
         'long': 'Tuberculous meningitis, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB meningitis-cult dx'},
        {'code': '013.05',
         'long': 'Tuberculous meningitis, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB meningitis-histo dx'},
        {'code': '013.06',
         'long': 'Tuberculous meningitis, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB meningitis-oth test'},
        {'code': '013.10',
         'long': 'Tuberculoma of meninges, unspecified',
         'short': 'Tubrclma meninges-unspec'},
        {'code': '013.11',
         'long': 'Tuberculoma of meninges, bacteriological or histological examination not done',
         'short': 'Tubrclma mening-no exam'},
        {'code': '013.12',
         'long': 'Tuberculoma of meninges, bacteriological or histological examination unknown (at present)',
         'short': 'Tubrclma menin-exam unkn'},
        {'code': '013.13',
         'long': 'Tuberculoma of meninges, tubercle bacilli found (in sputum) by microscopy',
         'short': 'Tubrclma mening-micro dx'},
        {'code': '013.14',
         'long': 'Tuberculoma of meninges, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'Tubrclma mening-cult dx'},
        {'code': '013.15',
         'long': 'Tuberculoma of meninges, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'Tubrclma mening-histo dx'},
        {'code': '013.16',
         'long': 'Tuberculoma of meninges, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'Tubrclma mening-oth test'},
        {'code': '013.20',
         'long': 'Tuberculoma of brain, unspecified',
         'short': 'Tuberculoma brain-unspec'},
        {'code': '013.21',
         'long': 'Tuberculoma of brain, bacteriological or histological examination not done',
         'short': 'Tubrcloma brain-no exam'},
        {'code': '013.22',
         'long': 'Tuberculoma of brain, bacteriological or histological examination unknown (at present)',
         'short': 'Tubrclma brain-exam unkn'},
        {'code': '013.23',
         'long': 'Tuberculoma of brain, tubercle bacilli found (in sputum) by microscopy',
         'short': 'Tubrcloma brain-micro dx'},
        {'code': '013.24',
         'long': 'Tuberculoma of brain, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'Tubrcloma brain-cult dx'},
        {'code': '013.25',
         'long': 'Tuberculoma of brain, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'Tubrcloma brain-histo dx'},
        {'code': '013.26',
         'long': 'Tuberculoma of brain, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'Tubrcloma brain-oth test'},
        {'code': '013.30',
         'long': 'Tuberculous abscess of brain, unspecified',
         'short': 'TB brain abscess-unspec'},
        {'code': '013.31',
         'long': 'Tuberculous abscess of brain, bacteriological or histological examination not done',
         'short': 'TB brain abscess-no exam'},
        {'code': '013.32',
         'long': 'Tuberculous abscess of brain, bacteriological or histological examination unknown (at present)',
         'short': 'TB brain absc-exam unkn'},
        {'code': '013.33',
         'long': 'Tuberculous abscess of brain, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB brain absc-micro dx'},
        {'code': '013.34',
         'long': 'Tuberculous abscess of brain, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB brain abscess-cult dx'},
        {'code': '013.35',
         'long': 'Tuberculous abscess of brain, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB brain absc-histo dx'},
        {'code': '013.36',
         'long': 'Tuberculous abscess of brain, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB brain absc-oth test'},
        {'code': '013.40',
         'long': 'Tuberculoma of spinal cord, unspecified',
         'short': 'Tubrclma sp cord-unspec'},
        {'code': '013.41',
         'long': 'Tuberculoma of spinal cord, bacteriological or histological examination not done',
         'short': 'Tubrclma sp cord-no exam'},
        {'code': '013.42',
         'long': 'Tuberculoma of spinal cord, bacteriological or histological examination unknown (at present)',
         'short': 'Tubrclma sp cd-exam unkn'},
        {'code': '013.43',
         'long': 'Tuberculoma of spinal cord, tubercle bacilli found (in sputum) by microscopy',
         'short': 'Tubrclma sp crd-micro dx'},
        {'code': '013.44',
         'long': 'Tuberculoma of spinal cord, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'Tubrclma sp cord-cult dx'},
        {'code': '013.45',
         'long': 'Tuberculoma of spinal cord, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'Tubrclma sp crd-histo dx'},
        {'code': '013.46',
         'long': 'Tuberculoma of spinal cord, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'Tubrclma sp crd-oth test'},
        {'code': '013.50',
         'long': 'Tuberculous abscess of spinal cord, unspecified',
         'short': 'TB sp crd abscess-unspec'},
        {'code': '013.51',
         'long': 'Tuberculous abscess of spinal cord, bacteriological or histological examination not done',
         'short': 'TB sp crd absc-no exam'},
        {'code': '013.52',
         'long': 'Tuberculous abscess of spinal cord, bacteriological or histological examination unknown (at present)',
         'short': 'TB sp crd absc-exam unkn'},
        {'code': '013.53',
         'long': 'Tuberculous abscess of spinal cord, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB sp crd absc-micro dx'},
        {'code': '013.54',
         'long': 'Tuberculous abscess of spinal cord, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB sp crd absc-cult dx'},
        {'code': '013.55',
         'long': 'Tuberculous abscess of spinal cord, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB sp crd absc-histo dx'},
        {'code': '013.56',
         'long': 'Tuberculous abscess of spinal cord, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB sp crd absc-oth test'},
        {'code': '013.60',
         'long': 'Tuberculous encephalitis or myelitis, unspecified',
         'short': 'TB encephalitis-unspec'},
        {'code': '013.61',
         'long': 'Tuberculous encephalitis or myelitis, bacteriological or histological examination not done',
         'short': 'TB encephalitis-no exam'},
        {'code': '013.62',
         'long': 'Tuberculous encephalitis or myelitis, bacteriological or histological examination unknown (at present)',
         'short': 'TB encephalit-exam unkn'},
        {'code': '013.63',
         'long': 'Tuberculous encephalitis or myelitis, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB encephalitis-micro dx'},
        {'code': '013.64',
         'long': 'Tuberculous encephalitis or myelitis, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB encephalitis-cult dx'},
        {'code': '013.65',
         'long': 'Tuberculous encephalitis or myelitis, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB encephalitis-histo dx'},
        {'code': '013.66',
         'long': 'Tuberculous encephalitis or myelitis, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB encephalitis-oth test'},
        {'code': '013.80',
         'long': 'Other specified tuberculosis of central nervous system, unspecified',
         'short': 'Cns TB NEC-unspec'},
        {'code': '013.81',
         'long': 'Other specified tuberculosis of central nervous system, bacteriological or histological examination not done',
         'short': 'Cns TB NEC-no exam'},
        {'code': '013.82',
         'long': 'Other specified tuberculosis of central nervous system, bacteriological or histological examination unknown (at present)',
         'short': 'Cns TB NEC-exam unkn'},
        {'code': '013.83',
         'long': 'Other specified tuberculosis of central nervous system, tubercle bacilli found (in sputum) by microscopy',
         'short': 'Cns TB NEC-micro dx'},
        {'code': '013.84',
         'long': 'Other specified tuberculosis of central nervous system, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'Cns TB NEC-cult dx'},
        {'code': '013.85',
         'long': 'Other specified tuberculosis of central nervous system, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'Cns TB NEC-histo dx'},
        {'code': '013.86',
         'long': 'Other specified tuberculosis of central nervous system, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'Cns TB NEC-oth test'},
        {'code': '013.90',
         'long': 'Unspecified tuberculosis of central nervous system, unspecified',
         'short': 'Cns TB NOS-unspec'},
        {'code': '013.91',
         'long': 'Unspecified tuberculosis of central nervous system, bacteriological or histological examination not done',
         'short': 'Cns TB NOS-no exam'},
        {'code': '013.92',
         'long': 'Unspecified tuberculosis of central nervous system, bacteriological or histological examination unknown (at present)',
         'short': 'Cns TB NOS-exam unkn'},
        {'code': '013.93',
         'long': 'Unspecified tuberculosis of central nervous system, tubercle bacilli found (in sputum) by microscopy',
         'short': 'Cns TB NOS-micro dx'},
        {'code': '013.94',
         'long': 'Unspecified tuberculosis of central nervous system, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'Cns TB NOS-cult dx'},
        {'code': '013.95',
         'long': 'Unspecified tuberculosis of central nervous system, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'Cns TB NOS-histo dx'},
        {'code': '013.96',
         'long': 'Unspecified tuberculosis of central nervous system, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'Cns TB NOS-oth test'},
        {'code': '014.00',
         'long': 'Tuberculous peritonitis, unspecified',
         'short': 'TB peritonitis-unspec'},
        {'code': '014.01',
         'long': 'Tuberculous peritonitis, bacteriological or histological examination not done',
         'short': 'TB peritonitis-no exam'},
        {'code': '014.02',
         'long': 'Tuberculous peritonitis, bacteriological or histological examination unknown (at present)',
         'short': 'TB peritonitis-exam unkn'},
        {'code': '014.03',
         'long': 'Tuberculous peritonitis, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB peritonitis-micro dx'},
        {'code': '014.04',
         'long': 'Tuberculous peritonitis, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB peritonitis-cult dx'},
        {'code': '014.05',
         'long': 'Tuberculous peritonitis, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB peritonitis-histo dx'},
        {'code': '014.06',
         'long': 'Tuberculous peritonitis, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB peritonitis-oth test'},
        {'code': '014.80',
         'long': 'Other tuberculosis of intestines, peritoneum, and mesenteric glands, unspecified',
         'short': 'Intestinal TB NEC-unspec'},
        {'code': '014.81',
         'long': 'Other tuberculosis of intestines, peritoneum, and mesenteric glands, bacteriological or histological examination not done',
         'short': 'Intestin TB NEC-no exam'},
        {'code': '014.82',
         'long': 'Other tuberculosis of intestines, peritoneum, and mesenteric glands, bacteriological or histological examination unknown (at present)',
         'short': 'Intest TB NEC-exam unkn'},
        {'code': '014.83',
         'long': 'Other tuberculosis of intestines, peritoneum, and mesenteric glands, tubercle bacilli found (in sputum) by microscopy',
         'short': 'Intestin TB NEC-micro dx'},
        {'code': '014.84',
         'long': 'Other tuberculosis of intestines, peritoneum, and mesenteric glands, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'Intestin TB NEC-cult dx'},
        {'code': '014.85',
         'long': 'Other tuberculosis of intestines, peritoneum, and mesenteric glands, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'Intestin TB NEC-histo dx'},
        {'code': '014.86',
         'long': 'Other tuberculosis of intestines, peritoneum, and mesenteric glands, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'Intestin TB NEC-oth test'},
        {'code': '015.00',
         'long': 'Tuberculosis of vertebral column, unspecified',
         'short': 'TB of vertebra-unspec'},
        {'code': '015.01',
         'long': 'Tuberculosis of vertebral column, bacteriological or histological examination not done',
         'short': 'TB of vertebra-no exam'},
        {'code': '015.02',
         'long': 'Tuberculosis of vertebral column, bacteriological or histological examination unknown (at present)',
         'short': 'TB of vertebra-exam unkn'},
        {'code': '015.03',
         'long': 'Tuberculosis of vertebral column, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB of vertebra-micro dx'},
        {'code': '015.04',
         'long': 'Tuberculosis of vertebral column, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB of vertebra-cult dx'},
        {'code': '015.05',
         'long': 'Tuberculosis of vertebral column, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB of vertebra-histo dx'},
        {'code': '015.06',
         'long': 'Tuberculosis of vertebral column, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB of vertebra-oth test'},
        {'code': '015.10',
         'long': 'Tuberculosis of hip, unspecified',
         'short': 'TB of hip-unspec'},
        {'code': '015.11',
         'long': 'Tuberculosis of hip, bacteriological or histological examination not done',
         'short': 'TB of hip-no exam'},
        {'code': '015.12',
         'long': 'Tuberculosis of hip, bacteriological or histological examination unknown (at present)',
         'short': 'TB of hip-exam unkn'},
        {'code': '015.13',
         'long': 'Tuberculosis of hip, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB of hip-micro dx'},
        {'code': '015.14',
         'long': 'Tuberculosis of hip, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB of hip-cult dx'},
        {'code': '015.15',
         'long': 'Tuberculosis of hip, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB of hip-histo dx'},
        {'code': '015.16',
         'long': 'Tuberculosis of hip, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB of hip-oth test'},
        {'code': '015.20',
         'long': 'Tuberculosis of knee, unspecified',
         'short': 'TB of knee-unspec'},
        {'code': '015.21',
         'long': 'Tuberculosis of knee, bacteriological or histological examination not done',
         'short': 'TB of knee-no exam'},
        {'code': '015.22',
         'long': 'Tuberculosis of knee, bacteriological or histological examination unknown (at present)',
         'short': 'TB of knee-exam unkn'},
        {'code': '015.23',
         'long': 'Tuberculosis of knee, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB of knee-micro dx'},
        {'code': '015.24',
         'long': 'Tuberculosis of knee, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB of knee-cult dx'},
        {'code': '015.25',
         'long': 'Tuberculosis of knee, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB of knee-histo dx'},
        {'code': '015.26',
         'long': 'Tuberculosis of knee, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB of knee-oth test'},
        {'code': '015.50',
         'long': 'Tuberculosis of limb bones, unspecified',
         'short': 'TB of limb bones-unspec'},
        {'code': '015.51',
         'long': 'Tuberculosis of limb bones, bacteriological or histological examination not done',
         'short': 'TB limb bones-no exam'},
        {'code': '015.52',
         'long': 'Tuberculosis of limb bones, bacteriological or histological examination unknown (at present)',
         'short': 'TB limb bones-exam unkn'},
        {'code': '015.53',
         'long': 'Tuberculosis of limb bones, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB limb bones-micro dx'},
        {'code': '015.54',
         'long': 'Tuberculosis of limb bones, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB limb bones-cult dx'},
        {'code': '015.55',
         'long': 'Tuberculosis of limb bones, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB limb bones-histo dx'},
        {'code': '015.56',
         'long': 'Tuberculosis of limb bones, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB limb bones-oth test'},
        {'code': '015.60',
         'long': 'Tuberculosis of mastoid, unspecified',
         'short': 'TB of mastoid-unspec'},
        {'code': '015.61',
         'long': 'Tuberculosis of mastoid, bacteriological or histological examination not done',
         'short': 'TB of mastoid-no exam'},
        {'code': '015.62',
         'long': 'Tuberculosis of mastoid, bacteriological or histological examination unknown (at present)',
         'short': 'TB of mastoid-exam unkn'},
        {'code': '015.63',
         'long': 'Tuberculosis of mastoid, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB of mastoid-micro dx'},
        {'code': '015.64',
         'long': 'Tuberculosis of mastoid, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB of mastoid-cult dx'},
        {'code': '015.65',
         'long': 'Tuberculosis of mastoid, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB of mastoid-histo dx'},
        {'code': '015.66',
         'long': 'Tuberculosis of mastoid, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB of mastoid-oth test'},
        {'code': '015.70',
         'long': 'Tuberculosis of other specified bone, unspecified',
         'short': 'TB of bone NEC-unspec'},
        {'code': '015.71',
         'long': 'Tuberculosis of other specified bone, bacteriological or histological examination not done',
         'short': 'TB of bone NEC-no exam'},
        {'code': '015.72',
         'long': 'Tuberculosis of other specified bone, bacteriological or histological examination unknown (at present)',
         'short': 'TB of bone NEC-exam unkn'},
        {'code': '015.73',
         'long': 'Tuberculosis of other specified bone, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB of bone NEC-micro dx'},
        {'code': '015.74',
         'long': 'Tuberculosis of other specified bone, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB of bone NEC-cult dx'},
        {'code': '015.75',
         'long': 'Tuberculosis of other specified bone, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB of bone NEC-histo dx'},
        {'code': '015.76',
         'long': 'Tuberculosis of other specified bone, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB of bone NEC-oth test'},
        {'code': '015.80',
         'long': 'Tuberculosis of other specified joint, unspecified',
         'short': 'TB of joint NEC-unspec'},
        {'code': '015.81',
         'long': 'Tuberculosis of other specified joint, bacteriological or histological examination not done',
         'short': 'TB of joint NEC-no exam'},
        {'code': '015.82',
         'long': 'Tuberculosis of other specified joint, bacteriological or histological examination unknown (at present)',
         'short': 'TB joint NEC-exam unkn'},
        {'code': '015.83',
         'long': 'Tuberculosis of other specified joint, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB of joint NEC-micro dx'},
        {'code': '015.84',
         'long': 'Tuberculosis of other specified joint, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB of joint NEC-cult dx'},
        {'code': '015.85',
         'long': 'Tuberculosis of other specified joint, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB of joint NEC-histo dx'},
        {'code': '015.86',
         'long': 'Tuberculosis of other specified joint, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB of joint NEC-oth test'},
        {'code': '015.90',
         'long': 'Tuberculosis of unspecified bones and joints, unspecified',
         'short': 'TB bone/joint NOS-unspec'},
        {'code': '015.91',
         'long': 'Tuberculosis of unspecified bones and joints, bacteriological or histological examination not done',
         'short': 'TB bone/jt NOS-no exam'},
        {'code': '015.92',
         'long': 'Tuberculosis of unspecified bones and joints, bacteriological or histological examination unknown (at present)',
         'short': 'TB bone/jt NOS-exam unkn'},
        {'code': '015.93',
         'long': 'Tuberculosis of unspecified bones and joints, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB bone/jt NOS-micro dx'},
        {'code': '015.94',
         'long': 'Tuberculosis of unspecified bones and joints, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB bone/jt NOS-cult dx'},
        {'code': '015.95',
         'long': 'Tuberculosis of unspecified bones and joints, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB bone/jt NOS-histo dx'},
        {'code': '015.96',
         'long': 'Tuberculosis of unspecified bones and joints, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB bone/jt NOS-oth test'},
        {'code': '016.00',
         'long': 'Tuberculosis of kidney, unspecified',
         'short': 'TB of kidney-unspec'},
        {'code': '016.01',
         'long': 'Tuberculosis of kidney, bacteriological or histological examination not done',
         'short': 'TB of kidney-no exam'},
        {'code': '016.02',
         'long': 'Tuberculosis of kidney, bacteriological or histological examination unknown (at present)',
         'short': 'TB of kidney-exam unkn'},
        {'code': '016.03',
         'long': 'Tuberculosis of kidney, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB of kidney-micro dx'},
        {'code': '016.04',
         'long': 'Tuberculosis of kidney, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB of kidney-cult dx'},
        {'code': '016.05',
         'long': 'Tuberculosis of kidney, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB of kidney-histo dx'},
        {'code': '016.06',
         'long': 'Tuberculosis of kidney, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB of kidney-oth test'},
        {'code': '016.10',
         'long': 'Tuberculosis of bladder, unspecified',
         'short': 'TB of bladder-unspec'},
        {'code': '016.11',
         'long': 'Tuberculosis of bladder, bacteriological or histological examination not done',
         'short': 'TB of bladder-no exam'},
        {'code': '016.12',
         'long': 'Tuberculosis of bladder, bacteriological or histological examination unknown (at present)',
         'short': 'TB of bladder-exam unkn'},
        {'code': '016.13',
         'long': 'Tuberculosis of bladder, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB of bladder-micro dx'},
        {'code': '016.14',
         'long': 'Tuberculosis of bladder, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB of bladder-cult dx'},
        {'code': '016.15',
         'long': 'Tuberculosis of bladder, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB of bladder-histo dx'},
        {'code': '016.16',
         'long': 'Tuberculosis of bladder, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB of bladder-oth test'},
        {'code': '016.20',
         'long': 'Tuberculosis of ureter, unspecified',
         'short': 'TB of ureter-unspec'},
        {'code': '016.21',
         'long': 'Tuberculosis of ureter, bacteriological or histological examination not done',
         'short': 'TB of ureter-no exam'},
        {'code': '016.22',
         'long': 'Tuberculosis of ureter, bacteriological or histological examination unknown (at present)',
         'short': 'TB of ureter-exam unkn'},
        {'code': '016.23',
         'long': 'Tuberculosis of ureter, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB of ureter-micro dx'},
        {'code': '016.24',
         'long': 'Tuberculosis of ureter, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB of ureter-cult dx'},
        {'code': '016.25',
         'long': 'Tuberculosis of ureter, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB of ureter-histo dx'},
        {'code': '016.26',
         'long': 'Tuberculosis of ureter, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB of ureter-oth test'},
        {'code': '016.30',
         'long': 'Tuberculosis of other urinary organs, unspecified',
         'short': 'TB urinary NEC-unspec'},
        {'code': '016.31',
         'long': 'Tuberculosis of other urinary organs, bacteriological or histological examination not done',
         'short': 'TB urinary NEC-no exam'},
        {'code': '016.32',
         'long': 'Tuberculosis of other urinary organs, bacteriological or histological examination unknown (at present)',
         'short': 'TB urinary NEC-exam unkn'},
        {'code': '016.33',
         'long': 'Tuberculosis of other urinary organs, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB urinary NEC-micro dx'},
        {'code': '016.34',
         'long': 'Tuberculosis of other urinary organs, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB urinary NEC-cult dx'},
        {'code': '016.35',
         'long': 'Tuberculosis of other urinary organs, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB urinary NEC-histo dx'},
        {'code': '016.36',
         'long': 'Tuberculosis of other urinary organs, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB urinary NEC-oth test'},
        {'code': '016.40',
         'long': 'Tuberculosis of epididymis, unspecified',
         'short': 'TB epididymis-unspec'},
        {'code': '016.41',
         'long': 'Tuberculosis of epididymis, bacteriological or histological examination not done',
         'short': 'TB epididymis-no exam'},
        {'code': '016.42',
         'long': 'Tuberculosis of epididymis, bacteriological or histological examination unknown (at present)',
         'short': 'TB epididymis-exam unkn'},
        {'code': '016.43',
         'long': 'Tuberculosis of epididymis, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB epididymis-micro dx'},
        {'code': '016.44',
         'long': 'Tuberculosis of epididymis, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB epididymis-cult dx'},
        {'code': '016.45',
         'long': 'Tuberculosis of epididymis, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB epididymis-histo dx'},
        {'code': '016.46',
         'long': 'Tuberculosis of epididymis, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB epididymis-oth test'},
        {'code': '016.50',
         'long': 'Tuberculosis of other male genital organs, unspecified',
         'short': 'TB male genit NEC-unspec'},
        {'code': '016.51',
         'long': 'Tuberculosis of other male genital organs, bacteriological or histological examination not done',
         'short': 'TB male gen NEC-no exam'},
        {'code': '016.52',
         'long': 'Tuberculosis of other male genital organs, bacteriological or histological examination unknown (at present)',
         'short': 'TB male gen NEC-ex unkn'},
        {'code': '016.53',
         'long': 'Tuberculosis of other male genital organs, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB male gen NEC-micro dx'},
        {'code': '016.54',
         'long': 'Tuberculosis of other male genital organs, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB male gen NEC-cult dx'},
        {'code': '016.55',
         'long': 'Tuberculosis of other male genital organs, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB male gen NEC-histo dx'},
        {'code': '016.56',
         'long': 'Tuberculosis of other male genital organs, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB male gen NEC-oth test'},
        {'code': '016.60',
         'long': 'Tuberculous oophoritis and salpingitis, unspecified',
         'short': 'TB ovary & tube-unspec'},
        {'code': '016.61',
         'long': 'Tuberculous oophoritis and salpingitis, bacteriological or histological examination not done',
         'short': 'TB ovary & tube-no exam'},
        {'code': '016.62',
         'long': 'Tuberculous oophoritis and salpingitis, bacteriological or histological examination unknown (at present)',
         'short': 'TB ovary/tube-exam unkn'},
        {'code': '016.63',
         'long': 'Tuberculous oophoritis and salpingitis, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB ovary & tube-micro dx'},
        {'code': '016.64',
         'long': 'Tuberculous oophoritis and salpingitis, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB ovary & tube-cult dx'},
        {'code': '016.65',
         'long': 'Tuberculous oophoritis and salpingitis, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB ovary & tube-histo dx'},
        {'code': '016.66',
         'long': 'Tuberculous oophoritis and salpingitis, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB ovary & tube-oth test'},
        {'code': '016.70',
         'long': 'Tuberculosis of other female genital organs, unspecified',
         'short': 'TB female gen NEC-unspec'},
        {'code': '016.71',
         'long': 'Tuberculosis of other female genital organs, bacteriological or histological examination not done',
         'short': 'TB fem gen NEC-no exam'},
        {'code': '016.72',
         'long': 'Tuberculosis of other female genital organs, bacteriological or histological examination unknown (at present)',
         'short': 'TB fem gen NEC-exam unkn'},
        {'code': '016.73',
         'long': 'Tuberculosis of other female genital organs, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB fem gen NEC-micro dx'},
        {'code': '016.74',
         'long': 'Tuberculosis of other female genital organs, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB fem gen NEC-cult dx'},
        {'code': '016.75',
         'long': 'Tuberculosis of other female genital organs, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB fem gen NEC-histo dx'},
        {'code': '016.76',
         'long': 'Tuberculosis of other female genital organs, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB fem gen NEC-oth test'},
        {'code': '016.90',
         'long': 'Genitourinary tuberculosis, unspecified, unspecified',
         'short': 'Gu TB NOS-unspec'},
        {'code': '016.91',
         'long': 'Genitourinary tuberculosis, unspecified, bacteriological or histological examination not done',
         'short': 'Gu TB NOS-no exam'},
        {'code': '016.92',
         'long': 'Genitourinary tuberculosis, unspecified, bacteriological or histological examination unknown (at present)',
         'short': 'Gu TB NOS-exam unkn'},
        {'code': '016.93',
         'long': 'Genitourinary tuberculosis, unspecified, tubercle bacilli found (in sputum) by microscopy',
         'short': 'Gu TB NOS-micro dx'},
        {'code': '016.94',
         'long': 'Genitourinary tuberculosis, unspecified, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'Gu TB NOS-cult dx'},
        {'code': '016.95',
         'long': 'Genitourinary tuberculosis, unspecified, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'Gu TB NOS-histo dx'},
        {'code': '016.96',
         'long': 'Genitourinary tuberculosis, unspecified, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'Gu TB NOS-oth test'},
        {'code': '017.00',
         'long': 'Tuberculosis of skin and subcutaneous cellular tissue, unspecified',
         'short': 'TB skin/subcutan-unspec'},
        {'code': '017.01',
         'long': 'Tuberculosis of skin and subcutaneous cellular tissue, bacteriological or histological examination not done',
         'short': 'TB skin/subcut-no exam'},
        {'code': '017.02',
         'long': 'Tuberculosis of skin and subcutaneous cellular tissue, bacteriological or histological examination unknown (at present)',
         'short': 'TB skin/subcut-exam unkn'},
        {'code': '017.03',
         'long': 'Tuberculosis of skin and subcutaneous cellular tissue, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB skin/subcut-micro dx'},
        {'code': '017.04',
         'long': 'Tuberculosis of skin and subcutaneous cellular tissue, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB skin/subcut-cult dx'},
        {'code': '017.05',
         'long': 'Tuberculosis of skin and subcutaneous cellular tissue, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB skin/subcut-histo dx'},
        {'code': '017.06',
         'long': 'Tuberculosis of skin and subcutaneous cellular tissue, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB skin/subcut-oth test'},
        {'code': '017.10',
         'long': 'Erythema nodosum with hypersensitivity reaction in tuberculosis, unspecified',
         'short': 'Erythema nodos tb-unspec'},
        {'code': '017.11',
         'long': 'Erythema nodosum with hypersensitivity reaction in tuberculosis, bacteriological or histological examination not done',
         'short': 'Erythem nodos tb-no exam'},
        {'code': '017.12',
         'long': 'Erythema nodosum with hypersensitivity reaction in tuberculosis, bacteriological or histological examination unknown (at present)',
         'short': 'Erythem nod tb-exam unkn'},
        {'code': '017.13',
         'long': 'Erythema nodosum with hypersensitivity reaction in tuberculosis, tubercle bacilli found (in sputum) by microscopy',
         'short': 'Erythem nod tb-micro dx'},
        {'code': '017.14',
         'long': 'Erythema nodosum with hypersensitivity reaction in tuberculosis, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'Erythem nodos tb-cult dx'},
        {'code': '017.15',
         'long': 'Erythema nodosum with hypersensitivity reaction in tuberculosis, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'Erythem nod tb-histo dx'},
        {'code': '017.16',
         'long': 'Erythema nodosum with hypersensitivity reaction in tuberculosis, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'Erythem nod tb-oth test'},
        {'code': '017.20',
         'long': 'Tuberculosis of peripheral lymph nodes, unspecified',
         'short': 'TB periph lymph-unspec'},
        {'code': '017.21',
         'long': 'Tuberculosis of peripheral lymph nodes, bacteriological or histological examination not done',
         'short': 'TB periph lymph-no exam'},
        {'code': '017.22',
         'long': 'Tuberculosis of peripheral lymph nodes, bacteriological or histological examination unknown (at present)',
         'short': 'TB periph lymph-exam unk'},
        {'code': '017.23',
         'long': 'Tuberculosis of peripheral lymph nodes, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB periph lymph-micro dx'},
        {'code': '017.24',
         'long': 'Tuberculosis of peripheral lymph nodes, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB periph lymph-cult dx'},
        {'code': '017.25',
         'long': 'Tuberculosis of peripheral lymph nodes, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB periph lymph-histo dx'},
        {'code': '017.26',
         'long': 'Tuberculosis of peripheral lymph nodes, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB periph lymph-oth test'},
        {'code': '017.30',
         'long': 'Tuberculosis of eye, unspecified',
         'short': 'TB of eye-unspec'},
        {'code': '017.31',
         'long': 'Tuberculosis of eye, bacteriological or histological examination not done',
         'short': 'TB of eye-no exam'},
        {'code': '017.32',
         'long': 'Tuberculosis of eye, bacteriological or histological examination unknown (at present)',
         'short': 'TB of eye-exam unkn'},
        {'code': '017.33',
         'long': 'Tuberculosis of eye, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB of eye-micro dx'},
        {'code': '017.34',
         'long': 'Tuberculosis of eye, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB of eye-cult dx'},
        {'code': '017.35',
         'long': 'Tuberculosis of eye, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB of eye-histo dx'},
        {'code': '017.36',
         'long': 'Tuberculosis of eye, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB of eye-oth test'},
        {'code': '017.40',
         'long': 'Tuberculosis of ear, unspecified',
         'short': 'TB of ear-unspec'},
        {'code': '017.41',
         'long': 'Tuberculosis of ear, bacteriological or histological examination not done',
         'short': 'TB of ear-no exam'},
        {'code': '017.42',
         'long': 'Tuberculosis of ear, bacteriological or histological examination unknown (at present)',
         'short': 'TB of ear-exam unkn'},
        {'code': '017.43',
         'long': 'Tuberculosis of ear, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB of ear-micro dx'},
        {'code': '017.44',
         'long': 'Tuberculosis of ear, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB of ear-cult dx'},
        {'code': '017.45',
         'long': 'Tuberculosis of ear, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB of ear-histo dx'},
        {'code': '017.46',
         'long': 'Tuberculosis of ear, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB of ear-oth test'},
        {'code': '017.50',
         'long': 'Tuberculosis of thyroid gland, unspecified',
         'short': 'TB of thyroid-unspec'},
        {'code': '017.51',
         'long': 'Tuberculosis of thyroid gland, bacteriological or histological examination not done',
         'short': 'TB of thyroid-no exam'},
        {'code': '017.52',
         'long': 'Tuberculosis of thyroid gland, bacteriological or histological examination unknown (at present)',
         'short': 'TB of thyroid-exam unkn'},
        {'code': '017.53',
         'long': 'Tuberculosis of thyroid gland, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB of thyroid-micro dx'},
        {'code': '017.54',
         'long': 'Tuberculosis of thyroid gland, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB of thyroid-cult dx'},
        {'code': '017.55',
         'long': 'Tuberculosis of thyroid gland, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB of thyroid-histo dx'},
        {'code': '017.56',
         'long': 'Tuberculosis of thyroid gland, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB of thyroid-oth test'},
        {'code': '017.60',
         'long': 'Tuberculosis of adrenal glands, unspecified',
         'short': 'TB of adrenal-unspec'},
        {'code': '017.61',
         'long': 'Tuberculosis of adrenal glands, bacteriological or histological examination not done',
         'short': 'TB of adrenal-no exam'},
        {'code': '017.62',
         'long': 'Tuberculosis of adrenal glands, bacteriological or histological examination unknown (at present)',
         'short': 'TB of adrenal-exam unkn'},
        {'code': '017.63',
         'long': 'Tuberculosis of adrenal glands, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB of adrenal-micro dx'},
        {'code': '017.64',
         'long': 'Tuberculosis of adrenal glands, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB of adrenal-cult dx'},
        {'code': '017.65',
         'long': 'Tuberculosis of adrenal glands, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB of adrenal-histo dx'},
        {'code': '017.66',
         'long': 'Tuberculosis of adrenal glands, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB of adrenal-oth test'},
        {'code': '017.70',
         'long': 'Tuberculosis of spleen, unspecified',
         'short': 'TB of spleen-unspec'},
        {'code': '017.71',
         'long': 'Tuberculosis of spleen, bacteriological or histological examination not done',
         'short': 'TB of spleen-no exam'},
        {'code': '017.72',
         'long': 'Tuberculosis of spleen, bacteriological or histological examination unknown (at present)',
         'short': 'TB of spleen-exam unkn'},
        {'code': '017.73',
         'long': 'Tuberculosis of spleen, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB of spleen-micro dx'},
        {'code': '017.74',
         'long': 'Tuberculosis of spleen, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB of spleen-cult dx'},
        {'code': '017.75',
         'long': 'Tuberculosis of spleen, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB of spleen-histo dx'},
        {'code': '017.76',
         'long': 'Tuberculosis of spleen, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB of spleen-oth test'},
        {'code': '017.80',
         'long': 'Tuberculosis of esophagus, unspecified',
         'short': 'TB esophagus-unspec'},
        {'code': '017.81',
         'long': 'Tuberculosis of esophagus, bacteriological or histological examination not done',
         'short': 'TB esophagus-no exam'},
        {'code': '017.82',
         'long': 'Tuberculosis of esophagus, bacteriological or histological examination unknown (at present)',
         'short': 'TB esophagus-exam unkn'},
        {'code': '017.83',
         'long': 'Tuberculosis of esophagus, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB esophagus-micro dx'},
        {'code': '017.84',
         'long': 'Tuberculosis of esophagus, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB esophagus-cult dx'},
        {'code': '017.85',
         'long': 'Tuberculosis of esophagus, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB esophagus-histo dx'},
        {'code': '017.86',
         'long': 'Tuberculosis of esophagus, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB esophagus-oth test'},
        {'code': '017.90',
         'long': 'Tuberculosis of other specified organs, unspecified',
         'short': 'TB of organ NEC-unspec'},
        {'code': '017.91',
         'long': 'Tuberculosis of other specified organs, bacteriological or histological examination not done',
         'short': 'TB of organ NEC-no exam'},
        {'code': '017.92',
         'long': 'Tuberculosis of other specified organs, bacteriological or histological examination unknown (at present)',
         'short': 'TB organ NEC-exam unkn'},
        {'code': '017.93',
         'long': 'Tuberculosis of other specified organs, tubercle bacilli found (in sputum) by microscopy',
         'short': 'TB of organ NEC-micro dx'},
        {'code': '017.94',
         'long': 'Tuberculosis of other specified organs, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'TB of organ NEC-cult dx'},
        {'code': '017.95',
         'long': 'Tuberculosis of other specified organs, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'TB of organ NEC-histo dx'},
        {'code': '017.96',
         'long': 'Tuberculosis of other specified organs, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'TB of organ NEC-oth test'},
        {'code': '018.00',
         'long': 'Acute miliary tuberculosis, unspecified',
         'short': 'Acute miliary tb-unspec'},
        {'code': '018.01',
         'long': 'Acute miliary tuberculosis, bacteriological or histological examination not done',
         'short': 'Acute miliary tb-no exam'},
        {'code': '018.02',
         'long': 'Acute miliary tuberculosis, bacteriological or histological examination unknown (at present)',
         'short': 'Ac miliary tb-exam unkn'},
        {'code': '018.03',
         'long': 'Acute miliary tuberculosis, tubercle bacilli found (in sputum) by microscopy',
         'short': 'Ac miliary tb-micro dx'},
        {'code': '018.04',
         'long': 'Acute miliary tuberculosis, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'Acute miliary tb-cult dx'},
        {'code': '018.05',
         'long': 'Acute miliary tuberculosis, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'Ac miliary tb-histo dx'},
        {'code': '018.06',
         'long': 'Acute miliary tuberculosis, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'Ac miliary tb-oth test'},
        {'code': '018.80',
         'long': 'Other specified miliary tuberculosis, unspecified',
         'short': 'Miliary TB NEC-unspec'},
        {'code': '018.81',
         'long': 'Other specified miliary tuberculosis, bacteriological or histological examination not done',
         'short': 'Miliary TB NEC-no exam'},
        {'code': '018.82',
         'long': 'Other specified miliary tuberculosis, bacteriological or histological examination unknown (at present)',
         'short': 'Miliary TB NEC-exam unkn'},
        {'code': '018.83',
         'long': 'Other specified miliary tuberculosis, tubercle bacilli found (in sputum) by microscopy',
         'short': 'Miliary TB NEC-micro dx'},
        {'code': '018.84',
         'long': 'Other specified miliary tuberculosis, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'Miliary TB NEC-cult dx'},
        {'code': '018.85',
         'long': 'Other specified miliary tuberculosis, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'Miliary TB NEC-histo dx'},
        {'code': '018.86',
         'long': 'Other specified miliary tuberculosis, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'Miliary TB NEC-oth test'},
        {'code': '018.90',
         'long': 'Miliary tuberculosis, unspecified, unspecified',
         'short': 'Miliary TB NOS-unspec'},
        {'code': '018.91',
         'long': 'Miliary tuberculosis, unspecified, bacteriological or histological examination not done',
         'short': 'Miliary TB NOS-no exam'},
        {'code': '018.92',
         'long': 'Miliary tuberculosis, unspecified, bacteriological or histological examination unknown (at present)',
         'short': 'Miliary TB NOS-exam unkn'},
        {'code': '018.93',
         'long': 'Miliary tuberculosis, unspecified, tubercle bacilli found (in sputum) by microscopy',
         'short': 'Miliary TB NOS-micro dx'},
        {'code': '018.94',
         'long': 'Miliary tuberculosis, unspecified, tubercle bacilli not found (in sputum) by microscopy, but found by bacterial culture',
         'short': 'Miliary TB NOS-cult dx'},
        {'code': '018.95',
         'long': 'Miliary tuberculosis, unspecified, tubercle bacilli not found by bacteriological examination, but tuberculosis confirmed histologically',
         'short': 'Miliary TB NOS-histo dx'},
        {'code': '018.96',
         'long': 'Miliary tuberculosis, unspecified, tubercle bacilli not found by bacteriological or histological examination, but tuberculosis confirmed by other methods [inoculation of animals]',
         'short': 'Miliary TB NOS-oth test'},
        {'code': '020.0',
         'long': 'Bubonic plague',
         'short': 'Bubonic plague'},
        {'code': '020.1',
         'long': 'Cellulocutaneous plague',
         'short': 'Cellulocutaneous plague'},
        {'code': '020.2',
         'long': 'Septicemic plague',
         'short': 'Septicemic plague'},
        {'code': '020.3',
         'long': 'Primary pneumonic plague',
         'short': 'Primary pneumonic plague'},
        {'code': '020.4',
         'long': 'Secondary pneumonic plague',
         'short': 'Secondary pneumon plague'},
        {'code': '020.5',
         'long': 'Pneumonic plague, unspecified',
         'short': 'Pneumonic plague NOS'},
        {'code': '020.8',
         'long': 'Other specified types of plague',
         'short': 'Other types of plague'},
        {'code': '020.9',
         'long': 'Plague, unspecified',
         'short': 'Plague NOS'},
        {'code': '021.0',
         'long': 'Ulceroglandular tularemia',
         'short': 'Ulceroglandul tularemia'},
        {'code': '021.1',
         'long': 'Enteric tularemia',
         'short': 'Enteric tularemia'},
        {'code': '021.2',
         'long': 'Pulmonary tularemia',
         'short': 'Pulmonary tularemia'},
        {'code': '021.3',
         'long': 'Oculoglandular tularemia',
         'short': 'Oculoglandular tularemia'},
        {'code': '021.8',
         'long': 'Other specified tularemia',
         'short': 'Tularemia NEC'},
        {'code': '021.9',
         'long': 'Unspecified tularemia',
         'short': 'Tularemia NOS'},
        {'code': '022.0',
         'long': 'Cutaneous anthrax',
         'short': 'Cutaneous anthrax'},
        {'code': '022.1',
         'long': 'Pulmonary anthrax',
         'short': 'Pulmonary anthrax'},
        {'code': '022.2',
         'long': 'Gastrointestinal anthrax',
         'short': 'Gastrointestinal anthrax'},
        {'code': '022.3',
         'long': 'Anthrax septicemia',
         'short': 'Anthrax septicemia'},
        {'code': '022.8',
         'long': 'Other specified manifestations of anthrax',
         'short': 'Other anthrax manifest'},
        {'code': '022.9',
         'long': 'Anthrax, unspecified',
         'short': 'Anthrax NOS'},
        {'code': '023.0',
         'long': 'Brucella melitensis',
         'short': 'Brucella melitensis'},
        {'code': '023.1',
         'long': 'Brucella abortus',
         'short': 'Brucella abortus'},
        {'code': '023.2', 'long': 'Brucella suis', 'short': 'Brucella suis'},
        {'code': '023.3',
         'long': 'Brucella canis',
         'short': 'Brucella canis'},
        {'code': '023.8',
         'long': 'Other brucellosis',
         'short': 'Brucellosis NEC'},
        {'code': '023.9',
         'long': 'Brucellosis, unspecified',
         'short': 'Brucellosis NOS'},
        {'code': '024', 'long': 'Glanders', 'short': 'Glanders'},
        {'code': '025', 'long': 'Melioidosis', 'short': 'Melioidosis'},
        {'code': '026.0',
         'long': 'Spirillary fever',
         'short': 'Spirillary fever'},
        {'code': '026.1',
         'long': 'Streptobacillary fever',
         'short': 'Streptobacillary fever'},
        {'code': '026.9',
         'long': 'Unspecified rat-bite fever',
         'short': 'Rat-bite fever NOS'},
        {'code': '027.0', 'long': 'Listeriosis', 'short': 'Listeriosis'},
        {'code': '027.1',
         'long': 'Erysipelothrix infection',
         'short': 'Erysipelothrix infection'},
        {'code': '027.2',
         'long': 'Pasteurellosis',
         'short': 'Pasteurellosis'},
        {'code': '027.8',
         'long': 'Other specified zoonotic bacterial diseases',
         'short': 'Zoonotic bact dis NEC'},
        {'code': '027.9',
         'long': 'Unspecified zoonotic bacterial disease',
         'short': 'Zoonotic bact dis NOS'},
        {'code': '030.0',
         'long': 'Lepromatous leprosy [type L]',
         'short': 'Lepromatous leprosy'},
        {'code': '030.1',
         'long': 'Tuberculoid leprosy [type T]',
         'short': 'Tuberculoid leprosy'},
        {'code': '030.2',
         'long': 'Indeterminate leprosy [group I]',
         'short': 'Indeterminate leprosy'},
        {'code': '030.3',
         'long': 'Borderline leprosy [group B]',
         'short': 'Borderline leprosy'},
        {'code': '030.8',
         'long': 'Other specified leprosy',
         'short': 'Leprosy NEC'},
        {'code': '030.9',
         'long': 'Leprosy, unspecified',
         'short': 'Leprosy NOS'},
        {'code': '031.0',
         'long': 'Pulmonary diseases due to other mycobacteria',
         'short': 'Pulmonary mycobacteria'},
        {'code': '031.1',
         'long': 'Cutaneous diseases due to other mycobacteria',
         'short': 'Cutaneous mycobacteria'},
        {'code': '031.2',
         'long': 'Disseminated due to other mycobacteria',
         'short': 'DMAC bacteremia'},
        {'code': '031.8',
         'long': 'Other specified mycobacterial diseases',
         'short': 'Mycobacterial dis NEC'},
        {'code': '031.9',
         'long': 'Unspecified diseases due to mycobacteria',
         'short': 'Mycobacterial dis NOS'},
        {'code': '032.0',
         'long': 'Faucial diphtheria',
         'short': 'Faucial diphtheria'},
        {'code': '032.1',
         'long': 'Nasopharyngeal diphtheria',
         'short': 'Nasopharynx diphtheria'},
        {'code': '032.2',
         'long': 'Anterior nasal diphtheria',
         'short': 'Ant nasal diphtheria'},
        {'code': '032.3',
         'long': 'Laryngeal diphtheria',
         'short': 'Laryngeal diphtheria'},
        {'code': '032.81',
         'long': 'Conjunctival diphtheria',
         'short': 'Conjunctival diphtheria'},
        {'code': '032.82',
         'long': 'Diphtheritic myocarditis',
         'short': 'Diphtheritic myocarditis'},
        {'code': '032.83',
         'long': 'Diphtheritic peritonitis',
         'short': 'Diphtheritic peritonitis'},
        {'code': '032.84',
         'long': 'Diphtheritic cystitis',
         'short': 'Diphtheritic cystitis'},
        {'code': '032.85',
         'long': 'Cutaneous diphtheria',
         'short': 'Cutaneous diphtheria'},
        {'code': '032.89',
         'long': 'Other specified diphtheria',
         'short': 'Diphtheria NEC'},
        {'code': '032.9',
         'long': 'Diphtheria, unspecified',
         'short': 'Diphtheria NOS'},
        {'code': '033.0',
         'long': 'Whooping cough due to bordetella pertussis [B. pertussis]',
         'short': 'Bordetella pertussis'},
        {'code': '033.1',
         'long': 'Whooping cough due to bordetella parapertussis [B. parapertussis]',
         'short': 'Bordetella parapertussis'},
        {'code': '033.8',
         'long': 'Whooping cough due to other specified organism',
         'short': 'Whooping cough NEC'},
        {'code': '033.9',
         'long': 'Whooping cough, unspecified organism',
         'short': 'Whooping cough NOS'},
        {'code': '034.0',
         'long': 'Streptococcal sore throat',
         'short': 'Strep sore throat'},
        {'code': '034.1', 'long': 'Scarlet fever', 'short': 'Scarlet fever'},
        {'code': '035', 'long': 'Erysipelas', 'short': 'Erysipelas'},
        {'code': '036.0',
         'long': 'Meningococcal meningitis',
         'short': 'Meningococcal meningitis'},
        {'code': '036.1',
         'long': 'Meningococcal encephalitis',
         'short': 'Meningococc encephalitis'},
        {'code': '036.2',
         'long': 'Meningococcemia',
         'short': 'Meningococcemia'},
        {'code': '036.3',
         'long': 'Waterhouse-Friderichsen syndrome, meningococcal',
         'short': 'Meningococc adrenal synd'},
        {'code': '036.40',
         'long': 'Meningococcal carditis, unspecified',
         'short': 'Meningococc carditis NOS'},
        {'code': '036.41',
         'long': 'Meningococcal pericarditis',
         'short': 'Meningococc pericarditis'},
        {'code': '036.42',
         'long': 'Meningococcal endocarditis',
         'short': 'Meningococc endocarditis'},
        {'code': '036.43',
         'long': 'Meningococcal myocarditis',
         'short': 'Meningococc myocarditis'},
        {'code': '036.81',
         'long': 'Meningococcal optic neuritis',
         'short': 'Meningococc optic neurit'},
        {'code': '036.82',
         'long': 'Meningococcal arthropathy',
         'short': 'Meningococc arthropathy'},
        {'code': '036.89',
         'long': 'Other specified meningococcal infections',
         'short': 'Meningococcal infect NEC'},
        {'code': '036.9',
         'long': 'Meningococcal infection, unspecified',
         'short': 'Meningococcal infect NOS'},
        {'code': '037', 'long': 'Tetanus', 'short': 'Tetanus'},
        {'code': '038.0',
         'long': 'Streptococcal septicemia',
         'short': 'Streptococcal septicemia'},
        {'code': '038.10',
         'long': 'Staphylococcal septicemia, unspecified',
         'short': 'Staphylcocc septicem NOS'},
        {'code': '038.11',
         'long': 'Methicillin susceptible Staphylococcus aureus septicemia',
         'short': 'Meth susc Staph aur sept'},
        {'code': '038.12',
         'long': 'Methicillin resistant Staphylococcus aureus septicemia',
         'short': 'MRSA septicemia'},
        {'code': '038.19',
         'long': 'Other staphylococcal septicemia',
         'short': 'Staphylcocc septicem NEC'},
        {'code': '038.2',
         'long': 'Pneumococcal septicemia [Streptococcus pneumoniae septicemia]',
         'short': 'Pneumococcal septicemia'},
        {'code': '038.3',
         'long': 'Septicemia due to anaerobes',
         'short': 'Anaerobic septicemia'},
        {'code': '038.40',
         'long': 'Septicemia due to gram-negative organism, unspecified',
         'short': 'Gram-neg septicemia NOS'},
        {'code': '038.41',
         'long': 'Septicemia due to hemophilus influenzae [H. influenzae]',
         'short': 'H. influenae septicemia'},
        {'code': '038.42',
         'long': 'Septicemia due to escherichia coli [E. coli]',
         'short': 'E coli septicemia'},
        {'code': '038.43',
         'long': 'Septicemia due to pseudomonas',
         'short': 'Pseudomonas septicemia'},
        {'code': '038.44',
         'long': 'Septicemia due to serratia',
         'short': 'Serratia septicemia'},
        {'code': '038.49',
         'long': 'Other septicemia due to gram-negative organisms',
         'short': 'Gram-neg septicemia NEC'},
        {'code': '038.8',
         'long': 'Other specified septicemias',
         'short': 'Septicemia NEC'},
        {'code': '038.9',
         'long': 'Unspecified septicemia',
         'short': 'Septicemia NOS'},
        {'code': '039.0',
         'long': 'Cutaneous actinomycotic infection',
         'short': 'Cutaneous actinomycosis'},
        {'code': '039.1',
         'long': 'Pulmonary actinomycotic infection',
         'short': 'Pulmonary actinomycosis'},
        {'code': '039.2',
         'long': 'Abdominal actinomycotic infection',
         'short': 'Abdominal actinomycosis'},
        {'code': '039.3',
         'long': 'Cervicofacial actinomycotic infection',
         'short': 'Cervicofac actinomycosis'},
        {'code': '039.4', 'long': 'Madura foot', 'short': 'Madura foot'},
        {'code': '039.8',
         'long': 'Actinomycotic infection of other specified sites',
         'short': 'Actinomycosis NEC'},
        {'code': '039.9',
         'long': 'Actinomycotic infection of unspecified site',
         'short': 'Actinomycosis NOS'},
        {'code': '040.0', 'long': 'Gas gangrene', 'short': 'Gas gangrene'},
        {'code': '040.1', 'long': 'Rhinoscleroma', 'short': 'Rhinoscleroma'},
        {'code': '040.2',
         'long': "Whipple's disease",
         'short': "Whipple's disease"},
        {'code': '040.3',
         'long': 'Necrobacillosis',
         'short': 'Necrobacillosis'},
        {'code': '040.41',
         'long': 'Infant botulism',
         'short': 'Infant botulism'},
        {'code': '040.42',
         'long': 'Wound botulism',
         'short': 'Wound botulism'},
        {'code': '040.81',
         'long': 'Tropical pyomyositis',
         'short': 'Tropical pyomyositis'},
        {'code': '040.82',
         'long': 'Toxic shock syndrome',
         'short': 'Toxic shock syndrome'},
        {'code': '040.89',
         'long': 'Other specified bacterial diseases',
         'short': 'Bacterial diseases NEC'},
        {'code': '041.00',
         'long': 'Streptococcus infection in conditions classified elsewhere and of unspecified site, streptococcus, unspecified',
         'short': 'Streptococcus unspecf'},
        {'code': '041.01',
         'long': 'Streptococcus infection in conditions classified elsewhere and of unspecified site, streptococcus, group A',
         'short': 'Streptococcus group a'},
        {'code': '041.02',
         'long': 'Streptococcus infection in conditions classified elsewhere and of unspecified site, streptococcus, group B',
         'short': 'Streptococcus group b'},
        {'code': '041.03',
         'long': 'Streptococcus infection in conditions classified elsewhere and of unspecified site, streptococcus, group C',
         'short': 'Streptococcus group c'},
        {'code': '041.04',
         'long': 'Streptococcus infection in conditions classified elsewhere and of unspecified site, streptococcus, group D [Enterococcus]',
         'short': 'Enterococcus group d'},
        {'code': '041.05',
         'long': 'Streptococcus infection in conditions classified elsewhere and of unspecified site, streptococcus, group G',
         'short': 'Streptococcus group g'},
        {'code': '041.09',
         'long': 'Streptococcus infection in conditions classified elsewhere and of unspecified site, other streptococcus',
         'short': 'Other streptococcus'},
        {'code': '041.10',
         'long': 'Staphylococcus infection in conditions classified elsewhere and of unspecified site, staphylococcus, unspecified',
         'short': 'Staphylococcus unspcfied'},
        {'code': '041.11',
         'long': 'Methicillin susceptible Staphylococcus aureus in conditions classified elsewhere and of unspecified site',
         'short': 'Mth sus Stph aur els/NOS'},
        {'code': '041.12',
         'long': 'Methicillin resistant Staphylococcus aureus in conditions classified elsewhere and of unspecified site',
         'short': 'MRSA elsewhere/NOS'},
        {'code': '041.19',
         'long': 'Staphylococcus infection in conditions classified elsewhere and of unspecified site, other staphylococcus',
         'short': 'Other staphylococcus'},
        {'code': '041.2',
         'long': 'Pneumococcus infection in conditions classified elsewhere and of unspecified site',
         'short': 'Pneumococcus infect NOS'},
        {'code': '041.3',
         'long': "Friedl\xc3\xa4nder's bacillus infection in conditions classified elsewhere and of unspecified site",
         'short': 'Klebsiella pneumoniae'},
        {'code': '041.41',
         'long': 'Shiga toxin-producing Escherichia coli [E. coli] (STEC) O157',
         'short': 'Shiga txn-produce E.coli'},
        {'code': '041.42',
         'long': 'Other specified Shiga toxin-producing Escherichia coli [E. coli] (STEC)',
         'short': 'Shga txn prod E.coli NEC'},
        {'code': '041.43',
         'long': 'Shiga toxin-producing Escherichia coli [E. coli] (STEC), unspecified',
         'short': 'Shga txn prod E.coli NOS'},
        {'code': '041.49',
         'long': 'Other and unspecified Escherichia coli [E. coli]',
         'short': 'E.coli infection NEC/NOS'},
        {'code': '041.5',
         'long': 'Hemophilus influenzae [H. influenzae] infection in conditions classified elsewhere and of unspecified site',
         'short': 'H. influenzae infect NOS'},
        {'code': '041.6',
         'long': 'Proteus (mirabilis) (morganii) infection in conditions classified elsewhere and of unspecified site',
         'short': 'Proteus infection NOS'},
        {'code': '041.7',
         'long': 'Pseudomonas infection in conditions classified elsewhere and of unspecified site',
         'short': 'Pseudomonas infect NOS'},
        {'code': '041.81',
         'long': 'Other specified bacterial infections in conditions classified elsewhere and of unspecified site, mycoplasma',
         'short': 'Mycoplasma'},
        {'code': '041.82',
         'long': 'Bacteroides fragilis',
         'short': 'Bacteroides fragilis'},
        {'code': '041.83',
         'long': 'Other specified bacterial infections in conditions classified elsewhere and of unspecified site, Clostridium perfringens',
         'short': 'Clostridium perfringens'},
        {'code': '041.84',
         'long': 'Other specified bacterial infections in conditions classified elsewhere and of unspecified site, other anaerobes',
         'short': 'Other anaerobes'},
        {'code': '041.85',
         'long': 'Other specified bacterial infections in conditions classified elsewhere and of unspecified site, other gram-negative organisms',
         'short': 'Oth gram negatv bacteria'},
        {'code': '041.86',
         'long': 'Helicobacter pylori [H. pylori]',
         'short': 'Helicobacter pylori'},
        {'code': '041.89',
         'long': 'Other specified bacterial infections in conditions classified elsewhere and of unspecified site, other specified bacteria',
         'short': 'Oth specf bacteria'},
        {'code': '041.9',
         'long': 'Bacterial infection, unspecified, in conditions classified elsewhere and of unspecified site',
         'short': 'Bacterial infection NOS'},
        {'code': '042',
         'long': 'Human immunodeficiency virus [HIV] disease',
         'short': 'Human immuno virus dis'},
        {'code': '045.00',
         'long': 'Acute paralytic poliomyelitis specified as bulbar, poliovirus, unspecified type',
         'short': 'Ac bulbar polio-type NOS'},
        {'code': '045.01',
         'long': 'Acute paralytic poliomyelitis specified as bulbar, poliovirus type I',
         'short': 'Ac bulbar polio-type 1'},
        {'code': '045.02',
         'long': 'Acute paralytic poliomyelitis specified as bulbar, poliovirus type II',
         'short': 'Ac bulbar polio-type 2'},
        {'code': '045.03',
         'long': 'Acute paralytic poliomyelitis specified as bulbar, poliovirus type III',
         'short': 'Ac bulbar polio-type 3'},
        {'code': '045.10',
         'long': 'Acute poliomyelitis with other paralysis, poliovirus, unspecified type',
         'short': 'Paral polio NEC-type NOS'},
        {'code': '045.11',
         'long': 'Acute poliomyelitis with other paralysis, poliovirus type I',
         'short': 'Paral polio NEC-type 1'},
        {'code': '045.12',
         'long': 'Acute poliomyelitis with other paralysis, poliovirus type II',
         'short': 'Paral polio NEC-type 2'},
        {'code': '045.13',
         'long': 'Acute poliomyelitis with other paralysis, poliovirus type III',
         'short': 'Paral polio NEC-type 3'},
        {'code': '045.20',
         'long': 'Acute nonparalytic poliomyelitis, poliovirus, unspecified type',
         'short': 'Nonparaly polio-type NOS'},
        {'code': '045.21',
         'long': 'Acute nonparalytic poliomyelitis, poliovirus type I',
         'short': 'Nonparalyt polio-type 1'},
        {'code': '045.22',
         'long': 'Acute nonparalytic poliomyelitis, poliovirus type II',
         'short': 'Nonparalyt polio-type 2'},
        {'code': '045.23',
         'long': 'Acute nonparalytic poliomyelitis, poliovirus type III',
         'short': 'Nonparalyt polio-type 3'},
        {'code': '045.90',
         'long': 'Acute poliomyelitis, unspecified, poliovirus, unspecified type',
         'short': 'Ac polio NOS-type NOS'},
        {'code': '045.91',
         'long': 'Acute poliomyelitis, unspecified, poliovirus type I',
         'short': 'Ac polio NOS-type 1'},
        {'code': '045.92',
         'long': 'Acute poliomyelitis, unspecified, poliovirus type II',
         'short': 'Ac polio NOS-type 2'},
        {'code': '045.93',
         'long': 'Acute poliomyelitis, unspecified, poliovirus type III',
         'short': 'Ac polio NOS-type 3'},
        {'code': '046.0', 'long': 'Kuru', 'short': 'Kuru'},
        {'code': '046.11',
         'long': 'Variant Creutzfeldt-Jakob disease',
         'short': 'Varnt Creutzfeldt-Jakob'},
        {'code': '046.19',
         'long': 'Other and unspecified Creutzfeldt-Jakob disease',
         'short': 'Creutzfldt-Jakob NEC/NOS'},
        {'code': '046.2',
         'long': 'Subacute sclerosing panencephalitis',
         'short': 'Subac scleros panenceph'},
        {'code': '046.3',
         'long': 'Progressive multifocal leukoencephalopathy',
         'short': 'Prog multifoc leukoencep'},
        {'code': '046.71',
         'long': 'Gerstmann-Str\xc3\xa4ussler-Scheinker syndrome',
         'short': 'Gerstmn-Straus-Schnk syn'},
        {'code': '046.72',
         'long': 'Fatal familial insomnia',
         'short': 'Fatal familial insomnia'},
        {'code': '046.79',
         'long': 'Other and unspecified prion disease of central nervous system',
         'short': 'Prion dis of CNS NEC/NOS'},
        {'code': '046.8',
         'long': 'Other specified slow virus infection of central nervous system',
         'short': 'Cns slow virus infec NEC'},
        {'code': '046.9',
         'long': 'Unspecified slow virus infection of central nervous system',
         'short': 'Cns slow virus infec NOS'},
        {'code': '047.0',
         'long': 'Meningitis due to coxsackie virus',
         'short': 'Coxsackie virus mening'},
        {'code': '047.1',
         'long': 'Meningitis due to echo virus',
         'short': 'Echo virus meningitis'},
        {'code': '047.8',
         'long': 'Other specified viral meningitis',
         'short': 'Viral meningitis NEC'},
        {'code': '047.9',
         'long': 'Unspecified viral meningitis',
         'short': 'Viral meningitis NOS'},
        {'code': '048',
         'long': 'Other enterovirus diseases of central nervous system',
         'short': 'Oth enteroviral cns dis'},
        {'code': '049.0',
         'long': 'Lymphocytic choriomeningitis',
         'short': 'Lymphocytic choriomening'},
        {'code': '049.1',
         'long': 'Meningitis due to adenovirus',
         'short': 'Adenoviral meningitis'},
        {'code': '049.8',
         'long': 'Other specified non-arthropod-borne viral diseases of central nervous system',
         'short': 'Viral encephalitis NEC'},
        {'code': '049.9',
         'long': 'Unspecified non-arthropod-borne viral diseases of central nervous system',
         'short': 'Viral encephalitis NOS'},
        {'code': '050.0', 'long': 'Variola major', 'short': 'Variola major'},
        {'code': '050.1', 'long': 'Alastrim', 'short': 'Alastrim'},
        {'code': '050.2',
         'long': 'Modified smallpox',
         'short': 'Modified smallpox'},
        {'code': '050.9',
         'long': 'Smallpox, unspecified',
         'short': 'Smallpox NOS'},
        {'code': '051.01', 'long': 'Cowpox', 'short': 'Cowpox'},
        {'code': '051.02',
         'long': 'Vaccinia not from vaccination',
         'short': 'Vaccinia n/f vaccination'},
        {'code': '051.1', 'long': 'Pseudocowpox', 'short': 'Pseudocowpox'},
        {'code': '051.2',
         'long': 'Contagious pustular dermatitis',
         'short': 'Contagious pustular derm'},
        {'code': '051.9',
         'long': 'Paravaccinia, unspecified',
         'short': 'Paravaccinia NOS'},
        {'code': '052.0',
         'long': 'Postvaricella encephalitis',
         'short': 'Postvaricella encephalit'},
        {'code': '052.1',
         'long': 'Varicella (hemorrhagic) pneumonitis',
         'short': 'Varicella pneumonitis'},
        {'code': '052.2',
         'long': 'Postvaricella myelitis',
         'short': 'Postvaricella myelitis'},
        {'code': '052.7',
         'long': 'Chickenpox with other specified complications',
         'short': 'Varicella complicat NEC'},
        {'code': '052.8',
         'long': 'Chickenpox with unspecified complication',
         'short': 'Varicella complicat NOS'},
        {'code': '052.9',
         'long': 'Varicella without mention of complication',
         'short': 'Varicella uncomplicated'},
        {'code': '053.0',
         'long': 'Herpes zoster with meningitis',
         'short': 'Herpes zoster meningitis'},
        {'code': '053.10',
         'long': 'Herpes zoster with unspecified nervous system complication',
         'short': 'H zoster nerv syst NOS'},
        {'code': '053.11',
         'long': 'Geniculate herpes zoster',
         'short': 'Geniculate herpes zoster'},
        {'code': '053.12',
         'long': 'Postherpetic trigeminal neuralgia',
         'short': 'Postherpes trigem neural'},
        {'code': '053.13',
         'long': 'Postherpetic polyneuropathy',
         'short': 'Postherpes polyneuropath'},
        {'code': '053.14',
         'long': 'Herpes zoster myelitis',
         'short': 'Herpes zoster myelitis'},
        {'code': '053.19',
         'long': 'Herpes zoster with other nervous system complications',
         'short': 'H zoster nerv syst NEC'},
        {'code': '053.20',
         'long': 'Herpes zoster dermatitis of eyelid',
         'short': 'Herpes zoster of eyelid'},
        {'code': '053.21',
         'long': 'Herpes zoster keratoconjunctivitis',
         'short': 'H zoster keratoconjunct'},
        {'code': '053.22',
         'long': 'Herpes zoster iridocyclitis',
         'short': 'H zoster iridocyclitis'},
        {'code': '053.29',
         'long': 'Herpes zoster with other ophthalmic complications',
         'short': 'Herpes zoster of eye NEC'},
        {'code': '053.71',
         'long': 'Otitis externa due to herpes zoster',
         'short': 'H zoster otitis externa'},
        {'code': '053.79',
         'long': 'Herpes zoster with other specified complications',
         'short': 'H zoster complicated NEC'},
        {'code': '053.8',
         'long': 'Herpes zoster with unspecified complication',
         'short': 'H zoster complicated NOS'},
        {'code': '053.9',
         'long': 'Herpes zoster without mention of complication',
         'short': 'Herpes zoster NOS'},
        {'code': '054.0',
         'long': 'Eczema herpeticum',
         'short': 'Eczema herpeticum'},
        {'code': '054.10',
         'long': 'Genital herpes, unspecified',
         'short': 'Genital herpes NOS'},
        {'code': '054.11',
         'long': 'Herpetic vulvovaginitis',
         'short': 'Herpetic vulvovaginitis'},
        {'code': '054.12',
         'long': 'Herpetic ulceration of vulva',
         'short': 'Herpetic ulcer of vulva'},
        {'code': '054.13',
         'long': 'Herpetic infection of penis',
         'short': 'Herpetic infect of penis'},
        {'code': '054.19',
         'long': 'Other genital herpes',
         'short': 'Genital herpes NEC'},
        {'code': '054.2',
         'long': 'Herpetic gingivostomatitis',
         'short': 'Herpetic gingivostomat'},
        {'code': '054.3',
         'long': 'Herpetic meningoencephalitis',
         'short': 'Herpetic encephalitis'},
        {'code': '054.40',
         'long': 'Herpes simplex with unspecified ophthalmic complication',
         'short': 'Herpes simplex eye NOS'},
        {'code': '054.41',
         'long': 'Herpes simplex dermatitis of eyelid',
         'short': 'Herpes simplex of eyelid'},
        {'code': '054.42',
         'long': 'Dendritic keratitis',
         'short': 'Dendritic keratitis'},
        {'code': '054.43',
         'long': 'Herpes simplex disciform keratitis',
         'short': 'H simplex keratitis'},
        {'code': '054.44',
         'long': 'Herpes simplex iridocyclitis',
         'short': 'H simplex iridocyclitis'},
        {'code': '054.49',
         'long': 'Herpes simplex with other ophthalmic complications',
         'short': 'Herpes simplex eye NEC'},
        {'code': '054.5',
         'long': 'Herpetic septicemia',
         'short': 'Herpetic septicemia'},
        {'code': '054.6',
         'long': 'Herpetic whitlow',
         'short': 'Herpetic whitlow'},
        {'code': '054.71',
         'long': 'Visceral herpes simplex',
         'short': 'Visceral herpes simplex'},
        {'code': '054.72',
         'long': 'Herpes simplex meningitis',
         'short': 'H simplex meningitis'},
        {'code': '054.73',
         'long': 'Herpes simplex otitis externa',
         'short': 'H simplex otitis externa'},
        {'code': '054.74',
         'long': 'Herpes simplex myelitis',
         'short': 'Herpes simplex myelitis'},
        {'code': '054.79',
         'long': 'Herpes simplex with other specified complications',
         'short': 'H simplex complicat NEC'},
        {'code': '054.8',
         'long': 'Herpes simplex with unspecified complication',
         'short': 'H simplex complicat NOS'},
        {'code': '054.9',
         'long': 'Herpes simplex without mention of complication',
         'short': 'Herpes simplex NOS'},
        {'code': '055.0',
         'long': 'Postmeasles encephalitis',
         'short': 'Postmeasles encephalitis'},
        {'code': '055.1',
         'long': 'Postmeasles pneumonia',
         'short': 'Postmeasles pneumonia'},
        {'code': '055.2',
         'long': 'Postmeasles otitis media',
         'short': 'Postmeasles otitis media'},
        {'code': '055.71',
         'long': 'Measles keratoconjunctivitis',
         'short': 'Measles keratitis'},
        {'code': '055.79',
         'long': 'Measles with other specified complications',
         'short': 'Measles complication NEC'},
        {'code': '055.8',
         'long': 'Measles with unspecified complication',
         'short': 'Measles complication NOS'},
        {'code': '055.9',
         'long': 'Measles without mention of complication',
         'short': 'Measles uncomplicated'},
        {'code': '056.00',
         'long': 'Rubella with unspecified neurological complication',
         'short': 'Rubella nerve compl NOS'},
        {'code': '056.01',
         'long': 'Encephalomyelitis due to rubella',
         'short': 'Rubella encephalitis'},
        {'code': '056.09',
         'long': 'Rubella with other neurological complications',
         'short': 'Rubella nerve compl NEC'},
        {'code': '056.71',
         'long': 'Arthritis due to rubella',
         'short': 'Arthritis due to rubella'},
        {'code': '056.79',
         'long': 'Rubella with other specified complications',
         'short': 'Rubella complication NEC'},
        {'code': '056.8',
         'long': 'Rubella with unspecified complications',
         'short': 'Rubella complication NOS'},
        {'code': '056.9',
         'long': 'Rubella without mention of complication',
         'short': 'Rubella uncomplicated'},
        {'code': '057.0',
         'long': 'Erythema infectiosum (fifth disease)',
         'short': 'Erythema infectiosum'},
        {'code': '057.8',
         'long': 'Other specified viral exanthemata',
         'short': 'Viral exanthemata NEC'},
        {'code': '057.9',
         'long': 'Viral exanthem, unspecified',
         'short': 'Viral exanthemata NOS'},
        {'code': '058.10',
         'long': 'Roseola infantum, unspecified',
         'short': 'Roseola infantum NOS'},
        {'code': '058.11',
         'long': 'Roseola infantum due to human herpesvirus 6',
         'short': 'Roseola infant d/t HHV-6'},
        {'code': '058.12',
         'long': 'Roseola infantum due to human herpesvirus 7',
         'short': 'Roseola infant d/t HHV-7'},
        {'code': '058.21',
         'long': 'Human herpesvirus 6 encephalitis',
         'short': 'Human herpesvir 6 enceph'},
        {'code': '058.29',
         'long': 'Other human herpesvirus encephalitis',
         'short': 'Human herpesvr encph NEC'},
        {'code': '058.81',
         'long': 'Human herpesvirus 6 infection',
         'short': 'Human herpesvirus 6 infc'},
        {'code': '058.82',
         'long': 'Human herpesvirus 7 infection',
         'short': 'Human herpesvirus 7 infc'},
        {'code': '058.89',
         'long': 'Other human herpesvirus infection',
         'short': 'Human herpesvirs inf NEC'},
        {'code': '059.00',
         'long': 'Orthopoxvirus infection, unspecified',
         'short': 'Orthopoxvirus infect NOS'},
        {'code': '059.01', 'long': 'Monkeypox', 'short': 'Monkeypox'},
        {'code': '059.09',
         'long': 'Other orthopoxvirus infections',
         'short': 'Orthopoxvirus infect NEC'},
        {'code': '059.10',
         'long': 'Parapoxvirus infection, unspecified',
         'short': 'Parapoxvirus infectn NOS'},
        {'code': '059.11',
         'long': 'Bovine stomatitis',
         'short': 'Bovine stomatitis'},
        {'code': '059.12', 'long': 'Sealpox', 'short': 'Sealpox'},
        {'code': '059.19',
         'long': 'Other parapoxvirus infections',
         'short': 'Parapoxvirus infectn NEC'},
        {'code': '059.20',
         'long': 'Yatapoxvirus infection, unspecified',
         'short': 'Yatapoxvirus infectn NOS'},
        {'code': '059.21', 'long': 'Tanapox', 'short': 'Tanapox'},
        {'code': '059.22',
         'long': 'Yaba monkey tumor virus',
         'short': 'Yaba monkey tumor virus'},
        {'code': '059.8',
         'long': 'Other poxvirus infections',
         'short': 'Poxvirus infections NEC'},
        {'code': '059.9',
         'long': 'Poxvirus infections, unspecified',
         'short': 'Poxvirus infection NOS'},
        {'code': '060.0',
         'long': 'Sylvatic yellow fever',
         'short': 'Sylvatic yellow fever'},
        {'code': '060.1',
         'long': 'Urban yellow fever',
         'short': 'Urban yellow fever'},
        {'code': '060.9',
         'long': 'Yellow fever, unspecified',
         'short': 'Yellow fever NOS'},
        {'code': '061', 'long': 'Dengue', 'short': 'Dengue'},
        {'code': '062.0',
         'long': 'Japanese encephalitis',
         'short': 'Japanese encephalitis'},
        {'code': '062.1',
         'long': 'Western equine encephalitis',
         'short': 'West equine encephalitis'},
        {'code': '062.2',
         'long': 'Eastern equine encephalitis',
         'short': 'East equine encephalitis'},
        {'code': '062.3',
         'long': 'St. Louis encephalitis',
         'short': 'St Louis encephalitis'},
        {'code': '062.4',
         'long': 'Australian encephalitis',
         'short': 'Australian encephalitis'},
        {'code': '062.5',
         'long': 'California virus encephalitis',
         'short': 'California encephalitis'},
        {'code': '062.8',
         'long': 'Other specified mosquito-borne viral encephalitis',
         'short': 'Mosquit-borne enceph NEC'},
        {'code': '062.9',
         'long': 'Mosquito-borne viral encephalitis, unspecified',
         'short': 'Mosquit-borne enceph NOS'},
        {'code': '063.0',
         'long': 'Russian spring-summer [taiga] encephalitis',
         'short': 'Russia spr-summer enceph'},
        {'code': '063.1', 'long': 'Louping ill', 'short': 'Louping ill'},
        {'code': '063.2',
         'long': 'Central european encephalitis',
         'short': 'Cent Europe encephalitis'},
        {'code': '063.8',
         'long': 'Other specified tick-borne viral encephalitis',
         'short': 'Tick-borne enceph NEC'},
        {'code': '063.9',
         'long': 'Tick-borne viral encephalitis, unspecified',
         'short': 'Tick-borne enceph NOS'},
        {'code': '064',
         'long': 'Viral encephalitis transmitted by other and unspecified arthropods',
         'short': 'Vir enceph arthropod NEC'},
        {'code': '065.0',
         'long': 'Crimean hemorrhagic fever [CHF Congo virus]',
         'short': 'Crimean hemorrhagic fev'},
        {'code': '065.1',
         'long': 'Omsk hemorrhagic fever',
         'short': 'Omsk hemorrhagic fever'},
        {'code': '065.2',
         'long': 'Kyasanur forest disease',
         'short': 'Kyasanur forest disease'},
        {'code': '065.3',
         'long': 'Other tick-borne hemorrhagic fever',
         'short': 'Tick-borne hem fever NEC'},
        {'code': '065.4',
         'long': 'Mosquito-borne hemorrhagic fever',
         'short': 'Mosquito-borne hem fever'},
        {'code': '065.8',
         'long': 'Other specified arthropod-borne hemorrhagic fever',
         'short': 'Arthropod hem fever NEC'},
        {'code': '065.9',
         'long': 'Arthropod-borne hemorrhagic fever, unspecified',
         'short': 'Arthropod hem fever NOS'},
        {'code': '066.0',
         'long': 'Phlebotomus fever',
         'short': 'Phlebotomus fever'},
        {'code': '066.1',
         'long': 'Tick-borne fever',
         'short': 'Tick-borne fever'},
        {'code': '066.2',
         'long': 'Venezuelan equine fever',
         'short': 'Venezuelan equine fever'},
        {'code': '066.3',
         'long': 'Other mosquito-borne fever',
         'short': 'Mosquito-borne fever NEC'},
        {'code': '066.40',
         'long': 'West Nile Fever, unspecified',
         'short': 'West Nile Fever NOS'},
        {'code': '066.41',
         'long': 'West Nile Fever with encephalitis',
         'short': 'West Nile Fever w/enceph'},
        {'code': '066.42',
         'long': 'West Nile Fever with other neurologic manifestation',
         'short': 'West Nile neuro man NEC'},
        {'code': '066.49',
         'long': 'West Nile Fever with other complications',
         'short': 'West Nile w complic NEC'},
        {'code': '066.8',
         'long': 'Other specified arthropod-borne viral diseases',
         'short': 'Arthropod virus NEC'},
        {'code': '066.9',
         'long': 'Arthropod-borne viral disease, unspecified',
         'short': 'Arthropod virus NOS'},
        {'code': '070.0',
         'long': 'Viral hepatitis A with hepatic coma',
         'short': 'Hepatitis A with coma'},
        {'code': '070.1',
         'long': 'Viral hepatitis A without mention of hepatic coma',
         'short': 'Hepatitis A w/o coma'},
        {'code': '070.20',
         'long': 'Viral hepatitis B with hepatic coma, acute or unspecified, without mention of hepatitis delta',
         'short': 'Hpt B acte coma wo dlta'},
        {'code': '070.21',
         'long': 'Viral hepatitis B with hepatic coma, acute or unspecified, with hepatitis delta',
         'short': 'Hpt B acte coma w dlta'},
        {'code': '070.22',
         'long': 'Chronic viral hepatitis B with hepatic coma without hepatitis delta',
         'short': 'Hpt B chrn coma wo dlta'},
        {'code': '070.23',
         'long': 'Chronic viral hepatitis B with hepatic coma with hepatitis delta',
         'short': 'Hpt B chrn coma w dlta'},
        {'code': '070.30',
         'long': 'Viral hepatitis B without mention of hepatic coma, acute or unspecified, without mention of hepatitis delta',
         'short': 'Hpt B acte wo cm wo dlta'},
        {'code': '070.31',
         'long': 'Viral hepatitis B without mention of hepatic coma, acute or unspecified, with hepatitis delta',
         'short': 'Hpt B acte wo cm w dlta'},
        {'code': '070.32',
         'long': 'Chronic viral hepatitis B without mention of hepatic coma without mention of hepatitis delta',
         'short': 'Hpt B chrn wo cm wo dlta'},
        {'code': '070.33',
         'long': 'Chronic viral hepatitis B without mention of hepatic coma with hepatitis delta',
         'short': 'Hpt B chrn wo cm w dlta'},
        {'code': '070.41',
         'long': 'Acute hepatitis C with hepatic coma',
         'short': 'Hpt C acute w hepat Coma'},
        {'code': '070.42',
         'long': 'Hepatitis delta without mention of active hepatitis B disease with hepatic coma',
         'short': 'Hpt dlt wo b w hpt coma'},
        {'code': '070.43',
         'long': 'Hepatitis E with hepatic coma',
         'short': 'Hpt E w hepat Coma'},
        {'code': '070.44',
         'long': 'Chronic hepatitis C with hepatic coma',
         'short': 'Chrnc hpt C w hepat Coma'},
        {'code': '070.49',
         'long': 'Other specified viral hepatitis with hepatic coma',
         'short': 'Oth vrl hepat w hpt coma'},
        {'code': '070.51',
         'long': 'Acute hepatitis C without mention of hepatic coma',
         'short': 'Hpt C acute wo hpat coma'},
        {'code': '070.52',
         'long': 'Hepatitis delta without mention of active hepatitis B disease or hepatic coma',
         'short': 'Hpt dlt wo b wo hpt coma'},
        {'code': '070.53',
         'long': 'Hepatitis E without mention of hepatic coma',
         'short': 'Hpt E wo hepat Coma'},
        {'code': '070.54',
         'long': 'Chronic hepatitis C without mention of hepatic coma',
         'short': 'Chrnc hpt C wo hpat coma'},
        {'code': '070.59',
         'long': 'Other specified viral hepatitis without mention of hepatic coma',
         'short': 'Oth vrl hpat wo hpt coma'},
        {'code': '070.6',
         'long': 'Unspecified viral hepatitis with hepatic coma',
         'short': 'Viral hepat NOS w coma'},
        {'code': '070.70',
         'long': 'Unspecified viral hepatitis C without hepatic coma',
         'short': 'Hpt C w/o hepat coma NOS'},
        {'code': '070.71',
         'long': 'Unspecified viral hepatitis C with hepatic coma',
         'short': 'Hpt C w hepatic coma NOS'},
        {'code': '070.9',
         'long': 'Unspecified viral hepatitis without mention of hepatic coma',
         'short': 'Viral hepat NOS w/o coma'},
        {'code': '071', 'long': 'Rabies', 'short': 'Rabies'},
        {'code': '072.0',
         'long': 'Mumps orchitis',
         'short': 'Mumps orchitis'},
        {'code': '072.1',
         'long': 'Mumps meningitis',
         'short': 'Mumps meningitis'},
        {'code': '072.2',
         'long': 'Mumps encephalitis',
         'short': 'Mumps encephalitis'},
        {'code': '072.3',
         'long': 'Mumps pancreatitis',
         'short': 'Mumps pancreatitis'},
        {'code': '072.71',
         'long': 'Mumps hepatitis',
         'short': 'Mumps hepatitis'},
        {'code': '072.72',
         'long': 'Mumps polyneuropathy',
         'short': 'Mumps polyneuropathy'},
        {'code': '072.79',
         'long': 'Other mumps with other specified complications',
         'short': 'Mumps complication NEC'},
        {'code': '072.8',
         'long': 'Mumps with unspecified complication',
         'short': 'Mumps complication NOS'},
        {'code': '072.9',
         'long': 'Mumps without mention of complication',
         'short': 'Mumps uncomplicated'},
        {'code': '073.0',
         'long': 'Ornithosis with pneumonia',
         'short': 'Ornithosis pneumonia'},
        {'code': '073.7',
         'long': 'Ornithosis with other specified complications',
         'short': 'Ornithosis complicat NEC'},
        {'code': '073.8',
         'long': 'Ornithosis with unspecified complication',
         'short': 'Ornithosis complicat NOS'},
        {'code': '073.9',
         'long': 'Ornithosis, unspecified',
         'short': 'Ornithosis NOS'},
        {'code': '074.0', 'long': 'Herpangina', 'short': 'Herpangina'},
        {'code': '074.1',
         'long': 'Epidemic pleurodynia',
         'short': 'Epidemic pleurodynia'},
        {'code': '074.20',
         'long': 'Coxsackie carditis, unspecified',
         'short': 'Coxsackie carditis NOS'},
        {'code': '074.21',
         'long': 'Coxsackie pericarditis',
         'short': 'Coxsackie pericarditis'},
        {'code': '074.22',
         'long': 'Coxsackie endocarditis',
         'short': 'Coxsackie endocarditis'},
        {'code': '074.23',
         'long': 'Coxsackie myocarditis',
         'short': 'Coxsackie myocarditis'},
        {'code': '074.3',
         'long': 'Hand, foot, and mouth disease',
         'short': 'Hand, foot & mouth dis'},
        {'code': '074.8',
         'long': 'Other specified diseases due to Coxsackie virus',
         'short': 'Coxsackie virus NEC'},
        {'code': '075',
         'long': 'Infectious mononucleosis',
         'short': 'Infectious mononucleosis'},
        {'code': '076.0',
         'long': 'Trachoma, initial stage',
         'short': 'Trachoma, initial stage'},
        {'code': '076.1',
         'long': 'Trachoma, active stage',
         'short': 'Trachoma, active stage'},
        {'code': '076.9',
         'long': 'Trachoma, unspecified',
         'short': 'Trachoma NOS'},
        {'code': '077.0',
         'long': 'Inclusion conjunctivitis',
         'short': 'Inclusion conjunctivitis'},
        {'code': '077.1',
         'long': 'Epidemic keratoconjunctivitis',
         'short': 'Epidem keratoconjunctiv'},
        {'code': '077.2',
         'long': 'Pharyngoconjunctival fever',
         'short': 'Pharyngoconjunct fever'},
        {'code': '077.3',
         'long': 'Other adenoviral conjunctivitis',
         'short': 'Adenoviral conjunct NEC'},
        {'code': '077.4',
         'long': 'Epidemic hemorrhagic conjunctivitis',
         'short': 'Epidem hem conjunctivit'},
        {'code': '077.8',
         'long': 'Other viral conjunctivitis',
         'short': 'Viral conjunctivitis NEC'},
        {'code': '077.98',
         'long': 'Unspecified diseases of conjunctiva due to chlamydiae',
         'short': 'Unsp ds conjuc chlamydia'},
        {'code': '077.99',
         'long': 'Unspecified diseases of conjunctiva due to viruses',
         'short': 'Unsp ds conjuc viruses'},
        {'code': '078.0',
         'long': 'Molluscum contagiosum',
         'short': 'Molluscum contagiosum'},
        {'code': '078.10',
         'long': 'Viral warts, unspecified',
         'short': 'Viral warts NOS'},
        {'code': '078.11',
         'long': 'Condyloma acuminatum',
         'short': 'Condyloma acuminatum'},
        {'code': '078.12', 'long': 'Plantar wart', 'short': 'Plantar wart'},
        {'code': '078.19',
         'long': 'Other specified viral warts',
         'short': 'Oth specfd viral warts'},
        {'code': '078.2',
         'long': 'Sweating fever',
         'short': 'Sweating fever'},
        {'code': '078.3',
         'long': 'Cat-scratch disease',
         'short': 'Cat-scratch disease'},
        {'code': '078.4',
         'long': 'Foot and mouth disease',
         'short': 'Foot & mouth disease'},
        {'code': '078.5',
         'long': 'Cytomegaloviral disease',
         'short': 'Cytomegaloviral disease'},
        {'code': '078.6',
         'long': 'Hemorrhagic nephrosonephritis',
         'short': 'Hem nephrosonephritis'},
        {'code': '078.7',
         'long': 'Arenaviral hemorrhagic fever',
         'short': 'Arenaviral hem fever'},
        {'code': '078.81',
         'long': 'Epidemic vertigo',
         'short': 'Epidemic vertigo'},
        {'code': '078.82',
         'long': 'Epidemic vomiting syndrome',
         'short': 'Epidemic vomiting synd'},
        {'code': '078.88',
         'long': 'Other specified diseases due to chlamydiae',
         'short': 'Oth spec dis chlamydiae'},
        {'code': '078.89',
         'long': 'Other specified diseases due to viruses',
         'short': 'Oth spec dis viruses'},
        {'code': '079.0',
         'long': 'Adenovirus infection in conditions classified elsewhere and of unspecified site',
         'short': 'Adenovirus infect NOS'},
        {'code': '079.1',
         'long': 'Echo virus infection in conditions classified elsewhere and of unspecified site',
         'short': 'Echo virus infect NOS'},
        {'code': '079.2',
         'long': 'Coxsackie virus infection in conditions classified elsewhere and of unspecified site',
         'short': 'Coxsackie virus inf NOS'},
        {'code': '079.3',
         'long': 'Rhinovirus infection in conditions classified elsewhere and of unspecified site',
         'short': 'Rhinovirus infect NOS'},
        {'code': '079.4',
         'long': 'Human papillomavirus in conditions classified elsewhere and of unspecified site',
         'short': 'Human papillomavirus'},
        {'code': '079.50',
         'long': 'Retrovirus, unspecified',
         'short': 'Retrovirus, unspecified'},
        {'code': '079.51',
         'long': 'Human T-cell lymphotrophic virus, type I [HTLV-I]',
         'short': 'Htlv-1 infection oth dis'},
        {'code': '079.52',
         'long': 'Human T-cell lymphotrophic virus, type II [HTLV-II]',
         'short': 'Htlv-ii infectn oth dis'},
        {'code': '079.53',
         'long': 'Human immunodeficiency virus, type 2 [HIV-2]',
         'short': 'Hiv-2 infection oth dis'},
        {'code': '079.59',
         'long': 'Other specified retrovirus',
         'short': 'Oth specfied retrovirus'},
        {'code': '079.6',
         'long': 'Respiratory syncytial virus (RSV)',
         'short': 'Resprtry syncytial virus'},
        {'code': '079.81',
         'long': 'Hantavirus infection',
         'short': 'Hantavirus infection'},
        {'code': '079.82',
         'long': 'SARS-associated coronavirus',
         'short': 'SARS assoc coronavirus'},
        {'code': '079.83',
         'long': 'Parvovirus B19',
         'short': 'Parvovirus B19'},
        {'code': '079.88',
         'long': 'Other specified chlamydial infection',
         'short': 'Oth spcf chlamydial infc'},
        {'code': '079.89',
         'long': 'Other specified viral infection',
         'short': 'Oth specf viral infectn'},
        {'code': '079.98',
         'long': 'Unspecified chlamydial infection',
         'short': 'Chlamydial infection NOS'},
        {'code': '079.99',
         'long': 'Unspecified viral infection',
         'short': 'Viral infection NOS'},
        {'code': '080',
         'long': 'Louse-borne (epidemic) typhus',
         'short': 'Louse-borne typhus'},
        {'code': '081.0',
         'long': 'Murine (endemic) typhus',
         'short': 'Murine typhus'},
        {'code': '081.1',
         'long': "Brill's disease",
         'short': "Brill's disease"},
        {'code': '081.2', 'long': 'Scrub typhus', 'short': 'Scrub typhus'},
        {'code': '081.9',
         'long': 'Typhus, unspecified',
         'short': 'Typhus NOS'},
        {'code': '082.0',
         'long': 'Spotted fevers',
         'short': 'Spotted fevers'},
        {'code': '082.1',
         'long': 'Boutonneuse fever',
         'short': 'Boutonneuse fever'},
        {'code': '082.2',
         'long': 'North Asian tick fever',
         'short': 'North asian tick fever'},
        {'code': '082.3',
         'long': 'Queensland tick typhus',
         'short': 'Queensland tick typhus'},
        {'code': '082.40',
         'long': 'Ehrlichiosis, unspecified',
         'short': 'Ehrlichiosis NOS'},
        {'code': '082.41',
         'long': 'Ehrlichiosis chafeensis [E. chafeensis]',
         'short': 'Ehrlichiosis chafeensis'},
        {'code': '082.49',
         'long': 'Other ehrlichiosis',
         'short': 'Ehrlichiosis NEC'},
        {'code': '082.8',
         'long': 'Other specified tick-borne rickettsioses',
         'short': 'Tick-borne ricketts NEC'},
        {'code': '082.9',
         'long': 'Tick-borne rickettsiosis, unspecified',
         'short': 'Tick-borne ricketts NOS'},
        {'code': '083.0', 'long': 'Q fever', 'short': 'Q fever'},
        {'code': '083.1', 'long': 'Trench fever', 'short': 'Trench fever'},
        {'code': '083.2',
         'long': 'Rickettsialpox',
         'short': 'Rickettsialpox'},
        {'code': '083.8',
         'long': 'Other specified rickettsioses',
         'short': 'Rickettsioses NEC'},
        {'code': '083.9',
         'long': 'Rickettsiosis, unspecified',
         'short': 'Rickettsiosis NOS'},
        {'code': '084.0',
         'long': 'Falciparum malaria [malignant tertian]',
         'short': 'Falciparum malaria'},
        {'code': '084.1',
         'long': 'Vivax malaria [benign tertian]',
         'short': 'Vivax malaria'},
        {'code': '084.2',
         'long': 'Quartan malaria',
         'short': 'Quartan malaria'},
        {'code': '084.3', 'long': 'Ovale malaria', 'short': 'Ovale malaria'},
        {'code': '084.4', 'long': 'Other malaria', 'short': 'Malaria NEC'},
        {'code': '084.5', 'long': 'Mixed malaria', 'short': 'Mixed malaria'},
        {'code': '084.6',
         'long': 'Malaria, unspecified',
         'short': 'Malaria NOS'},
        {'code': '084.7',
         'long': 'Induced malaria',
         'short': 'Induced malaria'},
        {'code': '084.8',
         'long': 'Blackwater fever',
         'short': 'Blackwater fever'},
        {'code': '084.9',
         'long': 'Other pernicious complications of malaria',
         'short': 'Malaria complicated NEC'},
        {'code': '085.0',
         'long': 'Visceral [kala-azar] leishmaniasis',
         'short': 'Visceral leishmaniasis'},
        {'code': '085.1',
         'long': 'Cutaneous leishmaniasis, urban',
         'short': 'Cutan leishmanias urban'},
        {'code': '085.2',
         'long': 'Cutaneous leishmaniasis, Asian desert',
         'short': 'Cutan leishmanias asian'},
        {'code': '085.3',
         'long': 'Cutaneous leishmaniasis, Ethiopian',
         'short': 'Cutan leishmanias ethiop'},
        {'code': '085.4',
         'long': 'Cutaneous leishmaniasis, American',
         'short': 'Cutan leishmanias amer'},
        {'code': '085.5',
         'long': 'Mucocutaneous leishmaniasis, (American)',
         'short': 'Mucocutan leishmaniasis'},
        {'code': '085.9',
         'long': 'Leishmaniasis, unspecified',
         'short': 'Leishmaniasis NOS'},
        {'code': '086.0',
         'long': "Chagas' disease with heart involvement",
         'short': 'Chagas disease of heart'},
        {'code': '086.1',
         'long': "Chagas' disease with other organ involvement",
         'short': 'Chagas dis of oth organ'},
        {'code': '086.2',
         'long': "Chagas' disease without mention of organ involvement",
         'short': 'Chagas disease NOS'},
        {'code': '086.3',
         'long': 'Gambian trypanosomiasis',
         'short': 'Gambian trypanosomiasis'},
        {'code': '086.4',
         'long': 'Rhodesian trypanosomiasis',
         'short': 'Rhodesian trypanosomias'},
        {'code': '086.5',
         'long': 'African trypanosomiasis, unspecified',
         'short': 'African trypanosoma NOS'},
        {'code': '086.9',
         'long': 'Trypanosomiasis, unspecified',
         'short': 'Trypanosomiasis NOS'},
        {'code': '087.0',
         'long': 'Relapsing fever, louse-borne',
         'short': 'Louse-borne relaps fever'},
        {'code': '087.1',
         'long': 'Relapsing fever, tick-borne',
         'short': 'Tick-borne relaps fever'},
        {'code': '087.9',
         'long': 'Relapsing fever, unspecified',
         'short': 'Relapsing fever NOS'},
        {'code': '088.0', 'long': 'Bartonellosis', 'short': 'Bartonellosis'},
        {'code': '088.81', 'long': 'Lyme Disease', 'short': 'Lyme disease'},
        {'code': '088.82', 'long': 'Babesiosis', 'short': 'Babesiosis'},
        {'code': '088.89',
         'long': 'Other specified arthropod-borne diseases, other',
         'short': 'Oth arthropod-borne dis'},
        {'code': '088.9',
         'long': 'Arthropod-borne disease, unspecified',
         'short': 'Arthropod-borne dis NOS'},
        {'code': '090.0',
         'long': 'Early congenital syphilis, symptomatic',
         'short': 'Early cong syph symptom'},
        {'code': '090.1',
         'long': 'Early congenital syphilis, latent',
         'short': 'Early congen syph latent'},
        {'code': '090.2',
         'long': 'Early congenital syphilis, unspecified',
         'short': 'Early congen syph NOS'},
        {'code': '090.3',
         'long': 'Syphilitic interstitial keratitis',
         'short': 'Syphilitic keratitis'},
        {'code': '090.40',
         'long': 'Juvenile neurosyphilis, unspecified',
         'short': 'Juvenile neurosyph NOS'},
        {'code': '090.41',
         'long': 'Congenital syphilitic encephalitis',
         'short': 'Congen syph encephalitis'},
        {'code': '090.42',
         'long': 'Congenital syphilitic meningitis',
         'short': 'Congen syph meningitis'},
        {'code': '090.49',
         'long': 'Other juvenile neurosyphilis',
         'short': 'Juvenile neurosyph NEC'},
        {'code': '090.5',
         'long': 'Other late congenital syphilis, symptomatic',
         'short': 'Late congen syph symptom'},
        {'code': '090.6',
         'long': 'Late congenital syphilis, latent',
         'short': 'Late congen syph latent'},
        {'code': '090.7',
         'long': 'Late congenital syphilis, unspecified',
         'short': 'Late congen syph NOS'},
        {'code': '090.9',
         'long': 'Congenital syphilis, unspecified',
         'short': 'Congenital syphilis NOS'},
        {'code': '091.0',
         'long': 'Genital syphilis (primary)',
         'short': 'Primary genital syphilis'},
        {'code': '091.1',
         'long': 'Primary anal syphilis',
         'short': 'Primary anal syphilis'},
        {'code': '091.2',
         'long': 'Other primary syphilis',
         'short': 'Primary syphilis NEC'},
        {'code': '091.3',
         'long': 'Secondary syphilis of skin or mucous membranes',
         'short': 'Secondary syph skin'},
        {'code': '091.4',
         'long': 'Adenopathy due to secondary syphilis',
         'short': 'Syphilitic adenopathy'},
        {'code': '091.50',
         'long': 'Syphilitic uveitis, unspecified',
         'short': 'Syphilitic uveitis NOS'},
        {'code': '091.51',
         'long': 'Syphilitic chorioretinitis (secondary)',
         'short': 'Syphilit chorioretinitis'},
        {'code': '091.52',
         'long': 'Syphilitic iridocyclitis (secondary)',
         'short': 'Syphilitic iridocyclitis'},
        {'code': '091.61',
         'long': 'Secondary syphilitic periostitis',
         'short': 'Syphilitic periostitis'},
        {'code': '091.62',
         'long': 'Secondary syphilitic hepatitis',
         'short': 'Syphilitic hepatitis'},
        {'code': '091.69',
         'long': 'Secondary syphilis of other viscera',
         'short': 'Second syph viscera NEC'},
        {'code': '091.7',
         'long': 'Secondary syphilis, relapse',
         'short': 'Second syphilis relapse'},
        {'code': '091.81',
         'long': 'Acute syphilitic meningitis (secondary)',
         'short': 'Acute syphil meningitis'},
        {'code': '091.82',
         'long': 'Syphilitic alopecia',
         'short': 'Syphilitic alopecia'},
        {'code': '091.89',
         'long': 'Other forms of secondary syphilis',
         'short': 'Secondary syphilis NEC'},
        {'code': '091.9',
         'long': 'Unspecified secondary syphilis',
         'short': 'Secondary syphilis NOS'},
        {'code': '092.0',
         'long': 'Early syphilis, latent, serological relapse after treatment',
         'short': 'Early syph latent relaps'},
        {'code': '092.9',
         'long': 'Early syphilis, latent, unspecified',
         'short': 'Early syphil latent NOS'},
        {'code': '093.0',
         'long': 'Aneurysm of aorta, specified as syphilitic',
         'short': 'Aortic aneurysm, syphil'},
        {'code': '093.1',
         'long': 'Syphilitic aortitis',
         'short': 'Syphilitic aortitis'},
        {'code': '093.20',
         'long': 'Syphilitic endocarditis of valve, unspecified',
         'short': 'Syphil endocarditis NOS'},
        {'code': '093.21',
         'long': 'Syphilitic endocarditis of mitral valve',
         'short': 'Syphilitic mitral valve'},
        {'code': '093.22',
         'long': 'Syphilitic endocarditis of aortic valve',
         'short': 'Syphilitic aortic valve'},
        {'code': '093.23',
         'long': 'Syphilitic endocarditis of tricuspid valve',
         'short': 'Syphil tricuspid valve'},
        {'code': '093.24',
         'long': 'Syphilitic endocarditis of pulmonary valve',
         'short': 'Syphil pulmonary valve'},
        {'code': '093.81',
         'long': 'Syphilitic pericarditis',
         'short': 'Syphilitic pericarditis'},
        {'code': '093.82',
         'long': 'Syphilitic myocarditis',
         'short': 'Syphilitic myocarditis'},
        {'code': '093.89',
         'long': 'Other specified cardiovascular syphilis',
         'short': 'Cardiovascular syph NEC'},
        {'code': '093.9',
         'long': 'Cardiovascular syphilis, unspecified',
         'short': 'Cardiovascular syph NOS'},
        {'code': '094.0',
         'long': 'Tabes dorsalis',
         'short': 'Tabes dorsalis'},
        {'code': '094.1',
         'long': 'General paresis',
         'short': 'General paresis'},
        {'code': '094.2',
         'long': 'Syphilitic meningitis',
         'short': 'Syphilitic meningitis'},
        {'code': '094.3',
         'long': 'Asymptomatic neurosyphilis',
         'short': 'Asymptomat neurosyphilis'},
        {'code': '094.81',
         'long': 'Syphilitic encephalitis',
         'short': 'Syphilitic encephalitis'},
        {'code': '094.82',
         'long': 'Syphilitic parkinsonism',
         'short': 'Syphilitic parkinsonism'},
        {'code': '094.83',
         'long': 'Syphilitic disseminated retinochoroiditis',
         'short': 'Syph dissem retinitis'},
        {'code': '094.84',
         'long': 'Syphilitic optic atrophy',
         'short': 'Syphilitic optic atrophy'},
        {'code': '094.85',
         'long': 'Syphilitic retrobulbar neuritis',
         'short': 'Syph retrobulb neuritis'},
        {'code': '094.86',
         'long': 'Syphilitic acoustic neuritis',
         'short': 'Syphil acoustic neuritis'},
        {'code': '094.87',
         'long': 'Syphilitic ruptured cerebral aneurysm',
         'short': 'Syph rupt cereb aneurysm'},
        {'code': '094.89',
         'long': 'Other specified neurosyphilis',
         'short': 'Neurosyphilis NEC'},
        {'code': '094.9',
         'long': 'Neurosyphilis, unspecified',
         'short': 'Neurosyphilis NOS'},
        {'code': '095.0',
         'long': 'Syphilitic episcleritis',
         'short': 'Syphilitic episcleritis'},
        {'code': '095.1',
         'long': 'Syphilis of lung',
         'short': 'Syphilis of lung'},
        {'code': '095.2',
         'long': 'Syphilitic peritonitis',
         'short': 'Syphilitic peritonitis'},
        {'code': '095.3',
         'long': 'Syphilis of liver',
         'short': 'Syphilis of liver'},
        {'code': '095.4',
         'long': 'Syphilis of kidney',
         'short': 'Syphilis of kidney'},
        {'code': '095.5',
         'long': 'Syphilis of bone',
         'short': 'Syphilis of bone'},
        {'code': '095.6',
         'long': 'Syphilis of muscle',
         'short': 'Syphilis of muscle'},
        {'code': '095.7',
         'long': 'Syphilis of synovium, tendon, and bursa',
         'short': 'Syphilis of tendon/bursa'},
        {'code': '095.8',
         'long': 'Other specified forms of late symptomatic syphilis',
         'short': 'Late sympt syphilis NEC'},
        {'code': '095.9',
         'long': 'Late symptomatic syphilis, unspecified',
         'short': 'Late sympt syphilis NOS'},
        {'code': '096',
         'long': 'Late syphilis, latent',
         'short': 'Late syphilis latent'},
        {'code': '097.0',
         'long': 'Late syphilis, unspecified',
         'short': 'Late syphilis NOS'},
        {'code': '097.1',
         'long': 'Latent syphilis, unspecified',
         'short': 'Latent syphilis NOS'},
        {'code': '097.9',
         'long': 'Syphilis, unspecified',
         'short': 'Syphilis NOS'},
        {'code': '098.0',
         'long': 'Gonococcal infection (acute) of lower genitourinary tract',
         'short': 'Acute gc infect lower gu'},
        {'code': '098.10',
         'long': 'Gonococcal infection (acute) of upper genitourinary tract, site unspecified',
         'short': 'Gc (acute) upper gu NOS'},
        {'code': '098.11',
         'long': 'Gonococcal cystitis (acute)',
         'short': 'Gc cystitis (acute)'},
        {'code': '098.12',
         'long': 'Gonococcal prostatitis (acute)',
         'short': 'Gc prostatitis (acute)'},
        {'code': '098.13',
         'long': 'Gonococcal epididymo-orchitis (acute)',
         'short': 'Gc orchitis (acute)'},
        {'code': '098.14',
         'long': 'Gonococcal seminal vesiculitis (acute)',
         'short': 'Gc sem vesiculit (acute)'},
        {'code': '098.15',
         'long': 'Gonococcal cervicitis (acute)',
         'short': 'Gc cervicitis (acute)'},
        {'code': '098.16',
         'long': 'Gonococcal endometritis (acute)',
         'short': 'Gc endometritis (acute)'},
        {'code': '098.17',
         'long': 'Gonococcal salpingitis, specified as acute',
         'short': 'Acute gc salpingitis'},
        {'code': '098.19',
         'long': 'Other gonococcal infection (acute) of upper genitourinary tract',
         'short': 'Gc (acute) upper gu NEC'},
        {'code': '098.2',
         'long': 'Gonococcal infection, chronic, of lower genitourinary tract',
         'short': 'Chr gc infect lower gu'},
        {'code': '098.30',
         'long': 'Chronic gonococcal infection of upper genitourinary tract, site unspecified',
         'short': 'Chr gc upper gu NOS'},
        {'code': '098.31',
         'long': 'Gonococcal cystitis, chronic',
         'short': 'Gc cystitis, chronic'},
        {'code': '098.32',
         'long': 'Gonococcal prostatitis, chronic',
         'short': 'Gc prostatitis, chronic'},
        {'code': '098.33',
         'long': 'Gonococcal epididymo-orchitis, chronic',
         'short': 'Gc orchitis, chronic'},
        {'code': '098.34',
         'long': 'Gonococcal seminal vesiculitis, chronic',
         'short': 'Gc sem vesiculitis, chr'},
        {'code': '098.35',
         'long': 'Gonococcal cervicitis, chronic',
         'short': 'Gc cervicitis, chronic'},
        {'code': '098.36',
         'long': 'Gonococcal endometritis, chronic',
         'short': 'Gc endometritis, chronic'},
        {'code': '098.37',
         'long': 'Gonococcal salpingitis (chronic)',
         'short': 'Gc salpingitis (chronic)'},
        {'code': '098.39',
         'long': 'Other chronic gonococcal infection of upper genitourinary tract',
         'short': 'Chr gc upper gu NEC'},
        {'code': '098.40',
         'long': 'Gonococcal conjunctivitis (neonatorum)',
         'short': 'Gonococcal conjunctivit'},
        {'code': '098.41',
         'long': 'Gonococcal iridocyclitis',
         'short': 'Gonococcal iridocyclitis'},
        {'code': '098.42',
         'long': 'Gonococcal endophthalmia',
         'short': 'Gonococcal endophthalmia'},
        {'code': '098.43',
         'long': 'Gonococcal keratitis',
         'short': 'Gonococcal keratitis'},
        {'code': '098.49',
         'long': 'Other gonococcal infection of eye',
         'short': 'Gonococcal eye NEC'},
        {'code': '098.50',
         'long': 'Gonococcal arthritis',
         'short': 'Gonococcal arthritis'},
        {'code': '098.51',
         'long': 'Gonococcal synovitis and tenosynovitis',
         'short': 'Gonococcal synovitis'},
        {'code': '098.52',
         'long': 'Gonococcal bursitis',
         'short': 'Gonococcal bursitis'},
        {'code': '098.53',
         'long': 'Gonococcal spondylitis',
         'short': 'Gonococcal spondylitis'},
        {'code': '098.59',
         'long': 'Other gonococcal infection of joint',
         'short': 'Gc infect joint NEC'},
        {'code': '098.6',
         'long': 'Gonococcal infection of pharynx',
         'short': 'Gonococcal infec pharynx'},
        {'code': '098.7',
         'long': 'Gonococcal infection of anus and rectum',
         'short': 'Gc infect anus & rectum'},
        {'code': '098.81',
         'long': 'Gonococcal keratosis (blennorrhagica)',
         'short': 'Gonococcal keratosis'},
        {'code': '098.82',
         'long': 'Gonococcal meningitis',
         'short': 'Gonococcal meningitis'},
        {'code': '098.83',
         'long': 'Gonococcal pericarditis',
         'short': 'Gonococcal pericarditis'},
        {'code': '098.84',
         'long': 'Gonococcal endocarditis',
         'short': 'Gonococcal endocarditis'},
        {'code': '098.85',
         'long': 'Other gonococcal heart disease',
         'short': 'Gonococcal heart dis NEC'},
        {'code': '098.86',
         'long': 'Gonococcal peritonitis',
         'short': 'Gonococcal peritonitis'},
        {'code': '098.89',
         'long': 'Gonococcal infection of other specified sites',
         'short': 'Gonococcal inf site NEC'},
        {'code': '099.0', 'long': 'Chancroid', 'short': 'Chancroid'},
        {'code': '099.1',
         'long': 'Lymphogranuloma venereum',
         'short': 'Lymphogranuloma venereum'},
        {'code': '099.2',
         'long': 'Granuloma inguinale',
         'short': 'Granuloma inguinale'},
        {'code': '099.3',
         'long': "Reiter's disease",
         'short': "Reiter's disease"},
        {'code': '099.40',
         'long': 'Other nongonococcal urethritis, unspecified',
         'short': 'Unspcf nongnccl urethrts'},
        {'code': '099.41',
         'long': 'Other nongonococcal urethritis, chlamydia trachomatis',
         'short': 'Chlmyd trachomatis ureth'},
        {'code': '099.49',
         'long': 'Other nongonococcal urethritis, other specified organism',
         'short': 'Nongc urth oth spf orgsm'},
        {'code': '099.50',
         'long': 'Other venereal diseases due to chlamydia trachomatis, unspecified site',
         'short': 'Oth VD chlm trch unsp st'},
        {'code': '099.51',
         'long': 'Other venereal diseases due to chlamydia trachomatis, pharynx',
         'short': 'Oth VD chlm trch pharynx'},
        {'code': '099.52',
         'long': 'Other venereal diseases due to chlamydia trachomatis, anus and rectum',
         'short': 'Oth VD chlm trch ans rct'},
        {'code': '099.53',
         'long': 'Other venereal diseases due to chlamydia trachomatis, lower genitourinary sites',
         'short': 'Oth VD chlm trch lowr gu'},
        {'code': '099.54',
         'long': 'Other venereal diseases due to chlamydia trachomatis, other genitourinary sites',
         'short': 'Oth VD chlm trch oth gu'},
        {'code': '099.55',
         'long': 'Other venereal diseases due to chlamydia trachomatis, unspecified genitourinary site',
         'short': 'Ot VD chlm trch unspf gu'},
        {'code': '099.56',
         'long': 'Other venereal diseases due to chlamydia trachomatis, peritoneum',
         'short': 'Ot VD chlm trch prtoneum'},
        {'code': '099.59',
         'long': 'Other venereal diseases due to chlamydia trachomatis, other specified site',
         'short': 'Oth VD chlm trch spcf st'},
        {'code': '099.8',
         'long': 'Other specified venereal diseases',
         'short': 'Venereal disease NEC'},
        {'code': '099.9',
         'long': 'Venereal disease, unspecified',
         'short': 'Venereal disease NOS'},
        {'code': '100.0',
         'long': 'Leptospirosis icterohemorrhagica',
         'short': 'Leptospiros icterohem'},
        {'code': '100.81',
         'long': 'Leptospiral meningitis (aseptic)',
         'short': 'Leptospiral meningitis'},
        {'code': '100.89',
         'long': 'Other specified leptospiral infections',
         'short': 'Leptospiral infect NEC'},
        {'code': '100.9',
         'long': 'Leptospirosis, unspecified',
         'short': 'Leptospirosis NOS'},
        {'code': '101',
         'long': "Vincent's angina",
         'short': "Vincent's angina"},
        {'code': '102.0',
         'long': 'Initial lesions of yaws',
         'short': 'Initial lesions yaws'},
        {'code': '102.1',
         'long': 'Multiple papillomata due to yaws and wet crab yaws',
         'short': 'Multiple papillomata'},
        {'code': '102.2',
         'long': 'Other early skin lesions of yaws',
         'short': 'Early skin yaws NEC'},
        {'code': '102.3',
         'long': 'Hyperkeratosis due to yaws',
         'short': 'Hyperkeratosis of yaws'},
        {'code': '102.4',
         'long': 'Gummata and ulcers due to yaws',
         'short': 'Gummata and ulcers, yaws'},
        {'code': '102.5', 'long': 'Gangosa', 'short': 'Gangosa'},
        {'code': '102.6',
         'long': 'Bone and joint lesions due to yaws',
         'short': 'Yaws of bone & joint'},
        {'code': '102.7',
         'long': 'Other manifestations of yaws',
         'short': 'Yaws manifestations NEC'},
        {'code': '102.8', 'long': 'Latent yaws', 'short': 'Latent yaws'},
        {'code': '102.9', 'long': 'Yaws, unspecified', 'short': 'Yaws NOS'},
        {'code': '103.0',
         'long': 'Primary lesions of pinta',
         'short': 'Pinta primary lesions'},
        {'code': '103.1',
         'long': 'Intermediate lesions of pinta',
         'short': 'Pinta intermed lesions'},
        {'code': '103.2',
         'long': 'Late lesions of pinta',
         'short': 'Pinta late lesions'},
        {'code': '103.3',
         'long': 'Mixed lesions of pinta',
         'short': 'Pinta mixed lesions'},
        {'code': '103.9', 'long': 'Pinta, unspecified', 'short': 'Pinta NOS'},
        {'code': '104.0',
         'long': 'Nonvenereal endemic syphilis',
         'short': 'Nonvenereal endemic syph'},
        {'code': '104.8',
         'long': 'Other specified spirochetal infections',
         'short': 'Spirochetal infect NEC'},
        {'code': '104.9',
         'long': 'Spirochetal infection, unspecified',
         'short': 'Spirochetal infect NOS'},
        {'code': '110.0',
         'long': 'Dermatophytosis of scalp and beard',
         'short': 'Dermatophyt scalp/beard'},
        {'code': '110.1',
         'long': 'Dermatophytosis of nail',
         'short': 'Dermatophytosis of nail'},
        {'code': '110.2',
         'long': 'Dermatophytosis of hand',
         'short': 'Dermatophytosis of hand'},
        {'code': '110.3',
         'long': 'Dermatophytosis of groin and perianal area',
         'short': 'Dermatophytosis of groin'},
        {'code': '110.4',
         'long': 'Dermatophytosis of foot',
         'short': 'Dermatophytosis of foot'},
        {'code': '110.5',
         'long': 'Dermatophytosis of the body',
         'short': 'Dermatophytosis of body'},
        {'code': '110.6',
         'long': 'Deep seated dermatophytosis',
         'short': 'Deep dermatophytosis'},
        {'code': '110.8',
         'long': 'Dermatophytosis of other specified sites',
         'short': 'Dermatophytosis site NEC'},
        {'code': '110.9',
         'long': 'Dermatophytosis of unspecified site',
         'short': 'Dermatophytosis site NOS'},
        {'code': '111.0',
         'long': 'Pityriasis versicolor',
         'short': 'Pityriasis versicolor'},
        {'code': '111.1', 'long': 'Tinea nigra', 'short': 'Tinea nigra'},
        {'code': '111.2', 'long': 'Tinea blanca', 'short': 'Tinea blanca'},
        {'code': '111.3', 'long': 'Black piedra', 'short': 'Black piedra'},
        {'code': '111.8',
         'long': 'Other specified dermatomycoses',
         'short': 'Dermatomycoses NEC'},
        {'code': '111.9',
         'long': 'Dermatomycosis, unspecified',
         'short': 'Dermatomycosis NOS'},
        {'code': '112.0', 'long': 'Candidiasis of mouth', 'short': 'Thrush'},
        {'code': '112.1',
         'long': 'Candidiasis of vulva and vagina',
         'short': 'Candidal vulvovaginitis'},
        {'code': '112.2',
         'long': 'Candidiasis of other urogenital sites',
         'short': 'Candidias urogenital NEC'},
        {'code': '112.3',
         'long': 'Candidiasis of skin and nails',
         'short': 'Cutaneous candidiasis'},
        {'code': '112.4',
         'long': 'Candidiasis of lung',
         'short': 'Candidiasis of lung'},
        {'code': '112.5',
         'long': 'Disseminated candidiasis',
         'short': 'Disseminated candidiasis'},
        {'code': '112.81',
         'long': 'Candidal endocarditis',
         'short': 'Candidal endocarditis'},
        {'code': '112.82',
         'long': 'Candidal otitis externa',
         'short': 'Candidal otitis externa'},
        {'code': '112.83',
         'long': 'Candidal meningitis',
         'short': 'Candidal meningitis'},
        {'code': '112.84',
         'long': 'Candidal esophagitis',
         'short': 'Candidal esophagitis'},
        {'code': '112.85',
         'long': 'Candidal enteritis',
         'short': 'Candidal enteritis'},
        {'code': '112.89',
         'long': 'Other candidiasis of other specified sites',
         'short': 'Candidiasis site NEC'},
        {'code': '112.9',
         'long': 'Candidiasis of unspecified site',
         'short': 'Candidiasis site NOS'},
        {'code': '114.0',
         'long': 'Primary coccidioidomycosis (pulmonary)',
         'short': 'Primary coccidioidomycos'},
        {'code': '114.1',
         'long': 'Primary extrapulmonary coccidioidomycosis',
         'short': 'Prim cutan coccidioid'},
        {'code': '114.2',
         'long': 'Coccidioidal meningitis',
         'short': 'Coccidioidal meningitis'},
        {'code': '114.3',
         'long': 'Other forms of progressive coccidioidomycosis',
         'short': 'Progress coccidioid NEC'},
        {'code': '114.4',
         'long': 'Chronic pulmonary coccidioidomycosis',
         'short': 'Ch pl coccidioidomycosis'},
        {'code': '114.5',
         'long': 'Pulmonary coccidioidomycosis, unspecified',
         'short': 'Pl cocidioidomycosis NOS'},
        {'code': '114.9',
         'long': 'Coccidioidomycosis, unspecified',
         'short': 'Coccidioidomycosis NOS'},
        {'code': '115.00',
         'long': 'Infection by Histoplasma capsulatum, without mention of manifestation',
         'short': 'Histoplasma capsulat NOS'},
        {'code': '115.01',
         'long': 'Infection by Histoplasma capsulatum, meningitis',
         'short': 'Histoplasm capsul mening'},
        {'code': '115.02',
         'long': 'Infection by Histoplasma capsulatum, retinitis',
         'short': 'Histoplasm capsul retina'},
        {'code': '115.03',
         'long': 'Infection by Histoplasma capsulatum, pericarditis',
         'short': 'Histoplasm caps pericard'},
        {'code': '115.04',
         'long': 'Infection by Histoplasma capsulatum, endocarditis',
         'short': 'Histoplasm caps endocard'},
        {'code': '115.05',
         'long': 'Infection by Histoplasma capsulatum, pneumonia',
         'short': 'Histoplasm caps pneumon'},
        {'code': '115.09',
         'long': 'Infection by Histoplasma capsulatum, other',
         'short': 'Histoplasma capsulat NEC'},
        {'code': '115.10',
         'long': 'Infection by Histoplasma duboisii, without mention of manifestation',
         'short': 'Histoplasma duboisii NOS'},
        {'code': '115.11',
         'long': 'Infection by Histoplasma duboisii, meningitis',
         'short': 'Histoplasm dubois mening'},
        {'code': '115.12',
         'long': 'Infection by Histoplasma duboisii, retinitis',
         'short': 'Histoplasm dubois retina'},
        {'code': '115.13',
         'long': 'Infection by Histoplasma duboisii, pericarditis',
         'short': 'Histoplasm dub pericard'},
        {'code': '115.14',
         'long': 'Infection by Histoplasma duboisii, endocarditis',
         'short': 'Histoplasm dub endocard'},
        {'code': '115.15',
         'long': 'Infection by Histoplasma duboisii, pneumonia',
         'short': 'Histoplasm dub pneumonia'},
        {'code': '115.19',
         'long': 'Infection by Histoplasma duboisii, other',
         'short': 'Histoplasma duboisii NEC'},
        {'code': '115.90',
         'long': 'Histoplasmosis, unspecified, without mention of manifestation',
         'short': 'Histoplasmosis NOS'},
        {'code': '115.91',
         'long': 'Histoplasmosis, unspecified, meningitis',
         'short': 'Histoplasmosis meningit'},
        {'code': '115.92',
         'long': 'Histoplasmosis, unspecified, retinitis',
         'short': 'Histoplasmosis retinitis'},
        {'code': '115.93',
         'long': 'Histoplasmosis, unspecified, pericarditis',
         'short': 'Histoplasmosis pericard'},
        {'code': '115.94',
         'long': 'Histoplasmosis, unspecified, endocarditis',
         'short': 'Histoplasmosis endocard'},
        {'code': '115.95',
         'long': 'Histoplasmosis, unspecified, pneumonia',
         'short': 'Histoplasmosis pneumonia'},
        {'code': '115.99',
         'long': 'Histoplasmosis, unspecified, other',
         'short': 'Histoplasmosis NEC'},
        {'code': '116.0', 'long': 'Blastomycosis', 'short': 'Blastomycosis'},
        {'code': '116.1',
         'long': 'Paracoccidioidomycosis',
         'short': 'Paracoccidioidomycosis'},
        {'code': '116.2', 'long': 'Lobomycosis', 'short': 'Lobomycosis'},
        {'code': '117.0',
         'long': 'Rhinosporidiosis',
         'short': 'Rhinosporidiosis'},
        {'code': '117.1',
         'long': 'Sporotrichosis',
         'short': 'Sporotrichosis'},
        {'code': '117.2',
         'long': 'Chromoblastomycosis',
         'short': 'Chromoblastomycosis'},
        {'code': '117.3', 'long': 'Aspergillosis', 'short': 'Aspergillosis'},
        {'code': '117.4',
         'long': 'Mycotic mycetomas',
         'short': 'Mycotic mycetomas'},
        {'code': '117.5',
         'long': 'Cryptococcosis',
         'short': 'Cryptococcosis'},
        {'code': '117.6',
         'long': 'Allescheriosis [Petriellidosis]',
         'short': 'Allescheriosis'},
        {'code': '117.7',
         'long': 'Zygomycosis [Phycomycosis or Mucormycosis]',
         'short': 'Zygomycosis'},
        {'code': '117.8',
         'long': 'Infection by dematiacious fungi [Phaehyphomycosis]',
         'short': 'Dematiacious fungi inf'},
        {'code': '117.9',
         'long': 'Other and unspecified mycoses',
         'short': 'Mycoses NEC & NOS'},
        {'code': '118',
         'long': 'Opportunistic mycoses',
         'short': 'Opportunistic mycoses'},
        {'code': '120.0',
         'long': 'Schistosomiasis due to schistosoma haematobium',
         'short': 'Schistosoma haematobium'},
        {'code': '120.1',
         'long': 'Schistosomiasis due to schistosoma mansoni',
         'short': 'Schistosoma mansoni'},
        {'code': '120.2',
         'long': 'Schistosomiasis due to schistosoma japonicum',
         'short': 'Schistosoma japonicum'},
        {'code': '120.3',
         'long': 'Cutaneous schistosomiasis',
         'short': 'Cutaneous schistosoma'},
        {'code': '120.8',
         'long': 'Other specified schistosomiasis',
         'short': 'Schistosomiasis NEC'},
        {'code': '120.9',
         'long': 'Schistosomiasis, unspecified',
         'short': 'Schistosomiasis NOS'},
        {'code': '121.0',
         'long': 'Opisthorchiasis',
         'short': 'Opisthorchiasis'},
        {'code': '121.1', 'long': 'Clonorchiasis', 'short': 'Clonorchiasis'},
        {'code': '121.2',
         'long': 'Paragonimiasis',
         'short': 'Paragonimiasis'},
        {'code': '121.3', 'long': 'Fascioliasis', 'short': 'Fascioliasis'},
        {'code': '121.4',
         'long': 'Fasciolopsiasis',
         'short': 'Fasciolopsiasis'},
        {'code': '121.5',
         'long': 'Metagonimiasis',
         'short': 'Metagonimiasis'},
        {'code': '121.6',
         'long': 'Heterophyiasis',
         'short': 'Heterophyiasis'},
        {'code': '121.8',
         'long': 'Other specified trematode infections',
         'short': 'Trematode infection NEC'},
        {'code': '121.9',
         'long': 'Trematode infection, unspecified',
         'short': 'Trematode infection NOS'},
        {'code': '122.0',
         'long': 'Echinococcus granulosus infection of liver',
         'short': 'Echinococc granul liver'},
        {'code': '122.1',
         'long': 'Echinococcus granulosus infection of lung',
         'short': 'Echinococc granul lung'},
        {'code': '122.2',
         'long': 'Echinococcus granulosus infection of thyroid',
         'short': 'Echinococc gran thyroid'},
        {'code': '122.3',
         'long': 'Echinococcus granulosus infection, other',
         'short': 'Echinococc granul NEC'},
        {'code': '122.4',
         'long': 'Echinococcus granulosus infection, unspecified',
         'short': 'Echinococc granul NOS'},
        {'code': '122.5',
         'long': 'Echinococcus multilocularis infection of liver',
         'short': 'Echinococ multiloc liver'},
        {'code': '122.6',
         'long': 'Echinococcus multilocularis infection, other',
         'short': 'Echinococc multiloc NEC'},
        {'code': '122.7',
         'long': 'Echinococcus multilocularis infection, unspecified',
         'short': 'Echinococc multiloc NOS'},
        {'code': '122.8',
         'long': 'Echinococcosis, unspecified, of liver',
         'short': 'Echinococcosis NOS liver'},
        {'code': '122.9',
         'long': 'Echinococcosis, other and unspecified',
         'short': 'Echinococcosis NEC/NOS'},
        {'code': '123.0',
         'long': 'Taenia solium infection, intestinal form',
         'short': 'Taenia solium intestine'},
        {'code': '123.1', 'long': 'Cysticercosis', 'short': 'Cysticercosis'},
        {'code': '123.2',
         'long': 'Taenia saginata infection',
         'short': 'Taenia saginata infect'},
        {'code': '123.3',
         'long': 'Taeniasis, unspecified',
         'short': 'Taeniasis NOS'},
        {'code': '123.4',
         'long': 'Diphyllobothriasis, intestinal',
         'short': 'Diphyllobothrias intest'},
        {'code': '123.5',
         'long': 'Sparganosis [larval diphyllobothriasis]',
         'short': 'Sparganosis'},
        {'code': '123.6',
         'long': 'Hymenolepiasis',
         'short': 'Hymenolepiasis'},
        {'code': '123.8',
         'long': 'Other specified cestode infection',
         'short': 'Cestode infection NEC'},
        {'code': '123.9',
         'long': 'Cestode infection, unspecified',
         'short': 'Cestode infection NOS'},
        {'code': '124', 'long': 'Trichinosis', 'short': 'Trichinosis'},
        {'code': '125.0',
         'long': 'Bancroftian filariasis',
         'short': 'Bancroftian filariasis'},
        {'code': '125.1',
         'long': 'Malayan filariasis',
         'short': 'Malayan filariasis'},
        {'code': '125.2', 'long': 'Loiasis', 'short': 'Loiasis'},
        {'code': '125.3',
         'long': 'Onchocerciasis',
         'short': 'Onchocerciasis'},
        {'code': '125.4',
         'long': 'Dipetalonemiasis',
         'short': 'Dipetalonemiasis'},
        {'code': '125.5',
         'long': 'Mansonella ozzardi infection',
         'short': 'Mansonella ozzardi infec'},
        {'code': '125.6',
         'long': 'Other specified filariasis',
         'short': 'Filariasis NEC'},
        {'code': '125.7', 'long': 'Dracontiasis', 'short': 'Dracontiasis'},
        {'code': '125.9',
         'long': 'Unspecified filariasis',
         'short': 'Filariasis NOS'},
        {'code': '126.0',
         'long': 'Ancylostomiasis due to ancylostoma duodenale',
         'short': 'Ancylostoma duodenale'},
        {'code': '126.1',
         'long': 'Necatoriasis due to necator americanus',
         'short': 'Necator Americanus'},
        {'code': '126.2',
         'long': 'Ancylostomiasis due to ancylostoma braziliense',
         'short': 'Ancylostoma braziliense'},
        {'code': '126.3',
         'long': 'Ancylostomiasis due to ancylostoma ceylanicum',
         'short': 'Ancylostoma ceylanicum'},
        {'code': '126.8',
         'long': 'Other specified ancylostoma',
         'short': 'Ancylostoma NEC'},
        {'code': '126.9',
         'long': 'Ancylostomiasis and necatoriasis, unspecified',
         'short': 'Ancylostomiasis NOS'},
        {'code': '127.0', 'long': 'Ascariasis', 'short': 'Ascariasis'},
        {'code': '127.1', 'long': 'Anisakiasis', 'short': 'Anisakiasis'},
        {'code': '127.2',
         'long': 'Strongyloidiasis',
         'short': 'Strongyloidiasis'},
        {'code': '127.3', 'long': 'Trichuriasis', 'short': 'Trichuriasis'},
        {'code': '127.4', 'long': 'Enterobiasis', 'short': 'Enterobiasis'},
        {'code': '127.5', 'long': 'Capillariasis', 'short': 'Capillariasis'},
        {'code': '127.6',
         'long': 'Trichostrongyliasis',
         'short': 'Trichostrongyliasis'},
        {'code': '127.7',
         'long': 'Other specified intestinal helminthiasis',
         'short': 'Intest helminthiasis NEC'},
        {'code': '127.8',
         'long': 'Mixed intestinal helminthiasis',
         'short': 'Mixed intestine helminth'},
        {'code': '127.9',
         'long': 'Intestinal helminthiasis, unspecified',
         'short': 'Intest helminthiasis NOS'},
        {'code': '128.0', 'long': 'Toxocariasis', 'short': 'Toxocariasis'},
        {'code': '128.1',
         'long': 'Gnathostomiasis',
         'short': 'Gnathostomiasis'},
        {'code': '128.8',
         'long': 'Other specified helminthiasis',
         'short': 'Helminthiasis NEC'},
        {'code': '128.9',
         'long': 'Helminth infection, unspecified',
         'short': 'Helminthiasis NOS'},
        {'code': '129',
         'long': 'Intestinal parasitism, unspecified',
         'short': 'Intestin parasitism NOS'},
        {'code': '130.0',
         'long': 'Meningoencephalitis due to toxoplasmosis',
         'short': 'Toxoplasm meningoenceph'},
        {'code': '130.1',
         'long': 'Conjunctivitis due to toxoplasmosis',
         'short': 'Toxoplasm conjunctivitis'},
        {'code': '130.2',
         'long': 'Chorioretinitis due to toxoplasmosis',
         'short': 'Toxoplasm chorioretinit'},
        {'code': '130.3',
         'long': 'Myocarditis due to toxoplasmosis',
         'short': 'Toxoplasma myocarditis'},
        {'code': '130.4',
         'long': 'Pneumonitis due to toxoplasmosis',
         'short': 'Toxoplasma pneumonitis'},
        {'code': '130.5',
         'long': 'Hepatitis due to toxoplasmosis',
         'short': 'Toxoplasma hepatitis'},
        {'code': '130.7',
         'long': 'Toxoplasmosis of other specified sites',
         'short': 'Toxoplasmosis site NEC'},
        {'code': '130.8',
         'long': 'Multisystemic disseminated toxoplasmosis',
         'short': 'Multisystem toxoplasmos'},
        {'code': '130.9',
         'long': 'Toxoplasmosis, unspecified',
         'short': 'Toxoplasmosis NOS'},
        {'code': '131.00',
         'long': 'Urogenital trichomoniasis, unspecified',
         'short': 'Urogenital trichomon NOS'},
        {'code': '131.01',
         'long': 'Trichomonal vulvovaginitis',
         'short': 'Trichomonal vaginitis'},
        {'code': '131.02',
         'long': 'Trichomonal urethritis',
         'short': 'Trichomonal urethritis'},
        {'code': '131.03',
         'long': 'Trichomonal prostatitis',
         'short': 'Trichomonal prostatitis'},
        {'code': '131.09',
         'long': 'Other urogenital trichomoniasis',
         'short': 'Urogenital trichomon NEC'},
        {'code': '131.8',
         'long': 'Trichomoniasis of other specified sites',
         'short': 'Trichomoniasis NEC'},
        {'code': '131.9',
         'long': 'Trichomoniasis, unspecified',
         'short': 'Trichomoniasis NOS'},
        {'code': '132.0',
         'long': 'Pediculus capitis [head louse]',
         'short': 'Pediculus capitis'},
        {'code': '132.1',
         'long': 'Pediculus corporis [body louse]',
         'short': 'Pediculus corporis'},
        {'code': '132.2',
         'long': 'Phthirus pubis [pubic louse]',
         'short': 'Phthirus pubis'},
        {'code': '132.3',
         'long': 'Mixed pediculosis infestation',
         'short': 'Mixed pedicul & phthirus'},
        {'code': '132.9',
         'long': 'Pediculosis, unspecified',
         'short': 'Pediculosis NOS'},
        {'code': '133.0', 'long': 'Scabies', 'short': 'Scabies'},
        {'code': '133.8',
         'long': 'Other acariasis',
         'short': 'Acariasis NEC'},
        {'code': '133.9',
         'long': 'Acariasis, unspecified',
         'short': 'Acariasis NOS'},
        {'code': '134.0', 'long': 'Myiasis', 'short': 'Myiasis'},
        {'code': '134.1',
         'long': 'Other arthropod infestation',
         'short': 'Arthropod infest NEC'},
        {'code': '134.2', 'long': 'Hirudiniasis', 'short': 'Hirudiniasis'},
        {'code': '134.8',
         'long': 'Other specified infestations',
         'short': 'Infestation NEC'},
        {'code': '134.9',
         'long': 'Infestation, unspecified',
         'short': 'Infestation NOS'},
        {'code': '135', 'long': 'Sarcoidosis', 'short': 'Sarcoidosis'},
        {'code': '136.0', 'long': 'Ainhum', 'short': 'Ainhum'},
        {'code': '136.1',
         'long': "Behcet's syndrome",
         'short': "Behcet's syndrome"},
        {'code': '136.21',
         'long': 'Specific infection due to acanthamoeba',
         'short': 'Infectn d/t acanthamoeba'},
        {'code': '136.29',
         'long': 'Other specific infections by free-living amebae',
         'short': 'Infc free-liv amebae NEC'},
        {'code': '136.3',
         'long': 'Pneumocystosis',
         'short': 'Pneumocystosis'},
        {'code': '136.4',
         'long': 'Psorospermiasis',
         'short': 'Psorospermiasis'},
        {'code': '136.5',
         'long': 'Sarcosporidiosis',
         'short': 'Sarcosporidiosis'},
        {'code': '136.8',
         'long': 'Other specified infectious and parasitic diseases',
         'short': 'Infect/parasite dis NEC'},
        {'code': '136.9',
         'long': 'Unspecified infectious and parasitic diseases',
         'short': 'Infect/parasite dis NOS'},
        {'code': '137.0',
         'long': 'Late effects of respiratory or unspecified tuberculosis',
         'short': 'Late effect tb, resp/NOS'},
        {'code': '137.1',
         'long': 'Late effects of central nervous system tuberculosis',
         'short': 'Late effect cns TB'},
        {'code': '137.2',
         'long': 'Late effects of genitourinary tuberculosis',
         'short': 'Late effect gu TB'},
        {'code': '137.3',
         'long': 'Late effects of tuberculosis of bones and joints',
         'short': 'Late eff bone & joint TB'},
        {'code': '137.4',
         'long': 'Late effects of tuberculosis of other specified organs',
         'short': 'Late effect TB NEC'},
        {'code': '138',
         'long': 'Late effects of acute poliomyelitis',
         'short': 'Late effect acute polio'},
        {'code': '139.0',
         'long': 'Late effects of viral encephalitis',
         'short': 'Late eff viral encephal'},
        {'code': '139.1',
         'long': 'Late effects of trachoma',
         'short': 'Late effect of trachoma'},
        {'code': '139.8',
         'long': 'Late effects of other and unspecified infectious and parasitic diseases',
         'short': 'Late eff infect dis NEC'}],
 'CD': [{'code': '140.0',
         'long': 'Malignant neoplasm of upper lip, vermilion border',
         'short': 'Mal neo upper vermilion'},
        {'code': '140.1',
         'long': 'Malignant neoplasm of lower lip, vermilion border',
         'short': 'Mal neo lower vermilion'},
        {'code': '140.3',
         'long': 'Malignant neoplasm of upper lip, inner aspect',
         'short': 'Mal neo upper lip, inner'},
        {'code': '140.4',
         'long': 'Malignant neoplasm of lower lip, inner aspect',
         'short': 'Mal neo lower lip, inner'},
        {'code': '140.5',
         'long': 'Malignant neoplasm of lip, unspecified, inner aspect',
         'short': 'Mal neo lip, inner NOS'},
        {'code': '140.6',
         'long': 'Malignant neoplasm of commissure of lip',
         'short': 'Mal neo lip, commissure'},
        {'code': '140.8',
         'long': 'Malignant neoplasm of other sites of lip',
         'short': 'Mal neo lip NEC'},
        {'code': '140.9',
         'long': 'Malignant neoplasm of lip, unspecified, vermilion border',
         'short': 'Mal neo lip/vermil NOS'},
        {'code': '141.0',
         'long': 'Malignant neoplasm of base of tongue',
         'short': 'Mal neo tongue base'},
        {'code': '141.1',
         'long': 'Malignant neoplasm of dorsal surface of tongue',
         'short': 'Mal neo dorsal tongue'},
        {'code': '141.2',
         'long': 'Malignant neoplasm of tip and lateral border of tongue',
         'short': 'Mal neo tip/lat tongue'},
        {'code': '141.3',
         'long': 'Malignant neoplasm of ventral surface of tongue',
         'short': 'Mal neo ventral tongue'},
        {'code': '141.4',
         'long': 'Malignant neoplasm of anterior two-thirds of tongue, part unspecified',
         'short': 'Mal neo ant 2/3 tongue'},
        {'code': '141.5',
         'long': 'Malignant neoplasm of junctional zone of tongue',
         'short': 'Mal neo tongue junction'},
        {'code': '141.6',
         'long': 'Malignant neoplasm of lingual tonsil',
         'short': 'Mal neo lingual tonsil'},
        {'code': '141.8',
         'long': 'Malignant neoplasm of other sites of tongue',
         'short': 'Malig neo tongue NEC'},
        {'code': '141.9',
         'long': 'Malignant neoplasm of tongue, unspecified',
         'short': 'Malig neo tongue NOS'},
        {'code': '142.0',
         'long': 'Malignant neoplasm of parotid gland',
         'short': 'Malig neo parotid'},
        {'code': '142.1',
         'long': 'Malignant neoplasm of submandibular gland',
         'short': 'Malig neo submandibular'},
        {'code': '142.2',
         'long': 'Malignant neoplasm of sublingual gland',
         'short': 'Malig neo sublingual'},
        {'code': '142.8',
         'long': 'Malignant neoplasm of other major salivary glands',
         'short': 'Mal neo maj salivary NEC'},
        {'code': '142.9',
         'long': 'Malignant neoplasm of salivary gland, unspecified',
         'short': 'Mal neo salivary NOS'},
        {'code': '143.0',
         'long': 'Malignant neoplasm of upper gum',
         'short': 'Malig neo upper gum'},
        {'code': '143.1',
         'long': 'Malignant neoplasm of lower gum',
         'short': 'Malig neo lower gum'},
        {'code': '143.8',
         'long': 'Malignant neoplasm of other sites of gum',
         'short': 'Malig neo gum NEC'},
        {'code': '143.9',
         'long': 'Malignant neoplasm of gum, unspecified',
         'short': 'Malig neo gum NOS'},
        {'code': '144.0',
         'long': 'Malignant neoplasm of anterior portion of floor of mouth',
         'short': 'Mal neo ant floor mouth'},
        {'code': '144.1',
         'long': 'Malignant neoplasm of lateral portion of floor of mouth',
         'short': 'Mal neo lat floor mouth'},
        {'code': '144.8',
         'long': 'Malignant neoplasm of other sites of floor of mouth',
         'short': 'Mal neo mouth floor NEC'},
        {'code': '144.9',
         'long': 'Malignant neoplasm of floor of mouth, part unspecified',
         'short': 'Mal neo mouth floor NOS'},
        {'code': '145.0',
         'long': 'Malignant neoplasm of cheek mucosa',
         'short': 'Mal neo cheek mucosa'},
        {'code': '145.1',
         'long': 'Malignant neoplasm of vestibule of mouth',
         'short': 'Mal neo mouth vestibule'},
        {'code': '145.2',
         'long': 'Malignant neoplasm of hard palate',
         'short': 'Malig neo hard palate'},
        {'code': '145.3',
         'long': 'Malignant neoplasm of soft palate',
         'short': 'Malig neo soft palate'},
        {'code': '145.4',
         'long': 'Malignant neoplasm of uvula',
         'short': 'Malignant neoplasm uvula'},
        {'code': '145.5',
         'long': 'Malignant neoplasm of palate, unspecified',
         'short': 'Malignant neo palate NOS'},
        {'code': '145.6',
         'long': 'Malignant neoplasm of retromolar area',
         'short': 'Malig neo retromolar'},
        {'code': '145.8',
         'long': 'Malignant neoplasm of other specified parts of mouth',
         'short': 'Malig neoplasm mouth NEC'},
        {'code': '145.9',
         'long': 'Malignant neoplasm of mouth, unspecified',
         'short': 'Malig neoplasm mouth NOS'},
        {'code': '146.0',
         'long': 'Malignant neoplasm of tonsil',
         'short': 'Malignant neopl tonsil'},
        {'code': '146.1',
         'long': 'Malignant neoplasm of tonsillar fossa',
         'short': 'Mal neo tonsillar fossa'},
        {'code': '146.2',
         'long': 'Malignant neoplasm of tonsillar pillars (anterior) (posterior)',
         'short': 'Mal neo tonsil pillars'},
        {'code': '146.3',
         'long': 'Malignant neoplasm of vallecula epiglottica',
         'short': 'Malign neopl vallecula'},
        {'code': '146.4',
         'long': 'Malignant neoplasm of anterior aspect of epiglottis',
         'short': 'Mal neo ant epiglottis'},
        {'code': '146.5',
         'long': 'Malignant neoplasm of junctional region of oropharynx',
         'short': 'Mal neo epiglottis junct'},
        {'code': '146.6',
         'long': 'Malignant neoplasm of lateral wall of oropharynx',
         'short': 'Mal neo lat oropharynx'},
        {'code': '146.7',
         'long': 'Malignant neoplasm of posterior wall of oropharynx',
         'short': 'Mal neo post oropharynx'},
        {'code': '146.8',
         'long': 'Malignant neoplasm of other specified sites of oropharynx',
         'short': 'Mal neo oropharynx NEC'},
        {'code': '146.9',
         'long': 'Malignant neoplasm of oropharynx, unspecified site',
         'short': 'Malig neo oropharynx NOS'},
        {'code': '147.0',
         'long': 'Malignant neoplasm of superior wall of nasopharynx',
         'short': 'Mal neo super nasopharyn'},
        {'code': '147.1',
         'long': 'Malignant neoplasm of posterior wall of nasopharynx',
         'short': 'Mal neo post nasopharynx'},
        {'code': '147.2',
         'long': 'Malignant neoplasm of lateral wall of nasopharynx',
         'short': 'Mal neo lat nasopharynx'},
        {'code': '147.3',
         'long': 'Malignant neoplasm of anterior wall of nasopharynx',
         'short': 'Mal neo ant nasopharynx'},
        {'code': '147.8',
         'long': 'Malignant neoplasm of other specified sites of nasopharynx',
         'short': 'Mal neo nasopharynx NEC'},
        {'code': '147.9',
         'long': 'Malignant neoplasm of nasopharynx, unspecified site',
         'short': 'Mal neo nasopharynx NOS'},
        {'code': '148.0',
         'long': 'Malignant neoplasm of postcricoid region of hypopharynx',
         'short': 'Mal neo postcricoid'},
        {'code': '148.1',
         'long': 'Malignant neoplasm of pyriform sinus',
         'short': 'Mal neo pyriform sinus'},
        {'code': '148.2',
         'long': 'Malignant neoplasm of aryepiglottic fold, hypopharyngeal aspect',
         'short': 'Mal neo aryepiglott fold'},
        {'code': '148.3',
         'long': 'Malignant neoplasm of posterior hypopharyngeal wall',
         'short': 'Mal neo post hypopharynx'},
        {'code': '148.8',
         'long': 'Malignant neoplasm of other specified sites of hypopharynx',
         'short': 'Mal neo hypopharynx NEC'},
        {'code': '148.9',
         'long': 'Malignant neoplasm of hypopharynx, unspecified site',
         'short': 'Mal neo hypopharynx NOS'},
        {'code': '149.0',
         'long': 'Malignant neoplasm of pharynx, unspecified',
         'short': 'Mal neo pharynx NOS'},
        {'code': '149.1',
         'long': "Malignant neoplasm of waldeyer's ring",
         'short': "Mal neo waldeyer's ring"},
        {'code': '149.8',
         'long': 'Malignant neoplasm of other sites within the lip and oral cavity',
         'short': 'Mal neo oral/pharynx NEC'},
        {'code': '149.9',
         'long': 'Malignant neoplasm of ill-defined sites within the lip and oral cavity',
         'short': 'Mal neo orophryn ill-def'},
        {'code': '150.0',
         'long': 'Malignant neoplasm of cervical esophagus',
         'short': 'Mal neo cervical esophag'},
        {'code': '150.1',
         'long': 'Malignant neoplasm of thoracic esophagus',
         'short': 'Mal neo thoracic esophag'},
        {'code': '150.2',
         'long': 'Malignant neoplasm of abdominal esophagus',
         'short': 'Mal neo abdomin esophag'},
        {'code': '150.3',
         'long': 'Malignant neoplasm of upper third of esophagus',
         'short': 'Mal neo upper 3rd esoph'},
        {'code': '150.4',
         'long': 'Malignant neoplasm of middle third of esophagus',
         'short': 'Mal neo middle 3rd esoph'},
        {'code': '150.5',
         'long': 'Malignant neoplasm of lower third of esophagus',
         'short': 'Mal neo lower 3rd esoph'},
        {'code': '150.8',
         'long': 'Malignant neoplasm of other specified part of esophagus',
         'short': 'Mal neo esophagus NEC'},
        {'code': '150.9',
         'long': 'Malignant neoplasm of esophagus, unspecified site',
         'short': 'Mal neo esophagus NOS'},
        {'code': '151.0',
         'long': 'Malignant neoplasm of cardia',
         'short': 'Mal neo stomach cardia'},
        {'code': '151.1',
         'long': 'Malignant neoplasm of pylorus',
         'short': 'Malignant neo pylorus'},
        {'code': '151.2',
         'long': 'Malignant neoplasm of pyloric antrum',
         'short': 'Mal neo pyloric antrum'},
        {'code': '151.3',
         'long': 'Malignant neoplasm of fundus of stomach',
         'short': 'Mal neo stomach fundus'},
        {'code': '151.4',
         'long': 'Malignant neoplasm of body of stomach',
         'short': 'Mal neo stomach body'},
        {'code': '151.5',
         'long': 'Malignant neoplasm of lesser curvature of stomach, unspecified',
         'short': 'Mal neo stom lesser curv'},
        {'code': '151.6',
         'long': 'Malignant neoplasm of greater curvature of stomach, unspecified',
         'short': 'Mal neo stom great curv'},
        {'code': '151.8',
         'long': 'Malignant neoplasm of other specified sites of stomach',
         'short': 'Malig neopl stomach NEC'},
        {'code': '151.9',
         'long': 'Malignant neoplasm of stomach, unspecified site',
         'short': 'Malig neopl stomach NOS'},
        {'code': '152.0',
         'long': 'Malignant neoplasm of duodenum',
         'short': 'Malignant neopl duodenum'},
        {'code': '152.1',
         'long': 'Malignant neoplasm of jejunum',
         'short': 'Malignant neopl jejunum'},
        {'code': '152.2',
         'long': 'Malignant neoplasm of ileum',
         'short': 'Malignant neoplasm ileum'},
        {'code': '152.3',
         'long': "Malignant neoplasm of Meckel's diverticulum",
         'short': "Mal neo meckel's divert"},
        {'code': '152.8',
         'long': 'Malignant neoplasm of other specified sites of small intestine',
         'short': 'Mal neo small bowel NEC'},
        {'code': '152.9',
         'long': 'Malignant neoplasm of small intestine, unspecified site',
         'short': 'Mal neo small bowel NOS'},
        {'code': '153.0',
         'long': 'Malignant neoplasm of hepatic flexure',
         'short': 'Mal neo hepatic flexure'},
        {'code': '153.1',
         'long': 'Malignant neoplasm of transverse colon',
         'short': 'Mal neo transverse colon'},
        {'code': '153.2',
         'long': 'Malignant neoplasm of descending colon',
         'short': 'Mal neo descend colon'},
        {'code': '153.3',
         'long': 'Malignant neoplasm of sigmoid colon',
         'short': 'Mal neo sigmoid colon'},
        {'code': '153.4',
         'long': 'Malignant neoplasm of cecum',
         'short': 'Malignant neoplasm cecum'},
        {'code': '153.5',
         'long': 'Malignant neoplasm of appendix vermiformis',
         'short': 'Malignant neo appendix'},
        {'code': '153.6',
         'long': 'Malignant neoplasm of ascending colon',
         'short': 'Malig neo ascend colon'},
        {'code': '153.7',
         'long': 'Malignant neoplasm of splenic flexure',
         'short': 'Mal neo splenic flexure'},
        {'code': '153.8',
         'long': 'Malignant neoplasm of other specified sites of large intestine',
         'short': 'Malignant neo colon NEC'},
        {'code': '153.9',
         'long': 'Malignant neoplasm of colon, unspecified site',
         'short': 'Malignant neo colon NOS'},
        {'code': '154.0',
         'long': 'Malignant neoplasm of rectosigmoid junction',
         'short': 'Mal neo rectosigmoid jct'},
        {'code': '154.1',
         'long': 'Malignant neoplasm of rectum',
         'short': 'Malignant neopl rectum'},
        {'code': '154.2',
         'long': 'Malignant neoplasm of anal canal',
         'short': 'Malig neopl anal canal'},
        {'code': '154.3',
         'long': 'Malignant neoplasm of anus, unspecified site',
         'short': 'Malignant neo anus NOS'},
        {'code': '154.8',
         'long': 'Malignant neoplasm of other sites of rectum, rectosigmoid junction, and anus',
         'short': 'Mal neo rectum/anus NEC'},
        {'code': '155.0',
         'long': 'Malignant neoplasm of liver, primary',
         'short': 'Mal neo liver, primary'},
        {'code': '155.1',
         'long': 'Malignant neoplasm of intrahepatic bile ducts',
         'short': 'Mal neo intrahepat ducts'},
        {'code': '155.2',
         'long': 'Malignant neoplasm of liver, not specified as primary or secondary',
         'short': 'Malignant neo liver NOS'},
        {'code': '156.0',
         'long': 'Malignant neoplasm of gallbladder',
         'short': 'Malig neo gallbladder'},
        {'code': '156.1',
         'long': 'Malignant neoplasm of extrahepatic bile ducts',
         'short': 'Mal neo extrahepat ducts'},
        {'code': '156.2',
         'long': 'Malignant neoplasm of ampulla of vater',
         'short': 'Mal neo ampulla of vater'},
        {'code': '156.8',
         'long': 'Malignant neoplasm of other specified sites of gallbladder and extrahepatic bile ducts',
         'short': 'Malig neo biliary NEC'},
        {'code': '156.9',
         'long': 'Malignant neoplasm of biliary tract, part unspecified site',
         'short': 'Malig neo biliary NOS'},
        {'code': '157.0',
         'long': 'Malignant neoplasm of head of pancreas',
         'short': 'Mal neo pancreas head'},
        {'code': '157.1',
         'long': 'Malignant neoplasm of body of pancreas',
         'short': 'Mal neo pancreas body'},
        {'code': '157.2',
         'long': 'Malignant neoplasm of tail of pancreas',
         'short': 'Mal neo pancreas tail'},
        {'code': '157.3',
         'long': 'Malignant neoplasm of pancreatic duct',
         'short': 'Mal neo pancreatic duct'},
        {'code': '157.4',
         'long': 'Malignant neoplasm of islets of langerhans',
         'short': 'Mal neo islet langerhans'},
        {'code': '157.8',
         'long': 'Malignant neoplasm of other specified sites of pancreas',
         'short': 'Malig neo pancreas NEC'},
        {'code': '157.9',
         'long': 'Malignant neoplasm of pancreas, part unspecified',
         'short': 'Malig neo pancreas NOS'},
        {'code': '158.0',
         'long': 'Malignant neoplasm of retroperitoneum',
         'short': 'Mal neo retroperitoneum'},
        {'code': '158.8',
         'long': 'Malignant neoplasm of specified parts of peritoneum',
         'short': 'Mal neo peritoneum NEC'},
        {'code': '158.9',
         'long': 'Malignant neoplasm of peritoneum, unspecified',
         'short': 'Mal neo peritoneum NOS'},
        {'code': '159.0',
         'long': 'Malignant neoplasm of intestinal tract, part unspecified',
         'short': 'Malig neo intestine NOS'},
        {'code': '159.1',
         'long': 'Malignant neoplasm of spleen, not elsewhere classified',
         'short': 'Malignant neo spleen NEC'},
        {'code': '159.8',
         'long': 'Malignant neoplasm of other sites of digestive system and intra-abdominal organs',
         'short': 'Mal neo gi/intra-abd NEC'},
        {'code': '159.9',
         'long': 'Malignant neoplasm of ill-defined sites within the digestive organs and peritoneum',
         'short': 'Mal neo GI tract ill-def'},
        {'code': '160.0',
         'long': 'Malignant neoplasm of nasal cavities',
         'short': 'Mal neo nasal cavities'},
        {'code': '160.1',
         'long': 'Malignant neoplasm of auditory tube, middle ear, and mastoid air cells',
         'short': 'Malig neo middle ear'},
        {'code': '160.2',
         'long': 'Malignant neoplasm of maxillary sinus',
         'short': 'Mal neo maxillary sinus'},
        {'code': '160.3',
         'long': 'Malignant neoplasm of ethmoidal sinus',
         'short': 'Mal neo ethmoidal sinus'},
        {'code': '160.4',
         'long': 'Malignant neoplasm of frontal sinus',
         'short': 'Malig neo frontal sinus'},
        {'code': '160.5',
         'long': 'Malignant neoplasm of sphenoidal sinus',
         'short': 'Mal neo sphenoid sinus'},
        {'code': '160.8',
         'long': 'Malignant neoplasm of other accessory sinuses',
         'short': 'Mal neo access sinus NEC'},
        {'code': '160.9',
         'long': 'Malignant neoplasm of accessory sinus, unspecified',
         'short': 'Mal neo access sinus NOS'},
        {'code': '161.0',
         'long': 'Malignant neoplasm of glottis',
         'short': 'Malignant neo glottis'},
        {'code': '161.1',
         'long': 'Malignant neoplasm of supraglottis',
         'short': 'Malig neo supraglottis'},
        {'code': '161.2',
         'long': 'Malignant neoplasm of subglottis',
         'short': 'Malig neo subglottis'},
        {'code': '161.3',
         'long': 'Malignant neoplasm of laryngeal cartilages',
         'short': 'Mal neo cartilage larynx'},
        {'code': '161.8',
         'long': 'Malignant neoplasm of other specified sites of larynx',
         'short': 'Malignant neo larynx NEC'},
        {'code': '161.9',
         'long': 'Malignant neoplasm of larynx, unspecified',
         'short': 'Malignant neo larynx NOS'},
        {'code': '162.0',
         'long': 'Malignant neoplasm of trachea',
         'short': 'Malignant neo trachea'},
        {'code': '162.2',
         'long': 'Malignant neoplasm of main bronchus',
         'short': 'Malig neo main bronchus'},
        {'code': '162.3',
         'long': 'Malignant neoplasm of upper lobe, bronchus or lung',
         'short': 'Mal neo upper lobe lung'},
        {'code': '162.4',
         'long': 'Malignant neoplasm of middle lobe, bronchus or lung',
         'short': 'Mal neo middle lobe lung'},
        {'code': '162.5',
         'long': 'Malignant neoplasm of lower lobe, bronchus or lung',
         'short': 'Mal neo lower lobe lung'},
        {'code': '162.8',
         'long': 'Malignant neoplasm of other parts of bronchus or lung',
         'short': 'Mal neo bronch/lung NEC'},
        {'code': '162.9',
         'long': 'Malignant neoplasm of bronchus and lung, unspecified',
         'short': 'Mal neo bronch/lung NOS'},
        {'code': '163.0',
         'long': 'Malignant neoplasm of parietal pleura',
         'short': 'Mal neo parietal pleura'},
        {'code': '163.1',
         'long': 'Malignant neoplasm of visceral pleura',
         'short': 'Mal neo visceral pleura'},
        {'code': '163.8',
         'long': 'Malignant neoplasm of other specified sites of pleura',
         'short': 'Malig neopl pleura NEC'},
        {'code': '163.9',
         'long': 'Malignant neoplasm of pleura, unspecified',
         'short': 'Malig neopl pleura NOS'},
        {'code': '164.0',
         'long': 'Malignant neoplasm of thymus',
         'short': 'Malignant neopl thymus'},
        {'code': '164.1',
         'long': 'Malignant neoplasm of heart',
         'short': 'Malignant neopl heart'},
        {'code': '164.2',
         'long': 'Malignant neoplasm of anterior mediastinum',
         'short': 'Mal neo ant mediastinum'},
        {'code': '164.3',
         'long': 'Malignant neoplasm of posterior mediastinum',
         'short': 'Mal neo post mediastinum'},
        {'code': '164.8',
         'long': 'Malignant neoplasm of other parts of mediastinum',
         'short': 'Mal neo mediastinum NEC'},
        {'code': '164.9',
         'long': 'Malignant neoplasm of mediastinum, part unspecified',
         'short': 'Mal neo mediastinum NOS'},
        {'code': '165.0',
         'long': 'Malignant neoplasm of upper respiratory tract, part unspecified',
         'short': 'Mal neo upper resp NOS'},
        {'code': '165.8',
         'long': 'Malignant neoplasm of other sites within the respiratory system and intrathoracic organs',
         'short': 'Mal neo thorax/resp NEC'},
        {'code': '165.9',
         'long': 'Malignant neoplasm of ill-defined sites within the respiratory system',
         'short': 'Mal neo resp system NOS'},
        {'code': '170.0',
         'long': 'Malignant neoplasm of bones of skull and face, except mandible',
         'short': 'Mal neo skull/face bone'},
        {'code': '170.1',
         'long': 'Malignant neoplasm of mandible',
         'short': 'Malignant neo mandible'},
        {'code': '170.2',
         'long': 'Malignant neoplasm of vertebral column, excluding sacrum and coccyx',
         'short': 'Malig neo vertebrae'},
        {'code': '170.3',
         'long': 'Malignant neoplasm of ribs, sternum, and clavicle',
         'short': 'Mal neo ribs/stern/clav'},
        {'code': '170.4',
         'long': 'Malignant neoplasm of scapula and long bones of upper limb',
         'short': 'Mal neo long bones arm'},
        {'code': '170.5',
         'long': 'Malignant neoplasm of short bones of upper limb',
         'short': 'Mal neo bones wrist/hand'},
        {'code': '170.6',
         'long': 'Malignant neoplasm of pelvic bones, sacrum, and coccyx',
         'short': 'Mal neo pelvic girdle'},
        {'code': '170.7',
         'long': 'Malignant neoplasm of long bones of lower limb',
         'short': 'Mal neo long bones leg'},
        {'code': '170.8',
         'long': 'Malignant neoplasm of short bones of lower limb',
         'short': 'Mal neo bones ankle/foot'},
        {'code': '170.9',
         'long': 'Malignant neoplasm of bone and articular cartilage, site unspecified',
         'short': 'Malig neopl bone NOS'},
        {'code': '171.0',
         'long': 'Malignant neoplasm of connective and other soft tissue of head, face, and neck',
         'short': 'Mal neo soft tissue head'},
        {'code': '171.2',
         'long': 'Malignant neoplasm of connective and other soft tissue of upper limb, including shoulder',
         'short': 'Mal neo soft tissue arm'},
        {'code': '171.3',
         'long': 'Malignant neoplasm of connective and other soft tissue of lower limb, including hip',
         'short': 'Mal neo soft tissue leg'},
        {'code': '171.4',
         'long': 'Malignant neoplasm of connective and other soft tissue of thorax',
         'short': 'Mal neo soft tis thorax'},
        {'code': '171.5',
         'long': 'Malignant neoplasm of connective and other soft tissue of abdomen',
         'short': 'Mal neo soft tis abdomen'},
        {'code': '171.6',
         'long': 'Malignant neoplasm of connective and other soft tissue of pelvis',
         'short': 'Mal neo soft tis pelvis'},
        {'code': '171.7',
         'long': 'Malignant neoplasm of connective and other soft tissue of trunk, unspecified',
         'short': 'Mal neopl trunk NOS'},
        {'code': '171.8',
         'long': 'Malignant neoplasm of other specified sites of connective and other soft tissue',
         'short': 'Mal neo soft tissue NEC'},
        {'code': '171.9',
         'long': 'Malignant neoplasm of connective and other soft tissue, site unspecified',
         'short': 'Mal neo soft tissue NOS'},
        {'code': '172.0',
         'long': 'Malignant melanoma of skin of lip',
         'short': 'Malig melanoma lip'},
        {'code': '172.1',
         'long': 'Malignant melanoma of skin of eyelid, including canthus',
         'short': 'Malig melanoma eyelid'},
        {'code': '172.2',
         'long': 'Malignant melanoma of skin of ear and external auditory canal',
         'short': 'Malig melanoma ear'},
        {'code': '172.3',
         'long': 'Malignant melanoma of skin of other and unspecified parts of face',
         'short': 'Mal melanom face NEC/NOS'},
        {'code': '172.4',
         'long': 'Malignant melanoma of skin of scalp and neck',
         'short': 'Mal melanoma scalp/neck'},
        {'code': '172.5',
         'long': 'Malignant melanoma of skin of trunk, except scrotum',
         'short': 'Malig melanoma trunk'},
        {'code': '172.6',
         'long': 'Malignant melanoma of skin of upper limb, including shoulder',
         'short': 'Malig melanoma arm'},
        {'code': '172.7',
         'long': 'Malignant melanoma of skin of lower limb, including hip',
         'short': 'Malig melanoma leg'},
        {'code': '172.8',
         'long': 'Malignant melanoma of other specified sites of skin',
         'short': 'Malig melanoma skin NEC'},
        {'code': '172.9',
         'long': 'Melanoma of skin, site unspecified',
         'short': 'Malig melanoma skin NOS'},
        {'code': '173.00',
         'long': 'Unspecified malignant neoplasm of skin of lip',
         'short': 'Malig neopl skin lip NOS'},
        {'code': '173.01',
         'long': 'Basal cell carcinoma of skin of lip',
         'short': 'Basal cell ca skin lip'},
        {'code': '173.02',
         'long': 'Squamous cell carcinoma of skin of lip',
         'short': 'Squamous cell ca skn lip'},
        {'code': '173.09',
         'long': 'Other specified malignant neoplasm of skin of lip',
         'short': 'Malig neo skin lip NEC'},
        {'code': '173.10',
         'long': 'Unspecified malignant neoplasm of eyelid, including canthus',
         'short': 'Mal neo eyelid/canth NOS'},
        {'code': '173.11',
         'long': 'Basal cell carcinoma of eyelid, including canthus',
         'short': 'Basal cell ca lid/canth'},
        {'code': '173.12',
         'long': 'Squamous cell carcinoma of eyelid, including canthus',
         'short': 'Squam cell ca lid/canth'},
        {'code': '173.19',
         'long': 'Other specified malignant neoplasm of eyelid, including canthus',
         'short': 'Mal neo eyelid/canth NEC'},
        {'code': '173.20',
         'long': 'Unspecified malignant neoplasm of skin of ear and external auditory canal',
         'short': 'Malig neo skin ear NOS'},
        {'code': '173.21',
         'long': 'Basal cell carcinoma of skin of ear and external auditory canal',
         'short': 'Basal cell ca skin ear'},
        {'code': '173.22',
         'long': 'Squamous cell carcinoma of skin of ear and external auditory canal',
         'short': 'Squam cell ca skin ear'},
        {'code': '173.29',
         'long': 'Other specified malignant neoplasm of skin of ear and external auditory canal',
         'short': 'Neo skin ear/ex canl NEC'},
        {'code': '173.30',
         'long': 'Unspecified malignant neoplasm of skin of other and unspecified parts of face',
         'short': 'Mal neo skn face NEC/NOS'},
        {'code': '173.31',
         'long': 'Basal cell carcinoma of skin of other and unspecified parts of face',
         'short': 'Bsl cel skn face NEC/NOS'},
        {'code': '173.32',
         'long': 'Squamous cell carcinoma of skin of other and unspecified parts of face',
         'short': 'Sqm cel skn face NEC/NOS'},
        {'code': '173.39',
         'long': 'Other specified malignant neoplasm of skin of other and unspecified parts of face',
         'short': 'Mal neo skn face NEC/NOS'},
        {'code': '173.40',
         'long': 'Unspecified malignant neoplasm of scalp and skin of neck',
         'short': 'Mal neo sclp/skn nck NOS'},
        {'code': '173.41',
         'long': 'Basal cell carcinoma of scalp and skin of neck',
         'short': 'Bsl cell ca scalp/skn nk'},
        {'code': '173.42',
         'long': 'Squamous cell carcinoma of scalp and skin of neck',
         'short': 'Sqam cell ca sclp/skn nk'},
        {'code': '173.49',
         'long': 'Other specified malignant neoplasm of scalp and skin of neck',
         'short': 'Mal neo sclp/skn nck NEC'},
        {'code': '173.50',
         'long': 'Unspecified malignant neoplasm of skin of trunk, except scrotum',
         'short': 'Malig neo skin trunk NOS'},
        {'code': '173.51',
         'long': 'Basal cell carcinoma of skin of trunk, except scrotum',
         'short': 'Basal cell ca skin trunk'},
        {'code': '173.52',
         'long': 'Squamous cell carcinoma of skin of trunk, except scrotum',
         'short': 'Squam cell ca skin trunk'},
        {'code': '173.59',
         'long': 'Other specified malignant neoplasm of skin of trunk, except scrotum',
         'short': 'Malig neo skin trunk NEC'},
        {'code': '173.60',
         'long': 'Unspecified malignant neoplasm of skin of upper limb, including shoulder',
         'short': 'Mal neo skin up limb NOS'},
        {'code': '173.61',
         'long': 'Basal cell carcinoma of skin of upper limb, including shoulder',
         'short': 'Basal cell ca skn up lmb'},
        {'code': '173.62',
         'long': 'Squamous cell carcinoma of skin of upper limb, including shoulder',
         'short': 'Squam cell ca skn up lmb'},
        {'code': '173.69',
         'long': 'Other specified malignant neoplasm of skin of upper limb, including shoulder',
         'short': 'Malig neo skn up lmb NEC'},
        {'code': '173.70',
         'long': 'Unspecified malignant neoplasm of skin of lower limb, including hip',
         'short': 'Mal neo skn low limb NOS'},
        {'code': '173.71',
         'long': 'Basal cell carcinoma of skin of lower limb, including hip',
         'short': 'Basl cell ca skn low lmb'},
        {'code': '173.72',
         'long': 'Squamous cell carcinoma of skin of lower limb, including hip',
         'short': 'Sqam cell ca skn low lmb'},
        {'code': '173.79',
         'long': 'Other specified malignant neoplasm of skin of lower limb, including hip',
         'short': 'Mal neo skin low lmb NEC'},
        {'code': '173.80',
         'long': 'Unspecified malignant neoplasm of other specified sites of skin',
         'short': 'Mal neo skn site NEC/NOS'},
        {'code': '173.81',
         'long': 'Basal cell carcinoma of other specified sites of skin',
         'short': 'Bsl cell ca skn site NEC'},
        {'code': '173.82',
         'long': 'Squamous cell carcinoma of other specified sites of skin',
         'short': 'Sqm cell ca skn site NEC'},
        {'code': '173.89',
         'long': 'Other specified malignant neoplasm of other specified sites of skin',
         'short': 'Oth mal neo skn site NEC'},
        {'code': '173.90',
         'long': 'Unspecified malignant neoplasm of skin, site unspecified',
         'short': 'Malig neo skin site NOS'},
        {'code': '173.91',
         'long': 'Basal cell carcinoma of skin, site unspecified',
         'short': 'Basal cell ca skin NOS'},
        {'code': '173.92',
         'long': 'Squamous cell carcinoma of skin, site unspecified',
         'short': 'Squam cell ca skin NOS'},
        {'code': '173.99',
         'long': 'Other specified malignant neoplasm of skin, site unspecified',
         'short': 'Oth mal neo skn site NOS'},
        {'code': '174.0',
         'long': 'Malignant neoplasm of nipple and areola of female breast',
         'short': 'Malig neo nipple'},
        {'code': '174.1',
         'long': 'Malignant neoplasm of central portion of female breast',
         'short': 'Mal neo breast-central'},
        {'code': '174.2',
         'long': 'Malignant neoplasm of upper-inner quadrant of female breast',
         'short': 'Mal neo breast up-inner'},
        {'code': '174.3',
         'long': 'Malignant neoplasm of lower-inner quadrant of female breast',
         'short': 'Mal neo breast low-inner'},
        {'code': '174.4',
         'long': 'Malignant neoplasm of upper-outer quadrant of female breast',
         'short': 'Mal neo breast up-outer'},
        {'code': '174.5',
         'long': 'Malignant neoplasm of lower-outer quadrant of female breast',
         'short': 'Mal neo breast low-outer'},
        {'code': '174.6',
         'long': 'Malignant neoplasm of axillary tail of female breast',
         'short': 'Mal neo breast-axillary'},
        {'code': '174.8',
         'long': 'Malignant neoplasm of other specified sites of female breast',
         'short': 'Malign neopl breast NEC'},
        {'code': '174.9',
         'long': 'Malignant neoplasm of breast (female), unspecified',
         'short': 'Malign neopl breast NOS'},
        {'code': '175.0',
         'long': 'Malignant neoplasm of nipple and areola of male breast',
         'short': 'Mal neo male nipple'},
        {'code': '175.9',
         'long': 'Malignant neoplasm of other and unspecified sites of male breast',
         'short': 'Mal neo male breast NEC'},
        {'code': '176.0',
         'long': "Kaposi's sarcoma, skin",
         'short': "Skin - kaposi's sarcoma"},
        {'code': '176.1',
         'long': "Kaposi's sarcoma, soft tissue",
         'short': "Sft tisue - kpsi's srcma"},
        {'code': '176.2',
         'long': "Kaposi's sarcoma, palate",
         'short': "Palate - kpsi's sarcoma"},
        {'code': '176.3',
         'long': "Kaposi's sarcoma, gastrointestinal sites",
         'short': "GI sites - kpsi's srcoma"},
        {'code': '176.4',
         'long': "Kaposi's sarcoma, lung",
         'short': "Lung - kaposi's sarcoma"},
        {'code': '176.5',
         'long': "Kaposi's sarcoma, lymph nodes",
         'short': "Lym nds - kpsi's sarcoma"},
        {'code': '176.8',
         'long': "Kaposi's sarcoma, other specified sites",
         'short': "Spf sts - kpsi's sarcoma"},
        {'code': '176.9',
         'long': "Kaposi's sarcoma, unspecified site",
         'short': "Kaposi's sarcoma NOS"},
        {'code': '179',
         'long': 'Malignant neoplasm of uterus, part unspecified',
         'short': 'Malig neopl uterus NOS'},
        {'code': '180.0',
         'long': 'Malignant neoplasm of endocervix',
         'short': 'Malig neo endocervix'},
        {'code': '180.1',
         'long': 'Malignant neoplasm of exocervix',
         'short': 'Malig neo exocervix'},
        {'code': '180.8',
         'long': 'Malignant neoplasm of other specified sites of cervix',
         'short': 'Malig neo cervix NEC'},
        {'code': '180.9',
         'long': 'Malignant neoplasm of cervix uteri, unspecified site',
         'short': 'Mal neo cervix uteri NOS'},
        {'code': '181',
         'long': 'Malignant neoplasm of placenta',
         'short': 'Malignant neopl placenta'},
        {'code': '182.0',
         'long': 'Malignant neoplasm of corpus uteri, except isthmus',
         'short': 'Malig neo corpus uteri'},
        {'code': '182.1',
         'long': 'Malignant neoplasm of isthmus',
         'short': 'Mal neo uterine isthmus'},
        {'code': '182.8',
         'long': 'Malignant neoplasm of other specified sites of body of uterus',
         'short': 'Mal neo body uterus NEC'},
        {'code': '183.0',
         'long': 'Malignant neoplasm of ovary',
         'short': 'Malign neopl ovary'},
        {'code': '183.2',
         'long': 'Malignant neoplasm of fallopian tube',
         'short': 'Mal neo fallopian tube'},
        {'code': '183.3',
         'long': 'Malignant neoplasm of broad ligament of uterus',
         'short': 'Mal neo broad ligament'},
        {'code': '183.4',
         'long': 'Malignant neoplasm of parametrium',
         'short': 'Malig neo parametrium'},
        {'code': '183.5',
         'long': 'Malignant neoplasm of round ligament of uterus',
         'short': 'Mal neo round ligament'},
        {'code': '183.8',
         'long': 'Malignant neoplasm of other specified sites of uterine adnexa',
         'short': 'Mal neo adnexa NEC'},
        {'code': '183.9',
         'long': 'Malignant neoplasm of uterine adnexa, unspecified site',
         'short': 'Mal neo adnexa NOS'},
        {'code': '184.0',
         'long': 'Malignant neoplasm of vagina',
         'short': 'Malign neopl vagina'},
        {'code': '184.1',
         'long': 'Malignant neoplasm of labia majora',
         'short': 'Mal neo labia majora'},
        {'code': '184.2',
         'long': 'Malignant neoplasm of labia minora',
         'short': 'Mal neo labia minora'},
        {'code': '184.3',
         'long': 'Malignant neoplasm of clitoris',
         'short': 'Malign neopl clitoris'},
        {'code': '184.4',
         'long': 'Malignant neoplasm of vulva, unspecified site',
         'short': 'Malign neopl vulva NOS'},
        {'code': '184.8',
         'long': 'Malignant neoplasm of other specified sites of female genital organs',
         'short': 'Mal neo female genit NEC'},
        {'code': '184.9',
         'long': 'Malignant neoplasm of female genital organ, site unspecified',
         'short': 'Mal neo female genit NOS'},
        {'code': '185',
         'long': 'Malignant neoplasm of prostate',
         'short': 'Malign neopl prostate'},
        {'code': '186.0',
         'long': 'Malignant neoplasm of undescended testis',
         'short': 'Mal neo undescend testis'},
        {'code': '186.9',
         'long': 'Malignant neoplasm of other and unspecified testis',
         'short': 'Malig neo testis NEC'},
        {'code': '187.1',
         'long': 'Malignant neoplasm of prepuce',
         'short': 'Malign neopl prepuce'},
        {'code': '187.2',
         'long': 'Malignant neoplasm of glans penis',
         'short': 'Malig neo glans penis'},
        {'code': '187.3',
         'long': 'Malignant neoplasm of body of penis',
         'short': 'Malig neo penis body'},
        {'code': '187.4',
         'long': 'Malignant neoplasm of penis, part unspecified',
         'short': 'Malig neo penis NOS'},
        {'code': '187.5',
         'long': 'Malignant neoplasm of epididymis',
         'short': 'Malig neo epididymis'},
        {'code': '187.6',
         'long': 'Malignant neoplasm of spermatic cord',
         'short': 'Mal neo spermatic cord'},
        {'code': '187.7',
         'long': 'Malignant neoplasm of scrotum',
         'short': 'Malign neopl scrotum'},
        {'code': '187.8',
         'long': 'Malignant neoplasm of other specified sites of male genital organs',
         'short': 'Mal neo male genital NEC'},
        {'code': '187.9',
         'long': 'Malignant neoplasm of male genital organ, site unspecified',
         'short': 'Mal neo male genital NOS'},
        {'code': '188.0',
         'long': 'Malignant neoplasm of trigone of urinary bladder',
         'short': 'Mal neo bladder-trigone'},
        {'code': '188.1',
         'long': 'Malignant neoplasm of dome of urinary bladder',
         'short': 'Mal neo bladder-dome'},
        {'code': '188.2',
         'long': 'Malignant neoplasm of lateral wall of urinary bladder',
         'short': 'Mal neo bladder-lateral'},
        {'code': '188.3',
         'long': 'Malignant neoplasm of anterior wall of urinary bladder',
         'short': 'Mal neo bladder-anterior'},
        {'code': '188.4',
         'long': 'Malignant neoplasm of posterior wall of urinary bladder',
         'short': 'Mal neo bladder-post'},
        {'code': '188.5',
         'long': 'Malignant neoplasm of bladder neck',
         'short': 'Mal neo bladder neck'},
        {'code': '188.6',
         'long': 'Malignant neoplasm of ureteric orifice',
         'short': 'Mal neo ureteric orifice'},
        {'code': '188.7',
         'long': 'Malignant neoplasm of urachus',
         'short': 'Malig neo urachus'},
        {'code': '188.8',
         'long': 'Malignant neoplasm of other specified sites of bladder',
         'short': 'Malig neo bladder NEC'},
        {'code': '188.9',
         'long': 'Malignant neoplasm of bladder, part unspecified',
         'short': 'Malig neo bladder NOS'},
        {'code': '189.0',
         'long': 'Malignant neoplasm of kidney, except pelvis',
         'short': 'Malig neopl kidney'},
        {'code': '189.1',
         'long': 'Malignant neoplasm of renal pelvis',
         'short': 'Malig neo renal pelvis'},
        {'code': '189.2',
         'long': 'Malignant neoplasm of ureter',
         'short': 'Malign neopl ureter'},
        {'code': '189.3',
         'long': 'Malignant neoplasm of urethra',
         'short': 'Malign neopl urethra'},
        {'code': '189.4',
         'long': 'Malignant neoplasm of paraurethral glands',
         'short': 'Mal neo paraurethral'},
        {'code': '189.8',
         'long': 'Malignant neoplasm of other specified sites of urinary organs',
         'short': 'Mal neo urinary NEC'},
        {'code': '189.9',
         'long': 'Malignant neoplasm of urinary organ, site unspecified',
         'short': 'Mal neo urinary NOS'},
        {'code': '190.0',
         'long': 'Malignant neoplasm of eyeball, except conjunctiva, cornea, retina, and choroid',
         'short': 'Malign neopl eyeball'},
        {'code': '190.1',
         'long': 'Malignant neoplasm of orbit',
         'short': 'Malign neopl orbit'},
        {'code': '190.2',
         'long': 'Malignant neoplasm of lacrimal gland',
         'short': 'Mal neo lacrimal gland'},
        {'code': '190.3',
         'long': 'Malignant neoplasm of conjunctiva',
         'short': 'Mal neo conjunctiva'},
        {'code': '190.4',
         'long': 'Malignant neoplasm of cornea',
         'short': 'Malign neopl cornea'},
        {'code': '190.5',
         'long': 'Malignant neoplasm of retina',
         'short': 'Malign neopl retina'},
        {'code': '190.6',
         'long': 'Malignant neoplasm of choroid',
         'short': 'Malign neopl choroid'},
        {'code': '190.7',
         'long': 'Malignant neoplasm of lacrimal duct',
         'short': 'Mal neo lacrimal duct'},
        {'code': '190.8',
         'long': 'Malignant neoplasm of other specified sites of eye',
         'short': 'Malign neopl eye NEC'},
        {'code': '190.9',
         'long': 'Malignant neoplasm of eye, part unspecified',
         'short': 'Malign neopl eye NOS'},
        {'code': '191.0',
         'long': 'Malignant neoplasm of cerebrum, except lobes and ventricles',
         'short': 'Malign neopl cerebrum'},
        {'code': '191.1',
         'long': 'Malignant neoplasm of frontal lobe',
         'short': 'Malig neo frontal lobe'},
        {'code': '191.2',
         'long': 'Malignant neoplasm of temporal lobe',
         'short': 'Mal neo temporal lobe'},
        {'code': '191.3',
         'long': 'Malignant neoplasm of parietal lobe',
         'short': 'Mal neo parietal lobe'},
        {'code': '191.4',
         'long': 'Malignant neoplasm of occipital lobe',
         'short': 'Mal neo occipital lobe'},
        {'code': '191.5',
         'long': 'Malignant neoplasm of ventricles',
         'short': 'Mal neo cereb ventricle'},
        {'code': '191.6',
         'long': 'Malignant neoplasm of cerebellum nos',
         'short': 'Mal neo cerebellum NOS'},
        {'code': '191.7',
         'long': 'Malignant neoplasm of brain stem',
         'short': 'Mal neo brain stem'},
        {'code': '191.8',
         'long': 'Malignant neoplasm of other parts of brain',
         'short': 'Malig neo brain NEC'},
        {'code': '191.9',
         'long': 'Malignant neoplasm of brain, unspecified',
         'short': 'Malig neo brain NOS'},
        {'code': '192.0',
         'long': 'Malignant neoplasm of cranial nerves',
         'short': 'Mal neo cranial nerves'},
        {'code': '192.1',
         'long': 'Malignant neoplasm of cerebral meninges',
         'short': 'Mal neo cerebral mening'},
        {'code': '192.2',
         'long': 'Malignant neoplasm of spinal cord',
         'short': 'Mal neo spinal cord'},
        {'code': '192.3',
         'long': 'Malignant neoplasm of spinal meninges',
         'short': 'Mal neo spinal meninges'},
        {'code': '192.8',
         'long': 'Malignant neoplasm of other specified sites of nervous system',
         'short': 'Mal neo nervous syst NEC'},
        {'code': '192.9',
         'long': 'Malignant neoplasm of nervous system, part unspecified',
         'short': 'Mal neo nervous syst NOS'},
        {'code': '193',
         'long': 'Malignant neoplasm of thyroid gland',
         'short': 'Malign neopl thyroid'},
        {'code': '194.0',
         'long': 'Malignant neoplasm of adrenal gland',
         'short': 'Malign neopl adrenal'},
        {'code': '194.1',
         'long': 'Malignant neoplasm of parathyroid gland',
         'short': 'Malig neo parathyroid'},
        {'code': '194.3',
         'long': 'Malignant neoplasm of pituitary gland and craniopharyngeal duct',
         'short': 'Malig neo pituitary'},
        {'code': '194.4',
         'long': 'Malignant neoplasm of pineal gland',
         'short': 'Malign neo pineal gland'},
        {'code': '194.5',
         'long': 'Malignant neoplasm of carotid body',
         'short': 'Mal neo carotid body'},
        {'code': '194.6',
         'long': 'Malignant neoplasm of aortic body and other paraganglia',
         'short': 'Mal neo paraganglia NEC'},
        {'code': '194.8',
         'long': 'Malignant neoplasm of other endocrine glands and related structures',
         'short': 'Mal neo endocrine NEC'},
        {'code': '194.9',
         'long': 'Malignant neoplasm of endocrine gland, site unspecified',
         'short': 'Mal neo endocrine NOS'},
        {'code': '195.0',
         'long': 'Malignant neoplasm of head, face, and neck',
         'short': 'Mal neo head/face/neck'},
        {'code': '195.1',
         'long': 'Malignant neoplasm of thorax',
         'short': 'Malign neopl thorax'},
        {'code': '195.2',
         'long': 'Malignant neoplasm of abdomen',
         'short': 'Malig neo abdomen'},
        {'code': '195.3',
         'long': 'Malignant neoplasm of pelvis',
         'short': 'Malign neopl pelvis'},
        {'code': '195.4',
         'long': 'Malignant neoplasm of upper limb',
         'short': 'Malign neopl arm'},
        {'code': '195.5',
         'long': 'Malignant neoplasm of lower limb',
         'short': 'Malign neopl leg'},
        {'code': '195.8',
         'long': 'Malignant neoplasm of other specified sites',
         'short': 'Malig neo site NEC'},
        {'code': '196.0',
         'long': 'Secondary and unspecified malignant neoplasm of lymph nodes of head, face, and neck',
         'short': 'Mal neo lymph-head/neck'},
        {'code': '196.1',
         'long': 'Secondary and unspecified malignant neoplasm of intrathoracic lymph nodes',
         'short': 'Mal neo lymph-intrathor'},
        {'code': '196.2',
         'long': 'Secondary and unspecified malignant neoplasm of intra-abdominal lymph nodes',
         'short': 'Mal neo lymph intra-abd'},
        {'code': '196.3',
         'long': 'Secondary and unspecified malignant neoplasm of lymph nodes of axilla and upper limb',
         'short': 'Mal neo lymph-axilla/arm'},
        {'code': '196.5',
         'long': 'Secondary and unspecified malignant neoplasm of lymph nodes of inguinal region and lower limb',
         'short': 'Mal neo lymph-inguin/leg'},
        {'code': '196.6',
         'long': 'Secondary and unspecified malignant neoplasm of intrapelvic lymph nodes',
         'short': 'Mal neo lymph-intrapelv'},
        {'code': '196.8',
         'long': 'Secondary and unspecified malignant neoplasm of lymph nodes of multiple sites',
         'short': 'Mal neo lymph node-mult'},
        {'code': '196.9',
         'long': 'Secondary and unspecified malignant neoplasm of lymph nodes, site unspecified',
         'short': 'Mal neo lymph node NOS'},
        {'code': '197.0',
         'long': 'Secondary malignant neoplasm of lung',
         'short': 'Secondary malig neo lung'},
        {'code': '197.1',
         'long': 'Secondary malignant neoplasm of mediastinum',
         'short': 'Sec mal neo mediastinum'},
        {'code': '197.2',
         'long': 'Secondary malignant neoplasm of pleura',
         'short': 'Second malig neo pleura'},
        {'code': '197.3',
         'long': 'Secondary malignant neoplasm of other respiratory organs',
         'short': 'Sec malig neo resp NEC'},
        {'code': '197.4',
         'long': 'Secondary malignant neoplasm of small intestine including duodenum',
         'short': 'Sec malig neo sm bowel'},
        {'code': '197.5',
         'long': 'Secondary malignant neoplasm of large intestine and rectum',
         'short': 'Sec malig neo lg bowel'},
        {'code': '197.6',
         'long': 'Secondary malignant neoplasm of retroperitoneum and peritoneum',
         'short': 'Sec mal neo peritoneum'},
        {'code': '197.7',
         'long': 'Malignant neoplasm of liver, secondary',
         'short': 'Second malig neo liver'},
        {'code': '197.8',
         'long': 'Secondary malignant neoplasm of other digestive organs and spleen',
         'short': 'Sec mal neo GI NEC'},
        {'code': '198.0',
         'long': 'Secondary malignant neoplasm of kidney',
         'short': 'Second malig neo kidney'},
        {'code': '198.1',
         'long': 'Secondary malignant neoplasm of other urinary organs',
         'short': 'Sec malig neo urin NEC'},
        {'code': '198.2',
         'long': 'Secondary malignant neoplasm of skin',
         'short': 'Secondary malig neo skin'},
        {'code': '198.3',
         'long': 'Secondary malignant neoplasm of brain and spinal cord',
         'short': 'Sec mal neo brain/spine'},
        {'code': '198.4',
         'long': 'Secondary malignant neoplasm of other parts of nervous system',
         'short': 'Sec malig neo nerve NEC'},
        {'code': '198.5',
         'long': 'Secondary malignant neoplasm of bone and bone marrow',
         'short': 'Secondary malig neo bone'},
        {'code': '198.6',
         'long': 'Secondary malignant neoplasm of ovary',
         'short': 'Second malig neo ovary'},
        {'code': '198.7',
         'long': 'Secondary malignant neoplasm of adrenal gland',
         'short': 'Second malig neo adrenal'},
        {'code': '198.81',
         'long': 'Secondary malignant neoplasm of breast',
         'short': 'Second malig neo breast'},
        {'code': '198.82',
         'long': 'Secondary malignant neoplasm of genital organs',
         'short': 'Second malig neo genital'},
        {'code': '198.89',
         'long': 'Secondary malignant neoplasm of other specified sites',
         'short': 'Secondary malig neo NEC'},
        {'code': '199.0',
         'long': 'Disseminated malignant neoplasm without specification of site',
         'short': 'Malig neo disseminated'},
        {'code': '199.1',
         'long': 'Other malignant neoplasm without specification of site',
         'short': 'Malignant neoplasm NOS'},
        {'code': '199.2',
         'long': 'Malignant neoplasm associated with transplant organ',
         'short': 'Malig neopl-transp organ'},
        {'code': '200.00',
         'long': 'Reticulosarcoma, unspecified site, extranodal and solid organ sites',
         'short': 'Retclsrc unsp xtrndl org'},
        {'code': '200.01',
         'long': 'Reticulosarcoma, lymph nodes of head, face, and neck',
         'short': 'Reticulosarcoma head'},
        {'code': '200.02',
         'long': 'Reticulosarcoma, intrathoracic lymph nodes',
         'short': 'Reticulosarcoma thorax'},
        {'code': '200.03',
         'long': 'Reticulosarcoma, intra-abdominal lymph nodes',
         'short': 'Reticulosarcoma abdom'},
        {'code': '200.04',
         'long': 'Reticulosarcoma, lymph nodes of axilla and upper limb',
         'short': 'Reticulosarcoma axilla'},
        {'code': '200.05',
         'long': 'Reticulosarcoma, lymph nodes of inguinal region and lower limb',
         'short': 'Reticulosarcoma inguin'},
        {'code': '200.06',
         'long': 'Reticulosarcoma, intrapelvic lymph nodes',
         'short': 'Reticulosarcoma pelvic'},
        {'code': '200.07',
         'long': 'Reticulosarcoma, spleen',
         'short': 'Reticulosarcoma spleen'},
        {'code': '200.08',
         'long': 'Reticulosarcoma, lymph nodes of multiple sites',
         'short': 'Reticulosarcoma mult'},
        {'code': '200.10',
         'long': 'Lymphosarcoma, unspecified site, extranodal and solid organ sites',
         'short': 'Lymphsrc unsp xtrndl org'},
        {'code': '200.11',
         'long': 'Lymphosarcoma, lymph nodes of head, face, and neck',
         'short': 'Lymphosarcoma head'},
        {'code': '200.12',
         'long': 'Lymphosarcoma, intrathoracic lymph nodes',
         'short': 'Lymphosarcoma thorax'},
        {'code': '200.13',
         'long': 'Lymphosarcoma, intra-abdominal lymph nodes',
         'short': 'Lymphosarcoma abdom'},
        {'code': '200.14',
         'long': 'Lymphosarcoma, lymph nodes of axilla and upper limb',
         'short': 'Lymphosarcoma axilla'},
        {'code': '200.15',
         'long': 'Lymphosarcoma, lymph nodes of inguinal region and lower limb',
         'short': 'Lymphosarcoma inguin'},
        {'code': '200.16',
         'long': 'Lymphosarcoma, intrapelvic lymph nodes',
         'short': 'Lymphosarcoma pelvic'},
        {'code': '200.17',
         'long': 'Lymphosarcoma, spleen',
         'short': 'Lymphosarcoma spleen'},
        {'code': '200.18',
         'long': 'Lymphosarcoma, lymph nodes of multiple sites',
         'short': 'Lymphosarcoma mult'},
        {'code': '200.20',
         'long': "Burkitt's tumor or lymphoma, unspecified site, extranodal and solid organ sites",
         'short': 'Brkt tmr unsp xtrndl org'},
        {'code': '200.21',
         'long': "Burkitt's tumor or lymphoma, lymph nodes of head, face, and neck",
         'short': "Burkitt's tumor head"},
        {'code': '200.22',
         'long': "Burkitt's tumor or lymphoma, intrathoracic lymph nodes",
         'short': "Burkitt's tumor thorax"},
        {'code': '200.23',
         'long': "Burkitt's tumor or lymphoma, intra-abdominal lymph nodes",
         'short': "Burkitt's tumor abdom"},
        {'code': '200.24',
         'long': "Burkitt's tumor or lymphoma, lymph nodes of axilla and upper limb",
         'short': "Burkitt's tumor axilla"},
        {'code': '200.25',
         'long': "Burkitt's tumor or lymphoma, lymph nodes of inguinal region and lower limb",
         'short': "Burkitt's tumor inguin"},
        {'code': '200.26',
         'long': "Burkitt's tumor or lymphoma, intrapelvic lymph nodes",
         'short': "Burkitt's tumor pelvic"},
        {'code': '200.27',
         'long': "Burkitt's tumor or lymphoma, spleen",
         'short': "Burkitt's tumor spleen"},
        {'code': '200.28',
         'long': "Burkitt's tumor or lymphoma, lymph nodes of multiple sites",
         'short': "Burkitt's tumor mult"},
        {'code': '200.30',
         'long': 'Marginal zone lymphoma, unspecified site, extranodal and solid organ sites',
         'short': 'Margnl zone lym xtrndl'},
        {'code': '200.31',
         'long': 'Marginal zone lymphoma, lymph nodes of head, face, and neck',
         'short': 'Margin zone lym head'},
        {'code': '200.32',
         'long': 'Marginal zone lymphoma, intrathoracic lymph nodes',
         'short': 'Margin zone lym thorax'},
        {'code': '200.33',
         'long': 'Marginal zone lymphoma, intraabdominal lymph nodes',
         'short': 'Margin zone lym abdom'},
        {'code': '200.34',
         'long': 'Marginal zone lymphoma, lymph nodes of axilla and upper limb',
         'short': 'Margin zone lym axilla'},
        {'code': '200.35',
         'long': 'Marginal zone lymphoma, lymph nodes of inguinal region and lower limb',
         'short': 'Margin zone lym inguin'},
        {'code': '200.36',
         'long': 'Marginal zone lymphoma, intrapelvic lymph nodes',
         'short': 'Margin zone lym pelvic'},
        {'code': '200.37',
         'long': 'Marginal zone lymphoma, spleen',
         'short': 'Margin zone lymph spleen'},
        {'code': '200.38',
         'long': 'Marginal zone lymphoma, lymph nodes of multiple sites',
         'short': 'Margin zone lymph multip'},
        {'code': '200.40',
         'long': 'Mantle cell lymphoma, unspecified site, extranodal and solid organ sites',
         'short': 'Mantle cell lym xtrrndl'},
        {'code': '200.41',
         'long': 'Mantle cell lymphoma, lymph nodes of head, face, and neck',
         'short': 'Mantle cell lymph head'},
        {'code': '200.42',
         'long': 'Mantle cell lymphoma, intrathoracic lymph nodes',
         'short': 'Mantle cell lymph thorax'},
        {'code': '200.43',
         'long': 'Mantle cell lymphoma, intra-abdominal lymph nodes',
         'short': 'Mantle cell lymph abdom'},
        {'code': '200.44',
         'long': 'Mantle cell lymphoma, lymph nodes of axilla and upper limb',
         'short': 'Mantle cell lymph axilla'},
        {'code': '200.45',
         'long': 'Mantle cell lymphoma, lymph nodes of inguinal region and lower limb',
         'short': 'Mantle cell lymph inguin'},
        {'code': '200.46',
         'long': 'Mantle cell lymphoma, intrapelvic lymph nodes',
         'short': 'Mantle cell lymph pelvic'},
        {'code': '200.47',
         'long': 'Mantle cell lymphoma, spleen',
         'short': 'Mantle cell lymph spleen'},
        {'code': '200.48',
         'long': 'Mantle cell lymphoma, lymph nodes of multiple sites',
         'short': 'Mantle cell lymph multip'},
        {'code': '200.50',
         'long': 'Primary central nervous system lymphoma, unspecified site, extranodal and solid organ sites',
         'short': 'Primary CNS lymph xtrndl'},
        {'code': '200.51',
         'long': 'Primary central nervous system lymphoma, lymph nodes of head, face, and neck',
         'short': 'Primary CNS lymph head'},
        {'code': '200.52',
         'long': 'Primary central nervous system lymphoma, intrathoracic lymph nodes',
         'short': 'Primary CNS lymph thorax'},
        {'code': '200.53',
         'long': 'Primary central nervous system lymphoma, intra-abdominal lymph nodes',
         'short': 'Primary CNS lymph abdom'},
        {'code': '200.54',
         'long': 'Primary central nervous system lymphoma, lymph nodes of axilla and upper limb',
         'short': 'Primary CNS lymph axilla'},
        {'code': '200.55',
         'long': 'Primary central nervous system lymphoma, lymph nodes of inguinal region and lower limb',
         'short': 'Primary CNS lym inguin'},
        {'code': '200.56',
         'long': 'Primary central nervous system lymphoma, intrapelvic lymph nodes',
         'short': 'Primary CNS lymph pelvic'},
        {'code': '200.57',
         'long': 'Primary central nervous system lymphoma, spleen',
         'short': 'Primary CNS lymph spleen'},
        {'code': '200.58',
         'long': 'Primary central nervous system lymphoma, lymph nodes of multiple sites',
         'short': 'Primary CNS lymph multip'},
        {'code': '200.60',
         'long': 'Anaplastic large cell lymphoma, unspecified site, extranodal and solid organ sites',
         'short': 'Anaplastic lymph xtrndl'},
        {'code': '200.61',
         'long': 'Anaplastic large cell lymphoma, lymph nodes of head, face, and neck',
         'short': 'Anaplastic lymph head'},
        {'code': '200.62',
         'long': 'Anaplastic large cell lymphoma, intrathoracic lymph nodes',
         'short': 'Anaplastic lymph thorax'},
        {'code': '200.63',
         'long': 'Anaplastic large cell lymphoma, intra-abdominal lymph nodes',
         'short': 'Anaplastic lymph abdom'},
        {'code': '200.64',
         'long': 'Anaplastic large cell lymphoma, lymph nodes of axilla and upper limb',
         'short': 'Anaplastic lymph axilla'},
        {'code': '200.65',
         'long': 'Anaplastic large cell lymphoma, lymph nodes of inguinal region and lower limb',
         'short': 'Anaplastic lymph inguin'},
        {'code': '200.66',
         'long': 'Anaplastic large cell lymphoma, intrapelvic lymph nodes',
         'short': 'Anaplastic lymph pelvic'},
        {'code': '200.67',
         'long': 'Anaplastic large cell lymphoma, spleen',
         'short': 'Anaplastic lymph spleen'},
        {'code': '200.68',
         'long': 'Anaplastic large cell lymphoma, lymph nodes of multiple sites',
         'short': 'Anaplastic lymph multip'},
        {'code': '200.70',
         'long': 'Large cell lymphoma, unspecified site, extranodal and solid organ sites',
         'short': 'Large cell lymph xtrndl'},
        {'code': '200.71',
         'long': 'Large cell lymphoma, lymph nodes of head, face, and neck',
         'short': 'Large cell lymphoma head'},
        {'code': '200.72',
         'long': 'Large cell lymphoma, intrathoracic lymph nodes',
         'short': 'Large cell lymph thorax'},
        {'code': '200.73',
         'long': 'Large cell lymphoma, intra-abdominal lymph nodes',
         'short': 'Large cell lymph abdom'},
        {'code': '200.74',
         'long': 'Large cell lymphoma, lymph nodes of axilla and upper limb',
         'short': 'Large cell lymph axilla'},
        {'code': '200.75',
         'long': 'Large cell lymphoma, lymph nodes of inguinal region and lower limb',
         'short': 'Large cell lymph inguin'},
        {'code': '200.76',
         'long': 'Large cell lymphoma, intrapelvic lymph nodes',
         'short': 'Large cell lymph pelvic'},
        {'code': '200.77',
         'long': 'Large cell lymphoma, spleen',
         'short': 'Large cell lymph spleen'},
        {'code': '200.78',
         'long': 'Large cell lymphoma, lymph nodes of multiple sites',
         'short': 'Large cell lymph multip'},
        {'code': '200.80',
         'long': 'Other named variants of lymphosarcoma and reticulosarcoma, unspecified site, extranodal and solid organ sites',
         'short': 'Oth varn unsp xtrndl org'},
        {'code': '200.81',
         'long': 'Other named variants of lymphosarcoma and reticulosarcoma, lymph nodes of head, face, and neck',
         'short': 'Mixed lymphosarc head'},
        {'code': '200.82',
         'long': 'Other named variants of lymphosarcoma and reticulosarcoma,intrathoracic lymph nodes',
         'short': 'Mixed lymphosarc thorax'},
        {'code': '200.83',
         'long': 'Other named variants of lymphosarcoma and reticulosarcoma, intra-abdominal lymph nodes',
         'short': 'Mixed lymphosarc abdom'},
        {'code': '200.84',
         'long': 'Other named variants of lymphosarcoma and reticulosarcoma, lymph nodes of axilla and upper limb',
         'short': 'Mixed lymphosarc axilla'},
        {'code': '200.85',
         'long': 'Other named variants of lymphosarcoma and reticulosarcoma, lymph nodes of inguinal region and lower limb',
         'short': 'Mixed lymphosarc inguin'},
        {'code': '200.86',
         'long': 'Other named variants of lymphosarcoma and reticulosarcoma, intrapelvic lymph nodes',
         'short': 'Mixed lymphosarc pelvic'},
        {'code': '200.87',
         'long': 'Other named variants of lymphosarcoma and reticulosarcoma, spleen',
         'short': 'Mixed lymphosarc spleen'},
        {'code': '200.88',
         'long': 'Other named variants of lymphosarcoma and reticulosarcoma, lymph nodes of multiple sites',
         'short': 'Mixed lymphosarc mult'},
        {'code': '201.00',
         'long': "Hodgkin's paragranuloma, unspecified site, extranodal and solid organ sites",
         'short': 'Hdgk prg unsp xtrndl org'},
        {'code': '201.01',
         'long': "Hodgkin's paragranuloma, lymph nodes of head, face, and neck",
         'short': 'Hodgkins paragran head'},
        {'code': '201.02',
         'long': "Hodgkin's paragranuloma, intrathoracic lymph nodes",
         'short': 'Hodgkins paragran thorax'},
        {'code': '201.03',
         'long': "Hodgkin's paragranuloma, intra-abdominal lymph nodes",
         'short': 'Hodgkins paragran abdom'},
        {'code': '201.04',
         'long': "Hodgkin's paragranuloma, lymph nodes of axilla and upper limb",
         'short': 'Hodgkins paragran axilla'},
        {'code': '201.05',
         'long': "Hodgkin's paragranuloma, lymph nodes of inguinal region and lower limb",
         'short': 'Hodgkins paragran inguin'},
        {'code': '201.06',
         'long': "Hodgkin's paragranuloma, intrapelvic lymph nodes",
         'short': 'Hodgkins paragran pelvic'},
        {'code': '201.07',
         'long': "Hodgkin's paragranuloma, spleen",
         'short': 'Hodgkins paragran spleen'},
        {'code': '201.08',
         'long': "Hodgkin's paragranuloma, lymph nodes of multiple sites",
         'short': 'Hodgkins paragran mult'},
        {'code': '201.10',
         'long': "Hodgkin's granuloma, unspecified site, extranodal and solid organ sites",
         'short': 'Hdgk grn unsp xtrndl org'},
        {'code': '201.11',
         'long': "Hodgkin's granuloma, lymph nodes of head, face, and neck",
         'short': 'Hodgkins granulom head'},
        {'code': '201.12',
         'long': "Hodgkin's granuloma, intrathoracic lymph nodes",
         'short': 'Hodgkins granulom thorax'},
        {'code': '201.13',
         'long': "Hodgkin's granuloma, intra-abdominal lymph nodes",
         'short': 'Hodgkins granulom abdom'},
        {'code': '201.14',
         'long': "Hodgkin's granuloma, lymph nodes of axilla and upper limb",
         'short': 'Hodgkins granulom axilla'},
        {'code': '201.15',
         'long': "Hodgkin's granuloma, lymph nodes of inguinal region and lower limb",
         'short': 'Hodgkins granulom inguin'},
        {'code': '201.16',
         'long': "Hodgkin's granuloma, intrapelvic lymph nodes",
         'short': 'Hodgkins granulom pelvic'},
        {'code': '201.17',
         'long': "Hodgkin's granuloma, spleen",
         'short': 'Hodgkins granulom spleen'},
        {'code': '201.18',
         'long': "Hodgkin's granuloma, lymph nodes of multiple sites",
         'short': 'Hodgkins granulom mult'},
        {'code': '201.20',
         'long': "Hodgkin's sarcoma, unspecified site, extranodal and solid organ sites",
         'short': 'Hdgk src unsp xtrndl org'},
        {'code': '201.21',
         'long': "Hodgkin's sarcoma, lymph nodes of head, face, and neck",
         'short': 'Hodgkins sarcoma head'},
        {'code': '201.22',
         'long': "Hodgkin's sarcoma, intrathoracic lymph nodes",
         'short': 'Hodgkins sarcoma thorax'},
        {'code': '201.23',
         'long': "Hodgkin's sarcoma, intra-abdominal lymph nodes",
         'short': 'Hodgkins sarcoma abdom'},
        {'code': '201.24',
         'long': "Hodgkin's sarcoma, lymph nodes of axilla and upper limb",
         'short': 'Hodgkins sarcoma axilla'},
        {'code': '201.25',
         'long': "Hodgkin's sarcoma, lymph nodes of inguinal region and lower limb",
         'short': 'Hodgkins sarcoma inguin'},
        {'code': '201.26',
         'long': "Hodgkin's sarcoma, intrapelvic lymph nodes",
         'short': 'Hodgkins sarcoma pelvic'},
        {'code': '201.27',
         'long': "Hodgkin's sarcoma, spleen",
         'short': 'Hodgkins sarcoma spleen'},
        {'code': '201.28',
         'long': "Hodgkin's sarcoma, lymph nodes of multiple sites",
         'short': 'Hodgkins sarcoma mult'},
        {'code': '201.40',
         'long': "Hodgkin's disease, lymphocytic-histiocytic predominance, unspecified site, extranodal and solid organ sites",
         'short': 'Lym-hst unsp xtrndl orgn'},
        {'code': '201.41',
         'long': "Hodgkin's disease, lymphocytic-histiocytic predominance, lymph nodes of head, face, and neck",
         'short': 'Hodg lymph-histio head'},
        {'code': '201.42',
         'long': "Hodgkin's disease, lymphocytic-histiocytic predominance, intrathoracic lymph nodes",
         'short': 'Hodg lymph-histio thorax'},
        {'code': '201.43',
         'long': "Hodgkin's disease, lymphocytic-histiocytic predominance, intra-abdominal lymph nodes",
         'short': 'Hodg lymph-histio abdom'},
        {'code': '201.44',
         'long': "Hodgkin's disease, lymphocytic-histiocytic predominance, lymph nodes of axilla and upper limb",
         'short': 'Hodg lymph-histio axilla'},
        {'code': '201.45',
         'long': "Hodgkin's disease, lymphocytic-histiocytic predominance, lymph nodes of inguinal region and lower limb",
         'short': 'Hodg lymph-histio inguin'},
        {'code': '201.46',
         'long': "Hodgkin's disease, lymphocytic-histiocytic predominance, intrapelvic lymph nodes",
         'short': 'Hodg lymph-histio pelvic'},
        {'code': '201.47',
         'long': "Hodgkin's disease, lymphocytic-histiocytic predominance, spleen",
         'short': 'Hodg lymph-histio spleen'},
        {'code': '201.48',
         'long': "Hodgkin's disease, lymphocytic-histiocytic predominance, lymph nodes of multiple sites",
         'short': 'Hodg lymph-histio mult'},
        {'code': '201.50',
         'long': "Hodgkin's disease, nodular sclerosis, unspecified site, extranodal and solid organ sites",
         'short': 'Ndr sclr unsp xtrndl org'},
        {'code': '201.51',
         'long': "Hodgkin's disease, nodular sclerosis, lymph nodes of head, face, and neck",
         'short': 'Hodg nodul sclero head'},
        {'code': '201.52',
         'long': "Hodgkin's disease, nodular sclerosis, intrathoracic lymph nodes",
         'short': 'Hodg nodul sclero thorax'},
        {'code': '201.53',
         'long': "Hodgkin's disease, nodular sclerosis, intra-abdominal lymph nodes",
         'short': 'Hodg nodul sclero abdom'},
        {'code': '201.54',
         'long': "Hodgkin's disease, nodular sclerosis, lymph nodes of axilla and upper limb",
         'short': 'Hodg nodul sclero axilla'},
        {'code': '201.55',
         'long': "Hodgkin's disease, nodular sclerosis, lymph nodes of inguinal region and lower limb",
         'short': 'Hodg nodul sclero inguin'},
        {'code': '201.56',
         'long': "Hodgkin's disease, nodular sclerosis, intrapelvic lymph nodes",
         'short': 'Hodg nodul sclero pelvic'},
        {'code': '201.57',
         'long': "Hodgkin's disease, nodular sclerosis, spleen",
         'short': 'Hodg nodul sclero spleen'},
        {'code': '201.58',
         'long': "Hodgkin's disease, nodular sclerosis, lymph nodes of multiple sites",
         'short': 'Hodg nodul sclero mult'},
        {'code': '201.60',
         'long': "Hodgkin's disease, mixed cellularity, unspecified site, extranodal and solid organ sites",
         'short': 'Mxd celr unsp xtrndl org'},
        {'code': '201.61',
         'long': "Hodgkin's disease, mixed cellularity, lymph nodes of head, face, and neck",
         'short': 'Hodgkins mix cell head'},
        {'code': '201.62',
         'long': "Hodgkin's disease, mixed cellularity, intrathoracic lymph nodes",
         'short': 'Hodgkins mix cell thorax'},
        {'code': '201.63',
         'long': "Hodgkin's disease, mixed cellularity, intra-abdominal lymph nodes",
         'short': 'Hodgkins mix cell abdom'},
        {'code': '201.64',
         'long': "Hodgkin's disease, mixed cellularity, lymph nodes of axilla and upper limb",
         'short': 'Hodgkins mix cell axilla'},
        {'code': '201.65',
         'long': "Hodgkin's disease, mixed cellularity, lymph nodes of inguinal region and lower limb",
         'short': 'Hodgkins mix cell inguin'},
        {'code': '201.66',
         'long': "Hodgkin's disease, mixed cellularity, intrapelvic lymph nodes",
         'short': 'Hodgkins mix cell pelvic'},
        {'code': '201.67',
         'long': "Hodgkin's disease, mixed cellularity, spleen",
         'short': 'Hodgkins mix cell spleen'},
        {'code': '201.68',
         'long': "Hodgkin's disease, mixed cellularity, lymph nodes of multiple sites",
         'short': 'Hodgkins mix cell mult'},
        {'code': '201.70',
         'long': "Hodgkin's disease, lymphocytic depletion, unspecified site, extranodal and solid organ sites",
         'short': 'Lym dplt unsp xtrndl org'},
        {'code': '201.71',
         'long': "Hodgkin's disease, lymphocytic depletion, lymph nodes of head, face, and neck",
         'short': 'Hodg lymph deplet head'},
        {'code': '201.72',
         'long': "Hodgkin's disease, lymphocytic depletion, intrathoracic lymph nodes",
         'short': 'Hodg lymph deplet thorax'},
        {'code': '201.73',
         'long': "Hodgkin's disease, lymphocytic depletion, intra-abdominal lymph nodes",
         'short': 'Hodg lymph deplet abdom'},
        {'code': '201.74',
         'long': "Hodgkin's disease, lymphocytic depletion, lymph nodes of axilla and upper limb",
         'short': 'Hodg lymph deplet axilla'},
        {'code': '201.75',
         'long': "Hodgkin's disease, lymphocytic depletion, lymph nodes of inguinal region and lower limb",
         'short': 'Hodg lymph deplet inguin'},
        {'code': '201.76',
         'long': "Hodgkin's disease, lymphocytic depletion, intrapelvic lymph nodes",
         'short': 'Hodg lymph deplet pelvic'},
        {'code': '201.77',
         'long': "Hodgkin's disease, lymphocytic depletion, spleen",
         'short': 'Hodg lymph deplet spleen'},
        {'code': '201.78',
         'long': "Hodgkin's disease, lymphocytic depletion, lymph nodes of multiple sites",
         'short': 'Hodg lymph deplet mult'},
        {'code': '201.90',
         'long': "Hodgkin's disease, unspecified type, unspecified site, extranodal and solid organ sites",
         'short': 'Hdgk dis unsp xtrndl org'},
        {'code': '201.91',
         'long': "Hodgkin's disease, unspecified type, lymph nodes of head, face, and neck",
         'short': 'Hodgkins dis NOS head'},
        {'code': '201.92',
         'long': "Hodgkin's disease, unspecified type, intrathoracic lymph nodes",
         'short': 'Hodgkins dis NOS thorax'},
        {'code': '201.93',
         'long': "Hodgkin's disease, unspecified type, intra-abdominal lymph nodes",
         'short': 'Hodgkins dis NOS abdom'},
        {'code': '201.94',
         'long': "Hodgkin's disease, unspecified type, lymph nodes of axilla and upper limb",
         'short': 'Hodgkins dis NOS axilla'},
        {'code': '201.95',
         'long': "Hodgkin's disease, unspecified type, lymph nodes of inguinal region and lower limb",
         'short': 'Hodgkins dis NOS inguin'},
        {'code': '201.96',
         'long': "Hodgkin's disease, unspecified type, intrapelvic lymph nodes",
         'short': 'Hodgkins dis NOS pelvic'},
        {'code': '201.97',
         'long': "Hodgkin's disease, unspecified type, spleen",
         'short': 'Hodgkins dis NOS spleen'},
        {'code': '201.98',
         'long': "Hodgkin's disease, unspecified type, lymph nodes of multiple sites",
         'short': 'Hodgkins dis NOS mult'},
        {'code': '202.00',
         'long': 'Nodular lymphoma, unspecified site, extranodal and solid organ sites',
         'short': 'Ndlr lym unsp xtrndl org'},
        {'code': '202.01',
         'long': 'Nodular lymphoma, lymph nodes of head, face, and neck',
         'short': 'Nodular lymphoma head'},
        {'code': '202.02',
         'long': 'Nodular lymphoma, intrathoracic lymph nodes',
         'short': 'Nodular lymphoma thorax'},
        {'code': '202.03',
         'long': 'Nodular lymphoma, intra-abdominal lymph nodes',
         'short': 'Nodular lymphoma abdom'},
        {'code': '202.04',
         'long': 'Nodular lymphoma, lymph nodes of axilla and upper limb',
         'short': 'Nodular lymphoma axilla'},
        {'code': '202.05',
         'long': 'Nodular lymphoma, lymph nodes of inguinal region and lower limb',
         'short': 'Nodular lymphoma inguin'},
        {'code': '202.06',
         'long': 'Nodular lymphoma, intrapelvic lymph nodes',
         'short': 'Nodular lymphoma pelvic'},
        {'code': '202.07',
         'long': 'Nodular lymphoma, spleen',
         'short': 'Nodular lymphoma spleen'},
        {'code': '202.08',
         'long': 'Nodular lymphoma, lymph nodes of multiple sites',
         'short': 'Nodular lymphoma mult'},
        {'code': '202.10',
         'long': 'Mycosis fungoides, unspecified site, extranodal and solid organ sites',
         'short': 'Mycs fng unsp xtrndl org'},
        {'code': '202.11',
         'long': 'Mycosis fungoides, lymph nodes of head, face, and neck',
         'short': 'Mycosis fungoides head'},
        {'code': '202.12',
         'long': 'Mycosis fungoides, intrathoracic lymph nodes',
         'short': 'Mycosis fungoides thorax'},
        {'code': '202.13',
         'long': 'Mycosis fungoides, intra-abdominal lymph nodes',
         'short': 'Mycosis fungoides abdom'},
        {'code': '202.14',
         'long': 'Mycosis fungoides, lymph nodes of axilla and upper limb',
         'short': 'Mycosis fungoides axilla'},
        {'code': '202.15',
         'long': 'Mycosis fungoides, lymph nodes of inguinal region and lower limb',
         'short': 'Mycosis fungoides inguin'},
        {'code': '202.16',
         'long': 'Mycosis fungoides, intrapelvic lymph nodes',
         'short': 'Mycosis fungoides pelvic'},
        {'code': '202.17',
         'long': 'Mycosis fungoides, spleen',
         'short': 'Mycosis fungoides spleen'},
        {'code': '202.18',
         'long': 'Mycosis fungoides, lymph nodes of multiple sites',
         'short': 'Mycosis fungoides mult'},
        {'code': '202.20',
         'long': "Sezary's disease, unspecified site, extranodal and solid organ sites",
         'short': 'Szry dis unsp xtrndl org'},
        {'code': '202.21',
         'long': "Sezary's disease, lymph nodes of head, face, and neck",
         'short': "Sezary's disease head"},
        {'code': '202.22',
         'long': "Sezary's disease, intrathoracic lymph nodes",
         'short': "Sezary's disease thorax"},
        {'code': '202.23',
         'long': "Sezary's disease, intra-abdominal lymph nodes",
         'short': "Sezary's disease abdom"},
        {'code': '202.24',
         'long': "Sezary's disease, lymph nodes of axilla and upper limb",
         'short': "Sezary's disease axilla"},
        {'code': '202.25',
         'long': "Sezary's disease, lymph nodes of inguinal region and lower limb",
         'short': "Sezary's disease inguin"},
        {'code': '202.26',
         'long': "Sezary's disease, intrapelvic lymph nodes",
         'short': "Sezary's disease pelvic"},
        {'code': '202.27',
         'long': "Sezary's disease, spleen",
         'short': "Sezary's disease spleen"},
        {'code': '202.28',
         'long': "Sezary's disease, lymph nodes of multiple sites",
         'short': "Sezary's disease mult"},
        {'code': '202.30',
         'long': 'Malignant histiocytosis, unspecified site, extranodal and solid organ sites',
         'short': 'Mlg hist unsp xtrndl org'},
        {'code': '202.31',
         'long': 'Malignant histiocytosis, lymph nodes of head, face, and neck',
         'short': 'Mal histiocytosis head'},
        {'code': '202.32',
         'long': 'Malignant histiocytosis, intrathoracic lymph nodes',
         'short': 'Mal histiocytosis thorax'},
        {'code': '202.33',
         'long': 'Malignant histiocytosis, intra-abdominal lymph nodes',
         'short': 'Mal histiocytosis abdom'},
        {'code': '202.34',
         'long': 'Malignant histiocytosis, lymph nodes of axilla and upper limb',
         'short': 'Mal histiocytosis axilla'},
        {'code': '202.35',
         'long': 'Malignant histiocytosis, lymph nodes of inguinal region and lower limb',
         'short': 'Mal histiocytosis inguin'},
        {'code': '202.36',
         'long': 'Malignant histiocytosis, intrapelvic lymph nodes',
         'short': 'Mal histiocytosis pelvic'},
        {'code': '202.37',
         'long': 'Malignant histiocytosis, spleen',
         'short': 'Mal histiocytosis spleen'},
        {'code': '202.38',
         'long': 'Malignant histiocytosis, lymph nodes of multiple sites',
         'short': 'Mal histiocytosis mult'},
        {'code': '202.40',
         'long': 'Leukemic reticuloendotheliosis, unspecified site, extranodal and solid organ sites',
         'short': 'Lk rtctl unsp xtrndl org'},
        {'code': '202.41',
         'long': 'Leukemic reticuloendotheliosis, lymph nodes of head, face, and neck',
         'short': 'Hairy-cell leukem head'},
        {'code': '202.42',
         'long': 'Leukemic reticuloendotheliosis, intrathoracic lymph nodes',
         'short': 'Hairy-cell leukem thorax'},
        {'code': '202.43',
         'long': 'Leukemic reticuloendotheliosis, intra-abdominal lymph nodes',
         'short': 'Hairy-cell leukem abdom'},
        {'code': '202.44',
         'long': 'Leukemic reticuloendotheliosis, lymph nodes of axilla and upper arm',
         'short': 'Hairy-cell leukem axilla'},
        {'code': '202.45',
         'long': 'Leukemic reticuloendotheliosis, lymph nodes of inguinal region and lower limb',
         'short': 'Hairy-cell leukem inguin'},
        {'code': '202.46',
         'long': 'Leukemic reticuloendotheliosis, intrapelvic lymph nodes',
         'short': 'Hairy-cell leukem pelvic'},
        {'code': '202.47',
         'long': 'Leukemic reticuloendotheliosis, spleen',
         'short': 'Hairy-cell leukem spleen'},
        {'code': '202.48',
         'long': 'Leukemic reticuloendotheliosis, lymph nodes of multiple sites',
         'short': 'Hairy-cell leukem mult'},
        {'code': '202.50',
         'long': 'Letterer-siwe disease, unspecified site, extranodal and solid organ sites',
         'short': 'Ltr-siwe unsp xtrndl org'},
        {'code': '202.51',
         'long': 'Letterer-siwe disease, lymph nodes of head, face, and neck',
         'short': 'Letterer-siwe dis head'},
        {'code': '202.52',
         'long': 'Letterer-siwe disease, intrathoracic lymph nodes',
         'short': 'Letterer-siwe dis thorax'},
        {'code': '202.53',
         'long': 'Letterer-siwe disease, intra-abdominal lymph nodes',
         'short': 'Letterer-siwe dis abdom'},
        {'code': '202.54',
         'long': 'Letterer-siwe disease, lymph nodes of axilla and upper limb',
         'short': 'Letterer-siwe dis axilla'},
        {'code': '202.55',
         'long': 'Letterer-siwe disease, lymph nodes of inguinal region and lower limb',
         'short': 'Letterer-siwe dis inguin'},
        {'code': '202.56',
         'long': 'Letterer-siwe disease, intrapelvic lymph nodes',
         'short': 'Letterer-siwe dis pelvic'},
        {'code': '202.57',
         'long': 'Letterer-siwe disease, spleen',
         'short': 'Letterer-siwe dis spleen'},
        {'code': '202.58',
         'long': 'Letterer-siwe disease, lymph nodes of multiple sites',
         'short': 'Letterer-siwe dis mult'},
        {'code': '202.60',
         'long': 'Malignant mast cell tumors, unspecified site, extranodal and solid organ sites',
         'short': 'Mlg mast unsp xtrndl org'},
        {'code': '202.61',
         'long': 'Malignant mast cell tumors, lymph nodes of head, face, and neck',
         'short': 'Mal mastocytosis head'},
        {'code': '202.62',
         'long': 'Malignant mast cell tumors, intrathoracic lymph nodes',
         'short': 'Mal mastocytosis thorax'},
        {'code': '202.63',
         'long': 'Malignant mast cell tumors, intra-abdominal lymph nodes',
         'short': 'Mal mastocytosis abdom'},
        {'code': '202.64',
         'long': 'Malignant mast cell tumors, lymph nodes of axilla and upper limb',
         'short': 'Mal mastocytosis axilla'},
        {'code': '202.65',
         'long': 'Malignant mast cell tumors, lymph nodes of inguinal region and lower limb',
         'short': 'Mal mastocytosis inguin'},
        {'code': '202.66',
         'long': 'Malignant mast cell tumors, intrapelvic lymph nodes',
         'short': 'Mal mastocytosis pelvic'},
        {'code': '202.67',
         'long': 'Malignant mast cell tumors, spleen',
         'short': 'Mal mastocytosis spleen'},
        {'code': '202.68',
         'long': 'Malignant mast cell tumors, lymph nodes of multiple sites',
         'short': 'Mal mastocytosis mult'},
        {'code': '202.70',
         'long': 'Peripheral T cell lymphoma, unspecified site, extranodal and solid organ sites',
         'short': 'Periph T cell lym xtrndl'},
        {'code': '202.71',
         'long': 'Peripheral T cell lymphoma, lymph nodes of head, face, and neck',
         'short': 'Periph T cell lymph head'},
        {'code': '202.72',
         'long': 'Peripheral T cell lymphoma, intrathoracic lymph nodes',
         'short': 'Periph T cell lym thorax'},
        {'code': '202.73',
         'long': 'Peripheral T cell lymphoma, intra-abdominal lymph nodes',
         'short': 'Periph T cell lym abdom'},
        {'code': '202.74',
         'long': 'Peripheral T cell lymphoma, lymph nodes of axilla and upper limb',
         'short': 'Periph T cell lym axilla'},
        {'code': '202.75',
         'long': 'Peripheral T cell lymphoma, lymph nodes of inguinal region and lower limb',
         'short': 'Periph T cell lym inguin'},
        {'code': '202.76',
         'long': 'Peripheral T cell lymphoma, intrapelvic lymph nodes',
         'short': 'Periph T cell lym pelvic'},
        {'code': '202.77',
         'long': 'Peripheral T cell lymphoma, spleen',
         'short': 'Periph T cell lym spleen'},
        {'code': '202.78',
         'long': 'Peripheral T cell lymphoma, lymph nodes of multiple sites',
         'short': 'Periph T cell lym multip'},
        {'code': '202.80',
         'long': 'Other malignant lymphomas, unspecified site, extranodal and solid organ sites',
         'short': 'Oth lymp unsp xtrndl org'},
        {'code': '202.81',
         'long': 'Other malignant lymphomas, lymph nodes of head, face, and neck',
         'short': 'Lymphomas NEC head'},
        {'code': '202.82',
         'long': 'Other malignant lymphomas, intrathoracic lymph nodes',
         'short': 'Lymphomas NEC thorax'},
        {'code': '202.83',
         'long': 'Other malignant lymphomas, intra-abdominal lymph nodes',
         'short': 'Lymphomas NEC abdom'},
        {'code': '202.84',
         'long': 'Other malignant lymphomas, lymph nodes of axilla and upper limb',
         'short': 'Lymphomas NEC axilla'},
        {'code': '202.85',
         'long': 'Other malignant lymphomas, lymph nodes of inguinal region and lower limb',
         'short': 'Lymphomas NEC inguin'},
        {'code': '202.86',
         'long': 'Other malignant lymphomas, intrapelvic lymph nodes',
         'short': 'Lymphomas NEC pelvic'},
        {'code': '202.87',
         'long': 'Other malignant lymphomas, spleen',
         'short': 'Lymphomas NEC spleen'},
        {'code': '202.88',
         'long': 'Other malignant lymphomas, lymph nodes of multiple sites',
         'short': 'Lymphomas NEC mult'},
        {'code': '202.90',
         'long': 'Other and unspecified malignant neoplasms of lymphoid and histiocytic tissue, unspecified site, extranodal and solid organ sites',
         'short': 'Unsp lym unsp xtrndl org'},
        {'code': '202.91',
         'long': 'Other and unspecified malignant neoplasms of lymphoid and histiocytic tissue, lymph nodes of head, face, and neck',
         'short': 'Lymphoid mal NEC head'},
        {'code': '202.92',
         'long': 'Other and unspecified malignant neoplasms of lymphoid and histiocytic tissue, intrathoracic lymph nodes',
         'short': 'Lymphoid mal NEC thorax'},
        {'code': '202.93',
         'long': 'Other and unspecified malignant neoplasms of lymphoid and histiocytic tissue, intra-abdominal lymph nodes',
         'short': 'Lymphoid mal NEC abdom'},
        {'code': '202.94',
         'long': 'Other and unspecified malignant neoplasms of lymphoid and histiocytic tissue, lymph nodes of axilla and upper limb',
         'short': 'Lymphoid mal NEC axilla'},
        {'code': '202.95',
         'long': 'Other and unspecified malignant neoplasms of lymphoid and histiocytic tissue, lymph nodes of inguinal region and lower limb',
         'short': 'Lymphoid mal NEC inguin'},
        {'code': '202.96',
         'long': 'Other and unspecified malignant neoplasms of lymphoid and histiocytic tissue, intrapelvic lymph nodes',
         'short': 'Lymphoid mal NEC pelvic'},
        {'code': '202.97',
         'long': 'Other and unspecified malignant neoplasms of lymphoid and histiocytic tissue, spleen',
         'short': 'Lymphoid mal NEC spleen'},
        {'code': '202.98',
         'long': 'Other and unspecified malignant neoplasms of lymphoid and histiocytic tissue, lymph nodes of multiple sites',
         'short': 'Lymphoid mal NEC mult'},
        {'code': '203.00',
         'long': 'Multiple myeloma, without mention of having achieved remission',
         'short': 'Mult mye w/o achv rmson'},
        {'code': '203.01',
         'long': 'Multiple myeloma, in remission',
         'short': 'Mult myelm w remission'},
        {'code': '203.02',
         'long': 'Multiple myeloma, in relapse',
         'short': 'Mult myeloma in relapse'},
        {'code': '203.10',
         'long': 'Plasma cell leukemia, without mention of having achieved remission',
         'short': 'Pls cl leu w/o achv rmsn'},
        {'code': '203.11',
         'long': 'Plasma cell leukemia, in remission',
         'short': 'Plsm cell leuk w rmson'},
        {'code': '203.12',
         'long': 'Plasma cell leukemia, in relapse',
         'short': 'Plsm cel leuk in relapse'},
        {'code': '203.80',
         'long': 'Other immunoproliferative neoplasms, without mention of having achieved remission',
         'short': 'Oth imno npl wo ach rmsn'},
        {'code': '203.81',
         'long': 'Other immunoproliferative neoplasms, in remission',
         'short': 'Oth imnprfl npl w rmsn'},
        {'code': '203.82',
         'long': 'Other immunoproliferative neoplasms, in relapse',
         'short': 'Oth imnprlf neo-relapse'},
        {'code': '204.00',
         'long': 'Acute lymphoid leukemia, without mention of having achieved remission',
         'short': 'Ac lym leuk wo achv rmsn'},
        {'code': '204.01',
         'long': 'Acute lymphoid leukemia, in remission',
         'short': 'Act lym leuk w rmsion'},
        {'code': '204.02',
         'long': 'Acute lymphoid leukemia, in relapse',
         'short': 'Act lymp leuk in relapse'},
        {'code': '204.10',
         'long': 'Chronic lymphoid leukemia, without mention of having achieved remission',
         'short': 'Ch lym leuk wo achv rmsn'},
        {'code': '204.11',
         'long': 'Chronic lymphoid leukemia, in remission',
         'short': 'Chr lym leuk w rmsion'},
        {'code': '204.12',
         'long': 'Chronic lymphoid leukemia, in relapse',
         'short': 'Chr lymp leuk in relapse'},
        {'code': '204.20',
         'long': 'Subacute lymphoid leukemia, without mention of having achieved remission',
         'short': 'Sbac lym leu wo ach rmsn'},
        {'code': '204.21',
         'long': 'Subacute lymphoid leukemia, in remission',
         'short': 'Sbac lym leuk w rmsion'},
        {'code': '204.22',
         'long': 'Subacute lymphoid leukemia, in relapse',
         'short': 'Sbac lym leuk in relapse'},
        {'code': '204.80',
         'long': 'Other lymphoid leukemia, without mention of having achieved remission',
         'short': 'Oth lym leu wo achv rmsn'},
        {'code': '204.81',
         'long': 'Other lymphoid leukemia, in remission',
         'short': 'Oth lym leuk w rmsion'},
        {'code': '204.82',
         'long': 'Other lymphoid leukemia, in relapse',
         'short': 'Oth lym leuk in relapse'},
        {'code': '204.90',
         'long': 'Unspecified lymphoid leukemia, without mention of having achieved remission',
         'short': 'Uns lym leu wo ach rmsn'},
        {'code': '204.91',
         'long': 'Unspecified lymphoid leukemia, in remission',
         'short': 'Uns lym leuk w rmsion'},
        {'code': '204.92',
         'long': 'Unspecified lymphoid leukemia, in relapse',
         'short': 'Lymp leuk NOS relapse'},
        {'code': '205.00',
         'long': 'Acute myeloid leukemia, without mention of having achieved remission',
         'short': 'Ac myl leuk wo achv rmsn'},
        {'code': '205.01',
         'long': 'Acute myeloid leukemia, in remission',
         'short': 'Act myl leuk w rmsion'},
        {'code': '205.02',
         'long': 'Acute myeloid leukemia, in relapse',
         'short': 'Act myel leuk in relapse'},
        {'code': '205.10',
         'long': 'Chronic myeloid leukemia, without mention of having achieved remission',
         'short': 'Ch myl leuk wo achv rmsn'},
        {'code': '205.11',
         'long': 'Chronic myeloid leukemia, in remission',
         'short': 'Chr myl leuk w rmsion'},
        {'code': '205.12',
         'long': 'Chronic myeloid leukemia, in relapse',
         'short': 'Chr myel leuk in relapse'},
        {'code': '205.20',
         'long': 'Subacute myeloid leukemia, without mention of having achieved remission',
         'short': 'Sbac myl leu wo ach rmsn'},
        {'code': '205.21',
         'long': 'Subacute myeloid leukemia,in remission',
         'short': 'Sbac myl leuk w rmsion'},
        {'code': '205.22',
         'long': 'Subacute myeloid leukemia, in relapse',
         'short': 'Sbac myl leuk in relapse'},
        {'code': '205.30',
         'long': 'Myeloid sarcoma, without mention of having achieved remission',
         'short': 'Myl sarcoma wo achv rmsn'},
        {'code': '205.31',
         'long': 'Myeloid sarcoma, in remission',
         'short': 'Myl srcoma w rmsion'},
        {'code': '205.32',
         'long': 'Myeloid sarcoma, in relapse',
         'short': 'Myel sarcoma in relapse'},
        {'code': '205.80',
         'long': 'Other myeloid leukemia, without mention of having achieved remission',
         'short': 'Oth my leuk wo achv rmsn'},
        {'code': '205.81',
         'long': 'Other myeloid leukemia, in remission',
         'short': 'Oth myl leuk w rmsion'},
        {'code': '205.82',
         'long': 'Other myeloid leukemia, in relapse',
         'short': 'Oth myel leuk in relapse'},
        {'code': '205.90',
         'long': 'Unspecified myeloid leukemia, without mention of having achieved remission',
         'short': 'Uns my leu wo ach rmsn'},
        {'code': '205.91',
         'long': 'Unspecified myeloid leukemia, in remission',
         'short': 'Uns myl leuk w rmsion'},
        {'code': '205.92',
         'long': 'Unspecified myeloid leukemia, in relapse',
         'short': 'Myel leuk NOS in relapse'},
        {'code': '206.00',
         'long': 'Acute monocytic leukemia, without mention of having achieved remission',
         'short': 'Ac mono leu wo achv rmsn'},
        {'code': '206.01',
         'long': 'Acute monocytic leukemia,in remission',
         'short': 'Act mono leuk w rmsion'},
        {'code': '206.02',
         'long': 'Acute monocytic leukemia, in relapse',
         'short': 'Act mono leuk in relapse'},
        {'code': '206.10',
         'long': 'Chronic monocytic leukemia, without mention of having achieved remission',
         'short': 'Ch mono leu wo achv rmsn'},
        {'code': '206.11',
         'long': 'Chronic monocytic leukemia, in remission',
         'short': 'Chr mono leuk w rmsion'},
        {'code': '206.12',
         'long': 'Chronic monocytic leukemia, in relapse',
         'short': 'Chr mono leuk in relapse'},
        {'code': '206.20',
         'long': 'Subacute monocytic leukemia, without mention of having achieved remission',
         'short': 'Sbac mno leu wo ach rmsn'},
        {'code': '206.21',
         'long': 'Subacute monocytic leukemia, in remission',
         'short': 'Sbac mono leuk w rmsion'},
        {'code': '206.22',
         'long': 'Subacute monocytic leukemia, in relapse',
         'short': 'Sbac mono leu in relapse'},
        {'code': '206.80',
         'long': 'Other monocytic leukemia, without mention of having achieved remission',
         'short': 'Ot mono leu wo achv rmsn'},
        {'code': '206.81',
         'long': 'Other monocytic leukemia, in remission',
         'short': 'Oth mono leuk w rmsion'},
        {'code': '206.82',
         'long': 'Other monocytic leukemia, in relapse',
         'short': 'Oth mono leuk in relapse'},
        {'code': '206.90',
         'long': 'Unspecified monocytic leukemia, without mention of having achieved remission',
         'short': 'Uns mno leu wo ach rmsn'},
        {'code': '206.91',
         'long': 'Unspecified monocytic leukemia, in remission',
         'short': 'Uns mono leuk w rmsion'},
        {'code': '206.92',
         'long': 'Unspecified monocytic leukemia, in relapse',
         'short': 'Mono leuk NOS relapse'},
        {'code': '207.00',
         'long': 'Acute erythremia and erythroleukemia, without mention of having achieved remission',
         'short': 'Ac erth/erlk wo ach rmsn'},
        {'code': '207.01',
         'long': 'Acute erythremia and erythroleukemia, in remission',
         'short': 'Act erth/erylk w rmson'},
        {'code': '207.02',
         'long': 'Acute erythremia and erythroleukemia, in relapse',
         'short': 'Ac erth/erylk in relapse'},
        {'code': '207.10',
         'long': 'Chronic erythremia, without mention of having achieved remission',
         'short': 'Chr erythrm w/o ach rmsn'},
        {'code': '207.11',
         'long': 'Chronic erythremia, in remission',
         'short': 'Chr erythrm w remision'},
        {'code': '207.12',
         'long': 'Chronic erythremia, in relapse',
         'short': 'Chr erythrmia in relapse'},
        {'code': '207.20',
         'long': 'Megakaryocytic leukemia, without mention of having achieved remission',
         'short': 'Mgkrcyt leuk wo ach rmsn'},
        {'code': '207.21',
         'long': 'Megakaryocytic leukemia, in remission',
         'short': 'Mgkrycyt leuk w rmsion'},
        {'code': '207.22',
         'long': 'Megakaryocytic leukemia, in relapse',
         'short': 'Mgkrycyt leuk in relapse'},
        {'code': '207.80',
         'long': 'Other specified leukemia, without mention of having achieved remission',
         'short': 'Oth leuk w/o achv rmsn'},
        {'code': '207.81',
         'long': 'Other specified leukemia, in remission',
         'short': 'Oth spf leuk w remsion'},
        {'code': '207.82',
         'long': 'Other specified leukemia, in relapse',
         'short': 'Oth spf leuk in relapse'},
        {'code': '208.00',
         'long': 'Acute leukemia of unspecified cell type, without mention of having achieved remission',
         'short': 'Ac leu un cl wo ach rmsn'},
        {'code': '208.01',
         'long': 'Acute leukemia of unspecified cell type, in remission',
         'short': 'Act leuk uns cl w rmson'},
        {'code': '208.02',
         'long': 'Acute leukemia of unspecified cell type, in relapse',
         'short': 'Ac leuk uns cl relapse'},
        {'code': '208.10',
         'long': 'Chronic leukemia of unspecified cell type, without mention of having achieved remission',
         'short': 'Ch leu un cl wo ach rmsn'},
        {'code': '208.11',
         'long': 'Chronic leukemia of unspecified cell type, in remission',
         'short': 'Chr leuk uns cl w rmson'},
        {'code': '208.12',
         'long': 'Chronic leukemia of unspecified cell type, in relapse',
         'short': 'Ch leu uns cl in relapse'},
        {'code': '208.20',
         'long': 'Subacute leukemia of unspecified cell type, without mention of having achieved remission',
         'short': 'Sbc leu un cl wo ah rmsn'},
        {'code': '208.21',
         'long': 'Subacute leukemia of unspecified cell type, in remission',
         'short': 'Sbac leuk uns cl w rmson'},
        {'code': '208.22',
         'long': 'Subacute leukemia of unspecified cell type, in relapse',
         'short': 'Sbac leu uns cl-relapse'},
        {'code': '208.80',
         'long': 'Other leukemia of unspecified cell type, without mention of having achieved remission',
         'short': 'Ot leu un cl wo ach rmsn'},
        {'code': '208.81',
         'long': 'Other leukemia of unspecified cell type, in remission',
         'short': 'Oth leuk uns cl w rmson'},
        {'code': '208.82',
         'long': 'Other leukemia of unspecified cell type, in relapse',
         'short': 'Oth leuk uns cl-relapse'},
        {'code': '208.90',
         'long': 'Unspecified leukemia, without mention of having achieved remission',
         'short': 'Leuk NOS w/o achv rmsn'},
        {'code': '208.91',
         'long': 'Unspecified leukemia, in remission',
         'short': 'Leukemia NOS w remission'},
        {'code': '208.92',
         'long': 'Unspecified leukemia, in relapse',
         'short': 'Leukemia NOS in relapse'},
        {'code': '209.00',
         'long': 'Malignant carcinoid tumor of the small intestine, unspecified portion',
         'short': 'Mal crcnoid sm intst NOS'},
        {'code': '209.01',
         'long': 'Malignant carcinoid tumor of the duodenum',
         'short': 'Malig carcinoid duodenum'},
        {'code': '209.02',
         'long': 'Malignant carcinoid tumor of the jejunum',
         'short': 'Malig carcinoid jejunum'},
        {'code': '209.03',
         'long': 'Malignant carcinoid tumor of the ileum',
         'short': 'Malig carcinoid ileum'},
        {'code': '209.10',
         'long': 'Malignant carcinoid tumor of the large intestine, unspecified portion',
         'short': 'Mal crcnoid lg intst NOS'},
        {'code': '209.11',
         'long': 'Malignant carcinoid tumor of the appendix',
         'short': 'Malig carcinoid appendix'},
        {'code': '209.12',
         'long': 'Malignant carcinoid tumor of the cecum',
         'short': 'Malig carcinoid cecum'},
        {'code': '209.13',
         'long': 'Malignant carcinoid tumor of the ascending colon',
         'short': 'Mal crcnoid ascend colon'},
        {'code': '209.14',
         'long': 'Malignant carcinoid tumor of the transverse colon',
         'short': 'Mal crcnoid transv colon'},
        {'code': '209.15',
         'long': 'Malignant carcinoid tumor of the descending colon',
         'short': 'Mal carcinoid desc colon'},
        {'code': '209.16',
         'long': 'Malignant carcinoid tumor of the sigmoid colon',
         'short': 'Mal carcinoid sig colon'},
        {'code': '209.17',
         'long': 'Malignant carcinoid tumor of the rectum',
         'short': 'Malig carcinoid rectum'},
        {'code': '209.20',
         'long': 'Malignant carcinoid tumor of unknown primary site',
         'short': 'Mal crcnd prim site unkn'},
        {'code': '209.21',
         'long': 'Malignant carcinoid tumor of the bronchus and lung',
         'short': 'Mal carcinoid bronc/lung'},
        {'code': '209.22',
         'long': 'Malignant carcinoid tumor of the thymus',
         'short': 'Malig carcinoid thymus'},
        {'code': '209.23',
         'long': 'Malignant carcinoid tumor of the stomach',
         'short': 'Malig carcinoid stomach'},
        {'code': '209.24',
         'long': 'Malignant carcinoid tumor of the kidney',
         'short': 'Malig carcinoid kidney'},
        {'code': '209.25',
         'long': 'Malignant carcinoid tumor of foregut, not otherwise specified',
         'short': 'Mal carcnoid foregut NOS'},
        {'code': '209.26',
         'long': 'Malignant carcinoid tumor of midgut, not otherwise specified',
         'short': 'Mal carcinoid midgut NOS'},
        {'code': '209.27',
         'long': 'Malignant carcinoid tumor of hindgut, not otherwise specified',
         'short': 'Mal carcnoid hindgut NOS'},
        {'code': '209.29',
         'long': 'Malignant carcinoid tumor of other sites',
         'short': 'Malig carcinoid oth site'},
        {'code': '209.30',
         'long': 'Malignant poorly differentiated neuroendocrine carcinoma, any site',
         'short': 'Malig neuroendo ca NOS'},
        {'code': '209.31',
         'long': 'Merkel cell carcinoma of the face',
         'short': 'Merkel cell ca-face'},
        {'code': '209.32',
         'long': 'Merkel cell carcinoma of the scalp and neck',
         'short': 'Merkel cell ca-sclp/neck'},
        {'code': '209.33',
         'long': 'Merkel cell carcinoma of the upper limb',
         'short': 'Merkel cell ca-up limb'},
        {'code': '209.34',
         'long': 'Merkel cell carcinoma of the lower limb',
         'short': 'Merkel cell ca-low limb'},
        {'code': '209.35',
         'long': 'Merkel cell carcinoma of the trunk',
         'short': 'Merkel cell ca-trunk'},
        {'code': '209.36',
         'long': 'Merkel cell carcinoma of other sites',
         'short': 'Merkel cell ca-oth sites'},
        {'code': '209.40',
         'long': 'Benign carcinoid tumor of the small intestine, unspecified portion',
         'short': 'Ben crcnoid sm intst NOS'},
        {'code': '209.41',
         'long': 'Benign carcinoid tumor of the duodenum',
         'short': 'Ben carcinoid duodenum'},
        {'code': '209.42',
         'long': 'Benign carcinoid tumor of the jejunum',
         'short': 'Benign carcinoid jejunum'},
        {'code': '209.43',
         'long': 'Benign carcinoid tumor of the ileum',
         'short': 'Benign carcinoid ileum'},
        {'code': '209.50',
         'long': 'Benign carcinoid tumor of the large intestine, unspecified portion',
         'short': 'Ben crcnoid lg intst NOS'},
        {'code': '209.51',
         'long': 'Benign carcinoid tumor of the appendix',
         'short': 'Ben carcinoid appendix'},
        {'code': '209.52',
         'long': 'Benign carcinoid tumor of the cecum',
         'short': 'Benign carcinoid cecum'},
        {'code': '209.53',
         'long': 'Benign carcinoid tumor of the ascending colon',
         'short': 'Ben carcinoid asc colon'},
        {'code': '209.54',
         'long': 'Benign carcinoid tumor of the transverse colon',
         'short': 'Ben crcinoid trans colon'},
        {'code': '209.55',
         'long': 'Benign carcinoid tumor of the descending colon',
         'short': 'Ben carcinoid desc colon'},
        {'code': '209.56',
         'long': 'Benign carcinoid tumor of the sigmoid colon',
         'short': 'Ben carcinoid sig colon'},
        {'code': '209.57',
         'long': 'Benign carcinoid tumor of the rectum',
         'short': 'Benign carcinoid rectum'},
        {'code': '209.60',
         'long': 'Benign carcinoid tumor of unknown primary site',
         'short': 'Ben crcnd prim site unkn'},
        {'code': '209.61',
         'long': 'Benign carcinoid tumor of the bronchus and lung',
         'short': 'Ben carcinoid bronc/lung'},
        {'code': '209.62',
         'long': 'Benign carcinoid tumor of the thymus',
         'short': 'Benign carcinoid thymus'},
        {'code': '209.63',
         'long': 'Benign carcinoid tumor of the stomach',
         'short': 'Benign carcinoid stomach'},
        {'code': '209.64',
         'long': 'Benign carcinoid tumor of the kidney',
         'short': 'Benign carcinoid kidney'},
        {'code': '209.65',
         'long': 'Benign carcinoid tumor of foregut, not otherwise specified',
         'short': 'Ben crcinoid foregut NOS'},
        {'code': '209.66',
         'long': 'Benign carcinoid tumor of midgut, not otherwise specified',
         'short': 'Ben crcinoid midgut NOS'},
        {'code': '209.67',
         'long': 'Benign carcinoid tumor of hindgut, not otherwise specified',
         'short': 'Ben crcnoid hindgut NOS'},
        {'code': '209.69',
         'long': 'Benign carcinoid tumor of other sites',
         'short': 'Bengn carcinoid oth site'},
        {'code': '209.70',
         'long': 'Secondary neuroendocrine tumor, unspecified site',
         'short': 'Sec neuroendo tumor NOS'},
        {'code': '209.71',
         'long': 'Secondary neuroendocrine tumor of distant lymph nodes',
         'short': 'Sec neuroend tu dist lym'},
        {'code': '209.72',
         'long': 'Secondary neuroendocrine tumor of liver',
         'short': 'Sec neuroend tumor-liver'},
        {'code': '209.73',
         'long': 'Secondary neuroendocrine tumor of bone',
         'short': 'Sec neuroendo tumor-bone'},
        {'code': '209.74',
         'long': 'Secondary neuroendocrine tumor of peritoneum',
         'short': 'Sec neuroendo tu-periton'},
        {'code': '209.75',
         'long': 'Secondary Merkel cell carcinoma',
         'short': 'Secondary Merkel cell ca'},
        {'code': '209.79',
         'long': 'Secondary neuroendocrine tumor of other sites',
         'short': 'Sec neuroend tu oth site'},
        {'code': '210.0',
         'long': 'Benign neoplasm of lip',
         'short': 'Benign neoplasm lip'},
        {'code': '210.1',
         'long': 'Benign neoplasm of tongue',
         'short': 'Benign neoplasm tongue'},
        {'code': '210.2',
         'long': 'Benign neoplasm of major salivary glands',
         'short': 'Ben neo major salivary'},
        {'code': '210.3',
         'long': 'Benign neoplasm of floor of mouth',
         'short': 'Benign neo mouth floor'},
        {'code': '210.4',
         'long': 'Benign neoplasm of other and unspecified parts of mouth',
         'short': 'Benign neo mouth NEC/NOS'},
        {'code': '210.5',
         'long': 'Benign neoplasm of tonsil',
         'short': 'Benign neoplasm tonsil'},
        {'code': '210.6',
         'long': 'Benign neoplasm of other parts of oropharynx',
         'short': 'Benign neo oropharyn NEC'},
        {'code': '210.7',
         'long': 'Benign neoplasm of nasopharynx',
         'short': 'Benign neo nasopharynx'},
        {'code': '210.8',
         'long': 'Benign neoplasm of hypopharynx',
         'short': 'Benign neo hypopharynx'},
        {'code': '210.9',
         'long': 'Benign neoplasm of pharynx, unspecified',
         'short': 'Benign neo pharynx NOS'},
        {'code': '211.0',
         'long': 'Benign neoplasm of esophagus',
         'short': 'Benign neo esophagus'},
        {'code': '211.1',
         'long': 'Benign neoplasm of stomach',
         'short': 'Benign neoplasm stomach'},
        {'code': '211.2',
         'long': 'Benign neoplasm of duodenum, jejunum, and ileum',
         'short': 'Benign neoplasm sm bowel'},
        {'code': '211.3',
         'long': 'Benign neoplasm of colon',
         'short': 'Benign neoplasm lg bowel'},
        {'code': '211.4',
         'long': 'Benign neoplasm of rectum and anal canal',
         'short': 'Benign neopl rectum/anus'},
        {'code': '211.5',
         'long': 'Benign neoplasm of liver and biliary passages',
         'short': 'Ben neo liver/bile ducts'},
        {'code': '211.6',
         'long': 'Benign neoplasm of pancreas, except islets of Langerhans',
         'short': 'Benign neoplasm pancreas'},
        {'code': '211.7',
         'long': 'Benign neoplasm of islets of Langerhans',
         'short': 'Ben neo islets langerhan'},
        {'code': '211.8',
         'long': 'Benign neoplasm of retroperitoneum and peritoneum',
         'short': 'Ben neo peritoneum'},
        {'code': '211.9',
         'long': 'Benign neoplasm of other and unspecified site in the digestive system',
         'short': 'Ben neo GI tract NEC/NOS'},
        {'code': '212.0',
         'long': 'Benign neoplasm of nasal cavities, middle ear, and accessory sinuses',
         'short': 'Ben neo nasal cav/sinus'},
        {'code': '212.1',
         'long': 'Benign neoplasm of larynx',
         'short': 'Benign neo larynx'},
        {'code': '212.2',
         'long': 'Benign neoplasm of trachea',
         'short': 'Benign neo trachea'},
        {'code': '212.3',
         'long': 'Benign neoplasm of bronchus and lung',
         'short': 'Benign neo bronchus/lung'},
        {'code': '212.4',
         'long': 'Benign neoplasm of pleura',
         'short': 'Benign neoplasm pleura'},
        {'code': '212.5',
         'long': 'Benign neoplasm of mediastinum',
         'short': 'Benign neo mediastinum'},
        {'code': '212.6',
         'long': 'Benign neoplasm of thymus',
         'short': 'Benign neoplasm thymus'},
        {'code': '212.7',
         'long': 'Benign neoplasm of heart',
         'short': 'Benign neoplasm heart'},
        {'code': '212.8',
         'long': 'Benign neoplasm of other specified sites of respiratory and intrathoracic organs',
         'short': 'Benign neo resp sys NEC'},
        {'code': '212.9',
         'long': 'Benign neoplasm of respiratory and intrathoracic organs, site unspecified',
         'short': 'Benign neo resp sys NOS'},
        {'code': '213.0',
         'long': 'Benign neoplasm of bones of skull and face',
         'short': 'Ben neo skull/face bone'},
        {'code': '213.1',
         'long': 'Benign neoplasm of lower jaw bone',
         'short': 'Ben neo lower jaw bone'},
        {'code': '213.2',
         'long': 'Benign neoplasm of vertebral column, excluding sacrum and coccyx',
         'short': 'Benign neo vertebrae'},
        {'code': '213.3',
         'long': 'Benign neoplasm of ribs, sternum, and clavicle',
         'short': 'Ben neo ribs/stern/clav'},
        {'code': '213.4',
         'long': 'Benign neoplasm of scapula and long bones of upper limb',
         'short': 'Ben neo long bones arm'},
        {'code': '213.5',
         'long': 'Benign neoplasm of short bones of upper limb',
         'short': 'Ben neo bones wrist/hand'},
        {'code': '213.6',
         'long': 'Benign neoplasm of pelvic bones, sacrum, and coccyx',
         'short': 'Benign neo pelvic girdle'},
        {'code': '213.7',
         'long': 'Benign neoplasm of long bones of lower limb',
         'short': 'Ben neo long bones leg'},
        {'code': '213.8',
         'long': 'Benign neoplasm of short bones of lower limb',
         'short': 'Ben neo bones ankle/foot'},
        {'code': '213.9',
         'long': 'Benign neoplasm of bone and articular cartilage, site unspecified',
         'short': 'Benign neo bone NOS'},
        {'code': '214.0',
         'long': 'Lipoma of skin and subcutaneous tissue of face',
         'short': 'Lipoma skin face'},
        {'code': '214.1',
         'long': 'Lipoma of other skin and subcutaneous tissue',
         'short': 'Lipoma skin NEC'},
        {'code': '214.2',
         'long': 'Lipoma of intrathoracic organs',
         'short': 'Lipoma intrathoracic'},
        {'code': '214.3',
         'long': 'Lipoma of intra-abdominal organs',
         'short': 'Lipoma intra-abdominal'},
        {'code': '214.4',
         'long': 'Lipoma of spermatic cord',
         'short': 'Lipoma spermatic cord'},
        {'code': '214.8',
         'long': 'Lipoma of other specified sites',
         'short': 'Lipoma NEC'},
        {'code': '214.9',
         'long': 'Lipoma, unspecified site',
         'short': 'Lipoma NOS'},
        {'code': '215.0',
         'long': 'Other benign neoplasm of connective and other soft tissue of head, face, and neck',
         'short': 'Ben neo soft tissue head'},
        {'code': '215.2',
         'long': 'Other benign neoplasm of connective and other soft tissue of upper limb, including shoulder',
         'short': 'Ben neo soft tissue arm'},
        {'code': '215.3',
         'long': 'Other benign neoplasm of connective and other soft tissue of lower limb, including hip',
         'short': 'Ben neo soft tissue leg'},
        {'code': '215.4',
         'long': 'Other benign neoplasm of connective and other soft tissue of thorax',
         'short': 'Ben neo soft tis thorax'},
        {'code': '215.5',
         'long': 'Other benign neoplasm of connective and other soft tissue of abdomen',
         'short': 'Ben neo soft tis abdomen'},
        {'code': '215.6',
         'long': 'Other benign neoplasm of connective and other soft tissue of pelvis',
         'short': 'Ben neo soft tis pelvis'},
        {'code': '215.7',
         'long': 'Other benign neoplasm of connective and other soft tissue of trunk, unspecified',
         'short': 'Benign neo trunk NOS'},
        {'code': '215.8',
         'long': 'Other benign neoplasm of connective and other soft tissue of other specified sites',
         'short': 'Ben neo soft tissue NEC'},
        {'code': '215.9',
         'long': 'Other benign neoplasm of connective and other soft tissue, site unspecified',
         'short': 'Ben neo soft tissue NOS'},
        {'code': '216.0',
         'long': 'Benign neoplasm of skin of lip',
         'short': 'Benign neo skin lip'},
        {'code': '216.1',
         'long': 'Benign neoplasm of eyelid, including canthus',
         'short': 'Benign neo skin eyelid'},
        {'code': '216.2',
         'long': 'Benign neoplasm of ear and external auditory canal',
         'short': 'Benign neo skin ear'},
        {'code': '216.3',
         'long': 'Benign neoplasm of skin of other and unspecified parts of face',
         'short': 'Benign neo skin face NEC'},
        {'code': '216.4',
         'long': 'Benign neoplasm of scalp and skin of neck',
         'short': 'Ben neo scalp/skin neck'},
        {'code': '216.5',
         'long': 'Benign neoplasm of skin of trunk, except scrotum',
         'short': 'Benign neo skin trunk'},
        {'code': '216.6',
         'long': 'Benign neoplasm of skin of upper limb, including shoulder',
         'short': 'Benign neo skin arm'},
        {'code': '216.7',
         'long': 'Benign neoplasm of skin of lower limb, including hip',
         'short': 'Benign neo skin leg'},
        {'code': '216.8',
         'long': 'Benign neoplasm of other specified sites of skin',
         'short': 'Benign neoplasm skin NEC'},
        {'code': '216.9',
         'long': 'Benign neoplasm of skin, site unspecified',
         'short': 'Benign neoplasm skin NOS'},
        {'code': '217',
         'long': 'Benign neoplasm of breast',
         'short': 'Benign neoplasm breast'},
        {'code': '218.0',
         'long': 'Submucous leiomyoma of uterus',
         'short': 'Submucous leiomyoma'},
        {'code': '218.1',
         'long': 'Intramural leiomyoma of uterus',
         'short': 'Intramural leiomyoma'},
        {'code': '218.2',
         'long': 'Subserous leiomyoma of uterus',
         'short': 'Subserous leiomyoma'},
        {'code': '218.9',
         'long': 'Leiomyoma of uterus, unspecified',
         'short': 'Uterine leiomyoma NOS'},
        {'code': '219.0',
         'long': 'Benign neoplasm of cervix uteri',
         'short': 'Benign neo cervix uteri'},
        {'code': '219.1',
         'long': 'Benign neoplasm of corpus uteri',
         'short': 'Benign neo corpus uteri'},
        {'code': '219.8',
         'long': 'Benign neoplasm of other specified parts of uterus',
         'short': 'Benign neo uterus NEC'},
        {'code': '219.9',
         'long': 'Benign neoplasm of uterus, part unspecified',
         'short': 'Benign neo uterus NOS'},
        {'code': '220',
         'long': 'Benign neoplasm of ovary',
         'short': 'Benign neoplasm ovary'},
        {'code': '221.0',
         'long': 'Benign neoplasm of fallopian tube and uterine ligaments',
         'short': 'Ben neo fallopian tube'},
        {'code': '221.1',
         'long': 'Benign neoplasm of vagina',
         'short': 'Benign neoplasm vagina'},
        {'code': '221.2',
         'long': 'Benign neoplasm of vulva',
         'short': 'Benign neoplasm vulva'},
        {'code': '221.8',
         'long': 'Benign neoplasm of other specified sites of female genital organs',
         'short': 'Ben neo fem genital NEC'},
        {'code': '221.9',
         'long': 'Benign neoplasm of female genital organ, site unspecified',
         'short': 'Ben neo fem genital NOS'},
        {'code': '222.0',
         'long': 'Benign neoplasm of testis',
         'short': 'Benign neoplasm testis'},
        {'code': '222.1',
         'long': 'Benign neoplasm of penis',
         'short': 'Benign neoplasm penis'},
        {'code': '222.2',
         'long': 'Benign neoplasm of prostate',
         'short': 'Benign neoplasm prostate'},
        {'code': '222.3',
         'long': 'Benign neoplasm of epididymis',
         'short': 'Benign neo epididymis'},
        {'code': '222.4',
         'long': 'Benign neoplasm of scrotum',
         'short': 'Benign neoplasm scrotum'},
        {'code': '222.8',
         'long': 'Benign neoplasm of other specified sites of male genital organs',
         'short': 'Ben neo male genital NEC'},
        {'code': '222.9',
         'long': 'Benign neoplasm of male genital organ, site unspecified',
         'short': 'Ben neo male genital NOS'},
        {'code': '223.0',
         'long': 'Benign neoplasm of kidney, except pelvis',
         'short': 'Benign neoplasm kidney'},
        {'code': '223.1',
         'long': 'Benign neoplasm of renal pelvis',
         'short': 'Benign neo renal pelvis'},
        {'code': '223.2',
         'long': 'Benign neoplasm of ureter',
         'short': 'Benign neoplasm ureter'},
        {'code': '223.3',
         'long': 'Benign neoplasm of bladder',
         'short': 'Benign neoplasm bladder'},
        {'code': '223.81',
         'long': 'Benign neoplasm of urethra',
         'short': 'Benign neoplasm urethra'},
        {'code': '223.89',
         'long': 'Benign neoplasm of other specified sites of urinary organs',
         'short': 'Benign neo urinary NEC'},
        {'code': '223.9',
         'long': 'Benign neoplasm of urinary organ, site unspecified',
         'short': 'Benign neo urinary NOS'},
        {'code': '224.0',
         'long': 'Benign neoplasm of eyeball, except conjunctiva, cornea, retina, and choroid',
         'short': 'Benign neoplasm eyeball'},
        {'code': '224.1',
         'long': 'Benign neoplasm of orbit',
         'short': 'Benign neoplasm orbit'},
        {'code': '224.2',
         'long': 'Benign neoplasm of lacrimal gland',
         'short': 'Ben neo lacrimal gland'},
        {'code': '224.3',
         'long': 'Benign neoplasm of conjunctiva',
         'short': 'Benign neo conjunctiva'},
        {'code': '224.4',
         'long': 'Benign neoplasm of cornea',
         'short': 'Benign neoplasm cornea'},
        {'code': '224.5',
         'long': 'Benign neoplasm of retina',
         'short': 'Benign neoplasm retina'},
        {'code': '224.6',
         'long': 'Benign neoplasm of choroid',
         'short': 'Benign neoplasm choroid'},
        {'code': '224.7',
         'long': 'Benign neoplasm of lacrimal duct',
         'short': 'Ben neo lacrimal duct'},
        {'code': '224.8',
         'long': 'Benign neoplasm of other specified parts of eye',
         'short': 'Benign neoplasm eye NEC'},
        {'code': '224.9',
         'long': 'Benign neoplasm of eye, part unspecified',
         'short': 'Benign neoplasm eye NOS'},
        {'code': '225.0',
         'long': 'Benign neoplasm of brain',
         'short': 'Benign neoplasm brain'},
        {'code': '225.1',
         'long': 'Benign neoplasm of cranial nerves',
         'short': 'Benign neo cranial nerve'},
        {'code': '225.2',
         'long': 'Benign neoplasm of cerebral meninges',
         'short': 'Ben neo cerebr meninges'},
        {'code': '225.3',
         'long': 'Benign neoplasm of spinal cord',
         'short': 'Benign neo spinal cord'},
        {'code': '225.4',
         'long': 'Benign neoplasm of spinal meninges',
         'short': 'Ben neo spinal meninges'},
        {'code': '225.8',
         'long': 'Benign neoplasm of other specified sites of nervous system',
         'short': 'Benign neo nerv sys NEC'},
        {'code': '225.9',
         'long': 'Benign neoplasm of nervous system, part unspecified',
         'short': 'Benign neo nerv sys NOS'},
        {'code': '226',
         'long': 'Benign neoplasm of thyroid glands',
         'short': 'Benign neoplasm thyroid'},
        {'code': '227.0',
         'long': 'Benign neoplasm of adrenal gland',
         'short': 'Benign neoplasm adrenal'},
        {'code': '227.1',
         'long': 'Benign neoplasm of parathyroid gland',
         'short': 'Benign neo parathyroid'},
        {'code': '227.3',
         'long': 'Benign neoplasm of pituitary gland and craniopharyngeal duct',
         'short': 'Benign neo pituitary'},
        {'code': '227.4',
         'long': 'Benign neoplasm of pineal gland',
         'short': 'Ben neopl pineal gland'},
        {'code': '227.5',
         'long': 'Benign neoplasm of carotid body',
         'short': 'Benign neo carotid body'},
        {'code': '227.6',
         'long': 'Benign neoplasm of aortic body and other paraganglia',
         'short': 'Ben neo paraganglia NEC'},
        {'code': '227.8',
         'long': 'Benign neoplasm of other endocrine glands and related structures',
         'short': 'Benign neo endocrine NEC'},
        {'code': '227.9',
         'long': 'Benign neoplasm of endocrine gland, site unspecified',
         'short': 'Benign neo endocrine NOS'},
        {'code': '228.00',
         'long': 'Hemangioma of unspecified site',
         'short': 'Hemangioma NOS'},
        {'code': '228.01',
         'long': 'Hemangioma of skin and subcutaneous tissue',
         'short': 'Hemangioma skin'},
        {'code': '228.02',
         'long': 'Hemangioma of intracranial structures',
         'short': 'Hemangioma intracranial'},
        {'code': '228.03',
         'long': 'Hemangioma of retina',
         'short': 'Hemangioma retina'},
        {'code': '228.04',
         'long': 'Hemangioma of intra-abdominal structures',
         'short': 'Hemangioma intra-abdom'},
        {'code': '228.09',
         'long': 'Hemangioma of other sites',
         'short': 'Hemangioma NEC'},
        {'code': '228.1',
         'long': 'Lymphangioma, any site',
         'short': 'Lymphangioma, any site'},
        {'code': '229.0',
         'long': 'Benign neoplasm of lymph nodes',
         'short': 'Benign neo lymph nodes'},
        {'code': '229.8',
         'long': 'Benign neoplasm of other specified sites',
         'short': 'Benign neoplasm NEC'},
        {'code': '229.9',
         'long': 'Benign neoplasm of unspecified site',
         'short': 'Benign neoplasm NOS'},
        {'code': '230.0',
         'long': 'Carcinoma in situ of lip, oral cavity, and pharynx',
         'short': 'Ca in situ oral cav/phar'},
        {'code': '230.1',
         'long': 'Carcinoma in situ of esophagus',
         'short': 'Ca in situ esophagus'},
        {'code': '230.2',
         'long': 'Carcinoma in situ of stomach',
         'short': 'Ca in situ stomach'},
        {'code': '230.3',
         'long': 'Carcinoma in situ of colon',
         'short': 'Ca in situ colon'},
        {'code': '230.4',
         'long': 'Carcinoma in situ of rectum',
         'short': 'Ca in situ rectum'},
        {'code': '230.5',
         'long': 'Carcinoma in situ of anal canal',
         'short': 'Ca in situ anal canal'},
        {'code': '230.6',
         'long': 'Carcinoma in situ of anus, unspecified',
         'short': 'Ca in situ anus NOS'},
        {'code': '230.7',
         'long': 'Carcinoma in situ of other and unspecified parts of intestine',
         'short': 'Ca in situ bowel NEC/NOS'},
        {'code': '230.8',
         'long': 'Carcinoma in situ of liver and biliary system',
         'short': 'Ca in situ liver/biliary'},
        {'code': '230.9',
         'long': 'Carcinoma in situ of other and unspecified digestive organs',
         'short': 'Ca in situ GI NEC/NOS'},
        {'code': '231.0',
         'long': 'Carcinoma in situ of larynx',
         'short': 'Ca in situ larynx'},
        {'code': '231.1',
         'long': 'Carcinoma in situ of trachea',
         'short': 'Ca in situ trachea'},
        {'code': '231.2',
         'long': 'Carcinoma in situ of bronchus and lung',
         'short': 'Ca in situ bronchus/lung'},
        {'code': '231.8',
         'long': 'Carcinoma in situ of other specified parts of respiratory system',
         'short': 'Ca in situ resp sys NEC'},
        {'code': '231.9',
         'long': 'Carcinoma in situ of respiratory system, part unspecified',
         'short': 'Ca in situ resp sys NOS'},
        {'code': '232.0',
         'long': 'Carcinoma in situ of skin of lip',
         'short': 'Ca in situ skin lip'},
        {'code': '232.1',
         'long': 'Carcinoma in situ of eyelid, including canthus',
         'short': 'Ca in situ eyelid'},
        {'code': '232.2',
         'long': 'Carcinoma in situ of skin of ear and external auditory canal',
         'short': 'Ca in situ skin ear'},
        {'code': '232.3',
         'long': 'Carcinoma in situ of skin of other and unspecified parts of face',
         'short': 'Ca in situ skin face NEC'},
        {'code': '232.4',
         'long': 'Carcinoma in situ of scalp and skin of neck',
         'short': 'Ca in situ scalp'},
        {'code': '232.5',
         'long': 'Carcinoma in situ of skin of trunk, except scrotum',
         'short': 'Ca in situ skin trunk'},
        {'code': '232.6',
         'long': 'Carcinoma in situ of skin of upper limb, including shoulder',
         'short': 'Ca in situ skin arm'},
        {'code': '232.7',
         'long': 'Carcinoma in situ of skin of lower limb, including hip',
         'short': 'Ca in situ skin leg'},
        {'code': '232.8',
         'long': 'Carcinoma in situ of other specified sites of skin',
         'short': 'Ca in situ skin NEC'},
        {'code': '232.9',
         'long': 'Carcinoma in situ of skin, site unspecified',
         'short': 'Ca in situ skin NOS'},
        {'code': '233.0',
         'long': 'Carcinoma in situ of breast',
         'short': 'Ca in situ breast'},
        {'code': '233.1',
         'long': 'Carcinoma in situ of cervix uteri',
         'short': 'Ca in situ cervix uteri'},
        {'code': '233.2',
         'long': 'Carcinoma in situ of other and unspecified parts of uterus',
         'short': 'Ca in situ uterus NEC'},
        {'code': '233.30',
         'long': 'Carcinoma in situ, unspecified female genital organ',
         'short': 'Ca in situ fem gen NOS'},
        {'code': '233.31',
         'long': 'Carcinoma in situ, vagina',
         'short': 'Carcinoma in situ vagina'},
        {'code': '233.32',
         'long': 'Carcinoma in situ, vulva',
         'short': 'Carcinoma in situ vulva'},
        {'code': '233.39',
         'long': 'Carcinoma in situ, other female genital organ',
         'short': 'Ca in situ fem gen NEC'},
        {'code': '233.4',
         'long': 'Carcinoma in situ of prostate',
         'short': 'Ca in situ prostate'},
        {'code': '233.5',
         'long': 'Carcinoma in situ of penis',
         'short': 'Ca in situ penis'},
        {'code': '233.6',
         'long': 'Carcinoma in situ of other and unspecified male genital organs',
         'short': 'Ca in situ male gen NEC'},
        {'code': '233.7',
         'long': 'Carcinoma in situ of bladder',
         'short': 'Ca in situ bladder'},
        {'code': '233.9',
         'long': 'Carcinoma in situ of other and unspecified urinary organs',
         'short': 'Ca in situ urinary NEC'},
        {'code': '234.0',
         'long': 'Carcinoma in situ of eye',
         'short': 'Ca in situ eye'},
        {'code': '234.8',
         'long': 'Carcinoma in situ of other specified sites',
         'short': 'Ca in situ NEC'},
        {'code': '234.9',
         'long': 'Carcinoma in situ, site unspecified',
         'short': 'Ca in situ NOS'},
        {'code': '235.0',
         'long': 'Neoplasm of uncertain behavior of major salivary glands',
         'short': 'Unc behav neo salivary'},
        {'code': '235.1',
         'long': 'Neoplasm of uncertain behavior of lip, oral cavity, and pharynx',
         'short': 'Unc behav neo oral/phar'},
        {'code': '235.2',
         'long': 'Neoplasm of uncertain behavior of stomach, intestines, and rectum',
         'short': 'Unc behav neo intestine'},
        {'code': '235.3',
         'long': 'Neoplasm of uncertain behavior of liver and biliary passages',
         'short': 'Unc behav neo liver'},
        {'code': '235.4',
         'long': 'Neoplasm of uncertain behavior of retroperitoneum and peritoneum',
         'short': 'Unc behav neo peritoneum'},
        {'code': '235.5',
         'long': 'Neoplasm of uncertain behavior of other and unspecified digestive organs',
         'short': 'Unc behav neo GI NEC'},
        {'code': '235.6',
         'long': 'Neoplasm of uncertain behavior of larynx',
         'short': 'Unc behav neo larynx'},
        {'code': '235.7',
         'long': 'Neoplasm of uncertain behavior of trachea, bronchus, and lung',
         'short': 'Unc behav neo lung'},
        {'code': '235.8',
         'long': 'Neoplasm of uncertain behavior of pleura, thymus, and mediastinum',
         'short': 'Unc behav neo pleura'},
        {'code': '235.9',
         'long': 'Neoplasm of uncertain behavior of other and unspecified respiratory organs',
         'short': 'Unc behav neo resp NEC'},
        {'code': '236.0',
         'long': 'Neoplasm of uncertain behavior of uterus',
         'short': 'Uncert behav neo uterus'},
        {'code': '236.1',
         'long': 'Neoplasm of uncertain behavior of placenta',
         'short': 'Unc behav neo placenta'},
        {'code': '236.2',
         'long': 'Neoplasm of uncertain behavior of ovary',
         'short': 'Unc behav neo ovary'},
        {'code': '236.3',
         'long': 'Neoplasm of uncertain behavior of other and unspecified female genital organs',
         'short': 'Unc behav neo female NEC'},
        {'code': '236.4',
         'long': 'Neoplasm of uncertain behavior of testis',
         'short': 'Unc behav neo testis'},
        {'code': '236.5',
         'long': 'Neoplasm of uncertain behavior of prostate',
         'short': 'Unc behav neo prostate'},
        {'code': '236.6',
         'long': 'Neoplasm of uncertain behavior of other and unspecified male genital organs',
         'short': 'Unc behav neo male NEC'},
        {'code': '236.7',
         'long': 'Neoplasm of uncertain behavior of bladder',
         'short': 'Unc behav neo bladder'},
        {'code': '236.90',
         'long': 'Neoplasm of uncertain behavior of urinary organ, unspecified',
         'short': 'Unc behav neo urinar NOS'},
        {'code': '236.91',
         'long': 'Neoplasm of uncertain behavior of kidney and ureter',
         'short': 'Unc behav neo kidney'},
        {'code': '236.99',
         'long': 'Neoplasm of uncertain behavior of other and unspecified urinary organs',
         'short': 'Unc behav neo urinar NEC'},
        {'code': '237.0',
         'long': 'Neoplasm of uncertain behavior of pituitary gland and craniopharyngeal duct',
         'short': 'Unc behav neo pituitary'},
        {'code': '237.1',
         'long': 'Neoplasm of uncertain behavior of pineal gland',
         'short': 'Unc behav neo pineal'},
        {'code': '237.2',
         'long': 'Neoplasm of uncertain behavior of adrenal gland',
         'short': 'Unc behav neo adrenal'},
        {'code': '237.3',
         'long': 'Neoplasm of uncertain behavior of paraganglia',
         'short': 'Unc behav neo paragang'},
        {'code': '237.4',
         'long': 'Neoplasm of uncertain behavior of other and unspecified endocrine glands',
         'short': 'Uncer neo endocrine NEC'},
        {'code': '237.5',
         'long': 'Neoplasm of uncertain behavior of brain and spinal cord',
         'short': 'Unc beh neo brain/spinal'},
        {'code': '237.6',
         'long': 'Neoplasm of uncertain behavior of meninges',
         'short': 'Unc behav neo meninges'},
        {'code': '237.70',
         'long': 'Neurofibromatosis, unspecified',
         'short': 'Neurofibromatosis NOS'},
        {'code': '237.71',
         'long': "Neurofibromatosis, type 1 [von recklinghausen's disease]",
         'short': 'Neurofibromatosis type I'},
        {'code': '237.72',
         'long': 'Neurofibromatosis, type 2 [acoustic neurofibromatosis]',
         'short': 'Neurofibromatosis typ II'},
        {'code': '237.73',
         'long': 'Schwannomatosis',
         'short': 'Schwannomatosis'},
        {'code': '237.79',
         'long': 'Other neurofibromatosis',
         'short': 'Neurofibromatosis NEC'},
        {'code': '237.9',
         'long': 'Neoplasm of uncertain behavior of other and unspecified parts of nervous system',
         'short': 'Unc beh neo nerv sys NEC'},
        {'code': '238.0',
         'long': 'Neoplasm of uncertain behavior of bone and articular cartilage',
         'short': 'Unc behav neo bone'},
        {'code': '238.1',
         'long': 'Neoplasm of uncertain behavior of connective and other soft tissue',
         'short': 'Unc behav neo soft tissu'},
        {'code': '238.2',
         'long': 'Neoplasm of uncertain behavior of skin',
         'short': 'Unc behav neo skin'},
        {'code': '238.3',
         'long': 'Neoplasm of uncertain behavior of breast',
         'short': 'Unc behav neo breast'},
        {'code': '238.4',
         'long': 'Polycythemia vera',
         'short': 'Polycythemia vera'},
        {'code': '238.5',
         'long': 'Neoplasm of uncertain behavior of histiocytic and mast cells',
         'short': 'Mastocytoma NOS'},
        {'code': '238.6',
         'long': 'Neoplasm of uncertain behavior of plasma cells',
         'short': 'Plasmacytoma NOS'},
        {'code': '238.71',
         'long': 'Essential thrombocythemia',
         'short': 'Essntial thrombocythemia'},
        {'code': '238.72',
         'long': 'Low grade myelodysplastic syndrome lesions',
         'short': 'Low grde myelody syn les'},
        {'code': '238.73',
         'long': 'High grade myelodysplastic syndrome lesions',
         'short': 'Hi grde myelodys syn les'},
        {'code': '238.74',
         'long': 'Myelodysplastic syndrome with 5q deletion',
         'short': 'Myelodyspls syn w 5q del'},
        {'code': '238.75',
         'long': 'Myelodysplastic syndrome, unspecified',
         'short': 'Myelodysplastic synd NOS'},
        {'code': '238.76',
         'long': 'Myelofibrosis with myeloid metaplasia',
         'short': 'Myelofi w myelo metaplas'},
        {'code': '238.77',
         'long': 'Post-transplant lymphoproliferative disorder (PTLD)',
         'short': 'Post tp lymphprolif dis'},
        {'code': '238.79',
         'long': 'Other lymphatic and hematopoietic tissues',
         'short': 'Lymph/hematpoitc tis NEC'},
        {'code': '238.8',
         'long': 'Neoplasm of uncertain behavior of other specified sites',
         'short': 'Uncert behavior neo NEC'},
        {'code': '238.9',
         'long': 'Neoplasm of uncertain behavior, site unspecified',
         'short': 'Uncert behavior neo NOS'},
        {'code': '239.0',
         'long': 'Neoplasm of unspecified nature of digestive system',
         'short': 'Digestive neoplasm NOS'},
        {'code': '239.1',
         'long': 'Neoplasm of unspecified nature of respiratory system',
         'short': 'Respiratory neoplasm NOS'},
        {'code': '239.2',
         'long': 'Neoplasm of unspecified nature of bone, soft tissue, and skin',
         'short': 'Bone/skin neoplasm NOS'},
        {'code': '239.3',
         'long': 'Neoplasm of unspecified nature of breast',
         'short': 'Breast neoplasm NOS'},
        {'code': '239.4',
         'long': 'Neoplasm of unspecified nature of bladder',
         'short': 'Bladder neoplasm NOS'},
        {'code': '239.5',
         'long': 'Neoplasm of unspecified nature of other genitourinary organs',
         'short': 'Other gu neoplasm NOS'},
        {'code': '239.6',
         'long': 'Neoplasm of unspecified nature of brain',
         'short': 'Brain neoplasm NOS'},
        {'code': '239.7',
         'long': 'Neoplasm of unspecified nature of endocrine glands and other parts of nervous system',
         'short': 'Endocrine/nerv neo NOS'},
        {'code': '239.81',
         'long': 'Neoplasms of unspecified nature, retina and choroid',
         'short': 'Neo retina/choroid NOS'},
        {'code': '239.89',
         'long': 'Neoplasms of unspecified nature, other specified sites',
         'short': 'Neoplasm other sites NOS'},
        {'code': '239.9',
         'long': 'Neoplasm of unspecified nature, site unspecified',
         'short': 'Neoplasm NOS'},
        {'code': '279.00',
         'long': 'Hypogammaglobulinemia, unspecified',
         'short': 'Hypogammaglobulinem NOS'},
        {'code': '279.01',
         'long': 'Selective IgA immunodeficiency',
         'short': 'Selective iga immunodef'},
        {'code': '279.02',
         'long': 'Selective IgM immunodeficiency',
         'short': 'Selective IgM immunodef'},
        {'code': '279.03',
         'long': 'Other selective immunoglobulin deficiencies',
         'short': 'Selective ig defic NEC'},
        {'code': '279.04',
         'long': 'Congenital hypogammaglobulinemia',
         'short': 'Cong hypogammaglobulinem'},
        {'code': '279.05',
         'long': 'Immunodeficiency with increased IgM',
         'short': 'Immunodefic w hyper-igm'},
        {'code': '279.06',
         'long': 'Common variable immunodeficiency',
         'short': 'Common variabl immunodef'},
        {'code': '279.09',
         'long': 'Other deficiency of humoral immunity',
         'short': 'Humoral immunity def NEC'},
        {'code': '279.10',
         'long': 'Immunodeficiency with predominant T-cell defect, unspecified',
         'short': 'Immundef t-cell def NOS'},
        {'code': '279.11',
         'long': "Digeorge's syndrome",
         'short': "Digeorge's syndrome"},
        {'code': '279.12',
         'long': 'Wiskott-aldrich syndrome',
         'short': 'Wiskott-aldrich syndrome'},
        {'code': '279.13',
         'long': "Nezelof's syndrome",
         'short': "Nezelof's syndrome"},
        {'code': '279.19',
         'long': 'Other deficiency of cell-mediated immunity',
         'short': 'Defic cell immunity NOS'},
        {'code': '279.2',
         'long': 'Combined immunity deficiency',
         'short': 'Combined immunity defic'},
        {'code': '279.3',
         'long': 'Unspecified immunity deficiency',
         'short': 'Immunity deficiency NOS'},
        {'code': '279.41',
         'long': 'Autoimmune lymphoproliferative syndrome',
         'short': 'Autoimmun lymphprof synd'},
        {'code': '279.49',
         'long': 'Autoimmune disease, not elsewhere classified',
         'short': 'Autoimmune disease NEC'},
        {'code': '279.50',
         'long': 'Graft-versus-host disease, unspecified',
         'short': 'Graft-versus-host NOS'},
        {'code': '279.51',
         'long': 'Acute graft-versus-host disease',
         'short': 'Ac graft-versus-host dis'},
        {'code': '279.52',
         'long': 'Chronic graft-versus-host disease',
         'short': 'Chronc graft-vs-host dis'},
        {'code': '279.53',
         'long': 'Acute on chronic graft-versus-host disease',
         'short': 'Ac on chrn grft-vs-host'},
        {'code': '279.8',
         'long': 'Other specified disorders involving the immune mechanism',
         'short': 'Immune mechanism dis NEC'},
        {'code': '279.9',
         'long': 'Unspecified disorder of immune mechanism',
         'short': 'Immune mechanism dis NOS'},
        {'code': '280.0',
         'long': 'Iron deficiency anemia secondary to blood loss (chronic)',
         'short': 'Chr blood loss anemia'},
        {'code': '280.1',
         'long': 'Iron deficiency anemia secondary to inadequate dietary iron intake',
         'short': 'Iron def anemia dietary'},
        {'code': '280.8',
         'long': 'Other specified iron deficiency anemias',
         'short': 'Iron defic anemia NEC'},
        {'code': '280.9',
         'long': 'Iron deficiency anemia, unspecified',
         'short': 'Iron defic anemia NOS'},
        {'code': '281.0',
         'long': 'Pernicious anemia',
         'short': 'Pernicious anemia'},
        {'code': '281.1',
         'long': 'Other vitamin B12 deficiency anemia',
         'short': 'B12 defic anemia NEC'},
        {'code': '281.2',
         'long': 'Folate-deficiency anemia',
         'short': 'Folate-deficiency anemia'},
        {'code': '281.3',
         'long': 'Other specified megaloblastic anemias not elsewhere classified',
         'short': 'Megaloblastic anemia NEC'},
        {'code': '281.4',
         'long': 'Protein-deficiency anemia',
         'short': 'Protein defic anemia'},
        {'code': '281.8',
         'long': 'Anemia associated with other specified nutritional deficiency',
         'short': 'Nutritional anemia NEC'},
        {'code': '281.9',
         'long': 'Unspecified deficiency anemia',
         'short': 'Deficiency anemia NOS'},
        {'code': '282.0',
         'long': 'Hereditary spherocytosis',
         'short': 'Hereditary spherocytosis'},
        {'code': '282.1',
         'long': 'Hereditary elliptocytosis',
         'short': 'Heredit elliptocytosis'},
        {'code': '282.2',
         'long': 'Anemias due to disorders of glutathione metabolism',
         'short': 'Glutathione dis anemia'},
        {'code': '282.3',
         'long': 'Other hemolytic anemias due to enzyme deficiency',
         'short': 'Enzyme defic anemia NEC'},
        {'code': '282.40',
         'long': 'Thalassemia, unspecified',
         'short': 'Thalassemia, unspecified'},
        {'code': '282.41',
         'long': 'Sickle-cell thalassemia without crisis',
         'short': 'Thlasema Hb-S w/o crisis'},
        {'code': '282.42',
         'long': 'Sickle-cell thalassemia with crisis',
         'short': 'Thlassemia Hb-S w crisis'},
        {'code': '282.43',
         'long': 'Alpha thalassemia',
         'short': 'Alpha thalassemia'},
        {'code': '282.44',
         'long': 'Beta thalassemia',
         'short': 'Beta thalassemia'},
        {'code': '282.45',
         'long': 'Delta-beta thalassemia',
         'short': 'Delta-beta thalassemia'},
        {'code': '282.46',
         'long': 'Thalassemia minor',
         'short': 'Thalassemia minor'},
        {'code': '282.47',
         'long': 'Hemoglobin E-beta thalassemia',
         'short': 'Hgb E-beta thalassemia'},
        {'code': '282.49',
         'long': 'Other thalassemia',
         'short': 'Thalassemia NEC'},
        {'code': '282.5',
         'long': 'Sickle-cell trait',
         'short': 'Sickle-cell trait'},
        {'code': '282.60',
         'long': 'Sickle-cell disease, unspecified',
         'short': 'Sickle cell disease NOS'},
        {'code': '282.61',
         'long': 'Hb-SS disease without crisis',
         'short': 'Hb-SS disease w/o crisis'},
        {'code': '282.62',
         'long': 'Hb-SS disease with crisis',
         'short': 'Hb-SS disease w crisis'},
        {'code': '282.63',
         'long': 'Sickle-cell/Hb-C disease without crisis',
         'short': 'Hb-SS/hb-C dis w/o crsis'},
        {'code': '282.64',
         'long': 'Sickle-cell/Hb-C disease with crisis',
         'short': 'Hb-S/Hb-C dis w crisis'},
        {'code': '282.68',
         'long': 'Other sickle-cell disease without crisis',
         'short': 'Hb-S dis w/o crisis NEC'},
        {'code': '282.69',
         'long': 'Other sickle-cell disease with crisis',
         'short': 'Hb-SS dis NEC w crisis'},
        {'code': '282.7',
         'long': 'Other hemoglobinopathies',
         'short': 'Hemoglobinopathies NEC'},
        {'code': '282.8',
         'long': 'Other specified hereditary hemolytic anemias',
         'short': 'Hered hemolytic anem NEC'},
        {'code': '282.9',
         'long': 'Hereditary hemolytic anemia, unspecified',
         'short': 'Hered hemolytic anem NOS'},
        {'code': '283.0',
         'long': 'Autoimmune hemolytic anemias',
         'short': 'Autoimmun hemolytic anem'},
        {'code': '283.10',
         'long': 'Non-autoimmune hemolytic anemia, unspecified',
         'short': 'Nonauto hem anemia NOS'},
        {'code': '283.11',
         'long': 'Hemolytic-uremic syndrome',
         'short': 'Hemolytic uremic synd'},
        {'code': '283.19',
         'long': 'Other non-autoimmune hemolytic anemias',
         'short': 'Oth nonauto hem anemia'},
        {'code': '283.2',
         'long': 'Hemoglobinuria due to hemolysis from external causes',
         'short': 'Hemolytic hemoglobinuria'},
        {'code': '283.9',
         'long': 'Acquired hemolytic anemia, unspecified',
         'short': 'Acq hemolytic anemia NOS'},
        {'code': '284.01',
         'long': 'Constitutional red blood cell aplasia',
         'short': 'Constitution RBC aplasia'},
        {'code': '284.09',
         'long': 'Other constitutional aplastic anemia',
         'short': 'Const aplastc anemia NEC'},
        {'code': '284.11',
         'long': 'Antineoplastic chemotherapy induced pancytopenia',
         'short': 'Antin chemo indcd pancyt'},
        {'code': '284.12',
         'long': 'Other drug-induced pancytopenia',
         'short': 'Oth drg indcd pancytopna'},
        {'code': '284.19',
         'long': 'Other pancytopenia',
         'short': 'Other pancytopenia'},
        {'code': '284.2', 'long': 'Myelophthisis', 'short': 'Myelophthisis'},
        {'code': '284.81',
         'long': 'Red cell aplasia (acquired)(adult)(with thymoma)',
         'short': 'Red cell aplasia'},
        {'code': '284.89',
         'long': 'Other specified aplastic anemias',
         'short': 'Aplastic anemias NEC'},
        {'code': '284.9',
         'long': 'Aplastic anemia, unspecified',
         'short': 'Aplastic anemia NOS'},
        {'code': '285.0',
         'long': 'Sideroblastic anemia',
         'short': 'Sideroblastic anemia'},
        {'code': '285.1',
         'long': 'Acute posthemorrhagic anemia',
         'short': 'Ac posthemorrhag anemia'},
        {'code': '285.21',
         'long': 'Anemia in chronic kidney disease',
         'short': 'Anemia in chr kidney dis'},
        {'code': '285.22',
         'long': 'Anemia in neoplastic disease',
         'short': 'Anemia in neoplastic dis'},
        {'code': '285.29',
         'long': 'Anemia of other chronic disease',
         'short': 'Anemia-other chronic dis'},
        {'code': '285.3',
         'long': 'Antineoplastic chemotherapy induced anemia',
         'short': 'Anemia d/t antineo chemo'},
        {'code': '285.8',
         'long': 'Other specified anemias',
         'short': 'Anemia NEC'},
        {'code': '285.9',
         'long': 'Anemia, unspecified',
         'short': 'Anemia NOS'},
        {'code': '286.0',
         'long': 'Congenital factor VIII disorder',
         'short': 'Cong factor viii diord'},
        {'code': '286.1',
         'long': 'Congenital factor IX disorder',
         'short': 'Cong factor IX disorder'},
        {'code': '286.2',
         'long': 'Congenital factor XI deficiency',
         'short': 'Cong factor xi disorder'},
        {'code': '286.3',
         'long': 'Congenital deficiency of other clotting factors',
         'short': 'Cong def clot factor NEC'},
        {'code': '286.4',
         'long': "Von Willebrand's disease",
         'short': "Von willebrand's disease"},
        {'code': '286.52',
         'long': 'Acquired hemophilia',
         'short': 'Acquired hemophilia'},
        {'code': '286.53',
         'long': 'Antiphospholipid antibody with hemorrhagic disorder',
         'short': 'Antiphospholipid w hemor'},
        {'code': '286.59',
         'long': 'Other hemorrhagic disorder due to intrinsic circulating anticoagulants, antibodies, or inhibitors',
         'short': 'Ot hem d/t circ anticoag'},
        {'code': '286.6',
         'long': 'Defibrination syndrome',
         'short': 'Defibrination syndrome'},
        {'code': '286.7',
         'long': 'Acquired coagulation factor deficiency',
         'short': 'Acq coagul factor defic'},
        {'code': '286.9',
         'long': 'Other and unspecified coagulation defects',
         'short': 'Coagulat defect NEC/NOS'},
        {'code': '287.0',
         'long': 'Allergic purpura',
         'short': 'Allergic purpura'},
        {'code': '287.1',
         'long': 'Qualitative platelet defects',
         'short': 'Thrombocytopathy'},
        {'code': '287.2',
         'long': 'Other nonthrombocytopenic purpuras',
         'short': 'Purpura NOS'},
        {'code': '287.30',
         'long': 'Primary thrombocytopenia,unspecified',
         'short': 'Prim thrombocytopen NOS'},
        {'code': '287.31',
         'long': 'Immune thrombocytopenic purpura',
         'short': 'Immune thrombocyt purpra'},
        {'code': '287.32',
         'long': "Evans' syndrome",
         'short': "Evans' syndrome"},
        {'code': '287.33',
         'long': 'Congenital and hereditary thrombocytopenic purpura',
         'short': 'Cong/herid thromb purpra'},
        {'code': '287.39',
         'long': 'Other primary thrombocytopenia',
         'short': 'Prim thrombocytopen NEC'},
        {'code': '287.41',
         'long': 'Posttransfusion purpura',
         'short': 'Posttransfusion purpura'},
        {'code': '287.49',
         'long': 'Other secondary thrombocytopenia',
         'short': 'Sec thrombocytpenia NEC'},
        {'code': '287.5',
         'long': 'Thrombocytopenia, unspecified',
         'short': 'Thrombocytopenia NOS'},
        {'code': '287.8',
         'long': 'Other specified hemorrhagic conditions',
         'short': 'Hemorrhagic cond NEC'},
        {'code': '287.9',
         'long': 'Unspecified hemorrhagic conditions',
         'short': 'Hemorrhagic cond NOS'},
        {'code': '288.00',
         'long': 'Neutropenia, unspecified',
         'short': 'Neutropenia NOS'},
        {'code': '288.01',
         'long': 'Congenital neutropenia',
         'short': 'Congenital neutropenia'},
        {'code': '288.02',
         'long': 'Cyclic neutropenia',
         'short': 'Cyclic neutropenia'},
        {'code': '288.03',
         'long': 'Drug induced neutropenia',
         'short': 'Drug induced neutropenia'},
        {'code': '288.04',
         'long': 'Neutropenia due to infection',
         'short': 'Neutropenia d/t infectn'},
        {'code': '288.09',
         'long': 'Other neutropenia',
         'short': 'Neutropenia NEC'},
        {'code': '288.1',
         'long': 'Functional disorders of polymorphonuclear neutrophils',
         'short': 'Function dis neutrophils'},
        {'code': '288.2',
         'long': 'Genetic anomalies of leukocytes',
         'short': 'Genetic anomaly leukocyt'},
        {'code': '288.3', 'long': 'Eosinophilia', 'short': 'Eosinophilia'},
        {'code': '288.4',
         'long': 'Hemophagocytic syndromes',
         'short': 'Hemophagocytic syndromes'},
        {'code': '288.50',
         'long': 'Leukocytopenia, unspecified',
         'short': 'Leukocytopenia NOS'},
        {'code': '288.51',
         'long': 'Lymphocytopenia',
         'short': 'Lymphocytopenia'},
        {'code': '288.59',
         'long': 'Other decreased white blood cell count',
         'short': 'Decreased WBC count NEC'},
        {'code': '288.60',
         'long': 'Leukocytosis, unspecified',
         'short': 'Leukocytosis NOS'},
        {'code': '288.61',
         'long': 'Lymphocytosis (symptomatic)',
         'short': 'Lymphocytosis-symptomatc'},
        {'code': '288.62',
         'long': 'Leukemoid reaction',
         'short': 'Leukemoid reaction'},
        {'code': '288.63',
         'long': 'Monocytosis (symptomatic)',
         'short': 'Monocytosis-symptomatic'},
        {'code': '288.64', 'long': 'Plasmacytosis', 'short': 'Plasmacytosis'},
        {'code': '288.65', 'long': 'Basophilia', 'short': 'Basophilia'},
        {'code': '288.66', 'long': 'Bandemia', 'short': 'Bandemia'},
        {'code': '288.69',
         'long': 'Other elevated white blood cell count',
         'short': 'Elevated WBC count NEC'},
        {'code': '288.8',
         'long': 'Other specified disease of white blood cells',
         'short': 'Wbc disease NEC'},
        {'code': '288.9',
         'long': 'Unspecified disease of white blood cells',
         'short': 'Wbc disease NOS'},
        {'code': '289.0',
         'long': 'Polycythemia, secondary',
         'short': 'Secondary polycythemia'},
        {'code': '289.1',
         'long': 'Chronic lymphadenitis',
         'short': 'Chronic lymphadenitis'},
        {'code': '289.2',
         'long': 'Nonspecific mesenteric lymphadenitis',
         'short': 'Mesenteric lymphadenitis'},
        {'code': '289.3',
         'long': 'Lymphadenitis, unspecified, except mesenteric',
         'short': 'Lymphadenitis NOS'},
        {'code': '289.4', 'long': 'Hypersplenism', 'short': 'Hypersplenism'},
        {'code': '289.50',
         'long': 'Disease of spleen, unspecified',
         'short': 'Spleen disease NOS'},
        {'code': '289.51',
         'long': 'Chronic congestive splenomegaly',
         'short': 'Chr congest splenomegaly'},
        {'code': '289.52',
         'long': 'Splenic sequestration',
         'short': 'Splenic sequestration'},
        {'code': '289.53',
         'long': 'Neutropenic splenomegaly',
         'short': 'Neutropenic splenomegaly'},
        {'code': '289.59',
         'long': 'Other diseases of spleen',
         'short': 'Spleen disease NEC'},
        {'code': '289.6',
         'long': 'Familial polycythemia',
         'short': 'Familial polycythemia'},
        {'code': '289.7',
         'long': 'Methemoglobinemia',
         'short': 'Methemoglobinemia'},
        {'code': '289.81',
         'long': 'Primary hypercoagulable state',
         'short': 'Prim hypercoagulable st'},
        {'code': '289.82',
         'long': 'Secondary hypercoagulable state',
         'short': 'Sec hypercoagulable st'},
        {'code': '289.83', 'long': 'Myelofibrosis', 'short': 'Myelofibrosis'},
        {'code': '289.84',
         'long': 'Heparin-induced thrombocytopenia (HIT)',
         'short': 'Heparin-indu thrombocyto'},
        {'code': '289.89',
         'long': 'Other specified diseases of blood and blood-forming organs',
         'short': 'Blood diseases NEC'},
        {'code': '289.9',
         'long': 'Unspecified diseases of blood and blood-forming organs',
         'short': 'Blood disease NOS'}],
 'E': [{'code': '240.0',
        'long': 'Goiter, specified as simple',
        'short': 'Simple goiter'},
       {'code': '240.9',
        'long': 'Goiter, unspecified',
        'short': 'Goiter NOS'},
       {'code': '241.0',
        'long': 'Nontoxic uninodular goiter',
        'short': 'Nontox uninodular goiter'},
       {'code': '241.1',
        'long': 'Nontoxic multinodular goiter',
        'short': 'Nontox multinodul goiter'},
       {'code': '241.9',
        'long': 'Unspecified nontoxic nodular goiter',
        'short': 'Nontox nodul goiter NOS'},
       {'code': '242.00',
        'long': 'Toxic diffuse goiter without mention of thyrotoxic crisis or storm',
        'short': 'Tox dif goiter no crisis'},
       {'code': '242.01',
        'long': 'Toxic diffuse goiter with mention of thyrotoxic crisis or storm',
        'short': 'Tox dif goiter w crisis'},
       {'code': '242.10',
        'long': 'Toxic uninodular goiter without mention of thyrotoxic crisis or storm',
        'short': 'Tox uninod goit no cris'},
       {'code': '242.11',
        'long': 'Toxic uninodular goiter with mention of thyrotoxic crisis or storm',
        'short': 'Tox uninod goit w crisis'},
       {'code': '242.20',
        'long': 'Toxic multinodular goiter without mention of thyrotoxic crisis or storm',
        'short': 'Tox multnod goit no cris'},
       {'code': '242.21',
        'long': 'Toxic multinodular goiter with mention of thyrotoxic crisis or storm',
        'short': 'Tox multnod goit w cris'},
       {'code': '242.30',
        'long': 'Toxic nodular goiter, unspecified type, without mention of thyrotoxic crisis or storm',
        'short': 'Tox nod goiter no crisis'},
       {'code': '242.31',
        'long': 'Toxic nodular goiter, unspecified type, with mention of thyrotoxic crisis or storm',
        'short': 'Tox nod goiter w crisis'},
       {'code': '242.40',
        'long': 'Thyrotoxicosis from ectopic thyroid nodule without mention of thyrotoxic crisis or storm',
        'short': 'Thyrotox-ect nod no cris'},
       {'code': '242.41',
        'long': 'Thyrotoxicosis from ectopic thyroid nodule with mention of thyrotoxic crisis or storm',
        'short': 'Thyrotox-ect nod w cris'},
       {'code': '242.80',
        'long': 'Thyrotoxicosis of other specified origin without mention of thyrotoxic crisis or storm',
        'short': 'Thyrtox orig NEC no cris'},
       {'code': '242.81',
        'long': 'Thyrotoxicosis of other specified origin with mention of thyrotoxic crisis or storm',
        'short': 'Thyrotox orig NEC w cris'},
       {'code': '242.90',
        'long': 'Thyrotoxicosis without mention of goiter or other cause, and without mention of thyrotoxic crisis or storm',
        'short': 'Thyrotox NOS no crisis'},
       {'code': '242.91',
        'long': 'Thyrotoxicosis without mention of goiter or other cause, with mention of thyrotoxic crisis or storm',
        'short': 'Thyrotox NOS w crisis'},
       {'code': '243',
        'long': 'Congenital hypothyroidism',
        'short': 'Congenital hypothyroidsm'},
       {'code': '244.0',
        'long': 'Postsurgical hypothyroidism',
        'short': 'Postsurgical hypothyroid'},
       {'code': '244.1',
        'long': 'Other postablative hypothyroidism',
        'short': 'Postablat hypothyr NEC'},
       {'code': '244.2',
        'long': 'Iodine hypothyroidism',
        'short': 'Iodine hypothyroidism'},
       {'code': '244.3',
        'long': 'Other iatrogenic hypothyroidism',
        'short': 'Iatrogen hypothyroid NEC'},
       {'code': '244.8',
        'long': 'Other specified acquired hypothyroidism',
        'short': 'Acquired hypothyroid NEC'},
       {'code': '244.9',
        'long': 'Unspecified acquired hypothyroidism',
        'short': 'Hypothyroidism NOS'},
       {'code': '245.0',
        'long': 'Acute thyroiditis',
        'short': 'Acute thyroiditis'},
       {'code': '245.1',
        'long': 'Subacute thyroiditis',
        'short': 'Subacute thyroiditis'},
       {'code': '245.2',
        'long': 'Chronic lymphocytic thyroiditis',
        'short': 'Chr lymphocyt thyroidit'},
       {'code': '245.3',
        'long': 'Chronic fibrous thyroiditis',
        'short': 'Chr fibrous thyroiditis'},
       {'code': '245.4',
        'long': 'Iatrogenic thyroiditis',
        'short': 'Iatrogenic thyroiditis'},
       {'code': '245.8',
        'long': 'Other and unspecified chronic thyroiditis',
        'short': 'Chr thyroiditis NEC/NOS'},
       {'code': '245.9',
        'long': 'Thyroiditis, unspecified',
        'short': 'Thyroiditis NOS'},
       {'code': '246.0',
        'long': 'Disorders of thyrocalcitonin secretion',
        'short': 'Dis thyrocalciton secret'},
       {'code': '246.1',
        'long': 'Dyshormonogenic goiter',
        'short': 'Dyshormonogenic goiter'},
       {'code': '246.2',
        'long': 'Cyst of thyroid',
        'short': 'Cyst of thyroid'},
       {'code': '246.3',
        'long': 'Hemorrhage and infarction of thyroid',
        'short': 'Hemorr/infarc thyroid'},
       {'code': '246.8',
        'long': 'Other specified disorders of thyroid',
        'short': 'Disorders of thyroid NEC'},
       {'code': '246.9',
        'long': 'Unspecified disorder of thyroid',
        'short': 'Disorder of thyroid NOS'},
       {'code': '249.00',
        'long': 'Secondary diabetes mellitus without mention of complication, not stated as uncontrolled, or unspecified',
        'short': 'Sec DM wo cmp nt st uncn'},
       {'code': '249.01',
        'long': 'Secondary diabetes mellitus without mention of complication, uncontrolled',
        'short': 'Sec DM wo comp uncontrld'},
       {'code': '249.10',
        'long': 'Secondary diabetes mellitus with ketoacidosis, not stated as uncontrolled, or unspecified',
        'short': 'Sec DM keto nt st uncntr'},
       {'code': '249.11',
        'long': 'Secondary diabetes mellitus with ketoacidosis, uncontrolled',
        'short': 'Sec DM ketoacd uncntrld'},
       {'code': '249.20',
        'long': 'Secondary diabetes mellitus with hyperosmolarity, not stated as uncontrolled, or unspecified',
        'short': 'Sec DM hpros nt st uncnr'},
       {'code': '249.21',
        'long': 'Secondary diabetes mellitus with hyperosmolarity, uncontrolled',
        'short': 'Sec DM hprosmlr uncntrld'},
       {'code': '249.30',
        'long': 'Secondary diabetes mellitus with other coma, not stated as uncontrolled, or unspecified',
        'short': 'Sec DM ot cma nt st uncn'},
       {'code': '249.31',
        'long': 'Secondary diabetes mellitus with other coma, uncontrolled',
        'short': 'Sec DM oth coma uncntrld'},
       {'code': '249.40',
        'long': 'Secondary diabetes mellitus with renal manifestations, not stated as uncontrolled, or unspecified',
        'short': 'Sec DM renl nt st uncntr'},
       {'code': '249.41',
        'long': 'Secondary diabetes mellitus with renal manifestations, uncontrolled',
        'short': 'Sec DM renal uncontrld'},
       {'code': '249.50',
        'long': 'Secondary diabetes mellitus with ophthalmic manifestations, not stated as uncontrolled, or unspecified',
        'short': 'Sec DM ophth nt st uncn'},
       {'code': '249.51',
        'long': 'Secondary diabetes mellitus with ophthalmic manifestations, uncontrolled',
        'short': 'Sec DM ophth uncontrld'},
       {'code': '249.60',
        'long': 'Secondary diabetes mellitus with neurological manifestations, not stated as uncontrolled, or unspecified',
        'short': 'Sec DM neuro nt st uncn'},
       {'code': '249.61',
        'long': 'Secondary diabetes mellitus with neurological manifestations, uncontrolled',
        'short': 'Sec DM neuro uncontrld'},
       {'code': '249.70',
        'long': 'Secondary diabetes mellitus with peripheral circulatory disorders, not stated as uncontrolled, or unspecified',
        'short': 'Sec DM circ nt st uncntr'},
       {'code': '249.71',
        'long': 'Secondary diabetes mellitus with peripheral circulatory disorders, uncontrolled',
        'short': 'Sec DM circ uncontrld'},
       {'code': '249.80',
        'long': 'Secondary diabetes mellitus with other specified manifestations, not stated as uncontrolled, or unspecified',
        'short': 'Sec DM oth nt st uncontr'},
       {'code': '249.81',
        'long': 'Secondary diabetes mellitus with other specified manifestations, uncontrolled',
        'short': 'Sec DM other uncontrld'},
       {'code': '249.90',
        'long': 'Secondary diabetes mellitus with unspecified complication, not stated as uncontrolled, or unspecified',
        'short': 'Sec DM unsp nt st uncon'},
       {'code': '249.91',
        'long': 'Secondary diabetes mellitus with unspecified complication, uncontrolled',
        'short': 'Sec DM unsp uncontrold'},
       {'code': '250.00',
        'long': 'Diabetes mellitus without mention of complication, type II or unspecified type, not stated as uncontrolled',
        'short': 'DMII wo cmp nt st uncntr'},
       {'code': '250.01',
        'long': 'Diabetes mellitus without mention of complication, type I [juvenile type], not stated as uncontrolled',
        'short': 'DMI wo cmp nt st uncntrl'},
       {'code': '250.02',
        'long': 'Diabetes mellitus without mention of complication, type II or unspecified type, uncontrolled',
        'short': 'DMII wo cmp uncntrld'},
       {'code': '250.03',
        'long': 'Diabetes mellitus without mention of complication, type I [juvenile type], uncontrolled',
        'short': 'DMI wo cmp uncntrld'},
       {'code': '250.10',
        'long': 'Diabetes with ketoacidosis, type II or unspecified type, not stated as uncontrolled',
        'short': 'DMII keto nt st uncntrld'},
       {'code': '250.11',
        'long': 'Diabetes with ketoacidosis, type I [juvenile type], not stated as uncontrolled',
        'short': 'DMI keto nt st uncntrld'},
       {'code': '250.12',
        'long': 'Diabetes with ketoacidosis, type II or unspecified type, uncontrolled',
        'short': 'DMII ketoacd uncontrold'},
       {'code': '250.13',
        'long': 'Diabetes with ketoacidosis, type I [juvenile type], uncontrolled',
        'short': 'DMI ketoacd uncontrold'},
       {'code': '250.20',
        'long': 'Diabetes with hyperosmolarity, type II or unspecified type, not stated as uncontrolled',
        'short': 'DMII hprsm nt st uncntrl'},
       {'code': '250.21',
        'long': 'Diabetes with hyperosmolarity, type I [juvenile type], not stated as uncontrolled',
        'short': 'DMI hprsm nt st uncntrld'},
       {'code': '250.22',
        'long': 'Diabetes with hyperosmolarity, type II or unspecified type, uncontrolled',
        'short': 'DMII hprosmlr uncontrold'},
       {'code': '250.23',
        'long': 'Diabetes with hyperosmolarity, type I [juvenile type], uncontrolled',
        'short': 'DMI hprosmlr uncontrold'},
       {'code': '250.30',
        'long': 'Diabetes with other coma, type II or unspecified type, not stated as uncontrolled',
        'short': 'DMII o cm nt st uncntrld'},
       {'code': '250.31',
        'long': 'Diabetes with other coma, type I [juvenile type], not stated as uncontrolled',
        'short': 'DMI o cm nt st uncntrld'},
       {'code': '250.32',
        'long': 'Diabetes with other coma, type II or unspecified type, uncontrolled',
        'short': 'DMII oth coma uncontrold'},
       {'code': '250.33',
        'long': 'Diabetes with other coma, type I [juvenile type], uncontrolled',
        'short': 'DMI oth coma uncontrold'},
       {'code': '250.40',
        'long': 'Diabetes with renal manifestations, type II or unspecified type, not stated as uncontrolled',
        'short': 'DMII renl nt st uncntrld'},
       {'code': '250.41',
        'long': 'Diabetes with renal manifestations, type I [juvenile type], not stated as uncontrolled',
        'short': 'DMI renl nt st uncntrld'},
       {'code': '250.42',
        'long': 'Diabetes with renal manifestations, type II or unspecified type, uncontrolled',
        'short': 'DMII renal uncntrld'},
       {'code': '250.43',
        'long': 'Diabetes with renal manifestations, type I [juvenile type], uncontrolled',
        'short': 'DMI renal uncntrld'},
       {'code': '250.50',
        'long': 'Diabetes with ophthalmic manifestations, type II or unspecified type, not stated as uncontrolled',
        'short': 'DMII ophth nt st uncntrl'},
       {'code': '250.51',
        'long': 'Diabetes with ophthalmic manifestations, type I [juvenile type], not stated as uncontrolled',
        'short': 'DMI ophth nt st uncntrld'},
       {'code': '250.52',
        'long': 'Diabetes with ophthalmic manifestations, type II or unspecified type, uncontrolled',
        'short': 'DMII ophth uncntrld'},
       {'code': '250.53',
        'long': 'Diabetes with ophthalmic manifestations, type I [juvenile type], uncontrolled',
        'short': 'DMI ophth uncntrld'},
       {'code': '250.60',
        'long': 'Diabetes with neurological manifestations, type II or unspecified type, not stated as uncontrolled',
        'short': 'DMII neuro nt st uncntrl'},
       {'code': '250.61',
        'long': 'Diabetes with neurological manifestations, type I [juvenile type], not stated as uncontrolled',
        'short': 'DMI neuro nt st uncntrld'},
       {'code': '250.62',
        'long': 'Diabetes with neurological manifestations, type II or unspecified type, uncontrolled',
        'short': 'DMII neuro uncntrld'},
       {'code': '250.63',
        'long': 'Diabetes with neurological manifestations, type I [juvenile type], uncontrolled',
        'short': 'DMI neuro uncntrld'},
       {'code': '250.70',
        'long': 'Diabetes with peripheral circulatory disorders, type II or unspecified type, not stated as uncontrolled',
        'short': 'DMII circ nt st uncntrld'},
       {'code': '250.71',
        'long': 'Diabetes with peripheral circulatory disorders, type I [juvenile type], not stated as uncontrolled',
        'short': 'DMI circ nt st uncntrld'},
       {'code': '250.72',
        'long': 'Diabetes with peripheral circulatory disorders, type II or unspecified type, uncontrolled',
        'short': 'DMII circ uncntrld'},
       {'code': '250.73',
        'long': 'Diabetes with peripheral circulatory disorders, type I [juvenile type], uncontrolled',
        'short': 'DMI circ uncntrld'},
       {'code': '250.80',
        'long': 'Diabetes with other specified manifestations, type II or unspecified type, not stated as uncontrolled',
        'short': 'DMII oth nt st uncntrld'},
       {'code': '250.81',
        'long': 'Diabetes with other specified manifestations, type I [juvenile type], not stated as uncontrolled',
        'short': 'DMI oth nt st uncntrld'},
       {'code': '250.82',
        'long': 'Diabetes with other specified manifestations, type II or unspecified type, uncontrolled',
        'short': 'DMII oth uncntrld'},
       {'code': '250.83',
        'long': 'Diabetes with other specified manifestations, type I [juvenile type], uncontrolled',
        'short': 'DMI oth uncntrld'},
       {'code': '250.90',
        'long': 'Diabetes with unspecified complication, type II or unspecified type, not stated as uncontrolled',
        'short': 'DMII unspf nt st uncntrl'},
       {'code': '250.91',
        'long': 'Diabetes with unspecified complication, type I [juvenile type], not stated as uncontrolled',
        'short': 'DMI unspf nt st uncntrld'},
       {'code': '250.92',
        'long': 'Diabetes with unspecified complication, type II or unspecified type, uncontrolled',
        'short': 'DMII unspf uncntrld'},
       {'code': '250.93',
        'long': 'Diabetes with unspecified complication, type I [juvenile type], uncontrolled',
        'short': 'DMI unspf uncntrld'},
       {'code': '251.0',
        'long': 'Hypoglycemic coma',
        'short': 'Hypoglycemic coma'},
       {'code': '251.1',
        'long': 'Other specified hypoglycemia',
        'short': 'Oth spcf hypoglycemia'},
       {'code': '251.2',
        'long': 'Hypoglycemia, unspecified',
        'short': 'Hypoglycemia NOS'},
       {'code': '251.3',
        'long': 'Postsurgical hypoinsulinemia',
        'short': 'Postsurg hypoinsulinemia'},
       {'code': '251.4',
        'long': 'Abnormality of secretion of glucagon',
        'short': 'Abn secretion glucagon'},
       {'code': '251.5',
        'long': 'Abnormality of secretion of gastrin',
        'short': 'Abnorm secretion gastrin'},
       {'code': '251.8',
        'long': 'Other specified disorders of pancreatic internal secretion',
        'short': 'Pancreatic disorder NEC'},
       {'code': '251.9',
        'long': 'Unspecified disorder of pancreatic internal secretion',
        'short': 'Pancreatic disorder NOS'},
       {'code': '252.00',
        'long': 'Hyperparathyroidism, unspecified',
        'short': 'Hyperparathyroidism NOS'},
       {'code': '252.01',
        'long': 'Primary hyperparathyroidism',
        'short': 'Primary hyperparathyroid'},
       {'code': '252.02',
        'long': 'Secondary hyperparathyroidism, non-renal',
        'short': 'Sec hyprprthyrd nonrenal'},
       {'code': '252.08',
        'long': 'Other hyperparathyroidism',
        'short': 'Hyperparathyroidism NEC'},
       {'code': '252.1',
        'long': 'Hypoparathyroidism',
        'short': 'Hypoparathyroidism'},
       {'code': '252.8',
        'long': 'Other specified disorders of parathyroid gland',
        'short': 'Parathyroid disorder NEC'},
       {'code': '252.9',
        'long': 'Unspecified disorder of parathyroid gland',
        'short': 'Parathyroid disorder NOS'},
       {'code': '253.0',
        'long': 'Acromegaly and gigantism',
        'short': 'Acromegaly and gigantism'},
       {'code': '253.1',
        'long': 'Other and unspecified anterior pituitary hyperfunction',
        'short': 'Ant pituit hyperfunc NEC'},
       {'code': '253.2',
        'long': 'Panhypopituitarism',
        'short': 'Panhypopituitarism'},
       {'code': '253.3',
        'long': 'Pituitary dwarfism',
        'short': 'Pituitary dwarfism'},
       {'code': '253.4',
        'long': 'Other anterior pituitary disorders',
        'short': 'Anter pituitary dis NEC'},
       {'code': '253.5',
        'long': 'Diabetes insipidus',
        'short': 'Diabetes insipidus'},
       {'code': '253.6',
        'long': 'Other disorders of neurohypophysis',
        'short': 'Neurohypophysis dis NEC'},
       {'code': '253.7',
        'long': 'Iatrogenic pituitary disorders',
        'short': 'Iatrogenic pituitary dis'},
       {'code': '253.8',
        'long': 'Other disorders of the pituitary and other syndromes of diencephalohypophyseal origin',
        'short': 'Pituitary disorder NEC'},
       {'code': '253.9',
        'long': 'Unspecified disorder of the pituitary gland and its hypothalamic control',
        'short': 'Pituitary disorder NOS'},
       {'code': '254.0',
        'long': 'Persistent hyperplasia of thymus',
        'short': 'Persist hyperplas thymus'},
       {'code': '254.1',
        'long': 'Abscess of thymus',
        'short': 'Abscess of thymus'},
       {'code': '254.8',
        'long': 'Other specified diseases of thymus gland',
        'short': 'Diseases of thymus NEC'},
       {'code': '254.9',
        'long': 'Unspecified disease of thymus gland',
        'short': 'Disease of thymus NOS'},
       {'code': '255.0',
        'long': "Cushing's syndrome",
        'short': "Cushing's syndrome"},
       {'code': '255.10',
        'long': 'Hyperaldosteronism, unspecified',
        'short': 'Hyperaldosteronism NOS'},
       {'code': '255.11',
        'long': 'Glucocorticoid-remediable aldosteronism',
        'short': 'Glucrtcod-rem aldsternsm'},
       {'code': '255.12',
        'long': "Conn's syndrome",
        'short': "Conn's syndrome"},
       {'code': '255.13',
        'long': "Bartter's syndrome",
        'short': "Bartter's syndrome"},
       {'code': '255.14',
        'long': 'Other secondary aldosteronism',
        'short': 'Secondry aldosternsm NEC'},
       {'code': '255.2',
        'long': 'Adrenogenital disorders',
        'short': 'Adrenogenital disorders'},
       {'code': '255.3',
        'long': 'Other corticoadrenal overactivity',
        'short': 'Corticoadren overact NEC'},
       {'code': '255.41',
        'long': 'Glucocorticoid deficiency',
        'short': 'Glucocorticoid deficient'},
       {'code': '255.42',
        'long': 'Mineralocorticoid deficiency',
        'short': 'Mineralcorticoid defcnt'},
       {'code': '255.5',
        'long': 'Other adrenal hypofunction',
        'short': 'Adrenal hypofunction NEC'},
       {'code': '255.6',
        'long': 'Medulloadrenal hyperfunction',
        'short': 'Medulloadrenal hyperfunc'},
       {'code': '255.8',
        'long': 'Other specified disorders of adrenal glands',
        'short': 'Adrenal disorder NEC'},
       {'code': '255.9',
        'long': 'Unspecified disorder of adrenal glands',
        'short': 'Adrenal disorder NOS'},
       {'code': '256.0',
        'long': 'Hyperestrogenism',
        'short': 'Hyperestrogenism'},
       {'code': '256.1',
        'long': 'Other ovarian hyperfunction',
        'short': 'Ovarian hyperfunc NEC'},
       {'code': '256.2',
        'long': 'Postablative ovarian failure',
        'short': 'Postablativ ovarian fail'},
       {'code': '256.31',
        'long': 'Premature menopause',
        'short': 'Premature menopause'},
       {'code': '256.39',
        'long': 'Other ovarian failure',
        'short': 'Ovarian failure NEC'},
       {'code': '256.4',
        'long': 'Polycystic ovaries',
        'short': 'Polycystic ovaries'},
       {'code': '256.8',
        'long': 'Other ovarian dysfunction',
        'short': 'Ovarian dysfunction NEC'},
       {'code': '256.9',
        'long': 'Unspecified ovarian dysfunction',
        'short': 'Ovarian dysfunction NOS'},
       {'code': '257.0',
        'long': 'Testicular hyperfunction',
        'short': 'Testicular hyperfunction'},
       {'code': '257.1',
        'long': 'Postablative testicular hypofunction',
        'short': 'Postablat testic hypofun'},
       {'code': '257.2',
        'long': 'Other testicular hypofunction',
        'short': 'Testicular hypofunc NEC'},
       {'code': '257.8',
        'long': 'Other testicular dysfunction',
        'short': 'Testicular dysfunct NEC'},
       {'code': '257.9',
        'long': 'Unspecified testicular dysfunction',
        'short': 'Testicular dysfunct NOS'},
       {'code': '258.01',
        'long': 'Multiple endocrine neoplasia [MEN] type I',
        'short': 'Mult endo neoplas type I'},
       {'code': '258.02',
        'long': 'Multiple endocrine neoplasia [MEN] type IIA',
        'short': 'Mult endo neop type IIA'},
       {'code': '258.03',
        'long': 'Multiple endocrine neoplasia [MEN] type IIB',
        'short': 'Mult endo neop type IIB'},
       {'code': '258.1',
        'long': 'Other combinations of endocrine dysfunction',
        'short': 'Comb endocr dysfunct NEC'},
       {'code': '258.8',
        'long': 'Other specified polyglandular dysfunction',
        'short': 'Polyglandul dysfunc NEC'},
       {'code': '258.9',
        'long': 'Polyglandular dysfunction, unspecified',
        'short': 'Polyglandul dysfunc NOS'},
       {'code': '259.0',
        'long': 'Delay in sexual development and puberty, not elsewhere classified',
        'short': 'Delay sexual develop NEC'},
       {'code': '259.1',
        'long': 'Precocious sexual development and puberty, not elsewhere classified',
        'short': 'Sexual precocity NEC'},
       {'code': '259.2',
        'long': 'Carcinoid syndrome',
        'short': 'Carcinoid syndrome'},
       {'code': '259.3',
        'long': 'Ectopic hormone secretion, not elsewhere classified',
        'short': 'Ectopic hormone secr NEC'},
       {'code': '259.4',
        'long': 'Dwarfism, not elsewhere classified',
        'short': 'Dwarfism NEC'},
       {'code': '259.50',
        'long': 'Androgen insensitivity, unspecified',
        'short': 'Androgen insensitvty NOS'},
       {'code': '259.51',
        'long': 'Androgen insensitivity syndrome',
        'short': 'Androgen insensitvty syn'},
       {'code': '259.52',
        'long': 'Partial androgen insensitivity',
        'short': 'Part androgen insnsitvty'},
       {'code': '259.8',
        'long': 'Other specified endocrine disorders',
        'short': 'Endocrine disorders NEC'},
       {'code': '259.9',
        'long': 'Unspecified endocrine disorder',
        'short': 'Endocrine disorder NOS'},
       {'code': '260', 'long': 'Kwashiorkor', 'short': 'Kwashiorkor'},
       {'code': '261',
        'long': 'Nutritional marasmus',
        'short': 'Nutritional marasmus'},
       {'code': '262',
        'long': 'Other severe protein-calorie malnutrition',
        'short': 'Oth severe malnutrition'},
       {'code': '263.0',
        'long': 'Malnutrition of moderate degree',
        'short': 'Malnutrition mod degree'},
       {'code': '263.1',
        'long': 'Malnutrition of mild degree',
        'short': 'Malnutrition mild degree'},
       {'code': '263.2',
        'long': 'Arrested development following protein-calorie malnutrition',
        'short': 'Arrest devel d/t malnutr'},
       {'code': '263.8',
        'long': 'Other protein-calorie malnutrition',
        'short': 'Protein-cal malnutr NEC'},
       {'code': '263.9',
        'long': 'Unspecified protein-calorie malnutrition',
        'short': 'Protein-cal malnutr NOS'},
       {'code': '264.0',
        'long': 'Vitamin A deficiency with conjunctival xerosis',
        'short': 'Vit A conjunctiv xerosis'},
       {'code': '264.1',
        'long': "Vitamin A deficiency with conjunctival xerosis and Bitot's spot",
        'short': "Vit A bitot's spot"},
       {'code': '264.2',
        'long': 'Vitamin A deficiency with corneal xerosis',
        'short': 'Vit A corneal xerosis'},
       {'code': '264.3',
        'long': 'Vitamin A deficiency with corneal ulceration and xerosis',
        'short': 'Vit A cornea ulcer/xeros'},
       {'code': '264.4',
        'long': 'Vitamin A deficiency with keratomalacia',
        'short': 'Vit A keratomalacia'},
       {'code': '264.5',
        'long': 'Vitamin A deficiency with night blindness',
        'short': 'Vit A night blindness'},
       {'code': '264.6',
        'long': 'Vitamin A deficiency with xerophthalmic scars of cornea',
        'short': 'Vit A def w corneal scar'},
       {'code': '264.7',
        'long': 'Other ocular manifestations of vitamin A deficiency',
        'short': 'Vit A ocular defic NEC'},
       {'code': '264.8',
        'long': 'Other manifestations of vitamin A deficiency',
        'short': 'Vitamin A deficiency NEC'},
       {'code': '264.9',
        'long': 'Unspecified vitamin A deficiency',
        'short': 'Vitamin A deficiency NOS'},
       {'code': '265.0', 'long': 'Beriberi', 'short': 'Beriberi'},
       {'code': '265.1',
        'long': 'Other and unspecified manifestations of thiamine deficiency',
        'short': 'Thiamine defic NEC/NOS'},
       {'code': '265.2', 'long': 'Pellagra', 'short': 'Pellagra'},
       {'code': '266.0',
        'long': 'Ariboflavinosis',
        'short': 'Ariboflavinosis'},
       {'code': '266.1',
        'long': 'Vitamin B6 deficiency',
        'short': 'Vitamin b6 deficiency'},
       {'code': '266.2',
        'long': 'Other B-complex deficiencies',
        'short': 'B-complex defic NEC'},
       {'code': '266.9',
        'long': 'Unspecified vitamin B deficiency',
        'short': 'Vitamin b deficiency NOS'},
       {'code': '267',
        'long': 'Ascorbic acid deficiency',
        'short': 'Ascorbic acid deficiency'},
       {'code': '268.0',
        'long': 'Rickets, active',
        'short': 'Rickets, active'},
       {'code': '268.1',
        'long': 'Rickets, late effect',
        'short': 'Rickets, late effect'},
       {'code': '268.2',
        'long': 'Osteomalacia, unspecified',
        'short': 'Osteomalacia NOS'},
       {'code': '268.9',
        'long': 'Unspecified vitamin D deficiency',
        'short': 'Vitamin D deficiency NOS'},
       {'code': '269.0',
        'long': 'Deficiency of vitamin K',
        'short': 'Deficiency of vitamin k'},
       {'code': '269.1',
        'long': 'Deficiency of other vitamins',
        'short': 'Vitamin Deficiency NEC'},
       {'code': '269.2',
        'long': 'Unspecified vitamin deficiency',
        'short': 'Vitamin Deficiency NOS'},
       {'code': '269.3',
        'long': 'Mineral deficiency, not elsewhere classified',
        'short': 'Mineral deficiency NEC'},
       {'code': '269.8',
        'long': 'Other nutritional deficiency',
        'short': 'Nutrition deficiency NEC'},
       {'code': '269.9',
        'long': 'Unspecified nutritional deficiency',
        'short': 'Nutrition deficiency NOS'},
       {'code': '270.0',
        'long': 'Disturbances of amino-acid transport',
        'short': 'Amino-acid transport dis'},
       {'code': '270.1',
        'long': 'Phenylketonuria [PKU]',
        'short': 'Phenylketonuria - pku'},
       {'code': '270.2',
        'long': 'Other disturbances of aromatic amino-acid metabolism',
        'short': 'Arom amin-acid metab NEC'},
       {'code': '270.3',
        'long': 'Disturbances of branched-chain amino-acid metabolism',
        'short': 'Bran-chain amin-acid dis'},
       {'code': '270.4',
        'long': 'Disturbances of sulphur-bearing amino-acid metabolism',
        'short': 'Sulph amino-acid met dis'},
       {'code': '270.5',
        'long': 'Disturbances of histidine metabolism',
        'short': 'Dis histidine metabolism'},
       {'code': '270.6',
        'long': 'Disorders of urea cycle metabolism',
        'short': 'Dis urea cycle metabol'},
       {'code': '270.7',
        'long': 'Other disturbances of straight-chain amino-acid metabolism',
        'short': 'Straig amin-acid met NEC'},
       {'code': '270.8',
        'long': 'Other specified disorders of amino-acid metabolism',
        'short': 'Dis amino-acid metab NEC'},
       {'code': '270.9',
        'long': 'Unspecified disorder of amino-acid metabolism',
        'short': 'Dis amino-acid metab NOS'},
       {'code': '271.0', 'long': 'Glycogenosis', 'short': 'Glycogenosis'},
       {'code': '271.1', 'long': 'Galactosemia', 'short': 'Galactosemia'},
       {'code': '271.2',
        'long': 'Hereditary fructose intolerance',
        'short': 'Hered fructose intoleran'},
       {'code': '271.3',
        'long': 'Intestinal disaccharidase deficiencies and disaccharide malabsorption',
        'short': 'Disaccharidase def/malab'},
       {'code': '271.4',
        'long': 'Renal glycosuria',
        'short': 'Renal glycosuria'},
       {'code': '271.8',
        'long': 'Other specified disorders of carbohydrate transport and metabolism',
        'short': 'Dis carbohydr metab NEC'},
       {'code': '271.9',
        'long': 'Unspecified disorder of carbohydrate transport and metabolism',
        'short': 'Dis carbohydr metab NOS'},
       {'code': '272.0',
        'long': 'Pure hypercholesterolemia',
        'short': 'Pure hypercholesterolem'},
       {'code': '272.1',
        'long': 'Pure hyperglyceridemia',
        'short': 'Pure hyperglyceridemia'},
       {'code': '272.2',
        'long': 'Mixed hyperlipidemia',
        'short': 'Mixed hyperlipidemia'},
       {'code': '272.3',
        'long': 'Hyperchylomicronemia',
        'short': 'Hyperchylomicronemia'},
       {'code': '272.4',
        'long': 'Other and unspecified hyperlipidemia',
        'short': 'Hyperlipidemia NEC/NOS'},
       {'code': '272.5',
        'long': 'Lipoprotein deficiencies',
        'short': 'Lipoprotein deficiencies'},
       {'code': '272.6', 'long': 'Lipodystrophy', 'short': 'Lipodystrophy'},
       {'code': '272.7', 'long': 'Lipidoses', 'short': 'Lipidoses'},
       {'code': '272.8',
        'long': 'Other disorders of lipoid metabolism',
        'short': 'Lipoid metabol dis NEC'},
       {'code': '272.9',
        'long': 'Unspecified disorder of lipoid metabolism',
        'short': 'Lipoid metabol dis NOS'},
       {'code': '273.0',
        'long': 'Polyclonal hypergammaglobulinemia',
        'short': 'Polyclon hypergammaglobu'},
       {'code': '273.1',
        'long': 'Monoclonal paraproteinemia',
        'short': 'Monoclon paraproteinemia'},
       {'code': '273.2',
        'long': 'Other paraproteinemias',
        'short': 'Paraproteinemia NEC'},
       {'code': '273.3',
        'long': 'Macroglobulinemia',
        'short': 'Macroglobulinemia'},
       {'code': '273.4',
        'long': 'Alpha-1-antitrypsin deficiency',
        'short': 'Alpha-1-antitrypsin def'},
       {'code': '273.8',
        'long': 'Other disorders of plasma protein metabolism',
        'short': 'Dis plas protein met NEC'},
       {'code': '273.9',
        'long': 'Unspecified disorder of plasma protein metabolism',
        'short': 'Dis plas protein met NOS'},
       {'code': '274.00',
        'long': 'Gouty arthropathy, unspecified',
        'short': 'Gouty arthropathy NOS'},
       {'code': '274.01',
        'long': 'Acute gouty arthropathy',
        'short': 'Acute gouty arthropathy'},
       {'code': '274.02',
        'long': 'Chronic gouty arthropathy without mention of tophus (tophi)',
        'short': 'Chr gouty atrph wo tophi'},
       {'code': '274.03',
        'long': 'Chronic gouty arthropathy with tophus (tophi)',
        'short': 'Chr gouty atroph w tophi'},
       {'code': '274.10',
        'long': 'Gouty nephropathy, unspecified',
        'short': 'Gouty nephropathy NOS'},
       {'code': '274.11',
        'long': 'Uric acid nephrolithiasis',
        'short': 'Uric acid nephrolithias'},
       {'code': '274.19',
        'long': 'Other gouty nephropathy',
        'short': 'Gouty nephropathy NEC'},
       {'code': '274.81',
        'long': 'Gouty tophi of ear',
        'short': 'Gouty tophi of ear'},
       {'code': '274.82',
        'long': 'Gouty tophi of other sites, except ear',
        'short': 'Gouty tophi site NEC'},
       {'code': '274.89',
        'long': 'Gout with other specified manifestations',
        'short': 'Gout w manifestation NEC'},
       {'code': '274.9', 'long': 'Gout, unspecified', 'short': 'Gout NOS'},
       {'code': '275.01',
        'long': 'Hereditary hemochromatosis',
        'short': 'Heredit hemochromatosis'},
       {'code': '275.02',
        'long': 'Hemochromatosis due to repeated red blood cell transfusions',
        'short': 'Hemochromatos-rbc trans'},
       {'code': '275.03',
        'long': 'Other hemochromatosis',
        'short': 'Hemochromatosis NEC'},
       {'code': '275.09',
        'long': 'Other disorders of iron metabolism',
        'short': 'Disord iron metablsm NEC'},
       {'code': '275.1',
        'long': 'Disorders of copper metabolism',
        'short': 'Dis copper metabolism'},
       {'code': '275.2',
        'long': 'Disorders of magnesium metabolism',
        'short': 'Dis magnesium metabolism'},
       {'code': '275.3',
        'long': 'Disorders of phosphorus metabolism',
        'short': 'Dis phosphorus metabol'},
       {'code': '275.40',
        'long': 'Unspecified disorder of calcium metabolism',
        'short': 'Dis calcium metablsm NOS'},
       {'code': '275.41', 'long': 'Hypocalcemia', 'short': 'Hypocalcemia'},
       {'code': '275.42', 'long': 'Hypercalcemia', 'short': 'Hypercalcemia'},
       {'code': '275.49',
        'long': 'Other disorders of calcium metabolism',
        'short': 'Dis calcium metablsm NEC'},
       {'code': '275.5',
        'long': 'Hungry bone syndrome',
        'short': 'Hungry bone syndrome'},
       {'code': '275.8',
        'long': 'Other specified disorders of mineral metabolism',
        'short': 'Dis mineral metabol NEC'},
       {'code': '275.9',
        'long': 'Unspecified disorder of mineral metabolism',
        'short': 'Dis mineral metabol NOS'},
       {'code': '276.0',
        'long': 'Hyperosmolality and/or hypernatremia',
        'short': 'Hyperosmolality'},
       {'code': '276.1',
        'long': 'Hyposmolality and/or hyponatremia',
        'short': 'Hyposmolality'},
       {'code': '276.2', 'long': 'Acidosis', 'short': 'Acidosis'},
       {'code': '276.3', 'long': 'Alkalosis', 'short': 'Alkalosis'},
       {'code': '276.4',
        'long': 'Mixed acid-base balance disorder',
        'short': 'Mixed acid-base bal dis'},
       {'code': '276.50',
        'long': 'Volume depletion, unspecified',
        'short': 'Volume depletion NOS'},
       {'code': '276.51', 'long': 'Dehydration', 'short': 'Dehydration'},
       {'code': '276.52', 'long': 'Hypovolemia', 'short': 'Hypovolemia'},
       {'code': '276.61',
        'long': 'Transfusion associated circulatory overload',
        'short': 'Transfsn w circ overload'},
       {'code': '276.69',
        'long': 'Other fluid overload',
        'short': 'Fluid overload NEC'},
       {'code': '276.7',
        'long': 'Hyperpotassemia',
        'short': 'Hyperpotassemia'},
       {'code': '276.8', 'long': 'Hypopotassemia', 'short': 'Hypopotassemia'},
       {'code': '276.9',
        'long': 'Electrolyte and fluid disorders not elsewhere classified',
        'short': 'Electrolyt/fluid dis NEC'},
       {'code': '277.00',
        'long': 'Cystic fibrosis without mention of meconium ileus',
        'short': 'Cystic fibros w/o ileus'},
       {'code': '277.01',
        'long': 'Cystic fibrosis with meconium ileus',
        'short': 'Cystic fibrosis w ileus'},
       {'code': '277.02',
        'long': 'Cystic fibrosis with pulmonary manifestations',
        'short': 'Cystic fibros w pul man'},
       {'code': '277.03',
        'long': 'Cystic fibrosis with gastrointestinal manifestations',
        'short': 'Cystic fibrosis w GI man'},
       {'code': '277.09',
        'long': 'Cystic fibrosis with other manifestations',
        'short': 'Cystic fibrosis NEC'},
       {'code': '277.1',
        'long': 'Disorders of porphyrin metabolism',
        'short': 'Dis porphyrin metabolism'},
       {'code': '277.2',
        'long': 'Other disorders of purine and pyrimidine metabolism',
        'short': 'Purine/pyrimid dis NEC'},
       {'code': '277.30',
        'long': 'Amyloidosis, unspecified',
        'short': 'Amyloidosis NOS'},
       {'code': '277.31',
        'long': 'Familial Mediterranean fever',
        'short': 'Fam Mediterranean fever'},
       {'code': '277.39',
        'long': 'Other amyloidosis',
        'short': 'Amyloidosis NEC'},
       {'code': '277.4',
        'long': 'Disorders of bilirubin excretion',
        'short': 'Dis bilirubin excretion'},
       {'code': '277.5',
        'long': 'Mucopolysaccharidosis',
        'short': 'Mucopolysaccharidosis'},
       {'code': '277.6',
        'long': 'Other deficiencies of circulating enzymes',
        'short': 'Defic circul enzyme NEC'},
       {'code': '277.7',
        'long': 'Dysmetabolic syndrome X',
        'short': 'Dysmetabolic syndrome x'},
       {'code': '277.81',
        'long': 'Primary carnitine deficiency',
        'short': 'Primary carnitine defncy'},
       {'code': '277.82',
        'long': 'Carnitine deficiency due to inborn errors of metabolism',
        'short': 'Crnitne def d/t nb met'},
       {'code': '277.83',
        'long': 'Iatrogenic carnitine deficiency',
        'short': 'Iatrogenic carnitine def'},
       {'code': '277.84',
        'long': 'Other secondary carnitine deficiency',
        'short': 'Sec carnitine defncy NEC'},
       {'code': '277.85',
        'long': 'Disorders of fatty acid oxidation',
        'short': 'Disorders acid oxidation'},
       {'code': '277.86',
        'long': 'Peroxisomal disorders',
        'short': 'Peroxisomal disorders'},
       {'code': '277.87',
        'long': 'Disorders of mitochondrial metabolism',
        'short': 'Dis mitochondrial metab'},
       {'code': '277.88',
        'long': 'Tumor lysis syndrome',
        'short': 'Tumor lysis syndrome'},
       {'code': '277.89',
        'long': 'Other specified disorders of metabolism',
        'short': 'Metabolism disorder NEC'},
       {'code': '277.9',
        'long': 'Unspecified disorder of metabolism',
        'short': 'Metabolism disorder NOS'},
       {'code': '278.00',
        'long': 'Obesity, unspecified',
        'short': 'Obesity NOS'},
       {'code': '278.01',
        'long': 'Morbid obesity',
        'short': 'Morbid obesity'},
       {'code': '278.02', 'long': 'Overweight', 'short': 'Overweight'},
       {'code': '278.03',
        'long': 'Obesity hypoventilation syndrome',
        'short': 'Obesity hypovent synd'},
       {'code': '278.1',
        'long': 'Localized adiposity',
        'short': 'Localized adiposity'},
       {'code': '278.2',
        'long': 'Hypervitaminosis A',
        'short': 'Hypervitaminosis a'},
       {'code': '278.3',
        'long': 'Hypercarotinemia',
        'short': 'Hypercarotinemia'},
       {'code': '278.4',
        'long': 'Hypervitaminosis D',
        'short': 'Hypervitaminosis d'},
       {'code': '278.8',
        'long': 'Other hyperalimentation',
        'short': 'Other hyperalimentation'}],
 'F': [{'code': '290.0',
        'long': 'Senile dementia, uncomplicated',
        'short': 'Senile dementia uncomp'},
       {'code': '290.10',
        'long': 'Presenile dementia, uncomplicated',
        'short': 'Presenile dementia'},
       {'code': '290.11',
        'long': 'Presenile dementia with delirium',
        'short': 'Presenile delirium'},
       {'code': '290.12',
        'long': 'Presenile dementia with delusional features',
        'short': 'Presenile delusion'},
       {'code': '290.13',
        'long': 'Presenile dementia with depressive features',
        'short': 'Presenile depression'},
       {'code': '290.20',
        'long': 'Senile dementia with delusional features',
        'short': 'Senile delusion'},
       {'code': '290.21',
        'long': 'Senile dementia with depressive features',
        'short': 'Senile depressive'},
       {'code': '290.3',
        'long': 'Senile dementia with delirium',
        'short': 'Senile delirium'},
       {'code': '290.40',
        'long': 'Vascular dementia, uncomplicated',
        'short': 'Vascular dementia,uncomp'},
       {'code': '290.41',
        'long': 'Vascular dementia, with delirium',
        'short': 'Vasc dementia w delirium'},
       {'code': '290.42',
        'long': 'Vascular dementia, with delusions',
        'short': 'Vasc dementia w delusion'},
       {'code': '290.43',
        'long': 'Vascular dementia, with depressed mood',
        'short': 'Vasc dementia w depressn'},
       {'code': '290.8',
        'long': 'Other specified senile psychotic conditions',
        'short': 'Senile psychosis NEC'},
       {'code': '290.9',
        'long': 'Unspecified senile psychotic condition',
        'short': 'Senile psychot cond NOS'},
       {'code': '291.0',
        'long': 'Alcohol withdrawal delirium',
        'short': 'Delirium tremens'},
       {'code': '291.1',
        'long': 'Alcohol-induced persisting amnestic disorder',
        'short': 'Alcohol amnestic disordr'},
       {'code': '291.2',
        'long': 'Alcohol-induced persisting dementia',
        'short': 'Alcohol persist dementia'},
       {'code': '291.3',
        'long': 'Alcohol-induced psychotic disorder with hallucinations',
        'short': 'Alcoh psy dis w hallucin'},
       {'code': '291.4',
        'long': 'Idiosyncratic alcohol intoxication',
        'short': 'Pathologic alcohol intox'},
       {'code': '291.5',
        'long': 'Alcohol-induced psychotic disorder with delusions',
        'short': 'Alcoh psych dis w delus'},
       {'code': '291.81',
        'long': 'Alcohol withdrawal',
        'short': 'Alcohol withdrawal'},
       {'code': '291.82',
        'long': 'Alcohol induced sleep disorders',
        'short': 'Alcoh induce sleep disor'},
       {'code': '291.89',
        'long': 'Other alcohol-induced mental disorders',
        'short': 'Alcohol mental disor NEC'},
       {'code': '291.9',
        'long': 'Unspecified alcohol-induced mental disorders',
        'short': 'Alcohol mental disor NOS'},
       {'code': '292.0',
        'long': 'Drug withdrawal',
        'short': 'Drug withdrawal'},
       {'code': '292.11',
        'long': 'Drug-induced psychotic disorder with delusions',
        'short': 'Drug psych disor w delus'},
       {'code': '292.12',
        'long': 'Drug-induced psychotic disorder with hallucinations',
        'short': 'Drug psy dis w hallucin'},
       {'code': '292.2',
        'long': 'Pathological drug intoxication',
        'short': 'Pathologic drug intox'},
       {'code': '292.81',
        'long': 'Drug-induced delirium',
        'short': 'Drug-induced delirium'},
       {'code': '292.82',
        'long': 'Drug-induced persisting dementia',
        'short': 'Drug persisting dementia'},
       {'code': '292.83',
        'long': 'Drug-induced persisting amnestic disorder',
        'short': 'Drug persist amnestc dis'},
       {'code': '292.84',
        'long': 'Drug-induced mood disorder',
        'short': 'Drug-induced mood disord'},
       {'code': '292.85',
        'long': 'Drug induced sleep disorders',
        'short': 'Drug induced sleep disor'},
       {'code': '292.89',
        'long': 'Other specified drug-induced mental disorders',
        'short': 'Drug mental disorder NEC'},
       {'code': '292.9',
        'long': 'Unspecified drug-induced mental disorder',
        'short': 'Drug mental disorder NOS'},
       {'code': '293.0',
        'long': 'Delirium due to conditions classified elsewhere',
        'short': 'Delirium d/t other cond'},
       {'code': '293.1',
        'long': 'Subacute delirium',
        'short': 'Subacute delirium'},
       {'code': '293.81',
        'long': 'Psychotic disorder with delusions in conditions classified elsewhere',
        'short': 'Psy dis w delus oth dis'},
       {'code': '293.82',
        'long': 'Psychotic disorder with hallucinations in conditions classified elsewhere',
        'short': 'Psy dis w halluc oth dis'},
       {'code': '293.83',
        'long': 'Mood disorder in conditions classified elsewhere',
        'short': 'Mood disorder other dis'},
       {'code': '293.84',
        'long': 'Anxiety disorder in conditions classified elsewhere',
        'short': 'Anxiety disorder oth dis'},
       {'code': '293.89',
        'long': 'Other specified transient mental disorders due to conditions classified elsewhere, other',
        'short': 'Transient mental dis NEC'},
       {'code': '293.9',
        'long': 'Unspecified transient mental disorder in conditions classified elsewhere',
        'short': 'Transient mental dis NOS'},
       {'code': '294.0',
        'long': 'Amnestic disorder in conditions classified elsewhere',
        'short': 'Amnestic disord oth dis'},
       {'code': '294.10',
        'long': 'Dementia in conditions classified elsewhere without behavioral disturbance',
        'short': 'Dementia w/o behav dist'},
       {'code': '294.11',
        'long': 'Dementia in conditions classified elsewhere with behavioral disturbance',
        'short': 'Dementia w behavior dist'},
       {'code': '294.20',
        'long': 'Dementia, unspecified, without behavioral disturbance',
        'short': 'Demen NOS w/o behv dstrb'},
       {'code': '294.21',
        'long': 'Dementia, unspecified, with behavioral disturbance',
        'short': 'Demen NOS w behav distrb'},
       {'code': '294.8',
        'long': 'Other persistent mental disorders due to conditions classified elsewhere',
        'short': 'Mental disor NEC oth dis'},
       {'code': '294.9',
        'long': 'Unspecified persistent mental disorders due to conditions classified elsewhere',
        'short': 'Mental disor NOS oth dis'},
       {'code': '295.00',
        'long': 'Simple type schizophrenia, unspecified',
        'short': 'Simpl schizophren-unspec'},
       {'code': '295.01',
        'long': 'Simple type schizophrenia, subchronic',
        'short': 'Simpl schizophren-subchr'},
       {'code': '295.02',
        'long': 'Simple type schizophrenia, chronic',
        'short': 'Simple schizophren-chr'},
       {'code': '295.03',
        'long': 'Simple type schizophrenia, subchronic with acute exacerbation',
        'short': 'Simp schiz-subchr/exacer'},
       {'code': '295.04',
        'long': 'Simple type schizophrenia, chronic with acute exacerbation',
        'short': 'Simpl schizo-chr/exacerb'},
       {'code': '295.05',
        'long': 'Simple type schizophrenia, in remission',
        'short': 'Simpl schizophren-remiss'},
       {'code': '295.10',
        'long': 'Disorganized type schizophrenia, unspecified',
        'short': 'Hebephrenia-unspec'},
       {'code': '295.11',
        'long': 'Disorganized type schizophrenia, subchronic',
        'short': 'Hebephrenia-subchronic'},
       {'code': '295.12',
        'long': 'Disorganized type schizophrenia, chronic',
        'short': 'Hebephrenia-chronic'},
       {'code': '295.13',
        'long': 'Disorganized type schizophrenia, subchronic with acute exacerbation',
        'short': 'Hebephren-subchr/exacerb'},
       {'code': '295.14',
        'long': 'Disorganized type schizophrenia, chronic with acute exacerbation',
        'short': 'Hebephrenia-chr/exacerb'},
       {'code': '295.15',
        'long': 'Disorganized type schizophrenia, in remission',
        'short': 'Hebephrenia-remission'},
       {'code': '295.20',
        'long': 'Catatonic type schizophrenia, unspecified',
        'short': 'Catatonia-unspec'},
       {'code': '295.21',
        'long': 'Catatonic type schizophrenia, subchronic',
        'short': 'Catatonia-subchronic'},
       {'code': '295.22',
        'long': 'Catatonic type schizophrenia, chronic',
        'short': 'Catatonia-chronic'},
       {'code': '295.23',
        'long': 'Catatonic type schizophrenia, subchronic with acute exacerbation',
        'short': 'Catatonia-subchr/exacerb'},
       {'code': '295.24',
        'long': 'Catatonic type schizophrenia, chronic with acute exacerbation',
        'short': 'Catatonia-chr/exacerb'},
       {'code': '295.25',
        'long': 'Catatonic type schizophrenia, in remission',
        'short': 'Catatonia-remission'},
       {'code': '295.30',
        'long': 'Paranoid type schizophrenia, unspecified',
        'short': 'Paranoid schizo-unspec'},
       {'code': '295.31',
        'long': 'Paranoid type schizophrenia, subchronic',
        'short': 'Paranoid schizo-subchr'},
       {'code': '295.32',
        'long': 'Paranoid type schizophrenia, chronic',
        'short': 'Paranoid schizo-chronic'},
       {'code': '295.33',
        'long': 'Paranoid type schizophrenia, subchronic with acute exacerbation',
        'short': 'Paran schizo-subchr/exac'},
       {'code': '295.34',
        'long': 'Paranoid type schizophrenia, chronic with acute exacerbation',
        'short': 'Paran schizo-chr/exacerb'},
       {'code': '295.35',
        'long': 'Paranoid type schizophrenia, in remission',
        'short': 'Paranoid schizo-remiss'},
       {'code': '295.40',
        'long': 'Schizophreniform disorder, unspecified',
        'short': 'Schizophreniform dis NOS'},
       {'code': '295.41',
        'long': 'Schizophreniform disorder, subchronic',
        'short': 'Schizophrenic dis-subchr'},
       {'code': '295.42',
        'long': 'Schizophreniform disorder, chronic',
        'short': 'Schizophren dis-chronic'},
       {'code': '295.43',
        'long': 'Schizophreniform disorder, subchronic with acute exacerbation',
        'short': 'Schizo dis-subchr/exacer'},
       {'code': '295.44',
        'long': 'Schizophreniform disorder, chronic with acute exacerbation',
        'short': 'Schizophr dis-chr/exacer'},
       {'code': '295.45',
        'long': 'Schizophreniform disorder, in remission',
        'short': 'Schizophrenic dis-remiss'},
       {'code': '295.50',
        'long': 'Latent schizophrenia, unspecified',
        'short': 'Latent schizophren-unsp'},
       {'code': '295.51',
        'long': 'Latent schizophrenia, subchronic',
        'short': 'Lat schizophren-subchr'},
       {'code': '295.52',
        'long': 'Latent schizophrenia, chronic',
        'short': 'Latent schizophren-chr'},
       {'code': '295.53',
        'long': 'Latent schizophrenia, subchronic with acute exacerbation',
        'short': 'Lat schizo-subchr/exacer'},
       {'code': '295.54',
        'long': 'Latent schizophrenia, chronic with acute exacerbation',
        'short': 'Latent schizo-chr/exacer'},
       {'code': '295.55',
        'long': 'Latent schizophrenia, in remission',
        'short': 'Lat schizophren-remiss'},
       {'code': '295.60',
        'long': 'Schizophrenic disorders, residual type, unspecified',
        'short': 'Schizophr dis resid NOS'},
       {'code': '295.61',
        'long': 'Schizophrenic disorders, residual type, subchronic',
        'short': 'Schizoph dis resid-subch'},
       {'code': '295.62',
        'long': 'Schizophrenic disorders, residual type, chronic',
        'short': 'Schizophr dis resid-chr'},
       {'code': '295.63',
        'long': 'Schizophrenic disorders, residual type, subchronic with acute exacerbation',
        'short': 'Schizo resid subchr/exac'},
       {'code': '295.64',
        'long': 'Schizophrenic disorders, residual type, chronic with acute exacerbation',
        'short': 'Schizoph resid-chro/exac'},
       {'code': '295.65',
        'long': 'Schizophrenic disorders, residual type, in remission',
        'short': 'Schizoph dis resid-remis'},
       {'code': '295.70',
        'long': 'Schizoaffective disorder, unspecified',
        'short': 'Schizoaffective dis NOS'},
       {'code': '295.71',
        'long': 'Schizoaffective disorder, subchronic',
        'short': 'Schizoaffectv dis-subchr'},
       {'code': '295.72',
        'long': 'Schizoaffective disorder, chronic',
        'short': 'Schizoaffective dis-chr'},
       {'code': '295.73',
        'long': 'Schizoaffective disorder, subchronic with acute exacerbation',
        'short': 'Schizoaff dis-subch/exac'},
       {'code': '295.74',
        'long': 'Schizoaffective disorder, chronic with acute exacerbation',
        'short': 'Schizoafftv dis-chr/exac'},
       {'code': '295.75',
        'long': 'Schizoaffective disorder, in remission',
        'short': 'Schizoaffectve dis-remis'},
       {'code': '295.80',
        'long': 'Other specified types of schizophrenia, unspecified',
        'short': 'Schizophrenia NEC-unspec'},
       {'code': '295.81',
        'long': 'Other specified types of schizophrenia, subchronic',
        'short': 'Schizophrenia NEC-subchr'},
       {'code': '295.82',
        'long': 'Other specified types of schizophrenia, chronic',
        'short': 'Schizophrenia NEC-chr'},
       {'code': '295.83',
        'long': 'Other specified types of schizophrenia, subchronic with acute exacerbation',
        'short': 'Schizo NEC-subchr/exacer'},
       {'code': '295.84',
        'long': 'Other specified types of schizophrenia, chronic with acute exacerbation',
        'short': 'Schizo NEC-chr/exacerb'},
       {'code': '295.85',
        'long': 'Other specified types of schizophrenia, in remission',
        'short': 'Schizophrenia NEC-remiss'},
       {'code': '295.90',
        'long': 'Unspecified schizophrenia, unspecified',
        'short': 'Schizophrenia NOS-unspec'},
       {'code': '295.91',
        'long': 'Unspecified schizophrenia, subchronic',
        'short': 'Schizophrenia NOS-subchr'},
       {'code': '295.92',
        'long': 'Unspecified schizophrenia, chronic',
        'short': 'Schizophrenia NOS-chr'},
       {'code': '295.93',
        'long': 'Unspecified schizophrenia, subchronic with acute exacerbation',
        'short': 'Schizo NOS-subchr/exacer'},
       {'code': '295.94',
        'long': 'Unspecified schizophrenia, chronic with acute exacerbation',
        'short': 'Schizo NOS-chr/exacerb'},
       {'code': '295.95',
        'long': 'Unspecified schizophrenia, in remission',
        'short': 'Schizophrenia NOS-remiss'},
       {'code': '296.00',
        'long': 'Bipolar I disorder, single manic episode, unspecified',
        'short': 'Bipol I single manic NOS'},
       {'code': '296.01',
        'long': 'Bipolar I disorder, single manic episode, mild',
        'short': 'Bipol I single manc-mild'},
       {'code': '296.02',
        'long': 'Bipolar I disorder, single manic episode, moderate',
        'short': 'Bipol I single manic-mod'},
       {'code': '296.03',
        'long': 'Bipolar I disorder, single manic episode, severe, without mention of psychotic behavior',
        'short': 'Bipol I sing-sev w/o psy'},
       {'code': '296.04',
        'long': 'Bipolar I disorder, single manic episode, severe, specified as with psychotic behavior',
        'short': 'Bipo I sin man-sev w psy'},
       {'code': '296.05',
        'long': 'Bipolar I disorder, single manic episode, in partial or unspecified remission',
        'short': 'Bipol I sing man rem NOS'},
       {'code': '296.06',
        'long': 'Bipolar I disorder, single manic episode, in full remission',
        'short': 'Bipol I single manic rem'},
       {'code': '296.10',
        'long': 'Manic affective disorder, recurrent episode, unspecified',
        'short': 'Recur manic dis-unspec'},
       {'code': '296.11',
        'long': 'Manic affective disorder, recurrent episode, mild',
        'short': 'Recur manic dis-mild'},
       {'code': '296.12',
        'long': 'Manic affective disorder, recurrent episode, moderate',
        'short': 'Recur manic dis-mod'},
       {'code': '296.13',
        'long': 'Manic affective disorder, recurrent episode, severe, without mention of psychotic behavior',
        'short': 'Recur manic dis-severe'},
       {'code': '296.14',
        'long': 'Manic affective disorder, recurrent episode, severe, specified as with psychotic behavior',
        'short': 'Recur manic-sev w psycho'},
       {'code': '296.15',
        'long': 'Manic affective disorder, recurrent episode, in partial or unspecified remission',
        'short': 'Recur manic-part remiss'},
       {'code': '296.16',
        'long': 'Manic affective disorder, recurrent episode, in full remission',
        'short': 'Recur manic-full remiss'},
       {'code': '296.20',
        'long': 'Major depressive affective disorder, single episode, unspecified',
        'short': 'Depress psychosis-unspec'},
       {'code': '296.21',
        'long': 'Major depressive affective disorder, single episode, mild',
        'short': 'Depress psychosis-mild'},
       {'code': '296.22',
        'long': 'Major depressive affective disorder, single episode, moderate',
        'short': 'Depressive psychosis-mod'},
       {'code': '296.23',
        'long': 'Major depressive affective disorder, single episode, severe, without mention of psychotic behavior',
        'short': 'Depress psychosis-severe'},
       {'code': '296.24',
        'long': 'Major depressive affective disorder, single episode, severe, specified as with psychotic behavior',
        'short': 'Depr psychos-sev w psych'},
       {'code': '296.25',
        'long': 'Major depressive affective disorder, single episode, in partial or unspecified remission',
        'short': 'Depr psychos-part remiss'},
       {'code': '296.26',
        'long': 'Major depressive affective disorder, single episode, in full remission',
        'short': 'Depr psychos-full remiss'},
       {'code': '296.30',
        'long': 'Major depressive affective disorder, recurrent episode, unspecified',
        'short': 'Recurr depr psychos-unsp'},
       {'code': '296.31',
        'long': 'Major depressive affective disorder, recurrent episode, mild',
        'short': 'Recurr depr psychos-mild'},
       {'code': '296.32',
        'long': 'Major depressive affective disorder, recurrent episode, moderate',
        'short': 'Recurr depr psychos-mod'},
       {'code': '296.33',
        'long': 'Major depressive affective disorder, recurrent episode, severe, without mention of psychotic behavior',
        'short': 'Recur depr psych-severe'},
       {'code': '296.34',
        'long': 'Major depressive affective disorder, recurrent episode, severe, specified as with psychotic behavior',
        'short': 'Rec depr psych-psychotic'},
       {'code': '296.35',
        'long': 'Major depressive affective disorder, recurrent episode, in partial or unspecified remission',
        'short': 'Recur depr psyc-part rem'},
       {'code': '296.36',
        'long': 'Major depressive affective disorder, recurrent episode, in full remission',
        'short': 'Recur depr psyc-full rem'},
       {'code': '296.40',
        'long': 'Bipolar I disorder, most recent episode (or current) manic, unspecified',
        'short': 'Bipol I currnt manic NOS'},
       {'code': '296.41',
        'long': 'Bipolar I disorder, most recent episode (or current) manic, mild',
        'short': 'Bipol I curnt manic-mild'},
       {'code': '296.42',
        'long': 'Bipolar I disorder, most recent episode (or current) manic, moderate',
        'short': 'Bipol I currnt manic-mod'},
       {'code': '296.43',
        'long': 'Bipolar I disorder, most recent episode (or current) manic, severe, without mention of psychotic behavior',
        'short': 'Bipol I manc-sev w/o psy'},
       {'code': '296.44',
        'long': 'Bipolar I disorder, most recent episode (or current) manic, severe, specified as with psychotic behavior',
        'short': 'Bipol I manic-sev w psy'},
       {'code': '296.45',
        'long': 'Bipolar I disorder, most recent episode (or current) manic, in partial or unspecified remission',
        'short': 'Bipol I cur man part rem'},
       {'code': '296.46',
        'long': 'Bipolar I disorder, most recent episode (or current) manic, in full remission',
        'short': 'Bipol I cur man full rem'},
       {'code': '296.50',
        'long': 'Bipolar I disorder, most recent episode (or current) depressed, unspecified',
        'short': 'Bipol I cur depres NOS'},
       {'code': '296.51',
        'long': 'Bipolar I disorder, most recent episode (or current) depressed, mild',
        'short': 'Bipol I cur depress-mild'},
       {'code': '296.52',
        'long': 'Bipolar I disorder, most recent episode (or current) depressed, moderate',
        'short': 'Bipol I cur depress-mod'},
       {'code': '296.53',
        'long': 'Bipolar I disorder, most recent episode (or current) depressed, severe, without mention of psychotic behavior',
        'short': 'Bipol I curr dep w/o psy'},
       {'code': '296.54',
        'long': 'Bipolar I disorder, most recent episode (or current) depressed, severe, specified as with psychotic behavior',
        'short': 'Bipol I currnt dep w psy'},
       {'code': '296.55',
        'long': 'Bipolar I disorder, most recent episode (or current) depressed, in partial or unspecified remission',
        'short': 'Bipol I cur dep rem NOS'},
       {'code': '296.56',
        'long': 'Bipolar I disorder, most recent episode (or current) depressed, in full remission',
        'short': 'Bipol I currnt dep remis'},
       {'code': '296.60',
        'long': 'Bipolar I disorder, most recent episode (or current) mixed, unspecified',
        'short': 'Bipol I currnt mixed NOS'},
       {'code': '296.61',
        'long': 'Bipolar I disorder, most recent episode (or current) mixed, mild',
        'short': 'Bipol I currnt mix-mild'},
       {'code': '296.62',
        'long': 'Bipolar I disorder, most recent episode (or current) mixed, moderate',
        'short': 'Bipol I currnt mixed-mod'},
       {'code': '296.63',
        'long': 'Bipolar I disorder, most recent episode (or current) mixed, severe, without mention of psychotic behavior',
        'short': 'Bipol I cur mix w/o psy'},
       {'code': '296.64',
        'long': 'Bipolar I disorder, most recent episode (or current) mixed, severe, specified as with psychotic behavior',
        'short': 'Bipol I cur mixed w psy'},
       {'code': '296.65',
        'long': 'Bipolar I disorder, most recent episode (or current) mixed, in partial or unspecified remission',
        'short': 'Bipol I cur mix-part rem'},
       {'code': '296.66',
        'long': 'Bipolar I disorder, most recent episode (or current) mixed, in full remission',
        'short': 'Bipol I cur mixed remiss'},
       {'code': '296.7',
        'long': 'Bipolar I disorder, most recent episode (or current) unspecified',
        'short': 'Bipolor I current NOS'},
       {'code': '296.80',
        'long': 'Bipolar disorder, unspecified',
        'short': 'Bipolar disorder NOS'},
       {'code': '296.81',
        'long': 'Atypical manic disorder',
        'short': 'Atypical manic disorder'},
       {'code': '296.82',
        'long': 'Atypical depressive disorder',
        'short': 'Atypical depressive dis'},
       {'code': '296.89',
        'long': 'Other bipolar disorders',
        'short': 'Bipolar disorder NEC'},
       {'code': '296.90',
        'long': 'Unspecified episodic mood disorder',
        'short': 'Episodic mood disord NOS'},
       {'code': '296.99',
        'long': 'Other specified episodic mood disorder',
        'short': 'Episodic mood disord NEC'},
       {'code': '297.0',
        'long': 'Paranoid state, simple',
        'short': 'Paranoid state, simple'},
       {'code': '297.1',
        'long': 'Delusional disorder',
        'short': 'Delusional disorder'},
       {'code': '297.2', 'long': 'Paraphrenia', 'short': 'Paraphrenia'},
       {'code': '297.3',
        'long': 'Shared psychotic disorder',
        'short': 'Shared psychotic disord'},
       {'code': '297.8',
        'long': 'Other specified paranoid states',
        'short': 'Paranoid states NEC'},
       {'code': '297.9',
        'long': 'Unspecified paranoid state',
        'short': 'Paranoid state NOS'},
       {'code': '298.0',
        'long': 'Depressive type psychosis',
        'short': 'React depress psychosis'},
       {'code': '298.1',
        'long': 'Excitative type psychosis',
        'short': 'Excitativ type psychosis'},
       {'code': '298.2',
        'long': 'Reactive confusion',
        'short': 'Reactive confusion'},
       {'code': '298.3',
        'long': 'Acute paranoid reaction',
        'short': 'Acute paranoid reaction'},
       {'code': '298.4',
        'long': 'Psychogenic paranoid psychosis',
        'short': 'Psychogen paranoid psych'},
       {'code': '298.8',
        'long': 'Other and unspecified reactive psychosis',
        'short': 'React psychosis NEC/NOS'},
       {'code': '298.9',
        'long': 'Unspecified psychosis',
        'short': 'Psychosis NOS'},
       {'code': '299.00',
        'long': 'Autistic disorder, current or active state',
        'short': 'Autistic disord-current'},
       {'code': '299.01',
        'long': 'Autistic disorder, residual state',
        'short': 'Autistic disord-residual'},
       {'code': '299.10',
        'long': 'Childhood disintegrative disorder, current or active state',
        'short': 'Childhd disintegr-active'},
       {'code': '299.11',
        'long': 'Childhood disintegrative disorder, residual state',
        'short': 'Childhd disintegr-resid'},
       {'code': '299.80',
        'long': 'Other specified pervasive developmental disorders, current or active state',
        'short': 'Pervasv dev dis-cur NEC'},
       {'code': '299.81',
        'long': 'Other specified pervasive developmental disorders, residual state',
        'short': 'Pervasv dev dis-res NEC'},
       {'code': '299.90',
        'long': 'Unspecified pervasive developmental disorder, current or active state',
        'short': 'Pervasv dev dis-cur NOS'},
       {'code': '299.91',
        'long': 'Unspecified pervasive developmental disorder, residual state',
        'short': 'Pervasv dev dis-res NOS'},
       {'code': '300.00',
        'long': 'Anxiety state, unspecified',
        'short': 'Anxiety state NOS'},
       {'code': '300.01',
        'long': 'Panic disorder without agoraphobia',
        'short': 'Panic dis w/o agorphobia'},
       {'code': '300.02',
        'long': 'Generalized anxiety disorder',
        'short': 'Generalized anxiety dis'},
       {'code': '300.09',
        'long': 'Other anxiety states',
        'short': 'Anxiety state NEC'},
       {'code': '300.10',
        'long': 'Hysteria, unspecified',
        'short': 'Hysteria NOS'},
       {'code': '300.11',
        'long': 'Conversion disorder',
        'short': 'Conversion disorder'},
       {'code': '300.12',
        'long': 'Dissociative amnesia',
        'short': 'Dissociative amnesia'},
       {'code': '300.13',
        'long': 'Dissociative fugue',
        'short': 'Dissociative fugue'},
       {'code': '300.14',
        'long': 'Dissociative identity disorder',
        'short': 'Dissociatve identity dis'},
       {'code': '300.15',
        'long': 'Dissociative disorder or reaction, unspecified',
        'short': 'Dissociative react NOS'},
       {'code': '300.16',
        'long': 'Factitious disorder with predominantly psychological signs and symptoms',
        'short': 'Factitious dis w symptom'},
       {'code': '300.19',
        'long': 'Other and unspecified factitious illness',
        'short': 'Factitious ill NEC/NOS'},
       {'code': '300.20',
        'long': 'Phobia, unspecified',
        'short': 'Phobia NOS'},
       {'code': '300.21',
        'long': 'Agoraphobia with panic disorder',
        'short': 'Agoraphobia w panic dis'},
       {'code': '300.22',
        'long': 'Agoraphobia without mention of panic attacks',
        'short': 'Agoraphobia w/o panic'},
       {'code': '300.23', 'long': 'Social phobia', 'short': 'Social phobia'},
       {'code': '300.29',
        'long': 'Other isolated or specific phobias',
        'short': 'Isolated/spec phobia NEC'},
       {'code': '300.3',
        'long': 'Obsessive-compulsive disorders',
        'short': 'Obsessive-compulsive dis'},
       {'code': '300.4',
        'long': 'Dysthymic disorder',
        'short': 'Dysthymic disorder'},
       {'code': '300.5', 'long': 'Neurasthenia', 'short': 'Neurasthenia'},
       {'code': '300.6',
        'long': 'Depersonalization disorder',
        'short': 'Depersonalization disord'},
       {'code': '300.7',
        'long': 'Hypochondriasis',
        'short': 'Hypochondriasis'},
       {'code': '300.81',
        'long': 'Somatization disorder',
        'short': 'Somatization disorder'},
       {'code': '300.82',
        'long': 'Undifferentiated somatoform disorder',
        'short': 'Undiff somatoform disrdr'},
       {'code': '300.89',
        'long': 'Other somatoform disorders',
        'short': 'Somatoform disorders NEC'},
       {'code': '300.9',
        'long': 'Unspecified nonpsychotic mental disorder',
        'short': 'Nonpsychotic disord NOS'},
       {'code': '301.0',
        'long': 'Paranoid personality disorder',
        'short': 'Paranoid personality'},
       {'code': '301.10',
        'long': 'Affective personality disorder, unspecified',
        'short': 'Affectiv personality NOS'},
       {'code': '301.11',
        'long': 'Chronic hypomanic personality disorder',
        'short': 'Chronic hypomanic person'},
       {'code': '301.12',
        'long': 'Chronic depressive personality disorder',
        'short': 'Chr depressive person'},
       {'code': '301.13',
        'long': 'Cyclothymic disorder',
        'short': 'Cyclothymic disorder'},
       {'code': '301.20',
        'long': 'Schizoid personality disorder, unspecified',
        'short': 'Schizoid personality NOS'},
       {'code': '301.21',
        'long': 'Introverted personality',
        'short': 'Introverted personality'},
       {'code': '301.22',
        'long': 'Schizotypal personality disorder',
        'short': 'Schizotypal person dis'},
       {'code': '301.3',
        'long': 'Explosive personality disorder',
        'short': 'Explosive personality'},
       {'code': '301.4',
        'long': 'Obsessive-compulsive personality disorder',
        'short': 'Obsessive-compulsive dis'},
       {'code': '301.50',
        'long': 'Histrionic personality disorder, unspecified',
        'short': 'Histrionic person NOS'},
       {'code': '301.51',
        'long': 'Chronic factitious illness with physical symptoms',
        'short': 'Chr factitious illness'},
       {'code': '301.59',
        'long': 'Other histrionic personality disorder',
        'short': 'Histrionic person NEC'},
       {'code': '301.6',
        'long': 'Dependent personality disorder',
        'short': 'Dependent personality'},
       {'code': '301.7',
        'long': 'Antisocial personality disorder',
        'short': 'Antisocial personality'},
       {'code': '301.81',
        'long': 'Narcissistic personality disorder',
        'short': 'Narcissistic personality'},
       {'code': '301.82',
        'long': 'Avoidant personality disorder',
        'short': 'Avoidant personality dis'},
       {'code': '301.83',
        'long': 'Borderline personality disorder',
        'short': 'Borderline personality'},
       {'code': '301.84',
        'long': 'Passive-aggressive personality',
        'short': 'Passive-aggressiv person'},
       {'code': '301.89',
        'long': 'Other personality disorders',
        'short': 'Personality disorder NEC'},
       {'code': '301.9',
        'long': 'Unspecified personality disorder',
        'short': 'Personality disorder NOS'},
       {'code': '302.0',
        'long': 'Ego-dystonic sexual orientation',
        'short': 'Ego-dystonic sex orient'},
       {'code': '302.1', 'long': 'Zoophilia', 'short': 'Zoophilia'},
       {'code': '302.2', 'long': 'Pedophilia', 'short': 'Pedophilia'},
       {'code': '302.3',
        'long': 'Transvestic fetishism',
        'short': 'Transvestic fetishism'},
       {'code': '302.4', 'long': 'Exhibitionism', 'short': 'Exhibitionism'},
       {'code': '302.50',
        'long': 'Trans-sexualism with unspecified sexual history',
        'short': 'Trans-sexualism NOS'},
       {'code': '302.51',
        'long': 'Trans-sexualism with asexual history',
        'short': 'Trans-sexualism, asexual'},
       {'code': '302.52',
        'long': 'Trans-sexualism with homosexual history',
        'short': 'Trans-sexual, homosexual'},
       {'code': '302.53',
        'long': 'Trans-sexualism with heterosexual history',
        'short': 'Trans-sex, heterosexual'},
       {'code': '302.6',
        'long': 'Gender identity disorder in children',
        'short': 'Gendr identity dis-child'},
       {'code': '302.70',
        'long': 'Psychosexual dysfunction, unspecified',
        'short': 'Psychosexual dysfunc NOS'},
       {'code': '302.71',
        'long': 'Hypoactive sexual desire disorder',
        'short': 'Hypoactive sex desire'},
       {'code': '302.72',
        'long': 'Psychosexual dysfunction with inhibited sexual excitement',
        'short': 'Inhibited sex excitement'},
       {'code': '302.73',
        'long': 'Female orgasmic disorder',
        'short': 'Female orgasmic disorder'},
       {'code': '302.74',
        'long': 'Male orgasmic disorder',
        'short': 'Male orgasmic disorder'},
       {'code': '302.75',
        'long': 'Premature ejaculation',
        'short': 'Premature ejaculation'},
       {'code': '302.76',
        'long': 'Dyspareunia, psychogenic',
        'short': 'Dyspareunia,psychogenic'},
       {'code': '302.79',
        'long': 'Psychosexual dysfunction with other specified psychosexual dysfunctions',
        'short': 'Psychosexual dysfunc NEC'},
       {'code': '302.81', 'long': 'Fetishism', 'short': 'Fetishism'},
       {'code': '302.82', 'long': 'Voyeurism', 'short': 'Voyeurism'},
       {'code': '302.83',
        'long': 'Sexual masochism',
        'short': 'Sexual masochism'},
       {'code': '302.84', 'long': 'Sexual sadism', 'short': 'Sexual sadism'},
       {'code': '302.85',
        'long': 'Gender identity disorder in adolescents or adults',
        'short': 'Gend iden dis,adol/adult'},
       {'code': '302.89',
        'long': 'Other specified psychosexual disorders',
        'short': 'Psychosexual dis NEC'},
       {'code': '302.9',
        'long': 'Unspecified psychosexual disorder',
        'short': 'Psychosexual dis NOS'},
       {'code': '303.00',
        'long': 'Acute alcoholic intoxication in alcoholism, unspecified',
        'short': 'Ac alcohol intox-unspec'},
       {'code': '303.01',
        'long': 'Acute alcoholic intoxication in alcoholism, continuous',
        'short': 'Ac alcohol intox-contin'},
       {'code': '303.02',
        'long': 'Acute alcoholic intoxication in alcoholism, episodic',
        'short': 'Ac alcohol intox-episod'},
       {'code': '303.03',
        'long': 'Acute alcoholic intoxication in alcoholism, in remission',
        'short': 'Ac alcohol intox-remiss'},
       {'code': '303.90',
        'long': 'Other and unspecified alcohol dependence, unspecified',
        'short': 'Alcoh dep NEC/NOS-unspec'},
       {'code': '303.91',
        'long': 'Other and unspecified alcohol dependence, continuous',
        'short': 'Alcoh dep NEC/NOS-contin'},
       {'code': '303.92',
        'long': 'Other and unspecified alcohol dependence, episodic',
        'short': 'Alcoh dep NEC/NOS-episod'},
       {'code': '303.93',
        'long': 'Other and unspecified alcohol dependence, in remission',
        'short': 'Alcoh dep NEC/NOS-remiss'},
       {'code': '304.00',
        'long': 'Opioid type dependence, unspecified',
        'short': 'Opioid dependence-unspec'},
       {'code': '304.01',
        'long': 'Opioid type dependence, continuous',
        'short': 'Opioid dependence-contin'},
       {'code': '304.02',
        'long': 'Opioid type dependence, episodic',
        'short': 'Opioid dependence-episod'},
       {'code': '304.03',
        'long': 'Opioid type dependence, in remission',
        'short': 'Opioid dependence-remiss'},
       {'code': '304.10',
        'long': 'Sedative, hypnotic or anxiolytic dependence, unspecified',
        'short': 'Sed,hyp,anxiolyt dep-NOS'},
       {'code': '304.11',
        'long': 'Sedative, hypnotic or anxiolytic dependence, continuous',
        'short': 'Sed,hyp,anxiolyt dep-con'},
       {'code': '304.12',
        'long': 'Sedative, hypnotic or anxiolytic dependence, episodic',
        'short': 'Sed,hyp,anxiolyt dep-epi'},
       {'code': '304.13',
        'long': 'Sedative, hypnotic or anxiolytic dependence, in remission',
        'short': 'Sed,hyp,anxiolyt dep-rem'},
       {'code': '304.20',
        'long': 'Cocaine dependence, unspecified',
        'short': 'Cocaine depend-unspec'},
       {'code': '304.21',
        'long': 'Cocaine dependence, continuous',
        'short': 'Cocaine depend-contin'},
       {'code': '304.22',
        'long': 'Cocaine dependence, episodic',
        'short': 'Cocaine depend-episodic'},
       {'code': '304.23',
        'long': 'Cocaine dependence, in remission',
        'short': 'Cocaine depend-remiss'},
       {'code': '304.30',
        'long': 'Cannabis dependence, unspecified',
        'short': 'Cannabis depend-unspec'},
       {'code': '304.31',
        'long': 'Cannabis dependence, continuous',
        'short': 'Cannabis depend-contin'},
       {'code': '304.32',
        'long': 'Cannabis dependence, episodic',
        'short': 'Cannabis depend-episodic'},
       {'code': '304.33',
        'long': 'Cannabis dependence, in remission',
        'short': 'Cannabis depend-remiss'},
       {'code': '304.40',
        'long': 'Amphetamine and other psychostimulant dependence, unspecified',
        'short': 'Amphetamin depend-unspec'},
       {'code': '304.41',
        'long': 'Amphetamine and other psychostimulant dependence, continuous',
        'short': 'Amphetamin depend-contin'},
       {'code': '304.42',
        'long': 'Amphetamine and other psychostimulant dependence, episodic',
        'short': 'Amphetamin depend-episod'},
       {'code': '304.43',
        'long': 'Amphetamine and other psychostimulant dependence, in remission',
        'short': 'Amphetamin depend-remiss'},
       {'code': '304.50',
        'long': 'Hallucinogen dependence, unspecified',
        'short': 'Hallucinogen dep-unspec'},
       {'code': '304.51',
        'long': 'Hallucinogen dependence, continuous',
        'short': 'Hallucinogen dep-contin'},
       {'code': '304.52',
        'long': 'Hallucinogen dependence, episodic',
        'short': 'Hallucinogen dep-episod'},
       {'code': '304.53',
        'long': 'Hallucinogen dependence, in remission',
        'short': 'Hallucinogen dep-remiss'},
       {'code': '304.60',
        'long': 'Other specified drug dependence, unspecified',
        'short': 'Drug depend NEC-unspec'},
       {'code': '304.61',
        'long': 'Other specified drug dependence, continuous',
        'short': 'Drug depend NEC-contin'},
       {'code': '304.62',
        'long': 'Other specified drug dependence, episodic',
        'short': 'Drug depend NEC-episodic'},
       {'code': '304.63',
        'long': 'Other specified drug dependence, in remission',
        'short': 'Drug depend NEC-in rem'},
       {'code': '304.70',
        'long': 'Combinations of opioid type drug with any other drug dependence, unspecified',
        'short': 'Opioid/other dep-unspec'},
       {'code': '304.71',
        'long': 'Combinations of opioid type drug with any other drug dependence, continuous',
        'short': 'Opioid/other dep-contin'},
       {'code': '304.72',
        'long': 'Combinations of opioid type drug with any other drug dependence, episodic',
        'short': 'Opioid/other dep-episod'},
       {'code': '304.73',
        'long': 'Combinations of opioid type drug with any other drug dependence, in remission',
        'short': 'Opioid/other dep-remiss'},
       {'code': '304.80',
        'long': 'Combinations of drug dependence excluding opioid type drug, unspecified',
        'short': 'Comb drug dep NEC-unspec'},
       {'code': '304.81',
        'long': 'Combinations of drug dependence excluding opioid type drug, continuous',
        'short': 'Comb drug dep NEC-contin'},
       {'code': '304.82',
        'long': 'Combinations of drug dependence excluding opioid type drug, episodic',
        'short': 'Comb drug dep NEC-episod'},
       {'code': '304.83',
        'long': 'Combinations of drug dependence excluding opioid type drug, in remission',
        'short': 'Comb drug dep NEC-remiss'},
       {'code': '304.90',
        'long': 'Unspecified drug dependence, unspecified',
        'short': 'Drug depend NOS-unspec'},
       {'code': '304.91',
        'long': 'Unspecified drug dependence, continuous',
        'short': 'Drug depend NOS-contin'},
       {'code': '304.92',
        'long': 'Unspecified drug dependence, episodic',
        'short': 'Drug depend NOS-episodic'},
       {'code': '304.93',
        'long': 'Unspecified drug dependence, in remission',
        'short': 'Drug depend NOS-remiss'},
       {'code': '305.00',
        'long': 'Alcohol abuse, unspecified',
        'short': 'Alcohol abuse-unspec'},
       {'code': '305.01',
        'long': 'Alcohol abuse, continuous',
        'short': 'Alcohol abuse-continuous'},
       {'code': '305.02',
        'long': 'Alcohol abuse, episodic',
        'short': 'Alcohol abuse-episodic'},
       {'code': '305.03',
        'long': 'Alcohol abuse, in remission',
        'short': 'Alcohol abuse-in remiss'},
       {'code': '305.1',
        'long': 'Tobacco use disorder',
        'short': 'Tobacco use disorder'},
       {'code': '305.20',
        'long': 'Cannabis abuse, unspecified',
        'short': 'Cannabis abuse-unspec'},
       {'code': '305.21',
        'long': 'Cannabis abuse, continuous',
        'short': 'Cannabis abuse-contin'},
       {'code': '305.22',
        'long': 'Cannabis abuse, episodic',
        'short': 'Cannabis abuse-episodic'},
       {'code': '305.23',
        'long': 'Cannabis abuse, in remission',
        'short': 'Cannabis abuse-in remiss'},
       {'code': '305.30',
        'long': 'Hallucinogen abuse, unspecified',
        'short': 'Hallucinog abuse-unspec'},
       {'code': '305.31',
        'long': 'Hallucinogen abuse, continuous',
        'short': 'Hallucinog abuse-contin'},
       {'code': '305.32',
        'long': 'Hallucinogen abuse, episodic',
        'short': 'Hallucinog abuse-episod'},
       {'code': '305.33',
        'long': 'Hallucinogen abuse, in remission',
        'short': 'Hallucinog abuse-remiss'},
       {'code': '305.40',
        'long': 'Sedative, hypnotic or anxiolytic abuse, unspecified',
        'short': 'Sed,hyp,anxiolytc ab-NOS'},
       {'code': '305.41',
        'long': 'Sedative, hypnotic or anxiolytic abuse, continuous',
        'short': 'Sed,hyp,anxiolytc ab-con'},
       {'code': '305.42',
        'long': 'Sedative, hypnotic or anxiolytic abuse, episodic',
        'short': 'Sed,hyp,anxiolytc ab-epi'},
       {'code': '305.43',
        'long': 'Sedative, hypnotic or anxiolytic abuse, in remission',
        'short': 'Sed,hyp,anxiolytc ab-rem'},
       {'code': '305.50',
        'long': 'Opioid abuse, unspecified',
        'short': 'Opioid abuse-unspec'},
       {'code': '305.51',
        'long': 'Opioid abuse, continuous',
        'short': 'Opioid abuse-continuous'},
       {'code': '305.52',
        'long': 'Opioid abuse, episodic',
        'short': 'Opioid abuse-episodic'},
       {'code': '305.53',
        'long': 'Opioid abuse, in remission',
        'short': 'Opioid abuse-in remiss'},
       {'code': '305.60',
        'long': 'Cocaine abuse, unspecified',
        'short': 'Cocaine abuse-unspec'},
       {'code': '305.61',
        'long': 'Cocaine abuse, continuous',
        'short': 'Cocaine abuse-continuous'},
       {'code': '305.62',
        'long': 'Cocaine abuse, episodic',
        'short': 'Cocaine abuse-episodic'},
       {'code': '305.63',
        'long': 'Cocaine abuse, in remission',
        'short': 'Cocaine abuse-in remiss'},
       {'code': '305.70',
        'long': 'Amphetamine or related acting sympathomimetic abuse, unspecified',
        'short': 'Amphetamine abuse-unspec'},
       {'code': '305.71',
        'long': 'Amphetamine or related acting sympathomimetic abuse, continuous',
        'short': 'Amphetamine abuse-contin'},
       {'code': '305.72',
        'long': 'Amphetamine or related acting sympathomimetic abuse, episodic',
        'short': 'Amphetamine abuse-episod'},
       {'code': '305.73',
        'long': 'Amphetamine or related acting sympathomimetic abuse, in remission',
        'short': 'Amphetamine abuse-remiss'},
       {'code': '305.80',
        'long': 'Antidepressant type abuse, unspecified',
        'short': 'Antidepress abuse-unspec'},
       {'code': '305.81',
        'long': 'Antidepressant type abuse, continuous',
        'short': 'Antidepress abuse-contin'},
       {'code': '305.82',
        'long': 'Antidepressant type abuse, episodic',
        'short': 'Antidepress abuse-episod'},
       {'code': '305.83',
        'long': 'Antidepressant type abuse, in remission',
        'short': 'Antidepress abuse-remiss'},
       {'code': '305.90',
        'long': 'Other, mixed, or unspecified drug abuse, unspecified',
        'short': 'Drug abuse NEC-unspec'},
       {'code': '305.91',
        'long': 'Other, mixed, or unspecified drug abuse, continuous',
        'short': 'Drug abuse NEC-contin'},
       {'code': '305.92',
        'long': 'Other, mixed, or unspecified drug abuse, episodic',
        'short': 'Drug abuse NEC-episodic'},
       {'code': '305.93',
        'long': 'Other, mixed, or unspecified drug abuse, in remission',
        'short': 'Drug abuse NEC-in remiss'},
       {'code': '306.0',
        'long': 'Musculoskeletal malfunction arising from mental factors',
        'short': 'Psychogen musculskel dis'},
       {'code': '306.1',
        'long': 'Respiratory malfunction arising from mental factors',
        'short': 'Psychogenic respir dis'},
       {'code': '306.2',
        'long': 'Cardiovascular malfunction arising from mental factors',
        'short': 'Psychogen cardiovasc dis'},
       {'code': '306.3',
        'long': 'Skin disorder arising from mental factors',
        'short': 'Psychogenic skin disease'},
       {'code': '306.4',
        'long': 'Gastrointestinal malfunction arising from mental factors',
        'short': 'Psychogenic GI disease'},
       {'code': '306.50',
        'long': 'Psychogenic genitourinary malfunction, unspecified',
        'short': 'Psychogenic gu dis NOS'},
       {'code': '306.51',
        'long': 'Psychogenic vaginismus',
        'short': 'Psychogenic vaginismus'},
       {'code': '306.52',
        'long': 'Psychogenic dysmenorrhea',
        'short': 'Psychogenic dysmenorrhea'},
       {'code': '306.53',
        'long': 'Psychogenic dysuria',
        'short': 'Psychogenic dysuria'},
       {'code': '306.59',
        'long': 'Other genitourinary malfunction arising from mental factors',
        'short': 'Psychogenic gu dis NEC'},
       {'code': '306.6',
        'long': 'Endocrine disorder arising from mental factors',
        'short': 'Psychogen endocrine dis'},
       {'code': '306.7',
        'long': 'Disorder of organs of special sense arising from mental factors',
        'short': 'Psychogenic sensory dis'},
       {'code': '306.8',
        'long': 'Other specified psychophysiological malfunction',
        'short': 'Psychogenic disorder NEC'},
       {'code': '306.9',
        'long': 'Unspecified psychophysiological malfunction',
        'short': 'Psychogenic disorder NOS'},
       {'code': '307.0',
        'long': 'Adult onset fluency disorder',
        'short': 'Adult onset flncy disord'},
       {'code': '307.1',
        'long': 'Anorexia nervosa',
        'short': 'Anorexia nervosa'},
       {'code': '307.20',
        'long': 'Tic disorder, unspecified',
        'short': 'Tic disorder NOS'},
       {'code': '307.21',
        'long': 'Transient tic disorder',
        'short': 'Transient tic disorder'},
       {'code': '307.22',
        'long': 'Chronic motor or vocal tic disorder',
        'short': 'Chr motor/vocal tic dis'},
       {'code': '307.23',
        'long': "Tourette's disorder",
        'short': "Tourette's disorder"},
       {'code': '307.3',
        'long': 'Stereotypic movement disorder',
        'short': 'Stereotypic movement dis'},
       {'code': '307.40',
        'long': 'Nonorganic sleep disorder, unspecified',
        'short': 'Nonorganic sleep dis NOS'},
       {'code': '307.41',
        'long': 'Transient disorder of initiating or maintaining sleep',
        'short': 'Transient insomnia'},
       {'code': '307.42',
        'long': 'Persistent disorder of initiating or maintaining sleep',
        'short': 'Persistent insomnia'},
       {'code': '307.43',
        'long': 'Transient disorder of initiating or maintaining wakefulness',
        'short': 'Transient hypersomnia'},
       {'code': '307.44',
        'long': 'Persistent disorder of initiating or maintaining wakefulness',
        'short': 'Persistent hypersomnia'},
       {'code': '307.45',
        'long': 'Circadian rhythm sleep disorder of nonorganic origin',
        'short': 'Nonorganic circadian rhy'},
       {'code': '307.46',
        'long': 'Sleep arousal disorder',
        'short': 'Sleep arousal disorder'},
       {'code': '307.47',
        'long': 'Other dysfunctions of sleep stages or arousal from sleep',
        'short': 'Sleep stage dysfunc NEC'},
       {'code': '307.48',
        'long': 'Repetitive intrusions of sleep',
        'short': 'Repetit sleep intrusion'},
       {'code': '307.49',
        'long': 'Other specific disorders of sleep of nonorganic origin',
        'short': 'Nonorganic sleep dis NEC'},
       {'code': '307.50',
        'long': 'Eating disorder, unspecified',
        'short': 'Eating disorder NOS'},
       {'code': '307.51',
        'long': 'Bulimia nervosa',
        'short': 'Bulimia nervosa'},
       {'code': '307.52', 'long': 'Pica', 'short': 'Pica'},
       {'code': '307.53',
        'long': 'Rumination disorder',
        'short': 'Rumination disorder'},
       {'code': '307.54',
        'long': 'Psychogenic vomiting',
        'short': 'Psychogenic vomiting'},
       {'code': '307.59',
        'long': 'Other disorders of eating',
        'short': 'Eating disorder NEC'},
       {'code': '307.6', 'long': 'Enuresis', 'short': 'Enuresis'},
       {'code': '307.7', 'long': 'Encopresis', 'short': 'Encopresis'},
       {'code': '307.80',
        'long': 'Psychogenic pain, site unspecified',
        'short': 'Psychogenic pain NOS'},
       {'code': '307.81',
        'long': 'Tension headache',
        'short': 'Tension headache'},
       {'code': '307.89',
        'long': 'Other pain disorders related to psychological factors',
        'short': 'Psychogenic pain NEC'},
       {'code': '307.9',
        'long': 'Other and unspecified special symptoms or syndromes, not elsewhere classified',
        'short': 'Special symptom NEC/NOS'},
       {'code': '308.0',
        'long': 'Predominant disturbance of emotions',
        'short': 'Stress react, emotional'},
       {'code': '308.1',
        'long': 'Predominant disturbance of consciousness',
        'short': 'Stress reaction, fugue'},
       {'code': '308.2',
        'long': 'Predominant psychomotor disturbance',
        'short': 'Stress react, psychomot'},
       {'code': '308.3',
        'long': 'Other acute reactions to stress',
        'short': 'Acute stress react NEC'},
       {'code': '308.4',
        'long': 'Mixed disorders as reaction to stress',
        'short': 'Stress react, mixed dis'},
       {'code': '308.9',
        'long': 'Unspecified acute reaction to stress',
        'short': 'Acute stress react NOS'},
       {'code': '309.0',
        'long': 'Adjustment disorder with depressed mood',
        'short': 'Adjustmnt dis w depressn'},
       {'code': '309.1',
        'long': 'Prolonged depressive reaction',
        'short': 'Prolong depressive react'},
       {'code': '309.21',
        'long': 'Separation anxiety disorder',
        'short': 'Separation anxiety'},
       {'code': '309.22',
        'long': 'Emancipation disorder of adolescence and early adult life',
        'short': 'Emancipation disorder'},
       {'code': '309.23',
        'long': 'Specific academic or work inhibition',
        'short': 'Academic/work inhibition'},
       {'code': '309.24',
        'long': 'Adjustment disorder with anxiety',
        'short': 'Adjustment dis w anxiety'},
       {'code': '309.28',
        'long': 'Adjustment disorder with mixed anxiety and depressed mood',
        'short': 'Adjust dis w anxiety/dep'},
       {'code': '309.29',
        'long': 'Other adjustment reactions with predominant disturbance of other emotions',
        'short': 'Adj react-emotion NEC'},
       {'code': '309.3',
        'long': 'Adjustment disorder with disturbance of conduct',
        'short': 'Adjust disor/dis conduct'},
       {'code': '309.4',
        'long': 'Adjustment disorder with mixed disturbance of emotions and conduct',
        'short': 'Adj dis-emotion/conduct'},
       {'code': '309.81',
        'long': 'Posttraumatic stress disorder',
        'short': 'Posttraumatic stress dis'},
       {'code': '309.82',
        'long': 'Adjustment reaction with physical symptoms',
        'short': 'Adjust react-phys sympt'},
       {'code': '309.83',
        'long': 'Adjustment reaction with withdrawal',
        'short': 'Adjust react-withdrawal'},
       {'code': '309.89',
        'long': 'Other specified adjustment reactions',
        'short': 'Adjustment reaction NEC'},
       {'code': '309.9',
        'long': 'Unspecified adjustment reaction',
        'short': 'Adjustment reaction NOS'},
       {'code': '310.0',
        'long': 'Frontal lobe syndrome',
        'short': 'Frontal lobe syndrome'},
       {'code': '310.1',
        'long': 'Personality change due to conditions classified elsewhere',
        'short': 'Personality chg oth dis'},
       {'code': '310.2',
        'long': 'Postconcussion syndrome',
        'short': 'Postconcussion syndrome'},
       {'code': '310.81',
        'long': 'Pseudobulbar affect',
        'short': 'Pseudobulbar affect'},
       {'code': '310.89',
        'long': 'Other specified nonpsychotic mental disorders following organic brain damage',
        'short': 'Nonpsych mntl disord NEC'},
       {'code': '310.9',
        'long': 'Unspecified nonpsychotic mental disorder following organic brain damage',
        'short': 'Nonpsychot brain syn NOS'},
       {'code': '311',
        'long': 'Depressive disorder, not elsewhere classified',
        'short': 'Depressive disorder NEC'},
       {'code': '312.00',
        'long': 'Undersocialized conduct disorder, aggressive type, unspecified',
        'short': 'Unsocial aggress-unspec'},
       {'code': '312.01',
        'long': 'Undersocialized conduct disorder, aggressive type, mild',
        'short': 'Unsocial aggression-mild'},
       {'code': '312.02',
        'long': 'Undersocialized conduct disorder, aggressive type, moderate',
        'short': 'Unsocial aggression-mod'},
       {'code': '312.03',
        'long': 'Undersocialized conduct disorder, aggressive type, severe',
        'short': 'Unsocial aggress-severe'},
       {'code': '312.10',
        'long': 'Undersocialized conduct disorder, unaggressive type, unspecified',
        'short': 'Unsocial unaggress-unsp'},
       {'code': '312.11',
        'long': 'Undersocialized conduct disorder, unaggressive type, mild',
        'short': 'Unsocial unaggress-mild'},
       {'code': '312.12',
        'long': 'Undersocialized conduct disorder, unaggressive type, moderate',
        'short': 'Unsocial unaggress-mod'},
       {'code': '312.13',
        'long': 'Undersocialized conduct disorder, unaggressive type, severe',
        'short': 'Unsocial unaggr-severe'},
       {'code': '312.20',
        'long': 'Socialized conduct disorder, unspecified',
        'short': 'Social conduct dis-unsp'},
       {'code': '312.21',
        'long': 'Socialized conduct disorder, mild',
        'short': 'Social conduct dis-mild'},
       {'code': '312.22',
        'long': 'Socialized conduct disorder, moderate',
        'short': 'Social conduct dis-mod'},
       {'code': '312.23',
        'long': 'Socialized conduct disorder, severe',
        'short': 'Social conduct dis-sev'},
       {'code': '312.30',
        'long': 'Impulse control disorder, unspecified',
        'short': 'Impulse control dis NOS'},
       {'code': '312.31',
        'long': 'Pathological gambling',
        'short': 'Pathological gambling'},
       {'code': '312.32', 'long': 'Kleptomania', 'short': 'Kleptomania'},
       {'code': '312.33', 'long': 'Pyromania', 'short': 'Pyromania'},
       {'code': '312.34',
        'long': 'Intermittent explosive disorder',
        'short': 'Intermitt explosive dis'},
       {'code': '312.35',
        'long': 'Isolated explosive disorder',
        'short': 'Isolated explosive dis'},
       {'code': '312.39',
        'long': 'Other disorders of impulse control',
        'short': 'Impulse control dis NEC'},
       {'code': '312.4',
        'long': 'Mixed disturbance of conduct and emotions',
        'short': 'Mix dis conduct/emotion'},
       {'code': '312.81',
        'long': 'Conduct disorder, childhood onset type',
        'short': 'Cndct dsrdr chldhd onst'},
       {'code': '312.82',
        'long': 'Conduct disorder, adolescent onset type',
        'short': 'Cndct dsrdr adlscnt onst'},
       {'code': '312.89',
        'long': 'Other conduct disorder',
        'short': 'Other conduct disorder'},
       {'code': '312.9',
        'long': 'Unspecified disturbance of conduct',
        'short': 'Conduct disturbance NOS'},
       {'code': '313.0',
        'long': 'Overanxious disorder specific to childhood and adolescence',
        'short': 'Overanxious disorder'},
       {'code': '313.1',
        'long': 'Misery and unhappiness disorder specific to childhood and adolescence',
        'short': 'Misery & unhappiness dis'},
       {'code': '313.21',
        'long': 'Shyness disorder of childhood',
        'short': 'Shyness disorder-child'},
       {'code': '313.22',
        'long': 'Introverted disorder of childhood',
        'short': 'Introverted dis-child'},
       {'code': '313.23',
        'long': 'Selective mutism',
        'short': 'Selective mutism'},
       {'code': '313.3',
        'long': 'Relationship problems specific to childhood and adolescence',
        'short': 'Relationship problems'},
       {'code': '313.81',
        'long': 'Oppositional defiant disorder',
        'short': 'Opposition defiant disor'},
       {'code': '313.82',
        'long': 'Identity disorder of childhood or adolescence',
        'short': 'Identity disorder'},
       {'code': '313.83',
        'long': 'Academic underachievement disorder of childhood or adolescence',
        'short': 'Academic underachievment'},
       {'code': '313.89',
        'long': 'Other emotional disturbances of childhood or adolescence',
        'short': 'Emotional dis child NEC'},
       {'code': '313.9',
        'long': 'Unspecified emotional disturbance of childhood or adolescence',
        'short': 'Emotional dis child NOS'},
       {'code': '314.00',
        'long': 'Attention deficit disorder without mention of hyperactivity',
        'short': 'Attn defic nonhyperact'},
       {'code': '314.01',
        'long': 'Attention deficit disorder with hyperactivity',
        'short': 'Attn deficit w hyperact'},
       {'code': '314.1',
        'long': 'Hyperkinesis with developmental delay',
        'short': 'Hyperkinet w devel delay'},
       {'code': '314.2',
        'long': 'Hyperkinetic conduct disorder',
        'short': 'Hyperkinetic conduct dis'},
       {'code': '314.8',
        'long': 'Other specified manifestations of hyperkinetic syndrome',
        'short': 'Other hyperkinetic synd'},
       {'code': '314.9',
        'long': 'Unspecified hyperkinetic syndrome',
        'short': 'Hyperkinetic synd NOS'},
       {'code': '315.00',
        'long': 'Developmental reading disorder, unspecified',
        'short': 'Reading disorder NOS'},
       {'code': '315.01', 'long': 'Alexia', 'short': 'Alexia'},
       {'code': '315.02',
        'long': 'Developmental dyslexia',
        'short': 'Developmental dyslexia'},
       {'code': '315.09',
        'long': 'Other specific developmental reading disorder',
        'short': 'Reading disorder NEC'},
       {'code': '315.1',
        'long': 'Mathematics disorder',
        'short': 'Mathematics disorder'},
       {'code': '315.2',
        'long': 'Other specific developmental learning difficulties',
        'short': 'Oth learning difficulty'},
       {'code': '315.31',
        'long': 'Expressive language disorder',
        'short': 'Expressive language dis'},
       {'code': '315.32',
        'long': 'Mixed receptive-expressive language disorder',
        'short': 'Recp-expres language dis'},
       {'code': '315.34',
        'long': 'Speech and language developmental delay due to hearing loss',
        'short': 'Speech del d/t hear loss'},
       {'code': '315.35',
        'long': 'Childhood onset fluency disorder',
        'short': 'Chldhd onset flncy disor'},
       {'code': '315.39',
        'long': 'Other developmental speech or language disorder',
        'short': 'Speech/language dis NEC'},
       {'code': '315.4',
        'long': 'Developmental coordination disorder',
        'short': 'Devel coordination dis'},
       {'code': '315.5',
        'long': 'Mixed development disorder',
        'short': 'Mixed development dis'},
       {'code': '315.8',
        'long': 'Other specified delays in development',
        'short': 'Development delays NEC'},
       {'code': '315.9',
        'long': 'Unspecified delay in development',
        'short': 'Development delay NOS'},
       {'code': '316',
        'long': 'Psychic factors associated with diseases classified elsewhere',
        'short': 'Psychic factor w oth dis'},
       {'code': '317',
        'long': 'Mild intellectual disabilities',
        'short': 'Mild intellect disabilty'},
       {'code': '318.0',
        'long': 'Moderate intellectual disabilities',
        'short': 'Mod intellect disability'},
       {'code': '318.1',
        'long': 'Severe intellectual disabilities',
        'short': 'Sev intellect disability'},
       {'code': '318.2',
        'long': 'Profound intellectual disabilities',
        'short': 'Profnd intellct disablty'},
       {'code': '319',
        'long': 'Unspecified intellectual disabilities',
        'short': 'Intellect disability NOS'}],
 'G': [{'code': '320.0',
        'long': 'Hemophilus meningitis',
        'short': 'Hemophilus meningitis'},
       {'code': '320.1',
        'long': 'Pneumococcal meningitis',
        'short': 'Pneumococcal meningitis'},
       {'code': '320.2',
        'long': 'Streptococcal meningitis',
        'short': 'Streptococcal meningitis'},
       {'code': '320.3',
        'long': 'Staphylococcal meningitis',
        'short': 'Staphylococc meningitis'},
       {'code': '320.7',
        'long': 'Meningitis in other bacterial diseases classified elsewhere',
        'short': 'Mening in oth bact dis'},
       {'code': '320.81',
        'long': 'Anaerobic meningitis',
        'short': 'Anaerobic meningitis'},
       {'code': '320.82',
        'long': 'Meningitis due to gram-negative bacteria, not elsewhere classified',
        'short': 'Mningts gram-neg bct NEC'},
       {'code': '320.89',
        'long': 'Meningitis due to other specified bacteria',
        'short': 'Meningitis oth spcf bact'},
       {'code': '320.9',
        'long': 'Meningitis due to unspecified bacterium',
        'short': 'Bacterial meningitis NOS'},
       {'code': '321.0',
        'long': 'Cryptococcal meningitis',
        'short': 'Cryptococcal meningitis'},
       {'code': '321.1',
        'long': 'Meningitis in other fungal diseases',
        'short': 'Mening in oth fungal dis'},
       {'code': '321.2',
        'long': 'Meningitis due to viruses not elsewhere classified',
        'short': 'Mening in oth viral dis'},
       {'code': '321.3',
        'long': 'Meningitis due to trypanosomiasis',
        'short': 'Trypanosomiasis meningit'},
       {'code': '321.4',
        'long': 'Meningitis in sarcoidosis',
        'short': 'Meningit d/t sarcoidosis'},
       {'code': '321.8',
        'long': 'Meningitis due to other nonbacterial organisms classified elsewhere',
        'short': 'Mening in oth nonbac dis'},
       {'code': '322.0',
        'long': 'Nonpyogenic meningitis',
        'short': 'Nonpyogenic meningitis'},
       {'code': '322.1',
        'long': 'Eosinophilic meningitis',
        'short': 'Eosinophilic meningitis'},
       {'code': '322.2',
        'long': 'Chronic meningitis',
        'short': 'Chronic meningitis'},
       {'code': '322.9',
        'long': 'Meningitis, unspecified',
        'short': 'Meningitis NOS'},
       {'code': '323.01',
        'long': 'Encephalitis and encephalomyelitis in viral diseases classified elsewhere',
        'short': 'Enceph/encephmye oth dis'},
       {'code': '323.02',
        'long': 'Myelitis in viral diseases classified elsewhere',
        'short': 'Myelitis-oth viral dis'},
       {'code': '323.1',
        'long': 'Encephalitis, myelitis, and encephalomyelitis in rickettsial diseases classified elsewhere',
        'short': 'Rickettsial encephalitis'},
       {'code': '323.2',
        'long': 'Encephalitis, myelitis, and encephalomyelitis in protozoal diseases classified elsewhere',
        'short': 'Protozoal encephalitis'},
       {'code': '323.41',
        'long': 'Other encephalitis and encephalomyelitis due to other infections classified elsewhere',
        'short': 'Ot encph/mye ot inf else'},
       {'code': '323.42',
        'long': 'Other myelitis due to other infections classified elsewhere',
        'short': 'Oth myelitis ot inf else'},
       {'code': '323.51',
        'long': 'Encephalitis and encephalomyelitis following immunization procedures',
        'short': 'Enceph/myel folwg immune'},
       {'code': '323.52',
        'long': 'Myelitis following immunization procedures',
        'short': 'Myelitis follwg immune'},
       {'code': '323.61',
        'long': 'Infectious acute disseminated encephalomyelitis (ADEM)',
        'short': 'Inf ac dis encephalomyel'},
       {'code': '323.62',
        'long': 'Other postinfectious encephalitis and encephalomyelitis',
        'short': 'Postinf encephalitis NEC'},
       {'code': '323.63',
        'long': 'Postinfectious myelitis',
        'short': 'Postinfectious myelitis'},
       {'code': '323.71',
        'long': 'Toxic encephalitis and encephalomyelitis',
        'short': 'Toxic encph & encephlomy'},
       {'code': '323.72',
        'long': 'Toxic myelitis',
        'short': 'Toxic myelitis'},
       {'code': '323.81',
        'long': 'Other causes of encephalitis and encephalomyelitis',
        'short': 'Enceph & encephlalo NEC'},
       {'code': '323.82',
        'long': 'Other causes of myelitis',
        'short': 'Myelitis cause NEC'},
       {'code': '323.9',
        'long': 'Unspecified causes of encephalitis, myelitis, and encephalomyelitis',
        'short': 'Encephalitis NOS'},
       {'code': '324.0',
        'long': 'Intracranial abscess',
        'short': 'Intracranial abscess'},
       {'code': '324.1',
        'long': 'Intraspinal abscess',
        'short': 'Intraspinal abscess'},
       {'code': '324.9',
        'long': 'Intracranial and intraspinal abscess of unspecified site',
        'short': 'Cns abscess NOS'},
       {'code': '325',
        'long': 'Phlebitis and thrombophlebitis of intracranial venous sinuses',
        'short': 'Phlebitis intrcran sinus'},
       {'code': '326',
        'long': 'Late effects of intracranial abscess or pyogenic infection',
        'short': 'Late eff cns abscess'},
       {'code': '327.00',
        'long': 'Organic insomnia, unspecified',
        'short': 'Organic insomnia NOS'},
       {'code': '327.01',
        'long': 'Insomnia due to medical condition classified elsewhere',
        'short': 'Insomnia in other dis'},
       {'code': '327.02',
        'long': 'Insomnia due to mental disorder',
        'short': 'Insomnia dt mental disor'},
       {'code': '327.09',
        'long': 'Other organic insomnia',
        'short': 'Organic insomnia NEC'},
       {'code': '327.10',
        'long': 'Organic hypersomnia, unspecified',
        'short': 'Organic hypersomnia NOS'},
       {'code': '327.11',
        'long': 'Idiopathic hypersomnia with long sleep time',
        'short': 'Idio hypersom-long sleep'},
       {'code': '327.12',
        'long': 'Idiopathic hypersomnia without long sleep time',
        'short': 'Idio hypersom-no lng slp'},
       {'code': '327.13',
        'long': 'Recurrent hypersomnia',
        'short': 'Recurrent hypersomnia'},
       {'code': '327.14',
        'long': 'Hypersomnia due to medical condition classified elsewhere',
        'short': 'Hypersomnia in other dis'},
       {'code': '327.15',
        'long': 'Hypersomnia due to mental disorder',
        'short': 'Hypersom dt mental disor'},
       {'code': '327.19',
        'long': 'Other organic hypersomnia',
        'short': 'Organic hypersomnia NEC'},
       {'code': '327.20',
        'long': 'Organic sleep apnea, unspecified',
        'short': 'Organic sleep apnea NOS'},
       {'code': '327.21',
        'long': 'Primary central sleep apnea',
        'short': 'Prim central sleep apnea'},
       {'code': '327.22',
        'long': 'High altitude periodic breathing',
        'short': 'High altitude breathing'},
       {'code': '327.23',
        'long': 'Obstructive sleep apnea (adult)(pediatric)',
        'short': 'Obstructive sleep apnea'},
       {'code': '327.24',
        'long': 'Idiopathic sleep related non-obstructive alveolar hypoventilation',
        'short': 'Idiopath sleep hypovent'},
       {'code': '327.25',
        'long': 'Congenital central alveolar hypoventilation syndrome',
        'short': 'Cong cntrl hypovent synd'},
       {'code': '327.26',
        'long': 'Sleep related hypoventilation/hypoxemia in conditions classifiable elsewhere',
        'short': 'Sleep hypovent oth dis'},
       {'code': '327.27',
        'long': 'Central sleep apnea in conditions classified elsewhere',
        'short': 'Cntrl sleep apnea ot dis'},
       {'code': '327.29',
        'long': 'Other organic sleep apnea',
        'short': 'Organic sleep apnea NEC'},
       {'code': '327.30',
        'long': 'Circadian rhythm sleep disorder, unspecified',
        'short': 'Circadian rhym sleep NOS'},
       {'code': '327.31',
        'long': 'Circadian rhythm sleep disorder, delayed sleep phase type',
        'short': 'Circadian rhy-delay slp'},
       {'code': '327.32',
        'long': 'Circadian rhythm sleep disorder, advanced sleep phase type',
        'short': 'Circadian rhy-advc sleep'},
       {'code': '327.33',
        'long': 'Circadian rhythm sleep disorder, irregular sleep-wake type',
        'short': 'Circadian rhym-irreg slp'},
       {'code': '327.34',
        'long': 'Circadian rhythm sleep disorder, free-running type',
        'short': 'Circadian rhym-free run'},
       {'code': '327.35',
        'long': 'Circadian rhythm sleep disorder, jet lag type',
        'short': 'Circadian rhythm-jetlag'},
       {'code': '327.36',
        'long': 'Circadian rhythm sleep disorder, shift work type',
        'short': 'Circadian rhy-shift work'},
       {'code': '327.37',
        'long': 'Circadian rhythm sleep disorder in conditions classified elsewhere',
        'short': 'Circadian rhym oth dis'},
       {'code': '327.39',
        'long': 'Other circadian rhythm sleep disorder',
        'short': 'Circadian rhym sleep NEC'},
       {'code': '327.40',
        'long': 'Organic parasomnia, unspecified',
        'short': 'Organic parasomnia NOS'},
       {'code': '327.41',
        'long': 'Confusional arousals',
        'short': 'Confusional arousals'},
       {'code': '327.42',
        'long': 'REM sleep behavior disorder',
        'short': 'REM sleep behavior dis'},
       {'code': '327.43',
        'long': 'Recurrent isolated sleep paralysis',
        'short': 'Recurrnt sleep paralysis'},
       {'code': '327.44',
        'long': 'Parasomnia in conditions classified elsewhere',
        'short': 'Parasomnia oth diseases'},
       {'code': '327.49',
        'long': 'Other organic parasomnia',
        'short': 'Organic parasomnia NEC'},
       {'code': '327.51',
        'long': 'Periodic limb movement disorder',
        'short': 'Periodic limb movement'},
       {'code': '327.52',
        'long': 'Sleep related leg cramps',
        'short': 'Sleep related leg cramps'},
       {'code': '327.53',
        'long': 'Sleep related bruxism',
        'short': 'Sleep related bruxism'},
       {'code': '327.59',
        'long': 'Other organic sleep related movement disorders',
        'short': 'Organic sleep movemt NEC'},
       {'code': '327.8',
        'long': 'Other organic sleep disorders',
        'short': 'Sleep organic disord NEC'},
       {'code': '330.0', 'long': 'Leukodystrophy', 'short': 'Leukodystrophy'},
       {'code': '330.1',
        'long': 'Cerebral lipidoses',
        'short': 'Cerebral lipidoses'},
       {'code': '330.2',
        'long': 'Cerebral degeneration in generalized lipidoses',
        'short': 'Cereb degen in lipidosis'},
       {'code': '330.3',
        'long': 'Cerebral degeneration of childhood in other diseases classified elsewhere',
        'short': 'Cerb deg chld in oth dis'},
       {'code': '330.8',
        'long': 'Other specified cerebral degenerations in childhood',
        'short': 'Cereb degen in child NEC'},
       {'code': '330.9',
        'long': 'Unspecified cerebral degeneration in childhood',
        'short': 'Cereb degen in child NOS'},
       {'code': '331.0',
        'long': "Alzheimer's disease",
        'short': "Alzheimer's disease"},
       {'code': '331.11',
        'long': "Pick's disease",
        'short': "Pick's disease"},
       {'code': '331.19',
        'long': 'Other frontotemporal dementia',
        'short': 'Frontotemp dementia NEC'},
       {'code': '331.2',
        'long': 'Senile degeneration of brain',
        'short': 'Senile degenerat brain'},
       {'code': '331.3',
        'long': 'Communicating hydrocephalus',
        'short': 'Communicat hydrocephalus'},
       {'code': '331.4',
        'long': 'Obstructive hydrocephalus',
        'short': 'Obstructiv hydrocephalus'},
       {'code': '331.5',
        'long': 'Idiopathic normal pressure hydrocephalus (INPH)',
        'short': 'Norml pressure hydroceph'},
       {'code': '331.6',
        'long': 'Corticobasal degeneration',
        'short': 'Corticobasal degneration'},
       {'code': '331.7',
        'long': 'Cerebral degeneration in diseases classified elsewhere',
        'short': 'Cereb degen in oth dis'},
       {'code': '331.81',
        'long': "Reye's syndrome",
        'short': "Reye's syndrome"},
       {'code': '331.82',
        'long': 'Dementia with lewy bodies',
        'short': 'Dementia w Lewy bodies'},
       {'code': '331.83',
        'long': 'Mild cognitive impairment, so stated',
        'short': 'Mild cognitive impairemt'},
       {'code': '331.89',
        'long': 'Other cerebral degeneration',
        'short': 'Cereb degeneration NEC'},
       {'code': '331.9',
        'long': 'Cerebral degeneration, unspecified',
        'short': 'Cereb degeneration NOS'},
       {'code': '332.0',
        'long': 'Paralysis agitans',
        'short': 'Paralysis agitans'},
       {'code': '332.1',
        'long': 'Secondary parkinsonism',
        'short': 'Secondary parkinsonism'},
       {'code': '333.0',
        'long': 'Other degenerative diseases of the basal ganglia',
        'short': 'Degen basal ganglia NEC'},
       {'code': '333.1',
        'long': 'Essential and other specified forms of tremor',
        'short': 'Tremor NEC'},
       {'code': '333.2', 'long': 'Myoclonus', 'short': 'Myoclonus'},
       {'code': '333.3',
        'long': 'Tics of organic origin',
        'short': 'Tics of organic origin'},
       {'code': '333.4',
        'long': "Huntington's chorea",
        'short': "Huntington's chorea"},
       {'code': '333.5', 'long': 'Other choreas', 'short': 'Chorea NEC'},
       {'code': '333.6',
        'long': 'Genetic torsion dystonia',
        'short': 'Genetic torsion dystonia'},
       {'code': '333.71',
        'long': 'Athetoid cerebral palsy',
        'short': 'Athetoid cerebral palsy'},
       {'code': '333.72',
        'long': 'Acute dystonia due to drugs',
        'short': 'Acute dystonia d/t drugs'},
       {'code': '333.79',
        'long': 'Other acquired torsion dystonia',
        'short': 'Acq torsion dystonia NEC'},
       {'code': '333.81', 'long': 'Blepharospasm', 'short': 'Blepharospasm'},
       {'code': '333.82',
        'long': 'Orofacial dyskinesia',
        'short': 'Orofacial dyskinesia'},
       {'code': '333.83',
        'long': 'Spasmodic torticollis',
        'short': 'Spasmodic torticollis'},
       {'code': '333.84',
        'long': "Organic writers' cramp",
        'short': "Organic writers' cramp"},
       {'code': '333.85',
        'long': 'Subacute dyskinesia due to drugs',
        'short': 'Subac dyskinesa d/t drug'},
       {'code': '333.89',
        'long': 'Other fragments of torsion dystonia',
        'short': 'Fragm torsion dyston NEC'},
       {'code': '333.90',
        'long': 'Unspecified extrapyramidal disease and abnormal movement disorder',
        'short': 'Extrapyramidal dis NOS'},
       {'code': '333.91',
        'long': 'Stiff-man syndrome',
        'short': 'Stiff-man syndrome'},
       {'code': '333.92',
        'long': 'Neuroleptic malignant syndrome',
        'short': 'Neuroleptic malgnt synd'},
       {'code': '333.93',
        'long': 'Benign shuddering attacks',
        'short': 'Bnign shuddering attacks'},
       {'code': '333.94',
        'long': 'Restless legs syndrome (RLS)',
        'short': 'Restless legs syndrome'},
       {'code': '333.99',
        'long': 'Other extrapyramidal diseases and abnormal movement disorders',
        'short': 'Extrapyramidal dis NEC'},
       {'code': '334.0',
        'long': "Friedreich's ataxia",
        'short': "Friedreich's ataxia"},
       {'code': '334.1',
        'long': 'Hereditary spastic paraplegia',
        'short': 'Hered spastic paraplegia'},
       {'code': '334.2',
        'long': 'Primary cerebellar degeneration',
        'short': 'Primary cerebellar degen'},
       {'code': '334.3',
        'long': 'Other cerebellar ataxia',
        'short': 'Cerebellar ataxia NEC'},
       {'code': '334.4',
        'long': 'Cerebellar ataxia in diseases classified elsewhere',
        'short': 'Cerebel atax in oth dis'},
       {'code': '334.8',
        'long': 'Other spinocerebellar diseases',
        'short': 'Spinocerebellar dis NEC'},
       {'code': '334.9',
        'long': 'Spinocerebellar disease, unspecified',
        'short': 'Spinocerebellar dis NOS'},
       {'code': '335.0',
        'long': 'Werdnig-Hoffmann disease',
        'short': 'Werdnig-hoffmann disease'},
       {'code': '335.10',
        'long': 'Spinal muscular atrophy, unspecified',
        'short': 'Spinal muscl atrophy NOS'},
       {'code': '335.11',
        'long': 'Kugelberg-Welander disease',
        'short': 'Kugelberg-welander dis'},
       {'code': '335.19',
        'long': 'Other spinal muscular atrophy',
        'short': 'Spinal muscl atrophy NEC'},
       {'code': '335.20',
        'long': 'Amyotrophic lateral sclerosis',
        'short': 'Amyotrophic sclerosis'},
       {'code': '335.21',
        'long': 'Progressive muscular atrophy',
        'short': 'Prog muscular atrophy'},
       {'code': '335.22',
        'long': 'Progressive bulbar palsy',
        'short': 'Progressive bulbar palsy'},
       {'code': '335.23',
        'long': 'Pseudobulbar palsy',
        'short': 'Pseudobulbar palsy'},
       {'code': '335.24',
        'long': 'Primary lateral sclerosis',
        'short': 'Prim lateral sclerosis'},
       {'code': '335.29',
        'long': 'Other motor neuron disease',
        'short': 'Motor neuron disease NEC'},
       {'code': '335.8',
        'long': 'Other anterior horn cell diseases',
        'short': 'Ant horn cell dis NEC'},
       {'code': '335.9',
        'long': 'Anterior horn cell disease, unspecified',
        'short': 'Ant horn cell dis NOS'},
       {'code': '336.0',
        'long': 'Syringomyelia and syringobulbia',
        'short': 'Syringomyelia'},
       {'code': '336.1',
        'long': 'Vascular myelopathies',
        'short': 'Vascular myelopathies'},
       {'code': '336.2',
        'long': 'Subacute combined degeneration of spinal cord in diseases classified elsewhere',
        'short': 'Comb deg cord in oth dis'},
       {'code': '336.3',
        'long': 'Myelopathy in other diseases classified elsewhere',
        'short': 'Myelopathy in oth dis'},
       {'code': '336.8',
        'long': 'Other myelopathy',
        'short': 'Myelopathy NEC'},
       {'code': '336.9',
        'long': 'Unspecified disease of spinal cord',
        'short': 'Spinal cord disease NOS'},
       {'code': '337.00',
        'long': 'Idiopathic peripheral autonomic neuropathy, unspecified',
        'short': 'Idio perph auto neur NOS'},
       {'code': '337.01',
        'long': 'Carotid sinus syndrome',
        'short': 'Carotid sinus syndrome'},
       {'code': '337.09',
        'long': 'Other idiopathic peripheral autonomic neuropathy',
        'short': 'Idio perph auto neur NEC'},
       {'code': '337.1',
        'long': 'Peripheral autonomic neuropathy in disorders classified elsewhere',
        'short': 'Aut neuropthy in oth dis'},
       {'code': '337.20',
        'long': 'Reflex sympathetic dystrophy, unspecified',
        'short': 'Unsp rflx sympth dystrph'},
       {'code': '337.21',
        'long': 'Reflex sympathetic dystrophy of the upper limb',
        'short': 'Rflx sym dystrph up limb'},
       {'code': '337.22',
        'long': 'Reflex sympathetic dystrophy of the lower limb',
        'short': 'Rflx sym dystrph lwr lmb'},
       {'code': '337.29',
        'long': 'Reflex sympathetic dystrophy of other specified site',
        'short': 'Rflx sym dystrph oth st'},
       {'code': '337.3',
        'long': 'Autonomic dysreflexia',
        'short': 'Autonomic dysreflexia'},
       {'code': '337.9',
        'long': 'Unspecified disorder of autonomic nervous system',
        'short': 'Autonomic nerve dis NEC'},
       {'code': '338.0',
        'long': 'Central pain syndrome',
        'short': 'Central pain syndrome'},
       {'code': '338.11',
        'long': 'Acute pain due to trauma',
        'short': 'Acute pain due to trauma'},
       {'code': '338.12',
        'long': 'Acute post-thoracotomy pain',
        'short': 'Acute post-thoracot pain'},
       {'code': '338.18',
        'long': 'Other acute postoperative pain',
        'short': 'Acute postop pain NEC'},
       {'code': '338.19',
        'long': 'Other acute pain',
        'short': 'Acute pain NEC'},
       {'code': '338.21',
        'long': 'Chronic pain due to trauma',
        'short': 'Chronc pain d/t trauma'},
       {'code': '338.22',
        'long': 'Chronic post-thoracotomy pain',
        'short': 'Chron post-thoracot pain'},
       {'code': '338.28',
        'long': 'Other chronic postoperative pain',
        'short': 'Chronic postop pain NEC'},
       {'code': '338.29',
        'long': 'Other chronic pain',
        'short': 'Chronic pain NEC'},
       {'code': '338.3',
        'long': 'Neoplasm related pain (acute) (chronic)',
        'short': 'Neoplasm related pain'},
       {'code': '338.4',
        'long': 'Chronic pain syndrome',
        'short': 'Chronic pain syndrome'},
       {'code': '339.00',
        'long': 'Cluster headache syndrome, unspecified',
        'short': 'Cluster headache syn NOS'},
       {'code': '339.01',
        'long': 'Episodic cluster headache',
        'short': 'Episodc cluster headache'},
       {'code': '339.02',
        'long': 'Chronic cluster headache',
        'short': 'Chronic cluster headache'},
       {'code': '339.03',
        'long': 'Episodic paroxysmal hemicrania',
        'short': 'Episdc paroxyml hemicran'},
       {'code': '339.04',
        'long': 'Chronic paroxysmal hemicrania',
        'short': 'Chr paroxysml hemicrania'},
       {'code': '339.05',
        'long': 'Short lasting unilateral neuralgiform headache with conjunctival injection and tearing',
        'short': 'Shrt lst uni nral hdache'},
       {'code': '339.09',
        'long': 'Other trigeminal autonomic cephalgias',
        'short': 'Trigem autonmc cephl NEC'},
       {'code': '339.10',
        'long': 'Tension type headache, unspecified',
        'short': 'Tension headache NOS'},
       {'code': '339.11',
        'long': 'Episodic tension type headache',
        'short': 'Episdic tension headache'},
       {'code': '339.12',
        'long': 'Chronic tension type headache',
        'short': 'Chronic tension headache'},
       {'code': '339.20',
        'long': 'Post-traumatic headache, unspecified',
        'short': 'Post-trauma headache NOS'},
       {'code': '339.21',
        'long': 'Acute post-traumatic headache',
        'short': 'Ac post-trauma headache'},
       {'code': '339.22',
        'long': 'Chronic post-traumatic headache',
        'short': 'Chr post-trauma headache'},
       {'code': '339.3',
        'long': 'Drug induced headache, not elsewhere classified',
        'short': 'Drug induce headache NEC'},
       {'code': '339.41',
        'long': 'Hemicrania continua',
        'short': 'Hemicrania continua'},
       {'code': '339.42',
        'long': 'New daily persistent headache',
        'short': 'New daily pers headache'},
       {'code': '339.43',
        'long': 'Primary thunderclap headache',
        'short': 'Prim thnderclap headache'},
       {'code': '339.44',
        'long': 'Other complicated headache syndrome',
        'short': 'Comp headache synd NEC'},
       {'code': '339.81',
        'long': 'Hypnic headache',
        'short': 'Hypnic headache'},
       {'code': '339.82',
        'long': 'Headache associated with sexual activity',
        'short': 'Headache w sex activity'},
       {'code': '339.83',
        'long': 'Primary cough headache',
        'short': 'Primary cough headache'},
       {'code': '339.84',
        'long': 'Primary exertional headache',
        'short': 'Prim exertion headache'},
       {'code': '339.85',
        'long': 'Primary stabbing headache',
        'short': 'Prim stabbing headache'},
       {'code': '339.89',
        'long': 'Other headache syndromes',
        'short': 'Headache syndrome NEC'},
       {'code': '340',
        'long': 'Multiple sclerosis',
        'short': 'Multiple sclerosis'},
       {'code': '341.0',
        'long': 'Neuromyelitis optica',
        'short': 'Neuromyelitis optica'},
       {'code': '341.1',
        'long': "Schilder's disease",
        'short': "Schilder's disease"},
       {'code': '341.20',
        'long': 'Acute (transverse) myelitis NOS',
        'short': 'Acute myelitis NOS'},
       {'code': '341.21',
        'long': 'Acute (transverse) myelitis in conditions classified elsewhere',
        'short': 'Acute myelitis oth cond'},
       {'code': '341.22',
        'long': 'Idiopathic transverse myelitis',
        'short': 'Idiopathc trans myelitis'},
       {'code': '341.8',
        'long': 'Other demyelinating diseases of central nervous system',
        'short': 'Cns demyelination NEC'},
       {'code': '341.9',
        'long': 'Demyelinating disease of central nervous system, unspecified',
        'short': 'Cns demyelination NOS'},
       {'code': '342.00',
        'long': 'Flaccid hemiplegia and hemiparesis affecting unspecified side',
        'short': 'Flccd hmiplga unspf side'},
       {'code': '342.01',
        'long': 'Flaccid hemiplegia and hemiparesis affecting dominant side',
        'short': 'Flccd hmiplga domnt side'},
       {'code': '342.02',
        'long': 'Flaccid hemiplegia and hemiparesis affecting nondominant side',
        'short': 'Flccd hmiplg nondmnt sde'},
       {'code': '342.10',
        'long': 'Spastic hemiplegia and hemiparesis affecting unspecified side',
        'short': 'Spstc hmiplga unspf side'},
       {'code': '342.11',
        'long': 'Spastic hemiplegia and hemiparesis affecting dominant side',
        'short': 'Spstc hmiplga domnt side'},
       {'code': '342.12',
        'long': 'Spastic hemiplegia and hemiparesis affecting nondominant side',
        'short': 'Spstc hmiplg nondmnt sde'},
       {'code': '342.80',
        'long': 'Other specified hemiplegia and hemiparesis affecting unspecified side',
        'short': 'Ot sp hmiplga unspf side'},
       {'code': '342.81',
        'long': 'Other specified hemiplegia and hemiparesis affecting dominant side',
        'short': 'Ot sp hmiplga domnt side'},
       {'code': '342.82',
        'long': 'Other specified hemiplegia and hemiparesis affecting nondominant side',
        'short': 'Ot sp hmiplg nondmnt sde'},
       {'code': '342.90',
        'long': 'Hemiplegia, unspecified, affecting unspecified side',
        'short': 'Unsp hemiplga unspf side'},
       {'code': '342.91',
        'long': 'Hemiplegia, unspecified, affecting dominant side',
        'short': 'Unsp hemiplga domnt side'},
       {'code': '342.92',
        'long': 'Hemiplegia, unspecified, affecting nondominant side',
        'short': 'Unsp hmiplga nondmnt sde'},
       {'code': '343.0',
        'long': 'Congenital diplegia',
        'short': 'Congenital diplegia'},
       {'code': '343.1',
        'long': 'Congenital hemiplegia',
        'short': 'Congenital hemiplegia'},
       {'code': '343.2',
        'long': 'Congenital quadriplegia',
        'short': 'Congenital quadriplegia'},
       {'code': '343.3',
        'long': 'Congenital monoplegia',
        'short': 'Congenital monoplegia'},
       {'code': '343.4',
        'long': 'Infantile hemiplegia',
        'short': 'Infantile hemiplegia'},
       {'code': '343.8',
        'long': 'Other specified infantile cerebral palsy',
        'short': 'Cerebral palsy NEC'},
       {'code': '343.9',
        'long': 'Infantile cerebral palsy, unspecified',
        'short': 'Cerebral palsy NOS'},
       {'code': '344.00',
        'long': 'Quadriplegia, unspecified',
        'short': 'Quadriplegia, unspecifd'},
       {'code': '344.01',
        'long': 'Quadriplegia, C1-C4, complete',
        'short': 'Quadrplg c1-c4, complete'},
       {'code': '344.02',
        'long': 'Quadriplegia, C1-C4, incomplete',
        'short': 'Quadrplg c1-c4, incomplt'},
       {'code': '344.03',
        'long': 'Quadriplegia, C5-C7, complete',
        'short': 'Quadrplg c5-c7, complete'},
       {'code': '344.04',
        'long': 'Quadriplegia, C5-C7, incomplete',
        'short': 'Quadrplg c5-c7, incomplt'},
       {'code': '344.09',
        'long': 'Other quadriplegia',
        'short': 'Other quadriplegia'},
       {'code': '344.1', 'long': 'Paraplegia', 'short': 'Paraplegia NOS'},
       {'code': '344.2',
        'long': 'Diplegia of upper limbs',
        'short': 'Diplegia of upper limbs'},
       {'code': '344.30',
        'long': 'Monoplegia of lower limb affecting unspecified side',
        'short': 'Monplga lwr lmb unsp sde'},
       {'code': '344.31',
        'long': 'Monoplegia of lower limb affecting dominant side',
        'short': 'Monplga lwr lmb dmnt sde'},
       {'code': '344.32',
        'long': 'Monoplegia of lower limb affecting nondominant side',
        'short': 'Mnplg lwr lmb nondmnt sd'},
       {'code': '344.40',
        'long': 'Monoplegia of upper limb affecting unspecified side',
        'short': 'Monplga upr lmb unsp sde'},
       {'code': '344.41',
        'long': 'Monoplegia of upper limb affecting dominant side',
        'short': 'Monplga upr lmb dmnt sde'},
       {'code': '344.42',
        'long': 'Monoplegia of upper limb affecting nondominant sde',
        'short': 'Mnplg upr lmb nondmnt sd'},
       {'code': '344.5',
        'long': 'Unspecified monoplegia',
        'short': 'Monoplegia NOS'},
       {'code': '344.60',
        'long': 'Cauda equina syndrome without mention of neurogenic bladder',
        'short': 'Cauda equina synd NOS'},
       {'code': '344.61',
        'long': 'Cauda equina syndrome with neurogenic bladder',
        'short': 'Neurogenic bladder'},
       {'code': '344.81',
        'long': 'Locked-in state',
        'short': 'Locked-in state'},
       {'code': '344.89',
        'long': 'Other specified paralytic syndrome',
        'short': 'Oth spcf paralytic synd'},
       {'code': '344.9',
        'long': 'Paralysis, unspecified',
        'short': 'Paralysis NOS'},
       {'code': '345.00',
        'long': 'Generalized nonconvulsive epilepsy, without mention of intractable epilepsy',
        'short': 'Gen noncv ep w/o intr ep'},
       {'code': '345.01',
        'long': 'Generalized nonconvulsive epilepsy, with intractable epilepsy',
        'short': 'Gen nonconv ep w intr ep'},
       {'code': '345.10',
        'long': 'Generalized convulsive epilepsy, without mention of intractable epilepsy',
        'short': 'Gen cnv epil w/o intr ep'},
       {'code': '345.11',
        'long': 'Generalized convulsive epilepsy, with intractable epilepsy',
        'short': 'Gen cnv epil w intr epil'},
       {'code': '345.2',
        'long': 'Petit mal status',
        'short': 'Petit mal status'},
       {'code': '345.3',
        'long': 'Grand mal status',
        'short': 'Grand mal status'},
       {'code': '345.40',
        'long': 'Localization-related (focal) (partial) epilepsy and epileptic syndromes with complex partial seizures, without mention of intractable epilepsy',
        'short': 'Psymotr epil w/o int epi'},
       {'code': '345.41',
        'long': 'Localization-related (focal) (partial) epilepsy and epileptic syndromes with complex partial seizures, with intractable epilepsy',
        'short': 'Psymotr epil w intr epil'},
       {'code': '345.50',
        'long': 'Localization-related (focal) (partial) epilepsy and epileptic syndromes with simple partial seizures, without mention of intractable epilepsy',
        'short': 'Part epil w/o intr epil'},
       {'code': '345.51',
        'long': 'Localization-related (focal) (partial) epilepsy and epileptic syndromes with simple partial seizures, with intractable epilepsy',
        'short': 'Part epil w intr epil'},
       {'code': '345.60',
        'long': 'Infantile spasms, without mention of intractable epilepsy',
        'short': 'Inf spasm w/o intr epil'},
       {'code': '345.61',
        'long': 'Infantile spasms, with intractable epilepsy',
        'short': 'Inf spasm w intract epil'},
       {'code': '345.70',
        'long': 'Epilepsia partialis continua, without mention of intractable epilepsy',
        'short': 'Epil par cont w/o int ep'},
       {'code': '345.71',
        'long': 'Epilepsia partialis continua, with intractable epilepsy',
        'short': 'Epil par cont w intr epi'},
       {'code': '345.80',
        'long': 'Other forms of epilepsy and recurrent seizures, without mention of intractable epilepsy',
        'short': 'Epilep NEC w/o intr epil'},
       {'code': '345.81',
        'long': 'Other forms of epilepsy and recurrent seizures, with intractable epilepsy',
        'short': 'Epilepsy NEC w intr epil'},
       {'code': '345.90',
        'long': 'Epilepsy, unspecified, without mention of intractable epilepsy',
        'short': 'Epilep NOS w/o intr epil'},
       {'code': '345.91',
        'long': 'Epilepsy, unspecified, with intractable epilepsy',
        'short': 'Epilepsy NOS w intr epil'},
       {'code': '346.00',
        'long': 'Migraine with aura, without mention of intractable migraine without mention of status migrainosus',
        'short': 'Mgrn w aura wo ntrc mgrn'},
       {'code': '346.01',
        'long': 'Migraine with aura, with intractable migraine, so stated, without mention of status migrainosus',
        'short': 'Mgrn w aura w ntrc mgrn'},
       {'code': '346.02',
        'long': 'Migraine with aura, without mention of intractable migraine with status migrainosus',
        'short': 'Mgrn w aur wo ntrc mgrn'},
       {'code': '346.03',
        'long': 'Migraine with aura, with intractable migraine, so stated, with status migrainosus',
        'short': 'Mgrn w aura w ntrc mgrn'},
       {'code': '346.10',
        'long': 'Migraine without aura, without mention of intractable migraine without mention of status migrainosus',
        'short': 'Mgrn wo aura wo ntrc mgr'},
       {'code': '346.11',
        'long': 'Migraine without aura, with intractable migraine, so stated, without mention of status migrainosus',
        'short': 'Mgrn wo aura w ntrc mgrn'},
       {'code': '346.12',
        'long': 'Migraine without aura, without mention of intractable migraine with status migrainosus',
        'short': 'Mgrn wo aura wo ntrc mgr'},
       {'code': '346.13',
        'long': 'Migraine without aura, with intractable migraine, so stated, with status migrainosus',
        'short': 'Mgrn wo aura w ntrc mgrn'},
       {'code': '346.20',
        'long': 'Variants of migraine, not elsewhere classified, without mention of intractable migraine without mention of status migrainosus',
        'short': 'Vrnt mgrn wo ntr mgr NEC'},
       {'code': '346.21',
        'long': 'Variants of migraine, not elsewhere classified, with intractable migraine, so stated, without mention of status migrainosus',
        'short': 'Vrnt mgrn w ntrc mgr NEC'},
       {'code': '346.22',
        'long': 'Variants of migraine, not elsewhere classified, without mention of intractable migraine with status migrainosus',
        'short': 'Var mgr NEC wo ntc mgr'},
       {'code': '346.23',
        'long': 'Variants of migraine, not elsewhere classified, with intractable migraine, so stated, with status migrainosus',
        'short': 'Var mgrn NEC w ntrc mgr'},
       {'code': '346.30',
        'long': 'Hemiplegic migraine, without mention of intractable migraine without mention of status migrainosus',
        'short': 'Hmplg mgr wo ntrc wo st'},
       {'code': '346.31',
        'long': 'Hemiplegic migraine, with intractable migraine, so stated, without mention of status migrainosus',
        'short': 'Hmplg mgrn w ntrc wo st'},
       {'code': '346.32',
        'long': 'Hemiplegic migraine, without mention of intractable migraine with status migrainosus',
        'short': 'Hemplg mgr wo ntrc w st'},
       {'code': '346.33',
        'long': 'Hemiplegic migraine, with intractable migraine, so stated, with status migrainosus',
        'short': 'Hmplg mgrn w ntrc w st'},
       {'code': '346.40',
        'long': 'Menstrual migraine, without mention of intractable migraine without mention of status migrainosus',
        'short': 'Menst mgr wo ntrc wo st'},
       {'code': '346.41',
        'long': 'Menstrual migraine, with intractable migraine, so stated, without mention of status migrainosus',
        'short': 'Menstl mgrn w ntrc wo st'},
       {'code': '346.42',
        'long': 'Menstrual migraine, without mention of intractable migraine with status migrainosus',
        'short': 'Menstl mgr wo ntrc w st'},
       {'code': '346.43',
        'long': 'Menstrual migraine, with intractable migraine, so stated, with status migrainosus',
        'short': 'Menstl mgrn w ntrc w st'},
       {'code': '346.50',
        'long': 'Persistent migraine aura without cerebral infarction, without mention of intractable migraine without mention of status migrainosus',
        'short': 'Prst aura wo inf/ntr/st'},
       {'code': '346.51',
        'long': 'Persistent migraine aura without cerebral infarction, with intractable migraine, so stated, without mention of status migrainosus',
        'short': 'Prs ara w ntr wo inf/st'},
       {'code': '346.52',
        'long': 'Persistent migraine aura without cerebral infarction, without mention of intractable migraine with status migrainosus',
        'short': 'Prs ara wo inf/ntr w st'},
       {'code': '346.53',
        'long': 'Persistent migraine aura without cerebral infarction, with intractable migraine, so stated, with status migrainosus',
        'short': 'Prs ara wo inf w ntr/st'},
       {'code': '346.60',
        'long': 'Persistent migraine aura with cerebral infarction, without mention of intractable migraine without mention of status migrainosus',
        'short': 'Prs ara w inf wo ntr/st'},
       {'code': '346.61',
        'long': 'Persistent migraine aura with cerebral infarction, with intractable migraine, so stated, without mention of status migrainosus',
        'short': 'Prs ara w/inf/ntr wo st'},
       {'code': '346.62',
        'long': 'Persistent migraine aura with cerebral infarction, without mention of intractable migraine with status migrainosus',
        'short': 'Prs ara wo ntr w inf/st'},
       {'code': '346.63',
        'long': 'Persistent migraine aura with cerebral infarction, with intractable migraine, so stated, with status migrainosus',
        'short': 'Prst ara w inf w ntr/st'},
       {'code': '346.70',
        'long': 'Chronic migraine without aura, without mention of intractable migraine without mention of status migrainosus',
        'short': 'Ch mgr wo ar wo nt wo st'},
       {'code': '346.71',
        'long': 'Chronic migraine without aura, with intractable migraine, so stated, without mention of status migrainosus',
        'short': 'Ch mgr wo ara w nt wo st'},
       {'code': '346.72',
        'long': 'Chronic migraine without aura, without mention of intractable migraine with status migrainosus',
        'short': 'Ch mgr wo ara wo nt w st'},
       {'code': '346.73',
        'long': 'Chronic migraine without aura, with intractable migraine, so stated, with status migrainosus',
        'short': 'Ch mgr wo ara w ntr w st'},
       {'code': '346.80',
        'long': 'Other forms of migraine, without mention of intractable migraine without mention of status migrainosus',
        'short': 'Othr migrne wo ntrc mgrn'},
       {'code': '346.81',
        'long': 'Other forms of migraine, with intractable migraine, so stated, without mention of status migrainosus',
        'short': 'Othr migrne w ntrc mgrne'},
       {'code': '346.82',
        'long': 'Other forms of migraine, without mention of intractable migraine with status migrainosus',
        'short': 'Oth mgr wo ntrc w st mgr'},
       {'code': '346.83',
        'long': 'Other forms of migraine, with intractable migraine, so stated, with status migrainosus',
        'short': 'Oth mgr w ntrc w st mgr'},
       {'code': '346.90',
        'long': 'Migraine, unspecified, without mention of intractable migraine without mention of status migrainosus',
        'short': 'Migrne unsp wo ntrc mgrn'},
       {'code': '346.91',
        'long': 'Migraine, unspecified, with intractable migraine, so stated, without mention of status migrainosus',
        'short': 'Mgrn unsp w ntrc mgr std'},
       {'code': '346.92',
        'long': 'Migraine, unspecified, without mention of intractable migraine with status migrainosus',
        'short': 'Mgr NOS wo ntrc w st mgr'},
       {'code': '346.93',
        'long': 'Migraine, unspecified, with intractable migraine, so stated, with status migrainosus',
        'short': 'Mgrn NOS w ntrc w st mgr'},
       {'code': '347.00',
        'long': 'Narcolepsy, without cataplexy',
        'short': 'Narcolepsy w/o cataplexy'},
       {'code': '347.01',
        'long': 'Narcolepsy, with cataplexy',
        'short': 'Narcolepsy w cataplexy'},
       {'code': '347.10',
        'long': 'Narcolepsy in conditions classified elsewhere, without cataplexy',
        'short': 'Narclpsy w/o cat oth dis'},
       {'code': '347.11',
        'long': 'Narcolepsy in conditions classified elsewhere, with cataplexy',
        'short': 'Narcolepsy w cat oth dis'},
       {'code': '348.0', 'long': 'Cerebral cysts', 'short': 'Cerebral cysts'},
       {'code': '348.1',
        'long': 'Anoxic brain damage',
        'short': 'Anoxic brain damage'},
       {'code': '348.2',
        'long': 'Benign intracranial hypertension',
        'short': 'Pseudotumor cerebri'},
       {'code': '348.30',
        'long': 'Encephalopathy, unspecified',
        'short': 'Encephalopathy NOS'},
       {'code': '348.31',
        'long': 'Metabolic encephalopathy',
        'short': 'Metabolic encephalopathy'},
       {'code': '348.39',
        'long': 'Other encephalopathy',
        'short': 'Encephalopathy NEC'},
       {'code': '348.4',
        'long': 'Compression of brain',
        'short': 'Compression of brain'},
       {'code': '348.5', 'long': 'Cerebral edema', 'short': 'Cerebral edema'},
       {'code': '348.81',
        'long': 'Temporal sclerosis',
        'short': 'Temporal sclerosis'},
       {'code': '348.82', 'long': 'Brain death', 'short': 'Brain death'},
       {'code': '348.89',
        'long': 'Other conditions of brain',
        'short': 'Brain conditions NEC'},
       {'code': '348.9',
        'long': 'Unspecified condition of brain',
        'short': 'Brain condition NOS'},
       {'code': '349.0',
        'long': 'Reaction to spinal or lumbar puncture',
        'short': 'Lumbar puncture reaction'},
       {'code': '349.1',
        'long': 'Nervous system complications from surgically implanted device',
        'short': 'Complication cns device'},
       {'code': '349.2',
        'long': 'Disorders of meninges, not elsewhere classified',
        'short': 'Disorder of meninges NEC'},
       {'code': '349.31',
        'long': 'Accidental puncture or laceration of dura during a procedure',
        'short': 'Accid punc/op lac dura'},
       {'code': '349.39',
        'long': 'Other dural tear',
        'short': 'Dural tear NEC'},
       {'code': '349.81',
        'long': 'Cerebrospinal fluid rhinorrhea',
        'short': 'Cerebrospinal rhinorrhea'},
       {'code': '349.82',
        'long': 'Toxic encephalopathy',
        'short': 'Toxic encephalopathy'},
       {'code': '349.89',
        'long': 'Other specified disorders of nervous system',
        'short': 'Cns disorder NEC'},
       {'code': '349.9',
        'long': 'Unspecified disorders of nervous system',
        'short': 'Cns disorder NOS'},
       {'code': '350.1',
        'long': 'Trigeminal neuralgia',
        'short': 'Trigeminal neuralgia'},
       {'code': '350.2',
        'long': 'Atypical face pain',
        'short': 'Atypical face pain'},
       {'code': '350.8',
        'long': 'Other specified trigeminal nerve disorders',
        'short': 'Trigeminal nerve dis NEC'},
       {'code': '350.9',
        'long': 'Trigeminal nerve disorder, unspecified',
        'short': 'Trigeminal nerve dis NOS'},
       {'code': '351.0', 'long': "Bell's palsy", 'short': "Bell's palsy"},
       {'code': '351.1',
        'long': 'Geniculate ganglionitis',
        'short': 'Geniculate ganglionitis'},
       {'code': '351.8',
        'long': 'Other facial nerve disorders',
        'short': 'Facial nerve dis NEC'},
       {'code': '351.9',
        'long': 'Facial nerve disorder, unspecified',
        'short': 'Facial nerve dis NOS'},
       {'code': '352.0',
        'long': 'Disorders of olfactory (1st) nerve',
        'short': 'Olfactory nerve disorder'},
       {'code': '352.1',
        'long': 'Glossopharyngeal neuralgia',
        'short': 'Glossopharyng neuralgia'},
       {'code': '352.2',
        'long': 'Other disorders of glossopharyngeal [9th] nerve',
        'short': 'Glossophar nerve dis NEC'},
       {'code': '352.3',
        'long': 'Disorders of pneumogastric [10th] nerve',
        'short': 'Pneumogastric nerve dis'},
       {'code': '352.4',
        'long': 'Disorders of accessory [11th] nerve',
        'short': 'Accessory nerve disorder'},
       {'code': '352.5',
        'long': 'Disorders of hypoglossal [12th] nerve',
        'short': 'Hypoglossal nerve dis'},
       {'code': '352.6',
        'long': 'Multiple cranial nerve palsies',
        'short': 'Mult cranial nerve palsy'},
       {'code': '352.9',
        'long': 'Unspecified disorder of cranial nerves',
        'short': 'Cranial nerve dis NOS'},
       {'code': '353.0',
        'long': 'Brachial plexus lesions',
        'short': 'Brachial plexus lesions'},
       {'code': '353.1',
        'long': 'Lumbosacral plexus lesions',
        'short': 'Lumbosacral plex lesion'},
       {'code': '353.2',
        'long': 'Cervical root lesions, not elsewhere classified',
        'short': 'Cervical root lesion NEC'},
       {'code': '353.3',
        'long': 'Thoracic root lesions, not elsewhere classified',
        'short': 'Thoracic root lesion NEC'},
       {'code': '353.4',
        'long': 'Lumbosacral root lesions, not elsewhere classified',
        'short': 'Lumbsacral root les NEC'},
       {'code': '353.5',
        'long': 'Neuralgic amyotrophy',
        'short': 'Neuralgic amyotrophy'},
       {'code': '353.6',
        'long': 'Phantom limb (syndrome)',
        'short': 'Phantom limb (syndrome)'},
       {'code': '353.8',
        'long': 'Other nerve root and plexus disorders',
        'short': 'Nerv root/plexus dis NEC'},
       {'code': '353.9',
        'long': 'Unspecified nerve root and plexus disorder',
        'short': 'Nerv root/plexus dis NOS'},
       {'code': '354.0',
        'long': 'Carpal tunnel syndrome',
        'short': 'Carpal tunnel syndrome'},
       {'code': '354.1',
        'long': 'Other lesion of median nerve',
        'short': 'Median nerve lesion NEC'},
       {'code': '354.2',
        'long': 'Lesion of ulnar nerve',
        'short': 'Ulnar nerve lesion'},
       {'code': '354.3',
        'long': 'Lesion of radial nerve',
        'short': 'Radial nerve lesion'},
       {'code': '354.4',
        'long': 'Causalgia of upper limb',
        'short': 'Causalgia upper limb'},
       {'code': '354.5',
        'long': 'Mononeuritis multiplex',
        'short': 'Mononeuritis multiplex'},
       {'code': '354.8',
        'long': 'Other mononeuritis of upper limb',
        'short': 'Mononeuritis arm NEC'},
       {'code': '354.9',
        'long': 'Mononeuritis of upper limb, unspecified',
        'short': 'Mononeuritis arm NOS'},
       {'code': '355.0',
        'long': 'Lesion of sciatic nerve',
        'short': 'Sciatic nerve lesion'},
       {'code': '355.1',
        'long': 'Meralgia paresthetica',
        'short': 'Meralgia paresthetica'},
       {'code': '355.2',
        'long': 'Other lesion of femoral nerve',
        'short': 'Femoral nerve lesion NEC'},
       {'code': '355.3',
        'long': 'Lesion of lateral popliteal nerve',
        'short': 'Lat popliteal nerve les'},
       {'code': '355.4',
        'long': 'Lesion of medial popliteal nerve',
        'short': 'Med popliteal nerve les'},
       {'code': '355.5',
        'long': 'Tarsal tunnel syndrome',
        'short': 'Tarsal tunnel syndrome'},
       {'code': '355.6',
        'long': 'Lesion of plantar nerve',
        'short': 'Plantar nerve lesion'},
       {'code': '355.71',
        'long': 'Causalgia of lower limb',
        'short': 'Causalgia lower limb'},
       {'code': '355.79',
        'long': 'Other mononeuritis of lower limb',
        'short': 'Oth mononeur lower limb'},
       {'code': '355.8',
        'long': 'Mononeuritis of lower limb, unspecified',
        'short': 'Mononeuritis leg NOS'},
       {'code': '355.9',
        'long': 'Mononeuritis of unspecified site',
        'short': 'Mononeuritis NOS'},
       {'code': '356.0',
        'long': 'Hereditary peripheral neuropathy',
        'short': 'Hered periph neuropathy'},
       {'code': '356.1',
        'long': 'Peroneal muscular atrophy',
        'short': 'Peroneal muscle atrophy'},
       {'code': '356.2',
        'long': 'Hereditary sensory neuropathy',
        'short': 'Hered sensory neuropathy'},
       {'code': '356.3',
        'long': "Refsum's disease",
        'short': "Refsum's disease"},
       {'code': '356.4',
        'long': 'Idiopathic progressive polyneuropathy',
        'short': 'Idio prog polyneuropathy'},
       {'code': '356.8',
        'long': 'Other specified idiopathic peripheral neuropathy',
        'short': 'Idio periph neurpthy NEC'},
       {'code': '356.9',
        'long': 'Unspecified hereditary and idiopathic peripheral neuropathy',
        'short': 'Idio periph neurpthy NOS'},
       {'code': '357.0',
        'long': 'Acute infective polyneuritis',
        'short': 'Ac infect polyneuritis'},
       {'code': '357.1',
        'long': 'Polyneuropathy in collagen vascular disease',
        'short': 'Neurpthy in col vasc dis'},
       {'code': '357.2',
        'long': 'Polyneuropathy in diabetes',
        'short': 'Neuropathy in diabetes'},
       {'code': '357.3',
        'long': 'Polyneuropathy in malignant disease',
        'short': 'Neuropathy in malig dis'},
       {'code': '357.4',
        'long': 'Polyneuropathy in other diseases classified elsewhere',
        'short': 'Neuropathy in other dis'},
       {'code': '357.5',
        'long': 'Alcoholic polyneuropathy',
        'short': 'Alcoholic polyneuropathy'},
       {'code': '357.6',
        'long': 'Polyneuropathy due to drugs',
        'short': 'Neuropathy due to drugs'},
       {'code': '357.7',
        'long': 'Polyneuropathy due to other toxic agents',
        'short': 'Neurpthy toxic agent NEC'},
       {'code': '357.81',
        'long': 'Chronic inflammatory demyelinating polyneuritis',
        'short': 'Chr inflam polyneuritis'},
       {'code': '357.82',
        'long': 'Critical illness polyneuropathy',
        'short': 'Crit illness neuropathy'},
       {'code': '357.89',
        'long': 'Other inflammatory and toxic neuropathy',
        'short': 'Inflam/tox neuropthy NEC'},
       {'code': '357.9',
        'long': 'Unspecified inflammatory and toxic neuropathy',
        'short': 'Inflam/tox neuropthy NOS'},
       {'code': '358.00',
        'long': 'Myasthenia gravis without (acute) exacerbation',
        'short': 'Mysthna grvs w/o ac exac'},
       {'code': '358.01',
        'long': 'Myasthenia gravis with (acute) exacerbation',
        'short': 'Myasthna gravs w ac exac'},
       {'code': '358.1',
        'long': 'Myasthenic syndromes in diseases classified elsewhere',
        'short': 'Myasthenia in oth dis'},
       {'code': '358.2',
        'long': 'Toxic myoneural disorders',
        'short': 'Toxic myoneural disorder'},
       {'code': '358.30',
        'long': 'Lambert-Eaton syndrome, unspecified',
        'short': 'Lambert-Eaton synd NOS'},
       {'code': '358.31',
        'long': 'Lambert-Eaton syndrome in neoplastic disease',
        'short': 'Lambert-Eaton synd neopl'},
       {'code': '358.39',
        'long': 'Lambert-Eaton syndrome in other diseases classified elsewhere',
        'short': 'Lambert-Eaton syn ot dis'},
       {'code': '358.8',
        'long': 'Other specified myoneural disorders',
        'short': 'Myoneural disorders NEC'},
       {'code': '358.9',
        'long': 'Myoneural disorders, unspecified',
        'short': 'Myoneural disorders NOS'},
       {'code': '359.0',
        'long': 'Congenital hereditary muscular dystrophy',
        'short': 'Cong hered musc dystrphy'},
       {'code': '359.1',
        'long': 'Hereditary progressive muscular dystrophy',
        'short': 'Hered prog musc dystrphy'},
       {'code': '359.21',
        'long': 'Myotonic muscular dystrophy',
        'short': 'Myotonic musclr dystrphy'},
       {'code': '359.22',
        'long': 'Myotonia congenita',
        'short': 'Myotonia congenita'},
       {'code': '359.23',
        'long': 'Myotonic chondrodystrophy',
        'short': 'Myotonic chondrodystrphy'},
       {'code': '359.24',
        'long': 'Drug- induced myotonia',
        'short': 'Drug induced myotonia'},
       {'code': '359.29',
        'long': 'Other specified myotonic disorder',
        'short': 'Myotonic disorder NEC'},
       {'code': '359.3',
        'long': 'Periodic paralysis',
        'short': 'Periodic paralysis'},
       {'code': '359.4', 'long': 'Toxic myopathy', 'short': 'Toxic myopathy'},
       {'code': '359.5',
        'long': 'Myopathy in endocrine diseases classified elsewhere',
        'short': 'Myopathy in endocrin dis'},
       {'code': '359.6',
        'long': 'Symptomatic inflammatory myopathy in diseases classified elsewhere',
        'short': 'Infl myopathy in oth dis'},
       {'code': '359.71',
        'long': 'Inclusion body myositis',
        'short': 'Inclusion body myositis'},
       {'code': '359.79',
        'long': 'Other inflammatory and immune myopathies, NEC',
        'short': 'Inflm/immune myopath NEC'},
       {'code': '359.81',
        'long': 'Critical illness myopathy',
        'short': 'Critical illness myopthy'},
       {'code': '359.89',
        'long': 'Other myopathies',
        'short': 'Myopathies NEC'},
       {'code': '359.9',
        'long': 'Myopathy, unspecified',
        'short': 'Myopathy NOS'}],
 'H': [{'code': '360.00',
        'long': 'Purulent endophthalmitis, unspecified',
        'short': 'Purulent endophthalm NOS'},
       {'code': '360.01',
        'long': 'Acute endophthalmitis',
        'short': 'Acute endophthalmitis'},
       {'code': '360.02',
        'long': 'Panophthalmitis',
        'short': 'Panophthalmitis'},
       {'code': '360.03',
        'long': 'Chronic endophthalmitis',
        'short': 'Chronic endophthalmitis'},
       {'code': '360.04',
        'long': 'Vitreous abscess',
        'short': 'Vitreous abscess'},
       {'code': '360.11',
        'long': 'Sympathetic uveitis',
        'short': 'Sympathetic uveitis'},
       {'code': '360.12', 'long': 'Panuveitis', 'short': 'Panuveitis'},
       {'code': '360.13',
        'long': 'Parasitic endophthalmitis NOS',
        'short': 'Parasitic endophthal NOS'},
       {'code': '360.14',
        'long': 'Ophthalmia nodosa',
        'short': 'Ophthalmia nodosa'},
       {'code': '360.19',
        'long': 'Other endophthalmitis',
        'short': 'Endophthalmitis NEC'},
       {'code': '360.20',
        'long': 'Degenerative disorder of globe, unspecified',
        'short': 'Degenerat globe dis NOS'},
       {'code': '360.21',
        'long': 'Progressive high (degenerative) myopia',
        'short': 'Progressive high myopia'},
       {'code': '360.23', 'long': 'Siderosis of globe', 'short': 'Siderosis'},
       {'code': '360.24',
        'long': 'Other metallosis of globe',
        'short': 'Other metallosis, eye'},
       {'code': '360.29',
        'long': 'Other degenerative disorders of globe',
        'short': 'Degenerative globe NEC'},
       {'code': '360.30',
        'long': 'Hypotony of eye, unspecified',
        'short': 'Hypotony NOS, eye'},
       {'code': '360.31',
        'long': 'Primary hypotony of eye',
        'short': 'Primary hypotony'},
       {'code': '360.32',
        'long': 'Ocular fistula causing hypotony',
        'short': 'Hypotony due to fistula'},
       {'code': '360.33',
        'long': 'Hypotony associated with other ocular disorders',
        'short': 'Hypotony w eye dis NEC'},
       {'code': '360.34',
        'long': 'Flat anterior chamber of eye',
        'short': 'Flat anterior chamber'},
       {'code': '360.40',
        'long': 'Degenerated globe or eye, unspecified',
        'short': 'Degeneration of eye NOS'},
       {'code': '360.41',
        'long': 'Blind hypotensive eye',
        'short': 'Blind hypotensive eye'},
       {'code': '360.42',
        'long': 'Blind hypertensive eye',
        'short': 'Blind hypertensive eye'},
       {'code': '360.43',
        'long': 'Hemophthalmos, except current injury',
        'short': 'Hemophthalmos'},
       {'code': '360.44', 'long': 'Leucocoria', 'short': 'Leucocoria'},
       {'code': '360.50',
        'long': 'Foreign body, magnetic, intraocular, unspecified',
        'short': 'Old magnet fb, eye NOS'},
       {'code': '360.51',
        'long': 'Foreign body, magnetic, in anterior chamber of eye',
        'short': 'Old magnet fb, ant chamb'},
       {'code': '360.52',
        'long': 'Foreign body, magnetic, in iris or ciliary body',
        'short': 'Old magnet fb, iris'},
       {'code': '360.53',
        'long': 'Foreign body, magnetic, in lens',
        'short': 'Old magnet fb, lens'},
       {'code': '360.54',
        'long': 'Foreign body, magnetic, in vitreous',
        'short': 'Old magnet fb, vitreous'},
       {'code': '360.55',
        'long': 'Foreign body, magnetic, in posterior wall',
        'short': 'Old magnet fb, post wall'},
       {'code': '360.59',
        'long': 'Intraocular foreign body, magnetic, in other or multiple sites',
        'short': 'Old magnet fb, eye NEC'},
       {'code': '360.60',
        'long': 'Foreign body, intraocular, unspecified',
        'short': 'Intraocular FB NOS'},
       {'code': '360.61',
        'long': 'Foreign body in anterior chamber',
        'short': 'FB in anterior chamber'},
       {'code': '360.62',
        'long': 'Foreign body in iris or ciliary body',
        'short': 'FB in iris or ciliary'},
       {'code': '360.63',
        'long': 'Foreign body in lens',
        'short': 'Foreign body in lens'},
       {'code': '360.64',
        'long': 'Foreign body in vitreous',
        'short': 'Foreign body in vitreous'},
       {'code': '360.65',
        'long': 'Foreign body in posterior wall of eye',
        'short': 'FB in posterior wall'},
       {'code': '360.69',
        'long': 'Intraocular foreign body in other or multiple sites',
        'short': 'Intraocular FB NEC'},
       {'code': '360.81',
        'long': 'Luxation of globe',
        'short': 'Luxation of globe'},
       {'code': '360.89',
        'long': 'Other disorders of globe',
        'short': 'Disorder of globe NEC'},
       {'code': '360.9',
        'long': 'Unspecified disorder of globe',
        'short': 'Disorder of globe NOS'},
       {'code': '361.00',
        'long': 'Retinal detachment with retinal defect, unspecified',
        'short': 'Detachmnt w defect NOS'},
       {'code': '361.01',
        'long': 'Recent retinal detachment, partial, with single defect',
        'short': 'Part detach-singl defec'},
       {'code': '361.02',
        'long': 'Recent retinal detachment, partial, with multiple defects',
        'short': 'Part detach-mult defect'},
       {'code': '361.03',
        'long': 'Recent retinal detachment, partial, with giant tear',
        'short': 'Part detach-giant tear'},
       {'code': '361.04',
        'long': 'Recent retinal detachment, partial, with retinal dialysis',
        'short': 'Part detach-dialysis'},
       {'code': '361.05',
        'long': 'Recent retinal detachment, total or subtotal',
        'short': 'Recent detachment, total'},
       {'code': '361.06',
        'long': 'Old retinal detachment, partial',
        'short': 'Old detachment, partial'},
       {'code': '361.07',
        'long': 'Old retinal detachment, total or subtotal',
        'short': 'Old detachment, total'},
       {'code': '361.10',
        'long': 'Retinoschisis, unspecified',
        'short': 'Retinoschisis NOS'},
       {'code': '361.11',
        'long': 'Flat retinoschisis',
        'short': 'Flat retinoschisis'},
       {'code': '361.12',
        'long': 'Bullous retinoschisis',
        'short': 'Bullous retinoschisis'},
       {'code': '361.13',
        'long': 'Primary retinal cysts',
        'short': 'Primary retinal cysts'},
       {'code': '361.14',
        'long': 'Secondary retinal cysts',
        'short': 'Secondary retinal cysts'},
       {'code': '361.19',
        'long': 'Other retinoschisis and retinal cysts',
        'short': 'Retinoshisis or cyst NEC'},
       {'code': '361.2',
        'long': 'Serous retinal detachment',
        'short': 'Serous retina detachment'},
       {'code': '361.30',
        'long': 'Retinal defect, unspecified',
        'short': 'Retinal defect NOS'},
       {'code': '361.31',
        'long': 'Round hole of retina without detachment',
        'short': 'Round hole of retina'},
       {'code': '361.32',
        'long': 'Horseshoe tear of retina without detachment',
        'short': 'Horseshoe tear of retina'},
       {'code': '361.33',
        'long': 'Multiple defects of retina without detachment',
        'short': 'Mult defects of retina'},
       {'code': '361.81',
        'long': 'Traction detachment of retina',
        'short': 'Retinal traction detach'},
       {'code': '361.89',
        'long': 'Other forms of retinal detachment',
        'short': 'Retinal detachment NEC'},
       {'code': '361.9',
        'long': 'Unspecified retinal detachment',
        'short': 'Retinal detachment NOS'},
       {'code': '362.01',
        'long': 'Background diabetic retinopathy',
        'short': 'Diabetic retinopathy NOS'},
       {'code': '362.02',
        'long': 'Proliferative diabetic retinopathy',
        'short': 'Prolif diab retinopathy'},
       {'code': '362.03',
        'long': 'Nonproliferative diabetic retinopathy NOS',
        'short': 'Nonprolf db retnoph NOS'},
       {'code': '362.04',
        'long': 'Mild nonproliferative diabetic retinopathy',
        'short': 'Mild nonprolf db retnoph'},
       {'code': '362.05',
        'long': 'Moderate nonproliferative diabetic retinopathy',
        'short': 'Mod nonprolf db retinoph'},
       {'code': '362.06',
        'long': 'Severe nonproliferative diabetic retinopathy',
        'short': 'Sev nonprolf db retinoph'},
       {'code': '362.07',
        'long': 'Diabetic macular edema',
        'short': 'Diabetic macular edema'},
       {'code': '362.10',
        'long': 'Background retinopathy, unspecified',
        'short': 'Backgrnd retinopathy NOS'},
       {'code': '362.11',
        'long': 'Hypertensive retinopathy',
        'short': 'Hypertensive retinopathy'},
       {'code': '362.12',
        'long': 'Exudative retinopathy',
        'short': 'Exudative retinopathy'},
       {'code': '362.13',
        'long': 'Changes in vascular appearance of retina',
        'short': 'Retinal vascular changes'},
       {'code': '362.14',
        'long': 'Retinal microaneurysms NOS',
        'short': 'Retina microaneurysm NOS'},
       {'code': '362.15',
        'long': 'Retinal telangiectasia',
        'short': 'Retinal telangiectasia'},
       {'code': '362.16',
        'long': 'Retinal neovascularization NOS',
        'short': 'Retinal neovascular NOS'},
       {'code': '362.17',
        'long': 'Other intraretinal microvascular abnormalities',
        'short': 'Retinal varices'},
       {'code': '362.18',
        'long': 'Retinal vasculitis',
        'short': 'Retinal vasculitis'},
       {'code': '362.20',
        'long': 'Retinopathy of prematurity, unspecified',
        'short': 'Retinoph prematurity NOS'},
       {'code': '362.21',
        'long': 'Retrolental fibroplasia',
        'short': 'Retrolental fibroplasia'},
       {'code': '362.22',
        'long': 'Retinopathy of prematurity, stage 0',
        'short': 'Retinoph prematr,stage 0'},
       {'code': '362.23',
        'long': 'Retinopathy of prematurity, stage 1',
        'short': 'Retinoph prematr,stage 1'},
       {'code': '362.24',
        'long': 'Retinopathy of prematurity, stage 2',
        'short': 'Retinoph prematr,stage 2'},
       {'code': '362.25',
        'long': 'Retinopathy of prematurity, stage 3',
        'short': 'Retinoph prematr,stage 3'},
       {'code': '362.26',
        'long': 'Retinopathy of prematurity, stage 4',
        'short': 'Retinoph prematr.stage 4'},
       {'code': '362.27',
        'long': 'Retinopathy of prematurity, stage 5',
        'short': 'Retinoph prematr,stage 5'},
       {'code': '362.29',
        'long': 'Other nondiabetic proliferative retinopathy',
        'short': 'Prolif retinopathy NEC'},
       {'code': '362.30',
        'long': 'Retinal vascular occlusion, unspecified',
        'short': 'Retinal vasc occlus NOS'},
       {'code': '362.31',
        'long': 'Central retinal artery occlusion',
        'short': 'Cent retina artery occlu'},
       {'code': '362.32',
        'long': 'Retinal arterial branch occlusion',
        'short': 'Arterial branch occlus'},
       {'code': '362.33',
        'long': 'Partial retinal arterial occlusion',
        'short': 'Part arterial occlusion'},
       {'code': '362.34',
        'long': 'Transient retinal arterial occlusion',
        'short': 'Transient arterial occlu'},
       {'code': '362.35',
        'long': 'Central retinal vein occlusion',
        'short': 'Cent retinal vein occlus'},
       {'code': '362.36',
        'long': 'Venous tributary (branch) occlusion',
        'short': 'Venous tributary occlus'},
       {'code': '362.37',
        'long': 'Venous engorgement',
        'short': 'Retina venous engorgemnt'},
       {'code': '362.40',
        'long': 'Retinal layer separation, unspecified',
        'short': 'Retina layer separat NOS'},
       {'code': '362.41',
        'long': 'Central serous retinopathy',
        'short': 'Cent serous retinopathy'},
       {'code': '362.42',
        'long': 'Serous detachment of retinal pigment epithelium',
        'short': 'Serous detach pigm epith'},
       {'code': '362.43',
        'long': 'Hemorrhagic detachment of retinal pigment epithelium',
        'short': 'Hem detach pigmnt epith'},
       {'code': '362.50',
        'long': 'Macular degeneration (senile), unspecified',
        'short': 'Macular degeneration NOS'},
       {'code': '362.51',
        'long': 'Nonexudative senile macular degeneration',
        'short': 'Nonexudat macular degen'},
       {'code': '362.52',
        'long': 'Exudative senile macular degeneration',
        'short': 'Exudative macular degen'},
       {'code': '362.53',
        'long': 'Cystoid macular degeneration',
        'short': 'Cystoid macular degen'},
       {'code': '362.54',
        'long': 'Macular cyst, hole, or pseudohole',
        'short': 'Macular cyst or hole'},
       {'code': '362.55',
        'long': 'Toxic maculopathy',
        'short': 'Toxic maculopathy'},
       {'code': '362.56',
        'long': 'Macular puckering',
        'short': 'Macular puckering'},
       {'code': '362.57',
        'long': 'Drusen (degenerative)',
        'short': 'Drusen (degenerative)'},
       {'code': '362.60',
        'long': 'Peripheral retinal degeneration, unspecified',
        'short': 'Periph retina degen NOS'},
       {'code': '362.61',
        'long': 'Paving stone degeneration',
        'short': 'Paving stone degenerat'},
       {'code': '362.62',
        'long': 'Microcystoid degeneration',
        'short': 'Microcystoid degenerat'},
       {'code': '362.63',
        'long': 'Lattice degeneration',
        'short': 'Lattice degeneration'},
       {'code': '362.64',
        'long': 'Senile reticular degeneration',
        'short': 'Senile reticular degen'},
       {'code': '362.65',
        'long': 'Secondary pigmentary degeneration',
        'short': 'Secondry pigment degen'},
       {'code': '362.66',
        'long': 'Secondary vitreoretinal degenerations',
        'short': 'Sec vitreoretina degen'},
       {'code': '362.70',
        'long': 'Hereditary retinal dystrophy, unspecified',
        'short': 'Hered retin dystrphy NOS'},
       {'code': '362.71',
        'long': 'Retinal dystrophy in systemic or cerebroretinal lipidoses',
        'short': 'Ret dystrph in lipidoses'},
       {'code': '362.72',
        'long': 'Retinal dystrophy in other systemic disorders and syndromes',
        'short': 'Ret dystrph in syst dis'},
       {'code': '362.73',
        'long': 'Vitreoretinal dystrophies',
        'short': 'Vitreoretinal dystrophy'},
       {'code': '362.74',
        'long': 'Pigmentary retinal dystrophy',
        'short': 'Pigment retina dystrophy'},
       {'code': '362.75',
        'long': 'Other dystrophies primarily involving the sensory retina',
        'short': 'Sensory retina dystrophy'},
       {'code': '362.76',
        'long': 'Dystrophies primarily involving the retinal pigment epithelium',
        'short': 'Vitelliform dystrophy'},
       {'code': '362.77',
        'long': "Dystrophies primarily involving Bruch's membrane",
        'short': 'Bruch membrane dystrophy'},
       {'code': '362.81',
        'long': 'Retinal hemorrhage',
        'short': 'Retinal hemorrhage'},
       {'code': '362.82',
        'long': 'Retinal exudates and deposits',
        'short': 'Retina exudates/deposits'},
       {'code': '362.83', 'long': 'Retinal edema', 'short': 'Retinal edema'},
       {'code': '362.84',
        'long': 'Retinal ischemia',
        'short': 'Retinal ischemia'},
       {'code': '362.85',
        'long': 'Retinal nerve fiber bundle defects',
        'short': 'Retinal nerv fiber defec'},
       {'code': '362.89',
        'long': 'Other retinal disorders',
        'short': 'Retinal disorders NEC'},
       {'code': '362.9',
        'long': 'Unspecified retinal disorder',
        'short': 'Retinal disorder NOS'},
       {'code': '363.00',
        'long': 'Focal chorioretinitis, unspecified',
        'short': 'Focal chorioretinit NOS'},
       {'code': '363.01',
        'long': 'Focal choroiditis and chorioretinitis, juxtapapillary',
        'short': 'Juxtapap foc choroiditis'},
       {'code': '363.03',
        'long': 'Focal choroiditis and chorioretinitis of other posterior pole',
        'short': 'Foc choroiditis post NEC'},
       {'code': '363.04',
        'long': 'Focal choroiditis and chorioretinitis, peripheral',
        'short': 'Periph focal choroiditis'},
       {'code': '363.05',
        'long': 'Focal retinitis and retinochoroiditis, juxtapapillary',
        'short': 'Juxtapap focal retinitis'},
       {'code': '363.06',
        'long': 'Focal retinitis and retinochoroiditis, macular or paramacular',
        'short': 'Macular focal retinitis'},
       {'code': '363.07',
        'long': 'Focal retinitis and retinochoroiditis of other posterior pole',
        'short': 'Foc retinitis post NEC'},
       {'code': '363.08',
        'long': 'Focal retinitis and retinochoroiditis, peripheral',
        'short': 'Periph focal retinitis'},
       {'code': '363.10',
        'long': 'Disseminated chorioretinitis, unspecified',
        'short': 'Dissem chorioretinit NOS'},
       {'code': '363.11',
        'long': 'Disseminated choroiditis and chorioretinitis, posterior pole',
        'short': 'Dissem choroiditis, post'},
       {'code': '363.12',
        'long': 'Disseminated choroiditis and chorioretinitis, peripheral',
        'short': 'Periph disem choroiditis'},
       {'code': '363.13',
        'long': 'Disseminated choroiditis and chorioretinitis, generalized',
        'short': 'Gen dissem choroiditis'},
       {'code': '363.14',
        'long': 'Disseminated retinitis and retinochoroiditis, metastatic',
        'short': 'Metastat dissem retinit'},
       {'code': '363.15',
        'long': 'Disseminated retinitis and retinochoroiditis, pigment epitheliopathy',
        'short': 'Pigment epitheliopathy'},
       {'code': '363.20',
        'long': 'Chorioretinitis, unspecified',
        'short': 'Chorioretinitis NOS'},
       {'code': '363.21', 'long': 'Pars planitis', 'short': 'Pars planitis'},
       {'code': '363.22',
        'long': "Harada's disease",
        'short': "Harada's disease"},
       {'code': '363.30',
        'long': 'Chorioretinal scar, unspecified',
        'short': 'Chorioretinal scar NOS'},
       {'code': '363.31',
        'long': 'Solar retinopathy',
        'short': 'Solar retinopathy'},
       {'code': '363.32',
        'long': 'Other macular scars',
        'short': 'Macular scars NEC'},
       {'code': '363.33',
        'long': 'Other scars of posterior pole',
        'short': 'Posterior pole scar NEC'},
       {'code': '363.34',
        'long': 'Peripheral scars',
        'short': 'Peripheral retinal scars'},
       {'code': '363.35',
        'long': 'Disseminated scars',
        'short': 'Disseminated retina scar'},
       {'code': '363.40',
        'long': 'Choroidal degeneration, unspecified',
        'short': 'Choroidal degen NOS'},
       {'code': '363.41',
        'long': 'Senile atrophy of choroid',
        'short': 'Senile atrophy, choroid'},
       {'code': '363.42',
        'long': 'Diffuse secondary atrophy of choroid',
        'short': 'Difus sec atroph choroid'},
       {'code': '363.43',
        'long': 'Angioid streaks of choroid',
        'short': 'Angioid streaks, choroid'},
       {'code': '363.50',
        'long': 'Hereditary choroidal dystrophy or atrophy, unspecified',
        'short': 'Hered choroid atroph NOS'},
       {'code': '363.51',
        'long': 'Circumpapillary dystrophy of choroid, partial',
        'short': 'Prt circmpap choroid dys'},
       {'code': '363.52',
        'long': 'Circumpapillary dystrophy of choroid, total',
        'short': 'Tot circmpap choroid dys'},
       {'code': '363.53',
        'long': 'Central dystrophy of choroid, partial',
        'short': 'Part cent choroid dystr'},
       {'code': '363.54',
        'long': 'Central choroidal atrophy, total',
        'short': 'Tot cent choroid atrophy'},
       {'code': '363.55', 'long': 'Choroideremia', 'short': 'Choroideremia'},
       {'code': '363.56',
        'long': 'Other diffuse or generalized dystrophy of choroid, partial',
        'short': 'Prt gen choroid dyst NEC'},
       {'code': '363.57',
        'long': 'Other diffuse or generalized dystrophy of choroid, total',
        'short': 'Tot gen choroid dyst NEC'},
       {'code': '363.61',
        'long': 'Choroidal hemorrhage, unspecified',
        'short': 'Choroidal hemorrhage NOS'},
       {'code': '363.62',
        'long': 'Expulsive choroidal hemorrhage',
        'short': 'Expulsive choroid hemorr'},
       {'code': '363.63',
        'long': 'Choroidal rupture',
        'short': 'Choroidal rupture'},
       {'code': '363.70',
        'long': 'Choroidal detachment, unspecified',
        'short': 'Choroidal detachment NOS'},
       {'code': '363.71',
        'long': 'Serous choroidal detachment',
        'short': 'Serous choroid detachmnt'},
       {'code': '363.72',
        'long': 'Hemorrhagic choroidal detachment',
        'short': 'Hemorr choroid detachmnt'},
       {'code': '363.8',
        'long': 'Other disorders of choroid',
        'short': 'Disorders of choroid NEC'},
       {'code': '363.9',
        'long': 'Unspecified disorder of choroid',
        'short': 'Choroidal disorder NOS'},
       {'code': '364.00',
        'long': 'Acute and subacute iridocyclitis, unspecified',
        'short': 'Acute iridocyclitis NOS'},
       {'code': '364.01',
        'long': 'Primary iridocyclitis',
        'short': 'Primary iridocyclitis'},
       {'code': '364.02',
        'long': 'Recurrent iridocyclitis',
        'short': 'Recurrent iridocyclitis'},
       {'code': '364.03',
        'long': 'Secondary iridocyclitis, infectious',
        'short': 'Secondry iritis, infect'},
       {'code': '364.04',
        'long': 'Secondary iridocyclitis, noninfectious',
        'short': 'Second iritis, noninfec'},
       {'code': '364.05', 'long': 'Hypopyon', 'short': 'Hypopyon'},
       {'code': '364.10',
        'long': 'Chronic iridocyclitis, unspecified',
        'short': 'Chr iridocyclitis NOS'},
       {'code': '364.11',
        'long': 'Chronic iridocyclitis in diseases classified elsewhere',
        'short': 'Chr iridocyl in oth dis'},
       {'code': '364.21',
        'long': "Fuchs' heterochromic cyclitis",
        'short': 'Fuch hetrochrom cyclitis'},
       {'code': '364.22',
        'long': 'Glaucomatocyclitic crises',
        'short': 'Glaucomatocyclit crises'},
       {'code': '364.23',
        'long': 'Lens-induced iridocyclitis',
        'short': 'Lens-induced iridocyclit'},
       {'code': '364.24',
        'long': 'Vogt-koyanagi syndrome',
        'short': 'Vogt-koyanagi syndrome'},
       {'code': '364.3',
        'long': 'Unspecified iridocyclitis',
        'short': 'Iridocyclitis NOS'},
       {'code': '364.41',
        'long': 'Hyphema of iris and ciliary body',
        'short': 'Hyphema'},
       {'code': '364.42',
        'long': 'Rubeosis iridis',
        'short': 'Rubeosis iridis'},
       {'code': '364.51',
        'long': 'Essential or progressive iris atrophy',
        'short': 'Progressive iris atrophy'},
       {'code': '364.52', 'long': 'Iridoschisis', 'short': 'Iridoschisis'},
       {'code': '364.53',
        'long': 'Pigmentary iris degeneration',
        'short': 'Pigment iris degenerat'},
       {'code': '364.54',
        'long': 'Degeneration of pupillary margin',
        'short': 'Pupillary margin degen'},
       {'code': '364.55',
        'long': 'Miotic cysts of pupillary margin',
        'short': 'Miotic cyst pupil margin'},
       {'code': '364.56',
        'long': 'Degenerative changes of chamber angle',
        'short': 'Degen chamber angle'},
       {'code': '364.57',
        'long': 'Degenerative changes of ciliary body',
        'short': 'Degen ciliary body'},
       {'code': '364.59',
        'long': 'Other iris atrophy',
        'short': 'Iris atrophy NEC'},
       {'code': '364.60',
        'long': 'Idiopathic cysts of iris, ciliary body, and anterior chamber',
        'short': 'Idiopathic cysts'},
       {'code': '364.61',
        'long': 'Implantation cysts of iris, ciliary body, and anterior chamber',
        'short': 'Implantation cysts'},
       {'code': '364.62',
        'long': 'Exudative cysts of iris or anterior chamber',
        'short': 'Exud cyst iris/ant chamb'},
       {'code': '364.63',
        'long': 'Primary cyst of pars plana',
        'short': 'Primary cyst pars plana'},
       {'code': '364.64',
        'long': 'Exudative cyst of pars plana',
        'short': 'Exudat cyst pars plana'},
       {'code': '364.70',
        'long': 'Adhesions of iris, unspecified',
        'short': 'Adhesions of iris NOS'},
       {'code': '364.71',
        'long': 'Posterior synechiae of iris',
        'short': 'Posterior synechiae'},
       {'code': '364.72',
        'long': 'Anterior synechiae of iris',
        'short': 'Anterior synechiae'},
       {'code': '364.73',
        'long': 'Goniosynechiae',
        'short': 'Goniosynechiae'},
       {'code': '364.74',
        'long': 'Adhesions and disruptions of pupillary membranes',
        'short': 'Pupillary membranes'},
       {'code': '364.75',
        'long': 'Pupillary abnormalities',
        'short': 'Pupillary abnormalities'},
       {'code': '364.76', 'long': 'Iridodialysis', 'short': 'Iridodialysis'},
       {'code': '364.77',
        'long': 'Recession of chamber angle of eye',
        'short': 'Recession, chamber angle'},
       {'code': '364.81',
        'long': 'Floppy iris syndrome',
        'short': 'Floppy iris syndrome'},
       {'code': '364.82',
        'long': 'Plateau iris syndrome',
        'short': 'Plateau iris syndrome'},
       {'code': '364.89',
        'long': 'Other disorders of iris and ciliary body',
        'short': 'Iris/ciliary disord NEC'},
       {'code': '364.9',
        'long': 'Unspecified disorder of iris and ciliary body',
        'short': 'Iris/ciliary dis NOS'},
       {'code': '365.00',
        'long': 'Preglaucoma, unspecified',
        'short': 'Preglaucoma NOS'},
       {'code': '365.01',
        'long': 'Open angle with borderline findings, low risk',
        'short': 'Opn angl brderln lo risk'},
       {'code': '365.02',
        'long': 'Anatomical narrow angle borderline glaucoma',
        'short': 'Anatomical narrow angle'},
       {'code': '365.03',
        'long': 'Steroid responders borderline glaucoma',
        'short': 'Steroid responders'},
       {'code': '365.04',
        'long': 'Ocular hypertension',
        'short': 'Ocular hypertension'},
       {'code': '365.05',
        'long': 'Open angle with borderline findings, high risk',
        'short': 'Opn ang w brdrlne hi rsk'},
       {'code': '365.06',
        'long': 'Primary angle closure without glaucoma damage',
        'short': 'Prim angle clos w/o dmg'},
       {'code': '365.10',
        'long': 'Open-angle glaucoma, unspecified',
        'short': 'Open-angle glaucoma NOS'},
       {'code': '365.11',
        'long': 'Primary open angle glaucoma',
        'short': 'Prim open angle glaucoma'},
       {'code': '365.12',
        'long': 'Low tension open-angle glaucoma',
        'short': 'Low tension glaucoma'},
       {'code': '365.13',
        'long': 'Pigmentary open-angle glaucoma',
        'short': 'Pigmentary glaucoma'},
       {'code': '365.14',
        'long': 'Glaucoma of childhood',
        'short': 'Glaucoma of childhood'},
       {'code': '365.15',
        'long': 'Residual stage of open angle glaucoma',
        'short': 'Residual opn ang glaucma'},
       {'code': '365.20',
        'long': 'Primary angle-closure glaucoma, unspecified',
        'short': 'Prim angl-clos glauc NOS'},
       {'code': '365.21',
        'long': 'Intermittent angle-closure glaucoma',
        'short': 'Intermit angl-clos glauc'},
       {'code': '365.22',
        'long': 'Acute angle-closure glaucoma',
        'short': 'Acute angl-clos glaucoma'},
       {'code': '365.23',
        'long': 'Chronic angle-closure glaucoma',
        'short': 'Chr angle-clos glaucoma'},
       {'code': '365.24',
        'long': 'Residual stage of angle-closure glaucoma',
        'short': 'Residual angl-clos glauc'},
       {'code': '365.31',
        'long': 'Corticosteroid-induced glaucoma, glaucomatous stage',
        'short': 'Glauc stage-ster induced'},
       {'code': '365.32',
        'long': 'Corticosteroid-induced glaucoma, residual stage',
        'short': 'Glauc resid-ster induced'},
       {'code': '365.41',
        'long': 'Glaucoma associated with chamber angle anomalies',
        'short': 'Glauc w chamb angle anom'},
       {'code': '365.42',
        'long': 'Glaucoma associated with anomalies of iris',
        'short': 'Glaucoma w iris anomaly'},
       {'code': '365.43',
        'long': 'Glaucoma associated with other anterior segment anomalies',
        'short': 'Glauc w ant seg anom NEC'},
       {'code': '365.44',
        'long': 'Glaucoma associated with systemic syndromes',
        'short': 'Glaucoma w systemic synd'},
       {'code': '365.51',
        'long': 'Phacolytic glaucoma',
        'short': 'Phacolytic glaucoma'},
       {'code': '365.52',
        'long': 'Pseudoexfoliation glaucoma',
        'short': 'Pseudoexfoliat glaucoma'},
       {'code': '365.59',
        'long': 'Glaucoma associated with other lens disorders',
        'short': 'Glaucoma w lens dis NEC'},
       {'code': '365.60',
        'long': 'Glaucoma associated with unspecified ocular disorder',
        'short': 'Glauc w ocular dis NOS'},
       {'code': '365.61',
        'long': 'Glaucoma associated with pupillary block',
        'short': 'Glauc w pupillary block'},
       {'code': '365.62',
        'long': 'Glaucoma associated with ocular inflammations',
        'short': 'Glaucoma w ocular inflam'},
       {'code': '365.63',
        'long': 'Glaucoma associated with vascular disorders',
        'short': 'Glaucoma w vascular dis'},
       {'code': '365.64',
        'long': 'Glaucoma associated with tumors or cysts',
        'short': 'Glaucoma w tumor or cyst'},
       {'code': '365.65',
        'long': 'Glaucoma associated with ocular trauma',
        'short': 'Glaucoma w ocular trauma'},
       {'code': '365.70',
        'long': 'Glaucoma stage, unspecified',
        'short': 'Glaucoma stage NOS'},
       {'code': '365.71',
        'long': 'Mild stage glaucoma',
        'short': 'Mild stage glaucoma'},
       {'code': '365.72',
        'long': 'Moderate stage glaucoma',
        'short': 'Moderate stage glaucoma'},
       {'code': '365.73',
        'long': 'Severe stage glaucoma',
        'short': 'Severe stage glaucoma'},
       {'code': '365.74',
        'long': 'Indeterminate stage glaucoma',
        'short': 'Indeterm stage glaucoma'},
       {'code': '365.81',
        'long': 'Hypersecretion glaucoma',
        'short': 'Hypersecretion glaucoma'},
       {'code': '365.82',
        'long': 'Glaucoma with increased episcleral venous pressure',
        'short': 'Glauc w inc episcl press'},
       {'code': '365.83',
        'long': 'Aqueous misdirection',
        'short': 'Aqueous misdirection'},
       {'code': '365.89',
        'long': 'Other specified glaucoma',
        'short': 'Glaucoma NEC'},
       {'code': '365.9',
        'long': 'Unspecified glaucoma',
        'short': 'Glaucoma NOS'},
       {'code': '366.00',
        'long': 'Nonsenile cataract, unspecified',
        'short': 'Nonsenile cataract NOS'},
       {'code': '366.01',
        'long': 'Anterior subcapsular polar cataract',
        'short': 'Ant subcaps pol cataract'},
       {'code': '366.02',
        'long': 'Posterior subcapsular polar cataract',
        'short': 'Post subcaps pol catarct'},
       {'code': '366.03',
        'long': 'Cortical, lamellar, or zonular cataract',
        'short': 'Cortical cataract'},
       {'code': '366.04',
        'long': 'Nuclear cataract',
        'short': 'Nuclear cataract'},
       {'code': '366.09',
        'long': 'Other and combined forms of nonsenile cataract',
        'short': 'Nonsenile cataract NEC'},
       {'code': '366.10',
        'long': 'Senile cataract, unspecified',
        'short': 'Senile cataract NOS'},
       {'code': '366.11',
        'long': 'Pseudoexfoliation of lens capsule',
        'short': 'Pseudoexfol lens capsule'},
       {'code': '366.12',
        'long': 'Incipient senile cataract',
        'short': 'Incipient cataract'},
       {'code': '366.13',
        'long': 'Anterior subcapsular polar senile cataract',
        'short': 'Ant subcaps senile catar'},
       {'code': '366.14',
        'long': 'Posterior subcapsular polar senile cataract',
        'short': 'Post subcap senile catar'},
       {'code': '366.15',
        'long': 'Cortical senile cataract',
        'short': 'Cortical senile cataract'},
       {'code': '366.16',
        'long': 'Senile nuclear sclerosis',
        'short': 'Senile nuclear cataract'},
       {'code': '366.17',
        'long': 'Total or mature cataract',
        'short': 'Mature cataract'},
       {'code': '366.18',
        'long': 'Hypermature cataract',
        'short': 'Hypermature cataract'},
       {'code': '366.19',
        'long': 'Other and combined forms of senile cataract',
        'short': 'Senile cataract NEC'},
       {'code': '366.20',
        'long': 'Traumatic cataract, unspecified',
        'short': 'Traumatic cataract NOS'},
       {'code': '366.21',
        'long': 'Localized traumatic opacities',
        'short': 'Local traumatic opacity'},
       {'code': '366.22',
        'long': 'Total traumatic cataract',
        'short': 'Total traumatic cataract'},
       {'code': '366.23',
        'long': 'Partially resolved traumatic cataract',
        'short': 'Part resolv traum catar'},
       {'code': '366.30',
        'long': 'Cataracta complicata, unspecified',
        'short': 'Cataracta complicata NOS'},
       {'code': '366.31',
        'long': 'Glaucomatous flecks (subcapsular)',
        'short': 'Glaucomatous flecks'},
       {'code': '366.32',
        'long': 'Cataract in inflammatory ocular disorders',
        'short': 'Cataract in inflam dis'},
       {'code': '366.33',
        'long': 'Cataract with neovascularization',
        'short': 'Cataract w neovasculizat'},
       {'code': '366.34',
        'long': 'Cataract in degenerative ocular disorders',
        'short': 'Cataract in degen dis'},
       {'code': '366.41',
        'long': 'Diabetic cataract',
        'short': 'Diabetic cataract'},
       {'code': '366.42',
        'long': 'Tetanic cataract',
        'short': 'Tetanic cataract'},
       {'code': '366.43',
        'long': 'Myotonic cataract',
        'short': 'Myotonic cataract'},
       {'code': '366.44',
        'long': 'Cataract associated with other syndromes',
        'short': 'Cataract w syndrome NEC'},
       {'code': '366.45',
        'long': 'Toxic cataract',
        'short': 'Toxic cataract'},
       {'code': '366.46',
        'long': 'Cataract associated with radiation and other physical influences',
        'short': 'Cataract w radiation'},
       {'code': '366.50',
        'long': 'After-cataract, unspecified',
        'short': 'After-cataract NOS'},
       {'code': '366.51',
        'long': "Soemmering's ring",
        'short': "Soemmering's ring"},
       {'code': '366.52',
        'long': 'Other after-cataract, not obscuring vision',
        'short': 'After-cataract NEC'},
       {'code': '366.53',
        'long': 'After-cataract, obscuring vision',
        'short': 'Aftr-catar obscur vision'},
       {'code': '366.8', 'long': 'Other cataract', 'short': 'Cataract NEC'},
       {'code': '366.9',
        'long': 'Unspecified cataract',
        'short': 'Cataract NOS'},
       {'code': '367.0', 'long': 'Hypermetropia', 'short': 'Hypermetropia'},
       {'code': '367.1', 'long': 'Myopia', 'short': 'Myopia'},
       {'code': '367.20',
        'long': 'Astigmatism, unspecified',
        'short': 'Astigmatism NOS'},
       {'code': '367.21',
        'long': 'Regular astigmatism',
        'short': 'Regular astigmatism'},
       {'code': '367.22',
        'long': 'Irregular astigmatism',
        'short': 'Irregular astigmatism'},
       {'code': '367.31', 'long': 'Anisometropia', 'short': 'Anisometropia'},
       {'code': '367.32', 'long': 'Aniseikonia', 'short': 'Aniseikonia'},
       {'code': '367.4', 'long': 'Presbyopia', 'short': 'Presbyopia'},
       {'code': '367.51',
        'long': 'Paresis of accommodation',
        'short': 'Paresis of accommodation'},
       {'code': '367.52',
        'long': 'Total or complete internal ophthalmoplegia',
        'short': 'Tot intern ophthalmopleg'},
       {'code': '367.53',
        'long': 'Spasm of accommodation',
        'short': 'Spasm of accommodation'},
       {'code': '367.81',
        'long': 'Transient refractive change',
        'short': 'Transient refract change'},
       {'code': '367.89',
        'long': 'Other disorders of refraction and accommodation',
        'short': 'Refraction disorder NEC'},
       {'code': '367.9',
        'long': 'Unspecified disorder of refraction and accommodation',
        'short': 'Refraction disorder NOS'},
       {'code': '368.00',
        'long': 'Amblyopia, unspecified',
        'short': 'Amblyopia NOS'},
       {'code': '368.01',
        'long': 'Strabismic amblyopia',
        'short': 'Strabismic amblyopia'},
       {'code': '368.02',
        'long': 'Deprivation amblyopia',
        'short': 'Deprivation amblyopia'},
       {'code': '368.03',
        'long': 'Refractive amblyopia',
        'short': 'Refractive amblyopia'},
       {'code': '368.10',
        'long': 'Subjective visual disturbance, unspecified',
        'short': 'Subj visual disturb NOS'},
       {'code': '368.11',
        'long': 'Sudden visual loss',
        'short': 'Sudden visual loss'},
       {'code': '368.12',
        'long': 'Transient visual loss',
        'short': 'Transient visual loss'},
       {'code': '368.13',
        'long': 'Visual discomfort',
        'short': 'Visual discomfort'},
       {'code': '368.14',
        'long': 'Visual distortions of shape and size',
        'short': 'Distortion of shape/size'},
       {'code': '368.15',
        'long': 'Other visual distortions and entoptic phenomena',
        'short': 'Visual distortions NEC'},
       {'code': '368.16',
        'long': 'Psychophysical visual disturbances',
        'short': 'Psychophysic visual dist'},
       {'code': '368.2', 'long': 'Diplopia', 'short': 'Diplopia'},
       {'code': '368.30',
        'long': 'Binocular vision disorder, unspecified',
        'short': 'Binocular vision dis NOS'},
       {'code': '368.31',
        'long': 'Suppression of binocular vision',
        'short': 'Binocular vis suppress'},
       {'code': '368.32',
        'long': 'Simultaneous visual perception without fusion',
        'short': 'Visual percept w/o fusn'},
       {'code': '368.33',
        'long': 'Fusion with defective stereopsis',
        'short': 'Fusion w def stereopsis'},
       {'code': '368.34',
        'long': 'Abnormal retinal correspondence',
        'short': 'Abn retina correspond'},
       {'code': '368.40',
        'long': 'Visual field defect, unspecified',
        'short': 'Visual field defect NOS'},
       {'code': '368.41',
        'long': 'Scotoma involving central area',
        'short': 'Central scotoma'},
       {'code': '368.42',
        'long': 'Scotoma of blind spot area',
        'short': 'Scotoma of blind spot'},
       {'code': '368.43',
        'long': 'Sector or arcuate visual field defects',
        'short': 'Sector or arcuate defect'},
       {'code': '368.44',
        'long': 'Other localized visual field defect',
        'short': 'Visual field defect NEC'},
       {'code': '368.45',
        'long': 'Generalized visual field contraction or constriction',
        'short': 'Gen visual contraction'},
       {'code': '368.46',
        'long': 'Homonymous bilateral field defects',
        'short': 'Homonymous hemianopsia'},
       {'code': '368.47',
        'long': 'Heteronymous bilateral field defects',
        'short': 'Heteronymous hemianopsia'},
       {'code': '368.51', 'long': 'Protan defect', 'short': 'Protan defect'},
       {'code': '368.52', 'long': 'Deutan defect', 'short': 'Deutan defect'},
       {'code': '368.53', 'long': 'Tritan defect', 'short': 'Tritan defect'},
       {'code': '368.54', 'long': 'Achromatopsia', 'short': 'Achromatopsia'},
       {'code': '368.55',
        'long': 'Acquired color vision deficiencies',
        'short': 'Acq color deficiency'},
       {'code': '368.59',
        'long': 'Other color vision deficiencies',
        'short': 'Color deficiency NEC'},
       {'code': '368.60',
        'long': 'Night blindness, unspecified',
        'short': 'Night blindness NOS'},
       {'code': '368.61',
        'long': 'Congenital night blindness',
        'short': 'Congen night blindness'},
       {'code': '368.62',
        'long': 'Acquired night blindness',
        'short': 'Acquired night blindness'},
       {'code': '368.63',
        'long': 'Abnormal dark adaptation curve',
        'short': 'Abn dark adaptat curve'},
       {'code': '368.69',
        'long': 'Other night blindness',
        'short': 'Night blindness NEC'},
       {'code': '368.8',
        'long': 'Other specified visual disturbances',
        'short': 'Visual disturbances NEC'},
       {'code': '368.9',
        'long': 'Unspecified visual disturbance',
        'short': 'Visual disturbance NOS'},
       {'code': '369.00',
        'long': 'Profound impairment, both eyes, impairment level not further specified',
        'short': 'Both eyes blind-who def'},
       {'code': '369.01',
        'long': 'Better eye: total vision impairment; lesser eye: total vision impairment',
        'short': 'Tot impairment-both eyes'},
       {'code': '369.02',
        'long': 'Better eye: near-total vision impairment; lesser eye: not further specified',
        'short': 'One eye-near tot/oth-NOS'},
       {'code': '369.03',
        'long': 'Better eye: near-total vision impairment; lesser eye: total vision impairment',
        'short': 'One eye-near tot/oth-tot'},
       {'code': '369.04',
        'long': 'Better eye: near-total vision impairment; lesser eye: near-total vision impairment',
        'short': 'Near-tot impair-both eye'},
       {'code': '369.05',
        'long': 'Better eye: profound vision impairment; lesser eye: not further specified',
        'short': 'One eye-profound/oth-NOS'},
       {'code': '369.06',
        'long': 'Better eye: profound vision impairment; lesser eye: total vision impairment',
        'short': 'One eye-profound/oth-tot'},
       {'code': '369.07',
        'long': 'Better eye: profound vision impairment; lesser eye: near-total vision impairment',
        'short': 'One eye-prfnd/oth-nr tot'},
       {'code': '369.08',
        'long': 'Better eye: profound vision impairment; lesser eye: profound vision impairment',
        'short': 'Profound impair both eye'},
       {'code': '369.10',
        'long': 'Moderate or severe impairment, better eye, impairment level not further specified',
        'short': 'Blindness/low vision'},
       {'code': '369.11',
        'long': 'Better eye: severe vision impairment; lesser eye: blind, not further specified',
        'short': '1 eye-sev/oth-blind NOS'},
       {'code': '369.12',
        'long': 'Better eye: severe vision impairment; lesser eye: total vision impairment',
        'short': 'One eye-severe/oth-total'},
       {'code': '369.13',
        'long': 'Better eye: severe vision impairment; lesser eye: near-total vision impairment',
        'short': 'One eye-sev/oth-near tot'},
       {'code': '369.14',
        'long': 'Better eye: severe vision impairment; lesser eye: profound vision impairment',
        'short': 'One eye-sev/oth-prfnd'},
       {'code': '369.15',
        'long': 'Better eye: moderate vision impairment; lesser eye: blind, not further specified',
        'short': 'One eye-mod/oth-blind'},
       {'code': '369.16',
        'long': 'Better eye: moderate vision impairment; lesser eye: total vision impairment',
        'short': 'One eye-moderate/oth-tot'},
       {'code': '369.17',
        'long': 'Better eye: moderate vision impairment; lesser eye: near-total vision impairment',
        'short': 'One eye-mod/oth-near tot'},
       {'code': '369.18',
        'long': 'Better eye: moderate vision impairment; lesser eye: profound vision impairment',
        'short': 'One eye-mod/oth-profound'},
       {'code': '369.20',
        'long': 'Moderate or severe impairment, both eyes, impairment level not further specified',
        'short': 'Low vision, 2 eyes NOS'},
       {'code': '369.21',
        'long': 'Better eye: severe vision impairment; lesser eye; impairment not further specified',
        'short': 'One eye-severe/oth-NOS'},
       {'code': '369.22',
        'long': 'Better eye: severe vision impairment; lesser eye: severe vision impairment',
        'short': 'Severe impair-both eyes'},
       {'code': '369.23',
        'long': 'Better eye: moderate vision impairment; lesser eye: impairment not further specified',
        'short': 'One eye-moderate/oth-NOS'},
       {'code': '369.24',
        'long': 'Better eye: moderate vision impairment; lesser eye: severe vision impairment',
        'short': 'One eye-moderate/oth-sev'},
       {'code': '369.25',
        'long': 'Better eye: moderate vision impairment; lesser eye: moderate vision impairment',
        'short': 'Moderate impair-both eye'},
       {'code': '369.3',
        'long': 'Unqualified visual loss, both eyes',
        'short': 'Blindness NOS, both eyes'},
       {'code': '369.4',
        'long': 'Legal blindness, as defined in U.S.A.',
        'short': 'Legal blindness-usa def'},
       {'code': '369.60',
        'long': 'Profound impairment, one eye, impairment level not further specified',
        'short': 'Blindness, one eye'},
       {'code': '369.61',
        'long': 'One eye: total vision impairment; other eye: not specified',
        'short': 'One eye-total/oth-unknwn'},
       {'code': '369.62',
        'long': 'One eye: total vision impairment; other eye: near-normal vision',
        'short': 'One eye-tot/oth-near nor'},
       {'code': '369.63',
        'long': 'One eye: total vision impairment; other eye: normal vision',
        'short': 'One eye-total/oth-normal'},
       {'code': '369.64',
        'long': 'One eye: near-total vision impairment; other eye: vision not specified',
        'short': 'One eye-near tot/oth-NOS'},
       {'code': '369.65',
        'long': 'One eye: near-total vision impairment; other eye: near-normal vision',
        'short': 'Near-tot imp/near-normal'},
       {'code': '369.66',
        'long': 'One eye: near-total vision impairment; other eye: normal vision',
        'short': 'Near-total impair/normal'},
       {'code': '369.67',
        'long': 'One eye: profound vision impairment; other eye: vision not specified',
        'short': 'One eye-prfound/oth-unkn'},
       {'code': '369.68',
        'long': 'One eye: profound vision impairment; other eye: near-normal vision',
        'short': 'Profnd impair/near norm'},
       {'code': '369.69',
        'long': 'One eye: profound vision impairment; other eye: normal vision',
        'short': 'Profound impair/normal'},
       {'code': '369.70',
        'long': 'Moderate or severe impairment, one eye, impairment level not further specified',
        'short': 'Low vision, one eye'},
       {'code': '369.71',
        'long': 'One eye: severe vision impairment; other eye: vision not specified',
        'short': 'One eye-severe/oth-unknw'},
       {'code': '369.72',
        'long': 'One eye: severe vision impairment; other eye: near-normal vision',
        'short': 'One eye-sev/oth-nr norm'},
       {'code': '369.73',
        'long': 'One eye: severe vision impairment; other eye: normal vision',
        'short': 'One eye-severe/oth-norm'},
       {'code': '369.74',
        'long': 'One eye: moderate vision impairment; other eye: vision not specified',
        'short': 'One eye-mod/other-unknwn'},
       {'code': '369.75',
        'long': 'One eye: moderate vision impairment; other eye: near-normal vision',
        'short': 'One eye-mod/oth-nr norm'},
       {'code': '369.76',
        'long': 'One eye: moderate vision impairment; other eye: normal vision',
        'short': 'One eye-mod/oth normal'},
       {'code': '369.8',
        'long': 'Unqualified visual loss, one eye',
        'short': 'Visual loss, one eye NOS'},
       {'code': '369.9',
        'long': 'Unspecified visual loss',
        'short': 'Visual loss NOS'},
       {'code': '370.00',
        'long': 'Corneal ulcer, unspecified',
        'short': 'Corneal ulcer NOS'},
       {'code': '370.01',
        'long': 'Marginal corneal ulcer',
        'short': 'Marginal corneal ulcer'},
       {'code': '370.02',
        'long': 'Ring corneal ulcer',
        'short': 'Ring corneal ulcer'},
       {'code': '370.03',
        'long': 'Central corneal ulcer',
        'short': 'Central corneal ulcer'},
       {'code': '370.04',
        'long': 'Hypopyon ulcer',
        'short': 'Hypopyon ulcer'},
       {'code': '370.05',
        'long': 'Mycotic corneal ulcer',
        'short': 'Mycotic corneal ulcer'},
       {'code': '370.06',
        'long': 'Perforated corneal ulcer',
        'short': 'Perforated corneal ulcer'},
       {'code': '370.07',
        'long': "Mooren's ulcer",
        'short': "Mooren's ulcer"},
       {'code': '370.20',
        'long': 'Superficial keratitis, unspecified',
        'short': 'Superfic keratitis NOS'},
       {'code': '370.21',
        'long': 'Punctate keratitis',
        'short': 'Punctate keratitis'},
       {'code': '370.22',
        'long': 'Macular keratitis',
        'short': 'Macular keratitis'},
       {'code': '370.23',
        'long': 'Filamentary keratitis',
        'short': 'Filamentary keratitis'},
       {'code': '370.24',
        'long': 'Photokeratitis',
        'short': 'Photokeratitis'},
       {'code': '370.31',
        'long': 'Phlyctenular keratoconjunctivitis',
        'short': 'Phlycten keratoconjunct'},
       {'code': '370.32',
        'long': 'Limbar and corneal involvement in vernal conjunctivitis',
        'short': 'Limbar keratoconjunctiv'},
       {'code': '370.33',
        'long': "Keratoconjunctivitis sicca, not specified as Sjogren's",
        'short': 'Keratoconjunctivit sicca'},
       {'code': '370.34',
        'long': 'Exposure keratoconjunctivitis',
        'short': 'Expsure keratoconjunctiv'},
       {'code': '370.35',
        'long': 'Neurotrophic keratoconjunctivitis',
        'short': 'Neurotroph keratoconjunc'},
       {'code': '370.40',
        'long': 'Keratoconjunctivitis, unspecified',
        'short': 'Keratoconjunctivitis NOS'},
       {'code': '370.44',
        'long': 'Keratitis or keratoconjunctivitis in exanthema',
        'short': 'Keratitis in exanthema'},
       {'code': '370.49',
        'long': 'Other keratoconjunctivitis',
        'short': 'Keratoconjunctivitis NEC'},
       {'code': '370.50',
        'long': 'Interstitial keratitis, unspecified',
        'short': 'Interstit keratitis NOS'},
       {'code': '370.52',
        'long': 'Diffuse interstitial keratitis',
        'short': 'Diffus interstit keratit'},
       {'code': '370.54',
        'long': 'Sclerosing keratitis',
        'short': 'Sclerosing keratitis'},
       {'code': '370.55',
        'long': 'Corneal abscess',
        'short': 'Corneal abscess'},
       {'code': '370.59',
        'long': 'Other interstitial and deep keratitis',
        'short': 'Interstit keratitis NEC'},
       {'code': '370.60',
        'long': 'Corneal neovascularization, unspecified',
        'short': 'Cornea neovasculariz NOS'},
       {'code': '370.61',
        'long': 'Localized vascularization of cornea',
        'short': 'Local vasculariza cornea'},
       {'code': '370.62',
        'long': 'Pannus (corneal)',
        'short': 'Corneal pannus'},
       {'code': '370.63',
        'long': 'Deep vascularization of cornea',
        'short': 'Deep vasculariza cornea'},
       {'code': '370.64',
        'long': 'Ghost vessels (corneal)',
        'short': 'Corneal ghost vessels'},
       {'code': '370.8',
        'long': 'Other forms of keratitis',
        'short': 'Keratitis NEC'},
       {'code': '370.9',
        'long': 'Unspecified keratitis',
        'short': 'Keratitis NOS'},
       {'code': '371.00',
        'long': 'Corneal opacity, unspecified',
        'short': 'Corneal opacity NOS'},
       {'code': '371.01',
        'long': 'Minor opacity of cornea',
        'short': 'Minor opacity of cornea'},
       {'code': '371.02',
        'long': 'Peripheral opacity of cornea',
        'short': 'Periph opacity of cornea'},
       {'code': '371.03',
        'long': 'Central opacity of cornea',
        'short': 'Central opacity, cornea'},
       {'code': '371.04',
        'long': 'Adherent leucoma',
        'short': 'Adherent leucoma'},
       {'code': '371.05',
        'long': 'Phthisical cornea',
        'short': 'Phthisical cornea'},
       {'code': '371.10',
        'long': 'Corneal deposit, unspecified',
        'short': 'Corneal deposit NOS'},
       {'code': '371.11',
        'long': 'Anterior corneal pigmentations',
        'short': 'Ant cornea pigmentation'},
       {'code': '371.12',
        'long': 'Stromal corneal pigmentations',
        'short': 'Stromal cornea pigment'},
       {'code': '371.13',
        'long': 'Posterior corneal pigmentations',
        'short': 'Post cornea pigmentation'},
       {'code': '371.14',
        'long': 'Kayser-Fleischer ring',
        'short': 'Kayser-fleischer ring'},
       {'code': '371.15',
        'long': 'Other corneal deposits associated with metabolic disorders',
        'short': 'Oth deposit w metab dis'},
       {'code': '371.16',
        'long': 'Argentous corneal deposits',
        'short': 'Argentous cornea deposit'},
       {'code': '371.20',
        'long': 'Corneal edema, unspecified',
        'short': 'Corneal edema NOS'},
       {'code': '371.21',
        'long': 'Idiopathic corneal edema',
        'short': 'Idiopathic corneal edema'},
       {'code': '371.22',
        'long': 'Secondary corneal edema',
        'short': 'Secondary corneal edema'},
       {'code': '371.23',
        'long': 'Bullous keratopathy',
        'short': 'Bullous keratopathy'},
       {'code': '371.24',
        'long': 'Corneal edema due to wearing of contact lenses',
        'short': 'Edema d/t contact lens'},
       {'code': '371.30',
        'long': 'Corneal membrane change, unspecified',
        'short': 'Cornea memb change NOS'},
       {'code': '371.31',
        'long': "Folds and rupture of bowman's membrane",
        'short': 'Fold of bowman membrane'},
       {'code': '371.32',
        'long': "Folds in descemet's membrane",
        'short': 'Fold in descemet membran'},
       {'code': '371.33',
        'long': "Rupture in descemet's membrane",
        'short': 'Rupture descemet membran'},
       {'code': '371.40',
        'long': 'Corneal degeneration, unspecified',
        'short': 'Corneal degeneration NOS'},
       {'code': '371.41',
        'long': 'Senile corneal changes',
        'short': 'Senile corneal changes'},
       {'code': '371.42',
        'long': 'Recurrent erosion of cornea',
        'short': 'Recurrent cornea erosion'},
       {'code': '371.43',
        'long': 'Band-shaped keratopathy',
        'short': 'Band-shaped keratopathy'},
       {'code': '371.44',
        'long': 'Other calcerous degenerations of cornea',
        'short': 'Calcer cornea degen NEC'},
       {'code': '371.45',
        'long': 'Keratomalacia NOS',
        'short': 'Keratomalacia NOS'},
       {'code': '371.46',
        'long': 'Nodular degeneration of cornea',
        'short': 'Nodular cornea degen'},
       {'code': '371.48',
        'long': 'Peripheral degenerations of cornea',
        'short': 'Peripheral cornea degen'},
       {'code': '371.49',
        'long': 'Other corneal degenerations',
        'short': 'Cornea degeneration NEC'},
       {'code': '371.50',
        'long': 'Hereditary corneal dystrophy, unspecified',
        'short': 'Corneal dystrophy NOS'},
       {'code': '371.51',
        'long': 'Juvenile epithelial corneal dystrophy',
        'short': 'Juv epith cornea dystrph'},
       {'code': '371.52',
        'long': 'Other anterior corneal dystrophies',
        'short': 'Ant cornea dystrophy NEC'},
       {'code': '371.53',
        'long': 'Granular corneal dystrophy',
        'short': 'Granular cornea dystrphy'},
       {'code': '371.54',
        'long': 'Lattice corneal dystrophy',
        'short': 'Lattice cornea dystrophy'},
       {'code': '371.55',
        'long': 'Macular corneal dystrophy',
        'short': 'Macular cornea dystrophy'},
       {'code': '371.56',
        'long': 'Other stromal corneal dystrophies',
        'short': 'Strom cornea dystrph NEC'},
       {'code': '371.57',
        'long': 'Endothelial corneal dystrophy',
        'short': 'Endothel cornea dystrphy'},
       {'code': '371.58',
        'long': 'Other posterior corneal dystrophies',
        'short': 'Post cornea dystrphy NEC'},
       {'code': '371.60',
        'long': 'Keratoconus, unspecified',
        'short': 'Keratoconus NOS'},
       {'code': '371.61',
        'long': 'Keratoconus, stable condition',
        'short': 'Keratoconus, stable'},
       {'code': '371.62',
        'long': 'Keratoconus, acute hydrops',
        'short': 'Keratoconus, ac hydrops'},
       {'code': '371.70',
        'long': 'Corneal deformity, unspecified',
        'short': 'Corneal deformity NOS'},
       {'code': '371.71',
        'long': 'Corneal ectasia',
        'short': 'Corneal ectasia'},
       {'code': '371.72', 'long': 'Descemetocele', 'short': 'Descemetocele'},
       {'code': '371.73',
        'long': 'Corneal staphyloma',
        'short': 'Corneal staphyloma'},
       {'code': '371.81',
        'long': 'Corneal anesthesia and hypoesthesia',
        'short': 'Corneal anesthesia'},
       {'code': '371.82',
        'long': 'Corneal disorder due to contact lens',
        'short': 'Corneal dsdr contct lens'},
       {'code': '371.89',
        'long': 'Other corneal disorders',
        'short': 'Corneal disorder NEC'},
       {'code': '371.9',
        'long': 'Unspecified corneal disorder',
        'short': 'Corneal disorder NOS'},
       {'code': '372.00',
        'long': 'Acute conjunctivitis, unspecified',
        'short': 'Acute conjunctivitis NOS'},
       {'code': '372.01',
        'long': 'Serous conjunctivitis, except viral',
        'short': 'Serous conjunctivitis'},
       {'code': '372.02',
        'long': 'Acute follicular conjunctivitis',
        'short': 'Ac follic conjunctivitis'},
       {'code': '372.03',
        'long': 'Other mucopurulent conjunctivitis',
        'short': 'Mucopur conjunctivit NEC'},
       {'code': '372.04',
        'long': 'Pseudomembranous conjunctivitis',
        'short': 'Pseudomemb conjunctivit'},
       {'code': '372.05',
        'long': 'Acute atopic conjunctivitis',
        'short': 'Ac atopic conjunctivitis'},
       {'code': '372.06',
        'long': 'Acute chemical conjunctivitis',
        'short': 'Ac chem conjunctivitis'},
       {'code': '372.10',
        'long': 'Chronic conjunctivitis, unspecified',
        'short': 'Chr conjunctivitis NOS'},
       {'code': '372.11',
        'long': 'Simple chronic conjunctivitis',
        'short': 'Simpl chr conjunctivitis'},
       {'code': '372.12',
        'long': 'Chronic follicular conjunctivitis',
        'short': 'Chr follic conjunctivit'},
       {'code': '372.13',
        'long': 'Vernal conjunctivitis',
        'short': 'Vernal conjunctivitis'},
       {'code': '372.14',
        'long': 'Other chronic allergic conjunctivitis',
        'short': 'Chr allrg conjunctiv NEC'},
       {'code': '372.15',
        'long': 'Parasitic conjunctivitis',
        'short': 'Parasitic conjunctivitis'},
       {'code': '372.20',
        'long': 'Blepharoconjunctivitis, unspecified',
        'short': 'Blepharoconjunctivit NOS'},
       {'code': '372.21',
        'long': 'Angular blepharoconjunctivitis',
        'short': 'Angular blepharoconjunct'},
       {'code': '372.22',
        'long': 'Contact blepharoconjunctivitis',
        'short': 'Contact blepharoconjunct'},
       {'code': '372.30',
        'long': 'Conjunctivitis, unspecified',
        'short': 'Conjunctivitis NOS'},
       {'code': '372.31',
        'long': 'Rosacea conjunctivitis',
        'short': 'Rosacea conjunctivitis'},
       {'code': '372.33',
        'long': 'Conjunctivitis in mucocutaneous disease',
        'short': 'Mucocutan dis conjunctiv'},
       {'code': '372.34', 'long': 'Pingueculitis', 'short': 'Pingueculitis'},
       {'code': '372.39',
        'long': 'Other conjunctivitis',
        'short': 'Conjunctivitis NEC'},
       {'code': '372.40',
        'long': 'Pterygium, unspecified',
        'short': 'Pterygium NOS'},
       {'code': '372.41',
        'long': 'Peripheral pterygium, stationary',
        'short': 'Periph station pterygium'},
       {'code': '372.42',
        'long': 'Peripheral pterygium, progressive',
        'short': 'Periph progess pterygium'},
       {'code': '372.43',
        'long': 'Central pterygium',
        'short': 'Central pterygium'},
       {'code': '372.44',
        'long': 'Double pterygium',
        'short': 'Double pterygium'},
       {'code': '372.45',
        'long': 'Recurrent pterygium',
        'short': 'Recurrent pterygium'},
       {'code': '372.50',
        'long': 'Conjunctival degeneration, unspecified',
        'short': 'Conjunctival degen NOS'},
       {'code': '372.51', 'long': 'Pinguecula', 'short': 'Pinguecula'},
       {'code': '372.52',
        'long': 'Pseudopterygium',
        'short': 'Pseudopterygium'},
       {'code': '372.53',
        'long': 'Conjunctival xerosis',
        'short': 'Conjunctival xerosis'},
       {'code': '372.54',
        'long': 'Conjunctival concretions',
        'short': 'Conjunctival concretions'},
       {'code': '372.55',
        'long': 'Conjunctival pigmentations',
        'short': 'Conjunctiva pigmentation'},
       {'code': '372.56',
        'long': 'Conjunctival deposits',
        'short': 'Conjunctival deposits'},
       {'code': '372.61',
        'long': 'Granuloma of conjunctiva',
        'short': 'Granuloma of conjunctiva'},
       {'code': '372.62',
        'long': 'Localized adhesions and strands of conjunctiva',
        'short': 'Local conjunctiva adhes'},
       {'code': '372.63', 'long': 'Symblepharon', 'short': 'Symblepharon'},
       {'code': '372.64',
        'long': 'Scarring of conjunctiva',
        'short': 'Scarring of conjunctiva'},
       {'code': '372.71',
        'long': 'Hyperemia of conjunctiva',
        'short': 'Hyperemia of conjunctiva'},
       {'code': '372.72',
        'long': 'Conjunctival hemorrhage',
        'short': 'Conjunctival hemorrhage'},
       {'code': '372.73',
        'long': 'Conjunctival edema',
        'short': 'Conjunctival edema'},
       {'code': '372.74',
        'long': 'Vascular abnormalities of conjunctiva',
        'short': 'Conjunctiva vasc anomaly'},
       {'code': '372.75',
        'long': 'Conjunctival cysts',
        'short': 'Conjunctival cysts'},
       {'code': '372.81',
        'long': 'Conjunctivochalasis',
        'short': 'Conjunctivochalasis'},
       {'code': '372.89',
        'long': 'Other disorders of conjunctiva',
        'short': 'Conjunctiva disorder NEC'},
       {'code': '372.9',
        'long': 'Unspecified disorder of conjunctiva',
        'short': 'Conjunctiva disorder NOS'},
       {'code': '373.00',
        'long': 'Blepharitis, unspecified',
        'short': 'Blepharitis NOS'},
       {'code': '373.01',
        'long': 'Ulcerative blepharitis',
        'short': 'Ulcerative blepharitis'},
       {'code': '373.02',
        'long': 'Squamous blepharitis',
        'short': 'Squamous blepharitis'},
       {'code': '373.11',
        'long': 'Hordeolum externum',
        'short': 'Hordeolum externum'},
       {'code': '373.12',
        'long': 'Hordeolum internum',
        'short': 'Hordeolum internum'},
       {'code': '373.13',
        'long': 'Abscess of eyelid',
        'short': 'Abscess of eyelid'},
       {'code': '373.2', 'long': 'Chalazion', 'short': 'Chalazion'},
       {'code': '373.31',
        'long': 'Eczematous dermatitis of eyelid',
        'short': 'Eczem dermatitis eyelid'},
       {'code': '373.32',
        'long': 'Contact and allergic dermatitis of eyelid',
        'short': 'Contact dermatit eyelid'},
       {'code': '373.33',
        'long': 'Xeroderma of eyelid',
        'short': 'Xeroderma of eyelid'},
       {'code': '373.34',
        'long': 'Discoid lupus erythematosus of eyelid',
        'short': 'Disc lup erythematos lid'},
       {'code': '373.4',
        'long': 'Infective dermatitis of eyelid of types resulting in deformity',
        'short': 'Infect derm lid w deform'},
       {'code': '373.5',
        'long': 'Other infective dermatitis of eyelid',
        'short': 'Infec dermatitis lid NEC'},
       {'code': '373.6',
        'long': 'Parasitic infestation of eyelid',
        'short': 'Parasitic infest eyelid'},
       {'code': '373.8',
        'long': 'Other inflammations of eyelids',
        'short': 'Inflammation eyelid NEC'},
       {'code': '373.9',
        'long': 'Unspecified inflammation of eyelid',
        'short': 'Inflammation eyelid NOS'},
       {'code': '374.00',
        'long': 'Entropion, unspecified',
        'short': 'Entropion NOS'},
       {'code': '374.01',
        'long': 'Senile entropion',
        'short': 'Senile entropion'},
       {'code': '374.02',
        'long': 'Mechanical entropion',
        'short': 'Mechanical entropion'},
       {'code': '374.03',
        'long': 'Spastic entropion',
        'short': 'Spastic entropion'},
       {'code': '374.04',
        'long': 'Cicatricial entropion',
        'short': 'Cicatricial entropion'},
       {'code': '374.05',
        'long': 'Trichiasis of eyelid without entropion',
        'short': 'Trichiasis w/o entropion'},
       {'code': '374.10',
        'long': 'Ectropion, unspecified',
        'short': 'Ectropion NOS'},
       {'code': '374.11',
        'long': 'Senile ectropion',
        'short': 'Senile ectropion'},
       {'code': '374.12',
        'long': 'Mechanical ectropion',
        'short': 'Mechanical ectropion'},
       {'code': '374.13',
        'long': 'Spastic ectropion',
        'short': 'Spastic ectropion'},
       {'code': '374.14',
        'long': 'Cicatricial ectropion',
        'short': 'Cicatricial ectropion'},
       {'code': '374.20',
        'long': 'Lagophthalmos, unspecified',
        'short': 'Lagophthalmos NOS'},
       {'code': '374.21',
        'long': 'Paralytic lagophthalmos',
        'short': 'Paralytic lagophthalmos'},
       {'code': '374.22',
        'long': 'Mechanical lagophthalmos',
        'short': 'Mechanical lagophthalmos'},
       {'code': '374.23',
        'long': 'Cicatricial lagophthalmos',
        'short': 'Cicatricial lagophthalm'},
       {'code': '374.30',
        'long': 'Ptosis of eyelid, unspecified',
        'short': 'Ptosis of eyelid NOS'},
       {'code': '374.31',
        'long': 'Paralytic ptosis',
        'short': 'Paralytic ptosis'},
       {'code': '374.32',
        'long': 'Myogenic ptosis',
        'short': 'Myogenic ptosis'},
       {'code': '374.33',
        'long': 'Mechanical ptosis',
        'short': 'Mechanical ptosis'},
       {'code': '374.34',
        'long': 'Blepharochalasis',
        'short': 'Blepharochalasis'},
       {'code': '374.41',
        'long': 'Lid retraction or lag',
        'short': 'Lid retraction or lag'},
       {'code': '374.43',
        'long': 'Abnormal innervation syndrome of eyelid',
        'short': 'Abnorm innervation synd'},
       {'code': '374.44',
        'long': 'Sensory disorders of eyelid',
        'short': 'Sensory disorders, lid'},
       {'code': '374.45',
        'long': 'Other sensorimotor disorders of eyelid',
        'short': 'Sensormotr disor lid NEC'},
       {'code': '374.46',
        'long': 'Blepharophimosis',
        'short': 'Blepharophimosis'},
       {'code': '374.50',
        'long': 'Degenerative disorder of eyelid, unspecified',
        'short': 'Degen disorder NOS, lid'},
       {'code': '374.51',
        'long': 'Xanthelasma of eyelid',
        'short': 'Xanthelasma'},
       {'code': '374.52',
        'long': 'Hyperpigmentation of eyelid',
        'short': 'Hyperpigmentation lid'},
       {'code': '374.53',
        'long': 'Hypopigmentation of eyelid',
        'short': 'Hypopigmentation lid'},
       {'code': '374.54',
        'long': 'Hypertrichosis of eyelid',
        'short': 'Hypertrichosis of eyelid'},
       {'code': '374.55',
        'long': 'Hypotrichosis of eyelid',
        'short': 'Hypotrichosis of eyelid'},
       {'code': '374.56',
        'long': 'Other degenerative disorders of skin affecting eyelid',
        'short': 'Degen dis eyelid NEC'},
       {'code': '374.81',
        'long': 'Hemorrhage of eyelid',
        'short': 'Hemorrhage of eyelid'},
       {'code': '374.82',
        'long': 'Edema of eyelid',
        'short': 'Edema of eyelid'},
       {'code': '374.83',
        'long': 'Elephantiasis of eyelid',
        'short': 'Elephantiasis of eyelid'},
       {'code': '374.84',
        'long': 'Cysts of eyelids',
        'short': 'Cysts of eyelids'},
       {'code': '374.85',
        'long': 'Vascular anomalies of eyelid',
        'short': 'Vascular anomaly, eyelid'},
       {'code': '374.86',
        'long': 'Retained foreign body of eyelid',
        'short': 'Old foreign body, eyelid'},
       {'code': '374.87',
        'long': 'Dermatochalasis',
        'short': 'Dermatochalasis'},
       {'code': '374.89',
        'long': 'Other disorders of eyelid',
        'short': 'Disorders of eyelid NEC'},
       {'code': '374.9',
        'long': 'Unspecified disorder of eyelid',
        'short': 'Disorder of eyelid NOS'},
       {'code': '375.00',
        'long': 'Dacryoadenitis, unspecified',
        'short': 'Dacryoadenitis NOS'},
       {'code': '375.01',
        'long': 'Acute dacryoadenitis',
        'short': 'Acute dacryoadenitis'},
       {'code': '375.02',
        'long': 'Chronic dacryoadenitis',
        'short': 'Chronic dacryoadenitis'},
       {'code': '375.03',
        'long': 'Chronic enlargement of lacrimal gland',
        'short': 'Ch enlargmnt lacrim glnd'},
       {'code': '375.11', 'long': 'Dacryops', 'short': 'Dacryops'},
       {'code': '375.12',
        'long': 'Other lacrimal cysts and cystic degeneration',
        'short': 'Lacrimal gland cyst NEC'},
       {'code': '375.13',
        'long': 'Primary lacrimal atrophy',
        'short': 'Primary lacrimal atrophy'},
       {'code': '375.14',
        'long': 'Secondary lacrimal atrophy',
        'short': 'Secondary lacrim atrophy'},
       {'code': '375.15',
        'long': 'Tear film insufficiency, unspecified',
        'short': 'Tear film insuffic NOS'},
       {'code': '375.16',
        'long': 'Dislocation of lacrimal gland',
        'short': 'Lacrimal gland dislocat'},
       {'code': '375.20',
        'long': 'Epiphora, unspecified as to cause',
        'short': 'Epiphora NOS'},
       {'code': '375.21',
        'long': 'Epiphora due to excess lacrimation',
        'short': 'Epiphora d/t excess tear'},
       {'code': '375.22',
        'long': 'Epiphora due to insufficient drainage',
        'short': 'Epiphora d/t insuf drain'},
       {'code': '375.30',
        'long': 'Dacryocystitis, unspecified',
        'short': 'Dacryocystitis NOS'},
       {'code': '375.31',
        'long': 'Acute canaliculitis, lacrimal',
        'short': 'Acute canaliculitis'},
       {'code': '375.32',
        'long': 'Acute dacryocystitis',
        'short': 'Acute dacryocystitis'},
       {'code': '375.33',
        'long': 'Phlegmonous dacryocystitis',
        'short': 'Phlegmon dacryocystitis'},
       {'code': '375.41',
        'long': 'Chronic canaliculitis',
        'short': 'Chronic canaliculitis'},
       {'code': '375.42',
        'long': 'Chronic dacryocystitis',
        'short': 'Chronic dacryocystitis'},
       {'code': '375.43',
        'long': 'Lacrimal mucocele',
        'short': 'Lacrimal mucocele'},
       {'code': '375.51',
        'long': 'Eversion of lacrimal punctum',
        'short': 'Lacriml punctum eversion'},
       {'code': '375.52',
        'long': 'Stenosis of lacrimal punctum',
        'short': 'Lacriml punctum stenosis'},
       {'code': '375.53',
        'long': 'Stenosis of lacrimal canaliculi',
        'short': 'Lacrim canalic stenosis'},
       {'code': '375.54',
        'long': 'Stenosis of lacrimal sac',
        'short': 'Lacrimal sac stenosis'},
       {'code': '375.55',
        'long': 'Obstruction of nasolacrimal duct, neonatal',
        'short': 'Neonatal nasolacrml obst'},
       {'code': '375.56',
        'long': 'Stenosis of nasolacrimal duct, acquired',
        'short': 'Acq nasolacrml stenosis'},
       {'code': '375.57', 'long': 'Dacryolith', 'short': 'Dacryolith'},
       {'code': '375.61',
        'long': 'Lacrimal fistula',
        'short': 'Lacrimal fistula'},
       {'code': '375.69',
        'long': 'Other changes of lacrimal passages',
        'short': 'Lacrim passge change NEC'},
       {'code': '375.81',
        'long': 'Granuloma of lacrimal passages',
        'short': 'Lacrim passage granuloma'},
       {'code': '375.89',
        'long': 'Other disorders of lacrimal system',
        'short': 'Lacrimal syst dis NEC'},
       {'code': '375.9',
        'long': 'Unspecified disorder of lacrimal system',
        'short': 'Lacrimal syst dis NOS'},
       {'code': '376.00',
        'long': 'Acute inflammation of orbit, unspecified',
        'short': 'Acute inflam NOS, orbit'},
       {'code': '376.01',
        'long': 'Orbital cellulitis',
        'short': 'Orbital cellulitis'},
       {'code': '376.02',
        'long': 'Orbital periostitis',
        'short': 'Orbital periostitis'},
       {'code': '376.03',
        'long': 'Orbital osteomyelitis',
        'short': 'Orbital osteomyelitis'},
       {'code': '376.04',
        'long': 'Orbital tenonitis',
        'short': 'Orbital tenonitis'},
       {'code': '376.10',
        'long': 'Chronic inflammation of orbit, unspecified',
        'short': 'Chr inflam NOS, orbit'},
       {'code': '376.11',
        'long': 'Orbital granuloma',
        'short': 'Orbital granuloma'},
       {'code': '376.12',
        'long': 'Orbital myositis',
        'short': 'Orbital myositis'},
       {'code': '376.13',
        'long': 'Parasitic infestation of orbit',
        'short': 'Parasite infest, orbit'},
       {'code': '376.21',
        'long': 'Thyrotoxic exophthalmos',
        'short': 'Thyrotoxic exophthalmos'},
       {'code': '376.22',
        'long': 'Exophthalmic ophthalmoplegia',
        'short': 'Exophthalm ophthalmopleg'},
       {'code': '376.30',
        'long': 'Exophthalmos, unspecified',
        'short': 'Exophthalmos NOS'},
       {'code': '376.31',
        'long': 'Constant exophthalmos',
        'short': 'Constant exophthalmos'},
       {'code': '376.32',
        'long': 'Orbital hemorrhage',
        'short': 'Orbital hemorrhage'},
       {'code': '376.33',
        'long': 'Orbital edema or congestion',
        'short': 'Orbital edema'},
       {'code': '376.34',
        'long': 'Intermittent exophthalmos',
        'short': 'Intermittnt exophthalmos'},
       {'code': '376.35',
        'long': 'Pulsating exophthalmos',
        'short': 'Pulsating exophthalmos'},
       {'code': '376.36',
        'long': 'Lateral displacement of globe',
        'short': 'Lateral globe displacmnt'},
       {'code': '376.40',
        'long': 'Deformity of orbit, unspecified',
        'short': 'Deformity of orbit NOS'},
       {'code': '376.41',
        'long': 'Hypertelorism of orbit',
        'short': 'Hypertelorism of orbit'},
       {'code': '376.42',
        'long': 'Exostosis of orbit',
        'short': 'Exostosis of orbit'},
       {'code': '376.43',
        'long': 'Local deformities of orbit due to bone disease',
        'short': 'Orbt deform d/t bone dis'},
       {'code': '376.44',
        'long': 'Orbital deformities associated with craniofacial deformities',
        'short': 'Craniofacial-orbit defor'},
       {'code': '376.45',
        'long': 'Atrophy of orbit',
        'short': 'Atrophy of orbit'},
       {'code': '376.46',
        'long': 'Enlargement of orbit',
        'short': 'Enlargement of orbit'},
       {'code': '376.47',
        'long': 'Deformity of orbit due to trauma or surgery',
        'short': 'Orbit deform d/t trauma'},
       {'code': '376.50',
        'long': 'Enophthalmos, unspecified as to cause',
        'short': 'Enophthalmos NOS'},
       {'code': '376.51',
        'long': 'Enophthalmos due to atrophy of orbital tissue',
        'short': 'Enophth d/t orbit atrphy'},
       {'code': '376.52',
        'long': 'Enophthalmos due to trauma or surgery',
        'short': 'Enophthalmos d/t trauma'},
       {'code': '376.6',
        'long': 'Retained (old) foreign body following penetrating wound of orbit',
        'short': 'Old foreign body, orbit'},
       {'code': '376.81', 'long': 'Orbital cysts', 'short': 'Orbital cysts'},
       {'code': '376.82',
        'long': 'Myopathy of extraocular muscles',
        'short': 'Extraocul muscl myopathy'},
       {'code': '376.89',
        'long': 'Other orbital disorders',
        'short': 'Orbital disorders NEC'},
       {'code': '376.9',
        'long': 'Unspecified disorder of orbit',
        'short': 'Orbital disorder NOS'},
       {'code': '377.00',
        'long': 'Papilledema, unspecified',
        'short': 'Papilledema NOS'},
       {'code': '377.01',
        'long': 'Papilledema associated with increased intracranial pressure',
        'short': 'Papilledema w incr press'},
       {'code': '377.02',
        'long': 'Papilledema associated with decreased ocular pressure',
        'short': 'Papilledema w decr press'},
       {'code': '377.03',
        'long': 'Papilledema associated with retinal disorder',
        'short': 'Papilledema w retina dis'},
       {'code': '377.04',
        'long': 'Foster-Kennedy syndrome',
        'short': 'Foster-kennedy syndrome'},
       {'code': '377.10',
        'long': 'Optic atrophy, unspecified',
        'short': 'Optic atrophy NOS'},
       {'code': '377.11',
        'long': 'Primary optic atrophy',
        'short': 'Primary optic atrophy'},
       {'code': '377.12',
        'long': 'Postinflammatory optic atrophy',
        'short': 'Postinflam optic atrophy'},
       {'code': '377.13',
        'long': 'Optic atrophy associated with retinal dystrophies',
        'short': 'Optic atrph w retin dyst'},
       {'code': '377.14',
        'long': 'Glaucomatous atrophy [cupping] of optic disc',
        'short': 'Cupping of optic disc'},
       {'code': '377.15',
        'long': 'Partial optic atrophy',
        'short': 'Partial optic atrophy'},
       {'code': '377.16',
        'long': 'Hereditary optic atrophy',
        'short': 'Hereditary optic atrophy'},
       {'code': '377.21',
        'long': 'Drusen of optic disc',
        'short': 'Drusen of optic disc'},
       {'code': '377.22',
        'long': 'Crater-like holes of optic disc',
        'short': 'Crater-like hole op disc'},
       {'code': '377.23',
        'long': 'Coloboma of optic disc',
        'short': 'Coloboma of optic disc'},
       {'code': '377.24',
        'long': 'Pseudopapilledema',
        'short': 'Pseudopapilledema'},
       {'code': '377.30',
        'long': 'Optic neuritis, unspecified',
        'short': 'Optic neuritis NOS'},
       {'code': '377.31',
        'long': 'Optic papillitis',
        'short': 'Optic papillitis'},
       {'code': '377.32',
        'long': 'Retrobulbar neuritis (acute)',
        'short': 'Retrobulbar neuritis'},
       {'code': '377.33',
        'long': 'Nutritional optic neuropathy',
        'short': 'Nutrition optc neuropthy'},
       {'code': '377.34',
        'long': 'Toxic optic neuropathy',
        'short': 'Toxic optic neuropathy'},
       {'code': '377.39',
        'long': 'Other optic neuritis',
        'short': 'Optic neuritis NEC'},
       {'code': '377.41',
        'long': 'Ischemic optic neuropathy',
        'short': 'Ischemic optic neuropthy'},
       {'code': '377.42',
        'long': 'Hemorrhage in optic nerve sheaths',
        'short': 'Optic nerve sheath hemor'},
       {'code': '377.43',
        'long': 'Optic nerve hypoplasia',
        'short': 'Optic nerve hypoplasia'},
       {'code': '377.49',
        'long': 'Other disorders of optic nerve',
        'short': 'Optic nerve disorder NEC'},
       {'code': '377.51',
        'long': 'Disorders of optic chiasm associated with pituitary neoplasms and disorders',
        'short': 'Opt chiasm w pituit dis'},
       {'code': '377.52',
        'long': 'Disorders of optic chiasm associated with other neoplasms',
        'short': 'Opt chiasm dis/neopl NEC'},
       {'code': '377.53',
        'long': 'Disorders of optic chiasm associated with vascular disorders',
        'short': 'Opt chiasm w vascul dis'},
       {'code': '377.54',
        'long': 'Disorders of optic chiasm associated with inflammatory disorders',
        'short': 'Op chiasm dis w infl dis'},
       {'code': '377.61',
        'long': 'Disorders of other visual pathways associated with neoplasms',
        'short': 'Vis path dis w neoplasms'},
       {'code': '377.62',
        'long': 'Disorders of other visual pathways associated with vascular disorders',
        'short': 'Vis path dis w vasc dis'},
       {'code': '377.63',
        'long': 'Disorders of other visual pathways associated with inflammatory disorders',
        'short': 'Vis path dis w infl dis'},
       {'code': '377.71',
        'long': 'Disorders of visual cortex associated with neoplasms',
        'short': 'Vis cortx dis w neoplasm'},
       {'code': '377.72',
        'long': 'Disorders of visual cortex associated with vascular disorders',
        'short': 'Vis cortx dis w vasc dis'},
       {'code': '377.73',
        'long': 'Disorders of visual cortex associated with inflammatory disorders',
        'short': 'Vis cortex dis w inflam'},
       {'code': '377.75',
        'long': 'Cortical blindness',
        'short': 'Cortical blindness'},
       {'code': '377.9',
        'long': 'Unspecified disorder of optic nerve and visual pathways',
        'short': 'Optic nerve disorder NOS'},
       {'code': '378.00',
        'long': 'Esotropia, unspecified',
        'short': 'Esotropia NOS'},
       {'code': '378.01',
        'long': 'Monocular esotropia',
        'short': 'Monocular esotropia'},
       {'code': '378.02',
        'long': 'Monocular esotropia with A pattern',
        'short': 'Monoc esotrop w a pattrn'},
       {'code': '378.03',
        'long': 'Monocular esotropia with V pattern',
        'short': 'Monoc esotrop w v pattrn'},
       {'code': '378.04',
        'long': 'Monocular esotropia with other noncomitancies',
        'short': 'Monoc esotrop w x/y pat'},
       {'code': '378.05',
        'long': 'Alternating esotropia',
        'short': 'Alternating esotropia'},
       {'code': '378.06',
        'long': 'Alternating esotropia with A pattern',
        'short': 'Alt esotropia w a pattrn'},
       {'code': '378.07',
        'long': 'Alternating esotropia with V pattern',
        'short': 'Alt esotropia w v pattrn'},
       {'code': '378.08',
        'long': 'Alternating esotropia with other noncomitancies',
        'short': 'Alt esotrop w x/y pattrn'},
       {'code': '378.10',
        'long': 'Exotropia, unspecified',
        'short': 'Exotropia NOS'},
       {'code': '378.11',
        'long': 'Monocular exotropia',
        'short': 'Monocular exotropia'},
       {'code': '378.12',
        'long': 'Monocular exotropia with A pattern',
        'short': 'Monoc exotrop w a pattrn'},
       {'code': '378.13',
        'long': 'Monocular exotropia with V pattern',
        'short': 'Monoc exotrop w v pattrn'},
       {'code': '378.14',
        'long': 'Monocular exotropia with other noncomitancies',
        'short': 'Monoc exotrop w x/y pat'},
       {'code': '378.15',
        'long': 'Alternating exotropia',
        'short': 'Alternating exotropia'},
       {'code': '378.16',
        'long': 'Alternating exotropia with A pattern',
        'short': 'Alt exotropia w a pattrn'},
       {'code': '378.17',
        'long': 'Alternating exotropia with V pattern',
        'short': 'Alt exotropia w v pattrn'},
       {'code': '378.18',
        'long': 'Alternating exotropia with other noncomitancies',
        'short': 'Alt exotrop w x/y pattrn'},
       {'code': '378.20',
        'long': 'Intermittent heterotropia, unspecified',
        'short': 'Intermit heterotrop NOS'},
       {'code': '378.21',
        'long': 'Intermittent esotropia, monocular',
        'short': 'Intermit monoc esotropia'},
       {'code': '378.22',
        'long': 'Intermittent esotropia, alternating',
        'short': 'Intermit altrn esotropia'},
       {'code': '378.23',
        'long': 'Intermittent exotropia, monocular',
        'short': 'Intermit monoc exotropia'},
       {'code': '378.24',
        'long': 'Intermittent exotropia, alternating',
        'short': 'Intermit altrn exotropia'},
       {'code': '378.30',
        'long': 'Heterotropia, unspecified',
        'short': 'Heterotropia NOS'},
       {'code': '378.31', 'long': 'Hypertropia', 'short': 'Hypertropia'},
       {'code': '378.32', 'long': 'Hypotropia', 'short': 'Hypotropia'},
       {'code': '378.33', 'long': 'Cyclotropia', 'short': 'Cyclotropia'},
       {'code': '378.34',
        'long': 'Monofixation syndrome',
        'short': 'Monofixation syndrome'},
       {'code': '378.35',
        'long': 'Accommodative component in esotropia',
        'short': 'Accommodative esotropia'},
       {'code': '378.40',
        'long': 'Heterophoria, unspecified',
        'short': 'Heterophoria NOS'},
       {'code': '378.41', 'long': 'Esophoria', 'short': 'Esophoria'},
       {'code': '378.42', 'long': 'Exophoria', 'short': 'Exophoria'},
       {'code': '378.43',
        'long': 'Vertical heterophoria',
        'short': 'Vertical heterophoria'},
       {'code': '378.44', 'long': 'Cyclophoria', 'short': 'Cyclophoria'},
       {'code': '378.45',
        'long': 'Alternating hyperphoria',
        'short': 'Alternating hyperphoria'},
       {'code': '378.50',
        'long': 'Paralytic strabismus, unspecified',
        'short': 'Paralytic strabismus NOS'},
       {'code': '378.51',
        'long': 'Third or oculomotor nerve palsy, partial',
        'short': 'Partial third nerv palsy'},
       {'code': '378.52',
        'long': 'Third or oculomotor nerve palsy, total',
        'short': 'Total third nerve palsy'},
       {'code': '378.53',
        'long': 'Fourth or trochlear nerve palsy',
        'short': 'Fourth nerve palsy'},
       {'code': '378.54',
        'long': 'Sixth or abducens nerve palsy',
        'short': 'Sixth nerve palsy'},
       {'code': '378.55',
        'long': 'External ophthalmoplegia',
        'short': 'External ophthalmoplegia'},
       {'code': '378.56',
        'long': 'Total ophthalmoplegia',
        'short': 'Total ophthalmoplegia'},
       {'code': '378.60',
        'long': 'Mechanical strabismus, unspecified',
        'short': 'Mechanical strabism NOS'},
       {'code': '378.61',
        'long': "Brown's (tendon) sheath syndrome",
        'short': "Brown's sheath syndrome"},
       {'code': '378.62',
        'long': 'Mechanical strabismus from other musculofascial disorders',
        'short': 'Mech strab d/t muscl dis'},
       {'code': '378.63',
        'long': 'Limited duction associated with other conditions',
        'short': 'Mech strab w oth conditn'},
       {'code': '378.71',
        'long': "Duane's syndrome",
        'short': "Duane's syndrome"},
       {'code': '378.72',
        'long': 'Progressive external ophthalmoplegia',
        'short': 'Prog ext ophthalmoplegia'},
       {'code': '378.73',
        'long': 'Strabismus in other neuromuscular disorders',
        'short': 'Neuromuscle dis strabism'},
       {'code': '378.81',
        'long': 'Palsy of conjugate gaze',
        'short': 'Palsy of conjugate gaze'},
       {'code': '378.82',
        'long': 'Spasm of conjugate gaze',
        'short': 'Spasm of conjugate gaze'},
       {'code': '378.83',
        'long': 'Convergence insufficiency or palsy',
        'short': 'Convergenc insufficiency'},
       {'code': '378.84',
        'long': 'Convergence excess or spasm',
        'short': 'Convergence excess'},
       {'code': '378.85',
        'long': 'Anomalies of divergence',
        'short': 'Anomalies of divergence'},
       {'code': '378.86',
        'long': 'Internuclear ophthalmoplegia',
        'short': 'Internucl ophthalmopleg'},
       {'code': '378.87',
        'long': 'Other dissociated deviation of eye movements',
        'short': 'Skew deviation, eye'},
       {'code': '378.9',
        'long': 'Unspecified disorder of eye movements',
        'short': 'Eye movemnt disorder NOS'},
       {'code': '379.00',
        'long': 'Scleritis, unspecified',
        'short': 'Scleritis NOS'},
       {'code': '379.01',
        'long': 'Episcleritis periodica fugax',
        'short': 'Episclerit periodic fugx'},
       {'code': '379.02',
        'long': 'Nodular episcleritis',
        'short': 'Nodular episcleritis'},
       {'code': '379.03',
        'long': 'Anterior scleritis',
        'short': 'Anterior scleritis'},
       {'code': '379.04',
        'long': 'Scleromalacia perforans',
        'short': 'Scleromalacia perforans'},
       {'code': '379.05',
        'long': 'Scleritis with corneal involvement',
        'short': 'Scleritis w cornea invol'},
       {'code': '379.06',
        'long': 'Brawny scleritis',
        'short': 'Brawny scleritis'},
       {'code': '379.07',
        'long': 'Posterior scleritis',
        'short': 'Posterior scleritis'},
       {'code': '379.09',
        'long': 'Other scleritis and episcleritis',
        'short': 'Scleritis NEC'},
       {'code': '379.11',
        'long': 'Scleral ectasia',
        'short': 'Scleral ectasia'},
       {'code': '379.12',
        'long': 'Staphyloma posticum',
        'short': 'Staphyloma posticum'},
       {'code': '379.13',
        'long': 'Equatorial staphyloma',
        'short': 'Equatorial staphyloma'},
       {'code': '379.14',
        'long': 'Anterior staphyloma, localized',
        'short': 'Local anterior staphylma'},
       {'code': '379.15',
        'long': 'Ring staphyloma',
        'short': 'Ring staphyloma'},
       {'code': '379.16',
        'long': 'Other degenerative disorders of sclera',
        'short': 'Scleral degen dis NEC'},
       {'code': '379.19',
        'long': 'Other disorders of sclera',
        'short': 'Disorder of sclera NEC'},
       {'code': '379.21',
        'long': 'Vitreous degeneration',
        'short': 'Vitreous degeneration'},
       {'code': '379.22',
        'long': 'Crystalline deposits in vitreous',
        'short': 'Crystal deposit vitreous'},
       {'code': '379.23',
        'long': 'Vitreous hemorrhage',
        'short': 'Vitreous hemorrhage'},
       {'code': '379.24',
        'long': 'Other vitreous opacities',
        'short': 'Vitreous opacities NEC'},
       {'code': '379.25',
        'long': 'Vitreous membranes and strands',
        'short': 'Vitreous membranes'},
       {'code': '379.26',
        'long': 'Vitreous prolapse',
        'short': 'Vitreous prolapse'},
       {'code': '379.27',
        'long': 'Vitreomacular adhesion',
        'short': 'Vitreomacular adhesion'},
       {'code': '379.29',
        'long': 'Other disorders of vitreous',
        'short': 'Vitreous disorders NEC'},
       {'code': '379.31', 'long': 'Aphakia', 'short': 'Aphakia'},
       {'code': '379.32',
        'long': 'Subluxation of lens',
        'short': 'Subluxation of lens'},
       {'code': '379.33',
        'long': 'Anterior dislocation of lens',
        'short': 'Ant dislocation of lens'},
       {'code': '379.34',
        'long': 'Posterior dislocation of lens',
        'short': 'Post dislocation of lens'},
       {'code': '379.39',
        'long': 'Other disorders of lens',
        'short': 'Disorders of lens NEC'},
       {'code': '379.40',
        'long': 'Abnormal pupillary function, unspecified',
        'short': 'Abn pupil function NOS'},
       {'code': '379.41', 'long': 'Anisocoria', 'short': 'Anisocoria'},
       {'code': '379.42',
        'long': 'Miosis (persistent), not due to miotics',
        'short': 'Miosis not d/t miotics'},
       {'code': '379.43',
        'long': 'Mydriasis (persistent), not due to mydriatics',
        'short': 'Mydriasis not d/t mydrtc'},
       {'code': '379.45',
        'long': 'Argyll Robertson pupil, atypical',
        'short': 'Argyll robertson pupil'},
       {'code': '379.46',
        'long': 'Tonic pupillary reaction',
        'short': 'Tonic pupillary reaction'},
       {'code': '379.49',
        'long': 'Other anomalies of pupillary function',
        'short': 'Pupil funct anomaly NEC'},
       {'code': '379.50',
        'long': 'Nystagmus, unspecified',
        'short': 'Nystagmus NOS'},
       {'code': '379.51',
        'long': 'Congenital nystagmus',
        'short': 'Congenital nystagmus'},
       {'code': '379.52',
        'long': 'Latent nystagmus',
        'short': 'Latent nystagmus'},
       {'code': '379.53',
        'long': 'Visual deprivation nystagmus',
        'short': 'Visual deprivatn nystagm'},
       {'code': '379.54',
        'long': 'Nystagmus associated with disorders of the vestibular system',
        'short': 'Nystagms w vestibulr dis'},
       {'code': '379.55',
        'long': 'Dissociated nystagmus',
        'short': 'Dissociated nystagmus'},
       {'code': '379.56',
        'long': 'Other forms of nystagmus',
        'short': 'Nystagmus NEC'},
       {'code': '379.57',
        'long': 'Deficiencies of saccadic eye movements',
        'short': 'Saccadic eye movmnt def'},
       {'code': '379.58',
        'long': 'Deficiencies of smooth pursuit movements',
        'short': 'Smooth pursuit mvmnt def'},
       {'code': '379.59',
        'long': 'Other irregularities of eye movements',
        'short': 'Irregular eye mvmnts NEC'},
       {'code': '379.60',
        'long': 'Inflammation (infection) of postprocedural bleb, unspecified',
        'short': 'Inflam postproc bleb NOS'},
       {'code': '379.61',
        'long': 'Inflammation (infection) of postprocedural bleb, stage 1',
        'short': 'Inflam postproc bleb, 1'},
       {'code': '379.62',
        'long': 'Inflammation (infection) of postprocedural bleb, stage 2',
        'short': 'Inflam postproc bleb, 2'},
       {'code': '379.63',
        'long': 'Inflammation (infection) of postprocedural bleb, stage 3',
        'short': 'Inflam postproc bleb, 3'},
       {'code': '379.8',
        'long': 'Other specified disorders of eye and adnexa',
        'short': 'Eye disorders NEC'},
       {'code': '379.90',
        'long': 'Disorder of eye, unspecified',
        'short': 'Eye disorder NOS'},
       {'code': '379.91',
        'long': 'Pain in or around eye',
        'short': 'Pain in or around eye'},
       {'code': '379.92',
        'long': 'Swelling or mass of eye',
        'short': 'Swelling or mass of eye'},
       {'code': '379.93',
        'long': 'Redness or discharge of eye',
        'short': 'Redness/discharge of eye'},
       {'code': '379.99',
        'long': 'Other ill-defined disorders of eye',
        'short': 'Ill-defined eye dis NEC'},
       {'code': '380.00',
        'long': 'Perichondritis of pinna, unspecified',
        'short': 'Perichondritis pinna NOS'},
       {'code': '380.01',
        'long': 'Acute perichondritis of pinna',
        'short': 'Ac perichondritis pinna'},
       {'code': '380.02',
        'long': 'Chronic perichondritis of pinna',
        'short': 'Chr perichondritis pinna'},
       {'code': '380.03',
        'long': 'Chondritis of pinna',
        'short': 'Chondritis of pinna'},
       {'code': '380.10',
        'long': 'Infective otitis externa, unspecified',
        'short': 'Infec otitis externa NOS'},
       {'code': '380.11',
        'long': 'Acute infection of pinna',
        'short': 'Acute infection of pinna'},
       {'code': '380.12',
        'long': "Acute swimmers' ear",
        'short': "Acute swimmers' ear"},
       {'code': '380.13',
        'long': 'Other acute infections of external ear',
        'short': 'Ac infect extern ear NEC'},
       {'code': '380.14',
        'long': 'Malignant otitis externa',
        'short': 'Malignant otitis externa'},
       {'code': '380.15',
        'long': 'Chronic mycotic otitis externa',
        'short': 'Chr mycot otitis externa'},
       {'code': '380.16',
        'long': 'Other chronic infective otitis externa',
        'short': 'Chr inf otit externa NEC'},
       {'code': '380.21',
        'long': 'Cholesteatoma of external ear',
        'short': 'Cholesteatoma extern ear'},
       {'code': '380.22',
        'long': 'Other acute otitis externa',
        'short': 'Acute otitis externa NEC'},
       {'code': '380.23',
        'long': 'Other chronic otitis externa',
        'short': 'Chr otitis externa NEC'},
       {'code': '380.30',
        'long': 'Disorder of pinna, unspecified',
        'short': 'Disorder of pinna NOS'},
       {'code': '380.31',
        'long': 'Hematoma of auricle or pinna',
        'short': 'Hematoma auricle/pinna'},
       {'code': '380.32',
        'long': 'Acquired deformities of auricle or pinna',
        'short': 'Acq deform auricle/pinna'},
       {'code': '380.39',
        'long': 'Other noninfectious disorders of pinna',
        'short': 'Noninfect dis pinna NEC'},
       {'code': '380.4',
        'long': 'Impacted cerumen',
        'short': 'Impacted cerumen'},
       {'code': '380.50',
        'long': 'Acquired stenosis of external ear canal, unspecified as to cause',
        'short': 'Acq stenos ear canal NOS'},
       {'code': '380.51',
        'long': 'Acquired stenosis of external ear canal secondary to trauma',
        'short': 'Stenosis ear d/t trauma'},
       {'code': '380.52',
        'long': 'Acquired stenosis of external ear canal secondary to surgery',
        'short': 'Stenosis ear d/t surgery'},
       {'code': '380.53',
        'long': 'Acquired stenosis of external ear canal secondary to inflammation',
        'short': 'Stenosis ear d/t inflam'},
       {'code': '380.81',
        'long': 'Exostosis of external ear canal',
        'short': 'Exostosis ext ear canal'},
       {'code': '380.89',
        'long': 'Other disorders of external ear',
        'short': 'Dis external ear NEC'},
       {'code': '380.9',
        'long': 'Unspecified disorder of external ear',
        'short': 'Dis external ear NOS'},
       {'code': '381.00',
        'long': 'Acute nonsuppurative otitis media, unspecified',
        'short': 'Ac nonsup otitis med NOS'},
       {'code': '381.01',
        'long': 'Acute serous otitis media',
        'short': 'Ac serous otitis media'},
       {'code': '381.02',
        'long': 'Acute mucoid otitis media',
        'short': 'Ac mucoid otitis media'},
       {'code': '381.03',
        'long': 'Acute sanguinous otitis media',
        'short': 'Ac sanguin otitis media'},
       {'code': '381.04',
        'long': 'Acute allergic serous otitis media',
        'short': 'Ac allergic serous OM'},
       {'code': '381.05',
        'long': 'Acute allergic mucoid otitis media',
        'short': 'Ac allergic mucoid OM'},
       {'code': '381.06',
        'long': 'Acute allergic sanguinous otitis media',
        'short': 'Ac allerg sanguinous OM'},
       {'code': '381.10',
        'long': 'Chronic serous otitis media, simple or unspecified',
        'short': 'Chr serous OM simp/NOS'},
       {'code': '381.19',
        'long': 'Other chronic serous otitis media',
        'short': 'Chr serous OM NEC'},
       {'code': '381.20',
        'long': 'Chronic mucoid otitis media, simple or unspecified',
        'short': 'Chr mucoid OM simp/NOS'},
       {'code': '381.29',
        'long': 'Other chronic mucoid otitis media',
        'short': 'Chr mucoid OM NEC'},
       {'code': '381.3',
        'long': 'Other and unspecified chronic nonsuppurative otitis media',
        'short': 'Chr nonsup OM NOS/NEC'},
       {'code': '381.4',
        'long': 'Nonsuppurative otitis media, not specified as acute or chronic',
        'short': 'Nonsupp otitis media NOS'},
       {'code': '381.50',
        'long': 'Eustachian salpingitis, unspecified',
        'short': 'Eustachian salping NOS'},
       {'code': '381.51',
        'long': 'Acute Eustachian salpingitis',
        'short': 'Ac eustachian salping'},
       {'code': '381.52',
        'long': 'Chronic Eustachian salpingitis',
        'short': 'Chr eustachian salping'},
       {'code': '381.60',
        'long': 'Obstruction of Eustachian tube, unspecified',
        'short': 'Obstr eustach tube NOS'},
       {'code': '381.61',
        'long': 'Osseous obstruction of Eustachian tube',
        'short': 'Osseous eustachian obstr'},
       {'code': '381.62',
        'long': 'Intrinsic cartilagenous obstruction of Eustachian tube',
        'short': 'Intrinsic eustach obstr'},
       {'code': '381.63',
        'long': 'Extrinsic cartilagenous obstruction of Eustachian tube',
        'short': 'Extrinsic eustach obstr'},
       {'code': '381.7',
        'long': 'Patulous Eustachian tube',
        'short': 'Patulous eustachian tube'},
       {'code': '381.81',
        'long': 'Dysfunction of Eustachian tube',
        'short': 'Dysfunct eustachian tube'},
       {'code': '381.89',
        'long': 'Other disorders of Eustachian tube',
        'short': 'Eustachian tube dis NEC'},
       {'code': '381.9',
        'long': 'Unspecified Eustachian tube disorder',
        'short': 'Eustachian tube dis NOS'},
       {'code': '382.00',
        'long': 'Acute suppurative otitis media without spontaneous rupture of eardrum',
        'short': 'Ac supp otitis media NOS'},
       {'code': '382.01',
        'long': 'Acute suppurative otitis media with spontaneous rupture of eardrum',
        'short': 'Ac supp OM w drum rupt'},
       {'code': '382.02',
        'long': 'Acute suppurative otitis media in diseases classified elsewhere',
        'short': 'Ac supp OM in oth dis'},
       {'code': '382.1',
        'long': 'Chronic tubotympanic suppurative otitis media',
        'short': 'Chr tubotympan suppur OM'},
       {'code': '382.2',
        'long': 'Chronic atticoantral suppurative otitis media',
        'short': 'Chr atticoantral sup OM'},
       {'code': '382.3',
        'long': 'Unspecified chronic suppurative otitis media',
        'short': 'Chr sup otitis media NOS'},
       {'code': '382.4',
        'long': 'Unspecified suppurative otitis media',
        'short': 'Suppur otitis media NOS'},
       {'code': '382.9',
        'long': 'Unspecified otitis media',
        'short': 'Otitis media NOS'},
       {'code': '383.00',
        'long': 'Acute mastoiditis without complications',
        'short': 'Ac mastoiditis w/o compl'},
       {'code': '383.01',
        'long': 'Subperiosteal abscess of mastoid',
        'short': 'Subperi mastoid abscess'},
       {'code': '383.02',
        'long': 'Acute mastoiditis with other complications',
        'short': 'Ac mastoiditis-compl NEC'},
       {'code': '383.1',
        'long': 'Chronic mastoiditis',
        'short': 'Chronic mastoiditis'},
       {'code': '383.20',
        'long': 'Petrositis, unspecified',
        'short': 'Petrositis NOS'},
       {'code': '383.21',
        'long': 'Acute petrositis',
        'short': 'Acute petrositis'},
       {'code': '383.22',
        'long': 'Chronic petrositis',
        'short': 'Chronic petrositis'},
       {'code': '383.30',
        'long': 'Postmastoidectomy complication, unspecified',
        'short': 'Postmastoid compl NOS'},
       {'code': '383.31',
        'long': 'Mucosal cyst of postmastoidectomy cavity',
        'short': 'Postmastoid mucosal cyst'},
       {'code': '383.32',
        'long': 'Recurrent cholesteatoma of postmastoidectomy cavity',
        'short': 'Postmastoid cholesteatma'},
       {'code': '383.33',
        'long': 'Granulations of postmastoidectomy cavity',
        'short': 'Postmastoid granulations'},
       {'code': '383.81',
        'long': 'Postauricular fistula',
        'short': 'Postauricular fistula'},
       {'code': '383.89',
        'long': 'Other disorders of mastoid',
        'short': 'Disorders of mastoid NEC'},
       {'code': '383.9',
        'long': 'Unspecified mastoiditis',
        'short': 'Mastoiditis NOS'},
       {'code': '384.00',
        'long': 'Acute myringitis, unspecified',
        'short': 'Acute myringitis NOS'},
       {'code': '384.01',
        'long': 'Bullous myringitis',
        'short': 'Bullous myringitis'},
       {'code': '384.09',
        'long': 'Other acute myringitis without mention of otitis media',
        'short': 'Acute myringitis NEC'},
       {'code': '384.1',
        'long': 'Chronic myringitis without mention of otitis media',
        'short': 'Chronic myringitis'},
       {'code': '384.20',
        'long': 'Perforation of tympanic membrane, unspecified',
        'short': 'Perforat tympan memb NOS'},
       {'code': '384.21',
        'long': 'Central perforation of tympanic membrane',
        'short': 'Cent perf tympanic memb'},
       {'code': '384.22',
        'long': 'Attic perforation of tympanic membrane',
        'short': 'Attic perf tympanic memb'},
       {'code': '384.23',
        'long': 'Other marginal perforation of tympanic membrane',
        'short': 'Marginal perf tymp NEC'},
       {'code': '384.24',
        'long': 'Multiple perforations of tympanic membrane',
        'short': 'Mult perf tympanic memb'},
       {'code': '384.25',
        'long': 'Total perforation of tympanic membrane',
        'short': 'Total perf tympanic memb'},
       {'code': '384.81',
        'long': 'Atrophic flaccid tympanic membrane',
        'short': 'Atrophic flaccid tympan'},
       {'code': '384.82',
        'long': 'Atrophic nonflaccid tympanic membrane',
        'short': 'Atrophic nonflaccid tymp'},
       {'code': '384.9',
        'long': 'Unspecified disorder of tympanic membrane',
        'short': 'Dis tympanic memb NOS'},
       {'code': '385.00',
        'long': 'Tympanosclerosis, unspecified as to involvement',
        'short': 'Tympanosclerosis NOS'},
       {'code': '385.01',
        'long': 'Tympanosclerosis involving tympanic membrane only',
        'short': 'Tympanoscl-tympanic memb'},
       {'code': '385.02',
        'long': 'Tympanosclerosis involving tympanic membrane and ear ossicles',
        'short': 'Tympnoscler-tymp/ossicle'},
       {'code': '385.03',
        'long': 'Tympanosclerosis involving tympanic membrane, ear ossicles, and middle ear',
        'short': 'Tympanoscler-all parts'},
       {'code': '385.09',
        'long': 'Tympanosclerosis involving other combination of structures',
        'short': 'Tympnsclr-oth site comb'},
       {'code': '385.10',
        'long': 'Adhesive middle ear disease, unspecified as to involvement',
        'short': 'Adhesive mid ear dis NOS'},
       {'code': '385.11',
        'long': 'Adhesions of drum head to incus',
        'short': 'Adhesion tympanum-incus'},
       {'code': '385.12',
        'long': 'Adhesions of drum head to stapes',
        'short': 'Adhesion tympanum-stapes'},
       {'code': '385.13',
        'long': 'Adhesions of drum head to promontorium',
        'short': 'Adhesion tymp-promontor'},
       {'code': '385.19',
        'long': 'Other middle ear adhesions and combinations',
        'short': 'Adhesive mid ear dis NEC'},
       {'code': '385.21',
        'long': 'Impaired mobility of malleus',
        'short': 'Ankylosis malleus'},
       {'code': '385.22',
        'long': 'Impaired mobility of other ear ossicles',
        'short': 'Ankylosis ear ossicl NEC'},
       {'code': '385.23',
        'long': 'Discontinuity or dislocation of ear ossicles',
        'short': 'Dislocation ear ossicle'},
       {'code': '385.24',
        'long': 'Partial loss or necrosis of ear ossicles',
        'short': 'Partial loss ear ossicle'},
       {'code': '385.30',
        'long': 'Cholesteatoma, unspecified',
        'short': 'Cholesteatoma NOS'},
       {'code': '385.31',
        'long': 'Cholesteatoma of attic',
        'short': 'Cholesteatoma of attic'},
       {'code': '385.32',
        'long': 'Cholesteatoma of middle ear',
        'short': 'Cholesteatoma middle ear'},
       {'code': '385.33',
        'long': 'Cholesteatoma of middle ear and mastoid',
        'short': 'Cholestma mid ear/mstoid'},
       {'code': '385.35',
        'long': 'Diffuse cholesteatosis of middle ear and mastoid',
        'short': 'Diffuse cholesteatosis'},
       {'code': '385.82',
        'long': 'Cholesterin granuloma of middle ear and mastoid',
        'short': 'Cholesterin granuloma'},
       {'code': '385.83',
        'long': 'Retained foreign body of middle ear',
        'short': 'Foreign body middle ear'},
       {'code': '385.89',
        'long': 'Other disorders of middle ear and mastoid',
        'short': 'Dis mid ear/mastoid NEC'},
       {'code': '385.9',
        'long': 'Unspecified disorder of middle ear and mastoid',
        'short': 'Dis mid ear/mastoid NOS'},
       {'code': '386.00',
        'long': "M\xc3\xa9ni\xc3\xa8re's disease, unspecified",
        'short': "Meniere's disease NOS"},
       {'code': '386.01',
        'long': "Active M\xc3\xa9ni\xc3\xa8re's disease, cochleovestibular",
        'short': 'Actv Meniere,cochlvestib'},
       {'code': '386.02',
        'long': "Active M\xc3\xa9ni\xc3\xa8re's disease, cochlear",
        'short': 'Active Meniere, cochlear'},
       {'code': '386.03',
        'long': "Active M\xc3\xa9ni\xc3\xa8re's disease, vestibular",
        'short': 'Actv Meniere, vestibular'},
       {'code': '386.04',
        'long': "Inactive M\xc3\xa9ni\xc3\xa8re's disease",
        'short': "Inactive Meniere's dis"},
       {'code': '386.10',
        'long': 'Peripheral vertigo, unspecified',
        'short': 'Peripheral vertigo NOS'},
       {'code': '386.11',
        'long': 'Benign paroxysmal positional vertigo',
        'short': 'Benign parxysmal vertigo'},
       {'code': '386.12',
        'long': 'Vestibular neuronitis',
        'short': 'Vestibular neuronitis'},
       {'code': '386.19',
        'long': 'Other peripheral vertigo',
        'short': 'Peripheral vertigo NEC'},
       {'code': '386.2',
        'long': 'Vertigo of central origin',
        'short': 'Central origin vertigo'},
       {'code': '386.30',
        'long': 'Labyrinthitis, unspecified',
        'short': 'Labyrinthitis NOS'},
       {'code': '386.31',
        'long': 'Serous labyrinthitis',
        'short': 'Serous labyrinthitis'},
       {'code': '386.32',
        'long': 'Circumscribed labyrinthitis',
        'short': 'Circumscri labyrinthitis'},
       {'code': '386.33',
        'long': 'Suppurative labyrinthitis',
        'short': 'Suppurativ labyrinthitis'},
       {'code': '386.34',
        'long': 'Toxic labyrinthitis',
        'short': 'Toxic labyrinthitis'},
       {'code': '386.35',
        'long': 'Viral labyrinthitis',
        'short': 'Viral labyrinthitis'},
       {'code': '386.40',
        'long': 'Labyrinthine fistula, unspecified',
        'short': 'Labyrinthine fistula NOS'},
       {'code': '386.41',
        'long': 'Round window fistula',
        'short': 'Round window fistula'},
       {'code': '386.42',
        'long': 'Oval window fistula',
        'short': 'Oval window fistula'},
       {'code': '386.43',
        'long': 'Semicircular canal fistula',
        'short': 'Semicircul canal fistula'},
       {'code': '386.48',
        'long': 'Labyrinthine fistula of combined sites',
        'short': 'Labyrinth fistula comb'},
       {'code': '386.50',
        'long': 'Labyrinthine dysfunction, unspecified',
        'short': 'Labyrinthine dysfunc NOS'},
       {'code': '386.51',
        'long': 'Hyperactive labyrinth, unilateral',
        'short': 'Hypract labyrinth unilat'},
       {'code': '386.52',
        'long': 'Hyperactive labyrinth, bilateral',
        'short': 'Hyperact labyrinth bilat'},
       {'code': '386.53',
        'long': 'Hypoactive labyrinth, unilateral',
        'short': 'Hypoact labyrinth unilat'},
       {'code': '386.54',
        'long': 'Hypoactive labyrinth, bilateral',
        'short': 'Hypoact labyrinth bilat'},
       {'code': '386.55',
        'long': 'Loss of labyrinthine reactivity, unilateral',
        'short': 'Loss labyrn react unilat'},
       {'code': '386.56',
        'long': 'Loss of labyrinthine reactivity, bilateral',
        'short': 'Loss labyrin react bilat'},
       {'code': '386.58',
        'long': 'Other forms and combinations of labyrinthine dysfunction',
        'short': 'Labyrinthine dysfunc NEC'},
       {'code': '386.8',
        'long': 'Other disorders of labyrinth',
        'short': 'Disorders labyrinth NEC'},
       {'code': '386.9',
        'long': 'Unspecified vertiginous syndromes and labyrinthine disorders',
        'short': 'Vertiginous synd NOS'},
       {'code': '387.0',
        'long': 'Otosclerosis involving oval window, nonobliterative',
        'short': 'Otoscler-oval wnd nonobl'},
       {'code': '387.1',
        'long': 'Otosclerosis involving oval window, obliterative',
        'short': 'Otoscler-oval wndw oblit'},
       {'code': '387.2',
        'long': 'Cochlear otosclerosis',
        'short': 'Cochlear otosclerosis'},
       {'code': '387.8',
        'long': 'Other otosclerosis',
        'short': 'Otosclerosis NEC'},
       {'code': '387.9',
        'long': 'Otosclerosis, unspecified',
        'short': 'Otosclerosis NOS'},
       {'code': '388.00',
        'long': 'Degenerative and vascular disorders, unspecified',
        'short': 'Degen/vascul dis ear NOS'},
       {'code': '388.01', 'long': 'Presbyacusis', 'short': 'Presbyacusis'},
       {'code': '388.02',
        'long': 'Transient ischemic deafness',
        'short': 'Trans ischemic deafness'},
       {'code': '388.10',
        'long': 'Noise effects on inner ear, unspecified',
        'short': 'Noise effect-ear/NOS'},
       {'code': '388.11',
        'long': 'Acoustic trauma (explosive) to ear',
        'short': 'Acoustic trauma'},
       {'code': '388.12',
        'long': 'Noise-induced hearing loss',
        'short': 'Hearing loss d/t noise'},
       {'code': '388.2',
        'long': 'Sudden hearing loss, unspecified',
        'short': 'Sudden hearing loss NOS'},
       {'code': '388.30',
        'long': 'Tinnitus, unspecified',
        'short': 'Tinnitus NOS'},
       {'code': '388.31',
        'long': 'Subjective tinnitus',
        'short': 'Subjective tinnitus'},
       {'code': '388.32',
        'long': 'Objective tinnitus',
        'short': 'Objective tinnitus'},
       {'code': '388.40',
        'long': 'Abnormal auditory perception, unspecified',
        'short': 'Abn auditory percept NOS'},
       {'code': '388.41', 'long': 'Diplacusis', 'short': 'Diplacusis'},
       {'code': '388.42', 'long': 'Hyperacusis', 'short': 'Hyperacusis'},
       {'code': '388.43',
        'long': 'Impairment of auditory discrimination',
        'short': 'Impairm auditory discrim'},
       {'code': '388.44',
        'long': 'Auditory recruitment',
        'short': 'Auditory recruitment'},
       {'code': '388.45',
        'long': 'Acquired auditory processing disorder',
        'short': 'Acq auditory process dis'},
       {'code': '388.5',
        'long': 'Disorders of acoustic nerve',
        'short': 'Acoustic nerve disorders'},
       {'code': '388.60',
        'long': 'Otorrhea, unspecified',
        'short': 'Otorrhea NOS'},
       {'code': '388.61',
        'long': 'Cerebrospinal fluid otorrhea',
        'short': 'Cerebrosp fluid otorrhea'},
       {'code': '388.69', 'long': 'Other otorrhea', 'short': 'Otorrhea NEC'},
       {'code': '388.70',
        'long': 'Otalgia, unspecified',
        'short': 'Otalgia NOS'},
       {'code': '388.71', 'long': 'Otogenic pain', 'short': 'Otogenic pain'},
       {'code': '388.72',
        'long': 'Referred otogenic pain',
        'short': 'Referred pain of ear'},
       {'code': '388.8',
        'long': 'Other disorders of ear',
        'short': 'Disorders of ear NEC'},
       {'code': '388.9',
        'long': 'Unspecified disorder of ear',
        'short': 'Disorder of ear NOS'},
       {'code': '389.00',
        'long': 'Conductive hearing loss, unspecified',
        'short': 'Conduct hearing loss NOS'},
       {'code': '389.01',
        'long': 'Conductive hearing loss, external ear',
        'short': 'Conduc hear loss ext ear'},
       {'code': '389.02',
        'long': 'Conductive hearing loss, tympanic membrane',
        'short': 'Conduct hear loss tympan'},
       {'code': '389.03',
        'long': 'Conductive hearing loss, middle ear',
        'short': 'Conduc hear loss mid ear'},
       {'code': '389.04',
        'long': 'Conductive hearing loss, inner ear',
        'short': 'Cond hear loss inner ear'},
       {'code': '389.05',
        'long': 'Conductive hearing loss, unilateral',
        'short': 'Condctv hear loss,unilat'},
       {'code': '389.06',
        'long': 'Conductive hearing loss, bilateral',
        'short': 'Condctv hear loss, bilat'},
       {'code': '389.08',
        'long': 'Conductive hearing loss of combined types',
        'short': 'Cond hear loss comb type'},
       {'code': '389.10',
        'long': 'Sensorineural hearing loss, unspecified',
        'short': 'Sensorneur hear loss NOS'},
       {'code': '389.11',
        'long': 'Sensory hearing loss, bilateral',
        'short': 'Sensry hearng loss,bilat'},
       {'code': '389.12',
        'long': 'Neural hearing loss, bilateral',
        'short': 'Neural hearng loss,bilat'},
       {'code': '389.13',
        'long': 'Neural hearing loss, unilateral',
        'short': 'Neural hear loss, unilat'},
       {'code': '389.14',
        'long': 'Central hearing loss',
        'short': 'Central hearing loss'},
       {'code': '389.15',
        'long': 'Sensorineural hearing loss, unilateral',
        'short': 'Sensorneur hear loss uni'},
       {'code': '389.16',
        'long': 'Sensorineural hearing loss, asymmetrical',
        'short': 'Sensoneur hear loss asym'},
       {'code': '389.17',
        'long': 'Sensory hearing loss, unilateral',
        'short': 'Sensory hear loss,unilat'},
       {'code': '389.18',
        'long': 'Sensorineural hearing loss, bilateral',
        'short': 'Sensonrl hear loss,bilat'},
       {'code': '389.20',
        'long': 'Mixed hearing loss, unspecified',
        'short': 'Mixed hearing loss NOS'},
       {'code': '389.21',
        'long': 'Mixed hearing loss, unilateral',
        'short': 'Mixed hearing loss,unilt'},
       {'code': '389.22',
        'long': 'Mixed hearing loss, bilateral',
        'short': 'Mixed hearing loss,bilat'},
       {'code': '389.7',
        'long': 'Deaf, nonspeaking, not elsewhere classifiable',
        'short': 'Deaf, nonspeaking NEC'},
       {'code': '389.8',
        'long': 'Other specified forms of hearing loss',
        'short': 'Hearing loss NEC'},
       {'code': '389.9',
        'long': 'Unspecified hearing loss',
        'short': 'Hearing loss NOS'}],
 'I': [{'code': '390',
        'long': 'Rheumatic fever without mention of heart involvement',
        'short': 'Rheum fev w/o hrt involv'},
       {'code': '391.0',
        'long': 'Acute rheumatic pericarditis',
        'short': 'Acute rheumatic pericard'},
       {'code': '391.1',
        'long': 'Acute rheumatic endocarditis',
        'short': 'Acute rheumatic endocard'},
       {'code': '391.2',
        'long': 'Acute rheumatic myocarditis',
        'short': 'Ac rheumatic myocarditis'},
       {'code': '391.8',
        'long': 'Other acute rheumatic heart disease',
        'short': 'Ac rheumat hrt dis NEC'},
       {'code': '391.9',
        'long': 'Acute rheumatic heart disease, unspecified',
        'short': 'Ac rheumat hrt dis NOS'},
       {'code': '392.0',
        'long': 'Rheumatic chorea with heart involvement',
        'short': 'Rheum chorea w hrt invol'},
       {'code': '392.9',
        'long': 'Rheumatic chorea without mention of heart involvement',
        'short': 'Rheumatic chorea NOS'},
       {'code': '393',
        'long': 'Chronic rheumatic pericarditis',
        'short': 'Chr rheumatic pericard'},
       {'code': '394.0',
        'long': 'Mitral stenosis',
        'short': 'Mitral stenosis'},
       {'code': '394.1',
        'long': 'Rheumatic mitral insufficiency',
        'short': 'Rheumatic mitral insuff'},
       {'code': '394.2',
        'long': 'Mitral stenosis with insufficiency',
        'short': 'Mitral stenosis w insuff'},
       {'code': '394.9',
        'long': 'Other and unspecified mitral valve diseases',
        'short': 'Mitral valve dis NEC/NOS'},
       {'code': '395.0',
        'long': 'Rheumatic aortic stenosis',
        'short': 'Rheumat aortic stenosis'},
       {'code': '395.1',
        'long': 'Rheumatic aortic insufficiency',
        'short': 'Rheumatic aortic insuff'},
       {'code': '395.2',
        'long': 'Rheumatic aortic stenosis with insufficiency',
        'short': 'Rheum aortic sten/insuff'},
       {'code': '395.9',
        'long': 'Other and unspecified rheumatic aortic diseases',
        'short': 'Rheum aortic dis NEC/NOS'},
       {'code': '396.0',
        'long': 'Mitral valve stenosis and aortic valve stenosis',
        'short': 'Mitral/aortic stenosis'},
       {'code': '396.1',
        'long': 'Mitral valve stenosis and aortic valve insufficiency',
        'short': 'Mitral stenos/aort insuf'},
       {'code': '396.2',
        'long': 'Mitral valve insufficiency and aortic valve stenosis',
        'short': 'Mitral insuf/aort stenos'},
       {'code': '396.3',
        'long': 'Mitral valve insufficiency and aortic valve insufficiency',
        'short': 'Mitral/aortic val insuff'},
       {'code': '396.8',
        'long': 'Multiple involvement of mitral and aortic valves',
        'short': 'Mitr/aortic mult involv'},
       {'code': '396.9',
        'long': 'Mitral and aortic valve diseases, unspecified',
        'short': 'Mitral/aortic v dis NOS'},
       {'code': '397.0',
        'long': 'Diseases of tricuspid valve',
        'short': 'Tricuspid valve disease'},
       {'code': '397.1',
        'long': 'Rheumatic diseases of pulmonary valve',
        'short': 'Rheum pulmon valve dis'},
       {'code': '397.9',
        'long': 'Rheumatic diseases of endocardium, valve unspecified',
        'short': 'Rheum endocarditis NOS'},
       {'code': '398.0',
        'long': 'Rheumatic myocarditis',
        'short': 'Rheumatic myocarditis'},
       {'code': '398.90',
        'long': 'Rheumatic heart disease, unspecified',
        'short': 'Rheumatic heart dis NOS'},
       {'code': '398.91',
        'long': 'Rheumatic heart failure (congestive)',
        'short': 'Rheumatic heart failure'},
       {'code': '398.99',
        'long': 'Other rheumatic heart diseases',
        'short': 'Rheumatic heart dis NEC'},
       {'code': '401.0',
        'long': 'Malignant essential hypertension',
        'short': 'Malignant hypertension'},
       {'code': '401.1',
        'long': 'Benign essential hypertension',
        'short': 'Benign hypertension'},
       {'code': '401.9',
        'long': 'Unspecified essential hypertension',
        'short': 'Hypertension NOS'},
       {'code': '402.00',
        'long': 'Malignant hypertensive heart disease without heart failure',
        'short': 'Mal hyp ht dis w/o hf'},
       {'code': '402.01',
        'long': 'Malignant hypertensive heart disease with heart failure',
        'short': 'Mal hypert hrt dis w hf'},
       {'code': '402.10',
        'long': 'Benign hypertensive heart disease without heart failure',
        'short': 'Benign hyp ht dis w/o hf'},
       {'code': '402.11',
        'long': 'Benign hypertensive heart disease with heart failure',
        'short': 'Benign hyp ht dis w hf'},
       {'code': '402.90',
        'long': 'Unspecified hypertensive heart disease without heart failure',
        'short': 'Hyp hrt dis NOS w/o hf'},
       {'code': '402.91',
        'long': 'Unspecified hypertensive heart disease with heart failure',
        'short': 'Hyp ht dis NOS w ht fail'},
       {'code': '403.00',
        'long': 'Hypertensive chronic kidney disease, malignant, with chronic kidney disease stage I through stage IV, or unspecified',
        'short': 'Mal hy kid w cr kid I-IV'},
       {'code': '403.01',
        'long': 'Hypertensive chronic kidney disease, malignant, with chronic kidney disease stage V or end stage renal disease',
        'short': 'Mal hyp kid w cr kid V'},
       {'code': '403.10',
        'long': 'Hypertensive chronic kidney disease, benign, with chronic kidney disease stage I through stage IV, or unspecified',
        'short': 'Ben hy kid w cr kid I-IV'},
       {'code': '403.11',
        'long': 'Hypertensive chronic kidney disease, benign, with chronic kidney disease stage V or end stage renal disease',
        'short': 'Ben hyp kid w cr kid V'},
       {'code': '403.90',
        'long': 'Hypertensive chronic kidney disease, unspecified, with chronic kidney disease stage I through stage IV, or unspecified',
        'short': 'Hy kid NOS w cr kid I-IV'},
       {'code': '403.91',
        'long': 'Hypertensive chronic kidney disease, unspecified, with chronic kidney disease stage V or end stage renal disease',
        'short': 'Hyp kid NOS w cr kid V'},
       {'code': '404.00',
        'long': 'Hypertensive heart and chronic kidney disease, malignant, without heart failure and with chronic kidney disease stage I through stage IV, or unspecified',
        'short': 'Mal hy ht/kd I-IV w/o hf'},
       {'code': '404.01',
        'long': 'Hypertensive heart and chronic kidney disease, malignant, with heart failure and with chronic kidney disease stage I through stage IV, or unspecified',
        'short': 'Mal hyp ht/kd I-IV w hf'},
       {'code': '404.02',
        'long': 'Hypertensive heart and chronic kidney disease, malignant, without heart failure and with chronic kidney disease stage V or end stage renal disease',
        'short': 'Mal hy ht/kd st V w/o hf'},
       {'code': '404.03',
        'long': 'Hypertensive heart and chronic kidney disease, malignant, with heart failure and with chronic kidney disease stage V or end stage renal disease',
        'short': 'Mal hyp ht/kd stg V w hf'},
       {'code': '404.10',
        'long': 'Hypertensive heart and chronic kidney disease, benign, without heart failure and with chronic kidney disease stage I through stage IV, or unspecified',
        'short': 'Ben hy ht/kd I-IV w/o hf'},
       {'code': '404.11',
        'long': 'Hypertensive heart and chronic kidney disease, benign, with heart failure and with chronic kidney disease stage I through stage IV, or unspecified',
        'short': 'Ben hyp ht/kd I-IV w hf'},
       {'code': '404.12',
        'long': 'Hypertensive heart and chronic kidney disease, benign, without heart failure and with chronic kidney disease stage V or end stage renal disease',
        'short': 'Ben hy ht/kd st V w/o hf'},
       {'code': '404.13',
        'long': 'Hypertensive heart and chronic kidney disease, benign, with heart failure and chronic kidney disease stage V or end stage renal disease',
        'short': 'Ben hyp ht/kd stg V w hf'},
       {'code': '404.90',
        'long': 'Hypertensive heart and chronic kidney disease, unspecified, without heart failure and with chronic kidney disease stage I through stage IV, or unspecified',
        'short': 'Hy ht/kd NOS I-IV w/o hf'},
       {'code': '404.91',
        'long': 'Hypertensive heart and chronic kidney disease, unspecified, with heart failure and with chronic kidney disease stage I through stage IV, or unspecified',
        'short': 'Hyp ht/kd NOS I-IV w hf'},
       {'code': '404.92',
        'long': 'Hypertensive heart and chronic kidney disease, unspecified, without heart failure and with chronic kidney disease stage V or end stage renal disease',
        'short': 'Hy ht/kd NOS st V w/o hf'},
       {'code': '404.93',
        'long': 'Hypertensive heart and chronic kidney disease, unspecified, with heart failure and chronic kidney disease stage V or end stage renal disease',
        'short': 'Hyp ht/kd NOS st V w hf'},
       {'code': '405.01',
        'long': 'Malignant renovascular hypertension',
        'short': 'Mal renovasc hypertens'},
       {'code': '405.09',
        'long': 'Other malignant secondary hypertension',
        'short': 'Mal second hyperten NEC'},
       {'code': '405.11',
        'long': 'Benign renovascular hypertension',
        'short': 'Benign renovasc hyperten'},
       {'code': '405.19',
        'long': 'Other benign secondary hypertension',
        'short': 'Benign second hypert NEC'},
       {'code': '405.91',
        'long': 'Unspecified renovascular hypertension',
        'short': 'Renovasc hypertension'},
       {'code': '405.99',
        'long': 'Other unspecified secondary hypertension',
        'short': 'Second hypertension NEC'},
       {'code': '410.00',
        'long': 'Acute myocardial infarction of anterolateral wall, episode of care unspecified',
        'short': 'AMI anterolateral,unspec'},
       {'code': '410.01',
        'long': 'Acute myocardial infarction of anterolateral wall, initial episode of care',
        'short': 'AMI anterolateral, init'},
       {'code': '410.02',
        'long': 'Acute myocardial infarction of anterolateral wall, subsequent episode of care',
        'short': 'AMI anterolateral,subseq'},
       {'code': '410.10',
        'long': 'Acute myocardial infarction of other anterior wall, episode of care unspecified',
        'short': 'AMI anterior wall,unspec'},
       {'code': '410.11',
        'long': 'Acute myocardial infarction of other anterior wall, initial episode of care',
        'short': 'AMI anterior wall, init'},
       {'code': '410.12',
        'long': 'Acute myocardial infarction of other anterior wall, subsequent episode of care',
        'short': 'AMI anterior wall,subseq'},
       {'code': '410.20',
        'long': 'Acute myocardial infarction of inferolateral wall, episode of care unspecified',
        'short': 'AMI inferolateral,unspec'},
       {'code': '410.21',
        'long': 'Acute myocardial infarction of inferolateral wall, initial episode of care',
        'short': 'AMI inferolateral, init'},
       {'code': '410.22',
        'long': 'Acute myocardial infarction of inferolateral wall, subsequent episode of care',
        'short': 'AMI inferolateral,subseq'},
       {'code': '410.30',
        'long': 'Acute myocardial infarction of inferoposterior wall, episode of care unspecified',
        'short': 'AMI inferopost, unspec'},
       {'code': '410.31',
        'long': 'Acute myocardial infarction of inferoposterior wall, initial episode of care',
        'short': 'AMI inferopost, initial'},
       {'code': '410.32',
        'long': 'Acute myocardial infarction of inferoposterior wall, subsequent episode of care',
        'short': 'AMI inferopost, subseq'},
       {'code': '410.40',
        'long': 'Acute myocardial infarction of other inferior wall, episode of care unspecified',
        'short': 'AMI inferior wall,unspec'},
       {'code': '410.41',
        'long': 'Acute myocardial infarction of other inferior wall, initial episode of care',
        'short': 'AMI inferior wall, init'},
       {'code': '410.42',
        'long': 'Acute myocardial infarction of other inferior wall, subsequent episode of care',
        'short': 'AMI inferior wall,subseq'},
       {'code': '410.50',
        'long': 'Acute myocardial infarction of other lateral wall, episode of care unspecified',
        'short': 'AMI lateral NEC, unspec'},
       {'code': '410.51',
        'long': 'Acute myocardial infarction of other lateral wall, initial episode of care',
        'short': 'AMI lateral NEC, initial'},
       {'code': '410.52',
        'long': 'Acute myocardial infarction of other lateral wall, subsequent episode of care',
        'short': 'AMI lateral NEC, subseq'},
       {'code': '410.60',
        'long': 'True posterior wall infarction, episode of care unspecified',
        'short': 'True post infarct,unspec'},
       {'code': '410.61',
        'long': 'True posterior wall infarction, initial episode of care',
        'short': 'True post infarct, init'},
       {'code': '410.62',
        'long': 'True posterior wall infarction, subsequent episode of care',
        'short': 'True post infarct,subseq'},
       {'code': '410.70',
        'long': 'Subendocardial infarction, episode of care unspecified',
        'short': 'Subendo infarct, unspec'},
       {'code': '410.71',
        'long': 'Subendocardial infarction, initial episode of care',
        'short': 'Subendo infarct, initial'},
       {'code': '410.72',
        'long': 'Subendocardial infarction, subsequent episode of care',
        'short': 'Subendo infarct, subseq'},
       {'code': '410.80',
        'long': 'Acute myocardial infarction of other specified sites, episode of care unspecified',
        'short': 'AMI NEC, unspecified'},
       {'code': '410.81',
        'long': 'Acute myocardial infarction of other specified sites, initial episode of care',
        'short': 'AMI NEC, initial'},
       {'code': '410.82',
        'long': 'Acute myocardial infarction of other specified sites, subsequent episode of care',
        'short': 'AMI NEC, subsequent'},
       {'code': '410.90',
        'long': 'Acute myocardial infarction of unspecified site, episode of care unspecified',
        'short': 'AMI NOS, unspecified'},
       {'code': '410.91',
        'long': 'Acute myocardial infarction of unspecified site, initial episode of care',
        'short': 'AMI NOS, initial'},
       {'code': '410.92',
        'long': 'Acute myocardial infarction of unspecified site, subsequent episode of care',
        'short': 'AMI NOS, subsequent'},
       {'code': '411.0',
        'long': 'Postmyocardial infarction syndrome',
        'short': 'Post MI syndrome'},
       {'code': '411.1',
        'long': 'Intermediate coronary syndrome',
        'short': 'Intermed coronary synd'},
       {'code': '411.81',
        'long': 'Acute coronary occlusion without myocardial infarction',
        'short': 'Acute cor occlsn w/o MI'},
       {'code': '411.89',
        'long': 'Other acute and subacute forms of ischemic heart disease, other',
        'short': 'Ac ischemic hrt dis NEC'},
       {'code': '412',
        'long': 'Old myocardial infarction',
        'short': 'Old myocardial infarct'},
       {'code': '413.0',
        'long': 'Angina decubitus',
        'short': 'Angina decubitus'},
       {'code': '413.1',
        'long': 'Prinzmetal angina',
        'short': 'Prinzmetal angina'},
       {'code': '413.9',
        'long': 'Other and unspecified angina pectoris',
        'short': 'Angina pectoris NEC/NOS'},
       {'code': '414.00',
        'long': 'Coronary atherosclerosis of unspecified type of vessel, native or graft',
        'short': 'Cor ath unsp vsl ntv/gft'},
       {'code': '414.01',
        'long': 'Coronary atherosclerosis of native coronary artery',
        'short': 'Crnry athrscl natve vssl'},
       {'code': '414.02',
        'long': 'Coronary atherosclerosis of autologous vein bypass graft',
        'short': 'Crn ath atlg vn bps grft'},
       {'code': '414.03',
        'long': 'Coronary atherosclerosis of nonautologous biological bypass graft',
        'short': 'Crn ath nonatlg blg grft'},
       {'code': '414.04',
        'long': 'Coronary atherosclerosis of artery bypass graft',
        'short': 'Cor ath artry bypas grft'},
       {'code': '414.05',
        'long': 'Coronary atherosclerosis of unspecified bypass graft',
        'short': 'Cor ath bypass graft NOS'},
       {'code': '414.06',
        'long': 'Coronary atherosclerosis of native coronary artery of transplanted heart',
        'short': 'Cor ath natv art tp hrt'},
       {'code': '414.07',
        'long': 'Coronary atherosclerosis of bypass graft (artery) (vein) of transplanted heart',
        'short': 'Cor ath bps graft tp hrt'},
       {'code': '414.10',
        'long': 'Aneurysm of heart (wall)',
        'short': 'Aneurysm of heart'},
       {'code': '414.11',
        'long': 'Aneurysm of coronary vessels',
        'short': 'Aneurysm coronary vessel'},
       {'code': '414.12',
        'long': 'Dissection of coronary artery',
        'short': 'Dissection cor artery'},
       {'code': '414.19',
        'long': 'Other aneurysm of heart',
        'short': 'Aneurysm of heart NEC'},
       {'code': '414.2',
        'long': 'Chronic total occlusion of coronary artery',
        'short': 'Chr tot occlus cor artry'},
       {'code': '414.3',
        'long': 'Coronary atherosclerosis due to lipid rich plaque',
        'short': 'Cor ath d/t lpd rch plaq'},
       {'code': '414.4',
        'long': 'Coronary atherosclerosis due to calcified coronary lesion',
        'short': 'Cor ath d/t calc cor lsn'},
       {'code': '414.8',
        'long': 'Other specified forms of chronic ischemic heart disease',
        'short': 'Chr ischemic hrt dis NEC'},
       {'code': '414.9',
        'long': 'Chronic ischemic heart disease, unspecified',
        'short': 'Chr ischemic hrt dis NOS'},
       {'code': '415.0',
        'long': 'Acute cor pulmonale',
        'short': 'Acute cor pulmonale'},
       {'code': '415.11',
        'long': 'Iatrogenic pulmonary embolism and infarction',
        'short': 'Iatrogen pulm emb/infarc'},
       {'code': '415.12',
        'long': 'Septic pulmonary embolism',
        'short': 'Septic pulmonary embolsm'},
       {'code': '415.13',
        'long': 'Saddle embolus of pulmonary artery',
        'short': 'Saddle embol pulmon art'},
       {'code': '415.19',
        'long': 'Other pulmonary embolism and infarction',
        'short': 'Pulm embol/infarct NEC'},
       {'code': '416.0',
        'long': 'Primary pulmonary hypertension',
        'short': 'Prim pulm hypertension'},
       {'code': '416.1',
        'long': 'Kyphoscoliotic heart disease',
        'short': 'Kyphoscoliotic heart dis'},
       {'code': '416.2',
        'long': 'Chronic pulmonary embolism',
        'short': 'Chr pulmonary embolism'},
       {'code': '416.8',
        'long': 'Other chronic pulmonary heart diseases',
        'short': 'Chr pulmon heart dis NEC'},
       {'code': '416.9',
        'long': 'Chronic pulmonary heart disease, unspecified',
        'short': 'Chr pulmon heart dis NOS'},
       {'code': '417.0',
        'long': 'Arteriovenous fistula of pulmonary vessels',
        'short': 'Arterioven fistu pul ves'},
       {'code': '417.1',
        'long': 'Aneurysm of pulmonary artery',
        'short': 'Pulmon artery aneurysm'},
       {'code': '417.8',
        'long': 'Other specified diseases of pulmonary circulation',
        'short': 'Pulmon circulat dis NEC'},
       {'code': '417.9',
        'long': 'Unspecified disease of pulmonary circulation',
        'short': 'Pulmon circulat dis NOS'},
       {'code': '420.0',
        'long': 'Acute pericarditis in diseases classified elsewhere',
        'short': 'Ac pericardit in oth dis'},
       {'code': '420.90',
        'long': 'Acute pericarditis, unspecified',
        'short': 'Acute pericarditis NOS'},
       {'code': '420.91',
        'long': 'Acute idiopathic pericarditis',
        'short': 'Ac idiopath pericarditis'},
       {'code': '420.99',
        'long': 'Other acute pericarditis',
        'short': 'Acute pericarditis NEC'},
       {'code': '421.0',
        'long': 'Acute and subacute bacterial endocarditis',
        'short': 'Ac/subac bact endocard'},
       {'code': '421.1',
        'long': 'Acute and subacute infective endocarditis in diseases classified elsewhere',
        'short': 'Ac endocardit in oth dis'},
       {'code': '421.9',
        'long': 'Acute endocarditis, unspecified',
        'short': 'Ac/subac endocardit NOS'},
       {'code': '422.0',
        'long': 'Acute myocarditis in diseases classified elsewhere',
        'short': 'Ac myocardit in oth dis'},
       {'code': '422.90',
        'long': 'Acute myocarditis, unspecified',
        'short': 'Acute myocarditis NOS'},
       {'code': '422.91',
        'long': 'Idiopathic myocarditis',
        'short': 'Idiopathic myocarditis'},
       {'code': '422.92',
        'long': 'Septic myocarditis',
        'short': 'Septic myocarditis'},
       {'code': '422.93',
        'long': 'Toxic myocarditis',
        'short': 'Toxic myocarditis'},
       {'code': '422.99',
        'long': 'Other acute myocarditis',
        'short': 'Acute myocarditis NEC'},
       {'code': '423.0',
        'long': 'Hemopericardium',
        'short': 'Hemopericardium'},
       {'code': '423.1',
        'long': 'Adhesive pericarditis',
        'short': 'Adhesive pericarditis'},
       {'code': '423.2',
        'long': 'Constrictive pericarditis',
        'short': 'Constrictiv pericarditis'},
       {'code': '423.3',
        'long': 'Cardiac tamponade',
        'short': 'Cardiac tamponade'},
       {'code': '423.8',
        'long': 'Other specified diseases of pericardium',
        'short': 'Pericardial disease NEC'},
       {'code': '423.9',
        'long': 'Unspecified disease of pericardium',
        'short': 'Pericardial disease NOS'},
       {'code': '424.0',
        'long': 'Mitral valve disorders',
        'short': 'Mitral valve disorder'},
       {'code': '424.1',
        'long': 'Aortic valve disorders',
        'short': 'Aortic valve disorder'},
       {'code': '424.2',
        'long': 'Tricuspid valve disorders, specified as nonrheumatic',
        'short': 'Nonrheum tricusp val dis'},
       {'code': '424.3',
        'long': 'Pulmonary valve disorders',
        'short': 'Pulmonary valve disorder'},
       {'code': '424.90',
        'long': 'Endocarditis, valve unspecified, unspecified cause',
        'short': 'Endocarditis NOS'},
       {'code': '424.91',
        'long': 'Endocarditis in diseases classified elsewhere',
        'short': 'Endocarditis in oth dis'},
       {'code': '424.99',
        'long': 'Other endocarditis, valve unspecified',
        'short': 'Endocarditis NEC'},
       {'code': '425.0',
        'long': 'Endomyocardial fibrosis',
        'short': 'Endomyocardial fibrosis'},
       {'code': '425.11',
        'long': 'Hypertrophic obstructive cardiomyopathy',
        'short': 'Hyprtrophc obst cardiomy'},
       {'code': '425.18',
        'long': 'Other hypertrophic cardiomyopathy',
        'short': 'Oth hyprtrophic cardiomy'},
       {'code': '425.2',
        'long': 'Obscure cardiomyopathy of Africa',
        'short': 'Obsc afric cardiomyopath'},
       {'code': '425.3',
        'long': 'Endocardial fibroelastosis',
        'short': 'Endocard fibroelastosis'},
       {'code': '425.4',
        'long': 'Other primary cardiomyopathies',
        'short': 'Prim cardiomyopathy NEC'},
       {'code': '425.5',
        'long': 'Alcoholic cardiomyopathy',
        'short': 'Alcoholic cardiomyopathy'},
       {'code': '425.7',
        'long': 'Nutritional and metabolic cardiomyopathy',
        'short': 'Metabolic cardiomyopathy'},
       {'code': '425.8',
        'long': 'Cardiomyopathy in other diseases classified elsewhere',
        'short': 'Cardiomyopath in oth dis'},
       {'code': '425.9',
        'long': 'Secondary cardiomyopathy, unspecified',
        'short': 'Second cardiomyopath NOS'},
       {'code': '426.0',
        'long': 'Atrioventricular block, complete',
        'short': 'Atriovent block complete'},
       {'code': '426.10',
        'long': 'Atrioventricular block, unspecified',
        'short': 'Atriovent block NOS'},
       {'code': '426.11',
        'long': 'First degree atrioventricular block',
        'short': 'Atriovent block-1st degr'},
       {'code': '426.12',
        'long': 'Mobitz (type) II atrioventricular block',
        'short': 'Atrioven block-mobitz ii'},
       {'code': '426.13',
        'long': 'Other second degree atrioventricular block',
        'short': 'Av block-2nd degree NEC'},
       {'code': '426.2',
        'long': 'Left bundle branch hemiblock',
        'short': 'Left bb hemiblock'},
       {'code': '426.3',
        'long': 'Other left bundle branch block',
        'short': 'Left bb block NEC'},
       {'code': '426.4',
        'long': 'Right bundle branch block',
        'short': 'Rt bundle branch block'},
       {'code': '426.50',
        'long': 'Bundle branch block, unspecified',
        'short': 'Bundle branch block NOS'},
       {'code': '426.51',
        'long': 'Right bundle branch block and left posterior fascicular block',
        'short': 'Rt bbb/lft post fasc blk'},
       {'code': '426.52',
        'long': 'Right bundle branch block and left anterior fascicular block',
        'short': 'Rt bbb/lft ant fasc blk'},
       {'code': '426.53',
        'long': 'Other bilateral bundle branch block',
        'short': 'Bilat bb block NEC'},
       {'code': '426.54',
        'long': 'Trifascicular block',
        'short': 'Trifascicular block'},
       {'code': '426.6',
        'long': 'Other heart block',
        'short': 'Other heart block'},
       {'code': '426.7',
        'long': 'Anomalous atrioventricular excitation',
        'short': 'Anomalous av excitation'},
       {'code': '426.81',
        'long': 'Lown-Ganong-Levine syndrome',
        'short': 'Lown-ganong-levine synd'},
       {'code': '426.82',
        'long': 'Long QT syndrome',
        'short': 'Long QT syndrome'},
       {'code': '426.89',
        'long': 'Other specified conduction disorders',
        'short': 'Conduction disorder NEC'},
       {'code': '426.9',
        'long': 'Conduction disorder, unspecified',
        'short': 'Conduction disorder NOS'},
       {'code': '427.0',
        'long': 'Paroxysmal supraventricular tachycardia',
        'short': 'Parox atrial tachycardia'},
       {'code': '427.1',
        'long': 'Paroxysmal ventricular tachycardia',
        'short': 'Parox ventric tachycard'},
       {'code': '427.2',
        'long': 'Paroxysmal tachycardia, unspecified',
        'short': 'Parox tachycardia NOS'},
       {'code': '427.31',
        'long': 'Atrial fibrillation',
        'short': 'Atrial fibrillation'},
       {'code': '427.32',
        'long': 'Atrial flutter',
        'short': 'Atrial flutter'},
       {'code': '427.41',
        'long': 'Ventricular fibrillation',
        'short': 'Ventricular fibrillation'},
       {'code': '427.42',
        'long': 'Ventricular flutter',
        'short': 'Ventricular flutter'},
       {'code': '427.5', 'long': 'Cardiac arrest', 'short': 'Cardiac arrest'},
       {'code': '427.60',
        'long': 'Premature beats, unspecified',
        'short': 'Premature beats NOS'},
       {'code': '427.61',
        'long': 'Supraventricular premature beats',
        'short': 'Atrial premature beats'},
       {'code': '427.69',
        'long': 'Other premature beats',
        'short': 'Premature beats NEC'},
       {'code': '427.81',
        'long': 'Sinoatrial node dysfunction',
        'short': 'Sinoatrial node dysfunct'},
       {'code': '427.89',
        'long': 'Other specified cardiac dysrhythmias',
        'short': 'Cardiac dysrhythmias NEC'},
       {'code': '427.9',
        'long': 'Cardiac dysrhythmia, unspecified',
        'short': 'Cardiac dysrhythmia NOS'},
       {'code': '428.0',
        'long': 'Congestive heart failure, unspecified',
        'short': 'CHF NOS'},
       {'code': '428.1',
        'long': 'Left heart failure',
        'short': 'Left heart failure'},
       {'code': '428.20',
        'long': 'Systolic heart failure, unspecified',
        'short': 'Systolic hrt failure NOS'},
       {'code': '428.21',
        'long': 'Acute systolic heart failure',
        'short': 'Ac systolic hrt failure'},
       {'code': '428.22',
        'long': 'Chronic systolic heart failure',
        'short': 'Chr systolic hrt failure'},
       {'code': '428.23',
        'long': 'Acute on chronic systolic heart failure',
        'short': 'Ac on chr syst hrt fail'},
       {'code': '428.30',
        'long': 'Diastolic heart failure, unspecified',
        'short': 'Diastolc hrt failure NOS'},
       {'code': '428.31',
        'long': 'Acute diastolic heart failure',
        'short': 'Ac diastolic hrt failure'},
       {'code': '428.32',
        'long': 'Chronic diastolic heart failure',
        'short': 'Chr diastolic hrt fail'},
       {'code': '428.33',
        'long': 'Acute on chronic diastolic heart failure',
        'short': 'Ac on chr diast hrt fail'},
       {'code': '428.40',
        'long': 'Combined systolic and diastolic heart failure, unspecified',
        'short': 'Syst/diast hrt fail NOS'},
       {'code': '428.41',
        'long': 'Acute combined systolic and diastolic heart failure',
        'short': 'Ac syst/diastol hrt fail'},
       {'code': '428.42',
        'long': 'Chronic combined systolic and diastolic heart failure',
        'short': 'Chr syst/diastl hrt fail'},
       {'code': '428.43',
        'long': 'Acute on chronic combined systolic and diastolic heart failure',
        'short': 'Ac/chr syst/dia hrt fail'},
       {'code': '428.9',
        'long': 'Heart failure, unspecified',
        'short': 'Heart failure NOS'},
       {'code': '429.0',
        'long': 'Myocarditis, unspecified',
        'short': 'Myocarditis NOS'},
       {'code': '429.1',
        'long': 'Myocardial degeneration',
        'short': 'Myocardial degeneration'},
       {'code': '429.2',
        'long': 'Cardiovascular disease, unspecified',
        'short': 'Ascvd'},
       {'code': '429.3', 'long': 'Cardiomegaly', 'short': 'Cardiomegaly'},
       {'code': '429.4',
        'long': 'Functional disturbances following cardiac surgery',
        'short': 'Hrt dis postcardiac surg'},
       {'code': '429.5',
        'long': 'Rupture of chordae tendineae',
        'short': 'Chordae tendinae rupture'},
       {'code': '429.6',
        'long': 'Rupture of papillary muscle',
        'short': 'Papillary muscle rupture'},
       {'code': '429.71',
        'long': 'Acquired cardiac septal defect',
        'short': 'Acq cardiac septl defect'},
       {'code': '429.79',
        'long': 'Certain sequelae of myocardial infarction, not elsewhere classified, other',
        'short': 'Other sequelae of MI NEC'},
       {'code': '429.81',
        'long': 'Other disorders of papillary muscle',
        'short': 'Papillary muscle dis NEC'},
       {'code': '429.82',
        'long': 'Hyperkinetic heart disease',
        'short': 'Hyperkinetic heart dis'},
       {'code': '429.83',
        'long': 'Takotsubo syndrome',
        'short': 'Takotsubo syndrome'},
       {'code': '429.89',
        'long': 'Other ill-defined heart diseases',
        'short': 'Ill-defined hrt dis NEC'},
       {'code': '429.9',
        'long': 'Heart disease, unspecified',
        'short': 'Heart disease NOS'},
       {'code': '430',
        'long': 'Subarachnoid hemorrhage',
        'short': 'Subarachnoid hemorrhage'},
       {'code': '431',
        'long': 'Intracerebral hemorrhage',
        'short': 'Intracerebral hemorrhage'},
       {'code': '432.0',
        'long': 'Nontraumatic extradural hemorrhage',
        'short': 'Nontraum extradural hem'},
       {'code': '432.1',
        'long': 'Subdural hemorrhage',
        'short': 'Subdural hemorrhage'},
       {'code': '432.9',
        'long': 'Unspecified intracranial hemorrhage',
        'short': 'Intracranial hemorr NOS'},
       {'code': '433.00',
        'long': 'Occlusion and stenosis of basilar artery without mention of cerebral infarction',
        'short': 'Ocl bslr art wo infrct'},
       {'code': '433.01',
        'long': 'Occlusion and stenosis of basilar artery with cerebral infarction',
        'short': 'Ocl bslr art w infrct'},
       {'code': '433.10',
        'long': 'Occlusion and stenosis of carotid artery without mention of cerebral infarction',
        'short': 'Ocl crtd art wo infrct'},
       {'code': '433.11',
        'long': 'Occlusion and stenosis of carotid artery with cerebral infarction',
        'short': 'Ocl crtd art w infrct'},
       {'code': '433.20',
        'long': 'Occlusion and stenosis of vertebral artery without mention of cerebral infarction',
        'short': 'Ocl vrtb art wo infrct'},
       {'code': '433.21',
        'long': 'Occlusion and stenosis of vertebral artery with cerebral infarction',
        'short': 'Ocl vrtb art w infrct'},
       {'code': '433.30',
        'long': 'Occlusion and stenosis of multiple and bilateral precerebral arteries without mention of cerebral infarction',
        'short': 'Ocl mlt bi art wo infrct'},
       {'code': '433.31',
        'long': 'Occlusion and stenosis of multiple and bilateral precerebral arteries with cerebral infarction',
        'short': 'Ocl mlt bi art w infrct'},
       {'code': '433.80',
        'long': 'Occlusion and stenosis of other specified precerebral artery without mention of cerebral infarction',
        'short': 'Ocl spcf art wo infrct'},
       {'code': '433.81',
        'long': 'Occlusion and stenosis of other specified precerebral artery with cerebral infarction',
        'short': 'Ocl spcf art w infrct'},
       {'code': '433.90',
        'long': 'Occlusion and stenosis of unspecified precerebral artery without mention of cerebral infarction',
        'short': 'Ocl art NOS wo infrct'},
       {'code': '433.91',
        'long': 'Occlusion and stenosis of unspecified precerebral artery with cerebral infarction',
        'short': 'Ocl art NOS w infrct'},
       {'code': '434.00',
        'long': 'Cerebral thrombosis without mention of cerebral infarction',
        'short': 'Crbl thrmbs wo infrct'},
       {'code': '434.01',
        'long': 'Cerebral thrombosis with cerebral infarction',
        'short': 'Crbl thrmbs w infrct'},
       {'code': '434.10',
        'long': 'Cerebral embolism without mention of cerebral infarction',
        'short': 'Crbl emblsm wo infrct'},
       {'code': '434.11',
        'long': 'Cerebral embolism with cerebral infarction',
        'short': 'Crbl emblsm w infrct'},
       {'code': '434.90',
        'long': 'Cerebral artery occlusion, unspecified without mention of cerebral infarction',
        'short': 'Crbl art oc NOS wo infrc'},
       {'code': '434.91',
        'long': 'Cerebral artery occlusion, unspecified with cerebral infarction',
        'short': 'Crbl art ocl NOS w infrc'},
       {'code': '435.0',
        'long': 'Basilar artery syndrome',
        'short': 'Basilar artery syndrome'},
       {'code': '435.1',
        'long': 'Vertebral artery syndrome',
        'short': 'Vertebral artery syndrom'},
       {'code': '435.2',
        'long': 'Subclavian steal syndrome',
        'short': 'Subclavian steal syndrom'},
       {'code': '435.3',
        'long': 'Vertebrobasilar artery syndrome',
        'short': 'Vertbrobaslr artery synd'},
       {'code': '435.8',
        'long': 'Other specified transient cerebral ischemias',
        'short': 'Trans cereb ischemia NEC'},
       {'code': '435.9',
        'long': 'Unspecified transient cerebral ischemia',
        'short': 'Trans cereb ischemia NOS'},
       {'code': '436',
        'long': 'Acute, but ill-defined, cerebrovascular disease',
        'short': 'Cva'},
       {'code': '437.0',
        'long': 'Cerebral atherosclerosis',
        'short': 'Cerebral atherosclerosis'},
       {'code': '437.1',
        'long': 'Other generalized ischemic cerebrovascular disease',
        'short': 'Ac cerebrovasc insuf NOS'},
       {'code': '437.2',
        'long': 'Hypertensive encephalopathy',
        'short': 'Hypertens encephalopathy'},
       {'code': '437.3',
        'long': 'Cerebral aneurysm, nonruptured',
        'short': 'Nonrupt cerebral aneurym'},
       {'code': '437.4',
        'long': 'Cerebral arteritis',
        'short': 'Cerebral arteritis'},
       {'code': '437.5',
        'long': 'Moyamoya disease',
        'short': 'Moyamoya disease'},
       {'code': '437.6',
        'long': 'Nonpyogenic thrombosis of intracranial venous sinus',
        'short': 'Nonpyogen thrombos sinus'},
       {'code': '437.7',
        'long': 'Transient global amnesia',
        'short': 'Transient global amnesia'},
       {'code': '437.8',
        'long': 'Other ill-defined cerebrovascular disease',
        'short': 'Cerebrovasc disease NEC'},
       {'code': '437.9',
        'long': 'Unspecified cerebrovascular disease',
        'short': 'Cerebrovasc disease NOS'},
       {'code': '438.0',
        'long': 'Late effects of cerebrovascular disease, cognitive deficits',
        'short': 'Late ef CV dis-cognf def'},
       {'code': '438.10',
        'long': 'Late effects of cerebrovascular disease, speech and language deficit, unspecified',
        'short': 'Late ef-spch/lng def NOS'},
       {'code': '438.11',
        'long': 'Late effects of cerebrovascular disease, aphasia',
        'short': 'Late eff CV dis-aphasia'},
       {'code': '438.12',
        'long': 'Late effects of cerebrovascular disease, dysphasia',
        'short': 'Late eff CV dis-dysphsia'},
       {'code': '438.13',
        'long': 'Late effects of cerebrovascular disease, dysarthria',
        'short': 'Late eff CV-dysarthria'},
       {'code': '438.14',
        'long': 'Late effects of cerebrovascular disease, fluency disorder',
        'short': 'Late eff CV-fluency dis'},
       {'code': '438.19',
        'long': 'Late effects of cerebrovascular disease, other speech and language deficits',
        'short': 'Late ef-spch/lang df NEC'},
       {'code': '438.20',
        'long': 'Late effects of cerebrovascular disease, hemiplegia affecting unspecified side',
        'short': 'Late ef-hemplga side NOS'},
       {'code': '438.21',
        'long': 'Late effects of cerebrovascular disease, hemiplegia affecting dominant side',
        'short': 'Late ef-hemplga dom side'},
       {'code': '438.22',
        'long': 'Late effects of cerebrovascular disease, hemiplegia affecting nondominant side',
        'short': 'Late ef-hemiplga non-dom'},
       {'code': '438.30',
        'long': 'Late effects of cerebrovascular disease, monoplegia of upper limb affecting unspecified side',
        'short': 'Late ef-mplga up lmb NOS'},
       {'code': '438.31',
        'long': 'Late effects of cerebrovascular disease, monoplegia of upper limb affecting dominant side',
        'short': 'Late ef-mplga up lmb dom'},
       {'code': '438.32',
        'long': 'Late effects of cerebrovascular disease, monoplegia of upper limb affecting nondominant side',
        'short': 'Lt ef-mplga uplmb nondom'},
       {'code': '438.40',
        'long': 'Late effects of cerebrovascular disease, monoplegia of lower limb affecting unspecified side',
        'short': 'Lte ef-mplga low lmb NOS'},
       {'code': '438.41',
        'long': 'Late effects of cerebrovascular disease, monoplegia of lower limb affecting dominant side',
        'short': 'Lte ef-mplga low lmb dom'},
       {'code': '438.42',
        'long': 'Late effects of cerebrovascular disease, monoplegia of lower limb affecting nondominant side',
        'short': 'Lt ef-mplga lowlmb nondm'},
       {'code': '438.50',
        'long': 'Late effects of cerebrovascular disease, other paralytic syndrome affecting unspecified side',
        'short': 'Lt ef oth paral side NOS'},
       {'code': '438.51',
        'long': 'Late effects of cerebrovascular disease, other paralytic syndrome affecting dominant side',
        'short': 'Lt ef oth paral dom side'},
       {'code': '438.52',
        'long': 'Late effects of cerebrovascular disease, other paralytic syndrome affecting nondominant side',
        'short': 'Lt ef oth parals non-dom'},
       {'code': '438.53',
        'long': 'Late effects of cerebrovascular disease, other paralytic syndrome, bilateral',
        'short': 'Lt ef oth parals-bilat'},
       {'code': '438.6',
        'long': 'Late effects of cerebrovascular disease, alterations of sensations',
        'short': 'Alteration of sensations'},
       {'code': '438.7',
        'long': 'Late effects of cerebrovascular disease, disturbances of vision',
        'short': 'Disturbances of vision'},
       {'code': '438.81',
        'long': 'Other late effects of cerebrovascular disease, apraxia',
        'short': 'Late eff CV dis-apraxia'},
       {'code': '438.82',
        'long': 'Other late effects of cerebrovascular disease, dysphagia',
        'short': 'Late ef CV dis dysphagia'},
       {'code': '438.83',
        'long': 'Other late effects of cerebrovascular disease, facial weakness',
        'short': 'Facial weakness'},
       {'code': '438.84',
        'long': 'Other late effects of cerebrovascular disease, ataxia',
        'short': 'Ataxia'},
       {'code': '438.85',
        'long': 'Other late effects of cerebrovascular disease, vertigo',
        'short': 'Vertigo'},
       {'code': '438.89',
        'long': 'Other late effects of cerebrovascular disease',
        'short': 'Late effect CV dis NEC'},
       {'code': '438.9',
        'long': 'Unspecified late effects of cerebrovascular disease',
        'short': 'Late effect CV dis NOS'},
       {'code': '440.0',
        'long': 'Atherosclerosis of aorta',
        'short': 'Aortic atherosclerosis'},
       {'code': '440.1',
        'long': 'Atherosclerosis of renal artery',
        'short': 'Renal artery atheroscler'},
       {'code': '440.20',
        'long': 'Atherosclerosis of native arteries of the extremities, unspecified',
        'short': 'Athscl extrm ntv art NOS'},
       {'code': '440.21',
        'long': 'Atherosclerosis of native arteries of the extremities with intermittent claudication',
        'short': 'Ath ext ntv at w claudct'},
       {'code': '440.22',
        'long': 'Atherosclerosis of native arteries of the extremities with rest pain',
        'short': 'Ath ext ntv at w rst pn'},
       {'code': '440.23',
        'long': 'Atherosclerosis of native arteries of the extremities with ulceration',
        'short': 'Ath ext ntv art ulcrtion'},
       {'code': '440.24',
        'long': 'Atherosclerosis of native arteries of the extremities with gangrene',
        'short': 'Ath ext ntv art gngrene'},
       {'code': '440.29',
        'long': 'Other atherosclerosis of native arteries of the extremities',
        'short': 'Athrsc extrm ntv art oth'},
       {'code': '440.30',
        'long': 'Atherosclerosis of unspecified bypass graft of the extremities',
        'short': 'Athscl extrm bps gft NOS'},
       {'code': '440.31',
        'long': 'Atherosclerosis of autologous vein bypass graft of the extremities',
        'short': 'Ath ext autologs bps gft'},
       {'code': '440.32',
        'long': 'Atherosclerosis of nonautologous biological bypass graft of the extremities',
        'short': 'Ath ext nonautlg bps gft'},
       {'code': '440.4',
        'long': 'Chronic total occlusion of artery of the extremities',
        'short': 'Chr tot occl art extrem'},
       {'code': '440.8',
        'long': 'Atherosclerosis of other specified arteries',
        'short': 'Atherosclerosis NEC'},
       {'code': '440.9',
        'long': 'Generalized and unspecified atherosclerosis',
        'short': 'Atherosclerosis NOS'},
       {'code': '441.00',
        'long': 'Dissection of aorta, unspecified site',
        'short': 'Dsct of aorta unsp site'},
       {'code': '441.01',
        'long': 'Dissection of aorta, thoracic',
        'short': 'Dsct of thoracic aorta'},
       {'code': '441.02',
        'long': 'Dissection of aorta, abdominal',
        'short': 'Dsct of abdominal aorta'},
       {'code': '441.03',
        'long': 'Dissection of aorta, thoracoabdominal',
        'short': 'Dsct of thoracoabd aorta'},
       {'code': '441.1',
        'long': 'Thoracic aneurysm, ruptured',
        'short': 'Ruptur thoracic aneurysm'},
       {'code': '441.2',
        'long': 'Thoracic aneurysm without mention of rupture',
        'short': 'Thoracic aortic aneurysm'},
       {'code': '441.3',
        'long': 'Abdominal aneurysm, ruptured',
        'short': 'Rupt abd aortic aneurysm'},
       {'code': '441.4',
        'long': 'Abdominal aneurysm without mention of rupture',
        'short': 'Abdom aortic aneurysm'},
       {'code': '441.5',
        'long': 'Aortic aneurysm of unspecified site, ruptured',
        'short': 'Rupt aortic aneurysm NOS'},
       {'code': '441.6',
        'long': 'Thoracoabdominal aneurysm, ruptured',
        'short': 'Thoracoabd aneurysm rupt'},
       {'code': '441.7',
        'long': 'Thoracoabdominal aneurysm, without mention of rupture',
        'short': 'Thracabd anurysm wo rupt'},
       {'code': '441.9',
        'long': 'Aortic aneurysm of unspecified site without mention of rupture',
        'short': 'Aortic aneurysm NOS'},
       {'code': '442.0',
        'long': 'Aneurysm of artery of upper extremity',
        'short': 'Upper extremity aneurysm'},
       {'code': '442.1',
        'long': 'Aneurysm of renal artery',
        'short': 'Renal artery aneurysm'},
       {'code': '442.2',
        'long': 'Aneurysm of iliac artery',
        'short': 'Iliac artery aneurysm'},
       {'code': '442.3',
        'long': 'Aneurysm of artery of lower extremity',
        'short': 'Lower extremity aneurysm'},
       {'code': '442.81',
        'long': 'Aneurysm of artery of neck',
        'short': 'Aneurysm of neck'},
       {'code': '442.82',
        'long': 'Aneurysm of subclavian artery',
        'short': 'Subclavian aneurysm'},
       {'code': '442.83',
        'long': 'Aneurysm of splenic artery',
        'short': 'Splenic artery aneurysm'},
       {'code': '442.84',
        'long': 'Aneurysm of other visceral artery',
        'short': 'Visceral aneurysm NEC'},
       {'code': '442.89',
        'long': 'Aneurysm of other specified artery',
        'short': 'Aneurysm NEC'},
       {'code': '442.9',
        'long': 'Aneurysm of unspecified site',
        'short': 'Aneurysm NOS'},
       {'code': '443.0',
        'long': "Raynaud's syndrome",
        'short': "Raynaud's syndrome"},
       {'code': '443.1',
        'long': "Thromboangiitis obliterans [Buerger's disease]",
        'short': 'Thromboangiit obliterans'},
       {'code': '443.21',
        'long': 'Dissection of carotid artery',
        'short': 'Dissect carotid artery'},
       {'code': '443.22',
        'long': 'Dissection of iliac artery',
        'short': 'Dissection iliac artery'},
       {'code': '443.23',
        'long': 'Dissection of renal artery',
        'short': 'Dissection renal artery'},
       {'code': '443.24',
        'long': 'Dissection of vertebral artery',
        'short': 'Dissect vertebral artery'},
       {'code': '443.29',
        'long': 'Dissection of other artery',
        'short': 'Dissection artery NEC'},
       {'code': '443.81',
        'long': 'Peripheral angiopathy in diseases classified elsewhere',
        'short': 'Angiopathy in other dis'},
       {'code': '443.82',
        'long': 'Erythromelalgia',
        'short': 'Erythromelalgia'},
       {'code': '443.89',
        'long': 'Other specified peripheral vascular diseases',
        'short': 'Periph vascular dis NEC'},
       {'code': '443.9',
        'long': 'Peripheral vascular disease, unspecified',
        'short': 'Periph vascular dis NOS'},
       {'code': '444.01',
        'long': 'Saddle embolus of abdominal aorta',
        'short': 'Saddle embolus abd aorta'},
       {'code': '444.09',
        'long': 'Other arterial embolism and thrombosis of abdominal aorta',
        'short': 'Ot art emb/thrm abd aort'},
       {'code': '444.1',
        'long': 'Embolism and thrombosis of thoracic aorta',
        'short': 'Thoracic aortic embolism'},
       {'code': '444.21',
        'long': 'Arterial embolism and thrombosis of upper extremity',
        'short': 'Upper extremity embolism'},
       {'code': '444.22',
        'long': 'Arterial embolism and thrombosis of lower extremity',
        'short': 'Lower extremity embolism'},
       {'code': '444.81',
        'long': 'Embolism and thrombosis of iliac artery',
        'short': 'Iliac artery embolism'},
       {'code': '444.89',
        'long': 'Embolism and thrombosis of other specified artery',
        'short': 'Arterial embolism NEC'},
       {'code': '444.9',
        'long': 'Embolism and thrombosis of unspecified artery',
        'short': 'Arterial embolism NOS'},
       {'code': '445.01',
        'long': 'Atheroembolism of upper extremity',
        'short': 'Atheroembolism,upper ext'},
       {'code': '445.02',
        'long': 'Atheroembolism of lower extremity',
        'short': 'Atheroembolism,lower ext'},
       {'code': '445.81',
        'long': 'Atheroembolism of kidney',
        'short': 'Atheroembolism, kidney'},
       {'code': '445.89',
        'long': 'Atheroembolism of other site',
        'short': 'Atheroembolism, site NEC'},
       {'code': '446.0',
        'long': 'Polyarteritis nodosa',
        'short': 'Polyarteritis nodosa'},
       {'code': '446.1',
        'long': 'Acute febrile mucocutaneous lymph node syndrome [MCLS]',
        'short': 'Mucocutan lymph node syn'},
       {'code': '446.20',
        'long': 'Hypersensitivity angiitis, unspecified',
        'short': 'Hypersensit angiitis NOS'},
       {'code': '446.21',
        'long': "Goodpasture's syndrome",
        'short': "Goodpasture's syndrome"},
       {'code': '446.29',
        'long': 'Other specified hypersensitivity angiitis',
        'short': 'Hypersensit angiitis NEC'},
       {'code': '446.3',
        'long': 'Lethal midline granuloma',
        'short': 'Lethal midline granuloma'},
       {'code': '446.4',
        'long': "Wegener's granulomatosis",
        'short': "Wegener's granulomatosis"},
       {'code': '446.5',
        'long': 'Giant cell arteritis',
        'short': 'Giant cell arteritis'},
       {'code': '446.6',
        'long': 'Thrombotic microangiopathy',
        'short': 'Thrombot microangiopathy'},
       {'code': '446.7',
        'long': "Takayasu's disease",
        'short': "Takayasu's disease"},
       {'code': '447.0',
        'long': 'Arteriovenous fistula, acquired',
        'short': 'Acq arterioven fistula'},
       {'code': '447.1',
        'long': 'Stricture of artery',
        'short': 'Stricture of artery'},
       {'code': '447.2',
        'long': 'Rupture of artery',
        'short': 'Rupture of artery'},
       {'code': '447.3',
        'long': 'Hyperplasia of renal artery',
        'short': 'Renal artery hyperplasia'},
       {'code': '447.4',
        'long': 'Celiac artery compression syndrome',
        'short': 'Celiac art compress syn'},
       {'code': '447.5',
        'long': 'Necrosis of artery',
        'short': 'Necrosis of artery'},
       {'code': '447.6',
        'long': 'Arteritis, unspecified',
        'short': 'Arteritis NOS'},
       {'code': '447.70',
        'long': 'Aortic ectasia, unspecified site',
        'short': 'Aortic ectasia, site NOS'},
       {'code': '447.71',
        'long': 'Thoracic aortic ectasia',
        'short': 'Thoracic aortic ectasia'},
       {'code': '447.72',
        'long': 'Abdominal aortic ectasia',
        'short': 'Abdominal aortic ectasia'},
       {'code': '447.73',
        'long': 'Thoracoabdominal aortic ectasia',
        'short': 'Thoracoabd aortc ectasia'},
       {'code': '447.8',
        'long': 'Other specified disorders of arteries and arterioles',
        'short': 'Arterial disease NEC'},
       {'code': '447.9',
        'long': 'Unspecified disorders of arteries and arterioles',
        'short': 'Arterial disease NOS'},
       {'code': '448.0',
        'long': 'Hereditary hemorrhagic telangiectasia',
        'short': 'Heredit hemorr telangiec'},
       {'code': '448.1',
        'long': 'Nevus, non-neoplastic',
        'short': 'Nevus, non-neoplastic'},
       {'code': '448.9',
        'long': 'Other and unspecified capillary diseases',
        'short': 'Capillary dis NEC/NOS'},
       {'code': '449',
        'long': 'Septic arterial embolism',
        'short': 'Septic arterial embolism'},
       {'code': '451.0',
        'long': 'Phlebitis and thrombophlebitis of superficial vessels of lower extremities',
        'short': 'Superfic phlebitis-leg'},
       {'code': '451.11',
        'long': 'Phlebitis and thrombophlebitis of femoral vein (deep) (superficial)',
        'short': 'Femoral vein phlebitis'},
       {'code': '451.19',
        'long': 'Phlebitis and thrombophlebitis of deep veins of lower extremities, other',
        'short': 'Deep phlebitis-leg NEC'},
       {'code': '451.2',
        'long': 'Phlebitis and thrombophlebitis of lower extremities, unspecified',
        'short': 'Thrombophlebitis leg NOS'},
       {'code': '451.81',
        'long': 'Phlebitis and thrombophlebitis of iliac vein',
        'short': 'Iliac thrombophlebitis'},
       {'code': '451.82',
        'long': 'Phlebitis and thrombophlebitis of superficial veins of upper extremities',
        'short': 'Phlbts sprfc vn up extrm'},
       {'code': '451.83',
        'long': 'Phlebitis and thrombophlebitis of deep veins of upper extremities',
        'short': 'Phlbts deep vn up extrm'},
       {'code': '451.84',
        'long': 'Phlebitis and thrombophlebitis of upper extremities, unspecified',
        'short': 'Phlbts vn NOS up extrm'},
       {'code': '451.89',
        'long': 'Phlebitis and thrombophlebitis of other sites',
        'short': 'Thrombophlebitis NEC'},
       {'code': '451.9',
        'long': 'Phlebitis and thrombophlebitis of unspecified site',
        'short': 'Thrombophlebitis NOS'},
       {'code': '452',
        'long': 'Portal vein thrombosis',
        'short': 'Portal vein thrombosis'},
       {'code': '453.0',
        'long': 'Budd-chiari syndrome',
        'short': 'Budd-chiari syndrome'},
       {'code': '453.1',
        'long': 'Thrombophlebitis migrans',
        'short': 'Thrombophlebitis migrans'},
       {'code': '453.2',
        'long': 'Other venous embolism and thrombosis of inferior vena cava',
        'short': 'Oth inf vena cava thromb'},
       {'code': '453.3',
        'long': 'Other venous embolism and thrombosis of renal vein',
        'short': 'Renal vein thrombosis'},
       {'code': '453.40',
        'long': 'Acute venous embolism and thrombosis of unspecified deep vessels of lower extremity',
        'short': 'Ac DVT/embl low ext NOS'},
       {'code': '453.41',
        'long': 'Acute venous embolism and thrombosis of deep vessels of proximal lower extremity',
        'short': 'Ac DVT/emb prox low ext'},
       {'code': '453.42',
        'long': 'Acute venous embolism and thrombosis of deep vessels of distal lower extremity',
        'short': 'Ac DVT/emb distl low ext'},
       {'code': '453.50',
        'long': 'Chronic venous embolism and thrombosis of unspecified deep vessels of lower extremity',
        'short': 'Ch DVT/embl low ext NOS'},
       {'code': '453.51',
        'long': 'Chronic venous embolism and thrombosis of deep vessels of proximal lower extremity',
        'short': 'Ch DVT/embl prox low ext'},
       {'code': '453.52',
        'long': 'Chronic venous embolism and thrombosis of deep vessels of distal lower extremity',
        'short': 'Ch DVT/embl dstl low ext'},
       {'code': '453.6',
        'long': 'Venous embolism and thrombosis of superficial vessels of lower extremity',
        'short': 'Embl suprfcl ves low ext'},
       {'code': '453.71',
        'long': 'Chronic venous embolism and thrombosis of superficial veins of upper extremity',
        'short': 'Ch emblsm suprfcl up ext'},
       {'code': '453.72',
        'long': 'Chronic venous embolism and thrombosis of deep veins of upper extremity',
        'short': 'Ch DVT/embl up ext'},
       {'code': '453.73',
        'long': 'Chronic venous embolism and thrombosis of upper extremity, unspecified',
        'short': 'Ch emblsm up ext NOS'},
       {'code': '453.74',
        'long': 'Chronic venous embolism and thrombosis of axillary veins',
        'short': 'Ch emblsm axillary veins'},
       {'code': '453.75',
        'long': 'Chronic venous embolism and thrombosis of subclavian veins',
        'short': 'Ch emblsm subclav veins'},
       {'code': '453.76',
        'long': 'Chronic venous embolism and thrombosis of internal jugular veins',
        'short': 'Ch embl internl jug vein'},
       {'code': '453.77',
        'long': 'Chronic venous embolism and thrombosis of other thoracic veins',
        'short': 'Ch embl thorac vein NEC'},
       {'code': '453.79',
        'long': 'Chronic venous embolism and thrombosis of other specified veins',
        'short': 'Ch emblsm veins NEC'},
       {'code': '453.81',
        'long': 'Acute venous embolism and thrombosis of superficial veins of upper extremity',
        'short': 'Ac embl suprfcl up ext'},
       {'code': '453.82',
        'long': 'Acute venous embolism and thrombosis of deep veins of upper extremity',
        'short': 'Ac DVT/embl up ext'},
       {'code': '453.83',
        'long': 'Acute venous embolism and thrombosis of upper extremity, unspecified',
        'short': 'Ac emblsm up ext NOS'},
       {'code': '453.84',
        'long': 'Acute venous embolism and thrombosis of axillary veins',
        'short': 'Ac emblsm axillary veins'},
       {'code': '453.85',
        'long': 'Acute venous embolism and thrombosis of subclavian veins',
        'short': 'Ac embl subclav veins'},
       {'code': '453.86',
        'long': 'Acute venous embolism and thrombosis of internal jugular veins',
        'short': 'Ac embl internl jug vein'},
       {'code': '453.87',
        'long': 'Acute venous embolism and thrombosis of other thoracic veins',
        'short': 'Ac embl thorac vein NEC'},
       {'code': '453.89',
        'long': 'Acute venous embolism and thrombosis of other specified veins',
        'short': 'Ac embolism veins NEC'},
       {'code': '453.9',
        'long': 'Other venous embolism and thrombosis of unspecified site',
        'short': 'Venous thrombosis NOS'},
       {'code': '454.0',
        'long': 'Varicose veins of lower extremities with ulcer',
        'short': 'Leg varicosity w ulcer'},
       {'code': '454.1',
        'long': 'Varicose veins of lower extremities with inflammation',
        'short': 'Leg varicosity w inflam'},
       {'code': '454.2',
        'long': 'Varicose veins of lower extremities with ulcer and inflammation',
        'short': 'Varicos leg ulcer/inflam'},
       {'code': '454.8',
        'long': 'Varicose veins of lower extremities with other complications',
        'short': 'Varic vein leg,comp NEC'},
       {'code': '454.9',
        'long': 'Asymptomatic varicose veins',
        'short': 'Asympt varicose veins'},
       {'code': '455.0',
        'long': 'Internal hemorrhoids without mention of complication',
        'short': 'Int hemorrhoid w/o compl'},
       {'code': '455.1',
        'long': 'Internal thrombosed hemorrhoids',
        'short': 'Int thrombos hemorrhoid'},
       {'code': '455.2',
        'long': 'Internal hemorrhoids with other complication',
        'short': 'Int hemrrhoid w comp NEC'},
       {'code': '455.3',
        'long': 'External hemorrhoids without mention of complication',
        'short': 'Ext hemorrhoid w/o compl'},
       {'code': '455.4',
        'long': 'External thrombosed hemorrhoids',
        'short': 'Ext thrombos hemorrhoid'},
       {'code': '455.5',
        'long': 'External hemorrhoids with other complication',
        'short': 'Ext hemrrhoid w comp NEC'},
       {'code': '455.6',
        'long': 'Unspecified hemorrhoids without mention of complication',
        'short': 'Hemorrhoids NOS'},
       {'code': '455.7',
        'long': 'Unspecified thrombosed hemorrhoids',
        'short': 'Thrombos hemorrhoids NOS'},
       {'code': '455.8',
        'long': 'Unspecified hemorrhoids with other complication',
        'short': 'Hemrrhoid NOS w comp NEC'},
       {'code': '455.9',
        'long': 'Residual hemorrhoidal skin tags',
        'short': 'Residual hemorrhoid tags'},
       {'code': '456.0',
        'long': 'Esophageal varices with bleeding',
        'short': 'Esophag varices w bleed'},
       {'code': '456.1',
        'long': 'Esophageal varices without mention of bleeding',
        'short': 'Esoph varices w/o bleed'},
       {'code': '456.20',
        'long': 'Esophageal varices in diseases classified elsewhere, with bleeding',
        'short': 'Bleed esoph var oth dis'},
       {'code': '456.21',
        'long': 'Esophageal varices in diseases classified elsewhere, without mention of bleeding',
        'short': 'Esoph varice oth dis NOS'},
       {'code': '456.3',
        'long': 'Sublingual varices',
        'short': 'Sublingual varices'},
       {'code': '456.4',
        'long': 'Scrotal varices',
        'short': 'Scrotal varices'},
       {'code': '456.5', 'long': 'Pelvic varices', 'short': 'Pelvic varices'},
       {'code': '456.6', 'long': 'Vulval varices', 'short': 'Vulval varices'},
       {'code': '456.8',
        'long': 'Varices of other sites',
        'short': 'Varices of other sites'},
       {'code': '457.0',
        'long': 'Postmastectomy lymphedema syndrome',
        'short': 'Postmastect lymphedema'},
       {'code': '457.1',
        'long': 'Other lymphedema',
        'short': 'Other lymphedema'},
       {'code': '457.2', 'long': 'Lymphangitis', 'short': 'Lymphangitis'},
       {'code': '457.8',
        'long': 'Other noninfectious disorders of lymphatic channels',
        'short': 'Noninfect lymph dis NEC'},
       {'code': '457.9',
        'long': 'Unspecified noninfectious disorder of lymphatic channels',
        'short': 'Noninfect lymph dis NOS'},
       {'code': '458.0',
        'long': 'Orthostatic hypotension',
        'short': 'Orthostatic hypotension'},
       {'code': '458.1',
        'long': 'Chronic hypotension',
        'short': 'Chronic hypotension'},
       {'code': '458.21',
        'long': 'Hypotension of hemodialysis',
        'short': 'Hemododialysis hypotensn'},
       {'code': '458.29',
        'long': 'Other iatrogenic hypotension',
        'short': 'Iatrogenc hypotnsion NEC'},
       {'code': '458.8',
        'long': 'Other specified hypotension',
        'short': 'Hypotension NEC'},
       {'code': '458.9',
        'long': 'Hypotension, unspecified',
        'short': 'Hypotension NOS'},
       {'code': '459.0',
        'long': 'Hemorrhage, unspecified',
        'short': 'Hemorrhage NOS'},
       {'code': '459.10',
        'long': 'Postphlebetic syndrome without complications',
        'short': 'Postphlbtc synd w/o comp'},
       {'code': '459.11',
        'long': 'Postphlebetic syndrome with ulcer',
        'short': 'Postphlebtc synd w ulcer'},
       {'code': '459.12',
        'long': 'Postphlebetic syndrome with inflammation',
        'short': 'Postphlebtc syn w inflam'},
       {'code': '459.13',
        'long': 'Postphlebetic syndrome with ulcer and inflammation',
        'short': 'Postphl syn w ulc&inflam'},
       {'code': '459.19',
        'long': 'Postphlebetic syndrome with other complication',
        'short': 'Postphleb synd comp NEC'},
       {'code': '459.2',
        'long': 'Compression of vein',
        'short': 'Compression of vein'},
       {'code': '459.30',
        'long': 'Chronic venous hypertension without complications',
        'short': 'Chr venous hypr w/o comp'},
       {'code': '459.31',
        'long': 'Chronic venous hypertension with ulcer',
        'short': 'Chr venous hyper w ulcer'},
       {'code': '459.32',
        'long': 'Chronic venous hypertension with inflammation',
        'short': 'Chr venous hypr w inflam'},
       {'code': '459.33',
        'long': 'Chronic venous hypertension with ulcer and inflammation',
        'short': 'Chr ven hyp w ulc&inflam'},
       {'code': '459.39',
        'long': 'Chronic venous hypertension with other complication',
        'short': 'Chr venous hyp comp NEC'},
       {'code': '459.81',
        'long': 'Venous (peripheral) insufficiency, unspecified',
        'short': 'Venous insufficiency NOS'},
       {'code': '459.89',
        'long': 'Other specified disorders of circulatory system',
        'short': 'Circulatory disease NEC'},
       {'code': '459.9',
        'long': 'Unspecified circulatory system disorder',
        'short': 'Circulatory disease NOS'}],
 'J': [{'code': '460',
        'long': 'Acute nasopharyngitis [common cold]',
        'short': 'Acute nasopharyngitis'},
       {'code': '461.0',
        'long': 'Acute maxillary sinusitis',
        'short': 'Ac maxillary sinusitis'},
       {'code': '461.1',
        'long': 'Acute frontal sinusitis',
        'short': 'Ac frontal sinusitis'},
       {'code': '461.2',
        'long': 'Acute ethmoidal sinusitis',
        'short': 'Ac ethmoidal sinusitis'},
       {'code': '461.3',
        'long': 'Acute sphenoidal sinusitis',
        'short': 'Ac sphenoidal sinusitis'},
       {'code': '461.8',
        'long': 'Other acute sinusitis',
        'short': 'Other acute sinusitis'},
       {'code': '461.9',
        'long': 'Acute sinusitis, unspecified',
        'short': 'Acute sinusitis NOS'},
       {'code': '462',
        'long': 'Acute pharyngitis',
        'short': 'Acute pharyngitis'},
       {'code': '463',
        'long': 'Acute tonsillitis',
        'short': 'Acute tonsillitis'},
       {'code': '464.00',
        'long': 'Acute laryngitis without mention of obstruction',
        'short': 'Ac laryngitis w/o obst'},
       {'code': '464.01',
        'long': 'Acute laryngitis with obstruction',
        'short': 'Ac laryngitis w obstruct'},
       {'code': '464.10',
        'long': 'Acute tracheitis without mention of obstruction',
        'short': 'Ac tracheitis no obstruc'},
       {'code': '464.11',
        'long': 'Acute tracheitis with obstruction',
        'short': 'Ac tracheitis w obstruct'},
       {'code': '464.20',
        'long': 'Acute laryngotracheitis without mention of obstruction',
        'short': 'Ac laryngotrach no obstr'},
       {'code': '464.21',
        'long': 'Acute laryngotracheitis with obstruction',
        'short': 'Ac laryngotrach w obstr'},
       {'code': '464.30',
        'long': 'Acute epiglottitis without mention of obstruction',
        'short': 'Ac epiglottitis no obstr'},
       {'code': '464.31',
        'long': 'Acute epiglottitis with obstruction',
        'short': 'Ac epiglottitis w obstr'},
       {'code': '464.4', 'long': 'Croup', 'short': 'Croup'},
       {'code': '464.50',
        'long': 'Supraglottitis unspecified, without obstruction',
        'short': 'Supraglottis w/o obs NOS'},
       {'code': '464.51',
        'long': 'Supraglottitis unspecified, with obstruction',
        'short': 'Supraglottis w obstr NOS'},
       {'code': '465.0',
        'long': 'Acute laryngopharyngitis',
        'short': 'Acute laryngopharyngitis'},
       {'code': '465.8',
        'long': 'Acute upper respiratory infections of other multiple sites',
        'short': 'Acute uri mult sites NEC'},
       {'code': '465.9',
        'long': 'Acute upper respiratory infections of unspecified site',
        'short': 'Acute uri NOS'},
       {'code': '466.0',
        'long': 'Acute bronchitis',
        'short': 'Acute bronchitis'},
       {'code': '466.11',
        'long': 'Acute bronchiolitis due to respiratory syncytial virus (RSV)',
        'short': 'Acu broncholitis d/t RSV'},
       {'code': '466.19',
        'long': 'Acute bronchiolitis due to other infectious organisms',
        'short': 'Acu brnchlts d/t oth org'},
       {'code': '470',
        'long': 'Deviated nasal septum',
        'short': 'Deviated nasal septum'},
       {'code': '471.0',
        'long': 'Polyp of nasal cavity',
        'short': 'Polyp of nasal cavity'},
       {'code': '471.1',
        'long': 'Polypoid sinus degeneration',
        'short': 'Polypoid sinus degen'},
       {'code': '471.8',
        'long': 'Other polyp of sinus',
        'short': 'Nasal sinus polyp NEC'},
       {'code': '471.9',
        'long': 'Unspecified nasal polyp',
        'short': 'Nasal polyp NOS'},
       {'code': '472.0',
        'long': 'Chronic rhinitis',
        'short': 'Chronic rhinitis'},
       {'code': '472.1',
        'long': 'Chronic pharyngitis',
        'short': 'Chronic pharyngitis'},
       {'code': '472.2',
        'long': 'Chronic nasopharyngitis',
        'short': 'Chronic nasopharyngitis'},
       {'code': '473.0',
        'long': 'Chronic maxillary sinusitis',
        'short': 'Chr maxillary sinusitis'},
       {'code': '473.1',
        'long': 'Chronic frontal sinusitis',
        'short': 'Chr frontal sinusitis'},
       {'code': '473.2',
        'long': 'Chronic ethmoidal sinusitis',
        'short': 'Chr ethmoidal sinusitis'},
       {'code': '473.3',
        'long': 'Chronic sphenoidal sinusitis',
        'short': 'Chr sphenoidal sinusitis'},
       {'code': '473.8',
        'long': 'Other chronic sinusitis',
        'short': 'Chronic sinusitis NEC'},
       {'code': '473.9',
        'long': 'Unspecified sinusitis (chronic)',
        'short': 'Chronic sinusitis NOS'},
       {'code': '474.00',
        'long': 'Chronic tonsillitis',
        'short': 'Chronic tonsillitis'},
       {'code': '474.01',
        'long': 'Chronic adenoiditis',
        'short': 'Chronic adenoiditis'},
       {'code': '474.02',
        'long': 'Chronic tonsillitis and adenoiditis',
        'short': 'Chronic tonsils&adenoids'},
       {'code': '474.10',
        'long': 'Hypertrophy of tonsil with adenoids',
        'short': 'Hypertrophy T and A'},
       {'code': '474.11',
        'long': 'Hypertrophy of tonsils alone',
        'short': 'Hypertrophy tonsils'},
       {'code': '474.12',
        'long': 'Hypertrophy of adenoids alone',
        'short': 'Hypertrophy adenoids'},
       {'code': '474.2',
        'long': 'Adenoid vegetations',
        'short': 'Adenoid vegetations'},
       {'code': '474.8',
        'long': 'Other chronic disease of tonsils and adenoids',
        'short': 'Chr T & A dis NEC'},
       {'code': '474.9',
        'long': 'Unspecified chronic disease of tonsils and adenoids',
        'short': 'Chr T & A dis NOS'},
       {'code': '475',
        'long': 'Peritonsillar abscess',
        'short': 'Peritonsillar abscess'},
       {'code': '476.0',
        'long': 'Chronic laryngitis',
        'short': 'Chronic laryngitis'},
       {'code': '476.1',
        'long': 'Chronic laryngotracheitis',
        'short': 'Chr laryngotracheitis'},
       {'code': '477.0',
        'long': 'Allergic rhinitis due to pollen',
        'short': 'Rhinitis due to pollen'},
       {'code': '477.1',
        'long': 'Allergic rhinitis due to food',
        'short': 'Allergic rhinitis-food'},
       {'code': '477.2',
        'long': 'Allergic rhinitis due to animal (cat) (dog) hair and dander',
        'short': 'Allerg rhinitis-cat/dog'},
       {'code': '477.8',
        'long': 'Allergic rhinitis due to other allergen',
        'short': 'Allergic rhinitis NEC'},
       {'code': '477.9',
        'long': 'Allergic rhinitis, cause unspecified',
        'short': 'Allergic rhinitis NOS'},
       {'code': '478.0',
        'long': 'Hypertrophy of nasal turbinates',
        'short': 'Hypertrph nasal turbinat'},
       {'code': '478.11',
        'long': 'Nasal mucositis (ulcerative)',
        'short': 'Nasal mucositis (ulcer)'},
       {'code': '478.19',
        'long': 'Other disease of nasal cavity and sinuses',
        'short': 'Nasal & sinus dis NEC'},
       {'code': '478.20',
        'long': 'Unspecified disease of pharynx',
        'short': 'Disease of pharynx NOS'},
       {'code': '478.21',
        'long': 'Cellulitis of pharynx or nasopharynx',
        'short': 'Cellulitis of pharynx'},
       {'code': '478.22',
        'long': 'Parapharyngeal abscess',
        'short': 'Parapharyngeal abscess'},
       {'code': '478.24',
        'long': 'Retropharyngeal abscess',
        'short': 'Retropharyngeal abscess'},
       {'code': '478.25',
        'long': 'Edema of pharynx or nasopharynx',
        'short': 'Edema pharynx/nasopharyx'},
       {'code': '478.26',
        'long': 'Cyst of pharynx or nasopharynx',
        'short': 'Cyst pharynx/nasopharynx'},
       {'code': '478.29',
        'long': 'Other diseases of pharynx, not elsewhere classified',
        'short': 'Disease of pharynx NEC'},
       {'code': '478.30',
        'long': 'Paralysis of vocal cords or larynx, unspecified',
        'short': 'Vocal cord paralysis NOS'},
       {'code': '478.31',
        'long': 'Unilateral paralysis of vocal cords or larynx, partial',
        'short': 'Vocal paral unilat part'},
       {'code': '478.32',
        'long': 'Unilateral paralysis of vocal cords or larynx, complete',
        'short': 'Vocal paral unilat total'},
       {'code': '478.33',
        'long': 'Bilateral paralysis of vocal cords or larynx, partial',
        'short': 'Vocal paral bilat part'},
       {'code': '478.34',
        'long': 'Bilateral paralysis of vocal cords or larynx, complete',
        'short': 'Vocal paral bilat total'},
       {'code': '478.4',
        'long': 'Polyp of vocal cord or larynx',
        'short': 'Vocal cord/larynx polyp'},
       {'code': '478.5',
        'long': 'Other diseases of vocal cords',
        'short': 'Vocal cord disease NEC'},
       {'code': '478.6',
        'long': 'Edema of larynx',
        'short': 'Edema of larynx'},
       {'code': '478.70',
        'long': 'Unspecified disease of larynx',
        'short': 'Disease of larynx NOS'},
       {'code': '478.71',
        'long': 'Cellulitis and perichondritis of larynx',
        'short': 'Laryngeal cellulitis'},
       {'code': '478.74',
        'long': 'Stenosis of larynx',
        'short': 'Stenosis of larynx'},
       {'code': '478.75',
        'long': 'Laryngeal spasm',
        'short': 'Laryngeal spasm'},
       {'code': '478.79',
        'long': 'Other diseases of larynx, not elsewhere classified',
        'short': 'Disease of larynx NEC'},
       {'code': '478.8',
        'long': 'Upper respiratory tract hypersensitivity reaction, site unspecified',
        'short': 'Urt hypersens react NOS'},
       {'code': '478.9',
        'long': 'Other and unspecified diseases of upper respiratory tract',
        'short': 'Upper resp dis NEC/NOS'},
       {'code': '480.0',
        'long': 'Pneumonia due to adenovirus',
        'short': 'Adenoviral pneumonia'},
       {'code': '480.1',
        'long': 'Pneumonia due to respiratory syncytial virus',
        'short': 'Resp syncyt viral pneum'},
       {'code': '480.2',
        'long': 'Pneumonia due to parainfluenza virus',
        'short': 'Parinfluenza viral pneum'},
       {'code': '480.3',
        'long': 'Pneumonia due to SARS-associated coronavirus',
        'short': 'Pneumonia due to SARS'},
       {'code': '480.8',
        'long': 'Pneumonia due to other virus not elsewhere classified',
        'short': 'Viral pneumonia NEC'},
       {'code': '480.9',
        'long': 'Viral pneumonia, unspecified',
        'short': 'Viral pneumonia NOS'},
       {'code': '481',
        'long': 'Pneumococcal pneumonia [Streptococcus pneumoniae pneumonia]',
        'short': 'Pneumococcal pneumonia'},
       {'code': '482.0',
        'long': 'Pneumonia due to Klebsiella pneumoniae',
        'short': 'K. pneumoniae pneumonia'},
       {'code': '482.1',
        'long': 'Pneumonia due to Pseudomonas',
        'short': 'Pseudomonal pneumonia'},
       {'code': '482.2',
        'long': 'Pneumonia due to Hemophilus influenzae [H. influenzae]',
        'short': 'H.influenzae pneumonia'},
       {'code': '482.30',
        'long': 'Pneumonia due to Streptococcus, unspecified',
        'short': 'Streptococcal pneumn NOS'},
       {'code': '482.31',
        'long': 'Pneumonia due to Streptococcus, group A',
        'short': 'Pneumonia strptococcus a'},
       {'code': '482.32',
        'long': 'Pneumonia due to Streptococcus, group B',
        'short': 'Pneumonia strptococcus b'},
       {'code': '482.39',
        'long': 'Pneumonia due to other Streptococcus',
        'short': 'Pneumonia oth strep'},
       {'code': '482.40',
        'long': 'Pneumonia due to Staphylococcus, unspecified',
        'short': 'Staphylococcal pneu NOS'},
       {'code': '482.41',
        'long': 'Methicillin susceptible pneumonia due to Staphylococcus aureus',
        'short': 'Meth sus pneum d/t Staph'},
       {'code': '482.42',
        'long': 'Methicillin resistant pneumonia due to Staphylococcus aureus',
        'short': 'Meth res pneu d/t Staph'},
       {'code': '482.49',
        'long': 'Other Staphylococcus pneumonia',
        'short': 'Staph pneumonia NEC'},
       {'code': '482.81',
        'long': 'Pneumonia due to anaerobes',
        'short': 'Pneumonia anaerobes'},
       {'code': '482.82',
        'long': 'Pneumonia due to escherichia coli [E. coli]',
        'short': 'Pneumonia e coli'},
       {'code': '482.83',
        'long': 'Pneumonia due to other gram-negative bacteria',
        'short': 'Pneumo oth grm-neg bact'},
       {'code': '482.84',
        'long': "Pneumonia due to Legionnaires' disease",
        'short': "Legionnaires' disease"},
       {'code': '482.89',
        'long': 'Pneumonia due to other specified bacteria',
        'short': 'Pneumonia oth spcf bact'},
       {'code': '482.9',
        'long': 'Bacterial pneumonia, unspecified',
        'short': 'Bacterial pneumonia NOS'},
       {'code': '483.0',
        'long': 'Pneumonia due to mycoplasma pneumoniae',
        'short': 'Pneu mycplsm pneumoniae'},
       {'code': '483.1',
        'long': 'Pneumonia due to chlamydia',
        'short': 'Pneumonia d/t chlamydia'},
       {'code': '483.8',
        'long': 'Pneumonia due to other specified organism',
        'short': 'Pneumon oth spec orgnsm'},
       {'code': '484.1',
        'long': 'Pneumonia in cytomegalic inclusion disease',
        'short': 'Pneum w cytomeg incl dis'},
       {'code': '484.3',
        'long': 'Pneumonia in whooping cough',
        'short': 'Pneumonia in whoop cough'},
       {'code': '484.5',
        'long': 'Pneumonia in anthrax',
        'short': 'Pneumonia in anthrax'},
       {'code': '484.6',
        'long': 'Pneumonia in aspergillosis',
        'short': 'Pneum in aspergillosis'},
       {'code': '484.7',
        'long': 'Pneumonia in other systemic mycoses',
        'short': 'Pneum in oth sys mycoses'},
       {'code': '484.8',
        'long': 'Pneumonia in other infectious diseases classified elsewhere',
        'short': 'Pneum in infect dis NEC'},
       {'code': '485',
        'long': 'Bronchopneumonia, organism unspecified',
        'short': 'Bronchopneumonia org NOS'},
       {'code': '486',
        'long': 'Pneumonia, organism unspecified',
        'short': 'Pneumonia, organism NOS'},
       {'code': '487.0',
        'long': 'Influenza with pneumonia',
        'short': 'Influenza with pneumonia'},
       {'code': '487.1',
        'long': 'Influenza with other respiratory manifestations',
        'short': 'Flu w resp manifest NEC'},
       {'code': '487.8',
        'long': 'Influenza with other manifestations',
        'short': 'Flu w manifestation NEC'},
       {'code': '488.01',
        'long': 'Influenza due to identified avian influenza virus with pneumonia',
        'short': 'Flu dt iden avian w pneu'},
       {'code': '488.02',
        'long': 'Influenza due to identified avian influenza virus with other respiratory manifestations',
        'short': 'Flu dt avian w oth resp'},
       {'code': '488.09',
        'long': 'Influenza due to identified avian influenza virus with other manifestations',
        'short': 'Flu dt avian manfest NEC'},
       {'code': '488.11',
        'long': 'Influenza due to identified 2009 H1N1 influenza virus with pneumonia',
        'short': 'Flu dt 2009 H1N1 w pneu'},
       {'code': '488.12',
        'long': 'Influenza due to identified 2009 H1N1 influenza virus with other respiratory manifestations',
        'short': 'Flu-2009 H1N1 w oth resp'},
       {'code': '488.19',
        'long': 'Influenza due to identified 2009 H1N1 influenza virus with other manifestations',
        'short': 'Flu-2009 H1N1 w oth man'},
       {'code': '488.81',
        'long': 'Influenza due to identified novel influenza A virus with pneumonia',
        'short': 'Flu dt nvl A vrs w pneu'},
       {'code': '488.82',
        'long': 'Influenza due to identified novel influenza A virus with other respiratory manifestations',
        'short': 'Flu dt nvl A w oth resp'},
       {'code': '488.89',
        'long': 'Influenza due to identified novel influenza A virus with other manifestations',
        'short': 'Flu dt novel A w oth man'},
       {'code': '490',
        'long': 'Bronchitis, not specified as acute or chronic',
        'short': 'Bronchitis NOS'},
       {'code': '491.0',
        'long': 'Simple chronic bronchitis',
        'short': 'Simple chr bronchitis'},
       {'code': '491.1',
        'long': 'Mucopurulent chronic bronchitis',
        'short': 'Mucopurul chr bronchitis'},
       {'code': '491.20',
        'long': 'Obstructive chronic bronchitis without exacerbation',
        'short': 'Obst chr bronc w/o exac'},
       {'code': '491.21',
        'long': 'Obstructive chronic bronchitis with (acute) exacerbation',
        'short': 'Obs chr bronc w(ac) exac'},
       {'code': '491.22',
        'long': 'Obstructive chronic bronchitis with acute bronchitis',
        'short': 'Obs chr bronc w ac bronc'},
       {'code': '491.8',
        'long': 'Other chronic bronchitis',
        'short': 'Chronic bronchitis NEC'},
       {'code': '491.9',
        'long': 'Unspecified chronic bronchitis',
        'short': 'Chronic bronchitis NOS'},
       {'code': '492.0',
        'long': 'Emphysematous bleb',
        'short': 'Emphysematous bleb'},
       {'code': '492.8', 'long': 'Other emphysema', 'short': 'Emphysema NEC'},
       {'code': '493.00',
        'long': 'Extrinsic asthma, unspecified',
        'short': 'Extrinsic asthma NOS'},
       {'code': '493.01',
        'long': 'Extrinsic asthma with status asthmaticus',
        'short': 'Ext asthma w status asth'},
       {'code': '493.02',
        'long': 'Extrinsic asthma with (acute) exacerbation',
        'short': 'Ext asthma w(acute) exac'},
       {'code': '493.10',
        'long': 'Intrinsic asthma, unspecified',
        'short': 'Intrinsic asthma NOS'},
       {'code': '493.11',
        'long': 'Intrinsic asthma with status asthmaticus',
        'short': 'Int asthma w status asth'},
       {'code': '493.12',
        'long': 'Intrinsic asthma with (acute) exacerbation',
        'short': 'Int asthma w (ac) exac'},
       {'code': '493.20',
        'long': 'Chronic obstructive asthma, unspecified',
        'short': 'Chronic obst asthma NOS'},
       {'code': '493.21',
        'long': 'Chronic obstructive asthma with status asthmaticus',
        'short': 'Ch ob asthma w stat asth'},
       {'code': '493.22',
        'long': 'Chronic obstructive asthma with (acute) exacerbation',
        'short': 'Ch obst asth w (ac) exac'},
       {'code': '493.81',
        'long': 'Exercise induced bronchospasm',
        'short': 'Exercse ind bronchospasm'},
       {'code': '493.82',
        'long': 'Cough variant asthma',
        'short': 'Cough variant asthma'},
       {'code': '493.90',
        'long': 'Asthma, unspecified type, unspecified',
        'short': 'Asthma NOS'},
       {'code': '493.91',
        'long': 'Asthma, unspecified type, with status asthmaticus',
        'short': 'Asthma w status asthmat'},
       {'code': '493.92',
        'long': 'Asthma, unspecified type, with (acute) exacerbation',
        'short': 'Asthma NOS w (ac) exac'},
       {'code': '494.0',
        'long': 'Bronchiectasis without acute exacerbation',
        'short': 'Bronchiectas w/o ac exac'},
       {'code': '494.1',
        'long': 'Bronchiectasis with acute exacerbation',
        'short': 'Bronchiectasis w ac exac'},
       {'code': '495.0', 'long': "Farmers' lung", 'short': "Farmers' lung"},
       {'code': '495.1', 'long': 'Bagassosis', 'short': 'Bagassosis'},
       {'code': '495.2',
        'long': "Bird-fanciers' lung",
        'short': "Bird-fanciers' lung"},
       {'code': '495.3', 'long': 'Suberosis', 'short': 'Suberosis'},
       {'code': '495.4',
        'long': "Malt workers' lung",
        'short': "Malt workers' lung"},
       {'code': '495.5',
        'long': "Mushroom workers' lung",
        'short': "Mushroom workers' lung"},
       {'code': '495.6',
        'long': "Maple bark-strippers' lung",
        'short': "Mapl bark-stripprs' lung"},
       {'code': '495.7',
        'long': '"Ventilation" pneumonitis',
        'short': '"ventilation" pneumonit'},
       {'code': '495.8',
        'long': 'Other specified allergic alveolitis and pneumonitis',
        'short': 'Allerg alveol/pneum NEC'},
       {'code': '495.9',
        'long': 'Unspecified allergic alveolitis and pneumonitis',
        'short': 'Allerg alveol/pneum NOS'},
       {'code': '496',
        'long': 'Chronic airway obstruction, not elsewhere classified',
        'short': 'Chr airway obstruct NEC'},
       {'code': '500',
        'long': "Coal workers' pneumoconiosis",
        'short': "Coal workers' pneumocon"},
       {'code': '501', 'long': 'Asbestosis', 'short': 'Asbestosis'},
       {'code': '502',
        'long': 'Pneumoconiosis due to other silica or silicates',
        'short': 'Silica pneumocon NEC'},
       {'code': '503',
        'long': 'Pneumoconiosis due to other inorganic dust',
        'short': 'Inorg dust pneumocon NEC'},
       {'code': '504',
        'long': 'Pneumonopathy due to inhalation of other dust',
        'short': 'Dust pneumonopathy NEC'},
       {'code': '505',
        'long': 'Pneumoconiosis, unspecified',
        'short': 'Pneumoconiosis NOS'},
       {'code': '506.0',
        'long': 'Bronchitis and pneumonitis due to fumes and vapors',
        'short': 'Fum/vapor bronc/pneumon'},
       {'code': '506.1',
        'long': 'Acute pulmonary edema due to fumes and vapors',
        'short': 'Fum/vapor ac pulm edema'},
       {'code': '506.2',
        'long': 'Upper respiratory inflammation due to fumes and vapors',
        'short': 'Fum/vapor up resp inflam'},
       {'code': '506.3',
        'long': 'Other acute and subacute respiratory conditions due to fumes and vapors',
        'short': 'Fum/vap ac resp cond NEC'},
       {'code': '506.4',
        'long': 'Chronic respiratory conditions due to fumes and vapors',
        'short': 'Fum/vapor chr resp cond'},
       {'code': '506.9',
        'long': 'Unspecified respiratory conditions due to fumes and vapors',
        'short': 'Fum/vapor resp cond NOS'},
       {'code': '507.0',
        'long': 'Pneumonitis due to inhalation of food or vomitus',
        'short': 'Food/vomit pneumonitis'},
       {'code': '507.1',
        'long': 'Pneumonitis due to inhalation of oils and essences',
        'short': 'Oil/essence pneumonitis'},
       {'code': '507.8',
        'long': 'Pneumonitis due to other solids and liquids',
        'short': 'Solid/liq pneumonit NEC'},
       {'code': '508.0',
        'long': 'Acute pulmonary manifestations due to radiation',
        'short': 'Ac pul manif d/t radiat'},
       {'code': '508.1',
        'long': 'Chronic and other pulmonary manifestations due to radiation',
        'short': 'Chr pul manif d/t radiat'},
       {'code': '508.2',
        'long': 'Respiratory conditions due to smoke inhalation',
        'short': 'Resp cond dt smoke inhal'},
       {'code': '508.8',
        'long': 'Respiratory conditions due to other specified external agents',
        'short': 'Resp cond: ext agent NEC'},
       {'code': '508.9',
        'long': 'Respiratory conditions due to unspecified external agent',
        'short': 'Resp cond: ext agent NOS'},
       {'code': '510.0',
        'long': 'Empyema with fistula',
        'short': 'Empyema with fistula'},
       {'code': '510.9',
        'long': 'Empyema without mention of fistula',
        'short': 'Empyema w/o fistula'},
       {'code': '511.0',
        'long': 'Pleurisy without mention of effusion or current tuberculosis',
        'short': 'Pleurisy w/o effus or TB'},
       {'code': '511.1',
        'long': 'Pleurisy with effusion, with mention of a bacterial cause other than tuberculosis',
        'short': 'Bact pleur/effus not TB'},
       {'code': '511.81',
        'long': 'Malignant pleural effusion',
        'short': 'Malignant pleural effusn'},
       {'code': '511.89',
        'long': 'Other specified forms of effusion, except tuberculous',
        'short': 'Effusion NEC exc tb'},
       {'code': '511.9',
        'long': 'Unspecified pleural effusion',
        'short': 'Pleural effusion NOS'},
       {'code': '512.0',
        'long': 'Spontaneous tension pneumothorax',
        'short': 'Spont tens pneumothorax'},
       {'code': '512.1',
        'long': 'Iatrogenic pneumothorax',
        'short': 'Iatrogenic pneumothorax'},
       {'code': '512.2',
        'long': 'Postoperative air leak',
        'short': 'Postoperative air leak'},
       {'code': '512.81',
        'long': 'Primary spontaneous pneumothorax',
        'short': 'Prim spont pneumothorax'},
       {'code': '512.82',
        'long': 'Secondary spontaneous pneumothorax',
        'short': 'Sec spont pneumothorax'},
       {'code': '512.83',
        'long': 'Chronic pneumothorax',
        'short': 'Chronic pneumothorax'},
       {'code': '512.84',
        'long': 'Other air leak',
        'short': 'Other air leak'},
       {'code': '512.89',
        'long': 'Other pneumothorax',
        'short': 'Other pneumothorax'},
       {'code': '513.0',
        'long': 'Abscess of lung',
        'short': 'Abscess of lung'},
       {'code': '513.1',
        'long': 'Abscess of mediastinum',
        'short': 'Abscess of mediastinum'},
       {'code': '514',
        'long': 'Pulmonary congestion and hypostasis',
        'short': 'Pulm congest/hypostasis'},
       {'code': '515',
        'long': 'Postinflammatory pulmonary fibrosis',
        'short': 'Postinflam pulm fibrosis'},
       {'code': '516.0',
        'long': 'Pulmonary alveolar proteinosis',
        'short': 'Pul alveolar proteinosis'},
       {'code': '516.1',
        'long': 'Idiopathic pulmonary hemosiderosis',
        'short': 'Idio pulm hemosiderosis'},
       {'code': '516.2',
        'long': 'Pulmonary alveolar microlithiasis',
        'short': 'Pulm alveolar microlith'},
       {'code': '516.30',
        'long': 'Idiopathic interstitial pneumonia, not otherwise specified',
        'short': 'Idiopath inters pneu NOS'},
       {'code': '516.31',
        'long': 'Idiopathic pulmonary fibrosis',
        'short': 'Idiopath pulmon fibrosis'},
       {'code': '516.32',
        'long': 'Idiopathic non-specific interstitial pneumonitis',
        'short': 'Idio non-spec inter pneu'},
       {'code': '516.33',
        'long': 'Acute interstitial pneumonitis',
        'short': 'Acute interstitial pneum'},
       {'code': '516.34',
        'long': 'Respiratory bronchiolitis interstitial lung disease',
        'short': 'Resp brncio interst lung'},
       {'code': '516.35',
        'long': 'Idiopathic lymphoid interstitial pneumonia',
        'short': 'Idiopth lym interst pneu'},
       {'code': '516.36',
        'long': 'Cryptogenic organizing pneumonia',
        'short': 'Cryptogenic organiz pneu'},
       {'code': '516.37',
        'long': 'Desquamative interstitial pneumonia',
        'short': 'Desquamatv interst pneu'},
       {'code': '516.4',
        'long': 'Lymphangioleiomyomatosis',
        'short': 'Lymphangioleiomyomatosis'},
       {'code': '516.5',
        'long': 'Adult pulmonary Langerhans cell histiocytosis',
        'short': 'Adlt pul Langs cell hist'},
       {'code': '516.61',
        'long': 'Neuroendocrine cell hyperplasia of infancy',
        'short': 'Neuroend cell hyprpl inf'},
       {'code': '516.62',
        'long': 'Pulmonary interstitial glycogenosis',
        'short': 'Pulm interstitl glycogen'},
       {'code': '516.63',
        'long': 'Surfactant mutations of the lung',
        'short': 'Surfactant mutation lung'},
       {'code': '516.64',
        'long': 'Alveolar capillary dysplasia with vein misalignment',
        'short': 'Alv cap dysp w vn misaln'},
       {'code': '516.69',
        'long': 'Other interstitial lung diseases of childhood',
        'short': 'Oth intrst lung dis chld'},
       {'code': '516.8',
        'long': 'Other specified alveolar and parietoalveolar pneumonopathies',
        'short': 'Alveol pneumonopathy NEC'},
       {'code': '516.9',
        'long': 'Unspecified alveolar and parietoalveolar pneumonopathy',
        'short': 'Alveol pneumonopathy NOS'},
       {'code': '517.1',
        'long': 'Rheumatic pneumonia',
        'short': 'Rheumatic pneumonia'},
       {'code': '517.2',
        'long': 'Lung involvement in systemic sclerosis',
        'short': 'Syst sclerosis lung dis'},
       {'code': '517.3',
        'long': 'Acute chest syndrome',
        'short': 'Acute chest syndrome'},
       {'code': '517.8',
        'long': 'Lung involvement in other diseases classified elsewhere',
        'short': 'Lung involv in oth dis'},
       {'code': '518.0',
        'long': 'Pulmonary collapse',
        'short': 'Pulmonary collapse'},
       {'code': '518.1',
        'long': 'Interstitial emphysema',
        'short': 'Interstitial emphysema'},
       {'code': '518.2',
        'long': 'Compensatory emphysema',
        'short': 'Compensatory emphysema'},
       {'code': '518.3',
        'long': 'Pulmonary eosinophilia',
        'short': 'Pulmonary eosinophilia'},
       {'code': '518.4',
        'long': 'Acute edema of lung, unspecified',
        'short': 'Acute lung edema NOS'},
       {'code': '518.51',
        'long': 'Acute respiratory failure following trauma and surgery',
        'short': 'Ac resp flr fol trma/srg'},
       {'code': '518.52',
        'long': 'Other pulmonary insufficiency, not elsewhere classified, following trauma and surgery',
        'short': 'Ot pul insuf fol trm/srg'},
       {'code': '518.53',
        'long': 'Acute and chronic respiratory failure following trauma and surgery',
        'short': 'Ac/chr rsp flr fol tr/sg'},
       {'code': '518.6',
        'long': 'Allergic bronchopulmonary aspergillosis',
        'short': 'Alrgc brncpul asprglosis'},
       {'code': '518.7',
        'long': 'Transfusion related acute lung injury (TRALI)',
        'short': 'Transfsn rel ac lung inj'},
       {'code': '518.81',
        'long': 'Acute respiratory failure',
        'short': 'Acute respiratry failure'},
       {'code': '518.82',
        'long': 'Other pulmonary insufficiency, not elsewhere classified',
        'short': 'Other pulmonary insuff'},
       {'code': '518.83',
        'long': 'Chronic respiratory failure',
        'short': 'Chronic respiratory fail'},
       {'code': '518.84',
        'long': 'Acute and chronic respiratory failure',
        'short': 'Acute & chronc resp fail'},
       {'code': '518.89',
        'long': 'Other diseases of lung, not elsewhere classified',
        'short': 'Other lung disease NEC'},
       {'code': '519.00',
        'long': 'Tracheostomy complication, unspecified',
        'short': 'Tracheostomy comp NOS'},
       {'code': '519.01',
        'long': 'Infection of tracheostomy',
        'short': 'Tracheostomy infection'},
       {'code': '519.02',
        'long': 'Mechanical complication of tracheostomy',
        'short': 'Tracheostomy - mech comp'},
       {'code': '519.09',
        'long': 'Other tracheostomy complications',
        'short': 'Tracheostomy comp NEC'},
       {'code': '519.11',
        'long': 'Acute bronchospasm',
        'short': 'Acute bronchospasm'},
       {'code': '519.19',
        'long': 'Other diseases of trachea and bronchus',
        'short': 'Trachea & bronch dis NEC'},
       {'code': '519.2', 'long': 'Mediastinitis', 'short': 'Mediastinitis'},
       {'code': '519.3',
        'long': 'Other diseases of mediastinum, not elsewhere classified',
        'short': 'Mediastinum disease NEC'},
       {'code': '519.4',
        'long': 'Disorders of diaphragm',
        'short': 'Disorders of diaphragm'},
       {'code': '519.8',
        'long': 'Other diseases of respiratory system, not elsewhere classified',
        'short': 'Resp system disease NEC'},
       {'code': '519.9',
        'long': 'Unspecified disease of respiratory system',
        'short': 'Resp system disease NOS'}],
 'K': [{'code': '520.0', 'long': 'Anodontia', 'short': 'Anodontia'},
       {'code': '520.1',
        'long': 'Supernumerary teeth',
        'short': 'Supernumerary teeth'},
       {'code': '520.2',
        'long': 'Abnormalities of size and form of teeth',
        'short': 'Abnormal tooth size/form'},
       {'code': '520.3', 'long': 'Mottled teeth', 'short': 'Mottled teeth'},
       {'code': '520.4',
        'long': 'Disturbances of tooth formation',
        'short': 'Tooth formation disturb'},
       {'code': '520.5',
        'long': 'Hereditary disturbances in tooth structure, not elsewhere classified',
        'short': 'Heredit tooth struct NEC'},
       {'code': '520.6',
        'long': 'Disturbances in tooth eruption',
        'short': 'Tooth eruption disturb'},
       {'code': '520.7',
        'long': 'Teething syndrome',
        'short': 'Teething syndrome'},
       {'code': '520.8',
        'long': 'Other specified disorders of tooth development and eruption',
        'short': 'Tooth devel/erup dis NEC'},
       {'code': '520.9',
        'long': 'Unspecified disorder of tooth development and eruption',
        'short': 'Tooth devel/erup dis NOS'},
       {'code': '521.00',
        'long': 'Dental caries, unspecified',
        'short': 'Dental caries NOS'},
       {'code': '521.01',
        'long': 'Dental caries limited to enamel',
        'short': 'Dental caries - enamel'},
       {'code': '521.02',
        'long': 'Dental caries extending into dentine',
        'short': 'Dental caries - dentine'},
       {'code': '521.03',
        'long': 'Dental caries extending into pulp',
        'short': 'Dental caries - pulp'},
       {'code': '521.04',
        'long': 'Arrested dental caries',
        'short': 'Dental caries - arrested'},
       {'code': '521.05', 'long': 'Odontoclasia', 'short': 'Odontoclasia'},
       {'code': '521.06',
        'long': 'Dental caries pit and fissure',
        'short': 'Dentl caries-pit/fissure'},
       {'code': '521.07',
        'long': 'Dental caries of smooth surface',
        'short': 'Dentl caries-smooth surf'},
       {'code': '521.08',
        'long': 'Dental caries of root surface',
        'short': 'Dental caries-root surf'},
       {'code': '521.09',
        'long': 'Other dental caries',
        'short': 'Dental caries NEC'},
       {'code': '521.10',
        'long': 'Excessive attrition, unspecified',
        'short': 'Excessive attrition NOS'},
       {'code': '521.11',
        'long': 'Excessive attrition, limited to enamel',
        'short': 'Excess attrition-enamel'},
       {'code': '521.12',
        'long': 'Excessive attrition, extending into dentine',
        'short': 'Excess attrition-dentine'},
       {'code': '521.13',
        'long': 'Excessive attrition, extending into pulp',
        'short': 'Excessive attrition-pulp'},
       {'code': '521.14',
        'long': 'Excessive attrition, localized',
        'short': 'Excess attrition-local'},
       {'code': '521.15',
        'long': 'Excessive attrition, generalized',
        'short': 'Excess attrition-general'},
       {'code': '521.20',
        'long': 'Abrasion, unspecified',
        'short': 'Abrasion NOS'},
       {'code': '521.21',
        'long': 'Abrasion, limited to enamel',
        'short': 'Abrasion-enamel'},
       {'code': '521.22',
        'long': 'Abrasion, extending into dentine',
        'short': 'Abrasion-dentine'},
       {'code': '521.23',
        'long': 'Abrasion, extending into pulp',
        'short': 'Abrasion-pulp'},
       {'code': '521.24',
        'long': 'Abrasion, localized',
        'short': 'Abrasion-localized'},
       {'code': '521.25',
        'long': 'Abrasion, generalized',
        'short': 'Abrasion-generalized'},
       {'code': '521.30',
        'long': 'Erosion, unspecified',
        'short': 'Erosion NOS'},
       {'code': '521.31',
        'long': 'Erosion, limited to enamel',
        'short': 'Erosion-enamel'},
       {'code': '521.32',
        'long': 'Erosion, extending into dentine',
        'short': 'Erosion-dentine'},
       {'code': '521.33',
        'long': 'Erosion, extending into pulp',
        'short': 'Erosion-pulp'},
       {'code': '521.34',
        'long': 'Erosion, localized',
        'short': 'Erosion-localized'},
       {'code': '521.35',
        'long': 'Erosion, generalized',
        'short': 'Erosion-generalized'},
       {'code': '521.40',
        'long': 'Pathological resorption, unspecified',
        'short': 'Path resorption NOS'},
       {'code': '521.41',
        'long': 'Pathological resorption, internal',
        'short': 'Path resorption-internal'},
       {'code': '521.42',
        'long': 'Pathological resorption, external',
        'short': 'Path resorption-external'},
       {'code': '521.49',
        'long': 'Other pathological resorption',
        'short': 'Path resorption NEC'},
       {'code': '521.5',
        'long': 'Hypercementosis',
        'short': 'Hypercementosis'},
       {'code': '521.6',
        'long': 'Ankylosis of teeth',
        'short': 'Ankylosis of teeth'},
       {'code': '521.7',
        'long': 'Intrinsic posteruptive color changes',
        'short': 'Intrin posteruptv color'},
       {'code': '521.81', 'long': 'Cracked tooth', 'short': 'Cracked tooth'},
       {'code': '521.89',
        'long': 'Other specific diseases of hard tissues of teeth',
        'short': 'Dis hard tiss teeth NEC'},
       {'code': '521.9',
        'long': 'Unspecified disease of hard tissues of teeth',
        'short': 'Hard tiss dis teeth NOS'},
       {'code': '522.0', 'long': 'Pulpitis', 'short': 'Pulpitis'},
       {'code': '522.1',
        'long': 'Necrosis of the pulp',
        'short': 'Necrosis of tooth pulp'},
       {'code': '522.2',
        'long': 'Pulp degeneration',
        'short': 'Tooth pulp degeneration'},
       {'code': '522.3',
        'long': 'Abnormal hard tissue formation in pulp',
        'short': 'Abn hard tiss-tooth pulp'},
       {'code': '522.4',
        'long': 'Acute apical periodontitis of pulpal origin',
        'short': 'Ac apical periodontitis'},
       {'code': '522.5',
        'long': 'Periapical abscess without sinus',
        'short': 'Periapical abscess'},
       {'code': '522.6',
        'long': 'Chronic apical periodontitis',
        'short': 'Chr apical periodontitis'},
       {'code': '522.7',
        'long': 'Periapical abscess with sinus',
        'short': 'Periapical absc w sinus'},
       {'code': '522.8', 'long': 'Radicular cyst', 'short': 'Radicular cyst'},
       {'code': '522.9',
        'long': 'Other and unspecified diseases of pulp and periapical tissues',
        'short': 'Pulp/periapical dis NEC'},
       {'code': '523.00',
        'long': 'Acute gingivitis, plaque induced',
        'short': 'Acute gingititis, plaque'},
       {'code': '523.01',
        'long': 'Acute gingivitis, non-plaque induced',
        'short': 'Ac gingivitis,nonplaque'},
       {'code': '523.10',
        'long': 'Chronic gingivitis, plaque induced',
        'short': 'Chronc gingititis,plaque'},
       {'code': '523.11',
        'long': 'Chronic gingivitis, non-plaque induced',
        'short': 'Chr gingivitis-nonplaque'},
       {'code': '523.20',
        'long': 'Gingival recession, unspecified',
        'short': 'Gingival recession NOS'},
       {'code': '523.21',
        'long': 'Gingival recession, minimal',
        'short': 'Gingival recess-minimal'},
       {'code': '523.22',
        'long': 'Gingival recession, moderate',
        'short': 'Gingival recess-moderate'},
       {'code': '523.23',
        'long': 'Gingival recession, severe',
        'short': 'Gingival recess-severe'},
       {'code': '523.24',
        'long': 'Gingival recession, localized',
        'short': 'Gingival recession-local'},
       {'code': '523.25',
        'long': 'Gingival recession, generalized',
        'short': 'Gingival recess-general'},
       {'code': '523.30',
        'long': 'Aggressive periodontitis, unspecified',
        'short': 'Aggres periodontitis NOS'},
       {'code': '523.31',
        'long': 'Aggressive periodontitis, localized',
        'short': 'Aggres periodontitis,loc'},
       {'code': '523.32',
        'long': 'Aggressive periodontitis, generalized',
        'short': 'Aggres periodontitis,gen'},
       {'code': '523.33',
        'long': 'Acute periodontitis',
        'short': 'Acute periodontitis'},
       {'code': '523.40',
        'long': 'Chronic periodontitis, unspecified',
        'short': 'Chronc periodontitis NOS'},
       {'code': '523.41',
        'long': 'Chronic periodontitis, localized',
        'short': 'Chr periodontitis, local'},
       {'code': '523.42',
        'long': 'Chronic periodontitis, generalized',
        'short': 'Chron periodontitis,gen'},
       {'code': '523.5', 'long': 'Periodontosis', 'short': 'Periodontosis'},
       {'code': '523.6',
        'long': 'Accretions on teeth',
        'short': 'Accretions on teeth'},
       {'code': '523.8',
        'long': 'Other specified periodontal diseases',
        'short': 'Periodontal disease NEC'},
       {'code': '523.9',
        'long': 'Unspecified gingival and periodontal disease',
        'short': 'Gingiv/periodont dis NOS'},
       {'code': '524.00',
        'long': 'Major anomalies of jaw size, unspecified anomaly',
        'short': 'Unspcf anomaly jaw size'},
       {'code': '524.01',
        'long': 'Major anomalies of jaw size, maxillary hyperplasia',
        'short': 'Maxillary hyperplasia'},
       {'code': '524.02',
        'long': 'Major anomalies of jaw size, mandibular hyperplasia',
        'short': 'Mandibular hyperplasia'},
       {'code': '524.03',
        'long': 'Major anomalies of jaw size, maxillary hypoplasia',
        'short': 'Maxillary hypoplasia'},
       {'code': '524.04',
        'long': 'Major anomalies of jaw size, mandibular hypoplasia',
        'short': 'Mandibular hypoplasia'},
       {'code': '524.05',
        'long': 'Major anomalies of jaw size, macrogenia',
        'short': 'Macrogenia'},
       {'code': '524.06',
        'long': 'Major anomalies of jaw size, microgenia',
        'short': 'Microgenia'},
       {'code': '524.07',
        'long': 'Excessive tuberosity of jaw',
        'short': 'Excessive tuberosity-jaw'},
       {'code': '524.09',
        'long': 'Major anomalies of jaw size, other specified anomaly',
        'short': 'Oth spcf anmly jaw size'},
       {'code': '524.10',
        'long': 'Anomalies of relationship of jaw to cranial base, unspecified anomaly',
        'short': 'Unspcf anm jaw cranl bse'},
       {'code': '524.11',
        'long': 'Anomalies of relationship of jaw to cranial base, maxillary asymmetry',
        'short': 'Maxillary asymmetry'},
       {'code': '524.12',
        'long': 'Anomalies of relationship of jaw to cranial base, other jaw asymmetry',
        'short': 'Other jaw asymmetry'},
       {'code': '524.19',
        'long': 'Anomalies of relationship of jaw to cranial base, other specified anomaly',
        'short': 'Spcfd anom jaw cranl bse'},
       {'code': '524.20',
        'long': 'Unspecified anomaly of dental arch relationship',
        'short': 'Anomaly dental arch NOS'},
       {'code': '524.21',
        'long': "Malocclusion, Angle's class I",
        'short': "Malocc- Angle's class I"},
       {'code': '524.22',
        'long': "Malocclusion, Angle's class II",
        'short': "Malocc-Angle's class II"},
       {'code': '524.23',
        'long': "Malocclusion, Angle's class III",
        'short': "Malocc-Angle's class III"},
       {'code': '524.24',
        'long': 'Open anterior occlusal relationship',
        'short': 'Open anterior occlusion'},
       {'code': '524.25',
        'long': 'Open posterior occlusal relationship',
        'short': 'Open posterior occlusion'},
       {'code': '524.26',
        'long': 'Excessive horizontal overlap',
        'short': 'Excess horizontl overlap'},
       {'code': '524.27',
        'long': 'Reverse articulation',
        'short': 'Reverse articulation'},
       {'code': '524.28',
        'long': 'Anomalies of interarch distance',
        'short': 'Anom interarch distance'},
       {'code': '524.29',
        'long': 'Other anomalies of dental arch relationship',
        'short': 'Anomaly dental arch NEC'},
       {'code': '524.30',
        'long': 'Unspecified anomaly of tooth position',
        'short': 'Tooth position anom NOS'},
       {'code': '524.31',
        'long': 'Crowding of teeth',
        'short': 'Crowding of teeth'},
       {'code': '524.32',
        'long': 'Excessive spacing of teeth',
        'short': 'Excessive spacing-teeth'},
       {'code': '524.33',
        'long': 'Horizontal displacement of teeth',
        'short': 'Horizontl displace-teeth'},
       {'code': '524.34',
        'long': 'Vertical displacement of teeth',
        'short': 'Vertical displace-teeth'},
       {'code': '524.35',
        'long': 'Rotation of tooth/teeth',
        'short': 'Rotation of teeth'},
       {'code': '524.36',
        'long': 'Insufficient interocclusal distance of teeth (ridge)',
        'short': 'Insuf interocclusl-teeth'},
       {'code': '524.37',
        'long': 'Excessive interocclusal distance of teeth',
        'short': 'Exces interocclusl-teeth'},
       {'code': '524.39',
        'long': 'Other anomalies of tooth position',
        'short': 'Tooth position anom NEC'},
       {'code': '524.4',
        'long': 'Malocclusion, unspecified',
        'short': 'Malocclusion NOS'},
       {'code': '524.50',
        'long': 'Dentofacial functional abnormality, unspecified',
        'short': 'Dentofac funct abnor NOS'},
       {'code': '524.51',
        'long': 'Abnormal jaw closure',
        'short': 'Abnormal jaw closure'},
       {'code': '524.52',
        'long': 'Limited mandibular range of motion',
        'short': 'Limited mandibular ROM'},
       {'code': '524.53',
        'long': 'Deviation in opening and closing of the mandible',
        'short': 'Dev open/close mandible'},
       {'code': '524.54',
        'long': 'Insufficient anterior guidance',
        'short': 'Insuff anterior guidance'},
       {'code': '524.55',
        'long': 'Centric occlusion maximum intercuspation discrepancy',
        'short': 'Centric occl intrcsp dis'},
       {'code': '524.56',
        'long': 'Non-working side interference',
        'short': 'Nonwork side interfrnce'},
       {'code': '524.57',
        'long': 'Lack of posterior occlusal support',
        'short': 'Lack post occlsl support'},
       {'code': '524.59',
        'long': 'Other dentofacial functional abnormalities',
        'short': 'Dentofac funct abnor NEC'},
       {'code': '524.60',
        'long': 'Temporomandibular joint disorders, unspecified',
        'short': 'TMJ disorders NOS'},
       {'code': '524.61',
        'long': 'Temporomandibular joint disorders, adhesions and ankylosis (bony or fibrous)',
        'short': 'Adhesns/ankylosis - TMJ'},
       {'code': '524.62',
        'long': 'Temporomandibular joint disorders, arthralgia of temporomandibular joint',
        'short': 'Arthralgia TMJ'},
       {'code': '524.63',
        'long': 'Temporomandibular joint disorders, articular disc disorder (reducing or non-reducing)',
        'short': 'Articular disc disorder'},
       {'code': '524.64',
        'long': 'Temporomandibular joint sounds on opening and/or closing the jaw',
        'short': 'TMJ sounds opn/close jaw'},
       {'code': '524.69',
        'long': 'Other specified temporomandibular joint disorders',
        'short': 'Other specf TMJ disordrs'},
       {'code': '524.70',
        'long': 'Dental alveolar anomalies, unspecified alveolar anomaly',
        'short': 'Unspf dent alvelr anmaly'},
       {'code': '524.71',
        'long': 'Alveolar maxillary hyperplasia',
        'short': 'Alveolar maxil hyprplsia'},
       {'code': '524.72',
        'long': 'Alveolar mandibular hyperplasia',
        'short': 'Alveolar mandib hyprplas'},
       {'code': '524.73',
        'long': 'Alveolar maxillary hypoplasia',
        'short': 'Alveolar maxil hypoplsia'},
       {'code': '524.74',
        'long': 'Alveolar mandibular hypoplasia',
        'short': 'Alveolar mandb hypoplsia'},
       {'code': '524.75',
        'long': 'Vertical displacement of alveolus and teeth',
        'short': 'Vertical displace teeth'},
       {'code': '524.76',
        'long': 'Occlusal plane deviation',
        'short': 'Occlusal plane deviation'},
       {'code': '524.79',
        'long': 'Other specified alveolar anomaly',
        'short': 'Oth spcf alveolar anmaly'},
       {'code': '524.81',
        'long': 'Anterior soft tissue impingement',
        'short': 'Anterior soft tiss impg'},
       {'code': '524.82',
        'long': 'Posterior soft tissue impingement',
        'short': 'Posterior soft tiss impg'},
       {'code': '524.89',
        'long': 'Other specified dentofacial anomalies',
        'short': 'Dentofacial anomaly NEC'},
       {'code': '524.9',
        'long': 'Unspecified dentofacial anomalies',
        'short': 'Dentofacial anomaly NOS'},
       {'code': '525.0',
        'long': 'Exfoliation of teeth due to systemic causes',
        'short': 'Exfoliation of teeth'},
       {'code': '525.10',
        'long': 'Acquired absence of teeth, unspecified',
        'short': 'Acq absence of teeth NOS'},
       {'code': '525.11',
        'long': 'Loss of teeth due to trauma',
        'short': 'Loss of teeth d/t trauma'},
       {'code': '525.12',
        'long': 'Loss of teeth due to periodontal disease',
        'short': 'Loss teeth d/t peri dis'},
       {'code': '525.13',
        'long': 'Loss of teeth due to caries',
        'short': 'Loss of teeth d/t caries'},
       {'code': '525.19',
        'long': 'Other loss of teeth',
        'short': 'Loss of teeth NEC'},
       {'code': '525.20',
        'long': 'Unspecified atrophy of edentulous alveolar ridge',
        'short': 'Atrophy alvlar ridge NOS'},
       {'code': '525.21',
        'long': 'Minimal atrophy of the mandible',
        'short': 'Atrophy mandible-minimal'},
       {'code': '525.22',
        'long': 'Moderate atrophy of the mandible',
        'short': 'Atrophy mandible-modrate'},
       {'code': '525.23',
        'long': 'Severe atrophy of the mandible',
        'short': 'Atrophy mandible-severe'},
       {'code': '525.24',
        'long': 'Minimal atrophy of the maxilla',
        'short': 'Atrophy maxilla-minimal'},
       {'code': '525.25',
        'long': 'Moderate atrophy of the maxilla',
        'short': 'Atrophy maxilla-moderate'},
       {'code': '525.26',
        'long': 'Severe atrophy of the maxilla',
        'short': 'Atrophy maxilla-severe'},
       {'code': '525.3',
        'long': 'Retained dental root',
        'short': 'Retained dental root'},
       {'code': '525.40',
        'long': 'Complete edentulism, unspecified',
        'short': 'Complete edentulism NOS'},
       {'code': '525.41',
        'long': 'Complete edentulism, class I',
        'short': 'Comp edentulism,class I'},
       {'code': '525.42',
        'long': 'Complete edentulism, class II',
        'short': 'Comp edentulism,class II'},
       {'code': '525.43',
        'long': 'Complete edentulism, class III',
        'short': 'Comp edentulsm,class III'},
       {'code': '525.44',
        'long': 'Complete edentulism, class IV',
        'short': 'Comp edentulism,class IV'},
       {'code': '525.50',
        'long': 'Partial edentulism, unspecified',
        'short': 'Partial edentulism NOS'},
       {'code': '525.51',
        'long': 'Partial edentulism, class I',
        'short': 'Part edentulism,class I'},
       {'code': '525.52',
        'long': 'Partial edentulism, class II',
        'short': 'Part edentulism,class II'},
       {'code': '525.53',
        'long': 'Partial edentulism, class III',
        'short': 'Part edentulsm,class III'},
       {'code': '525.54',
        'long': 'Partial edentulism, class IV',
        'short': 'Part edentulism,class IV'},
       {'code': '525.60',
        'long': 'Unspecified unsatisfactory restoration of tooth',
        'short': 'Unsat restore tooth NOS'},
       {'code': '525.61',
        'long': 'Open restoration margins',
        'short': 'Open restoration margins'},
       {'code': '525.62',
        'long': 'Unrepairable overhanging of dental restorative materials',
        'short': 'Overhang dental restore'},
       {'code': '525.63',
        'long': 'Fractured dental restorative material without loss of material',
        'short': 'Fx dental mat w/o loss'},
       {'code': '525.64',
        'long': 'Fractured dental restorative material with loss of material',
        'short': 'Fx dentl material w loss'},
       {'code': '525.65',
        'long': 'Contour of existing restoration of tooth biologically incompatible with oral health',
        'short': 'Contour restore tooth'},
       {'code': '525.66',
        'long': 'Allergy to existing dental restorative material',
        'short': 'Allergy dental res mat'},
       {'code': '525.67',
        'long': 'Poor aesthetics of existing restoration',
        'short': 'Poor aesthetics restore'},
       {'code': '525.69',
        'long': 'Other unsatisfactory restoration of existing tooth',
        'short': 'Unsat restore tooth NEC'},
       {'code': '525.71',
        'long': 'Osseointegration failure of dental implant',
        'short': 'Osseo fail dental implnt'},
       {'code': '525.72',
        'long': 'Post-osseointegration biological failure of dental implant',
        'short': 'Post-osse biol fail impl'},
       {'code': '525.73',
        'long': 'Post-osseointegration mechanical failure of dental implant',
        'short': 'Post-osse mech fail impl'},
       {'code': '525.79',
        'long': 'Other endosseous dental implant failure',
        'short': 'Endos dentl imp fail NEC'},
       {'code': '525.8',
        'long': 'Other specified disorders of the teeth and supporting structures',
        'short': 'Dental disorder NEC'},
       {'code': '525.9',
        'long': 'Unspecified disorder of the teeth and supporting structures',
        'short': 'Dental disorder NOS'},
       {'code': '526.0',
        'long': 'Developmental odontogenic cysts',
        'short': 'Devel odontogenic cysts'},
       {'code': '526.1',
        'long': 'Fissural cysts of jaw',
        'short': 'Fissural cysts of jaw'},
       {'code': '526.2',
        'long': 'Other cysts of jaws',
        'short': 'Cysts of jaws NEC'},
       {'code': '526.3',
        'long': 'Central giant cell (reparative) granuloma',
        'short': 'Cent giant cell granulom'},
       {'code': '526.4',
        'long': 'Inflammatory conditions of jaw',
        'short': 'Inflammation of jaw'},
       {'code': '526.5',
        'long': 'Alveolitis of jaw',
        'short': 'Alveolitis of jaw'},
       {'code': '526.61',
        'long': 'Perforation of root canal space',
        'short': 'Perfor root canal space'},
       {'code': '526.62',
        'long': 'Endodontic overfill',
        'short': 'Endodontic overfill'},
       {'code': '526.63',
        'long': 'Endodontic underfill',
        'short': 'Endodontic underfill'},
       {'code': '526.69',
        'long': 'Other periradicular pathology associated with previous endodontic treatment',
        'short': 'Periradicular path NEC'},
       {'code': '526.81',
        'long': 'Exostosis of jaw',
        'short': 'Exostosis of jaw'},
       {'code': '526.89',
        'long': 'Other specified diseases of the jaws',
        'short': 'Jaw disease NEC'},
       {'code': '526.9',
        'long': 'Unspecified disease of the jaws',
        'short': 'Jaw disease NOS'},
       {'code': '527.0',
        'long': 'Atrophy of salivary gland',
        'short': 'Salivary gland atrophy'},
       {'code': '527.1',
        'long': 'Hypertrophy of salivary gland',
        'short': 'Salivary glnd hyprtrophy'},
       {'code': '527.2', 'long': 'Sialoadenitis', 'short': 'Sialoadenitis'},
       {'code': '527.3',
        'long': 'Abscess of salivary gland',
        'short': 'Salivary gland abscess'},
       {'code': '527.4',
        'long': 'Fistula of salivary gland',
        'short': 'Salivary gland fistula'},
       {'code': '527.5', 'long': 'Sialolithiasis', 'short': 'Sialolithiasis'},
       {'code': '527.6',
        'long': 'Mucocele of salivary gland',
        'short': 'Salivary gland mucocele'},
       {'code': '527.7',
        'long': 'Disturbance of salivary secretion',
        'short': 'Salivary secretion dis'},
       {'code': '527.8',
        'long': 'Other specified diseases of the salivary glands',
        'short': 'Salivary gland dis NEC'},
       {'code': '527.9',
        'long': 'Unspecified disease of the salivary glands',
        'short': 'Salivary gland dis NOS'},
       {'code': '528.00',
        'long': 'Stomatitis and mucositis, unspecified',
        'short': 'Stomatitis/mucositis NOS'},
       {'code': '528.01',
        'long': 'Mucositis (ulcerative) due to antineoplastic therapy',
        'short': 'Mucosits d/t antineo rx'},
       {'code': '528.02',
        'long': 'Mucositis (ulcerative) due to other drugs',
        'short': 'Mucositis d/t drugs NEC'},
       {'code': '528.09',
        'long': 'Other stomatitis and mucositis (ulcerative)',
        'short': 'Stomatits & mucosits NEC'},
       {'code': '528.1', 'long': 'Cancrum oris', 'short': 'Cancrum oris'},
       {'code': '528.2', 'long': 'Oral aphthae', 'short': 'Oral aphthae'},
       {'code': '528.3',
        'long': 'Cellulitis and abscess of oral soft tissues',
        'short': 'Cellulitis/abscess mouth'},
       {'code': '528.4',
        'long': 'Cysts of oral soft tissues',
        'short': 'Oral soft tissue cyst'},
       {'code': '528.5',
        'long': 'Diseases of lips',
        'short': 'Diseases of lips'},
       {'code': '528.6',
        'long': 'Leukoplakia of oral mucosa, including tongue',
        'short': 'Leukoplakia oral mucosa'},
       {'code': '528.71',
        'long': 'Minimal keratinized residual ridge mucosa',
        'short': 'Keratin ridge mucosa-min'},
       {'code': '528.72',
        'long': 'Excessive keratinized residual ridge mucosa',
        'short': 'Keratin ridge muc-excess'},
       {'code': '528.79',
        'long': 'Other disturbances of oral epithelium, including tongue',
        'short': 'Dist oral epithelium NEC'},
       {'code': '528.8',
        'long': 'Oral submucosal fibrosis, including of tongue',
        'short': 'Oral submucosal fibrosis'},
       {'code': '528.9',
        'long': 'Other and unspecified diseases of the oral soft tissues',
        'short': 'Oral soft tissue dis NEC'},
       {'code': '529.0', 'long': 'Glossitis', 'short': 'Glossitis'},
       {'code': '529.1',
        'long': 'Geographic tongue',
        'short': 'Geographic tongue'},
       {'code': '529.2',
        'long': 'Median rhomboid glossitis',
        'short': 'Med rhomboid glossitis'},
       {'code': '529.3',
        'long': 'Hypertrophy of tongue papillae',
        'short': 'Hypertroph tongue papill'},
       {'code': '529.4',
        'long': 'Atrophy of tongue papillae',
        'short': 'Atrophy tongue papillae'},
       {'code': '529.5',
        'long': 'Plicated tongue',
        'short': 'Plicated tongue'},
       {'code': '529.6', 'long': 'Glossodynia', 'short': 'Glossodynia'},
       {'code': '529.8',
        'long': 'Other specified conditions of the tongue',
        'short': 'Tongue disorder NEC'},
       {'code': '529.9',
        'long': 'Unspecified condition of the tongue',
        'short': 'Tongue disorder NOS'},
       {'code': '530.0',
        'long': 'Achalasia and cardiospasm',
        'short': 'Achalasia & cardiospasm'},
       {'code': '530.10',
        'long': 'Esophagitis, unspecified',
        'short': 'Esophagitis, unspecified'},
       {'code': '530.11',
        'long': 'Reflux esophagitis',
        'short': 'Reflux esophagitis'},
       {'code': '530.12',
        'long': 'Acute esophagitis',
        'short': 'Acute esophagitis'},
       {'code': '530.13',
        'long': 'Eosinophilic esophagitis',
        'short': 'Eosinophilic esophagitis'},
       {'code': '530.19',
        'long': 'Other esophagitis',
        'short': 'Other esophagitis'},
       {'code': '530.20',
        'long': 'Ulcer of esophagus without bleeding',
        'short': 'Ulc esophagus w/o bleed'},
       {'code': '530.21',
        'long': 'Ulcer of esophagus with bleeding',
        'short': 'Ulcer esophagus w bleed'},
       {'code': '530.3',
        'long': 'Stricture and stenosis of esophagus',
        'short': 'Esophageal stricture'},
       {'code': '530.4',
        'long': 'Perforation of esophagus',
        'short': 'Perforation of esophagus'},
       {'code': '530.5',
        'long': 'Dyskinesia of esophagus',
        'short': 'Dyskinesia of esophagus'},
       {'code': '530.6',
        'long': 'Diverticulum of esophagus, acquired',
        'short': 'Acq esophag diverticulum'},
       {'code': '530.7',
        'long': 'Gastroesophageal laceration-hemorrhage syndrome',
        'short': 'Mallory-weiss syndrome'},
       {'code': '530.81',
        'long': 'Esophageal reflux',
        'short': 'Esophageal reflux'},
       {'code': '530.82',
        'long': 'Esophageal hemorrhage',
        'short': 'Esophageal hemorrhage'},
       {'code': '530.83',
        'long': 'Esophageal leukoplakia',
        'short': 'Esophageal leukoplakia'},
       {'code': '530.84',
        'long': 'Tracheoesophageal fistula',
        'short': 'Tracheoesophageal fstula'},
       {'code': '530.85',
        'long': "Barrett's esophagus",
        'short': "Barrett's esophagus"},
       {'code': '530.86',
        'long': 'Infection of esophagostomy',
        'short': 'Esophagostomy infection'},
       {'code': '530.87',
        'long': 'Mechanical complication of esophagostomy',
        'short': 'Mech comp esophagostomy'},
       {'code': '530.89',
        'long': 'Other specified disorders of esophagus',
        'short': 'Other dsrders esophagus'},
       {'code': '530.9',
        'long': 'Unspecified disorder of esophagus',
        'short': 'Esophageal disorder NOS'},
       {'code': '531.00',
        'long': 'Acute gastric ulcer with hemorrhage, without mention of obstruction',
        'short': 'Ac stomach ulcer w hem'},
       {'code': '531.01',
        'long': 'Acute gastric ulcer with hemorrhage, with obstruction',
        'short': 'Ac stomac ulc w hem-obst'},
       {'code': '531.10',
        'long': 'Acute gastric ulcer with perforation, without mention of obstruction',
        'short': 'Ac stomach ulcer w perf'},
       {'code': '531.11',
        'long': 'Acute gastric ulcer with perforation, with obstruction',
        'short': 'Ac stom ulc w perf-obst'},
       {'code': '531.20',
        'long': 'Acute gastric ulcer with hemorrhage and perforation, without mention of obstruction',
        'short': 'Ac stomac ulc w hem/perf'},
       {'code': '531.21',
        'long': 'Acute gastric ulcer with hemorrhage and perforation, with obstruction',
        'short': 'Ac stom ulc hem/perf-obs'},
       {'code': '531.30',
        'long': 'Acute gastric ulcer without mention of hemorrhage or perforation, without mention of obstruction',
        'short': 'Acute stomach ulcer NOS'},
       {'code': '531.31',
        'long': 'Acute gastric ulcer without mention of hemorrhage or perforation, with obstruction',
        'short': 'Ac stomach ulc NOS-obstr'},
       {'code': '531.40',
        'long': 'Chronic or unspecified gastric ulcer with hemorrhage, without mention of obstruction',
        'short': 'Chr stomach ulc w hem'},
       {'code': '531.41',
        'long': 'Chronic or unspecified gastric ulcer with hemorrhage, with obstruction',
        'short': 'Chr stom ulc w hem-obstr'},
       {'code': '531.50',
        'long': 'Chronic or unspecified gastric ulcer with perforation, without mention of obstruction',
        'short': 'Chr stomach ulcer w perf'},
       {'code': '531.51',
        'long': 'Chronic or unspecified gastric ulcer with perforation, with obstruction',
        'short': 'Chr stom ulc w perf-obst'},
       {'code': '531.60',
        'long': 'Chronic or unspecified gastric ulcer with hemorrhage and perforation, without mention of obstruction',
        'short': 'Chr stomach ulc hem/perf'},
       {'code': '531.61',
        'long': 'Chronic or unspecified gastric ulcer with hemorrhage and perforation, with obstruction',
        'short': 'Chr stom ulc hem/perf-ob'},
       {'code': '531.70',
        'long': 'Chronic gastric ulcer without mention of hemorrhage or perforation, without mention of obstruction',
        'short': 'Chr stomach ulcer NOS'},
       {'code': '531.71',
        'long': 'Chronic gastric ulcer without mention of hemorrhage or perforation, with obstruction',
        'short': 'Chr stomach ulc NOS-obst'},
       {'code': '531.90',
        'long': 'Gastric ulcer, unspecified as acute or chronic, without mention of hemorrhage or perforation, without mention of obstruction',
        'short': 'Stomach ulcer NOS'},
       {'code': '531.91',
        'long': 'Gastric ulcer, unspecified as acute or chronic, without mention of hemorrhage or perforation, with obstruction',
        'short': 'Stomach ulcer NOS-obstr'},
       {'code': '532.00',
        'long': 'Acute duodenal ulcer with hemorrhage, without mention of obstruction',
        'short': 'Ac duodenal ulcer w hem'},
       {'code': '532.01',
        'long': 'Acute duodenal ulcer with hemorrhage, with obstruction',
        'short': 'Ac duoden ulc w hem-obst'},
       {'code': '532.10',
        'long': 'Acute duodenal ulcer with perforation, without mention of obstruction',
        'short': 'Ac duodenal ulcer w perf'},
       {'code': '532.11',
        'long': 'Acute duodenal ulcer with perforation, with obstruction',
        'short': 'Ac duoden ulc perf-obstr'},
       {'code': '532.20',
        'long': 'Acute duodenal ulcer with hemorrhage and perforation, without mention of obstruction',
        'short': 'Ac duoden ulc w hem/perf'},
       {'code': '532.21',
        'long': 'Acute duodenal ulcer with hemorrhage and perforation, with obstruction',
        'short': 'Ac duod ulc hem/perf-obs'},
       {'code': '532.30',
        'long': 'Acute duodenal ulcer without mention of hemorrhage or perforation, without mention of obstruction',
        'short': 'Acute duodenal ulcer NOS'},
       {'code': '532.31',
        'long': 'Acute duodenal ulcer without mention of hemorrhage or perforation, with obstruction',
        'short': 'Ac duodenal ulc NOS-obst'},
       {'code': '532.40',
        'long': 'Chronic or unspecified duodenal ulcer with hemorrhage, without mention of obstruction',
        'short': 'Chr duoden ulcer w hem'},
       {'code': '532.41',
        'long': 'Chronic or unspecified duodenal ulcer with hemorrhage, with obstruction',
        'short': 'Chr duoden ulc hem-obstr'},
       {'code': '532.50',
        'long': 'Chronic or unspecified duodenal ulcer with perforation, without mention of obstruction',
        'short': 'Chr duoden ulcer w perf'},
       {'code': '532.51',
        'long': 'Chronic or unspecified duodenal ulcer with perforation, with obstruction',
        'short': 'Chr duoden ulc perf-obst'},
       {'code': '532.60',
        'long': 'Chronic or unspecified duodenal ulcer with hemorrhage and perforation, without mention of obstruction',
        'short': 'Chr duoden ulc hem/perf'},
       {'code': '532.61',
        'long': 'Chronic or unspecified duodenal ulcer with hemorrhage and perforation, with obstruction',
        'short': 'Chr duod ulc hem/perf-ob'},
       {'code': '532.70',
        'long': 'Chronic duodenal ulcer without mention of hemorrhage or perforation, without mention of obstruction',
        'short': 'Chr duodenal ulcer NOS'},
       {'code': '532.71',
        'long': 'Chronic duodenal ulcer without mention of hemorrhage or perforation, with obstruction',
        'short': 'Chr duoden ulc NOS-obstr'},
       {'code': '532.90',
        'long': 'Duodenal ulcer, unspecified as acute or chronic, without hemorrhage or perforation, without mention of obstruction',
        'short': 'Duodenal ulcer NOS'},
       {'code': '532.91',
        'long': 'Duodenal ulcer, unspecified as acute or chronic, without mention of hemorrhage or perforation, with obstruction',
        'short': 'Duodenal ulcer NOS-obstr'},
       {'code': '533.00',
        'long': 'Acute peptic ulcer of unspecified site with hemorrhage, without mention of obstruction',
        'short': 'Ac peptic ulcer w hemorr'},
       {'code': '533.01',
        'long': 'Acute peptic ulcer of unspecified site with hemorrhage, with obstruction',
        'short': 'Ac peptic ulc w hem-obst'},
       {'code': '533.10',
        'long': 'Acute peptic ulcer of unspecified site with perforation, without mention of obstruction',
        'short': 'Ac peptic ulcer w perfor'},
       {'code': '533.11',
        'long': 'Acute peptic ulcer of unspecified site with perforation, with obstruction',
        'short': 'Ac peptic ulc w perf-obs'},
       {'code': '533.20',
        'long': 'Acute peptic ulcer of unspecified site with hemorrhage and perforation, without mention of obstruction',
        'short': 'Ac peptic ulc w hem/perf'},
       {'code': '533.21',
        'long': 'Acute peptic ulcer of unspecified site with hemorrhage and perforation, with obstruction',
        'short': 'Ac pept ulc hem/perf-obs'},
       {'code': '533.30',
        'long': 'Acute peptic ulcer of unspecified site without mention of hemorrhage and perforation, without mention of obstruction',
        'short': 'Acute peptic ulcer NOS'},
       {'code': '533.31',
        'long': 'Acute peptic ulcer of unspecified site without mention of hemorrhage and perforation, with obstruction',
        'short': 'Ac peptic ulcer NOS-obst'},
       {'code': '533.40',
        'long': 'Chronic or unspecified peptic ulcer of unspecified site with hemorrhage, without mention of obstruction',
        'short': 'Chr peptic ulcer w hem'},
       {'code': '533.41',
        'long': 'Chronic or unspecified peptic ulcer of unspecified site with hemorrhage, with obstruction',
        'short': 'Chr peptic ulc w hem-obs'},
       {'code': '533.50',
        'long': 'Chronic or unspecified peptic ulcer of unspecified site with perforation, without mention of obstruction',
        'short': 'Chr peptic ulcer w perf'},
       {'code': '533.51',
        'long': 'Chronic or unspecified peptic ulcer of unspecified site with perforation, with obstruction',
        'short': 'Chr peptic ulc perf-obst'},
       {'code': '533.60',
        'long': 'Chronic or unspecified peptic ulcer of unspecified site with hemorrhage and perforation, without mention of obstruction',
        'short': 'Chr pept ulc w hem/perf'},
       {'code': '533.61',
        'long': 'Chronic or unspecified peptic ulcer of unspecified site with hemorrhage and perforation, with obstruction',
        'short': 'Chr pept ulc hem/perf-ob'},
       {'code': '533.70',
        'long': 'Chronic peptic ulcer of unspecified site without mention of hemorrhage or perforation, without mention of obstruction',
        'short': 'Chronic peptic ulcer NOS'},
       {'code': '533.71',
        'long': 'Chronic peptic ulcer of unspecified site without mention of hemorrhage or perforation, with obstruction',
        'short': 'Chr peptic ulcer NOS-obs'},
       {'code': '533.90',
        'long': 'Peptic ulcer of unspecified site, unspecified as acute or chronic, without mention of hemorrhage or perforation, without mention of obstruction',
        'short': 'Peptic ulcer NOS'},
       {'code': '533.91',
        'long': 'Peptic ulcer of unspecified site, unspecified as acute or chronic, without mention of hemorrhage or perforation, with obstruction',
        'short': 'Peptic ulcer NOS-obstruc'},
       {'code': '534.00',
        'long': 'Acute gastrojejunal ulcer with hemorrhage, without mention of obstruction',
        'short': 'Ac marginal ulcer w hem'},
       {'code': '534.01',
        'long': 'Acute gastrojejunal ulcer, with hemorrhage, with obstruction',
        'short': 'Ac margin ulc w hem-obst'},
       {'code': '534.10',
        'long': 'Acute gastrojejunal ulcer with perforation, without mention of obstruction',
        'short': 'Ac marginal ulcer w perf'},
       {'code': '534.11',
        'long': 'Acute gastrojejunal ulcer with perforation, with obstruction',
        'short': 'Ac margin ulc w perf-obs'},
       {'code': '534.20',
        'long': 'Acute gastrojejunal ulcer with hemorrhage and perforation, without mention of obstruction',
        'short': 'Ac margin ulc w hem/perf'},
       {'code': '534.21',
        'long': 'Acute gastrojejunal ulcer with hemorrhage and perforation, with obstruction',
        'short': 'Ac marg ulc hem/perf-obs'},
       {'code': '534.30',
        'long': 'Acute gastrojejunal ulcer without mention of hemorrhage or perforation, without mention of obstruction',
        'short': 'Ac marginal ulcer NOS'},
       {'code': '534.31',
        'long': 'Acute gastrojejunal ulcer without mention of hemorrhage or perforation, with obstruction',
        'short': 'Ac marginal ulc NOS-obst'},
       {'code': '534.40',
        'long': 'Chronic or unspecified gastrojejunal ulcer with hemorrhage, without mention of obstruction',
        'short': 'Chr marginal ulcer w hem'},
       {'code': '534.41',
        'long': 'Chronic or unspecified gastrojejunal ulcer, with hemorrhage, with obstruction',
        'short': 'Chr margin ulc w hem-obs'},
       {'code': '534.50',
        'long': 'Chronic or unspecified gastrojejunal ulcer with perforation, without mention of obstruction',
        'short': 'Chr marginal ulc w perf'},
       {'code': '534.51',
        'long': 'Chronic or unspecified gastrojejunal ulcer with perforation, with obstruction',
        'short': 'Chr margin ulc perf-obst'},
       {'code': '534.60',
        'long': 'Chronic or unspecified gastrojejunal ulcer with hemorrhage and perforation, without mention of obstruction',
        'short': 'Chr margin ulc hem/perf'},
       {'code': '534.61',
        'long': 'Chronic or unspecified gastrojejunal ulcer with hemorrhage and perforation, with obstruction',
        'short': 'Chr marg ulc hem/perf-ob'},
       {'code': '534.70',
        'long': 'Chronic gastrojejunal ulcer without mention of hemorrhage or perforation, without mention of obstruction',
        'short': 'Chr marginal ulcer NOS'},
       {'code': '534.71',
        'long': 'Chronic gastrojejunal ulcer without mention of hemorrhage or perforation, with obstruction',
        'short': 'Chr marginal ulc NOS-obs'},
       {'code': '534.90',
        'long': 'Gastrojejunal ulcer, unspecified as acute or chronic, without mention of hemorrhage or perforation, without mention of obstruction',
        'short': 'Gastrojejunal ulcer NOS'},
       {'code': '534.91',
        'long': 'Gastrojejunal ulcer, unspecified as acute or chronic, without mention of hemorrhage or perforation, with obstruction',
        'short': 'Gastrojejun ulc NOS-obst'},
       {'code': '535.00',
        'long': 'Acute gastritis, without mention of hemorrhage',
        'short': 'Acute gastrtis w/o hmrhg'},
       {'code': '535.01',
        'long': 'Acute gastritis, with hemorrhage',
        'short': 'Acute gastritis w hmrhg'},
       {'code': '535.10',
        'long': 'Atrophic gastritis, without mention of hemorrhage',
        'short': 'Atrph gastrtis w/o hmrhg'},
       {'code': '535.11',
        'long': 'Atrophic gastritis, with hemorrhage',
        'short': 'Atrph gastritis w hmrhg'},
       {'code': '535.20',
        'long': 'Gastric mucosal hypertrophy, without mention of hemorrhage',
        'short': 'Gstr mcsl hyprt w/o hmrg'},
       {'code': '535.21',
        'long': 'Gastric mucosal hypertrophy, with hemorrhage',
        'short': 'Gstr mcsl hyprt w hmrg'},
       {'code': '535.30',
        'long': 'Alcoholic gastritis, without mention of hemorrhage',
        'short': 'Alchl gastrtis w/o hmrhg'},
       {'code': '535.31',
        'long': 'Alcoholic gastritis, with hemorrhage',
        'short': 'Alchl gstritis w hmrhg'},
       {'code': '535.40',
        'long': 'Other specified gastritis, without mention of hemorrhage',
        'short': 'Oth spf gstrt w/o hmrhg'},
       {'code': '535.41',
        'long': 'Other specified gastritis, with hemorrhage',
        'short': 'Oth spf gastrt w hmrhg'},
       {'code': '535.50',
        'long': 'Unspecified gastritis and gastroduodenitis, without mention of hemorrhage',
        'short': 'Gstr/ddnts NOS w/o hmrhg'},
       {'code': '535.51',
        'long': 'Unspecified gastritis and gastroduodenitis, with hemorrhage',
        'short': 'Gstr/ddnts NOS w hmrhg'},
       {'code': '535.60',
        'long': 'Duodenitis, without mention of hemorrhage',
        'short': 'Duodenitis w/o hmrhg'},
       {'code': '535.61',
        'long': 'Duodenitis, with hemorrhage',
        'short': 'Duodenitis w hmrhg'},
       {'code': '535.70',
        'long': 'Eosinophilic gastritis, without mention of hemorrhage',
        'short': 'Eosinophil gastrt wo hem'},
       {'code': '535.71',
        'long': 'Eosinophilic gastritis, with hemorrhage',
        'short': 'Eosinophilc gastrt w hem'},
       {'code': '536.0', 'long': 'Achlorhydria', 'short': 'Achlorhydria'},
       {'code': '536.1',
        'long': 'Acute dilatation of stomach',
        'short': 'Ac dilation of stomach'},
       {'code': '536.2',
        'long': 'Persistent vomiting',
        'short': 'Persistent vomiting'},
       {'code': '536.3', 'long': 'Gastroparesis', 'short': 'Gastroparesis'},
       {'code': '536.40',
        'long': 'Gastrostomy complication, unspecified',
        'short': 'Gastrostomy comp NOS'},
       {'code': '536.41',
        'long': 'Infection of gastrostomy',
        'short': 'Gastrostomy infection'},
       {'code': '536.42',
        'long': 'Mechanical complication of gastrostomy',
        'short': 'Gastrostomy comp - mech'},
       {'code': '536.49',
        'long': 'Other gastrostomy complications',
        'short': 'Gastrostomy comp NEC'},
       {'code': '536.8',
        'long': 'Dyspepsia and other specified disorders of function of stomach',
        'short': 'Stomach function dis NEC'},
       {'code': '536.9',
        'long': 'Unspecified functional disorder of stomach',
        'short': 'Stomach function dis NOS'},
       {'code': '537.0',
        'long': 'Acquired hypertrophic pyloric stenosis',
        'short': 'Acq pyloric stenosis'},
       {'code': '537.1',
        'long': 'Gastric diverticulum',
        'short': 'Gastric diverticulum'},
       {'code': '537.2',
        'long': 'Chronic duodenal ileus',
        'short': 'Chronic duodenal ileus'},
       {'code': '537.3',
        'long': 'Other obstruction of duodenum',
        'short': 'Duodenal obstruction NEC'},
       {'code': '537.4',
        'long': 'Fistula of stomach or duodenum',
        'short': 'Gastric/duodenal fistula'},
       {'code': '537.5', 'long': 'Gastroptosis', 'short': 'Gastroptosis'},
       {'code': '537.6',
        'long': 'Hourglass stricture or stenosis of stomach',
        'short': 'Hourglass stricture stom'},
       {'code': '537.81', 'long': 'Pylorospasm', 'short': 'Pylorospasm'},
       {'code': '537.82',
        'long': 'Angiodysplasia of stomach and duodenum without mention of hemorrhage',
        'short': 'Angio stm/dudn w/o hmrhg'},
       {'code': '537.83',
        'long': 'Angiodysplasia of stomach and duodenum with hemorrhage',
        'short': 'Angio stm/dudn w hmrhg'},
       {'code': '537.84',
        'long': 'Dieulafoy lesion (hemorrhagic) of stomach and duodenum',
        'short': 'Dieulafoy les,stom&duod'},
       {'code': '537.89',
        'long': 'Other specified disorders of stomach and duodenum',
        'short': 'Gastroduodenal dis NEC'},
       {'code': '537.9',
        'long': 'Unspecified disorder of stomach and duodenum',
        'short': 'Gastroduodenal dis NOS'},
       {'code': '538',
        'long': 'Gastrointestinal mucositis (ulcerative)',
        'short': 'GI mucositis (ulceratve)'},
       {'code': '539.01',
        'long': 'Infection due to gastric band procedure',
        'short': 'Inf d/t gastrc band proc'},
       {'code': '539.09',
        'long': 'Other complications of gastric band procedure',
        'short': 'Oth cmp gastrc band proc'},
       {'code': '539.81',
        'long': 'Infection due to other bariatric procedure',
        'short': 'Inf d/t ot bariatrc proc'},
       {'code': '539.89',
        'long': 'Other complications of other bariatric procedure',
        'short': 'Ot comp ot bariatrc proc'},
       {'code': '540.0',
        'long': 'Acute appendicitis with generalized peritonitis',
        'short': 'Ac append w peritonitis'},
       {'code': '540.1',
        'long': 'Acute appendicitis with peritoneal abscess',
        'short': 'Abscess of appendix'},
       {'code': '540.9',
        'long': 'Acute appendicitis without mention of peritonitis',
        'short': 'Acute appendicitis NOS'},
       {'code': '541',
        'long': 'Appendicitis, unqualified',
        'short': 'Appendicitis NOS'},
       {'code': '542',
        'long': 'Other appendicitis',
        'short': 'Other appendicitis'},
       {'code': '543.0',
        'long': 'Hyperplasia of appendix (lymphoid)',
        'short': 'Hyperplasia of appendix'},
       {'code': '543.9',
        'long': 'Other and unspecified diseases of appendix',
        'short': 'Diseases of appendix NEC'},
       {'code': '550.00',
        'long': 'Inguinal hernia, with gangrene, unilateral or unspecified (not specified as recurrent)',
        'short': 'Unilat ing hernia w gang'},
       {'code': '550.01',
        'long': 'Inguinal hernia, with gangrene, unilateral or unspecified, recurrent',
        'short': 'Recur unil ing hern-gang'},
       {'code': '550.02',
        'long': 'Inguinal hernia, with gangrene, bilateral (not specified as recurrent)',
        'short': 'Bilat ing hernia w gang'},
       {'code': '550.03',
        'long': 'Inguinal hernia, with gangrene, bilateral, recurrent',
        'short': 'Recur bil ing hern-gang'},
       {'code': '550.10',
        'long': 'Inguinal hernia, with obstruction, without mention of gangrene, unilateral or unspecified (not specified as recurrent)',
        'short': 'Unilat ing hernia w obst'},
       {'code': '550.11',
        'long': 'Inguinal hernia, with obstruction, without mention of gangrene, unilateral or unspecified, recurrent',
        'short': 'Recur unil ing hern-obst'},
       {'code': '550.12',
        'long': 'Inguinal hernia, with obstruction, without mention of gangrene, bilateral (not specified as recurrent)',
        'short': 'Bilat ing hernia w obst'},
       {'code': '550.13',
        'long': 'Inguinal hernia, with obstruction, without mention of gangrene, bilateral, recurrent',
        'short': 'Recur bil ing hern-obstr'},
       {'code': '550.90',
        'long': 'Inguinal hernia, without mention of obstruction or gangrene, unilateral or unspecified (not specified as recurrent)',
        'short': 'Unilat inguinal hernia'},
       {'code': '550.91',
        'long': 'Inguinal hernia, without mention of obstruction or gangrene, unilateral or unspecified, recurrent',
        'short': 'Recur unilat inguin hern'},
       {'code': '550.92',
        'long': 'Inguinal hernia, without mention of obstruction or gangrene, bilateral (not specified as recurrent)',
        'short': 'Bilat inguinal hernia'},
       {'code': '550.93',
        'long': 'Inguinal hernia, without mention of obstruction or gangrene, bilateral, recurrent',
        'short': 'Recur bilat inguin hern'},
       {'code': '551.00',
        'long': 'Femoral hernia with gangrene, unilateral or unspecified (not specified as recurrent)',
        'short': 'Unil femoral hern w gang'},
       {'code': '551.01',
        'long': 'Femoral hernia with gangrene, unilateral or unspecified, recurrent',
        'short': 'Rec unil fem hern w gang'},
       {'code': '551.02',
        'long': 'Femoral hernia with gangrene, bilateral (not specified as recurrent)',
        'short': 'Bilat fem hern w gang'},
       {'code': '551.03',
        'long': 'Femoral hernia with gangrene, bilateral, recurrent',
        'short': 'Recur bil fem hern-gang'},
       {'code': '551.1',
        'long': 'Umbilical hernia with gangrene',
        'short': 'Umbilical hernia w gangr'},
       {'code': '551.20',
        'long': 'Ventral hernia, unspecified, with gangrene',
        'short': 'Gangr ventral hernia NOS'},
       {'code': '551.21',
        'long': 'Incisional ventral hernia, with gangrene',
        'short': 'Gangr incisional hernia'},
       {'code': '551.29',
        'long': 'Other ventral hernia with gangrene',
        'short': 'Gang ventral hernia NEC'},
       {'code': '551.3',
        'long': 'Diaphragmatic hernia with gangrene',
        'short': 'Diaphragm hernia w gangr'},
       {'code': '551.8',
        'long': 'Hernia of other specified sites, with gangrene',
        'short': 'Hernia, site NEC w gangr'},
       {'code': '551.9',
        'long': 'Hernia of unspecified site, with gangrene',
        'short': 'Hernia, site NOS w gangr'},
       {'code': '552.00',
        'long': 'Femoral hernia with obstruction, unilateral or unspecified (not specified as recurrent)',
        'short': 'Unil femoral hern w obst'},
       {'code': '552.01',
        'long': 'Femoral hernia with obstruction, unilateral or unspecified, recurrent',
        'short': 'Rec unil fem hern w obst'},
       {'code': '552.02',
        'long': 'Femoral hernia with obstruction, bilateral (not specified as recurrent)',
        'short': 'Bil femoral hern w obstr'},
       {'code': '552.03',
        'long': 'Femoral hernia with obstruction, bilateral, recurrent',
        'short': 'Rec bil fem hern w obstr'},
       {'code': '552.1',
        'long': 'Umbilical hernia with obstruction',
        'short': 'Umbilical hernia w obstr'},
       {'code': '552.20',
        'long': 'Ventral, unspecified, hernia with obstruction',
        'short': 'Obstr ventral hernia NOS'},
       {'code': '552.21',
        'long': 'Incisional ventral hernia with obstruction',
        'short': 'Obstr incisional hernia'},
       {'code': '552.29',
        'long': 'Other ventral hernia with obstruction',
        'short': 'Obstr ventral hernia NEC'},
       {'code': '552.3',
        'long': 'Diaphragmatic hernia with obstruction',
        'short': 'Diaphragm hernia w obstr'},
       {'code': '552.8',
        'long': 'Hernia of other specified sites, with obstruction',
        'short': 'Hernia, site NEC w obstr'},
       {'code': '552.9',
        'long': 'Hernia of unspecified site, with obstruction',
        'short': 'Hernia, site NOS w obstr'},
       {'code': '553.00',
        'long': 'Femoral hernia without mention of obstruction of gangrene, unilateral or unspecified(not specified as recurrent)',
        'short': 'Unilat femoral hernia'},
       {'code': '553.01',
        'long': 'Femoral hernia without mention of obstruction or gangrene, unilateral or unspecified, recurrent',
        'short': 'Recur unil femoral hern'},
       {'code': '553.02',
        'long': 'Femoral hernia without mention of obstruction or gangrene, bilateral (not specified as recurrent)',
        'short': 'Bilateral femoral hernia'},
       {'code': '553.03',
        'long': 'Femoral hernia without mention of obstruction or gangrene, bilateral,recurrent',
        'short': 'Recur bilat femoral hern'},
       {'code': '553.1',
        'long': 'Umbilical hernia without mention of obstruction or gangrene',
        'short': 'Umbilical hernia'},
       {'code': '553.20',
        'long': 'Ventral, unspecified, hernia without mention of obstruction or gangrene',
        'short': 'Ventral hernia NOS'},
       {'code': '553.21',
        'long': 'Incisional hernia without mention of obstruction or gangrene',
        'short': 'Incisional hernia'},
       {'code': '553.29',
        'long': 'Other ventral hernia without mention of obstruction or gangrene',
        'short': 'Ventral hernia NEC'},
       {'code': '553.3',
        'long': 'Diaphragmatic hernia without mention of obstruction or gangrene',
        'short': 'Diaphragmatic hernia'},
       {'code': '553.8',
        'long': 'Hernia of other specified sites without mention of obstruction or gangrene',
        'short': 'Hernia NEC'},
       {'code': '553.9',
        'long': 'Hernia of unspecified site without mention of obstruction or gangrene',
        'short': 'Hernia NOS'},
       {'code': '555.0',
        'long': 'Regional enteritis of small intestine',
        'short': 'Reg enteritis, sm intest'},
       {'code': '555.1',
        'long': 'Regional enteritis of large intestine',
        'short': 'Reg enteritis, lg intest'},
       {'code': '555.2',
        'long': 'Regional enteritis of small intestine with large intestine',
        'short': 'Reg enterit sm/lg intest'},
       {'code': '555.9',
        'long': 'Regional enteritis of unspecified site',
        'short': 'Regional enteritis NOS'},
       {'code': '556.0',
        'long': 'Ulcerative (chronic) enterocolitis',
        'short': 'Ulcerative enterocolitis'},
       {'code': '556.1',
        'long': 'Ulcerative (chronic) ileocolitis',
        'short': 'Ulcerative ileocolitis'},
       {'code': '556.2',
        'long': 'Ulcerative (chronic) proctitis',
        'short': 'Ulcerative proctitis'},
       {'code': '556.3',
        'long': 'Ulcerative (chronic) proctosigmoiditis',
        'short': 'Ulcertve prctosigmoidtis'},
       {'code': '556.4',
        'long': 'Pseudopolyposis of colon',
        'short': 'Pseudopolyposis colon'},
       {'code': '556.5',
        'long': 'Left-sided ulcerative (chronic) colitis',
        'short': 'Lftsded ulcertve colitis'},
       {'code': '556.6',
        'long': 'Universal ulcerative (chronic) colitis',
        'short': 'Univrsl ulcertve colitis'},
       {'code': '556.8',
        'long': 'Other ulcerative colitis',
        'short': 'Other ulcerative colitis'},
       {'code': '556.9',
        'long': 'Ulcerative colitis, unspecified',
        'short': 'Ulceratve colitis unspcf'},
       {'code': '557.0',
        'long': 'Acute vascular insufficiency of intestine',
        'short': 'Ac vasc insuff intestine'},
       {'code': '557.1',
        'long': 'Chronic vascular insufficiency of intestine',
        'short': 'Chr vasc insuff intest'},
       {'code': '557.9',
        'long': 'Unspecified vascular insufficiency of intestine',
        'short': 'Vasc insuff intest NOS'},
       {'code': '558.1',
        'long': 'Gastroenteritis and colitis due to radiation',
        'short': 'Radiation gastroenterit'},
       {'code': '558.2',
        'long': 'Toxic gastroenteritis and colitis',
        'short': 'Toxic gastroenteritis'},
       {'code': '558.3',
        'long': 'Allergic gastroenteritis and colitis',
        'short': 'Allrgic gastro & colitis'},
       {'code': '558.41',
        'long': 'Eosinophilic gastroenteritis',
        'short': 'Eosinophilic gastroent'},
       {'code': '558.42',
        'long': 'Eosinophilic colitis',
        'short': 'Eosinophilic colitis'},
       {'code': '558.9',
        'long': 'Other and unspecified noninfectious gastroenteritis and colitis',
        'short': 'Noninf gastroenterit NEC'},
       {'code': '560.0',
        'long': 'Intussusception',
        'short': 'Intussusception'},
       {'code': '560.1',
        'long': 'Paralytic ileus',
        'short': 'Paralytic ileus'},
       {'code': '560.2',
        'long': 'Volvulus',
        'short': 'Volvulus of intestine'},
       {'code': '560.30',
        'long': 'Impaction of intestine, unspecified',
        'short': 'Impaction intestine NOS'},
       {'code': '560.31',
        'long': 'Gallstone ileus',
        'short': 'Gallstone ileus'},
       {'code': '560.32',
        'long': 'Fecal impaction',
        'short': 'Fecal impaction'},
       {'code': '560.39',
        'long': 'Other impaction of intestine',
        'short': 'Impaction intestine NEC'},
       {'code': '560.81',
        'long': 'Intestinal or peritoneal adhesions with obstruction (postoperative) (postinfection)',
        'short': 'Intestinal adhes w obstr'},
       {'code': '560.89',
        'long': 'Other specified intestinal obstruction',
        'short': 'Intestinal obstruct NEC'},
       {'code': '560.9',
        'long': 'Unspecified intestinal obstruction',
        'short': 'Intestinal obstruct NOS'},
       {'code': '562.00',
        'long': 'Diverticulosis of small intestine (without mention of hemorrhage)',
        'short': 'Dvrtclo sml int w/o hmrg'},
       {'code': '562.01',
        'long': 'Diverticulitis of small intestine (without mention of hemorrhage)',
        'short': 'Dvrtcli sml int w/o hmrg'},
       {'code': '562.02',
        'long': 'Diverticulosis of small intestine with hemorrhage',
        'short': 'Dvrtclo sml int w hmrhg'},
       {'code': '562.03',
        'long': 'Diverticulitis of small intestine with hemorrhage',
        'short': 'Dvrtcli sml int w hmrhg'},
       {'code': '562.10',
        'long': 'Diverticulosis of colon (without mention of hemorrhage)',
        'short': 'Dvrtclo colon w/o hmrhg'},
       {'code': '562.11',
        'long': 'Diverticulitis of colon (without mention of hemorrhage)',
        'short': 'Dvrtcli colon w/o hmrhg'},
       {'code': '562.12',
        'long': 'Diverticulosis of colon with hemorrhage',
        'short': 'Dvrtclo colon w hmrhg'},
       {'code': '562.13',
        'long': 'Diverticulitis of colon with hemorrhage',
        'short': 'Dvrtcli colon w hmrhg'},
       {'code': '564.00',
        'long': 'Constipation, unspecified',
        'short': 'Constipation NOS'},
       {'code': '564.01',
        'long': 'Slow transit constipation',
        'short': 'Slow transt constipation'},
       {'code': '564.02',
        'long': 'Outlet dysfunction constipation',
        'short': 'Outlet dysfnc constption'},
       {'code': '564.09',
        'long': 'Other constipation',
        'short': 'Constipation NEC'},
       {'code': '564.1',
        'long': 'Irritable bowel syndrome',
        'short': 'Irritable bowel syndrome'},
       {'code': '564.2',
        'long': 'Postgastric surgery syndromes',
        'short': 'Postgastric surgery synd'},
       {'code': '564.3',
        'long': 'Vomiting following gastrointestinal surgery',
        'short': 'Vomiting post-gi surgery'},
       {'code': '564.4',
        'long': 'Other postoperative functional disorders',
        'short': 'Postop GI funct dis NEC'},
       {'code': '564.5',
        'long': 'Functional diarrhea',
        'short': 'Functional diarrhea'},
       {'code': '564.6', 'long': 'Anal spasm', 'short': 'Anal spasm'},
       {'code': '564.7',
        'long': "Megacolon, other than Hirschsprung's",
        'short': 'Megacolon NEC'},
       {'code': '564.81',
        'long': 'Neurogenic bowel',
        'short': 'Neurogenic bowel'},
       {'code': '564.89',
        'long': 'Other functional disorders of intestine',
        'short': 'Funct dis intestine NEC'},
       {'code': '564.9',
        'long': 'Unspecified functional disorder of intestine',
        'short': 'Funct dis intestine NOS'},
       {'code': '565.0', 'long': 'Anal fissure', 'short': 'Anal fissure'},
       {'code': '565.1', 'long': 'Anal fistula', 'short': 'Anal fistula'},
       {'code': '566',
        'long': 'Abscess of anal and rectal regions',
        'short': 'Anal & rectal abscess'},
       {'code': '567.0',
        'long': 'Peritonitis in infectious diseases classified elsewhere',
        'short': 'Peritonitis in infec dis'},
       {'code': '567.1',
        'long': 'Pneumococcal peritonitis',
        'short': 'Pneumococcal peritonitis'},
       {'code': '567.21',
        'long': 'Peritonitis (acute) generalized',
        'short': 'Peritonitis (acute) gen'},
       {'code': '567.22',
        'long': 'Peritoneal abscess',
        'short': 'Peritoneal abscess'},
       {'code': '567.23',
        'long': 'Spontaneous bacterial peritonitis',
        'short': 'Spontan bact peritonitis'},
       {'code': '567.29',
        'long': 'Other suppurative peritonitis',
        'short': 'Suppurat peritonitis NEC'},
       {'code': '567.31',
        'long': 'Psoas muscle abscess',
        'short': 'Psoas muscle abscess'},
       {'code': '567.38',
        'long': 'Other retroperitoneal abscess',
        'short': 'Retroperiton abscess NEC'},
       {'code': '567.39',
        'long': 'Other retroperitoneal infections',
        'short': 'Retroperiton infect NEC'},
       {'code': '567.81',
        'long': 'Choleperitonitis',
        'short': 'Choleperitonitis'},
       {'code': '567.82',
        'long': 'Sclerosing mesenteritis',
        'short': 'Sclerosing mesenteritis'},
       {'code': '567.89',
        'long': 'Other specified peritonitis',
        'short': 'Peritonitis NEC'},
       {'code': '567.9',
        'long': 'Unspecified peritonitis',
        'short': 'Peritonitis NOS'},
       {'code': '568.0',
        'long': 'Peritoneal adhesions (postoperative) (postinfection)',
        'short': 'Peritoneal adhesions'},
       {'code': '568.81',
        'long': 'Hemoperitoneum (nontraumatic)',
        'short': 'Hemoperitoneum'},
       {'code': '568.82',
        'long': 'Peritoneal effusion (chronic)',
        'short': 'Peritoneal effusion'},
       {'code': '568.89',
        'long': 'Other specified disorders of peritoneum',
        'short': 'Peritoneal disorder NEC'},
       {'code': '568.9',
        'long': 'Unspecified disorder of peritoneum',
        'short': 'Peritoneal disorder NOS'},
       {'code': '569.0',
        'long': 'Anal and rectal polyp',
        'short': 'Anal & rectal polyp'},
       {'code': '569.1',
        'long': 'Rectal prolapse',
        'short': 'Rectal prolapse'},
       {'code': '569.2',
        'long': 'Stenosis of rectum and anus',
        'short': 'Rectal & anal stenosis'},
       {'code': '569.3',
        'long': 'Hemorrhage of rectum and anus',
        'short': 'Rectal & anal hemorrhage'},
       {'code': '569.41',
        'long': 'Ulcer of anus and rectum',
        'short': 'Rectal & anal ulcer'},
       {'code': '569.42',
        'long': 'Anal or rectal pain',
        'short': 'Anal or rectal pain'},
       {'code': '569.43',
        'long': 'Anal sphincter tear (healed) (old)',
        'short': 'Anal sphincter tear-old'},
       {'code': '569.44',
        'long': 'Dysplasia of anus',
        'short': 'Dysplasia of anus'},
       {'code': '569.49',
        'long': 'Other specified disorders of rectum and anus',
        'short': 'Rectal & anal dis NEC'},
       {'code': '569.5',
        'long': 'Abscess of intestine',
        'short': 'Intestinal abscess'},
       {'code': '569.60',
        'long': 'Colostomy and enterostomy complication, unspecified',
        'short': 'Colstomy/enter comp NOS'},
       {'code': '569.61',
        'long': 'Infection of colostomy or enterostomy',
        'short': 'Colosty/enterost infectn'},
       {'code': '569.62',
        'long': 'Mechanical complication of colostomy and enterostomy',
        'short': 'Colosty/enter comp-mech'},
       {'code': '569.69',
        'long': 'Other colostomy and enterostomy complication',
        'short': 'Colstmy/enteros comp NEC'},
       {'code': '569.71', 'long': 'Pouchitis', 'short': 'Pouchitis'},
       {'code': '569.79',
        'long': 'Other complications of intestinal pouch',
        'short': 'Comp intest pouch NEC'},
       {'code': '569.81',
        'long': 'Fistula of intestine, excluding rectum and anus',
        'short': 'Intestinal fistula'},
       {'code': '569.82',
        'long': 'Ulceration of intestine',
        'short': 'Ulceration of intestine'},
       {'code': '569.83',
        'long': 'Perforation of intestine',
        'short': 'Perforation of intestine'},
       {'code': '569.84',
        'long': 'Angiodysplasia of intestine (without mention of hemorrhage)',
        'short': 'Angio intes w/o hmrhg'},
       {'code': '569.85',
        'long': 'Angiodysplasia of intestine with hemorrhage',
        'short': 'Angio intes w hmrhg'},
       {'code': '569.86',
        'long': 'Dieulafoy lesion (hemorrhagic) of intestine',
        'short': 'Dieulafoy les, intestine'},
       {'code': '569.87',
        'long': 'Vomiting of fecal matter',
        'short': 'Vomiting of fecal matter'},
       {'code': '569.89',
        'long': 'Other specified disorders of intestine',
        'short': 'Intestinal disorders NEC'},
       {'code': '569.9',
        'long': 'Unspecified disorder of intestine',
        'short': 'Intestinal disorder NOS'},
       {'code': '570',
        'long': 'Acute and subacute necrosis of liver',
        'short': 'Acute necrosis of liver'},
       {'code': '571.0',
        'long': 'Alcoholic fatty liver',
        'short': 'Alcoholic fatty liver'},
       {'code': '571.1',
        'long': 'Acute alcoholic hepatitis',
        'short': 'Ac alcoholic hepatitis'},
       {'code': '571.2',
        'long': 'Alcoholic cirrhosis of liver',
        'short': 'Alcohol cirrhosis liver'},
       {'code': '571.3',
        'long': 'Alcoholic liver damage, unspecified',
        'short': 'Alcohol liver damage NOS'},
       {'code': '571.40',
        'long': 'Chronic hepatitis, unspecified',
        'short': 'Chronic hepatitis NOS'},
       {'code': '571.41',
        'long': 'Chronic persistent hepatitis',
        'short': 'Chr persistent hepatitis'},
       {'code': '571.42',
        'long': 'Autoimmune hepatitis',
        'short': 'Autoimmune hepatitis'},
       {'code': '571.49',
        'long': 'Other chronic hepatitis',
        'short': 'Chronic hepatitis NEC'},
       {'code': '571.5',
        'long': 'Cirrhosis of liver without mention of alcohol',
        'short': 'Cirrhosis of liver NOS'},
       {'code': '571.6',
        'long': 'Biliary cirrhosis',
        'short': 'Biliary cirrhosis'},
       {'code': '571.8',
        'long': 'Other chronic nonalcoholic liver disease',
        'short': 'Chronic liver dis NEC'},
       {'code': '571.9',
        'long': 'Unspecified chronic liver disease without mention of alcohol',
        'short': 'Chronic liver dis NOS'},
       {'code': '572.0',
        'long': 'Abscess of liver',
        'short': 'Abscess of liver'},
       {'code': '572.1', 'long': 'Portal pyemia', 'short': 'Portal pyemia'},
       {'code': '572.2',
        'long': 'Hepatic encephalopathy',
        'short': 'Hepatic encephalopathy'},
       {'code': '572.3',
        'long': 'Portal hypertension',
        'short': 'Portal hypertension'},
       {'code': '572.4',
        'long': 'Hepatorenal syndrome',
        'short': 'Hepatorenal syndrome'},
       {'code': '572.8',
        'long': 'Other sequelae of chronic liver disease',
        'short': 'Oth sequela, chr liv dis'},
       {'code': '573.0',
        'long': 'Chronic passive congestion of liver',
        'short': 'Chr passiv congest liver'},
       {'code': '573.1',
        'long': 'Hepatitis in viral diseases classified elsewhere',
        'short': 'Hepatitis in viral dis'},
       {'code': '573.2',
        'long': 'Hepatitis in other infectious diseases classified elsewhere',
        'short': 'Hepatitis in oth inf dis'},
       {'code': '573.3',
        'long': 'Hepatitis, unspecified',
        'short': 'Hepatitis NOS'},
       {'code': '573.4',
        'long': 'Hepatic infarction',
        'short': 'Hepatic infarction'},
       {'code': '573.5',
        'long': 'Hepatopulmonary syndrome',
        'short': 'Hepatopulmonary syndrome'},
       {'code': '573.8',
        'long': 'Other specified disorders of liver',
        'short': 'Liver disorders NEC'},
       {'code': '573.9',
        'long': 'Unspecified disorder of liver',
        'short': 'Liver disorder NOS'},
       {'code': '574.00',
        'long': 'Calculus of gallbladder with acute cholecystitis, without mention of obstruction',
        'short': 'Cholelith w ac cholecyst'},
       {'code': '574.01',
        'long': 'Calculus of gallbladder with acute cholecystitis, with obstruction',
        'short': 'Cholelith/ac gb inf-obst'},
       {'code': '574.10',
        'long': 'Calculus of gallbladder with other cholecystitis, without mention of obstruction',
        'short': 'Cholelith w cholecys NEC'},
       {'code': '574.11',
        'long': 'Calculus of gallbladder with other cholecystitis, with obstruction',
        'short': 'Cholelith/gb inf NEC-obs'},
       {'code': '574.20',
        'long': 'Calculus of gallbladder without mention of cholecystitis, without mention of obstruction',
        'short': 'Cholelithiasis NOS'},
       {'code': '574.21',
        'long': 'Calculus of gallbladder without mention of cholecystitis, with obstruction',
        'short': 'Cholelithias NOS w obstr'},
       {'code': '574.30',
        'long': 'Calculus of bile duct with acute cholecystitis, without mention of obstruction',
        'short': 'Choledocholith/ac gb inf'},
       {'code': '574.31',
        'long': 'Calculus of bile duct with acute cholecystitis, with obstruction',
        'short': 'Choledochlith/ac gb-obst'},
       {'code': '574.40',
        'long': 'Calculus of bile duct with other cholecystitis, without mention of obstruction',
        'short': 'Choledochlith/gb inf NEC'},
       {'code': '574.41',
        'long': 'Calculus of bile duct with other cholecystitis, with obstruction',
        'short': 'Choledochlith/gb NEC-obs'},
       {'code': '574.50',
        'long': 'Calculus of bile duct without mention of cholecystitis, without mention of obstruction',
        'short': 'Choledocholithiasis NOS'},
       {'code': '574.51',
        'long': 'Calculus of bile duct without mention of cholecystitis, with obstruction',
        'short': 'Choledochlith NOS w obst'},
       {'code': '574.60',
        'long': 'Calculus of gallbladder and bile duct with acute cholecystitis, without mention of obstruction',
        'short': 'Gall&bil cal w/ac w/o ob'},
       {'code': '574.61',
        'long': 'Calculus of gallbladder and bile duct with acute cholecystitis, with obstruction',
        'short': 'Gall&bil cal w/ac w obs'},
       {'code': '574.70',
        'long': 'Calculus of gallbladder and bile duct with other cholecystitis, without mention of obstruction',
        'short': 'Gal&bil cal w/oth w/o ob'},
       {'code': '574.71',
        'long': 'Calculus of gallbladder and bile duct with other cholecystitis, with obstruction',
        'short': 'Gall&bil cal w/oth w obs'},
       {'code': '574.80',
        'long': 'Calculus of gallbladder and bile duct with acute and chronic cholecystitis, without mention of obstruction',
        'short': 'Gal&bil cal w/ac&chr w/o'},
       {'code': '574.81',
        'long': 'Calculus of gallbladder and bile duct with acute and chronic cholecystitis, with obstruction',
        'short': 'Gal&bil cal w/ac&ch w ob'},
       {'code': '574.90',
        'long': 'Calculus of gallbladder and bile duct without cholecystitis, without mention of obstruction',
        'short': 'Gall&bil cal w/o cho w/o'},
       {'code': '574.91',
        'long': 'Calculus of gallbladder and bile duct without cholecystitis, with obstruction',
        'short': 'Gall&bil cal w/o ch w ob'},
       {'code': '575.0',
        'long': 'Acute cholecystitis',
        'short': 'Acute cholecystitis'},
       {'code': '575.10',
        'long': 'Cholecystitis, unspecified',
        'short': 'Cholecystitis NOS'},
       {'code': '575.11',
        'long': 'Chronic cholecystitis',
        'short': 'Chronic cholecystitis'},
       {'code': '575.12',
        'long': 'Acute and chronic cholecystitis',
        'short': 'Acte & chr cholecystitis'},
       {'code': '575.2',
        'long': 'Obstruction of gallbladder',
        'short': 'Obstruction gallbladder'},
       {'code': '575.3',
        'long': 'Hydrops of gallbladder',
        'short': 'Hydrops of gallbladder'},
       {'code': '575.4',
        'long': 'Perforation of gallbladder',
        'short': 'Perforation gallbladder'},
       {'code': '575.5',
        'long': 'Fistula of gallbladder',
        'short': 'Fistula of gallbladder'},
       {'code': '575.6',
        'long': 'Cholesterolosis of gallbladder',
        'short': 'Gb cholesterolosis'},
       {'code': '575.8',
        'long': 'Other specified disorders of gallbladder',
        'short': 'Dis of gallbladder NEC'},
       {'code': '575.9',
        'long': 'Unspecified disorder of gallbladder',
        'short': 'Dis of gallbladder NOS'},
       {'code': '576.0',
        'long': 'Postcholecystectomy syndrome',
        'short': 'Postcholecystectomy synd'},
       {'code': '576.1', 'long': 'Cholangitis', 'short': 'Cholangitis'},
       {'code': '576.2',
        'long': 'Obstruction of bile duct',
        'short': 'Obstruction of bile duct'},
       {'code': '576.3',
        'long': 'Perforation of bile duct',
        'short': 'Perforation of bile duct'},
       {'code': '576.4',
        'long': 'Fistula of bile duct',
        'short': 'Fistula of bile duct'},
       {'code': '576.5',
        'long': 'Spasm of sphincter of Oddi',
        'short': 'Spasm sphincter of oddi'},
       {'code': '576.8',
        'long': 'Other specified disorders of biliary tract',
        'short': 'Dis of biliary tract NEC'},
       {'code': '576.9',
        'long': 'Unspecified disorder of biliary tract',
        'short': 'Dis of biliary tract NOS'},
       {'code': '577.0',
        'long': 'Acute pancreatitis',
        'short': 'Acute pancreatitis'},
       {'code': '577.1',
        'long': 'Chronic pancreatitis',
        'short': 'Chronic pancreatitis'},
       {'code': '577.2',
        'long': 'Cyst and pseudocyst of pancreas',
        'short': 'Pancreat cyst/pseudocyst'},
       {'code': '577.8',
        'long': 'Other specified diseases of pancreas',
        'short': 'Pancreatic disease NEC'},
       {'code': '577.9',
        'long': 'Unspecified disease of pancreas',
        'short': 'Pancreatic disease NOS'},
       {'code': '578.0', 'long': 'Hematemesis', 'short': 'Hematemesis'},
       {'code': '578.1', 'long': 'Blood in stool', 'short': 'Blood in stool'},
       {'code': '578.9',
        'long': 'Hemorrhage of gastrointestinal tract, unspecified',
        'short': 'Gastrointest hemorr NOS'},
       {'code': '579.0', 'long': 'Celiac disease', 'short': 'Celiac disease'},
       {'code': '579.1', 'long': 'Tropical sprue', 'short': 'Tropical sprue'},
       {'code': '579.2',
        'long': 'Blind loop syndrome',
        'short': 'Blind loop syndrome'},
       {'code': '579.3',
        'long': 'Other and unspecified postsurgical nonabsorption',
        'short': 'Intest postop nonabsorb'},
       {'code': '579.4',
        'long': 'Pancreatic steatorrhea',
        'short': 'Pancreatic steatorrhea'},
       {'code': '579.8',
        'long': 'Other specified intestinal malabsorption',
        'short': 'Intest malabsorption NEC'},
       {'code': '579.9',
        'long': 'Unspecified intestinal malabsorption',
        'short': 'Intest malabsorption NOS'}],
 'L': [{'code': '680.0',
        'long': 'Carbuncle and furuncle of face',
        'short': 'Carbuncle of face'},
       {'code': '680.1',
        'long': 'Carbuncle and furuncle of neck',
        'short': 'Carbuncle of neck'},
       {'code': '680.2',
        'long': 'Carbuncle and furuncle of trunk',
        'short': 'Carbuncle of trunk'},
       {'code': '680.3',
        'long': 'Carbuncle and furuncle of upper arm and forearm',
        'short': 'Carbuncle of arm'},
       {'code': '680.4',
        'long': 'Carbuncle and furuncle of hand',
        'short': 'Carbuncle of hand'},
       {'code': '680.5',
        'long': 'Carbuncle and furuncle of buttock',
        'short': 'Carbuncle of buttock'},
       {'code': '680.6',
        'long': 'Carbuncle and furuncle of leg, except foot',
        'short': 'Carbuncle of leg'},
       {'code': '680.7',
        'long': 'Carbuncle and furuncle of foot',
        'short': 'Carbuncle of foot'},
       {'code': '680.8',
        'long': 'Carbuncle and furuncle of other specified sites',
        'short': 'Carbuncle, site NEC'},
       {'code': '680.9',
        'long': 'Carbuncle and furuncle of unspecified site',
        'short': 'Carbuncle NOS'},
       {'code': '681.00',
        'long': 'Cellulitis and abscess of finger, unspecified',
        'short': 'Cellulitis, finger NOS'},
       {'code': '681.01', 'long': 'Felon', 'short': 'Felon'},
       {'code': '681.02',
        'long': 'Onychia and paronychia of finger',
        'short': 'Onychia of finger'},
       {'code': '681.10',
        'long': 'Cellulitis and abscess of toe, unspecified',
        'short': 'Cellulitis, toe NOS'},
       {'code': '681.11',
        'long': 'Onychia and paronychia of toe',
        'short': 'Onychia of toe'},
       {'code': '681.9',
        'long': 'Cellulitis and abscess of unspecified digit',
        'short': 'Cellulitis of digit NOS'},
       {'code': '682.0',
        'long': 'Cellulitis and abscess of face',
        'short': 'Cellulitis of face'},
       {'code': '682.1',
        'long': 'Cellulitis and abscess of neck',
        'short': 'Cellulitis of neck'},
       {'code': '682.2',
        'long': 'Cellulitis and abscess of trunk',
        'short': 'Cellulitis of trunk'},
       {'code': '682.3',
        'long': 'Cellulitis and abscess of upper arm and forearm',
        'short': 'Cellulitis of arm'},
       {'code': '682.4',
        'long': 'Cellulitis and abscess of hand, except fingers and thumb',
        'short': 'Cellulitis of hand'},
       {'code': '682.5',
        'long': 'Cellulitis and abscess of buttock',
        'short': 'Cellulitis of buttock'},
       {'code': '682.6',
        'long': 'Cellulitis and abscess of leg, except foot',
        'short': 'Cellulitis of leg'},
       {'code': '682.7',
        'long': 'Cellulitis and abscess of foot, except toes',
        'short': 'Cellulitis of foot'},
       {'code': '682.8',
        'long': 'Cellulitis and abscess of other specified sites',
        'short': 'Cellulitis, site NEC'},
       {'code': '682.9',
        'long': 'Cellulitis and abscess of unspecified sites',
        'short': 'Cellulitis NOS'},
       {'code': '683',
        'long': 'Acute lymphadenitis',
        'short': 'Acute lymphadenitis'},
       {'code': '684', 'long': 'Impetigo', 'short': 'Impetigo'},
       {'code': '685.0',
        'long': 'Pilonidal cyst with abscess',
        'short': 'Pilonidal cyst w abscess'},
       {'code': '685.1',
        'long': 'Pilonidal cyst without mention of abscess',
        'short': 'Pilonidal cyst w/o absc'},
       {'code': '686.00',
        'long': 'Pyoderma, unspecified',
        'short': 'Pyoderma NOS'},
       {'code': '686.01',
        'long': 'Pyoderma gangrenosum',
        'short': 'Pyoderma gangrenosum'},
       {'code': '686.09', 'long': 'Other pyoderma', 'short': 'Pyoderma NEC'},
       {'code': '686.1',
        'long': 'Pyogenic granuloma of skin and subcutaneous tissue',
        'short': 'Pyogenic granuloma'},
       {'code': '686.8',
        'long': 'Other specified local infections of skin and subcutaneous tissue',
        'short': 'Local skin infection NEC'},
       {'code': '686.9',
        'long': 'Unspecified local infection of skin and subcutaneous tissue',
        'short': 'Local skin infection NOS'},
       {'code': '690.10',
        'long': 'Seborrheic dermatitis, unspecified',
        'short': 'Sebrrheic dermatitis NOS'},
       {'code': '690.11',
        'long': 'Seborrhea capitis',
        'short': 'Seborrhea capitis'},
       {'code': '690.12',
        'long': 'Seborrheic infantile dermatitis',
        'short': 'Sbrheic infantl drmtitis'},
       {'code': '690.18',
        'long': 'Other seborrheic dermatitis',
        'short': 'Sebrrheic dermatitis NEC'},
       {'code': '690.8',
        'long': 'Other erythematosquamous dermatosis',
        'short': 'Erythmtsquamous derm NEC'},
       {'code': '691.0',
        'long': 'Diaper or napkin rash',
        'short': 'Diaper or napkin rash'},
       {'code': '691.8',
        'long': 'Other atopic dermatitis and related conditions',
        'short': 'Other atopic dermatitis'},
       {'code': '692.0',
        'long': 'Contact dermatitis and other eczema due to detergents',
        'short': 'Detergent dermatitis'},
       {'code': '692.1',
        'long': 'Contact dermatitis and other eczema due to oils and greases',
        'short': 'Oil & grease dermatitis'},
       {'code': '692.2',
        'long': 'Contact dermatitis and other eczema due to solvents',
        'short': 'Solvent dermatitis'},
       {'code': '692.3',
        'long': 'Contact dermatitis and other eczema due to drugs and medicines in contact with skin',
        'short': 'Topical med dermatitis'},
       {'code': '692.4',
        'long': 'Contact dermatitis and other eczema due to other chemical products',
        'short': 'Chemical dermatitis NEC'},
       {'code': '692.5',
        'long': 'Contact dermatitis and other eczema due to food in contact with skin',
        'short': 'Topical food dermatitis'},
       {'code': '692.6',
        'long': 'Contact dermatitis and other eczema due to plants [except food]',
        'short': 'Dermatitis due to plant'},
       {'code': '692.70',
        'long': 'Unspecified dermatitis due to sun',
        'short': 'Solar dermatitis NOS'},
       {'code': '692.71', 'long': 'Sunburn', 'short': 'Sunburn'},
       {'code': '692.72',
        'long': 'Acute dermatitis due to solar radiation',
        'short': 'Act drmtitis solar rdiat'},
       {'code': '692.73',
        'long': 'Actinic reticuloid and actinic granuloma',
        'short': 'Actnc retic actnc grnlma'},
       {'code': '692.74',
        'long': 'Other chronic dermatitis due to solar radiation',
        'short': 'Oth chr drmtit solar rad'},
       {'code': '692.75',
        'long': 'Disseminated superficial actinic porokeratosis (DSAP)',
        'short': 'Dis sup actnc porokrtsis'},
       {'code': '692.76',
        'long': 'Sunburn of second degree',
        'short': '2nd degree sunburn'},
       {'code': '692.77',
        'long': 'Sunburn of third degree',
        'short': '3rd degree sunburn'},
       {'code': '692.79',
        'long': 'Other dermatitis due to solar radiation',
        'short': 'Oth dermatitis solar rad'},
       {'code': '692.81',
        'long': 'Dermatitis due to cosmetics',
        'short': 'Cosmetic dermatitis'},
       {'code': '692.82',
        'long': 'Dermatitis due to other radiation',
        'short': 'Dermatitis oth radiation'},
       {'code': '692.83',
        'long': 'Dermatitis due to metals',
        'short': 'Dermatitis metals'},
       {'code': '692.84',
        'long': 'Contact dermatitis and other eczema due to animal (cat) (dog) dander',
        'short': 'Contact drmatitis-animal'},
       {'code': '692.89',
        'long': 'Contact dermatitis and other eczema due to other specified agents',
        'short': 'Dermatitis NEC'},
       {'code': '692.9',
        'long': 'Contact dermatitis and other eczema, unspecified cause',
        'short': 'Dermatitis NOS'},
       {'code': '693.0',
        'long': 'Dermatitis due to drugs and medicines taken internally',
        'short': 'Drug dermatitis NOS'},
       {'code': '693.1',
        'long': 'Dermatitis due to food taken internally',
        'short': 'Dermat d/t food ingest'},
       {'code': '693.8',
        'long': 'Dermatitis due to other specified substances taken internally',
        'short': 'Dermat d/t int agent NEC'},
       {'code': '693.9',
        'long': 'Dermatitis due to unspecified substance taken internally',
        'short': 'Dermat d/t int agent NOS'},
       {'code': '694.0',
        'long': 'Dermatitis herpetiformis',
        'short': 'Dermatitis herpetiformis'},
       {'code': '694.1',
        'long': 'Subcorneal pustular dermatosis',
        'short': 'Subcorneal pust dermatos'},
       {'code': '694.2',
        'long': 'Juvenile dermatitis herpetiformis',
        'short': 'Juven dermat herpetiform'},
       {'code': '694.3',
        'long': 'Impetigo herpetiformis',
        'short': 'Impetigo herpetiformis'},
       {'code': '694.4', 'long': 'Pemphigus', 'short': 'Pemphigus'},
       {'code': '694.5', 'long': 'Pemphigoid', 'short': 'Pemphigoid'},
       {'code': '694.60',
        'long': 'Benign mucous membrane pemphigoid without mention of ocular involvement',
        'short': 'Bn mucous memb pemph NOS'},
       {'code': '694.61',
        'long': 'Benign mucous membrane pemphigoid with ocular involvement',
        'short': 'Ocular pemphigus'},
       {'code': '694.8',
        'long': 'Other specified bullous dermatoses',
        'short': 'Bullous dermatoses NEC'},
       {'code': '694.9',
        'long': 'Unspecified bullous dermatoses',
        'short': 'Bullous dermatoses NOS'},
       {'code': '695.0', 'long': 'Toxic erythema', 'short': 'Toxic erythema'},
       {'code': '695.10',
        'long': 'Erythema multiforme, unspecified',
        'short': 'Erythema multiforme NOS'},
       {'code': '695.11',
        'long': 'Erythema multiforme minor',
        'short': 'Erythma multiforme minor'},
       {'code': '695.12',
        'long': 'Erythema multiforme major',
        'short': 'Erythema multiforme maj'},
       {'code': '695.13',
        'long': 'Stevens-Johnson syndrome',
        'short': 'Stevens-Johnson syndrome'},
       {'code': '695.14',
        'long': 'Stevens-Johnson syndrome-toxic epidermal necrolysis overlap syndrome',
        'short': 'Stevens-Johnson-TEN syn'},
       {'code': '695.15',
        'long': 'Toxic epidermal necrolysis',
        'short': 'Toxic epidrml necrolysis'},
       {'code': '695.19',
        'long': 'Other erythema multiforme',
        'short': 'Erythema multiforme NEC'},
       {'code': '695.2',
        'long': 'Erythema nodosum',
        'short': 'Erythema nodosum'},
       {'code': '695.3', 'long': 'Rosacea', 'short': 'Rosacea'},
       {'code': '695.4',
        'long': 'Lupus erythematosus',
        'short': 'Lupus erythematosus'},
       {'code': '695.50',
        'long': 'Exfoliation due to erythematous condition involving less than 10 percent of body surface',
        'short': 'Exfol d/t eryth <10% bdy'},
       {'code': '695.51',
        'long': 'Exfoliation due to erythematous condition involving 10-19 percent of body surface',
        'short': 'Exfl d/t eryth 10-19 bdy'},
       {'code': '695.52',
        'long': 'Exfoliation due to erythematous condition involving 20-29 percent of body surface',
        'short': 'Exfl d/t eryth 20-29 bdy'},
       {'code': '695.53',
        'long': 'Exfoliation due to erythematous condition involving 30-39 percent of body surface',
        'short': 'Exfl d/t eryth 30-39 bdy'},
       {'code': '695.54',
        'long': 'Exfoliation due to erythematous condition involving 40-49 percent of body surface',
        'short': 'Exfl d/t eryth 40-49 bdy'},
       {'code': '695.55',
        'long': 'Exfoliation due to erythematous condition involving 50-59 percent of body surface',
        'short': 'Exfl d/t eryth 50-59 bdy'},
       {'code': '695.56',
        'long': 'Exfoliation due to erythematous condition involving 60-69 percent of body surface',
        'short': 'Exfl d/t eryth 60-69 bdy'},
       {'code': '695.57',
        'long': 'Exfoliation due to erythematous condition involving 70-79 percent of body surface',
        'short': 'Exfl d/t eryth 70-79 bdy'},
       {'code': '695.58',
        'long': 'Exfoliation due to erythematous condition involving 80-89 percent of body surface',
        'short': 'Exfl d/t eryth 80-89 bdy'},
       {'code': '695.59',
        'long': 'Exfoliation due to erythematous condition involving 90 percent or more of body surface',
        'short': 'Exfl d/t eryth >=90% bdy'},
       {'code': '695.81',
        'long': "Ritter's disease",
        'short': "Ritter's disease"},
       {'code': '695.89',
        'long': 'Other specified erythematous conditions',
        'short': 'Erythematous cond NEC'},
       {'code': '695.9',
        'long': 'Unspecified erythematous condition',
        'short': 'Erythematous cond NOS'},
       {'code': '696.0',
        'long': 'Psoriatic arthropathy',
        'short': 'Psoriatic arthropathy'},
       {'code': '696.1',
        'long': 'Other psoriasis',
        'short': 'Other psoriasis'},
       {'code': '696.2', 'long': 'Parapsoriasis', 'short': 'Parapsoriasis'},
       {'code': '696.3',
        'long': 'Pityriasis rosea',
        'short': 'Pityriasis rosea'},
       {'code': '696.4',
        'long': 'Pityriasis rubra pilaris',
        'short': 'Pityriasis rubra pilaris'},
       {'code': '696.5',
        'long': 'Other and unspecified pityriasis',
        'short': 'Pityriasis NEC & NOS'},
       {'code': '696.8',
        'long': 'Other psoriasis and similar disorders',
        'short': 'Psorias related dis NEC'},
       {'code': '697.0', 'long': 'Lichen planus', 'short': 'Lichen planus'},
       {'code': '697.1', 'long': 'Lichen nitidus', 'short': 'Lichen nitidus'},
       {'code': '697.8',
        'long': 'Other lichen, not elsewhere classified',
        'short': 'Lichen NEC'},
       {'code': '697.9',
        'long': 'Lichen, unspecified',
        'short': 'Lichen NOS'},
       {'code': '698.0', 'long': 'Pruritus ani', 'short': 'Pruritus ani'},
       {'code': '698.1',
        'long': 'Pruritus of genital organs',
        'short': 'Pruritus of genitalia'},
       {'code': '698.2', 'long': 'Prurigo', 'short': 'Prurigo'},
       {'code': '698.3',
        'long': 'Lichenification and lichen simplex chronicus',
        'short': 'Lichenification'},
       {'code': '698.4',
        'long': 'Dermatitis factitia [artefacta]',
        'short': 'Dermatitis factitia'},
       {'code': '698.8',
        'long': 'Other specified pruritic conditions',
        'short': 'Pruritic conditions NEC'},
       {'code': '698.9',
        'long': 'Unspecified pruritic disorder',
        'short': 'Pruritic disorder NOS'},
       {'code': '700',
        'long': 'Corns and callosities',
        'short': 'Corns and callosities'},
       {'code': '701.0',
        'long': 'Circumscribed scleroderma',
        'short': 'Circumscribe scleroderma'},
       {'code': '701.1',
        'long': 'Keratoderma, acquired',
        'short': 'Keratoderma, acquired'},
       {'code': '701.2',
        'long': 'Acquired acanthosis nigricans',
        'short': 'Acq acanthosis nigricans'},
       {'code': '701.3',
        'long': 'Striae atrophicae',
        'short': 'Striae atrophicae'},
       {'code': '701.4', 'long': 'Keloid scar', 'short': 'Keloid scar'},
       {'code': '701.5',
        'long': 'Other abnormal granulation tissue',
        'short': 'Abnormal granulation NEC'},
       {'code': '701.8',
        'long': 'Other specified hypertrophic and atrophic conditions of skin',
        'short': 'Skin hypertro/atroph NEC'},
       {'code': '701.9',
        'long': 'Unspecified hypertrophic and atrophic conditions of skin',
        'short': 'Skin hypertro/atroph NOS'},
       {'code': '702.0',
        'long': 'Actinic keratosis',
        'short': 'Actinic keratosis'},
       {'code': '702.11',
        'long': 'Inflamed seborrheic keratosis',
        'short': 'Inflamed sbrheic keratos'},
       {'code': '702.19',
        'long': 'Other seborrheic keratosis',
        'short': 'Other sborheic keratosis'},
       {'code': '702.8',
        'long': 'Other specified dermatoses',
        'short': 'Other specf dermatoses'},
       {'code': '703.0', 'long': 'Ingrowing nail', 'short': 'Ingrowing nail'},
       {'code': '703.8',
        'long': 'Other specified diseases of nail',
        'short': 'Diseases of nail NEC'},
       {'code': '703.9',
        'long': 'Unspecified disease of nail',
        'short': 'Disease of nail NOS'},
       {'code': '704.00',
        'long': 'Alopecia, unspecified',
        'short': 'Alopecia NOS'},
       {'code': '704.01',
        'long': 'Alopecia areata',
        'short': 'Alopecia areata'},
       {'code': '704.02',
        'long': 'Telogen effluvium',
        'short': 'Telogen effluvium'},
       {'code': '704.09', 'long': 'Other alopecia', 'short': 'Alopecia NEC'},
       {'code': '704.1', 'long': 'Hirsutism', 'short': 'Hirsutism'},
       {'code': '704.2',
        'long': 'Abnormalities of the hair',
        'short': 'Abnormalities of hair'},
       {'code': '704.3',
        'long': 'Variations in hair color',
        'short': 'Variations in hair color'},
       {'code': '704.41', 'long': 'Pilar cyst', 'short': 'Pilar cyst'},
       {'code': '704.42',
        'long': 'Trichilemmal cyst',
        'short': 'Trichilemmal cyst'},
       {'code': '704.8',
        'long': 'Other specified diseases of hair and hair follicles',
        'short': 'Hair diseases NEC'},
       {'code': '704.9',
        'long': 'Unspecified disease of hair and hair follicles',
        'short': 'Hair disease NOS'},
       {'code': '705.0', 'long': 'Anhidrosis', 'short': 'Anhidrosis'},
       {'code': '705.1', 'long': 'Prickly heat', 'short': 'Prickly heat'},
       {'code': '705.21',
        'long': 'Primary focal hyperhidrosis',
        'short': 'Primary focal hyprhidros'},
       {'code': '705.22',
        'long': 'Secondary focal hyperhidrosis',
        'short': 'Sec focal hyperhidrosis'},
       {'code': '705.81', 'long': 'Dyshidrosis', 'short': 'Dyshidrosis'},
       {'code': '705.82',
        'long': 'Fox-Fordyce disease',
        'short': 'Fox-fordyce disease'},
       {'code': '705.83', 'long': 'Hidradenitis', 'short': 'Hidradenitis'},
       {'code': '705.89',
        'long': 'Other specified disorders of sweat glands',
        'short': 'Sweat gland disorder NEC'},
       {'code': '705.9',
        'long': 'Unspecified disorder of sweat glands',
        'short': 'Sweat gland disorder NOS'},
       {'code': '706.0',
        'long': 'Acne varioliformis',
        'short': 'Acne varioliformis'},
       {'code': '706.1', 'long': 'Other acne', 'short': 'Acne NEC'},
       {'code': '706.2', 'long': 'Sebaceous cyst', 'short': 'Sebaceous cyst'},
       {'code': '706.3', 'long': 'Seborrhea', 'short': 'Seborrhea'},
       {'code': '706.8',
        'long': 'Other specified diseases of sebaceous glands',
        'short': 'Sebaceous gland dis NEC'},
       {'code': '706.9',
        'long': 'Unspecified disease of sebaceous glands',
        'short': 'Sebaceous gland dis NOS'},
       {'code': '707.00',
        'long': 'Pressure ulcer, unspecified site',
        'short': 'Pressure ulcer, site NOS'},
       {'code': '707.01',
        'long': 'Pressure ulcer, elbow',
        'short': 'Pressure ulcer, elbow'},
       {'code': '707.02',
        'long': 'Pressure ulcer, upper back',
        'short': 'Pressure ulcer, upr back'},
       {'code': '707.03',
        'long': 'Pressure ulcer, lower back',
        'short': 'Pressure ulcer, low back'},
       {'code': '707.04',
        'long': 'Pressure ulcer, hip',
        'short': 'Pressure ulcer, hip'},
       {'code': '707.05',
        'long': 'Pressure ulcer, buttock',
        'short': 'Pressure ulcer, buttock'},
       {'code': '707.06',
        'long': 'Pressure ulcer, ankle',
        'short': 'Pressure ulcer, ankle'},
       {'code': '707.07',
        'long': 'Pressure ulcer, heel',
        'short': 'Pressure ulcer, heel'},
       {'code': '707.09',
        'long': 'Pressure ulcer, other site',
        'short': 'Pressure ulcer, site NEC'},
       {'code': '707.10',
        'long': 'Ulcer of lower limb, unspecified',
        'short': 'Ulcer of lower limb NOS'},
       {'code': '707.11',
        'long': 'Ulcer of thigh',
        'short': 'Ulcer of thigh'},
       {'code': '707.12', 'long': 'Ulcer of calf', 'short': 'Ulcer of calf'},
       {'code': '707.13',
        'long': 'Ulcer of ankle',
        'short': 'Ulcer of ankle'},
       {'code': '707.14',
        'long': 'Ulcer of heel and midfoot',
        'short': 'Ulcer of heel & midfoot'},
       {'code': '707.15',
        'long': 'Ulcer of other part of foot',
        'short': 'Ulcer other part of foot'},
       {'code': '707.19',
        'long': 'Ulcer of other part of lower limb',
        'short': 'Ulcer oth part low limb'},
       {'code': '707.20',
        'long': 'Pressure ulcer, unspecified stage',
        'short': 'Pressure ulcer,stage NOS'},
       {'code': '707.21',
        'long': 'Pressure ulcer, stage I',
        'short': 'Pressure ulcer, stage I'},
       {'code': '707.22',
        'long': 'Pressure ulcer, stage II',
        'short': 'Pressure ulcer, stage II'},
       {'code': '707.23',
        'long': 'Pressure ulcer, stage III',
        'short': 'Pressure ulcer,stage III'},
       {'code': '707.24',
        'long': 'Pressure ulcer, stage IV',
        'short': 'Pressure ulcer, stage IV'},
       {'code': '707.25',
        'long': 'Pressure ulcer, unstageable',
        'short': 'Pressure ulcer,unstagebl'},
       {'code': '707.8',
        'long': 'Chronic ulcer of other specified sites',
        'short': 'Chronic skin ulcer NEC'},
       {'code': '707.9',
        'long': 'Chronic ulcer of unspecified site',
        'short': 'Chronic skin ulcer NOS'},
       {'code': '708.0',
        'long': 'Allergic urticaria',
        'short': 'Allergic urticaria'},
       {'code': '708.1',
        'long': 'Idiopathic urticaria',
        'short': 'Idiopathic urticaria'},
       {'code': '708.2',
        'long': 'Urticaria due to cold and heat',
        'short': 'Urticaria from cold/heat'},
       {'code': '708.3',
        'long': 'Dermatographic urticaria',
        'short': 'Dermatographic urticaria'},
       {'code': '708.4',
        'long': 'Vibratory urticaria',
        'short': 'Vibratory urticaria'},
       {'code': '708.5',
        'long': 'Cholinergic urticaria',
        'short': 'Cholinergic urticaria'},
       {'code': '708.8',
        'long': 'Other specified urticaria',
        'short': 'Urticaria NEC'},
       {'code': '708.9',
        'long': 'Urticaria, unspecified',
        'short': 'Urticaria NOS'},
       {'code': '709.00',
        'long': 'Dyschromia, unspecified',
        'short': 'Dyschromia, unspecified'},
       {'code': '709.01', 'long': 'Vitiligo', 'short': 'Vitiligo'},
       {'code': '709.09',
        'long': 'Other dyschromia',
        'short': 'Other dyschromia'},
       {'code': '709.1',
        'long': 'Vascular disorders of skin',
        'short': 'Vascular disord of skin'},
       {'code': '709.2',
        'long': 'Scar conditions and fibrosis of skin',
        'short': 'Scar & fibrosis of skin'},
       {'code': '709.3',
        'long': 'Degenerative skin disorders',
        'short': 'Degenerative skin disord'},
       {'code': '709.4',
        'long': 'Foreign body granuloma of skin and subcutaneous tissue',
        'short': 'Foreign body granul-skin'},
       {'code': '709.8',
        'long': 'Other specified disorders of skin',
        'short': 'Skin disorders NEC'},
       {'code': '709.9',
        'long': 'Unspecified disorder of skin and subcutaneous tissue',
        'short': 'Skin disorder NOS'}],
 'M': [{'code': '710.0',
        'long': 'Systemic lupus erythematosus',
        'short': 'Syst lupus erythematosus'},
       {'code': '710.1',
        'long': 'Systemic sclerosis',
        'short': 'Systemic sclerosis'},
       {'code': '710.2', 'long': 'Sicca syndrome', 'short': 'Sicca syndrome'},
       {'code': '710.3',
        'long': 'Dermatomyositis',
        'short': 'Dermatomyositis'},
       {'code': '710.4', 'long': 'Polymyositis', 'short': 'Polymyositis'},
       {'code': '710.5',
        'long': 'Eosinophilia myalgia syndrome',
        'short': 'Eosinophilia myalgia snd'},
       {'code': '710.8',
        'long': 'Other specified diffuse diseases of connective tissue',
        'short': 'Diff connect tis dis NEC'},
       {'code': '710.9',
        'long': 'Unspecified diffuse connective tissue disease',
        'short': 'Diff connect tis dis NOS'},
       {'code': '711.00',
        'long': 'Pyogenic arthritis, site unspecified',
        'short': 'Pyogen arthritis-unspec'},
       {'code': '711.01',
        'long': 'Pyogenic arthritis, shoulder region',
        'short': 'Pyogen arthritis-shlder'},
       {'code': '711.02',
        'long': 'Pyogenic arthritis, upper arm',
        'short': 'Pyogen arthritis-up/arm'},
       {'code': '711.03',
        'long': 'Pyogenic arthritis, forearm',
        'short': 'Pyogen arthritis-forearm'},
       {'code': '711.04',
        'long': 'Pyogenic arthritis, hand',
        'short': 'Pyogen arthritis-hand'},
       {'code': '711.05',
        'long': 'Pyogenic arthritis, pelvic region and thigh',
        'short': 'Pyogen arthritis-pelvis'},
       {'code': '711.06',
        'long': 'Pyogenic arthritis, lower leg',
        'short': 'Pyogen arthritis-l/leg'},
       {'code': '711.07',
        'long': 'Pyogenic arthritis, ankle and foot',
        'short': 'Pyogen arthritis-ankle'},
       {'code': '711.08',
        'long': 'Pyogenic arthritis, other specified sites',
        'short': 'Pyogen arthritis NEC'},
       {'code': '711.09',
        'long': 'Pyogenic arthritis, multiple sites',
        'short': 'Pyogen arthritis-mult'},
       {'code': '711.10',
        'long': "Arthropathy associated with Reiter's disease and nonspecific urethritis, site unspecified",
        'short': 'Reiter arthritis-unspec'},
       {'code': '711.11',
        'long': "Arthropathy associated with Reiter's disease and nonspecific urethritis, shoulder region",
        'short': 'Reiter arthritis-shlder'},
       {'code': '711.12',
        'long': "Arthropathy associated with Reiter's disease and nonspecific urethritis, upper arm",
        'short': 'Reiter arthritis-up/arm'},
       {'code': '711.13',
        'long': "Arthropathy associated with Reiter's disease and nonspecific urethritis, forearm",
        'short': 'Reiter arthritis-forearm'},
       {'code': '711.14',
        'long': "Arthropathy associated with Reiter's disease and nonspecific urethritis, hand",
        'short': 'Reiter arthritis-hand'},
       {'code': '711.15',
        'long': "Arthropathy associated with Reiter's disease and nonspecific urethritis, pelvic region and thigh",
        'short': 'Reiter arthritis-pelvis'},
       {'code': '711.16',
        'long': "Arthropathy associated with Reiter's disease and nonspecific urethritis, lower leg",
        'short': 'Reiter arthritis-l/leg'},
       {'code': '711.17',
        'long': "Arthropathy associated with Reiter's disease and nonspecific urethritis, ankle and foot",
        'short': 'Reiter arthritis-ankle'},
       {'code': '711.18',
        'long': "Arthropathy associated with Reiter's disease and nonspecific urethritis, other specified sites",
        'short': 'Reiter arthritis NEC'},
       {'code': '711.19',
        'long': "Arthropathy associated with Reiter's disease and nonspecific urethritis, multiple sites",
        'short': 'Reiter arthritis-mult'},
       {'code': '711.20',
        'long': "Arthropathy in Behcet's syndrome, site unspecified",
        'short': 'Behcet arthritis-unspec'},
       {'code': '711.21',
        'long': "Arthropathy in Behcet's syndrome, shoulder region",
        'short': 'Behcet arthritis-shlder'},
       {'code': '711.22',
        'long': "Arthropathy in Behcet's syndrome, upper arm",
        'short': 'Behcet arthritis-up/arm'},
       {'code': '711.23',
        'long': "Arthropathy in Behcet's syndrome, forearm",
        'short': 'Behcet arthritis-forearm'},
       {'code': '711.24',
        'long': "Arthropathy in Behcet's syndrome, hand",
        'short': 'Behcet arthritis-hand'},
       {'code': '711.25',
        'long': "Arthropathy in Behcet's syndrome, pelvic region and thigh",
        'short': 'Behcet arthritis-pelvis'},
       {'code': '711.26',
        'long': "Arthropathy in Behcet's syndrome, lower leg",
        'short': 'Behcet arthritis-l/leg'},
       {'code': '711.27',
        'long': "Arthropathy in Behcet's syndrome, ankle and foot",
        'short': 'Behcet arthritis-ankle'},
       {'code': '711.28',
        'long': "Arthropathy in Behcet's syndrome, other specified sites",
        'short': 'Behcet arthritis NEC'},
       {'code': '711.29',
        'long': "Arthropathy in Behcet's syndrome, multiple sites",
        'short': 'Behcet arthritis-mult'},
       {'code': '711.30',
        'long': 'Postdysenteric arthropathy, site unspecified',
        'short': 'Dysenter arthrit-unspec'},
       {'code': '711.31',
        'long': 'Postdysenteric arthropathy, shoulder region',
        'short': 'Dysenter arthrit-shlder'},
       {'code': '711.32',
        'long': 'Postdysenteric arthropathy, upper arm',
        'short': 'Dysenter arthrit-up/arm'},
       {'code': '711.33',
        'long': 'Postdysenteric arthropathy, forearm',
        'short': 'Dysenter arthrit-forearm'},
       {'code': '711.34',
        'long': 'Postdysenteric arthropathy, hand',
        'short': 'Dysenter arthrit-hand'},
       {'code': '711.35',
        'long': 'Postdysenteric arthropathy, pelvic region and thigh',
        'short': 'Dysenter arthrit-pelvis'},
       {'code': '711.36',
        'long': 'Postdysenteric arthropathy, lower leg',
        'short': 'Dysenter arthrit-l/leg'},
       {'code': '711.37',
        'long': 'Postdysenteric arthropathy, ankle and foot',
        'short': 'Dysenter arthrit-ankle'},
       {'code': '711.38',
        'long': 'Postdysenteric arthropathy, other specified sites',
        'short': 'Dysenter arthrit NEC'},
       {'code': '711.39',
        'long': 'Postdysenteric arthropathy, multiple sites',
        'short': 'Dysenter arthrit-mult'},
       {'code': '711.40',
        'long': 'Arthropathy associated with other bacterial diseases, site unspecified',
        'short': 'Bact arthritis-unspec'},
       {'code': '711.41',
        'long': 'Arthropathy associated with other bacterial diseases, shoulder region',
        'short': 'Bact arthritis-shlder'},
       {'code': '711.42',
        'long': 'Arthropathy associated with other bacterial diseases, upper arm',
        'short': 'Bact arthritis-up/arm'},
       {'code': '711.43',
        'long': 'Arthropathy associated with other bacterial diseases, forearm',
        'short': 'Bact arthritis-forearm'},
       {'code': '711.44',
        'long': 'Arthropathy associated with other bacterial diseases, hand',
        'short': 'Bact arthritis-hand'},
       {'code': '711.45',
        'long': 'Arthropathy associated with other bacterial diseases, pelvic region and thigh',
        'short': 'Bact arthritis-pelvis'},
       {'code': '711.46',
        'long': 'Arthropathy associated with other bacterial diseases, lower leg',
        'short': 'Bact arthritis-l/leg'},
       {'code': '711.47',
        'long': 'Arthropathy associated with other bacterial diseases, ankle and foot',
        'short': 'Bact arthritis-ankle'},
       {'code': '711.48',
        'long': 'Arthropathy associated with other bacterial diseases, other specified sites',
        'short': 'Bact arthritis NEC'},
       {'code': '711.49',
        'long': 'Arthropathy associated with other bacterial diseases, multiple sites',
        'short': 'Bact arthritis-mult'},
       {'code': '711.50',
        'long': 'Arthropathy associated with other viral diseases, site unspecified',
        'short': 'Viral arthritis-unspec'},
       {'code': '711.51',
        'long': 'Arthropathy associated with other viral diseases, shoulder region',
        'short': 'Viral arthritis-shlder'},
       {'code': '711.52',
        'long': 'Arthropathy associated with other viral diseases, upper arm',
        'short': 'Viral arthritis-up/arm'},
       {'code': '711.53',
        'long': 'Arthropathy associated with other viral diseases, forearm',
        'short': 'Viral arthritis-forearm'},
       {'code': '711.54',
        'long': 'Arthropathy associated with other viral diseases, hand',
        'short': 'Viral arthritis-hand'},
       {'code': '711.55',
        'long': 'Arthropathy associated with other viral diseases, pelvic region and thigh',
        'short': 'Viral arthritis-pelvis'},
       {'code': '711.56',
        'long': 'Arthropathy associated with other viral diseases, lower leg',
        'short': 'Viral arthritis-l/leg'},
       {'code': '711.57',
        'long': 'Arthropathy associated with other viral diseases, ankle and foot',
        'short': 'Viral arthritis-ankle'},
       {'code': '711.58',
        'long': 'Arthropathy associated with other viral diseases, other specified sites',
        'short': 'Viral arthritis NEC'},
       {'code': '711.59',
        'long': 'Arthropathy associated with other viral diseases, multiple sites',
        'short': 'Viral arthritis-mult'},
       {'code': '711.60',
        'long': 'Arthropathy associated with mycoses, site unspecified',
        'short': 'Mycotic arthritis-unspec'},
       {'code': '711.61',
        'long': 'Arthropathy associated with mycoses, shoulder region',
        'short': 'Mycotic arthritis-shlder'},
       {'code': '711.62',
        'long': 'Arthropathy associated with mycoses, upper arm',
        'short': 'Mycotic arthritis-up/arm'},
       {'code': '711.63',
        'long': 'Arthropathy associated with mycoses, forearm',
        'short': 'Mycotic arthrit-forearm'},
       {'code': '711.64',
        'long': 'Arthropathy associated with mycoses, hand',
        'short': 'Mycotic arthritis-hand'},
       {'code': '711.65',
        'long': 'Arthropathy associated with mycoses, pelvic region and thigh',
        'short': 'Mycotic arthritis-pelvis'},
       {'code': '711.66',
        'long': 'Arthropathy associated with mycoses, lower leg',
        'short': 'Mycotic arthritis-l/leg'},
       {'code': '711.67',
        'long': 'Arthropathy associated with mycoses, ankle and foot',
        'short': 'Mycotic arthritis-ankle'},
       {'code': '711.68',
        'long': 'Arthropathy associated with mycoses, other specified sites',
        'short': 'Mycotic arthritis NEC'},
       {'code': '711.69',
        'long': 'Arthropathy associated with mycoses, involving multiple sites',
        'short': 'Mycotic arthritis-mult'},
       {'code': '711.70',
        'long': 'Arthropathy associated with helminthiasis, site unspecified',
        'short': 'Helminth arthrit-unspec'},
       {'code': '711.71',
        'long': 'Arthropathy associated with helminthiasis, shoulder region',
        'short': 'Helminth arthrit-shlder'},
       {'code': '711.72',
        'long': 'Arthropathy associated with helminthiasis, upper arm',
        'short': 'Helminth arthrit-up/arm'},
       {'code': '711.73',
        'long': 'Arthropathy associated with helminthiasis, forearm',
        'short': 'Helminth arthrit-forearm'},
       {'code': '711.74',
        'long': 'Arthropathy associated with helminthiasis, hand',
        'short': 'Helminth arthrit-hand'},
       {'code': '711.75',
        'long': 'Arthropathy associated with helminthiasis, pelvic region and thigh',
        'short': 'Helminth arthrit-pelvis'},
       {'code': '711.76',
        'long': 'Arthropathy associated with helminthiasis, lower leg',
        'short': 'Helminth arthrit-l/leg'},
       {'code': '711.77',
        'long': 'Arthropathy associated with helminthiasis, ankle and foot',
        'short': 'Helminth arthrit-ankle'},
       {'code': '711.78',
        'long': 'Arthropathy associated with helminthiasis, other specified sites',
        'short': 'Helminth arthrit NEC'},
       {'code': '711.79',
        'long': 'Arthropathy associated with helminthiasis, multiple sites',
        'short': 'Helminth arthrit-mult'},
       {'code': '711.80',
        'long': 'Arthropathy associated with other infectious and parasitic diseases, site unspecified',
        'short': 'Inf arthritis NEC-unspec'},
       {'code': '711.81',
        'long': 'Arthropathy associated with other infectious and parasitic diseases, shoulder region',
        'short': 'Inf arthritis NEC-shlder'},
       {'code': '711.82',
        'long': 'Arthropathy associated with other infectious and parasitic diseases, upper arm',
        'short': 'Inf arthritis NEC-up/arm'},
       {'code': '711.83',
        'long': 'Arthropathy associated with other infectious and parasitic diseases, forearm',
        'short': 'Inf arthrit NEC-forearm'},
       {'code': '711.84',
        'long': 'Arthropathy associated with other infectious and parasitic diseases, hand',
        'short': 'Inf arthritis NEC-hand'},
       {'code': '711.85',
        'long': 'Arthropathy associated with other infectious and parasitic diseases, pelvic region and thigh',
        'short': 'Inf arthritis NEC-pelvis'},
       {'code': '711.86',
        'long': 'Arthropathy associated with other infectious and parasitic diseases, lower leg',
        'short': 'Inf arthritis NEC-l/leg'},
       {'code': '711.87',
        'long': 'Arthropathy associated with other infectious and parasitic diseases, ankle and foot',
        'short': 'Inf arthritis NEC-ankle'},
       {'code': '711.88',
        'long': 'Arthropathy associated with other infectious and parasitic diseases, other specified sites',
        'short': 'Inf arthrit NEC-oth site'},
       {'code': '711.89',
        'long': 'Arthropathy associated with other infectious and parasitic diseases, multiple sites',
        'short': 'Inf arthritis NEC-mult'},
       {'code': '711.90',
        'long': 'Unspecified infective arthritis, site unspecified',
        'short': 'Inf arthritis NOS-unspec'},
       {'code': '711.91',
        'long': 'Unspecified infective arthritis, shoulder region',
        'short': 'Inf arthritis NOS-shlder'},
       {'code': '711.92',
        'long': 'Unspecified infective arthritis, upper arm',
        'short': 'Inf arthritis NOS-up/arm'},
       {'code': '711.93',
        'long': 'Unspecified infective arthritis, forearm',
        'short': 'Inf arthrit NOS-forearm'},
       {'code': '711.94',
        'long': 'Unspecified infective arthritis, hand',
        'short': 'Inf arthrit NOS-hand'},
       {'code': '711.95',
        'long': 'Unspecified infective arthritis, pelvic region and thigh',
        'short': 'Inf arthrit NOS-pelvis'},
       {'code': '711.96',
        'long': 'Unspecified infective arthritis, lower leg',
        'short': 'Inf arthrit NOS-l/leg'},
       {'code': '711.97',
        'long': 'Unspecified infective arthritis, ankle and foot',
        'short': 'Inf arthrit NOS-ankle'},
       {'code': '711.98',
        'long': 'Unspecified infective arthritis, other specified sites',
        'short': 'Inf arthrit NOS-oth site'},
       {'code': '711.99',
        'long': 'Unspecified infective arthritis, multiple sites',
        'short': 'Inf arthritis NOS-mult'},
       {'code': '712.10',
        'long': 'Chondrocalcinosis, due to dicalcium phosphate crystals, site unspecified',
        'short': 'Dicalc phos cryst-unspec'},
       {'code': '712.11',
        'long': 'Chondrocalcinosis, due to dicalcium phosphate crystals, shoulder region',
        'short': 'Dicalc phos cryst-shlder'},
       {'code': '712.12',
        'long': 'Chondrocalcinosis, due to dicalcium phosphate crystals, upper arm',
        'short': 'Dicalc phos cryst-up/arm'},
       {'code': '712.13',
        'long': 'Chondrocalcinosis, due to dicalcium phosphate crystals, forearm',
        'short': 'Dicalc phos crys-forearm'},
       {'code': '712.14',
        'long': 'Chondrocalcinosis, due to dicalcium phosphate crystals, hand',
        'short': 'Dicalc phos cryst-hand'},
       {'code': '712.15',
        'long': 'Chondrocalcinosis, due to dicalcium phosphate crystals, pelvic region and thigh',
        'short': 'Dicalc phos cryst-pelvis'},
       {'code': '712.16',
        'long': 'Chondrocalcinosis, due to dicalcium phosphate crystals, lower leg',
        'short': 'Dicalc phos cryst-l/leg'},
       {'code': '712.17',
        'long': 'Chondrocalcinosis, due to dicalcium phosphate crystals, ankle and foot',
        'short': 'Dicalc phos cryst-ankle'},
       {'code': '712.18',
        'long': 'Chondrocalcinosis, due to dicalcium phosphate crystals, other specified sites',
        'short': 'Dicalc phos cry-site NEC'},
       {'code': '712.19',
        'long': 'Chondrocalcinosis, due to dicalcium phosphate crystals, multiple sites',
        'short': 'Dicalc phos cryst-mult'},
       {'code': '712.20',
        'long': 'Chondrocalcinosis, due to pyrophosphate crystals, site unspecified',
        'short': 'Pyrophosph cryst-unspec'},
       {'code': '712.21',
        'long': 'Chondrocalcinosis, due to pyrophosphate crystals, shoulder region',
        'short': 'Pyrophosph cryst-shlder'},
       {'code': '712.22',
        'long': 'Chondrocalcinosis, due to pyrophosphate crystals, upper arm',
        'short': 'Pyrophosph cryst-up/arm'},
       {'code': '712.23',
        'long': 'Chondrocalcinosis, due to pyrophosphate crystals, forearm',
        'short': 'Pyrophosph cryst-forearm'},
       {'code': '712.24',
        'long': 'Chondrocalcinosis, due to pyrophosphate crystals, hand',
        'short': 'Pyrophosph cryst-hand'},
       {'code': '712.25',
        'long': 'Chondrocalcinosis, due to pyrophosphate crystals, pelvic region and thigh',
        'short': 'Pyrophosph cryst-pelvis'},
       {'code': '712.26',
        'long': 'Chondrocalcinosis, due to pyrophosphate crystals, lower leg',
        'short': 'Pyrophosph cryst-l/leg'},
       {'code': '712.27',
        'long': 'Chondrocalcinosis, due to pyrophosphate crystals, ankle and foot',
        'short': 'Pyrophosph cryst-ankle'},
       {'code': '712.28',
        'long': 'Chondrocalcinosis, due to pyrophosphate crystals, other specified sites',
        'short': 'Pyrophos cryst-site NEC'},
       {'code': '712.29',
        'long': 'Chondrocalcinosis, due to pyrophosphate crystals, multiple sites',
        'short': 'Pyrophos cryst-mult'},
       {'code': '712.30',
        'long': 'Chondrocalcinosis, unspecified, site unspecified',
        'short': 'Chondrocalcin NOS-unspec'},
       {'code': '712.31',
        'long': 'Chondrocalcinosis, unspecified, shoulder region',
        'short': 'Chondrocalcin NOS-shlder'},
       {'code': '712.32',
        'long': 'Chondrocalcinosis, unspecified, upper arm',
        'short': 'Chondrocalcin NOS-up/arm'},
       {'code': '712.33',
        'long': 'Chondrocalcinosis, unspecified, forearm',
        'short': 'Chondrocalc NOS-forearm'},
       {'code': '712.34',
        'long': 'Chondrocalcinosis, unspecified, hand',
        'short': 'Chondrocalcin NOS-hand'},
       {'code': '712.35',
        'long': 'Chondrocalcinosis, unspecified, pelvic region and thigh',
        'short': 'Chondrocalcin NOS-pelvis'},
       {'code': '712.36',
        'long': 'Chondrocalcinosis, unspecified, lower leg',
        'short': 'Chondrocalcin NOS-l/leg'},
       {'code': '712.37',
        'long': 'Chondrocalcinosis, unspecified, ankle and foot',
        'short': 'Chondrocalcin NOS-ankle'},
       {'code': '712.38',
        'long': 'Chondrocalcinosis, unspecified, other specified sites',
        'short': 'Chondrocalc NOS-oth site'},
       {'code': '712.39',
        'long': 'Chondrocalcinosis, unspecified, multiple sites',
        'short': 'Chondrocalcin NOS-mult'},
       {'code': '712.80',
        'long': 'Other specified crystal arthropathies, site unspecified',
        'short': 'Cryst arthrop NEC-unspec'},
       {'code': '712.81',
        'long': 'Other specified crystal arthropathies, shoulder region',
        'short': 'Cryst arthrop NEC-shlder'},
       {'code': '712.82',
        'long': 'Other specified crystal arthropathies, upper arm',
        'short': 'Cryst arthrop NEC-up/arm'},
       {'code': '712.83',
        'long': 'Other specified crystal arthropathies, forearm',
        'short': 'Crys arthrop NEC-forearm'},
       {'code': '712.84',
        'long': 'Other specified crystal arthropathies, hand',
        'short': 'Cryst arthrop NEC-hand'},
       {'code': '712.85',
        'long': 'Other specified crystal arthropathies, pelvic region and thigh',
        'short': 'Cryst arthrop NEC-pelvis'},
       {'code': '712.86',
        'long': 'Other specified crystal arthropathies, lower leg',
        'short': 'Cryst arthrop NEC-l/leg'},
       {'code': '712.87',
        'long': 'Other specified crystal arthropathies, ankle and foot',
        'short': 'Cryst arthrop NEC-ankle'},
       {'code': '712.88',
        'long': 'Other specified crystal arthropathies, other specified sites',
        'short': 'Cry arthrop NEC-oth site'},
       {'code': '712.89',
        'long': 'Other specified crystal arthropathies, multiple sites',
        'short': 'Cryst arthrop NEC-mult'},
       {'code': '712.90',
        'long': 'Unspecified crystal arthropathy, site unspecified',
        'short': 'Cryst arthrop NOS-unspec'},
       {'code': '712.91',
        'long': 'Unspecified crystal arthropathy, shoulder region',
        'short': 'Cryst arthrop NOS-shldr'},
       {'code': '712.92',
        'long': 'Unspecified crystal arthropathy, upper arm',
        'short': 'Cryst arthrop NOS-up/arm'},
       {'code': '712.93',
        'long': 'Unspecified crystal arthropathy, forearm',
        'short': 'Crys arthrop NOS-forearm'},
       {'code': '712.94',
        'long': 'Unspecified crystal arthropathy, hand',
        'short': 'Cryst arthrop NOS-hand'},
       {'code': '712.95',
        'long': 'Unspecified crystal arthropathy, pelvic region and thigh',
        'short': 'Cryst arthrop NOS-pelvis'},
       {'code': '712.96',
        'long': 'Unspecified crystal arthropathy, lower leg',
        'short': 'Cryst arthrop NOS-l/leg'},
       {'code': '712.97',
        'long': 'Unspecified crystal arthropathy, ankle and foot',
        'short': 'Cryst arthrop NOS-ankle'},
       {'code': '712.98',
        'long': 'Unspecified crystal arthropathy, other specified sites',
        'short': 'Cry arthrop NOS-oth site'},
       {'code': '712.99',
        'long': 'Unspecified crystal arthropathy, multiple sites',
        'short': 'Cryst arthrop NOS-mult'},
       {'code': '713.0',
        'long': 'Arthropathy associated with other endocrine and metabolic disorders',
        'short': 'Arthrop w endocr/met dis'},
       {'code': '713.1',
        'long': 'Arthropathy associated with gastrointestinal conditions other than infections',
        'short': 'Arthrop w noninf GI dis'},
       {'code': '713.2',
        'long': 'Arthropathy associated with hematological disorders',
        'short': 'Arthropath w hematol dis'},
       {'code': '713.3',
        'long': 'Arthropathy associated with dermatological disorders',
        'short': 'Arthropathy w skin dis'},
       {'code': '713.4',
        'long': 'Arthropathy associated with respiratory disorders',
        'short': 'Arthropathy w resp dis'},
       {'code': '713.5',
        'long': 'Arthropathy associated with neurological disorders',
        'short': 'Arthropathy w nerve dis'},
       {'code': '713.6',
        'long': 'Arthropathy associated with hypersensitivity reaction',
        'short': 'Arthrop w hypersen react'},
       {'code': '713.7',
        'long': 'Other general diseases with articular involvement',
        'short': 'Arthrop w system dis NEC'},
       {'code': '713.8',
        'long': 'Arthropathy associated with other conditions classifiable elsewhere',
        'short': 'Arthrop w oth dis NEC'},
       {'code': '714.0',
        'long': 'Rheumatoid arthritis',
        'short': 'Rheumatoid arthritis'},
       {'code': '714.1',
        'long': "Felty's syndrome",
        'short': "Felty's syndrome"},
       {'code': '714.2',
        'long': 'Other rheumatoid arthritis with visceral or systemic involvement',
        'short': 'Syst rheum arthritis NEC'},
       {'code': '714.30',
        'long': 'Polyarticular juvenile rheumatoid arthritis, chronic or unspecified',
        'short': 'Juv rheum arthritis NOS'},
       {'code': '714.31',
        'long': 'Polyarticular juvenile rheumatoid arthritis, acute',
        'short': 'Polyart juv rheum arthr'},
       {'code': '714.32',
        'long': 'Pauciarticular juvenile rheumatoid arthritis',
        'short': 'Pauciart juv rheum arthr'},
       {'code': '714.33',
        'long': 'Monoarticular juvenile rheumatoid arthritis',
        'short': 'Monoart juv rheum arthr'},
       {'code': '714.4',
        'long': 'Chronic postrheumatic arthropathy',
        'short': 'Chr postrheum arthritis'},
       {'code': '714.81',
        'long': 'Rheumatoid lung',
        'short': 'Rheumatoid lung'},
       {'code': '714.89',
        'long': 'Other specified inflammatory polyarthropathies',
        'short': 'Inflamm polyarthrop NEC'},
       {'code': '714.9',
        'long': 'Unspecified inflammatory polyarthropathy',
        'short': 'Inflamm polyarthrop NOS'},
       {'code': '715.00',
        'long': 'Osteoarthrosis, generalized, site unspecified',
        'short': 'General osteoarthrosis'},
       {'code': '715.04',
        'long': 'Osteoarthrosis, generalized, hand',
        'short': 'Gen osteoarthros-hand'},
       {'code': '715.09',
        'long': 'Osteoarthrosis, generalized, multiple sites',
        'short': 'General osteoarthrosis'},
       {'code': '715.10',
        'long': 'Osteoarthrosis, localized, primary, site unspecified',
        'short': 'Loc prim osteoart-unspec'},
       {'code': '715.11',
        'long': 'Osteoarthrosis, localized, primary, shoulder region',
        'short': 'Loc prim osteoart-shlder'},
       {'code': '715.12',
        'long': 'Osteoarthrosis, localized, primary, upper arm',
        'short': 'Loc prim osteoart-up/arm'},
       {'code': '715.13',
        'long': 'Osteoarthrosis, localized, primary, forearm',
        'short': 'Loc prim osteoart-forarm'},
       {'code': '715.14',
        'long': 'Osteoarthrosis, localized, primary, hand',
        'short': 'Loc prim osteoarth-hand'},
       {'code': '715.15',
        'long': 'Osteoarthrosis, localized, primary, pelvic region and thigh',
        'short': 'Loc prim osteoart-pelvis'},
       {'code': '715.16',
        'long': 'Osteoarthrosis, localized, primary, lower leg',
        'short': 'Loc prim osteoart-l/leg'},
       {'code': '715.17',
        'long': 'Osteoarthrosis, localized, primary, ankle and foot',
        'short': 'Loc prim osteoarth-ankle'},
       {'code': '715.18',
        'long': 'Osteoarthrosis, localized, primary, other specified sites',
        'short': 'Loc prim osteoarthr NEC'},
       {'code': '715.20',
        'long': 'Osteoarthrosis, localized, secondary, site unspecified',
        'short': 'Loc 2nd osteoarth-unspec'},
       {'code': '715.21',
        'long': 'Osteoarthrosis, localized, secondary, shoulder region',
        'short': 'Loc 2nd osteoarth-shlder'},
       {'code': '715.22',
        'long': 'Osteoarthrosis, localized, secondary, upper arm',
        'short': 'Loc 2nd osteoarth-up/arm'},
       {'code': '715.23',
        'long': 'Osteoarthrosis, localized, secondary, forearm',
        'short': 'Loc 2nd osteoart-forearm'},
       {'code': '715.24',
        'long': 'Osteoarthrosis, localized, secondary, hand',
        'short': 'Loc 2nd osteoarthro-hand'},
       {'code': '715.25',
        'long': 'Osteoarthrosis, localized, secondary, pelvic region and thigh',
        'short': 'Loc 2nd osteoarth-pelvis'},
       {'code': '715.26',
        'long': 'Osteoarthrosis, localized, secondary, lower leg',
        'short': 'Loc 2nd osteoarthr-l/leg'},
       {'code': '715.27',
        'long': 'Osteoarthrosis, localized, secondary, ankle and foot',
        'short': 'Loc 2nd osteoarthr-ankle'},
       {'code': '715.28',
        'long': 'Osteoarthrosis, localized, secondary, other specified sites',
        'short': 'Loc 2nd osteoarthros NEC'},
       {'code': '715.30',
        'long': 'Osteoarthrosis, localized, not specified whether primary or secondary, site unspecified',
        'short': 'Loc osteoarth NOS-unspec'},
       {'code': '715.31',
        'long': 'Osteoarthrosis, localized, not specified whether primary or secondary, shoulder region',
        'short': 'Loc osteoarth NOS-shlder'},
       {'code': '715.32',
        'long': 'Osteoarthrosis, localized, not specified whether primary or secondary, upper arm',
        'short': 'Loc osteoarth NOS-up/arm'},
       {'code': '715.33',
        'long': 'Osteoarthrosis, localized, not specified whether primary or secondary, forearm',
        'short': 'Loc osteoart NOS-forearm'},
       {'code': '715.34',
        'long': 'Osteoarthrosis, localized, not specified whether primary or secondary, hand',
        'short': 'Loc osteoarth NOS-hand'},
       {'code': '715.35',
        'long': 'Osteoarthrosis, localized, not specified whether primary or secondary, pelvic region and thigh',
        'short': 'Loc osteoarth NOS-pelvis'},
       {'code': '715.36',
        'long': 'Osteoarthrosis, localized, not specified whether primary or secondary, lower leg',
        'short': 'Loc osteoarth NOS-l/leg'},
       {'code': '715.37',
        'long': 'Osteoarthrosis, localized, not specified whether primary or secondary, ankle and foot',
        'short': 'Loc osteoarth NOS-ankle'},
       {'code': '715.38',
        'long': 'Osteoarthrosis, localized, not specified whether primary or secondary, other specified sites',
        'short': 'Loc osteoar NOS-site NEC'},
       {'code': '715.80',
        'long': 'Osteoarthrosis involving, or with mention of more than one site, but not specified as generalized, site unspecified',
        'short': 'Osteoarthrosis-mult site'},
       {'code': '715.89',
        'long': 'Osteoarthrosis involving, or with mention of more than one site, but not specified as generalized, multiple sites',
        'short': 'Osteoarthrosis-mult site'},
       {'code': '715.90',
        'long': 'Osteoarthrosis, unspecified whether generalized or localized, site unspecified',
        'short': 'Osteoarthros NOS-unspec'},
       {'code': '715.91',
        'long': 'Osteoarthrosis, unspecified whether generalized or localized, shoulder region',
        'short': 'Osteoarthros NOS-shlder'},
       {'code': '715.92',
        'long': 'Osteoarthrosis, unspecified whether generalized or localized, upper arm',
        'short': 'Osteoarthros NOS-up/arm'},
       {'code': '715.93',
        'long': 'Osteoarthrosis, unspecified whether generalized or localized, forearm',
        'short': 'Osteoarthros NOS-forearm'},
       {'code': '715.94',
        'long': 'Osteoarthrosis, unspecified whether generalized or localized, hand',
        'short': 'Osteoarthros NOS-hand'},
       {'code': '715.95',
        'long': 'Osteoarthrosis, unspecified whether generalized or localized, pelvic region and thigh',
        'short': 'Osteoarthros NOS-pelvis'},
       {'code': '715.96',
        'long': 'Osteoarthrosis, unspecified whether generalized or localized, lower leg',
        'short': 'Osteoarthros NOS-l/leg'},
       {'code': '715.97',
        'long': 'Osteoarthrosis, unspecified whether generalized or localized, ankle and foot',
        'short': 'Osteoarthros NOS-ankle'},
       {'code': '715.98',
        'long': 'Osteoarthrosis, unspecified whether generalized or localized, other specified sites',
        'short': 'Osteoarthro NOS-oth site'},
       {'code': '716.00',
        'long': 'Kaschin-Beck disease, site unspecified',
        'short': 'Kaschin-beck dis-unspec'},
       {'code': '716.01',
        'long': 'Kaschin-Beck disease, shoulder region',
        'short': 'Kaschin-beck dis-shlder'},
       {'code': '716.02',
        'long': 'Kaschin-Beck disease, upper arm',
        'short': 'Kaschin-beck dis-up/arm'},
       {'code': '716.03',
        'long': 'Kaschin-Beck disease, forearm',
        'short': 'Kaschin-beck dis-forearm'},
       {'code': '716.04',
        'long': 'Kaschin-Beck disease, hand',
        'short': 'Kaschin-beck dis-hand'},
       {'code': '716.05',
        'long': 'Kaschin-Beck disease, pelvic region and thigh',
        'short': 'Kaschin-beck dis-pelvis'},
       {'code': '716.06',
        'long': 'Kaschin-Beck disease, lower leg',
        'short': 'Kaschin-beck dis-l/leg'},
       {'code': '716.07',
        'long': 'Kaschin-Beck disease, ankle and foot',
        'short': 'Kaschin-beck dis-ankle'},
       {'code': '716.08',
        'long': 'Kaschin-Beck disease, other specified sites',
        'short': 'Kaschin-beck dis NEC'},
       {'code': '716.09',
        'long': 'Kaschin-Beck disease, multiple sites',
        'short': 'Kaschin-beck dis-mult'},
       {'code': '716.10',
        'long': 'Traumatic arthropathy, site unspecified',
        'short': 'Traum arthropathy-unspec'},
       {'code': '716.11',
        'long': 'Traumatic arthropathy, shoulder region',
        'short': 'Traum arthropathy-shlder'},
       {'code': '716.12',
        'long': 'Traumatic arthropathy, upper arm',
        'short': 'Traum arthropathy-up/arm'},
       {'code': '716.13',
        'long': 'Traumatic arthropathy, forearm',
        'short': 'Traum arthropath-forearm'},
       {'code': '716.14',
        'long': 'Traumatic arthropathy, hand',
        'short': 'Traum arthropathy-hand'},
       {'code': '716.15',
        'long': 'Traumatic arthropathy, pelvic region and thigh',
        'short': 'Traum arthropathy-pelvis'},
       {'code': '716.16',
        'long': 'Traumatic arthropathy, lower leg',
        'short': 'Traum arthropathy-l/leg'},
       {'code': '716.17',
        'long': 'Traumatic arthropathy, ankle and foot',
        'short': 'Traum arthropathy-ankle'},
       {'code': '716.18',
        'long': 'Traumatic arthropathy, other specified sites',
        'short': 'Traum arthropathy NEC'},
       {'code': '716.19',
        'long': 'Traumatic arthropathy, multiple sites',
        'short': 'Traum arthropathy-mult'},
       {'code': '716.20',
        'long': 'Allergic arthritis, site unspecified',
        'short': 'Allerg arthritis-unspec'},
       {'code': '716.21',
        'long': 'Allergic arthritis, shoulder region',
        'short': 'Allerg arthritis-shlder'},
       {'code': '716.22',
        'long': 'Allergic arthritis, upper arm',
        'short': 'Allerg arthritis-up/arm'},
       {'code': '716.23',
        'long': 'Allergic arthritis, forearm',
        'short': 'Allerg arthritis-forearm'},
       {'code': '716.24',
        'long': 'Allergic arthritis, hand',
        'short': 'Allerg arthritis-hand'},
       {'code': '716.25',
        'long': 'Allergic arthritis, pelvic region and thigh',
        'short': 'Allerg arthritis-pelvis'},
       {'code': '716.26',
        'long': 'Allergic arthritis, lower leg',
        'short': 'Allerg arthritis-l/leg'},
       {'code': '716.27',
        'long': 'Allergic arthritis, ankle and foot',
        'short': 'Allerg arthritis-ankle'},
       {'code': '716.28',
        'long': 'Allergic arthritis, other specified sites',
        'short': 'Allerg arthritis NEC'},
       {'code': '716.29',
        'long': 'Allergic arthritis, multiple sites',
        'short': 'Allerg arthritis-mult'},
       {'code': '716.30',
        'long': 'Climacteric arthritis, site unspecified',
        'short': 'Climact arthritis-unspec'},
       {'code': '716.31',
        'long': 'Climacteric arthritis, shoulder region',
        'short': 'Climact arthritis-shlder'},
       {'code': '716.32',
        'long': 'Climacteric arthritis, upper arm',
        'short': 'Climact arthritis-up/arm'},
       {'code': '716.33',
        'long': 'Climacteric arthritis, forearm',
        'short': 'Climact arthrit-forearm'},
       {'code': '716.34',
        'long': 'Climacteric arthritis, hand',
        'short': 'Climact arthritis-hand'},
       {'code': '716.35',
        'long': 'Climacteric arthritis, pelvic region and thigh',
        'short': 'Climact arthritis-pelvis'},
       {'code': '716.36',
        'long': 'Climacteric arthritis, lower leg',
        'short': 'Climact arthritis-l/leg'},
       {'code': '716.37',
        'long': 'Climacteric arthritis, ankle and foot',
        'short': 'Climact arthritis-ankle'},
       {'code': '716.38',
        'long': 'Climacteric arthritis, other specified sites',
        'short': 'Climact arthritis NEC'},
       {'code': '716.39',
        'long': 'Climacteric arthritis, multiple sites',
        'short': 'Climact arthritis-mult'},
       {'code': '716.40',
        'long': 'Transient arthropathy, site unspecified',
        'short': 'Trans arthropathy-unspec'},
       {'code': '716.41',
        'long': 'Transient arthropathy, shoulder region',
        'short': 'Trans arthropathy-shlder'},
       {'code': '716.42',
        'long': 'Transient arthropathy, upper arm',
        'short': 'Trans arthropathy-up/arm'},
       {'code': '716.43',
        'long': 'Transient arthropathy, forearm',
        'short': 'Trans arthropath-forearm'},
       {'code': '716.44',
        'long': 'Transient arthropathy, hand',
        'short': 'Trans arthropathy-hand'},
       {'code': '716.45',
        'long': 'Transient arthropathy, pelvic region and thigh',
        'short': 'Trans arthropathy-pelvis'},
       {'code': '716.46',
        'long': 'Transient arthropathy, lower leg',
        'short': 'Trans arthropathy-l/leg'},
       {'code': '716.47',
        'long': 'Transient arthropathy, ankle and foot',
        'short': 'Trans arthropathy-ankle'},
       {'code': '716.48',
        'long': 'Transient arthropathy, other specified sites',
        'short': 'Trans arthropathy NEC'},
       {'code': '716.49',
        'long': 'Transient arthropathy, multiple sites',
        'short': 'Trans arthropathy-mult'},
       {'code': '716.50',
        'long': 'Unspecified polyarthropathy or polyarthritis, site unspecified',
        'short': 'Polyarthritis NOS-unspec'},
       {'code': '716.51',
        'long': 'Unspecified polyarthropathy or polyarthritis, shoulder region',
        'short': 'Polyarthritis NOS-shlder'},
       {'code': '716.52',
        'long': 'Unspecified polyarthropathy or polyarthritis, upper arm',
        'short': 'Polyarthritis NOS-up/arm'},
       {'code': '716.53',
        'long': 'Unspecified polyarthropathy or polyarthritis, forearm',
        'short': 'Polyarthrit NOS-forearm'},
       {'code': '716.54',
        'long': 'Unspecified polyarthropathy or polyarthritis, hand',
        'short': 'Polyarthritis NOS-hand'},
       {'code': '716.55',
        'long': 'Unspecified polyarthropathy or polyarthritis, pelvic region and thigh',
        'short': 'Polyarthritis NOS-pelvis'},
       {'code': '716.56',
        'long': 'Unspecified polyarthropathy or polyarthritis, lower leg',
        'short': 'Polyarthritis NOS-l/leg'},
       {'code': '716.57',
        'long': 'Unspecified polyarthropathy or polyarthritis, ankle and foot',
        'short': 'Polyarthritis NOS-ankle'},
       {'code': '716.58',
        'long': 'Unspecified polyarthropathy or polyarthritis, other specified sites',
        'short': 'Polyarthrit NOS-oth site'},
       {'code': '716.59',
        'long': 'Unspecified polyarthropathy or polyarthritis, multiple sites',
        'short': 'Polyarthritis NOS-mult'},
       {'code': '716.60',
        'long': 'Unspecified monoarthritis, site unspecified',
        'short': 'Monoarthritis NOS-unspec'},
       {'code': '716.61',
        'long': 'Unspecified monoarthritis, shoulder region',
        'short': 'Monoarthritis NOS-shlder'},
       {'code': '716.62',
        'long': 'Unspecified monoarthritis, upper arm',
        'short': 'Monoarthritis NOS-up/arm'},
       {'code': '716.63',
        'long': 'Unspecified monoarthritis, forearm',
        'short': 'Monoarthrit NOS-forearm'},
       {'code': '716.64',
        'long': 'Unspecified monoarthritis, hand',
        'short': 'Monoarthritis NOS-hand'},
       {'code': '716.65',
        'long': 'Unspecified monoarthritis, pelvic region and thigh',
        'short': 'Monoarthritis NOS-pelvis'},
       {'code': '716.66',
        'long': 'Unspecified monoarthritis, lower leg',
        'short': 'Monoarthritis NOS-l/leg'},
       {'code': '716.67',
        'long': 'Unspecified monoarthritis, ankle and foot',
        'short': 'Monoarthritis NOS-ankle'},
       {'code': '716.68',
        'long': 'Unspecified monoarthritis, other specified sites',
        'short': 'Monoarthrit NOS-oth site'},
       {'code': '716.80',
        'long': 'Other specified arthropathy, site unspecified',
        'short': 'Arthropathy NEC-unspec'},
       {'code': '716.81',
        'long': 'Other specified arthropathy, shoulder region',
        'short': 'Arthropathy NEC-shlder'},
       {'code': '716.82',
        'long': 'Other specified arthropathy, upper arm',
        'short': 'Arthropathy NEC-up/arm'},
       {'code': '716.83',
        'long': 'Other specified arthropathy, forearm',
        'short': 'Arthropathy NEC-forearm'},
       {'code': '716.84',
        'long': 'Other specified arthropathy, hand',
        'short': 'Arthropathy NEC-hand'},
       {'code': '716.85',
        'long': 'Other specified arthropathy, pelvic region and thigh',
        'short': 'Arthropathy NEC-pelvis'},
       {'code': '716.86',
        'long': 'Other specified arthropathy, lower leg',
        'short': 'Arthropathy NEC-l/leg'},
       {'code': '716.87',
        'long': 'Other specified arthropathy, ankle and foot',
        'short': 'Arthropathy NEC-ankle'},
       {'code': '716.88',
        'long': 'Other specified arthropathy, other specified sites',
        'short': 'Arthropathy NEC-oth site'},
       {'code': '716.89',
        'long': 'Other specified arthropathy, multiple sites',
        'short': 'Arthropathy NEC-mult'},
       {'code': '716.90',
        'long': 'Arthropathy, unspecified, site unspecified',
        'short': 'Arthropathy NOS-unspec'},
       {'code': '716.91',
        'long': 'Arthropathy, unspecified, shoulder region',
        'short': 'Arthropathy NOS-shlder'},
       {'code': '716.92',
        'long': 'Arthropathy, unspecified, upper arm',
        'short': 'Arthropathy NOS-up/arm'},
       {'code': '716.93',
        'long': 'Arthropathy, unspecified, forearm',
        'short': 'Arthropathy NOS-forearm'},
       {'code': '716.94',
        'long': 'Arthropathy, unspecified, hand',
        'short': 'Arthropathy NOS-hand'},
       {'code': '716.95',
        'long': 'Arthropathy, unspecified, pelvic region and thigh',
        'short': 'Arthropathy NOS-pelvis'},
       {'code': '716.96',
        'long': 'Arthropathy, unspecified, lower leg',
        'short': 'Arthropathy NOS-l/leg'},
       {'code': '716.97',
        'long': 'Arthropathy, unspecified, ankle and foot',
        'short': 'Arthropathy NOS-ankle'},
       {'code': '716.98',
        'long': 'Arthropathy, unspecified, other specified sites',
        'short': 'Arthropathy NOS-oth site'},
       {'code': '716.99',
        'long': 'Arthropathy, unspecified, multiple sites',
        'short': 'Arthropathy NOS-mult'},
       {'code': '717.0',
        'long': 'Old bucket handle tear of medial meniscus',
        'short': 'Old bucket tear med men'},
       {'code': '717.1',
        'long': 'Derangement of anterior horn of medial meniscus',
        'short': 'Derang ant med meniscus'},
       {'code': '717.2',
        'long': 'Derangement of posterior horn of medial meniscus',
        'short': 'Derang post med meniscus'},
       {'code': '717.3',
        'long': 'Other and unspecified derangement of medial meniscus',
        'short': 'Derang med meniscus NEC'},
       {'code': '717.40',
        'long': 'Derangement of lateral meniscus, unspecified',
        'short': 'Derang lat meniscus NOS'},
       {'code': '717.41',
        'long': 'Bucket handle tear of lateral meniscus',
        'short': 'Old bucket tear lat men'},
       {'code': '717.42',
        'long': 'Derangement of anterior horn of lateral meniscus',
        'short': 'Derange ant lat meniscus'},
       {'code': '717.43',
        'long': 'Derangement of posterior horn of lateral meniscus',
        'short': 'Derang post lat meniscus'},
       {'code': '717.49',
        'long': 'Other derangement of lateral meniscus',
        'short': 'Derang lat meniscus NEC'},
       {'code': '717.5',
        'long': 'Derangement of meniscus, not elsewhere classified',
        'short': 'Derangement meniscus NEC'},
       {'code': '717.6',
        'long': 'Loose body in knee',
        'short': 'Loose body in knee'},
       {'code': '717.7',
        'long': 'Chondromalacia of patella',
        'short': 'Chondromalacia patellae'},
       {'code': '717.81',
        'long': 'Old disruption of lateral collateral ligament',
        'short': 'Old disrupt lat collat'},
       {'code': '717.82',
        'long': 'Old disruption of medial collateral ligament',
        'short': 'Old disrupt med collat'},
       {'code': '717.83',
        'long': 'Old disruption of anterior cruciate ligament',
        'short': 'Old disrupt ant cruciate'},
       {'code': '717.84',
        'long': 'Old disruption of posterior cruciate ligament',
        'short': 'Old disrupt post cruciat'},
       {'code': '717.85',
        'long': 'Old disruption of other ligaments of knee',
        'short': 'Old disrupt knee lig NEC'},
       {'code': '717.89',
        'long': 'Other internal derangement of knee',
        'short': 'Int derangement knee NEC'},
       {'code': '717.9',
        'long': 'Unspecified internal derangement of knee',
        'short': 'Int derangement knee NOS'},
       {'code': '718.00',
        'long': 'Articular cartilage disorder, site unspecified',
        'short': 'Artic cartil dis-unspec'},
       {'code': '718.01',
        'long': 'Articular cartilage disorder, shoulder region',
        'short': 'Artic cartil dis-shlder'},
       {'code': '718.02',
        'long': 'Articular cartilage disorder, upper arm',
        'short': 'Artic cartil dis-up/arm'},
       {'code': '718.03',
        'long': 'Articular cartilage disorder, forearm',
        'short': 'Artic cartil dis-forearm'},
       {'code': '718.04',
        'long': 'Articular cartilage disorder, hand',
        'short': 'Artic cartil dis-hand'},
       {'code': '718.05',
        'long': 'Articular cartilage disorder, pelvic region and thigh',
        'short': 'Artic cartil dis-pelvis'},
       {'code': '718.07',
        'long': 'Articular cartilage disorder, ankle and foot',
        'short': 'Artic cartil dis-ankle'},
       {'code': '718.08',
        'long': 'Articular cartilage disorder, other specified sites',
        'short': 'Artic cartil dis-jt NEC'},
       {'code': '718.09',
        'long': 'Articular cartilage disorder, multiple sites',
        'short': 'Artic cartil dis-mult jt'},
       {'code': '718.10',
        'long': 'Loose body in joint, site unspecified',
        'short': 'Loose body-unspec'},
       {'code': '718.11',
        'long': 'Loose body in joint, shoulder region',
        'short': 'Loose body-shlder'},
       {'code': '718.12',
        'long': 'Loose body in joint, upper arm',
        'short': 'Loose body-up/arm'},
       {'code': '718.13',
        'long': 'Loose body in joint, forearm',
        'short': 'Loose body-forearm'},
       {'code': '718.14',
        'long': 'Loose body in joint, hand',
        'short': 'Loose body-hand'},
       {'code': '718.15',
        'long': 'Loose body in joint, pelvic region and thigh',
        'short': 'Loose body-pelvis'},
       {'code': '718.17',
        'long': 'Loose body in joint, ankle and foot',
        'short': 'Loose body-ankle'},
       {'code': '718.18',
        'long': 'Loose body in joint, other specified sites',
        'short': 'Loose body-joint NEC'},
       {'code': '718.19',
        'long': 'Loose body in joint, multiple sites',
        'short': 'Loose body-mult joints'},
       {'code': '718.20',
        'long': 'Pathological dislocation of joint, site unspecified',
        'short': 'Pathol dislocat-unspec'},
       {'code': '718.21',
        'long': 'Pathological dislocation of joint, shoulder region',
        'short': 'Pathol dislocat-shlder'},
       {'code': '718.22',
        'long': 'Pathological dislocation of joint, upper arm',
        'short': 'Pathol dislocat-up/arm'},
       {'code': '718.23',
        'long': 'Pathological dislocation of joint, forearm',
        'short': 'Pathol dislocat-forearm'},
       {'code': '718.24',
        'long': 'Pathological dislocation of joint, hand',
        'short': 'Pathol dislocat-hand'},
       {'code': '718.25',
        'long': 'Pathological dislocation of joint, pelvic region and thigh',
        'short': 'Pathol dislocat-pelvis'},
       {'code': '718.26',
        'long': 'Pathological dislocation of joint, lower leg',
        'short': 'Pathol dislocat-l/leg'},
       {'code': '718.27',
        'long': 'Pathological dislocation of joint, ankle and foot',
        'short': 'Pathol dislocat-ankle'},
       {'code': '718.28',
        'long': 'Pathological dislocation of joint, other specified sites',
        'short': 'Pathol dislocat-jt NEC'},
       {'code': '718.29',
        'long': 'Pathological dislocation of joint, multiple sites',
        'short': 'Pathol dislocat-mult jts'},
       {'code': '718.30',
        'long': 'Recurrent dislocation of joint, site unspecified',
        'short': 'Recur dislocat-unspec'},
       {'code': '718.31',
        'long': 'Recurrent dislocation of joint, shoulder region',
        'short': 'Recur dislocat-shlder'},
       {'code': '718.32',
        'long': 'Recurrent dislocation of joint, upper arm',
        'short': 'Recur dislocat-up/arm'},
       {'code': '718.33',
        'long': 'Recurrent dislocation of joint, forearm',
        'short': 'Recur dislocat-forearm'},
       {'code': '718.34',
        'long': 'Recurrent dislocation of joint, hand',
        'short': 'Recur dislocat-hand'},
       {'code': '718.35',
        'long': 'Recurrent dislocation of joint, pelvic region and thigh',
        'short': 'Recur dislocat-pelvis'},
       {'code': '718.36',
        'long': 'Recurrent dislocation of joint, lower leg',
        'short': 'Recur dislocat-l/leg'},
       {'code': '718.37',
        'long': 'Recurrent dislocation of joint, ankle and foot',
        'short': 'Recur dislocat-ankle'},
       {'code': '718.38',
        'long': 'Recurrent dislocation of joint, other specified sites',
        'short': 'Recur dislocat-jt NEC'},
       {'code': '718.39',
        'long': 'Recurrent dislocation of joint, multiple sites',
        'short': 'Recur dislocat-mult jts'},
       {'code': '718.40',
        'long': 'Contracture of joint, site unspecified',
        'short': 'Jt contracture-unspec'},
       {'code': '718.41',
        'long': 'Contracture of joint, shoulder region',
        'short': 'Jt contracture-shlder'},
       {'code': '718.42',
        'long': 'Contracture of joint, upper arm',
        'short': 'Jt contracture-up/arm'},
       {'code': '718.43',
        'long': 'Contracture of joint, forearm',
        'short': 'Jt contracture-forearm'},
       {'code': '718.44',
        'long': 'Contracture of joint, hand',
        'short': 'Jt contracture-hand'},
       {'code': '718.45',
        'long': 'Contracture of joint, pelvic region and thigh',
        'short': 'Jt contracture-pelvis'},
       {'code': '718.46',
        'long': 'Contracture of joint, lower leg',
        'short': 'Jt contracture-l/leg'},
       {'code': '718.47',
        'long': 'Contracture of joint, ankle and foot',
        'short': 'Jt contracture-ankle'},
       {'code': '718.48',
        'long': 'Contracture of joint, other specified sites',
        'short': 'Jt contracture-jt NEC'},
       {'code': '718.49',
        'long': 'Contracture of joint, multiple sites',
        'short': 'Jt contracture-mult jts'},
       {'code': '718.50',
        'long': 'Ankylosis of joint, site unspecified',
        'short': 'Ankylosis-unspec'},
       {'code': '718.51',
        'long': 'Ankylosis of joint, shoulder region',
        'short': 'Ankylosis-shoulder'},
       {'code': '718.52',
        'long': 'Ankylosis of joint, upper arm',
        'short': 'Ankylosis-upper/arm'},
       {'code': '718.53',
        'long': 'Ankylosis of joint, forearm',
        'short': 'Ankylosis-forearm'},
       {'code': '718.54',
        'long': 'Ankylosis of joint, hand',
        'short': 'Ankylosis-hand'},
       {'code': '718.55',
        'long': 'Ankylosis of joint, pelvic region and thigh',
        'short': 'Ankylosis-pelvis'},
       {'code': '718.56',
        'long': 'Ankylosis of joint, lower leg',
        'short': 'Ankylosis-lower/leg'},
       {'code': '718.57',
        'long': 'Ankylosis of joint, ankle and foot',
        'short': 'Ankylosis-ankle'},
       {'code': '718.58',
        'long': 'Ankylosis of joint, other specified sites',
        'short': 'Ankylosis-joint NEC'},
       {'code': '718.59',
        'long': 'Ankylosis of joint, multiple sites',
        'short': 'Ankylosis-mult joints'},
       {'code': '718.65',
        'long': 'Unspecified intrapelvic protrusion of acetabulum, pelvic region and thigh',
        'short': 'Protrusio acetabuli NOS'},
       {'code': '718.70',
        'long': 'Developmental dislocation of joint, site unspecified',
        'short': 'Dev dislocat jt site NOS'},
       {'code': '718.71',
        'long': 'Developmental dislocation of joint, shoulder region',
        'short': 'Dev dislocat joint-shldr'},
       {'code': '718.72',
        'long': 'Developmental dislocation of joint, upper arm',
        'short': 'Dev dislocat jt-up/arm'},
       {'code': '718.73',
        'long': 'Developmental dislocation of joint, forearm',
        'short': 'Dev dislocat jt-forearm'},
       {'code': '718.74',
        'long': 'Developmental dislocation of joint, hand',
        'short': 'Dev dislocat joint-hand'},
       {'code': '718.75',
        'long': 'Developmental dislocation of joint, pelvic region and thigh',
        'short': 'Dev dis jt-pelvic/thigh'},
       {'code': '718.76',
        'long': 'Developmental dislocation of joint, lower leg',
        'short': 'Dev disloc jt-lower leg'},
       {'code': '718.77',
        'long': 'Developmental dislocation of joint, ankle and foot',
        'short': 'Dev disloc jt-ankle/foot'},
       {'code': '718.78',
        'long': 'Developmental dislocation of joint, other specified sites',
        'short': 'Dev disloc jt-site NEC'},
       {'code': '718.79',
        'long': 'Developmental dislocation of joint, multiple sites',
        'short': 'Dev disloc jt-mult sites'},
       {'code': '718.80',
        'long': 'Other joint derangement, not elsewhere classified, site unspecified',
        'short': 'Jt derangmnt NEC-unsp jt'},
       {'code': '718.81',
        'long': 'Other joint derangement, not elsewhere classified, shoulder region',
        'short': 'Jt derangment NEC-shlder'},
       {'code': '718.82',
        'long': 'Other joint derangement, not elsewhere classified, upper arm',
        'short': 'Jt derangment NEC-up/arm'},
       {'code': '718.83',
        'long': 'Other joint derangement, not elsewhere classified, forearm',
        'short': 'Jt derangmnt NEC-forearm'},
       {'code': '718.84',
        'long': 'Other joint derangement, not elsewhere classified, hand',
        'short': 'Jt derangement NEC-hand'},
       {'code': '718.85',
        'long': 'Other joint derangement, not elsewhere classified, pelvic region and thigh',
        'short': 'Jt derangment NEC-pelvis'},
       {'code': '718.86',
        'long': 'Other joint derangement, not elsewhere classified, lower leg',
        'short': 'Jt derangement NEC-l/leg'},
       {'code': '718.87',
        'long': 'Other joint derangement, not elsewhere classified, ankle and foot',
        'short': 'Jt derangement NEC-ankle'},
       {'code': '718.88',
        'long': 'Other joint derangement, not elsewhere classified, other specified sites',
        'short': 'Jt derangment NEC-oth jt'},
       {'code': '718.89',
        'long': 'Other joint derangement, not elsewhere classified, multiple sites',
        'short': 'Jt derangement NEC-mult'},
       {'code': '718.90',
        'long': 'Unspecified derangement of joint, site unspecified',
        'short': 'Jt derangmnt NOS-unsp jt'},
       {'code': '718.91',
        'long': 'Unspecified derangement of joint, shoulder region',
        'short': 'Jt derangment NOS-shlder'},
       {'code': '718.92',
        'long': 'Unspecified derangement of joint, upper arm',
        'short': 'Jt derangment NOS-up/arm'},
       {'code': '718.93',
        'long': 'Unspecified derangement of joint, forearm',
        'short': 'Jt derangmnt NOS-forearm'},
       {'code': '718.94',
        'long': 'Unspecified derangement of joint, hand',
        'short': 'Jt derangement NOS-hand'},
       {'code': '718.95',
        'long': 'Unspecified derangement of joint, pelvic region and thigh',
        'short': 'Jt derangment NOS-pelvis'},
       {'code': '718.97',
        'long': 'Unspecified derangement of joint, ankle and foot',
        'short': 'Jt derangement NOS-ankle'},
       {'code': '718.98',
        'long': 'Unspecified derangement of joint, other specified sites',
        'short': 'Jt derangment NOS-oth jt'},
       {'code': '718.99',
        'long': 'Unspecified derangement of joint, multiple sites',
        'short': 'Jt derangement NOS-mult'},
       {'code': '719.00',
        'long': 'Effusion of joint, site unspecified',
        'short': 'Joint effusion-unspec'},
       {'code': '719.01',
        'long': 'Effusion of joint, shoulder region',
        'short': 'Joint effusion-shlder'},
       {'code': '719.02',
        'long': 'Effusion of joint, upper arm',
        'short': 'Joint effusion-up/arm'},
       {'code': '719.03',
        'long': 'Effusion of joint, forearm',
        'short': 'Joint effusion-forearm'},
       {'code': '719.04',
        'long': 'Effusion of joint, hand',
        'short': 'Joint effusion-hand'},
       {'code': '719.05',
        'long': 'Effusion of joint, pelvic region and thigh',
        'short': 'Joint effusion-pelvis'},
       {'code': '719.06',
        'long': 'Effusion of joint, lower leg',
        'short': 'Joint effusion-l/leg'},
       {'code': '719.07',
        'long': 'Effusion of joint, ankle and foot',
        'short': 'Joint effusion-ankle'},
       {'code': '719.08',
        'long': 'Effusion of joint, other specified sites',
        'short': 'Joint effusion-jt NEC'},
       {'code': '719.09',
        'long': 'Effusion of joint, multiple sites',
        'short': 'Joint effusion-mult jts'},
       {'code': '719.10',
        'long': 'Hemarthrosis, site unspecified',
        'short': 'Hemarthrosis-unspec'},
       {'code': '719.11',
        'long': 'Hemarthrosis, shoulder region',
        'short': 'Hemarthrosis-shlder'},
       {'code': '719.12',
        'long': 'Hemarthrosis, upper arm',
        'short': 'Hemarthrosis-up/arm'},
       {'code': '719.13',
        'long': 'Hemarthrosis, forearm',
        'short': 'Hemarthrosis-forearm'},
       {'code': '719.14',
        'long': 'Hemarthrosis, hand',
        'short': 'Hemarthrosis-hand'},
       {'code': '719.15',
        'long': 'Hemarthrosis, pelvic region and thigh',
        'short': 'Hemarthrosis-pelvis'},
       {'code': '719.16',
        'long': 'Hemarthrosis, lower leg',
        'short': 'Hemarthrosis-l/leg'},
       {'code': '719.17',
        'long': 'Hemarthrosis, ankle and foot',
        'short': 'Hemarthrosis-ankle'},
       {'code': '719.18',
        'long': 'Hemarthrosis, other specified sites',
        'short': 'Hemarthrosis-jt NEC'},
       {'code': '719.19',
        'long': 'Hemarthrosis, multiple sites',
        'short': 'Hemarthrosis-mult jts'},
       {'code': '719.20',
        'long': 'Villonodular synovitis, site unspecified',
        'short': 'Villonod synovit-unspec'},
       {'code': '719.21',
        'long': 'Villonodular synovitis, shoulder region',
        'short': 'Villonod synovit-shlder'},
       {'code': '719.22',
        'long': 'Villonodular synovitis, upper arm',
        'short': 'Villonod synovit-up/arm'},
       {'code': '719.23',
        'long': 'Villonodular synovitis, forearm',
        'short': 'Villonod synovit-forearm'},
       {'code': '719.24',
        'long': 'Villonodular synovitis, hand',
        'short': 'Villonod synovit-hand'},
       {'code': '719.25',
        'long': 'Villonodular synovitis, pelvic region and thigh',
        'short': 'Villonod synovit-pelvis'},
       {'code': '719.26',
        'long': 'Villonodular synovitis, lower leg',
        'short': 'Villonod synovit-l/leg'},
       {'code': '719.27',
        'long': 'Villonodular synovitis, ankle and foot',
        'short': 'Villonod synovit-ankle'},
       {'code': '719.28',
        'long': 'Villonodular synovitis, other specified sites',
        'short': 'Villonod synovit-jt NEC'},
       {'code': '719.29',
        'long': 'Villonodular synovitis, multiple sites',
        'short': 'Villonod synovit-mult jt'},
       {'code': '719.30',
        'long': 'Palindromic rheumatism, site unspecified',
        'short': 'Palindrom rheum-unspec'},
       {'code': '719.31',
        'long': 'Palindromic rheumatism, shoulder region',
        'short': 'Palindrom rheum-shlder'},
       {'code': '719.32',
        'long': 'Palindromic rheumatism, upper arm',
        'short': 'Palindrom rheum-up/arm'},
       {'code': '719.33',
        'long': 'Palindromic rheumatism, forearm',
        'short': 'Palindrom rheum-forearm'},
       {'code': '719.34',
        'long': 'Palindromic rheumatism, hand',
        'short': 'Palindrom rheum-hand'},
       {'code': '719.35',
        'long': 'Palindromic rheumatism, pelvic region and thigh',
        'short': 'Palindrom rheum-pelvis'},
       {'code': '719.36',
        'long': 'Palindromic rheumatism, lower leg',
        'short': 'Palindrom rheum-l/leg'},
       {'code': '719.37',
        'long': 'Palindromic rheumatism, ankle and foot',
        'short': 'Palindrom rheum-ankle'},
       {'code': '719.38',
        'long': 'Palindromic rheumatism, other specified sites',
        'short': 'Palindrom rheum-jt NEC'},
       {'code': '719.39',
        'long': 'Palindromic rheumatism, multiple sites',
        'short': 'Palindrom rheum-mult jts'},
       {'code': '719.40',
        'long': 'Pain in joint, site unspecified',
        'short': 'Joint pain-unspec'},
       {'code': '719.41',
        'long': 'Pain in joint, shoulder region',
        'short': 'Joint pain-shlder'},
       {'code': '719.42',
        'long': 'Pain in joint, upper arm',
        'short': 'Joint pain-up/arm'},
       {'code': '719.43',
        'long': 'Pain in joint, forearm',
        'short': 'Joint pain-forearm'},
       {'code': '719.44',
        'long': 'Pain in joint, hand',
        'short': 'Joint pain-hand'},
       {'code': '719.45',
        'long': 'Pain in joint, pelvic region and thigh',
        'short': 'Joint pain-pelvis'},
       {'code': '719.46',
        'long': 'Pain in joint, lower leg',
        'short': 'Joint pain-l/leg'},
       {'code': '719.47',
        'long': 'Pain in joint, ankle and foot',
        'short': 'Joint pain-ankle'},
       {'code': '719.48',
        'long': 'Pain in joint, other specified sites',
        'short': 'Joint pain-jt NEC'},
       {'code': '719.49',
        'long': 'Pain in joint, multiple sites',
        'short': 'Joint pain-mult jts'},
       {'code': '719.50',
        'long': 'Stiffness of joint, not elsewhere classified, site unspecified',
        'short': 'Jt stiffness NEC-unspec'},
       {'code': '719.51',
        'long': 'Stiffness of joint, not elsewhere classified, shoulder region',
        'short': 'Jt stiffness NEC-shlder'},
       {'code': '719.52',
        'long': 'Stiffness of joint, not elsewhere classified, upper arm',
        'short': 'Jt stiffness NEC-up/arm'},
       {'code': '719.53',
        'long': 'Stiffness of joint, not elsewhere classified, forearm',
        'short': 'Jt stiffnes NEC-forearm'},
       {'code': '719.54',
        'long': 'Stiffness of joint, not elsewhere classified, hand',
        'short': 'Jt stiffness NEC-hand'},
       {'code': '719.55',
        'long': 'Stiffness of joint, not elsewhere classified, pelvic region and thigh',
        'short': 'Jt stiffness NEC-pelvis'},
       {'code': '719.56',
        'long': 'Stiffness of joint, not elsewhere classified, lower leg',
        'short': 'Jt stiffness NEC-l/leg'},
       {'code': '719.57',
        'long': 'Stiffness of joint, not elsewhere classified, ankle and foot',
        'short': 'Jt stiffness NEC-ankle'},
       {'code': '719.58',
        'long': 'Stiffness of joint, not elsewhere classified, other specified sites',
        'short': 'Jt stiffness NEC-oth jt'},
       {'code': '719.59',
        'long': 'Stiffness of joint, not elsewhere classified, multiple sites',
        'short': 'Jt stiffness NEC-mult jt'},
       {'code': '719.60',
        'long': 'Other symptoms referable to joint, site unspecified',
        'short': 'Joint sympt NEC-unsp jt'},
       {'code': '719.61',
        'long': 'Other symptoms referable to joint, shoulder region',
        'short': 'Joint symptom NEC-shlder'},
       {'code': '719.62',
        'long': 'Other symptoms referable to joint, upper arm',
        'short': 'Joint symptom NEC-up/arm'},
       {'code': '719.63',
        'long': 'Other symptoms referable to joint, forearm',
        'short': 'Joint sympt NEC-forearm'},
       {'code': '719.64',
        'long': 'Other symptoms referable to joint, hand',
        'short': 'Joint symptom NEC-hand'},
       {'code': '719.65',
        'long': 'Other symptoms referable to joint, pelvic region and thigh',
        'short': 'Joint symptom NEC-pelvis'},
       {'code': '719.66',
        'long': 'Other symptoms referable to joint, lower leg',
        'short': 'Joint symptom NEC-l/leg'},
       {'code': '719.67',
        'long': 'Other symptoms referable to joint, ankle and foot',
        'short': 'Joint symptom NEC-ankle'},
       {'code': '719.68',
        'long': 'Other symptoms referable to joint, other specified sites',
        'short': 'Joint symptom NEC-oth jt'},
       {'code': '719.69',
        'long': 'Other symptoms referable to joint, multiple sites',
        'short': 'Joint sympt NEC-mult jts'},
       {'code': '719.7',
        'long': 'Difficulty in walking',
        'short': 'Difficulty in walking'},
       {'code': '719.80',
        'long': 'Other specified disorders of joint, site unspecified',
        'short': 'Joint dis NEC-unspec'},
       {'code': '719.81',
        'long': 'Other specified disorders of joint, shoulder region',
        'short': 'Joint dis NEC-shlder'},
       {'code': '719.82',
        'long': 'Other specified disorders of joint, upper arm',
        'short': 'Joint dis NEC-up/arm'},
       {'code': '719.83',
        'long': 'Other specified disorders of joint, forearm',
        'short': 'Joint dis NEC-forearm'},
       {'code': '719.84',
        'long': 'Other specified disorders of joint, hand',
        'short': 'Joint dis NEC-hand'},
       {'code': '719.85',
        'long': 'Other specified disorders of joint, pelvic region and thigh',
        'short': 'Joint dis NEC-pelvis'},
       {'code': '719.86',
        'long': 'Other specified disorders of joint, lower leg',
        'short': 'Joint dis NEC-l/leg'},
       {'code': '719.87',
        'long': 'Other specified disorders of joint, ankle and foot',
        'short': 'Joint dis NEC-ankle'},
       {'code': '719.88',
        'long': 'Other specified disorders of joint, other specified sites',
        'short': 'Joint dis NEC-oth jt'},
       {'code': '719.89',
        'long': 'Other specified disorders of joint, multiple sites',
        'short': 'Joint dis NEC-mult jts'},
       {'code': '719.90',
        'long': 'Unspecified disorder of joint, site unspecified',
        'short': 'Joint dis NOS-unspec jt'},
       {'code': '719.91',
        'long': 'Unspecified disorder of joint, shoulder region',
        'short': 'Joint dis NOS-shlder'},
       {'code': '719.92',
        'long': 'Unspecified disorder of joint, upper arm',
        'short': 'Joint dis NOS-up/arm'},
       {'code': '719.93',
        'long': 'Unspecified disorder of joint, forearm',
        'short': 'Joint dis NOS-forearm'},
       {'code': '719.94',
        'long': 'Unspecified disorder of joint, hand',
        'short': 'Joint dis NOS-hand'},
       {'code': '719.95',
        'long': 'Unspecified disorder of joint, pelvic region and thigh',
        'short': 'Joint dis NOS-pelvis'},
       {'code': '719.96',
        'long': 'Unspecified disorder of joint, lower leg',
        'short': 'Joint dis NOS-l/leg'},
       {'code': '719.97',
        'long': 'Unspecified disorder of joint, ankle and foot',
        'short': 'Joint dis NOS-ankle'},
       {'code': '719.98',
        'long': 'Unspecified disorder of joint, other specified sites',
        'short': 'Joint dis NOS-oth jt'},
       {'code': '719.99',
        'long': 'Unspecified disorder of joint, multiple sites',
        'short': 'Joint dis NOS-mult jts'},
       {'code': '720.0',
        'long': 'Ankylosing spondylitis',
        'short': 'Ankylosing spondylitis'},
       {'code': '720.1',
        'long': 'Spinal enthesopathy',
        'short': 'Spinal enthesopathy'},
       {'code': '720.2',
        'long': 'Sacroiliitis, not elsewhere classified',
        'short': 'Sacroiliitis NEC'},
       {'code': '720.81',
        'long': 'Inflammatory spondylopathies in diseases classified elsewhere',
        'short': 'Spondylopathy in oth dis'},
       {'code': '720.89',
        'long': 'Other inflammatory spondylopathies',
        'short': 'Inflam spondylopathy NEC'},
       {'code': '720.9',
        'long': 'Unspecified inflammatory spondylopathy',
        'short': 'Inflam spondylopathy NOS'},
       {'code': '721.0',
        'long': 'Cervical spondylosis without myelopathy',
        'short': 'Cervical spondylosis'},
       {'code': '721.1',
        'long': 'Cervical spondylosis with myelopathy',
        'short': 'Cerv spondyl w myelopath'},
       {'code': '721.2',
        'long': 'Thoracic spondylosis without myelopathy',
        'short': 'Thoracic spondylosis'},
       {'code': '721.3',
        'long': 'Lumbosacral spondylosis without myelopathy',
        'short': 'Lumbosacral spondylosis'},
       {'code': '721.41',
        'long': 'Spondylosis with myelopathy, thoracic region',
        'short': 'Spond compr thor sp cord'},
       {'code': '721.42',
        'long': 'Spondylosis with myelopathy, lumbar region',
        'short': 'Spond compr lumb sp cord'},
       {'code': '721.5', 'long': 'Kissing spine', 'short': 'Kissing spine'},
       {'code': '721.6',
        'long': 'Ankylosing vertebral hyperostosis',
        'short': 'Ankyl vert hyperostosis'},
       {'code': '721.7',
        'long': 'Traumatic spondylopathy',
        'short': 'Traumatic spondylopathy'},
       {'code': '721.8',
        'long': 'Other allied disorders of spine',
        'short': 'Spinal disorders NEC'},
       {'code': '721.90',
        'long': 'Spondylosis of unspecified site, without mention of myelopathy',
        'short': 'Spondylos NOS w/o myelop'},
       {'code': '721.91',
        'long': 'Spondylosis of unspecified site, with myelopathy',
        'short': 'Spondylosis NOS w myelop'},
       {'code': '722.0',
        'long': 'Displacement of cervical intervertebral disc without myelopathy',
        'short': 'Cervical disc displacmnt'},
       {'code': '722.10',
        'long': 'Displacement of lumbar intervertebral disc without myelopathy',
        'short': 'Lumbar disc displacement'},
       {'code': '722.11',
        'long': 'Displacement of thoracic intervertebral disc without myelopathy',
        'short': 'Thoracic disc displacmnt'},
       {'code': '722.2',
        'long': 'Displacement of intervertebral disc, site unspecified, without myelopathy',
        'short': 'Disc displacement NOS'},
       {'code': '722.30',
        'long': "Schmorl's nodes, unspecified region",
        'short': "Schmorl's nodes NOS"},
       {'code': '722.31',
        'long': "Schmorl's nodes, thoracic region",
        'short': 'Schmorls node-thoracic'},
       {'code': '722.32',
        'long': "Schmorl's nodes, lumbar region",
        'short': 'Schmorls node-lumbar'},
       {'code': '722.39',
        'long': "Schmorl's nodes, other region",
        'short': 'Schmorls node-region NEC'},
       {'code': '722.4',
        'long': 'Degeneration of cervical intervertebral disc',
        'short': 'Cervical disc degen'},
       {'code': '722.51',
        'long': 'Degeneration of thoracic or thoracolumbar intervertebral disc',
        'short': 'Thoracic disc degen'},
       {'code': '722.52',
        'long': 'Degeneration of lumbar or lumbosacral intervertebral disc',
        'short': 'Lumb/lumbosac disc degen'},
       {'code': '722.6',
        'long': 'Degeneration of intervertebral disc, site unspecified',
        'short': 'Disc degeneration NOS'},
       {'code': '722.70',
        'long': 'Intervertebral disc disorder with myelopathy, unspecified region',
        'short': 'Disc dis w myelopath NOS'},
       {'code': '722.71',
        'long': 'Intervertebral disc disorder with myelopathy, cervical region',
        'short': 'Cerv disc dis w myelopat'},
       {'code': '722.72',
        'long': 'Intervertebral disc disorder with myelopathy, thoracic region',
        'short': 'Thor disc dis w myelopat'},
       {'code': '722.73',
        'long': 'Intervertebral disc disorder with myelopathy, lumbar region',
        'short': 'Lumb disc dis w myelopat'},
       {'code': '722.80',
        'long': 'Postlaminectomy syndrome, unspecified region',
        'short': 'Postlaminectomy synd NOS'},
       {'code': '722.81',
        'long': 'Postlaminectomy syndrome, cervical region',
        'short': 'Postlaminect synd-cerv'},
       {'code': '722.82',
        'long': 'Postlaminectomy syndrome, thoracic region',
        'short': 'Postlaminect synd-thorac'},
       {'code': '722.83',
        'long': 'Postlaminectomy syndrome, lumbar region',
        'short': 'Postlaminect synd-lumbar'},
       {'code': '722.90',
        'long': 'Other and unspecified disc disorder, unspecified region',
        'short': 'Disc dis NEC/NOS-unspec'},
       {'code': '722.91',
        'long': 'Other and unspecified disc disorder, cervical region',
        'short': 'Disc dis NEC/NOS-cerv'},
       {'code': '722.92',
        'long': 'Other and unspecified disc disorder, thoracic region',
        'short': 'Disc dis NEC/NOS-thorac'},
       {'code': '722.93',
        'long': 'Other and unspecified disc disorder, lumbar region',
        'short': 'Disc dis NEC/NOS-lumbar'},
       {'code': '723.0',
        'long': 'Spinal stenosis in cervical region',
        'short': 'Cervical spinal stenosis'},
       {'code': '723.1', 'long': 'Cervicalgia', 'short': 'Cervicalgia'},
       {'code': '723.2',
        'long': 'Cervicocranial syndrome',
        'short': 'Cervicocranial syndrome'},
       {'code': '723.3',
        'long': 'Cervicobrachial syndrome (diffuse)',
        'short': 'Cervicobrachial syndrome'},
       {'code': '723.4',
        'long': 'Brachial neuritis or radiculitis NOS',
        'short': 'Brachial neuritis NOS'},
       {'code': '723.5',
        'long': 'Torticollis, unspecified',
        'short': 'Torticollis NOS'},
       {'code': '723.6',
        'long': 'Panniculitis specified as affecting neck',
        'short': 'Panniculitis of neck'},
       {'code': '723.7',
        'long': 'Ossification of posterior longitudinal ligament in cervical region',
        'short': 'Ossification cerv lig'},
       {'code': '723.8',
        'long': 'Other syndromes affecting cervical region',
        'short': 'Cervical syndrome NEC'},
       {'code': '723.9',
        'long': 'Unspecified musculoskeletal disorders and symptoms referable to neck',
        'short': 'Neck disorder/sympt NOS'},
       {'code': '724.00',
        'long': 'Spinal stenosis, unspecified region',
        'short': 'Spinal stenosis NOS'},
       {'code': '724.01',
        'long': 'Spinal stenosis, thoracic region',
        'short': 'Spinal stenosis-thoracic'},
       {'code': '724.02',
        'long': 'Spinal stenosis, lumbar region, without neurogenic claudication',
        'short': 'Spin sten,lumbr wo claud'},
       {'code': '724.03',
        'long': 'Spinal stenosis, lumbar region, with neurogenic claudication',
        'short': 'Spin sten,lumbr w claud'},
       {'code': '724.09',
        'long': 'Spinal stenosis, other region',
        'short': 'Spinal stenosis-oth site'},
       {'code': '724.1',
        'long': 'Pain in thoracic spine',
        'short': 'Pain in thoracic spine'},
       {'code': '724.2', 'long': 'Lumbago', 'short': 'Lumbago'},
       {'code': '724.3', 'long': 'Sciatica', 'short': 'Sciatica'},
       {'code': '724.4',
        'long': 'Thoracic or lumbosacral neuritis or radiculitis, unspecified',
        'short': 'Lumbosacral neuritis NOS'},
       {'code': '724.5',
        'long': 'Backache, unspecified',
        'short': 'Backache NOS'},
       {'code': '724.6',
        'long': 'Disorders of sacrum',
        'short': 'Disorders of sacrum'},
       {'code': '724.70',
        'long': 'Unspecified disorder of coccyx',
        'short': 'Disorder of coccyx NOS'},
       {'code': '724.71',
        'long': 'Hypermobility of coccyx',
        'short': 'Hypermobility of coccyx'},
       {'code': '724.79',
        'long': 'Other disorders of coccyx',
        'short': 'Disorder of coccyx NEC'},
       {'code': '724.8',
        'long': 'Other symptoms referable to back',
        'short': 'Other back symptoms'},
       {'code': '724.9',
        'long': 'Other unspecified back disorders',
        'short': 'Back disorder NOS'},
       {'code': '725',
        'long': 'Polymyalgia rheumatica',
        'short': 'Polymyalgia rheumatica'},
       {'code': '726.0',
        'long': 'Adhesive capsulitis of shoulder',
        'short': 'Adhesive capsulit shlder'},
       {'code': '726.10',
        'long': 'Disorders of bursae and tendons in shoulder region, unspecified',
        'short': 'Rotator cuff synd NOS'},
       {'code': '726.11',
        'long': 'Calcifying tendinitis of shoulder',
        'short': 'Calcif tendinitis shlder'},
       {'code': '726.12',
        'long': 'Bicipital tenosynovitis',
        'short': 'Bicipital tenosynovitis'},
       {'code': '726.13',
        'long': 'Partial tear of rotator cuff',
        'short': 'Partial tear rotatr cuff'},
       {'code': '726.19',
        'long': 'Other specified disorders of bursae and tendons in shoulder region',
        'short': 'Rotator cuff dis NEC'},
       {'code': '726.2',
        'long': 'Other affections of shoulder region, not elsewhere classified',
        'short': 'Shoulder region dis NEC'},
       {'code': '726.30',
        'long': 'Enthesopathy of elbow, unspecified',
        'short': 'Elbow enthesopathy NOS'},
       {'code': '726.31',
        'long': 'Medial epicondylitis',
        'short': 'Medial epicondylitis'},
       {'code': '726.32',
        'long': 'Lateral epicondylitis',
        'short': 'Lateral epicondylitis'},
       {'code': '726.33',
        'long': 'Olecranon bursitis',
        'short': 'Olecranon bursitis'},
       {'code': '726.39',
        'long': 'Other enthesopathy of elbow region',
        'short': 'Elbow enthesopathy NEC'},
       {'code': '726.4',
        'long': 'Enthesopathy of wrist and carpus',
        'short': 'Enthesopathy of wrist'},
       {'code': '726.5',
        'long': 'Enthesopathy of hip region',
        'short': 'Enthesopathy of hip'},
       {'code': '726.60',
        'long': 'Enthesopathy of knee, unspecified',
        'short': 'Enthesopathy of knee NOS'},
       {'code': '726.61',
        'long': 'Pes anserinus tendinitis or bursitis',
        'short': 'Pes anserinus tendinitis'},
       {'code': '726.62',
        'long': 'Tibial collateral ligament bursitis',
        'short': 'Tibial coll lig bursitis'},
       {'code': '726.63',
        'long': 'Fibular collateral ligament bursitis',
        'short': 'Fibula coll lig bursitis'},
       {'code': '726.64',
        'long': 'Patellar tendinitis',
        'short': 'Patellar tendinitis'},
       {'code': '726.65',
        'long': 'Prepatellar bursitis',
        'short': 'Prepatellar bursitis'},
       {'code': '726.69',
        'long': 'Other enthesopathy of knee',
        'short': 'Enthesopathy of knee NEC'},
       {'code': '726.70',
        'long': 'Enthesopathy of ankle and tarsus, unspecified',
        'short': 'Ankle enthesopathy NOS'},
       {'code': '726.71',
        'long': 'Achilles bursitis or tendinitis',
        'short': 'Achilles tendinitis'},
       {'code': '726.72',
        'long': 'Tibialis tendinitis',
        'short': 'Tibialis tendinitis'},
       {'code': '726.73',
        'long': 'Calcaneal spur',
        'short': 'Calcaneal spur'},
       {'code': '726.79',
        'long': 'Other enthesopathy of ankle and tarsus',
        'short': 'Ankle enthesopathy NEC'},
       {'code': '726.8',
        'long': 'Other peripheral enthesopathies',
        'short': 'Periph enthesopathy NEC'},
       {'code': '726.90',
        'long': 'Enthesopathy of unspecified site',
        'short': 'Enthesopathy, site NOS'},
       {'code': '726.91',
        'long': 'Exostosis of unspecified site',
        'short': 'Exostosis, site NOS'},
       {'code': '727.00',
        'long': 'Synovitis and tenosynovitis, unspecified',
        'short': 'Synovitis NOS'},
       {'code': '727.01',
        'long': 'Synovitis and tenosynovitis in diseases classified elsewhere',
        'short': 'Synovitis in oth dis'},
       {'code': '727.02',
        'long': 'Giant cell tumor of tendon sheath',
        'short': 'Giant cell tumor tendon'},
       {'code': '727.03',
        'long': 'Trigger finger (acquired)',
        'short': 'Trigger finger'},
       {'code': '727.04',
        'long': 'Radial styloid tenosynovitis',
        'short': 'Radial styloid tenosynov'},
       {'code': '727.05',
        'long': 'Other tenosynovitis of hand and wrist',
        'short': 'Tenosynov hand/wrist NEC'},
       {'code': '727.06',
        'long': 'Tenosynovitis of foot and ankle',
        'short': 'Tenosynovitis foot/ankle'},
       {'code': '727.09',
        'long': 'Other synovitis and tenosynovitis',
        'short': 'Synovitis NEC'},
       {'code': '727.1', 'long': 'Bunion', 'short': 'Bunion'},
       {'code': '727.2',
        'long': 'Specific bursitides often of occupational origin',
        'short': 'Occupational bursitis'},
       {'code': '727.3', 'long': 'Other bursitis', 'short': 'Bursitis NEC'},
       {'code': '727.40',
        'long': 'Synovial cyst, unspecified',
        'short': 'Synovial cyst NOS'},
       {'code': '727.41',
        'long': 'Ganglion of joint',
        'short': 'Ganglion of joint'},
       {'code': '727.42',
        'long': 'Ganglion of tendon sheath',
        'short': 'Ganglion of tendon'},
       {'code': '727.43',
        'long': 'Ganglion, unspecified',
        'short': 'Ganglion NOS'},
       {'code': '727.49',
        'long': 'Other ganglion and cyst of synovium, tendon, and bursa',
        'short': 'Bursal cyst NEC'},
       {'code': '727.50',
        'long': 'Rupture of synovium, unspecified',
        'short': 'Rupture of synovium NOS'},
       {'code': '727.51',
        'long': 'Synovial cyst of popliteal space',
        'short': 'Popliteal synovial cyst'},
       {'code': '727.59',
        'long': 'Other rupture of synovium',
        'short': 'Rupture of synovium NEC'},
       {'code': '727.60',
        'long': 'Nontraumatic rupture of unspecified tendon',
        'short': 'Nontraum tendon rupt NOS'},
       {'code': '727.61',
        'long': 'Complete rupture of rotator cuff',
        'short': 'Rotator cuff rupture'},
       {'code': '727.62',
        'long': 'Nontraumatic rupture of tendons of biceps (long head)',
        'short': 'Biceps tendon rupture'},
       {'code': '727.63',
        'long': 'Nontraumatic rupture of extensor tendons of hand and wrist',
        'short': 'Rupt exten tendon hand'},
       {'code': '727.64',
        'long': 'Nontraumatic rupture of flexor tendons of hand and wrist',
        'short': 'Rupt flexor tendon hand'},
       {'code': '727.65',
        'long': 'Nontraumatic rupture of quadriceps tendon',
        'short': 'Rupture quadricep tendon'},
       {'code': '727.66',
        'long': 'Nontraumatic rupture of patellar tendon',
        'short': 'Rupture patellar tendon'},
       {'code': '727.67',
        'long': 'Nontraumatic rupture of achilles tendon',
        'short': 'Rupture achilles tendon'},
       {'code': '727.68',
        'long': 'Nontraumatic rupture of other tendons of foot and ankle',
        'short': 'Rupture tendon foot NEC'},
       {'code': '727.69',
        'long': 'Nontraumatic rupture of other tendon',
        'short': 'Nontraum tendon rupt NEC'},
       {'code': '727.81',
        'long': 'Contracture of tendon (sheath)',
        'short': 'Contracture of tendon'},
       {'code': '727.82',
        'long': 'Calcium deposits in tendon and bursa',
        'short': 'Calcium deposit tendon'},
       {'code': '727.83',
        'long': 'Plica syndrome',
        'short': 'Plica syndrome'},
       {'code': '727.89',
        'long': 'Other disorders of synovium, tendon, and bursa',
        'short': 'Synov/tend/bursa dis NEC'},
       {'code': '727.9',
        'long': 'Unspecified disorder of synovium, tendon, and bursa',
        'short': 'Synov/tend/bursa dis NOS'},
       {'code': '728.0',
        'long': 'Infective myositis',
        'short': 'Infective myositis'},
       {'code': '728.10',
        'long': 'Calcification and ossification, unspecified',
        'short': 'Muscular calcificat NOS'},
       {'code': '728.11',
        'long': 'Progressive myositis ossificans',
        'short': 'Prog myositis ossificans'},
       {'code': '728.12',
        'long': 'Traumatic myositis ossificans',
        'short': 'Traum myositis ossifican'},
       {'code': '728.13',
        'long': 'Postoperative heterotopic calcification',
        'short': 'Postop heterotopic calc'},
       {'code': '728.19',
        'long': 'Other muscular calcification and ossification',
        'short': 'Muscular calcificat NEC'},
       {'code': '728.2',
        'long': 'Muscular wasting and disuse atrophy, not elsewhere classified',
        'short': 'Musc disuse atrophy NEC'},
       {'code': '728.3',
        'long': 'Other specific muscle disorders',
        'short': 'Muscle disorders NEC'},
       {'code': '728.4',
        'long': 'Laxity of ligament',
        'short': 'Laxity of ligament'},
       {'code': '728.5',
        'long': 'Hypermobility syndrome',
        'short': 'Hypermobility syndrome'},
       {'code': '728.6',
        'long': 'Contracture of palmar fascia',
        'short': 'Contracted palmar fascia'},
       {'code': '728.71',
        'long': 'Plantar fascial fibromatosis',
        'short': 'Plantar fibromatosis'},
       {'code': '728.79',
        'long': 'Other fibromatoses of muscle, ligament, and fascia',
        'short': 'Fibromatoses NEC'},
       {'code': '728.81',
        'long': 'Interstitial myositis',
        'short': 'Interstitial myositis'},
       {'code': '728.82',
        'long': 'Foreign body granuloma of muscle',
        'short': 'FB granuloma of muscle'},
       {'code': '728.83',
        'long': 'Rupture of muscle, nontraumatic',
        'short': 'Nontraum muscle rupture'},
       {'code': '728.84',
        'long': 'Diastasis of muscle',
        'short': 'Diastasis of muscle'},
       {'code': '728.85',
        'long': 'Spasm of muscle',
        'short': 'Spasm of muscle'},
       {'code': '728.86',
        'long': 'Necrotizing fasciitis',
        'short': 'Necrotizing fasciitis'},
       {'code': '728.87',
        'long': 'Muscle weakness (generalized)',
        'short': 'Muscle weakness-general'},
       {'code': '728.88',
        'long': 'Rhabdomyolysis',
        'short': 'Rhabdomyolysis'},
       {'code': '728.89',
        'long': 'Other disorders of muscle, ligament, and fascia',
        'short': 'Muscle/ligament dis NEC'},
       {'code': '728.9',
        'long': 'Unspecified disorder of muscle, ligament, and fascia',
        'short': 'Muscle/ligament dis NOS'},
       {'code': '729.0',
        'long': 'Rheumatism, unspecified and fibrositis',
        'short': 'Rheumatism NOS'},
       {'code': '729.1',
        'long': 'Myalgia and myositis, unspecified',
        'short': 'Myalgia and myositis NOS'},
       {'code': '729.2',
        'long': 'Neuralgia, neuritis, and radiculitis, unspecified',
        'short': 'Neuralgia/neuritis NOS'},
       {'code': '729.30',
        'long': 'Panniculitis, unspecified site',
        'short': 'Panniculitis, unsp site'},
       {'code': '729.31',
        'long': 'Hypertrophy of fat pad, knee',
        'short': 'Hypertrophy of fat pad'},
       {'code': '729.39',
        'long': 'Panniculitis, other site',
        'short': 'Panniculitis, site NEC'},
       {'code': '729.4',
        'long': 'Fasciitis, unspecified',
        'short': 'Fasciitis NOS'},
       {'code': '729.5', 'long': 'Pain in limb', 'short': 'Pain in limb'},
       {'code': '729.6',
        'long': 'Residual foreign body in soft tissue',
        'short': 'Old FB in soft tissue'},
       {'code': '729.71',
        'long': 'Nontraumatic compartment syndrome of upper extremity',
        'short': 'Nontraum comp syn-up ext'},
       {'code': '729.72',
        'long': 'Nontraumatic compartment syndrome of lower extremity',
        'short': 'Nontraum comp syn-low ex'},
       {'code': '729.73',
        'long': 'Nontraumatic compartment syndrome of abdomen',
        'short': 'Nontrauma comp syn-abd'},
       {'code': '729.79',
        'long': 'Nontraumatic compartment syndrome of other sites',
        'short': 'Nontrauma comp syn NEC'},
       {'code': '729.81',
        'long': 'Swelling of limb',
        'short': 'Swelling of limb'},
       {'code': '729.82', 'long': 'Cramp of limb', 'short': 'Cramp in limb'},
       {'code': '729.89',
        'long': 'Other musculoskeletal symptoms referable to limbs',
        'short': 'Muscskel sympt limb NEC'},
       {'code': '729.90',
        'long': 'Disorders of soft tissue, unspecified',
        'short': 'Soft tissue disord NOS'},
       {'code': '729.91',
        'long': 'Post-traumatic seroma',
        'short': 'Post-traumatic seroma'},
       {'code': '729.92',
        'long': 'Nontraumatic hematoma of soft tissue',
        'short': 'Nontrauma hema soft tiss'},
       {'code': '729.99',
        'long': 'Other disorders of soft tissue',
        'short': 'Soft tissue disorder NEC'},
       {'code': '730.00',
        'long': 'Acute osteomyelitis, site unspecified',
        'short': 'Ac osteomyelitis-unspec'},
       {'code': '730.01',
        'long': 'Acute osteomyelitis, shoulder region',
        'short': 'Ac osteomyelitis-shlder'},
       {'code': '730.02',
        'long': 'Acute osteomyelitis, upper arm',
        'short': 'Ac osteomyelitis-up/arm'},
       {'code': '730.03',
        'long': 'Acute osteomyelitis, forearm',
        'short': 'Ac osteomyelitis-forearm'},
       {'code': '730.04',
        'long': 'Acute osteomyelitis, hand',
        'short': 'Ac osteomyelitis-hand'},
       {'code': '730.05',
        'long': 'Acute osteomyelitis, pelvic region and thigh',
        'short': 'Ac osteomyelitis-pelvis'},
       {'code': '730.06',
        'long': 'Acute osteomyelitis, lower leg',
        'short': 'Ac osteomyelitis-l/leg'},
       {'code': '730.07',
        'long': 'Acute osteomyelitis, ankle and foot',
        'short': 'Ac osteomyelitis-ankle'},
       {'code': '730.08',
        'long': 'Acute osteomyelitis, other specified sites',
        'short': 'Ac osteomyelitis NEC'},
       {'code': '730.09',
        'long': 'Acute osteomyelitis, multiple sites',
        'short': 'Ac osteomyelitis-mult'},
       {'code': '730.10',
        'long': 'Chronic osteomyelitis, site unspecified',
        'short': 'Chr osteomyelitis-unsp'},
       {'code': '730.11',
        'long': 'Chronic osteomyelitis, shoulder region',
        'short': 'Chr osteomyelit-shlder'},
       {'code': '730.12',
        'long': 'Chronic osteomyelitis, upper arm',
        'short': 'Chr osteomyelit-up/arm'},
       {'code': '730.13',
        'long': 'Chronic osteomyelitis, forearm',
        'short': 'Chr osteomyelit-forearm'},
       {'code': '730.14',
        'long': 'Chronic osteomyelitis, hand',
        'short': 'Chr osteomyelit-hand'},
       {'code': '730.15',
        'long': 'Chronic osteomyelitis, pelvic region and thigh',
        'short': 'Chr osteomyelit-pelvis'},
       {'code': '730.16',
        'long': 'Chronic osteomyelitis, lower leg',
        'short': 'Chr osteomyelit-l/leg'},
       {'code': '730.17',
        'long': 'Chronic osteomyelitis, ankle and foot',
        'short': 'Chr osteomyelit-ankle'},
       {'code': '730.18',
        'long': 'Chronic osteomyelitis, other specified sites',
        'short': 'Chr osteomyelit NEC'},
       {'code': '730.19',
        'long': 'Chronic osteomyelitis, multiple sites',
        'short': 'Chr osteomyelit-mult'},
       {'code': '730.20',
        'long': 'Unspecified osteomyelitis, site unspecified',
        'short': 'Osteomyelitis NOS-unspec'},
       {'code': '730.21',
        'long': 'Unspecified osteomyelitis, shoulder region',
        'short': 'Osteomyelitis NOS-shlder'},
       {'code': '730.22',
        'long': 'Unspecified osteomyelitis, upper arm',
        'short': 'Osteomyelitis NOS-up/arm'},
       {'code': '730.23',
        'long': 'Unspecified osteomyelitis, forearm',
        'short': 'Osteomyelit NOS-forearm'},
       {'code': '730.24',
        'long': 'Unspecified osteomyelitis, hand',
        'short': 'Osteomyelitis NOS-hand'},
       {'code': '730.25',
        'long': 'Unspecified osteomyelitis, pelvic region and thigh',
        'short': 'Osteomyelitis NOS-pelvis'},
       {'code': '730.26',
        'long': 'Unspecified osteomyelitis, lower leg',
        'short': 'Osteomyelitis NOS-l/leg'},
       {'code': '730.27',
        'long': 'Unspecified osteomyelitis, ankle and foot',
        'short': 'Osteomyelitis NOS-ankle'},
       {'code': '730.28',
        'long': 'Unspecified osteomyelitis, other specified sites',
        'short': 'Osteomyelit NOS-oth site'},
       {'code': '730.29',
        'long': 'Unspecified osteomyelitis, multiple sites',
        'short': 'Osteomyelitis NOS-mult'},
       {'code': '730.30',
        'long': 'Periostitis, without mention of osteomyelitis, site unspecified',
        'short': 'Periostitis-unspec'},
       {'code': '730.31',
        'long': 'Periostitis, without mention of osteomyelitis, shoulder region',
        'short': 'Periostitis-shlder'},
       {'code': '730.32',
        'long': 'Periostitis, without mention of osteomyelitis, upper arm',
        'short': 'Periostitis-up/arm'},
       {'code': '730.33',
        'long': 'Periostitis, without mention of osteomyelitis, forearm',
        'short': 'Periostitis-forearm'},
       {'code': '730.34',
        'long': 'Periostitis, without mention of osteomyelitis, hand',
        'short': 'Periostitis-hand'},
       {'code': '730.35',
        'long': 'Periostitis, without mention of osteomyelitis, pelvic region and thigh',
        'short': 'Periostitis-pelvis'},
       {'code': '730.36',
        'long': 'Periostitis, without mention of osteomyelitis, lower leg',
        'short': 'Periostitis-l/leg'},
       {'code': '730.37',
        'long': 'Periostitis, without mention of osteomyelitis, ankle and foot',
        'short': 'Periostitis-ankle'},
       {'code': '730.38',
        'long': 'Periostitis, without mention of osteomyelitis, other specified sites',
        'short': 'Periostitis NEC'},
       {'code': '730.39',
        'long': 'Periostitis, without mention of osteomyelitis, multiple sites',
        'short': 'Periostitis-mult'},
       {'code': '730.70',
        'long': 'Osteopathy resulting from poliomyelitis, site unspecified',
        'short': 'Polio osteopathy-unspec'},
       {'code': '730.71',
        'long': 'Osteopathy resulting from poliomyelitis, shoulder region',
        'short': 'Polio osteopathy-shlder'},
       {'code': '730.72',
        'long': 'Osteopathy resulting from poliomyelitis, upper arm',
        'short': 'Polio osteopathy-up/arm'},
       {'code': '730.73',
        'long': 'Osteopathy resulting from poliomyelitis, forearm',
        'short': 'Polio osteopathy-forearm'},
       {'code': '730.74',
        'long': 'Osteopathy resulting from poliomyelitis, hand',
        'short': 'Polio osteopathy-hand'},
       {'code': '730.75',
        'long': 'Osteopathy resulting from poliomyelitis, pelvic region and thigh',
        'short': 'Polio osteopathy-pelvis'},
       {'code': '730.76',
        'long': 'Osteopathy resulting from poliomyelitis, lower leg',
        'short': 'Polio osteopathy-l/leg'},
       {'code': '730.77',
        'long': 'Osteopathy resulting from poliomyelitis, ankle and foot',
        'short': 'Polio osteopathy-ankle'},
       {'code': '730.78',
        'long': 'Osteopathy resulting from poliomyelitis, other specified sites',
        'short': 'Polio osteopathy NEC'},
       {'code': '730.79',
        'long': 'Osteopathy resulting from poliomyelitis, multiple sites',
        'short': 'Polio osteopathy-mult'},
       {'code': '730.80',
        'long': 'Other infections involving bone in diseases classified elsewhere, site unspecified',
        'short': 'Bone infect NEC-unspec'},
       {'code': '730.81',
        'long': 'Other infections involving bone in diseases classified elsewhere, shoulder region',
        'short': 'Bone infect NEC-shlder'},
       {'code': '730.82',
        'long': 'Other infections involving bone in diseases classified elsewhere, upper arm',
        'short': 'Bone infect NEC-up/arm'},
       {'code': '730.83',
        'long': 'Other infections involving bone in diseases classified elsewhere, forearm',
        'short': 'Bone infect NEC-forearm'},
       {'code': '730.84',
        'long': 'Other infections involving bone in diseases classified elsewhere, hand',
        'short': 'Bone infect NEC-hand'},
       {'code': '730.85',
        'long': 'Other infections involving bone in diseases classified elsewhere, pelvic region and thigh',
        'short': 'Bone infect NEC-pelvis'},
       {'code': '730.86',
        'long': 'Other infections involving bone in diseases classified elsewhere, lower leg',
        'short': 'Bone infect NEC-l/leg'},
       {'code': '730.87',
        'long': 'Other infections involving bone in diseases classified elsewhere, ankle and foot',
        'short': 'Bone infect NEC-ankle'},
       {'code': '730.88',
        'long': 'Other infections involving bone in diseases classified elsewhere, other specified sites',
        'short': 'Bone infect NEC-oth site'},
       {'code': '730.89',
        'long': 'Other infections involving bone in diseases classified elsewhere, multiple sites',
        'short': 'Bone infect NEC-mult'},
       {'code': '730.90',
        'long': 'Unspecified infection of bone, site unspecified',
        'short': 'Bone infec NOS-unsp site'},
       {'code': '730.91',
        'long': 'Unspecified infection of bone, shoulder region',
        'short': 'Bone infect NOS-shlder'},
       {'code': '730.92',
        'long': 'Unspecified infection of bone, upper arm',
        'short': 'Bone infect NOS-up/arm'},
       {'code': '730.93',
        'long': 'Unspecified infection of bone, forearm',
        'short': 'Bone infect NOS-forearm'},
       {'code': '730.94',
        'long': 'Unspecified infection of bone, hand',
        'short': 'Bone infect NOS-hand'},
       {'code': '730.95',
        'long': 'Unspecified infection of bone, pelvic region and thigh',
        'short': 'Bone infect NOS-pelvis'},
       {'code': '730.96',
        'long': 'Unspecified infection of bone, lower leg',
        'short': 'Bone infect NOS-l/leg'},
       {'code': '730.97',
        'long': 'Unspecified infection of bone, ankle and foot',
        'short': 'Bone infect NOS-ankle'},
       {'code': '730.98',
        'long': 'Unspecified infection of bone, other specified sites',
        'short': 'Bone infect NOS-oth site'},
       {'code': '730.99',
        'long': 'Unspecified infection of bone, multiple sites',
        'short': 'Bone infect NOS-mult'},
       {'code': '731.0',
        'long': 'Osteitis deformans without mention of bone tumor',
        'short': 'Osteitis deformans NOS'},
       {'code': '731.1',
        'long': 'Osteitis deformans in diseases classified elsewhere',
        'short': 'Osteitis def in oth dis'},
       {'code': '731.2',
        'long': 'Hypertrophic pulmonary osteoarthropathy',
        'short': 'Hypertroph osteoarthrop'},
       {'code': '731.3',
        'long': 'Major osseous defects',
        'short': 'Major osseous defects'},
       {'code': '731.8',
        'long': 'Other bone involvement in diseases classified elsewhere',
        'short': 'Bone involv in oth dis'},
       {'code': '732.0',
        'long': 'Juvenile osteochondrosis of spine',
        'short': 'Juv osteochondros spine'},
       {'code': '732.1',
        'long': 'Juvenile osteochondrosis of hip and pelvis',
        'short': 'Juv osteochondros pelvis'},
       {'code': '732.2',
        'long': 'Nontraumatic slipped upper femoral epiphysis',
        'short': 'Femoral epiphysiolysis'},
       {'code': '732.3',
        'long': 'Juvenile osteochondrosis of upper extremity',
        'short': 'Juv osteochondrosis arm'},
       {'code': '732.4',
        'long': 'Juvenile osteochondrosis of lower extremity, excluding foot',
        'short': 'Juv osteochondrosis leg'},
       {'code': '732.5',
        'long': 'Juvenile osteochondrosis of foot',
        'short': 'Juv osteochondrosis foot'},
       {'code': '732.6',
        'long': 'Other juvenile osteochondrosis',
        'short': 'Juv osteochondrosis NEC'},
       {'code': '732.7',
        'long': 'Osteochondritis dissecans',
        'short': 'Osteochondrit dissecans'},
       {'code': '732.8',
        'long': 'Other specified forms of osteochondropathy',
        'short': 'Osteochondropathy NEC'},
       {'code': '732.9',
        'long': 'Unspecified osteochondropathy',
        'short': 'Osteochondropathy NOS'},
       {'code': '733.00',
        'long': 'Osteoporosis, unspecified',
        'short': 'Osteoporosis NOS'},
       {'code': '733.01',
        'long': 'Senile osteoporosis',
        'short': 'Senile osteoporosis'},
       {'code': '733.02',
        'long': 'Idiopathic osteoporosis',
        'short': 'Idiopathic osteoporosis'},
       {'code': '733.03',
        'long': 'Disuse osteoporosis',
        'short': 'Disuse osteoporosis'},
       {'code': '733.09',
        'long': 'Other osteoporosis',
        'short': 'Osteoporosis NEC'},
       {'code': '733.10',
        'long': 'Pathologic fracture, unspecified site',
        'short': 'Path fx unspecified site'},
       {'code': '733.11',
        'long': 'Pathologic fracture of humerus',
        'short': 'Path fx humerus'},
       {'code': '733.12',
        'long': 'Pathologic fracture of distal radius and ulna',
        'short': 'Path fx dstl radius ulna'},
       {'code': '733.13',
        'long': 'Pathologic fracture of vertebrae',
        'short': 'Path fx vertebrae'},
       {'code': '733.14',
        'long': 'Pathologic fracture of neck of femur',
        'short': 'Path fx neck of femur'},
       {'code': '733.15',
        'long': 'Pathologic fracture of other specified part of femur',
        'short': 'Path fx oth spcf prt fmr'},
       {'code': '733.16',
        'long': 'Pathologic fracture of tibia or fibula',
        'short': 'Path fx tibia fibula'},
       {'code': '733.19',
        'long': 'Pathologic fracture of other specified site',
        'short': 'Path fx oth specif site'},
       {'code': '733.20',
        'long': 'Cyst of bone (localized), unspecified',
        'short': 'Cyst of bone NOS'},
       {'code': '733.21',
        'long': 'Solitary bone cyst',
        'short': 'Solitary bone cyst'},
       {'code': '733.22',
        'long': 'Aneurysmal bone cyst',
        'short': 'Aneurysmal bone cyst'},
       {'code': '733.29',
        'long': 'Other bone cyst',
        'short': 'Bone cyst NEC'},
       {'code': '733.3',
        'long': 'Hyperostosis of skull',
        'short': 'Hyperostosis of skull'},
       {'code': '733.40',
        'long': 'Aseptic necrosis of bone, site unspecified',
        'short': 'Asept necrosis bone NOS'},
       {'code': '733.41',
        'long': 'Aseptic necrosis of head of humerus',
        'short': 'Aseptic necrosis humerus'},
       {'code': '733.42',
        'long': 'Aseptic necrosis of head and neck of femur',
        'short': 'Aseptic necrosis femur'},
       {'code': '733.43',
        'long': 'Aseptic necrosis of medial femoral condyle',
        'short': 'Asept necro femur condyl'},
       {'code': '733.44',
        'long': 'Aseptic necrosis of talus',
        'short': 'Aseptic necrosis talus'},
       {'code': '733.45',
        'long': 'Aseptic necrosis of bone, jaw',
        'short': 'Aseptic necrosis of jaw'},
       {'code': '733.49',
        'long': 'Aseptic necrosis of bone, other',
        'short': 'Asept necrosis bone NEC'},
       {'code': '733.5',
        'long': 'Osteitis condensans',
        'short': 'Osteitis condensans'},
       {'code': '733.6',
        'long': "Tietze's disease",
        'short': "Tietze's disease"},
       {'code': '733.7',
        'long': 'Algoneurodystrophy',
        'short': 'Algoneurodystrophy'},
       {'code': '733.81',
        'long': 'Malunion of fracture',
        'short': 'Malunion of fracture'},
       {'code': '733.82',
        'long': 'Nonunion of fracture',
        'short': 'Nonunion of fracture'},
       {'code': '733.90',
        'long': 'Disorder of bone and cartilage, unspecified',
        'short': 'Bone & cartilage dis NOS'},
       {'code': '733.91',
        'long': 'Arrest of bone development or growth',
        'short': 'Arrest of bone growth'},
       {'code': '733.92',
        'long': 'Chondromalacia',
        'short': 'Chondromalacia'},
       {'code': '733.93',
        'long': 'Stress fracture of tibia or fibula',
        'short': 'Stress fx tibia/fibula'},
       {'code': '733.94',
        'long': 'Stress fracture of the metatarsals',
        'short': 'Stress fx metatarsals'},
       {'code': '733.95',
        'long': 'Stress fracture of other bone',
        'short': 'Stress fracture bone NEC'},
       {'code': '733.96',
        'long': 'Stress fracture of femoral neck',
        'short': 'Stress fx femoral neck'},
       {'code': '733.97',
        'long': 'Stress fracture of shaft of femur',
        'short': 'Stress fx shaft femur'},
       {'code': '733.98',
        'long': 'Stress fracture of pelvis',
        'short': 'Stress fx pelvis'},
       {'code': '733.99',
        'long': 'Other disorders of bone and cartilage',
        'short': 'Bone & cartilage dis NEC'},
       {'code': '734', 'long': 'Flat foot', 'short': 'Flat foot'},
       {'code': '735.0',
        'long': 'Hallux valgus (acquired)',
        'short': 'Hallux valgus'},
       {'code': '735.1',
        'long': 'Hallux varus (acquired)',
        'short': 'Hallux varus'},
       {'code': '735.2', 'long': 'Hallux rigidus', 'short': 'Hallux rigidus'},
       {'code': '735.3', 'long': 'Hallux malleus', 'short': 'Hallux malleus'},
       {'code': '735.4',
        'long': 'Other hammer toe (acquired)',
        'short': 'Other hammer toe'},
       {'code': '735.5', 'long': 'Claw toe (acquired)', 'short': 'Claw toe'},
       {'code': '735.8',
        'long': 'Other acquired deformities of toe',
        'short': 'Acq deformity of toe NEC'},
       {'code': '735.9',
        'long': 'Unspecified acquired deformity of toe',
        'short': 'Acq deformity of toe NOS'},
       {'code': '736.00',
        'long': 'Unspecified deformity of forearm, excluding fingers',
        'short': 'Forearm deformity NOS'},
       {'code': '736.01',
        'long': 'Cubitus valgus (acquired)',
        'short': 'Cubitus valgus'},
       {'code': '736.02',
        'long': 'Cubitus varus (acquired)',
        'short': 'Cubitus varus'},
       {'code': '736.03',
        'long': 'Valgus deformity of wrist (acquired)',
        'short': 'Valgus deformity wrist'},
       {'code': '736.04',
        'long': 'Varus deformity of wrist (acquired)',
        'short': 'Varus deformity wrist'},
       {'code': '736.05',
        'long': 'Wrist drop (acquired)',
        'short': 'Wrist drop'},
       {'code': '736.06',
        'long': 'Claw hand (acquired)',
        'short': 'Claw hand'},
       {'code': '736.07',
        'long': 'Club hand, acquired',
        'short': 'Club hand, acquired'},
       {'code': '736.09',
        'long': 'Other acquired deformities of forearm, excluding fingers',
        'short': 'Forearm deformity NEC'},
       {'code': '736.1', 'long': 'Mallet finger', 'short': 'Mallet finger'},
       {'code': '736.20',
        'long': 'Unspecified deformity of finger',
        'short': 'Acq finger deformity NOS'},
       {'code': '736.21',
        'long': 'Boutonniere deformity',
        'short': 'Boutonniere deformity'},
       {'code': '736.22',
        'long': 'Swan-neck deformity',
        'short': 'Swan-neck deformity'},
       {'code': '736.29',
        'long': 'Other acquired deformities of finger',
        'short': 'Acq finger deformity NEC'},
       {'code': '736.30',
        'long': 'Unspecified acquired deformity of hip',
        'short': 'Acq hip deformity NOS'},
       {'code': '736.31',
        'long': 'Coxa valga (acquired)',
        'short': 'Coxa valga'},
       {'code': '736.32',
        'long': 'Coxa vara (acquired)',
        'short': 'Coxa vara'},
       {'code': '736.39',
        'long': 'Other acquired deformities of hip',
        'short': 'Acq hip deformity NEC'},
       {'code': '736.41',
        'long': 'Genu valgum (acquired)',
        'short': 'Genu valgum'},
       {'code': '736.42',
        'long': 'Genu varum (acquired)',
        'short': 'Genu varum'},
       {'code': '736.5',
        'long': 'Genu recurvatum (acquired)',
        'short': 'Genu recurvatum'},
       {'code': '736.6',
        'long': 'Other acquired deformities of knee',
        'short': 'Acq knee deformity NEC'},
       {'code': '736.70',
        'long': 'Unspecified deformity of ankle and foot, acquired',
        'short': 'Acq ankle-foot def NOS'},
       {'code': '736.71',
        'long': 'Acquired equinovarus deformity',
        'short': 'Acq equinovarus'},
       {'code': '736.72',
        'long': 'Equinus deformity of foot, acquired',
        'short': 'Acq equinus deformity'},
       {'code': '736.73',
        'long': 'Cavus deformity of foot, acquired',
        'short': 'Cavus deformity of foot'},
       {'code': '736.74',
        'long': 'Claw foot, acquired',
        'short': 'Claw foot, acquired'},
       {'code': '736.75',
        'long': 'Cavovarus deformity of foot, acquired',
        'short': 'Acq cavovarus deformity'},
       {'code': '736.76',
        'long': 'Other acquired calcaneus deformity',
        'short': 'Calcaneus deformity NEC'},
       {'code': '736.79',
        'long': 'Other acquired deformities of ankle and foot',
        'short': 'Acq ankle-foot def NEC'},
       {'code': '736.81',
        'long': 'Unequal leg length (acquired)',
        'short': 'Unequal leg length'},
       {'code': '736.89',
        'long': 'Other acquired deformity of other parts of limb',
        'short': 'Oth acq limb deformity'},
       {'code': '736.9',
        'long': 'Acquired deformity of limb, site unspecified',
        'short': 'Acq limb deformity NOS'},
       {'code': '737.0',
        'long': 'Adolescent postural kyphosis',
        'short': 'Adoles postural kyphosis'},
       {'code': '737.10',
        'long': 'Kyphosis (acquired) (postural)',
        'short': 'Kyphosis NOS'},
       {'code': '737.11',
        'long': 'Kyphosis due to radiation',
        'short': 'Radiation kyphosis'},
       {'code': '737.12',
        'long': 'Kyphosis, postlaminectomy',
        'short': 'Postlaminectomy kyphosis'},
       {'code': '737.19',
        'long': 'Other kyphosis (acquired)',
        'short': 'Kyphosis NEC'},
       {'code': '737.20',
        'long': 'Lordosis (acquired) (postural)',
        'short': 'Lordosis NOS'},
       {'code': '737.21',
        'long': 'Lordosis, postlaminectomy',
        'short': 'Postlaminectomy lordosis'},
       {'code': '737.22',
        'long': 'Other postsurgical lordosis',
        'short': 'Oth postsurgery lordosis'},
       {'code': '737.29',
        'long': 'Other lordosis (acquired)',
        'short': 'Lordosis NEC'},
       {'code': '737.30',
        'long': 'Scoliosis [and kyphoscoliosis], idiopathic',
        'short': 'Idiopathic scoliosis'},
       {'code': '737.31',
        'long': 'Resolving infantile idiopathic scoliosis',
        'short': 'Resolv idiopath scolios'},
       {'code': '737.32',
        'long': 'Progressive infantile idiopathic scoliosis',
        'short': 'Progr idiopath scoliosis'},
       {'code': '737.33',
        'long': 'Scoliosis due to radiation',
        'short': 'Radiation scoliosis'},
       {'code': '737.34',
        'long': 'Thoracogenic scoliosis',
        'short': 'Thoracogenic scoliosis'},
       {'code': '737.39',
        'long': 'Other kyphoscoliosis and scoliosis',
        'short': 'Scoliosis NEC'},
       {'code': '737.40',
        'long': 'Curvature of spine, unspecified, associated with other conditions',
        'short': 'Spin curv NOS in oth dis'},
       {'code': '737.41',
        'long': 'Kyphosis associated with other conditions',
        'short': 'Kyphosis in oth dis'},
       {'code': '737.42',
        'long': 'Lordosis associated with other conditions',
        'short': 'Lordosis in oth dis'},
       {'code': '737.43',
        'long': 'Scoliosis associated with other conditions',
        'short': 'Scoliosis in oth dis'},
       {'code': '737.8',
        'long': 'Other curvatures of spine',
        'short': 'Curvature of spine NEC'},
       {'code': '737.9',
        'long': 'Unspecified curvature of spine',
        'short': 'Curvature of spine NOS'},
       {'code': '738.0',
        'long': 'Acquired deformity of nose',
        'short': 'Acq nose deformity'},
       {'code': '738.10',
        'long': 'Unspecified acquired deformity of head',
        'short': 'Unspf acq deformity head'},
       {'code': '738.11',
        'long': 'Zygomatic hyperplasia',
        'short': 'Zygomatic hyperplasia'},
       {'code': '738.12',
        'long': 'Zygomatic hypoplasia',
        'short': 'Zygomatic hypoplasia'},
       {'code': '738.19',
        'long': 'Other specified acquired deformity of head',
        'short': 'Oth spcf deformity head'},
       {'code': '738.2',
        'long': 'Acquired deformity of neck',
        'short': 'Acq neck deformity'},
       {'code': '738.3',
        'long': 'Acquired deformity of chest and rib',
        'short': 'Acq chest deformity'},
       {'code': '738.4',
        'long': 'Acquired spondylolisthesis',
        'short': 'Acq spondylolisthesis'},
       {'code': '738.5',
        'long': 'Other acquired deformity of back or spine',
        'short': 'Other acq back deformity'},
       {'code': '738.6',
        'long': 'Acquired deformity of pelvis',
        'short': 'Acq pelvic deformity'},
       {'code': '738.7',
        'long': 'Cauliflower ear',
        'short': 'Cauliflower ear'},
       {'code': '738.8',
        'long': 'Acquired deformity of other specified site',
        'short': 'Acq deformity NEC'},
       {'code': '738.9',
        'long': 'Acquired deformity of unspecified site',
        'short': 'Acq deformity NOS'},
       {'code': '739.0',
        'long': 'Nonallopathic lesions, head region',
        'short': 'Somat dys head region'},
       {'code': '739.1',
        'long': 'Nonallopathic lesions, cervical region',
        'short': 'Somat dysfunc cervic reg'},
       {'code': '739.2',
        'long': 'Nonallopathic lesions, thoracic region',
        'short': 'Somat dysfunc thorac reg'},
       {'code': '739.3',
        'long': 'Nonallopathic lesions, lumbar region',
        'short': 'Somat dysfunc lumbar reg'},
       {'code': '739.4',
        'long': 'Nonallopathic lesions, sacral region',
        'short': 'Somat dysfunc sacral reg'},
       {'code': '739.5',
        'long': 'Nonallopathic lesions, pelvic region',
        'short': 'Somat dysfunc pelvic reg'},
       {'code': '739.6',
        'long': 'Nonallopathic lesions, lower extremities',
        'short': 'Somat dysfunc lower extr'},
       {'code': '739.7',
        'long': 'Nonallopathic lesions, upper extremities',
        'short': 'Somat dysfunc upper extr'},
       {'code': '739.8',
        'long': 'Nonallopathic lesions, rib cage',
        'short': 'Somat dysfunc rib cage'},
       {'code': '739.9',
        'long': 'Nonallopathic lesions, abdomen and other sites',
        'short': 'Somatic dysfunction NEC'}],
 'N': [{'code': '580.0',
        'long': 'Acute glomerulonephritis with lesion of proliferative glomerulonephritis',
        'short': 'Ac proliferat nephritis'},
       {'code': '580.4',
        'long': 'Acute glomerulonephritis with lesion of rapidly progressive glomerulonephritis',
        'short': 'Ac rapidly progr nephrit'},
       {'code': '580.81',
        'long': 'Acute glomerulonephritis in diseases classified elsewhere',
        'short': 'Ac nephritis in oth dis'},
       {'code': '580.89',
        'long': 'Acute glomerulonephritis with other specified pathological lesion in kidney',
        'short': 'Acute nephritis NEC'},
       {'code': '580.9',
        'long': 'Acute glomerulonephritis with unspecified pathological lesion in kidney',
        'short': 'Acute nephritis NOS'},
       {'code': '581.0',
        'long': 'Nephrotic syndrome with lesion of proliferative glomerulonephritis',
        'short': 'Nephrotic syn, prolifer'},
       {'code': '581.1',
        'long': 'Nephrotic syndrome with lesion of membranous glomerulonephritis',
        'short': 'Epimembranous nephritis'},
       {'code': '581.2',
        'long': 'Nephrotic syndrome with lesion of membranoproliferative glomerulonephritis',
        'short': 'Membranoprolif nephrosis'},
       {'code': '581.3',
        'long': 'Nephrotic syndrome with lesion of minimal change glomerulonephritis',
        'short': 'Minimal change nephrosis'},
       {'code': '581.81',
        'long': 'Nephrotic syndrome in diseases classified elsewhere',
        'short': 'Nephrotic syn in oth dis'},
       {'code': '581.89',
        'long': 'Nephrotic syndrome with other specified pathological lesion in kidney',
        'short': 'Nephrotic syndrome NEC'},
       {'code': '581.9',
        'long': 'Nephrotic syndrome with unspecified pathological lesion in kidney',
        'short': 'Nephrotic syndrome NOS'},
       {'code': '582.0',
        'long': 'Chronic glomerulonephritis with lesion of proliferative glomerulonephritis',
        'short': 'Chr proliferat nephritis'},
       {'code': '582.1',
        'long': 'Chronic glomerulonephritis with lesion of membranous glomerulonephritis',
        'short': 'Chr membranous nephritis'},
       {'code': '582.2',
        'long': 'Chronic glomerulonephritis with lesion of membranoproliferative glomerulonephritis',
        'short': 'Chr membranoprolif nephr'},
       {'code': '582.4',
        'long': 'Chronic glomerulonephritis with lesion of rapidly progressive glomerulonephritis',
        'short': 'Chr rapid progr nephrit'},
       {'code': '582.81',
        'long': 'Chronic glomerulonephritis in diseases classified elsewhere',
        'short': 'Chr nephritis in oth dis'},
       {'code': '582.89',
        'long': 'Chronic glomerulonephritis with other specified pathological lesion in kidney',
        'short': 'Chronic nephritis NEC'},
       {'code': '582.9',
        'long': 'Chronic glomerulonephritis with unspecified pathological lesion in kidney',
        'short': 'Chronic nephritis NOS'},
       {'code': '583.0',
        'long': 'Nephritis and nephropathy, not specified as acute or chronic, with lesion of proliferative glomerulonephritis',
        'short': 'Proliferat nephritis NOS'},
       {'code': '583.1',
        'long': 'Nephritis and nephropathy, not specified as acute or chronic, with lesion of membranous glomerulonephritis',
        'short': 'Membranous nephritis NOS'},
       {'code': '583.2',
        'long': 'Nephritis and nephropathy, not specified as acute or chronic, with lesion of membranoproliferative glomerulonephritis',
        'short': 'Membranoprolif nephr NOS'},
       {'code': '583.4',
        'long': 'Nephritis and nephropathy, not specified as acute or chronic, with lesion of rapidly progressive glomerulonephritis',
        'short': 'Rapidly prog nephrit NOS'},
       {'code': '583.6',
        'long': 'Nephritis and nephropathy, not specified as acute or chronic, with lesion of renal cortical necrosis',
        'short': 'Renal cort necrosis NOS'},
       {'code': '583.7',
        'long': 'Nephritis and nephropathy, not specified as acute or chronic, with lesion of renal medullary necrosis',
        'short': 'Nephr NOS/medull necros'},
       {'code': '583.81',
        'long': 'Nephritis and nephropathy, not specified as acute or chronic, in diseases classified elsewhere',
        'short': 'Nephritis NOS in oth dis'},
       {'code': '583.89',
        'long': 'Nephritis and nephropathy, not specified as acute or chronic, with other specified pathological lesion in kidney',
        'short': 'Nephritis NEC'},
       {'code': '583.9',
        'long': 'Nephritis and nephropathy, not specified as acute or chronic, with unspecified pathological lesion in kidney',
        'short': 'Nephritis NOS'},
       {'code': '584.5',
        'long': 'Acute kidney failure with lesion of tubular necrosis',
        'short': 'Ac kidny fail, tubr necr'},
       {'code': '584.6',
        'long': 'Acute kidney failure with lesion of renal cortical necrosis',
        'short': 'Ac kidny fail, cort necr'},
       {'code': '584.7',
        'long': 'Acute kidney failure with lesion of renal medullary [papillary] necrosis',
        'short': 'Ac kidny fail, medu necr'},
       {'code': '584.8',
        'long': 'Acute kidney failure with other specified pathological lesion in kidney',
        'short': 'Acute kidney failure NEC'},
       {'code': '584.9',
        'long': 'Acute kidney failure, unspecified',
        'short': 'Acute kidney failure NOS'},
       {'code': '585.1',
        'long': 'Chronic kidney disease, Stage I',
        'short': 'Chro kidney dis stage I'},
       {'code': '585.2',
        'long': 'Chronic kidney disease, Stage II (mild)',
        'short': 'Chro kidney dis stage II'},
       {'code': '585.3',
        'long': 'Chronic kidney disease, Stage III (moderate)',
        'short': 'Chr kidney dis stage III'},
       {'code': '585.4',
        'long': 'Chronic kidney disease, Stage IV (severe)',
        'short': 'Chr kidney dis stage IV'},
       {'code': '585.5',
        'long': 'Chronic kidney disease, Stage V',
        'short': 'Chron kidney dis stage V'},
       {'code': '585.6',
        'long': 'End stage renal disease',
        'short': 'End stage renal disease'},
       {'code': '585.9',
        'long': 'Chronic kidney disease, unspecified',
        'short': 'Chronic kidney dis NOS'},
       {'code': '586',
        'long': 'Renal failure, unspecified',
        'short': 'Renal failure NOS'},
       {'code': '587',
        'long': 'Renal sclerosis, unspecified',
        'short': 'Renal sclerosis NOS'},
       {'code': '588.0',
        'long': 'Renal osteodystrophy',
        'short': 'Renal osteodystrophy'},
       {'code': '588.1',
        'long': 'Nephrogenic diabetes insipidus',
        'short': 'Nephrogen diabetes insip'},
       {'code': '588.81',
        'long': 'Secondary hyperparathyroidism (of renal origin)',
        'short': 'Sec hyperparathyrd-renal'},
       {'code': '588.89',
        'long': 'Other specified disorders resulting from impaired renal function',
        'short': 'Impair ren funct dis NEC'},
       {'code': '588.9',
        'long': 'Unspecified disorder resulting from impaired renal function',
        'short': 'Impaired renal funct NOS'},
       {'code': '589.0',
        'long': 'Unilateral small kidney',
        'short': 'Unilateral small kidney'},
       {'code': '589.1',
        'long': 'Bilateral small kidneys',
        'short': 'Bilateral small kidneys'},
       {'code': '589.9',
        'long': 'Small kidney, unspecified',
        'short': 'Small kidney NOS'},
       {'code': '590.00',
        'long': 'Chronic pyelonephritis without lesion of renal medullary necrosis',
        'short': 'Chr pyelonephritis NOS'},
       {'code': '590.01',
        'long': 'Chronic pyelonephritis with lesion of renal medullary necrosis',
        'short': 'Chr pyeloneph w med necr'},
       {'code': '590.10',
        'long': 'Acute pyelonephritis without lesion of renal medullary necrosis',
        'short': 'Ac pyelonephritis NOS'},
       {'code': '590.11',
        'long': 'Acute pyelonephritis with lesion of renal medullary necrosis',
        'short': 'Ac pyelonephr w med necr'},
       {'code': '590.2',
        'long': 'Renal and perinephric abscess',
        'short': 'Renal/perirenal abscess'},
       {'code': '590.3',
        'long': 'Pyeloureteritis cystica',
        'short': 'Pyeloureteritis cystica'},
       {'code': '590.80',
        'long': 'Pyelonephritis, unspecified',
        'short': 'Pyelonephritis NOS'},
       {'code': '590.81',
        'long': 'Pyelitis or pyelonephritis in diseases classified elsewhere',
        'short': 'Pyelonephrit in oth dis'},
       {'code': '590.9',
        'long': 'Infection of kidney, unspecified',
        'short': 'Infection of kidney NOS'},
       {'code': '591', 'long': 'Hydronephrosis', 'short': 'Hydronephrosis'},
       {'code': '592.0',
        'long': 'Calculus of kidney',
        'short': 'Calculus of kidney'},
       {'code': '592.1',
        'long': 'Calculus of ureter',
        'short': 'Calculus of ureter'},
       {'code': '592.9',
        'long': 'Urinary calculus, unspecified',
        'short': 'Urinary calculus NOS'},
       {'code': '593.0', 'long': 'Nephroptosis', 'short': 'Nephroptosis'},
       {'code': '593.1',
        'long': 'Hypertrophy of kidney',
        'short': 'Hypertrophy of kidney'},
       {'code': '593.2',
        'long': 'Cyst of kidney, acquired',
        'short': 'Cyst of kidney, acquired'},
       {'code': '593.3',
        'long': 'Stricture or kinking of ureter',
        'short': 'Stricture of ureter'},
       {'code': '593.4',
        'long': 'Other ureteric obstruction',
        'short': 'Ureteric obstruction NEC'},
       {'code': '593.5', 'long': 'Hydroureter', 'short': 'Hydroureter'},
       {'code': '593.6',
        'long': 'Postural proteinuria',
        'short': 'Postural proteinuria'},
       {'code': '593.70',
        'long': 'Vesicoureteral reflux unspecified or without reflux nephropathy',
        'short': 'Vescouretrl rflux unspcf'},
       {'code': '593.71',
        'long': 'Vesicoureteral reflux with reflux nephropathy, unilateral',
        'short': 'Vscurt rflx npht uniltrl'},
       {'code': '593.72',
        'long': 'Vesicoureteral reflux with reflux nephropathy, bilateral',
        'short': 'Vscourtl rflx npht bltrl'},
       {'code': '593.73',
        'long': 'Other vesicoureteral reflux with reflux nephropathy NOS',
        'short': 'Vscourtl rflx w npht NOS'},
       {'code': '593.81',
        'long': 'Vascular disorders of kidney',
        'short': 'Renal vascular disorder'},
       {'code': '593.82',
        'long': 'Ureteral fistula',
        'short': 'Ureteral fistula'},
       {'code': '593.89',
        'long': 'Other specified disorders of kidney and ureter',
        'short': 'Renal & ureteral dis NEC'},
       {'code': '593.9',
        'long': 'Unspecified disorder of kidney and ureter',
        'short': 'Renal & ureteral dis NOS'},
       {'code': '594.0',
        'long': 'Calculus in diverticulum of bladder',
        'short': 'Blad diverticulum calcul'},
       {'code': '594.1',
        'long': 'Other calculus in bladder',
        'short': 'Bladder calculus NEC'},
       {'code': '594.2',
        'long': 'Calculus in urethra',
        'short': 'Urethral calculus'},
       {'code': '594.8',
        'long': 'Other lower urinary tract calculus',
        'short': 'Lower urin calcul NEC'},
       {'code': '594.9',
        'long': 'Calculus of lower urinary tract, unspecified',
        'short': 'Lower urin calcul NOS'},
       {'code': '595.0', 'long': 'Acute cystitis', 'short': 'Acute cystitis'},
       {'code': '595.1',
        'long': 'Chronic interstitial cystitis',
        'short': 'Chr interstit cystitis'},
       {'code': '595.2',
        'long': 'Other chronic cystitis',
        'short': 'Chronic cystitis NEC'},
       {'code': '595.3', 'long': 'Trigonitis', 'short': 'Trigonitis'},
       {'code': '595.4',
        'long': 'Cystitis in diseases classified elsewhere',
        'short': 'Cystitis in oth dis'},
       {'code': '595.81',
        'long': 'Cystitis cystica',
        'short': 'Cystitis cystica'},
       {'code': '595.82',
        'long': 'Irradiation cystitis',
        'short': 'Irradiation cystitis'},
       {'code': '595.89',
        'long': 'Other specified types of cystitis',
        'short': 'Cystitis NEC'},
       {'code': '595.9',
        'long': 'Cystitis, unspecified',
        'short': 'Cystitis NOS'},
       {'code': '596.0',
        'long': 'Bladder neck obstruction',
        'short': 'Bladder neck obstruction'},
       {'code': '596.1',
        'long': 'Intestinovesical fistula',
        'short': 'Intestinovesical fistula'},
       {'code': '596.2',
        'long': 'Vesical fistula, not elsewhere classified',
        'short': 'Vesical fistula NEC'},
       {'code': '596.3',
        'long': 'Diverticulum of bladder',
        'short': 'Diverticulum of bladder'},
       {'code': '596.4',
        'long': 'Atony of bladder',
        'short': 'Atony of bladder'},
       {'code': '596.51',
        'long': 'Hypertonicity of bladder',
        'short': 'Hypertonicity of bladder'},
       {'code': '596.52',
        'long': 'Low bladder compliance',
        'short': 'Low bladder compliance'},
       {'code': '596.53',
        'long': 'Paralysis of bladder',
        'short': 'Paralysis of bladder'},
       {'code': '596.54',
        'long': 'Neurogenic bladder NOS',
        'short': 'Neurogenic bladder NOS'},
       {'code': '596.55',
        'long': 'Detrusor sphincter dyssynergia',
        'short': 'Detrusr sphinc dyssnrgia'},
       {'code': '596.59',
        'long': 'Other functional disorder of bladder',
        'short': 'Oth func dsdr bladder'},
       {'code': '596.6',
        'long': 'Rupture of bladder, nontraumatic',
        'short': 'Bladder rupt, nontraum'},
       {'code': '596.7',
        'long': 'Hemorrhage into bladder wall',
        'short': 'Bladder wall hemorrhage'},
       {'code': '596.81',
        'long': 'Infection of cystostomy',
        'short': 'Infection of cystostomy'},
       {'code': '596.82',
        'long': 'Mechanical complication of cystostomy',
        'short': 'Mech comp of cystostomy'},
       {'code': '596.83',
        'long': 'Other complication of cystostomy',
        'short': 'Other comp of cystostomy'},
       {'code': '596.89',
        'long': 'Other specified disorders of bladder',
        'short': 'Disorders of bladder NEC'},
       {'code': '596.9',
        'long': 'Unspecified disorder of bladder',
        'short': 'Bladder disorder NOS'},
       {'code': '597.0',
        'long': 'Urethral abscess',
        'short': 'Urethral abscess'},
       {'code': '597.80',
        'long': 'Urethritis, unspecified',
        'short': 'Urethritis NOS'},
       {'code': '597.81',
        'long': 'Urethral syndrome NOS',
        'short': 'Urethral syndrome NOS'},
       {'code': '597.89',
        'long': 'Other urethritis',
        'short': 'Urethritis NEC'},
       {'code': '598.00',
        'long': 'Urethral stricture due to unspecified infection',
        'short': 'Urethr strict:infect NOS'},
       {'code': '598.01',
        'long': 'Urethral stricture due to infective diseases classified elsewhere',
        'short': 'Ureth strict:oth infect'},
       {'code': '598.1',
        'long': 'Traumatic urethral stricture',
        'short': 'Traum urethral stricture'},
       {'code': '598.2',
        'long': 'Postoperative urethral stricture',
        'short': 'Postop urethral strictur'},
       {'code': '598.8',
        'long': 'Other specified causes of urethral stricture',
        'short': 'Urethral stricture NEC'},
       {'code': '598.9',
        'long': 'Urethral stricture, unspecified',
        'short': 'Urethral stricture NOS'},
       {'code': '599.0',
        'long': 'Urinary tract infection, site not specified',
        'short': 'Urin tract infection NOS'},
       {'code': '599.1',
        'long': 'Urethral fistula',
        'short': 'Urethral fistula'},
       {'code': '599.2',
        'long': 'Urethral diverticulum',
        'short': 'Urethral diverticulum'},
       {'code': '599.3',
        'long': 'Urethral caruncle',
        'short': 'Urethral caruncle'},
       {'code': '599.4',
        'long': 'Urethral false passage',
        'short': 'Urethral false passage'},
       {'code': '599.5',
        'long': 'Prolapsed urethral mucosa',
        'short': 'Prolapse urethral mucosa'},
       {'code': '599.60',
        'long': 'Urinary obstruction, unspecified',
        'short': 'Urinary obstruction NOS'},
       {'code': '599.69',
        'long': 'Urinary obstruction, not elsewhere classified',
        'short': 'Urinary obstruction NEC'},
       {'code': '599.70',
        'long': 'Hematuria, unspecified',
        'short': 'Hematuria NOS'},
       {'code': '599.71',
        'long': 'Gross hematuria',
        'short': 'Gross hematuria'},
       {'code': '599.72',
        'long': 'Microscopic hematuria',
        'short': 'Microscopic hematuria'},
       {'code': '599.81',
        'long': 'Urethral hypermobility',
        'short': 'Urethral hypermobility'},
       {'code': '599.82',
        'long': 'Intrinsic (urethral) sphincter deficiency [ISD]',
        'short': 'Intrinsc sphnctr dficncy'},
       {'code': '599.83',
        'long': 'Urethral instability',
        'short': 'Urethral instability'},
       {'code': '599.84',
        'long': 'Other specified disorders of urethra',
        'short': 'Oth spcf dsdr urethra'},
       {'code': '599.89',
        'long': 'Other specified disorders of urinary tract',
        'short': 'Oth spcf dsdr urnry trct'},
       {'code': '599.9',
        'long': 'Unspecified disorder of urethra and urinary tract',
        'short': 'Urinary tract dis NOS'},
       {'code': '600.00',
        'long': 'Hypertrophy (benign) of prostate without urinary obstruction and other lower urinary tract symptom (LUTS)',
        'short': 'BPH w/o urinary obs/LUTS'},
       {'code': '600.01',
        'long': 'Hypertrophy (benign) of prostate with urinary obstruction and other lower urinary tract symptoms (LUTS)',
        'short': 'BPH w urinary obs/LUTS'},
       {'code': '600.10',
        'long': 'Nodular prostate without urinary obstruction',
        'short': 'Nod prostate w/o ur obst'},
       {'code': '600.11',
        'long': 'Nodular prostate with urinary obstruction',
        'short': 'Nod prostate w ur obst'},
       {'code': '600.20',
        'long': 'Benign localized hyperplasia of prostate without urinary obstruction and other lower urinary tract symptoms (LUTS)',
        'short': 'BPH loc w/o ur obs/LUTS'},
       {'code': '600.21',
        'long': 'Benign localized hyperplasia of prostate with urinary obstruction and other lower urinary tract symptoms (LUTS)',
        'short': 'BPH loc w urin obs/LUTS'},
       {'code': '600.3',
        'long': 'Cyst of prostate',
        'short': 'Cyst of prostate'},
       {'code': '600.90',
        'long': 'Hyperplasia of prostate, unspecified, without urinary obstruction and other lower urinary symptoms (LUTS)',
        'short': 'BPH NOS w/o ur obs/LUTS'},
       {'code': '600.91',
        'long': 'Hyperplasia of prostate, unspecified, with urinary obstruction and other lower urinary symptoms (LUTS)',
        'short': 'BPH NOS w ur obs/LUTS'},
       {'code': '601.0',
        'long': 'Acute prostatitis',
        'short': 'Acute prostatitis'},
       {'code': '601.1',
        'long': 'Chronic prostatitis',
        'short': 'Chronic prostatitis'},
       {'code': '601.2',
        'long': 'Abscess of prostate',
        'short': 'Abscess of prostate'},
       {'code': '601.3',
        'long': 'Prostatocystitis',
        'short': 'Prostatocystitis'},
       {'code': '601.4',
        'long': 'Prostatitis in diseases classified elsewhere',
        'short': 'Prostatitis in oth dis'},
       {'code': '601.8',
        'long': 'Other specified inflammatory diseases of prostate',
        'short': 'Prostatic inflam dis NEC'},
       {'code': '601.9',
        'long': 'Prostatitis, unspecified',
        'short': 'Prostatitis NOS'},
       {'code': '602.0',
        'long': 'Calculus of prostate',
        'short': 'Calculus of prostate'},
       {'code': '602.1',
        'long': 'Congestion or hemorrhage of prostate',
        'short': 'Prostatic congest/hemorr'},
       {'code': '602.2',
        'long': 'Atrophy of prostate',
        'short': 'Atrophy of prostate'},
       {'code': '602.3',
        'long': 'Dysplasia of prostate',
        'short': 'Dysplasia of prostate'},
       {'code': '602.8',
        'long': 'Other specified disorders of prostate',
        'short': 'Prostatic disorders NEC'},
       {'code': '602.9',
        'long': 'Unspecified disorder of prostate',
        'short': 'Prostatic disorder NOS'},
       {'code': '603.0',
        'long': 'Encysted hydrocele',
        'short': 'Encysted hydrocele'},
       {'code': '603.1',
        'long': 'Infected hydrocele',
        'short': 'Infected hydrocele'},
       {'code': '603.8',
        'long': 'Other specified types of hydrocele',
        'short': 'Hydrocele NEC'},
       {'code': '603.9',
        'long': 'Hydrocele, unspecified',
        'short': 'Hydrocele NOS'},
       {'code': '604.0',
        'long': 'Orchitis, epididymitis, and epididymo-orchitis, with abscess',
        'short': 'Orchitis with abscess'},
       {'code': '604.90',
        'long': 'Orchitis and epididymitis, unspecified',
        'short': 'Orchitis/epididymit NOS'},
       {'code': '604.91',
        'long': 'Orchitis and epididymitis in diseases classified elsewhere',
        'short': 'Orchitis in oth disease'},
       {'code': '604.99',
        'long': 'Other orchitis, epididymitis, and epididymo-orchitis, without mention of abscess',
        'short': 'Orchitis/epididymit NEC'},
       {'code': '605',
        'long': 'Redundant prepuce and phimosis',
        'short': 'Redun prepuce & phimosis'},
       {'code': '606.0', 'long': 'Azoospermia', 'short': 'Azoospermia'},
       {'code': '606.1', 'long': 'Oligospermia', 'short': 'Oligospermia'},
       {'code': '606.8',
        'long': 'Infertility due to extratesticular causes',
        'short': 'Male infertility NEC'},
       {'code': '606.9',
        'long': 'Male infertility, unspecified',
        'short': 'Male infertility NOS'},
       {'code': '607.0',
        'long': 'Leukoplakia of penis',
        'short': 'Leukoplakia of penis'},
       {'code': '607.1',
        'long': 'Balanoposthitis',
        'short': 'Balanoposthitis'},
       {'code': '607.2',
        'long': 'Other inflammatory disorders of penis',
        'short': 'Inflam dis, penis NEC'},
       {'code': '607.3', 'long': 'Priapism', 'short': 'Priapism'},
       {'code': '607.81',
        'long': 'Balanitis xerotica obliterans',
        'short': 'Balanitis xerotica oblit'},
       {'code': '607.82',
        'long': 'Vascular disorders of penis',
        'short': 'Vascular disorder, penis'},
       {'code': '607.83',
        'long': 'Edema of penis',
        'short': 'Edema of penis'},
       {'code': '607.84',
        'long': 'Impotence of organic origin',
        'short': 'Impotence, organic orign'},
       {'code': '607.85',
        'long': "Peyronie's disease",
        'short': "Peyronie's disease"},
       {'code': '607.89',
        'long': 'Other specified disorders of penis',
        'short': 'Disorder of penis NEC'},
       {'code': '607.9',
        'long': 'Unspecified disorder of penis',
        'short': 'Disorder of penis NOS'},
       {'code': '608.0',
        'long': 'Seminal vesiculitis',
        'short': 'Seminal vesiculitis'},
       {'code': '608.1', 'long': 'Spermatocele', 'short': 'Spermatocele'},
       {'code': '608.20',
        'long': 'Torsion of testis, unspecified',
        'short': 'Torsion of testis NOS'},
       {'code': '608.21',
        'long': 'Extravaginal torsion of spermatic cord',
        'short': 'Extravag tors sperm cord'},
       {'code': '608.22',
        'long': 'Intravaginal torsion of spermatic cord',
        'short': 'Intravag tors sperm cord'},
       {'code': '608.23',
        'long': 'Torsion of appendix testis',
        'short': 'Torsion appendix testis'},
       {'code': '608.24',
        'long': 'Torsion of appendix epididymis',
        'short': 'Torsion appy epididymis'},
       {'code': '608.3',
        'long': 'Atrophy of testis',
        'short': 'Atrophy of testis'},
       {'code': '608.4',
        'long': 'Other inflammatory disorders of male genital organs',
        'short': 'Male gen inflam dis NEC'},
       {'code': '608.81',
        'long': 'Disorders of male genital organs in diseases classified elsewhere',
        'short': 'Male gen dis in oth dis'},
       {'code': '608.82', 'long': 'Hematospermia', 'short': 'Hematospermia'},
       {'code': '608.83',
        'long': 'Vascular disorders of male genital organs',
        'short': 'Male gen vascul dis NEC'},
       {'code': '608.84',
        'long': 'Chylocele of tunica vaginalis',
        'short': 'Chylocele, tunic vaginal'},
       {'code': '608.85',
        'long': 'Stricture of male genital organs',
        'short': 'Stricture, male gen orgn'},
       {'code': '608.86',
        'long': 'Edema of male genital organs',
        'short': 'Edema, male genital orgn'},
       {'code': '608.87',
        'long': 'Retrograde ejaculation',
        'short': 'Retrograde ejaculation'},
       {'code': '608.89',
        'long': 'Other specified disorders of male genital organs',
        'short': 'Male genital dis NEC'},
       {'code': '608.9',
        'long': 'Unspecified disorder of male genital organs',
        'short': 'Male genital dis NOS'},
       {'code': '610.0',
        'long': 'Solitary cyst of breast',
        'short': 'Solitary cyst of breast'},
       {'code': '610.1',
        'long': 'Diffuse cystic mastopathy',
        'short': 'Diffus cystic mastopathy'},
       {'code': '610.2',
        'long': 'Fibroadenosis of breast',
        'short': 'Fibroadenosis of breast'},
       {'code': '610.3',
        'long': 'Fibrosclerosis of breast',
        'short': 'Fibrosclerosis of breast'},
       {'code': '610.4',
        'long': 'Mammary duct ectasia',
        'short': 'Mammary duct ectasia'},
       {'code': '610.8',
        'long': 'Other specified benign mammary dysplasias',
        'short': 'Benign mamm dysplas NEC'},
       {'code': '610.9',
        'long': 'Benign mammary dysplasia, unspecified',
        'short': 'Benign mamm dysplas NOS'},
       {'code': '611.0',
        'long': 'Inflammatory disease of breast',
        'short': 'Inflam disease of breast'},
       {'code': '611.1',
        'long': 'Hypertrophy of breast',
        'short': 'Hypertrophy of breast'},
       {'code': '611.2',
        'long': 'Fissure of nipple',
        'short': 'Fissure of nipple'},
       {'code': '611.3',
        'long': 'Fat necrosis of breast',
        'short': 'Fat necrosis of breast'},
       {'code': '611.4',
        'long': 'Atrophy of breast',
        'short': 'Atrophy of breast'},
       {'code': '611.5', 'long': 'Galactocele', 'short': 'Galactocele'},
       {'code': '611.6',
        'long': 'Galactorrhea not associated with childbirth',
        'short': 'Galactorrhea-nonobstet'},
       {'code': '611.71', 'long': 'Mastodynia', 'short': 'Mastodynia'},
       {'code': '611.72',
        'long': 'Lump or mass in breast',
        'short': 'Lump or mass in breast'},
       {'code': '611.79',
        'long': 'Other signs and symptoms in breast',
        'short': 'Symptoms in breast NEC'},
       {'code': '611.81',
        'long': 'Ptosis of breast',
        'short': 'Ptosis of breast'},
       {'code': '611.82',
        'long': 'Hypoplasia of breast',
        'short': 'Hypoplasia of breast'},
       {'code': '611.83',
        'long': 'Capsular contracture of breast implant',
        'short': 'Capslr contrctr brst imp'},
       {'code': '611.89',
        'long': 'Other specified disorders of breast',
        'short': 'Disorders breast NEC'},
       {'code': '611.9',
        'long': 'Unspecified breast disorder',
        'short': 'Breast disorder NOS'},
       {'code': '612.0',
        'long': 'Deformity of reconstructed breast',
        'short': 'Deformity reconst breast'},
       {'code': '612.1',
        'long': 'Disproportion of reconstructed breast',
        'short': 'Disproportn reconst brst'},
       {'code': '614.0',
        'long': 'Acute salpingitis and oophoritis',
        'short': 'Ac salpingo-oophoritis'},
       {'code': '614.1',
        'long': 'Chronic salpingitis and oophoritis',
        'short': 'Chr salpingo-oophoritis'},
       {'code': '614.2',
        'long': 'Salpingitis and oophoritis not specified as acute, subacute, or chronic',
        'short': 'Salpingo-oophoritis NOS'},
       {'code': '614.3',
        'long': 'Acute parametritis and pelvic cellulitis',
        'short': 'Acute parametritis'},
       {'code': '614.4',
        'long': 'Chronic or unspecified parametritis and pelvic cellulitis',
        'short': 'Chronic parametritis'},
       {'code': '614.5',
        'long': 'Acute or unspecified pelvic peritonitis, female',
        'short': 'Ac pelv peritonitis-fem'},
       {'code': '614.6',
        'long': 'Pelvic peritoneal adhesions, female (postoperative) (postinfection)',
        'short': 'Fem pelvic periton adhes'},
       {'code': '614.7',
        'long': 'Other chronic pelvic peritonitis, female',
        'short': 'Chr pelv periton NEC-fem'},
       {'code': '614.8',
        'long': 'Other specified inflammatory disease of female pelvic organs and tissues',
        'short': 'Fem pelv inflam dis NEC'},
       {'code': '614.9',
        'long': 'Unspecified inflammatory disease of female pelvic organs and tissues',
        'short': 'Fem pelv inflam dis NOS'},
       {'code': '615.0',
        'long': 'Acute inflammatory diseases of uterus, except cervix',
        'short': 'Ac uterine inflammation'},
       {'code': '615.1',
        'long': 'Chronic inflammatory diseases of uterus, except cervix',
        'short': 'Chr uterine inflammation'},
       {'code': '615.9',
        'long': 'Unspecified inflammatory disease of uterus',
        'short': 'Uterine inflam dis NOS'},
       {'code': '616.0',
        'long': 'Cervicitis and endocervicitis',
        'short': 'Cervicitis'},
       {'code': '616.10',
        'long': 'Vaginitis and vulvovaginitis, unspecified',
        'short': 'Vaginitis NOS'},
       {'code': '616.11',
        'long': 'Vaginitis and vulvovaginitis in diseases classified elsewhere',
        'short': 'Vaginitis in oth disease'},
       {'code': '616.2',
        'long': "Cyst of Bartholin's gland",
        'short': "Bartholin's gland cyst"},
       {'code': '616.3',
        'long': "Abscess of Bartholin's gland",
        'short': "Bartholin's glnd abscess"},
       {'code': '616.4',
        'long': 'Other abscess of vulva',
        'short': 'Abscess of vulva NEC'},
       {'code': '616.50',
        'long': 'Ulceration of vulva, unspecified',
        'short': 'Ulceration of vulva NOS'},
       {'code': '616.51',
        'long': 'Ulceration of vulva in diseases classified elsewhere',
        'short': 'Vulvar ulcer in oth dis'},
       {'code': '616.81',
        'long': 'Mucositis (ulcerative) of cervix, vagina, and vulva',
        'short': 'Mucositis cerv,vag,vulva'},
       {'code': '616.89',
        'long': 'Other inflammatory disease of cervix, vagina and vulva',
        'short': 'Inflm cerv,vag,vulva NEC'},
       {'code': '616.9',
        'long': 'Unspecified inflammatory disease of cervix, vagina, and vulva',
        'short': 'Female gen inflam NOS'},
       {'code': '617.0',
        'long': 'Endometriosis of uterus',
        'short': 'Uterine endometriosis'},
       {'code': '617.1',
        'long': 'Endometriosis of ovary',
        'short': 'Ovarian endometriosis'},
       {'code': '617.2',
        'long': 'Endometriosis of fallopian tube',
        'short': 'Tubal endometriosis'},
       {'code': '617.3',
        'long': 'Endometriosis of pelvic peritoneum',
        'short': 'Pelv perit endometriosis'},
       {'code': '617.4',
        'long': 'Endometriosis of rectovaginal septum and vagina',
        'short': 'Vaginal endometriosis'},
       {'code': '617.5',
        'long': 'Endometriosis of intestine',
        'short': 'Intestinal endometriosis'},
       {'code': '617.6',
        'long': 'Endometriosis in scar of skin',
        'short': 'Endometriosis in scar'},
       {'code': '617.8',
        'long': 'Endometriosis of other specified sites',
        'short': 'Endometriosis NEC'},
       {'code': '617.9',
        'long': 'Endometriosis, site unspecified',
        'short': 'Endometriosis NOS'},
       {'code': '618.00',
        'long': 'Unspecified prolapse of vaginal walls',
        'short': 'Vaginal wall prolpse NOS'},
       {'code': '618.01',
        'long': 'Cystocele, midline',
        'short': 'Cystocele, midline'},
       {'code': '618.02',
        'long': 'Cystocele, lateral',
        'short': 'Cystocele, lateral'},
       {'code': '618.03', 'long': 'Urethrocele', 'short': 'Urethrocele'},
       {'code': '618.04', 'long': 'Rectocele', 'short': 'Rectocele'},
       {'code': '618.05', 'long': 'Perineocele', 'short': 'Perineocele'},
       {'code': '618.09',
        'long': 'Other prolapse of vaginal walls without mention of uterine prolapse',
        'short': 'Cystourethrocele'},
       {'code': '618.1',
        'long': 'Uterine prolapse without mention of vaginal wall prolapse',
        'short': 'Uterine prolapse'},
       {'code': '618.2',
        'long': 'Uterovaginal prolapse, incomplete',
        'short': 'Uterovag prolaps-incompl'},
       {'code': '618.3',
        'long': 'Uterovaginal prolapse, complete',
        'short': 'Uterovag prolaps-complet'},
       {'code': '618.4',
        'long': 'Uterovaginal prolapse, unspecified',
        'short': 'Utervaginal prolapse NOS'},
       {'code': '618.5',
        'long': 'Prolapse of vaginal vault after hysterectomy',
        'short': 'Postop vaginal prolapse'},
       {'code': '618.6',
        'long': 'Vaginal enterocele, congenital or acquired',
        'short': 'Vaginal enterocele'},
       {'code': '618.7',
        'long': 'Old laceration of muscles of pelvic floor',
        'short': 'Old lacer pelvic muscle'},
       {'code': '618.81',
        'long': 'Incompetence or weakening of pubocervical tissue',
        'short': 'Incomptnce pubocerv tiss'},
       {'code': '618.82',
        'long': 'Incompetence or weakening of rectovaginal tissue',
        'short': 'Incomptnce rectovag tiss'},
       {'code': '618.83',
        'long': 'Pelvic muscle wasting',
        'short': 'Pelvic muscle wasting'},
       {'code': '618.84',
        'long': 'Cervical stump prolapse',
        'short': 'Cervical stump prolapse'},
       {'code': '618.89',
        'long': 'Other specified genital prolapse',
        'short': 'Genital prolapse NEC'},
       {'code': '618.9',
        'long': 'Unspecified genital prolapse',
        'short': 'Genital prolapse NOS'},
       {'code': '619.0',
        'long': 'Urinary-genital tract fistula, female',
        'short': 'Urin-genital fistul, fem'},
       {'code': '619.1',
        'long': 'Digestive-genital tract fistula, female',
        'short': 'Digest-genit fistul, fem'},
       {'code': '619.2',
        'long': 'Genital tract-skin fistula, female',
        'short': 'Genital-skin fistul, fem'},
       {'code': '619.8',
        'long': 'Other specified fistulas involving female genital tract',
        'short': 'Fem genital fistula NEC'},
       {'code': '619.9',
        'long': 'Unspecified fistula involving female genital tract',
        'short': 'Fem genital fistula NOS'},
       {'code': '620.0',
        'long': 'Follicular cyst of ovary',
        'short': 'Follicular cyst of ovary'},
       {'code': '620.1',
        'long': 'Corpus luteum cyst or hematoma',
        'short': 'Corpus luteum cyst'},
       {'code': '620.2',
        'long': 'Other and unspecified ovarian cyst',
        'short': 'Ovarian cyst NEC/NOS'},
       {'code': '620.3',
        'long': 'Acquired atrophy of ovary and fallopian tube',
        'short': 'Acq atrophy ovary & tube'},
       {'code': '620.4',
        'long': 'Prolapse or hernia of ovary and fallopian tube',
        'short': 'Prolapse of ovary & tube'},
       {'code': '620.5',
        'long': 'Torsion of ovary, ovarian pedicle, or fallopian tube',
        'short': 'Torsion of ovary or tube'},
       {'code': '620.6',
        'long': 'Broad ligament laceration syndrome',
        'short': 'Broad ligament lacer syn'},
       {'code': '620.7',
        'long': 'Hematoma of broad ligament',
        'short': 'Broad ligament hematoma'},
       {'code': '620.8',
        'long': 'Other noninflammatory disorders of ovary, fallopian tube, and broad ligament',
        'short': 'Noninfl dis ova/adnx NEC'},
       {'code': '620.9',
        'long': 'Unspecified noninflammatory disorder of ovary, fallopian tube, and broad ligament',
        'short': 'Noninfl dis ova/adnx NOS'},
       {'code': '621.0',
        'long': 'Polyp of corpus uteri',
        'short': 'Polyp of corpus uteri'},
       {'code': '621.1',
        'long': 'Chronic subinvolution of uterus',
        'short': 'Chr uterine subinvolutn'},
       {'code': '621.2',
        'long': 'Hypertrophy of uterus',
        'short': 'Hypertrophy of uterus'},
       {'code': '621.30',
        'long': 'Endometrial hyperplasia, unspecified',
        'short': 'Endometrial hyperpla NOS'},
       {'code': '621.31',
        'long': 'Simple endometrial hyperplasia without atypia',
        'short': 'Simp endo hyper w/o atyp'},
       {'code': '621.32',
        'long': 'Complex endometrial hyperplasia without atypia',
        'short': 'Comp endo hyper w/o atyp'},
       {'code': '621.33',
        'long': 'Endometrial hyperplasia with atypia',
        'short': 'Endomet hyperpla w atyp'},
       {'code': '621.34',
        'long': 'Benign endometrial hyperplasia',
        'short': 'Ben endomet hyperplasia'},
       {'code': '621.35',
        'long': 'Endometrial intraepithelial neoplasia [EIN]',
        'short': 'Endomet intraepithl neop'},
       {'code': '621.4', 'long': 'Hematometra', 'short': 'Hematometra'},
       {'code': '621.5',
        'long': 'Intrauterine synechiae',
        'short': 'Intrauterine synechiae'},
       {'code': '621.6',
        'long': 'Malposition of uterus',
        'short': 'Malposition of uterus'},
       {'code': '621.7',
        'long': 'Chronic inversion of uterus',
        'short': 'Chr inversion of uterus'},
       {'code': '621.8',
        'long': 'Other specified disorders of uterus, not elsewhere classified',
        'short': 'Disorders of uterus NEC'},
       {'code': '621.9',
        'long': 'Unspecified disorder of uterus',
        'short': 'Disorder of uterus NOS'},
       {'code': '622.0',
        'long': 'Erosion and ectropion of cervix',
        'short': 'Erosion/ectropion cervix'},
       {'code': '622.10',
        'long': 'Dysplasia of cervix, unspecified',
        'short': 'Dysplasia of cervix NOS'},
       {'code': '622.11',
        'long': 'Mild dysplasia of cervix',
        'short': 'Mild dysplasia of cervix'},
       {'code': '622.12',
        'long': 'Moderate dysplasia of cervix',
        'short': 'Mod dysplasia of cervix'},
       {'code': '622.2',
        'long': 'Leukoplakia of cervix (uteri)',
        'short': 'Leukoplakia of cervix'},
       {'code': '622.3',
        'long': 'Old laceration of cervix',
        'short': 'Old laceration of cervix'},
       {'code': '622.4',
        'long': 'Stricture and stenosis of cervix',
        'short': 'Stricture of cervix'},
       {'code': '622.5',
        'long': 'Incompetence of cervix',
        'short': 'Incompetence of cervix'},
       {'code': '622.6',
        'long': 'Hypertrophic elongation of cervix',
        'short': 'Hypertrophic elong cervx'},
       {'code': '622.7',
        'long': 'Mucous polyp of cervix',
        'short': 'Mucous polyp of cervix'},
       {'code': '622.8',
        'long': 'Other specified noninflammatory disorders of cervix',
        'short': 'Noninflam dis cervix NEC'},
       {'code': '622.9',
        'long': 'Unspecified noninflammatory disorder of cervix',
        'short': 'Noninflam dis cervix NOS'},
       {'code': '623.0',
        'long': 'Dysplasia of vagina',
        'short': 'Dysplasia of vagina'},
       {'code': '623.1',
        'long': 'Leukoplakia of vagina',
        'short': 'Leukoplakia of vagina'},
       {'code': '623.2',
        'long': 'Stricture or atresia of vagina',
        'short': 'Stricture of vagina'},
       {'code': '623.3',
        'long': 'Tight hymenal ring',
        'short': 'Tight hymenal ring'},
       {'code': '623.4',
        'long': 'Old vaginal laceration',
        'short': 'Old vaginal laceration'},
       {'code': '623.5',
        'long': 'Leukorrhea, not specified as infective',
        'short': 'Noninfect vag leukorrhea'},
       {'code': '623.6',
        'long': 'Vaginal hematoma',
        'short': 'Vaginal hematoma'},
       {'code': '623.7',
        'long': 'Polyp of vagina',
        'short': 'Polyp of vagina'},
       {'code': '623.8',
        'long': 'Other specified noninflammatory disorders of vagina',
        'short': 'Noninflam dis vagina NEC'},
       {'code': '623.9',
        'long': 'Unspecified noninflammatory disorder of vagina',
        'short': 'Noninflam dis vagina NOS'},
       {'code': '624.01',
        'long': 'Vulvar intraepithelial neoplasia I [VIN I]',
        'short': 'Vulvar intraeph neopl I'},
       {'code': '624.02',
        'long': 'Vulvar intraepithelial neoplasia II [VIN II]',
        'short': 'Vulvr intraepth neopl II'},
       {'code': '624.09',
        'long': 'Other dystrophy of vulva',
        'short': 'Dystrophy of vulva NEC'},
       {'code': '624.1',
        'long': 'Atrophy of vulva',
        'short': 'Atrophy of vulva'},
       {'code': '624.2',
        'long': 'Hypertrophy of clitoris',
        'short': 'Hypertrophy of clitoris'},
       {'code': '624.3',
        'long': 'Hypertrophy of labia',
        'short': 'Hypertrophy of labia'},
       {'code': '624.4',
        'long': 'Old laceration or scarring of vulva',
        'short': 'Old laceration of vulva'},
       {'code': '624.5',
        'long': 'Hematoma of vulva',
        'short': 'Hematoma of vulva'},
       {'code': '624.6',
        'long': 'Polyp of labia and vulva',
        'short': 'Polyp of labia and vulva'},
       {'code': '624.8',
        'long': 'Other specified noninflammatory disorders of vulva and perineum',
        'short': 'Noninflam dis vulva NEC'},
       {'code': '624.9',
        'long': 'Unspecified noninflammatory disorder of vulva and perineum',
        'short': 'Noninflam dis vulva NOS'},
       {'code': '625.0', 'long': 'Dyspareunia', 'short': 'Dyspareunia'},
       {'code': '625.1', 'long': 'Vaginismus', 'short': 'Vaginismus'},
       {'code': '625.2', 'long': 'Mittelschmerz', 'short': 'Mittelschmerz'},
       {'code': '625.3', 'long': 'Dysmenorrhea', 'short': 'Dysmenorrhea'},
       {'code': '625.4',
        'long': 'Premenstrual tension syndromes',
        'short': 'Premenstrual tension'},
       {'code': '625.5',
        'long': 'Pelvic congestion syndrome',
        'short': 'Pelvic congestion synd'},
       {'code': '625.6',
        'long': 'Stress incontinence, female',
        'short': 'Fem stress incontinence'},
       {'code': '625.70',
        'long': 'Vulvodynia, unspecified',
        'short': 'Vulvodynia NOS'},
       {'code': '625.71',
        'long': 'Vulvar vestibulitis',
        'short': 'Vulvar vestibulitis'},
       {'code': '625.79',
        'long': 'Other vulvodynia',
        'short': 'Other vulvodynia'},
       {'code': '625.8',
        'long': 'Other specified symptoms associated with female genital organs',
        'short': 'Fem genital symptoms NEC'},
       {'code': '625.9',
        'long': 'Unspecified symptom associated with female genital organs',
        'short': 'Fem genital symptoms NOS'},
       {'code': '626.0',
        'long': 'Absence of menstruation',
        'short': 'Absence of menstruation'},
       {'code': '626.1',
        'long': 'Scanty or infrequent menstruation',
        'short': 'Scanty menstruation'},
       {'code': '626.2',
        'long': 'Excessive or frequent menstruation',
        'short': 'Excessive menstruation'},
       {'code': '626.3',
        'long': 'Puberty bleeding',
        'short': 'Pubertal menorrhagia'},
       {'code': '626.4',
        'long': 'Irregular menstrual cycle',
        'short': 'Irregular menstruation'},
       {'code': '626.5',
        'long': 'Ovulation bleeding',
        'short': 'Ovulation bleeding'},
       {'code': '626.6', 'long': 'Metrorrhagia', 'short': 'Metrorrhagia'},
       {'code': '626.7',
        'long': 'Postcoital bleeding',
        'short': 'Postcoital bleeding'},
       {'code': '626.8',
        'long': 'Other disorders of menstruation and other abnormal bleeding from female genital tract',
        'short': 'Menstrual disorder NEC'},
       {'code': '626.9',
        'long': 'Unspecified disorders of menstruation and other abnormal bleeding from female genital tract',
        'short': 'Menstrual disorder NOS'},
       {'code': '627.0',
        'long': 'Premenopausal menorrhagia',
        'short': 'Premenopause menorrhagia'},
       {'code': '627.1',
        'long': 'Postmenopausal bleeding',
        'short': 'Postmenopausal bleeding'},
       {'code': '627.2',
        'long': 'Symptomatic menopausal or female climacteric states',
        'short': 'Sympt fem climact state'},
       {'code': '627.3',
        'long': 'Postmenopausal atrophic vaginitis',
        'short': 'Atrophic vaginitis'},
       {'code': '627.4',
        'long': 'Symptomatic states associated with artificial menopause',
        'short': 'Sympt state w artif meno'},
       {'code': '627.8',
        'long': 'Other specified menopausal and postmenopausal disorders',
        'short': 'Menopausal disorder NEC'},
       {'code': '627.9',
        'long': 'Unspecified menopausal and postmenopausal disorder',
        'short': 'Menopausal disorder NOS'},
       {'code': '628.0',
        'long': 'Infertility, female, associated with anovulation',
        'short': 'Infertility-anovulation'},
       {'code': '628.1',
        'long': 'Infertility, female, of pituitary-hypothalamic origin',
        'short': 'Infertil-pituitary orig'},
       {'code': '628.2',
        'long': 'Infertility, female, of tubal origin',
        'short': 'Infertility-tubal origin'},
       {'code': '628.3',
        'long': 'Infertility, female, of uterine origin',
        'short': 'Infertility-uterine orig'},
       {'code': '628.4',
        'long': 'Infertility, female, of cervical or vaginal origin',
        'short': 'Infertil-cervical orig'},
       {'code': '628.8',
        'long': 'Infertility, female, of other specified origin',
        'short': 'Female infertility NEC'},
       {'code': '628.9',
        'long': 'Infertility, female, of unspecified origin',
        'short': 'Female infertility NOS'},
       {'code': '629.0',
        'long': 'Hematocele, female, not elsewhere classified',
        'short': 'Hematocele, female NEC'},
       {'code': '629.1',
        'long': 'Hydrocele, canal of nuck',
        'short': 'Hydrocele canal nuck-fem'},
       {'code': '629.20',
        'long': 'Female genital mutilation status, unspecified',
        'short': 'Genital mutilation NOS'},
       {'code': '629.21',
        'long': 'Female genital mutilation Type I status',
        'short': 'Genital mutilatn type I'},
       {'code': '629.22',
        'long': 'Female genital mutilation Type II status',
        'short': 'Genital mutilatn type II'},
       {'code': '629.23',
        'long': 'Female genital mutilation Type III status',
        'short': 'Genital muilatn type III'},
       {'code': '629.29',
        'long': 'Other female genital mutilation status',
        'short': 'Fem genital mutilate NEC'},
       {'code': '629.31',
        'long': 'Erosion of implanted vaginal mesh and other prosthetic materials to surrounding organ or tissue',
        'short': 'Eros imp vag mesh in tis'},
       {'code': '629.32',
        'long': 'Exposure of implanted vaginal mesh and other prosthetic materials into vagina',
        'short': 'Exp imp vag mesh-vagina'},
       {'code': '629.81',
        'long': 'Recurrent pregnancy loss without current pregnancy',
        'short': 'Rec preg loss wo cur prg'},
       {'code': '629.89',
        'long': 'Other specified disorders of female genital organs',
        'short': 'Female genital disor NEC'},
       {'code': '629.9',
        'long': 'Unspecified disorder of female genital organs',
        'short': 'Female genital dis NOS'}],
 'O': [{'code': '630',
        'long': 'Hydatidiform mole',
        'short': 'Hydatidiform mole'},
       {'code': '631.0',
        'long': 'Inappropriate change in quantitative human chorionic gonadotropin (hCG) in early pregnancy',
        'short': 'Inapp chg hCG early preg'},
       {'code': '631.8',
        'long': 'Other abnormal products of conception',
        'short': 'Oth abn prod conception'},
       {'code': '632', 'long': 'Missed abortion', 'short': 'Missed abortion'},
       {'code': '633.00',
        'long': 'Abdominal pregnancy without intrauterine pregnancy',
        'short': 'Abd preg w/o intrau preg'},
       {'code': '633.01',
        'long': 'Abdominal pregnancy with intrauterine pregnancy',
        'short': 'Abd preg w intraut preg'},
       {'code': '633.10',
        'long': 'Tubal pregnancy without intrauterine pregnancy',
        'short': 'Tubal preg w/o intra prg'},
       {'code': '633.11',
        'long': 'Tubal pregnancy with intrauterine pregnancy',
        'short': 'Tubal preg w intra preg'},
       {'code': '633.20',
        'long': 'Ovarian pregnancy without intrauterine pregnancy',
        'short': 'Ovarn preg w/o intra prg'},
       {'code': '633.21',
        'long': 'Ovarian pregnancy with intrauterine pregnancy',
        'short': 'Ovarian preg w intra prg'},
       {'code': '633.80',
        'long': 'Other ectopic pregnancy without intrauterine pregnancy',
        'short': 'Ect preg NEC w/o int prg'},
       {'code': '633.81',
        'long': 'Other ectopic pregnancy with intrauterine pregnancy',
        'short': 'Ectpc prg NEC w int preg'},
       {'code': '633.90',
        'long': 'Unspecified ectopic pregnancy without intrauterine pregnancy',
        'short': 'Ect preg NOS w/o int prg'},
       {'code': '633.91',
        'long': 'Unspecified ectopic pregnancy with intrauterine pregnancy',
        'short': 'Ectp preg NOS w int preg'},
       {'code': '634.00',
        'long': 'Spontaneous abortion, complicated by genital tract and pelvic infection, unspecified',
        'short': 'Spon abor w pel inf-unsp'},
       {'code': '634.01',
        'long': 'Spontaneous abortion, complicated by genital tract and pelvic infection, incomplete',
        'short': 'Spon abor w pelv inf-inc'},
       {'code': '634.02',
        'long': 'Spontaneous abortion, complicated by genital tract and pelvic infection, complete',
        'short': 'Spon abor w pel inf-comp'},
       {'code': '634.10',
        'long': 'Spontaneous abortion, complicated by delayed or excessive hemorrhage, unspecified',
        'short': 'Spon abort w hemorr-unsp'},
       {'code': '634.11',
        'long': 'Spontaneous abortion, complicated by delayed or excessive hemorrhage, incomplete',
        'short': 'Spon abort w hemorr-inc'},
       {'code': '634.12',
        'long': 'Spontaneous abortion, complicated by delayed or excessive hemorrhage, complete',
        'short': 'Spon abort w hemorr-comp'},
       {'code': '634.20',
        'long': 'Spontaneous abortion, complicated by damage to pelvic organs or tissues, unspecified',
        'short': 'Spon ab w pel damag-unsp'},
       {'code': '634.21',
        'long': 'Spontaneous abortion, complicated by damage to pelvic organs or tissues, incomplete',
        'short': 'Spon ab w pelv damag-inc'},
       {'code': '634.22',
        'long': 'Spontaneous abortion, complicated by damage to pelvic organs or tissues, complete',
        'short': 'Spon ab w pel damag-comp'},
       {'code': '634.30',