
# -*- coding: utf-8 -*-

u'''A Python version of part of I{Karney}'s C++ module U{GeodesicExactC4
<https://GeographicLib.SourceForge.io/html/classGeographicLib_1_1GeodesicExactC4.html>}.

Copyright (C) Charles Karney (2012-2016) <Charles@Karney.com>
and licensed under the MIT/X11 License.  For more information,
see U{GeographicLib<https://GeographicLib.SourceForge.io>}.
'''
# See C{.geodesicx._C4_30.py} for a copy of comments from Karney's C{GeodesicExactC4.cpp}:

from pygeodesy.geodesicx.gxbases import _f, _f2

__all__ = ()
__version__ = '21.06.04'

_coeffs_27 = (  # GEOGRAPHICLIB_GEODESICEXACT_ORDER == 27
    # Generated by Maxima on 2017-05-27 10:17:57-04:00
    # C4[0], coeff of eps^26, polynomial in n of order 0
    4654, _f(327806325),
    # C4[0], coeff of eps^25, polynomial in n of order 1
    -331600, 247203, _f(5135632425),
    # C4[0], coeff of eps^24, polynomial in n of order 2
    -_f(30660788480), _f(15209307520), _f(3757742824),
    _f(0xbd65c2e6062d),
    # C4[0], coeff of eps^23, polynomial in n of order 3
    -_f(0x4a56872d110), _f(0x30d818a0d20), -_f(0x183639ebbb0),
    _f(0x1207973318d), _f(0x472c0a3d3d1ee9),
    # C4[0], coeff of eps^22, polynomial in n of order 4
    -_f(0x743607eea80), _f(0x5536ade42a0), -_f(0x37e9933c940),
    _f(0x1bb15f964e0), _f(469120197546), _f(0x472c0a3d3d1ee9),
    # C4[0], coeff of eps^21, polynomial in n of order 5
    -_f(0x1a80e82073690), _f(0x1485d9e7af5c0), -_f(0xf039fc9e8ff0),
    _f(0x9d5f26153ce0), -_f(0x4ddf0f750f50), _f(0x39e793daa6eb),
    _f(0xadde5e94360277d),
    # C4[0], coeff of eps^20, polynomial in n of order 6
    -_f(0xe72f9d31220580), _f(0xb817a196612bc0),
    -_f(0x8e0a680913c900), _f(0x67a3067b290a40),
    -_f(0x43c43707776c80), _f(0x217ef7b84400c0),
    _f(0x83b895ad56e94), _f2(16517, 0x8519000aea763),
    # C4[0], coeff of eps^19, polynomial in n of order 7
    -_f(0x5be35cb0a188d670), _f(0x49fb9f6e0e1fa420),
    -_f(0x3a970b1601b36050), _f(0x2d0406e3051baec0),
    -_f(0x20bde41e80026c30), _f(0x155cea808b65d160),
    -_f(0xa8bc4b2c853c610), _f(0x7d3acd77deac86f),
    _f2(1139708, 0xdfbd02f131daf),
    # C4[0], coeff of eps^18, polynomial in n of order 8
    -_f2(2219, 0x955c84d349100), _f(0x6f523368eabed3a0),
    -_f(0x58df9f4050ea48c0), _f(0x45eb9b162449f0e0),
    -_f(0x35736f4da3b86880), _f(0x26bb8b2d01772220),
    -_f(0x19350a3e2b857840), _f(0xc6cd21a34a65f60),
    _f(0x30a9f24aaae2862), _f2(1139708, 0xdfbd02f131daf),
    # C4[0], coeff of eps^17, polynomial in n of order 9
    -_f2(3520, 0x86c418e66b430), _f2(2768, 0x78979286ec480),
    -_f2(2191, 0xabc9bb4d59ed0), _f(0x6c38e96882e6a560),
    -_f(0x54765a5d7300bb70), _f(0x402d11108cfc5240),
    -_f(0x2e4c264c23518e10), _f(0x1e09e0cfb5ca8720),
    -_f(0xec7bce3f9449ab0), _f(0xaf0b9139605a58d),
    _f2(1139708, 0xdfbd02f131daf),
    # C4[0], coeff of eps^16, polynomial in n of order 10
    -_f2(6136, 0x52223aecbfa00), _f2(4597, 0xf56d1171d1b00),
    -_f2(3531, 0xe10107f964800), _f2(2747, 0xc7a53bf3c9500),
    -_f2(2142, 0x9c25bfa8f9600), _f(0x677abbdfa4dcef00),
    -_f(0x4e0ad45efdfc2400), _f(0x37ff2b5bd74de900),
    -_f(0x2432b6ddc0003200), _f(0x11c5dbb8178f4300),
    _f(0x4536f43fdb6a550), _f2(1139708, 0xdfbd02f131daf),
    # C4[0], coeff of eps^15, polynomial in n of order 11
    -_f2(13102, 0xf96f6011eba70), _f2(8724, 0xbd02d5fc04060),
    -_f2(6234, 0x68dfd557291d0), _f2(4636, 0xd96d16348cb80),
    -_f2(3525, 0x47255186b7b30), _f2(2702, 0xc781c601a46a0),
    -_f2(2062, 0x7b91b55fb7290), _f(0x60521f1f549575c0),
    -_f(0x44a70474ce1373f0), _f(0x2c2e0084319d1ce0),
    -_f(0x15a2a473a1b17b50), _f(0xff41fd49dab95d3),
    _f2(1139708, 0xdfbd02f131daf),
    # C4[0], coeff of eps^14, polynomial in n of order 12
    -_f2(63391, 0x70a4897dc9e80), _f2(23343, 0xc5a3f9fbbcce0),
    -_f2(13453, 0x278d24cdf3ac0), _f2(8911, 0x777a0315423a0),
    -_f2(6323, 0x2714f8a7fff00), _f2(4656, 0xe8c5e07109660),
    -_f2(3491, 0x6be5fd90e340), _f2(2621, 0xb84b17c4ad20),
    -_f(0x78f908534453df80), _f(0x55814182d129efe0),
    -_f(0x36b7bc0c02deebc0), _f(0x1ab5b755becbe6a0),
    _f(0x672760e43e7e5be), _f2(1139708, 0xdfbd02f131daf),
    # C4[0], coeff of eps^13, polynomial in n of order 13
    _f2(112706, 0xdfd869d806ed0), _f2(29093, 0xf8d3fc140cbc0),
    -_f2(65760, 0x7b52c14019950), _f2(24105, 0xa651ba0482d20),
    -_f2(13822, 0xd4286a2c4c370), _f2(9095, 0xad3608e2bd280),
    -_f2(6394, 0x2414e7ceec390), _f2(4646, 0x4bdec656d47e0),
    -_f2(3413, 0x76099d6b04db0), _f2(2482, 0x54f2fd0561940),
    -_f(0x6c7d891fb0df15d0), _f(0x44efe2727b65d2a0),
    -_f(0x2183dc0de2efcff0), _f(0x189262ba581c6bf1),
    _f2(1139708, 0xdfbd02f131daf),
    # C4[0], coeff of eps^12, polynomial in n of order 14
    _f2(22421, 0x80a7495217980), -_f2(122681, 0x25b6cd6074ac0),
    _f2(117806, 0x7498b0aecaf00), _f2(29700, 0x9de1e174ab0c0),
    -_f2(68413, 0x428634ee0fb80), _f2(24937, 0xf2aac2170b440),
    -_f2(14209, 0x4f5514d0cb600), _f2(9268, 0x742c2dd2c8fc0),
    -_f2(6433, 0x2286f06b3b080), _f2(4585, 0x3348b70941340),
    -_f2(3266, 0x3bda622d31b00), _f2(2252, 0x1340649a90ec0),
    -_f(0x589f5d02f1d02580), _f(0x2adce3e44e715240),
    _f(0xa36591ccc5a22bc), _f2(1139708, 0xdfbd02f131daf),
    # C4[0], coeff of eps^11, polynomial in n of order 15
    _f(0x3845a63e874b7f90), _f2(2990, 0x790a9d44cfaa0),
    _f2(23275, 0xc0709755ecab0), -_f2(127863, 0x516b98584c9c0),
    _f2(123656, 0x74905ab09b3d0), _f2(30291, 0xc8698ff57f9e0),
    -_f2(71410, 0x2ebef8806f110), _f2(25848, 0x521bca14dd980),
    -_f2(14605, 0xac6deef7d4ff0), _f2(9413, 0x816443bfd6920),
    -_f2(6415, 0x315eed8f094d0), _f2(4438, 0xfed32587f3cc0),
    -_f2(3002, 0xabba02cdaebb0), _f(0x74ba3cd78aa5e860),
    -_f(0x3812b2b32b2f8090), _f(0x28bab2d4ac11f317),
    _f2(1139708, 0xdfbd02f131daf),
    # C4[0], coeff of eps^10, polynomial in n of order 16
    _f(0xbcd4fd6df5b2600), _f(0x17fed2a1d906c020),
    _f(0x3a338f7e05a82540), _f2(3102, 0x8ee9d52fa7060),
    _f2(24235, 0xac0c2ca98fc80), -_f2(133761, 0xdb81f4d32fb60),
    _f2(130458, 0x34533ae1a43c0), _f2(30833, 0xcd61b102f94e0),
    -_f2(74830, 0xb3a54c3df6d00), _f2(26842, 0xad19affdd3920),
    -_f2(14996, 0x635b9e8c37dc0), _f2(9500, 0x408e4569f0960),
    -_f2(6294, 0x8e3c24f515680), _f2(4143, 0x97d5a30101da0),
    -_f2(2534, 0x56aa081845f40), _f(0x4b644b6e4da18de0),
    _f(0x11925bb6ba64765a), _f2(1139708, 0xdfbd02f131daf),
    # C4[0], coeff of eps^9, polynomial in n of order 17
    _f(0x3fcae6c51cf8fd0), _f(0x6afa1c71c2ac100),
    _f(0xc2892977602fa30), _f(0x18cb840e0ff332e0),
    _f(0x3c56602ddecd9290), _f2(3228, 0x26f051b5c20c0),
    _f2(25324, 0xf8a24438674f0), -_f2(140558, 0x5b2d711d11960),
    _f2(138496, 0xa2474d581bd50), _f2(31265, 0x7dd7c9350e080),
    -_f2(78781, 0x407f0fc917850), _f2(27920, 0xd85d0c9896a60),
    -_f2(15347, 0xbd51776ab0ff0), _f2(9468, 0xaa167d507e040),
    -_f2(5981, 0xcd152be8bed90), _f2(3570, 0xf062f37e99e20),
    -_f(0x68dc53d94dbff530), _f(0x4ae92c9a7a683bf5),
    _f2(1139708, 0xdfbd02f131daf),
    # C4[0], coeff of eps^8, polynomial in n of order 18
    _f(0x1b54ebcbbde1f00), _f(0x2947b9527677980),
    _f(0x415d003e7b1b800), _f(0x6df9566e0623680),
    _f(0xc8ad7ddfed65100), _f(0x19abdc3c4555e380),
    _f(0x3eb74cbd79d9ca00), _f2(3370, 0x20d152b7a6080),
    _f2(26575, 0x8086d641a0300), -_f2(148506, 0xeae36b607280),
    _f2(148190, 0x3f5dc7314dc00), _f2(31472, 0x41aaeb33d4a80),
    -_f2(83406, 0xf30366e47cb00), _f2(29065, 0x630b32b837780),
    -_f2(15585, 0x2764a1e4e1200), _f2(9192, 0xabf11a369f480),
    -_f2(5286, 0x3613c4b401900), _f2(2436, 0x784ea73c0a180),
    _f(0x2209232c3cc4cca8), _f2(1139708, 0xdfbd02f131daf),
    # C4[0], coeff of eps^7, polynomial in n of order 19
    _f(0xd73a52d8bd1790), _f(0x13078939da8f2e0),
    _f(0x1bc62bcb4923530), _f(0x2a1bb9d3adccf00),
    _f(0x42f03cdd160e0d0), _f(0x711670ab4ed8b20),
    _f(0xcf3f2963eb3be70), _f(0x1aa1c278c7668b40),
    _f(0x416120b2cbe67210), _f2(3532, 0x3a6649f1d3360),
    _f2(28031, 0x35f5ca2c79fb0), -_f2(157970, 0xd11b280f51880),
    _f2(160182, 0x9c904f3daeb50), _f2(31228, 0xe702b02a70ba0),
    -_f2(88907, 0xf3445bc050710), _f2(30210, 0xe03f62b8103c0),
    -_f2(15533, 0x7a0f6ace49370), _f2(8379, 0xc089c57da33e0),
    -_f2(3746, 0x32a85741515d0), _f2(2585, 0x396e1f38f6dbb),
    _f2(1139708, 0xdfbd02f131daf),
    # C4[0], coeff of eps^6, polynomial in n of order 20
    _f(0x73457ae9fefc80), _f(0x9bfefa36a68d60),
    _f(0xd7e57b2fb0d740), _f(0x132c60dd72bf720),
    _f(0x1c1d29144004a00), _f(0x2ad464b0fcdcce0),
    _f(0x446dc104a967cc0), _f(0x7436e717eb8b6a0),
    _f(0xd626d1c40bc9780), _f(0x1badddc640275c60),
    _f(0x445f879c8f67c240), _f2(3719, 0x5820c25fe6620),
    _f2(29754, 0xa45b204c52500), -_f2(169504, 0xe227b2d578420),
    _f2(175522, 0xa8a2f18c5e7c0), _f2(30060, 0x7f96216b245a0),
    -_f2(95556, 0xca707dfd4cd80), _f2(31150, 0x37da9e0a66b60),
    -_f2(14734, 0x203a74e6dd2c0), _f2(6239, 0x114e25ea99520),
    _f(0x4f113ff5b79764b6), _f2(1139708, 0xdfbd02f131daf),
    # C4[0], coeff of eps^5, polynomial in n of order 21
    _f(0x40c53da188eed0), _f(0x54ed187b34c440),
    _f(0x7146df082c9bb0), _f(0x9a154e844696a0),
    _f(0xd666e59b550690), _f(0x13262a46ef0dd00),
    _f(0x1c3f2cd359b1b70), _f(0x2b4dcc62e91c360),
    _f(0x45a57497f9cc650), _f(0x771c08f5a9775c0),
    _f(0xdd1a4961392f330), _f(0x1ccccddd60de2020),
    _f(0x47bbc762b5878e10), _f2(3937, 0xc2066e54dee80),
    _f2(31838, 0x13ce9b56b82f0), -_f2(183990, 0x8ea49a06f320),
    _f2(196055, 0x20a74184cbdd0), _f2(26856, 0x50de39af9a740),
    -_f2(103681, 0x9284ca213d550), _f2(31195, 0x5686bd94fe9a0),
    -_f2(11739, 0xecc6d600c4a70), _f2(7362, 0xc12f75a94f319),
    _f2(1139708, 0xdfbd02f131daf),
    # C4[0], coeff of eps^4, polynomial in n of order 22
    _f(0x25018b34093680), _f(0x2f66db340747c0),
    _f(0x3d8eaf55c4d300), _f(0x512efdf6054640),
    _f(0x6cf4c335af0f80), _f(0x952f237cecdcc0),
    _f(0xd10b7e4cd0dc00), _f(0x12cf85d69a3fb40),
    _f(0x1bf83185acb2880), _f(0x2b3ea99410c91c0),
    _f(0x462f30f09fee500), _f(0x7931c8e1f8c9040),
    _f(0xe34caff0bb50180), _f(0x1def0c2db115e6c0),
    _f(0x4b7080401d466e00), _f2(4194, 0xbf682a6ae8540),
    _f2(34423, 0x2600aa7441a80), -_f2(202943, 0xe8d9bbd87a440),
    _f2(225378, 0x7bd3e279ef700), _f2(18574, 0x52c9633395a40),
    -_f2(113350, 0xffc66a8300c80), _f2(27528, 0x198b9d86370c0),
    _f2(3947, 0xb3131e15c994), _f2(1139708, 0xdfbd02f131daf),
    # C4[0], coeff of eps^3, polynomial in n of order 23
    _f(0x14ba9dec234d90), _f(0x1a15f878f54920),
    _f(0x2134b5fb572db0), _f(0x2acf89c87d75c0),
    _f(0x37fb978513cbd0), _f(0x4a626dbdd79a60),
    _f(0x64a2becb8c9bf0), _f(0x8afd5ca732eb00),
    _f(0xc4970cf56e1210), _f(0x11deb4357fc9ba0),
    _f(0x1add3c5ff77a230), _f(0x2a08c939311e040),
    _f(0x451c5af5bb5c050), _f(0x7909ad73ef1ece0),
    _f(0xe685850971be070), _f(0x1edeb97922aff580),
    _f(0x4f3a8e20463e7690), _f2(4494, 0x6f4eb7a652e20),
    _f2(37733, 0xf376431ecf6b0), -_f2(229273, 0xd3dfdae1d3540),
    _f2(271637, 0x92a93446bd4d0), -_f2(5667, 0x8cc9ebb9c00a0),
    -_f2(121042, 0xac8f4eff17b10), _f2(39799, 0x5b8561a065b3f),
    _f2(1139708, 0xdfbd02f131daf),
    # C4[0], coeff of eps^2, polynomial in n of order 24
    _f(0xab22c89592500), _f(0xd46ccddd414a0), _f(0x10a4eb8f1ddb40),
    _f(0x15184ab619d7e0), _f(0x1b0f2efb81a980),
    _f(0x232d3128e64f20), _f(0x2e6a3ee43c47c0),
    _f(0x3e471bedb3b260), _f(0x552919f15d6e00),
    _f(0x7700089e6e39a0), _f(0xaa7eb4de50d440),
    _f(0xfb834e2f281ce0), _f(0x1801af760623280),
    _f(0x263a4a7c48d9420), _f(0x401905d594140c0),
    _f(0x72c2e250398d760), _f(0xe012c263c05b700),
    _f(0x1edcfb1205061ea0), _f(0x51c797f92b334d40),
    _f2(4810, 0x460394707a1e0), _f2(42101, 0xccb76963dbb80),
    -_f2(269613, 0x72aa3b84666e0), _f2(357865, 0x4c16ffd0cb9c0),
    -_f2(115779, 0xf2f861d29c3a0), -_f2(21708, 0xbd8e92577d4ae),
    _f2(1139708, 0xdfbd02f131daf),
    # C4[0], coeff of eps^1, polynomial in n of order 25
    _f(0x16b98c18c43f0), _f(0x1be76827efc80), _f(0x2291674649910),
    _f(0x2b3d2747a6820), _f(0x36a8d2fdcc830), _f(0x45e795ad137c0),
    _f(0x5a8eeaa036550), _f(0x77007a4bcbf60), _f(0x9ee5aa2960470),
    _f(0xd8045ac825300), _f(0x12bb93df5b3990),
    _f(0x1a9b1c398546a0), _f(0x26d2a92f5c98b0),
    _f(0x3a7858f998ee40), _f(0x5b6e62f9c0b5d0),
    _f(0x959d5c24529de0), _f(0x102f2d0b50524f0),
    _f(0x1e1472bfb1ba980), _f(0x3d69bf9cb587a10),
    _f(0x8ee1210e8c36520), _f(0x194d332fe8d44930),
    _f(0x6534ccbfa35124c0), _f2(15788, 0x2cc4c78572650),
    -_f2(115779, 0xf2f861d29c3a0), _f2(173669, 0xec7492bbea570),
    -_f2(75980, 0x9773003236861), _f2(379902, 0xf53f00fb109e5),
    # C4[0], coeff of eps^0, polynomial in n of order 26
    _f(0x104574695550b58), _f(0x124efd1ef41bc1c),
    _f(0x14b36c04f5f7ca0), _f(0x1787788b9792f24),
    _f(0x1ae5caaf52545e8), _f(0x1ef111702bafd2c),
    _f(0x23d6fb7cfc3d530), _f(0x29d483e08118c34),
    _f(0x313c47ee86cd878), _f(0x3a800de5bbb223c),
    _f(0x463f6a859617dc0), _f(0x555ed8909112544),
    _f(0x692d2b9362db308), _f(0x83a245a495f5b4c),
    _f(0xa7cc0a01a036650), _f(0xda93e49d10b2a54),
    _f(0x1243757f6f15c598), _f(0x193422259e6ad85c),
    _f(0x24309a0ea1d47ee0), _f(0x36b22ea791accb64),
    _f(0x588e3327aee70028), _f2(2530, 0x27feb6f2ec96c),
    _f2(5262, 0xb996ed2c7b770), _f2(14472, 0x7e5f0c3a53874),
    _f2(86834, 0xf63a495df52b8), -_f2(303922, 0x5dcc00c8da184),
    _f2(759805, 0xea7e01f6213ca), _f2(1139708, 0xdfbd02f131daf),
    # C4[1], coeff of eps^26, polynomial in n of order 0
    4654, _f(327806325),
    # C4[1], coeff of eps^25, polynomial in n of order 1
    _f(22113584), 5520955, _f(0xf784431927),
    # C4[1], coeff of eps^24, polynomial in n of order 2
    _f(29556996608), -_f(15922652416), _f(11273228472),
    _f(0x2383148b21287),
    # C4[1], coeff of eps^23, polynomial in n of order 3
    _f(0x165661ad6b70), -_f(0x1009b31cabe0), _f(0x7444963bdd0),
    _f(0x1d0511c64f5), _f(0x42b94999694cfa7),
    # C4[1], coeff of eps^22, polynomial in n of order 4
    _f(696434041088), -_f(561462728640), _f(334369174656),
    -_f(182661157184), _f(127941872058), _f(0x13691a10b39411),
    # C4[1], coeff of eps^21, polynomial in n of order 5
    _f(0x2b50c847e5bec70), -_f(0x25172ad2adc8640),
    _f(0x187490c86e06510), -_f(0x11cf5b364679120),
    _f(0x7e9f37da26e7b0), _f(0x1f979b01bfd5e3),
    _f2(227941, 0xc6590096a3923),
    # C4[1], coeff of eps^20, polynomial in n of order 6
    _f(0x84a641c077c100), -_f(0x75601a6b667780),
    _f(0x51157a29d94600), -_f(0x4247925ad10480),
    _f(0x269068d8c2ab00), -_f(0x15748d5a64a980),
    _f(0xed190d6b360a4), _f2(29731, 0x892d0013a607f),
    # C4[1], coeff of eps^19, polynomial in n of order 7
    _f(0x57e3d5e3e8a64d50), -_f(0x4ee151925712ac60),
    _f(0x379f60f9d8160ef0), -_f(0x3036f6417460ec40),
    _f(0x1eece80c1c746690), -_f(0x16f21d696f523420),
    _f(0x9ef6bfafd871830), _f(0x27a3f6720674fab),
    _f2(3419126, 0x9f3708d39590d),
    # C4[1], coeff of eps^18, polynomial in n of order 8
    _f2(2128, 0x469250df87e00), -_f(0x76ff6f2ca68ee740),
    _f(0x544ea56af984a280), -_f(0x4b3b3c5b1f3b3dc0),
    _f(0x324e822f05811f00), -_f(0x29dd8ae6f4502040),
    _f(0x179c3b6434632b80), -_f(0xd7628385c5d56c0),
    _f(0x91fdd6e000a7926), _f2(3419126, 0x9f3708d39590d),
    # C4[1], coeff of eps^17, polynomial in n of order 9
    _f2(3396, 0xc29d3f547be10), -_f2(2963, 0x6657b77d7b180),
    _f2(2082, 0xa3af2d55cd2f0), -_f(0x74e3fc23ed074b20),
    _f(0x4f51e11c0cc64dd0), -_f(0x45cc62cad46028c0),
    _f(0x2b210825284d5ab0), -_f(0x20cfde05bc67de60),
    _f(0xdb6584e22cc2590), _f(0x36aae0ede944991),
    _f2(3419126, 0x9f3708d39590d),
    # C4[1], coeff of eps^16, polynomial in n of order 10
    _f2(5994, 0xfab7bd428a400), -_f2(4919, 0xd8955c3980a00),
    _f2(3376, 0x641d9d71fd000), -_f2(2975, 0x320d339261600),
    _f(0x7dd1b5a4fb9ffc00), -_f(0x712cdc1424704200),
    _f(0x486493a43f86e800), -_f(0x3daeb06e6a40ce00),
    _f(0x21506b8426325400), -_f(0x13a656589a61fa00),
    _f(0xcfa4dcbf923eff0), _f2(3419126, 0x9f3708d39590d),
    # C4[1], coeff of eps^15, polynomial in n of order 11
    _f2(13117, 0x6cbddabc52ed0), -_f2(9318, 0xa8f3ea9b44c20),
    _f2(6040, 0x7b2fdab4ba7f0), -_f2(5022, 0x22b8983435e80),
    _f2(3330, 0x281af37e2710), -_f2(2968, 0x456e895a2c0e0),
    _f(0x7764510336be0030), -_f(0x6af4843f7d4f5f40),
    _f(0x3eba1ed514e18750), -_f(0x31669b90045c25a0),
    _f(0x13a17c0101ce1070), _f(0x4e2a88c78d66acf),
    _f2(3419126, 0x9f3708d39590d),
    # C4[1], coeff of eps^14, polynomial in n of order 12
    _f2(68147, 0x8cb1a33fbb300), -_f2(25030, 0x19a83b314d5c0),
    _f2(13399, 0xd5b954b9ffe80), -_f2(9632, 0x5ff7adc5b8740),
    _f2(6058, 0x6185fb910e200), -_f2(5122, 0x24f31e326fcc0),
    _f2(3246, 0x498e64bf8a580), -_f2(2929, 0xc60f539a7ee40),
    _f(0x6e041fee5d419100), -_f(0x60b53ba76d5f13c0),
    _f(0x3113d4fc9085ec80), -_f(0x1e6533c87b7d2540),
    _f(0x1357622acbb7b13a), _f2(3419126, 0x9f3708d39590d),
    # C4[1], coeff of eps^13, polynomial in n of order 13
    -_f2(121532, 0xe4514e2bd7670), -_f2(15940, 0x17553143d1340),
    _f2(71019, 0xc50f40d0125f0), -_f2(26120, 0x5d81b142df60),
    _f2(13667, 0x35bfe1bb73850), -_f2(9984, 0xe4f4c1c8f9780),
    _f2(6033, 0x4bb2ec6997cb0), -_f2(5212, 0x5459006443fa0),
    _f2(3108, 0x7a1250dedaf10), -_f2(2836, 0xbc55f0b59dbc0),
    _f(0x605fcd3581f88b70), -_f(0x4fb9f3b2da8b6fe0),
    _f(0x1d6444fcd70bcdd0), _f(0x74c81d1452803b5),
    _f2(3419126, 0x9f3708d39590d),
    # C4[1], coeff of eps^12, polynomial in n of order 14
    -_f2(18279, 0x4105927635f00), _f2(111436, 0xf9c78acad1e80),
    -_f2(127455, 0xb83d096a36600), -_f2(14599, 0xb6308ef406280),
    _f2(74253, 0x38e0bbebab300), -_f2(27394, 0x6661a055a9b80),
    _f2(13898, 0x35bd350d73c00), -_f2(10384, 0x95909b51f3c80),
    _f2(5941, 0x73f13b5b28500), -_f2(5277, 0x6484894bf580),
    _f2(2891, 0x688dd5accde00), -_f2(2646, 0x1bce07b5e7680),
    _f(0x4c6028727ac69700), -_f(0x32eae1a8c2946f80),
    _f(0x1ea30b56650e6834), _f2(3419126, 0x9f3708d39590d),
    # C4[1], coeff of eps^11, polynomial in n of order 15
    -_f(0x26534490cad1dfb0), -_f2(2194, 0x14a85ebaf95e0),
    -_f2(18676, 0x98f19d91af310), _f2(115088, 0x35b741cc34140),
    -_f2(134245, 0x8207aed455070), -_f2(12735, 0xf52bb5c1fbfa0),
    _f2(77916, 0x32c371fd8ec30), -_f2(28918, 0xb36d158cbf480),
    _f2(14055, 0x84fcc4e4ea6d0), -_f2(10840, 0xa60c8c5d6b960),
    _f2(5745, 0xafd650291c370), -_f2(5282, 0xabba6463d6a40),
    _f2(2556, 0x876a7d9212610), -_f2(2272, 0x615ae9eab6320),
    _f(0x2e7aab3dc406b2b0), _f(0xb7e588c69951913),
    _f2(3419126, 0x9f3708d39590d),
    # C4[1], coeff of eps^10, polynomial in n of order 16
    -_f(0x6ec9ec72fa83400), -_f(0xee6121f9ed5ac40),
    -_f(0x2698258da225a980), -_f2(2223, 0x82921a72280c0),
    -_f2(19088, 0x4fb95e6188700), _f2(119080, 0xff5c72a1c6ec0),
    -_f2(142117, 0x7c3deb03b7480), -_f2(10117, 0x6e8319b8485c0),
    _f2(82086, 0xede392256e600), -_f2(30795, 0xed5c849e10640),
    _f2(14073, 0x47ff3f3e080), -_f2(11359, 0x76d81b264bac0),
    _f2(5387, 0x791e9eab0d300), -_f2(5153, 0xcdddc38eb4b40),
    _f(0x7fb4f5b53eb31580), -_f(0x5fcfbdbbdde05fc0),
    _f(0x34b713242f2d630e), _f2(3419126, 0x9f3708d39590d),
    # C4[1], coeff of eps^9, polynomial in n of order 17
    -_f(0x20f38bbaca812f0), -_f(0x39b499036d51b00),
    -_f(0x6e4d3364d687b10), -_f(0xee56650d93fe5a0),
    -_f(0x26cbb66f58b91d30), -_f2(2250, 0xe985ef9ea8440),
    -_f2(19510, 0x3134f0f32ad50), _f2(123456, 0xc66bc06159520),
    -_f2(151362, 0xfafa005fcdf70), -_f2(6379, 0xaa0075c90d80),
    _f2(86843, 0xd7e050f079870), -_f2(33196, 0x7f1161b25e020),
    _f2(13831, 0x3ac1850370650), -_f2(11930, 0x8d19c5e9856c0),
    _f2(4775, 0x36871b380b630), -_f2(4708, 0xdfb0fde91e560),
    _f(0x4e466dbc0d5cf410), _f(0x132845ea2b7be139),
    _f2(3419126, 0x9f3708d39590d),
    # C4[1], coeff of eps^8, polynomial in n of order 18
    -_f(0xcaab4ddd8d4600), -_f(0x13c31d1cbb16d00),
    -_f(0x207a98d99de3000), -_f(0x390c3dedd68b300),
    -_f(0x6d71551ca261a00), -_f(0xed90e825b918900),
    -_f(0x26e62c786e462400), -_f2(2274, 0xbbaf6c5e10f00),
    -_f2(19934, 0x1db266a5f6e00), _f2(128254, 0x3ade3c4739b00),
    -_f2(162383, 0xab3413f131800), -_f(0x3992c873ce48ab00),
    _f2(92230, 0x4a4593a3dbe00), -_f2(36418, 0x345102e4b0100),
    _f2(13110, 0x864dfe531f400), -_f2(12475, 0xa3edd9488700),
    _f2(3771, 0xc13fa20286a00), -_f2(3469, 0x365d076765d00),
    _f(0x661b6984b64e65f8), _f2(3419126, 0x9f3708d39590d),
    # C4[1], coeff of eps^7, polynomial in n of order 19
    -_f(0x5b1678b2b96e30), -_f(0x83e7d604d6e1a0),
    -_f(0xc5c1bd21f06210), -_f(0x135402446a1f500),
    -_f(0x1fd9e061288aff0), -_f(0x381fb1c2d0ea860),
    -_f(0x6c176a9d32ee3d0), -_f(0xebcbb379725c7c0),
    -_f(0x26dc285f96da89b0), -_f2(2292, 0x8c4f779be1f20),
    -_f2(20344, 0xed4bfa0642d90), _f2(133496, 0x33ba4ee858580),
    -_f2(175742, 0x64c709ffb5b70), _f2(7288, 0xff81f26b85a20),
    _f2(98139, 0x5735ff04360b0), -_f2(41010, 0x6c5dc3c9a6d40),
    _f2(11505, 0xfe66ab587ad0), -_f2(12646, 0x14c7a4cad9ca0),
    _f2(2204, 0x9aaf76ecb66f0), _f(0x2076d1ad78dbacf7),
    _f2(3419126, 0x9f3708d39590d),
    # C4[1], coeff of eps^6, polynomial in n of order 20
    -_f(0x2d4d049c656700), -_f(0x3e4af5e8d022c0),
    -_f(0x57ced7fe851580), -_f(0x7f7034131ef240),
    -_f(0xbf83d85dea6c00), -_f(0x12c465612feb5c0),
    -_f(0x1f04ac518a30280), -_f(0x36d88216b840540),
    -_f(0x6a13494183c7100), -_f(0xe8a2e478ed378c0),
    -_f(0x269ca36792944f80), -_f2(2300, 0x7badf4501a840),
    -_f2(20714, 0x7015050283600), _f2(139156, 0x8278406ccd440),
    -_f2(192233, 0x29cb54965bc80), _f2(20133, 0xdb20ab18364c0),
    _f2(103930, 0xc444b13858500), -_f2(48022, 0x859c77e028ec0),
    _f2(8312, 0x1287962dbf680), -_f2(10954, 0x169105fd99e40),
    _f2(3795, 0x3bfe126c62e22), _f2(3419126, 0x9f3708d39590d),
    # C4[1], coeff of eps^5, polynomial in n of order 21
    -_f(0x1802918882e770), -_f(0x1fcd949a6860c0),
    -_f(0x2aeab9b7d2f010), -_f(0x3b2acc792185e0),
    -_f(0x539feddcdda2b0), -_f(0x79b43080aca700),
    -_f(0xb76e50170e2350), -_f(0x1207f374f78a820),
    -_f(0x1de74f0a09e95f0), -_f(0x351484156246d40),
    -_f(0x6722781c7da1e90), -_f(0xe37fba15ed8da60),
    -_f(0x260d3a8a453ee130), -_f2(2292, 0x258c84a62d380),
    -_f2(20989, 0x3411bcc4001d0), _f2(145073, 0x9b58d1932c360),
    -_f2(212947, 0x443e0cc67a470), _f2(41274, 0x9a63d1cc50640),
    _f2(107042, 0xff9bf7f6712f0), -_f2(59294, 0xf496954c0eee0),
    _f2(2833, 0xc664f5dce0050), _f(0x17b85ffcea47049d),
    _f2(3419126, 0x9f3708d39590d),
    # C4[1], coeff of eps^4, polynomial in n of order 22
    -_f(0xd20723e198100), -_f(0x10e999b2026480),
    -_f(0x161c2993f30e00), -_f(0x1d62585afd4f80),
    -_f(0x27ca0dc8a2fb00), -_f(0x370cc97a8ce280),
    -_f(0x4e170b46a3d800), -_f(0x7213d21df5ad80),
    -_f(0xac9b82d7503500), -_f(0x1109444f53c4080),
    -_f(0x1c6019c5f02a200), -_f(0x329a7eb49a52b80),
    -_f(0x62d84097135af00), -_f(0xdb6f2c88eb4fe80),
    -_f(0x2502e63c01a3ec00), -_f2(2256, 0x8389e52b04980),
    -_f2(21063, 0xc2942f767e900), _f2(150710, 0x347c6ec646380),
    -_f2(239155, 0x111ed671c3600), _f2(78297, 0xeac3242447880),
    _f2(97157, 0xffcea47049d00), -_f2(74487, 0xcca6f58949a80),
    _f2(11841, 0x219395a415cbc), _f2(3419126, 0x9f3708d39590d),
    # C4[1], coeff of eps^3, polynomial in n of order 23
    -_f(0x7207334f38cb0), -_f(0x8fe6a0f540760),
    -_f(0xb7c4f4df6c510), -_f(0xedcd97a176940),
    -_f(0x1384e0d9162770), -_f(0x1a108f169c7320),
    -_f(0x2378674e3fafd0), -_f(0x3154606a2c6100),
    -_f(0x465a9ded7c5a30), -_f(0x675a79a8aa6ee0),
    -_f(0x9d4a8ab99e2290), -_f(0xf9e328cb49d8c0),
    -_f(0x1a2ce594ece04f0), -_f(0x2efbcc23543daa0),
    -_f(0x5c688ee5939fd50), -_f(0xceb90d2fccdb080),
    -_f(0x2331240c282307b0), -_f2(2173, 0x456299e8e9660),
    -_f2(20716, 0x42df2018b2010), _f2(154405, 0x43613e2a37c0),
    -_f2(270827, 0xec43372c34270), _f2(146546, 0xa61bf3c2f7de0),
    _f2(26313, 0x9ff2a1de69530), -_f2(32563, 0x1c55db833bf05),
    _f2(3419126, 0x9f3708d39590d),
    # C4[1], coeff of eps^2, polynomial in n of order 24
    -_f(0x39a9fc22d9600), -_f(0x47a4ffa857140),
    -_f(0x59ea353148580), -_f(0x721982b3023c0),
    -_f(0x9291e22ef9d00), -_f(0xbeda9ea6fc240),
    -_f(0xfc517cd616480), -_f(0x1535335443d4c0),
    -_f(0x1d14474c2c6400), -_f(0x28c4706fdbe340),
    -_f(0x3aa43e35a32380), -_f(0x56eefde83775c0),
    -_f(0x859522b6982b00), -_f(0xd663f0e8861440),
    -_f(0x16b2ad2884e0280), -_f(0x2932441ccc746c0),
    -_f(0x51f4ee722e73200), -_f(0xb97e18f372a9540),
    -_f(0x1ff5b9ebacd64180), -_f(0x7d04fcecbaaf87c0),
    -_f2(19431, 0x998fba7cdb900), _f2(150594, 0xe619e547a59c0),
    -_f2(294712, 0x9903e1bb02080), _f2(231559, 0xe5f0c3a538740),
    -_f2(65126, 0x38abb70677e0a), _f2(3419126, 0x9f3708d39590d),
    # C4[1], coeff of eps^1, polynomial in n of order 25
    -_f(0x16b98c18c43f0), -_f(0x1be76827efc80),
    -_f(0x2291674649910), -_f(0x2b3d2747a6820),
    -_f(0x36a8d2fdcc830), -_f(0x45e795ad137c0),
    -_f(0x5a8eeaa036550), -_f(0x77007a4bcbf60),
    -_f(0x9ee5aa2960470), -_f(0xd8045ac825300),
    -_f(0x12bb93df5b3990), -_f(0x1a9b1c398546a0),
    -_f(0x26d2a92f5c98b0), -_f(0x3a7858f998ee40),
    -_f(0x5b6e62f9c0b5d0), -_f(0x959d5c24529de0),
    -_f(0x102f2d0b50524f0), -_f(0x1e1472bfb1ba980),
    -_f(0x3d69bf9cb587a10), -_f(0x8ee1210e8c36520),
    -_f(0x194d332fe8d44930), -_f(0x6534ccbfa35124c0),
    -_f2(15788, 0x2cc4c78572650), _f2(115779, 0xf2f861d29c3a0),
    -_f2(173669, 0xec7492bbea570), _f2(75980, 0x9773003236861),
    _f2(3419126, 0x9f3708d39590d),
    # C4[2], coeff of eps^26, polynomial in n of order 0
    2894476, _f(0xfe89d46f33),
    # C4[2], coeff of eps^25, polynomial in n of order 1
    -8609536, 5603312, _f(590597728875),
    # C4[2], coeff of eps^24, polynomial in n of order 2
    -_f(104352359168), _f(40707880576), _f(10376961584),
    _f(0xb18f66b7a5ca3),
    # C4[2], coeff of eps^23, polynomial in n of order 3
    -_f(0x265f8c17d00), _f(0x13bddd35200), -_f(871294451456),
    _f(553528081392), _f(0xa1c12e8b2dd1e3),
    # C4[2], coeff of eps^22, polynomial in n of order 4
    -_f(0x46e25cf59280), _f(0x290af5269020), -_f(0x22f7c7b01940),
    _f(0xd08f4d0d560), _f(0x355c24081bc), _f(0xc015674546693d9),
    # C4[2], coeff of eps^21, polynomial in n of order 5
    -_f(0x326f6045f923c80), _f(0x1fb1615f9d3a600),
    -_f(0x1db1797638c1780), _f(0xe9780531c07300),
    -_f(0x9d24cc38e5d280), _f(0x60cf9034bf3868),
    _f2(379902, 0xf53f00fb109e5),
    # C4[2], coeff of eps^20, polynomial in n of order 6
    -_f(0x4837c78c0550480), _f(0x313ba08613af040),
    -_f(0x2ee33229a4bc300), _f(0x1a152ee5f2ae9c0),
    -_f(0x172de5252da0180), _f(0x824fa762c0c340),
    _f(0x2180172e018ad8), _f2(379902, 0xf53f00fb109e5),
    # C4[2], coeff of eps^19, polynomial in n of order 7
    -_f(0x5fc4bec46509e480), _f(0x48096a7e75900b00),
    -_f(0x41caf1fb886dd580), _f(0x28558a32a56ef200),
    -_f(0x26dce3ddd1a42680), _f(0x120433e2d2025900),
    -_f(0xce36e1803df1780), _f(0x7a135866f905bb8),
    _f2(5698544, 0x5eb10eb5f946b),
    # C4[2], coeff of eps^18, polynomial in n of order 8
    -_f2(2176, 0xe1585afea1500), _f(0x73bced2a00a143a0),
    -_f(0x5fca97395e84bfc0), _f(0x418b4cd8fc5e04e0),
    -_f(0x3e6c34ea7ddb8a80), _f(0x212422dcacab1620),
    -_f(0x1f0466b0c7211540), _f(0xa12130d17045760),
    _f(0x29b0aa486315dbc), _f2(5698544, 0x5eb10eb5f946b),
    # C4[2], coeff of eps^17, polynomial in n of order 9
    -_f2(3194, 0x3409f96190200), _f2(3129, 0x198ba10e3f000),
    -_f2(2211, 0xeca78927c1e00), _f(0x6cf94ec7bfac7400),
    -_f(0x5f04d2df84f0ba00), _f(0x39318494ff85f800),
    -_f(0x38939121c731d600), _f(0x1854a6f7e2957c00),
    -_f(0x12decef0b13a7200), _f(0xa9861a018e14120),
    _f2(5698544, 0x5eb10eb5f946b),
    # C4[2], coeff of eps^16, polynomial in n of order 10
    -_f2(5172, 0xb8c4b33583a00), _f2(5700, 0x1d26bd0962f00),
    -_f2(3248, 0x8acf908fbc800), _f2(3050, 0xed985975b4100),
    -_f2(2251, 0xef96e32335600), _f(0x6370a1a9e900d300),
    -_f(0x5c955afee309e400), _f(0x2eb3ea14003fe500),
    -_f(0x2e844e36822a7200), _f(0xd8a8b891f217700),
    _f(0x388df4ca3a6fb20), _f2(5698544, 0x5eb10eb5f946b),
    # C4[2], coeff of eps^15, polynomial in n of order 11
    -_f2(11115, 0xb2ff91ec6c600), _f2(11728, 0x761e1ef822c00),
    -_f2(5178, 0x9a27d63f52200), _f2(5773, 0x24fd2adb2f000),
    -_f2(3328, 0x5f0c31c71fe00), _f2(2908, 0x836ab328fb400),
    -_f2(2291, 0x629d070485a00), _f(0x5681ee23b9ad7800),
    -_f(0x56cafdb120433600), _f(0x21dbd9f992213c00),
    -_f(0x1d4bdf01a76d9200), _f(0xf4e0cbd04176b20),
    _f2(5698544, 0x5eb10eb5f946b),
    # C4[2], coeff of eps^14, polynomial in n of order 12
    -_f2(73826, 0x9e48c9be75880), _f2(32637, 0x887aa6de960e0),
    -_f2(10940, 0x9647b1447b9c0), _f2(12348, 0xdd9347a34b3a0),
    -_f2(5206, 0x461aa415f3b00), _f2(5776, 0x82c559a327660),
    -_f2(3445, 0x2b71b5ef13c40), _f2(2676, 0xdbe2bf3d4c920),
    -_f2(2313, 0x6c289eed11d80), _f(0x45af1f46068fcbe0),
    -_f(0x4a646c774fde3ec0), _f(0x127e48f8affd9ea0),
    _f(0x4e336f38ab11704), _f2(5698544, 0x5eb10eb5f946b),
    # C4[2], coeff of eps^13, polynomial in n of order 13
    _f2(130976, 0x1a84c1eb6d80), -_f2(14597, 0x4f1d8a91fc600),
    -_f2(76483, 0x6c58cf65980), _f2(35388, 0xd1bf338007b00),
    -_f2(10663, 0x1c210a8b78080), _f2(13004, 0x14f125ca37c00),
    -_f2(5285, 0x554d73733c780), _f2(5660, 0xa57467d557d00),
    -_f2(3609, 0xe9c5b2656ee80), _f2(2326, 0xf26507322be00),
    -_f2(2274, 0xe6ae0b8fcb580), _f(0x30f364de4c777f00),
    -_f(0x3139417308d0dc80), _f(0x173bf41713ca3b88),
    _f2(5698544, 0x5eb10eb5f946b),
    # C4[2], coeff of eps^12, polynomial in n of order 14
    _f2(12302, 0xe52cc8d8c2180), -_f2(90162, 0x247de245423c0),
    _f2(136898, 0x7ace803b76f00), -_f2(20188, 0x482d40173de40),
    -_f2(79167, 0xe510d7fd7c380), _f2(38835, 0xfee0572864740),
    -_f2(10270, 0x4559a0d3b600), _f2(13648, 0x338b156f30cc0),
    -_f2(5468, 0x80042be36a880), _f2(5349, 0x619325bd73240),
    -_f2(3821, 0xffa84c59adb00), _f(0x729df2a6c14b77c0),
    -_f2(2073, 0x93dcfbe928d80), _f(0x193a4a0699e49d40),
    _f(0x6c8a3fc264f2d98), _f2(5698544, 0x5eb10eb5f946b),
    # C4[2], coeff of eps^11, polynomial in n of order 15
    _f(0x12b65c49560e1680), _f(0x4c91348dd4c57d00),
    _f2(12186, 0xb870c2ef8b380), -_f2(91199, 0x47a39f34d9e00),
    _f2(143440, 0xa133e98363080), -_f2(27237, 0xaf8901f443900),
    -_f2(81724, 0x1b06c40663280), _f2(43231, 0xcee7486ccec00),
    -_f2(9771, 0xb47d34b793580), _f2(14177, 0x876b1df11100),
    -_f2(5844, 0x5970f546f9880), _f2(4733, 0x71ff0d3b37600),
    -_f2(4034, 0xaeeb7c4e61b80), _f(0x4b0e043dd17f5b00),
    -_f(0x5c6dac5851097e80), _f(0x259ade3cf4689f28),
    _f2(5698544, 0x5eb10eb5f946b),
    # C4[2], coeff of eps^10, polynomial in n of order 16
    _f(0x285b74a086cfe00), _f(0x61629f583f6fc20),
    _f(0x11e1f0840e822e40), _f(0x4a2acb7177936860),
    _f2(12009, 0x162afd0a23e80), -_f2(92025, 0x51c6b64b59b60),
    _f2(150657, 0xe159fc0830ec0), -_f2(36240, 0x8903bcca1af20),
    -_f2(83842, 0x8f32e14ed8100), _f2(48929, 0x80db803df8d20),
    -_f2(9247, 0x4a711a73d90c0), _f2(14370, 0x3118e0d87960),
    -_f2(6545, 0xcfaa0092b4080), _f2(3681, 0xa71da4ef975a0),
    -_f2(4055, 0x6bd2ceb58b040), _f(0x201a58611bc4e1e0),
    _f(0x8ca8a9bec5eeb0c), _f2(5698544, 0x5eb10eb5f946b),
    # C4[2], coeff of eps^9, polynomial in n of order 17
    _f(0x8f791b0d72f300), _f(0x116eee5fb7db000),
    _f(0x2544a69b0af6d00), _f(0x5ae50a5c0f6ba00),
    _f(0x10e6ab279c402700), _f(0x472bda650b6c4400),
    _f2(11750, 0x4a89b28f5a100), -_f2(92512, 0x1ccd7f1613200),
    _f2(158574, 0x53a9410005b00), -_f2(47896, 0xbfb8d60312800),
    -_f2(84919, 0xb4a50d4cf2b00), _f2(56401, 0x32e93db7ce200),
    -_f2(8956, 0x3835fd4c87100), _f2(13782, 0xdee88bf296c00),
    -_f2(7712, 0x7aed9801af700), _f2(2126, 0x5791e5314f600),
    -_f2(3273, 0xe9400d1963d00), _f(0x4230ff2c7e6defd0),
    _f2(5698544, 0x5eb10eb5f946b),
    # C4[2], coeff of eps^8, polynomial in n of order 18
    _f(0x289b91a48ebf00), _f(0x45ee5b14465380),
    _f(0x7f92734c023800), _f(0xfa5ad187871c80),
    _f(0x21cddd2df61b100), _f(0x5372a978dde2580),
    _f(0xfbd02001ed7aa00), _f(0x436e93187af7ee80),
    _f2(11383, 0x2dcd21f7ea300), -_f2(92459, 0xff89d11970880),
    _f2(167131, 0xf0a2167d11c00), -_f2(63199, 0x7fe973623f80),
    -_f2(83766, 0xa02debe66b00), _f2(66187, 0xcedf7a1cac980),
    -_f2(9608, 0xefbab691d7200), _f2(11585, 0x75dbe72dc9280),
    -_f2(9220, 0x22c92d6997900), _f(0x18709d3bc0679b80),
    _f(0x5b7e325c6742390), _f2(5698544, 0x5eb10eb5f946b),
    # C4[2], coeff of eps^7, polynomial in n of order 19
    _f(0xd108e5f6f6100), _f(0x14cfb44a7f1600),
    _f(0x227bc5972bab00), _f(0x3bea4dd1053000),
    _f(0x6e5f06564db500), _f(0xdaf2ed1ea74a00),
    _f(0x1dec9104c41ff00), _f(0x4ae6e1cc221e400),
    _f(0xe5bde12a5950900), _f(0x3ec229ad8ff17e00),
    _f2(10869, 0xc2e1de8335300), -_f2(91550, 0xfd5202ded6800),
    _f2(176075, 0x65a5499a95d00), -_f2(83531, 0x98920703e4e00),
    -_f2(77994, 0x11133349c5900), _f2(78539, 0xb0828e93b4c00),
    -_f2(12981, 0x6d9e1d7114f00), _f2(6537, 0x5c156837be600),
    -_f2(9404, 0xf97b75bc90500), _f2(2071, 0xc05f52f113a50),
    _f2(5698544, 0x5eb10eb5f946b),
    # C4[2], coeff of eps^6, polynomial in n of order 20
    _f(0x4748ad3ff9e80), _f(0x6b926f7e60d60), _f(0xa71fa4085b840),
    _f(0x10c991e0a3ab20), _f(0x1c15b3b145b200),
    _f(0x314f7c7c43f8e0), _f(0x5be1ff458cabc0),
    _f(0xb89930a80796a0), _f(0x199734a3c07c580),
    _f(0x411aa25f2292460), _f(0xcb87e4542581f40),
    _f(0x38e7a442bb914220), _f2(10156, 0x20944a9a6d900),
    -_f2(89265, 0x51d50a4f57020), _f2(184683, 0x63f792d3912c0),
    -_f2(110680, 0x89cae6d0a5260), -_f2(62727, 0xfdf47fc1380),
    _f2(91791, 0x3f8035a7d3b60), -_f2(22895, 0xcc844c9bf79c0),
    -_f(0x5652aea374b626e0), -_f(0x38edb32bcbdda4ac),
    _f2(5698544, 0x5eb10eb5f946b),
    # C4[2], coeff of eps^5, polynomial in n of order 21
    _f(0x185346b40be80), _f(0x234a30239ea00), _f(0x345f5bcfbb580),
    _f(0x4fc2f91719900), _f(0x7d257d9ac0c80), _f(0xcb49d34f58800),
    _f(0x1580c944df8380), _f(0x263bb5e9cb7700),
    _f(0x483bd94933da80), _f(0x935c1fd3f92600),
    _f(0x14c807d3436d180), _f(0x35e9298d8a45500),
    _f(0xac6bf9cef462880), _f(0x318eb0c51232c400),
    _f2(9164, 0xf22328f6f9f80), -_f2(84728, 0x78acb3795cd00),
    _f2(191114, 0x47ac3650f680), -_f2(146268, 0x68f68696f9e00),
    -_f2(28124, 0xaf1a222081280), _f2(95633, 0xf3c35e98b1100),
    -_f2(42101, 0xccb76963dbb80), _f2(4250, 0xa99770cb50078),
    _f2(5698544, 0x5eb10eb5f946b),
    # C4[2], coeff of eps^4, polynomial in n of order 22
    _f(0x7c86a4240e80), _f(0xaf5db2064cc0), _f(0xfb958bed1300),
    _f(0x17080cf847940), _f(0x2288f92359780), _f(0x352f6beaa45c0),
    _f(0x54760062cdc00), _f(0x8b024608ff240), _f(0xeea60450a2080),
    _f(0x1af0609151bec0), _f(0x33c8072244a500),
    _f(0x6bad7af287eb40), _f(0xf83a707fcba980),
    _f(0x293d0a92ebeb7c0), _f(0x87aa233703e6e00),
    _f(0x2855283ce7ee6440), _f2(7785, 0x74e297d243280),
    -_f2(76427, 0xf39041d0ccf40), _f2(190726, 0x777542b243700),
    -_f2(188315, 0x1030e5dfaa2c0), _f2(42101, 0xccb76963dbb80),
    _f2(46959, 0xb31b5803129c0), -_f2(23682, 0x43272b482b978),
    _f2(5698544, 0x5eb10eb5f946b),
    # C4[2], coeff of eps^3, polynomial in n of order 23
    _f(0x21a7e921c980), _f(0x2e51be6e8f00), _f(0x40c19fbec480),
    _f(0x5c1e6062c200), _f(0x8599d6a9df80), _f(0xc60160b77500),
    _f(0x12cb7c4c7da80), _f(0x1d5985b996800), _f(0x2f524aaed7580),
    _f(0x4f30941955b00), _f(0x8a76dd63f7080), _f(0xff32326380e00),
    _f(0x1f5b1b59928b80), _f(0x42dd3cfeae4100),
    _f(0x9e90e4efcb8680), _f(0x1b33e235264b400),
    _f(0x5cdaf2eb93f2180), _f(0x1cd398a25fa82700),
    _f2(5865, 0x9368046121c80), -_f2(61723, 0xe7c88c9baa600),
    _f2(171645, 0xcc7599f993780), -_f2(213747, 0x992d035d6f300),
    _f2(126305, 0x66263c2b93280), -_f2(28944, 0xfcbe1874a70e8),
    _f2(5698544, 0x5eb10eb5f946b),
    # C4[2], coeff of eps^2, polynomial in n of order 24
    _f(0x5f08c3cb900), _f(0x807038c0ca0), _f(0xaffaed32440),
    _f(0xf4c5be483e0), _f(0x15a2490f6f80), _f(0x1f28eae1cb20),
    _f(0x2dce80c7fac0), _f(0x44e60304c260), _f(0x6a58ca3b2600),
    _f(0xa90e89d449a0), _f(0x1160126eb5140), _f(0x1db88b51940e0),
    _f(0x354168d7adc80), _f(0x64e3bca9a8820), _f(0xcc99ed98827c0),
    _f(0x1c3fb9ad58ff60), _f(0x45c01ca2899300),
    _f(0xc88852534b86a0), _f(0x2d1eac1f8a97e40),
    _f(0xee21e1c2e9afde0), _f2(3238, 0x9997f46a24980),
    -_f2(36434, 0x3fed7daa1bae0), _f2(105254, 0x7fca8779a54c0),
    -_f2(115779, 0xf2f861d29c3a0), _f2(43417, 0x7b1d24aefa95c),
    _f2(5698544, 0x5eb10eb5f946b),
    # C4[3], coeff of eps^26, polynomial in n of order 0
    433472, _f(72882272925),
    # C4[3], coeff of eps^25, polynomial in n of order 1
    _f(76231168), _f(19985680), _f(0x958a9334879),
    # C4[3], coeff of eps^24, polynomial in n of order 2
    _f(969805824), -_f(756467712), _f(427576864), _f(0x33a763b318f5),
    # C4[3], coeff of eps^23, polynomial in n of order 3
    _f(0xe7cfd39aa00), -_f(0xe6239d55400), _f(0x44ffe5cce00),
    _f(0x123fa804df0), _f(0x73400ac32a3f24f),
    # C4[3], coeff of eps^22, polynomial in n of order 4
    _f(633551529 << 15), -_f(0x130f2c71c000), _f(0x7e08a8b4000),
    -_f(0x69e0a004000), _f(0x39175efa340), _f(0x59a39697cb86721),
    # C4[3], coeff of eps^21, polynomial in n of order 5
    _f(0xe1a59555817c700), -_f(0xce92ef160470400),
    _f(0x6a50b28bc94d100), -_f(0x6ec5ce0328fa200),
    _f(0x1e2919432b73b00), _f(0x81169f96b647f8),
    _f2(2659320, 0xb4b906dd74543),
    # C4[3], coeff of eps^20, polynomial in n of order 6
    _f(0x4a951ec0f743800), -_f(0x39128060ba74400),
    _f(0x258d1de3ebd5000), -_f(0x25e6a8ece22dc00),
    _f(0xe953314d336800), -_f(0xd6fbba5b80b400),
    _f(0x6d3d6d3e79ea90), _f2(531864, 0x2425015f7daa7),
    # C4[3], coeff of eps^19, polynomial in n of order 7
    _f(0x7366685d2da15300), -_f(0x46390dd9eadeba00),
    _f(0x3de3739917104900), -_f(0x34e3ad131262bc00),
    _f(0x1ae64995e9a59f00), -_f(0x1d6cea9b561f3e00),
    _f(0x70d3407961b9500), _f(0x1ea45bc7b594048),
    _f2(7977962, 0x1e2b14985cfc9),
    # C4[3], coeff of eps^18, polynomial in n of order 8
    _f2(2991, 8707772229 << 17), -_f(0x5c0b6a6cd5328000),
    _f(0x6cf3b04ea6358000), -_f(0x47da0c907a958000),
    _f(0x334344c895550000), -_f(0x3257cd9b75628000),
    _f(0x11d874d9e96c8000), -_f(0x1273b92365d58000),
    _f(0x8b048eddb8dae80), _f2(7977962, 0x1e2b14985cfc9),
    # C4[3], coeff of eps^17, polynomial in n of order 9
    _f2(4599, 0x20675bc677c00), -_f2(2190, 0x6a6db0c48a000),
    _f2(3019, 0xad2c946b04400), -_f(0x5cc951aa5f7ff800),
    _f(0x61f2b89850d68c00), -_f(0x49aa7ace4eb85000),
    _f(0x26482ceb1d4d5400), -_f(0x2b88fb70a186a800),
    _f(0x8bf6f0c9a679c00), _f(0x26ce624431e62e0),
    _f2(7977962, 0x1e2b14985cfc9),
    # C4[3], coeff of eps^16, polynomial in n of order 10
    _f(0x383bee2531d2a000), -_f(0x2821094d061d1000),
    _f(0x2c347b321d4c8000), -_f(0x125d6736b20ff000),
    _f(0x1a6c4162f9ae6000), -_f(0xdca07dd1a07d000),
    _f(0xba2cc7913be4000), -_f(0xa8a49fd40deb000),
    _f(0x36dcb24ee422000), -_f(0x4159df2ed6e9000),
    _f(0x1bdad6784709c40), _f2(1139708, 0xdfbd02f131daf),
    # C4[3], coeff of eps^15, polynomial in n of order 11
    _f2(7381, 0x14c34c0c1f400), -_f2(13257, 0xf5b9dadc0c800),
    _f2(7086, 0x404eb1053bc00), -_f2(4054, 0xe4ed62e9ea000),
    _f2(5287, 0x17e93cc880400), -_f(0x7bc6aed7afe87800),
    _f2(2758, 0x364797381cc00), -_f(0x676ee80244a35000),
    _f(0x3b6d32d9ca041400), -_f(0x43e3e0c280942800),
    _f(0xa86d2e316b1dc00), _f(0x300bec0027818e0),
    _f2(7977962, 0x1e2b14985cfc9),
    # C4[3], coeff of eps^14, polynomial in n of order 12
    _f2(66948, 0x4f30b3f870000), -_f2(52646, 0x686a3833a8000),
    _f2(7561, 0xd0b8bda7a8000), -_f2(13026, 0x7d89ec00d8000),
    _f2(8130, 0xd3b0b583a0000), -_f2(3523, 0xd290763e28000),
    _f2(5530, 0x8b9708b698000), -_f(0x7e52c154efd58000),
    _f2(2356, 0x7673a06ad0000), -_f(0x6f6a34d21b028000),
    _f(0x220d8444fca88000), -_f(0x2fac85fa2e858000),
    _f(0x11c823101280e280), _f2(7977962, 0x1e2b14985cfc9),
    # C4[3], coeff of eps^13, polynomial in n of order 13
    -_f2(129173, 0x58489bc283900), _f2(59789, 0xf9dc41e63d400),
    _f2(65695, 0x9083acc5cc100), -_f2(58445, 0x2f2cc6e161a00),
    _f2(8184, 0x5e79915d1b00), -_f2(12353, 0x83a959670c800),
    _f2(9463, 0x4211f61d49500), -_f2(2966, 0xe12b8e3527600),
    _f2(5543, 0x52a28a556ef00), -_f2(2249, 0xe1f749ba16400),
    _f(0x6b0d1cda5c5fe900), -_f(0x70ab303245f3d200),
    _f(0xb596d16f1a34300), _f(0x35b4de912478078),
    _f2(7977962, 0x1e2b14985cfc9),
    # C4[3], coeff of eps^12, polynomial in n of order 14
    -_f2(6933, 0xfc2bb7bd6800), _f2(63382, 0x668969a617c00),
    -_f2(132589, 0xf0bdf2e789000), _f2(69768, 0x70d2052fd2400),
    _f2(63007, 0x6d053a2cb4800), -_f2(65233, 0xb829e1b817400),
    _f2(9601, 0xec9983923a000), -_f2(11042, 0x4317b942ccc00),
    _f2(11048, 0xa50acd625f800), -_f2(2545, 0x7c97f16176400),
    _f2(5107, 0xc83f2d67d000), -_f2(2697, 0x85e48cc53bc00),
    _f(0x36af107261fea800), -_f(0x57b6b3b8f7f45400),
    _f(0x1b355635bf037310), _f2(7977962, 0x1e2b14985cfc9),
    # C4[3], coeff of eps^11, polynomial in n of order 15
    -_f(0x718d19ce618f700), -_f(0x22292bb4d2a0a600),
    -_f2(6561, 0x7bb8e05b06500), _f2(61876, 0xa080215cbc400),
    -_f2(135759, 0x6c0a25f10b300), _f2(81504, 0x4116e653fae00),
    _f2(58147, 0xb03676e9edf00), -_f2(73011, 0xd75b35d7e2800),
    _f2(12405, 0x6d2fd911f1100), -_f2(8886, 0xdfa5214b6fe00),
    _f2(12677, 0x826d436a8a300), -_f2(2577, 0x6d77ecdf41400),
    _f2(3947, 0x879d1c7c5500), -_f2(3192, 0x95f286c2eaa00),
    _f(0x7343398f272e700), _f(0x20b3728b7b6b2d8),
    _f2(7977962, 0x1e2b14985cfc9),
    # C4[3], coeff of eps^10, polynomial in n of order 16
    -_f(0xaaaed768da0000), -_f(0x1d8d58546174000),
    -_f(0x650ff776c6dc000), -_f(0x1f0fa133b6eac000),
    -_f2(6125, 0x868b157bb8000), _f2(59813, 0x741ec012c000),
    -_f2(138411, 0xa7483b2cd4000), _f2(95264, 0x22057cd374000),
    _f2(50003, 0x3a5ca8a530000), -_f2(81502, 0xff7b30e274000),
    _f2(17542, 0xf2776c79b4000), -_f2(5812, 0xc63b637b2c000),
    _f2(13748, 0x38a6c4d018000), -_f2(3547, 0xbf6bf7e154000),
    _f(0x78ab12d1827bc000), -_f2(2957, 0x6b24852f8c000),
    _f(0x2bef42096127d7c0), _f2(7977962, 0x1e2b14985cfc9),
    # C4[3], coeff of eps^9, polynomial in n of order 17
    -_f(0x3cadc0edd6600), -_f(0x8587ee4c4e000),
    -_f(0x14633459f95a00), -_f(0x397bc2059d8400),
    -_f(0xc89f8adb490e00), -_f(0x3f2a86a64b5a800),
    -_f(0x32218961953c0200), _f2(8146, 0xa930f21b73400),
    -_f2(20015, 0x8b16989f1b600), _f2(15890, 0x8aa3fb72d9000),
    _f2(5271, 0xbcd5aeda65600), -_f2(12822, 0x9424c22ae1400),
    _f2(3774, 0x46bb658aca200), -_f(0x148a80159bb73800),
    _f(0x736580900f31ae00), -_f(0x336f49c74ee95c00),
    -_f(0x249e756eeea0600), -_f(0x13841fc89043bb0),
    _f2(1139708, 0xdfbd02f131daf),
    # C4[3], coeff of eps^8, polynomial in n of order 18
    -_f(0x5318540751000), -_f(0xa0702ad537800),
    -_f(0x14a9549a688000), -_f(0x2e31b9dc878800),
    -_f(0x72dceb1c83f000), -_f(0x14a6c8c8df91800),
    -_f(0x49c3e43ec426000), -_f(0x17df3e19aed32800),
    -_f2(5017, 0x9bceef61ed000), _f2(53301, 0x74feac5bf4800),
    -_f2(140139, 0x5706164944000), _f2(129320, 0x1fd8eca933800),
    _f2(16403, 0x87db178e25000), -_f2(95278, 0x1e65e67825800),
    _f2(40665, 0x6f4b03ec9e000), -_f(0x1c82af8b65ac6800),
    _f2(8049, 0x334ede6a77000), -_f2(7540, 0x5b108b15f800),
    _f(0x49ca297e3ffdbce0), _f2(7977962, 0x1e2b14985cfc9),
    # C4[3], coeff of eps^7, polynomial in n of order 19
    -_f(0x11fa490472e00), -_f(0x1fe0e98340400),
    -_f(0x3b2a552443a00), -_f(0x73f5544ad2000),
    -_f(0xf2e5765f90600), -_f(0x2290ce0f423c00),
    -_f(0x57b83400ee1200), -_f(0x1023f65b9bfd800),
    -_f(0x3b36c6db61bde00), -_f(0x13c7b72049527400),
    -_f2(4323, 0x73be8c4caea00), _f2(48359, 0x7d21dc7197000),
    -_f2(137343, 0xc18958973b600), _f2(148676, 0xd51cb5c775400),
    -_f2(14754, 0xa89f0bc9ec200), -_f2(92175, 0x33d1092c54800),
    _f2(60290, 0x88af4d43b7200), -_f2(5855, 0x8c9719d08e400),
    -_f(0x48b16aa4982d9a00), -_f(0x51dba59b00547450),
    _f2(7977962, 0x1e2b14985cfc9),
    # C4[3], coeff of eps^6, polynomial in n of order 20
    -_f(0x3f0527da8000), -_f(0x69410a894000), -_f(0xb5f68cf74000),
    -_f(0x14766cd18c000), -_f(5178956321 << 17),
    -_f(0x4cf42ca274000), -_f(0xa45199d7cc000),
    -_f(0x17e337e696c000), -_f(0x3e169088698000),
    -_f(0xbbd1c494494000), -_f(0x2c70014b4ca4000),
    -_f(0xf67e7406420c000), -_f2(3524, 0xcb63f52610000),
    _f2(41859, 0x1cfdfa000c000), -_f2(129839, 0xf92d750efc000),
    _f2(166586, 0x5d10da3394000), -_f2(59706, 0x5fbf7c0388000),
    -_f2(68020, 0xa047f74594000), _f2(75721, 0x1307a9002c000),
    -_f2(24384, 0xc0b45d798c000), _f(0x6534ccbfa35124c0),
    _f2(7977962, 0x1e2b14985cfc9),
    # C4[3], coeff of eps^5, polynomial in n of order 21
    -_f(0xcd30266b700), -_f(0x147d4e1fec00), -_f(0x21a6b4a64100),
    -_f(0x390579acce00), -_f(0x6423741d2b00), -_f(0xb749b833f000),
    -_f(0x1602ad6953500), -_f(0x2ccfc753d1200),
    -_f(0x61e5d62301f00), -_f(0xe995b2fcff400),
    -_f(0x270c826fb7a900), -_f(0x7a09e7f3045600),
    -_f(0x1dfb4c385ed9300), -_f(0xaddceca1091f800),
    -_f2(2624, 0xc45e83fdb9d00), _f2(33433, 0x20d0a109f6600),
    -_f2(114656, 0xa3de6d0238700), _f2(175907, 0x1d4b03fe80400),
    -_f2(116168, 0x7b17e334f1100), -_f2(3810, 0x1e1c2e9afde00),
    _f2(45340, 0x664f5dce00500), -_f2(17205, 0xff74273e2678),
    _f2(7977962, 0x1e2b14985cfc9),
    # C4[3], coeff of eps^4, polynomial in n of order 22
    -_f(784468838400), -_f(0x11a0a388400), -_f(0x1bda05d7000),
    -_f(0x2d25cb21c00), -_f(0x4b5283d5800), -_f(0x81d5381f400),
    -_f(0xe84e582c000), -_f(0x1b2017768c00), -_f(0x354f35942800),
    -_f(0x6f49195e6400), -_f(0xf9ffb1d81000), -_f(0x267769207fc00),
    -_f(0x6a9801634f800), -_f(0x15adc2fc41d400),
    -_f(0x5947d2bb916000), -_f(0x222d7eabcda6c00),
    -_f(0x22707489da53c800), _f2(7620, 0x3c385d35fbc00),
    -_f2(29197, 0x886c2c8e2b000), _f2(53341, 0xa58a8c79e2400),
    -_f2(51817, 0x997f46a249800), _f2(25908, 0xccbfa35124c00),
    -_f2(5262, 0xb996ed2c7b770), _f2(2659320, 0xb4b906dd74543),
    # C4[3], coeff of eps^3, polynomial in n of order 23
    -_f(242883621120), -_f(365079728640), -_f(559688344320),
    -_f(876931046400), -_f(0x147bd04f500), -_f(0x21c7b15a600),
    -_f(0x396d13e6700), -_f(0x650be18b000), -_f(0xb8f375f7900),
    -_f(0x16253c45ba00), -_f(0x2cc1928ceb00), -_f(0x6065d92f8400),
    -_f(0xe04f74737d00), -_f(0x23eadf138ce00),
    -_f(0x682920857ef00), -_f(0x1651f4aee45800),
    -_f(0x61a68e7d270100), -_f(0x281b43aa424e200),
    -_f(0x2bddd20238857300), _f2(10668, 0x544ee8e52d400),
    -_f2(45340, 0x664f5dce00500), _f2(90680, 0xcc9ebb9c00a00),
    -_f2(84203, 0x996ed2c7b7700), _f2(28944, 0xfcbe1874a70e8),
    _f2(7977962, 0x1e2b14985cfc9),
    # C4[4], coeff of eps^26, polynomial in n of order 0
    _f(74207744), _f(0x377b3e1aa351),
    # C4[4], coeff of eps^25, polynomial in n of order 1
    -_f(85649408), _f(42776448), _f(0x7a5a1b59863),
    # C4[4], coeff of eps^24, polynomial in n of order 2
    -_f(0x5d090f66800), _f(0x15cb8432c00), _f(412184096896),
    _f(0x3e897844a5071eb),
    # C4[4], coeff of eps^23, polynomial in n of order 3
    -_f(0xbff3f70d800), _f(0x44c7b31b000), -_f(0x48108b34800),
    _f(0x21db9c9a980), _f(0x4fc9e010f5dcf23),
    # C4[4], coeff of eps^22, polynomial in n of order 4
    -_f(0xd6b769b7e000), _f(0x72b1142e1800), -_f(0x82aa7be7f000),
    _f(0x1aa8532e0800), _f(0x779e97cc600), _f(0x40d4060dc7c384c7),
    # C4[4], coeff of eps^21, polynomial in n of order 5
    -_f(0x474af3a87693800), _f(0x3c389a0df442000),
    -_f(0x37e1a3d92db8800), _f(0x12d1db00bd71000),
    -_f(0x15fc16a85bcd800), _f(0x99491c279c9880),
    _f2(1139708, 0xdfbd02f131daf),
    # C4[4], coeff of eps^20, polynomial in n of order 6
    -_f(0x303d69b47fe22400), _f(0x3f4d2c93a259b200),
    -_f(0x29be542895db1800), _f(0x17eb54d9d2a59e00),
    -_f(0x1b89924120220c00), _f(0x4aa7a22c8d50a00),
    _f(0x157745851f3d4c0), _f2(10257379, 0xdda51a7ac0b27),
    # C4[4], coeff of eps^19, polynomial in n of order 7
    -_f(0x44c3305a70de1000), _f(0x6d1c9adfcac5e000),
    -_f(0x312f88327b293000), _f(0x3351684a1a554000),
    -_f(0x2ab43a21fd0e5000), _f(0xdaac481cc1ca000),
    -_f(0x120b854707e97000), _f(0x7289c72302f3500),
    _f2(10257379, 0xdda51a7ac0b27),
    # C4[4], coeff of eps^18, polynomial in n of order 8
    -_f2(2256, 0x7b501df238000), _f2(2620, 0x5abb698ccf000),
    -_f(0x3cfd86157c22a000), _f(0x656f30f9d7a5d000),
    -_f(0x3529aafa1251c000), _f(0x23979dd758c6b000),
    -_f(0x27cfd52f91a0e000), _f(0x52c1297ffdf9000),
    _f(0x1899e61f0915c00), _f2(10257379, 0xdda51a7ac0b27),
    # C4[4], coeff of eps^17, polynomial in n of order 9
    -_f2(5647, 0x92962c0679000), _f2(3064, 0xd620df9a18000),
    -_f(0x73b5708edb717000), _f2(2782, 0xf8e2a6bab2000),
    -_f(0x3aa55028ed4d5000), _f(0x54f5b0489ac0c000),
    -_f(0x3a8372ad6ebf3000), _f(0x128f31db99de6000),
    -_f(0x1bbb3cddeb8b1000), _f(0x9c3f5d344ffbb00),
    _f2(10257379, 0xdda51a7ac0b27),
    # C4[4], coeff of eps^16, polynomial in n of order 10
    -_f2(12546, 0xd0659481f7000), _f2(2321, 0x6f75c5bce2800),
    -_f2(5209, 0xc9bfbad2ac000), _f2(3693, 0x4f3d4dd785800),
    -_f(0x59b26230b2e61000), _f2(2785, 0x7ef843b608800),
    -_f(0x4086b5731d656000), _f(0x3b22d2695822b800),
    -_f(0x3bbf747f663cb000), _f(0x50e2c41c71ae800),
    _f(0x19182d9cca60700), _f2(10257379, 0xdda51a7ac0b27),
    # C4[4], coeff of eps^15, polynomial in n of order 11
    -_f2(14655, 0xa7ccf7b3e3000), _f2(5703, 0xb41e60048e000),
    -_f2(13723, 0x6fa2143b1000), _f2(2794, 0x80dd2a6158000),
    -_f2(4434, 0xbdbd659d5f000), _f2(4398, 0x1bf890b722000),
    -_f(0x462f1f0759b2d000), _f2(2504, 0xfcfacf17ac000),
    -_f(0x4eb2a95e9a75b000), _f(0x1bef3eef6f4b6000),
    -_f(0x2d8008caddc29000), _f(0xdbb189dc4eba300),
    _f2(10257379, 0xdda51a7ac0b27),
    # C4[4], coeff of eps^14, polynomial in n of order 12
    -_f2(31110, 0xd0a51132f4000), _f2(76716, 0x887753c58b000),
    -_f2(19285, 0xcfd85f57f6000), _f2(3558, 0x4fcfd1ab09000),
    -_f2(14554, 0xbf2d0ac9f8000), _f2(3850, 0x9631322307000),
    -_f2(3313, 0x90f8abbffa000), _f2(4999, 0xf3c6aed085000),
    -_f(0x44308029330fc000), _f(0x72cd2f325ae83000),
    -_f(0x5cc3eeffca3fe000), _f(0x2f990ef34001000),
    _f(0xedd65cb262fc00), _f2(10257379, 0xdda51a7ac0b27),
    # C4[4], coeff of eps^13, polynomial in n of order 13
    _f2(109832, 0xfe67f2664d000), -_f2(101414, 0x365d952fe4000),
    -_f2(21578, 0x2c7dffdd75000), _f2(81484, 0xfb5b01862000),
    -_f2(25828, 0x7adf44b697000), _f(0x527645ab2c368000),
    -_f2(14626, 0xa0f5b7bcd9000), _f2(5668, 0x89f8307d6e000),
    -_f(0x7c6deea8217fb000), _f2(5148, 0xb3c77272b4000),
    -_f(0x5ea4f23e05fbd000), _f(0x33d79ea3e6f7a000),
    -_f(0x512f5a2dc7bdf000), _f(0x13f171801c8d4d00),
    _f2(10257379, 0xdda51a7ac0b27),
    # C4[4], coeff of eps^12, polynomial in n of order 14
    _f2(3290, 0xf070eb97f3400), -_f2(37925, 0x14cc0872bb200),
    _f2(108756, 0x262a302ba0800), -_f2(111139, 0xba49ef60cbe00),
    -_f2(8978, 0x96e5af6312400), _f2(85061, 0xe9667b666b600),
    -_f2(34830, 0xb50884d615000), -_f(0x1ae66991075c5600),
    -_f2(13337, 0xd2d72b2557c00), _f2(8254, 0x43d2c57af1e00),
    -_f(0x39646320240ca800), _f2(4333, 0x5a8eb4efe1200),
    -_f2(2317, 0x387052d25d400), -_f(0x4971411b9aa7a00),
    -_f(0x239dc6f1135e6c0), _f2(10257379, 0xdda51a7ac0b27),
    # C4[4], coeff of eps^11, polynomial in n of order 15
    _f(0x22fb18f3d6fc800), _f(0xc812a63656dd000),
    _f2(2929, 0x54e6120875800), -_f2(35121, 0x48d05c62be000),
    _f2(106528, 0xc02be4bd3e800), -_f2(121104, 0xca8db31999000),
    _f2(7480, 0x3b39caec37800), _f2(86076, 0xd8784a9f2c000),
    -_f2(46728, 0xdb6f945bbf800), -_f(0x1e17ea5787b8f000),
    -_f2(10012, 0x630283c6800), _f2(11072, 0xcb500e9316000),
    -_f(0x3d2315ebbfcfd800), _f2(2196, 0x522d08f7fb000),
    -_f2(2582, 0x2942c8d084800), _f(0x1dbc900c41177d80),
    _f2(10257379, 0xdda51a7ac0b27),
    # C4[4], coeff of eps^10, polynomial in n of order 16
    _f(0x2367980c018000), _f(0x717a5d0aad6800),
    _f(0x1c7a6b9a7155000), _f(0xa7a0b73a0f93800),
    _f2(2540, 0xdc02459a12000), -_f2(31836, 0xf2625ff3ef800),
    _f2(102741, 0xc61b0075cf000), -_f2(130713, 0xb431635532800),
    _f2(28618, 0x913148900c000), _f2(82224, 0x225affaa4a800),
    -_f2(61371, 0x71836a73b7000), _f2(3358, 0xd2d9334507800),
    -_f2(4436, 0x51714c11fa000), _f2(12409, 0x2e12e0f984800),
    -_f2(3099, 0xb59c601f3d000), -_f(0x185351aa9adbe800),
    -_f(0xfcd867cd32b4e00), _f2(10257379, 0xdda51a7ac0b27),
    # C4[4], coeff of eps^9, polynomial in n of order 17
    _f(0x3b98569230800), _f(0x954e9f9ae8000), _f(0x1a387f0ed5f800),
    _f(0x561911aabbb000), _f(0x163673b1889e800),
    _f(0x870aa0c397ae000), _f2(2128, 0x4412890e0d800),
    -_f2(28018, 0x9edd02151f000), _f2(96862, 0x40aaeaffcc800),
    -_f2(138876, 0x18d8a92e8c000), _f2(55003, 0xc4365147fb800),
    _f2(69831, 0x65a81c2787000), -_f2(76836, 0x9198c23745800),
    _f2(14324, 0xf9d757893a000), _f(0x610a50cc5ec29800),
    _f2(9036, 0xddda1962ad000), -_f2(5866, 0x301cbcb97800),
    _f(0x2b3d64f38f7c3a80), _f2(10257379, 0xdda51a7ac0b27),
    # C4[4], coeff of eps^8, polynomial in n of order 18
    _f(0x7c44a1c56800), _f(0x10e1a40b9f400), _f(0x2778995e94000),
    _f(0x6511d82348c00), _f(0x122fbee15d1800),
    _f(0x3d60d47d162400), _f(0x10572b5ec96f000),
    _f(0x670e5c5512cbc00), _f(0x6a1969ca184cc800),
    -_f2(23632, 0x6fc488059ac00), _f2(88223, 0x601afc7b4a000),
    -_f2(143685, 0x3819032af1400), _f2(86217, 0x78ea8eac47800),
    _f2(43622, 0x50ec504da8400), -_f2(86857, 0xe4e3b378db000),
    _f2(34767, 0x1af4459111c00), _f(0x470ee9f8c8f42800),
    -_f(0xf0a395fd8dd4c00), -_f(0x55da5cd875ef3c80),
    _f2(10257379, 0xdda51a7ac0b27),
    # C4[4], coeff of eps^7, polynomial in n of order 19
    _f(0x114b06357800), _f(0x2239f3629000), _f(0x475e8ebd2800),
    _f(0x9e5523c88000), _f(0x17aa424dfd800), _f(0x3e2133dde7000),
    _f(0xb7f09cec78800), _f(0x280af153ee6000),
    _f(0xb0d866e91e3800), _f(0x48b6aeda5425000),
    _f(0x4ec10b7f840de800), -_f2(18693, 0xda891ccdbc000),
    _f2(76065, 0x2aaa760409800), -_f2(141961, 0xc3f732a21d000),
    _f2(119123, 0xd1c84be04800), -_f(0x7f4b67756e45e000),
    -_f2(76606, 0xe7a6860690800), _f2(56790, 0xce45bec021000),
    -_f2(14598, 0xc436164715800), _f(0x23b84843a30d9480),
    _f2(10257379, 0xdda51a7ac0b27),
    # C4[4], coeff of eps^6, polynomial in n of order 20
    _f(0x2492f246000), _f(0x43b68382800), _f(0x827fc7ff000),
    _f(0x10769dabb800), _f(0x231371038000), _f(0x4fad3dfb4800),
    _f(0xc39532c71000), _f(0x2109cc8eed800), _f(0x650cdd3e2a000),
    _f(0x16d3054b8e6800), _f(0x69275cf4ee3000),
    _f(0x2d6bb9aa2a1f800), _f(0x342dc9db6781c000),
    -_f2(13325, 0xb15a42ce7800), _f2(59725, 0xe775950b55000),
    -_f2(128819, 0x4abda20fae800), _f2(144216, 0xdf24ba0e000),
    -_f2(65935, 0x168961cdb5800), -_f2(23422, 0x325c674239000),
    _f2(39625, 0x392517e583800), -_f2(12954, 0x665fd1a892600),
    _f2(10257379, 0xdda51a7ac0b27),
    # C4[4], coeff of eps^5, polynomial in n of order 21
    _f(273177999360), _f(481049600000), _f(875104847872),
    _f(0x180866df000), _f(0x2f4b74a1800), _f(0x61abf5b8000),
    _f(0xd562fc0e800), _f(0x1f2598191000), _f(0x4ed8f85ab800),
    _f(0xdc91252ca000), _f(0x2bd44913d8800), _f(0xa584ade1c3000),
    _f(0x322090df0f5800), _f(0x16f6266186dc000),
    _f(0x1c472a543df62800), -_f2(7859, 0x7aaf0fd58b000),
    _f2(39234, 0x9eeb23497f800), -_f2(98180, 0xb70c1a0b12000),
    _f2(140051, 0xe6fe7071ac800), -_f2(115827, 0x9358bc0159000),
    _f2(51817, 0x997f46a249800), -_f2(9715, 0xccc7dd3e6dc80),
    _f2(10257379, 0xdda51a7ac0b27),
    # C4[4], coeff of eps^4, polynomial in n of order 22
    _f(18103127040), _f(30658521600), _f(53362944000),
    _f(95756838400), _f(177805329408), _f(343155696128),
    _f(692078714880), _f(0x155e2e7de00), _f(0x30194583c00),
    _f(0x741fc16da00), _f(0x131155285800), _f(0x379d38605600),
    _f(0xb96166967400), _f(0x2e2dfa3db5200), _f(0xee14dc9ed9000),
    _f(0x752e44962ece00), _f(0x9cf0406db58ac00),
    -_f2(3007, 0xfcd2e16ce3600), _f2(16844, 0xbb0354c82c800),
    -_f2(48007, 0x7b6318074ba00), _f2(77726, 0x663ee9f36e400),
    -_f2(64771, 0xffdf184adbe00), _f2(21050, 0xe65bb4b1eddc0),
    _f2(10257379, 0xdda51a7ac0b27),
    # C4[5], coeff of eps^26, polynomial in n of order 0
    356096, _f(98232628725),
    # C4[5], coeff of eps^25, polynomial in n of order 1
    _f(19006687232), _f(5473719680), _f(0x1580fd4afdbe65),
    # C4[5], coeff of eps^24, polynomial in n of order 2
    _f(91538057 << 15), -_f(0x378568c4000), _f(0x16cc31e2a00),
    _f(0x4c6f2137745e091),
    # C4[5], coeff of eps^23, polynomial in n of order 3
    _f(0xef2f223e3800), -_f(0x110fb2e7bf000), _f(0x282bb4606800),
    _f(0xbe30d7a6780), _f2(2828, 0xfcd03d1974f5),
    # C4[5], coeff of eps^22, polynomial in n of order 4
    _f(0x5e4a1598000), -_f(0x48b6e92a000), _f(97904939 << 14),
    -_f(0x20e8326e000), _f(850763001088), _f(0x2081a7235aaf593),
    # C4[5], coeff of eps^21, polynomial in n of order 5
    _f(0x40db2f49b455f800), -_f(0x1e99bb32c4c22000),
    _f(0x173ba0294630c800), -_f(0x194707e3169c1000),
    _f(0x2d83efe695c9800), _f(0xdf3e0617af3080),
    _f2(12536797, 0x9d1f205d24685),
    # C4[5], coeff of eps^20, polynomial in n of order 6
    _f(0x216feaa994ce0000), -_f(0xab5f967e8690000),
    _f(0x47922226ed5 << 18), -_f(0xb74a91dab5f0000),
    _f(0x3c54ceff81a0000), -_f(0x5d7cb98f1a50000),
    _f(0x1f9a69370b20800), _f2(4178932, 0x89b50ac9b6cd7),
    # C4[5], coeff of eps^19, polynomial in n of order 7
    _f(0x737c719d74a11000), -_f(0x33cb00709b02e000),
    _f(0x64aa4f647e063000), -_f(0x22d04f5347fb4000),
    _f(0x244213a9e6215000), -_f(0x2372b83384fba000),
    _f(0x29c5a12d1767000), _f(0xd64e2b028e9d00),
    _f2(12536797, 0x9d1f205d24685),
    # C4[5], coeff of eps^18, polynomial in n of order 8
    _f(0x4d6c482dac2a0000), -_f2(2329, 0xb1fe2723dc000),
    _f2(2244, 0xda129de1b8000), -_f(0x25b9c94d1ec14000),
    _f(0x5915813997350000), -_f(0x2b18411354f8c000),
    _f(0x1038d20e1fbe8000), -_f(0x1a9977b2ea9c4000),
    _f(0x7df995f732ef600), _f2(12536797, 0x9d1f205d24685),
    # C4[5], coeff of eps^17, polynomial in n of order 9
    _f(0x514388ef27d31000), -_f2(6020, 0x2be450c918000),
    _f(0x6fa66bdc836df000), -_f(0x67912be26fab2000),
    _f2(2539, 0xf65fb2006d000), -_f(0x237e1033f4d8c000),
    _f(0x3efb5ba75c79b000), -_f(0x32b52fd83cbe6000),
    _f(0x17d40e2c1a29000), _f(0x7dfd16a9c2e300),
    _f2(12536797, 0x9d1f205d24685),
    # C4[5], coeff of eps^16, polynomial in n of order 10
    _f2(12470, 0xf777d5cb70000), -_f2(8994, 0x34ff96fbd8000),
    _f(0x8b5e07446e3 << 18), -_f2(5684, 0xa351b76ba8000),
    _f2(2676, 0xe4b7624210000), -_f(0x3b4e8fe27b2f8000),
    _f2(2525, 0xe113384060000), -_f(0x317b33e66b8c8000),
    _f(0x1afebbc488cb0000), -_f(0x2abc78cdb6418000),
    _f(0xab0b32cc6da3c00), _f2(12536797, 0x9d1f205d24685),
    # C4[5], coeff of eps^15, polynomial in n of order 11
    _f2(45753, 0x27312c684b000), _f(0x6b25908081df2000),
    _f2(10080, 0x3e3c4e94e9000), -_f2(11483, 0x3052990658000),
    _f(0x186dcc47df2a7000), -_f2(4654, 0xe97b33c9a2000),
    _f2(3765, 0x192eb8a145000), -_f(0x1ea7f016e242c000),
    _f(0x7c08a9e80a083000), -_f(0x48a61c5124e36000),
    -_f(0x1ab8464a6fdf000), -_f(0xc3b3128c53f500),
    _f2(12536797, 0x9d1f205d24685),
    # C4[5], coeff of eps^14, polynomial in n of order 12
    -_f2(29853, 0xf97fbea090000), -_f2(72661, 0xb2e53c820c000),
    _f2(55735, 0xd505afdac8000), -_f(0x19eb9cd373704000),
    _f2(6447, 8655275741 << 17), -_f2(13735, 0x934f51ea3c000),
    _f(0x503c7c1e17a78000), -_f2(2910, 0x8f0f066334000),
    _f2(4611, 0xa07ae6cfd0000), -_f(0x28ec95124696c000),
    _f(0x386dc5f3bf428000), -_f(0x49a3cdb95c464000),
    _f(0xec86977ad08e600), _f2(12536797, 0x9d1f205d24685),
    # C4[5], coeff of eps^13, polynomial in n of order 13
    -_f2(77964, 0x27205a1bd000), _f2(116550, 0x911cc360c4000),
    -_f2(45605, 0xab8dec641b000), -_f2(66195, 0xc9de18da12000),
    _f2(66624, 0xae21593727000), -_f2(5576, 0x36f63ac28000),
    _f(0x6f2264aae1649000), -_f2(14832, 0x2c940b773e000),
    _f2(3661, 0xe0e147ff8b000), -_f(0x37687d20b9d14000),
    _f2(4430, 0xd2ef37d92d000), -_f(0x61330ed553f6a000),
    -_f(0x8fc7d2821691000), -_f(0x4de8f81581e0b00),
    _f2(12536797, 0x9d1f205d24685),
    # C4[5], coeff of eps^12, polynomial in n of order 14
    -_f(0x520b481798460000), _f2(18997, 713316873 << 16),
    -_f2(73060, 0xebcc7589c0000), _f2(119587, 0x641c11f8f0000),
    -_f2(63450, 0xfff4f2db20000), -_f2(54596, 0x54a14049b0000),
    _f2(77203, 5136366291 << 19), -_f2(15161, 0x669695c550000),
    -_f2(2898, 7333080783 << 17), -_f2(13401, 0xbb1dc317f0000),
    _f2(7364, 7522322675 << 18), _f(0xcbde6dd32070000),
    _f2(2498, 0xb270ac8f60000), -_f2(2207, 0xe5e147ba30000),
    _f(0x146e5a4ec1af3800), _f2(12536797, 0x9d1f205d24685),
    # C4[5], coeff of eps^11, polynomial in n of order 15
    -_f(0x8e2d12e55cc800), -_f(0x3c744345ee05000),
    -_f(0x436e3347c2885800), _f2(16354, 0x603aee4aee000),
    -_f2(66895, 0x3561b9526e800), _f2(120525, 0x7fafccca1000),
    -_f2(82888, 0x6ce782c3a7800), -_f2(36026, 0xb730ca850c000),
    _f2(84916, 0xe33bbac3af800), -_f2(30329, 0x9a1820a639000),
    -_f2(5003, 0x6724146c89800), -_f2(8175, 0xa51f341306000),
    _f2(10601, 0xdf58b3eb8d800), -_f(0x51534d8656793000),
    -_f(0x13f74fe07242b800), -_f(0x1338322158bf8680),
    _f2(12536797, 0x9d1f205d24685),
    # C4[5], coeff of eps^10, polynomial in n of order 16
    -_f(0x5e9d97de20000), -_f(0x15f51b48a5a000),
    -_f(0x679f3a6a83c000), -_f(0x2da38dbb53ee000),
    -_f(0x351287a208998000), _f2(13549, 0xfdc5cc829e000),
    -_f2(59298, 0x35ebc8a374000), _f2(118312, 0x8f7a13080a000),
    -_f2(102644, 0xbe9581710000), -_f2(8663, 0x3283e8b4ea000),
    _f2(85056, 0xa0c3d6fa54000), -_f2(50541, 0x58fecea57e000),
    _f(0x9e0314066f78000), -_f(0x56026edfbaf2000),
    _f2(9162, 0x6ada71271c000), -_f2(4514, 0x3f8f2be686000),
    _f(0x19aa7dbc9bd2b100), _f2(12536797, 0x9d1f205d24685),
    # C4[5], coeff of eps^9, polynomial in n of order 17
    -_f(0x689b7f794800), -_f(0x12aa316a68000),
    -_f(0x3c5fe03b7b800), -_f(0xe70662316b000),
    -_f(0x468257445d2800), -_f(0x204dea1c904e000),
    -_f(0x275c24b79c179800), _f2(10640, 0x725f868a0f000),
    -_f2(50163, 0x8367062950800), _f2(111598, 0xa3db986ecc000),
    -_f2(120105, 0x1af4e4a837800), _f2(28289, 0xbddfd64f09000),
    _f2(70122, 0x41f96206f1800), -_f2(70104, 0xcd1cf1241a000),
    _f2(17631, 0x83f469b94a800), _f2(3507, 0xd4dd7e683000),
    _f(0x234fa818af3f3800), -_f(0x5217ce807fb7e980),
    _f2(12536797, 0x9d1f205d24685),
    # C4[5], coeff of eps^8, polynomial in n of order 18
    -_f(0x8baa3048000), -_f(0x155e3991c000), -_f(237891401 << 18),
    -_f(0xa66484064000), -_f(0x22acb24838000),
    -_f(0x89475b1e6c000), -_f(0x2b8ce25f7b0000),
    -_f(0x14dd31b8f8b4000), -_f(0x1acbb07dd4628000),
    _f2(7723, 0xe6c1cd6b44000), -_f2(39540, 0xb1d09a9920000),
    _f2(98832, 0x70f12b47fc000), -_f2(130553, 0x474c4a5618000),
    _f2(72091, 0x9d4697d7f4000), _f2(31173, 0xcb977f1d70000),
    -_f2(72484, 0xa77099aa54000), _f2(42073, 0x76abc75bf8000),
    -_f2(8983, 0xdb34fa045c000), _f(0x7851cafec6ea600),
    _f2(12536797, 0x9d1f205d24685),
    # C4[5], coeff of eps^7, polynomial in n of order 19
    -_f(808445556736), -_f(0x19fd8659000), -_f(0x3ce45316800),
    -_f(0x98e89f08000), -_f(0x1a16c5239800), -_f(0x4ef4224b7000),
    -_f(0x11089a8d8c800), -_f(0x461e8219c6000),
    -_f(0x1740d89936f800), -_f(0xbb97ef56095000),
    -_f(0xffd8608f0242800), _f2(4956, 0x2ae7ba647c000),
    -_f2(27803, 0x8886c0e865800), _f2(78703, 0x691d56f30d000),
    -_f2(126581, 0xb2ac252438800), _f2(111405, 0x65dae188be000),
    -_f2(33040, 0xc82f8ec41b800), -_f2(31122, 0xa51c18fcd1000),
    _f2(33849, 0xe315529991800), -_f2(10096, 0xcfcaaeb453f80),
    _f2(12536797, 0x9d1f205d24685),
    # C4[5], coeff of eps^6, polynomial in n of order 20
    -_f(57693732864), -_f(118378242048), -_f(254261280768),
    -_f(575562375168), -_f(10565709 << 17), -_f(0x341c17b2000),
    -_f(0x92ee7ecc000), -_f(0x1ccf17876000), -_f(0x6786d9e38000),
    -_f(0x1bdf19e19a000), -_f(0x9bb8377424000),
    -_f(0x5352681ef5e000), -_f(0x79ce0dfd0cd0000),
    _f2(2563, 0x29027cc1fe000), -_f2(15917, 0xface8c747c000),
    _f2(51375, 0x61bf7d963a000), -_f2(99436, 0x390f87b768000),
    _f2(119998, 0xa6d5e6f116000), -_f2(88555, 0x279c7be1d4000),
    _f2(36577, 0x210e8c3652000), -_f2(6477, 0x332fe8d449300),
    _f2(12536797, 0x9d1f205d24685),
    # C4[5], coeff of eps^5, polynomial in n of order 21
    -_f(2537256960), -_f(4922368000), -_f(9913649152),
    -_f(20825468928), -_f(45893163008), -_f(3260719 << 15),
    -_f(265153996800), -_f(709434249216), -_f(0x1e3bc54b800),
    -_f(0x62f2289a000), -_f(0x174e12bf8800), -_f(0x69ee83c3b000),
    -_f(0x2753bfa335800), -_f(0x1693a2298bc000),
    -_f(0x23ce232de3a2800), _f(0x33ca29bdcdd43000),
    -_f2(5754, 0x693a6155df800), _f2(21176, 0x3b8f28c122000),
    -_f2(47646, 0x86021bb28c800), _f2(67058, 0x11f0010e41000),
    -_f2(51817, 0x997f46a249800), _f2(16192, 0xfff7c612b6f80),
    _f2(12536797, 0x9d1f205d24685),
    # C4[6], coeff of eps^26, polynomial in n of order 0
    _f(71266816), _f(0x75209f8d91ab),
    # C4[6], coeff of eps^25, polynomial in n of order 1
    -_f(61697 << 14), _f(365122560), _f(0x64173937d043),
    # C4[6], coeff of eps^24, polynomial in n of order 2
    -_f(0x10389da9c000), _f(0x19e75ef2000), _f(558875851776),
    _f(0xd767bab38dc330d),
    # C4[6], coeff of eps^23, polynomial in n of order 3
    -_f(0x142d81502c000), _f(0x6dee9f4b8000), -_f(0xae181cf64000),
    _f(0x39153b46b400), _f2(3342, 0x41381bc9272f3),
    # C4[6], coeff of eps^22, polynomial in n of order 4
    -_f(0x13480fca8c000), _f(0x16106a2c37000),
    -_f(0x1502d2e846000), _f(0x16180c1bd000), _f(0x74238242a00),
    _f2(3342, 0x41381bc9272f3),
    # C4[6], coeff of eps^21, polynomial in n of order 5
    -_f(0x1c0b06f2aed0000), _f(0x44926ab731c0000),
    -_f(0x2031c71e85b0000), _f(0xca25cdaf0e0000),
    -_f(0x14c7d62b6490000), _f(0x61052e04125000),
    _f2(1139708, 0xdfbd02f131daf),
    # C4[6], coeff of eps^20, polynomial in n of order 6
    -_f(0x3c147e5183b90000), _f(0x5c8a793ab7a08000),
    -_f(0xa71b84c4013 << 17), _f(0x26583d412b938000),
    -_f(0x1ec1409e52930000), _f(0xd82d55b5068000),
    _f(0x4a1c5add9a3000), _f2(14816215, 0x5c99263f881e3),
    # C4[6], coeff of eps^19, polynomial in n of order 7
    -_f2(2884, 0x97776797f0000), _f(0x5dcb94a5bbaa0000),
    -_f(0x2147754a866d0000), _f(0x59b9e153ee1c0000),
    -_f(0x1d3317b06cdb0000), _f(0xfd67f86b28e0000),
    -_f(0x193b89a255c90000), _f(0x662541f54195000),
    _f2(14816215, 0x5c99263f881e3),
    # C4[6], coeff of eps^18, polynomial in n of order 8
    -_f2(5404, 0x5e66e1f930000), _f(0x194c5bcfa9f36000),
    -_f2(2201, 0x4f230944e4000), _f2(2053, 0x73a8845e02000),
    -_f(0x127ebba7aac98000), _f(0x433c97a5782ce000),
    -_f(0x29997437ffc4c000), -_f(0xb36408ece66000),
    -_f(0x4eb946c9b6ac00), _f2(14816215, 0x5c99263f881e3),
    # C4[6], coeff of eps^17, polynomial in n of order 9
    -_f2(2829, 0x5744c85a98000), _f(0x53fda6bff9540000),
    -_f2(5946, 0xc179df32e8000), _f(0x424987c8bd3f0000),
    -_f(0x4d6fba1e72f38000), _f2(2362, 0x7a9b39aaa0000),
    -_f(0x1a7dd6520d788000), _f(0x1ca5a49549150000),
    -_f(0x279b8ad82b3d8000), _f(0x8624b660e613800),
    _f2(14816215, 0x5c99263f881e3),
    # C4[6], coeff of eps^16, polynomial in n of order 10
    _f2(3052, 0x1cc54fce28000), _f2(15175, 0x33b0e2aba4000),
    -_f2(5744, 0xc5440d7e0000), -_f(0xd3fdde9c4364000),
    -_f2(5627, 0x42b2a45de8000), _f2(2296, 0xc920e17994000),
    -_f(0x15ef23de88bf0000), _f2(2060, 0x9b7c8a7a8c000),
    -_f(0x3634e9b2229f8000), -_f(0x3eaac877287c000),
    -_f(0x1ee323a1ca0c800), _f2(14816215, 0x5c99263f881e3),
    # C4[6], coeff of eps^15, polynomial in n of order 11
    -_f2(77304, 0xeb4d9089c8000), _f2(21636, 0x8867f71d90000),
    _f2(6061, 8670344157 << 15), _f2(12960, 6074462725 << 18),
    -_f2(9403, 0x25b985468000), -_f(0x35c5d916ffb10000),
    -_f2(4114, 0x3d13bbebb8000), _f2(3690, 0x5a8c0420a0000),
    -_f(0x7db1fc00af08000), _f(0x3ee56918f4c50000),
    -_f(0x41d90b24a2658000), _f(0xb0f65a4ddefb800),
    _f2(14816215, 0x5c99263f881e3),
    # C4[6], coeff of eps^14, polynomial in n of order 12
    _f2(84445, 0xef949ea0f8000), _f2(19627, 0xf0e541fbce000),
    -_f2(80833, 0x5f741237dc000), _f2(34575, 0x1644d05d7a000),
    _f2(6828, 0x4cfbe5cb50000), _f2(8288, 0x561945cd26000),
    -_f2(12838, 0x6d3e328184000), _f(0x15c5608ef0ed2000),
    -_f(0x653ba29de4a58000), _f2(4217, 0x4b5d86267e000),
    -_f(0x3b46409683b2c000), -_f(0x974d654f27d6000),
    -_f(0x674dea252558c00), _f2(14816215, 0x5c99263f881e3),
    # C4[6], coeff of eps^13, polynomial in n of order 13
    _f2(45373, 0x376f121df0000), -_f2(98871, 0xe30dbcdfc0000),
    _f2(96522, 0x4174515a90000), -_f(0x2d5b0f36d6d20000),
    -_f2(79483, 0x53270530d0000), _f2(50297, 8337588523 << 19),
    _f2(3071, 0x5d816f2bd0000), _f(0x5cfb30543d820000),
    -_f2(14132, 0x4c1b1cdf90000), _f2(3907, 0xfc9bf30ac0000),
    _f(0x1e5e0fff75d10000), _f2(2700, 0x7f35ecdd60000),
    -_f(0x74992b46f6e50000), _f(0xe2f417f6bbc1000),
    _f2(14816215, 0x5c99263f881e3),
    # C4[6], coeff of eps^12, polynomial in n of order 14
    _f(0x1b3ddeae39bf0000), -_f2(7839, 0x62697a1358000),
    _f2(39400, 0x7dae3b2360000), -_f2(93477, 0x2dd7a51de8000),
    _f2(106917, 0x5f76290ad0000), -_f2(25706, 0x4975ab7078000),
    -_f2(70221, 0xf8d5dabdc0000), _f2(66679, 0x434a03a4f8000),
    -_f2(7926, 0xc17b4a4650000), -_f2(5104, 0x4c6b9c2d98000),
    -_f2(10825, 0x972fc79ee0000), _f2(8339, 0xae0935c7d8000),
    -_f(0xb5e35652d770000), -_f(0xb97cf166cab8000),
    -_f(0x1484ac4370939000), _f2(14816215, 0x5c99263f881e3),
    # C4[6], coeff of eps^11, polynomial in n of order 15
    _f(0x1da928c9710000), _f(0xef3463c3520000),
    _f(0x1433e03669f30000), -_f2(6121, 0xc895edf4c0000),
    _f2(32842, 0x2af7b46f50000), -_f2(85281, 0xda67593ea0000),
    _f2(113905, 0x4294ec3770000), -_f2(54341, 1789231857 << 19),
    -_f2(49473, 0x80d6dfd870000), _f2(78594, 0x71ba158da0000),
    -_f2(27684, 0xd5e2e99050000), -_f2(5831, 3589595121 << 18),
    -_f2(2437, 0x3d76dec030000), _f2(8713, 0x93ccba19e0000),
    -_f2(3467, 0xfccc93810000), _f(0xf2bb44edf33d000),
    _f2(14816215, 0x5c99263f881e3),
    # C4[6], coeff of eps^10, polynomial in n of order 16
    _f(0xcab3dac70000), _f(0x3665759289000), _f(0x12ce11eabe2000),
    _f(0x9df70180dbb000), _f(0xdfd754eb8954000),
    -_f2(4487, 0x5dd2369613000), _f2(25849, 0xff24cd52c6000),
    -_f2(73908, 0x17b3db62e1000), _f2(115119, 0x8d3c9a9638000),
    -_f2(83691, 0x41fe3e02af000), -_f2(14375, 0xada6f2de56000),
    _f2(76590, 0xeb60670083000), -_f2(52128, 0x9a91d83ce4000),
    _f2(7010, 0x5a128dfcb5000), _f2(3866, 0xf6d75c088e000),
    _f(0x469f50315e7e7000), -_f(0x4bbe9f188165a200),
    _f2(14816215, 0x5c99263f881e3),
    # C4[6], coeff of eps^9, polynomial in n of order 17
    _f(0x8ddfb274000), _f(120826333 << 18), _f(0x6b145a40c000),
    _f(0x1dc5136a58000), _f(0xab5ca60ba4000), _f(0x5e28748a970000),
    _f(0x8cad0403953c000), -_f2(3003, 0xaeb1521f78000),
    _f2(18707, 0x350991ecd4000), -_f2(59284, 0x6845654460000),
    _f2(107702, 0xd776bbe6c000), -_f2(107579, 0xe340531948000),
    _f2(33813, 0xa464b8b604000), _f2(48035, 0x81a4fa0dd0000),
    -_f2(64047, 0xa4265c8064000), _f2(31225, 0xe027c1dce8000),
    -_f2(5635, 0xd5d68038cc000), -_f(0x50368754849c400),
    _f2(14816215, 0x5c99263f881e3),
    # C4[6], coeff of eps^8, polynomial in n of order 18
    _f(490704814080), _f(0x13aa0f5a000), _f(31022013 << 17),
    _f(0xc68497e6000), _f(0x2fcbb8aac000), _f(0xdd4302e72000),
    _f(0x534405e9b8000), _f(0x30298b6eefe000),
    _f(0x4c5dcf34c0c4000), -_f(0x6d574da684a76000),
    _f2(11873, 5016286141 << 16), -_f2(42009, 0x509c0961ea000),
    _f2(89073, 0x6259ee06dc000), -_f2(115683, 0xae64a27b5e000),
    _f2(82889, 0x8f2a67cde8000), -_f2(11935, 0xb1dc537ad2000),
    -_f2(33312, 0xcf05a2430c000), _f2(28876, 0xae4eda7bba000),
    -_f2(8101, 0x83645851a5400), _f2(14816215, 0x5c99263f881e3),
    # C4[6], coeff of eps^7, polynomial in n of order 19
    _f(7458340864), _f(560703 << 15), _f(48303816704),
    _f(522951 << 18), _f(426386014208), _f(45283889 << 15),
    _f(0x56a252ac000), _f(440127317 << 16), _f(0xa648bd1f4000),
    _f(0x65fb114118000), _f(0xacffeca0b3c000),
    -_f(0x860da206139 << 17), _f(0x7d0a1c0732284000),
    -_f2(7961, 0x1b3e7a1f58000), _f2(19682, 0xa4af1c3bcc000),
    -_f2(31917, 0xccc8ef8390000), _f2(34094, 0x3798b7b14000),
    -_f2(23101, 0x583f152fc8000), _f2(8983, 0xdb34fa045c000),
    -_f(0x5f40c0b45d798c00), _f2(4938738, 0x74330cbfd80a1),
    # C4[6], coeff of eps^6, polynomial in n of order 20
    _f(651542528), _f(1480134656), _f(3538968576), _f(8971595776),
    _f(371371 << 16), _f(71493373952), _f(230978592768),
    _f(838422294528), _f(0x334e2804000), _f(0x106060339000),
    _f(0x6e2b415ae000), _f(0x484c62e3a3000), _f(0x848c0aa1558000),
    -_f(0xe0b56a0582f3000), _f(0x745df25523d02000),
    -_f2(8378, 0x6c27f21289000), _f2(23938, 0x5996b3a2ac000),
    -_f2(45881, 0xd660d84d1f000), _f2(58395, 0x10d8591c56000),
    -_f2(42673, 0x513ba394b5000), _f2(12954, 0x665fd1a892600),
    _f2(14816215, 0x5c99263f881e3),
    # C4[7], coeff of eps^26, polynomial in n of order 0
    _f(9763 << 15), _f(0x75209f8d91ab),
    # C4[7], coeff of eps^25, polynomial in n of order 1
    _f(239317 << 16), _f(5250319360), _f(0x4082f7e0f93b2f),
    # C4[7], coeff of eps^24, polynomial in n of order 2
    _f(179518703 << 19), -_f(591371495 << 18), _f(0x28b139bd9800),
    _f2(3231, 0x13f0854e6fdc3),
    # C4[7], coeff of eps^23, polynomial in n of order 3
    _f(0x2cef3d4baf0000), -_f(77130417375 << 17), _f(0xef66e7c50000),
    _f(0x5431e6572400), _f2(119549, 0xe1c344562ad2f),
    # C4[7], coeff of eps^22, polynomial in n of order 4
    _f(217227301 << 22), -_f(289844049 << 20), _f(78161061 << 21),
    -_f(250072603 << 20), _f(0x3ccfc393c000),
    _f2(3856, 0x72a333c0b70f1),
    # C4[7], coeff of eps^21, polynomial in n of order 5
    _f(0x4e0ae513ee240000), -_f(827903427791 << 20),
    _f(0xa247f543e5f << 18), -_f(0x3412b66b53f << 19),
    -_f(88149449003 << 18), -_f(0x22c21c78f4d000),
    _f2(17095633, 0x1c132c21ebd41),
    # C4[7], coeff of eps^20, polynomial in n of order 6
    _f(0x17d653fb3b3 << 21), -_f(0x28623ac8329 << 20),
    _f(0x157258d15a9 << 22), -_f(0x11bb996f2df << 20),
    _f(568501848145 << 21), -_f(0x17b5bd88f85 << 20),
    _f(0x53401a2130be000), _f2(17095633, 0x1c132c21ebd41),
    # C4[7], coeff of eps^19, polynomial in n of order 7
    -_f(0x83a0cdc49940000), -_f2(2692, 4590415189 << 19),
    _f(0x5a9e6c539a840000), -_f(834402440151 << 20),
    _f(0x4606e5f7741c0000), -_f(0x420b2360847 << 19),
    -_f(530800397043 << 18), -_f(0xe57fab5d571000),
    _f2(17095633, 0x1c132c21ebd41),
    # C4[7], coeff of eps^18, polynomial in n of order 8
    _f2(3472, 126556531 << 23), -_f2(5076, 3517313787 << 20),
    -_f(76794078375 << 21), -_f(0x6a9c1a13021 << 20),
    _f2(2051, 1043338611 << 22), -_f(704701202247 << 20),
    _f(0xfa27346673 << 21), -_f(0x245598aac6d << 20),
    _f(0x69deaea556c4000), _f2(17095633, 0x1c132c21ebd41),
    # C4[7], coeff of eps^17, polynomial in n of order 9
    _f2(15000, 0xe6601a91a0000), -_f(0x261369ca72f << 20),
    _f(0x42e9870754860000), -_f2(5748, 0xcbf4457740000),
    _f(0x3d07c1e90b320000), -_f(0x3f02d96efef << 19),
    _f(0x7fb986a3c79e0000), -_f(0x995e2453d1f << 18),
    -_f(0x4ae4d5f0bb60000), -_f(0x2b86668e596d800),
    _f2(17095633, 0x1c132c21ebd41),
    # C4[7], coeff of eps^16, polynomial in n of order 10
    -_f(0x73f9d78b0d9 << 20), _f(0x9cf538ea065 << 19),
    _f2(15740, 149203411 << 22), -_f2(4248, 1728572757 << 19),
    -_f(0x407b444d4cf << 20), -_f2(4968, 2121468799 << 19),
    _f2(2638, 499248115 << 21), _f(0x88c04a730380000),
    _f(0x44a3b895a7b << 20), -_f(0x74a26c7b8a3 << 19),
    _f(0x855f1c455087000), _f2(17095633, 0x1c132c21ebd41),
    # C4[7], coeff of eps^15, polynomial in n of order 11
    _f2(61154, 0xdd701642e0000), -_f2(66911, 9396541691 << 18),
    _f2(7800, 0xcd3506c5a0000), _f2(6879, 1489841009 << 20),
    _f2(13340, 0xebc72e5460000), -_f2(8995, 2037240317 << 18),
    -_f(0x58226c8c268e0000), -_f2(2527, 381291855 << 19),
    _f2(3789, 0xabee5235e0000), -_f(0x7b29f7fc67f << 18),
    -_f(0x7ff214bf2760000), -_f(0x75bce0e31735800),
    _f2(17095633, 0x1c132c21ebd41),
    # C4[7], coeff of eps^14, polynomial in n of order 12
    -_f2(101656, 596927171 << 22), _f2(53043, 574431381 << 20),
    _f2(45405, 240861115 << 21), -_f2(76255, 2673908009 << 20),
    _f2(23050, 192030143 << 23), _f2(9407, 3846737689 << 20),
    _f2(7022, 1974859325 << 21), -_f2(12738, 252856997 << 20),
    _f(0x137e788e9bf << 22), _f(0x118e235259d << 20),
    _f2(2782, 635761855 << 21), -_f(0x61e77094421 << 20),
    _f(0x9e768b34c754000), _f2(17095633, 0x1c132c21ebd41),
    # C4[7], coeff of eps^13, polynomial in n of order 13
    -_f2(21345, 0xc6c0a8cac0000), _f2(63537, 3528773151 << 20),
    -_f2(101990, 1331648317 << 18), _f2(73206, 6215106713 << 19),
    _f2(21832, 587136209 << 18), -_f2(78785, 930736779 << 21),
    _f2(42984, 0xe415720fc0000), _f2(4706, 912279695 << 19),
    -_f(0x6fb64418f6cc0000), -_f2(11952, 1697246539 << 20),
    _f2(6137, 3764705851 << 18), _f(0x39d9405b105 << 19),
    -_f(779141568695 << 18), -_f(0x14a7906c9982d000),
    _f2(17095633, 0x1c132c21ebd41),
    # C4[7], coeff of eps^12, polynomial in n of order 14
    -_f(254469508501 << 21), _f2(2615, 141135587 << 20),
    -_f2(16754, 480949921 << 22), _f2(54113, 1487459045 << 20),
    -_f2(98062, 1801972559 << 21), _f2(91200, 2801526327 << 20),
    -_f2(9603, 108846763 << 23), -_f2(69011, 498726663 << 20),
    _f2(62980, 2002280887 << 21), -_f2(11145, 4221789365 << 20),
    -_f2(7195, 1009585291 << 22), -_f2(4457, 3739558579 << 20),
    _f2(7974, 18407933 << 21), -_f2(2668, 664195297 << 20),
    _f(0x8b8039451326000), _f2(17095633, 0x1c132c21ebd41),
    # C4[7], coeff of eps^11, polynomial in n of order 15
    -_f(5353180065 << 18), -_f(25442595013 << 19),
    -_f(0x4cec268118c0000), _f(0x702c4e5b497 << 20),
    -_f2(12304, 5733646405 << 18), _f2(43346, 2744696673 << 19),
    -_f2(88871, 6285139975 << 18), _f2(103468, 468195229 << 21),
    -_f2(46365, 0xbad7731a40000), -_f2(41349, 1257587961 << 19),
    _f2(72365, 0x9597fe7540000), -_f2(36580, 2571848483 << 20),
    _f(0xc0cfef1c9f3 << 18), _f2(3419, 2944620333 << 19),
    _f(0x5d00262e0cc40000), -_f(0x44e0e913b4a79000),
    _f2(17095633, 0x1c132c21ebd41),
    # C4[7], coeff of eps^10, polynomial in n of order 16
    -_f(1386231 << 24), -_f(109742265 << 20), -_f(354075457 << 21),
    -_f(7044729419 << 20), -_f(48190848741 << 22),
    _f(0x4592e53c723 << 20), -_f2(8214, 1225367123 << 21),
    _f2(31749, 3931639185 << 20), -_f2(73861, 194985719 << 23),
    _f2(105371, 3738827519 << 20), -_f2(81325, 759307621 << 21),
    _f2(5533, 2607378797 << 20), _f2(54935, 128097033 << 22),
    -_f2(54849, 213867813 << 20), _f2(23331, 2117756809 << 21),
    -_f2(3571, 955076279 << 20), -_f(0xa766ab1fb094000),
    _f2(17095633, 0x1c132c21ebd41),
    # C4[7], coeff of eps^9, polynomial in n of order 17
    -_f(9271959 << 16), -_f(2137131 << 20), -_f(0x8adb5490000),
    -_f(374926717 << 17), -_f(5060508635 << 16), -_f(0xc549443040000),
    -_f(0x1658a10fa0d0000), _f(0x250f39cc17720000),
    -_f2(4742, 48259999 << 16), _f2(20239, 6692003029 << 19),
    -_f2(53602, 0x26a4a24510000), _f2(92339, 8168900207 << 17),
    -_f2(101236, 0x6fb3cfe30000), _f2(59785, 2334542613 << 18),
    _f(0x5c1211516deb0000), -_f2(32944, 0x86c05c8b60000),
    _f2(24775, 0x5aee521590000), -_f2(6657, 0xade066fea8c00),
    _f2(17095633, 0x1c132c21ebd41),
    # C4[7], coeff of eps^8, polynomial in n of order 18
    -_f(31473 << 19), -_f(194623 << 18), -_f(41393 << 22),
    -_f(2533665 << 18), -_f(5617311 << 19), -_f(60523827 << 18),
    -_f(107394483 << 20), -_f(4758923477 << 18), -_f(73625727245 << 19),
    _f(0xf5289483e640000), -_f2(2141, 878914353 << 21),
    _f2(10163, 0xf2a381edc0000), -_f2(30731, 8395289531 << 19),
    _f2(63101, 0xdb7b98c940000), -_f2(89756, 3102076305 << 20),
    _f2(87316, 6648120707 << 18), -_f2(55353, 8132528169 << 19),
    _f2(20534, 9081852529 << 18), -_f2(3368, 0xf233ddc1a2800),
    _f2(17095633, 0x1c132c21ebd41),
    # C4[7], coeff of eps^7, polynomial in n of order 19
    -_f(4693 << 16), -_f(6435 << 17), -_f(37895 << 16), -_f(7579 << 20),
    -_f(428505 << 16), -_f(854413 << 17), -_f(7933835 << 16),
    -_f(11246865 << 18), -_f(338155741 << 16), -_f(0xee3402ee0000),
    -_f(0x1efc2a618f0000), _f(517531990885 << 19),
    -_f(0x243e4ae81d610000), _f2(3081, 0xb7f72703e0000),
    -_f2(10639, 0x4442fa8130000), _f2(25534, 4122358181 << 18),
    -_f2(43524, 0x45cc2f5650000), _f2(51336, 0x52534b86a0000),
    -_f2(35935, 0x6cd3e81170000), _f2(10668, 0x544ee8e52d400),
    _f2(17095633, 0x1c132c21ebd41),
    # C4[8], coeff of eps^26, polynomial in n of order 0
    _f(1703 << 17), _f(0x7c72a9866ac5b),
    # C4[8], coeff of eps^25, polynomial in n of order 1
    -_f(177229 << 20), _f(727155 << 16), _f(0x491cf6cbc520f1),
    # C4[8], coeff of eps^24, polynomial in n of order 2
    -_f(9929683361 << 18), -_f(175790329 << 17), -_f(0x88fc23ec000),
    _f2(40280, 0xc561288d94a7f),
    # C4[8], coeff of eps^23, polynomial in n of order 3
    -_f(11862711753 << 19), _f(5010641713 << 20), -_f(14709027619 << 19),
    _f(0x62bf29e3e8000), _f2(135489, 0xddbb2b5096ef1),
    # C4[8], coeff of eps^22, polynomial in n of order 4
    -_f(6145646087 << 23), _f(131879372361 << 21),
    -_f(33613471903 << 22), -_f(3256336589 << 21),
    -_f(0xacc29a2990000), _f2(1761368, 0x42813317aa23d),
    # C4[8], coeff of eps^21, polynomial in n of order 5
    -_f(0x6a942373c4b << 19), _f(0x26ec3bfe245 << 21),
    -_f(0x8f791d3a3680000), _f(0x11c215e6335 << 20),
    -_f(0x2c38227cc2f << 19), _f(0x4429220c0f48000),
    _f2(19375050, 0xdb8d32044f89f),
    # C4[8], coeff of eps^20, polynomial in n of order 6
    -_f2(2934, 444315969 << 20), _f(0x6a3b64139b1 << 19),
    -_f(467101336651 << 21), _f(0x8d6914ca9b7 << 19),
    -_f(0x1951684536b << 20), -_f(344981960323 << 19),
    -_f(0x1536c8746170000), _f2(19375050, 0xdb8d32044f89f),
    # C4[8], coeff of eps^19, polynomial in n of order 7
    -_f2(3511, 3705843547 << 19), -_f(0x204aea957e3 << 20),
    -_f2(2145, 1225061153 << 19), _f(0x33d58e2ac0f << 21),
    -_f(10655273223 << 19), _f(0x21f191654df << 20),
    -_f(0x4229ae891cd << 19), _f(0x53ff9bb26958000),
    _f2(19375050, 0xdb8d32044f89f),
    # C4[8], coeff of eps^18, polynomial in n of order 8
    _f2(2327, 223378273 << 24), _f2(3002, 681494021 << 21),
    -_f2(5098, 180818405 << 22), -_f(5074441169 << 21),
    -_f(428729715071 << 23), _f(0x3cce86cb309 << 21),
    -_f(434398966071 << 22), -_f(156882519885 << 21),
    -_f(0x33e11620e250000), _f2(19375050, 0xdb8d32044f89f),
    # C4[8], coeff of eps^17, polynomial in n of order 9
    -_f2(6703, 1474120015 << 19), _f2(14458, 426935549 << 22),
    -_f(511886207649 << 19), -_f(39076914681 << 20),
    -_f2(5282, 7254660115 << 19), _f(0x33346658ebd << 21),
    _f(0xd2bcdb640d80000), _f(0x48aecde6f2d << 20),
    -_f(0x66a76bcf857 << 19), _f(0x650db91f67c8000),
    _f2(19375050, 0xdb8d32044f89f),
    # C4[8], coeff of eps^16, polynomial in n of order 10
    -_f2(41674, 2212282947 << 19), -_f2(7593, 6666692295 << 18),
    _f(0x22d5b967639 << 21), _f2(15266, 7870015191 << 18),
    -_f2(4856, 4082442485 << 19), -_f(0x76ec691ccd2c0000),
    -_f2(3302, 2416313159 << 20), _f2(3252, 0xd63fbdd4c0000),
    -_f(0xa56dc66b5380000), -_f(0x5b75ff5133c0000),
    -_f(0x7d0ead839928000), _f2(19375050, 0xdb8d32044f89f),
    # C4[8], coeff of eps^15, polynomial in n of order 11
    _f2(6774, 8529353663 << 19), _f2(68916, 757502869 << 20),
    -_f2(58358, 4821135835 << 19), _f2(3030, 627685345 << 22),
    _f2(8321, 1974413611 << 19), _f2(11199, 994841075 << 20),
    -_f2(10210, 402696815 << 19), -_f(0x10cbfe9c35f << 21),
    -_f(0x88d945e9f480000), _f2(2764, 2004030417 << 20),
    -_f(0xa3f22386a83 << 19), _f(0x6eb0baaefa68000),
    _f2(19375050, 0xdb8d32044f89f),
    # C4[8], coeff of eps^14, polynomial in n of order 12
    _f2(80789, 157273055 << 23), -_f2(92413, 883895019 << 21),
    _f2(33037, 752031121 << 22), _f2(52633, 1725093895 << 21),
    -_f2(71257, 198988971 << 24), _f2(21774, 462183721 << 21),
    _f2(9867, 923099607 << 22), _f2(2235, 815700763 << 21),
    -_f2(11863, 140786955 << 23), _f2(4226, 1910142077 << 21),
    _f(854212143197 << 22), _f(169477509103 << 21),
    -_f(0x1429c96cdeb90000), _f2(19375050, 0xdb8d32044f89f),
    # C4[8], coeff of eps^13, polynomial in n of order 13
    _f2(7986, 2577537059 << 19), -_f2(31049, 1388317679 << 21),
    _f2(71398, 6484881669 << 19), -_f2(96607, 3840488041 << 20),
    _f2(60036, 7375804551 << 19), _f2(24533, 301249307 << 22),
    -_f2(73258, 7729848599 << 19), _f2(45499, 3314021057 << 20),
    -_f(0x3ea6bf07b95 << 19), -_f2(6268, 968456357 << 21),
    -_f2(5889, 8030103219 << 19), _f2(7129, 2010513003 << 20),
    -_f2(2060, 6603694641 << 19), _f(0x4aa8326c4b38000),
    _f2(19375050, 0xdb8d32044f89f),
    # C4[8], coeff of eps^12, polynomial in n of order 14
    _f(110457315575 << 20), -_f(0x55e7441aebb << 19),
    _f2(5489, 1587292819 << 21), -_f2(23107, 1250112621 << 19),
    _f2(59020, 876513493 << 20), -_f2(93669, 6579434335 << 19),
    _f2(83160, 151752881 << 22), -_f2(14191, 6428793873 << 19),
    -_f2(55802, 147123789 << 20), _f2(63340, 7698024701 << 19),
    -_f2(24299, 306146767 << 21), -_f2(2685, 2028352693 << 19),
    _f2(2706, 1245782417 << 20), _f(0xd3e9bdc0259 << 19),
    -_f(0x3e4f75bd92cb0000), _f2(19375050, 0xdb8d32044f89f),
    # C4[8], coeff of eps^11, polynomial in n of order 15
    _f(349722603 << 19), _f(1945948591 << 20), _f(0xe000999c080000),
    -_f(852080688837 << 21), _f2(3397, 2932652343 << 19),
    -_f2(15561, 3567671555 << 20), _f2(44311, 3271472077 << 19),
    -_f2(82040, 520836183 << 22), _f2(95750, 3608174083 << 19),
    -_f2(56326, 3054118709 << 20), -_f2(14075, 6930316647 << 19),
    _f2(56094, 1163367017 << 21), -_f2(46280, 7703552945 << 19),
    _f2(17576, 4216930841 << 20), -_f2(2261, 6650055195 << 19),
    -_f(0xc8e19a260718000), _f2(19375050, 0xdb8d32044f89f),
    # C4[8], coeff of eps^10, polynomial in n of order 16
    _f(53199 << 25), _f(4832235 << 21), _f(18086833 << 22),
    _f(422991569 << 21), _f(3456128781 << 23), -_f(417864400569 << 21),
    _f(0x1c1175e6463 << 22), -_f2(9006, 876789843 << 21),
    _f2(28706, 92601679 << 24), -_f2(61776, 681174429 << 21),
    _f2(90600, 218403669 << 22), -_f2(86125, 255162935 << 21),
    _f2(41671, 220860591 << 23), _f2(9900, 1945963071 << 21),
    -_f2(31426, 812677625 << 22), _f2(21427, 717745189 << 21),
    -_f2(5580, 0x8f2cafdf0000), _f2(19375050, 0xdb8d32044f89f),
    # C4[8], coeff of eps^9, polynomial in n of order 17
    _f(47583 << 19), _f(12411 << 23), _f(964865 << 19),
    _f(2862477 << 20), _f(45013059 << 19), _f(139025201 << 21),
    _f(19339324389 << 19), -_f(313753792905 << 20),
    _f(0x5b827ae7827 << 19), -_f2(4043, 135949957 << 22),
    _f2(14485, 4274671945 << 19), -_f2(36111, 1380328223 << 20),
    _f2(64526, 2642754443 << 19), -_f2(82901, 1325528645 << 21),
    _f2(74876, 5403462445 << 19), -_f2(44997, 1726039605 << 20),
    _f2(16070, 4300719215 << 19), -_f2(2566, 0xd0ea909388000),
    _f2(19375050, 0xdb8d32044f89f),
    # C4[8], coeff of eps^8, polynomial in n of order 18
    _f(1053 << 18), _f(7293 << 17), _f(1749 << 21), _f(121635 << 17),
    _f(309043 << 18), _f(3853577 << 17), _f(8003583 << 19),
    _f(420632751 << 17), _f(7839064905 << 18), -_f(550302356331 << 17),
    _f(754118043861 << 20), -_f(0x433703efa18a0000),
    _f2(4345, 0xa637f297c0000), -_f2(12473, 0x9f7aaa1be0000),
    _f2(26308, 41230677 << 19), -_f2(40979, 0xc6d64da720000),
    _f2(45533, 1464249973 << 18), -_f2(30801, 0xcafec6ea60000),
    _f2(8983, 0xdb34fa045c000), _f2(19375050, 0xdb8d32044f89f),
    # C4[9], coeff of eps^26, polynomial in n of order 0
    _f(3679 << 17), _f(0xf744df0e6c69),
    # C4[9], coeff of eps^25, polynomial in n of order 1
    -_f(48841 << 20), -_f(336765 << 16), _f(0x19892cc90d5217f),
    # C4[9], coeff of eps^24, polynomial in n of order 2
    _f(24659297 << 26), -_f(64440233 << 25), _f(414215087 << 20),
    _f2(45019, 0xaf6c96bc5ad9d),
    # C4[9], coeff of eps^23, polynomial in n of order 3
    _f(0x55f7a92f661 << 19), -_f(0x115bb8ed6d9 << 20),
    -_f(198450589909 << 19), -_f(0xb7278b5afc8000),
    _f2(21654468, 0x9b0737e6b33fd),
    # C4[9], coeff of eps^22, polynomial in n of order 4
    _f(52440485279 << 23), -_f(8663417169 << 21), _f(29836121623 << 22),
    -_f(64017745099 << 21), _f(0x517eabcb370000),
    _f2(1968588, 0xe17edcf27917),
    # C4[9], coeff of eps^21, polynomial in n of order 5
    _f(0x29ddd14eea5 << 19), -_f(683397694747 << 21),
    _f(0x8a9d0ded323 << 19), -_f(0x12a27ad79eb << 20),
    -_f(365440747903 << 19), -_f(0x1a278f54ba58000),
    _f2(21654468, 0x9b0737e6b33fd),
    # C4[9], coeff of eps^20, polynomial in n of order 6
    -_f(258517517319 << 23), -_f2(2449, 779805879 << 22),
    _f(333316352075 << 24), _f(89662817151 << 22),
    _f(311028248083 << 23), -_f(514657501435 << 22),
    _f(0x42edd4687ca0000), _f2(21654468, 0x9b0737e6b33fd),
    # C4[9], coeff of eps^19, polynomial in n of order 7
    _f2(4708, 5969586757 << 19), -_f2(3967, 769306643 << 20),
    -_f(0x4aa5ebcacc1 << 19), -_f(0x2338c762cc1 << 21),
    _f(0xdfce640f299 << 19), -_f(0xee4b32a131 << 20),
    -_f(544152989037 << 19), -_f(0x392f1a561e88000),
    _f2(21654468, 0x9b0737e6b33fd),
    # C4[9], coeff of eps^18, polynomial in n of order 8
    _f2(10651, 141986579 << 24), _f2(2483, 579021431 << 21),
    _f(0x171656e9461 << 22), -_f2(5106, 1475723195 << 21),
    _f(424307179891 << 23), _f(353847768099 << 21),
    _f(0x12b721ceb0b << 22), -_f(0x16800175f8f << 21),
    _f(0x4cd03e8801b0000), _f2(21654468, 0x9b0737e6b33fd),
    # C4[9], coeff of eps^17, polynomial in n of order 9
    -_f2(12598, 568269079 << 19), -_f2(5705, 584195995 << 22),
    _f2(14434, 7986153127 << 19), -_f(0x53c43a7b401 << 20),
    -_f(0xc35a517653b << 19), -_f2(3831, 956767451 << 21),
    _f2(2686, 1674924547 << 19), _f(257168565717 << 20),
    -_f(441477690591 << 19), -_f(0x7fc3df35f858000),
    _f2(21654468, 0x9b0737e6b33fd),
    # C4[9], coeff of eps^16, polynomial in n of order 10
    _f2(73082, 82142393 << 24), -_f2(36372, 269994261 << 23),
    -_f2(8446, 14363443 << 26), _f2(3801, 517661957 << 23),
    _f2(13381, 17268719 << 24), -_f2(7345, 464489969 << 23),
    -_f(211182139987 << 25), -_f(326075858199 << 23),
    _f2(2675, 147207653 << 24), -_f(589098042253 << 23),
    _f(0x4cdddf4aa2c0000), _f2(21654468, 0x9b0737e6b33fd),
    # C4[9], coeff of eps^15, polynomial in n of order 11
    -_f2(70228, 3204573753 << 19), -_f2(3665, 997072835 << 20),
    _f2(67162, 8124243837 << 19), -_f2(56077, 490889175 << 22),
    _f2(5918, 7641432915 << 19), _f2(10294, 3043462539 << 20),
    _f2(5723, 2367840009 << 19), -_f2(10993, 938348055 << 21),
    _f2(2675, 6462906463 << 19), _f(0x3a39e82b059 << 20),
    _f(0xb502c3128a80000), -_f(0x1358f80d9c038000),
    _f2(21654468, 0x9b0737e6b33fd),
    # C4[9], coeff of eps^14, polynomial in n of order 12
    -_f2(45939, 459571779 << 23), _f2(81202, 1438384695 << 21),
    -_f2(84011, 799287213 << 22), _f2(28155, 23125821 << 21),
    _f2(46736, 266493023 << 24), -_f2(68202, 2086496557 << 21),
    _f2(29667, 382040805 << 22), _f2(5608, 647828697 << 21),
    -_f2(4401, 355658689 << 23), -_f2(6763, 1986460369 << 21),
    _f2(6284, 996052535 << 22), -_f(0x31efd65ac4b << 21),
    _f(0x21519ecdd470000), _f2(21654468, 0x9b0737e6b33fd),
    # C4[9], coeff of eps^13, polynomial in n of order 13
    -_f2(2321, 7142809405 << 19), _f2(11407, 565078561 << 21),
    -_f2(34996, 6437021595 << 19), _f2(70236, 3027507143 << 20),
    -_f2(89750, 2730116057 << 19), _f2(59647, 532152523 << 22),
    _f2(10736, 8218389321 << 19), -_f2(61423, 3588044783 << 20),
    _f2(52845, 5572842763 << 19), -_f2(15060, 1433211893 << 21),
    -_f2(4428, 664807251 << 19), _f(0x7ac3d0f14db << 20),
    _f(0xe0ec3bda56f << 19), -_f(0x3854598234228000),
    _f2(21654468, 0x9b0737e6b33fd),
    # C4[9], coeff of eps^12, polynomial in n of order 14
    -_f(2301546703 << 23), _f(147057720589 << 22),
    -_f(359161692259 << 24), _f2(7105, 778398699 << 22),
    -_f2(23999, 359671965 << 23), _f2(54661, 162239065 << 22),
    -_f2(84322, 1670081 << 25), _f2(82245, 254480119 << 22),
    -_f2(34604, 180181675 << 23), -_f2(26937, 29999003 << 22),
    _f2(54122, 167282399 << 24), -_f2(38795, 392755901 << 22),
    _f2(13349, 275194759 << 23), -_f(0x161047343cf << 22),
    -_f(0xd052410afde0000), _f2(21654468, 0x9b0737e6b33fd),
    # C4[9], coeff of eps^11, polynomial in n of order 15
    -_f(33392709 << 19), -_f(215980657 << 20), -_f(15729792143 << 19),
    _f(133575397083 << 21), -_f(0x5183d845f39 << 19),
    _f2(3762, 3694580381 << 20), -_f2(14049, 8382023811 << 19),
    _f2(36325, 545288329 << 22), -_f2(66629, 6532309165 << 19),
    _f2(85703, 4252949035 << 20), -_f2(71810, 6020466679 << 19),
    _f2(27704, 1818174537 << 21), _f2(15098, 409579871 << 19),
    -_f2(29448, 934474951 << 20), _f2(18689, 3410848533 << 19),
    -_f2(4754, 0x309583fd38000), _f2(21654468, 0x9b0737e6b33fd),
    # C4[9], coeff of eps^10, polynomial in n of order 16
    -_f(893 << 25), -_f(92625 << 21), -_f(399779 << 22),
    -_f(10904803 << 21), -_f(105333207 << 23), _f(15302554267 << 21),
    -_f(86594321625 << 22), _f(0xfe4052cb09 << 21),
    -_f2(2108, 118544893 << 24), _f2(6191, 505418439 << 21),
    -_f2(13344, 231933903 << 22), _f2(21384, 2064906293 << 21),
    -_f2(25319, 426528669 << 23), _f2(21525, 1826875827 << 21),
    -_f2(12380, 255070469 << 22), _f2(4285, 1002542497 << 21),
    -_f(0x29d9aac7ec250000), _f2(7218156, 0x33ad12a23bbff),
    # C4[9], coeff of eps^9, polynomial in n of order 17
    -_f(969 << 19), -_f(285 << 23), -_f(25175 << 19), -_f(85595 << 20),
    -_f(1557829 << 19), -_f(5632151 << 21), -_f(929304915 << 19),
    _f(18163686975 << 20), -_f(446826699585 << 19),
    _f(387249806307 << 22), -_f(0xd080dd307cf << 19),
    _f2(5560, 386556505 << 20), -_f2(13900, 1932782525 << 19),
    _f2(26517, 756597539 << 21), -_f2(38450, 1381788619 << 19),
    _f2(40711, 4015921907 << 20), -_f2(26784, 1441242297 << 19),
    _f2(7700, 0x72bfb1ba98000), _f2(21654468, 0x9b0737e6b33fd),
    # C4[10], coeff of eps^26, polynomial in n of order 0
    -_f(5057 << 18), _f(0x10edb70f760db7),
    # C4[10], coeff of eps^25, polynomial in n of order 1
    -_f(4901 << 25), _f(14157 << 21), _f(0x4082f7e0f93b2f),
    # C4[10], coeff of eps^24, polynomial in n of order 2
    -_f(8688787 << 25), -_f(2064227 << 24), -_f(9250461 << 21),
    _f2(7108, 0x5f112546294ad),
    # C4[10], coeff of eps^23, polynomial in n of order 3
    _f(363248763 << 25), _f(3123548769 << 26), -_f(5801671447 << 25),
    _f(14176223919 << 21), _f2(3419126, 0x9f3708d39590d),
    # C4[10], coeff of eps^22, polynomial in n of order 4
    -_f(490568702783 << 22), _f(0x422ec2346b3 << 20),
    -_f(446296001151 << 21), -_f(174052882927 << 20),
    -_f(0xed1818f25b << 17), _f2(23933886, 0x5a813dc916f5b),
    # C4[10], coeff of eps^21, polynomial in n of order 5
    -_f2(2585, 173491781 << 22), _f(226504425479 << 24),
    _f(118144668093 << 22), _f(325346294119 << 23),
    -_f(464280225409 << 22), _f(919092918513 << 18),
    _f2(23933886, 0x5a813dc916f5b),
    # C4[10], coeff of eps^20, polynomial in n of order 6
    -_f2(2656, 138725573 << 22), -_f(0x1a9c614c5c3 << 21),
    -_f(765139808215 << 23), _f(0x32058af918b << 21),
    -_f(117685929879 << 22), -_f(106680176295 << 21),
    -_f(0xf144800341 << 18), _f2(23933886, 0x5a813dc916f5b),
    # C4[10], coeff of eps^19, polynomial in n of order 7
    _f2(3432, 329072245 << 22), _f2(2930, 283183745 << 23),
    -_f2(4577, 1044295185 << 22), _f(34786730571 << 24),
    _f(54685893801 << 22), _f(647412775723 << 23),
    -_f(676279973341 << 22), _f(0xe9c610e7bd << 18),
    _f2(23933886, 0x5a813dc916f5b),
    # C4[10], coeff of eps^18, polynomial in n of order 8
    -_f2(11084, 235058537 << 23), _f2(11858, 1143524977 << 20),
    _f(0x2545fd77485 << 21), -_f(0x307c82cee9d << 20),
    -_f2(4103, 193833065 << 22), _f2(2140, 2163909077 << 20),
    _f(446041302231 << 21), -_f(54302113593 << 20),
    -_f(0x7f8004b3e7a0000), _f2(23933886, 0x5a813dc916f5b),
    # C4[10], coeff of eps^17, polynomial in n of order 9
    -_f2(16525, 309616105 << 23), -_f2(12873, 31213113 << 26),
    -_f(811482588455 << 23), _f2(13789, 37992821 << 24),
    -_f2(4637, 221662373 << 23), -_f(274288421561 << 25),
    -_f(562238052579 << 23), _f2(2541, 30117927 << 24),
    -_f(493061811809 << 23), _f(451991259993 << 19),
    _f2(23933886, 0x5a813dc916f5b),
    # C4[10], coeff of eps^16, polynomial in n of order 10
    -_f2(4541, 277413243 << 23), _f2(9880, 364937465 << 22),
    -_f2(5569, 118974143 << 25), -_f(671603509225 << 22),
    _f(626562721155 << 23), _f(0x126f9949db5 << 22),
    -_f(372257463743 << 24), _f(225505748691 << 22),
    _f(72729834113 << 23), _f(40056084593 << 22),
    -_f(360891225041 << 19), _f2(3419126, 0x9f3708d39590d),
    # C4[10], coeff of eps^15, polynomial in n of order 11
    _f2(82722, 490551845 << 23), -_f2(64701, 63547469 << 24),
    _f(116234844999 << 23), _f2(58506, 49315063 << 26),
    -_f2(58413, 433206103 << 23), _f2(16792, 103491845 << 24),
    _f2(8555, 183955915 << 23), -_f2(2317, 84066185 << 25),
    -_f2(7194, 11825619 << 23), _f2(5493, 119743831 << 24),
    -_f(667673139889 << 23), _f(58009080297 << 19),
    _f2(23933886, 0x5a813dc916f5b),
    # C4[10], coeff of eps^14, polynomial in n of order 12
    _f2(18981, 396462873 << 22), -_f2(46078, 2701457279 << 20),
    _f2(76015, 1126083519 << 21), -_f2(79652, 3524648005 << 20),
    _f2(36586, 273717939 << 23), _f2(28474, 1008822389 << 20),
    -_f2(61326, 649857063 << 21), _f2(42595, 3757087663 << 20),
    -_f2(8326, 955589709 << 22), -_f2(5139, 3984305559 << 20),
    _f(0x284545d9df3 << 21), _f(0x72b007891a3 << 20),
    -_f(0x33009c87a9620000), _f2(23933886, 0x5a813dc916f5b),
    # C4[10], coeff of eps^13, polynomial in n of order 13
    _f(543312976219 << 22), -_f2(3062, 112501267 << 24),
    _f2(11988, 59347917 << 22), -_f2(32439, 32307605 << 23),
    _f2(61980, 821355519 << 22), -_f2(81948, 80095793 << 25),
    _f2(67313, 1055324017 << 22), -_f2(16748, 109351667 << 23),
    -_f2(34832, 1017554013 << 22), _f2(50577, 16270159 << 24),
    -_f2(32450, 61276651 << 22), _f2(10213, 501613231 << 23),
    -_f(913358656441 << 22), -_f(0xcb30b375e9c0000),
    _f2(23933886, 0x5a813dc916f5b),
    # C4[10], coeff of eps^12, polynomial in n of order 14
    _f(553451171 << 22), -_f(41782403663 << 21), _f(122732484303 << 23),
    -_f(0x2eaf28525b9 << 21), _f2(6402, 476837273 << 22),
    -_f2(19347, 183862947 << 21), _f2(42585, 247358789 << 24),
    -_f2(68666, 1206346765 << 21), _f2(79038, 878189199 << 22),
    -_f2(58930, 1207602423 << 21), _f2(17031, 374958661 << 23),
    _f2(18189, 4759455 << 21), -_f2(27348, 414989947 << 22),
    _f2(16435, 1788023477 << 21), -_f2(4106, 0xe7ddb41f40000),
    _f2(23933886, 0x5a813dc916f5b),
    # C4[10], coeff of eps^11, polynomial in n of order 15
    _f(259293 << 22), _f(1935549 << 23), _f(164593143 << 22),
    -_f(1654671183 << 24), _f(83533307473 << 22),
    -_f(296200453241 << 23), _f2(2600, 89083243 << 22),
    -_f2(8792, 113023813 << 25), _f2(22203, 397075141 << 22),
    -_f2(42668, 107392175 << 23), _f2(62615, 179754463 << 22),
    -_f2(69317, 125076421 << 24), _f2(56036, 868613689 << 22),
    -_f2(31065, 284420581 << 23), _f2(10475, 628806483 << 22),
    -_f(0x6470cd13038c0000), _f2(23933886, 0x5a813dc916f5b),
    # C4[10], coeff of eps^10, polynomial in n of order 16
    _f(133 << 24), _f(15675 << 20), _f(77539 << 21), _f(2448017 << 20),
    _f(27681423 << 22), -_f(4770431897 << 20), _f(32525672025 << 21),
    -_f(503497402947 << 20), _f(327672913029 << 23),
    -_f2(2314, 857372269 << 20), _f2(6672, 231933903 << 21),
    -_f2(14969, 2031875351 << 20), _f2(26346, 292729733 << 22),
    -_f2(36032, 1727726401 << 20), _f2(36664, 1180419909 << 21),
    -_f2(23570, 290549227 << 20), _f2(6696, 0xabcf39720000),
    _f2(23933886, 0x5a813dc916f5b),
    # C4[11], coeff of eps^26, polynomial in n of order 0
    _f(611 << 23), _f(0xe6baee73ea363),
    # C4[11], coeff of eps^25, polynomial in n of order 1
    -_f(76597 << 26), -_f(1573935 << 21), _f(0x477bca00497fe9bf),
    # C4[11], coeff of eps^24, polynomial in n of order 2
    _f(5977365 << 29), -_f(9705069 << 28), _f(85309807 << 22),
    _f2(54497, 0x83837319e73d9),
    # C4[11], coeff of eps^23, polynomial in n of order 3
    _f(66340583679 << 26), -_f(4467880351 << 27), -_f(2404066379 << 26),
    -_f(68755156353 << 21), _f2(26213304, 0x19fb43ab7aab9),
    # C4[11], coeff of eps^22, polynomial in n of order 4
    _f(257415529 << 33), _f(402685503 << 30), _f(652792679 << 32),
    -_f(1631824579 << 30), _f(23005724469 << 23),
    _f2(26213304, 0x19fb43ab7aab9),
    # C4[11], coeff of eps^21, polynomial in n of order 5
    -_f(453253333179 << 23), -_f(222902987187 << 25),
    _f(749255628291 << 23), -_f(3378231395 << 24),
    -_f(18492933151 << 23), -_f(0xf79dae93c9 << 18),
    _f2(26213304, 0x19fb43ab7aab9),
    # C4[11], coeff of eps^20, polynomial in n of order 6
    _f2(4082, 27256381 << 26), -_f2(3843, 110832251 << 25),
    -_f(11608614857 << 27), -_f(12679113309 << 25),
    _f(80017732991 << 26), -_f(73865834735 << 25),
    _f(381345882225 << 19), _f2(26213304, 0x19fb43ab7aab9),
    # C4[11], coeff of eps^19, polynomial in n of order 7
    _f2(8515, 117356323 << 23), _f2(2727, 54002259 << 24),
    _f(95356337593 << 23), -_f2(4154, 53817247 << 25),
    _f(882540340143 << 23), _f(80081392881 << 24), _f(12076046661 << 23),
    -_f(0x7d57ec14bd40000), _f2(26213304, 0x19fb43ab7aab9),
    # C4[11], coeff of eps^18, polynomial in n of order 8
    -_f2(12505, 951035 << 32), -_f2(6194, 13758139 << 28),
    _f2(12920, 711829 << 30), -_f2(2328, 16199449 << 28),
    -_f2(2121, 1768403 << 31), -_f(23812716991 << 28),
    _f2(2380, 3848439 << 30), -_f(12910651229 << 28),
    _f(75285764519 << 21), _f2(26213304, 0x19fb43ab7aab9),
    # C4[11], coeff of eps^17, polynomial in n of order 9
    _f2(63004, 136371221 << 24), -_f2(23253, 27876759 << 27),
    -_f2(10033, 153577157 << 24), _f2(4968, 6981291 << 25),
    _f2(9826, 264428161 << 24), -_f2(8260, 44635479 << 26),
    _f(151361303079 << 24), _f(120235734969 << 25),
    _f(86414162541 << 24), -_f(0x22b971cd551 << 19),
    _f2(26213304, 0x19fb43ab7aab9),
    # C4[11], coeff of eps^16, polynomial in n of order 10
    -_f2(42751, 388403 << 27), -_f2(21692, 36263017 << 26),
    _f2(62310, 8348465 << 29), -_f2(46929, 14252519 << 26),
    _f2(7047, 32285691 << 27), _f2(9444, 49195723 << 26),
    -_f(6177911663 << 28), -_f2(7300, 34477811 << 26),
    _f2(4777, 27041001 << 27), -_f(65141092289 << 26),
    -_f(44359884933 << 20), _f2(26213304, 0x19fb43ab7aab9),
    # C4[11], coeff of eps^15, polynomial in n of order 11
    -_f2(54975, 7679265 << 24), _f2(76586, 39901517 << 25),
    -_f2(65943, 41351227 << 24), _f2(16034, 25331417 << 27),
    _f2(40019, 7760011 << 24), -_f2(57816, 89862917 << 25),
    _f2(33374, 245812081 << 24), -_f2(3538, 1406183 << 26),
    -_f2(5247, 183755081 << 24), _f(95390660393 << 25),
    _f(490233600157 << 24), -_f(0x5c9b8397461 << 19),
    _f2(26213304, 0x19fb43ab7aab9),
    # C4[11], coeff of eps^14, polynomial in n of order 12
    -_f2(5607, 843033 << 31), _f2(17587, 15869457 << 28),
    -_f2(40024, 1555693 << 30), _f2(66142, 8872067 << 28),
    -_f2(76302, 93659 << 32), _f2(52531, 9300813 << 28),
    -_f2(2628, 1860027 << 30), -_f2(39200, 13058241 << 28),
    _f2(46365, 693773 << 31), -_f2(27149, 11145943 << 28),
    _f2(7864, 1548807 << 30), -_f(7962030629 << 28),
    -_f(412888159761 << 21), _f2(26213304, 0x19fb43ab7aab9),
    # C4[11], coeff of eps^13, polynomial in n of order 13
    -_f(41790907379 << 23), _f(76324858599 << 25),
    -_f2(2753, 104130613 << 23), _f2(9526, 224954257 << 24),
    -_f2(24463, 68256343 << 23), _f2(47309, 29696781 << 26),
    -_f2(68504, 135442201 << 23), _f2(71563, 253449815 << 24),
    -_f2(47678, 505267003 << 23), _f2(8918, 86883405 << 25),
    _f2(19900, 176522371 << 23), -_f2(25292, 67707491 << 24),
    _f2(14565, 326677345 << 23), -_f2(3589, 0xb1b7cdcc40000),
    _f2(26213304, 0x19fb43ab7aab9),
    # C4[11], coeff of eps^12, polynomial in n of order 14
    -_f(2670507 << 26), _f(235653561 << 25), -_f(820617391 << 27),
    _f(25869702111 << 25), -_f(68305888497 << 26),
    _f2(3896, 38584213 << 25), -_f2(11280, 10173573 << 28),
    _f2(25274, 31321979 << 25), -_f2(44240, 19038327 << 26),
    _f2(60354, 128468529 << 25), -_f2(63152, 8090597 << 27),
    _f2(48923, 66496087 << 25), -_f2(26288, 683965 << 26),
    _f2(8669, 60420749 << 25), -_f(0xa3ae57ad353 << 19),
    _f2(26213304, 0x19fb43ab7aab9),
    # C4[11], coeff of eps^11, polynomial in n of order 15
    -_f(3933 << 23), -_f(33649 << 24), -_f(3312023 << 23),
    _f(38979963 << 25), -_f(2334466673 << 23), _f(9974539421 << 24),
    -_f(115419670443 << 23), _f(61272170729 << 26),
    -_f2(2977, 381931269 << 23), _f2(7656, 260966955 << 24),
    -_f2(15739, 178079295 << 23), _f2(25923, 81221929 << 25),
    -_f2(33768, 486785817 << 23), _f2(33232, 239529529 << 24),
    -_f2(20951, 91935571 << 23), _f2(5892, 8880483819 << 18),
    _f2(26213304, 0x19fb43ab7aab9),
    # C4[12], coeff of eps^26, polynomial in n of order 0
    -_f(1 << 33), _f(0x2f0618f20f09a7),
    # C4[12], coeff of eps^25, polynomial in n of order 1
    -_f(62273 << 28), _f(123651 << 24), _f(0x19e65bbd524850fb),
    # C4[12], coeff of eps^24, polynomial in n of order 2
    -_f(93684917 << 28), -_f(76423549 << 27), -_f(693037063 << 24),
    _f2(2191747, 0xd5a68f81111b3),
    # C4[12], coeff of eps^23, polynomial in n of order 3
    _f(311968535 << 28), _f(1760740793 << 29), -_f(1954369859 << 28),
    _f(3073971433 << 24), _f2(9497573, 0xf32718849f75d),
    # C4[12], coeff of eps^22, polynomial in n of order 4
    -_f(7646768769 << 30), _f(19951096269 << 28), _f(491010815 << 29),
    -_f(320366609 << 28), -_f(523396783 << 29),
    _f2(28492721, 0xd975498dde617),
    # C4[12], coeff of eps^21, polynomial in n of order 5
    -_f2(3026, 1811699 << 28), -_f(2760169147 << 30),
    -_f(4156137093 << 28), _f(9751170709 << 29), -_f(8065022455 << 28),
    _f(9009785085 << 24), _f2(28492721, 0xd975498dde617),
    # C4[12], coeff of eps^20, polynomial in n of order 6
    _f2(3415, 105419659 << 25), _f(300203870565 << 24),
    -_f2(4036, 50457863 << 26), _f(324492084003 << 24),
    _f(46663751897 << 25), _f(14263553185 << 24),
    -_f(262021003825 << 21), _f2(28492721, 0xd975498dde617),
    # C4[12], coeff of eps^19, polynomial in n of order 7
    -_f2(9657, 23913255 << 26), _f2(11274, 14202393 << 27),
    -_f(33749559685 << 26), -_f(32700069373 << 28),
    -_f(114920432067 << 26), _f2(2209, 3347763 << 27),
    -_f(43334519585 << 26), _f(23877094395 << 22),
    _f2(28492721, 0xd975498dde617),
    # C4[12], coeff of eps^18, polynomial in n of order 8
    -_f2(10357, 4316059 << 29), -_f2(12252, 51976653 << 26),
    _f(53111513007 << 27), _f2(10573, 38618953 << 26),
    -_f2(6814, 7336347 << 28), -_f(6527663009 << 26),
    _f(27052895205 << 27), _f(24601392501 << 26), -_f(17553357101 << 26),
    _f2(28492721, 0xd975498dde617),
    # C4[12], coeff of eps^17, polynomial in n of order 9
    -_f2(37197, 16059447 << 26), _f2(60620, 6214685 << 29),
    -_f2(35564, 62593849 << 26), _f(3388754439 << 27),
    _f2(9080, 41918565 << 26), _f(21802684253 << 28),
    -_f2(7184, 50608669 << 26), _f2(4144, 5922861 << 27),
    -_f(50938551167 << 26), -_f(22779400371 << 22),
    _f2(28492721, 0xd975498dde617),
    # C4[12], coeff of eps^16, polynomial in n of order 10
    _f2(72847, 10250567 << 26), -_f2(50730, 68954325 << 25),
    -_f(18441684165 << 28), _f2(46646, 59050757 << 25),
    -_f2(52485, 42154095 << 26), _f2(25457, 83058719 << 25),
    -_f(7107757125 << 27), -_f2(5015, 25213703 << 25),
    _f(15647388379 << 26), _f(240182800403 << 25),
    -_f(724544787239 << 22), _f2(28492721, 0xd975498dde617),
    # C4[12], coeff of eps^15, polynomial in n of order 11
    _f2(23399, 60546659 << 26), -_f2(46215, 22779895 << 27),
    _f2(67437, 13577137 << 26), -_f2(68612, 7311579 << 29),
    _f2(38802, 65276767 << 26), _f2(8195, 42655 << 27),
    -_f2(41126, 40169811 << 26), _f2(42002, 3198053 << 28),
    -_f2(22751, 40888613 << 26), _f2(6086, 3052981 << 27),
    -_f(14786628311 << 26), -_f(192226168043 << 22),
    _f2(28492721, 0xd975498dde617),
    # C4[12], coeff of eps^14, polynomial in n of order 12
    _f(18933494775 << 28), -_f2(4401, 33536241 << 26),
    _f2(12915, 15192945 << 27), -_f2(29094, 11527179 << 26),
    _f2(50530, 7111165 << 29), -_f2(66729, 34095909 << 26),
    _f2(63904, 14901367 << 27), -_f2(38025, 42880575 << 26),
    _f2(2775, 16493565 << 28), _f2(20705, 54393511 << 26),
    -_f2(23355, 27541123 << 27), _f2(12999, 62947213 << 26),
    -_f2(3169, 31971073 << 26), _f2(28492721, 0xd975498dde617),
    # C4[12], coeff of eps^13, polynomial in n of order 13
    _f(168754105 << 26), -_f(365884805 << 28), _f(8561579455 << 26),
    -_f(18298927075 << 27), _f(119493273445 << 26),
    -_f2(4555, 4035095 << 29), _f2(9255, 49236715 << 26),
    -_f2(14989, 8672597 << 27), _f2(19228, 2329233 << 26),
    -_f2(19175, 5958615 << 28), _f2(14321, 64798871 << 26),
    -_f2(7491, 16431175 << 27), _f2(2423, 48133949 << 26),
    -_f(387864634927 << 22), _f2(9497573, 0xf32718849f75d),
    # C4[12], coeff of eps^12, polynomial in n of order 14
    _f(198835 << 25), -_f(20309575 << 24), _f(82800575 << 26),
    -_f(3096741505 << 24), _f(9853268425 << 25), -_f(92620723195 << 24),
    _f(42100328725 << 27), -_f2(3631, 95393589 << 24),
    _f2(8507, 100242399 << 25), -_f2(16264, 217481391 << 24),
    _f2(25338, 57859733 << 26), -_f2(31673, 155080937 << 24),
    _f2(30296, 62498037 << 25), -_f2(18783, 217084003 << 24),
    _f2(5237, 1702548307 << 21), _f2(28492721, 0xd975498dde617),
    # C4[13], coeff of eps^26, polynomial in n of order 0
    _f(83 << 25), _f(0xb952c68e4fbe9),
    # C4[13], coeff of eps^25, polynomial in n of order 1
    -_f(71903 << 28), -_f(1749945 << 24), _f2(5818, 0x23b391cd899ed),
    # C4[13], coeff of eps^24, polynomial in n of order 2
    _f(16903565 << 32), -_f(16862357 << 31), _f(47373573 << 26),
    _f2(789029, 0x386f296be7703),
    # C4[13], coeff of eps^23, polynomial in n of order 3
    _f(16624462311 << 28), _f(913717761 << 29), -_f(74700691 << 28),
    -_f(16672249061 << 24), _f2(30772139, 0x98ef4f7042175),
    # C4[13], coeff of eps^22, polynomial in n of order 4
    -_f(876500127 << 32), -_f(1654287687 << 30), _f(2350551113 << 31),
    -_f(1761427069 << 30), _f(3376471371 << 25),
    _f2(30772139, 0x98ef4f7042175),
    # C4[13], coeff of eps^21, polynomial in n of order 5
    _f(32655563463 << 28), -_f2(3801, 39657 << 30), _f(14063722833 << 28),
    _f(3085833575 << 29), _f(1328082427 << 28), -_f(31671991379 << 24),
    _f2(30772139, 0x98ef4f7042175),
    # C4[13], coeff of eps^20, polynomial in n of order 6
    _f2(9254, 348341 << 33), _f(891770565 << 32), -_f(427379969 << 34),
    -_f(2022490653 << 32), _f(1067054247 << 33), -_f(569056495 << 32),
    _f(430257975 << 27), _f2(30772139, 0x98ef4f7042175),
    # C4[13], coeff of eps^19, polynomial in n of order 7
    -_f2(12155, 12992869 << 26), -_f(50480950653 << 27),
    _f2(10690, 33612001 << 26), -_f2(5460, 12466223 << 28),
    -_f(37884419769 << 26), _f(23471963137 << 27), _f(26726056077 << 26),
    -_f(264030652949 << 22), _f2(30772139, 0x98ef4f7042175),
    # C4[13], coeff of eps^18, polynomial in n of order 8
    _f2(55507, 1702051 << 31), -_f2(25284, 15301089 << 28),
    -_f2(4552, 6848911 << 29), _f2(8014, 12209149 << 28),
    _f2(2646, 1117571 << 30), -_f2(6924, 9493077 << 28),
    _f2(3590, 1368763 << 29), -_f(9963972599 << 28),
    -_f(15032559759 << 23), _f2(30772139, 0x98ef4f7042175),
    # C4[13], coeff of eps^17, polynomial in n of order 9
    -_f2(35540, 37090525 << 26), -_f2(14632, 1678969 << 29),
    _f2(49583, 4861453 << 26), -_f2(46373, 31739579 << 27),
    _f2(18858, 13991831 << 26), _f(34153973959 << 28),
    -_f2(4603, 63875327 << 26), -_f(5127820649 << 27),
    _f(116479282059 << 26), -_f(662201165171 << 22),
    _f2(30772139, 0x98ef4f7042175),
    # C4[13], coeff of eps^16, polynomial in n of order 10
    -_f2(50761, 3025121 << 30), _f2(66355, 4425085 << 29),
    -_f2(59858, 324757 << 32), _f2(26575, 1103635 << 29),
    _f2(16255, 479225 << 30), -_f2(41402, 7301831 << 29),
    _f2(37768, 714123 << 31), -_f2(19110, 4265457 << 29),
    _f2(4727, 1747987 << 30), -_f(399638603 << 29),
    -_f(44359884933 << 24), _f2(30772139, 0x98ef4f7042175),
    # C4[13], coeff of eps^15, polynomial in n of order 11
    -_f2(6366, 57157311 << 26), _f2(16360, 10192555 << 27),
    -_f2(33060, 46450725 << 26), _f2(52401, 3371487 << 29),
    -_f2(63840, 37321515 << 26), _f2(56445, 29554125 << 27),
    -_f2(29837, 31975057 << 26), -_f(31142569185 << 28),
    _f2(20917, 29855465 << 26), -_f2(21569, 9966225 << 27),
    _f2(11677, 61095555 << 26), -_f2(2823, 85634603 << 22),
    _f2(30772139, 0x98ef4f7042175),
    # C4[13], coeff of eps^14, polynomial in n of order 12
    -_f(583637535 << 30), _f(11022475035 << 28),
    -_f2(2387, 6604529 << 29), _f2(6865, 10202825 << 28),
    -_f2(15869, 914837 << 31), _f2(29710, 9184775 << 28),
    -_f2(45043, 8145271 << 29), _f2(54812, 7153333 << 28),
    -_f2(52441, 1442741 << 30), _f2(37945, 12833459 << 28),
    -_f2(19389, 6190909 << 29), _f2(6169, 7752673 << 28),
    -_f(487958734263 << 23), _f2(30772139, 0x98ef4f7042175),
    # C4[13], coeff of eps^13, polynomial in n of order 13
    -_f(23263695 << 26), _f(59053995 << 28), -_f(1639451385 << 26),
    _f(4222829325 << 27), -_f(33859413315 << 26), _f(13601644665 << 29),
    -_f2(4256, 19212781 << 26), _f2(9227, 30696251 << 27),
    -_f2(16594, 3848759 << 26), _f2(24654, 470841 << 28),
    -_f2(29745, 41662305 << 26), _f2(27762, 19442409 << 27),
    -_f2(16966, 1393323 << 26), _f2(4695, 1022390371 << 22),
    _f2(30772139, 0x98ef4f7042175),
    # C4[14], coeff of eps^26, polynomial in n of order 0
    -_f(6781 << 26), _f(0x5fa345ccc643905),
    # C4[14], coeff of eps^25, polynomial in n of order 1
    -_f(5869 << 31), _f(7353 << 27), _f(0x148e6926290dbdd9),
    # C4[14], coeff of eps^24, polynomial in n of order 2
    _f(299903009 << 31), _f(37927009 << 30), -_f(2056312073 << 27),
    _f2(33051557, 0x58695552a5cd3),
    # C4[14], coeff of eps^23, polynomial in n of order 3
    -_f(368055047 << 31), _f(374500339 << 32), -_f(256592557 << 31),
    _f(207940889 << 27), _f2(11017185, 0xc8231c70e1ef1),
    # C4[14], coeff of eps^22, polynomial in n of order 4
    -_f2(3490, 1015519 << 31), _f(4441335459 << 29), _f(1543166497 << 30),
    _f(845740769 << 29), -_f(7622621279 << 26),
    _f2(33051557, 0x58695552a5cd3),
    # C4[14], coeff of eps^21, polynomial in n of order 5
    _f(1872610391 << 32), -_f(324912469 << 34), -_f2(2076, 886527 << 32),
    _f(978081451 << 33), -_f(478972501 << 32), _f(98710857 << 28),
    _f2(33051557, 0x58695552a5cd3),
    # C4[14], coeff of eps^20, polynomial in n of order 6
    -_f2(4075, 185993 << 32), _f2(10359, 933297 << 31),
    -_f2(4245, 239235 << 33), -_f(1849695177 << 31), _f(616423549 << 32),
    _f(879958205 << 31), -_f(3876332285 << 28),
    _f2(33051557, 0x58695552a5cd3),
    # C4[14], coeff of eps^19, polynomial in n of order 7
    -_f2(16507, 1038671 << 32), -_f2(7426, 284587 << 33),
    _f2(6609, 461219 << 32), _f2(3685, 34759 << 34),
    -_f2(6576, 786795 << 32), _f2(3109, 191175 << 33),
    -_f(486788729 << 32), -_f(537600147 << 28),
    _f2(33051557, 0x58695552a5cd3),
    # C4[14], coeff of eps^18, polynomial in n of order 8
    -_f2(24788, 2034733 << 30), _f2(49876, 16016773 << 27),
    -_f2(40130, 10305415 << 28), _f2(13469, 4482399 << 27),
    _f2(3498, 5005267 << 29), -_f2(4111, 23511239 << 27),
    -_f(7714983213 << 28), _f(56106110739 << 27),
    -_f(151831927709 << 24), _f2(33051557, 0x58695552a5cd3),
    # C4[14], coeff of eps^17, polynomial in n of order 9
    _f2(63443, 3600701 << 29), -_f2(50757, 496203 << 32),
    _f2(16003, 4273171 << 29), _f2(22072, 52127 << 30),
    -_f2(40595, 5066263 << 29), _f2(33806, 1004469 << 31),
    -_f2(16095, 1666881 << 29), _f2(3680, 908597 << 30),
    _f(584087189 << 29), -_f(20381568753 << 25),
    _f2(33051557, 0x58695552a5cd3),
    # C4[14], coeff of eps^16, polynomial in n of order 10
    _f2(19689, 3969453 << 29), -_f2(36282, 12968943 << 28),
    _f2(53123, 80009 << 31), -_f2(60234, 3770241 << 28),
    _f2(49410, 2521755 << 29), -_f2(22943, 4183315 << 28),
    -_f2(5331, 2542455 << 30), _f2(20742, 9731931 << 28),
    -_f2(19939, 3671159 << 29), _f2(10552, 6717897 << 28),
    -_f2(2533, 118946129 << 25), _f2(33051557, 0x58695552a5cd3),
    # C4[14], coeff of eps^15, polynomial in n of order 11
    _f(8533174455 << 29), -_f2(3246, 843591 << 30),
    _f2(8406, 531117 << 29), -_f2(17842, 647003 << 32),
    _f2(31156, 7375267 << 29), -_f2(44630, 771985 << 30),
    _f2(51879, 2231193 << 29), -_f2(47870, 1100123 << 31),
    _f2(33689, 2160271 << 29), -_f2(16864, 3290075 << 30),
    _f2(5288, 925829 << 29), -_f(103506398177 << 25),
    _f2(33051557, 0x58695552a5cd3),
    # C4[14], coeff of eps^14, polynomial in n of order 12
    _f(66723345 << 29), -_f(1495097175 << 27), _f(3274386375 << 28),
    -_f(23122205325 << 27), _f(8392504155 << 30),
    -_f2(4840, 16188355 << 27), _f2(9826, 9115409 << 28),
    -_f2(16767, 17260281 << 27), _f2(23911, 7831387 << 29),
    -_f2(27976, 32288815 << 27), _f2(25559, 3357275 << 28),
    -_f2(15423, 21986149 << 27), _f2(4241, 135611051 << 24),
    _f2(33051557, 0x58695552a5cd3),
    # C4[15], coeff of eps^26, polynomial in n of order 0
    _f(71 << 30), _f(0x2213ecbbb96785d),
    # C4[15], coeff of eps^25, polynomial in n of order 1
    _f(6799 << 34), -_f(2467695 << 27), _f2(43244, 0xc47e8e0e2a501),
    # C4[15], coeff of eps^24, polynomial in n of order 2
    _f(1754601 << 37), -_f(1107369 << 36), _f(11866753 << 28),
    _f2(1859525, 0x141dc611b72b),
    # C4[15], coeff of eps^23, polynomial in n of order 3
    _f(72562737 << 34), _f(46462031 << 35), _f(31074907 << 34),
    -_f(3658156407 << 27), _f2(35330975, 0x17e35b3509831),
    # C4[15], coeff of eps^22, polynomial in n of order 4
    -_f(13531387 << 38), -_f2(2167, 14381 << 36), _f(55828981 << 37),
    -_f(25230703 << 36), _f(3197649 << 30),
    _f2(35330975, 0x17e35b3509831),
    # C4[15], coeff of eps^21, polynomial in n of order 5
    _f2(9732, 8631 << 37), -_f2(3185, 3623 << 39), -_f(35580543 << 37),
    _f(7839601 << 38), _f(14184443 << 37), -_f(3642815981 << 28),
    _f2(35330975, 0x17e35b3509831),
    # C4[15], coeff of eps^20, polynomial in n of order 6
    -_f2(8973, 2493 << 39), _f2(5093, 1677 << 40), _f2(4452, 53 << 40),
    -_f2(6181, 1625 << 40), _f2(2693, 7137 << 39), -_f(1482145 << 40),
    -_f(287239701 << 29), _f2(35330975, 0x17e35b3509831),
    # C4[15], coeff of eps^19, polynomial in n of order 7
    _f2(48363, 42681 << 36), -_f2(34138, 1171 << 37),
    _f2(9135, 63227 << 36), _f2(4396, 12847 << 38), -_f2(3596, 33667 << 36),
    -_f(22964529 << 37), _f(105092799 << 36), -_f(8732815777 << 28),
    _f2(35330975, 0x17e35b3509831),
    # C4[15], coeff of eps^18, polynomial in n of order 8
    -_f2(41806, 3793 << 39), _f2(7070, 18565 << 36),
    _f2(26107, 27709 << 37), -_f2(39103, 10113 << 36),
    _f2(30179, 111 << 38), -_f2(13593, 42919 << 36), _f2(2866, 20031 << 37),
    _f(9747283 << 36), -_f(584087189 << 30),
    _f2(35330975, 0x17e35b3509831),
    # C4[15], coeff of eps^17, polynomial in n of order 9
    -_f2(38751, 968439 << 32), _f2(52907, 129341 << 35),
    -_f2(56213, 262777 << 32), _f2(42911, 476327 << 33),
    -_f2(17166, 1038043 << 32), -_f2(7920, 60547 << 34),
    _f2(20320, 95267 << 32), -_f2(18461, 171251 << 33),
    _f2(9586, 798401 << 32), -_f2(2289, 97706315 << 25),
    _f2(35330975, 0x17e35b3509831),
    # C4[15], coeff of eps^16, polynomial in n of order 10
    -_f(182681295 << 35), _f2(3304, 139139 << 34), -_f2(6521, 16667 << 37),
    _f2(10722, 226797 << 34), -_f2(14618, 113609 << 35),
    _f2(16325, 9799 << 34), -_f2(14590, 57403 << 36),
    _f2(10019, 97137 << 34), -_f2(4925, 40451 << 35), _f(399638603 << 34),
    -_f(14786628311 << 26), _f2(11776991, 0xb2a11e67032bb),
    # C4[15], coeff of eps^15, polynomial in n of order 11
    -_f(76608285 << 32), _f(147323625 << 33), -_f(936978255 << 32),
    _f2(2382, 112581 << 35), -_f2(5377, 114593 << 32),
    _f2(10315, 142015 << 33), -_f2(16818, 394707 << 32),
    _f2(23142, 22533 << 34), -_f2(26356, 277413 << 32),
    _f2(23629, 395541 << 33), -_f2(14101, 658135 << 32),
    _f2(3855, 122649445 << 25), _f2(35330975, 0x17e35b3509831),
    # C4[16], coeff of eps^26, polynomial in n of order 0
    -_f(22951 << 32), _f2(14038, 0xf79362a6f2da9),
    # C4[16], coeff of eps^25, polynomial in n of order 1
    -_f(9017 << 35), _f(4815 << 31), _f2(9206, 0xf354c01a236f3),
    # C4[16], coeff of eps^24, polynomial in n of order 2
    _f(1146319 << 36), _f(916151 << 35), -_f(5763591 << 32),
    _f2(1979494, 0x5c2d55f3c2615),
    # C4[16], coeff of eps^23, polynomial in n of order 3
    -_f(15250071 << 35), _f(5353311 << 36), -_f(2240893 << 35),
    -_f(332469 << 31), _f2(1979494, 0x5c2d55f3c2615),
    # C4[16], coeff of eps^22, polynomial in n of order 4
    -_f2(2280, 6539 << 38), -_f(78951693 << 36), _f(12301989 << 37),
    _f(28829297 << 36), -_f(214091115 << 32),
    _f2(37610392, 0xd75d61176d38f),
    # C4[16], coeff of eps^21, polynomial in n of order 5
    _f2(3604, 40151 << 35), _f2(4989, 25591 << 37), -_f2(5766, 5439 << 35),
    _f2(2335, 38023 << 36), -_f(36776117 << 35), -_f(73810821 << 31),
    _f2(37610392, 0xd75d61176d38f),
    # C4[16], coeff of eps^20, polynomial in n of order 6
    -_f2(28603, 8635 << 37), _f2(5695, 63155 << 36), _f2(4892, 14039 << 38),
    -_f2(3091, 58619 << 36), -_f(29081577 << 37), _f(100489431 << 36),
    -_f(125982325 << 34), _f2(37610392, 0xd75d61176d38f),
    # C4[16], coeff of eps^19, polynomial in n of order 7
    -_f(44186749 << 35), _f2(28752, 63675 << 36), -_f2(37202, 72039 << 35),
    _f2(26902, 18169 << 37), -_f2(11512, 105649 << 35),
    _f2(2229, 59753 << 36), _f(26382181 << 35), -_f(267675387 << 31),
    _f2(37610392, 0xd75d61176d38f),
    # C4[16], coeff of eps^18, polynomial in n of order 8
    _f2(51956, 3503 << 39), -_f2(52000, 65291 << 36),
    _f2(36995, 30461 << 37), -_f2(12343, 54705 << 36),
    -_f2(9828, 2065 << 38), _f2(19743, 35337 << 36),
    -_f2(17124, 20865 << 37), _f2(8752, 19043 << 36),
    -_f2(2081, 554945 << 32), _f2(37610392, 0xd75d61176d38f),
    # C4[16], coeff of eps^17, polynomial in n of order 9
    _f2(11351, 15263 << 35), -_f2(21031, 10301 << 38),
    _f2(32809, 38737 << 35), -_f2(42826, 1799 << 36),
    _f2(46156, 123299 << 35), -_f2(40102, 7421 << 37),
    _f2(26942, 16853 << 35), -_f2(13031, 12333 << 36),
    _f2(3987, 20263 << 35), -_f(1198915809 << 31),
    _f2(37610392, 0xd75d61176d38f),
    # C4[16], coeff of eps^16, polynomial in n of order 10
    _f(100180065 << 34), -_f(583401555 << 33), _f2(2759, 6541 << 36),
    -_f2(5863, 45661 << 33), _f2(10706, 132871 << 34),
    -_f2(16773, 276519 << 33), _f2(22364, 92173 << 35),
    -_f2(24871, 48433 << 33), _f2(21929, 91821 << 34),
    -_f2(12958, 132347 << 33), _f2(3525, 1706711 << 30),
    _f2(37610392, 0xd75d61176d38f),
    # C4[17], coeff of eps^26, polynomial in n of order 0
    _f(1 << 32), _f(0x62a61c3e4dd975),
    # C4[17], coeff of eps^25, polynomial in n of order 1
    _f(4057 << 35), -_f(45015 << 31), _f2(8569, 0x3d59f665e75a3),
    # C4[17], coeff of eps^24, polynomial in n of order 2
    _f(43463 << 40), -_f(16895 << 39), -_f(11395 << 34),
    _f2(299923, 0x634cafeea1549),
    # C4[17], coeff of eps^23, polynomial in n of order 3
    -_f(1242717 << 35), _f(138325 << 36), _f(435713 << 35),
    -_f(3030063 << 31), _f2(299923, 0x634cafeea1549),
    # C4[17], coeff of eps^22, polynomial in n of order 4
    _f(2302621 << 39), -_f(9225219 << 37), _f(1747781 << 38),
    -_f(372113 << 37), -_f(1948863 << 32),
    _f2(2099463, 0xb718cf86694ff),
    # C4[17], coeff of eps^21, polynomial in n of order 5
    _f2(2996, 69763 << 35), _f2(5105, 30307 << 37), -_f2(2616, 23051 << 35),
    -_f(67503821 << 36), _f(191814791 << 35), -_f(933454921 << 31),
    _f2(39889810, 0x96d766f9d0eed),
    # C4[17], coeff of eps^20, polynomial in n of order 6
    _f2(30327, 1293 << 39), -_f2(35084, 3299 << 38), _f2(23968, 2311 << 40),
    -_f2(9776, 7093 << 38), _f(14159215 << 39), _f(3853577 << 38),
    -_f(61360803 << 33), _f2(39889810, 0x96d766f9d0eed),
    # C4[17], coeff of eps^19, polynomial in n of order 7
    -_f2(47757, 47889 << 35), _f2(31664, 61447 << 36),
    -_f2(8326, 73443 << 35), -_f2(11212, 17667 << 37),
    _f2(19076, 23915 << 35), -_f2(15916, 62675 << 36),
    _f2(8026, 42649 << 35), -_f(3989637911 << 31),
    _f2(39889810, 0x96d766f9d0eed),
    # C4[17], coeff of eps^18, polynomial in n of order 8
    -_f2(22252, 923 << 40), _f2(33139, 2449 << 37), -_f2(41618, 6905 << 38),
    _f2(43458, 30291 << 37), -_f2(36814, 1531 << 39),
    _f2(24253, 3845 << 37), -_f2(11561, 2707 << 38), _f2(3500, 30023 << 37),
    -_f(522604327 << 32), _f2(39889810, 0x96d766f9d0eed),
    # C4[17], coeff of eps^17, polynomial in n of order 9
    -_f(175857885 << 35), _f2(3123, 8343 << 38), -_f2(6297, 123891 << 35),
    _f2(11012, 26677 << 36), -_f2(16654, 74217 << 35),
    _f2(21593, 16599 << 37), -_f2(23509, 7807 << 35), _f2(20422, 743 << 36),
    -_f2(11961, 60789 << 35), _f2(3239, 1180923 << 31),
    _f2(39889810, 0x96d766f9d0eed),
    # C4[18], coeff of eps^26, polynomial in n of order 0
    -_f(56087 << 33), _f2(47221, 0xfaefc0318df67),
    # C4[18], coeff of eps^25, polynomial in n of order 1
    -_f(19981 << 39), -_f(10755 << 35), _f2(443886, 0x9d340e9e9cd95),
    # C4[18], coeff of eps^24, polynomial in n of order 2
    _f(84155 << 39), _f(380011 << 38), -_f(1249051 << 35),
    _f2(2219433, 0x12044919103e9),
    # C4[18], coeff of eps^23, polynomial in n of order 3
    -_f(2130987 << 39), _f(379583 << 40), -_f(70649 << 39),
    -_f(240567 << 35), _f2(2219433, 0x12044919103e9),
    # C4[18], coeff of eps^22, polynomial in n of order 4
    _f(4417441 << 38), -_f(7513869 << 36), -_f(1960735 << 37),
    _f(4812241 << 36), -_f(11409363 << 33),
    _f2(2219433, 0x12044919103e9),
    # C4[18], coeff of eps^21, polynomial in n of order 5
    -_f(28350547 << 38), _f(4603793 << 40), -_f(7176677 << 38),
    _f(573937 << 39), _f(220745 << 38), -_f(1482145 << 34),
    _f2(2219433, 0x12044919103e9),
    # C4[18], coeff of eps^20, polynomial in n of order 6
    _f2(26896, 5159 << 38), -_f2(4987, 8879 << 37), -_f2(12193, 6323 << 39),
    _f2(18360, 26775 << 37), -_f2(14825, 8691 << 38),
    _f2(7390, 26973 << 37), -_f(457982805 << 34),
    _f2(42169228, 0x56516cdc34a4b),
    # C4[18], coeff of eps^19, polynomial in n of order 7
    _f2(11070, 12259 << 38), -_f2(13431, 6105 << 39),
    _f2(13633, 4633 << 38), -_f2(11288, 2771 << 40), _f2(7306, 11663 << 38),
    -_f2(3437, 4851 << 39), _f(16896453 << 38), -_f(38239341 << 34),
    _f2(14056409, 0x721b244966e19),
    # C4[18], coeff of eps^18, polynomial in n of order 8
    _f2(3471, 5433 << 39), -_f2(6682, 62369 << 36), _f2(11244, 10859 << 37),
    -_f2(16478, 49907 << 36), _f2(20837, 10809 << 38),
    -_f2(22258, 26821 << 36), _f2(19078, 20857 << 37),
    -_f2(11086, 15383 << 36), _f2(2990, 191861 << 33),
    _f2(42169228, 0x56516cdc34a4b),
    # C4[19], coeff of eps^26, polynomial in n of order 0
    -_f(113 << 37), _f2(16591, 0x81ae2ec54d8df),
    # C4[19], coeff of eps^25, polynomial in n of order 1
    _f(94099 << 40), -_f(1178305 << 35), _f2(2339402, 0x6cefc2abb72d3),
    # C4[19], coeff of eps^24, polynomial in n of order 2
    _f(41263 << 43), -_f(6583 << 42), -_f(117501 << 36),
    _f2(2339402, 0x6cefc2abb72d3),
    # C4[19], coeff of eps^23, polynomial in n of order 3
    -_f(384159 << 40), -_f(130977 << 41), _f(286571 << 40),
    -_f(2657049 << 35), _f2(2339402, 0x6cefc2abb72d3),
    # C4[19], coeff of eps^22, polynomial in n of order 4
    _f(64121 << 46), -_f(23919 << 46), _f(6837 << 45), _f(901 << 46),
    -_f(170289 << 37), _f2(2339402, 0x6cefc2abb72d3),
    # C4[19], coeff of eps^21, polynomial in n of order 5
    -_f(955747 << 39), -_f(1386619 << 41), _f(7599723 << 39),
    -_f(2983211 << 40), _f(2945369 << 39), -_f(22232175 << 34),
    _f2(2339402, 0x6cefc2abb72d3),
    # C4[19], coeff of eps^20, polynomial in n of order 6
    -_f(2096679 << 42), _f(4148625 << 41), -_f(841269 << 43),
    _f(2143479 << 41), -_f(498253 << 42), _f(296429 << 41),
    -_f(2667861 << 35), _f2(2339402, 0x6cefc2abb72d3),
    # C4[19], coeff of eps^19, polynomial in n of order 7
    -_f(3026933 << 39), _f(2460315 << 40), -_f(7010575 << 39),
    _f(2166905 << 41), -_f(9101001 << 39), _f(3853577 << 40),
    -_f(4446435 << 39), _f(38239341 << 34),
    _f2(2339402, 0x6cefc2abb72d3),
    # C4[20], coeff of eps^26, polynomial in n of order 0
    -_f(34781 << 40), _f2(2459371, 0xc7db3c3e5e1bd),
    # C4[20], coeff of eps^25, polynomial in n of order 1
    -_f(4771 << 42), -_f(28479 << 38), _f2(2459371, 0xc7db3c3e5e1bd),
    # C4[20], coeff of eps^24, polynomial in n of order 2
    -_f(68467 << 42), _f(136501 << 41), -_f(310209 << 38),
    _f2(2459371, 0xc7db3c3e5e1bd),
    # C4[20], coeff of eps^23, polynomial in n of order 3
    -_f(327189 << 42), _f(20533 << 43), _f(14681 << 42),
    -_f(78387 << 38), _f2(2459371, 0xc7db3c3e5e1bd),
    # C4[20], coeff of eps^22, polynomial in n of order 4
    -_f(179129 << 44), _f(910389 << 42), -_f(348793 << 43),
    _f(341479 << 42), -_f(321657 << 40), _f2(2459371, 0xc7db3c3e5e1bd),
    # C4[20], coeff of eps^21, polynomial in n of order 5
    _f(1952379 << 42), -_f(388557 << 44), _f(975677 << 42),
    -_f(224349 << 43), _f(132447 << 42), -_f(296429 << 38),
    _f2(2459371, 0xc7db3c3e5e1bd),
    # C4[20], coeff of eps^20, polynomial in n of order 6
    _f(1242423 << 41), -_f(3451175 << 40), _f(1045213 << 42),
    -_f(4322097 << 40), _f(1810109 << 41), -_f(2075003 << 40),
    _f(4446435 << 37), _f2(2459371, 0xc7db3c3e5e1bd),
    # C4[21], coeff of eps^26, polynomial in n of order 0
    -_f(199 << 39), _f2(37381, 0xc16e795c129fb),
    # C4[21], coeff of eps^25, polynomial in n of order 1
    _f(65027 << 42), -_f(290455 << 38), _f2(2579341, 0x22c6b5d1050a7),
    # C4[21], coeff of eps^24, polynomial in n of order 2
    _f(1883 << 46), _f(1837 << 45), -_f(18073 << 40),
    _f2(2579341, 0x22c6b5d1050a7),
    # C4[21], coeff of eps^23, polynomial in n of order 3
    _f(871509 << 42), -_f(326909 << 43), _f(317735 << 42),
    -_f(1195627 << 38), _f2(2579341, 0x22c6b5d1050a7),
    # C4[21], coeff of eps^22, polynomial in n of order 4
    -_f(29971 << 46), _f(74261 << 44), -_f(16907 << 45), _f(9911 << 44),
    -_f(44149 << 39), _f2(859780, 0x60ece745ac58d),
    # C4[21], coeff of eps^21, polynomial in n of order 5
    -_f(848003 << 42), _f(252109 << 44), -_f(1027829 << 42),
    _f(426173 << 43), -_f(485639 << 42), _f(2075003 << 38),
    _f2(2579341, 0x22c6b5d1050a7),
    # C4[22], coeff of eps^26, polynomial in n of order 0
    -_f(2963 << 40), _f2(117361, 0x5360ca6881e97),
    # C4[22], coeff of eps^25, polynomial in n of order 1
    _f(79 << 45), -_f(363 << 41), _f2(117361, 0x5360ca6881e97),
    # C4[22], coeff of eps^24, polynomial in n of order 2
    -_f(76751 << 45), _f(74129 << 44), -_f(139337 << 41),
    _f2(2699310, 0x7db22f63abf91),
    # C4[22], coeff of eps^23, polynomial in n of order 3
    _f(102051 << 45), -_f(23023 << 46), _f(13409 << 45),
    -_f(29733 << 41), _f2(2699310, 0x7db22f63abf91),
    # C4[22], coeff of eps^22, polynomial in n of order 4
    _f(121647 << 45), -_f(489555 << 43), _f(201135 << 44),
    -_f(227953 << 43), _f(485639 << 40), _f2(2699310, 0x7db22f63abf91),
    # C4[23], coeff of eps^26, polynomial in n of order 0
    -_f(1 << 45), _f2(5837, 0x4b04b152e489),
    # C4[23], coeff of eps^25, polynomial in n of order 1
    _f(377 << 47), -_f(5665 << 41), _f2(122577, 0x627628bccbf3d),
    # C4[23], coeff of eps^24, polynomial in n of order 2
    -_f(57 << 50), _f(33 << 49), -_f(583 << 42),
    _f2(122577, 0x627628bccbf3d),
    # C4[23], coeff of eps^23, polynomial in n of order 3
    -_f(1269 << 47), _f(517 << 48), -_f(583 << 47), _f(9911 << 41),
    _f2(122577, 0x627628bccbf3d),
    # C4[24], coeff of eps^26, polynomial in n of order 0
    -_f(83 << 47), _f2(127793, 0x718b871115fe3),
    # C4[24], coeff of eps^25, polynomial in n of order 1
    _f(5 << 50), -_f(11 << 46), _f2(42597, 0xd083d7b05caa1),
    # C4[24], coeff of eps^24, polynomial in n of order 2
    _f(245 << 49), -_f(275 << 48), _f(583 << 45),
    _f2(127793, 0x718b871115fe3),
    # C4[25], coeff of eps^26, polynomial in n of order 0
    -_f(1 << 47), _f2(8867, 0x4cd786c27dde7),
    # C4[25], coeff of eps^25, polynomial in n of order 1
    -_f(13 << 50), _f(55 << 46), _f2(26601, 0xe6869447799b5),
    # C4[26], coeff of eps^26, polynomial in n of order 0
    _f(1 << 48), _f2(2126, 0x8c0e9e949456f),  # PYCHOK exported
)  # 4032

# **) MIT License
#
# Copyright (C) 2016-2021 -- mrJean1 at Gmail -- All Rights Reserved.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
# OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
# ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.
